/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.extraction;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.handler.extraction.ExtractingDocumentLoader;
import org.apache.solr.handler.extraction.ExtractionDateUtil;
import org.apache.solr.handler.extraction.ParseContextConfig;
import org.apache.solr.handler.extraction.SolrContentHandlerFactory;
import org.apache.solr.handler.loader.ContentStreamLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ExtractingRequestHandler
extends ContentStreamHandlerBase
implements SolrCoreAware,
PermissionNameProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PARSE_CONTEXT_CONFIG = "parseContext.config";
    public static final String CONFIG_LOCATION = "tika.config";
    public static final String DATE_FORMATS = "date.formats";
    protected TikaConfig config;
    protected ParseContextConfig parseContextConfig;
    protected Collection<String> dateFormats = ExtractionDateUtil.DEFAULT_DATE_FORMATS;
    protected SolrContentHandlerFactory factory;

    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.READ_PERM;
    }

    public void init(NamedList args) {
        super.init(args);
    }

    public void inform(SolrCore core) {
        if (this.initArgs != null) {
            NamedList configDateFormats;
            String parseContextConfigLoc;
            String tikaConfigLoc = (String)this.initArgs.get(CONFIG_LOCATION);
            if (tikaConfigLoc != null) {
                File configFile = new File(tikaConfigLoc);
                if (!configFile.isAbsolute()) {
                    configFile = new File(core.getResourceLoader().getConfigDir(), configFile.getPath());
                }
                try {
                    this.config = new TikaConfig(configFile);
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                }
            }
            if ((parseContextConfigLoc = (String)this.initArgs.get(PARSE_CONTEXT_CONFIG)) != null) {
                try {
                    this.parseContextConfig = new ParseContextConfig(core.getResourceLoader(), parseContextConfigLoc);
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                }
            }
            if ((configDateFormats = (NamedList)this.initArgs.get(DATE_FORMATS)) != null && configDateFormats.size() > 0) {
                this.dateFormats = new HashSet<String>();
                Iterator it = configDateFormats.iterator();
                while (it.hasNext()) {
                    String format = (String)((Map.Entry)it.next()).getValue();
                    log.info("Adding Date Format: " + format);
                    this.dateFormats.add(format);
                }
            }
        }
        if (this.config == null) {
            try (InputStream is = core.getResourceLoader().getClassLoader().getResourceAsStream("solr-default-tika-config.xml");){
                this.config = new TikaConfig(is);
            }
            catch (IOException | TikaException | SAXException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, e);
            }
        }
        if (this.parseContextConfig == null) {
            this.parseContextConfig = new ParseContextConfig();
        }
        this.factory = this.createFactory();
    }

    protected SolrContentHandlerFactory createFactory() {
        return new SolrContentHandlerFactory(this.dateFormats);
    }

    protected ContentStreamLoader newLoader(SolrQueryRequest req, UpdateRequestProcessor processor) {
        return new ExtractingDocumentLoader(req, processor, this.config, this.parseContextConfig, this.factory);
    }

    public String getDescription() {
        return "Add/Update Rich document";
    }
}

