/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchema;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.jempbox.xmp.pdfa.XMPSchemaPDFAId;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.poi.util.IOUtils;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.AccessPermissions;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PDF;
import org.apache.tika.metadata.PagedText;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.image.xmp.JempboxExtractor;
import org.apache.tika.parser.ocr.TesseractOCRParser;
import org.apache.tika.parser.pdf.AccessChecker;
import org.apache.tika.parser.pdf.OCR2XHTML;
import org.apache.tika.parser.pdf.PDF2XHTML;
import org.apache.tika.parser.pdf.PDFEncodedStringDecoder;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.parser.pdf.XFAExtractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PDFParser
extends AbstractParser
implements Initializable {
    private static volatile boolean HAS_WARNED = false;
    private static final Object[] LOCK = new Object[0];
    public static final String PASSWORD = "org.apache.tika.parser.pdf.password";
    private static final MediaType MEDIA_TYPE = MediaType.application((String)"pdf");
    private static final long serialVersionUID = -752276948656079347L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MEDIA_TYPE);
    private PDFParserConfig defaultConfig = new PDFParserConfig();
    private InitializableProblemHandler initializableProblemHandler = null;

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        PDFParserConfig localConfig = (PDFParserConfig)context.get(PDFParserConfig.class, (Object)this.defaultConfig);
        if (localConfig.getSetKCMS()) {
            System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
        }
        String password = "";
        try (PDDocument pdfDocument = null;){
            TikaInputStream tstream = TikaInputStream.cast((InputStream)stream);
            password = this.getPassword(metadata, context);
            MemoryUsageSetting memoryUsageSetting = MemoryUsageSetting.setupMainMemoryOnly();
            if (localConfig.getMaxMainMemoryBytes() >= 0L) {
                memoryUsageSetting = MemoryUsageSetting.setupMixed((long)localConfig.getMaxMainMemoryBytes());
            }
            pdfDocument = tstream != null && tstream.hasFile() ? PDDocument.load((File)tstream.getPath().toFile(), (String)password, (MemoryUsageSetting)memoryUsageSetting) : PDDocument.load((InputStream)new CloseShieldInputStream(stream), (String)password, (MemoryUsageSetting)memoryUsageSetting);
            metadata.set(PDF.IS_ENCRYPTED, Boolean.toString(pdfDocument.isEncrypted()));
            metadata.set("Content-Type", MEDIA_TYPE.toString());
            this.extractMetadata(pdfDocument, metadata, context);
            AccessChecker checker = localConfig.getAccessChecker();
            checker.check(metadata);
            if (handler != null) {
                if (this.shouldHandleXFAOnly(pdfDocument, localConfig)) {
                    this.handleXFAOnly(pdfDocument, handler, metadata, context);
                } else if (localConfig.getOcrStrategy().equals((Object)PDFParserConfig.OCR_STRATEGY.OCR_ONLY)) {
                    metadata.add("X-Parsed-By", TesseractOCRParser.class.toString());
                    OCR2XHTML.process(pdfDocument, handler, context, metadata, localConfig);
                } else {
                    if (localConfig.getOcrStrategy().equals((Object)PDFParserConfig.OCR_STRATEGY.OCR_AND_TEXT_EXTRACTION)) {
                        metadata.add("X-Parsed-By", TesseractOCRParser.class.toString());
                    }
                    PDF2XHTML.process(pdfDocument, handler, context, metadata, localConfig);
                }
            }
        }
    }

    private String getPassword(Metadata metadata, ParseContext context) {
        String password = null;
        PasswordProvider passwordProvider = (PasswordProvider)context.get(PasswordProvider.class);
        if (passwordProvider != null) {
            password = passwordProvider.getPassword(metadata);
        }
        if (password == null && metadata.get(PASSWORD) != null) {
            password = metadata.get(PASSWORD);
        }
        if (password == null) {
            password = "";
        }
        return password;
    }

    private void extractMetadata(PDDocument document, Metadata metadata, ParseContext context) throws TikaException {
        AccessPermission ap = document.getCurrentAccessPermission();
        metadata.set(AccessPermissions.EXTRACT_FOR_ACCESSIBILITY, Boolean.toString(ap.canExtractForAccessibility()));
        metadata.set(AccessPermissions.EXTRACT_CONTENT, Boolean.toString(ap.canExtractContent()));
        metadata.set(AccessPermissions.ASSEMBLE_DOCUMENT, Boolean.toString(ap.canAssembleDocument()));
        metadata.set(AccessPermissions.FILL_IN_FORM, Boolean.toString(ap.canFillInForm()));
        metadata.set(AccessPermissions.CAN_MODIFY, Boolean.toString(ap.canModify()));
        metadata.set(AccessPermissions.CAN_MODIFY_ANNOTATIONS, Boolean.toString(ap.canModifyAnnotations()));
        metadata.set(AccessPermissions.CAN_PRINT, Boolean.toString(ap.canPrint()));
        metadata.set(AccessPermissions.CAN_PRINT_DEGRADED, Boolean.toString(ap.canPrintDegraded()));
        if (document.getDocumentCatalog().getLanguage() != null) {
            metadata.set(TikaCoreProperties.LANGUAGE, document.getDocumentCatalog().getLanguage());
        }
        Document dom = this.loadDOM(document.getDocumentCatalog().getMetadata(), metadata, context);
        XMPMetadata xmp = null;
        if (dom != null) {
            xmp = new XMPMetadata(dom);
        }
        XMPSchemaDublinCore dcSchema = null;
        if (xmp != null) {
            try {
                dcSchema = xmp.getDublinCoreSchema();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JempboxExtractor.extractXMPMM(xmp, metadata);
        }
        PDDocumentInformation info = document.getDocumentInformation();
        metadata.set(PagedText.N_PAGES, document.getNumberOfPages());
        this.extractMultilingualItems(metadata, TikaCoreProperties.TITLE, info.getTitle(), (XMPSchema)dcSchema);
        this.addMetadata(metadata, PDF.DOC_INFO_TITLE, info.getTitle());
        this.extractDublinCoreListItems(metadata, TikaCoreProperties.CREATOR, info.getAuthor(), dcSchema);
        this.addMetadata(metadata, PDF.DOC_INFO_CREATOR, info.getAuthor());
        this.extractDublinCoreListItems(metadata, TikaCoreProperties.CONTRIBUTOR, null, dcSchema);
        this.addMetadata(metadata, TikaCoreProperties.CREATOR_TOOL, info.getCreator());
        this.addMetadata(metadata, PDF.DOC_INFO_CREATOR_TOOL, info.getCreator());
        this.addMetadata(metadata, TikaCoreProperties.KEYWORDS, info.getKeywords());
        this.addMetadata(metadata, PDF.DOC_INFO_KEY_WORDS, info.getKeywords());
        this.addMetadata(metadata, "producer", info.getProducer());
        this.addMetadata(metadata, PDF.DOC_INFO_PRODUCER, info.getProducer());
        this.extractMultilingualItems(metadata, TikaCoreProperties.DESCRIPTION, null, (XMPSchema)dcSchema);
        this.addMetadata(metadata, PDF.DOC_INFO_SUBJECT, info.getSubject());
        this.addMetadata(metadata, TikaCoreProperties.TRANSITION_SUBJECT_TO_OO_SUBJECT, info.getSubject());
        this.addMetadata(metadata, "trapped", info.getTrapped());
        this.addMetadata(metadata, PDF.DOC_INFO_TRAPPED, info.getTrapped());
        this.addMetadata(metadata, "created", info.getCreationDate());
        this.addMetadata(metadata, PDF.DOC_INFO_CREATED, info.getCreationDate());
        this.addMetadata(metadata, TikaCoreProperties.CREATED, info.getCreationDate());
        Calendar modified = info.getModificationDate();
        this.addMetadata(metadata, Metadata.LAST_MODIFIED, modified);
        this.addMetadata(metadata, TikaCoreProperties.MODIFIED, modified);
        this.addMetadata(metadata, PDF.DOC_INFO_MODIFICATION_DATE, info.getModificationDate());
        List<String> handledMetadata = Arrays.asList("Author", "Creator", "CreationDate", "ModDate", "Keywords", "Producer", "Subject", "Title", "Trapped");
        for (COSName key : info.getCOSObject().keySet()) {
            String name = key.getName();
            if (handledMetadata.contains(name)) continue;
            this.addMetadata(metadata, name, info.getCOSObject().getDictionaryObject(key));
            this.addMetadata(metadata, "pdf:docinfo:custom:" + name, info.getCOSObject().getDictionaryObject(key));
        }
        metadata.set(PDF.PDF_VERSION, Float.toString(document.getDocument().getVersion()));
        metadata.add(TikaCoreProperties.FORMAT.getName(), MEDIA_TYPE.toString() + "; version=" + Float.toString(document.getDocument().getVersion()));
        try {
            if (xmp != null) {
                xmp.addXMLNSMapping("http://www.aiim.org/pdfa/ns/id/", XMPSchemaPDFAId.class);
                XMPSchemaPDFAId pdfaxmp = (XMPSchemaPDFAId)xmp.getSchemaByClass(XMPSchemaPDFAId.class);
                if (pdfaxmp != null) {
                    if (pdfaxmp.getPart() != null) {
                        metadata.set(PDF.PDFAID_PART, Integer.toString(pdfaxmp.getPart()));
                    }
                    if (pdfaxmp.getConformance() != null) {
                        metadata.set(PDF.PDFAID_CONFORMANCE, pdfaxmp.getConformance());
                        String version = "A-" + pdfaxmp.getPart() + pdfaxmp.getConformance().toLowerCase(Locale.ROOT);
                        metadata.set(PDF.PDFA_VERSION, version);
                        metadata.add(TikaCoreProperties.FORMAT.getName(), MEDIA_TYPE.toString() + "; version=\"" + version + "\"");
                    }
                }
            }
        }
        catch (IOException e) {
            metadata.set("X-TIKA:pdf:metadata-xmp-parse-failed", "" + e);
        }
        COSDictionary root = document.getDocumentCatalog().getCOSObject();
        COSDictionary extensions = (COSDictionary)root.getDictionaryObject(COSName.getPDFName((String)"Extensions"));
        if (extensions != null) {
            for (COSName extName : extensions.keySet()) {
                if (extName.equals((Object)COSName.getPDFName((String)"ADBE"))) {
                    COSDictionary adobeExt = (COSDictionary)extensions.getDictionaryObject(extName);
                    if (adobeExt == null) continue;
                    String baseVersion = adobeExt.getNameAsString(COSName.getPDFName((String)"BaseVersion"));
                    int el = adobeExt.getInt(COSName.getPDFName((String)"ExtensionLevel"));
                    if (el == -1) continue;
                    metadata.set(PDF.PDF_EXTENSION_VERSION, baseVersion + " Adobe Extension Level " + el);
                    metadata.add(TikaCoreProperties.FORMAT.getName(), MEDIA_TYPE.toString() + "; version=\"" + baseVersion + " Adobe Extension Level " + el + "\"");
                    continue;
                }
                metadata.set("pdf:foundNonAdobeExtensionName", extName.getName());
            }
        }
    }

    private void extractMultilingualItems(Metadata metadata, Property property, String pdfBoxBaseline, XMPSchema schema) {
        if (schema == null) {
            if (pdfBoxBaseline != null && pdfBoxBaseline.length() > 0) {
                this.addMetadata(metadata, property, pdfBoxBaseline);
            }
            return;
        }
        for (String lang : schema.getLanguagePropertyLanguages(property.getName())) {
            String value = schema.getLanguageProperty(property.getName(), lang);
            if (value == null || value.length() <= 0 || pdfBoxBaseline != null && value.equals(pdfBoxBaseline)) continue;
            this.addMetadata(metadata, property, value);
            if (property.isMultiValuePermitted()) continue;
            return;
        }
        if (pdfBoxBaseline != null && pdfBoxBaseline.length() > 0) {
            if (!property.isMultiValuePermitted() && metadata.get(property) != null) {
                return;
            }
            this.addMetadata(metadata, property, pdfBoxBaseline);
        }
    }

    private void extractDublinCoreListItems(Metadata metadata, Property property, String pdfBoxBaseline, XMPSchemaDublinCore dc) {
        if (dc == null) {
            if (pdfBoxBaseline != null && pdfBoxBaseline.length() > 0) {
                this.addMetadata(metadata, property, pdfBoxBaseline);
            }
            return;
        }
        List<String> items = this.getXMPBagOrSeqList((XMPSchema)dc, property.getName());
        if (items == null) {
            if (pdfBoxBaseline != null && pdfBoxBaseline.length() > 0) {
                this.addMetadata(metadata, property, pdfBoxBaseline);
            }
            return;
        }
        for (String item : items) {
            if (pdfBoxBaseline == null || item.equals(pdfBoxBaseline)) continue;
            this.addMetadata(metadata, property, item);
        }
        if (pdfBoxBaseline != null && pdfBoxBaseline.length() > 0) {
            this.addMetadata(metadata, property, pdfBoxBaseline);
        }
    }

    private List<String> getXMPBagOrSeqList(XMPSchema schema, String name) {
        List ret = schema.getBagList(name);
        if (ret == null) {
            ret = schema.getSequenceList(name);
        }
        return ret;
    }

    private void addMetadata(Metadata metadata, Property property, String value) {
        if (value != null) {
            String decoded = this.decode(value);
            if (property.isMultiValuePermitted() || metadata.get(property) == null) {
                metadata.add(property, decoded);
            }
        }
    }

    private void addMetadata(Metadata metadata, String name, String value) {
        if (value != null) {
            metadata.add(name, this.decode(value));
        }
    }

    private String decode(String value) {
        if (PDFEncodedStringDecoder.shouldDecode(value)) {
            PDFEncodedStringDecoder d = new PDFEncodedStringDecoder();
            return d.decode(value);
        }
        return value;
    }

    private void addMetadata(Metadata metadata, String name, Calendar value) {
        if (value != null) {
            metadata.set(name, value.getTime().toString());
        }
    }

    private void addMetadata(Metadata metadata, Property property, Calendar value) {
        if (value != null) {
            metadata.set(property, value.getTime());
        }
    }

    private void addMetadata(Metadata metadata, String name, COSBase value) {
        if (value instanceof COSArray) {
            for (Object v : ((COSArray)value).toList()) {
                this.addMetadata(metadata, name, (COSBase)v);
            }
        } else if (value instanceof COSString) {
            this.addMetadata(metadata, name, ((COSString)value).getString());
        } else if (value != null && !(value instanceof COSDictionary)) {
            this.addMetadata(metadata, name, value.toString());
        }
    }

    private boolean shouldHandleXFAOnly(PDDocument pdDocument, PDFParserConfig config) {
        return config.getIfXFAExtractOnlyXFA() && pdDocument.getDocumentCatalog() != null && pdDocument.getDocumentCatalog().getAcroForm() != null && pdDocument.getDocumentCatalog().getAcroForm().getXFA() != null;
    }

    private void handleXFAOnly(PDDocument pdDocument, ContentHandler handler, Metadata metadata, ParseContext context) throws SAXException, IOException, TikaException {
        XFAExtractor ex = new XFAExtractor();
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        try (ByteArrayInputStream is = new ByteArrayInputStream(pdDocument.getDocumentCatalog().getAcroForm().getXFA().getBytes());){
            ex.extract(is, xhtml, metadata, context);
        }
        catch (XMLStreamException e) {
            throw new TikaException("XML error in XFA", (Throwable)e);
        }
        xhtml.endDocument();
    }

    public PDFParserConfig getPDFParserConfig() {
        return this.defaultConfig;
    }

    public void setPDFParserConfig(PDFParserConfig config) {
        this.defaultConfig = config;
    }

    public boolean getEnableAutoSpace() {
        return this.defaultConfig.getEnableAutoSpace();
    }

    public void setEnableAutoSpace(boolean v) {
        this.defaultConfig.setEnableAutoSpace(v);
    }

    public boolean getExtractAnnotationText() {
        return this.defaultConfig.getExtractAnnotationText();
    }

    public void setExtractAnnotationText(boolean v) {
        this.defaultConfig.setExtractAnnotationText(v);
    }

    public boolean getSuppressDuplicateOverlappingText() {
        return this.defaultConfig.getSuppressDuplicateOverlappingText();
    }

    public void setSuppressDuplicateOverlappingText(boolean v) {
        this.defaultConfig.setSuppressDuplicateOverlappingText(v);
    }

    public boolean getSortByPosition() {
        return this.defaultConfig.getSortByPosition();
    }

    @Field
    public void setSortByPosition(boolean v) {
        this.defaultConfig.setSortByPosition(v);
    }

    @Field
    public void setOcrStrategy(String ocrStrategyString) {
        this.defaultConfig.setOcrStrategy(ocrStrategyString);
    }

    @Field
    public void setOcrImageType(String imageType) {
        this.defaultConfig.setOcrImageType(imageType);
    }

    @Field
    void setOcrDPI(int dpi) {
        this.defaultConfig.setOcrDPI(dpi);
    }

    @Field
    void setOcrImageQuality(float imageQuality) {
        this.defaultConfig.setOcrImageQuality(imageQuality);
    }

    @Field
    void setOcrImageFormatName(String formatName) {
        this.defaultConfig.setOcrImageFormatName(formatName);
    }

    @Field
    void setOcrImageScale(float imageScale) {
        this.defaultConfig.setOcrImageScale(imageScale);
    }

    @Field
    void setExtractBookmarksText(boolean extractBookmarksText) {
        this.defaultConfig.setExtractBookmarksText(extractBookmarksText);
    }

    @Field
    void setExtractInlineImages(boolean extractInlineImages) {
        this.defaultConfig.setExtractInlineImages(extractInlineImages);
    }

    @Field
    void setCatchIntermediateExceptions(boolean catchIntermediateExceptions) {
        this.defaultConfig.setCatchIntermediateIOExceptions(catchIntermediateExceptions);
    }

    @Field
    void setExtractAcroFormContent(boolean extractAcroFormContent) {
        this.defaultConfig.setExtractAcroFormContent(extractAcroFormContent);
    }

    @Field
    void setIfXFAExtractOnlyXFA(boolean ifXFAExtractOnlyXFA) {
        this.defaultConfig.setIfXFAExtractOnlyXFA(ifXFAExtractOnlyXFA);
    }

    @Field
    void setAllowExtractionForAccessibility(boolean allowExtractionForAccessibility) {
        this.defaultConfig.setAccessChecker(new AccessChecker(allowExtractionForAccessibility));
    }

    @Field
    void setExtractUniqueInlineImagesOnly(boolean extractUniqueInlineImagesOnly) {
        this.defaultConfig.setExtractUniqueInlineImagesOnly(extractUniqueInlineImagesOnly);
    }

    @Field
    void setExtractActions(boolean extractActions) {
        this.defaultConfig.setExtractActions(extractActions);
    }

    @Field
    void setSetKCMS(boolean setKCMS) {
        this.defaultConfig.setSetKCMS(setKCMS);
    }

    @Field
    void setInitializableProblemHander(String name) {
        if ("ignore".equals(name)) {
            this.setInitializableProblemHandler(InitializableProblemHandler.IGNORE);
        } else if ("info".equalsIgnoreCase(name)) {
            this.setInitializableProblemHandler(InitializableProblemHandler.INFO);
        } else if ("warn".equalsIgnoreCase(name)) {
            this.setInitializableProblemHandler(InitializableProblemHandler.WARN);
        } else if ("throw".equalsIgnoreCase(name)) {
            this.setInitializableProblemHandler(InitializableProblemHandler.THROW);
        }
    }

    public void setInitializableProblemHandler(InitializableProblemHandler initializableProblemHandler) {
        this.initializableProblemHandler = initializableProblemHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadDOM(PDMetadata pdMetadata, Metadata metadata, ParseContext context) {
        if (pdMetadata == null) {
            return null;
        }
        InputStream is = null;
        try {
            try {
                is = pdMetadata.exportXMPMetadata();
            }
            catch (IOException e) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException((Throwable)e, (Metadata)metadata);
                Document document = null;
                IOUtils.closeQuietly((Closeable)is);
                return document;
            }
            DocumentBuilder documentBuilder = context.getDocumentBuilder();
            documentBuilder.setErrorHandler(null);
            Document document = documentBuilder.parse(is);
            return document;
        }
        catch (IOException | TikaException | SAXException e) {
            EmbeddedDocumentUtil.recordException((Throwable)e, (Metadata)metadata);
        }
        finally {
            IOUtils.closeQuietly((Closeable)is);
        }
        return null;
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkInitialization(InitializableProblemHandler handler) throws TikaConfigException {
        if (HAS_WARNED) {
            return;
        }
        Object[] objectArray = LOCK;
        synchronized (LOCK) {
            if (HAS_WARNED) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            StringBuilder sb = new StringBuilder();
            try {
                Class.forName("com.github.jaiimageio.impl.plugins.tiff.TIFFImageWriter");
            }
            catch (ClassNotFoundException e) {
                sb.append("TIFFImageWriter not loaded. tiff files will not be processed\n");
                sb.append("See https://pdfbox.apache.org/2.0/dependencies.html#jai-image-io\n");
                sb.append("for optional dependencies.\n");
            }
            try {
                Class.forName("com.github.jaiimageio.jpeg2000.impl.J2KImageReader");
            }
            catch (ClassNotFoundException e) {
                sb.append("J2KImageReader not loaded. JPEG2000 files will not be processed.\n");
                sb.append("See https://pdfbox.apache.org/2.0/dependencies.html#jai-image-io\n");
                sb.append("for optional dependencies.\n");
            }
            if (sb.length() > 0) {
                InitializableProblemHandler localInitializableProblemHandler = this.initializableProblemHandler == null ? handler : this.initializableProblemHandler;
                localInitializableProblemHandler.handleInitializableProblem("org.apache.tika.parsers.PDFParser", sb.toString());
            }
            HAS_WARNED = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

