/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.marshaller;

import com.sun.xml.bind.util.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class SchemaLocationFilter
extends XMLFilterImpl {
    private final String schemaLocation;
    private final String noNSSchemaLocation;
    private boolean rootElement = true;
    private String seenXsiURI = null;
    private String prefix = "xsi";
    private boolean prefixDeclared = false;
    private String xsiURI = "http://www.w3.org/2001/XMLSchema-instance";
    private int elementCount = 0;

    public SchemaLocationFilter(String _schemaLocation, String _noNSSchemaLocation, ContentHandler _writer) {
        this.schemaLocation = _schemaLocation;
        this.noNSSchemaLocation = _noNSSchemaLocation;
        this.setContentHandler(_writer);
    }

    public void startElement(String namespaceURI, String localName, String qname, Attributes atts) throws SAXException {
        ++this.elementCount;
        if (this.rootElement) {
            AttributesImpl attributes = new AttributesImpl(atts);
            atts = attributes;
            if (this.seenXsiURI == null || !this.seenXsiURI.equals(this.xsiURI)) {
                if (this.seenXsiURI != null) {
                    this.prefix = "xmlschemainstance";
                }
                this.prefixDeclared = true;
                super.startPrefixMapping(this.prefix, this.xsiURI);
            }
            if (this.schemaLocation != null) {
                attributes.addAttribute(this.xsiURI, "schemaLocation", this.prefix + ":schemaLocation", "CDATA", this.schemaLocation);
            }
            if (this.noNSSchemaLocation != null) {
                attributes.addAttribute(this.xsiURI, "noNamespaceSchemaLocation", this.prefix + ":noNamespaceSchemaLocation", "CDATA", this.noNSSchemaLocation);
            }
            this.rootElement = false;
        }
        super.startElement(namespaceURI, localName, qname, atts);
    }

    public void endElement(String namespaceURI, String localName, String qname) throws SAXException {
        if (--this.elementCount == 0 && this.prefixDeclared) {
            super.endPrefixMapping(this.prefix);
        }
        super.endElement(namespaceURI, localName, qname);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if ("xsi".equals(prefix)) {
            this.seenXsiURI = uri;
        }
        super.startPrefixMapping(prefix, uri);
    }
}

