/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.catalina.Host;
import org.apache.catalina.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ExpandWar {
    private static Log log = LogFactory.getLog(ExpandWar.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    public static String expand(Host host, URL war) throws IOException {
        int slash;
        int period;
        String pathname;
        if (host.getLogger().isDebugEnabled()) {
            host.getLogger().debug((Object)("expand(" + war.toString() + ")"));
        }
        if ((pathname = war.toString().replace('\\', '/')).endsWith("!/")) {
            pathname = pathname.substring(0, pathname.length() - 2);
        }
        if ((period = pathname.lastIndexOf(46)) >= pathname.length() - 4) {
            pathname = pathname.substring(0, period);
        }
        if ((slash = pathname.lastIndexOf(47)) >= 0) {
            pathname = pathname.substring(slash + 1);
        }
        if (host.getLogger().isDebugEnabled()) {
            host.getLogger().debug((Object)("  Proposed directory name: " + pathname));
        }
        return ExpandWar.expand(host, war, pathname);
    }

    /*
     * Loose catch block
     */
    public static String expand(Host host, URL war, String pathname) throws IOException {
        File docBase;
        block26: {
            Throwable t2;
            boolean success;
            InputStream input;
            JarFile jarFile;
            block23: {
                File appBase = new File(host.getAppBase());
                if (!appBase.isAbsolute()) {
                    appBase = new File(System.getProperty("catalina.base"), host.getAppBase());
                }
                if (!appBase.exists() || !appBase.isDirectory()) {
                    throw new IOException(sm.getString("hostConfig.appBase", appBase.getAbsolutePath()));
                }
                docBase = new File(appBase, pathname);
                if (docBase.exists()) {
                    return docBase.getAbsolutePath();
                }
                if (!docBase.mkdir() && !docBase.isDirectory()) {
                    throw new IOException(sm.getString("expandWar.createFailed", docBase));
                }
                String canonicalDocBasePrefix = docBase.getCanonicalPath();
                if (!canonicalDocBasePrefix.endsWith(File.separator)) {
                    canonicalDocBasePrefix = canonicalDocBasePrefix + File.separator;
                }
                JarURLConnection juc = (JarURLConnection)war.openConnection();
                juc.setUseCaches(false);
                jarFile = null;
                input = null;
                success = false;
                jarFile = juc.getJarFile();
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    File parent;
                    JarEntry jarEntry = jarEntries.nextElement();
                    String name = jarEntry.getName();
                    File expandedFile = new File(docBase, name);
                    if (!expandedFile.getCanonicalPath().startsWith(canonicalDocBasePrefix)) {
                        throw new IllegalArgumentException(sm.getString("expandWar.illegalPath", war, name));
                    }
                    int last = name.lastIndexOf(47);
                    if (last >= 0 && !(parent = new File(docBase, name.substring(0, last))).mkdirs() && !parent.isDirectory()) {
                        throw new IOException(sm.getString("expandWar.createFailed", parent));
                    }
                    if (name.endsWith("/")) continue;
                    input = jarFile.getInputStream(jarEntry);
                    ExpandWar.expand(input, expandedFile);
                    long lastModified = jarEntry.getTime();
                    if (lastModified != -1L && lastModified != 0L) {
                        expandedFile.setLastModified(lastModified);
                    }
                    input.close();
                    input = null;
                }
                success = true;
                Object var18_18 = null;
                if (success) break block23;
                ExpandWar.deleteDir(docBase);
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable t2) {
                    // empty catch block
                }
                input = null;
            }
            if (jarFile == null) break block26;
            try {
                jarFile.close();
            }
            catch (Throwable t2) {
                // empty catch block
            }
            jarFile = null;
            {
                break block26;
                catch (IOException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var18_19 = null;
                if (!success) {
                    ExpandWar.deleteDir(docBase);
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    input = null;
                }
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    jarFile = null;
                }
                throw throwable;
            }
        }
        return docBase.getAbsolutePath();
    }

    /*
     * Loose catch block
     */
    public static void validate(Host host, URL war, String pathname) throws IOException {
        block11: {
            File docBase;
            String canonicalDocBasePrefix;
            File appBase = new File(host.getAppBase());
            if (!appBase.isAbsolute()) {
                appBase = new File(System.getProperty("catalina.base"), host.getAppBase());
            }
            if (!(canonicalDocBasePrefix = (docBase = new File(appBase, pathname)).getCanonicalPath()).endsWith(File.separator)) {
                canonicalDocBasePrefix = canonicalDocBasePrefix + File.separator;
            }
            JarURLConnection juc = (JarURLConnection)war.openConnection();
            juc.setUseCaches(false);
            JarFile jarFile = null;
            jarFile = juc.getJarFile();
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String name = jarEntry.getName();
                File expandedFile = new File(docBase, name);
                if (expandedFile.getCanonicalPath().startsWith(canonicalDocBasePrefix)) continue;
                throw new IllegalArgumentException(sm.getString("expandWar.illegalPath", war, name));
            }
            Object var13_13 = null;
            if (jarFile == null) break block11;
            try {
                jarFile.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            jarFile = null;
            {
                break block11;
                catch (IOException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    jarFile = null;
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean copy(File src, File dest) {
        boolean result = true;
        String[] files = null;
        if (src.isDirectory()) {
            files = src.list();
            result = dest.mkdir();
        } else {
            files = new String[]{""};
        }
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length && result; ++i) {
            IOException e2222;
            Object var11_10;
            AbstractInterruptibleChannel oc;
            FileChannel ic;
            File fileDest;
            File fileSrc;
            block20: {
                fileSrc = new File(src, files[i]);
                fileDest = new File(dest, files[i]);
                if (fileSrc.isDirectory()) {
                    result = ExpandWar.copy(fileSrc, fileDest);
                    continue;
                }
                ic = null;
                oc = null;
                ic = new FileInputStream(fileSrc).getChannel();
                oc = new FileOutputStream(fileDest).getChannel();
                ic.transferTo(0L, ic.size(), (WritableByteChannel)((Object)oc));
                var11_10 = null;
                if (ic == null) break block20;
                try {
                    ic.close();
                }
                catch (IOException e2222) {
                    // empty catch block
                }
            }
            if (oc == null) continue;
            try {
                oc.close();
            }
            catch (IOException e2222) {}
            continue;
            {
                catch (IOException e3) {
                    log.error((Object)sm.getString("expandWar.copy", fileSrc, fileDest), (Throwable)e3);
                    result = false;
                    var11_10 = null;
                    if (ic != null) {
                        try {
                            ic.close();
                        }
                        catch (IOException e2222) {
                            // empty catch block
                        }
                    }
                    if (oc == null) continue;
                    try {
                        oc.close();
                    }
                    catch (IOException e2222) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var11_10 = null;
                if (ic != null) {
                    try {
                        ic.close();
                    }
                    catch (IOException e2222) {
                        // empty catch block
                    }
                }
                if (oc != null) {
                    try {
                        oc.close();
                    }
                    catch (IOException e2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return result;
    }

    public static boolean delete(File dir) {
        return ExpandWar.delete(dir, true);
    }

    public static boolean delete(File dir, boolean logFailure) {
        boolean result = dir.isDirectory() ? ExpandWar.deleteDir(dir, logFailure) : (dir.exists() ? dir.delete() : true);
        if (logFailure && !result) {
            log.error((Object)sm.getString("expandWar.deleteFailed", dir.getAbsolutePath()));
        }
        return result;
    }

    public static boolean deleteDir(File dir) {
        return ExpandWar.deleteDir(dir, true);
    }

    public static boolean deleteDir(File dir, boolean logFailure) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                ExpandWar.deleteDir(file, logFailure);
                continue;
            }
            file.delete();
        }
        boolean result = dir.exists() ? dir.delete() : true;
        if (logFailure && !result) {
            log.error((Object)sm.getString("expandWar.deleteFailed", dir.getAbsolutePath()));
        }
        return result;
    }

    protected static File expand(InputStream input, File docBase, String name) throws IOException {
        File file = new File(docBase, name);
        ExpandWar.expand(input, file);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void expand(InputStream input, File file) throws IOException {
        BufferedOutputStream output = null;
        try {
            int n;
            output = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[2048];
            while ((n = input.read(buffer)) > 0) {
                output.write(buffer, 0, n);
            }
            Object var6_5 = null;
            if (output == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (output == null) throw throwable;
            try {
                output.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            output.close();
            return;
        }
        catch (IOException e) {}
    }
}

