/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;

final class ByteConverter
implements Converter {
    public static final ByteConverter INSTANCE = new ByteConverter();

    ByteConverter() {
    }

    @Override
    public boolean accept(Class<?> cls) {
        return Byte.TYPE == cls || Byte.class == cls;
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        if (value == null) {
            return c == Byte.TYPE ? Byte.valueOf((byte)0) : null;
        }
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        } else if (value instanceof List) {
            List src = (List)value;
            Object object = value = !src.isEmpty() ? (Object)src.get(0) : null;
        }
        if (value == null) {
            return c == Byte.TYPE ? Byte.valueOf((byte)0) : null;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).byteValueExact();
        }
        if (value instanceof String) {
            String str;
            NumberFormat f = context.getNumberFormat();
            if (f != null) {
                value = f.parse((String)value);
            }
            if ((str = value.toString().trim().toLowerCase()).length() > 0) {
                int start = 0;
                if (str.charAt(0) == '+') {
                    ++start;
                }
                int num = 0;
                num = str.startsWith("0x", start) ? Integer.parseInt(str.substring(start + 2), 16) : Integer.parseInt(str.substring(start));
                return (byte)(num > 127 ? num - 256 : num);
            }
            return c == Byte.TYPE ? Byte.valueOf((byte)0) : null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to " + t);
    }
}

