/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import net.arnx.jsonic.AppendableConverter;
import net.arnx.jsonic.ArrayConverter;
import net.arnx.jsonic.BigDecimalConverter;
import net.arnx.jsonic.BigIntegerConverter;
import net.arnx.jsonic.BooleanArrayFormatter;
import net.arnx.jsonic.BooleanConverter;
import net.arnx.jsonic.ByteArrayFormatter;
import net.arnx.jsonic.ByteConverter;
import net.arnx.jsonic.ByteFormatter;
import net.arnx.jsonic.CalendarConverter;
import net.arnx.jsonic.CalendarFormatter;
import net.arnx.jsonic.CharArrayFormatter;
import net.arnx.jsonic.CharSequenceConverter;
import net.arnx.jsonic.CharacterConverter;
import net.arnx.jsonic.CharsetConverter;
import net.arnx.jsonic.CharsetFormatter;
import net.arnx.jsonic.ClassConverter;
import net.arnx.jsonic.ClassFormatter;
import net.arnx.jsonic.CollectionConverter;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.DateConverter;
import net.arnx.jsonic.DateFormatter;
import net.arnx.jsonic.DoubleArrayFormatter;
import net.arnx.jsonic.DoubleConverter;
import net.arnx.jsonic.EnumConverter;
import net.arnx.jsonic.EnumFormatter;
import net.arnx.jsonic.EnumerationFormatter;
import net.arnx.jsonic.FileConverter;
import net.arnx.jsonic.FloatArrayFormatter;
import net.arnx.jsonic.FloatConverter;
import net.arnx.jsonic.FloatFormatter;
import net.arnx.jsonic.FormatConverter;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.IntArrayFormatter;
import net.arnx.jsonic.IntegerConverter;
import net.arnx.jsonic.IterableFormatter;
import net.arnx.jsonic.IteratorFormatter;
import net.arnx.jsonic.JSONException;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.JSONReader;
import net.arnx.jsonic.JSONWriter;
import net.arnx.jsonic.ListFormatter;
import net.arnx.jsonic.LocaleConverter;
import net.arnx.jsonic.LocaleFormatter;
import net.arnx.jsonic.LongArrayFormatter;
import net.arnx.jsonic.LongConverter;
import net.arnx.jsonic.MapConverter;
import net.arnx.jsonic.MapFormatter;
import net.arnx.jsonic.NamingStyle;
import net.arnx.jsonic.NullFormatter;
import net.arnx.jsonic.NumberFormatter;
import net.arnx.jsonic.ObjectArrayFormatter;
import net.arnx.jsonic.ObjectConverter;
import net.arnx.jsonic.ObjectFormatter;
import net.arnx.jsonic.PatternConverter;
import net.arnx.jsonic.PlainConverter;
import net.arnx.jsonic.PlainFormatter;
import net.arnx.jsonic.PropertiesConverter;
import net.arnx.jsonic.SerializableConverter;
import net.arnx.jsonic.SerializableFormatter;
import net.arnx.jsonic.ShortArrayFormatter;
import net.arnx.jsonic.ShortConverter;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.StringSerializableConverter;
import net.arnx.jsonic.StringableFormmatter;
import net.arnx.jsonic.TimeZoneConverter;
import net.arnx.jsonic.TimeZoneFormatter;
import net.arnx.jsonic.TypeReference;
import net.arnx.jsonic.URIConverter;
import net.arnx.jsonic.URLConverter;
import net.arnx.jsonic.UUIDConverter;
import net.arnx.jsonic.io.AppendableOutputSource;
import net.arnx.jsonic.io.CharSequenceInputSource;
import net.arnx.jsonic.io.OutputSource;
import net.arnx.jsonic.io.ReaderInputSource;
import net.arnx.jsonic.io.StringBufferInputSource;
import net.arnx.jsonic.io.StringBuilderInputSource;
import net.arnx.jsonic.io.StringBuilderOutputSource;
import net.arnx.jsonic.io.StringInputSource;
import net.arnx.jsonic.io.WriterOutputSource;
import net.arnx.jsonic.util.BeanInfo;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.util.LocalCache;

public class JSON {
    public static volatile Class<? extends JSON> prototype = JSON.class;
    static final Character ROOT = Character.valueOf('$');
    private static final String PACKAGE_NAME = JSON.class.getName().substring(0, JSON.class.getName().lastIndexOf(46));
    private static final Map<Class<?>, Class<?>> PRIMITIVE_MAP = new HashMap(10);
    private static final Map<Class<?>, Formatter> FORMAT_MAP = new HashMap(50);
    private static final List<Formatter> FORMAT_LIST = new ArrayList<Formatter>(24);
    private static final Map<Class<?>, Converter> CONVERT_MAP = new HashMap(50);
    private static final List<Converter> CONVERT_LIST = new ArrayList<Converter>(24);
    Object contextObject;
    Locale locale = Locale.getDefault();
    TimeZone timeZone = TimeZone.getDefault();
    boolean prettyPrint = false;
    int initialIndent = 0;
    String indentText = "\t";
    int maxDepth = 32;
    boolean suppressNull = false;
    Mode mode = Mode.TRADITIONAL;
    String dateFormat;
    String numberFormat;
    NamingStyle propertyStyle = NamingStyle.NOOP;
    NamingStyle enumStyle = NamingStyle.NOOP;

    static Formatter getFormatterInstance(String name, ClassLoader cl) {
        try {
            Class<?> cls = Class.forName(name, true, cl);
            Formatter formatter = (Formatter)BeanInfo.get(cls).newInstance();
            formatter.accept(Object.class);
            return formatter;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return null;
    }

    static Converter getConverterInstance(String name, ClassLoader cl) {
        try {
            Class<?> cls = Class.forName(name, true, cl);
            Converter converter = (Converter)BeanInfo.get(cls).newInstance();
            converter.accept(Object.class);
            return converter;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return null;
    }

    static JSON newInstance() {
        JSON instance = null;
        try {
            instance = prototype.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return instance;
    }

    public static String encode(Object source) throws JSONException {
        return JSON.encode(source, false);
    }

    public static String encode(Object source, boolean prettyPrint) throws JSONException {
        JSON json = JSON.newInstance();
        json.setPrettyPrint(prettyPrint);
        return json.format(source);
    }

    public static void encode(Object source, OutputStream out) throws IOException, JSONException {
        JSON.newInstance().format(source, new OutputStreamWriter(out, "UTF-8"));
    }

    public static void encode(Object source, OutputStream out, boolean prettyPrint) throws IOException, JSONException {
        JSON json = JSON.newInstance();
        json.setPrettyPrint(prettyPrint);
        json.format(source, new OutputStreamWriter(out, "UTF-8"));
    }

    public static void encode(Object source, Appendable appendable) throws IOException, JSONException {
        JSON.newInstance().format(source, appendable);
    }

    public static void encode(Object source, Appendable appendable, boolean prettyPrint) throws IOException, JSONException {
        JSON json = JSON.newInstance();
        json.setPrettyPrint(prettyPrint);
        json.format(source, appendable);
    }

    public static String escapeScript(Object source) throws JSONException {
        JSON json = JSON.newInstance();
        json.setMode(Mode.SCRIPT);
        return json.format(source);
    }

    public static void escapeScript(Object source, OutputStream out) throws IOException, JSONException {
        JSON json = JSON.newInstance();
        json.setMode(Mode.SCRIPT);
        json.format(source, out);
    }

    public static void escapeScript(Object source, Appendable appendable) throws IOException, JSONException {
        JSON json = JSON.newInstance();
        json.setMode(Mode.SCRIPT);
        json.format(source, appendable);
    }

    public static <T> T decode(String source) throws JSONException {
        return JSON.newInstance().parse(source);
    }

    public static <T> T decode(String source, Class<? extends T> cls) throws JSONException {
        return JSON.newInstance().parse((CharSequence)source, cls);
    }

    public static <T> T decode(String source, Type type) throws JSONException {
        return JSON.newInstance().parse((CharSequence)source, type);
    }

    public static <T> T decode(InputStream in) throws IOException, JSONException {
        return JSON.newInstance().parse(in);
    }

    public static <T> T decode(InputStream in, Class<? extends T> cls) throws IOException, JSONException {
        return JSON.newInstance().parse(in, cls);
    }

    public static <T> T decode(InputStream in, Type type) throws IOException, JSONException {
        return JSON.newInstance().parse(in, type);
    }

    public static <T> T decode(Reader reader) throws IOException, JSONException {
        return JSON.newInstance().parse(reader);
    }

    public static <T> T decode(Reader reader, Class<? extends T> cls) throws IOException, JSONException {
        return JSON.newInstance().parse(reader, cls);
    }

    public static <T> T decode(Reader reader, Type type) throws IOException, JSONException {
        return JSON.newInstance().parse(reader, type);
    }

    public static void validate(CharSequence cs) throws JSONException {
        JSON json = JSON.newInstance();
        json.setMode(Mode.STRICT);
        json.setMaxDepth(0);
        json.parse(cs);
    }

    public static void validate(InputStream in) throws IOException, JSONException {
        JSON json = JSON.newInstance();
        json.setMode(Mode.STRICT);
        json.setMaxDepth(0);
        json.parse(in);
    }

    public static void validate(Reader reader) throws IOException, JSONException {
        JSON json = JSON.newInstance();
        json.setMode(Mode.STRICT);
        json.setMaxDepth(0);
        json.parse(reader);
    }

    public JSON() {
    }

    public JSON(int maxDepth) {
        this.setMaxDepth(maxDepth);
    }

    public JSON(Mode mode) {
        this.setMode(mode);
    }

    public void setContext(Object value) {
        this.contextObject = value;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        this.locale = locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException();
        }
        this.timeZone = timeZone;
    }

    public void setPrettyPrint(boolean value) {
        this.prettyPrint = value;
    }

    public void setInitialIndent(int indent) {
        if (indent < 0) {
            throw new IllegalArgumentException(this.getMessage("json.TooSmallArgumentError", "initialIndent", 0));
        }
        this.initialIndent = indent;
    }

    public void setIndentText(String text) {
        this.indentText = text;
    }

    public void setMaxDepth(int value) {
        if (value < 0) {
            throw new IllegalArgumentException(this.getMessage("json.TooSmallArgumentError", "maxDepth", 0));
        }
        this.maxDepth = value;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setSuppressNull(boolean value) {
        this.suppressNull = value;
    }

    public void setMode(Mode mode) {
        if (mode == null) {
            throw new NullPointerException();
        }
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    public void setNumberFormat(String format) {
        this.numberFormat = format;
    }

    public void setPropertyStyle(NamingStyle style) {
        this.propertyStyle = style;
    }

    public void setEnumStyle(NamingStyle style) {
        this.enumStyle = style;
    }

    public String format(Object source) {
        String text = null;
        try {
            if (source == null) {
                return "null";
            }
            int len = source instanceof CharSequence ? ((CharSequence)source).length() + 16 : (source instanceof Boolean ? 5 : (source instanceof Number ? 20 : 1000));
            StringBuilderOutputSource out = new StringBuilderOutputSource(len);
            this.format(source, out);
            text = ((Object)out).toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return text;
    }

    public OutputStream format(Object source, OutputStream out) throws IOException {
        this.format(source, new BufferedWriter(new OutputStreamWriter(out, "UTF-8")));
        return out;
    }

    public Appendable format(Object source, Appendable ap) throws IOException {
        OutputSource out = ap instanceof BufferedWriter ? new AppendableOutputSource(ap) : (ap instanceof Writer ? new WriterOutputSource((Writer)ap) : (ap instanceof StringBuilder ? new StringBuilderOutputSource((StringBuilder)ap) : new AppendableOutputSource(ap)));
        this.format(source, out);
        return ap;
    }

    private void format(Object source, OutputSource out) throws IOException {
        Context context = new Context();
        if (context.isPrettyPrint()) {
            context.appendIndent(out, 0);
        }
        context.enter(ROOT, null);
        source = context.preformatInternal(source != null ? source.getClass() : Object.class, source);
        context.formatInternal(source, out);
        context.exit();
        out.flush();
    }

    public JSONWriter getWriter(OutputStream out) throws IOException {
        return this.getWriter(new OutputStreamWriter(out, "UTF-8"));
    }

    public JSONWriter getWriter(Appendable ap) throws IOException {
        OutputSource out = ap instanceof BufferedWriter ? new AppendableOutputSource(ap) : (ap instanceof Writer ? new WriterOutputSource((Writer)ap) : (ap instanceof StringBuilder ? new StringBuilderOutputSource((StringBuilder)ap) : new AppendableOutputSource(ap)));
        return new JSONWriter(new Context(), out);
    }

    protected Object preformatNull(Context context, Type type) throws Exception {
        return null;
    }

    protected Object preformat(Context context, Object value) throws Exception {
        return value;
    }

    public <T> T parse(CharSequence cs) throws JSONException {
        CharSequenceInputSource is = cs instanceof String ? new StringInputSource((String)cs) : (cs instanceof StringBuilder ? new StringBuilderInputSource((StringBuilder)cs) : (cs instanceof StringBuffer ? new StringBufferInputSource((StringBuffer)cs) : new CharSequenceInputSource(cs)));
        Object value = null;
        try {
            JSONReader jreader = new JSONReader(new Context(), is, false, true);
            value = jreader.next() != null ? jreader.getValue() : null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (T)value;
    }

    public <T> T parse(CharSequence s, Class<? extends T> cls) throws JSONException {
        return this.parse(s, (Type)cls);
    }

    public <T> T parse(CharSequence cs, Type type) throws JSONException {
        CharSequenceInputSource is = cs instanceof String ? new StringInputSource((String)cs) : (cs instanceof StringBuilder ? new StringBuilderInputSource((StringBuilder)cs) : (cs instanceof StringBuffer ? new StringBufferInputSource((StringBuffer)cs) : new CharSequenceInputSource(cs)));
        if (type instanceof TypeReference) {
            type = ((TypeReference)type).getType();
        }
        T value = null;
        try {
            Context context = new Context();
            JSONReader jreader = new JSONReader(context, is, false, true);
            Object result = jreader.next() != null ? jreader.getValue() : null;
            value = context.convertInternal(result, ClassUtil.getRawType(type), type);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }

    public <T> T parse(InputStream in) throws IOException, JSONException {
        JSONReader jreader = new JSONReader(new Context(), new ReaderInputSource(in), false, true);
        return (T)(jreader.next() != null ? jreader.getValue() : null);
    }

    public <T> T parse(InputStream in, Class<? extends T> cls) throws IOException, JSONException {
        return this.parse(in, (Type)cls);
    }

    public <T> T parse(InputStream in, Type type) throws IOException, JSONException {
        Context context;
        JSONReader jreader;
        if (type instanceof TypeReference) {
            type = ((TypeReference)type).getType();
        }
        Object result = (jreader = new JSONReader(context = new Context(), new ReaderInputSource(in), false, true)).next() != null ? jreader.getValue() : null;
        return context.convertInternal(result, ClassUtil.getRawType(type), type);
    }

    public <T> T parse(Reader reader) throws IOException, JSONException {
        JSONReader jreader = new JSONReader(new Context(), new ReaderInputSource(reader), false, true);
        return (T)(jreader.next() != null ? jreader.getValue() : null);
    }

    public <T> T parse(Reader reader, Class<? extends T> cls) throws IOException, JSONException {
        return this.parse(reader, (Type)cls);
    }

    public <T> T parse(Reader reader, Type type) throws IOException, JSONException {
        Context context;
        JSONReader jreader;
        if (type instanceof TypeReference) {
            type = ((TypeReference)type).getType();
        }
        Object result = (jreader = new JSONReader(context = new Context(), new ReaderInputSource(reader), false, true)).next() != null ? jreader.getValue() : null;
        return context.convertInternal(result, ClassUtil.getRawType(type), type);
    }

    public JSONReader getReader(CharSequence cs) {
        return this.getReader(cs, true);
    }

    public JSONReader getReader(InputStream in) {
        return this.getReader(in, true);
    }

    public JSONReader getReader(Reader reader) {
        return this.getReader(reader, true);
    }

    public JSONReader getReader(CharSequence cs, boolean ignoreWhitespace) {
        CharSequenceInputSource in = cs instanceof String ? new StringInputSource((String)cs) : (cs instanceof StringBuilder ? new StringBuilderInputSource((StringBuilder)cs) : (cs instanceof StringBuffer ? new StringBufferInputSource((StringBuffer)cs) : new CharSequenceInputSource(cs)));
        return new JSONReader(new Context(), in, true, ignoreWhitespace);
    }

    public JSONReader getReader(InputStream in, boolean ignoreWhitespace) {
        return new JSONReader(new Context(), new ReaderInputSource(in), true, ignoreWhitespace);
    }

    public JSONReader getReader(Reader reader, boolean ignoreWhitespace) {
        return new JSONReader(new Context(), new ReaderInputSource(reader), true, ignoreWhitespace);
    }

    String getMessage(String id, Object ... args) {
        ResourceBundle bundle = ResourceBundle.getBundle(PACKAGE_NAME + ".Messages", this.locale);
        return MessageFormat.format(bundle.getString(id), args);
    }

    public Object convert(Object value, Type type) throws JSONException {
        if (type instanceof TypeReference) {
            type = ((TypeReference)type).getType();
        }
        return new Context().convertInternal(value, ClassUtil.getRawType(type), type);
    }

    protected <T> T postparse(Context context, Object value, Class<? extends T> cls, Type type) throws Exception {
        Object hint;
        Converter c = null;
        if (value != null && (hint = context.getHint()) != null) {
            if (hint.serialized() && hint != context.skipHint) {
                c = FormatConverter.INSTANCE;
            } else if (Serializable.class.equals(hint.type())) {
                c = SerializableConverter.INSTANCE;
            } else if (String.class.equals(hint.type())) {
                c = StringSerializableConverter.INSTANCE;
            } else if (hint.type() != Object.class && cls.isAssignableFrom(hint.type())) {
                cls = hint.type().asSubclass(cls);
            }
        }
        if (c == null) {
            c = value != null && cls == type && cls.isAssignableFrom(value.getClass()) ? PlainConverter.INSTANCE : CONVERT_MAP.get(cls);
        }
        if (c == null && context.memberCache != null) {
            c = (Converter)context.memberCache.get(cls);
        }
        if (c == null) {
            for (Converter converter : CONVERT_LIST) {
                if (!converter.accept(cls)) continue;
                c = converter;
                break;
            }
            if (c == null) {
                c = new ObjectConverter(cls);
            }
            if (context.memberCache == null) {
                context.memberCache = new HashMap();
            }
            context.memberCache.put(cls, c);
        }
        Object ret = c.convert(context, value, cls, type);
        return (T)ret;
    }

    protected String normalize(String name) {
        return name;
    }

    protected boolean ignore(Context context, Class<?> target, Member member) {
        if (Modifier.isTransient(member.getModifiers())) {
            return true;
        }
        return member.getDeclaringClass().equals(Object.class);
    }

    protected <T> T create(Context context, Class<? extends T> c) throws Exception {
        Serializable instance = null;
        if (Collection.class.equals(c) || List.class.equals(c) || ArrayList.class.equals(c)) {
            instance = context.createSizeHint >= 0 ? new ArrayList(context.createSizeHint) : new ArrayList();
        } else if (Map.class.equals(c)) {
            if (context.createSizeHint >= 0) {
                int capacity = Math.max((int)((float)context.createSizeHint / 0.75f) + 1, 16);
                instance = new LinkedHashMap(capacity);
            } else {
                instance = new LinkedHashMap();
            }
        } else if (c.isInterface()) {
            if (SortedMap.class.equals(c)) {
                instance = new TreeMap();
            } else if (SortedSet.class.equals(c)) {
                instance = new TreeSet();
            } else if (Set.class.equals(c)) {
                instance = new LinkedHashSet();
            } else if (Appendable.class.equals(c)) {
                instance = new StringBuilder();
            }
        } else if (Modifier.isAbstract(c.getModifiers())) {
            if (Calendar.class.equals(c)) {
                instance = Calendar.getInstance();
            }
        } else if ((c.isMemberClass() || c.isAnonymousClass()) && !Modifier.isStatic(c.getModifiers())) {
            Class<?> eClass = c.getEnclosingClass();
            Constructor<T> con = c.getDeclaredConstructor(eClass);
            con.setAccessible(true);
            instance = context.contextObject != null && eClass.isAssignableFrom(context.contextObject.getClass()) ? con.newInstance(context.contextObject) : con.newInstance(new Object[]{null});
        } else {
            Constructor<T> con;
            if (Date.class.isAssignableFrom(c)) {
                try {
                    con = c.getDeclaredConstructor(Long.TYPE);
                    con.setAccessible(true);
                    instance = con.newInstance(0L);
                }
                catch (NoSuchMethodException con2) {
                    // empty catch block
                }
            }
            if (instance == null) {
                con = c.getDeclaredConstructor(new Class[0]);
                con.setAccessible(true);
                instance = con.newInstance(new Object[0]);
            }
        }
        return c.cast(instance);
    }

    static {
        ClassLoader cl = JSON.class.getClassLoader();
        try {
            ClassLoader contextCL;
            ClassLoader current = contextCL = Thread.currentThread().getContextClassLoader();
            do {
                if (current != cl) continue;
                cl = contextCL;
                break;
            } while ((current = current.getParent()) != null);
        }
        catch (SecurityException contextCL) {
            // empty catch block
        }
        PRIMITIVE_MAP.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_MAP.put(Double.TYPE, Double.class);
        PRIMITIVE_MAP.put(Character.TYPE, Character.class);
        Formatter formatter = null;
        FORMAT_MAP.put(Boolean.TYPE, PlainFormatter.INSTANCE);
        FORMAT_MAP.put(Character.TYPE, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Byte.TYPE, ByteFormatter.INSTANCE);
        FORMAT_MAP.put(Short.TYPE, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Integer.TYPE, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Long.TYPE, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Float.TYPE, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(Double.TYPE, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(boolean[].class, BooleanArrayFormatter.INSTANCE);
        FORMAT_MAP.put(char[].class, CharArrayFormatter.INSTANCE);
        FORMAT_MAP.put(byte[].class, ByteArrayFormatter.INSTANCE);
        FORMAT_MAP.put(short[].class, ShortArrayFormatter.INSTANCE);
        FORMAT_MAP.put(int[].class, IntArrayFormatter.INSTANCE);
        FORMAT_MAP.put(long[].class, LongArrayFormatter.INSTANCE);
        FORMAT_MAP.put(float[].class, FloatArrayFormatter.INSTANCE);
        FORMAT_MAP.put(double[].class, DoubleArrayFormatter.INSTANCE);
        FORMAT_MAP.put(Object[].class, ObjectArrayFormatter.INSTANCE);
        FORMAT_MAP.put(Boolean.class, PlainFormatter.INSTANCE);
        FORMAT_MAP.put(Character.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Byte.class, ByteFormatter.INSTANCE);
        FORMAT_MAP.put(Short.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Integer.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Long.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(Float.class, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(Double.class, FloatFormatter.INSTANCE);
        FORMAT_MAP.put(BigInteger.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(BigDecimal.class, NumberFormatter.INSTANCE);
        FORMAT_MAP.put(String.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Date.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(java.sql.Date.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(Time.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(Timestamp.class, DateFormatter.INSTANCE);
        FORMAT_MAP.put(URI.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(URL.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(UUID.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Pattern.class, StringFormatter.INSTANCE);
        FORMAT_MAP.put(Class.class, ClassFormatter.INSTANCE);
        FORMAT_MAP.put(Locale.class, LocaleFormatter.INSTANCE);
        FORMAT_MAP.put(ArrayList.class, ListFormatter.INSTANCE);
        FORMAT_MAP.put(LinkedList.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(HashSet.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(TreeSet.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(LinkedHashSet.class, IterableFormatter.INSTANCE);
        FORMAT_MAP.put(HashMap.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(IdentityHashMap.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(Properties.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(TreeMap.class, MapFormatter.INSTANCE);
        FORMAT_MAP.put(LinkedHashMap.class, MapFormatter.INSTANCE);
        formatter = JSON.getFormatterInstance(PACKAGE_NAME + ".PathFormatter", cl);
        if (formatter != null) {
            FORMAT_LIST.add(formatter);
        }
        if ((formatter = JSON.getFormatterInstance(PACKAGE_NAME + ".TemporalEnumFormatter", cl)) != null) {
            FORMAT_LIST.add(formatter);
        }
        FORMAT_LIST.add(EnumFormatter.INSTANCE);
        FORMAT_LIST.add(MapFormatter.INSTANCE);
        FORMAT_LIST.add(ListFormatter.INSTANCE);
        FORMAT_LIST.add(IterableFormatter.INSTANCE);
        FORMAT_LIST.add(ObjectArrayFormatter.INSTANCE);
        FORMAT_LIST.add(StringableFormmatter.INSTANCE);
        FORMAT_LIST.add(DateFormatter.INSTANCE);
        FORMAT_LIST.add(CalendarFormatter.INSTANCE);
        FORMAT_LIST.add(NumberFormatter.INSTANCE);
        FORMAT_LIST.add(IteratorFormatter.INSTANCE);
        FORMAT_LIST.add(EnumerationFormatter.INSTANCE);
        FORMAT_LIST.add(TimeZoneFormatter.INSTANCE);
        FORMAT_LIST.add(CharsetFormatter.INSTANCE);
        formatter = JSON.getFormatterInstance(PACKAGE_NAME + ".SQLArrayFormatter", cl);
        if (formatter != null) {
            FORMAT_LIST.add(formatter);
        }
        if ((formatter = JSON.getFormatterInstance(PACKAGE_NAME + ".StructFormmatter", cl)) != null) {
            FORMAT_LIST.add(formatter);
        }
        if ((formatter = JSON.getFormatterInstance(PACKAGE_NAME + ".RowIdFormatter", cl)) != null) {
            FORMAT_LIST.add(formatter);
        }
        if ((formatter = JSON.getFormatterInstance(PACKAGE_NAME + ".ElementNodeFormatter", cl)) != null) {
            FORMAT_LIST.add(formatter);
        }
        if ((formatter = JSON.getFormatterInstance(PACKAGE_NAME + ".TextNodeFormatter", cl)) != null) {
            FORMAT_LIST.add(formatter);
        }
        if ((formatter = JSON.getFormatterInstance(PACKAGE_NAME + ".InetAddressFormatter", cl)) != null) {
            FORMAT_LIST.add(formatter);
        }
        if ((formatter = JSON.getFormatterInstance(PACKAGE_NAME + ".DynaBeanFormatter", cl)) != null) {
            FORMAT_LIST.add(formatter);
        }
        if ((formatter = JSON.getFormatterInstance(PACKAGE_NAME + ".OptionalIntFormatter", cl)) != null) {
            FORMAT_LIST.add(formatter);
        }
        if ((formatter = JSON.getFormatterInstance(PACKAGE_NAME + ".OptionalLongFormatter", cl)) != null) {
            FORMAT_LIST.add(formatter);
        }
        if ((formatter = JSON.getFormatterInstance(PACKAGE_NAME + ".OptionalDoubleFormatter", cl)) != null) {
            FORMAT_LIST.add(formatter);
        }
        if ((formatter = JSON.getFormatterInstance(PACKAGE_NAME + ".OptionalFormatter", cl)) != null) {
            FORMAT_LIST.add(formatter);
        }
        if ((formatter = JSON.getFormatterInstance(PACKAGE_NAME + ".InstantFormatter", cl)) != null) {
            FORMAT_LIST.add(formatter);
        }
        if ((formatter = JSON.getFormatterInstance(PACKAGE_NAME + ".TemporalAccessorFormatter", cl)) != null) {
            FORMAT_LIST.add(formatter);
        }
        if ((formatter = JSON.getFormatterInstance(PACKAGE_NAME + ".TemporalAmountFormatter", cl)) != null) {
            FORMAT_LIST.add(formatter);
        }
        if ((formatter = JSON.getFormatterInstance(PACKAGE_NAME + ".ZoneIdFormatter", cl)) != null) {
            FORMAT_LIST.add(formatter);
        }
        Converter converter = null;
        CONVERT_MAP.put(Boolean.TYPE, BooleanConverter.INSTANCE);
        CONVERT_MAP.put(Character.TYPE, CharacterConverter.INSTANCE);
        CONVERT_MAP.put(Byte.TYPE, ByteConverter.INSTANCE);
        CONVERT_MAP.put(Short.TYPE, ShortConverter.INSTANCE);
        CONVERT_MAP.put(Integer.TYPE, IntegerConverter.INSTANCE);
        CONVERT_MAP.put(Long.TYPE, LongConverter.INSTANCE);
        CONVERT_MAP.put(Float.TYPE, FloatConverter.INSTANCE);
        CONVERT_MAP.put(Double.TYPE, DoubleConverter.INSTANCE);
        CONVERT_MAP.put(boolean[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(char[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(byte[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(short[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(int[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(long[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(float[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(double[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(Object[].class, ArrayConverter.INSTANCE);
        CONVERT_MAP.put(Boolean.class, BooleanConverter.INSTANCE);
        CONVERT_MAP.put(Character.class, CharacterConverter.INSTANCE);
        CONVERT_MAP.put(Byte.class, ByteConverter.INSTANCE);
        CONVERT_MAP.put(Short.class, ShortConverter.INSTANCE);
        CONVERT_MAP.put(Integer.class, IntegerConverter.INSTANCE);
        CONVERT_MAP.put(Long.class, LongConverter.INSTANCE);
        CONVERT_MAP.put(Float.class, FloatConverter.INSTANCE);
        CONVERT_MAP.put(Double.class, DoubleConverter.INSTANCE);
        CONVERT_MAP.put(BigInteger.class, BigIntegerConverter.INSTANCE);
        CONVERT_MAP.put(BigDecimal.class, BigDecimalConverter.INSTANCE);
        CONVERT_MAP.put(Number.class, BigDecimalConverter.INSTANCE);
        CONVERT_MAP.put(Pattern.class, PatternConverter.INSTANCE);
        CONVERT_MAP.put(TimeZone.class, TimeZoneConverter.INSTANCE);
        CONVERT_MAP.put(Locale.class, LocaleConverter.INSTANCE);
        CONVERT_MAP.put(File.class, FileConverter.INSTANCE);
        CONVERT_MAP.put(URL.class, URLConverter.INSTANCE);
        CONVERT_MAP.put(URI.class, URIConverter.INSTANCE);
        CONVERT_MAP.put(UUID.class, UUIDConverter.INSTANCE);
        CONVERT_MAP.put(Charset.class, CharsetConverter.INSTANCE);
        CONVERT_MAP.put(Class.class, ClassConverter.INSTANCE);
        CONVERT_MAP.put(Date.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(java.sql.Date.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(Time.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(Timestamp.class, DateConverter.INSTANCE);
        CONVERT_MAP.put(Calendar.class, CalendarConverter.INSTANCE);
        CONVERT_MAP.put(Collection.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(Set.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(List.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(ArrayList.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(SortedSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(LinkedList.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(HashSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(TreeSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(LinkedHashSet.class, CollectionConverter.INSTANCE);
        CONVERT_MAP.put(Map.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(SortedMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(HashMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(IdentityHashMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(TreeMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(LinkedHashMap.class, MapConverter.INSTANCE);
        CONVERT_MAP.put(Properties.class, PropertiesConverter.INSTANCE);
        converter = JSON.getConverterInstance(PACKAGE_NAME + ".DayOfWeekConverter", cl);
        if (converter != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".MonthConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".PathConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        CONVERT_LIST.add(EnumConverter.INSTANCE);
        CONVERT_LIST.add(PropertiesConverter.INSTANCE);
        CONVERT_LIST.add(MapConverter.INSTANCE);
        CONVERT_LIST.add(CollectionConverter.INSTANCE);
        CONVERT_LIST.add(ArrayConverter.INSTANCE);
        CONVERT_LIST.add(DateConverter.INSTANCE);
        CONVERT_LIST.add(CalendarConverter.INSTANCE);
        CONVERT_LIST.add(CalendarConverter.INSTANCE);
        CONVERT_LIST.add(CharSequenceConverter.INSTANCE);
        CONVERT_LIST.add(AppendableConverter.INSTANCE);
        converter = JSON.getConverterInstance(PACKAGE_NAME + ".InetAddressConverter", cl);
        if (converter != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".NullableConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".OptionalIntConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".OptionalLongConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".OptionalDoubleConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".OptionalConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".DurationConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".InstantConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".LocalDateConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".LocalDateTimeConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".LocalTimeConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".MonthDayConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".OffsetDateTimeConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".OffsetTimeConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".PeriodConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".YearConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".YearMonthConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".ZonedDateTimeConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".ZoneIdConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
        if ((converter = JSON.getConverterInstance(PACKAGE_NAME + ".ZoneOffsetConverter", cl)) != null) {
            CONVERT_LIST.add(converter);
        }
    }

    private static class State {
        Object key;
        JSONHint hint;

        private State() {
        }
    }

    public final class Context {
        private final Locale locale;
        private final TimeZone timeZone;
        private final Object contextObject;
        private final int maxDepth;
        private final boolean prettyPrint;
        private final int initialIndent;
        private final String indentText;
        private final boolean suppressNull;
        private final Mode mode;
        private final String numberFormat;
        private final String dateFormat;
        private final NamingStyle propertyStyle;
        private final NamingStyle enumStyle;
        private State[] path;
        private int depth = -1;
        private Map<Class<?>, Object> memberCache;
        private final LocalCache cache;
        JSONHint skipHint;
        int createSizeHint = -1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Context() {
            JSON jSON = JSON.this;
            synchronized (jSON) {
                this.locale = JSON.this.locale;
                this.timeZone = JSON.this.timeZone;
                this.contextObject = JSON.this.contextObject;
                this.maxDepth = JSON.this.maxDepth;
                this.prettyPrint = JSON.this.prettyPrint;
                this.initialIndent = JSON.this.initialIndent;
                this.indentText = JSON.this.indentText;
                this.suppressNull = JSON.this.suppressNull;
                this.mode = JSON.this.mode;
                this.numberFormat = JSON.this.numberFormat;
                this.dateFormat = JSON.this.dateFormat;
                this.propertyStyle = JSON.this.propertyStyle;
                this.enumStyle = JSON.this.enumStyle;
                this.cache = new LocalCache(PACKAGE_NAME + ".Messages", this.locale, this.timeZone);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Context(Context context) {
            Context context2 = context;
            synchronized (context2) {
                this.locale = context.locale;
                this.timeZone = context.timeZone;
                this.contextObject = context.contextObject;
                this.maxDepth = context.maxDepth;
                this.prettyPrint = context.prettyPrint;
                this.initialIndent = context.initialIndent;
                this.indentText = context.indentText;
                this.suppressNull = context.suppressNull;
                this.mode = context.mode;
                this.numberFormat = context.numberFormat;
                this.dateFormat = context.dateFormat;
                this.propertyStyle = context.propertyStyle;
                this.enumStyle = context.enumStyle;
                this.depth = context.depth;
                this.path = new State[context.path.length];
                int max = Math.min(this.path.length, context.depth + 1);
                for (int i = 0; i < max; ++i) {
                    this.path[i] = new State();
                    this.path[i].key = context.path[i].key;
                    this.path[i].hint = context.path[i].hint;
                }
                this.cache = context.cache;
            }
        }

        Context copy() {
            return new Context(this);
        }

        public Locale getLocale() {
            return this.locale;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }

        public boolean isPrettyPrint() {
            return this.prettyPrint;
        }

        public int getInitialIndent() {
            return this.initialIndent;
        }

        public String getIndentText() {
            return this.indentText;
        }

        public boolean isSuppressNull() {
            return this.suppressNull;
        }

        public Mode getMode() {
            return this.mode;
        }

        public NamingStyle getPropertyStyle() {
            return this.propertyStyle;
        }

        public NamingStyle getEnumStyle() {
            return this.enumStyle;
        }

        public LocalCache getLocalCache() {
            return this.cache;
        }

        @Deprecated
        public int getLevel() {
            return this.getDepth();
        }

        public int getDepth() {
            return this.depth;
        }

        public Object getKey() {
            return this.path[this.depth].key;
        }

        public Object getKey(int depth) {
            if (depth < 0) {
                depth = this.getDepth() + depth;
            }
            if (depth <= this.depth) {
                return this.path[depth].key;
            }
            return null;
        }

        public JSONHint getHint() {
            return this.path[this.depth].hint;
        }

        public <T> T convert(Object key, Object value, Class<? extends T> c) throws Exception {
            this.enter(key, this.getHint());
            T o = JSON.this.postparse(this, value, c, c);
            this.exit();
            return (c.isPrimitive() ? (Class)PRIMITIVE_MAP.get(c) : c).cast(o);
        }

        public Object convert(Object key, Object value, Type t) throws Exception {
            Class c = ClassUtil.getRawType(t);
            this.enter(key, this.getHint());
            Object o = JSON.this.postparse(this, value, c, t);
            this.exit();
            return (c.isPrimitive() ? (Class)PRIMITIVE_MAP.get(c) : c).cast(o);
        }

        void enter(Object key, JSONHint hint) {
            State state;
            ++this.depth;
            if (this.path == null) {
                this.path = new State[4];
            }
            if (this.depth >= this.path.length) {
                State[] newPath = new State[this.depth * 2];
                System.arraycopy(this.path, 0, newPath, 0, this.path.length);
                this.path = newPath;
            }
            if ((state = this.path[this.depth]) == null) {
                this.path[this.depth] = state = new State();
            }
            state.key = key;
            state.hint = hint;
        }

        void enter(Object key) {
            this.enter(key, this.getHint());
        }

        void exit() {
            --this.depth;
        }

        void appendIndent(OutputSource out, int depth) throws IOException {
            int indent = this.getInitialIndent() + depth;
            for (int j = 0; j < indent; ++j) {
                out.append(this.getIndentText());
            }
        }

        NumberFormat getNumberFormat() {
            JSONHint hint = this.getHint();
            String format = hint != null && hint.format().length() > 0 ? hint.format() : this.numberFormat;
            return format != null ? this.getLocalCache().getNumberFormat(format) : null;
        }

        DateFormat getDateFormat() {
            String format = this.getDateFormatText();
            return format != null ? this.getLocalCache().getDateFormat(format) : null;
        }

        String getDateFormatText() {
            JSONHint hint = this.getHint();
            return hint != null && hint.format().length() > 0 ? hint.format() : this.dateFormat;
        }

        Type getResolvedType(Type ptype, Class<?> pcls, Type type) {
            return this.getLocalCache().getResolvedType(ptype, pcls, type);
        }

        public String toString() {
            StringBuilderOutputSource sb = new StringBuilderOutputSource(new StringBuilder());
            int length = Math.min(this.depth + 1, this.path.length);
            for (int i = 0; i < length; ++i) {
                State state = this.path[i];
                if (state.key == null) {
                    sb.append("[null]");
                    continue;
                }
                if (state.key instanceof Number) {
                    sb.append('[');
                    sb.append(state.key.toString());
                    sb.append(']');
                    continue;
                }
                if (state.key instanceof Character) {
                    sb.append(state.key.toString());
                    continue;
                }
                String str = state.key.toString();
                boolean escape = false;
                for (int j = 0; j < str.length(); ++j) {
                    if (j == 0) {
                        escape = !Character.isJavaIdentifierStart(str.charAt(j));
                    } else {
                        boolean bl = escape = !Character.isJavaIdentifierPart(str.charAt(j));
                    }
                    if (escape) break;
                }
                if (escape) {
                    sb.append('[');
                    try {
                        StringFormatter.serialize(this, str, sb);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sb.append(']');
                    continue;
                }
                sb.append('.');
                sb.append(str);
            }
            return sb.toString();
        }

        final Object preformatInternal(Type type, Object value) {
            try {
                if (value == null) {
                    return JSON.this.preformatNull(this, type);
                }
                if (this.getDepth() > this.getMaxDepth()) {
                    return null;
                }
                if (JSON.this.getClass() != JSON.class) {
                    return JSON.this.preformat(this, value);
                }
                return value;
            }
            catch (Exception e) {
                throw new JSONException(this.getMessage("json.format.ConversionError", value, this), 150, e);
            }
        }

        final Formatter formatInternal(Object src, OutputSource ap) throws IOException {
            Object o = src;
            Formatter f = null;
            if (o == null) {
                f = NullFormatter.INSTANCE;
            } else {
                JSONHint hint = this.getHint();
                if (hint != null) {
                    if (hint.serialized() && hint != this.skipHint) {
                        f = PlainFormatter.INSTANCE;
                    } else if (String.class.equals(hint.type())) {
                        f = StringFormatter.INSTANCE;
                    } else if (Serializable.class.equals(hint.type())) {
                        f = SerializableFormatter.INSTANCE;
                    }
                }
            }
            if (f == null) {
                f = (Formatter)FORMAT_MAP.get(o.getClass());
            }
            if (f == null && this.memberCache != null) {
                f = (Formatter)this.memberCache.get(o.getClass());
            }
            if (f == null) {
                for (Formatter formatter : FORMAT_LIST) {
                    if (!formatter.accept(o)) continue;
                    f = formatter;
                    break;
                }
                if (f == null) {
                    f = new ObjectFormatter(o.getClass());
                }
                if (this.memberCache == null) {
                    this.memberCache = new HashMap();
                }
                this.memberCache.put(o.getClass(), f);
            }
            try {
                f.format(this, src, o, ap);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JSONException(this.getMessage("json.format.ConversionError", src instanceof CharSequence ? "\"" + src + "\"" : src, this), 100, e);
            }
            return f;
        }

        <T> T postparseInternal(Object value, Class<? extends T> cls, Type type) throws Exception {
            return JSON.this.postparse(this, value, cls, type);
        }

        <T> T convertInternal(Object value, Class<?> cls, Type type) throws JSONException {
            T result = null;
            try {
                this.enter(ROOT, null);
                result = (T)JSON.this.postparse(this, value, cls, type);
                this.exit();
            }
            catch (Exception e) {
                String text;
                if (value instanceof CharSequence) {
                    text = "\"" + value + "\"";
                } else {
                    try {
                        text = value.toString();
                    }
                    catch (Exception e2) {
                        text = value.getClass().toString();
                    }
                }
                throw new JSONException(this.getMessage("json.parse.ConversionError", text, type, this), 250, e);
            }
            return result;
        }

        <T> T createInternal(Class<? extends T> c) throws Exception {
            return JSON.this.create(this, c);
        }

        boolean ignoreInternal(Class<?> target, Member member) {
            return JSON.this.ignore(this, target, member);
        }

        String normalizeInternal(String name) {
            return JSON.this.normalize(name);
        }

        String getMessage(String id, Object ... args) {
            return this.cache.getMessage(id, args);
        }
    }

    public static enum Mode {
        TRADITIONAL,
        STRICT,
        SCRIPT;

    }
}

