<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_brotli - Serveur HTTP Apache Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur HTTP Apache Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_brotli</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_brotli.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_brotli.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Compression du contenu via Brotli avant sa livraison au client</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>brotli_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_brotli.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.26 du serveur HTTP Apache</td></tr></table>
<h3>Sommaire</h3>

    <p>Le module <code class="module"><a href="../mod/mod_brotli.html">mod_brotli</a></code> fournit le filtre en sortie
    <code>BROTLI_COMPRESS</code> qui permet de compresser un contenu avant sa
    livraison au client en utilisant la bibliothque brotli. Ce filtre est
    implment en utilisant la bibliothque Brotli que l'on peut trouver  <a href="https://github.com/google/brotli">https://github.com/google/brotli</a>.</p>
</div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#recommended">Exemples de configurations</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#enable">Activation de la compression</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxies">Interaction avec les serveurs mandataires</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#precompressed">Servir un contenu pr-compress</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#brotlialteretag">BrotliAlterETag</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#brotlicompressionmaxinputblock">BrotliCompressionMaxInputBlock</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#brotlicompressionquality">BrotliCompressionQuality</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#brotlicompressionwindow">BrotliCompressionWindow</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#brotlifilternote">BrotliFilterNote</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mod_brotli">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mod_brotli">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="../filter.html">Filters</a></li>
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="recommended" id="recommended">Exemples de configurations</a></h2>
    <div class="warning"><h3>Compression et TLS</h3>
        <p>Certaines applications web sont vulnrables  une attaque de type vol
	d'informations lorsqu'une connexion TLS transmet des donnes
	compresses. Pour plus d'informations, tudiez en dtail la famille
	d'attaques "BREACH".</p>
    </div>
    <p>Voici une configuration simple qui compresse des types de contenus
    courants au format texte :</p>

    <div class="example"><h3>Compression de certains types seulement</h3><pre class="prettyprint lang-config">AddOutputFilterByType BROTLI_COMPRESS text/html text/plain text/xml text/css text/javascript application/javascript</pre>
</div>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="enable" id="enable">Activation de la compression</a></h2>
    <div class="warning"><h3>Compression et TLS</h3>
        <p>Certaines applications web sont vulnrables  une attaque de type vol
	d'informations lorsqu'une connexion TLS transmet des donnes
	compresses. Pour plus d'informations, tudiez en dtail la famille
	d'attaques "BREACH".</p>
    </div>

    <h3><a name="output" id="output">Compression en sortie</a></h3>
      <p>La compression est implmente par le <a href="../filter.html">filtre</a> <code>BROTLI_COMPRESS</code>. La
      directive suivante active la compression pour les documents correspondant
      au conteneur dans lequel elle est place :</p>

      <pre class="prettyprint lang-config">SetOutputFilter BROTLI_COMPRESS
SetEnvIfNoCase Request_URI \.(?:gif|jpe?g|png)$ no-brotli</pre>


      <p>Si vous voulez restreindre la compression  certains types MIME
      particuliers, vous pouvez utiliser la directive <code class="directive"><a href="../mod/mod_filter.html#addoutputfilterbytype">AddOutputFilterByType</a></code>. Dans l'exemple
      suivant, l'activation de la compression est restreinte aux fichiers html
      de la documentation d'Apache :</p>

      <pre class="prettyprint lang-config">&lt;Directory "/your-server-root/manual"&gt;
    AddOutputFilterByType BROTLI_COMPRESS text/html
&lt;/Directory&gt;</pre>


      <div class="note"><h3>Note</h3>
        Le filtre <code>BROTLI_COMPRESS</code> est toujours insr aprs les
	filtres RESOURCE comme PHP ou SSI. Il n'affecte jamais les sous-requtes
	internes.
      </div>
      <div class="note"><h3>Note</h3>
        Dfinie via <code class="directive"><a href="../mod/mod_env.html#setenv">SetEnv</a></code>, la variable
	d'environnement <code>no-brotli</code> permet de dsactiver la
	compression brotli pour une requte particulire, et ceci mme si elle
	est supporte par le client.
      </div>

    

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="proxies" id="proxies">Interaction avec les serveurs mandataires</a></h2>

    <p>Le module <code class="module"><a href="../mod/mod_brotli.html">mod_brotli</a></code> envoie un en-tte de rponse HTTP
    <code>Vary:Accept-Encoding</code> pour indiquer aux mandataires qu'une
    rponse mise en cache ne doit tre envoye qu'aux clients qui envoient
    l'en-tte de requte <code>Accept-Encoding</code> appropri. Ceci permet
    d'viter d'envoyer du contenu compress  un client qui ne sera pas en
    mesure de le dcompresser.</p>

    <p>Si vous utilisez des exclusions spciales dpendant, par exemple, de
    l'en-tte <code>User-Agent</code>, vous devez faire un ajout manuel 
    l'en-tte <code>Vary</code> afin d'informer les mandataires des restrictions
    supplmentaires. Par exemple, dans une configuration typique o l'addition
    du filtre <code>BROTLI_COMPRESS</code> dpend de l'en-tte <code>User-Agent</code>,
    vous devez ajouter :</p>

    <pre class="prettyprint lang-config">Header append Vary User-Agent</pre>


    <p>Si votre dcision d'utiliser la compression ou non dpend d'autres
    informations que le contenu d'en-ttes de requtes (par exemple la version
    HTTP), vous devez affecter la valeur <code>*</code>  l'en-tte
    <code>Vary</code>. Ceci permet d'viter que des mandataires qui le
    supportent n'effectuent une mise en cache intgrale.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">Header set Vary *</pre>
</div>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="precompressed" id="precompressed">Servir un contenu pr-compress</a></h2>

    <p>comme <code class="module"><a href="../mod/mod_brotli.html">mod_brotli</a></code> compresse systmatiquement un contenu
    pour chaque requte le concernant, il est possible d'obtenir un gain en
    performance en pr-compressant le contenu et en disant  mod_brotli de le
    servir sans le recompresser. Pour cela, vous pouvez utiliser une
    configuration du style :</p>

    <pre class="prettyprint lang-config">&lt;IfModule mod_headers.c&gt;
    # Sert des fichiers CSS compresss par brotli, s'ils existent
    # et si le client supporte brotli.
    RewriteCond "%{HTTP:Accept-encoding}" "br"
    RewriteCond "%{REQUEST_FILENAME}\.br" "-s"
    RewriteRule "^(.*)\.css"              "$1\.css\.br" [QSA]

    # Sert des fichiers JS compresss par brotli, s'ils existent
    # et si le client supporte brotli.
    RewriteCond "%{HTTP:Accept-encoding}" "br"
    RewriteCond "%{REQUEST_FILENAME}\.br" "-s"
    RewriteRule "^(.*)\.js"               "$1\.js\.br" [QSA]


    # Sert des types de contenu corrects, et vite la double compression.
    RewriteRule "\.css\.gz$" "-" [T=text/css,E=no-brotli:1]
    RewriteRule "\.js\.gz$"  "-" [T=text/javascript,E=no-brotli:1]


    &lt;FilesMatch "(\.js\.br|\.css\.br)$"&gt;
      # Sert un type d'encodage correct.
      Header append Content-Encoding br

      # Force les mandataires  mettre en cache sparment les fichiers css/js
      # compresss ou non par brotli.
      Header append Vary Accept-Encoding
    &lt;/FilesMatch&gt;
&lt;/IfModule&gt;</pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="brotlialteretag" id="brotlialteretag">Directive</a> <a name="BrotliAlterETag" id="BrotliAlterETag">BrotliAlterETag</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Comment l'en-tte de rponse ETag doit tre modifi au cours de la
compression</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>BrotliAlterETag AddSuffix|NoChange|Remove</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>BrotliAlterETag AddSuffix</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_brotli</td></tr>
</table>
    <p>La directive <code class="directive">BrotliAlterETag</code> permet d'indiquer
    comment l'en-tte ETag doit tre modifi lorsqu'une rponse est compresse.</p>
    <dl>
    <dt>AddSuffix</dt>
    <dd><p>Ajoute la mthode de compression  la fin de l'en-tte ETag, ce qui
    implique que les reprsentations compresses et non compresses possderont
    des en-ttes ETag uniques. C'tait le comportement par dfaut depuis la
    version 2.4.0 avec un autre module de compression dynamique,
    mod-deflate. Ce paramtre permet d'viter l'envoi de messages
    "HTTP Not Modified" (304) en rponse aux requtes conditionnelles pour des
    contenus compresss.</p></dd>
    <dt>NoChange</dt>
    <dd><p>Ne modifie pas l'en-tte ETag d'une rponse compresse. C'tait le
    comportement par dfaut depuis la version 2.4.0 avec un autre module de
    compression dynamique, mod-deflate. Ce paramtre ne respecte pas la
    proprit HTTP/1.1 selon laquelle toutes les reprsentations d'une mme
    ressource ont des en-ttes ETag uniques.</p></dd>
    <dt>Remove</dt>
    <dd><p>Supprime l'en-tte ETag des rponses compresses, ce qui rend
    impossibles certaines requtes conditionnelles, mais vite les inconvnients
    des options prcdentes.</p></dd>
    </dl>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="brotlicompressionmaxinputblock" id="brotlicompressionmaxinputblock">Directive</a> <a name="BrotliCompressionMaxInputBlock" id="BrotliCompressionMaxInputBlock">BrotliCompressionMaxInputBlock</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Taille maximale du bloc de donnes en entre</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>BrotliCompressionMaxInputBlock <var>value</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>(automatic)</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_brotli</td></tr>
</table>
    <p>La directive <code class="directive">BrotliCompressionMaxInputBlock</code> permet
    de spcifier la taille maximale du bloc de donnes en entre entre 16 et 24,
    sachant que plus cette taille sera grande, plus grande sera la quantit de
    mmoire consomme.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="brotlicompressionquality" id="brotlicompressionquality">Directive</a> <a name="BrotliCompressionQuality" id="BrotliCompressionQuality">BrotliCompressionQuality</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Qualit de la compression</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>BrotliCompressionQuality <var>value</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>BrotliCompressionQuality 5</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_brotli</td></tr>
</table>
    <p>La directive <code class="directive">BrotliCompressionQuality</code> permet de
    spcifier la qualit de la compression (une valeur entre 0 et
    11). Les valeurs les plus hautes correspondent  une compression de
    meilleure qualit mais plus lente.
  </p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="brotlicompressionwindow" id="brotlicompressionwindow">Directive</a> <a name="BrotliCompressionWindow" id="BrotliCompressionWindow">BrotliCompressionWindow</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Taille de la fentre de compression glissante brotli</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>BrotliCompressionWindow <var>value</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>BrotliCompressionWindow 18</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_brotli</td></tr>
</table>
    <p>La directive <code class="directive">BrotliCompressionWindow</code> permet de
    spcifier la taille de la fentre de compression glissante brotli (une
    valeur comprise entre 10 et 24). Une taille de fentre plus grande peut
    amliorer la qualit de la compression mais consomme d'avantage de mmoire.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="brotlifilternote" id="brotlifilternote">Directive</a> <a name="BrotliFilterNote" id="BrotliFilterNote">BrotliFilterNote</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Enregistre le taux de compression dans une note  des fins de
journalisation</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>BrotliFilterNote [<var>type</var>] <var>notename</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration globale, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_brotli</td></tr>
</table>
    <p>La directive <code class="directive">BrotliFilterNote</code> permet d'indiquer
    qu'une note  propos du taux de compression doit tre attache  la
    requte. L'argument <var>notename</var> permet de spcifier le nom de la
    note. Vous pouvez utiliser cette note  des fins de statistiques en ajoutant
    l'information correspondante  votre <a href="../logs.html#accesslog">access
    log</a>.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">BrotliFilterNote ratio

LogFormat '"%r" %b (%{ratio}n) "%{User-agent}i"' brotli
CustomLog "logs/brotli_log" brotli</pre>
</div>

    <p>Si vous souhaitez que l'information enregistre dans vos journaux soit
    plus pertinente, vous pouvez renseigner l'argument optionnel <var>type</var>
    afin de spcifier le type de donnes  enregistrer dans la note 
    journaliser. L'argument <var>type</var> accepte les valeurs suivantes :</p>

    <dl>
      <dt><code>Input</code></dt>
      <dd>Enregistre dans la note le nombre d'octets contenus dans le flux
      d'entre du filtre.</dd>

      <dt><code>Output</code></dt>
      <dd>Enregistre dans la note le nombre d'octets contenus dans le flux
      de sortie du filtre.</dd>

      <dt><code>Ratio</code></dt>
      <dd>Enregistre dans la note le taux de compression (<code>output/input *
      100</code>). Il s'agit de l'option par dfaut si l'argument
      <var>type</var> est omis.</dd>
    </dl>

    <p>Vous pouvez alors configurer vos journaux de la manire suivante :</p>

    <div class="example"><h3>Journalisation spcifique</h3><pre class="prettyprint lang-config">BrotliFilterNote Input instream
BrotliFilterNote Output outstream
BrotliFilterNote Ratio ratio

LogFormat '"%r" %{outstream}n/%{instream}n (%{ratio}n%%)' brotli
CustomLog "logs/brotli_log" brotli</pre>
</div>

<h3>Voir aussi</h3>
<ul>
<li><code class="module"><a href="../mod/mod_log_config.html">mod_log_config</a></code></li>
</ul>
</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_brotli.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_brotli.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_brotli.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2018 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>