// Coordinates: 49.545673, -123.309144
// Map Width: 50km

RMS.LoadLibrary("rmgen");
RMS.LoadLibrary("rmgen2");

InitMap();

log("Initializing tile classes...");
setBiome(2);
initMapSettings();
initTileClasses(["island"]);

log("Initializing environment...");

setSunColor(0.733, 0.746, 0.574);
setSkySet("stratus");

setWaterTint(0.388, 0.650, 0.661);
setWaterColor(0.388, 0.650, 0.661);
setWaterWaviness(8);
setWaterMurkiness(0.8);
setWaterType("lake");

setTerrainAmbientColor(0.349, 0.514, 0.671);

setSunRotation(PI * -0.5);
setSunElevation(PI/9);

setFogFactor(0.08);
setFogThickness(0);
setFogColor(0.75, 0.75, 0.75);

setPPEffect("hdr");
setPPContrast(0.67);
setPPSaturation(0.42);
setPPBloom(0.23);

log("Initializing biome...");

g_Terrains.mainTerrain = "snow rough";
g_Terrains.forestFloor1 = "snow grass 2";
g_Terrains.forestFloor2 = "snow 50";
g_Terrains.tier1Terrain = "snow grass 100";
g_Terrains.tier2Terrain = "snow rocks";
g_Terrains.tier3Terrain = "snow rough";
g_Terrains.tier4Terrain = "snow grass 75";
g_Terrains.roadWild = "path a";
g_Terrains.road = "road_flat";
g_Gaia.mainHuntableAnimal = "gaia/fauna_muskox";
g_Gaia.secondaryHuntableAnimal =  "gaia/fauna_wolf_snow";
g_Gaia.fish = "gaia/fauna_fish";
g_Gaia.tree1 = "gaia/flora_tree_pine_w";
g_Gaia.tree2 = "gaia/flora_tree_pine_w";
g_Gaia.tree3 = "gaia/flora_tree_pine_w";
g_Gaia.tree4 = "gaia/flora_tree_dead";
g_Gaia.tree5 = "gaia/flora_tree_pine_w";
g_Gaia.metalSmall = "gaia/geology_metal_temperate";
g_Gaia.fruitBush = "gaia/flora_bush_berry";
g_Decoratives.grass = "actor|props/flora/grass_soft_dry_tuft_a.xml";
g_Decoratives.grassShort = "actor|props/flora/grass_field_bloom_short.xml";
g_Decoratives.rockLarge = "actor|props/special/eyecandy/standing_stones.xml";
g_Decoratives.rockMedium = "actor|geology/stone_granite_small.xml";
g_Decoratives.bushMedium = "actor|props/flora/bush_medit_me_dry.xml";
g_Decoratives.bushSmall = "actor|props/flora/bush_medit_sm_dry.xml";

initBiome();
RMS.SetProgress(5);

log("Resetting terrain...");
resetTerrain(g_Terrains.mainTerrain, g_TileClasses.land, 1);
RMS.SetProgress(10);

log("Copying heightmap...");
var scale = paintHeightmap(getHeightMap(), getTileMap(), getTilePallet(), (tile, x, y) => {
	if (tile.indexOf("polar_ice_cracked") >= 0)
		addToClass(x, y, g_TileClasses.island);
});

log("Paint tile classes...");
paintTileClassBasedOnHeight(-100, -1, 3, g_TileClasses.water);
RMS.SetProgress(40);

log("Placing players...");
//Coordinate system of the heightmap
var singleBases = [
	[40, 85],
	[230, 40],
	[280, 110],
	[240, 180],
	[50, 170],
	[100, 240],
	[280, 280],
	[170, 280]
];
var strongholdBases = [
	[90, 210],
	[255, 120]
];
randomPlayerPlacementAt(singleBases, strongholdBases, scale, 0.06);
RMS.SetProgress(50);

log("Render mainland...");
addElements([
	{
		"func": addLayeredPatches,
		"avoid": [
			g_TileClasses.bluff, 2,
			g_TileClasses.dirt, 5,
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3,
			g_TileClasses.island, 2
		],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["many"]
	},
	{
		"func": addDecoration,
		"avoid": [
			g_TileClasses.bluff, 2,
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3,
			g_TileClasses.island, 2
		],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["few"]
	}
]);

addElements(shuffleArray([
	{
		"func": addMetal,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 20,
			g_TileClasses.metal, 30,
			g_TileClasses.water, 3,
			g_TileClasses.island, 2
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["normal", "many"]
	},
	{
		"func": addSmallMetal,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 20,
			g_TileClasses.metal, 30,
			g_TileClasses.water, 3,
			g_TileClasses.island, 2
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["normal", "many"]
	},
	{
		"func": addStone,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 30,
			g_TileClasses.metal, 20,
			g_TileClasses.water, 3,
			g_TileClasses.island, 2
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["normal", "many"]
	},
	{
		"func": addForests,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 15,
			g_TileClasses.metal, 3,
			g_TileClasses.mountain, 5,
			g_TileClasses.plateau, 5,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 3,
			g_TileClasses.water, 2,
			g_TileClasses.island, 2
		],
		"sizes": ["normal"],
		"mixes": ["similar"],
		"amounts": ["tons"]
	}
]));

addElements(shuffleArray([
	{
		"func": addBerries,
		"avoid": [
			g_TileClasses.berries, 30,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 5,
			g_TileClasses.metal, 10,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 10,
			g_TileClasses.water, 3,
			g_TileClasses.island, 2
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["normal", "many"]
	},
	{
		"func": addAnimals,
		"avoid": [
			g_TileClasses.animals, 20,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 2,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 1,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 3,
			g_TileClasses.island, 2
		],
		"sizes": ["normal"],
		"mixes": ["similar"],
		"amounts": ["many"]
	},
	{
		"func": addFish,
		"avoid": [
			g_TileClasses.fish, 12,
			g_TileClasses.player, 8
		],
		"stay": [g_TileClasses.water, 4],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["many"]
	},
	{
		"func": addStragglerTrees,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 7,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 1,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 12,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 5,
			g_TileClasses.island, 2
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["many"]
	}
]));
RMS.SetProgress(65);

g_Gaia.mainHuntableAnimal = "gaia/fauna_bear";
g_Gaia.secondaryHuntableAnimal =  "gaia/fauna_wolf_snow";

log("Render islands...");
addElements(shuffleArray([
	{
		"func": addMetal,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 10,
			g_TileClasses.metal, 10,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.island, 2],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["many"]
	},
	{
		"func": addSmallMetal,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 10,
			g_TileClasses.metal, 10,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.island, 2],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["tons"]
	},
	{
		"func": addStone,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 10,
			g_TileClasses.metal, 10,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.island, 2],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["many"]
	}
]));

addElements(shuffleArray([
	{
		"func": addAnimals,
		"avoid": [
			g_TileClasses.animals, 20,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 2,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 1,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 3
		],
		"stay": [g_TileClasses.island, 2],
		"sizes": ["huge"],
		"mixes": ["similar"],
		"amounts": ["many"]
	},
	{
		"func": addForests,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 8,
			g_TileClasses.metal, 3,
			g_TileClasses.mountain, 5,
			g_TileClasses.plateau, 5,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 3,
			g_TileClasses.water, 2
		],
		"stay": [g_TileClasses.island, 2],
		"sizes": ["small"],
		"mixes": ["similar"],
		"amounts": ["tons"]
	},
	{
		"func": addStragglerTrees,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.bluff, 5,
			g_TileClasses.forest, 5,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 1,
			g_TileClasses.plateau, 2,
			g_TileClasses.player, 12,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 5
		],
		"stay": [g_TileClasses.island, 2],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["tons"]
	}
]));
RMS.SetProgress(80);

log("Placing whale...");
g_Gaia.fish = "gaia/fauna_whale_fin";
addElements([
	{
		"func": addFish,
		"avoid": [
			g_TileClasses.fish, 2,
		],
		"stay": [g_TileClasses.water, 7],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["few"]
	}
]);
RMS.SetProgress(90);

ExportMap();

// MapTiles - Do Not Edit Below This Line
function getHeightMap()
{
	return [-7.88,-8.37,-8.75,-9.03,-9.38,-9.55,-9.80,-9.93,-10,-10,-10,-10,-10,-9.92,-9.75,-9.55,-9.28,-9.03,-8.64,-8.25,-7.78,-7.29,-6.75,-6.27,-5.75,-5.38,-5.18,-5,-5.25,-5.75,-6.39,-7,-7.50,-8,-8.38,-8.75,-9,-9.25,-9.43,-9.62,-9.67,-9.75,-9.75,-9.66,-9.62,-9.42,-9.25,-9.13,-8.92,-8.75,-8.63,-8.39,-8.11,-7.75,-7.51,-7.29,-7.11,-6.88,-6.64,-6.38,-6.04,-5.63,-5,-4.39,-3.88,-3.41,-3.30,-3.25,-3.15,-3,-2.63,-1.38,-0.76,-0.92,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3.99,3.98,4,4,4,4,4.97,5,5.98,6,6.98,6.98,6.99,7,7,7.02,7.02,7.95,7.98,7.99,7.99,7.99,8,8,8,9,9,9,9,10,10,10,10,10,10,10,9,9,8,7,7,7,7,7,8,10,11,11,11,11,11,11,11,11,12,12,12,13,14,13.98,14.01,14.89,15.10,15.87,15.87,15.96,15.99,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16.02,16.98,16.99,17,17,16,16,15,15,15,15,15,15,15,15,15,15,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.96,14.76,14.20,14,13.83,13.12,12.12,11.11,9.88,8.01,7,6,4,3,1,-0.60,-1.77,-2.38,-2.75,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-2.78,-1.25,0.70,1.11,2,3,4,4.90,5.22,6.01,6.99,8.02,9.23,10.61,12.12,13.75,15.45,16.99,18.21,18.59,18.73,19.12,19.77,20.65,21.51,21.62,20.22,19.90,19,18,17,16,15,14,14,13,13,13,13,14,15,16,18,18,18,17,16,15,15,13.87,13,12.76,13.10,13.77,14.97,16.49,16.62,16.74,17.09,17.75,18.62,19.59,19.98,20.63,21.73,21.76,21.99,22.87,23.87,24.86,24.12,24,24,24,24,24,24,23.95,-8.38,-8.79,-9.16,-9.50,-9.78,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.75,-9.50,-9.13,-8.75,-8.26,-7.76,-7.25,-6.55,-6.14,-5.88,-5.89,-5.88,-5.88,-6.37,-6.89,-7.50,-8,-8.50,-8.88,-9.16,-9.50,-9.75,-9.89,-10,-10,-10,-10,-10,-10,-9.90,-9.75,-9.50,-9.25,-9,-8.78,-8.53,-8.25,-7.98,-7.75,-7.55,-7.38,-7.24,-7.03,-6.86,-6.53,-6.14,-5.63,-4.90,-4.38,-3.88,-3.63,-3.63,-3.63,-3.05,-2.50,-1.01,0.62,0.75,0.96,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3.12,3.77,3.96,3.99,4,4.02,4.37,4.74,5.25,5.73,6.25,6.75,6.88,7,7,7.10,7.10,7.87,7.87,7.98,7.99,7.99,8,8.02,8.01,8,8.99,8.99,9.12,9.24,9.75,9.99,10,10,10,10,9.75,9.24,8.87,8.10,7,7,7,7,7,8,9,11,11,11,10,10,10,10,10,11,11,11,12,12.98,13.01,13.89,14.87,14.97,15.12,15.84,15.84,15.95,15.96,15.96,15.96,15.96,15.97,15.98,16,16,16,15.98,15.97,15.96,15.97,15.98,16.08,16.02,16.98,16.99,16,16,15,15,15,15,15,15,15,15,15,15,15,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.98,14.89,14.72,14.50,14.27,13.98,13.45,12.65,11.65,10.23,8.88,7.07,6,5,3,1.22,-0.37,-1.38,-2,-2.43,-2.75,-2.90,-3,-3,-3,-3,-3,-3,-3,-2.75,-1.30,-0.68,0.87,1.99,2.99,3.96,4.73,5.34,6.07,6.99,8,9.13,10.49,11.98,13.52,15.08,16.48,17.39,17.99,18.37,18.87,19.60,20.37,20.96,20.88,20.48,19.75,18.99,18,17.11,16.99,15,14.87,13.98,13.25,12.33,12.36,12.77,13.37,14.65,15.99,16.87,17.22,16.87,16.10,16,14.89,13.87,13.12,12.38,12.48,12.82,13.47,14.37,15.26,15.83,16.13,16.51,17.14,17.95,18.62,19.25,19.76,20.38,20.87,21.35,22.12,23,23.82,24,24,24.12,24.14,24.13,24.12,24.12,23.87,-8.75,-9.15,-9.51,-9.88,-10,-10,-10,-10,-10,-10,-11,-11,-10,-10,-10,-10,-10,-9.79,-9.50,-9.13,-8.68,-8.17,-7.63,-7,-6.67,-6.63,-6.63,-6.63,-6.54,-6.88,-7.38,-7.88,-8.40,-8.88,-9.25,-9.63,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.90,-9.63,-9.25,-9.03,-8.75,-8.41,-8.23,-8,-7.85,-7.68,-7.62,-7.50,-7.38,-7.13,-6.85,-6.40,-5.93,-5.38,-4.88,-5.50,-5.62,-4.78,-3.50,-1.63,-0.52,0.50,0.84,0.95,1,1,1,1,1,1,1,1,0.99,1.14,1.75,1.98,2,2,2.12,2.27,2.65,2.86,2.97,3,3.08,3.34,3.63,3.88,3.99,4,4.14,4.40,4.85,5.25,5.75,6.22,6.60,6.87,7,7.12,7.12,7.86,7.87,7.97,7.99,8,8,8.11,8.09,8.89,8.83,8.87,9.12,9.36,9.62,9.87,10.10,10.24,10.27,10.33,10.26,10.08,9.75,9.22,8.64,7.76,7.12,7,7,7,8,9,10,10,10,9,9,9,9,10,10,10,10,11,11.96,12.08,13.11,13.97,14.84,14.86,15.20,15.76,15.75,15.75,15.75,15.75,15.75,15.84,15.90,15.95,15.95,15.95,15.95,15.85,15.82,15.84,15.86,15.87,15.89,15.95,15.98,16,15,15,15,15,15,15,15,15,15,15,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,14.98,14.95,14.87,14.75,14.61,14.36,13.87,13.21,12.39,10.77,9.25,7.76,6.07,5,4,1.64,0.12,-0.73,-1.43,-2.03,-2.50,-2.76,-2.90,-3,-3,-3,-3,-3,-2.98,-2.38,-1.42,-0.18,0.87,1.96,2.87,3.75,4.51,5.25,6.07,6.98,7.97,9,10.25,11.63,13.12,14.52,15.74,16.62,17.26,17.87,18.51,19.34,20.12,20.70,20.82,20.48,19.85,19.01,18.14,17.34,16.61,15.75,14.95,14.52,13.10,12.25,12.02,12.37,13.23,14.33,15.62,16.50,16.75,16.34,15.75,15.09,14.27,13.37,12.50,12.13,12.14,12.37,12.95,13.62,14.25,14.82,15.25,15.73,16.26,16.99,17.64,18.27,18.83,19.46,20.01,20.75,21.46,22.33,23.20,23.75,24.11,24.23,24.75,24.76,24.82,24.83,23.85,-9.13,-9.50,-9.89,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.80,-9.42,-9,-8.51,-8,-7.63,-7.41,-7.25,-7.25,-7.25,-7.25,-7.38,-7.78,-8.38,-8.88,-9.38,-9.68,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.63,-9.27,-8.98,-8.66,-8.41,-8.25,-8.13,-8.02,-8,-8,-7.91,-7.78,-7.60,-7.26,-6.99,-6.75,-6.91,-7.66,-7.68,-6.14,-4.02,-1.88,0.37,0.59,0.87,0.96,1,1,1,1,1,1,1,1,1.12,1.37,1.74,1.96,2,2.01,2.24,2.50,2.83,2.87,2.98,3.07,3.20,3.40,3.71,3.87,3.99,4.07,4.25,4.58,4.96,5.36,5.76,6.21,6.58,6.85,7.02,7.25,7.61,7.75,7.95,7.99,8,8.12,8.12,8.12,8.82,8.86,9,9.12,9.37,9.62,9.87,10.12,10.34,10.50,10.62,10.63,10.58,10.37,10.12,9.64,9.07,8.37,7.65,7.25,7.12,7.25,7.75,8.14,8.88,9,9,9,9,9,9,9,9,9,10,10.01,11,11.87,12.87,13.13,13.86,14.20,14.75,15.09,15.24,15.24,15.25,15.25,15.25,15.74,15.74,15.75,15.75,15.75,15.75,15.76,15.21,15.15,15.13,15.12,15.10,15.08,15,15,15,15,15,15,15,16,15,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15.02,15.08,15.09,15.07,15,15,15,15,15.01,15,14.75,14.34,13.63,12.58,11.25,9.77,8.37,7.09,5.98,5,2.12,0.97,0.02,-0.75,-1.50,-2.11,-2.50,-2.75,-2.93,-3,-3,-3,-3,-2.92,-2.36,-1.25,0,1.08,1.88,2.74,3.51,4.33,5.12,6,6.96,7.87,8.86,9.98,11.25,12.62,13.88,15,15.86,16.61,17.35,18.15,19.12,20,20.73,20.95,20.62,19.96,19.12,18.25,17.36,16.50,15.72,14.85,13.85,12.85,11.96,11.62,11.96,12.74,13.87,15.13,16.25,16.37,15.96,15.26,14.52,13.72,12.87,12.24,11.95,11.95,12.12,12.50,12.97,13.40,13.86,14.34,14.75,15.37,16.07,16.75,17.46,18.09,18.75,19.50,20.32,21.14,22,22.86,23.73,24.11,24.73,25.08,25.25,25.75,24.89,24.82,-9.40,-9.76,-10,-10,-11,-11,-11,-11,-11,-11,-12,-12,-11,-11,-11,-11,-11,-10,-10,-9.88,-9.37,-8.88,-8.28,-8.25,-8.04,-7.89,-7.88,-7.91,-8,-7.89,-8.38,-8.88,-9.38,-9.87,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.76,-9.49,-9.13,-8.88,-8.63,-8.48,-8.38,-8.35,-8.37,-8.39,-8.43,-8.40,-8.27,-8.10,-7.88,-7.88,-8.28,-9.88,-9.03,-6.93,-4.37,-1.88,0.11,0.73,0.87,0.97,1,1,1,1,0.99,0.99,1,1.12,1.35,1.61,1.84,1.96,2,2.07,2.27,2.61,2.77,2.90,3,3.12,3.32,3.51,3.75,3.89,4,4.12,4.37,4.71,5.08,5.46,5.85,6.24,6.58,6.86,7.09,7.35,7.61,7.84,7.97,8,8.12,8.15,8.82,8.74,8.87,9.10,9.25,9.40,9.62,9.87,10.11,10.36,10.61,10.83,10.84,10.84,10.76,10.65,10.48,10.12,9.62,8.96,8.25,7.75,7.49,7.49,7.45,8,8.24,8.22,8.11,8,8,8,8,8,8,9,9,9.90,10.09,11.12,12.10,12.82,13.21,13.75,14.20,14.75,14.74,14.74,14.72,14.72,14.87,15.09,15.25,15.25,15.25,15.25,15.25,15.09,14.87,14.76,14.82,14.84,14.87,14.87,14.95,15,15,15,15,15,15,15,16,16,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15.08,15.14,15.25,15.23,15.12,15.07,15,15.02,15.12,15.23,15.25,15.11,14.73,14.01,12.98,11.73,10.37,9.01,7.76,6.62,5.84,3.50,1.98,0.95,0.01,-0.80,-1.51,-2.04,-2.43,-2.79,-3,-3,-3,-3,-2.98,-2.35,-1.13,0.23,1.14,1.83,2.60,3.37,4.14,5.02,6,6.90,7.83,8.71,9.72,10.87,12.12,13.25,14.25,15.12,16,16.88,17.87,18.97,19.98,20.75,21,20.73,20,19.20,18.25,17.33,16.37,15.48,14.50,13.50,12.50,11.50,11.21,11.39,12.20,13.25,14.48,15.58,15.99,15.62,14.87,14.01,13.15,12.39,11.89,11.72,11.71,11.88,12.15,12.40,12.87,13.23,13.62,14,14.58,15.23,16,16.77,17.58,18.37,19.23,20.11,21,21.89,22.71,23.36,23.99,24.70,25.71,25.71,24.73,24.74,24.75,-9.75,-10,-10,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9.75,-9.14,-8.88,-8.78,-8.75,-8.75,-8.63,-8.50,-8.63,-8.50,-8.80,-9.30,-9.80,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.87,-9.60,-9.27,-9.01,-8.79,-8.63,-8.55,-8.54,-8.63,-8.75,-8.86,-8.88,-8.86,-8.73,-8.55,-8.54,-8.91,-9.89,-8.88,-6.67,-4.13,-1.88,-0.25,0.62,0.88,0.98,1,1,1,0.99,0.99,1,1,1.25,1.51,1.82,1.90,1.98,2,2.08,2.34,2.61,2.82,2.97,3.09,3.23,3.39,3.62,3.84,3.96,4.02,4.24,4.50,4.86,5.22,5.58,5.90,6.25,6.60,6.87,7.11,7.36,7.62,7.87,8.01,8.15,8.24,8.75,8.82,8.98,9.12,9.34,9.50,9.71,9.87,10.12,10.36,10.60,10.75,10.87,10.95,10.97,10.95,10.87,10.75,10.50,10.12,9.57,9,8.50,8.13,7.95,7.89,7.96,8.01,8,8,8,7.99,8,8,8,8,8,8.96,9.09,9.87,10.85,11.83,12.21,12.75,13.23,13.75,13.87,13.99,14,14.10,14.22,14.27,14.70,14.71,14.72,14.72,14.73,14.73,14.75,14.23,14.23,14.21,14.15,14.12,14.12,14.89,14.99,15,15,16,15,15,15,16,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15.02,15.15,15.34,15.45,15.37,15.25,15.12,15.01,15.08,15.14,15.32,15.39,15.35,15.01,14.37,13.39,12.25,10.95,9.62,8.37,7.20,5.87,4.49,3.07,1.95,0.97,0.01,-0.77,-1.48,-2,-2.51,-2.87,-3,-3,-3,-3,-2.30,-1.25,0.02,0.87,1.71,2.47,3.24,4.09,5,6,6.97,7.87,8.75,9.62,10.64,11.73,12.73,13.65,14.62,15.58,16.59,17.70,18.85,19.88,20.74,21,20.71,20,19.13,18.22,17.23,16.24,15.25,14.25,13.25,12.24,11.34,10.75,10.87,11.51,12.62,13.77,14.88,15.50,15.25,14.50,13.50,12.62,11.95,11.50,11.40,11.57,11.76,12.08,12.34,12.64,13,13.25,13.59,14.07,14.74,15.50,16.37,17.25,18.13,19.08,20,20.90,21.84,22.58,23.12,23.60,23.98,24.08,23.87,23.27,23.26,22.73,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.64,-9.50,-9.43,-9.38,-9.30,-9.25,-9.13,-9.13,-9,-9.25,-9.67,-10,-10,-11,-11,-11,-11,-11,-11,-12,-11,-11,-11,-11,-11,-11,-11,-10,-9.89,-9.68,-9.40,-9.16,-8.98,-8.79,-8.75,-8.75,-8.78,-8.88,-9,-9.11,-9.18,-9.11,-8.91,-8.77,-8.85,-8.88,-7.75,-5.75,-3.64,-1.64,-0.17,0.62,0.88,0.98,1,1,0.99,0.99,0.99,1,1.13,1.37,1.70,1.89,1.98,2,2,2.10,2.37,2.62,2.84,3,3.13,3.34,3.51,3.75,3.87,4,4.14,4.37,4.71,5,5.37,5.72,6.01,6.36,6.62,6.87,7.12,7.37,7.64,7.90,8.14,8.37,8.62,8.77,9,9.14,9.37,9.58,9.75,9.95,10.12,10.36,10.59,10.75,10.87,10.97,11.01,11.10,11.12,11.10,11,10.85,10.57,10.13,9.71,9.27,8.98,8.74,8.57,8.45,8.37,8.37,8.36,8.35,8.25,8.11,8,8,8,8,8.07,8.87,9.12,10.13,11.15,11.86,12.23,12.75,13.09,13.25,13.26,13.27,13.27,13.71,13.99,14.15,14.25,14.25,14.25,14.25,14.25,14.20,14.12,14,14.07,14.13,14.13,14.12,14.87,15.02,15,16,16,15,15,15,16,16,16,16,15,15,15,15,15,15,15,15,15,15,15,15,15,15.10,15.25,15.48,15.60,15.50,15.35,15.15,15.08,15.08,15.14,15.35,15.49,15.51,15.32,14.75,13.86,12.75,11.50,10.23,8.95,7.64,6.50,5.25,4.15,3.02,2,1,0.10,-0.75,-1.49,-2.13,-2.63,-2.98,-3,-3,-3,-2.43,-1.60,-0.37,0.70,1.57,2.37,3.14,4.01,4.98,5.98,7,8.02,9,9.87,10.72,11.57,12.45,13.37,14.34,15.36,16.45,17.61,18.75,19.85,20.60,20.87,20.59,19.88,19.02,18.09,17.08,16.07,15.08,14.09,13.09,12.11,11.25,10.64,10.46,11,12,13.21,14.25,14.90,14.74,13.96,12.98,12.10,11.49,11.20,11.22,11.48,11.87,12.22,12.58,12.87,13.23,13.50,13.74,14.07,14.62,15.37,16.25,17.13,18.09,19,19.96,20.85,21.70,22.37,22.83,23,23.10,22.76,22.35,22.13,21.99,21.71,-10,-10,-11,-11,-12,-12,-12,-12,-12,-13,-13,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-9.88,-9.78,-9.63,-9.50,-9.38,-9.52,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9.86,-9.53,-9.27,-9.05,-8.89,-8.85,-8.85,-8.88,-9,-9.12,-9.23,-9.24,-9.24,-9,-8.66,-8.38,-7.75,-6.50,-4.88,-3.04,-1.38,-0.13,0.62,0.95,0.98,1,0.99,0.99,0.99,1,1.07,1.25,1.52,1.77,1.95,1.99,2,2,2.20,2.38,2.62,2.87,3.07,3.25,3.46,3.63,3.85,3.99,4.12,4.33,4.60,4.87,5.22,5.52,5.87,6.14,6.46,6.72,6.95,7.14,7.45,7.75,8.07,8.34,8.60,8.75,8.97,9.14,9.37,9.59,9.76,9.99,10.14,10.37,10.59,10.74,10.86,10.98,11.09,11.15,11.25,11.32,11.34,11.27,11.20,11,10.72,10.37,10.08,9.75,9.50,9.32,9.12,9.01,9,9.01,9,9,8.87,8.87,8,8,8,8.08,8.11,9.12,10,10.86,11.75,11.98,12.25,12.72,12.71,12.72,12.77,13,13.33,13.64,13.71,13.72,13.72,13.72,13.72,13.72,13.76,13.87,13.98,14,14.21,14.82,14.86,14.87,15.08,15.97,15.99,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15.12,15.32,15.50,15.63,15.60,15.45,15.25,15.12,15.10,15.13,15.33,15.50,15.61,15.49,15.01,14.25,13.24,12.07,10.77,9.57,8.37,7.25,6.25,5.32,4.27,3.22,2.11,1.01,0.01,-0.89,-1.66,-2.30,-2.85,-3,-3,-2.99,-2.52,-1.75,-0.53,0.50,1.46,2.27,3.12,3.98,4.87,5.87,7,8.22,9.33,10.20,10.90,11.63,12.47,13.37,14.36,15.38,16.50,17.64,18.82,19.76,20.46,20.65,20.37,19.72,18.86,17.87,16.87,15.85,14.86,13.88,12.96,12,11.20,10.59,10.32,10.62,11.50,12.62,13.64,14.26,14,13.24,12.37,11.52,11.08,10.89,11.11,11.51,12.10,12.62,13.10,13.50,13.82,14.01,14.24,14.50,14.99,15.62,16.37,17.25,18.13,19.07,19.90,20.74,21.47,21.97,22.24,22.32,22.01,21.70,21.34,21.02,20.97,20.64,-10,-11,-11,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.65,-9.77,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9.64,-9.38,-9.13,-8.98,-8.88,-8.88,-8.91,-9.01,-9.13,-9.17,-9.17,-9.03,-8.85,-8.38,-7.78,-6.91,-5.55,-4.05,-2.52,-1.12,0,0.62,0.95,0.98,0.98,0.98,0.99,1,1.02,1.15,1.37,1.63,1.87,1.98,2,2,2.09,2.26,2.50,2.73,2.95,3.12,3.37,3.59,3.75,3.95,4.10,4.25,4.49,4.75,5.08,5.37,5.73,6,6.32,6.58,6.77,7,7.25,7.51,7.87,8.22,8.50,8.75,8.95,9.12,9.37,9.59,9.76,9.99,10.14,10.37,10.59,10.73,10.85,10.98,11.10,11.23,11.36,11.48,11.57,11.61,11.62,11.52,11.40,11.25,11,10.76,10.57,10.34,10.12,9.96,9.85,9.82,9.85,9.96,9.84,9.62,9.20,8.87,8,8.02,8,8.12,9,9.87,10.75,11.20,11.75,11.99,12.21,12.27,12.32,12.33,12.64,12.99,13.21,13.33,13.33,13.33,13.33,13.32,13.27,13.26,13.74,13.95,14,14.22,14.82,14.90,14.95,15.02,15.02,15,15,14.98,14.97,14.97,14.97,14.98,15,15,15,15,15,15,15,15,15,15,15,15.08,15.02,15,15.01,15.12,15.32,15.50,15.62,15.62,15.51,15.37,15.23,15.12,15.13,15.25,15.47,15.59,15.52,15.25,14.62,13.73,12.63,11.50,10.34,9.23,8.25,7.39,6.52,5.61,4.47,3.25,2,0.77,-0.25,-1.13,-1.88,-2.50,-2.89,-3,-2.92,-2.61,-1.74,-0.62,0.45,1.37,2.24,3.01,3.84,4.65,5.63,6.86,8.13,9.45,10.36,11.12,11.86,12.65,13.62,14.62,15.73,16.83,17.88,18.95,19.75,20.32,20.39,20.10,19.45,18.59,17.61,16.60,15.59,14.61,13.63,12.76,11.87,11.11,10.45,10.12,10.12,11,12.12,13.08,13.49,13.20,12.51,11.75,11.08,10.73,10.75,11.12,11.74,12.48,13.21,13.87,14.36,14.63,14.77,14.88,15.12,15.50,16.08,16.75,17.57,18.37,19.15,19.95,20.60,21.10,21.35,21.37,21.25,20.98,20.64,20.33,20.01,19.96,19.62,-10,-11,-11,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.88,-10,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.75,-9.40,-9.15,-9,-8.88,-8.87,-8.89,-9,-9.10,-9.12,-9.02,-8.87,-8.53,-7.98,-7.25,-6.18,-4.80,-3.38,-2,-0.76,0.12,0.70,0.95,0.97,0.98,0.99,1,1.02,1.12,1.27,1.50,1.75,1.88,2,2.01,2.10,2.25,2.38,2.61,2.82,3,3.25,3.49,3.71,3.87,4.07,4.24,4.39,4.64,4.95,5.25,5.57,5.87,6.15,6.46,6.71,6.88,7.12,7.37,7.65,8,8.37,8.65,8.87,9.12,9.34,9.57,9.75,9.98,10.14,10.37,10.58,10.73,10.86,10.98,11.10,11.24,11.37,11.57,11.72,11.83,11.87,11.90,11.88,11.85,11.74,11.61,11.46,11.26,11.12,10.95,10.75,10.62,10.58,10.60,10.61,10.50,10.14,9.75,9.23,8.88,8.02,8.10,8.12,9.10,9.77,10.23,10.77,11.26,11.73,11.96,12,12.02,12.20,12.37,12.75,12.98,13.07,13.07,13.08,13.11,13.21,13.27,13.27,13.74,13.95,14,14.23,14.76,14.83,14.86,14.76,14.74,14.71,14.64,14.63,14.65,14.74,14.85,14.90,14.98,15,15,15,15,15,15,15,15.12,15.15,15.33,15.25,15.15,15.09,15.08,15.12,15.25,15.40,15.57,15.62,15.60,15.49,15.34,15.21,15.12,15.22,15.37,15.50,15.59,15.39,14.98,14.25,13.37,12.37,11.33,10.33,9.47,8.64,7.86,6.87,5.74,4.45,2.98,1.61,0.46,-0.50,-1.28,-2,-2.63,-3,-2.91,-2.50,-1.54,-0.55,0.39,1.33,2.12,2.87,3.62,4.38,5.37,6.51,7.86,9.12,10.20,11.11,11.98,12.90,13.98,15.09,16.15,17.25,18.25,19.12,19.77,20.12,20.12,19.75,19.11,18.25,17.26,16.25,15.25,14.27,13.37,12.50,11.65,10.87,10.24,9.87,9.95,10.62,11.64,12.58,12.86,12.50,11.88,11.25,10.70,10.49,10.63,11.20,11.99,12.87,13.82,14.59,15.33,15.51,15.62,15.64,15.85,16.20,16.70,17.32,18,18.73,19.37,19.97,20.46,20.70,20.61,20.36,20.09,19.77,19.50,19.25,19.01,18.95,18.62,-10,-11,-12,-12,-12,-13,-13,-13,-13,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.75,-9.43,-9.16,-9,-8.88,-8.86,-8.88,-8.91,-8.99,-9,-8.87,-8.61,-8.23,-7.53,-6.75,-5.52,-4.13,-2.68,-1.37,-0.38,0.37,0.73,0.87,0.95,0.98,1,1.02,1.12,1.25,1.46,1.62,1.84,1.96,2,2.12,2.23,2.37,2.57,2.74,2.89,3.12,3.36,3.60,3.82,4,4.21,4.37,4.61,4.85,5.12,5.38,5.71,6,6.27,6.59,6.83,7,7.25,7.50,7.83,8.14,8.50,8.82,9.01,9.25,9.50,9.75,9.96,10.14,10.37,10.58,10.75,10.85,10.98,11.10,11.24,11.38,11.59,11.75,11.95,12.09,12.20,12.25,12.25,12.24,12.20,12.12,12.01,11.95,11.83,11.65,11.50,11.37,11.26,11.25,11.25,11.02,10.73,10.27,9.86,9.22,8.89,8.87,8.86,9.14,9.75,10.12,10.27,10.99,11.62,11.75,11.87,11.97,12.09,12.35,12.63,12.89,13.01,13.07,13.09,13.15,13.35,13.65,13.70,13.77,13.88,13.97,14.02,14.14,14.25,14.26,14.25,14.25,14.24,14.25,14.25,14.25,14.37,14.60,14.76,14.90,14.98,15,15,15,15,15.02,15.12,15.14,15.77,15.65,15.61,15.40,15.25,15.15,15.22,15.25,15.34,15.40,15.50,15.57,15.50,15.37,15.24,15.12,15.15,15.27,15.45,15.51,15.50,15.25,14.75,14.12,13.33,12.46,11.58,10.74,9.95,9.20,8.25,7,5.51,3.90,2.48,1.25,0.23,-0.67,-1.50,-2.27,-3,-2.89,-2.36,-1.42,-0.50,0.39,1.25,1.99,2.64,3.37,4.12,5.01,6.12,7.37,8.62,9.75,10.86,11.90,13.07,14.25,15.46,16.60,17.62,18.52,19.25,19.75,19.95,19.77,19.37,18.73,17.87,16.96,15.96,14.96,13.99,13.08,12.15,11.36,10.61,9.99,9.62,9.72,10.37,11.33,12.13,12.34,11.96,11.37,10.77,10.38,10.33,10.62,11.25,12.12,13.21,14.25,15.22,16.07,16.26,16.34,16.38,16.61,16.90,17.37,17.95,18.58,19.13,19.62,19.99,20.15,20.12,19.75,19.37,18.95,18.62,18.37,18.12,18,17.95,17.62,-11,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-13,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.75,-9.41,-9.14,-8.93,-8.85,-8.78,-8.79,-8.86,-8.88,-8.79,-8.65,-8.35,-7.88,-7.13,-6.18,-4.90,-3.50,-2.04,-0.88,0.11,0.58,0.76,0.88,0.97,1,1.08,1.12,1.25,1.39,1.61,1.75,1.88,2,2.12,2.24,2.37,2.51,2.71,2.87,3.01,3.24,3.47,3.70,3.89,4.12,4.35,4.52,4.75,5,5.25,5.57,5.85,6.12,6.39,6.70,6.90,7.12,7.37,7.63,7.98,8.27,8.62,8.89,9.15,9.45,9.65,9.89,10.12,10.37,10.58,10.75,10.86,10.98,11.10,11.25,11.38,11.60,11.75,11.98,12.13,12.33,12.46,12.50,12.58,12.59,12.59,12.57,12.50,12.49,12.38,12.32,12.15,12.07,11.99,11.95,11.84,11.61,11.25,10.84,10.50,9.84,9.15,9.12,9.12,9.21,9.74,10,10.27,10.71,11.13,11.52,11.71,11.84,12,12.25,12.62,12.90,13.12,13.14,13.22,13.32,13.61,13.70,13.74,13.71,13.72,13.74,13.73,13.75,13.75,13.76,13.77,13.76,13.75,13.75,13.75,13.75,13.97,14.24,14.57,14.76,14.90,14.98,15,15,15.02,15.15,15.24,15.76,15.96,16.12,16.07,15.86,15.62,15.49,15.37,15.32,15.25,15.26,15.37,15.40,15.40,15.35,15.21,15.12,15.12,15.25,15.38,15.59,15.64,15.61,15.34,14.87,14.25,13.50,12.75,11.90,11.11,10.24,9.27,8.08,6.37,4.75,3.25,2,0.87,-0.10,-1.03,-2.01,-3,-2.90,-2.24,-1.38,-0.50,0.35,1.11,1.76,2.45,3.12,3.87,4.75,5.74,6.85,8,9.25,10.47,11.71,12.99,14.26,15.52,16.73,17.75,18.62,19.25,19.58,19.61,19.37,18.95,18.33,17.51,16.62,15.63,14.65,13.73,12.76,11.84,11,10.27,9.72,9.46,9.62,10.13,10.97,11.70,11.82,11.37,10.87,10.37,10.12,10.20,10.57,11.23,12.12,13.23,14.32,15.25,16.12,16.63,16.88,17.11,17.34,17.62,18,18.50,19.09,19.60,19.87,19.90,19.76,19.45,18.90,18.37,17.87,17.49,17.25,17,17,16.95,16.61,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-10,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.73,-9.38,-9.11,-8.88,-8.75,-8.73,-8.75,-8.75,-8.75,-8.66,-8.48,-8.12,-7.55,-6.79,-5.67,-4.29,-2.88,-1.50,-0.38,0.37,0.65,0.86,0.90,1,1.10,1.20,1.32,1.46,1.61,1.75,1.87,2,2.11,2.24,2.37,2.51,2.70,2.84,2.99,3.13,3.36,3.58,3.76,4,4.25,4.48,4.71,4.90,5.15,5.45,5.72,6,6.25,6.51,6.76,7.01,7.25,7.51,7.82,8.12,8.40,8.75,9,9.32,9.59,9.85,10.10,10.35,10.52,10.74,10.87,10.98,11.11,11.25,11.38,11.60,11.75,11.98,12.14,12.37,12.50,12.64,12.75,12.84,12.87,12.88,12.90,12.95,12.89,12.87,12.83,12.75,12.64,12.62,12.58,12.47,12.12,11.74,11.27,10.84,10.26,9.75,9.12,9.20,9.74,9.83,10,10.15,10.39,10.82,11.12,11.37,11.60,11.83,12.12,12.50,12.87,13.13,13.25,13.25,13.36,13.48,13.58,13.62,13.32,13.25,13.37,13.37,13.38,13.38,13.38,13.38,13.37,13.36,13.33,13.33,13.37,13.50,13.84,14.23,14.57,14.77,14.90,14.98,15,15.12,15.36,15.63,15.98,16.34,16.52,16.58,16.38,16.20,15.96,15.71,15.47,15.26,15.21,15.22,15.25,15.25,15.21,15.12,15.10,15.12,15.21,15.37,15.58,15.75,15.87,15.77,15.50,15.07,14.45,13.72,12.87,11.90,10.97,10.07,8.50,6.87,5.36,3.87,2.62,1.49,0.37,-0.75,-1.93,-3,-2.90,-2.16,-1.40,-0.62,0.20,0.88,1.57,2.22,2.87,3.62,4.46,5.36,6.37,7.50,8.73,10,11.35,12.70,14,15.27,16.49,17.50,18.37,18.88,19.12,19.11,18.86,18.46,17.87,17.20,16.36,15.46,14.50,13.58,12.62,11.62,10.75,10.01,9.50,9.34,9.47,9.87,10.50,11.08,11.12,10.75,10.33,9.97,9.85,9.99,10.37,11.01,11.87,12.88,13.97,14.97,15.84,16.72,17.25,17.62,17.89,18.13,18.40,18.87,19.40,19.95,20.09,19.75,19.26,18.73,18.10,17.47,16.87,16.49,16.25,16.07,16.02,15.98,15.59,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-11,-11,-12,-12,-12,-12,-12,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.63,-9.29,-9,-8.79,-8.67,-8.64,-8.65,-8.68,-8.68,-8.54,-8.29,-7.88,-7.29,-6.28,-5.03,-3.67,-2.26,-1,-0.14,0.48,0.77,0.89,0.99,1.09,1.21,1.35,1.50,1.62,1.75,1.87,2,2.11,2.24,2.37,2.57,2.70,2.83,2.97,3.11,3.25,3.48,3.70,3.88,4.12,4.37,4.61,4.85,5.09,5.35,5.61,5.87,6.12,6.39,6.64,6.88,7.13,7.39,7.70,7.97,8.25,8.57,8.87,9.12,9.45,9.73,10,10.25,10.50,10.71,10.86,10.97,11.11,11.25,11.38,11.60,11.75,11.98,12.14,12.37,12.52,12.72,12.85,12.95,13,13.12,13.21,13.25,13.26,13.26,13.25,13.25,13.22,13.15,13.12,13.07,12.87,12.59,12.14,11.72,11.25,10.75,10.25,9.87,9.75,9.85,9.95,10,10.09,10.25,10.49,10.75,11,11.25,11.50,11.87,12.27,12.72,13,13.12,13.14,13.15,13.23,13.25,13.24,13.13,13.10,13.12,13.12,13.14,13.14,13.14,13.14,13.14,13.12,13.11,13.11,13.12,13.24,13.50,13.89,14.27,14.62,14.85,14.96,15.07,15.24,15.57,15.90,16.34,16.75,17.07,17.14,17.02,16.84,16.50,16.11,15.71,15.37,15.15,15.12,15.12,15.12,15.11,15.08,15.01,15.02,15.12,15.25,15.47,15.72,15.89,16,15.87,15.51,15,14.25,13.37,12.27,11.21,9.97,8.59,7.08,5.62,4.37,3.08,1.88,0.62,-0.66,-1.88,-3,-2.91,-2.27,-1.54,-0.79,-0.04,0.63,1.33,1.99,2.64,3.37,4.14,5,5.98,7.07,8.25,9.52,10.87,12.24,13.51,14.75,15.88,16.89,17.74,18.25,18.48,18.40,18.24,17.88,17.46,16.86,16.12,15.33,14.46,13.57,12.62,11.62,10.75,10,9.48,9.25,9.32,9.60,10,10.35,10.37,10.12,9.75,9.50,9.50,9.72,10.12,10.70,11.39,12.25,13.25,14.34,15.34,16.46,17.26,17.95,18.32,18.33,18.45,18.76,19.33,19.82,19.87,19.37,18.72,17.99,17.25,16.62,16.01,15.65,15.57,15.39,15.40,15.35,14.59,-11,-12,-12,-13,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-11,-11,-12,-12,-12,-12,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.55,-9.24,-8.91,-8.74,-8.63,-8.61,-8.63,-8.63,-8.63,-8.50,-8.13,-7.65,-6.88,-5.75,-4.39,-3.03,-1.68,-0.67,0.11,0.62,0.86,0.96,1.01,1.14,1.34,1.50,1.65,1.83,1.90,2,2.12,2.25,2.38,2.58,2.73,2.83,2.95,3.08,3.23,3.38,3.61,3.83,4,4.25,4.49,4.73,4.97,5.23,5.50,5.75,6.01,6.32,6.58,6.82,7.02,7.27,7.57,7.85,8.12,8.37,8.65,8.98,9.25,9.52,9.85,10.12,10.37,10.62,10.82,10.96,11.10,11.25,11.38,11.59,11.75,11.98,12.14,12.37,12.52,12.72,12.86,12.98,13.09,13.21,13.34,13.46,13.51,13.59,13.60,13.60,13.59,13.58,13.57,13.50,13.45,13.25,12.95,12.52,12.12,11.65,11.23,10.75,10.37,10.12,10,10,10,10.07,10.12,10.25,10.40,10.62,10.87,11.13,11.51,11.98,12.37,12.71,12.86,12.87,12.87,12.88,12.98,13.01,13.08,13.10,13.10,13.10,13.09,13.08,13.07,13.02,13.02,13,13,13,13,13.12,13.37,13.74,14.11,14.46,14.74,14.89,15.09,15.32,15.73,16.20,16.73,17.24,17.62,17.84,17.82,17.52,17.08,16.49,15.90,15.49,15.22,15.12,15.10,15.09,15.02,15,14.99,14.98,15,15.09,15.23,15.39,15.62,15.75,15.75,15.50,15.01,14.26,13.35,12.21,11,9.74,8.38,7.02,5.72,4.39,3.12,1.87,0.62,-0.64,-1.77,-2.63,-2.98,-2.43,-1.76,-1.04,-0.35,0.37,1.09,1.75,2.40,3.12,3.87,4.72,5.62,6.65,7.85,9.11,10.38,11.71,12.90,14.08,15.12,16.09,16.87,17.37,17.62,17.62,17.50,17.26,16.96,16.49,15.87,15.22,14.46,13.62,12.75,11.85,10.88,10.12,9.50,9.23,9.15,9.27,9.51,9.72,9.65,9.49,9.24,9.11,9.12,9.37,9.73,10.21,10.76,11.50,12.37,13.40,14.47,15.62,16.58,17.37,17.87,17.85,17.90,18.23,18.64,19.12,19.25,18.75,18,17.23,16.48,15.85,15.33,15.10,15.15,15.25,15.37,15.34,14.59,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-11,-11,-10,-10,-11,-11,-12,-12,-12,-12,-13,-13,-13,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.88,-9.43,-9.11,-8.78,-8.62,-8.50,-8.50,-8.55,-8.61,-8.54,-8.37,-8,-7.41,-6.42,-5.13,-3.76,-2.40,-1.28,-0.38,0.33,0.71,0.87,0.98,1.11,1.25,1.47,1.63,1.83,1.96,2.07,2.14,2.26,2.45,2.60,2.75,2.87,2.96,3.07,3.20,3.36,3.52,3.75,3.98,4.15,4.37,4.62,4.85,5.09,5.36,5.62,5.89,6.21,6.48,6.73,6.98,7.22,7.47,7.73,8,8.25,8.51,8.77,9.09,9.36,9.62,9.95,10.23,10.49,10.72,10.87,11.07,11.24,11.37,11.59,11.75,11.96,12.12,12.34,12.50,12.65,12.83,12.97,13.11,13.24,13.37,13.50,13.65,13.76,13.84,13.86,13.85,13.84,13.83,13.82,13.76,13.72,13.51,13.24,12.87,12.49,12.12,11.72,11.32,10.87,10.25,10.25,10.12,10.11,10.09,10.10,10.12,10.23,10.37,10.52,10.84,11.15,11.59,11.98,12.25,12.45,12.50,12.58,12.70,12.87,13.01,13.15,13.25,13.25,13.23,13.14,13.11,13.02,13,13,13,13,13,13,13.11,13.33,13.64,14,14.36,14.65,14.87,15.11,15.36,15.87,16.45,17.08,17.75,18.26,18.62,18.52,18.14,17.50,16.77,16.12,15.62,15.37,15.24,15.12,15.10,15.01,15,14.95,14.87,14.86,14.85,14.87,14.95,15,15.12,15.11,14.87,14.48,13.77,12.88,11.84,10.62,9.45,8.23,7,5.75,4.50,3.22,1.90,0.62,-0.63,-1.67,-2.60,-3,-2.63,-2,-1.29,-0.60,0.13,0.87,1.51,2.22,2.88,3.62,4.47,5.37,6.37,7.50,8.71,9.95,11.12,12.26,13.34,14.26,15.13,15.87,16.39,16.71,16.75,16.73,16.59,16.36,16,15.59,15,14.37,13.64,12.85,12,11.07,10.22,9.59,9.21,9.02,9.01,9.12,9.13,9.10,8.90,8.75,8.72,8.75,8.99,9.25,9.62,10.08,10.62,11.37,12.27,13.25,14.25,15.08,15.90,16.52,16.70,16.87,17.20,17.60,18,18.25,17.88,17.20,16.37,15.64,15.10,14.75,14.76,15.12,15.57,15.87,15.90,15.59,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-14,-13,-13,-12,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-13,-13,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.75,-9.30,-8.99,-8.73,-8.52,-8.49,-8.49,-8.51,-8.53,-8.50,-8.25,-7.87,-7.14,-6,-4.63,-3.13,-1.78,-0.85,-0.02,0.50,0.75,0.90,1,1.13,1.36,1.57,1.75,1.90,2.07,2.15,2.33,2.48,2.62,2.76,2.88,3,3.10,3.21,3.35,3.50,3.72,3.90,4.12,4.36,4.52,4.75,4.98,5.22,5.50,5.75,6.08,6.37,6.62,6.87,7.12,7.37,7.62,7.87,8.13,8.39,8.65,8.90,9.15,9.46,9.73,10,10.27,10.57,10.77,11,11.21,11.37,11.52,11.73,11.89,12.11,12.27,12.49,12.63,12.82,12.96,13.10,13.25,13.37,13.57,13.73,13.87,13.97,14,14.07,14.07,14,14,13.98,13.95,13.87,13.75,13.50,13.13,12.82,12.50,12.21,11.86,11.48,11,10.47,10.39,10.26,10.20,10.12,10.12,10.12,10.23,10.37,10.59,10.87,11.22,11.52,11.83,12,12.20,12.37,12.63,12.98,13.25,13.50,13.61,13.61,13.50,13.37,13.25,13.12,13.07,13,13,13,13,13,13.12,13.36,13.65,14,14.33,14.63,14.87,15.12,15.46,16.08,16.70,17.37,18.12,18.75,19.11,19,18.57,17.76,17.02,16.37,15.89,15.62,15.40,15.26,15.15,15.09,15,14.88,14.82,14.65,14.57,14.46,14.37,14.32,14.24,14.10,13.87,13.48,12.87,12.13,11.23,10.14,9.11,8,6.90,5.77,4.60,3.27,1.99,0.71,-0.51,-1.67,-2.49,-3,-2.75,-2.15,-1.50,-0.77,-0.01,0.70,1.36,2,2.70,3.39,4.24,5.12,6.12,7.21,8.35,9.50,10.62,11.63,12.60,13.45,14.23,14.87,15.39,15.73,15.86,15.87,15.76,15.62,15.38,15.09,14.64,14.14,13.51,12.75,12,11.08,10.22,9.52,9.12,8.87,8.75,8.74,8.70,8.60,8.48,8.37,8.36,8.39,8.58,8.75,9,9.34,9.75,10.33,11.02,11.83,12.58,13.32,14.07,14.64,15.12,15.48,15.85,16.25,16.64,16.97,16.75,16.20,15.50,14.84,14.40,14.37,14.73,15.33,16.07,16.59,16.76,16.59,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-14,-13,-13,-12,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.92,-9.52,-9.13,-8.79,-8.55,-8.41,-8.38,-8.38,-8.41,-8.49,-8.38,-8.12,-7.63,-7,-5.62,-4.03,-2.53,-1.38,-0.38,0.25,0.62,0.86,0.97,1.02,1.24,1.45,1.62,1.86,2,2.14,2.33,2.49,2.63,2.83,2.97,3.08,3.12,3.25,3.37,3.50,3.71,3.88,4.12,4.34,4.50,4.72,4.87,5.12,5.36,5.62,5.90,6.23,6.50,6.77,7.07,7.32,7.57,7.82,8.07,8.33,8.58,8.82,9.02,9.27,9.52,9.82,10.09,10.37,10.62,10.87,11.12,11.37,11.50,11.70,11.87,12.02,12.25,12.45,12.62,12.76,12.95,13.09,13.24,13.37,13.57,13.74,13.88,14.02,14.14,14.25,14.25,14.25,14.22,14.13,14.11,14.07,14,13.87,13.70,13.38,13.12,12.89,12.65,12.37,12,11.59,11.13,10.82,10.59,10.38,10.27,10.23,10.21,10.22,10.27,10.46,10.64,10.95,11.22,11.50,11.75,12.07,12.39,12.87,13.35,13.75,14.01,14.13,14.12,13.98,13.75,13.50,13.27,13.12,13.07,13,13,13,13.02,13.22,13.46,13.75,14.02,14.36,14.70,14.96,15.25,15.62,16.27,16.98,17.62,18.35,18.89,19.25,19.13,18.72,18,17.33,16.65,16.34,16,15.75,15.50,15.35,15.14,15,14.87,14.71,14.50,14.25,14,13.75,13.51,13.27,13.01,12.72,12.32,11.77,11.15,10.40,9.60,8.70,7.75,6.86,5.85,4.65,3.37,2.08,0.75,-0.43,-1.50,-2.25,-2.76,-2.86,-2.30,-1.65,-0.91,-0.15,0.52,1.21,1.83,2.48,3.20,4,4.87,5.87,6.90,8,9.09,10.11,11,11.87,12.62,13.27,13.89,14.39,14.75,14.88,14.95,14.88,14.77,14.62,14.37,14.07,13.62,13.10,12.37,11.72,10.85,10.01,9.37,8.95,8.62,8.48,8.37,8.25,8.20,8.10,8,8,8.08,8.14,8.26,8.46,8.62,8.89,9.33,9.87,10.45,10.90,11.52,12.24,12.87,13.47,13.96,14.37,14.84,15.25,15.50,15.49,15.11,14.62,14.12,13.99,14.25,14.87,15.64,16.58,17.26,17.65,17.59,-11,-12,-12,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.74,-9.36,-9,-8.66,-8.43,-8.35,-8.27,-8.28,-8.29,-8.27,-8.24,-7.88,-7.39,-6.50,-5.13,-3.50,-2,-0.91,-0.02,0.49,0.75,0.89,1,1.12,1.33,1.50,1.74,1.90,2.12,2.26,2.47,2.62,2.84,3,3.12,3.25,3.35,3.46,3.59,3.74,3.89,4.12,4.33,4.50,4.72,4.87,5.07,5.25,5.50,5.77,6.10,6.37,6.65,6.97,7.23,7.48,7.73,7.98,8.24,8.49,8.73,8.96,9.14,9.38,9.62,9.87,10.13,10.45,10.74,11,11.27,11.50,11.63,11.83,11.99,12.14,12.37,12.57,12.74,12.87,13.02,13.22,13.37,13.51,13.72,13.87,14.08,14.24,14.37,14.46,14.48,14.47,14.39,14.36,14.25,14.15,14.09,13.99,13.85,13.62,13.46,13.27,13.12,12.88,12.57,12.13,11.73,11.33,11,10.75,10.59,10.46,10.37,10.35,10.37,10.47,10.62,10.84,11.10,11.38,11.75,12.15,12.70,13.26,13.87,14.37,14.73,14.86,14.75,14.50,14.21,13.86,13.51,13.25,13.12,13,13,13.07,13.20,13.39,13.71,13.97,14.23,14.50,14.84,15.12,15.50,15.99,16.64,17.27,17.89,18.49,18.96,19.21,19.13,18.84,18.27,17.71,17.24,16.82,16.48,16.13,15.86,15.58,15.32,15.08,14.84,14.58,14.25,13.95,13.58,13.15,12.75,12.37,11.99,11.60,11.14,10.70,10.12,9.52,8.87,8.15,7.39,6.62,5.73,4.62,3.37,2.12,0.90,-0.25,-1.17,-1.89,-2.43,-2.76,-2.38,-1.78,-1.02,-0.26,0.40,1.02,1.62,2.25,2.97,3.75,4.62,5.61,6.62,7.62,8.62,9.52,10.37,11.12,11.77,12.40,13,13.48,13.77,13.98,14,13.98,13.87,13.74,13.50,13.23,12.85,12.37,11.75,11.12,10.37,9.70,9.11,8.63,8.36,8.12,8,7.88,7.84,7.75,7.74,7.74,7.75,7.83,7.87,7.99,8.10,8.25,8.50,8.87,9.33,9.59,10.08,10.72,11.38,12,12.57,13.01,13.48,13.86,14.12,14.20,14.07,13.84,13.62,13.82,14.33,15.12,16.08,17.11,18.01,18.58,18.59,-11,-12,-12,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9.88,-9.51,-9.15,-8.85,-8.53,-8.36,-8.25,-8.16,-8.14,-8.13,-8.04,-7.99,-7.55,-7.02,-6.12,-4.54,-2.92,-1.60,-0.50,0.25,0.62,0.85,0.98,1.08,1.22,1.39,1.62,1.85,2.01,2.24,2.39,2.62,2.82,3,3.15,3.34,3.46,3.57,3.65,3.82,3.98,4.12,4.34,4.50,4.72,4.87,5.02,5.23,5.45,5.70,5.98,6.25,6.57,6.86,7.12,7.37,7.62,7.87,8.12,8.37,8.62,8.86,9.08,9.26,9.50,9.75,9.99,10.25,10.50,10.84,11.13,11.40,11.62,11.75,11.88,12.08,12.25,12.46,12.62,12.83,12.99,13.13,13.33,13.50,13.64,13.85,14,14.20,14.37,14.50,14.62,14.63,14.62,14.61,14.52,14.48,14.35,14.20,14.07,13.96,13.84,13.72,13.62,13.51,13.37,13.10,12.65,12.25,11.83,11.47,11.20,10.98,10.82,10.64,10.60,10.59,10.62,10.75,10.96,11.24,11.61,12.02,12.59,13.21,13.87,14.51,15.10,15.47,15.62,15.46,15.12,14.70,14.25,13.86,13.50,13.24,13.10,13.09,13.15,13.40,13.75,14.12,14.36,14.59,14.85,15.14,15.50,15.89,16.46,17.12,17.72,18.25,18.74,19.12,19.33,19.34,19.11,18.71,18.23,17.77,17.37,17,16.62,16.25,15.87,15.49,15.12,14.75,14.37,14,13.57,13.10,12.58,12.01,11.50,11.01,10.60,10.13,9.70,9.22,8.74,8.22,7.63,7,6.25,5.45,4.48,3.37,2.25,1.14,0.11,-0.75,-1.50,-2.13,-2.67,-2.62,-1.88,-1.13,-0.38,0.33,0.88,1.48,2.02,2.71,3.45,4.25,5.22,6.15,7.13,8.08,8.88,9.65,10.37,11,11.61,12.12,12.59,12.87,13,13.02,13,12.87,12.74,12.50,12.25,11.87,11.46,10.96,10.38,9.76,9.21,8.70,8.26,8,7.76,7.62,7.58,7.50,7.50,7.50,7.50,7.57,7.61,7.62,7.70,7.75,7.86,8.01,8.34,8.64,8.75,9.15,9.72,10.39,10.99,11.50,11.98,12.36,12.64,12.88,13.07,13.12,13.21,13.38,13.90,14.62,15.50,16.50,17.58,18.61,19.59,19.61,-11,-11,-12,-13,-13,-13,-14,-14,-14,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-13,-13,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-9.68,-9.38,-9,-8.64,-8.38,-8.23,-8.13,-8.03,-8,-7.90,-7.78,-7.61,-7.13,-6.54,-5.43,-3.92,-2.39,-1.13,-0.13,0.45,0.74,0.88,1,1.12,1.33,1.51,1.75,1.97,2.14,2.37,2.58,2.75,2.99,3.15,3.37,3.50,3.64,3.77,3.89,4.07,4.22,4.37,4.57,4.74,4.87,5.07,5.24,5.38,5.62,5.87,6.12,6.40,6.73,7,7.25,7.51,7.76,8,8.25,8.50,8.75,8.97,9.15,9.38,9.62,9.87,10.10,10.36,10.62,10.88,11.20,11.45,11.62,11.82,11.97,12.12,12.27,12.50,12.71,12.87,13.02,13.24,13.39,13.60,13.75,13.90,14.10,14.26,14.48,14.62,14.75,14.77,14.77,14.75,14.73,14.63,14.50,14.34,14.12,14,13.98,13.95,13.88,13.87,13.75,13.58,13.14,12.72,12.32,11.97,11.65,11.45,11.25,11.08,10.97,10.89,10.96,11.09,11.32,11.62,12.08,12.60,13.20,13.86,14.58,15.25,15.77,16.20,16.35,16.10,15.64,15.20,14.71,14.24,13.77,13.46,13.24,13.20,13.34,13.70,14.14,14.62,14.88,15.12,15.37,15.65,16.01,16.49,17.01,17.62,18.15,18.65,19.11,19.45,19.62,19.63,19.50,19.23,18.82,18.37,17.97,17.52,17.12,16.63,16.14,15.62,15.12,14.62,14.12,13.61,13.08,12.50,11.90,11.34,10.75,10.25,9.82,9.37,8.95,8.50,8.10,7.72,7.25,6.72,6,5.25,4.37,3.47,2.47,1.48,0.57,-0.29,-1.10,-1.79,-2.60,-2.78,-1.93,-1.15,-0.42,0.21,0.75,1.25,1.77,2.37,3.08,3.84,4.70,5.61,6.50,7.37,8.12,8.87,9.60,10.24,10.83,11.34,11.73,11.98,12.09,12.08,11.99,11.85,11.64,11.46,11.21,10.87,10.50,10.07,9.60,9.09,8.61,8.20,7.86,7.61,7.39,7.27,7.25,7.27,7.35,7.37,7.47,7.50,7.60,7.62,7.64,7.74,7.83,8,8.26,8.62,8.74,9.12,9.57,10.12,10.50,10.96,11.34,11.61,11.82,11.99,12.12,12.37,12.74,13.37,14.12,15.01,16,17,18.09,18.96,19.60,19.62,-10,-11,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.87,-9.55,-9.25,-8.88,-8.60,-8.35,-8.13,-8,-7.92,-7.86,-7.67,-7.49,-7.13,-6.51,-5.89,-4.63,-3.25,-1.80,-0.63,0.15,0.62,0.84,0.98,1.10,1.25,1.46,1.64,1.87,2.10,2.32,2.50,2.75,2.96,3.14,3.37,3.57,3.74,3.87,4.01,4.14,4.32,4.47,4.62,4.75,4.95,5.10,5.25,5.40,5.61,5.83,6.07,6.33,6.60,6.87,7.13,7.40,7.70,7.95,8.20,8.40,8.63,8.87,9.07,9.25,9.50,9.74,9.97,10.21,10.45,10.71,10.98,11.24,11.48,11.64,11.84,11.99,12.12,12.32,12.50,12.70,12.87,13.09,13.25,13.47,13.62,13.82,13.98,14.12,14.34,14.50,14.71,14.83,14.87,14.87,14.87,14.84,14.75,14.64,14.49,14.32,14.12,14.12,14.13,14.14,14.14,14.08,13.89,13.50,13.12,12.75,12.46,12.15,11.96,11.73,11.50,11.37,11.35,11.37,11.52,11.83,12.22,12.71,13.25,13.87,14.59,15.26,15.95,16.46,16.76,16.84,16.57,16.13,15.64,15.12,14.62,14.15,13.75,13.46,13.34,13.47,13.87,14.45,14.99,15.40,15.64,15.88,16.23,16.60,17.07,17.59,18.12,18.63,19.12,19.50,19.87,20.02,20.08,20,19.75,19.36,18.95,18.50,18.08,17.60,17.01,16.39,15.75,15.10,14.39,13.75,13.11,12.48,11.86,11.25,10.64,10.14,9.73,9.36,9,8.62,8.27,7.97,7.62,7.23,6.70,5.97,5.25,4.48,3.72,2.83,1.89,1.02,0.21,-0.63,-1.49,-2.38,-2.97,-2.17,-1.18,-0.52,0.01,0.51,1,1.49,2,2.62,3.32,4.08,4.87,5.74,6.50,7.26,8,8.75,9.40,10,10.50,10.84,11,11.08,11,10.88,10.75,10.58,10.37,10.12,9.85,9.50,9.13,8.75,8.35,7.98,7.63,7.37,7.21,7.09,7,7.07,7.14,7.26,7.45,7.59,7.73,7.85,7.90,8,8.11,8.25,8.48,8.76,9.12,9.37,9.75,10.12,10.48,10.75,11,11.13,11.25,11.36,11.40,11.57,11.85,12.37,13.24,14.27,15.37,16.37,17.49,18.27,19.60,19.12,18.62,-10,-11,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-17,-17,-16,-16,-16,-16,-15,-15,-14,-13,-13,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-11,-11,-10,-10,-10,-9.76,-9.49,-9.13,-8.77,-8.50,-8.25,-8.11,-7.99,-7.87,-7.73,-7.48,-7.13,-6.63,-5.88,-4.91,-3.75,-2.50,-1.25,-0.26,0.37,0.73,0.87,1.01,1.20,1.37,1.60,1.82,2,2.25,2.48,2.71,2.90,3.12,3.36,3.57,3.75,3.95,4.12,4.25,4.38,4.52,4.71,4.85,5,5.12,5.32,5.48,5.62,5.83,6,6.25,6.49,6.75,7,7.26,7.57,7.84,8.10,8.35,8.58,8.75,8.96,9.12,9.37,9.61,9.84,10.08,10.27,10.50,10.75,11,11.25,11.48,11.64,11.84,11.98,12.12,12.27,12.49,12.64,12.86,13.07,13.25,13.47,13.62,13.82,13.98,14.12,14.34,14.50,14.71,14.84,14.88,14.90,14.89,14.87,14.83,14.74,14.62,14.50,14.38,14.37,14.37,14.38,14.37,14.33,14.12,13.82,13.49,13.15,12.89,12.65,12.45,12.22,12,11.87,11.82,11.87,12.07,12.37,12.84,13.37,13.98,14.62,15.32,15.99,16.60,17.07,17.27,17.24,16.99,16.59,16.12,15.62,15.11,14.59,14.12,13.75,13.52,13.61,13.97,14.48,15.02,15.52,15.98,16.32,16.63,17,17.40,17.89,18.37,18.87,19.46,19.83,20.13,20.37,20.47,20.45,20.25,19.77,19.37,18.95,18.48,17.96,17.32,16.58,15.75,14.89,14.10,13.26,12.50,11.83,11.14,10.61,10.12,9.75,9.50,9.33,9.12,8.88,8.65,8.39,8.12,7.71,7.12,6.37,5.64,4.95,4.25,3.37,2.50,1.62,0.74,-0.15,-1.04,-2.09,-3.16,-2.35,-1.62,-0.84,-0.26,0.25,0.63,1.11,1.60,2.12,2.74,3.38,4.12,4.87,5.62,6.36,7.11,7.86,8.52,9.12,9.58,9.85,9.97,9.98,9.88,9.75,9.62,9.47,9.26,9.09,8.86,8.59,8.25,7.96,7.62,7.37,7.12,6.99,6.87,6.84,6.83,6.97,7.14,7.38,7.63,7.89,8.13,8.37,8.57,8.73,8.88,9.12,9.38,9.74,10.10,10.37,10.74,11.02,11.26,11.45,11.46,11.37,11.26,11.22,11.21,11.27,11.50,12.09,12.99,14.12,15.33,16.37,17.59,18.12,18.62,18.62,17.62,-10,-11,-11,-12,-13,-13,-14,-14,-15,-16,-16,-16,-16,-16,-17,-17,-16,-16,-16,-16,-15,-15,-14,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-11,-10,-10,-10,-10,-9.75,-9.40,-9.05,-8.75,-8.48,-8.18,-8.04,-7.93,-7.79,-7.62,-7.25,-6.76,-6.13,-5.14,-4.02,-2.88,-1.75,-0.75,0.01,0.52,0.76,0.97,1.12,1.27,1.50,1.75,1.97,2.20,2.39,2.63,2.87,3.12,3.35,3.57,3.75,3.97,4.12,4.33,4.50,4.62,4.75,4.90,5.08,5.23,5.37,5.51,5.72,5.87,6.02,6.24,6.40,6.62,6.87,7.12,7.38,7.65,7.96,8.22,8.48,8.70,8.86,9.01,9.24,9.46,9.70,9.90,10.13,10.37,10.60,10.82,11,11.25,11.46,11.62,11.75,11.90,12.08,12.24,12.39,12.61,12.76,12.98,13.14,13.37,13.59,13.75,13.90,14.10,14.26,14.50,14.64,14.82,14.87,14.87,14.88,14.88,14.87,14.83,14.75,14.70,14.62,14.61,14.62,14.62,14.61,14.50,14.34,14.09,13.84,13.59,13.37,13.12,12.89,12.65,12.47,12.32,12.25,12.35,12.58,12.95,13.40,14,14.62,15.26,15.96,16.59,17.14,17.62,17.75,17.62,17.34,16.97,16.51,16.08,15.59,15.08,14.57,14.11,13.83,13.75,13.97,14.35,14.84,15.37,15.89,16.40,16.77,17.12,17.38,17.72,18.12,18.62,19.14,19.62,20.12,20.50,20.64,20.72,20.51,20,19.61,19.12,18.62,18.02,17.34,16.49,15.50,14.60,13.64,12.75,11.90,11.20,10.58,10.09,9.75,9.75,9.83,9.84,9.83,9.75,9.62,9.38,9.11,8.65,8.11,7.39,6.63,5.87,5.01,4.14,3.25,2.27,1.34,0.37,-0.60,-1.58,-2.38,-2.67,-2.22,-1.15,-0.68,-0.14,0.24,0.62,1.11,1.61,2.12,2.75,3.37,4.02,4.74,5.45,6.14,6.88,7.59,8.12,8.50,8.72,8.76,8.76,8.73,8.62,8.50,8.37,8.25,8.12,7.95,7.70,7.47,7.24,7,6.87,6.74,6.63,6.62,6.72,6.75,7,7.35,7.71,8.08,8.46,8.82,9.13,9.48,9.75,10.01,10.34,10.63,11,11.34,11.62,11.95,12.20,12.34,12.34,12.12,11.85,11.50,11.25,11.14,11.20,11.36,11.76,12.52,13.58,14.75,15.96,16.96,17.62,17.84,17.82,17.64,-9.87,-10,-11,-12,-13,-13,-14,-15,-15,-16,-16,-16,-16,-17,-17,-17,-16,-16,-16,-16,-15,-15,-14,-13,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.75,-9.39,-9.03,-8.74,-8.41,-8.24,-8.05,-7.99,-7.78,-7.53,-7.03,-6.40,-5.54,-4.40,-3.13,-1.90,-0.88,-0.13,0.32,0.62,0.87,1.01,1.22,1.39,1.63,1.87,2.12,2.36,2.61,2.85,3.10,3.34,3.52,3.75,3.97,4.13,4.36,4.51,4.72,4.87,5,5.12,5.27,5.46,5.62,5.75,5.96,6.12,6.25,6.45,6.62,6.82,7,7.25,7.50,7.75,8,8.27,8.57,8.74,8.90,9.12,9.33,9.51,9.75,10,10.23,10.40,10.62,10.82,11,11.20,11.37,11.51,11.70,11.83,11.97,12.12,12.27,12.49,12.64,12.86,13.02,13.25,13.48,13.63,13.84,14,14.22,14.38,14.60,14.71,14.76,14.87,14.87,14.88,14.88,14.87,14.87,14.85,14.84,14.77,14.82,14.83,14.75,14.70,14.57,14.37,14.15,14,13.82,13.61,13.37,13.12,12.87,12.71,12.62,12.75,13,13.39,13.95,14.52,15.20,15.85,16.46,17.01,17.60,17.97,18.01,17.87,17.60,17.27,16.96,16.57,16.11,15.58,15,14.50,14.12,13.97,14,14.15,14.50,15,15.62,16.15,16.62,16.87,17,17.14,17.49,17.96,18.50,19.12,19.70,20.23,20.58,20.65,20.50,19.98,19.50,19,18.45,17.77,17,16.11,15.12,14.12,13.12,12.23,11.37,10.64,10.10,9.87,9.88,10.07,10.32,10.57,10.75,10.77,10.75,10.57,10.25,9.83,9.24,8.50,7.71,6.84,5.89,4.96,4,3,2,1,0.10,-0.98,-2.01,-2.60,-2.59,-2.04,-1.45,-0.83,-0.27,0.12,0.60,1.10,1.61,2.12,2.70,3.25,3.88,4.58,5.25,5.95,6.57,7.01,7.35,7.50,7.59,7.60,7.58,7.50,7.48,7.39,7.37,7.25,7.12,6.96,6.82,6.65,6.58,6.50,6.48,6.50,6.61,6.70,6.95,7.25,7.70,8.13,8.62,9.12,9.62,10.11,10.52,10.98,11.37,11.75,12.12,12.45,12.73,12.99,13.20,13.34,13.37,13.24,12.86,12.34,11.84,11.46,11.24,11.15,11.25,11.50,12.01,12.75,14.07,15.32,16.62,16.84,17.08,17.15,16.71,-9.41,-10,-11,-12,-12,-13,-14,-14,-15,-16,-16,-16,-16,-16,-17,-17,-17,-16,-16,-15,-15,-15,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.76,-9.38,-9,-8.67,-8.41,-8.25,-8.13,-8.01,-7.86,-7.51,-6.86,-6,-4.90,-3.51,-2.16,-1.01,0,0.37,0.58,0.75,0.96,1.12,1.32,1.52,1.76,2,2.25,2.50,2.76,3.02,3.27,3.51,3.75,3.97,4.14,4.37,4.58,4.75,4.90,5.10,5.24,5.37,5.50,5.65,5.85,6,6.21,6.37,6.50,6.62,6.76,6.97,7.14,7.37,7.62,7.85,8.09,8.35,8.57,8.75,8.99,9.20,9.37,9.61,9.83,10,10.24,10.40,10.62,10.75,10.95,11.11,11.25,11.38,11.51,11.63,11.77,11.96,12.12,12.32,12.50,12.70,12.87,13.09,13.25,13.50,13.70,13.87,14.09,14.26,14.45,14.59,14.71,14.77,14.87,14.87,14.89,14.90,14.90,14.90,14.96,14.95,14.97,14.98,14.90,14.87,14.77,14.65,14.51,14.37,14.24,14,13.75,13.49,13.23,13,12.98,13.09,13.36,13.76,14.35,14.96,15.60,16.23,16.83,17.25,17.74,18,18.08,17.95,17.74,17.50,17.25,16.97,16.50,16,15.48,14.90,14.48,14.14,14.02,14.10,14.27,14.63,15.13,15.63,16.01,16.25,16.37,16.52,16.83,17.25,17.77,18.40,19.09,19.70,20.12,20.36,20.15,19.57,19.07,18.50,17.88,17.22,16.37,15.49,14.50,13.52,12.61,11.72,10.95,10.37,10.07,9.96,10.12,10.57,11.09,11.50,11.84,11.99,11.97,11.76,11.50,11.07,10.40,9.63,8.74,7.75,6.73,5.70,4.64,3.63,2.64,1.62,0.65,-0.42,-1.55,-2.46,-2.90,-2.72,-2.17,-1.57,-0.91,-0.40,0.08,0.59,1.11,1.61,2.12,2.62,3.20,3.76,4.39,5,5.57,5.96,6.22,6.36,6.40,6.49,6.50,6.52,6.59,6.60,6.60,6.59,6.48,6.40,6.37,6.34,6.32,6.35,6.40,6.58,6.75,6.96,7.26,7.71,8.22,8.75,9.37,9.97,10.58,11.13,11.74,12.25,12.82,13.26,13.63,13.95,14.20,14.33,14.37,14.37,14.25,13.97,13.39,12.75,12.14,11.71,11.37,11.25,11.24,11.36,11.74,12.46,13.39,14.63,15.64,15.98,16.12,16.71,16.73,-9.14,-10,-11,-11,-12,-13,-14,-14,-15,-15,-16,-16,-16,-16,-17,-17,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-13,-13,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-11,-10,-10,-10,-10,-10,-10,-9.78,-9.38,-9,-8.63,-8.38,-8.24,-8.13,-8.11,-7.88,-7.55,-6.63,-5.50,-4.01,-2.55,-1.38,-0.25,0.62,0.82,0.76,0.87,1.01,1.22,1.40,1.64,1.89,2.14,2.40,2.72,2.99,3.25,3.50,3.75,3.97,4.14,4.37,4.59,4.75,4.98,5.12,5.32,5.47,5.61,5.75,5.87,6.08,6.25,6.45,6.61,6.74,6.86,6.97,7.10,7.27,7.50,7.70,7.87,8.12,8.36,8.59,8.77,9,9.23,9.45,9.62,9.85,10.01,10.22,10.37,10.57,10.72,10.85,10.98,11.10,11.22,11.33,11.45,11.58,11.73,11.87,12.09,12.25,12.48,12.64,12.87,13.08,13.27,13.50,13.73,13.90,14.11,14.26,14.46,14.60,14.72,14.77,14.87,14.88,14.95,14.96,14.98,15,15,15.07,15.09,15.07,15.02,15,14.98,14.87,14.77,14.63,14.46,14.12,13.84,13.50,13.32,13.23,13.33,13.62,14.07,14.61,15.22,15.84,16.45,16.97,17.25,17.62,17.75,17.82,17.75,17.62,17.52,17.39,17.14,16.75,16.27,15.75,15.24,14.73,14.34,14.12,14.07,14.13,14.49,14.83,15.20,15.50,15.75,15.96,16.12,16.36,16.71,17.21,17.75,18.39,19.01,19.49,19.64,19.47,18.87,18.33,17.74,17.12,16.37,15.61,14.75,13.85,12.90,12.07,11.25,10.74,10.25,10.08,10.15,10.60,11.24,11.88,12.57,13.02,13.25,13.25,13.01,12.70,12.15,11.50,10.62,9.62,8.52,7.46,6.37,5.32,4.25,3.25,2.24,1.23,0.16,-0.96,-1.95,-2.76,-3.09,-2.84,-2.23,-1.53,-0.92,-0.41,0.12,0.63,1.13,1.62,2.12,2.61,3.12,3.64,4.20,4.62,4.99,5.22,5.37,5.48,5.58,5.64,5.75,5.87,5.99,6.09,6.08,6.12,6.15,6.21,6.24,6.32,6.40,6.61,6.84,7.07,7.38,7.82,8.27,8.87,9.50,10.14,10.86,11.52,12.25,12.89,13.61,14.25,14.76,15.15,15.50,15.59,15.58,15.47,15.25,14.97,14.49,13.86,13.14,12.50,12,11.62,11.37,11.32,11.38,11.64,12.32,13.02,13.97,14.71,15,15.12,15.23,14.75,-9.50,-10,-10,-11,-12,-13,-13,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-11,-10,-10,-10,-10,-9.79,-9.38,-9,-8.62,-8.35,-8.14,-8.11,-8.13,-7.91,-7.55,-6.30,-4.78,-3.02,-1.63,-0.55,0.32,0.97,0.87,0.89,1,1.12,1.33,1.52,1.77,2.02,2.32,2.60,2.87,3.15,3.46,3.72,3.95,4.14,4.37,4.61,4.77,5,5.20,5.37,5.50,5.65,5.83,5.97,6.12,6.27,6.50,6.65,6.85,6.97,7.07,7.12,7.25,7.40,7.62,7.75,7.90,8.12,8.37,8.60,8.83,9,9.24,9.46,9.62,9.84,10,10.13,10.32,10.46,10.60,10.71,10.76,10.87,10.97,11.07,11.13,11.26,11.45,11.62,11.82,12,12.22,12.39,12.62,12.85,13.07,13.32,13.50,13.74,13.90,14.12,14.27,14.47,14.61,14.73,14.83,14.87,14.90,14.97,14.99,15,15.07,15.12,15.13,15.14,15.21,15.23,15.23,15.21,15.12,15,14.82,14.50,14.14,13.85,13.58,13.38,13.50,13.77,14.23,14.75,15.34,15.89,16.46,16.87,17.07,17.25,17.36,17.37,17.37,17.36,17.32,17.25,17.08,16.74,16.33,15.85,15.35,14.84,14.38,14.13,14.12,14.21,14.37,14.62,14.96,15.25,15.50,15.71,15.86,16.02,16.35,16.75,17.25,17.84,18.37,18.73,18.77,18.50,17.96,17.37,16.77,16.14,15.50,14.75,13.96,13.12,12.33,11.58,11,10.52,10.25,10.25,10.51,11.12,11.90,12.75,13.61,14.22,14.46,14.37,14.11,13.62,13,12.25,11.32,10.25,9.12,8.02,6.97,5.87,4.86,3.83,2.77,1.75,0.75,-0.35,-1.37,-2.26,-2.95,-3.08,-2.71,-2.15,-1.49,-0.87,-0.28,0.25,0.82,1.25,1.73,2.12,2.60,3.01,3.49,3.87,4.20,4.39,4.61,4.75,4.87,5.07,5.25,5.47,5.65,5.75,5.97,6.12,6.24,6.35,6.46,6.59,6.75,6.99,7.25,7.59,8,8.49,9,9.62,10.33,11.02,11.76,12.51,13.27,14.09,14.87,15.60,16.20,16.70,16.88,16.87,16.64,16.35,15.96,15.47,14.87,14.22,13.51,12.89,12.40,12.01,11.77,11.70,11.71,12.11,12.36,12.96,13.25,13.87,14.23,14.24,14.22,13.82,-9.77,-10,-11,-11,-12,-12,-13,-14,-14,-15,-15,-16,-16,-16,-16,-16,-17,-17,-17,-17,-16,-16,-16,-15,-15,-14,-13,-13,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.80,-9.38,-8.92,-8.52,-8.18,-8,-7.91,-8.02,-7.85,-7.38,-5.93,-3.92,-2.13,-0.76,0.07,0.63,0.99,0.97,0.99,1.08,1.23,1.45,1.70,1.95,2.21,2.48,2.75,3.08,3.37,3.62,3.88,4.13,4.37,4.61,4.83,5,5.23,5.38,5.59,5.75,5.87,6.01,6.20,6.36,6.51,6.74,6.89,7.09,7.21,7.26,7.37,7.47,7.60,7.73,7.85,7.98,8.13,8.37,8.61,8.83,9,9.22,9.38,9.61,9.75,9.90,10.07,10.20,10.32,10.40,10.50,10.57,10.62,10.65,10.75,10.85,10.97,11.12,11.27,11.50,11.71,11.89,12.12,12.36,12.59,12.82,13.02,13.26,13.50,13.74,13.95,14.12,14.32,14.48,14.62,14.75,14.84,14.87,14.95,14.98,15,15.01,15.11,15.20,15.24,15.32,15.37,15.45,15.47,15.40,15.34,15.13,14.87,14.52,14.15,13.86,13.62,13.65,13.90,14.34,14.77,15.33,15.84,16.25,16.57,16.62,16.75,16.83,16.82,16.84,16.85,16.86,16.82,16.65,16.40,16.11,15.71,15.25,14.82,14.48,14.25,14.20,14.25,14.40,14.70,15,15.33,15.59,15.75,15.90,16.08,16.25,16.59,16.97,17.37,17.76,17.98,17.88,17.51,17,16.38,15.83,15.23,14.59,13.88,13.20,12.46,11.75,11.23,10.75,10.47,10.37,10.50,10.99,11.73,12.60,13.50,14.47,15.12,15.37,15.25,14.87,14.25,13.50,12.62,11.65,10.62,9.59,8.50,7.48,6.46,5.45,4.39,3.37,2.36,1.25,0.28,-0.72,-1.63,-2.38,-2.82,-2.82,-2.68,-2.03,-1.28,-0.63,0,0.51,1,1.45,1.84,2.21,2.58,2.95,3.27,3.61,3.87,4.10,4.27,4.50,4.75,5.07,5.34,5.62,5.90,6.21,6.40,6.62,6.75,6.95,7.11,7.26,7.50,7.82,8.21,8.65,9.24,9.85,10.50,11.23,11.97,12.74,13.50,14.32,15.12,15.97,16.74,17.48,18,18.08,17.87,17.51,17,16.48,15.87,15.23,14.52,13.88,13.36,12.89,12.62,12.47,12.40,12.49,12.75,13.11,13.25,13.25,13.22,13.88,14,14,13.85,-10,-10,-11,-11,-12,-13,-13,-14,-14,-15,-15,-16,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-13,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.79,-9.36,-8.88,-8.40,-8,-7.73,-7.55,-7.63,-7.38,-7.01,-5.25,-3.04,-1.28,-0.13,0.50,0.87,0.99,0.99,1,1.12,1.33,1.57,1.84,2.11,2.37,2.63,2.96,3.25,3.58,3.86,4.12,4.37,4.61,4.84,5.02,5.25,5.46,5.62,5.77,5.97,6.12,6.25,6.39,6.60,6.76,6.98,7.13,7.33,7.45,7.51,7.62,7.65,7.75,7.86,7.89,8,8.21,8.39,8.62,8.84,9,9.14,9.34,9.50,9.65,9.85,9.97,10.08,10.12,10.23,10.25,10.27,10.33,10.36,10.38,10.50,10.62,10.75,10.97,11.14,11.37,11.61,11.84,12.07,12.27,12.51,12.77,13.01,13.27,13.51,13.75,13.97,14.12,14.33,14.49,14.62,14.74,14.82,14.87,14.88,14.96,14.98,15.02,15.13,15.25,15.37,15.50,15.60,15.62,15.63,15.62,15.49,15.25,14.99,14.62,14.25,14,13.89,14.09,14.37,14.75,15.22,15.61,15.87,16.01,16.02,16.10,16.12,16.12,16.20,16.25,16.26,16.26,16.21,16,15.75,15.47,15.12,14.75,14.49,14.32,14.25,14.37,14.62,14.95,15.27,15.62,15.90,16.12,16.27,16.38,16.50,16.65,16.87,17.12,17.34,17.37,17.11,16.62,16.07,15.46,14.87,14.34,13.75,13.14,12.50,11.87,11.37,10.89,10.61,10.47,10.51,10.87,11.47,12.25,13.21,14.12,15,15.62,15.87,15.75,15.25,14.59,13.75,12.86,11.87,10.87,9.87,8.87,7.95,7,6.02,5.07,4,2.99,1.95,0.93,-0.03,-0.95,-1.74,-2.35,-2.75,-2.89,-2.37,-1.65,-0.86,-0.18,0.36,0.85,1.25,1.62,1.95,2.25,2.60,2.89,3.25,3.51,3.83,4.12,4.40,4.76,5.10,5.51,5.99,6.37,6.74,7,7.25,7.47,7.62,7.75,7.96,8.12,8.46,8.87,9.37,10,10.71,11.39,12.13,12.89,13.65,14.45,15.24,16.02,16.85,17.64,18.40,18.75,18.75,18.50,18.02,17.47,16.87,16.24,15.58,14.88,14.27,13.82,13.50,13.37,13.37,13.47,13.62,13.86,14,14.07,14.02,14.12,14.13,14.12,14.12,13.87,-10,-10,-11,-12,-12,-13,-13,-14,-14,-15,-15,-16,-16,-17,-17,-18,-18,-18,-18,-18,-18,-17,-17,-16,-16,-15,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.78,-9.27,-8.75,-8.25,-7.75,-7.29,-6.99,-6.85,-6.52,-5.98,-4.13,-2.16,-0.64,0.25,0.74,0.95,1,0.99,1.02,1.23,1.45,1.71,1.99,2.25,2.57,2.86,3.13,3.48,3.75,4.08,4.35,4.60,4.85,5.08,5.26,5.49,5.65,5.86,6,6.20,6.36,6.50,6.64,6.85,7.01,7.24,7.37,7.57,7.65,7.76,7.87,7.96,8,8.02,8.07,8.14,8.34,8.50,8.71,8.87,9,9.11,9.23,9.37,9.50,9.70,9.77,9.87,9.89,9.97,9.99,10,10,10,10.02,10.12,10.25,10.40,10.62,10.83,11.02,11.25,11.50,11.75,12,12.25,12.50,12.76,13.07,13.34,13.58,13.77,14,14.14,14.34,14.49,14.61,14.65,14.75,14.75,14.83,14.86,14.95,15.08,15.21,15.36,15.50,15.63,15.75,15.84,15.86,15.77,15.65,15.46,15.12,14.75,14.45,14.25,14.23,14.37,14.62,14.96,15.15,15.27,15.34,15.26,15.27,15.36,15.47,15.59,15.71,15.76,15.83,15.75,15.64,15.50,15.26,15,14.75,14.50,14.37,14.37,14.58,14.87,15.32,15.75,16.12,16.49,16.74,16.87,16.96,16.97,16.99,17,17.07,17.01,16.86,16.46,15.85,15.23,14.61,14.02,13.57,13.11,12.62,12.08,11.50,11.11,10.75,10.57,10.59,10.82,11.25,11.99,12.83,13.74,14.60,15.35,15.75,15.87,15.73,15.26,14.62,13.83,12.90,12,11.08,10.13,9.26,8.45,7.60,6.71,5.75,4.74,3.65,2.62,1.57,0.60,-0.24,-1.10,-1.96,-2.73,-3.11,-2.80,-2.02,-1.11,-0.26,0.25,0.73,1.12,1.49,1.76,2.08,2.37,2.72,3.07,3.39,3.75,4.14,4.50,5,5.50,6.08,6.61,7.09,7.50,7.84,8.10,8.26,8.39,8.51,8.63,8.83,9.10,9.50,10.09,10.75,11.50,12.32,13.10,13.87,14.62,15.35,16.08,16.76,17.50,18.26,18.87,18.98,18.86,18.60,18.23,17.74,17.20,16.60,15.96,15.27,14.74,14.37,14.22,14.21,14.32,14.57,14.87,15.08,15.12,15.02,15,15,15,15,15,14.95,-10,-10,-11,-12,-12,-13,-13,-14,-14,-15,-16,-16,-17,-17,-18,-18,-18,-18,-18,-18,-18,-18,-17,-17,-16,-15,-14,-14,-13,-12,-12,-11,-11,-11,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.75,-9.24,-8.63,-8.03,-7.41,-6.79,-6.23,-5.63,-5.01,-4.13,-2.65,-1.25,-0.13,0.58,0.87,0.98,1,1,1.12,1.33,1.58,1.85,2.12,2.45,2.75,3.08,3.37,3.71,4,4.32,4.59,4.84,5.08,5.27,5.50,5.72,5.87,6.09,6.25,6.39,6.60,6.75,6.95,7.12,7.32,7.49,7.63,7.76,7.89,8.01,8.13,8.25,8.32,8.34,8.33,8.38,8.51,8.65,8.83,8.90,9,9.07,9.12,9.23,9.36,9.49,9.58,9.62,9.62,9.63,9.63,9.63,9.62,9.63,9.71,9.76,9.88,10.08,10.25,10.47,10.70,10.90,11.15,11.40,11.65,11.97,12.24,12.50,12.83,13.11,13.37,13.61,13.83,14,14.13,14.27,14.39,14.50,14.57,14.59,14.62,14.70,14.76,14.90,15.09,15.25,15.47,15.62,15.77,15.90,16,16.07,16,15.87,15.62,15.26,14.86,14.50,14.34,14.27,14.37,14.50,14.59,14.58,14.50,14.49,14.50,14.62,14.85,15.10,15.33,15.49,15.58,15.59,15.50,15.37,15.25,15,14.75,14.51,14.45,14.50,14.82,15.24,15.74,16.25,16.75,17.13,17.45,17.60,17.62,17.51,17.40,17.27,17.12,16.88,16.50,15.87,15.13,14.59,13.98,13.50,13.11,12.75,12.36,11.87,11.47,11,10.75,10.64,10.84,11.21,11.77,12.51,13.37,14.21,14.87,15.40,15.76,15.88,15.75,15.34,14.70,13.87,13,12.12,11.26,10.49,9.73,8.99,8.24,7.37,6.49,5.50,4.40,3.36,2.32,1.27,0.38,-0.43,-1.41,-2.23,-2.79,-2.83,-2.27,-1.34,-0.48,0.23,0.71,1.08,1.38,1.70,1.95,2.23,2.61,3,3.45,3.87,4.37,4.95,5.50,6.12,6.75,7.37,7.95,8.39,8.76,9.01,9.22,9.25,9.33,9.34,9.40,9.63,10.07,10.63,11.37,12.24,13.12,14,14.83,15.52,16.15,16.75,17.37,18.08,18.39,18.75,18.62,18.50,18.33,18.12,17.85,17.48,17,16.38,15.74,15.33,15,14.87,14.99,15.25,15.61,16,16.62,16.25,16.09,16,15.99,15.99,16,16,16,-10,-10,-11,-12,-12,-13,-13,-14,-15,-15,-16,-17,-17,-18,-18,-19,-19,-19,-19,-19,-19,-18,-18,-17,-16,-16,-15,-14,-13,-12,-12,-12,-11,-11,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.68,-9.13,-8.50,-7.86,-7.13,-6.29,-5.38,-4.38,-3.13,-2.13,-1.25,-0.38,0.35,0.75,0.95,0.99,1,1,1.13,1.46,1.73,2,2.32,2.62,2.97,3.27,3.62,3.97,4.25,4.57,4.84,5.10,5.33,5.51,5.75,5.96,6.12,6.32,6.50,6.64,6.86,7.01,7.22,7.37,7.58,7.75,7.87,8.01,8.14,8.27,8.47,8.60,8.65,8.64,8.63,8.72,8.82,8.95,9.02,9.12,9.13,9.15,9.21,9.24,9.25,9.26,9.32,9.34,9.34,9.34,9.35,9.35,9.35,9.36,9.37,9.48,9.59,9.73,9.87,10.11,10.35,10.60,10.85,11.10,11.36,11.62,11.90,12.24,12.51,12.85,13.12,13.37,13.62,13.77,13.96,14.09,14.21,14.32,14.37,14.40,14.45,14.50,14.61,14.75,14.90,15.12,15.36,15.58,15.75,15.97,16.12,16.23,16.25,16.20,16,15.72,15.22,14.70,14.27,14.08,13.97,13.89,13.87,13.75,13.65,13.63,13.87,14.12,14.46,14.85,15.21,15.46,15.60,15.62,15.60,15.50,15.27,15.01,14.76,14.61,14.57,14.72,15.09,15.60,16.15,16.76,17.37,17.86,18.21,18.36,18.34,18.20,17.98,17.72,17.37,16.99,16.37,15.62,14.83,14.12,13.72,13.33,13,12.75,12.38,11.98,11.57,11.14,10.95,10.96,11.24,11.75,12.37,13.12,13.87,14.59,15.13,15.59,15.84,15.87,15.73,15.33,14.73,13.97,13.12,12.34,11.58,10.87,10.23,9.60,8.89,8.12,7.23,6.24,5.15,4.12,3.07,2,1,0.17,-0.83,-1.74,-2.49,-2.79,-2.43,-1.51,-0.59,0.20,0.61,1,1.33,1.59,1.87,2.22,2.63,3.13,3.65,4.24,4.84,5.49,6.13,6.86,7.57,8.25,8.87,9.45,9.86,10.09,10.21,10.12,10,9.89,9.90,10.12,10.50,11.09,11.86,12.75,13.75,14.75,15.62,16.36,16.87,17.38,17.75,18.02,18.15,18.14,18.01,17.88,17.86,17.85,17.88,17.86,17.46,16.90,16.37,15.96,15.70,15.49,15.74,16.09,16.61,17,17.70,17.23,17.02,17,16.99,16.99,17,18,18,-10,-10,-11,-12,-12,-13,-13,-14,-15,-16,-16,-17,-18,-18,-19,-19,-19,-20,-20,-19,-19,-19,-18,-17,-17,-16,-15,-14,-13,-12,-12,-12,-11,-11,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.53,-9,-8.38,-7.63,-6.80,-5.88,-4.73,-3.13,-1.55,-0.53,-0.01,0.37,0.71,0.87,0.98,1,1,1.12,1.36,1.62,1.88,2.20,2.50,2.83,3.14,3.50,3.87,4.23,4.51,4.84,5.11,5.36,5.59,5.77,6,6.20,6.37,6.58,6.75,6.95,7.12,7.32,7.50,7.64,7.84,8,8.12,8.25,8.39,8.57,8.74,8.87,8.97,8.98,8.98,8.99,9.13,9.26,9.37,9.45,9.47,9.47,9.40,9.38,9.37,9.25,9.21,9.13,9.12,9.12,9.12,9.12,9.12,9.12,9.15,9.24,9.33,9.39,9.58,9.75,10,10.25,10.50,10.75,11,11.33,11.62,11.90,12.25,12.57,12.87,13.12,13.37,13.57,13.72,13.85,13.97,14.11,14.23,14.26,14.25,14.33,14.38,14.57,14.75,14.98,15.21,15.45,15.63,15.86,16.02,16.21,16.25,16.25,16.12,15.97,15.37,14.64,14.08,13.63,13.37,13.23,13.11,13,12.98,13.09,13.46,13.87,14.37,14.87,15.34,15.62,15.86,15.90,15.87,15.71,15.46,15.14,14.87,14.73,14.72,14.95,15.37,15.96,16.61,17.26,17.96,18.50,18.89,19.09,19.01,18.86,18.58,18.24,17.83,17.27,16.61,15.75,14.95,14.21,13.87,13.51,13.25,13,12.63,12.25,11.83,11.48,11.32,11.39,11.83,12.38,13.08,13.75,14.38,14.98,15.38,15.72,15.87,15.87,15.71,15.33,14.75,14.08,13.33,12.60,11.90,11.34,10.75,10.23,9.59,8.83,7.90,6.96,5.90,4.87,3.83,2.72,1.59,0.58,-0.26,-1.13,-1.95,-2.47,-2.41,-1.67,-0.79,0.12,0.47,0.82,1.12,1.47,1.76,2.12,2.75,3.37,4,4.64,5.37,6.11,6.85,7.61,8.37,9.12,9.87,10.50,11.07,11.23,11.07,10.82,10.57,10.37,10.34,10.46,10.76,11.35,12.12,13.08,14.12,15.21,16.33,17.14,17.60,17.76,17.86,17.77,17.62,17.50,17.33,17.22,17.22,17.36,17.57,17.89,18.12,17.40,17,16.63,16.39,16.36,16.48,16.82,17.24,17.71,17.96,18.07,17.99,17.97,17.97,17.98,18,18,18,-10,-10,-11,-12,-12,-13,-13,-14,-15,-16,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-19,-19,-19,-18,-17,-16,-15,-14,-13,-13,-12,-12,-11,-11,-11,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.88,-9.38,-8.80,-8.16,-7.43,-6.61,-5.60,-4.37,-2.50,-0.63,0.45,0.63,0.75,0.87,0.96,0.99,1,1,1.24,1.51,1.84,2.11,2.37,2.65,3,3.37,3.75,4.12,4.48,4.82,5.11,5.37,5.62,5.86,6.02,6.25,6.40,6.62,6.85,7.01,7.24,7.39,7.61,7.75,7.95,8.11,8.25,8.38,8.51,8.65,8.86,9,9,9,9.02,9.07,9.46,9.62,9.75,9.83,9.87,9.87,9.87,9.84,9.75,9.63,9.50,9.33,9.21,9.12,9.10,9.07,9,9,9.01,9.07,9.10,9.12,9.21,9.32,9.48,9.70,9.95,10.20,10.46,10.73,11,11.32,11.62,11.95,12.25,12.58,12.86,13.11,13.32,13.47,13.60,13.73,13.87,14,14.08,14.07,14.10,14.20,14.35,14.52,14.77,15.07,15.27,15.50,15.71,15.86,15.97,16,15.99,15.87,15.71,15.09,14.27,13.59,13.08,12.73,12.50,12.39,12.38,12.49,12.75,13.27,14,14.60,15.13,15.62,16,16.25,16.35,16.21,15.99,15.64,15.35,15.02,14.87,14.88,15.14,15.62,16.25,16.98,17.71,18.40,19.07,19.50,19.70,19.63,19.47,19.20,18.84,18.37,17.83,17.12,16.27,15.50,14.84,14.46,14.08,13.75,13.37,13,12.59,12.15,11.88,11.83,12.01,12.51,13.12,13.77,14.37,14.89,15.34,15.62,15.82,15.87,15.87,15.71,15.37,14.86,14.24,13.58,12.90,12.36,11.85,11.36,10.82,10.14,9.37,8.50,7.61,6.62,5.62,4.59,3.45,2.12,0.87,0.27,-0.57,-1.32,-1.96,-2.32,-1.98,-1.13,0,0.32,0.62,0.97,1.27,1.71,2.25,2.88,3.62,4.37,5.12,5.96,6.75,7.57,8.36,9.15,10,10.84,11.50,11.88,11.95,11.73,11.37,11,10.73,10.59,10.62,10.87,11.39,12.14,13.12,14.24,15.37,16.51,17.39,17.87,17.96,17.75,17.39,17.12,16.84,16.59,16.45,16.50,16.73,17.08,17.39,17.61,17.60,17.40,17.25,17.12,17.12,17.25,17.47,17.88,18.27,18.62,18.82,18.87,18.83,18.87,18.89,18.96,19,19,-10,-10,-11,-11,-12,-13,-13,-14,-16,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-18,-17,-16,-15,-13,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.73,-9.23,-8.63,-8,-7.24,-6.38,-5.50,-4,-2.13,-0.25,0.85,0.96,0.98,0.99,0.99,1,1,1,1.37,1.74,2.01,2.27,2.57,2.86,3.15,3.52,3.96,4.36,4.74,5.09,5.38,5.70,5.95,6.13,6.35,6.50,6.72,6.89,7.12,7.35,7.51,7.73,7.88,8.08,8.25,8.38,8.57,8.72,8.85,8.96,9.12,9,9.97,9.90,9.88,10.02,10.13,10.25,10.37,10.39,10.45,10.46,10.40,10.37,10.25,10.07,9.84,9.62,9.45,9.32,9.21,9.12,9.02,9,9,9,9,9.01,9.08,9.12,9.25,9.45,9.63,9.89,10.13,10.39,10.72,11,11.32,11.62,11.96,12.25,12.57,12.84,13.02,13.22,13.35,13.47,13.59,13.65,13.75,13.76,13.85,13.96,14.12,14.36,14.62,14.87,15.12,15.33,15.47,15.51,15.51,15.48,15.36,15.13,14.83,14.23,13.50,12.87,12.37,12.02,11.88,11.89,12.01,12.37,12.97,13.62,14.37,15.01,15.62,16.11,16.46,16.72,16.82,16.58,16.26,15.89,15.52,15.24,15.08,15.12,15.37,15.87,16.50,17.23,17.99,18.74,19.37,19.84,20.02,20.08,19.96,19.75,19.40,19,18.48,17.82,17.08,16.35,15.72,15.21,14.75,14.25,13.83,13.36,12.90,12.59,12.38,12.47,12.77,13.34,13.96,14.51,15.01,15.38,15.63,15.83,15.87,15.90,15.87,15.74,15.45,15,14.47,13.87,13.33,12.82,12.36,11.87,11.32,10.62,9.84,9,8.14,7.32,6.37,5.37,4.21,2.88,1.50,0.59,-0.11,-0.77,-1.52,-2.15,-2.36,-1.79,-0.16,0.11,0.37,0.74,1.12,1.62,2.25,3.01,3.87,4.73,5.61,6.47,7.33,8.20,9.09,9.96,10.76,11.51,12.11,12.37,12.33,12,11.62,11.25,10.96,10.82,10.83,11,11.39,12.02,12.89,13.97,15.10,16.22,17.14,17.72,17.74,17.40,16.98,16.58,16.20,15.87,15.73,15.83,16.11,16.50,16.95,17.32,17.51,17.62,17.65,17.74,17.85,18,18.26,18.62,18.96,19.24,19.64,19.73,19.76,18.96,18.87,18.07,18,18,-10,-10,-11,-12,-12,-13,-14,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-14,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.88,-9.50,-9,-8.43,-7.75,-7,-6.13,-5.13,-3.53,-1.75,0.10,0.87,0.99,0.99,0.99,1,1,1,1,1.63,1.89,2.23,2.50,2.74,3,3.34,3.72,4.12,4.58,5,5.37,5.74,6,6.25,6.49,6.64,6.85,7.01,7.25,7.47,7.65,7.87,8.08,8.25,8.39,8.60,8.75,8.95,9.11,9.25,9.36,9.27,9.95,10.08,10.11,10.87,10.99,11.01,11.10,11.12,11.14,11.20,11.15,11.12,11.02,10.86,10.58,10.24,9.90,9.70,9.50,9.37,9.25,9.12,9.02,9,9,9,9,9,9.02,9.12,9.25,9.47,9.64,9.87,10.12,10.39,10.72,11,11.33,11.62,11.97,12.25,12.52,12.76,12.98,13.11,13.23,13.33,13.37,13.45,13.50,13.58,13.71,13.87,14.12,14.38,14.64,14.87,15.02,15.10,15.01,14.88,14.72,14.46,14.12,13.72,13.14,12.61,12.02,11.57,11.39,11.50,11.75,12.13,12.74,13.40,14.21,14.97,15.62,16.15,16.62,16.90,17.12,17.12,16.88,16.59,16.15,15.75,15.46,15.25,15.33,15.61,16.07,16.63,17.35,18.07,18.75,19.37,19.82,20.08,20.21,20.22,20.11,19.87,19.50,19.08,18.50,17.87,17.25,16.62,16.02,15.39,14.82,14.22,13.65,13.25,13,12.99,13.20,13.62,14.20,14.75,15.25,15.62,15.87,15.96,15.98,15.98,15.96,15.88,15.76,15.52,15.20,14.73,14.21,13.70,13.23,12.75,12.26,11.64,10.90,10.12,9.38,8.70,7.96,7.12,6.13,5,3.63,2.12,0.86,0.20,-0.40,-1.21,-1.86,-2.23,-2.08,-1.41,-0.62,0.12,0.48,0.88,1.49,2.20,3.07,3.98,4.89,5.87,6.77,7.75,8.75,9.74,10.63,11.40,12.08,12.50,12.65,12.51,12.20,11.75,11.37,11.12,10.99,10.99,11.11,11.37,11.88,12.62,13.57,14.61,15.62,16.52,17.12,17.20,16.87,16.45,16,15.60,15.25,15.12,15.25,15.59,16,16.51,17,17.40,17.74,17.98,18.22,18.49,18.75,19.07,19.34,19.62,19.75,19.75,19.72,19.14,18.86,18.12,17.88,17.02,16.98,-10,-10,-11,-12,-12,-13,-14,-15,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-14,-13,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.90,-9.54,-9.23,-8.76,-8.25,-7.55,-6.76,-5.79,-4.68,-3.43,-1.25,0.84,0.87,1,1,1,1,1,1,1,1.75,2.08,2.37,2.62,2.87,3.11,3.40,3.86,4.32,4.77,5.25,5.71,6.08,6.37,6.62,6.84,7,7.21,7.38,7.62,7.85,8.07,8.25,8.47,8.63,8.85,9,9.22,9.37,9.61,9.75,9.90,10.12,10.37,10.82,11.25,11.61,11.87,11.96,12,12.01,12.02,12.02,12,11.97,11.82,11.50,11.10,10.62,10.23,9.89,9.72,9.57,9.38,9.25,9.12,9.02,9,9,9,9,9,9.07,9.13,9.26,9.47,9.64,9.87,10.14,10.46,10.74,11,11.35,11.63,11.99,12.25,12.51,12.74,12.87,13,13.11,13.13,13.21,13.25,13.34,13.48,13.64,13.88,14.13,14.37,14.57,14.62,14.61,14.37,14.12,13.84,13.49,13.11,12.63,12.21,11.72,11.24,10.98,11.12,11.50,12.01,12.62,13.36,14.12,14.97,15.72,16.35,16.75,17.12,17.37,17.50,17.45,17.24,16.87,16.46,16,15.70,15.50,15.50,15.75,16.14,16.70,17.25,17.87,18.50,19,19.39,19.72,19.96,20.10,20.10,19.98,19.75,19.48,19.10,18.61,18.02,17.45,16.76,16.08,15.25,14.59,13.98,13.62,13.50,13.62,13.97,14.45,15,15.57,16,16.25,16.27,16.23,16.12,16,15.99,15.90,15.85,15.63,15.37,14.97,14.49,13.99,13.50,13.07,12.50,11.87,11.12,10.39,9.75,9.20,8.58,7.84,6.87,5.76,4.45,2.86,1.21,0.25,-0.25,-0.97,-1.71,-2.32,-2.55,-2.10,-1.22,-0.24,0.15,0.65,1.34,2.12,3.01,4,4.99,5.99,6.98,8,9.11,10.25,11.24,11.87,12.40,12.75,12.87,12.65,12.27,11.87,11.50,11.25,11.13,11.12,11.24,11.40,11.82,12.37,13.13,14.01,14.90,15.71,16.24,16.37,16.20,15.82,15.39,15.02,14.75,14.71,14.86,15.21,15.65,16.25,16.82,17.33,17.75,18.12,18.50,18.90,19.46,19.73,20,20.12,20.61,19.75,19.25,18.75,18.13,17.86,17,16.08,15.97,-10,-10,-11,-12,-13,-14,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-17,-16,-15,-13,-13,-12,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.86,-9.52,-9.24,-8.88,-8.53,-8.05,-7.40,-6.60,-5.51,-4.26,-2.80,-1.13,0.75,0.96,1,1,1,1,1,1,1.97,1.87,2.21,2.50,2.75,2.95,3.12,3.50,3.96,4.49,5,5.52,6,6.39,6.75,7,7.21,7.37,7.60,7.82,8.01,8.25,8.49,8.72,8.90,9.12,9.35,9.52,9.75,10,10.20,10.37,10.57,10.75,11.12,11.51,12.02,12.47,12.75,12.86,12.87,12.88,12.89,12.87,12.84,12.76,12.58,12.12,11.57,10.96,10.46,10.11,9.87,9.73,9.58,9.38,9.25,9.12,9.02,9,9,9,9,9,9.08,9.13,9.27,9.48,9.70,9.96,10.23,10.50,10.75,11.09,11.37,11.73,12,12.27,12.50,12.71,12.85,12.95,13,13.02,13.10,13.14,13.26,13.47,13.64,13.87,14,14.09,14.01,13.87,13.59,13.24,12.86,12.48,12.08,11.64,11.27,10.97,10.70,10.71,11.12,11.82,12.50,13.32,14.12,15,15.77,16.50,17.02,17.46,17.70,17.87,17.90,17.84,17.60,17.23,16.75,16.33,15.96,15.75,15.74,15.88,16.21,16.60,17,17.50,17.96,18.37,18.73,19.02,19.35,19.57,19.65,19.70,19.63,19.59,19.40,19.13,18.71,18.09,17.34,16.50,15.65,14.88,14.32,14.08,14.02,14.27,14.73,15.25,15.85,16.36,16.70,16.77,16.70,16.47,16.24,16.09,16,15.97,15.87,15.75,15.50,15.12,14.64,14.14,13.65,13.21,12.62,12,11.34,10.72,10.20,9.72,9.13,8.46,7.52,6.46,5.09,3.50,1.70,0.61,-0.02,-0.72,-1.51,-2.24,-2.72,-2.51,-1.73,-0.61,-0.10,0.49,1.21,2.02,3,3.99,4.99,6,7.01,8.12,9.24,10.37,11.38,12.09,12.51,12.88,12.99,12.76,12.38,12,11.64,11.46,11.37,11.37,11.40,11.58,11.83,12.24,12.82,13.49,14.22,14.87,15.25,15.48,15.37,15.12,14.83,14.50,14.34,14.33,14.50,14.88,15.46,16.07,16.65,17.25,17.75,18.24,18.64,19.12,19.61,20.48,20.50,20.57,20,19.62,18.85,18.22,17.83,17.12,16.12,16,15.95,-10,-10,-11,-12,-13,-14,-15,-17,-18,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-17,-16,-15,-14,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-9.74,-9.41,-9.13,-8.88,-8.61,-8.28,-7.92,-7.30,-6.49,-5.26,-4,-2.54,-1,0.75,0.96,1,1,1,1,1,1,1.95,2,2.27,2.59,2.86,3,3.20,3.50,4.08,4.63,5.25,5.84,6.35,6.75,7.10,7.35,7.58,7.75,8,8.25,8.50,8.74,8.98,9.22,9.46,9.65,9.89,10.13,10.37,10.62,10.85,11.01,11.24,11.47,11.75,12.22,12.71,13.13,13.49,13.62,13.64,13.65,13.65,13.62,13.50,13.32,13.25,12.63,11.86,11.13,10.61,10.24,10,9.87,9.75,9.60,9.39,9.25,9.12,9.02,9,8.99,8.98,8.99,9,9.08,9.15,9.34,9.51,9.77,10.02,10.32,10.59,10.87,11.21,11.50,11.84,12.12,12.35,12.51,12.71,12.83,12.88,12.97,13,13.10,13.20,13.27,13.38,13.48,13.50,13.38,13.22,12.88,12.58,12.23,11.86,11.48,11.11,10.77,10.52,10.40,10.50,10.87,11.49,12.26,13.14,14.10,14.99,15.82,16.57,17.20,17.70,18.02,18.25,18.39,18.46,18.33,18.02,17.62,17.12,16.62,16.24,16,15.90,16,16.20,16.38,16.63,16.95,17.25,17.52,17.86,18.13,18.47,18.73,18.90,19.11,19.25,19.40,19.50,19.48,19.12,18.48,17.62,16.75,15.89,15.14,14.70,14.52,14.62,15,15.50,16.08,16.62,17.10,17.35,17.32,17.02,16.70,16.37,16.12,16.02,15.99,15.89,15.77,15.57,15.21,14.75,14.25,13.74,13.25,12.72,12.12,11.57,11.02,10.62,10.22,9.71,9,8.09,6.96,5.59,4,2.32,1.09,0.27,-0.41,-1.23,-2.02,-2.58,-2.67,-2.14,-1.42,-0.46,0.38,1.12,2,2.99,3.98,4.99,6,7.07,8.12,9.14,10.15,11.09,11.82,12.37,12.77,12.90,12.76,12.49,12.12,11.85,11.64,11.62,11.62,11.71,11.76,11.90,12.15,12.51,13,13.52,14.07,14.39,14.60,14.58,14.38,14.15,13.98,13.87,13.90,14.21,14.63,15.25,15.95,16.62,17.25,17.85,18.27,18.64,19,19.46,19.82,20.07,19.96,19.61,18.96,18.26,17.75,17.20,16.84,16.12,15.87,14.90,-10,-11,-11,-12,-13,-14,-16,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-17,-16,-15,-14,-13,-12,-12,-12,-11,-11,-10,-10,-10,-10,-10,-9.66,-9.38,-9.03,-8.75,-8.50,-8.29,-8.13,-7.88,-7.36,-6.42,-5.14,-3.75,-2.40,-1,0.75,0.96,1,1,1,1,1,1,1.95,2,2.33,2.62,2.87,3.02,3.25,3.62,4.15,4.83,5.50,6.12,6.65,7.12,7.40,7.70,7.90,8.14,8.40,8.71,8.98,9.24,9.49,9.75,10,10.26,10.51,10.75,11,11.25,11.50,11.73,11.88,12.12,12.38,12.84,13.27,13.75,14.11,14.23,14.25,14.25,14.24,14.12,13.90,13.62,13.21,12.62,11.98,11.25,10.73,10.37,10.20,10.09,9.96,9.76,9.61,9.40,9.25,9.12,9,8.97,8.90,8.90,8.96,9,9.10,9.25,9.46,9.70,9.95,10.20,10.46,10.75,11.08,11.37,11.71,11.98,12.22,12.39,12.61,12.75,12.85,12.88,12.97,13,13.08,13.12,13.12,13.08,12.88,12.62,12.32,11.96,11.60,11.25,10.88,10.59,10.32,10.10,9.98,10.11,10.50,11.15,12,12.88,13.87,14.87,15.75,16.61,17.32,17.88,18.37,18.73,18.90,19.02,19.09,18.90,18.61,18.11,17.50,16.88,16.46,16.20,16.10,16.10,16.12,16.12,16.21,16.27,16.46,16.62,16.87,17.14,17.47,17.75,18.07,18.37,18.75,19.11,19.37,19.49,19.21,18.58,17.72,16.87,16.10,15.46,15,15.08,15.25,15.72,16.25,16.82,17.36,17.75,17.89,17.75,17.37,16.95,16.51,16.25,16.12,16,15.96,15.83,15.58,15.22,14.75,14.25,13.75,13.27,12.83,12.35,11.87,11.47,11.10,10.71,10.15,9.46,8.49,7.26,5.87,4.37,2.88,1.60,0.72,-0.05,-0.86,-1.68,-2.35,-2.73,-2.55,-1.96,-0.92,0.13,1.12,1.99,2.97,3.95,4.97,6,7,8,8.88,9.76,10.61,11.27,11.87,12.35,12.61,12.62,12.45,12.20,11.97,11.85,11.84,11.87,11.98,12,12.08,12.14,12.35,12.62,13,13.37,13.62,13.75,13.75,13.63,13.50,13.37,13.35,13.49,13.82,14.35,15.01,15.77,16.57,17.34,17.97,18.37,18.50,18.62,18.85,19.12,19.50,19.57,18.89,18.34,17.75,17.22,16.77,16.14,15.86,15.12,14.89,-10,-11,-12,-13,-14,-14,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-16,-16,-15,-14,-13,-12,-12,-12,-11,-11,-10,-10,-10,-10,-9.73,-9.38,-9.01,-8.73,-8.42,-8.16,-8.03,-7.92,-7.88,-7.38,-6.37,-4.90,-3.41,-2.15,-0.87,0.75,0.96,1,1,1,1,1,1,1.95,2,2.25,2.62,2.90,3.12,3.37,3.82,4.37,5,5.74,6.39,6.95,7.37,7.75,8,8.26,8.57,8.86,9.13,9.46,9.75,10,10.33,10.62,10.87,11.13,11.39,11.70,11.96,12.21,12.38,12.60,12.76,13.08,13.45,13.87,14.25,14.50,14.58,14.58,14.51,14.47,14.27,14,13.62,13.12,12.59,11.98,11.36,10.87,10.62,10.48,10.33,10.15,10,9.77,9.59,9.37,9.20,9.02,8.95,8.87,8.86,8.87,8.96,9.08,9.24,9.39,9.62,9.87,10.12,10.37,10.70,11,11.34,11.62,11.87,12.12,12.35,12.50,12.65,12.76,12.87,12.88,12.90,12.90,12.87,12.82,12.60,12.25,11.83,11.37,10.98,10.62,10.33,10.09,9.87,9.71,9.62,9.74,10.12,10.77,11.62,12.62,13.60,14.59,15.57,16.46,17.25,17.89,18.50,19.02,19.37,19.61,19.72,19.75,19.57,19.14,18.50,17.75,17.07,16.51,16.25,16.15,16.12,16,15.77,15.64,15.62,15.62,15.75,15.90,16.14,16.47,16.82,17.22,17.70,18.21,18.71,19.10,19.25,19,18.45,17.64,16.88,16.25,15.75,15.50,15.62,15.95,16.38,16.96,17.50,17.99,18.33,18.37,18.14,17.73,17.23,16.75,16.46,16.25,16.12,15.99,15.84,15.58,15.21,14.75,14.25,13.77,13.37,13,12.62,12.25,11.87,11.50,11.12,10.57,9.77,8.75,7.50,6.12,4.62,3.25,2.01,1.12,0.35,-0.45,-1.27,-2.03,-2.61,-2.83,-2.41,-1.28,-0.14,1.12,1.97,2.87,3.87,4.87,5.95,6.83,7.72,8.51,9.25,10,10.62,11.25,11.74,12.08,12.21,12.14,12.01,11.88,11.86,11.87,12,12.11,12.13,12.13,12.12,12.21,12.35,12.52,12.75,12.88,12.98,12.96,12.86,12.75,12.65,12.73,12.88,13.27,13.87,14.73,15.58,16.37,17.14,18.37,18.38,18.01,17.98,18.08,18.34,18.58,18.59,18.25,17.75,17.24,16.75,16.22,15.82,15.12,14.87,14.88,-10,-11,-12,-13,-14,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-16,-15,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,-9.80,-9.43,-9.10,-8.75,-8.41,-8.16,-7.98,-7.78,-7.73,-7.74,-7.13,-5.89,-4.38,-2.88,-1.64,-0.63,0.83,0.97,1,1,1,1,1,1,1.90,2,2.12,2.62,2.97,3.20,3.50,4,4.58,5.23,5.90,6.62,7.23,7.64,8,8.32,8.62,8.90,9.25,9.60,9.90,10.25,10.58,10.87,11.15,11.49,11.75,12.02,12.34,12.62,12.87,13.10,13.25,13.46,13.70,14,14.37,14.62,14.72,14.64,14.61,14.50,14.37,14.15,13.87,13.46,12.99,12.50,11.99,11.51,11.14,10.90,10.75,10.61,10.40,10.23,10,9.74,9.48,9.25,9.01,8.87,8.76,8.75,8.77,8.87,9.02,9.24,9.45,9.64,9.87,10.12,10.37,10.65,11,11.33,11.62,11.87,12.11,12.32,12.50,12.62,12.75,12.84,12.86,12.83,12.74,12.59,12.36,12.07,11.50,10.97,10.47,10.02,9.75,9.57,9.45,9.37,9.36,9.51,9.98,10.57,11.34,12.25,13.25,14.25,15.21,16.10,16.95,17.71,18.37,18.99,19.58,19.96,20.14,20.25,20.33,20.02,19.58,18.75,17.86,17,16.37,16.07,16.08,15.99,15.75,15.33,15.01,14.87,14.83,14.87,15,15.24,15.57,15.97,16.48,17.08,17.72,18.27,18.75,18.89,18.75,18.25,17.62,17,16.50,16.20,16.10,16.26,16.62,17.11,17.60,18.08,18.47,18.70,18.65,18.45,18,17.51,17.10,16.74,16.46,16.24,16.02,15.86,15.58,15.21,14.75,14.27,13.87,13.58,13.25,12.99,12.62,12.26,11.87,11.40,10.84,10,8.95,7.64,6.25,4.85,3.51,2.36,1.52,0.76,0.02,-0.75,-1.70,-2.49,-2.72,-2.39,-1.55,-0.48,0.74,1.74,2.61,3.59,4.75,5.62,6.49,7.36,8.01,8.72,9.35,9.95,10.51,11,11.38,11.50,11.48,11.40,11.37,11.39,11.50,11.62,11.75,11.86,11.87,11.89,11.96,12,12.13,12.20,12.23,12.20,12.12,12,11.90,11.87,11.98,12.21,12.61,13.25,14.13,15.37,15.87,16.60,17.38,17.40,17.12,17.12,17.25,17.47,17.64,17.75,17.62,17.33,16.87,16.35,15.72,15.01,14.25,14.11,13.87,-10,-11,-12,-13,-14,-15,-16,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-14,-14,-13,-13,-13,-12,-11,-11,-10,-10,-10,-9.63,-9.25,-8.87,-8.50,-8.23,-7.99,-7.76,-7.55,-7.38,-7.25,-6.38,-5,-3.29,-1.90,-0.88,-0.13,0.87,0.98,1,1,1,1,1,1,1.95,2,2.12,2.75,3,3.25,3.63,4.13,4.75,5.37,6.09,6.75,7.34,7.77,8.15,8.50,8.87,9.23,9.59,9.95,10.27,10.64,10.99,11.33,11.64,12,12.33,12.62,12.96,13.25,13.51,13.75,13.90,14.08,14.24,14.45,14.62,14.71,14.62,14.51,14.37,14.24,14.09,13.87,13.59,13.25,12.86,12.45,12.07,11.72,11.45,11.23,11.02,10.87,10.70,10.46,10.14,9.87,9.57,9.25,9,8.82,8.70,8.63,8.72,8.86,9.01,9.25,9.50,9.73,9.96,10.15,10.40,10.73,11.02,11.35,11.62,11.87,12.10,12.27,12.49,12.62,12.75,12.76,12.75,12.62,12.40,12.12,11.75,11.25,10.64,10.09,9.60,9.25,9.08,9.01,9.10,9.24,9.49,9.96,10.50,11.15,12,12.87,13.86,14.76,15.65,16.48,17.25,17.99,18.63,19.26,19.87,20.26,20.51,20.62,20.63,20.27,19.70,18.74,17.64,16.70,15.97,15.59,15.52,15.45,15.14,14.64,14.33,14.11,14,14.01,14.15,14.45,14.82,15.27,15.88,16.62,17.35,18,18.48,18.65,18.58,18.20,17.70,17.22,16.87,16.71,16.72,16.96,17.32,17.75,18.12,18.49,18.73,18.82,18.75,18.51,18.22,17.84,17.46,17.09,16.73,16.38,16.12,15.87,15.59,15.22,14.75,14.36,14,13.77,13.61,13.37,13.02,12.63,12.20,11.62,10.96,10.09,9,7.75,6.38,5.08,3.84,2.65,1.87,1.15,0.46,-0.35,-1.21,-2,-2.39,-2.36,-1.82,-0.97,0.22,1.27,2.12,2.98,3.90,4.87,5.75,6.64,7.47,8.12,8.62,9.14,9.75,10.12,10.46,10.61,10.62,10.62,10.62,10.74,10.87,11.02,11.23,11.36,11.45,11.50,11.52,11.59,11.59,11.57,11.50,11.39,11.26,11.13,11.08,11.02,11.12,11.35,11.74,12.37,13.25,14.38,14.97,15.52,15.85,16,16.01,16.12,16.34,16.62,16.87,17.09,17.12,16.98,16.62,16.07,15.34,14.51,13.87,13.36,12.75,-10,-11,-12,-14,-15,-15,-16,-17,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-14,-14,-13,-13,-13,-12,-11,-11,-10,-10,-9.80,-9.41,-9.02,-8.64,-8.35,-8.05,-7.87,-7.63,-7.38,-6.92,-6.42,-5.11,-3.42,-1.76,-0.63,-0.01,0.50,0.87,0.99,1,1,2,1,1,1,1.95,2,2.12,2.83,3,3.33,3.75,4.25,4.86,5.50,6.13,6.77,7.37,7.87,8.26,8.64,9.07,9.46,9.84,10.22,10.61,10.99,11.32,11.64,12,12.37,12.75,13.12,13.50,13.85,14.12,14.37,14.50,14.59,14.62,14.64,14.62,14.52,14.37,14.20,14,13.87,13.74,13.57,13.34,13.07,12.75,12.47,12.14,11.88,11.65,11.50,11.35,11.13,10.95,10.63,10.34,9.98,9.61,9.25,8.95,8.71,8.58,8.52,8.62,8.84,9.08,9.33,9.58,9.82,10.02,10.26,10.50,10.82,11.12,11.37,11.63,11.87,12.10,12.27,12.49,12.62,12.71,12.71,12.60,12.37,12,11.58,11,10.40,9.83,9.25,8.87,8.65,8.63,8.87,9.12,9.47,9.99,10.57,11.23,11.95,12.71,13.50,14.35,15.20,16,16.75,17.50,18.15,18.84,19.38,19.95,20.33,20.62,20.84,20.84,20.25,19.50,18.39,17.25,16.12,15.27,14.77,14.64,14.51,14.26,13.85,13.50,13.26,13.22,13.26,13.50,13.83,14.25,14.86,15.52,16.34,17.12,17.84,18.36,18.62,18.58,18.26,17.88,17.57,17.33,17.25,17.34,17.57,17.87,18.32,18.50,18.71,18.74,18.64,18.57,18.40,18.25,18.07,17.76,17.45,17,16.62,16.25,15.90,15.60,15.20,14.75,14.37,14.12,14,13.90,13.75,13.38,12.96,12.37,11.75,10.99,10.07,9,7.85,6.60,5.35,4.13,3.11,2.27,1.58,0.85,0.09,-0.67,-1.37,-1.91,-2.30,-2.26,-1.67,-0.72,0.43,1.32,2,2.77,3.72,4.70,5.76,6.75,7.48,7.76,8.21,8.64,9.12,9.39,9.50,9.51,9.52,9.60,9.72,9.87,10.10,10.33,10.50,10.65,10.83,10.88,10.95,10.89,10.86,10.75,10.64,10.50,10.36,10.25,10.21,10.24,10.37,10.71,11.25,12.01,12.86,13.59,14.25,14.48,14.62,14.83,15.02,15.37,15.75,16.13,16.48,16.63,16.72,16.47,15.88,15.14,14.37,13.65,13.20,12.58,-11,-12,-13,-14,-15,-16,-17,-17,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-18,-17,-16,-15,-14,-14,-13,-12,-12,-11,-11,-10,-10,-10,-9.63,-9.24,-8.86,-8.50,-8.23,-8,-7.75,-7.50,-7.25,-6.50,-5.38,-3.63,-1.50,-0.25,0.32,0.62,0.88,0.99,1,1,1,1,1,1,1,1.95,2,2.12,2.85,3,3.33,3.75,4.32,4.89,5.57,6.21,6.83,7.37,7.87,8.35,8.75,9.20,9.61,10,10.38,10.82,11.13,11.50,11.87,12.25,12.63,13.08,13.50,13.97,14.32,14.57,14.74,14.95,14.98,14.88,14.75,14.51,14.26,14.01,13.83,13.62,13.51,13.45,13.32,13.12,12.96,12.75,12.50,12.26,12.09,11.88,11.75,11.60,11.38,11.13,10.86,10.48,10.02,9.62,9.22,8.86,8.60,8.47,8.47,8.60,8.84,9.12,9.39,9.70,9.96,10.20,10.40,10.64,10.90,11.22,11.47,11.71,11.87,12.10,12.26,12.46,12.58,12.62,12.52,12.35,11.99,11.50,10.89,10.26,9.63,9.10,8.62,8.37,8.46,8.65,9.02,9.50,10.02,10.62,11.36,12.01,12.74,13.46,14.13,14.87,15.59,16.27,17,17.64,18.24,18.73,19.14,19.65,20.08,20.48,20.75,20.75,20.01,19.12,17.95,16.65,15.48,14.49,13.86,13.57,13.38,13.23,12.90,12.63,12.48,12.48,12.62,12.97,13.38,13.98,14.62,15.39,16.25,17.10,17.85,18.38,18.72,18.74,18.51,18.23,17.95,17.75,17.74,17.84,17.99,18.32,18.65,18.63,18.62,18.50,18.33,18.20,18.12,18.12,18.12,18.01,17.75,17.27,16.76,16.33,15.88,15.50,15.09,14.62,14.25,14.08,14.02,14.07,13.89,13.58,13.08,12.50,11.83,11,10.07,9,7.90,6.75,5.62,4.50,3.50,2.75,2,1.27,0.59,-0.13,-0.83,-1.48,-2.15,-2.50,-2.50,-1.97,-1.04,-0.02,0.91,1.59,2.37,3.37,4.47,5.57,6.37,6.59,7,7.46,7.87,8.12,8.21,8.22,8.24,8.27,8.45,8.62,8.87,9.12,9.38,9.62,9.87,10,10.10,10.10,10.08,10,9.95,9.84,9.63,9.50,9.46,9.37,9.37,9.50,10.02,10.72,11.46,12.12,12.62,13,13.32,13.59,13.90,14.37,14.87,15.37,15.86,16.14,16.37,16.25,15.87,15.25,14.50,13.75,13.14,12.37,-11,-12,-13,-14,-15,-16,-17,-18,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-17,-16,-15,-15,-14,-13,-13,-12,-12,-11,-11,-10,-10,-9.79,-9.39,-9.01,-8.63,-8.35,-8.11,-7.89,-7.65,-7.36,-7,-5.91,-4.30,-2.14,-0.25,0.73,0.82,0.87,0.98,1,1,1,1,1,1,1,1,1.97,2,2.12,2.85,3,3.21,3.75,4.34,4.96,5.60,6.23,6.83,7.37,7.87,8.36,8.82,9.25,9.65,10.10,10.50,10.87,11.25,11.62,12,12.37,12.75,13.24,13.73,14.21,14.50,14.72,14.87,15,15.09,14.98,14.62,14.37,14.10,13.83,13.60,13.40,13.33,13.24,13.12,13.02,12.90,12.75,12.61,12.40,12.25,12.11,11.96,11.77,11.61,11.35,11,10.59,10.11,9.62,9.13,8.75,8.50,8.37,8.37,8.58,8.87,9.21,9.51,9.86,10.12,10.37,10.60,10.82,11.01,11.26,11.50,11.72,11.87,12.08,12.25,12.37,12.46,12.40,12.26,11.97,11.49,10.87,10.23,9.59,9,8.57,8.32,8.32,8.57,9,9.52,10.13,10.84,11.48,12.12,12.84,13.50,14.14,14.75,15.37,15.96,16.58,17.22,17.75,18.13,18.40,18.64,19,19.48,20.12,20.60,20.50,19.62,18.62,17.39,16.09,14.75,13.62,12.87,12.49,12.32,12.15,12,11.83,11.75,11.86,12.14,12.62,13.24,13.88,14.63,15.49,16.36,17.22,18,18.62,18.98,19.01,18.86,18.50,18.23,18,17.96,18,18.12,18.36,18.59,18.46,18.33,18.09,17.84,17.71,17.74,17.87,18.08,18.12,17.87,17.40,16.85,16.25,15.75,15.25,14.75,14.27,13.90,13.75,13.75,13.76,13.65,13.37,12.96,12.45,11.82,11.08,10.12,9.12,8,6.89,5.85,4.82,3.90,3.13,2.40,1.74,1.07,0.45,-0.13,-0.80,-1.72,-2.27,-2.73,-2.68,-2.05,-1.07,-0.12,0.35,0.95,1.90,3.12,4.12,4.75,5.25,5.63,6.07,6.37,6.60,6.70,6.73,6.75,6.84,6.98,7.21,7.49,7.82,8.12,8.47,8.75,8.96,9.11,9.21,9.25,9.25,9.24,9.14,9.09,8.90,8.76,8.64,8.45,8.46,8.96,9.57,10.12,10.72,11.21,11.62,11.98,12.35,12.77,13.36,13.99,14.62,15.14,15.62,15.89,16,15.82,15.37,14.73,13.87,13.10,12.22,-11,-12,-13,-14,-15,-16,-17,-18,-18,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-18,-18,-17,-16,-15,-14,-13,-13,-12,-12,-11,-11,-10,-10,-9.99,-9.55,-9.16,-8.79,-8.49,-8.15,-8,-7.77,-7.50,-7,-6.41,-4.88,-3.12,-1.27,0.09,0.85,0.96,0.97,0.99,1,1,1,1,1,1,1,1,1.97,2,2.11,2.86,3,3.27,3.75,4.33,4.95,5.59,6.23,6.82,7.37,7.87,8.34,8.76,9.24,9.64,10.10,10.50,10.86,11.24,11.61,11.98,12.37,12.75,13.23,13.72,14.12,14.49,14.65,14.87,14.99,14.88,14.75,14.50,14.25,13.96,13.64,13.45,13.26,13.20,13.12,13.09,13,12.96,12.85,12.73,12.59,12.45,12.25,12.12,11.97,11.75,11.49,11.12,10.63,10.12,9.60,9.10,8.70,8.38,8.25,8.34,8.52,8.87,9.27,9.71,10.02,10.35,10.59,10.75,10.96,11.12,11.33,11.50,11.65,11.84,12,12.12,12.22,12.23,12.11,11.85,11.38,10.85,10.15,9.51,8.97,8.50,8.25,8.25,8.50,8.98,9.59,10.27,10.98,11.62,12.25,12.88,13.58,14.23,14.84,15.34,15.75,16.24,16.75,17.25,17.63,17.84,17.86,17.89,18.20,18.65,19.26,19.95,19.98,19.12,18.13,16.90,15.58,14.13,12.87,11.97,11.48,11.25,11.14,11.10,11.07,11.12,11.40,11.88,12.51,13.25,14.07,14.87,15.75,16.62,17.50,18.26,18.89,19.34,19.38,19.13,18.72,18.25,17.96,17.77,17.75,17.83,17.95,18.08,17.90,17.76,17.52,17.32,17.15,17.25,17.49,17.77,17.98,17.83,17.34,16.65,16,15.37,14.77,14.25,13.75,13.37,13.14,13.12,13.12,13.01,12.84,12.51,12.12,11.62,11.09,10.33,9.38,8.35,7.21,6.08,5,4.12,3.40,2.75,2.09,1.49,0.95,0.59,-0.09,-0.97,-1.88,-2.75,-3.07,-2.66,-1.70,-0.73,0,0.62,1.34,2.10,2.87,3.46,3.88,4.33,4.63,4.89,5.09,5.12,5.15,5.22,5.26,5.45,5.70,6,6.37,6.77,7.21,7.52,7.84,8.08,8.25,8.37,8.49,8.50,8.50,8.47,8.37,8.25,8.09,7.89,7.87,8.12,8.50,8.97,9.45,9.87,10.25,10.64,11.11,11.62,12.32,13.07,13.76,14.40,14.89,15.25,15.38,15.37,15.14,14.73,13.62,12.75,11.08,-12,-13,-14,-15,-16,-16,-17,-18,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-16,-15,-15,-14,-13,-12,-12,-11,-11,-10,-10,-10,-9.74,-9.30,-8.91,-8.60,-8.27,-8.02,-7.88,-7.63,-7.15,-6.38,-5.35,-3.62,-1.75,-0.37,0.37,0.87,0.98,0.98,0.99,1,1,1,1,1,1,1,1,1.99,2,2.09,2.87,2.90,3.26,3.74,4.26,4.88,5.50,6.12,6.75,7.27,7.77,8.25,8.74,9.15,9.61,10,10.37,10.74,11.10,11.47,11.85,12.24,12.62,13.08,13.50,13.88,14.25,14.49,14.61,14.70,14.71,14.59,14.37,14.12,13.86,13.60,13.37,13.23,13.12,13.10,13.08,13.07,13,12.96,12.87,12.75,12.62,12.46,12.26,12.10,11.87,11.61,11.23,10.74,10.13,9.59,9.02,8.62,8.33,8.15,8.25,8.50,8.88,9.37,9.87,10.25,10.59,10.83,11,11.11,11.20,11.32,11.46,11.59,11.73,11.86,11.90,11.95,11.84,11.59,11.20,10.64,10.08,9.46,8.88,8.50,8.25,8.25,8.50,8.98,9.62,10.37,11.11,11.77,12.40,13,13.61,14.21,14.77,15.27,15.71,16,16.34,16.72,17.07,17.25,17.22,17.02,16.99,17.14,17.63,18.32,18.88,19.12,18.62,17.64,16.51,15.21,13.74,12.34,11.25,10.62,10.34,10.24,10.25,10.40,10.74,11.22,11.86,12.62,13.49,14.37,15.25,16.14,17,17.87,18.62,19.25,19.71,19.72,19.33,18.63,18,17.51,17.25,17.12,17.12,17.24,17.25,17.24,17.12,16.98,16.75,16.62,16.73,16.99,17.36,17.59,17.48,16.99,16.26,15.52,14.84,14.14,13.58,13.02,12.64,12.46,12.36,12.27,12.22,12.08,11.87,11.62,11.24,10.82,10.26,9.60,8.64,7.46,6.23,5.02,4.22,3.50,2.95,2.26,1.75,1.32,0.88,0.46,-0.08,-1.23,-2.17,-2.67,-2.48,-1.73,-0.87,-0.23,0.26,0.84,1.46,2,2.39,2.75,3.10,3.35,3.51,3.62,3.70,3.72,3.75,3.82,3.97,4.22,4.57,5,5.48,5.96,6.37,6.74,7.02,7.32,7.51,7.71,7.82,7.86,7.86,7.77,7.73,7.64,7.36,7.45,7.51,7.74,8.01,8.37,8.73,9.07,9.40,9.87,10.49,11.25,12.10,12.87,13.58,14.09,14.40,14.57,14.50,14.34,13.75,12.96,12.10,10.95,-12,-13,-14,-15,-16,-17,-17,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-20,-20,-19,-19,-18,-17,-17,-16,-15,-14,-13,-13,-12,-12,-11,-11,-10,-10,-9.86,-9.48,-9.03,-8.65,-8.36,-8.12,-7.91,-7.76,-7.48,-6.73,-5.48,-4,-2.13,-0.37,0.37,0.73,0.87,0.99,0.99,1,1,1,1,1,1,1,1,1,2,2,2.07,2.14,2.82,3.22,3.65,4.22,4.82,5.45,6.07,6.62,7.13,7.64,8.12,8.60,9,9.40,9.82,10.20,10.50,10.87,11.24,11.62,12,12.37,12.77,13.21,13.58,13.87,14.11,14.26,14.38,14.40,14.37,14.25,14.07,13.83,13.60,13.37,13.24,13.13,13.12,13.12,13.12,13.11,13.08,13,12.89,12.76,12.62,12.46,12.25,12,11.73,11.33,10.82,10.22,9.60,9,8.52,8.22,8.01,8.09,8.35,8.77,9.37,9.97,10.39,10.75,11,11.22,11.21,11.20,11.24,11.33,11.45,11.52,11.62,11.62,11.50,11.25,10.87,10.37,9.83,9.25,8.75,8.37,8.22,8.25,8.50,8.98,9.62,10.39,11.21,11.97,12.62,13.21,13.65,14.12,14.62,15.12,15.52,15.83,16,16.20,16.38,16.59,16.62,16.40,16.20,15.98,16.02,16.50,17.12,17.64,17.88,17.77,17.12,16.21,14.96,13.50,12,10.75,9.97,9.57,9.46,9.59,9.90,10.46,11.12,11.89,12.85,13.83,14.82,15.75,16.62,17.48,18.25,18.96,19.52,19.88,19.76,19.20,18.32,17.48,16.85,16.45,16.25,16.21,16.25,16.37,16.46,16.48,16.37,16.23,16.10,16.12,16.37,16.75,17,16.89,16.46,15.74,14.97,14.22,13.51,12.95,12.46,12.09,11.86,11.72,11.61,11.49,11.35,11.15,10.95,10.58,10.21,9.87,9.37,8.75,7.52,6.34,5,4,3,2.87,2.39,2.01,1.62,1.25,0.87,0.39,-0.39,-1.17,-1.64,-1.63,-1.20,-0.65,-0.24,0.12,0.52,1.07,1.45,1.71,1.89,2.11,2.26,2.37,2.47,2.50,2.50,2.50,2.58,2.65,2.89,3.25,3.73,4.25,4.75,5.25,5.70,6.07,6.37,6.64,6.87,7.07,7.13,7.21,7.22,7.21,7.21,7.12,7.02,7.08,7.14,7.34,7.50,7.75,8,8.27,8.73,9.36,10.15,11.09,11.89,12.58,13,13.25,13.35,13.24,12.96,12.49,11.87,11.23,9.84,-12,-13,-14,-15,-16,-17,-18,-18,-19,-19,-20,-20,-20,-20,-20,-20,-20,-19,-19,-19,-18,-17,-17,-16,-15,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-9.63,-9.23,-8.76,-8.38,-8.13,-7.90,-7.78,-7.68,-7.15,-6.04,-4.50,-2.38,-0.92,0.25,0.87,0.87,0.97,0.99,1,1,1,1,1,1,1,1,1,1,2,2,2.02,2.33,2.65,3.12,3.59,4.10,4.63,5.25,5.87,6.46,7,7.50,7.98,8.39,8.84,9.22,9.59,9.90,10.24,10.59,10.90,11.27,11.64,12.07,12.45,12.82,13.12,13.45,13.71,13.90,14.09,14.15,14.21,14.12,14,13.85,13.62,13.47,13.32,13.22,13.15,13.20,13.21,13.21,13.20,13.13,13.09,12.98,12.83,12.62,12.40,12.15,11.87,11.48,10.95,10.33,9.63,9.01,8.50,8.11,7.86,7.83,8.01,8.50,9.11,9.75,10.25,10.62,10.96,11.13,11.12,11.09,11.09,11.12,11.24,11.27,11.27,11.20,10.97,10.60,10.10,9.50,8.98,8.50,8.15,8.07,8.12,8.45,8.95,9.61,10.39,11.23,12,12.76,13.37,13.82,14.13,14.50,14.87,15.24,15.50,15.71,15.76,15.86,15.89,15.95,15.87,15.64,15.37,15.07,15.01,15.37,15.89,16.37,16.74,16.75,16.47,15.84,14.74,13.34,11.77,10.50,9.58,9.01,8.87,9.09,9.57,10.24,11.07,12,13.09,14.20,15.25,16.25,17.11,17.84,18.50,19.12,19.61,19.76,19.48,18.70,17.64,16.72,15.98,15.50,15.25,15.15,15.25,15.45,15.61,15.75,15.75,15.62,15.45,15.46,15.65,16.02,16.32,16.25,15.84,15.13,14.39,13.73,13.12,12.61,12.14,11.84,11.59,11.37,11.21,10.99,10.75,10.57,10.26,9.88,9.46,9.12,8.62,8.22,7.38,6.22,5,4,3,2.87,2.62,2.34,2.01,1.74,1.37,1,0.51,0.01,-0.35,-0.47,-0.37,-0.16,0,0.20,0.52,0.87,1.11,1.26,1.40,1.51,1.62,1.70,1.72,1.72,1.70,1.65,1.71,1.75,1.96,2.24,2.63,3.13,3.71,4.23,4.65,5.10,5.45,5.75,5.99,6.21,6.37,6.48,6.50,6.50,6.62,6.62,6.58,6.52,6.60,6.70,6.83,6.97,7.12,7.25,7.63,8.25,9.12,10,10.83,11.39,11.82,11.99,11.99,11.83,11.51,11.12,10.64,10.11,8.75,-12,-13,-14,-15,-16,-17,-18,-18,-19,-19,-20,-20,-20,-20,-20,-19,-19,-19,-18,-18,-17,-16,-16,-15,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-9.93,-9.49,-9,-8.50,-8.13,-7.88,-7.75,-7.63,-7.41,-6.63,-5.23,-3.50,-1.50,0.61,0.75,0.88,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,2,2,2.07,2.33,2.62,3,3.46,3.90,4.47,5.01,5.62,6.20,6.75,7.25,7.74,8.14,8.58,8.90,9.25,9.62,9.89,10.25,10.59,10.90,11.26,11.62,12,12.36,12.70,13,13.26,13.52,13.75,13.90,14,14.08,14.01,13.90,13.75,13.61,13.45,13.32,13.25,13.24,13.25,13.25,13.26,13.26,13.25,13.13,13,12.86,12.62,12.38,12.11,11.70,11.12,10.50,9.82,9.12,8.50,8,7.62,7.50,7.60,8,8.52,9.13,9.73,10.14,10.52,10.76,10.82,10.84,10.87,10.89,10.99,11,10.87,10.64,10.27,9.83,9.25,8.71,8.22,7.87,7.77,7.90,8.25,8.84,9.51,10.37,11.23,12.01,12.82,13.46,13.88,14.21,14.39,14.63,14.88,15.13,15.33,15.37,15.38,15.37,15.36,15.32,15.22,15,14.74,14.38,14.25,14.45,14.83,15.24,15.51,15.74,15.62,15.25,14.40,13.12,11.64,10.37,9.37,8.75,8.57,8.75,9.25,10.01,11,12.10,13.26,14.50,15.63,16.62,17.37,18,18.52,19,19.36,19.34,18.84,17.88,16.82,15.77,15,14.50,14.15,14.12,14.24,14.39,14.62,14.86,14.88,14.83,14.64,14.71,14.98,15.36,15.62,15.62,15.26,14.72,14.10,13.50,13.07,12.63,12.32,12,11.71,11.39,11.12,10.76,10.49,10.20,9.87,9.48,8.96,8.45,7.87,7.40,6.63,5.87,4.87,4,3,3,2.87,2.71,2.51,2.34,2.09,1.76,1.50,1.16,0.86,0.64,0.52,0.46,0.37,0.39,0.62,0.82,0.96,1.08,1.15,1.26,1.37,1.46,1.40,1.35,1.25,1.23,1.23,1.25,1.37,1.58,1.87,2.26,2.75,3.25,3.70,4.10,4.39,4.71,4.90,5.12,5.27,5.37,5.45,5.57,5.71,5.87,5.90,5.97,6,6.08,6.20,6.33,6.46,6.60,6.87,7.40,8.21,8.99,9.70,10.20,10.50,10.60,10.51,10.35,10.08,9.75,9.39,9,7.65,-13,-13,-14,-15,-16,-17,-18,-18,-19,-19,-20,-20,-20,-20,-20,-19,-19,-18,-18,-17,-16,-16,-15,-15,-14,-13,-13,-12,-12,-12,-11,-11,-10,-10,-9.88,-9.36,-8.79,-8.25,-7.89,-7.68,-7.54,-7.38,-6.87,-5.73,-4.13,-2.38,-0.88,0.62,0.87,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2.02,2.27,2.60,2.90,3.32,3.75,4.25,4.76,5.36,5.89,6.48,7,7.48,7.87,8.25,8.62,8.97,9.25,9.58,9.87,10.20,10.50,10.86,11.21,11.52,11.87,12.24,12.57,12.87,13.15,13.47,13.71,13.87,14.01,14.11,14.10,13.99,13.82,13.62,13.40,13.32,13.25,13.25,13.25,13.34,13.37,13.37,13.35,13.25,13.11,12.87,12.64,12.37,11.98,11.40,10.77,10.11,9.39,8.73,8.10,7.52,7.15,7.12,7.37,7.87,8.45,9,9.51,9.96,10.25,10.39,10.50,10.60,10.63,10.65,10.62,10.40,10.08,9.59,9,8.48,7.99,7.62,7.50,7.62,8,8.61,9.37,10.25,11.14,12.07,12.85,13.50,13.96,14.25,14.37,14.48,14.60,14.74,14.87,14.98,14.99,14.90,14.85,14.75,14.71,14.62,14.50,14.33,14.07,13.87,13.84,13.97,14.22,14.50,14.73,14.83,14.61,14,12.87,11.50,10.25,9.25,8.61,8.36,8.50,9.01,9.85,10.87,12.10,13.37,14.71,15.87,16.77,17.40,17.87,18.33,18.64,18.84,18.62,18,17,15.87,14.83,14,13.47,13.14,13.12,13.20,13.35,13.52,13.75,13.85,13.84,13.82,13.98,14.34,14.76,15.12,15.15,14.96,14.51,14.09,13.70,13.37,13.09,12.75,12.47,12.11,11.73,11.32,10.87,10.49,10.12,9.77,9.38,8.77,8.11,7.45,6.87,6.22,5.26,4.88,4,3,3,3,3.23,3.13,3.08,2.95,2.75,2.57,2.34,2.02,1.73,1.45,1.12,0.87,0.84,0.84,0.87,0.89,0.99,1.09,1.22,1.35,1.38,1.37,1.24,1.12,1.02,1,1.02,1.10,1.21,1.37,1.64,2,2.37,2.75,3.09,3.36,3.57,3.73,3.85,3.90,4,4.13,4.37,4.64,4.96,5.21,5.25,5.36,5.45,5.60,5.75,5.96,6.12,6.37,6.83,7.37,8,8.51,8.87,9.11,9.12,9.07,8.87,8.63,8.38,8.22,7.87,6.62,-13,-14,-14,-15,-16,-17,-17,-18,-19,-19,-19,-19,-20,-19,-19,-19,-18,-18,-18,-16,-16,-15,-15,-14,-14,-13,-13,-12,-12,-12,-11,-11,-10,-10,-9.88,-9.26,-8.65,-8.03,-7.68,-7.51,-7.38,-7.25,-6.38,-4.80,-2.65,-1.38,-0.38,0.62,0.87,1,1,1,1,1,1,1,1,1,1,2,1,1,1,2,2,2.07,2.25,2.50,2.82,3.13,3.57,4,4.51,5.10,5.63,6.22,6.74,7.21,7.62,7.99,8.33,8.62,8.95,9.23,9.50,9.77,10.11,10.40,10.75,11.10,11.40,11.75,12.12,12.48,12.82,13.12,13.48,13.75,14,14.22,14.27,14.25,14.09,13.84,13.58,13.36,13.24,13.20,13.23,13.27,13.37,13.49,13.50,13.48,13.36,13.15,12.95,12.62,12.25,11.75,11.20,10.51,9.87,9.12,8.36,7.62,7.08,6.76,6.83,7.20,7.71,8.25,8.86,9.37,9.75,10.07,10.24,10.33,10.35,10.35,10.20,9.99,9.37,8.77,8.25,7.75,7.38,7.25,7.36,7.73,8.33,9.10,10,11,11.98,12.87,13.61,14.11,14.37,14.39,14.37,14.36,14.36,14.37,14.47,14.50,14.49,14.37,14.25,14.13,14.12,14.12,14.12,14.07,13.89,13.75,13.51,13.39,13.39,13.57,13.77,13.98,13.88,13.49,12.50,11.26,10.12,9.12,8.45,8.12,8.25,8.75,9.62,10.75,12,13.36,14.62,15.75,16.59,17.12,17.50,17.85,18.12,18.21,17.89,17.23,16.13,14.96,13.85,13,12.37,12.14,12.12,12.13,12.25,12.39,12.60,12.71,12.82,13,13.37,13.90,14.48,14.87,15,14.89,14.64,14.37,14.12,13.88,13.65,13.37,13.02,12.62,12.14,11.64,11.20,10.75,10.38,10.09,9.65,9.09,8.25,7.51,6.75,6,5.11,4,4,3,3,4,3.75,3.85,3.88,3.89,3.87,3.82,3.63,3.37,2.98,2.46,1.89,1.47,1.23,1.07,0.98,0.96,0.97,1,1.10,1.22,1.34,1.25,1.13,1.02,1,0.99,0.99,1,1.02,1.12,1.25,1.49,1.73,1.98,2.20,2.37,2.48,2.57,2.61,2.62,2.62,2.84,3.21,3.63,4.02,4.38,4.57,4.62,4.75,4.97,5.24,5.50,5.77,6.07,6.37,6.75,7.12,7.45,7.62,7.73,7.72,7.62,7.48,7.33,7.14,7.08,6.87,5.58,-13,-14,-14,-15,-16,-17,-17,-18,-18,-19,-19,-19,-19,-19,-19,-19,-18,-17,-17,-16,-15,-15,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-9.27,-8.60,-7.87,-7.50,-7.37,-7.25,-7.12,-6,-4.25,-2.17,-0.39,0.25,0.62,0.88,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2.02,2.14,2.37,2.64,3,3.37,3.83,4.32,4.86,5.38,5.97,6.49,6.95,7.35,7.71,8,8.34,8.62,8.87,9.12,9.39,9.71,10,10.33,10.62,10.99,11.34,11.70,12.07,12.45,12.84,13.24,13.62,14,14.33,14.50,14.50,14.36,14.07,13.71,13.37,13.14,13.10,13.11,13.21,13.37,13.50,13.62,13.64,13.60,13.39,13.15,12.87,12.50,12.10,11.61,11.08,10.46,9.70,8.82,7.88,7.12,6.61,6.39,6.63,7.07,7.60,8.22,8.84,9.37,9.77,10,10.07,10,9.87,9.60,9.24,8.59,7.99,7.50,7.15,7,7.08,7.39,8.01,8.82,9.72,10.71,11.70,12.64,13.50,14.20,14.52,14.62,14.50,14.32,14.11,13.97,13.89,13.90,13.95,13.87,13.76,13.62,13.51,13.50,13.61,13.75,13.86,13.86,13.73,13.49,13.13,12.88,12.83,12.97,13.12,13.14,12.83,12.09,11,9.87,8.88,8.14,7.85,7.98,8.52,9.46,10.61,11.87,13.14,14.35,15.32,16,16.49,16.86,17.22,17.50,17.61,17.34,16.59,15.40,14.11,12.87,11.87,11.38,11.22,11.15,11.23,11.33,11.40,11.61,11.86,12.12,12.60,13.15,13.87,14.50,14.96,15.15,15.15,15.07,14.87,14.71,14.50,14.27,13.99,13.60,13.12,12.62,12.11,11.63,11.27,10.98,10.61,10.12,9.52,8.72,7.86,6.87,6,5,4,4,4,4,4,4.27,4.58,4.77,4.98,5.11,5.13,5.12,4.87,4.34,3.50,2.73,2.01,1.61,1.32,1.12,1,0.97,0.89,0.87,0.86,0.87,0.89,0.89,0.89,0.90,0.97,0.98,0.99,1,1,1.10,1.15,1.27,1.40,1.51,1.62,1.63,1.65,1.64,1.63,1.63,1.85,2.24,2.75,3.20,3.57,3.76,3.87,4,4.25,4.62,5.09,5.49,5.77,6.01,6.24,6.37,6.40,6.45,6.39,6.37,6.27,6.21,6.12,6.02,6,5.86,4.50,-13,-14,-14,-15,-16,-16,-17,-18,-18,-18,-19,-19,-19,-19,-19,-18,-17,-17,-16,-15,-15,-15,-14,-14,-13,-13,-13,-12,-12,-12,-12,-11,-11,-10,-10,-9.38,-8.62,-7.92,-7.50,-7.26,-7.13,-6.74,-5.75,-4.13,-1.88,-0.27,0.50,0.73,0.87,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2.10,2.25,2.50,2.85,3.23,3.62,4.11,4.62,5.15,5.73,6.24,6.65,7.08,7.40,7.75,8.02,8.33,8.58,8.82,9.07,9.35,9.62,9.88,10.24,10.58,10.89,11.25,11.64,12.08,12.50,12.98,13.46,13.95,14.37,14.63,14.75,14.60,14.25,13.82,13.37,13.08,12.89,12.89,13.01,13.25,13.50,13.70,13.76,13.75,13.60,13.35,13.01,12.70,12.33,11.90,11.50,11,10.23,9.26,8.25,7.37,6.63,6.25,6.25,6.50,6.90,7.57,8.27,9.01,9.59,9.83,9.85,9.63,9.37,8.87,8.25,7.70,7.20,6.87,6.75,6.85,6.97,7.75,8.57,9.47,10.40,11.37,12.32,13.22,13.97,14.51,14.84,14.85,14.57,14.12,13.75,13.48,13.35,13.27,13.27,13.25,13.12,13,12.87,12.88,13.08,13.35,13.62,13.86,13.82,13.50,13.11,12.62,12.25,12.23,12.34,12.40,12.25,11.71,10.73,9.62,8.62,7.87,7.58,7.75,8.35,9.25,10.46,11.70,12.87,13.87,14.62,15.20,15.63,16.09,16.50,16.87,17.12,16.98,16.23,14.87,13.34,11.77,10.86,10.48,10.37,10.37,10.49,10.62,10.75,10.96,11.46,12,12.65,13.40,14.22,14.87,15.37,15.62,15.71,15.62,15.50,15.35,15.12,14.87,14.49,14,13.50,13,12.62,12.25,12,11.63,11.20,10.60,9.90,9.15,8.09,6.99,5.99,5,4,4,4,4,4,4.97,5.26,5.72,6.12,6.37,6.57,6.60,6.89,5.83,4.62,3.50,2.46,1.99,1.52,1.26,1.11,1,0.84,0.63,0.48,0.37,0.50,0.62,0.75,0.87,0.96,0.98,0.99,1,1,1.01,1.07,1.10,1.12,1.14,1.20,1.21,1.21,1.21,1.22,1.24,1.37,1.63,2.07,2.39,2.71,2.87,3,3.13,3.49,4,4.59,5.11,5.49,5.73,5.82,5.75,5.62,5.49,5.36,5.25,5.12,5.08,5,5,5,4.86,3.62,-13,-14,-14,-15,-16,-16,-17,-17,-17,-18,-18,-18,-18,-18,-18,-17,-17,-16,-16,-15,-15,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-11,-11,-10,-9.49,-8.64,-7.90,-7.41,-7.24,-7.13,-6.77,-5.92,-4.38,-2.25,-0.64,0.21,0.59,0.87,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2.01,2.14,2.37,2.72,3.09,3.47,3.88,4.38,4.95,5.48,5.97,6.38,6.82,7.14,7.50,7.76,8.01,8.25,8.50,8.75,9,9.25,9.52,9.85,10.15,10.50,10.87,11.25,11.70,12.12,12.62,13.21,13.75,14.26,14.65,14.85,14.72,14.36,13.86,13.33,12.89,12.73,12.70,12.83,13.08,13.37,13.62,13.76,13.76,13.62,13.37,13.01,12.71,12.37,12.10,11.76,11.36,10.65,9.75,8.75,7.73,6.84,6.22,5.90,5.99,6.32,6.88,7.71,8.50,9.24,9.62,9.71,9.35,8.75,8.08,7.37,6.75,6.50,6.45,6.61,6.89,7.51,8.35,9.26,10.24,11.15,12,12.83,13.52,14.15,14.62,14.88,14.88,14.50,13.89,13.36,12.89,12.71,12.62,12.60,12.57,12.47,12.34,12.24,12.25,12.46,12.84,13.32,13.74,13.87,13.63,13.09,12.46,11.87,11.61,11.60,11.65,11.62,11.32,10.52,9.34,8.33,7.61,7.35,7.51,8.12,9.08,10.21,11.45,12.50,13.32,13.85,14.32,14.76,15.25,15.82,16.34,16.73,17,16.12,14.50,12.62,10.62,9.62,9.76,9.75,9.82,9.99,10.25,10.59,11,11.62,12.46,13.24,14.08,14.88,15.62,16.11,16.36,16.38,16.35,16.23,16.01,15.75,15.37,14.86,14.32,13.86,13.50,13.25,13.01,12.77,12.37,11.75,10.89,10.08,9.09,8.08,6.87,5.87,4.96,4.02,4,4.08,4.08,4.89,5.07,6.02,6.96,7,7.99,8,8,8,7,6,4,3,2.37,1.87,1.50,1.25,1.08,0.87,0.62,0.37,0.24,0.33,0.48,0.64,0.85,0.96,1,1,1.07,1.09,1.10,1.09,1.07,1.02,1.01,1.01,1,1,1,1.02,1.10,1.20,1.36,1.58,1.83,1.95,2.08,2.12,2.27,2.74,3.34,4,4.62,5.09,5.37,5.40,5.27,5.07,4.77,4.58,4.37,4.24,4.13,4.12,4.11,4.11,3.86,3.07,-13,-13,-14,-15,-15,-16,-16,-17,-17,-17,-17,-17,-17,-17,-17,-17,-16,-16,-15,-15,-14,-14,-14,-14,-14,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-9.54,-8.73,-7.90,-7.39,-7.26,-7.30,-7.14,-6.50,-5.13,-3.36,-1.51,-0.38,0.37,0.86,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2.12,2.36,2.62,2.97,3.26,3.71,4.20,4.70,5.20,5.64,6.12,6.50,6.87,7.24,7.50,7.76,8,8.24,8.47,8.70,8.95,9.23,9.50,9.84,10.13,10.50,10.87,11.32,11.75,12.25,12.85,13.46,14.01,14.50,14.75,14.62,14.25,13.75,13.15,12.73,12.47,12.38,12.51,12.82,13.12,13.47,13.62,13.63,13.50,13.23,12.87,12.52,12.25,12.09,11.87,11.60,11.07,10.25,9.25,8.15,7.12,6.23,5.65,5.50,5.71,6.25,7.02,7.88,8.63,9.14,9.32,9.23,8.09,7.24,6.57,6.11,5.75,6.24,6.65,7.32,8.12,9.14,10.12,11.07,11.87,12.50,13.14,13.72,14.22,14.62,14.86,14.84,14.37,13.62,12.96,12.37,12.08,11.89,11.87,11.83,11.75,11.62,11.50,11.50,11.75,12.14,12.75,13.37,13.64,13.58,13,12.21,11.50,11,10.87,10.87,10.88,10.63,10.12,8.98,8.09,7.50,7.25,7.48,8,8.83,9.76,10.77,11.71,12.38,12.98,13.49,14,14.50,15.14,15.77,16.34,16.50,16.35,14.34,12.12,10.50,9.60,9.37,9.39,9.57,9.86,10.36,10.88,11.57,12.27,13.13,14,14.87,15.75,16.49,16.99,17.22,17.25,17.14,17,16.76,16.38,15.86,15.25,14.72,14.36,14.13,14,13.87,13.58,13,12.12,11.10,9.99,8.84,7.74,6.85,5.09,4.87,4.10,4,4.12,4.87,5.12,6.10,6.99,7.87,8.09,8.95,9.01,9,9,8,7,5,4,3.13,2.40,1.88,1.50,1.32,1.11,0.88,0.72,0.57,0.51,0.62,0.76,0.89,1,1.07,1.12,1.21,1.25,1.26,1.25,1.20,1.12,1.09,1.02,1,1,1.01,1.08,1.12,1.14,1.24,1.34,1.39,1.37,1.40,1.50,1.62,2.09,2.72,3.38,4.08,4.62,4.99,5.09,4.90,4.62,4.35,4.02,3.76,3.60,3.49,3.45,3.40,3.40,3.15,2.62,-13,-13,-14,-14,-15,-15,-16,-16,-16,-16,-16,-17,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-13,-12,-11,-11,-10,-9.62,-8.75,-8,-7.50,-7.43,-7.66,-7.87,-7.43,-6.25,-4.50,-2.63,-1,0.23,0.87,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2.12,2.35,2.62,2.87,3.14,3.50,3.98,4.45,4.88,5.37,5.77,6.24,6.62,6.99,7.25,7.51,7.75,7.98,8.20,8.39,8.63,8.89,9.21,9.50,9.84,10.14,10.50,10.89,11.36,11.85,12.37,13,13.59,14.08,14.37,14.32,13.97,13.47,12.88,12.45,12.14,12.10,12.21,12.47,12.82,13.12,13.36,13.37,13.24,12.95,12.59,12.25,12,11.90,11.87,11.75,11.39,10.76,9.86,8.72,7.47,6.36,5.49,5.01,5.12,5.62,6.38,7.25,8,8.50,8.61,8.25,7.25,6.37,5.61,5.61,5.73,6.25,7,7.83,8.87,9.99,11.10,11.75,12.45,12.87,13.36,13.73,14.02,14.37,14.57,14.50,14.07,13.27,12.52,11.87,11.46,11.21,11.10,11.01,10.98,10.86,10.74,10.73,10.88,11.33,11.89,12.60,13,13,12.50,11.70,10.87,10.36,10.09,10,10,9.76,9.15,8.37,7.62,7.12,6.99,7.15,7.70,8.39,9.25,10.13,10.95,11.59,12.12,12.63,13.25,13.89,14.62,15.32,16,16.36,16.35,13.75,11.63,9.63,9.39,9.25,9.35,9.62,10.10,10.74,11.48,12.25,13.12,13.99,14.87,15.74,16.60,17.36,17.88,18.12,18.12,18,17.76,17.48,16.99,16.35,15.73,15.25,15.07,14.99,14.89,14.70,14.22,13.37,12.32,11.09,9.85,8.61,7.21,6.12,5.12,4.86,4.12,4.12,4.13,5,5.84,6.84,7.85,8.86,9.12,9.87,10.88,10.90,9.96,8.99,8,6,5,4.07,3.23,2.57,2.02,1.75,1.57,1.39,1.26,1.12,1.02,1,1.08,1.12,1.20,1.25,1.35,1.48,1.59,1.62,1.60,1.50,1.37,1.26,1.23,1.20,1.20,1.22,1.25,1.32,1.33,1.32,1.25,1.25,1.10,1.11,1.12,1.25,1.61,2.12,2.77,3.48,4.12,4.59,4.71,4.57,4.25,3.96,3.63,3.38,3.23,3.12,3.12,3.12,3.12,2.97,2.47,-13,-13,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-11,-11,-10,-9.63,-8.86,-8.23,-7.86,-7.77,-7.98,-8.17,-8.26,-7.28,-5.43,-3.41,-1.50,0,0.75,0.95,0.98,0.99,0.99,1,1,1,1,1,1,1,1,1,2,2,1.99,2,2,2.12,2.33,2.59,2.84,3.10,3.37,3.75,4.21,4.62,5.01,5.49,5.95,6.37,6.75,7.08,7.33,7.50,7.73,7.95,8.13,8.37,8.63,8.90,9.23,9.50,9.86,10.20,10.52,10.95,11.37,11.87,12.38,12.96,13.38,13.65,13.65,13.38,12.98,12.49,12.01,11.75,11.70,11.75,12,12.37,12.71,12.90,12.99,12.86,12.52,12.15,11.85,11.62,11.62,11.75,11.83,11.71,11.25,10.46,9.23,7.87,6.57,5.45,4.76,4.63,5.10,5.85,6.64,7.38,7.82,7.74,7.09,6.25,5.47,5.21,5.32,5.62,6.57,7.50,8.59,9.65,10.75,11.62,12.32,12.77,13.10,13.37,13.51,13.70,13.87,13.99,13.89,13.59,12.88,12.11,11.37,10.83,10.48,10.26,10.21,10.12,10,9.87,9.82,9.95,10.26,10.77,11.38,11.76,11.82,11.39,10.74,10,9.50,9.21,9.02,8.88,8.64,8.25,7.70,7.12,6.73,6.61,6.77,7.25,7.87,8.63,9.39,10.12,10.72,11.25,11.85,12.50,13.26,14.09,14.84,15.45,16.35,15.36,13.12,10.62,9.62,9.26,9.24,9.40,9.87,10.50,11.32,12.20,13.12,14,14.87,15.75,16.50,17.27,18,18.61,18.87,18.84,18.61,18.34,17.96,17.45,16.83,16.25,15.95,15.83,15.76,15.62,15.25,14.50,13.46,12.22,10.89,9.62,8.37,7.12,6,5.13,4.83,4.20,4.20,4.76,5.21,6.12,7.12,8.20,9.14,9.99,10.85,11.10,10.99,10.09,9.02,8,7,6,5,4.12,3.39,2.84,2.50,2.25,2.12,2.01,1.87,1.73,1.61,1.57,1.57,1.59,1.62,1.74,1.87,2.07,2.12,2.11,1.99,1.83,1.70,1.61,1.57,1.57,1.59,1.62,1.70,1.65,1.61,1.46,1.32,1.07,1,1,1.10,1.26,1.65,2.25,2.88,3.59,4.12,4.33,4.12,3.87,3.60,3.36,3.20,3.10,3.12,3.21,3.33,3.37,3.15,2.62,-12,-13,-13,-14,-14,-14,-15,-15,-15,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-11,-11,-10,-9.61,-8.88,-8.30,-8,-7.88,-8.01,-8.15,-8.17,-7.63,-6,-3.88,-1.75,-0.02,0.62,0.88,0.98,0.99,0.99,0.99,1,1,1,1,1,1,1,1,2,2,1.99,1.99,2,2.11,2.25,2.50,2.74,2.99,3.25,3.59,3.95,4.32,4.71,5.12,5.60,6.02,6.46,6.75,7.01,7.25,7.48,7.70,7.89,8.13,8.38,8.64,8.96,9.25,9.51,9.86,10.15,10.50,10.87,11.27,11.73,12.14,12.52,12.76,12.83,12.62,12.26,11.87,11.50,11.26,11.22,11.25,11.50,11.84,12.14,12.40,12.50,12.39,12.12,11.73,11.36,11.13,11.23,11.46,11.70,11.83,11.49,10.82,9.61,8.24,6.83,5.52,4.70,4.37,4.73,5.36,6.12,6.82,7.12,6.98,6.25,5.35,4.37,4.48,5.21,5.98,6.98,8.21,9.37,10.45,11.27,12.21,12.50,12.95,13.12,13.23,13.21,13.12,13.12,13.12,13.09,12.87,12.35,11.59,10.75,10.12,9.70,9.40,9.27,9.21,9.09,8.90,8.83,8.87,9.12,9.50,9.89,10.23,10.24,9.96,9.45,8.95,8.50,8.23,8.09,7.89,7.70,7.37,6.96,6.52,6.25,6.20,6.37,6.75,7.32,7.95,8.61,9.23,9.77,10.37,11,11.76,12.62,13.50,14.32,14.83,14.75,14.36,12.37,10.62,9.62,9.25,9.25,9.60,10.21,11,12,13,14.01,15,15.87,16.62,17.25,17.86,18.46,18.95,19.14,19.09,18.75,18.45,18.01,17.62,17.12,16.75,16.49,16.37,16.25,15.99,15.37,14.40,13.24,11.95,10.64,9.39,8.20,7.07,6,5.21,4.75,4.22,4.24,4.87,5.75,6.24,7.24,8.75,9.75,10.76,11.20,11.84,11.86,10.99,9.99,9,8,7,6,5.11,4.37,3.77,3.37,3.13,3,2.87,2.71,2.49,2.32,2.23,2.21,2.22,2.25,2.35,2.50,2.64,2.75,2.75,2.62,2.47,2.33,2.24,2.20,2.20,2.22,2.25,2.26,2.25,2.12,1.90,1.62,1.14,1.07,1,1,1.12,1.37,1.77,2.37,2.99,3.48,3.70,3.58,3.37,3.25,3.12,3.12,3.13,3.35,3.60,3.87,4,3.86,3.07,-12,-13,-13,-14,-14,-14,-14,-15,-15,-15,-15,-15,-15,-15,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-14,-14,-14,-14,-13,-13,-12,-11,-11,-10,-9.54,-8.90,-8.38,-8.04,-7.88,-7.88,-7.88,-7.85,-7.13,-5.92,-4,-1.87,-0.13,0.62,0.88,0.98,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,2,2,1.97,1.98,2,2.07,2.20,2.37,2.59,2.83,3.08,3.36,3.64,4,4.37,4.75,5.22,5.63,6.08,6.39,6.71,6.97,7.21,7.40,7.64,7.89,8.14,8.39,8.65,8.97,9.25,9.50,9.83,10.12,10.37,10.70,10.99,11.26,11.58,11.75,11.82,11.70,11.45,11.13,10.87,10.70,10.62,10.71,10.87,11.21,11.52,11.87,12.01,12,11.73,11.25,10.85,10.61,10.63,10.95,11.25,11.50,11.25,10.84,9.84,8.50,7.07,5.73,4.74,4.24,4.40,4.89,5.58,6.26,6.61,6.37,5.60,4.87,4.34,4.37,5.20,6.22,7.38,8.75,10.37,11,11.63,12.12,12.50,12.85,12.90,12.88,12.70,12.46,12.25,12.12,12.02,11.87,11.48,10.82,10,9.34,8.84,8.50,8.34,8.22,8.09,7.88,7.75,7.75,7.87,8.12,8.40,8.61,8.61,8.38,8.10,7.75,7.40,7.25,7.12,6.98,6.76,6.51,6.25,5.98,5.76,5.75,5.89,6.24,6.65,7.21,7.75,8.33,8.87,9.50,10.20,11,11.95,12.87,13.71,14.10,13.90,13.02,11.63,10.32,9.49,9.22,9.33,9.74,10.57,11.59,12.73,13.87,15,16.02,16.96,17.50,17.96,18.25,18.64,18.88,18.95,18.77,18.50,18.12,17.77,17.50,17.25,17.08,16.85,16.62,16.33,15.83,15.07,14,12.85,11.62,10.37,9.22,8.09,7.01,6.12,5.24,4.75,4.25,4.25,5,5.86,6.75,7.75,8.87,9.96,10.86,11.75,12.76,12.83,11.86,10.98,9.99,9,8,7,6.11,5.38,4.83,4.40,4.14,4,3.85,3.62,3.37,3.20,3.09,3.02,3.02,3.08,3.12,3.25,3.37,3.48,3.47,3.37,3.24,3.12,3.07,3,3,3.01,3.08,3.09,3.01,2.87,2.62,2.14,1.49,1.15,1.07,1,1,1.20,1.50,1.99,2.46,2.82,2.97,3,3,3.01,3.12,3.25,3.47,3.83,4.25,4.64,4.90,4.86,3.64,-12,-13,-13,-13,-13,-14,-14,-14,-14,-14,-15,-15,-15,-15,-16,-16,-16,-16,-16,-15,-15,-15,-15,-14,-14,-14,-14,-14,-13,-13,-13,-12,-11,-10,-10,-9.50,-8.89,-8.40,-8.05,-7.87,-7.75,-7.63,-7.38,-6.90,-5.75,-4.13,-1.88,-0.13,0.62,0.87,0.98,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,2,1.84,1.95,2,2,2.11,2.23,2.37,2.62,2.86,3.12,3.37,3.70,4,4.37,4.77,5.23,5.62,6,6.32,6.61,6.87,7.12,7.38,7.65,7.89,8.13,8.38,8.64,8.90,9.21,9.46,9.70,9.87,10.07,10.23,10.37,10.52,10.64,10.72,10.62,10.49,10.27,10.12,10,9.97,10,10.21,10.50,10.87,11.25,11.51,11.60,11.35,10.87,10.36,10,9.98,10.20,10.50,10.73,10.73,10.50,9.85,8.62,7.14,5.75,4.72,4.13,4.12,4.46,5,5.62,6.26,5.73,5,4.24,4.12,4.32,5.25,6.38,7.82,9.25,10.49,11.46,11.75,11.99,12.24,12.51,12.60,12.47,12.08,11.62,11.26,11.07,10.87,10.63,10.27,9.74,9.02,8.38,7.87,7.52,7.34,7.15,7.01,6.87,6.72,6.62,6.70,6.85,7,7.12,7.12,6.99,6.76,6.58,6.47,6.34,6.23,6.12,5.98,5.77,5.61,5.40,5.33,5.33,5.46,5.72,6.07,6.49,6.96,7.46,8,8.61,9.33,10.13,11.10,12.02,12.87,13.27,13.12,12.36,11.13,9.62,9.23,9.09,9.37,9.89,10.90,12.12,13.39,14.75,16.01,17.22,18,18.25,18.26,18.25,18.25,18.37,18.37,18.15,17.88,17.58,17.25,17.12,17.12,17.12,16.97,16.63,16.12,15.40,14.51,13.50,12.38,11.27,10.15,9.09,8,7,6.23,5.74,4.87,4.25,4.26,5,5.99,6.99,8,9,10,11,11.99,12.75,12.86,12.82,11.87,10.99,10,9,8.02,7.15,6.50,5.95,5.50,5.23,5,4.86,4.62,4.38,4.21,4.09,4.02,4.01,4.02,4.09,4.12,4.22,4.25,4.25,4.15,4.11,4.01,4,4,4,4,4,4,3.95,3.75,3.47,2.90,2.13,1.50,1.20,1.07,1,1.11,1.37,1.75,2.08,2.33,2.45,2.59,2.75,3,3.32,3.62,4,4.50,5.08,5.61,5.97,6.08,4.50,-12,-12,-13,-13,-13,-13,-13,-14,-14,-14,-14,-15,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-10,-10,-9.38,-8.85,-8.38,-8,-7.75,-7.62,-7.42,-7.16,-6.73,-5.88,-4.41,-2.25,-0.13,0.37,0.75,0.87,0.95,0.98,0.98,0.99,1,1,1,1,1,1,1,1,1,1.73,1.90,1.99,2,2.01,2.11,2.24,2.38,2.62,2.87,3.12,3.37,3.70,4,4.37,4.75,5.12,5.50,5.86,6.20,6.52,6.85,7.12,7.38,7.62,7.87,8.11,8.36,8.60,8.84,9.02,9.23,9.35,9.39,9.46,9.49,9.50,9.58,9.60,9.52,9.47,9.36,9.25,9.24,9.22,9.25,9.45,9.73,10.12,10.60,11,11.22,11,10.49,9.87,9.40,9.24,9.25,9.37,9.57,9.62,9.74,9.37,8.38,6.97,5.63,4.57,3.87,3.75,3.98,4.37,4.87,5.38,4.82,4.13,3.83,3.22,4.25,5.25,6.70,8.10,9.61,10.83,11.52,11.73,11.72,11.75,11.99,12,11.82,11.26,10.70,10.21,9.87,9.61,9.34,8.98,8.50,7.96,7.37,6.88,6.57,6.34,6.14,6,5.87,5.73,5.62,5.62,5.70,5.76,5.85,5.85,5.75,5.62,5.62,5.57,5.50,5.40,5.37,5.25,5.14,5.02,4.96,4.88,4.90,5.01,5.25,5.50,5.87,6.25,6.71,7.20,7.75,8.45,9.24,10.12,11,11.77,12.26,12.25,11.62,10.62,9.62,8.60,8.97,9.47,10.14,11.27,12.62,14.08,15.49,16.83,17.90,18.50,18.49,18.21,17.88,17.72,17.62,17.62,17.51,17.25,16.89,16.61,16.49,16.83,17.02,17.13,16.62,15.97,15.01,14.08,13.12,12.12,11.12,10.08,9,8,7,6.25,5.71,4.99,4.32,4.32,5.01,6,7.12,8.24,9.32,10.26,11.26,12.25,12.98,13.24,13.21,12.86,11.98,11,10,9.08,8.25,7.62,7.12,6.64,6.32,6.08,5.87,5.71,5.50,5.32,5.22,5.14,5.14,5.15,5.14,5.13,5.12,5.12,5.11,5.08,5,5,5,4.99,4.99,4.99,4.99,4.98,4.87,4.72,4.37,3.74,2.95,2.12,1.50,1.21,1.01,1.11,1.33,1.64,1.90,2.12,2.25,2.48,2.87,3.32,3.75,4.25,4.82,5.38,6.01,6.61,6.99,7.09,6.58,-12,-12,-12,-13,-12,-13,-13,-13,-13,-14,-14,-14,-15,-15,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-9.88,-9.38,-8.88,-8.50,-8.14,-7.89,-7.67,-7.50,-7.16,-6.78,-6.24,-5.05,-2.62,-1.25,0.35,0.49,0.75,0.87,0.87,0.95,0.97,0.98,0.98,0.99,0.99,0.99,0.99,1,1,1,1.75,1.89,1.96,1.99,2,2.01,2.11,2.24,2.38,2.62,2.87,3.12,3.37,3.65,4,4.33,4.63,5,5.37,5.75,6.13,6.50,6.84,7.12,7.35,7.58,7.75,7.99,8.21,8.38,8.59,8.71,8.75,8.73,8.63,8.60,8.51,8.50,8.50,8.47,8.39,8.37,8.37,8.38,8.39,8.49,8.62,8.87,9.26,9.82,10.36,10.72,10.62,10.02,9.40,8.85,8.46,8.25,8.23,8.27,8.38,8.46,8.27,7.62,6.51,5.34,4.32,3.62,3.38,3.50,3.75,4,4.10,3.87,3.12,3.12,3.12,4.09,5.22,6.75,8.13,9.71,11.65,11.63,11.62,11.13,11.02,11.24,11.25,11,10.37,9.62,9.02,8.62,8.32,8,7.64,7.25,6.76,6.33,5.89,5.61,5.37,5.24,5.11,4.97,4.86,4.75,4.75,4.75,4.77,4.84,4.84,4.75,4.73,4.83,4.83,4.77,4.76,4.75,4.74,4.65,4.62,4.61,4.61,4.62,4.75,4.88,5.12,5.40,5.75,6.11,6.50,7,7.60,8.25,9.01,9.83,10.51,11.02,11.13,10.75,10.07,9.26,8.58,8.88,9.62,10.57,11.76,13.12,14.58,15.96,17.12,18.02,18.33,18.10,17.62,17.26,17,16.87,16.90,16.90,16.71,16.25,15.90,15.83,16.20,16.61,16.90,16.62,15.96,15.02,14.09,13.12,12.13,11.12,10.07,9,8,7,6.26,5.65,5,4.33,4.34,5.25,6.24,7.34,8.63,9.64,10.64,11.65,12.71,13.72,13.99,14.75,13.76,12.97,11.98,11,10.13,9.37,8.87,8.34,7.83,7.37,7.12,6.95,6.82,6.63,6.50,6.47,6.46,6.48,6.48,6.39,6.32,6.20,6.10,6.02,6,6,6,6,6,6,6,6,5.98,5.87,5.63,5.22,4.59,3.62,2.72,1.96,1.38,1.12,1.10,1.33,1.64,1.95,2.15,2.40,2.77,3.25,3.76,4.38,5.08,5.75,6.46,7.11,7.64,8.01,8.09,6.62,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-14,-14,-15,-16,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-14,-13,-13,-13,-13,-12,-12,-11,-10,-10,-9.75,-9.36,-8.92,-8.60,-8.26,-8,-7.78,-7.61,-7.38,-7.10,-6.75,-5.90,-4,-1.67,-0.87,0.25,0.50,0.62,0.82,0.87,0.88,0.96,0.97,0.98,0.98,0.98,0.98,0.99,1,1,1.87,1.83,1.88,1.97,1.99,2,2.01,2.11,2.24,2.38,2.62,2.87,3.12,3.37,3.62,3.87,4.20,4.50,4.87,5.27,5.75,6.12,6.50,6.75,6.98,7.20,7.37,7.52,7.74,7.88,8.01,8.10,8.08,7.98,7.85,7.72,7.61,7.50,7.47,7.39,7.38,7.45,7.50,7.59,7.61,7.62,7.75,7.99,8.37,8.87,9.48,9.89,9.97,9.52,8.90,8.27,7.72,7.34,7.12,7.12,7.13,7.22,7.10,6.62,5.87,4.86,3.96,3.33,3.10,3.09,3.21,3.33,3.25,3.08,2.90,2.90,3.09,3.87,4.99,6.84,7.83,9.02,10.75,10.74,10.71,10.36,10.12,10.21,10.21,9.98,9.20,8.47,7.85,7.38,7.07,6.75,6.38,6.02,5.64,5.27,4.99,4.75,4.58,4.45,4.34,4.24,4.13,4.11,4.09,4.08,4.10,4.11,4.10,4.09,4.21,4.24,4.25,4.27,4.33,4.35,4.37,4.37,4.37,4.37,4.46,4.50,4.62,4.75,4.97,5.15,5.40,5.70,6,6.37,6.84,7.37,7.99,8.62,9.25,9.73,9.88,9.74,9.33,8.88,8.75,9,9.88,10.98,12.25,13.59,14.95,16.12,17,17.50,17.60,17.33,16.95,16.51,16.24,16.10,16.13,16.25,16.25,15.85,15.49,15.25,15.49,16.02,16.62,16.62,16.07,15.24,14.38,13.46,12.37,11.25,10.12,9.01,8,7,6.32,5.65,5.11,4.36,4.77,5.36,6.62,7.75,8.87,10,11.11,12.21,13.26,14.09,14.74,14.86,14.75,13.76,12.87,11.87,11.09,10.72,10.15,9.62,9,8.48,8.14,8,7.98,7.89,7.87,7.85,7.87,7.87,7.87,7.75,7.50,7.27,7.12,7.08,7.09,7.12,7.12,7.13,7.13,7.12,7.11,7.02,7,6.87,6.61,6.07,5.22,4.27,3.34,2.40,1.74,1.25,1.09,1.33,1.70,2,2.37,2.75,3.24,3.76,4.45,5.22,6.02,6.87,7.62,8.33,8.87,9.32,9.21,7.72,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-14,-14,-15,-16,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-10,-10,-10,-9.66,-9.35,-9,-8.68,-8.40,-8.15,-7.98,-7.76,-7.62,-7.43,-7.30,-7.25,-5.05,-3.30,-1.76,-0.75,0,0.37,0.62,0.83,0.87,0.87,0.88,0.95,0.96,0.97,0.97,0.98,1,1.12,1,1.72,1.77,1.90,1.98,1.99,2,2.01,2.11,2.24,2.38,2.62,2.86,3.09,3.27,3.50,3.75,4.09,4.45,4.87,5.35,5.75,6.11,6.37,6.52,6.73,6.87,7,7.14,7.27,7.37,7.37,7.32,7.14,7,6.85,6.72,6.61,6.50,6.49,6.49,6.51,6.62,6.72,6.75,6.76,6.87,7.01,7.37,7.85,8.37,8.85,9,8.83,8.35,7.75,7.15,6.60,6.24,6.09,6.01,6.02,5.95,5.61,5,4.15,3.45,2.96,2.74,2.70,2.72,2.73,2.88,3,2,2,3,3,4.08,5.87,6.86,7.84,8.77,9.21,9.75,9.25,9.12,9,8.77,8.45,7.86,7.23,6.63,6.24,5.87,5.58,5.25,4.96,4.62,4.37,4.14,4,3.88,3.84,3.75,3.72,3.65,3.62,3.62,3.62,3.62,3.62,3.62,3.63,3.84,3.87,3.90,4,4.02,4.12,4.15,4.24,4.27,4.37,4.49,4.60,4.73,4.86,5,5.13,5.34,5.50,5.72,5.97,6.25,6.62,7.08,7.60,8.11,8.50,8.71,8.70,8.52,8.49,8.70,9.11,10.13,11.37,12.65,14.01,15.20,16.07,16.52,16.76,16.72,16.48,16.12,15.70,15.34,15.12,15.32,15.51,15.71,15.45,15.02,14.72,14.83,15.37,15.96,16.14,15.95,15.47,14.85,13.87,12.70,11.47,10.23,9.08,8,7,6.33,5.70,5.22,4.89,5.12,5.88,7,8.20,9.27,10.33,11.36,12.62,13.65,14.65,15.20,15.72,15.07,14.75,13.20,12.85,12.12,11.82,11.62,10.89,10.23,9.52,9.25,9.22,9.25,9.26,9.32,9.33,9.35,9.35,9.25,9.01,8.72,8.38,8.22,8.15,8.25,8.37,8.47,8.50,8.49,8.39,8.33,8.20,8.08,7.90,7.62,6.99,6,5,3.89,2.87,1.96,1.37,1.09,1.33,1.73,2.12,2.60,3.02,3.62,4.26,5.11,6,7,7.98,8.86,9.62,10.26,10.82,11.11,9.82,-11,-12,-12,-12,-11,-12,-12,-12,-12,-13,-14,-14,-15,-16,-16,-16,-16,-16,-16,-15,-15,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,-10,-9.88,-9.64,-9.39,-9.13,-8.88,-8.63,-8.38,-8.15,-8,-7.86,-7.76,-7.80,-7.63,-6.25,-4.63,-3.12,-1.63,-0.67,0.10,0.50,0.74,0.82,0.84,0.85,0.86,0.87,0.87,0.88,0.97,1,1,1.12,1.13,1.72,1.87,1.96,1.98,1.99,2,2.01,2.11,2.24,2.38,2.62,2.84,3,3.23,3.45,3.72,4.07,4.48,4.90,5.33,5.62,5.87,6,6.14,6.26,6.37,6.50,6.59,6.62,6.59,6.48,6.33,6.12,6,5.87,5.75,5.71,5.63,5.64,5.72,5.76,5.87,5.88,5.90,5.99,6.11,6.35,6.74,7.13,7.52,7.83,7.83,7.62,7.25,6.70,6.09,5.52,5.22,5.02,5,4.87,4.59,4,3.37,2.77,2.40,2.25,2.25,2.25,2.12,2,2,2,2,2,2.99,3.97,4.08,5.11,6.12,7.10,7.83,8.10,8.75,7.99,7.62,7.26,6.88,6.48,6,5.52,5.14,4.85,4.52,4.25,4,3.76,3.62,3.50,3.46,3.40,3.39,3.39,3.39,3.39,3.39,3.39,3.40,3.40,3.45,3.47,3.62,3.73,3.77,3.86,3.90,4,4.10,4.15,4.25,4.37,4.50,4.70,4.86,5,5.13,5.25,5.37,5.50,5.60,5.71,5.83,5.98,6.14,6.46,6.82,7.21,7.50,7.73,7.77,7.87,8.09,8.58,9.37,10.38,11.75,13.12,14.39,15.33,15.77,15.88,15.88,15.83,15.58,15.20,14.75,14.37,14.13,14.37,14.74,15.12,15.13,14.72,14.36,14.25,14.62,15.07,15.25,15.25,15.10,14.87,14,12.99,11.51,10.25,9.10,8,7,6.33,5.70,5.32,5.02,5.37,6.12,7.33,8.61,9.62,10.64,11.75,13,14.20,15.08,15.65,15.71,15.25,14.75,13.98,13.20,13.07,12.87,12.74,12.46,11.45,10.73,10.50,10.51,10.64,10.77,10.86,10.84,10.75,10.65,10.49,10.15,9.77,9.48,9.27,9.35,9.51,9.76,9.98,10.02,10,9.87,9.62,9.37,9.12,8.96,8.75,8,7,5.76,4.60,3.14,2.07,1.37,1.08,1.26,1.71,2.22,2.64,3.22,3.88,4.72,5.71,6.76,7.95,9,10,10.95,11.75,12.45,13,12.87,-11,-11,-11,-11,-11,-11,-11,-12,-12,-13,-14,-14,-15,-16,-16,-16,-16,-16,-15,-15,-14,-14,-13,-12,-12,-12,-11,-10,-10,-9.80,-9.29,-9.77,-9.88,-9.85,-9.74,-9.61,-9.40,-9.23,-8.98,-8.68,-8.42,-8.18,-8.02,-8,-8.15,-8.14,-7.50,-6.26,-4.63,-2.79,-1.38,-0.25,0.36,0.57,0.62,0.62,0.59,0.58,0.62,0.73,0.83,0.87,0.96,0.99,1,1.09,1.74,1.76,1.87,1.96,1.98,1.99,2,2.01,2.11,2.24,2.37,2.60,2.75,2.96,3.12,3.37,3.71,4.08,4.48,4.84,5.10,5.32,5.38,5.50,5.61,5.63,5.73,5.75,5.75,5.72,5.61,5.47,5.33,5.22,5.12,5.02,4.99,4.96,4.96,4.98,5,5.07,5.09,5.11,5.12,5.22,5.36,5.62,5.98,6.26,6.50,6.62,6.65,6.61,6.24,5.57,4.96,4.39,4.15,4.02,3.88,3.62,3.12,2.50,2.07,1.83,1.71,1.72,1.86,1.99,2,2,2,2,2,2,3,3,4,4.87,5.87,6.12,6.84,6.83,6.75,6.21,5.82,5.50,5.20,4.87,4.52,4.25,3.98,3.70,3.45,3.24,3.09,3,3,3.10,3.12,3.22,3.25,3.35,3.37,3.45,3.47,3.48,3.48,3.50,3.52,3.76,3.88,3.99,4.02,4.12,4.21,4.25,4.37,4.49,4.62,4.84,5.07,5.27,5.50,5.71,5.84,5.89,5.99,6,6.01,6.02,6.08,6.12,6.24,6.45,6.70,6.89,7.08,7.21,7.39,7.85,8.52,9.57,10.72,12.20,13.48,14.50,15.12,15.27,15.13,15,14.86,14.60,14.23,13.84,13.47,13.23,13.38,13.77,14.25,14.50,14.25,13.73,13.48,13.52,13.84,14.07,14,13.98,13.71,13.24,12.50,11.37,10.22,9,7.98,7,6.32,5.70,5.33,5.07,5.37,6.25,7.60,8.84,9.96,11,12.12,13.33,14.62,15.63,15.82,15.72,15.27,14.76,14.25,13.87,13.84,13.86,13.75,13.57,12.50,11.89,11.82,11.95,12.14,12.37,12.37,12.25,12.11,11.87,11.58,11.20,10.76,10.49,10.37,10.51,10.87,11.25,11.59,11.71,11.62,11.36,10.98,10.59,10.23,9.87,9.95,9,8,6.07,4.75,3.34,2.02,1.37,1.07,1.24,1.60,2,2.60,3.23,4,4.96,6.08,7.33,8.62,9.88,11.11,12.13,13.11,13.87,14.58,14,-10,-11,-11,-11,-11,-11,-11,-11,-12,-13,-13,-14,-15,-16,-16,-16,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-10,-9.55,-9.25,-9.38,-9.74,-9.80,-9.88,-9.88,-9.88,-9.78,-9.65,-9.43,-9.13,-8.76,-8.39,-8.13,-8.04,-8.35,-8.77,-9,-8.29,-6.75,-4.43,-2.38,-0.88,-0.04,0.25,0.37,0.13,-0.13,-0.37,-0.05,0.25,0.62,0.75,0.87,0.99,1,1.11,1.07,1.65,1.76,1.87,1.89,1.96,1.98,2,2.01,2.11,2.23,2.37,2.51,2.70,2.87,3.07,3.32,3.62,3.96,4.25,4.49,4.63,4.75,4.82,4.86,4.87,4.87,4.87,4.87,4.83,4.73,4.62,4.50,4.47,4.38,4.37,4.34,4.32,4.27,4.27,4.32,4.34,4.35,4.35,4.36,4.37,4.48,4.62,4.85,5.10,5.26,5.46,5.59,5.71,5.50,5,4.32,3.75,3.37,3.15,3,2.74,2.34,1.83,1.49,1.37,1.25,1.12,1,1,1,1,1,1,2,2,2,2,3,3.96,4.08,4.87,4.87,4.97,4.87,4.75,4.25,4.24,4.07,3.87,3.70,3.48,3.25,3,2.82,2.70,2.62,2.62,2.75,2.89,3.07,3.21,3.36,3.50,3.62,3.74,3.75,3.76,3.82,3.85,3.88,4.21,4.36,4.47,4.50,4.59,4.62,4.65,4.75,4.87,5.01,5.25,5.58,5.87,6.23,6.50,6.65,6.75,6.83,6.77,6.75,6.63,6.57,6.48,6.46,6.50,6.62,6.73,6.84,7,7.27,7.84,8.64,9.83,11.20,12.75,13.75,14.45,14.71,14.57,14.25,14.08,13.87,13.61,13.26,12.90,12.59,12.27,12.39,12.77,13.25,13.50,13.25,12.73,12.37,12.37,12.50,12.62,12.51,12.37,12.12,11.83,11.40,11.37,9.75,8.65,7.75,6.87,6.27,5.70,5.33,5.07,5.37,6.37,7.63,8.97,10,11.12,12.35,13.62,14.77,15.62,15.87,15.76,15.62,15,14.35,14.34,14.65,14.72,14.75,13.98,13.38,13,12.96,13.24,13.64,13.84,13.76,13.57,13.25,12.88,12.50,12.11,11.71,11.39,11.37,11.62,12.12,12.75,13.20,13.37,13.12,12.70,12.21,11.63,11.25,10.87,10,10,9,7,4.87,3.26,2,1.37,1.02,1.12,1.37,1.77,2.37,3.12,4,5.07,6.25,7.65,9.12,10.61,12.12,13.23,14.23,15.09,15.77,15.13,-10,-10,-10,-11,-10,-10,-11,-11,-12,-12,-13,-14,-15,-15,-15,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-10,-10,-10,-9.88,-10,-9.75,-9.75,-9.88,-10,-10,-10,-10,-10,-9.75,-9.24,-8.63,-8.11,-7.77,-8,-9.26,-10,-11,-9.17,-6.13,-3.62,-1.88,-0.66,-0.13,0.21,-0.50,-1.87,-3.63,-3.50,-1.38,-0.50,0.61,0.75,0.97,0.99,0.99,1,1.12,1.62,1.65,1.76,1.87,1.96,1.99,2,2.01,2.11,2.20,2.32,2.40,2.58,2.72,2.87,3.12,3.38,3.64,3.86,3.98,4.02,4.10,4.10,4.08,4.01,4,3.98,3.90,3.87,3.82,3.75,3.74,3.72,3.70,3.65,3.63,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.71,3.75,3.87,4,4.12,4.25,4.39,4.59,4.46,4.12,3.61,3.10,2.73,2.45,2.24,2,1.72,1.37,1.12,1,1,1,1,0.99,0.99,0.99,1,1.12,1.13,1.12,1.12,1.88,2,2.99,3,3.02,3.08,3.09,3.11,3.12,3.15,3.10,3.10,3,2.95,2.85,2.71,2.52,2.39,2.37,2.38,2.57,2.75,2.96,3.13,3.37,3.62,3.87,4.12,4.26,4.37,4.39,4.45,4.48,4.58,4.87,5.08,5.15,5.25,5.25,5.25,5.25,5.26,5.37,5.52,5.83,6.20,6.62,7.08,7.47,7.75,7.88,7.96,7.87,7.75,7.60,7.37,7.20,7.01,6.97,6.95,6.97,7.01,7.21,7.50,8.09,8.96,10.12,11.62,13.62,13.97,14.37,13.96,13.60,13.26,13.10,12.88,12.65,12.37,12.12,11.85,11.62,11.62,11.76,12,12.02,11.86,11.50,11.12,11.12,11.24,11.26,11.11,10.87,10.62,10.38,10.12,9.64,9,8.21,7.34,6.75,6.26,5.70,5.33,5.07,5.37,6.37,7.75,9.10,10.25,11.35,12.62,13.77,14.77,15.62,15.77,15.86,15.64,15.32,15,15,15.21,15.63,14.99,14.75,14,13.75,13.83,14.13,14.52,14.77,14.75,14.52,14.20,13.82,13.37,12.96,12.51,12.25,12.26,12.61,13.14,13.87,14.57,14.62,14.25,13.71,13.08,12.62,12.13,11.99,11,10,9,7,5,3.12,2.12,1.36,1,1.01,1.14,1.50,2.15,3.02,4,5.09,6.36,7.84,9.46,11,12.65,14,15.12,16,17.22,17.32,-10,-10,-10,-10,-10,-10,-10,-11,-12,-12,-13,-14,-15,-15,-15,-15,-15,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-9.43,-9.49,-9.75,-10,-10,-10,-11,-10,-10,-9.86,-8.88,-7.90,-7.13,-6.77,-7.88,-10,-11,-9.66,-6.90,-4.92,-3.18,-2.03,-1.38,-1.63,-1.75,-4.03,-7.63,-12,-6.63,-1.04,-0.13,0.58,0.96,0.99,0.99,1,1,1.12,1.37,1.60,1.76,1.89,1.98,1.99,2,2,2.08,2.12,2.22,2.26,2.37,2.50,2.71,2.87,3.11,3.25,3.35,3.37,3.37,3.37,3.26,3.15,3.12,3.12,3.11,3.08,3.02,3.01,3,3,3,3,3,3,3,3.01,3.01,3.01,3,3,3,3,3,3.10,3.12,3.13,3.15,3.24,3.37,3.46,3.14,2.82,2.37,2.01,1.82,1.62,1.37,1.25,1.12,1,1,1,1,0.99,0.98,0.98,0.98,1,1,1,1,1.12,1.12,1.87,2,2,2,2,2,2.02,2.08,2.12,2.13,2.25,2.38,2.37,2.37,2.32,2.25,2.24,2.33,2.48,2.65,2.88,3.15,3.46,3.75,4.12,4.50,4.85,5.11,5.25,5.37,5.39,5.46,5.50,5.87,6,6.12,6.12,6.12,6.01,5.98,5.95,5.99,6.12,6.40,6.85,7.35,7.85,8.32,8.70,8.95,9.07,9.02,8.89,8.74,8.50,8.25,8,7.85,7.61,7.57,7.61,7.75,8.02,8.59,9.37,10.50,11.85,13.62,13.85,13.62,13.12,12.62,12.25,12.12,12.07,11.87,11.70,11.50,11.33,11.11,11,10.99,10.96,10.76,10.50,10.25,10.07,10.01,10,10,9.86,9.58,9.26,9.22,9,8.37,8.23,7.71,7.23,6.70,6.26,5.70,5.33,5.07,5.37,6.37,7.75,9.59,10.25,11.59,12.62,13.72,14.61,15.25,15.63,15.83,15.75,15.60,15.46,15.52,15.62,15.61,15.32,14.76,14.37,14.25,14.37,14.70,15,15.26,15.35,15.21,14.90,14.59,14.15,13.75,13.34,13.07,13.07,13.38,13.99,14.71,15.24,15.37,14.99,14.37,13.83,13.14,13,12.97,11,10,9,7,6,4,2.12,1.25,1,1,1.01,1.37,2.07,3,4,5.08,6.37,7.87,9.50,11.14,12.89,14.48,15.71,16.83,17.72,17.48,-9.88,-10,-10,-10,-10,-10,-10,-11,-11,-12,-13,-14,-14,-15,-15,-14,-14,-14,-13,-13,-13,-12,-12,-11,-11,-10,-10,-10,-9.64,-8.77,-9,-8.48,-8.75,-9.29,-10,-10,-11,-11,-11,-11,-10,-9.26,-7.78,-6.23,-4.88,-5.29,-6.87,-8.67,-7.91,-6.88,-6.03,-4.43,-2.93,-3.77,-4.51,-4.25,-5,-7.75,-14,-10,-3.63,-0.65,0.37,0.95,0.99,0.99,1,1,1,1.12,1.32,1.65,1.87,1.98,1.99,1.99,2,2,2,2.08,2.11,2.13,2.24,2.35,2.49,2.62,2.73,2.77,2.82,2.75,2.75,2.62,2.50,2.38,2.37,2.37,2.37,2.37,2.37,2.37,2.38,2.45,2.47,2.49,2.50,2.52,2.60,2.62,2.62,2.60,2.58,2.50,2.49,2.46,2.45,2.38,2.47,2.39,2.32,2.27,2.33,2.35,2,1.72,1.33,1.26,1.15,1,0.87,1,1,1,1,0.99,0.97,0.96,0.95,0.87,0.87,0.87,0.87,0.95,1,1.13,1.37,1.74,1.99,2,2,2,2,2,2,2,2,2.02,2.09,2.12,2.12,2.13,2.25,2.46,2.72,2.96,3.22,3.57,3.99,4.39,4.87,5.36,5.76,6.15,6.48,6.64,6.75,6.77,6.82,7.07,7.14,7.20,7.12,7,6.87,6.74,6.62,6.63,6.77,7.13,7.57,8.02,8.58,9.10,9.51,9.87,10.09,10.12,10.02,9.87,9.62,9.35,9.08,8.83,8.62,8.50,8.37,8.50,8.77,9.25,9.99,10.95,11.99,13.09,13.62,13.22,12.46,11.59,11.57,11.50,11.50,11.40,11.36,11.25,11.13,10.95,10.62,10.37,10.11,9.84,9.57,9.35,9.22,9.12,9.12,9.11,8.95,8.72,8.50,8.47,8.32,8.12,7.77,7.33,7.10,6.65,6.26,5.70,5.34,5.08,5.38,6.37,7.75,9.07,10.21,11.26,12.60,13.37,14.14,14.95,15.50,15.75,15.83,15.82,15.84,15.87,15.90,15.82,15.61,15.01,14.60,14.47,14.75,15.12,15.47,15.71,15.75,15.72,15.51,15.25,14.95,14.50,14.12,13.82,13.76,14.12,14.62,15.23,15.65,15.75,15.46,14.96,14.37,14.12,13.95,12.96,11,9.99,8.99,7,6,4,2,1.07,1.12,1,1,1.37,2.02,3,4,5.07,6.37,7.84,9.48,11.13,12.83,14.37,15.72,16.96,18.57,18.64,-9.42,-9.63,-9.75,-9.77,-9.80,-10,-10,-11,-12,-12,-13,-14,-15,-14,-14,-14,-14,-13,-13,-13,-12,-12,-12,-11,-11,-10,-9.77,-9.75,-7.75,-6.25,-6.25,-6.77,-7.48,-8.39,-9.51,-10,-11,-12,-12,-12,-11,-9.75,-7.75,-5.50,-2.41,-2.18,-2.67,-3.68,-3.75,-4.37,-5.38,-5.77,-4.77,-5.02,-6.79,-4.91,-3.62,-3.25,-4.18,-4.63,-2.63,-0.65,0.33,0.82,0.95,0.98,0.99,1,1,1,1.07,1.75,1.95,1.98,1.98,1.98,1.98,1.98,1.98,1.99,2,2,2.07,2.12,2.21,2.25,2.33,2.35,2.37,2.34,2.20,2.22,2.11,1.89,1.84,1.75,1.76,1.77,1.77,1.84,1.87,1.97,2,2.10,2.13,2.25,2.37,2.40,2.47,2.45,2.37,2.25,2.13,2.12,2.09,2.07,2.01,2,1.99,2,2,2,1,1.12,1.12,0.97,0.87,0.71,0.50,0.36,0.50,0.83,1,0.95,0.87,0.87,0.75,0.73,0.70,0.62,0.62,0.73,0.84,1,1.12,1.25,1.32,2,2,2,2,2,2,1.98,1.90,1.87,2,2.02,2.15,2.27,2.50,2.82,3.12,3.37,3.71,4.20,4.75,5.26,5.84,6.37,6.90,7.46,7.87,8.21,8.37,8.45,8.39,8.39,8.37,8.27,8.12,7.90,7.70,7.49,7.37,7.40,7.60,7.87,8.25,8.73,9.23,9.74,10.22,10.61,10.87,11.01,11.01,10.89,10.73,10.48,10.21,9.90,9.71,9.50,9.47,9.50,9.70,10.12,10.75,11.52,12.32,13.23,13.62,13.23,12.27,11.37,11.37,11.32,11.36,11.39,11.49,11.46,11.25,10.90,10.48,9.99,9.58,9.25,8.99,8.74,8.58,8.50,8.50,8.45,8.37,8.25,8.15,8.12,8.07,8,7.71,7.33,7,6.65,6.27,5.76,5.37,5.14,5.38,6.25,7.59,8.85,9.87,10.87,11.76,12.77,13.70,14.52,15.22,15.62,15.85,15.97,16.10,16.20,16.22,16.11,15.82,15.36,14.89,14.82,15.08,15.59,15.87,16.10,16.20,16.20,16.12,15.96,15.70,15.34,14.96,14.62,14.50,14.75,15.15,15.64,16,16.02,15.76,15.37,15.09,14.77,14.82,12.90,11.02,9.99,8.98,7,6,4,2,2,1,1,1,1.32,2,3,4.07,5.12,6.49,7.87,9.49,11.12,12.75,14.21,15.37,16.85,17.83,17.87,-9,-9.13,-9.25,-9.37,-9.50,-10,-10,-11,-12,-12,-13,-13,-13,-14,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-10,-10,-8.67,-7.01,-5.15,-4,-3.65,-4.61,-5.63,-7.03,-8.49,-10,-11,-13,-14,-13,-12,-10,-7.98,-5.36,-3,-0.15,0.25,0.37,-1.28,-1.63,-1.75,-4.77,-5.52,-3.63,-4.03,-2.75,-1,-0.63,-0.65,-0.75,-0.67,-0.25,0.32,0.62,0.86,0.95,0.99,1,1.09,1.08,1.98,2,1.98,1.99,1.99,1.97,1.90,1.87,1.87,1.87,1.87,1.88,1.89,1.90,1.97,2,2.07,2.01,2.01,2.02,2.01,2,1.86,1.62,1.40,1.35,1.35,1.37,1.37,1.38,1.50,1.62,1.72,1.77,1.89,2.07,2.24,2.36,2.40,2.48,2.35,2.13,2,1.95,1.95,1.97,1.99,1.99,2,1,1,1,1.12,1,1,0.87,0.62,0.25,-0.25,-0.42,-0.25,0.34,0.73,0.87,0.75,0.50,0,0.09,0.23,0.25,0.33,0.37,0.60,0.82,0.98,1,1.12,1.13,2,2,2,2,1,1,1,1.95,2,2.12,2.37,2.62,2.90,3.25,3.63,3.99,4.40,5.01,5.65,6.27,6.87,7.51,8.20,8.83,9.38,9.87,10.15,10.23,10.08,9.75,9.52,9.32,9,8.71,8.38,8.21,8.13,8.22,8.37,8.62,8.99,9.37,9.85,10.26,10.74,11.12,11.48,11.72,11.84,11.85,11.75,11.59,11.36,11.10,10.84,10.62,10.50,10.57,10.75,11.02,11.62,12.35,13.07,13.77,14.09,13.70,12.76,11.97,11.39,11.61,11.65,11.76,11.88,11.87,11.62,11.09,10.45,9.76,9.34,9,8.75,8.50,8.27,8.15,8.13,8.12,8.15,8.12,8.07,8.01,8,7.99,7.75,7.32,7.12,6.76,6.37,5.99,5.60,5.37,5.38,6.25,7.34,8.59,9.59,10.37,11.25,12.25,13.24,14.12,14.87,15.40,15.75,16.02,16.25,16.47,16.50,16.45,16.14,15.75,15.35,15.22,15.39,15.88,16.32,16.52,16.61,16.65,16.72,16.63,16.49,16.14,15.75,15.45,15.25,15.37,15.71,16.08,16.34,16.36,16.12,15.87,15.65,15.50,14.64,13.02,11.07,9.99,8.96,7,5.99,4,3,2,1,1,1,1.09,2,3.01,4.12,5.33,6.63,8.08,9.60,11.15,12.75,14.14,15.39,16.72,17.85,17.88,-8.50,-8.63,-8.75,-8.87,-9.26,-9.88,-10,-11,-11,-12,-12,-12,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-11,-11,-10,-9.03,-7.50,-4.50,-1.43,-1.41,-1.50,-1.52,-3.63,-5.36,-7.11,-9.05,-11,-13,-14,-15,-13,-10,-8.37,-5.86,-3.67,-2.03,-0.68,0.36,0.34,0.36,-1.29,-3.13,-6.12,-5,-2.75,-0.50,0.34,0.59,0.62,0.25,0.09,0.20,0.45,0.62,0.84,0.87,0.99,1,1.12,1.37,1.75,1.95,2,2,2,1.95,1.87,1.75,1.64,1.61,1.60,1.60,1.60,1.62,1.71,1.75,1.87,2,2,1.98,1.95,1.87,1.87,1.24,1.14,1.09,1.08,1.10,1.12,1.12,1.25,1.36,1.46,1.52,1.64,1.84,2.01,2.23,2.33,2.37,2.25,2,1.83,1.74,1.75,1.87,2,2,1,1,1,1.12,1.21,1.07,0.87,0.75,0.45,-0.18,-1,-1.55,-1.63,-1.50,-1.38,-1.38,-1.38,-1.63,-1.50,-1.13,-0.67,-0.42,-0.27,-0.01,0.34,0.63,0.87,0.97,1,1.12,1,1,1,1,1,1,1,1.99,2,2.07,2.85,3.12,3.40,3.89,4.34,4.73,5.26,5.99,6.71,7.37,8.07,8.75,9.48,10.22,10.87,11.48,11.85,11.87,11.59,10.95,10.48,10.07,9.63,9.27,9,8.89,8.88,9,9.21,9.47,9.75,10.12,10.48,10.85,11.22,11.57,11.87,12.20,12.45,12.61,12.64,12.62,12.49,12.25,12,11.75,11.62,11.62,11.76,12.12,12.58,13.25,14.10,14.87,15.02,14.72,13.25,12.36,12.25,12.13,12.27,12.37,12.50,12.39,12,11.25,10.45,9.71,9.25,8.98,8.75,8.51,8.33,8.21,8.14,8.13,8.21,8.12,8.14,8.13,8.12,8.11,7.95,7.70,7.33,7.12,6.75,6.33,5.87,5.37,5.71,6.24,7,7.98,8.87,9.76,10.73,11.74,12.72,13.63,14.49,15.12,15.62,16,16.40,16.58,16.82,16.75,16.62,16.25,15.87,15.65,15.76,16.13,16.50,16.82,17,17.20,17.35,17.45,17.37,17.10,16.62,16.12,15.87,15.87,16.15,16.50,16.72,16.62,16.45,16.25,16.21,16,15.50,13.14,11.09,10,8.95,7.01,5.98,4,3,2,1,1,1,1.11,2,3,4.22,5.61,6.87,8.32,9.64,11.32,12.87,14.50,15.75,16.98,17.87,17.72,-8.12,-8.16,-8.25,-8.40,-8.93,-9.75,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-9.80,-8.25,-5.90,-3.30,-1.27,0.50,0.49,-0.75,-1.51,-3.38,-5.50,-7.68,-10,-12,-15,-15,-14,-11,-8.78,-6.49,-4.64,-3.13,-1.50,0.36,0.62,0.48,0.50,-1.38,-4.67,-6.63,-2.88,0,0.62,0.74,0.50,0.34,0.24,0.25,0.47,0.62,0.82,0.87,0.98,1,1.12,1.37,1.61,1.87,2.09,2.11,2,1.96,1.83,1.62,1.07,1,1,1,1,1,1,1,1,1,1,1,1,1.02,1.09,1.11,1,1,1,1,1,1.02,1.11,1.13,1.23,1.26,1.37,1.49,1.62,1.74,1.83,1.87,1.75,1.59,1.40,1.37,1.37,1.12,1.12,1.09,1,2,2,1.50,1.25,0.87,0.50,0.25,0.09,-0.63,-1.75,-3,-3.38,-3.52,-3.54,-3.60,-3.64,-3.65,-3.50,-3.10,-2.50,-1.63,-1.13,-0.50,0.12,0.60,0.75,0.87,0.97,0.99,1,1,1,1,1,1,2,2,2,2.98,3.01,3.90,4.20,4.71,5.12,5.48,6.13,6.98,7.75,8.50,9.25,9.98,10.74,11.47,12.12,12.75,13.25,13.33,12.75,11.73,11.02,10.50,10.07,9.74,9.60,9.58,9.64,9.85,10.08,10.34,10.62,10.87,11.14,11.40,11.70,11.97,12.25,12.58,12.88,13.23,13.46,13.58,13.51,13.37,13.13,12.90,12.75,12.75,12.86,13.12,13.60,14.21,15.02,16.62,16.65,15.25,14.34,13.48,13.26,13.12,13.10,13.10,13.22,13.02,12.25,11.24,10.37,9.65,9.32,9.12,9,8.84,8.64,8.58,8.49,8.37,8.40,8.49,8.50,8.51,8.59,8.52,8.38,8.25,8,7.63,7.23,6.75,6.24,5.98,5.89,6.23,6.72,7.37,8.33,9.25,10.25,11.24,12.22,13.14,14,14.72,15.37,15.65,16.07,16.40,16.75,17.15,17,16.76,16.37,16.12,16.09,16.36,16.70,17,17.36,17.62,17.87,18.08,18.10,17.82,17.35,16.87,16.57,16.52,16.75,16.99,17.08,16.98,16.77,16.65,16.50,16.25,15.38,13.35,11.21,10.09,8.90,7.02,5.97,4.98,3,2,1,0.99,0.99,1.25,2,3,4.32,5.62,6.98,8.27,9.65,11.27,12.86,14.50,15.86,17.09,18.48,18.51,-7.66,-7.76,-7.87,-8.25,-9,-9.75,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-9.38,-7.63,-5.13,-1.40,-0.63,0.50,0.50,0.38,-0.90,-2,-3.50,-6.04,-8.75,-11,-13,-14,-13,-11,-9.24,-7.11,-5.38,-4,-2.04,0.25,0.50,0.50,0.33,-0.63,-1.38,-3.93,-4.90,-0.13,0.71,0.58,-0.13,-0.38,-0.25,0,0.25,0.58,0.75,0.87,0.95,1,1.12,1.25,1.49,1.75,2,2.07,1.97,1.75,1.61,1.36,1.12,1,1,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,0.99,1,0.99,0.99,1,1.02,1.09,1.10,1.07,1.01,1,1,1,1,1.01,1.10,1.13,1.20,1.12,1.02,0.98,0.90,0.87,0.98,1,1.12,1.13,1.87,1.96,2,1.62,1.23,0.59,-0.04,-0.51,-0.77,-1.12,-3.25,-4.28,-4.88,-5.14,-5.26,-5.35,-5.38,-5.38,-5.14,-4.75,-4.15,-3.27,-2.18,-1.13,-0.18,0.37,0.62,0.75,0.87,0.95,0.98,1,1,1,1,2,2,2,3,3,4,4.99,5,5.96,6,6.23,7.01,7.97,8.87,9.65,10.39,11.12,11.87,12.58,13.15,13.74,14.23,14.10,13.20,12.12,11.27,10.71,10.26,10.12,10.10,10.21,10.39,10.70,10.99,11.25,11.51,11.75,11.90,12.09,12.22,12.37,12.60,12.87,13.25,13.71,14.09,14.37,14.49,14.46,14.25,14.08,13.88,13.85,13.89,14.12,14.50,15.07,15.82,16.63,16.87,16.71,15.64,14.98,14.50,14.23,13.95,13.75,13.45,12.88,11.89,10.97,10.08,9.62,9.39,9.37,9.37,9.32,9.21,9.20,9.27,9.37,9.33,9.37,9.38,9.50,9.50,9.46,9.34,9.12,8.82,8.33,7.75,7.22,6.64,6.24,6.01,6.12,6.37,7.12,7.87,8.76,9.70,10.64,11.62,12.58,13.39,14.12,14.62,15.11,15.51,16,16.48,16.96,17.25,17.22,16.87,16.52,16.37,16.52,16.87,17.25,17.65,18.08,18.38,18.62,18.70,18.47,18,17.52,17.24,17.14,17.26,17.45,17.46,17.32,17.10,16.88,16.74,16.20,14.99,13.50,11.87,10.10,8.89,7.07,6.01,4.97,3,2,1.10,0.99,0.99,1.22,1.75,2.75,4.09,5.38,6.75,8.09,9.47,10.96,12.50,14.15,15.50,16.75,17.50,17.37,-7.25,-7.37,-7.50,-8.15,-8.88,-9.63,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.13,-7.50,-5.04,-1.43,0.58,0.50,0.37,0.32,-0.38,-1,-2.43,-4.50,-7,-9.50,-11,-13,-12,-11,-9.60,-7.63,-6,-4.42,-2.67,0.12,0.12,0.46,0.37,0.35,0.49,-2.64,-5.75,-6,-3.92,-2.50,-2,-1.63,-1.25,-0.65,-0.05,0.37,0.62,0.75,0.86,0.87,0.99,1.11,1.25,1.50,1.73,1.75,1.70,1.50,1.36,1.21,1.09,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1.01,1.12,1.25,1.25,1.12,1,0.87,0.82,0.72,0.62,0.52,0.50,0.49,0.39,0.35,0.26,0.25,0.37,0.59,0.75,0.97,1.12,1.75,1.75,1.87,1.98,1.33,0.85,0.08,-0.88,-1.80,-2.54,-3.79,-4.75,-5.62,-6.14,-6.50,-6.67,-6.77,-6.79,-6.75,-6.65,-6.24,-5.52,-4.75,-3.63,-2.17,-0.88,0,0.46,0.62,0.75,0.87,0.96,1,1.12,1.12,1.95,2,2,3,4,4,5,6,6,7,7,7,8,8.99,9.96,10.83,11.52,12.25,12.96,13.62,14.21,14.51,14.87,14.27,13.26,12.14,11.34,10.75,10.39,10.40,10.52,10.82,11.13,11.51,11.89,12.25,12.50,12.64,12.75,12.75,12.76,12.83,12.96,13.21,13.60,14.09,14.59,15,15.27,15.37,15.33,15.14,15,14.95,14.99,15.12,15.39,15.83,16.26,16.89,17.75,17.61,16.89,16.13,15.61,15.15,14.97,13.75,12.88,12.01,11.25,10.50,10.09,9.87,9.86,9.98,10.12,10.25,10.37,10.50,10.62,10.63,10.62,10.62,10.64,10.73,10.75,10.72,10.57,10.25,9.74,9.07,8.33,7.62,7,6.37,6.13,6.08,6.25,6.77,7.60,8.32,9.12,10,10.98,11.87,12.71,13.37,13.87,14.33,14.83,15.36,15.89,16.52,17.02,17.27,17.13,16.87,16.65,16.75,17.10,17.50,17.99,18.45,18.83,19.10,19.22,19,18.60,18.13,17.86,17.75,17.77,17.87,17.82,17.62,17.36,17.07,16.64,15.98,14.96,13.72,12.59,10.77,9.09,7.89,6.02,4.96,3,2,1.25,0.99,1,1.12,1.58,2.46,3.75,5.08,6.37,7.74,9.08,10.50,11.98,13.50,14.85,16.08,16.85,16.23,-6.75,-6.80,-7.38,-8.01,-8.63,-9.41,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-10,-10,-9.13,-7.76,-6.13,-3.25,-3.38,-2.41,-1.50,-0.63,0.23,0.22,-1.60,-3.25,-5.25,-7.43,-9.61,-11,-11,-11,-9.92,-8.17,-6.53,-5.10,-3.43,-1.91,0.10,0.12,0.37,0.58,0.37,-1.50,-3.38,-6.88,-7.88,-5.63,-4.03,-3.50,-2.75,-1.63,-0.54,0.12,0.47,0.59,0.62,0.63,0.74,0.84,1,1.25,1.36,1.37,1.34,1.23,1.10,1,0.98,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.25,1.70,1.65,1.22,0.97,0.76,0.57,0.38,0.12,-0.01,-0.15,-0.30,-0.53,-0.66,-0.55,-0.38,-0.01,0.34,0.62,0.87,1.08,1.23,1.25,1.13,1.09,1,0.37,-0.63,-2.02,-3.54,-4.79,-5.66,-6.38,-6.89,-7.39,-7.76,-8,-8.12,-8.12,-8,-7.73,-7.39,-6.75,-5.90,-4.98,-3.87,-2.29,-1.13,-0.25,0.25,0.25,0.37,0.62,0.95,1.25,1.63,2.12,2.58,3.12,4,5,5,6,7,7,8,8,9,9,10,10.98,11.90,12.59,13.25,13.97,14.58,14.98,15,14.86,14.08,13.02,12.02,11.25,10.75,10.62,10.73,11,11.37,11.87,12.37,12.83,13.21,13.46,13.58,13.58,13.50,13.37,13.27,13.33,13.50,13.87,14.37,14.99,15.50,15.96,16.20,16.25,16.20,16.11,16,16,16.12,16.26,16.50,16.87,17.25,17.70,18.50,17.37,17.23,16.20,15.52,14.46,13.33,12.09,11.20,10.50,10.21,10.11,10.13,10.34,10.64,11.02,11.40,11.73,11.99,12.12,12.12,12,11.99,12,12.08,12.12,12.08,11.76,11.38,10.61,9.73,8.76,8,7.34,6.76,6.36,6.14,6.14,6.36,7.12,7.84,8.50,9.37,10.32,11.14,11.89,12.50,13,13.46,13.99,14.57,15.15,15.86,16.47,16.89,17,16.97,16.87,17,17.27,17.75,18.25,18.75,19.13,19.40,19.51,19.36,19,18.62,18.37,18.27,18.33,18.34,18.24,17.96,17.59,17.12,16.61,15.87,14.97,13.86,12.51,10.87,9.10,7.88,6.90,4.96,3.12,2,1.33,1,1,1,1.35,2.12,3.36,4.70,6,7.25,8.52,9.87,11.32,12.73,14.09,15.25,16.14,16.10,-6.17,-6.42,-7.03,-7.88,-8.55,-9.38,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-10,-10,-9.17,-8.25,-7.52,-8.25,-7.17,-5.66,-3.25,-1.51,0.13,0.22,-1.13,-2.25,-3.55,-5.49,-7.64,-9.75,-11,-11,-10,-8.68,-7.15,-5.76,-4.61,-2.91,-1.50,-0.38,0.25,0.50,0.23,0.12,-1.64,-2.88,-4.16,-5.25,-5.29,-6.50,-4.53,-2.75,-1.05,-0.18,0,0.10,0.12,0.20,0.25,0.36,0.50,0.84,0.86,0.87,0.86,0.75,0.71,0.72,0.75,0.87,0.95,0.98,0.98,0.98,0.99,0.98,0.98,0.98,0.98,0.99,0.99,0.99,0.98,0.98,0.98,1,1.24,1.70,1.70,1.12,0.87,0.60,0.12,-0.25,-0.88,-1.13,-1.65,-2.02,-2.15,-1.98,-1.50,-0.92,-0.42,0,0.32,0.62,0.83,0.95,1,1,0.87,0.37,-0.28,-2.05,-3.78,-5.10,-6,-6.65,-7.24,-7.75,-8.18,-8.62,-8.99,-9.13,-9.24,-9.03,-8.75,-8.28,-7.75,-7,-6.25,-5.39,-4.13,-3,-1.75,-1.26,-0.80,-0.28,0.25,0.75,1.35,1.87,2.48,3,3.70,4.58,5,6,8,8,9,9,10,10,10,11.12,11.99,12.77,13.51,14.24,14.88,15.50,15.62,15.20,14.62,13.75,12.74,11.72,11.12,10.75,10.82,11,11.39,11.95,12.50,13.12,13.63,14.09,14.34,14.38,14.34,14.13,13.96,13.75,13.73,13.86,14.20,14.72,15.33,15.96,16.48,16.86,17.02,17.12,17.12,17.08,17.02,17.08,17.12,17.24,17.37,17.75,17.62,17.48,17.22,16.64,16.12,15.25,14.07,12.75,11.50,10.87,10.50,10.40,10.40,10.51,10.87,11.38,11.99,12.51,13.10,13.45,13.75,13.63,13.40,13.33,13.33,13.37,13.45,13.32,13.13,12,11.50,10.21,9.24,8.32,7.75,7.23,6.75,6.34,6.15,6.35,6.82,7.46,8.10,8.86,9.70,10.47,11.12,11.62,12.10,12.57,13.11,13.72,14.36,15,15.61,16.20,16.59,16.76,16.87,17.12,17.47,17.95,18.49,19,19.38,19.62,19.70,19.57,19.27,19.01,18.87,18.86,18.88,18.87,18.72,18.26,17.75,17.12,16.50,15.73,14.86,13.85,12.50,10.87,9.11,8,6.89,4.97,3.25,2,1.34,1,0.99,1,1.36,2,3.23,4.40,5.62,6.76,7.90,9.24,10.61,11.99,13.36,14.73,15.73,14.98,-5.63,-6.02,-6.88,-7.75,-8.41,-9.13,-9.63,-9.88,-10,-10,-10,-10,-10,-9.90,-9.99,-10,-10,-10,-10,-10,-10,-11,-10,-10,-9.13,-8.35,-8.35,-9.88,-9.25,-7.62,-4.67,-1.75,-1.16,-0.75,-0.80,-1.17,-1.99,-3.60,-5.93,-8.28,-10,-11,-10,-9.05,-7.75,-6.48,-5.15,-3.87,-2.42,-1.25,0.22,0.13,0.25,0.12,0.12,-0.01,-2.01,-2.88,-5,-8.39,-6.13,-4.01,-2.25,-1.38,-1,-0.88,-0.88,-0.75,-0.52,-0.40,-0.30,0.10,0.11,0.11,0.11,0.08,0,0.21,0.46,0.70,0.87,0.95,0.98,0.95,0.88,0.88,0.96,0.97,0.98,0.98,0.99,0.99,0.96,0.88,0.87,0.97,1.10,1.21,1.12,0.52,-0.25,-1.10,-1.76,-2.26,-2.63,-2.92,-3.25,-3.61,-3.75,-3.24,-2.38,-1.50,-0.86,-0.38,-0.04,0.23,0.50,0.75,0.87,0.95,0.84,-0.50,-2.25,-3.74,-5.02,-6,-6.75,-7.36,-7.86,-8.29,-8.77,-9.37,-9.75,-10,-10,-10,-9.67,-9.25,-8.66,-8,-7.37,-6.77,-5.77,-4.89,-3.88,-2.88,-2,-1.13,-0.25,0.57,1.33,2,2.71,3.36,4,4.62,5.25,6,8,9,10,10,11,11,11.87,12.25,12.99,13.73,14.39,15.10,15.75,16.27,15.97,15.24,14.37,13.39,12.45,11.50,11.08,10.89,11,11.35,11.84,12.45,13.11,13.75,14.37,14.83,15.08,15.11,14.98,14.74,14.47,14.24,14.12,14.23,14.51,15.01,15.63,16.33,16.89,17.37,17.74,17.95,18,18.02,18,18,18,17.99,17.87,17.63,17.34,16.90,16.60,16.25,15.77,15,13.85,12.62,11.62,11.21,11.11,11.11,11.12,11.23,11.52,12.12,12.77,13.50,14.12,14.62,15.10,15,14.75,14.62,14.51,14.60,14.47,13.99,13.12,12.33,11.36,10.37,9.72,9,8.26,7.75,7.23,6.75,6.34,6.36,6.71,7.24,7.76,8.45,9.14,9.84,10.37,10.87,11.26,11.65,12.26,12.89,13.52,14.14,14.83,15.38,15.90,16.35,16.75,17.08,17.48,17.98,18.58,19.12,19.52,19.75,19.82,19.72,19.52,19.39,19.37,19.45,19.50,19.48,19.21,18.62,17.87,17.10,16.33,15.50,14.62,13.57,12.37,10.70,9.11,7.87,6.89,4.87,3.33,2,1.34,1,0.99,1,1.37,2.01,3.09,4.14,5.25,6.25,7.37,8.61,9.90,11.25,12.62,13.95,14.83,14.87,-5.25,-6,-6.75,-7.62,-8.26,-8.78,-9.30,-9.63,-9.80,-9.88,-9.88,-9.78,-9.67,-9.60,-9.62,-9.62,-9.64,-9.77,-10,-10,-10,-10,-10,-9.88,-8.65,-7.67,-7.50,-9.13,-8.25,-6.76,-4.16,-2.67,-1.75,-1.29,-0.63,-0.29,-0.66,-2.10,-4.38,-6.78,-9.02,-10,-10,-9.25,-8.25,-7.04,-5.78,-4.49,-3.14,-1.91,-0.98,-0.16,0.13,0.37,0.48,0.07,-0.13,-1.75,-3.50,-4.88,-5.75,-5.29,-4.25,-3.28,-2.75,-2.67,-2.63,-2.17,-1.76,-1.63,-1.63,-1.38,-1.50,-1.38,-1.18,-1.13,-1.13,-0.77,-0.27,0.37,0.62,0.84,0.87,0.75,0.75,0.82,0.87,0.88,0.97,0.98,0.99,0.99,0.87,0.75,0.72,0.75,0.83,0.87,0.46,-0.39,-1.88,-3.10,-3.91,-4.25,-4.38,-4.50,-4.65,-4.78,-4.75,-4.27,-3.14,-2.04,-1.26,-0.85,-0.62,-0.29,0.12,0.62,0.87,0.75,0.83,-1.92,-3.73,-5.17,-6.25,-7,-7.53,-8,-8.40,-8.88,-9.35,-9.80,-10,-10,-10,-10,-10,-10,-9.50,-8.86,-8.14,-7.50,-7.05,-6.50,-5.89,-4.18,-3.04,-1.88,-0.75,0.25,1.23,2,2.75,3.49,4.12,4.74,5.37,6,8,9,10,12,12,12.99,12.88,13.34,13.89,14.61,15.25,15.87,16.39,16.62,16.07,15.15,14.15,13.12,12.23,11.39,10.87,11.08,11.26,11.70,12.24,12.87,13.59,14.25,14.87,15.36,15.61,15.62,15.47,15.20,14.87,14.63,14.52,14.62,14.90,15.38,16,16.64,17.26,17.84,18.25,18.60,18.76,18.87,18.87,18.87,18.85,18.70,18.37,17.62,16.87,16.36,16.12,16.02,15.84,15.24,14.27,13.20,12.39,12.11,12.07,12.12,12.22,12.25,12.45,12.87,13.52,14.32,15,15.62,16.10,16.10,15.87,15.75,15.63,15.38,14.83,14.01,13.23,12.37,11.52,10.87,10.25,9.75,9.12,8.25,7.75,7.23,6.76,6.36,6.75,7.13,7.58,8.12,8.75,9.33,9.77,10.23,10.62,11.11,11.59,12.25,12.84,13.49,14.13,14.75,15.32,15.77,16.32,16.75,17.21,17.75,18.37,19,19.50,19.84,19.96,19.96,19.87,19.87,19.95,20.01,20.10,20,19.59,18.83,17.89,16.97,16.01,15.12,14.15,13.14,11.87,10.40,9,7.87,6.20,4.75,3.33,2,1.35,1,0.99,1,1.37,2,2.95,3.84,4.77,5.72,6.84,8.07,9.37,10.65,11.87,13.02,13.83,12.75,-5.13,-5.90,-6.64,-7.50,-8.25,-8.68,-9.25,-9.53,-9.67,-9.74,-9.66,-9.60,-9.42,-9.28,-9.25,-9.16,-9.15,-9.25,-9.39,-9.68,-10,-10,-10,-9.12,-7.54,-6.17,-5.50,-4.93,-4.75,-4.04,-3.25,-2.38,-1.78,-1.25,-0.62,0.12,-0.26,-1.17,-2.90,-5.52,-7.61,-9,-9.53,-9.38,-8.65,-7.63,-6.41,-5.10,-3.75,-2.54,-1.50,-0.67,0,0.38,0.61,0.45,0,-0.53,-1.63,-2.65,-3.79,-6.25,-6.88,-4.63,-4.68,-5,-4.89,-4.27,-3.66,-3.50,-3.54,-3.63,-3.63,-3.52,-3.38,-3.13,-2.80,-2.37,-1.53,-0.75,0.37,0.48,0.48,0.12,0.36,0.50,0.74,0.82,0.87,0.95,0.88,0.87,0.74,0.48,0.13,0,0.62,0.47,-0.03,-1.80,-3.52,-5.67,-6.17,-6.15,-5.90,-5.86,-5.85,-5.85,-5.63,-5.01,-4,-2.87,-2.03,-1.65,-1.52,-1.27,-0.77,0.62,0.75,0.75,-1.49,-3.35,-5.05,-6.38,-7.25,-7.86,-8.25,-8.61,-8.92,-9.35,-9.77,-10,-10,-11,-11,-11,-11,-10,-10,-9.39,-8.73,-7.93,-7.24,-6.50,-5.50,-5,-3.88,-2.38,-1.03,0.11,1.10,1.98,2.75,3.49,4.12,4.75,5.37,6.09,7,8,10,12,12,13.98,13.73,14.13,14.70,15.34,16,16.51,16.87,16.85,16.11,15.12,14.09,13.01,12.12,11.46,11.07,11.26,11.61,12.07,12.62,13.25,13.95,14.62,15.23,15.63,15.87,15.89,15.75,15.50,15.25,15.07,14.99,15.09,15.37,15.83,16.37,16.99,17.59,18.12,18.61,19,19.25,19.47,19.61,19.65,19.51,19.13,18.39,17.57,16.50,16.25,16.25,16.45,16.36,15.89,15.12,14.21,13.40,13.11,13.12,13.33,13.40,13.40,13.40,13.65,14.32,15.10,15.84,16.37,16.62,16.71,16.62,16.52,16.33,15.75,15,14.12,13.27,12.51,11.99,11.47,11.13,10.75,10,9.12,8.26,7.71,7.12,6.87,6.88,7.12,7.48,7.90,8.48,8.99,9.38,9.65,10.24,10.63,11.24,11.87,12.50,13.12,13.75,14.32,14.77,15.26,15.75,16.24,16.74,17.34,18,18.75,19.37,19.84,20.11,20.24,20.33,20.38,20.50,20.62,20.59,20.33,19.75,18.87,17.84,16.75,15.72,14.73,13.75,12.65,11.45,10.09,8.87,7.11,6,4.57,3.24,2,1.35,1,0.99,1,1.25,1.83,2.58,3.37,4.25,5.25,6.37,7.62,8.95,10.12,11.22,12.07,12.60,11.72,-5.15,-6.02,-6.75,-7.63,-8.39,-9.01,-9.39,-9.60,-9.64,-9.63,-9.53,-9.38,-9.23,-9,-8.88,-8.74,-8.61,-8.50,-8.50,-8.63,-8.88,-9.04,-8.75,-7.68,-6.02,-4.05,-2.85,-2.02,-2,-2,-1.88,-1.64,-1.38,-1.02,-0.63,-0.38,-0.38,0,-2.42,-4.61,-6.75,-8.40,-9.38,-9.64,-9.18,-8.30,-7,-5.63,-4.26,-3.01,-1.91,-0.99,-0.13,0.37,0.71,0.62,0.50,0.24,-0.25,-0.87,-1.18,-3.25,-4.15,-4.78,-5.75,-8.50,-7.41,-6.12,-5.63,-5.50,-5.42,-5.41,-5.42,-5.38,-5.24,-5,-4.64,-4.13,-3.38,-1.90,-1.55,-1.40,-1.25,-1,-0.55,-0.18,0.24,0.50,0.75,0.75,0.75,0.63,0.49,-0.13,-0.88,-1.50,-1.75,-2,-2.50,-3.51,-5.03,-6.64,-7.49,-7.29,-6.99,-6.77,-6.73,-6.63,-6.42,-6,-5.16,-4.13,-3.37,-3.01,-2.93,-2.77,-2.38,-1.42,-1.38,-1.98,-3.25,-4.65,-5.99,-7.05,-7.91,-8.60,-8.88,-9.13,-9.38,-9.75,-10,-10,-11,-11,-12,-12,-11,-11,-10,-9.80,-8.93,-8.13,-7.13,-6,-4.88,-3.99,-3.78,-2.16,-1,0.07,1,1.87,2.62,3.37,4.11,4.75,5.45,6,7,8,10,11,12,13,14.63,14.60,15.12,15.64,16.32,16.75,16.97,16.84,16.10,15.12,14.08,13.02,12.23,11.62,11.35,11.62,11.96,12.39,12.97,13.57,14.20,14.77,15.34,15.74,15.97,16,15.95,15.75,15.59,15.45,15.39,15.51,15.83,16.24,16.74,17.25,17.75,18.25,18.65,19.07,19.37,19.63,19.87,20,19.76,19.22,18.35,17.47,16.57,16.60,16.83,17.13,17.20,17,16.21,15.34,14.51,14.22,14.32,14.50,14.75,14.50,14.38,14.46,15.12,15.90,16.62,17.09,17.25,17.35,17.33,17.12,16.73,16.08,15.26,14.47,13.72,13.14,12.63,12.36,12.11,11.76,11,10,9.12,8.23,7.34,7.12,7.07,7.14,7.45,7.85,8.33,8.77,9.23,9.63,10.12,10.62,11.24,11.87,12.51,13.12,13.71,14.14,14.50,14.88,15.27,15.75,16.22,16.86,17.62,18.39,19.14,19.75,20.22,20.50,20.70,20.87,21,21.02,20.88,20.50,19.82,18.76,17.62,16.46,15.36,14.33,13.33,12.25,11.02,9.73,8.12,7.12,5.75,4.45,3.12,2,1.36,1,0.99,1,1.13,1.58,2.13,2.87,3.73,4.73,5.90,7.23,8.60,9.71,10.60,11.25,11.71,10.62,-5.30,-6.28,-7.25,-8.18,-9.03,-9.66,-9.63,-9.68,-9.68,-9.63,-9.49,-9.26,-9.02,-8.76,-8.50,-8.25,-7.93,-7.63,-7.30,-7.13,-7.04,-7.01,-6.74,-5.88,-4.40,-2.67,-0.38,-0.25,-0.38,-0.53,-0.75,-0.79,-0.75,-0.63,-0.50,-0.62,-0.66,-1.18,-1.80,-4.13,-6.38,-8.38,-9.86,-10,-9.90,-8.86,-7.50,-6.05,-4.65,-3.38,-2.17,-1.13,-0.18,0.37,0.75,0.87,0.87,0.75,0.63,0.34,-0.15,-1.25,-2.62,-3.64,-5.01,-6.38,-7.27,-7.13,-7,-6.99,-7.01,-7.13,-7.11,-6.98,-6.85,-6.63,-6.30,-5.88,-5.25,-4.63,-4.16,-3.85,-3.43,-2.90,-2.40,-1.88,-1.25,-0.85,-0.62,-0.63,-0.54,-0.64,-1.10,-1.88,-3,-3.74,-4.13,-4.36,-4.63,-5.25,-6.13,-7.13,-7.68,-7.65,-7.50,-7.35,-7.25,-7.25,-7.17,-7,-6.66,-5.75,-5.03,-4.75,-4.73,-4.75,-4.63,-4.49,-4.27,-4.50,-5.12,-6,-7,-7.88,-8.62,-9.13,-9.43,-9.61,-9.76,-10,-10,-11,-11,-11,-12,-12,-11,-11,-10,-9.88,-9.02,-8.10,-6.91,-5.50,-4.25,-3.12,-2.18,-1.53,-0.67,0.12,0.98,1.75,2.50,3.25,4,4.75,5.50,6.12,7,8,10,11,12,13,13.95,14.60,15,15.52,16.10,16.50,16.62,16.62,16,15.12,14.13,13.23,12.47,11.96,11.74,12,12.35,12.75,13.25,13.77,14.35,14.86,15.27,15.62,15.87,15.99,16,15.95,15.86,15.82,15.85,15.99,16.25,16.61,17,17.38,17.76,18.12,18.47,18.77,19.12,19.47,19.75,19.89,19.62,19,18.12,17.46,16.95,17.20,17.61,18.12,18.12,18,17.23,16.49,15.75,15.45,15.50,15.63,15.75,15.50,15.35,15.46,16.01,16.75,17.39,17.83,18.02,18.12,18.07,17.75,17.22,16.50,15.75,14.98,14.46,14,13.65,13.36,13.12,12.84,12.10,11.10,9.87,8.76,7.86,7.32,7.12,7.21,7.45,7.82,8.25,8.75,9.23,9.73,10.25,10.83,11.40,12.08,12.72,13.32,13.86,14.27,14.62,14.89,15.20,15.50,15.88,16.50,17.36,18.15,18.98,19.63,20.21,20.59,20.88,21.15,21.35,21.35,21.08,20.57,19.70,18.61,17.37,16.22,15.12,14.10,13.10,12,10.77,9.40,8.12,7,5.64,4.34,3.01,2,1.36,1,0.99,1,1.01,1.25,1.73,2.37,3.20,4.22,5.36,6.62,8,9.12,10,10.49,10.82,9.59,-5.63,-6.88,-7.88,-8.63,-9.41,-10,-9.88,-9.86,-9.77,-9.64,-9.48,-9.24,-8.91,-8.62,-8.25,-7.79,-7.30,-6.66,-5.88,-5.16,-4.66,-4.49,-4.38,-3.99,-3.13,-1.54,-0.26,0.36,0.34,0.12,0,-0.12,-0.04,-0.03,-0.15,-0.50,-1,-1.54,-2.29,-4.18,-6.40,-8.53,-10,-10,-10,-9.23,-7.80,-6.37,-4.90,-3.55,-2.37,-1.25,-0.25,0.38,0.87,1.12,1.12,1.12,1,0.86,0.25,-0.40,-1.28,-2.38,-3.52,-4.89,-6.63,-7.28,-7.75,-8.12,-8.41,-8.50,-8.49,-8.41,-8.35,-8.16,-7.93,-7.63,-7.24,-6.77,-6.40,-6.02,-5.48,-5.05,-4.74,-4.38,-4.11,-3.80,-3.63,-3.50,-3.43,-3.51,-3.87,-4.48,-5.29,-6.01,-6.75,-6.38,-6.26,-6.50,-6.99,-7.39,-7.66,-7.75,-7.63,-7.50,-7.41,-7.49,-7.64,-7.75,-8.03,-7.28,-6.61,-6.35,-6.38,-6.63,-6.80,-7.17,-6.79,-6.52,-6.74,-7.25,-7.98,-8.66,-9.25,-9.65,-9.89,-10,-10,-10,-10,-11,-11,-12,-12,-12,-11,-11,-10,-9.75,-9,-8,-6.78,-5.38,-4.05,-2.75,-1.36,-0.77,-0.28,0.25,0.95,1.62,2.34,3.10,3.87,4.75,5.62,6.83,7,8,9,11,12,12.97,13.60,14.12,14.61,15.07,15.51,15.95,16.22,16.20,15.87,15.21,14.37,13.50,12.87,12.45,12.25,12.49,12.75,13.12,13.58,14,14.39,14.82,15.12,15.45,15.64,15.85,15.97,16.01,16.10,16.12,16.22,16.36,16.59,16.86,17.12,17.37,17.61,17.76,18,18.25,18.59,18.89,19.20,19.32,19.09,18.61,17.96,17.47,17.25,17.62,18.09,18.37,18.48,18.47,18.12,17.57,17,16.73,16.71,16.75,16.62,16.37,16.24,16.38,16.89,17.52,18.12,18.52,18.86,18.98,18.87,18.40,17.75,17.07,16.37,15.77,15.34,14.97,14.62,14.52,13.87,13.86,13.82,11.96,10.74,9.25,8.21,7.27,7.15,7.24,7.46,7.82,8.25,8.75,9.26,9.85,10.40,11.01,11.64,12.32,12.95,13.52,14.12,14.59,14.98,15.25,15.51,15.74,16.09,16.62,17.36,18.11,18.84,19.49,20.01,20.48,20.87,21.22,21.50,21.40,21.12,20.46,19.49,18.34,17.10,15.96,14.87,13.88,12.96,11.87,10.63,9.33,8.10,7,5.62,4.34,3.01,2,1.36,1,1,0.99,1,1.12,1.37,1.84,2.62,3.62,4.72,5.95,7.25,8.25,9.25,9.61,9.89,8.51,-6.13,-7.38,-8.37,-9.05,-9.63,-10,-10,-9.99,-9.88,-9.75,-9.50,-9.24,-8.89,-8.53,-8.12,-7.51,-6.77,-5.80,-4.61,-2.54,-1.78,-1.51,-1.54,-2.63,-2.25,-1.38,-0.30,0.33,0.37,0.37,0.37,0.35,0.36,0.35,0.13,-0.14,-0.68,-1.38,-2.38,-4.37,-6.50,-8.78,-10,-11,-10,-9.28,-7.90,-6.48,-5.01,-3.64,-2.39,-1.25,-0.18,0.47,0.96,1.25,1.36,1.32,1.23,0.99,0.62,0.21,-0.38,-1.13,-2,-3.13,-5.37,-7.25,-8.28,-9.01,-9.42,-9.54,-9.52,-9.53,-9.50,-9.38,-9.25,-9.02,-8.75,-8.42,-8.12,-7.62,-7.25,-6.99,-6.77,-6.68,-6.63,-6.50,-6.39,-6.26,-6.13,-6.11,-6.26,-6.68,-7.37,-8.52,-8.66,-7.88,-7.49,-7.36,-7.42,-7.52,-7.61,-7.55,-7.42,-7.26,-7.16,-7.23,-7.50,-7.80,-8.50,-7.98,-7.50,-7.39,-7.63,-8,-8.39,-9.10,-8.54,-8,-7.89,-8.16,-8.75,-9.37,-9.87,-10,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-11,-11,-10,-9.55,-8.85,-7.87,-6.75,-5.52,-4.26,-3,-1.75,-0.38,-0.12,0.35,0.86,1.46,2.12,2.87,3.74,4.62,5.70,6.85,8,8,9,10,11,12,13.02,13.59,14,14.45,14.95,15.38,15.76,15.97,15.87,15.40,14.75,14,13.40,13.02,12.87,13,13.24,13.51,13.87,14.20,14.47,14.71,14.89,15.12,15.37,15.62,15.87,16.09,16.25,16.37,16.50,16.62,16.75,16.89,17.02,17.12,17.20,17.24,17.34,17.52,17.86,18.21,18.48,18.59,18.37,18.01,17.52,17.25,17.21,17.50,17.83,17.90,18.12,18.35,18.57,18.34,18.02,17.87,17.75,17.75,17.46,17.13,17,17.25,17.74,18.25,18.74,19.20,19.62,19.87,19.51,18.99,18.27,17.64,17.08,16.58,16.13,15.90,15.60,14.89,14.09,13.87,13.84,12.15,11.75,9.75,8.37,7.46,7.24,7.25,7.48,7.83,8.25,8.76,9.37,9.97,10.61,11.25,11.87,12.50,13.13,13.75,14.36,14.96,15.37,15.70,15.99,16.26,16.62,17.08,17.62,18.23,18.77,19.34,19.77,20.23,20.62,21.02,21.32,21.32,21,20.15,19.12,17.99,16.76,15.70,14.65,13.74,12.84,11.85,10.62,9.27,8.09,6.99,5.63,4.34,3.02,2.12,1.49,1.12,1,0.99,1,1.01,1.14,1.50,2.14,3,3.96,5.08,6.25,7.32,8.25,8.63,8.89,7.50,-6.68,-7.87,-8.76,-9.50,-10,-10,-10,-10,-10,-9.79,-9.54,-9.26,-8.98,-8.61,-8.13,-7.41,-6.48,-5.18,-3.54,-1.48,0.50,0.38,-1.05,-1.76,-1.92,-1.38,-0.50,0.20,0.25,0.25,0.33,0.37,0.49,0.50,0.37,0.23,-0.28,-1.02,-2.29,-4.30,-6.41,-8.63,-10,-10,-10,-9.05,-7.76,-6.38,-4.99,-3.63,-2.38,-1.23,-0.13,0.50,1,1.33,1.49,1.49,1.37,1.12,0.88,0.62,0.25,-0.25,-0.90,-2.38,-4.50,-7.23,-8.68,-9.67,-10,-10,-10,-10,-10,-10,-10,-10,-9.92,-9.73,-9.24,-8.88,-8.62,-8.43,-8.49,-8.60,-8.73,-8.77,-8.78,-8.66,-8.49,-8.25,-8.16,-8.50,-8.91,-9.25,-9.50,-8.68,-8.16,-7.75,-7.52,-7.42,-7.28,-7.15,-6.93,-6.66,-6.43,-6.38,-6.52,-6.88,-7.65,-7.62,-7.55,-7.75,-8.13,-8.61,-9.02,-9.66,-9.18,-8.68,-8.53,-8.75,-9.24,-9.76,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-11,-11,-10,-10,-9.26,-8.61,-7.73,-6.75,-5.75,-4.64,-3.50,-2.16,-0.50,-0.25,0.12,0.62,1.22,1.87,2.62,3.50,4.37,5.45,6.87,8,8,9,10,11,11.97,12.60,12.96,13.37,13.87,14.45,15,15.50,15.84,15.95,15.73,15.24,14.62,14.10,13.72,13.50,13.59,13.73,13.96,14.14,14.36,14.47,14.50,14.62,14.75,15,15.34,15.70,16.07,16.37,16.58,16.70,16.74,16.75,16.75,16.74,16.63,16.57,16.50,16.51,16.73,17.07,17.39,17.65,17.74,17.57,17.25,16.89,16.73,16.75,16.85,16.95,17.07,17.37,17.87,18.46,18.75,18.87,18.75,18.62,18.39,18.10,17.83,17.75,18,18.40,18.87,19.10,19.39,19.75,19.98,19.75,19.25,18.75,18.20,17.64,17.20,16.77,16.49,16.39,15.08,14.02,13.08,12.87,11.90,10.77,9.62,8.48,7.62,7.25,7.25,7.48,7.84,8.25,8.82,9.39,10.08,10.75,11.40,12.10,12.73,13.34,13.89,14.50,15.11,15.72,16.12,16.45,16.75,17.14,17.62,18.09,18.52,18.97,19.34,19.63,19.99,20.32,20.62,20.90,20.90,20.50,19.75,18.72,17.60,16.38,15.26,14.26,13.39,12.62,11.73,10.58,9.26,8.07,7,5.75,4.51,3.36,2.48,1.71,1.25,1.01,1,0.99,1,1.02,1.26,1.74,2.37,3.14,4.08,5.25,6.25,7.25,7.62,7.89,6.48,-7.25,-8.17,-9.13,-9.88,-10,-10,-10,-10,-10,-9.88,-9.63,-9.36,-9.05,-8.75,-8.26,-7.50,-6.38,-4.87,-3,-0.93,0.47,0.37,-0.78,-1.88,-2.38,-2.25,-1.25,-0.90,-0.64,-0.50,-0.25,0.09,0.37,0.50,0.50,0.37,-0.12,-0.88,-2.25,-4.13,-6.10,-7.99,-9.37,-9.79,-9.40,-8.60,-7.42,-6.13,-4.77,-3.48,-2.24,-1.11,-0.02,0.62,1,1.37,1.50,1.61,1.50,1.34,1.12,0.87,0.62,0.23,-0.63,-2.03,-4.38,-7.25,-8.92,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.90,-9.63,-9.41,-9.38,-9.53,-9.79,-10,-10,-10,-10,-10,-9.78,-9.50,-9.55,-9.66,-9.91,-9.50,-9,-8.43,-7.87,-7.35,-6.99,-6.63,-6.38,-6.04,-5.61,-5.17,-4.93,-5,-5.26,-5.77,-6.37,-6.88,-7.36,-7.86,-8.36,-8.76,-9.18,-9,-8.75,-8.74,-8.93,-9.39,-9.90,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-9.50,-8.88,-8.25,-7.53,-6.75,-5.92,-5.05,-4.13,-3,-1.38,-0.88,-0.30,0.25,0.88,1.61,2.35,3.12,3.99,5,5.99,7,7,8,10,10,10.97,11.72,12.32,12.84,13.40,14.09,14.75,15.32,15.76,16.07,16.11,15.82,15.34,14.83,14.39,14.13,14.15,14.25,14.37,14.47,14.49,14.39,14.32,14.25,14.34,14.58,14.96,15.40,15.90,16.37,16.62,16.72,16.63,16.51,16.37,16.20,15.99,15.76,15.63,15.65,15.88,16.25,16.65,16.96,16.98,16.73,16.37,16.08,15.95,15.97,15.97,16.02,16.14,16.62,17.38,18.12,18.87,19.33,19.32,19.10,18.75,18.50,18.25,18.25,18.50,18.98,19.20,19.09,19.09,19.27,19.51,19.62,19.40,19.11,18.57,18,17.58,17.25,16.82,16.02,15.08,14,13.07,12.13,11.33,10.37,9.35,8.34,7.57,7.24,7.23,7.45,7.82,8.27,8.87,9.50,10.21,10.90,11.62,12.34,12.97,13.51,14.08,14.62,15.15,15.74,16.27,16.74,17.21,17.63,18.12,18.52,18.95,19.21,19.37,19.59,19.75,19.98,20.14,20.35,20.35,19.89,19.14,18.20,17.12,16,14.87,13.89,13.10,12.36,11.57,10.59,9.25,8.11,7,5.87,4.76,3.71,2.82,2.01,1.49,1.13,1,0.99,0.99,1,1.12,1.37,1.85,2.37,3.15,4.20,5.23,6.12,6.63,6.89,5.46,-7.63,-8.38,-9.25,-10,-10,-10,-10,-10,-10,-9.88,-9.63,-9.38,-9.15,-8.90,-8.50,-7.75,-6.50,-4.76,-2.65,-0.63,0.38,0.35,-1.05,-2.55,-3.68,-4.16,-3.93,-3.25,-2.55,-2,-1.27,-0.53,0.08,0.37,0.48,0.37,-0.05,-0.87,-2.13,-3.85,-5.60,-7.15,-8.35,-8.78,-8.63,-7.98,-6.99,-5.77,-4.50,-3.23,-2,-0.90,0.10,0.70,1.12,1.47,1.62,1.74,1.63,1.46,1.25,1.08,0.82,0.35,-0.51,-2.13,-4.74,-7.25,-9,-10,-10,-10,-10,-11,-11,-10,-10,-10,-10,-10,-10,-9.86,-9.73,-9.75,-10,-10,-10,-11,-11,-11,-11,-10,-10,-9.88,-9.75,-9.63,-9.43,-8.90,-8.38,-7.65,-6.88,-6.13,-5.42,-4.88,-4.49,-3.98,-3.52,-3.27,-3.16,-3.38,-3.80,-4.75,-5.63,-6.36,-6.99,-7.52,-8,-8.38,-8.41,-8.43,-8.61,-8.89,-9.37,-9.77,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-10,-10,-9.38,-8.79,-8.28,-7.88,-7.37,-6.75,-6.14,-5.50,-4.77,-4.05,-3.23,-2.02,-1.02,-0.13,0.62,1.33,2,2.72,3.37,4.12,5,6,6,7,9,9,10,11,11.71,12.38,13.12,13.84,14.52,15.13,15.74,16.13,16.37,16.37,15.99,15.51,15.12,14.84,14.76,14.76,14.77,14.74,14.59,14.33,14.02,13.87,13.87,14.09,14.50,15.08,15.64,16.15,16.49,16.51,16.37,16.12,15.83,15.50,15.20,14.95,14.76,14.86,15.12,15.60,16.02,16.35,16.36,16,15.58,15.22,15.01,15,15,15.12,15.49,16.15,17.08,17.87,18.57,19,19,18.75,18.51,18.39,18.27,18.33,18.50,18.75,18.87,18.50,18.37,18.40,18.71,19.10,19.22,19.11,18.46,17.88,17.47,17.12,16.61,15.84,14.96,13.89,12.89,11.97,11,10.08,9.12,8.24,7.58,7.25,7.24,7.46,7.84,8.35,8.96,9.62,10.37,11.14,11.95,12.63,13.26,13.84,14.27,14.75,15.25,15.75,16.34,16.87,17.49,18.02,18.58,19.01,19.37,19.50,19.50,19.50,19.51,19.60,19.62,19.62,19.57,19.23,18.58,17.64,16.62,15.61,14.51,13.60,12.85,12.13,11.46,10.62,9.76,8.11,7.34,6.27,5.26,4.25,3.26,2.45,1.72,1.25,1.02,1,0.99,1,1.01,1.15,1.37,1.85,2.37,3.26,4.15,5.10,5.77,6.12,4.50,-7.79,-8.62,-9.18,-9.92,-10,-10,-10,-10,-10,-9.85,-9.61,-9.38,-9.18,-9,-8.67,-8.04,-6.75,-4.88,-2.75,0.60,0.45,0.35,-1.75,-3.76,-5.37,-6.38,-6.40,-5.63,-4.80,-3.89,-2.88,-1.60,-0.38,0.25,0.24,0.12,-0.25,-0.91,-1.88,-3.40,-5.03,-6.52,-7.52,-7.99,-7.88,-7.35,-6.43,-5.37,-4.13,-2.88,-1.66,-0.63,0.25,0.75,1.12,1.48,1.63,1.75,1.73,1.50,1.36,1.12,0.87,0.37,-0.54,-2.37,-4.88,-7.25,-8.86,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.63,-9.48,-9.38,-9.50,-9.79,-10,-10,-11,-11,-11,-11,-10,-10,-9.63,-9.25,-9.04,-9.11,-8.63,-8.13,-7.28,-6.30,-5.16,-4.02,-3.18,-2.60,-2.12,-1.75,-1.43,-1.37,-1.30,-2.05,-3.25,-4.18,-5.04,-5.77,-6.40,-7.03,-7.42,-7.74,-8,-8.37,-8.76,-9.17,-9.50,-9.64,-9.63,-9.60,-9.63,-9.68,-10,-10,-11,-11,-11,-10,-9.63,-8.89,-8.35,-7.89,-7.62,-7.38,-7.11,-6.75,-6.35,-5.88,-5.39,-4.93,-5.02,-3.42,-1.77,-0.50,0.38,1.12,1.62,2.22,2.87,3,4,5,6,7,8,9,9.98,10.26,11.25,12.10,12.87,13.61,14.35,15,15.70,16.22,16.62,16.72,16.52,16.14,15.75,15.50,15.37,15.33,15.21,14.99,14.62,14.21,13.75,13.48,13.37,13.58,14,14.61,15.25,15.83,16.12,16.13,15.90,15.57,15.12,14.72,14.36,14.10,14,14.12,14.50,15.07,15.60,15.90,15.88,15.50,14.86,14.37,14.12,14,14.12,14.48,15.13,16.02,16.88,17.65,18.23,18.33,18.23,18.02,17.89,17.87,17.87,17.87,17.98,17.98,17.98,17.64,17.39,17.38,17.71,18.21,18.52,18.57,18,17.37,17,16.61,16.12,15.50,14.70,13.76,12.72,11.73,10.75,9.85,8.96,8.14,7.58,7.25,7.25,7.48,7.87,8.40,9.10,9.84,10.62,11.48,12.27,13.08,13.73,14.24,14.63,15.01,15.39,15.86,16.37,17.01,17.65,18.33,18.98,19.49,19.77,19.73,19.58,19.38,19.25,19.12,19,18.87,18.71,18.38,17.87,17.02,16.12,15.23,14.32,13.45,12.75,12.11,11.49,10.75,9.87,8.87,7.63,6.62,5.63,4.64,3.70,2.82,2.02,1.49,1.14,1.01,1,0.99,1,1.01,1.15,1.37,1.85,2.50,3.37,4.37,5.25,5.70,4.46,-7.88,-8.64,-9.25,-9.68,-10,-10,-10,-10,-9.89,-9.73,-9.50,-9.26,-9.13,-9,-8.75,-8.16,-7,-5.29,-2.80,-2,-2,-2.66,-3.73,-5.05,-6.30,-7.17,-7.50,-7.25,-6.54,-5.63,-4.50,-3.25,-1.63,-0.75,-0.55,-0.54,-0.50,-0.78,-1.41,-2.54,-4.86,-6.16,-7,-7.38,-7.27,-6.77,-5.99,-4.90,-3.73,-2.48,-1.28,-0.05,0.38,0.86,1.21,1.48,1.62,1.75,1.75,1.61,1.37,1.20,0.87,0.34,-0.63,-2.88,-5.12,-7.18,-8.65,-9.68,-10,-10,-10,-10,-10,-10,-10,-9.67,-9.38,-9.10,-8.68,-8.50,-8.48,-8.63,-9,-9.50,-10,-10,-10,-10,-10,-10,-9.38,-8.88,-8.38,-8.03,-8.35,-8.38,-7.27,-6.89,-6.13,-4,-2.38,-1.27,-0.61,-0.15,0.11,0.21,0.22,0.07,-0.78,-1.88,-2.87,-3.75,-4.51,-5.26,-5.89,-6.50,-7,-7.54,-8.13,-8.64,-9.01,-9.16,-9.13,-8.98,-8.75,-8.65,-8.63,-9.04,-9.86,-10,-11,-10,-9.41,-8.18,-7.38,-6.98,-6.80,-6.76,-6.80,-6.76,-6.65,-6.49,-6.23,-5.88,-5.49,-5,-4.16,-2.38,-0.75,0.83,1,1.12,1.87,2,3,4,4,5,6,7,8,9,10.22,11.12,11.87,12.62,13.37,14.14,14.95,15.64,16.24,16.72,17.02,16.95,16.62,16.34,16.10,15.95,15.82,15.59,15.20,14.63,14.07,13.50,13.11,12.95,13.08,13.49,14.09,14.75,15.33,15.62,15.63,15.37,14.87,14.37,13.87,13.50,13.32,13.27,13.51,14,14.71,15.37,15.76,15.75,15.15,14.37,13.51,13.33,13.24,13.57,14.12,15.02,15.97,16.77,17.47,17.70,17.62,17.39,17.14,17.01,17,17,17,17.01,17.07,16.90,16.65,16.37,16.34,16.60,17,17.37,17.37,17.08,16.63,16.22,15.75,15.21,14.58,13.86,13.07,12.25,11.37,10.48,9.61,8.76,8.10,7.57,7.25,7.25,7.50,7.96,8.57,9.25,10.09,10.95,11.84,12.73,13.51,14.23,14.75,15.12,15.46,15.75,16.12,16.60,17.24,17.87,18.50,19.12,19.64,19.87,19.75,19.49,19.20,18.87,18.61,18.34,18.09,17.83,17.49,16.99,16.35,15.60,14.82,14.02,13.34,12.71,12.12,11.65,10.96,10.09,9,7.97,6.97,5.96,5.07,4.08,3.14,2.37,1.82,1.37,1.14,1.01,1,0.99,1,1.01,1.15,1.37,1.96,2.85,3.96,5,5.77,4.48,-7.77,-8.54,-9.13,-9.63,-9.88,-10,-9.98,-9.88,-9.75,-9.52,-9.29,-9.12,-8.92,-8.77,-8.52,-8.05,-7.17,-5.92,-4.88,-4.28,-4.27,-4.68,-5.42,-6.37,-7.25,-7.88,-8.14,-8.10,-7.66,-7,-6.11,-5,-3.88,-2.65,-2,-1.66,-1,0.50,-1.43,-3.50,-5.16,-6.15,-6.78,-7.02,-6.88,-6.39,-5.62,-4.50,-3.26,-2,-0.75,0.12,0.61,0.88,1.23,1.47,1.63,1.83,1.85,1.62,1.45,1.12,0.75,0.22,-1.03,-3.30,-5.39,-7.25,-8.50,-9.38,-9.90,-10,-10,-10,-9.86,-9.50,-9.05,-8.64,-8.18,-7.75,-7.38,-7.12,-7,-7.13,-7.52,-8.13,-8.75,-9.25,-9.55,-9.64,-9.49,-9,-8.38,-7.75,-7.05,-6.53,-6.24,-6.02,-5.55,-5.76,-4.40,-2.67,-1.01,0.10,0.76,1.25,1.46,1.47,1.27,1,0.21,-0.66,-1.62,-2.48,-3.26,-4.03,-4.76,-5.50,-6.25,-7.13,-8,-8.63,-8.89,-8.79,-8.50,-8.15,-7.68,-7.28,-6.80,-7,-9.01,-9.99,-10,-10,-7.98,-6.13,-5.28,-5.41,-5.40,-5.93,-6.25,-6.42,-6.51,-6.50,-6.38,-6.10,-5.65,-5.13,-4.14,-3,-0.93,1,1,1,1,1,2,3,4,5,6,7,8,9,10.87,10.98,11.62,12.37,13.14,14.02,14.87,15.62,16.25,16.75,17.07,17.02,16.84,16.62,16.50,16.37,16.22,15.87,15.35,14.62,13.88,13.25,12.75,12.50,12.61,12.98,13.52,14.22,14.77,15.12,15.12,14.83,14.25,13.62,13.12,12.75,12.61,12.72,13.09,13.65,14.47,15.34,15.84,15.83,15.10,14.07,13.12,12.25,12.75,13.35,14,14.96,15.90,16.71,17.25,17.24,17,16.59,16.24,16.07,16,16,16,16.08,16.12,16,15.74,15.38,15.23,15.39,15.75,16.01,16.13,16.08,15.83,15.45,14.97,14.37,13.75,13.09,12.37,11.62,10.87,10.10,9.33,8.61,8,7.51,7.25,7.26,7.57,8.02,8.72,9.50,10.36,11.25,12.20,13.12,14,14.75,15.25,15.62,15.97,16.25,16.61,17,17.52,18.12,18.70,19.22,19.58,19.64,19.50,19.22,18.84,18.39,18,17.59,17.23,16.87,16.51,16.10,15.52,14.90,14.26,13.65,13.12,12.58,12.02,11.64,11.87,10.10,9,7.99,7,6,5.22,4.37,3.50,2.72,2.12,1.71,1.37,1.14,1.07,1,1,1,1.01,1.15,1.62,2.50,3.62,4.89,5.77,5.50,-7.52,-8.29,-8.91,-9.38,-9.67,-9.88,-9.89,-9.66,-9.50,-9.27,-9.05,-8.88,-8.66,-8.50,-8.30,-7.98,-7.41,-6.85,-6.30,-6.01,-6.01,-6.28,-6.85,-7.50,-8.12,-8.55,-8.79,-8.78,-8.54,-8.13,-7.51,-6.75,-5.86,-4.93,-4.13,-3.27,-2.25,-0.16,-2.68,-4.28,-5.76,-6.50,-6.88,-7,-6.75,-6.25,-5.43,-4.25,-2.78,-1.40,-0.38,0.33,0.70,0.87,1.12,1.34,1.50,1.72,1.82,1.62,1.37,1.07,0.50,-0.25,-1.92,-3.88,-5.78,-7.36,-8.54,-9.36,-9.75,-9.91,-9.88,-9.63,-9.25,-8.74,-8.13,-7.50,-6.85,-6.25,-5.75,-5.39,-5.23,-5.25,-5.61,-6.16,-6.88,-7.53,-8.02,-8.29,-8.25,-7.88,-7.17,-6.38,-5.50,-4.67,-3.98,-3.42,-3.25,-3,-2.40,-1.38,0.11,1,1.47,1.87,2.87,2.08,1.75,1.37,0.84,0.15,-0.52,-1.27,-2.03,-2.79,-3.61,-4.40,-5.37,-6.51,-7.87,-8.75,-8.89,-8.26,-7.55,-6.88,-7.23,-5.13,-4.49,-3.43,-3.80,-5.43,-7.75,-9.11,-6.64,-5.25,-4.37,-4.40,-4.54,-5.25,-5.75,-6.13,-6.37,-6.48,-6.41,-6.25,-5.80,-5.24,-4.39,-3.38,-1.02,1,1,1,1,1,2,3,3,5,6,8,8,9,9.98,10.75,11.37,12.14,13.02,14,14.87,15.62,16.20,16.62,16.96,16.85,16.62,16.57,16.59,16.64,16.48,16.07,15.38,14.60,13.75,13,12.46,12.13,12.14,12.49,13,13.70,14.27,14.72,14.75,14.37,13.75,13.07,12.48,12.11,12,12.22,12.65,13.37,14.25,15.32,15.87,15.97,15.10,13.87,12.37,12.07,12.75,13.11,13.76,14.75,15.83,16.60,16.89,16.60,16.24,15.74,15.34,15.11,15,14.99,15.07,15.14,15.26,15.21,14.89,14.51,14.25,14.26,14.50,14.77,15,15.12,15.09,14.83,14.36,13.71,13.02,12.37,11.72,11.01,10.36,9.64,9,8.38,7.87,7.50,7.26,7.33,7.62,8.12,8.85,9.65,10.59,11.50,12.48,13.40,14.34,15.12,15.72,16.12,16.46,16.75,17.10,17.48,17.89,18.37,18.86,19.23,19.37,19.35,19.12,18.75,18.33,17.85,17.33,16.77,16.36,15.96,15.57,15.12,14.62,14.12,13.60,13.12,12.74,12.37,11.61,11.12,10.87,9.88,8.90,7.98,7,6.12,5.39,4.62,3.84,3.01,2.49,2.02,1.73,1.47,1.25,1.12,1.01,1,1,1.07,1.26,2.08,3.25,4.70,5.70,4.50,-7.63,-8.25,-8.66,-9.01,-9.38,-9.50,-9.54,-9.50,-9.15,-8.98,-8.77,-8.61,-8.38,-8.23,-8.13,-8.03,-7.68,-7.68,-7.49,-7.30,-7.36,-7.51,-7.90,-8.38,-8.85,-9.15,-9.35,-9.36,-9.23,-8.98,-8.63,-8.23,-7.64,-6.91,-6.14,-5.38,-4.13,-4.25,-4.50,-5.65,-6.68,-6.88,-6.92,-6.89,-6.62,-6.15,-5.51,-4.03,-2.30,-0.50,0.25,0.62,0.85,0.96,1,1.22,1.37,1.50,1.62,1.59,1.36,0.87,0.12,-1,-2.65,-4.51,-6.18,-7.66,-8.75,-9.48,-9.75,-9.77,-9.61,-9.23,-8.66,-8,-7.25,-6.38,-5.53,-4.67,-4.13,-3.63,-3.26,-3.14,-3.38,-3.93,-4.67,-5.43,-6.14,-6.65,-6.88,-6.63,-5.89,-4.90,-3.87,-2.88,-1.60,-0.65,-0.74,-1,-0.90,-0.35,0.38,1.12,1.58,1.97,2.12,2.25,2.01,1.72,1.36,0.85,0.36,-0.23,-0.88,-1.55,-2.35,-3.15,-4.13,-5.39,-7.38,-9.13,-7.75,-7.36,-5.89,-5.27,-3.88,-2.93,-0.63,-0.11,0.37,-1.99,-3.49,-4.92,-4.75,-4.18,-3.86,-3.85,-4.12,-4.75,-5.30,-5.77,-6.13,-6.30,-6.38,-6.28,-6,-5.38,-4.61,-3.75,-1,1,1,1,1,1,1,2,3,4,6,7,8,9,9.99,10.12,11.12,12.02,12.99,13.95,14.87,15.51,16.09,16.32,16.38,16.25,16.10,16.09,16.25,16.50,16.49,16.09,15.37,14.49,13.60,12.76,12.14,11.82,11.75,12,12.52,13.21,13.85,14.32,14.37,14.07,13.37,12.63,12,11.61,11.50,11.75,12.27,13.07,14,15.07,15.75,15.76,15.21,13.49,12.25,11.89,12.12,12.70,13.46,14.39,15.50,16.25,16.37,15.84,15.27,14.85,14.46,14.21,14.02,14,14.09,14.25,14.47,14.52,14.21,13.76,13.48,13.27,13.38,13.64,14,14.32,14.47,14.37,13.96,13.35,12.58,11.83,11.12,10.50,9.87,9.25,8.73,8.23,7.76,7.48,7.32,7.36,7.62,8.20,8.89,9.76,10.72,11.63,12.61,13.52,14.40,15.23,15.87,16.39,16.85,17.20,17.50,17.87,18.25,18.63,19,19.21,19.14,18.90,18.59,18.12,17.63,17.10,16.51,15.99,15.46,14.98,14.50,14.07,13.59,13.12,12.62,12.22,11.77,11.37,10.75,10.12,9.87,9.07,8.95,7.87,7.12,6.35,5.65,4.88,4.12,3.37,2.83,2.49,2.14,1.87,1.62,1.37,1.15,1.07,1,1,1.15,1.74,2.74,3.89,4.77,4.58,-8.15,-8.55,-9,-9.25,-9.14,-9,-9.03,-8.92,-8.77,-8.52,-8.42,-8.42,-8,-7.64,-8,-8.25,-8.67,-8.63,-8.38,-8.26,-8.28,-8.40,-8.75,-9.11,-9.39,-9.63,-9.75,-9.75,-9.64,-9.51,-9.37,-9.13,-8.88,-8.38,-7.88,-7.25,-7.18,-6.50,-6.63,-7.25,-7.51,-7.16,-7,-6.75,-6.50,-6.18,-5.75,-4.04,-2,0.08,0.75,0.83,0.87,0.97,1,1.12,1.25,1.37,1.49,1.50,1.25,0.72,-0.26,-1.75,-3.38,-5.13,-6.67,-8.04,-9.11,-9.65,-9.88,-9.75,-9.41,-8.89,-8.25,-7.39,-6.43,-5.42,-4.41,-3.28,-2.67,-2.14,-1.67,-1.50,-1.61,-2,-2.62,-3.30,-4.12,-4.75,-5.18,-5.25,-4.49,-3.41,-2.25,-1.10,-0.36,0.12,0.01,-0.02,0.08,0.34,0.75,1.20,1.61,1.98,2.12,2.36,2.23,1.95,1.62,1.36,1,0.64,0.24,-0.37,-1.02,-1.77,-2.62,-3.50,-4.43,-5.01,-5.13,-4.90,-3.37,-2.17,-1.62,0.26,0.76,1.75,1.22,0.77,0.26,-2.02,-2.75,-2.88,-3,-3.25,-3.73,-4.38,-4.93,-5.49,-5.88,-6.18,-6.40,-6.42,-6.17,-5.62,-4.74,-3.50,-1.03,0.87,0.98,0.99,0.99,1,1.12,1.87,2.97,4,5,6,7,8,9,10,11,11.99,12.90,13.76,14.57,15.11,15.51,15.75,15.75,15.45,15.25,15.34,15.65,16.12,16.50,16,15.25,14.37,13.47,12.62,11.90,11.50,11.37,11.62,12.11,12.75,13.38,13.97,14.12,13.86,13.20,12.39,11.71,11.24,11.10,11.35,11.88,12.74,13.63,14.62,15.22,15.23,14.33,12.83,11.12,11.08,11.01,12.20,13,13.99,14.97,15.73,15.61,14.90,14.37,13.97,13.62,13.37,13.14,13.02,13.10,13.25,13.57,13.75,13.49,13.08,12.72,12.49,12.50,12.75,13.12,13.59,13.99,14.12,13.82,13.12,12.34,11.50,10.74,10.08,9.47,8.96,8.49,8.08,7.73,7.47,7.33,7.37,7.63,8.15,8.87,9.74,10.63,11.61,12.50,13.39,14.25,15.08,15.77,16.40,16.98,17.40,17.82,18.20,18.57,18.87,19.13,19.12,18.87,18.45,17.95,17.37,16.85,16.26,15.71,15.10,14.50,13.98,13.47,12.99,12.50,12.08,11.62,11.25,10.86,10.38,9.95,9.25,9.10,8.90,8.01,7.87,7.26,6.75,6.09,5.35,4.47,3.82,3.37,3,2.72,2.38,2.11,1.77,1.50,1.25,1.11,1,1.07,1.50,2.15,3.12,3.77,3.12,-8.66,-9.01,-9.13,-9.28,-9.25,-9,-8.41,-8.26,-8.13,-7.87,-7.75,-7.75,-7.25,-7.91,-9.25,-9.88,-10,-9.40,-9,-8.86,-8.88,-9,-9.25,-9.54,-9.77,-9.92,-10,-10,-9.91,-9.87,-9.76,-9.65,-9.54,-9.36,-9.13,-8.66,-8.43,-8.27,-8.42,-8.01,-7.67,-7.38,-7,-6.63,-6.27,-6.03,-5.51,-3.87,-1.63,0.24,0.87,0.99,0.99,0.99,1,1.12,1.23,1.25,1.36,1.34,1.22,0.62,-0.63,-2.25,-3.99,-5.65,-7.14,-8.48,-9.41,-9.92,-10,-9.85,-9.38,-8.75,-7.92,-6.99,-5.88,-4.75,-3.63,-2.38,-1.61,-1.23,-0.74,-0.43,-0.41,-0.63,-1,-1.52,-2.13,-2.77,-3.28,-3.39,-3.05,-2.01,-0.88,0,0.37,0.50,0.58,0.51,0.60,0.75,1,1.25,1.62,1.99,2.85,2.33,2.21,2.01,1.86,1.70,1.51,1.37,1.14,0.76,0.24,-0.38,-0.98,-1.42,-1.60,-1.52,-1.42,-1.39,-1.28,-0.74,0.65,1.26,2.74,3.73,3.75,2.82,1.62,0.46,-0.85,-1.40,-1.91,-2.41,-3.05,-3.68,-4.75,-4.92,-5.38,-5.88,-6.26,-6.51,-6.50,-6.10,-5,-3.15,-1.13,0.82,0.97,0.99,0.99,1,1.22,1.82,2.12,3,5,6,7,8,9,10,10.98,11.95,12.83,13.49,13.87,14.23,14.52,14.63,14.62,14.39,14.25,14.40,14.96,15.60,16.09,15.87,15.12,14.26,13.37,12.50,11.75,11.25,11.08,11.25,11.71,12.34,13,13.59,13.77,13.62,13,12.25,11.48,10.95,10.75,10.99,11.57,12.37,13.26,14.12,14.62,14.50,13.49,11.24,10.87,10.08,10.96,11.90,12.75,13.32,14.38,14.50,14.37,13.97,13.50,13.12,12.87,12.62,12.37,12.14,12.10,12.25,12.49,12.73,12.62,12.25,11.89,11.71,11.65,11.88,12.33,12.85,13.39,13.75,13.62,13.07,12.21,11.32,10.48,9.75,9.14,8.71,8.27,7.97,7.65,7.46,7.34,7.37,7.62,8.09,8.74,9.50,10.37,11.26,12.15,13.02,13.87,14.72,15.49,16.20,16.86,17.38,17.89,18.37,18.75,19.01,19.12,19,18.52,17.89,17.25,16.62,16,15.37,14.75,14.13,13.57,12.98,12.40,11.90,11.49,11.08,10.70,10.36,10,9.71,9.37,9.14,8.83,8.12,8,7.99,7.77,7.23,6.62,5.87,5.12,4.48,4,3.63,3.34,3,2.70,2.35,1.98,1.61,1.25,1.07,1.07,1.26,1.74,2.32,2.71,2.32,-9.15,-9.50,-9.63,-9.43,-9.13,-8.77,-8.26,-7.50,-7.25,-6.93,-7.04,-7.38,-7.29,-8.38,-9.65,-10,-11,-9.60,-9.02,-8.98,-9.03,-9.18,-9.50,-9.77,-10,-10,-10,-10,-10,-9.99,-9.92,-9.88,-9.80,-9.75,-10,-9.50,-9.13,-8.92,-8.68,-8.40,-8,-7.43,-7.03,-6.40,-6.13,-5.63,-4.88,-3.25,-1.30,0.25,0.87,0.99,0.99,0.99,1,1.10,1.12,1.21,1.22,1.12,0.97,0.46,-0.66,-2.63,-4.42,-6,-7.50,-8.66,-9.55,-10,-10,-9.90,-9.39,-8.67,-7.78,-6.75,-5.63,-4.40,-3.27,-2.03,-1.27,-0.68,-0.37,-0.11,0.07,0.09,-0.01,-0.25,-0.61,-0.90,-1.49,-1.75,-1.51,-0.88,0.27,0.64,0.75,0.76,0.84,0.87,0.95,1.02,1.21,1.37,1.62,1.99,2.20,2.25,2.12,2.02,1.98,1.89,1.87,1.87,1.86,1.64,1.33,0.87,0.52,0.37,0.39,0.50,0.50,0.51,0.62,1,1.32,2.70,3.72,4.75,5.75,4.75,4.11,2.37,1.35,0.47,-0.25,-0.88,-1.62,-2.60,-3.88,-4.17,-4.77,-5.41,-6.13,-6.75,-7.10,-6.93,-5.88,-3.75,-1.25,0.75,0.96,0.99,0.99,1,1.25,1.75,2.21,3.12,4,6,7,8,9,10,10.99,11.86,12.63,12.95,13.02,13.11,13.24,13.34,13.33,13.14,13.14,13.45,14.09,14.84,15.40,15.50,15,14.33,13.47,12.50,11.70,11.09,10.83,10.90,11.36,11.98,12.63,13.25,13.50,13.37,12.84,12.02,11.25,10.70,10.47,10.64,11.23,12,12.90,13.73,14.20,14.02,13.02,11.14,10.12,10.08,10.01,11,11.87,12.25,12.75,13.15,13.14,12.95,12.62,12.35,12.08,11.84,11.60,11.35,11.14,11.15,11.33,11.47,11.48,11.25,11.01,10.87,10.87,11.10,11.50,12.01,12.65,13.25,13.46,13,12.10,11.09,10.25,9.50,8.95,8.50,8.15,7.87,7.64,7.49,7.37,7.37,7.59,7.97,8.50,9.15,9.97,10.76,11.62,12.50,13.37,14.23,15.07,15.87,16.61,17.26,17.88,18.45,18.87,19.12,19.12,18.87,18.23,17.46,16.62,15.87,15.14,14.50,13.85,13.22,12.62,12,11.47,10.96,10.51,10.23,9.89,9.70,9.48,9.27,9.20,9.08,8.85,8.34,8.12,8,8.11,7.87,7.32,6.58,5.77,5.12,4.71,4.36,4,3.70,3.36,2.99,2.50,2,1.50,1.14,1.02,1.13,1.37,1.70,1.82,1.70,-9.38,-9.75,-9.88,-9.75,-9.38,-8.75,-8.13,-7.29,-6.38,-6.50,-7,-7.25,-7.76,-7.88,-8.63,-9.42,-10,-8.68,-8.48,-8.60,-8.86,-9.12,-9.43,-9.75,-9.93,-10,-10,-9.98,-9.89,-9.88,-9.86,-9.80,-9.78,-9.77,-10,-9.75,-9.63,-9.41,-9.13,-8.43,-8.25,-7.80,-7.17,-6.50,-6.04,-5.40,-4.43,-3,-1.13,0.25,0.88,0.99,0.99,0.99,1,1,1.10,1.11,1.10,1,0.82,0.22,-1.25,-2.99,-4.78,-6.39,-7.79,-8.93,-9.77,-10,-10,-10,-9.51,-8.75,-7.80,-6.75,-5.54,-4.38,-3.26,-2.14,-1.37,-0.67,-0.25,0,0.33,0.50,0.62,0.70,0.62,0.38,0.32,-0.42,-0.38,0.01,0.52,0.76,0.88,0.99,1.02,1.12,1.22,1.32,1.39,1.52,1.74,1.88,2.01,2.09,2.08,2.01,2,2.01,2.11,2.21,2.25,2.25,2.13,1.96,1.76,1.75,1.87,2,2.08,2.12,2.21,2.39,2.87,3.52,4.39,5.36,6.58,6.74,5.95,4.48,3.21,2.23,1.37,0.72,0,-0.89,-2.11,-3.48,-3.77,-4.64,-5.68,-6.90,-7.85,-8.25,-8.40,-5.03,-1.30,0.70,0.88,0.97,0.98,1,1.25,1.70,2.22,2.99,4.09,5,6,8,9,10,11,11.99,11.98,12.63,11.97,11.84,11.77,11.84,11.86,11.87,11.98,12.40,13.12,14.09,14.75,15.12,15.09,14.50,13.72,12.65,11.73,11,10.62,10.70,11.08,11.65,12.37,12.99,13.32,13.20,12.62,11.83,11,10.37,10.15,10.36,10.87,11.63,12.50,13.34,13.77,13.85,13.76,11.87,10.12,10.08,10.01,10,11,11.11,11.25,11.63,11.86,11.97,11.84,11.50,11.23,11,10.82,10.50,10.25,10.08,10.13,10.25,10.25,10.22,10.10,10.01,10.10,10.26,10.62,11.12,11.74,12.37,12.60,12.37,11.70,10.75,9.97,9.26,8.75,8.37,8.10,7.87,7.71,7.52,7.47,7.47,7.60,7.86,8.25,8.83,9.47,10.21,11,11.87,12.75,13.65,14.60,15.49,16.34,17.12,17.85,18.46,18.96,19.25,19.21,18.72,18,17.08,16.12,15.22,14.37,13.63,12.96,12.32,11.74,11.22,10.70,10.24,9.87,9.62,9.48,9.37,9.32,9.25,9.22,9.25,9.21,9.12,9.02,9.12,9,8.82,8.10,7.24,6.52,5.88,5.48,5.12,4.77,4.46,4.11,3.72,3.13,2.50,1.84,1.37,1.14,1.02,1.13,1.25,1.33,1.25,-9.40,-9.75,-9.78,-9.75,-9.37,-8.75,-7.88,-7.02,-6.15,-6.63,-6.75,-6.75,-6.63,-6.50,-6.50,-6.63,-6.63,-7,-7.30,-7.75,-8.25,-8.64,-9.13,-9.48,-9.63,-9.73,-9.65,-9.60,-9.50,-9.41,-9.39,-9.41,-9.38,-9.26,-9.25,-9.42,-10,-10,-9.75,-9.13,-8.75,-8.05,-7.41,-6.89,-6.13,-5.66,-4.64,-3.05,-1.05,0.95,0.96,0.99,0.99,0.99,1,1,1,1,1,0.87,0.75,0.10,-1.51,-3.49,-5.23,-6.76,-8.13,-9.16,-9.98,-10,-10,-10,-9.65,-8.88,-7.93,-6.88,-5.73,-4.55,-3.53,-2.52,-1.63,-0.75,-0.54,-0.13,0.23,0.50,0.71,0.75,0.82,0.75,0.60,0.49,0.59,0.52,0.77,0.89,1.01,1.13,1.25,1.37,1.49,1.57,1.62,1.73,1.84,1.90,1.99,2,2,2,2,2.11,2.24,2.39,2.60,2.72,2.75,2.74,2.73,2.75,2.90,3.14,3.35,3.45,3.58,3.75,4.08,4.50,5,5.87,6.62,7.50,6.83,5.98,4.85,3.75,2.87,2.07,1.25,0.37,-0.53,-1.50,-2.50,-3.63,-5.01,-6.73,-9.63,-10,-10,-6.88,-2.53,0.62,0.74,0.87,0.95,0.99,1.12,1.37,1.96,2.72,3.85,5,6,7,8,9,10,11,10.99,10.86,10.70,10.45,10.37,10.37,10.50,10.74,11.09,11.62,12.40,13.52,14.38,14.99,15.25,15.25,14.07,12.97,11.82,10.98,10.50,10.48,10.83,11.40,12.13,12.84,13.15,13.08,12.47,11.61,10.74,10.10,9.84,10,10.50,11.24,12.02,12.77,13.60,13.75,13.77,12.08,10.87,10.07,9.97,10,10,10,10.11,10.25,10.62,10.86,10.97,10.62,10.25,10.02,9.95,9.62,9.27,9.07,9.09,9.12,9.20,9.15,9.14,9.21,9.27,9.50,9.77,10.22,10.71,11.15,11.38,11.37,10.97,10.27,9.62,9.02,8.60,8.25,8.07,7.87,7.75,7.70,7.62,7.62,7.72,7.87,8.12,8.50,9,9.62,10.37,11.23,12.12,13.12,14.12,15.12,16.07,16.96,17.75,18.46,19,19.33,19.13,18.64,17.87,16.83,15.75,14.72,13.76,12.96,12.14,11.50,11,10.62,10.24,9.87,9.61,9.47,9.37,9.39,9.49,9.57,9.58,9.74,9.88,10.01,10.15,10.32,10.86,9.89,9,8,7.35,6.70,6.36,6,5.62,5.26,4.89,4.50,3.87,3.12,2.37,1.84,1.37,1.13,1.02,1.01,1.01,1.01,-9.38,-9.75,-9.75,-9.51,-9.05,-8.50,-7.51,-7,-6.75,-6.62,-6.43,-6.02,-5.50,-5,-4.63,-4.50,-4.25,-5.04,-5.87,-6.61,-7.27,-7.88,-8.43,-8.88,-9.05,-9.10,-9,-8.86,-8.67,-8.54,-8.51,-8.50,-8.27,-8.25,-7.91,-8.50,-9.63,-10,-10,-10,-9.38,-8.51,-7.29,-6.76,-6.04,-6.39,-6.41,-4.17,-1.03,0.97,0.99,1,1,0.99,0.99,0.99,0.99,0.99,0.87,0.63,0.25,-0.50,-2.13,-4.11,-5.75,-7.16,-8.41,-9.39,-10,-10,-10,-10,-9.86,-9.10,-8.15,-7.13,-6,-4.91,-4,-3.13,-2.38,-1.68,-1.05,-0.50,0,0.37,0.61,0.75,0.86,0.86,0.85,0.84,0.82,0.84,0.87,1,1.15,1.37,1.58,1.63,1.73,1.75,1.82,1.87,1.88,1.96,1.99,2,2,2,2.02,2.13,2.35,2.59,2.83,3,3.20,3.27,3.37,3.57,3.82,4.12,4.38,4.62,4.83,5,5.25,5.50,5.87,6.38,7,7.33,7.34,6.73,5.87,5,4.12,3.33,2.50,1.71,0.89,0.15,-0.63,-1.60,-2.93,-4.52,-6.93,-9.42,-10,-8,-4.51,-0.63,0.49,0.73,0.70,0.74,0.87,1.23,1.75,2.50,3.37,4.37,5.21,6,7,8,9,10,10,9,9.10,9.12,9.01,9.12,9.49,9.95,10.50,11.14,12.21,13.37,14.25,14.87,15.20,15.25,15,13.07,11.84,10.88,10.27,10.21,10.52,11.25,12,12.75,13.12,12.98,12.27,11.37,10.48,9.75,9.46,9.52,10.01,10.75,11.47,12.08,12.74,12.75,12.77,11.86,10.87,9.90,9,9,9,9,9,9.07,9.20,9.65,9.62,9.49,9.22,9.01,8.96,8.70,8.37,8.11,8.13,8.22,8.25,8.25,8.35,8.48,8.62,8.84,9.08,9.32,9.61,10,10.36,10.37,10.15,9.75,9.26,8.83,8.45,8.21,8.02,7.97,7.89,7.87,7.88,7.96,8,8.11,8.24,8.45,8.75,9.21,9.85,10.64,11.62,12.62,13.71,14.75,15.82,16.76,17.65,18.45,19,19.32,19.13,18.64,17.77,16.65,15.50,14.37,13.37,12.48,11.62,11,10.60,10.37,10.14,9.99,9.84,9.75,9.75,9.88,10.08,10.23,10.36,10.59,10.84,11.09,11.35,11.60,11.71,10.96,9.99,9,8.32,7.65,7.26,6.88,6.51,6.14,5.75,5.25,4.61,3.83,3.02,2.33,1.72,1.25,1.01,1,0.99,0.99,-9.39,-9.40,-9.42,-9.25,-8.75,-8,-7.39,-7.01,-6.75,-6.51,-6.04,-5.25,-4.30,-3.51,-3,-2.88,-2.88,-3.37,-4.25,-5.16,-6.03,-6.88,-7.48,-7.90,-8.13,-8.13,-7.98,-7.75,-7.50,-7.25,-6.91,-6.51,-6.85,-5.63,-5.40,-6.18,-7.43,-8.75,-9.51,-9.92,-9.77,-9.13,-8.17,-7.02,-6.43,-5.87,-5.88,-4.63,-1,1,1,1,1,0.97,0.87,0.87,0.87,0.87,0.87,0.37,-0.50,-1.62,-3.26,-4.89,-6.38,-7.65,-8.76,-9.66,-10,-10,-10,-10,-10,-9.29,-8.42,-7.43,-6.37,-5.39,-4.60,-3.88,-3.17,-2.50,-1.78,-1.12,-0.13,0.08,0.37,0.62,0.75,0.86,0.87,0.87,0.88,0.95,0.98,1.01,1.21,1.85,1.86,1.85,1.87,1.87,1.88,1.90,1.96,1.98,1.99,2,2,2,2.11,2.25,2.49,2.75,3,3.25,3.50,3.70,3.87,4.12,4.48,4.87,5.27,5.62,5.98,6.23,6.46,6.64,6.88,7.21,7.50,7.65,7.62,7.27,6.75,6.07,5.26,4.50,3.71,2.97,2.25,1.60,0.87,0.12,-1,-2.16,-4.67,-7.02,-8.68,-9.03,-6.25,-3.28,-0.25,0.12,0.07,0.20,0.49,0.87,1.49,2.21,3.07,3.99,4.88,5.88,6.98,8,8,8,8,8,8,8,8.12,8.25,9.12,9.71,10.37,11.02,12.25,13.47,14.39,14.83,14.77,14.62,14.25,12.88,11.73,10.71,10.02,9.72,10.33,11.11,11.95,12.74,13.08,12.87,12.12,11.23,10.25,9.49,9.07,9.08,9.50,10.25,10.97,11.25,11.24,11.22,11.15,10.86,9.98,8.99,8,8,8,8,8,8,8,8.11,8.22,8.21,8.11,8,7.97,7.75,7.52,7.37,7.39,7.50,7.57,7.62,7.75,7.99,8.24,8.45,8.48,8.58,8.87,9.23,9.62,9.71,9.60,9.33,8.97,8.61,8.34,8.13,8.08,8.07,8.11,8.20,8.26,8.37,8.47,8.50,8.52,8.58,8.65,8.97,9.50,10.25,11.21,12.23,13.27,14.40,15.51,16.61,17.60,18.38,19,19.24,19.20,18.71,17.76,16.62,15.40,14.25,13.23,12.27,11.48,10.87,10.50,10.46,10.39,10.39,10.40,10.48,10.59,10.75,10.96,11.13,11.37,11.62,11.89,12.20,12.48,12.77,12.60,11.96,10.98,10,9.25,8.64,8.27,7.76,7.38,7.08,6.62,6.07,5.35,4.50,3.65,2.83,2.02,1.49,1.13,1,1,1,-9.93,-9.75,-9.38,-8.90,-8.50,-7.75,-7.30,-6.93,-6.63,-6.17,-5.39,-4.28,-3.13,-2.15,-1.75,-1.63,-1.64,-1.80,-2.62,-3.62,-4.62,-5.50,-6.27,-6.68,-6.90,-6.87,-6.61,-6.26,-5.91,-5.52,-4.93,-3.87,-2.25,-2.29,-2.63,-3.38,-4.75,-6.12,-7.50,-8.88,-9.68,-9.65,-8.89,-7.88,-7.25,-6.75,-5.88,-4.25,-2.04,-0.23,0.71,0.90,1,0.96,0.75,0.50,0.32,0.22,0.21,-0.26,-1.50,-2.89,-4.53,-5.89,-7.13,-8.25,-9.23,-10,-10,-10,-10,-10,-10,-9.60,-8.76,-7.88,-6.88,-6,-5.25,-4.63,-4,-3.38,-2.63,-1.88,-1.13,-0.40,0.11,0.48,0.62,0.75,0.85,0.87,0.96,0.99,0.99,1,1.14,1.35,1.73,1.82,1.87,1.87,1.87,1.88,1.96,1.98,1.99,2,2,2.09,2.22,2.40,2.71,3,3.25,3.50,3.75,4,4.26,4.62,5,5.49,6,6.51,7.01,7.38,7.70,7.87,8,8.09,8.13,8.15,8.09,7.85,7.45,6.90,6.25,5.57,4.85,4.12,3.50,2.89,2.36,1.62,0.62,-0.43,-2.50,-4.80,-7,-8.38,-7.41,-5.05,-2.80,-1.50,-0.89,-0.50,0,0.62,1.25,1.97,2.74,3.59,4.48,5.45,6.60,7,8,7,7,7,7,7,8,8,8.99,9.76,10.25,11.33,12.36,13.72,14.58,14.62,14.36,13.82,13.10,12.57,11.12,10.70,9.32,9.46,10.13,11,11.87,12.62,13.22,12.77,12.08,11.12,10.08,9.22,8.52,8.47,8.87,9.70,10.72,10.74,10.12,10,10,9.87,8.99,8.01,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.87,6.77,6.75,6.88,7.08,7.22,7.37,7.57,7.84,8.02,8.33,8.48,8.59,8.83,9.09,9.37,9.37,9.26,9.02,8.75,8.48,8.25,8.12,8.12,8.23,8.37,8.58,8.75,8.96,9.08,9.11,9.02,8.95,8.86,8.90,9.37,10.07,10.88,11.87,12.95,14.09,15.24,16.37,17.47,18.37,18.87,19.24,19.23,18.74,17.83,16.63,15.40,14.25,13.21,12.33,11.62,11.12,10.87,10.87,10.99,11.12,11.27,11.46,11.62,11.76,12,12.25,12.50,12.75,13,13.25,13.45,13.57,13.40,12.82,11.96,11,10.10,9.75,9.10,8.58,8.24,7.97,7.62,6.97,6.12,5.20,4.25,3.34,2.48,1.82,1.48,1.37,1.37,1.25,-10,-10,-9.75,-9.25,-8.54,-7.78,-7.37,-6.88,-6.37,-5.63,-4.63,-3.30,-2.03,-1.12,-0.63,-0.50,-0.63,-0.75,-0.90,-1.87,-2.93,-3.92,-4.76,-5.38,-5.63,-5.48,-5.03,-4.62,-4.16,-3.75,-3,-1.75,0.37,0,-0.38,-1,-2.02,-3.38,-5.13,-6.88,-8.68,-9.50,-8.68,-8.25,-8.01,-7.73,-6.87,-5.17,-2.87,-0.75,0.39,0.77,0.87,0.97,0.50,-0.03,-0.54,-0.79,-0.90,-1.27,-2.88,-4.48,-5.79,-6.99,-7.93,-8.87,-9.64,-10,-10,-11,-11,-10,-10,-9.88,-9.14,-8.38,-7.50,-6.75,-5.92,-5.38,-4.76,-4.18,-3.62,-2.87,-2,-1.14,-0.12,0.12,0.38,0.50,0.62,0.85,0.99,1,0.95,0.95,1,1.13,1.37,1.72,1.64,1.65,1.73,1.82,1.87,1.97,1.99,2,2.02,2.15,2.37,2.65,3,3.27,3.60,3.86,4.12,4.37,4.65,5.01,5.49,5.99,6.58,7.25,7.96,8.50,8.95,9.12,9.09,8.99,8.87,8.75,8.62,8.37,8.09,7.63,7.12,6.50,5.87,5.25,4.63,4.12,3.61,2.87,1.89,0.75,-0.78,-2.79,-5.04,-6.88,-7.30,-5.92,-4.25,-3,-2.01,-1.16,-0.40,0.32,1,1.63,2.37,3.12,3.87,4.75,5.47,6.11,7,6,6,6,7,7,8,8,9,10,11,12,13,13.99,14.97,14.88,13.87,12.95,12.12,11.14,10.25,9.25,9.27,9.32,10,10.97,11.84,12.62,12.83,12.71,12.62,10.97,9.75,8.76,8.25,8.12,8.27,8.84,9.15,9.23,9.12,9,8.99,8.87,7.99,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6.25,6.49,6.85,7.11,7.37,7.65,8.07,8.39,8.74,8.99,9.21,9.37,9.51,9.62,9.50,9.26,9,8.70,8.38,8.24,8.20,8.25,8.40,8.72,9.01,9.37,9.62,9.83,9.86,9.74,9.50,9.25,9.15,9.45,9.97,10.65,11.58,12.62,13.74,14.88,16.08,17.21,18.22,18.77,19.22,19.27,18.86,17.96,16.74,15.49,14.32,13.27,12.50,11.96,11.62,11.50,11.58,11.77,12.09,12.35,12.57,12.74,12.87,13.08,13.32,13.60,13.84,14,14.12,14.20,14.20,13.98,13.46,12.63,11.87,10.88,10.12,9.75,9.35,9.08,8.82,8.50,7.84,6.97,5.87,4.77,3.77,3,2.47,2.12,2,2,1.70,-11,-10,-10,-9.63,-8.80,-8.01,-7.38,-6.75,-6,-5.02,-3.77,-2.39,-1.13,-0.38,0,0.12,0.12,0.12,-0.01,-0.38,-1,-2.05,-3.37,-4.13,-4.25,-3.88,-3.15,-2.39,-2.05,-1.88,-1.50,-0.50,0.25,0.75,0.59,0.25,-0.30,-1.17,-2.80,-4.91,-6.90,-7.90,-7.88,-8.16,-8.66,-9.12,-8.64,-6.87,-4.18,-1.63,-0.05,0.37,0.58,0.63,0.37,-0.63,-1.66,-2.50,-3.13,-3.99,-4.92,-6.10,-7.13,-8,-8.75,-9.42,-10,-10,-11,-11,-11,-11,-10,-10,-9.52,-8.98,-8.28,-7.53,-6.75,-6.14,-5.38,-5.04,-4.54,-3.88,-3.03,-2,-1.02,0.07,0.12,0.13,0.25,0.58,1.46,0.87,0.75,0.73,0.75,0.87,1.09,1.25,1.35,1.37,1.49,1.62,1.82,1.90,1.99,2,2.12,2.34,2.62,3,3.36,3.70,4,4.26,4.52,4.82,5.12,5.48,5.87,6.37,6.97,7.64,8.49,9.21,9.76,10,10,9.75,9.52,9.37,9.15,8.97,8.70,8.34,7.87,7.37,6.76,6.23,5.64,5.12,4.63,3.99,3.12,1.84,0.40,-1.25,-3.50,-5.38,-6.63,-6.50,-5.38,-4.17,-3,-1.80,-0.80,0,0.75,1.37,2,2.62,3.25,3.96,4.59,5.12,5.12,6,6,6,7,8,8,9,10,10,11,12,13,13.99,14,13.99,13.10,12.12,11.15,10.21,9.23,9.12,9.02,9.26,10,10.96,11.73,12.24,12.62,12.12,11.62,10.62,9.35,8.33,7.89,7.70,7.75,7.87,7.99,8,8,8,7.99,7.89,7.01,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,6,6.12,6.50,7,7.47,7.95,8.34,8.75,9.11,9.46,9.82,10.12,10.38,10.39,10.23,9.88,9.50,9.11,8.73,8.39,8.25,8.25,8.39,8.73,9.12,9.62,10.08,10.46,10.70,10.74,10.58,10.25,9.86,9.50,9.58,9.95,10.52,11.36,12.35,13.45,14.60,15.75,16.86,17.84,18.58,19.10,19.32,18.95,18.08,16.82,15.58,14.38,13.46,12.75,12.37,12.23,12.25,12.45,12.75,13.11,13.39,13.62,13.82,13.90,14.11,14.34,14.59,14.75,14.76,14.73,14.62,14.50,14.24,13.65,12.87,12.11,11.12,10.87,10.12,10.12,9.87,9.61,9.12,8.58,7.71,6.62,5.37,4.45,3.70,3.25,3,3,2.98,2.70,-11,-11,-10,-10,-9.12,-8.25,-7.42,-6.63,-5.67,-4.50,-3.13,-1.66,-0.50,0.07,0.37,0.50,0.62,0.62,0.50,0.33,-0.04,-0.75,-1.63,-2.29,-2.42,-2.12,-1.38,-0.64,-0.50,-0.51,-0.39,-0.13,0.50,0.75,0.83,0.73,0.48,-0.25,-1.43,-3.12,-4.64,-5.79,-6.75,-7.67,-8.92,-10,-10,-9.15,-6.38,-2.62,-1.55,-0.79,-0.48,0.11,0.75,-1.37,-2.91,-4.50,-5.40,-6.05,-6.76,-7.63,-8.39,-9,-9.50,-9.98,-10,-10,-11,-11,-11,-11,-10,-10,-9.85,-9.50,-9.25,-8.54,-7.75,-7.04,-6.43,-5.92,-5.50,-5,-4.25,-3.29,-2,-1.66,-1.37,-1.05,-0.75,0.12,0.33,0.34,0.32,0.34,0.36,0.57,0.75,0.87,0.98,1.10,1.25,1.49,1.73,1.87,2,2.10,2.25,2.52,2.90,3.36,3.75,4.12,4.50,4.82,5.09,5.35,5.62,5.90,6.26,6.72,7.22,7.82,8.50,9.26,9.97,10.37,10.48,10.26,10.08,9.87,9.73,9.50,9.25,8.96,8.57,8.11,7.61,7.08,6.51,6,5.50,5.01,4,2.74,1.26,-0.27,-2.25,-4.55,-6.18,-7.18,-6.50,-5.30,-3.75,-2.30,-1.13,-0.13,0.61,1.12,1.62,2.11,2.62,3.22,3.75,4.25,4.75,5,6,7,7,8,9,10,10,11,12,12,13,13,13.99,13.97,12.90,11.87,10.85,9.82,9.12,8.87,8.88,9.25,10,10.95,11.65,11.89,11.75,11.34,10.75,9.97,9,8.12,7.26,7.23,7.10,7,6.99,7,7,7,6.99,6.95,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6.35,6.86,7.45,8.11,8.75,9.25,9.71,10.02,10.38,10.83,11.24,11.50,11.49,11,10.40,9.84,9.25,8.77,8.49,8.35,8.39,8.70,9.12,9.71,10.27,10.87,11.34,11.63,11.74,11.52,11.12,10.60,10,9.83,9.99,10.50,11.24,12.14,13.23,14.33,15.40,16.49,17.39,18.23,18.75,19.08,18.77,18,16.85,15.62,14.50,13.62,13.10,12.87,12.88,13.09,13.37,13.74,14.12,14.40,14.62,14.76,14.87,15.02,15.25,15.39,15.49,15.26,15.02,14.87,14.74,14.38,13.82,13.12,12.37,11.84,11.15,11.12,10.87,10.85,10.12,9.71,8.87,8.63,6.89,5.76,4.88,4.33,4.12,4,4,3.99,3.87,-11,-11,-11,-10,-9.25,-8.38,-7.50,-6.52,-5.43,-4.13,-2.63,-1.25,-0.14,0.25,0.59,0.75,0.84,0.87,0.75,0.62,0.46,0,-0.64,-1.13,-1.25,-0.88,-0.38,0.20,0.33,0.33,0.35,0.57,0.70,0.86,0.87,0.87,0.70,0.25,-0.42,-1.50,-2.78,-4.14,-5.38,-6.74,-8.38,-10,-11,-11,-8.77,-6.25,-4.12,-3.01,-2.50,-2.29,-1.65,-2.28,-4.15,-7.02,-7.61,-7.88,-8.27,-8.76,-9.29,-9.75,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.76,-9.61,-9.38,-9,-8.52,-8,-7.48,-6.92,-6.40,-5.88,-5.28,-4.63,-4,-3.38,-3.28,-3.13,-2.13,-1.93,-1.53,-1.24,-1,-0.88,-0.54,0.34,0.37,0.37,0.62,0.87,1.12,1.37,1.62,1.87,2.08,2.25,2.50,2.87,3.26,3.75,4.20,4.62,5,5.37,5.64,5.95,6.20,6.40,6.70,6.99,7.36,7.83,8.37,9,9.60,10.12,10.38,10.47,10.37,10.27,10.15,10,9.77,9.50,9.12,8.74,8.33,7.76,7.25,6.72,6.25,5.73,4.75,3.37,1.83,0.12,-1.77,-4.16,-6.26,-7.92,-7.50,-6.14,-4.25,-2.63,-1.29,-0.25,0.49,0.97,1.32,1.62,2.07,2.58,3.12,3.75,4.37,5,6,7,8,9,9,10,11,11,12,12,12,12,13,12.98,11.96,10.98,9.99,9.12,8.82,8.21,8.75,9.21,9.98,10.73,11.71,11.70,10.98,10.70,9.98,9.26,8.71,7.75,7.12,6.75,6.24,6.12,6,6,6,6,6,5.97,5,5,5,5,5,5,5,5,4,4,4,4,5,5,5,6,6,6.71,7.38,8.15,8.99,9.75,10.37,10.86,11.14,11.50,11.89,12.36,12.62,12.51,11.76,10.98,10.12,9.45,8.87,8.59,8.50,8.63,9.07,9.62,10.35,11.01,11.72,12.25,12.64,12.82,12.62,12.12,11.47,10.65,10.14,10.08,10.50,11.22,12.10,13.10,14.12,15.14,16.12,17,17.75,18.27,18.60,18.40,17.82,16.84,15.72,14.62,13.76,13.40,13.39,13.62,13.90,14.27,14.70,15.02,15.34,15.50,15.62,15.75,15.87,16,16,15.87,15.50,15.25,15,14.77,14.48,14,13.40,12.85,12.25,12.08,11.85,11.76,11.09,10.82,9.83,8.85,7.86,6.87,5.88,5.02,4.98,4.99,5,5,5,5,-11,-11,-11,-10,-9.37,-8.38,-7.42,-6.42,-5.26,-3.88,-2.39,-1.03,-0.03,0.37,0.70,0.86,0.88,0.97,0.87,0.85,0.62,0.37,-0.10,-0.38,-0.43,-0.25,0.15,0.51,0.65,0.65,0.72,0.77,0.87,0.90,0.98,0.97,0.87,0.62,0.24,-0.50,-1.38,-2.68,-3.91,-5.38,-7.17,-9.38,-11,-12,-10,-8.76,-7,-5.78,-5.18,-5.30,-5.89,-5.75,-9.64,-10,-9.80,-9.85,-9.87,-9.91,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.92,-9.86,-9.75,-9.67,-9.63,-9.52,-9.39,-9.13,-8.76,-8.30,-7.87,-7.35,-6.80,-6.29,-5.80,-5.38,-5.03,-4.86,-4.63,-4.38,-3.75,-3.48,-3.16,-2.88,-2.50,-1.89,-1.27,-0.68,-0.27,0.33,0.72,0.99,1.25,1.58,1.87,2.14,2.47,2.83,3.25,3.71,4.12,4.61,5.08,5.50,5.90,6.25,6.59,6.82,6.98,7.12,7.25,7.47,7.75,8.12,8.62,9.13,9.62,10.01,10.34,10.49,10.50,10.50,10.38,10.23,9.97,9.62,9.24,8.77,8.38,7.75,7.15,6.62,6.12,5.12,3.75,2.11,0.34,-1.67,-4.02,-6.40,-8.65,-8.38,-6.42,-4.50,-2.79,-1.38,-0.27,0.37,0.75,1,1.24,1.50,1.99,2.57,3.25,4.09,5,6,7,9,9,9,10,10,11,11,11,11,11,11,11,10.98,10,9.09,8.12,8.12,8.14,8.20,8.87,9.75,10.75,10.25,10.24,10.08,9.75,9.25,8.73,7.98,7.25,6.75,6.23,5.75,5.20,5.13,5.12,5.10,5.08,5,4.99,5,5,5,4,4,4,4,4,4,4,4,4,5,5,5,6,6,7.15,8.02,8.98,9.96,10.87,11.62,12.11,12.39,12.73,13.10,13.50,13.63,13.46,12.49,11.37,10.37,9.58,9,8.73,8.72,8.98,9.50,10.22,11,11.83,12.62,13.25,13.64,13.86,13.75,13.25,12.40,11.58,10.71,10.25,10.59,11.24,12.11,13.08,14.07,15,15.87,16.62,17.25,17.75,18.01,18,17.62,16.87,15.87,14.87,14.12,13.87,14,14.37,14.75,15.21,15.60,15.89,16.12,16.26,16.37,16.50,16.57,16.51,16.37,16,15.64,15.36,15.09,14.85,14.57,14.20,13.74,13.24,12.87,12.73,12.75,11.95,11.24,10.75,9.20,8,7.12,6.12,5.87,5.09,5.02,5.99,6,7,7,7,-12,-11,-11,-10,-9.25,-8.29,-7.38,-6.38,-5.14,-3.76,-2.29,-1,0,0.45,0.75,0.95,1,1,1,0.98,0.85,0.61,0.36,0.14,0.12,0.25,0.48,0.71,0.82,0.87,0.89,0.98,1.02,1.12,1.12,1.12,1.02,0.96,0.70,0.20,-0.40,-1.50,-2.50,-3.78,-5.61,-7.63,-9.79,-11,-11,-10,-9.14,-8.05,-7.75,-8.25,-10,-10,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.86,-9.68,-9.61,-9.50,-9.50,-9.52,-9.61,-9.63,-9.65,-9.65,-9.62,-9.36,-9.02,-8.62,-8.15,-7.67,-7.25,-6.87,-6.51,-6.29,-6.24,-6.14,-5.75,-5.50,-5.27,-5.13,-4.79,-4.26,-3.53,-2.74,-1.86,-0.87,0.11,0.50,0.72,1,1.38,1.84,2.25,2.71,3.14,3.62,4.07,4.49,4.90,5.40,5.90,6.38,6.86,7.22,7.46,7.57,7.59,7.60,7.60,7.63,7.88,8.25,8.70,9.13,9.61,9.99,10.33,10.50,10.65,10.62,10.50,10.26,9.97,9.58,9.12,8.62,8.08,7.47,6.87,6.23,5.23,3.77,2.20,0.37,-1.63,-3.91,-6.25,-8.38,-8.02,-6.25,-4.51,-2.88,-1.50,-0.43,0.12,0.45,0.58,0.73,0.99,1.37,1.98,2.72,3.62,5,6,7,9,9,9,9,10,10,10,10,10,10,10,10,9.99,9,8.01,7.89,7.87,7.87,8.11,8.15,8.85,9.10,9.12,9.01,9,8.87,8.75,7.87,7.21,6.75,6.11,5.77,5.14,4.87,4.87,4.87,4.90,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,6,6,7,7.70,8.72,9.75,10.87,11.95,12.84,13.37,13.70,13.89,14.15,14.46,14.59,14,12.87,11.58,10.50,9.62,9.11,8.87,8.98,9.34,9.95,10.75,11.65,12.62,13.47,14.12,14.60,14.83,14.75,14.37,13.49,12.45,11.46,10.76,10.75,11.33,12.22,13.14,14.11,14.96,15.71,16.33,16.86,17.34,17.70,17.87,17.70,17.08,16.21,15.26,14.62,14.50,14.75,15.13,15.62,16.09,16.46,16.73,16.87,16.98,17,17.08,17.07,16.87,16.52,16.10,15.65,15.33,15,14.77,14.57,14.26,13.90,13.60,13.25,13,12.72,12.72,10.95,9.74,8.25,7.23,6.21,6.14,6,6,6.09,6.95,7,8,8,8,-12,-11,-11,-10,-9.01,-8.13,-7.25,-6.25,-5.05,-3.75,-2.27,-1,0,0.50,0.87,1,1.12,1.12,1.11,1.12,1.07,0.88,0.74,0.60,0.51,0.59,0.71,0.83,0.90,1,1.07,1.13,1.25,1.37,1.40,1.40,1.37,1.25,1,0.75,0.37,-0.48,-1.29,-2.37,-3.88,-5.76,-7.75,-9.63,-10,-10,-10,-9.54,-9.63,-10,-12,-13,-14,-14,-13,-13,-12,-11,-11,-11,-10,-10,-10,-9.75,-9.52,-9.38,-9.25,-9.23,-9.25,-9.38,-9.53,-9.67,-9.79,-9.88,-9.98,-9.79,-9.61,-9.24,-8.88,-8.48,-8.05,-7.75,-7.50,-7.30,-7.28,-7.27,-6.92,-6.80,-6.78,-6.77,-6.62,-6,-5.14,-4.18,-3.03,-1.76,-0.25,-0.15,0.12,0.50,1,1.62,2.20,2.77,3.37,3.87,4.25,4.62,5.09,5.61,6.15,6.75,7.32,7.83,8.12,8.12,8.10,7.98,7.85,7.74,7.75,7.99,8.27,8.70,9.12,9.52,9.95,10.25,10.61,10.65,10.62,10.46,10.12,9.75,9.33,8.83,8.25,7.62,6.95,6.12,5.07,3.71,2.12,0.35,-1.63,-3.77,-6,-7.51,-7.30,-6.04,-4.63,-3.18,-1.92,-1,-0.50,-0.25,-0.13,-0.03,0.21,0.62,1.20,1.87,2.98,4,5,6,8,8,8,8,8,9,9,9,9,9,9,9,9,8,7.98,7.01,7.08,7.87,7.87,7.85,7.87,8,8,8,7.99,7.96,7.76,6.99,6.20,5.82,5.13,5,4.86,4.12,4.09,4.07,4,3.99,4,4,4,4,4,3,3,4,4,4,4,4,4,5,5,6,6,7,7,8.34,9.37,10.50,11.71,12.87,13.88,14.52,14.85,15,15.12,15.13,14.89,14.08,12.87,11.58,10.49,9.62,9.20,9.07,9.22,9.63,10.36,11.25,12.25,13.25,14.13,14.87,15.39,15.71,15.72,15.45,14.52,13.27,12.10,11.20,11.09,11.62,12.50,13.39,14.26,15,15.62,16.12,16.58,17,17.50,17.85,17.87,17.39,16.63,15.89,15.47,15.36,15.59,16,16.50,16.89,17.25,17.40,17.50,17.50,17.47,17.37,17.32,17,16.51,15.99,15.50,15.11,14.76,14.52,14.36,14.12,14.07,13.58,13.62,13,12.65,11.65,10.25,8.90,7.87,6.95,6.24,6.15,6.15,6.84,7.12,7.88,8,8.99,8,8,-11,-11,-10,-9.75,-8.66,-7.80,-7.05,-6.15,-5.02,-3.68,-2.26,-1,0.07,0.63,1,1.24,1.37,1.37,1.37,1.37,1.34,1.24,1.11,0.97,0.86,0.83,0.86,0.90,1.01,1.21,1.32,1.20,1.60,1.70,1.75,1.82,1.76,1.64,1.49,1.25,1,0.38,-0.27,-1.13,-2.30,-3.91,-5.77,-7.62,-9.25,-10,-10,-10,-10,-11,-15,-16,-16,-16,-15,-14,-13,-12,-12,-11,-10,-10,-10,-9.63,-9.38,-9.14,-9.03,-9.03,-9.14,-9.35,-9.53,-9.75,-9.92,-10,-10,-10,-10,-9.73,-9.42,-9.10,-8.75,-8.50,-8.26,-8.12,-8.05,-8.04,-7.77,-7.75,-7.79,-7.98,-7.88,-7.29,-6.41,-5.66,-4.79,-2.67,-2.38,-1.54,-1,-0.38,0.25,1.07,1.87,2.62,3.25,3.76,4.13,4.52,5,5.58,6.22,6.87,7.60,8.24,8.63,8.75,8.61,8.40,8.24,8,7.87,7.87,8.01,8.33,8.64,9.07,9.47,9.85,10.20,10.46,10.50,10.38,10.14,9.83,9.37,8.90,8.37,7.72,6.89,6,4.87,3.51,2.01,0.35,-1.51,-3.63,-5.68,-7.63,-7.75,-6.49,-5.53,-4.63,-3.77,-3.10,-2.53,-2.15,-1.88,-1.54,-1,-0.50,0.12,1,1.75,3.87,4.87,5.95,6,7,7,7,7,7,8,8,8,8,8,8,8,7,7,7,7,7.02,7.09,6.98,6.98,6.99,7,7,7,6.98,6.83,6,5.12,4.87,4.87,4.11,4.09,4,3.96,3.98,3.99,3,3,3,3,3,3,3,3,4,4,4,4,5,5,5,6,6,7,7,8,9.01,10.20,11.34,12.51,13.75,14.77,15.50,15.84,15.87,15.82,15.50,14.85,13.83,12.59,11.38,10.37,9.62,9.25,9.22,9.46,9.96,10.70,11.62,12.62,13.65,14.62,15.50,16.11,16.47,16.59,16.38,15.50,14.12,12.77,11.83,11.71,12.25,13.08,13.87,14.62,15.25,15.71,16.07,16.40,16.87,17.37,17.87,18.07,17.75,17.12,16.60,16.25,16.24,16.47,16.87,17.33,17.70,17.88,17.98,17.87,17.72,17.50,17.35,17.15,16.84,16.25,15.60,15.02,14.62,14.26,14,13.77,13.60,13.34,13.25,12.73,12.62,12.63,10.71,9.34,8.22,7.27,6.90,6.25,6.24,7.22,7.82,8.12,8.87,8.90,8.98,8,7,-11,-10,-10,-9.13,-8.17,-7.43,-6.88,-6.25,-5.12,-3.68,-2.25,-0.88,0.21,0.87,1.23,1.48,1.60,1.65,1.62,1.62,1.61,1.52,1.47,1.25,1.12,1.01,1.02,1.10,1.25,1.38,1.51,1.64,1.82,1.99,2.12,2.20,2.20,2.12,2,1.84,1.62,1.22,0.65,-0.03,-1,-2.25,-3.91,-5.67,-7.29,-8.60,-9.35,-9.98,-10,-12,-15,-16,-17,-17,-16,-15,-14,-13,-12,-11,-11,-10,-10,-9.63,-9.35,-9.13,-9.03,-9.05,-9.18,-9.38,-9.63,-9.88,-10,-10,-10,-10,-10,-10,-9.88,-9.61,-9.30,-9.05,-8.88,-8.65,-8.55,-8.50,-8.25,-8.18,-8.25,-8.28,-8.15,-7.54,-6.75,-6.38,-7.66,-6.75,-4.38,-3.50,-2.79,-1.89,-0.98,0.12,1.22,2.11,2.77,3.35,3.77,4.24,4.73,5.33,6,6.76,7.61,8.37,8.95,9.20,9.12,8.87,8.62,8.37,8.12,8,7.98,8.10,8.27,8.60,8.90,9.25,9.61,9.87,10.11,10.10,9.96,9.65,9.35,8.89,8.46,7.75,6.90,5.84,4.62,3.36,1.96,0.37,-1.38,-3.38,-5.42,-7.40,-7.40,-7.13,-6.63,-6.10,-5.53,-5,-4.50,-4.03,-3.64,-3.23,-2.66,-1.93,-0.92,0,1.50,2.99,4.12,4.87,5.08,5,5,6,6,6,6,7,7,7,7,7,7,7,7,7,6.99,6.99,6,6,6,6,6,6,6,5.98,5.87,5.11,4.11,4.10,3.88,3.90,3.95,3.97,3,3,3,3,3,3,3,3,3,3,4,4,4,4,5,5,6,6,6,7,7,8,9,10,11.11,12.26,13.37,14.50,15.59,16.34,16.57,16.50,16.25,15.64,14.75,13.59,12.33,11.12,10.27,9.62,9.33,9.36,9.64,10.21,10.96,11.86,12.87,13.88,14.89,15.83,16.58,17.11,17.37,17.25,16.38,15.01,13.50,12.45,12.40,13.09,13.82,14.52,15.12,15.51,15.82,16.07,16.37,16.83,17.37,17.82,18.07,17.89,17.60,17.25,17.10,17.12,17.32,17.62,18,18.25,18.37,18.21,17.87,17.50,17.12,16.77,16.50,16.12,15.50,14.83,14.25,13.83,13.48,13.21,12.95,12.64,12.37,12,11.62,11.25,10.62,9.63,8.36,7.35,7.24,7.12,7.26,7.87,8.24,9.20,9.82,9.86,9.87,8.02,7,6,-10,-10,-9.38,-8.50,-7.63,-6.93,-6.63,-6.14,-5.25,-3.87,-2.13,-0.53,0.60,1.22,1.50,1.72,1.82,1.84,1.87,1.87,1.87,1.84,1.76,1.62,1.49,1.37,1.35,1.37,1.48,1.62,1.76,1.95,2.12,2.32,2.49,2.62,2.65,2.64,2.61,2.49,2.26,2,1.60,1,0.23,-0.80,-2.24,-3.88,-5.51,-6.98,-8.14,-9.27,-10,-12,-15,-16,-17,-17,-17,-15,-14,-13,-12,-12,-11,-10,-10,-9.75,-9.42,-9.25,-9.17,-9.25,-9.38,-9.60,-9.80,-10,-10,-10,-10,-10,-10,-10,-10,-9.99,-9.75,-9.50,-9.28,-9.04,-8.88,-8.67,-8.39,-8.25,-8.12,-7.87,-7.43,-6.68,-5.88,-5.52,-7.04,-6.25,-5.37,-6.25,-4.30,-3.61,-2.52,-0.89,0.50,1.57,2.26,2.85,3.32,3.75,4.27,4.88,5.62,6.48,7.37,8.25,9,9.37,9.50,9.37,9.10,8.76,8.50,8.24,8.08,8,8.02,8.20,8.38,8.63,8.89,9.13,9.33,9.37,9.37,9.24,9.01,8.75,8.37,7.95,6.83,5.64,4.48,3.23,1.96,0.52,-1.05,-3.12,-5.14,-6.75,-7.63,-7.80,-7.74,-7.50,-7.25,-6.88,-6.36,-5.80,-5.37,-4.99,-4.29,-3.26,-1.93,-0.43,1.09,2.75,3.82,3.86,3.99,4,4,4,5,5,5,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,4.99,4.90,4.07,3.90,3.01,3,3,3,3,3,3,3,3,3,3,3,3,3,3.97,3.97,4.01,4,4.97,5,5.98,6,6.99,7,7,8,9,10,10.98,12.01,13,14.10,15.12,16.12,16.87,17.01,16.90,16.50,15.74,14.70,13.50,12.25,11.09,10.23,9.64,9.39,9.50,9.87,10.40,11.12,12,12.99,14,15,15.98,16.82,17.49,17.90,17.89,17.22,15.99,14.65,13.75,13.62,14.01,14.59,15.12,15.57,15.77,15.95,16.10,16.38,16.87,17.47,17.87,18.12,18.12,18,17.87,17.87,17.97,18.09,18.25,18.40,18.50,18.40,17.98,17.46,16.87,16.27,15.86,15.39,14.95,14.37,13.75,13.23,12.75,12.45,12.13,11.87,11.57,11.20,10.75,10.26,9.84,9.26,8.37,8.02,7.37,7.35,7.34,8.27,9.24,10.73,10.75,10.77,9.95,8.87,7.08,6,6,-9.78,-9.27,-8.52,-7.88,-7.17,-6.77,-6.54,-6.16,-5.39,-3.78,-2,-0.25,0.99,1.50,1.87,1.90,1.89,1.97,2.09,2.20,2.25,2.25,2.23,2.02,1.87,1.74,1.62,1.62,1.71,1.84,2,2.20,2.40,2.65,2.90,3.12,3.25,3.32,3.27,3.23,3.09,2.87,2.51,2,1.33,0.38,-0.79,-2.28,-3.87,-5.38,-6.78,-8.25,-9.90,-12,-14,-15,-17,-17,-16,-16,-15,-14,-13,-12,-11,-10,-10,-9.99,-9.64,-9.50,-9.48,-9.51,-9.65,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.85,-9.62,-9.28,-9.01,-8.74,-8.36,-8,-7.62,-7.05,-6.28,-5.29,-4.13,-3.38,-2.41,-2.38,-3.14,-3.40,-4.13,-6.13,-4.14,-1.50,0.07,1.12,1.85,2.37,2.84,3.26,3.76,4.37,5.12,6,6.90,7.89,8.75,9.33,9.60,9.62,9.48,9.12,8.82,8.49,8.22,8,7.87,7.87,7.96,8.08,8.23,8.37,8.50,8.60,8.62,8.59,8.47,8.32,8.07,7.47,6.62,5.49,4.35,3.12,1.87,0.58,-0.93,-2.88,-5,-6.73,-7.91,-8.51,-8.74,-8.79,-8.77,-8.50,-7.90,-7.25,-6.75,-6.35,-5.85,-4.29,-2.75,-0.88,0.75,2,2.75,2.96,2.99,3,3,3,4,4,4,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,2,2,2.33,2.96,3.15,3.33,3.47,3.62,3.87,4.22,4.50,4.73,5.01,5.37,5.85,6.02,6.96,7,7,7.99,9,10,11,11.87,12.62,13.62,14.62,15.60,16.40,17.09,17.26,17.12,16.62,15.82,14.74,13.50,12.26,11.12,10.21,9.72,9.59,9.73,10.10,10.62,11.27,12.12,13,14,15,16,16.88,17.64,18.25,18.50,18.02,17.02,15.87,15.10,14.86,14.98,15.25,15.59,15.82,15.96,16,16.21,16.61,17.15,17.75,18.14,18.36,18.37,18.37,18.46,18.51,18.63,18.62,18.62,18.50,18.32,17.88,17.37,16.72,16,15.37,14.76,14.25,13.73,13.13,12.58,12.01,11.62,11.32,11.02,10.75,10.46,10.02,9.62,9.14,8.45,8.38,8.22,7.99,7.96,8.08,8.35,9.34,10.65,11.71,11.74,10.77,9.82,8.86,7.10,6.01,5.99,-9.25,-8.88,-8.28,-7.62,-7.03,-6.79,-6.62,-6.25,-5.25,-3.63,-1.88,-0.17,0.97,1.61,1.83,1.96,2,2.12,2.20,2.64,2.62,2.62,2.58,2.40,2.23,2.01,1.88,1.87,1.87,1.99,2.14,2.47,2.75,3.12,3.46,3.73,3.95,4.09,4.12,4.10,3.97,3.75,3.40,2.98,2.37,1.50,0.45,-0.87,-2.25,-3.74,-5.25,-6.90,-8.80,-11,-14,-15,-16,-16,-16,-15,-15,-14,-13,-12,-11,-11,-10,-10,-9.93,-9.80,-9.79,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.78,-9.43,-9.11,-8.64,-8.15,-7.63,-7,-6.13,-5,-3.75,-2.38,0.23,0.10,-0.26,-0.50,-0.65,-2.62,-3.48,-3.25,-1.49,-0.03,0.88,1.52,2,2.40,2.85,3.27,3.85,4.59,5.40,6.37,7.33,8.24,8.87,9.37,9.51,9.50,9.34,9,8.62,8.27,8,7.75,7.62,7.57,7.51,7.57,7.62,7.70,7.75,7.83,7.85,7.82,7.70,7.46,6.97,6.25,5.32,4.25,3.12,1.89,0.62,-0.79,-2.50,-4.80,-6.75,-8.17,-8.99,-9.36,-9.55,-9.64,-9.38,-8.85,-8.13,-7.60,-7.05,-6.17,-4.87,-3.26,-1.02,0.73,1.74,1.87,2,2,2.12,2.09,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,2.62,2.61,2.85,3.12,3.47,3.72,3.97,4.24,4.51,4.87,5.15,5.50,5.83,6.14,6.50,6.86,7.12,7.02,7.96,8,9,10,12,12,13.12,14.12,14.97,15.77,16.45,17.09,17.34,17.25,16.74,15.87,14.77,13.59,12.35,11.21,10.26,9.75,9.75,9.95,10.27,10.77,11.39,12.14,13.02,14,15,16,16.90,17.74,18.37,18.83,18.75,18.21,17.25,16.49,15.97,15.73,15.73,15.85,15.97,16,16.12,16.36,16.95,17.71,18.34,18.63,18.71,18.72,18.74,18.84,18.98,19,18.87,18.64,18.35,17.87,17.25,16.58,15.85,15.10,14.37,13.71,13.10,12.50,11.97,11.39,10.90,10.52,10.25,10.01,9.76,9.49,9.12,8.72,8.47,8.25,8.13,8.21,8.27,8.37,9.09,9.84,10.74,11.64,12.71,12.73,10.75,9.20,7.84,6.12,6.07,5.98,-8.90,-8.52,-8.03,-7.50,-7.12,-6.88,-6.75,-6.30,-5.25,-3.51,-1.65,-0.04,1,1.58,1.86,2.11,2.12,2.14,2.63,2.75,2.87,2.86,2.82,2.70,2.48,2.25,2.11,2,2,2.12,2.37,2.72,3.12,3.58,4,4.36,4.62,4.87,4.98,4.96,4.84,4.62,4.26,3.85,3.25,2.47,1.50,0.49,-0.65,-2,-3.50,-5.26,-7.30,-9.42,-12,-14,-15,-15,-15,-15,-14,-14,-13,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.90,-9.52,-9.13,-8.55,-7.99,-7.26,-6.41,-5.36,-3.89,-1.89,-0.79,0.22,0.47,0.37,0.32,-0.13,-1,-1.64,-1.75,-0.87,0.11,0.86,1.37,1.76,2.13,2.50,2.87,3.37,4.02,4.87,5.75,6.62,7.50,8.23,8.73,9,9.12,9.12,8.95,8.62,8.25,7.88,7.62,7.37,7.21,7.08,6.99,6.95,6.95,6.99,7.02,7.12,7.12,7.07,6.87,6.50,5.90,5.15,4.25,3.25,2.09,0.62,-0.68,-2.41,-4.63,-6.67,-8.16,-9,-9.42,-9.67,-9.75,-9.53,-9.02,-8.43,-7.85,-7.16,-6.23,-4.79,-3.27,-1.13,0.25,1,1.36,1.46,1.47,1.34,1.87,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2.21,2.50,2.75,3.01,3.25,3.58,3.87,4.23,4.57,4.89,5.26,5.63,6,6.37,6.73,7.01,7.32,7.52,7.74,8,8.25,8.95,9.01,10.98,11.98,12,13.84,14.60,14.82,15.49,16.14,16.75,17.14,17.34,16.75,15.87,14.84,13.62,12.40,11.32,10.40,9.99,9.89,10.12,10.48,10.90,11.50,12.22,13.07,14,15,15.99,16.89,17.75,18.47,19,19.25,19.12,18.49,17.60,16.75,16.23,15.99,15.97,16,16.12,16.02,16.82,17.46,18.27,19.02,19.21,19.02,18.96,18.87,18.87,18.87,18.76,18.63,18.39,18,17.37,16.62,15.83,15.01,14.21,13.37,12.62,12,11.45,10.90,10.46,10,9.70,9.45,9.23,9,8.77,8.57,8.37,8.24,8.25,8.36,8.39,9,9.38,10.33,11.21,12,12.62,12.65,11.71,10.12,8.22,7.13,6.12,6,5.97,-8.65,-8.38,-8,-7.38,-7.01,-6.88,-6.75,-6.26,-5.13,-3.40,-1.63,-0.03,1,1.51,1.88,2.25,2.83,2.70,2.77,2.87,2.90,2.90,2.87,2.82,2.62,2.45,2.25,2.12,2.12,2.24,2.50,2.88,3.38,3.90,4.47,4.96,5.36,5.63,5.85,5.86,5.75,5.50,5.15,4.75,4.14,3.45,2.58,1.59,0.50,-0.63,-1.89,-3.63,-5.75,-8.38,-11,-13,-14,-14,-14,-14,-14,-14,-13,-12,-12,-11,-11,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.62,-9.13,-8.50,-7.78,-6.99,-6,-4.75,-3.23,-1.37,-0.10,0.24,0.59,0.62,0.60,0.37,-0.03,-0.42,-0.50,-0.15,0.37,0.87,1.32,1.65,2.01,2.37,2.73,3.13,3.72,4.37,5.14,5.98,6.71,7.36,7.87,8.22,8.40,8.51,8.48,8.26,7.98,7.62,7.35,7.08,6.85,6.62,6.49,6.37,6.33,6.34,6.37,6.49,6.51,6.50,6.37,6.12,5.72,5.12,4.37,3.39,2.12,0.62,-0.68,-2.40,-4.66,-6.41,-7.79,-8.63,-9.13,-9.38,-9.41,-9.25,-8.88,-8.38,-7.75,-6.93,-5.88,-4.40,-2.78,-1,0.09,0.71,1,1.12,1.12,1.22,1.25,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2.32,2.59,2.87,3.12,3.45,3.74,4.08,4.46,4.87,5.26,5.74,6.20,6.62,7.02,7.40,7.75,8.01,8.25,8.37,8.50,8.64,8.90,9.26,9.90,10.95,11.02,12.02,13.01,13.83,14.37,14.99,15.62,16.25,16.77,17.09,16.63,15.87,14.86,13.71,12.51,11.40,10.58,10.14,10.11,10.25,10.61,11,11.52,12.24,13.08,14,14.99,15.98,16.89,17.75,18.50,19.10,19.51,19.73,19.37,18.37,17.20,16.35,16,16,16.07,16,16.98,17.12,18.12,18.98,19.51,19.57,19.24,19,18.77,18.57,18.37,18.25,18.14,18,17.60,16.89,16.10,15.21,14.32,13.37,12.50,11.65,11.07,10.57,10.12,9.75,9.39,9.12,8.87,8.71,8.57,8.45,8.35,8.33,8.37,8.46,8.99,9.45,10.08,10.85,11.77,12.64,13.24,13.62,12.64,11.15,9.25,7.87,6.15,6.12,6,5.96,-8.52,-8.17,-7.66,-7.25,-7,-6.88,-6.75,-6.25,-5.03,-3.38,-1.54,-0.03,0.97,1.50,1.97,2.38,2.74,2.87,2.95,2.97,2.99,2.98,2.96,2.87,2.75,2.59,2.38,2.25,2.23,2.32,2.59,3,3.57,4.15,4.83,5.40,5.96,6.36,6.62,6.70,6.60,6.36,6,5.60,5.01,4.36,3.51,2.62,1.62,0.50,-0.74,-2.13,-3.88,-6.63,-9.68,-10,-11,-11,-12,-12,-13,-12,-12,-12,-11,-11,-11,-11,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.63,-9.13,-8.49,-7.74,-6.85,-5.77,-4.51,-3,-1,-0.01,0.45,0.71,0.75,0.76,0.72,0.50,0.36,0.25,0.37,0.62,0.97,1.32,1.65,2.02,2.40,2.82,3.21,3.62,4.12,4.73,5.37,6,6.50,6.99,7.33,7.58,7.71,7.75,7.62,7.45,7.20,6.90,6.65,6.45,6.23,6.02,5.88,5.85,5.85,5.88,6,6.10,6.12,6.02,5.87,5.57,5.12,4.37,3.39,2.12,0.70,-0.75,-2.38,-4.63,-5.92,-7.13,-8,-8.53,-8.88,-8.99,-8.88,-8.55,-8.13,-7.50,-6.63,-5.40,-3.88,-2.01,-0.54,0.12,0.62,0.87,1,1,1.08,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2.37,2.70,2.98,3.25,3.57,3.87,4.25,4.62,5.12,5.62,6.13,6.72,7.25,7.75,8.25,8.62,8.95,9.13,9.25,9.32,9.33,9.37,9.50,9.83,10.27,10.88,11.09,11.88,12.87,13.15,13.85,14.46,15.12,15.75,16.34,16.75,16.50,15.75,14.84,13.74,12.61,11.57,10.72,10.26,10.25,10.39,10.70,11.01,11.58,12.24,13.08,14,14.99,15.98,16.95,17.83,18.57,19.23,19.62,19.96,19.62,18.62,17.33,16.23,16,16,16,17,17,18,19,19.52,19.75,19.52,19.21,18.83,18.39,18.02,17.75,17.62,17.52,17.39,17.07,16.46,15.64,14.70,13.64,12.64,11.71,10.87,10.27,9.87,9.59,9.33,9.10,8.87,8.65,8.50,8.46,8.45,8.50,8.50,8.95,9.38,10,10.74,11.45,12.35,13.25,14.60,14.62,13.62,12.64,10.86,9.12,7.24,6.20,6.01,5.99,5.96,-8.50,-8.05,-7.63,-7.13,-7,-6.88,-6.66,-6.04,-4.88,-3.25,-1.50,-0.03,0.97,1.50,1.99,2.40,2.74,2.96,3.02,3.08,3.02,3,2.99,2.90,2.86,2.71,2.51,2.37,2.33,2.37,2.62,3.02,3.59,4.25,4.97,5.65,6.33,6.85,7.22,7.36,7.27,7.10,6.76,6.37,5.86,5.23,4.48,3.62,2.64,1.62,0.51,-0.63,-2.03,-3.25,-6.50,-8.13,-8.26,-8.77,-9.63,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-11,-11,-11,-11,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-9.66,-9.13,-8.50,-7.75,-6.87,-5.79,-4.60,-3.12,-1.62,0,0.46,0.74,0.90,0.84,0.82,0.75,0.64,0.63,0.65,0.77,1.01,1.35,1.73,2.12,2.57,2.98,3.36,3.72,4.08,4.47,4.87,5.37,5.82,6.20,6.50,6.74,6.87,6.95,6.88,6.77,6.62,6.39,6.21,6,5.77,5.62,5.50,5.47,5.50,5.58,5.65,5.75,5.84,5.77,5.65,5.50,5.08,4.25,3.27,2.07,0.74,-0.63,-2.25,-4.25,-5.13,-6.25,-7.16,-7.88,-8.27,-8.49,-8.43,-8.25,-7.87,-7.25,-6.35,-5.11,-3.50,-1.51,-0.01,0.37,0.62,0.83,0.87,0.98,1,1,1,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,2.75,2.88,3.13,3.40,3.73,4.01,4.37,4.83,5.27,5.86,6.48,7.12,7.77,8.46,9.02,9.52,9.96,10.22,10.35,10.36,10.25,10.13,10.10,10.12,10.33,10.62,11,11.12,11.87,12.12,12.88,13.25,13.96,14.62,15.36,15.90,16.22,16.10,15.52,14.72,13.71,12.62,11.63,10.85,10.46,10.39,10.52,10.76,11.10,11.50,12.13,13.07,14,14.99,15.98,16.96,17.87,18.61,19.25,19.64,19.98,19.75,18.84,17.10,16,16,16,17,17,18,19.09,19.87,20.37,19.99,19.57,19.08,18.57,18.01,17.57,17.15,17,16.96,16.87,16.57,15.97,15.12,14.12,13.08,12,11.07,10.25,9.73,9.47,9.25,9.12,9,8.87,8.75,8.71,8.72,8.84,9.02,9.37,9.87,10.45,11.34,12.22,13.11,14,14.71,14.96,14.62,13.62,12.12,10.70,8.77,7.24,6.20,6.01,5.98,5.96,-8.39,-8.13,-7.75,-7.25,-7,-6.88,-6.53,-5.88,-4.63,-3.04,-1.43,-0.03,0.89,1.50,1.99,2.38,2.76,3.08,3.22,3.23,3.12,3.07,3,2.97,2.87,2.76,2.62,2.50,2.37,2.45,2.62,2.99,3.50,4.12,4.87,5.62,6.37,7.01,7.50,7.75,7.77,7.63,7.38,7.02,6.60,6,5.34,4.51,3.63,2.72,1.74,0.75,0.08,-1.51,-2.63,-4.25,-4.53,-4.98,-6.90,-8.68,-9.50,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.74,-9.18,-8.60,-7.87,-7,-6,-4.88,-3.55,-2.03,-0.28,0.20,0.37,0.57,0.71,0.62,0.62,0.62,0.62,0.71,0.85,1.07,1.37,1.75,2.22,2.72,3.21,3.59,3.87,4.12,4.37,4.62,4.89,5.24,5.50,5.75,5.97,6.10,6.14,6.14,6.11,6,5.85,5.65,5.50,5.35,5.23,5.13,5.13,5.23,5.34,5.47,5.57,5.62,5.62,5.51,5.37,4.87,4.12,3.13,2.08,0.87,-0.27,-1.63,-2.88,-4.13,-5.27,-6.30,-7.13,-7.67,-8,-8.12,-8,-7.66,-7.11,-6.18,-5,-3.41,-1.50,0.25,0.50,0.62,0.75,0.85,0.87,0.96,0.97,0.98,0.98,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3.12,3.33,3.49,3.72,3.99,4.25,4.62,5,5.47,6,6.62,7.36,8.12,8.89,9.65,10.36,10.87,11.26,11.50,11.51,11.40,11.23,10.99,10.77,10.75,10.84,11.07,11.37,11.75,12.12,12.15,12.84,13.15,13.35,14.25,15.02,15.62,15.87,15.75,15.25,14.50,13.58,12.61,11.74,11.08,10.74,10.64,10.75,10.95,11.21,11.58,12.21,13.01,13.99,14.99,15.99,16.99,17.98,19,19,20,20,20,19,17,16,16,17,17,18.07,19.09,20.71,20.62,20.37,19.96,19.38,18.85,18.24,17.63,17.10,16.65,16.47,16.37,16.25,15.96,15.37,14.57,13.58,12.50,11.50,10.50,9.86,9.46,9.23,9.12,9.12,9.12,9.12,9.12,9.20,9.33,9.57,9.96,10.46,11.08,11.85,12.83,13.87,14.76,15.58,16.58,15.60,14.62,13.25,11.75,10.12,8.25,7.20,6.20,6.01,5.98,5.96,-8.50,-8.13,-7.64,-7.30,-7.03,-6.87,-6.50,-5.67,-4.42,-2.88,-1.28,0.08,1,1.50,1.98,2.40,2.87,3.25,3.45,3.37,3.25,3.11,3,2.98,2.95,2.86,2.74,2.60,2.48,2.46,2.58,2.86,3.27,3.87,4.62,5.37,6.14,6.88,7.50,7.87,8.01,8,7.84,7.57,7.20,6.71,6.10,5.37,4.57,3.65,2.82,1.96,1.07,0.11,-0.92,-1.63,-1.64,-3.01,-4.62,-6.68,-7.75,-8.48,-8.88,-9.15,-9.38,-9.63,-9.90,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.79,-9.30,-8.75,-8.03,-7.13,-6.25,-5.25,-4.24,-3.10,-1.99,-0.85,-0.16,0,0.13,0.20,0.25,0.35,0.40,0.52,0.75,1,1.33,1.72,2.21,2.74,3.25,3.65,3.97,4.12,4.27,4.45,4.61,4.76,4.98,5.12,5.26,5.37,5.47,5.48,5.45,5.37,5.25,5.12,5,4.87,4.83,4.82,4.87,5,5.12,5.25,5.37,5.46,5.46,5.37,5.21,4.73,4,3.12,2.14,1.20,0.25,-0.64,-1.75,-2.98,-4.28,-5.48,-6.40,-7.13,-7.61,-7.85,-7.86,-7.63,-7.12,-6.26,-5.13,-3.73,-1.91,0.11,0.37,0.37,0.50,0.63,0.75,0.87,0.95,0.98,0.98,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3.60,3.87,4.11,4.36,4.62,4.96,5.27,5.70,6.14,6.74,7.39,8.22,9.08,9.97,10.82,11.57,12.13,12.51,12.71,12.63,12.45,12.12,11.75,11.49,11.34,11.36,11.50,11.84,12.25,12.75,13,13.21,13.22,13.23,14.21,14.90,15.50,15.74,15.59,15.08,14.32,13.39,12.57,11.84,11.34,11.02,10.98,11,11.14,11.37,11.71,12.26,13.09,14,14.99,15.99,16.99,18,19,19,20,20,20,18,17,17,16.99,17,18.09,18.98,19.97,20.62,20.73,20.25,19.63,19.07,18.50,17.87,17.25,16.73,16.25,16,15.82,15.60,15.23,14.64,13.87,12.90,11.89,10.96,10.14,9.58,9.25,9.12,9.13,9.25,9.37,9.52,9.75,9.97,10.24,10.57,11.09,11.65,12.39,13.25,14.34,15.52,16.52,16.72,16.58,15.73,14.62,12.87,11.25,9.71,8.25,7.09,6.20,6.02,6,5.96,-8.65,-8.28,-7.75,-7.38,-7.13,-6.76,-6.25,-5.38,-4.16,-2.75,-1.25,0,0.90,1.47,1.95,2.46,2.99,3.39,3.62,3.50,3.32,3.12,3,3,2.96,2.87,2.77,2.63,2.50,2.47,2.50,2.71,3.07,3.58,4.24,5,5.76,6.52,7.22,7.71,7.98,8.02,8,7.84,7.58,7.20,6.64,6.01,5.32,4.50,3.73,2.89,2.11,1.25,0.50,0.13,-0.93,-1.91,-3.25,-5.18,-6.27,-7,-7.49,-7.88,-8.25,-8.65,-9.15,-9.75,-10,-10,-11,-12,-12,-13,-13,-13,-12,-12,-11,-11,-11,-11,-11,-10,-10,-10,-9.74,-9.29,-8.86,-8.30,-7.73,-7.03,-6.36,-5.63,-4.88,-4.14,-3.28,-2.41,-1.54,-0.93,-0.66,-0.54,-0.38,-0.16,-0.03,0.23,0.50,0.87,1.22,1.59,2,2.50,3,3.39,3.74,3.88,4.01,4.12,4.23,4.36,4.49,4.59,4.70,4.75,4.84,4.86,4.84,4.76,4.72,4.62,4.50,4.46,4.40,4.49,4.61,4.75,4.96,5.12,5.24,5.27,5.27,5.23,5,4.62,3.98,3.20,2.35,1.50,0.85,0.23,0.08,-1.79,-3.38,-4.65,-5.75,-6.63,-7.25,-7.63,-7.76,-7.64,-7.25,-6.54,-5.54,-4.27,-2.78,-1.03,-0.64,-0.30,0,0.25,0.58,0.75,0.87,0.96,0.98,0.99,1,1,1,1,1,1,1,1,1,1,1,1,1.99,1.98,2,2.01,2.96,2.96,3.01,3.01,3.96,3.89,4.23,4.50,4.82,5.11,5.38,5.74,6.10,6.49,6.96,7.50,8.20,9,9.87,10.84,11.75,12.57,13.23,13.62,13.75,13.62,13.35,12.90,12.50,12.12,11.89,11.87,12,12.25,12.71,13.23,13.74,13.75,13.74,13.95,14.25,15.01,15.52,15.76,15.61,15.01,14.23,13.35,12.58,11.98,11.60,11.37,11.33,11.37,11.50,11.70,11.89,12.45,13.12,14,14.99,15.99,17,18,19,19,20,20,19,18,17,17,17,18.09,18.85,19.62,20.48,20.50,20.27,19.73,19.10,18.50,17.98,17.39,16.87,16.39,16,15.62,15.34,14.96,14.48,13.87,13.12,12.23,11.25,10.39,9.82,9.45,9.21,9.20,9.33,9.52,9.85,10.15,10.52,10.96,11.37,11.84,12.37,13,13.82,14.71,15.73,16.74,17.52,17.58,16.84,15.64,14.14,12.35,10.89,9.27,8.13,7.07,6.20,6.12,6.10,5.96,-8.63,-8.25,-7.77,-7.50,-7.14,-6.75,-6.13,-5.17,-4,-2.63,-1.25,0,0.85,1.38,1.87,2.45,3.02,3.49,3.65,3.50,3.33,3.12,3.02,3,2.98,2.90,2.86,2.72,2.59,2.49,2.47,2.57,2.82,3.23,3.77,4.50,5.25,6.01,6.73,7.25,7.62,7.84,7.87,7.85,7.70,7.38,7,6.49,5.87,5.15,4.48,3.74,2.98,2.20,1.46,0.62,-0.16,-1.25,-2.51,-4.29,-5.11,-5.65,-6.13,-6.60,-7.11,-7.67,-8.38,-9.13,-9.91,-10,-11,-12,-12,-13,-13,-13,-12,-12,-11,-11,-11,-11,-10,-10,-10,-9.63,-9.23,-8.78,-8.38,-7.90,-7.40,-6.90,-6.39,-5.88,-5.36,-5.11,-4.50,-3.73,-2.89,-2.50,-2.15,-1.75,-0.75,-1.13,-0.80,-0.38,0.11,0.50,0.87,1.25,1.62,2.01,2.46,2.84,3.12,3.37,3.50,3.62,3.72,3.82,3.95,4.07,4.12,4.23,4.26,4.32,4.32,4.25,4.24,4.13,4.10,4.07,4.08,4.14,4.34,4.52,4.75,4.96,5.10,5.15,5.20,5.11,4.90,4.59,4,3.27,2.51,1.83,1.24,0.75,0.07,-1,-2.60,-4,-5.17,-6.17,-6.99,-7.50,-7.78,-7.80,-7.54,-7,-6.25,-5.13,-3.88,-2.75,-1.88,-1.30,-0.75,-0.16,0.25,0.62,0.83,0.88,0.98,0.99,1,1,1,1,1,1,1,1,1,1,1,1.97,2.01,2.07,2.89,2.88,3.09,3.88,3.88,4.09,4.09,4.74,5,5.33,5.62,5.90,6.25,6.62,7,7.37,7.77,8.32,8.95,9.71,10.57,11.50,12.39,13.25,13.98,14.40,14.58,14.45,14.11,13.63,13.15,12.75,12.49,12.37,12.46,12.71,13.11,13.62,14.72,14.25,14.25,14.25,14.89,15.25,15.87,16.10,15.88,15.24,14.27,13.37,12.64,12.13,11.87,11.73,11.65,11.75,11.87,12.12,12.37,12.50,13.25,14.01,15,15.99,16.99,18,19,19,20,20,20,18,17,17,17.98,18.74,19.58,19.84,19.96,19.95,19.61,19.07,18.37,17.83,17.34,16.87,16.48,16.12,15.75,15.38,14.98,14.47,13.84,13.12,12.33,11.48,10.62,9.96,9.50,9.33,9.27,9.35,9.62,10,10.48,11,11.50,12.08,12.58,13.10,13.64,14.37,15.21,16.08,16.90,17.75,18.58,18.58,17,15.61,13.88,12.33,10.74,9.26,8.07,7.01,6.15,6.12,6.87,6.96,-8.77,-8.50,-8.02,-7.64,-7.25,-6.75,-6.03,-5.03,-3.80,-2.50,-1.13,0,0.83,1.36,1.83,2.37,3,3.47,3.62,3.46,3.25,3.12,3.01,3,3,2.98,2.87,2.75,2.62,2.50,2.45,2.46,2.61,2.88,3.37,3.98,4.65,5.39,6.12,6.70,7.12,7.38,7.57,7.61,7.52,7.37,7.11,6.71,6.21,5.62,5,4.37,3.62,2.87,2.10,1.25,0.36,-0.55,-1.91,-3.75,-4.13,-4.51,-4.92,-5.41,-6.02,-6.77,-7.64,-8.61,-9.52,-10,-11,-12,-12,-13,-13,-13,-13,-12,-11,-11,-10,-10,-10,-10,-9.49,-9,-8.61,-8.25,-7.88,-7.50,-7.12,-6.74,-6.36,-5.89,-5.49,-5.30,-5.01,-4.13,-3.51,-3.88,-3.88,-3.25,-2.93,-2.50,-1.78,-1.13,-0.50,0,0.39,0.75,1.07,1.37,1.72,2.07,2.37,2.62,2.84,2.97,3.07,3.15,3.33,3.48,3.62,3.73,3.77,3.85,3.86,3.85,3.82,3.75,3.73,3.70,3.74,3.87,4.10,4.34,4.59,4.83,4.99,5.12,5.12,5.12,4.97,4.62,4.10,3.38,2.71,2.02,1.50,0.99,0.37,-0.15,-1.90,-3.40,-4.75,-5.89,-6.86,-7.52,-8,-8.15,-8.02,-7.60,-6.87,-5.92,-5,-4.13,-3.27,-2.38,-1.42,-0.63,0,0.50,0.75,0.96,1,1,1,1,1,1,1,1,1,1,1,1,1.96,2.07,2.88,2.87,3.11,3.11,3.87,4.12,4.87,5,5.25,5.59,5.88,6.21,6.50,6.85,7.21,7.60,7.98,8.35,8.73,9.13,9.70,10.35,11.12,11.98,12.86,13.71,14.38,14.88,15.11,15.01,14.74,14.26,13.82,13.37,13.01,12.87,12.87,13.09,13.40,13.97,14.48,14.87,15,15.26,15.71,16.09,16.32,16.65,16.64,15.58,14.50,13.58,12.82,12.32,12.12,12.02,12.01,12.09,12.32,12.64,12.96,13.24,13.12,14.11,15,15.99,16.99,18,19,19,20,20,20,18.99,18,18.09,18.75,19.07,19.46,19.50,19.27,19.07,18.71,18.20,17.60,17.11,16.62,16.22,15.96,15.76,15.62,15.25,14.75,14.10,13.32,12.48,11.62,10.77,10.09,9.60,9.34,9.27,9.45,9.65,10.02,10.61,11.25,11.95,12.63,13.25,13.76,14.27,14.90,15.75,16.58,17.37,18.09,18.70,18.95,18.59,17.02,15.35,13.74,12.21,10.73,9.26,8.02,7,6.14,6.86,7.08,6.97,-9.29,-8.93,-8.38,-7.88,-7.39,-6.79,-6,-4.92,-3.65,-2.30,-1.02,0.08,0.77,1.26,1.74,2.25,2.85,3.25,3.37,3.32,3.15,3.11,3.07,3.07,3.07,3.01,3,2.87,2.75,2.60,2.47,2.38,2.47,2.63,3,3.50,4.11,4.75,5.40,6,6.50,6.85,7.08,7.20,7.23,7.13,6.99,6.71,6.34,5.87,5.37,4.77,4.12,3.37,2.61,1.75,0.86,-0.02,-1.29,-2.98,-3.24,-3.54,-3.99,-4.50,-5.17,-6.04,-7.03,-8.13,-9.17,-10,-11,-12,-12,-13,-13,-13,-13,-12,-11,-11,-10,-10,-10,-9.25,-8.65,-8.18,-7.85,-7.52,-7.26,-7,-6.74,-6.42,-6.13,-5.74,-5.23,-4.78,-4.24,-3.61,-3,-2.88,-3.75,-3.89,-6.05,-3.86,-2.87,-1.90,-1.25,-0.64,-0.35,0,0.25,0.57,0.87,1.25,1.62,1.90,2.13,2.27,2.37,2.50,2.70,2.88,3.11,3.25,3.37,3.45,3.49,3.48,3.47,3.40,3.39,3.39,3.49,3.62,3.87,4.12,4.39,4.70,4.89,5.12,5.25,5.25,5.10,4.75,4.15,3.50,2.83,2.21,1.62,1.12,0.62,-0.02,-1.39,-2.89,-4.38,-5.63,-6.63,-7.39,-7.92,-8.18,-8.17,-7.88,-7.36,-6.67,-5.92,-5.25,-4.55,-3.30,-2.13,-1.01,-0.14,0.48,0.85,1,1.12,1.10,1,1,1,1,1,1,1,1.99,1.97,2.07,2.09,2.87,3.11,3.12,3.86,4.12,4.85,5.12,5.85,6,6.25,6.57,6.85,7.12,7.40,7.75,8.13,8.57,8.97,9.33,9.64,10,10.45,10.97,11.61,12.35,13.12,13.95,14.62,15.15,15.46,15.47,15.24,14.85,14.37,13.95,13.60,13.37,13.32,13.39,13.70,14.12,14.63,15.63,15.64,16.08,16.70,16.86,17.08,17.12,16.76,15.95,14.77,13.75,12.95,12.33,12.22,12.70,12.25,12.25,12.77,13.24,13.76,14,14.12,14.12,15.09,15.99,16.99,18,19,19,20,20,20,19.98,19,18.97,18.96,18.95,18.95,18.83,18.60,18.26,17.87,17.37,16.87,16.35,15.77,15.38,15.25,15.36,15.50,15.25,14.62,13.76,12.87,11.96,11,10.24,9.63,9.36,9.25,9.38,9.70,10.12,10.63,11.37,12.20,13,13.84,14.60,15,15.37,16.14,17.09,17.90,18.72,19.13,19.59,19.59,18.61,16.87,15.23,13.35,12.20,10.73,9.25,8.02,7,6.13,6.87,7.90,7.98,-9.87,-9.42,-8.75,-8.15,-7.63,-7,-6.04,-4.88,-3.52,-2.13,-0.88,0.12,0.75,1.24,1.62,2.11,2.60,2.97,3.12,3.12,3.11,3.10,3.12,3.12,3.14,3.15,3.12,3.02,2.88,2.74,2.57,2.45,2.37,2.49,2.72,3.10,3.60,4.14,4.75,5.34,5.83,6.22,6.50,6.65,6.75,6.76,6.72,6.51,6.26,5.96,5.51,5.01,4.40,3.74,2.97,2.12,1.25,0.34,-0.66,-2,-2.38,-2.75,-3.24,-3.79,-4.55,-5.50,-6.61,-7.75,-8.90,-10,-11,-12,-13,-13,-13,-13,-13,-12,-11,-10,-9.75,-9.26,-9,-8.16,-7.61,-7.15,-6.88,-6.68,-6.55,-6.42,-6.25,-6.04,-5.79,-5.36,-4.67,-4,-3.30,-2.63,-1.91,-1.25,-2.23,-3.24,-4.80,-5,-3.55,-3,-1.75,-1.88,-1.35,-1.01,-0.77,-0.43,0,0.51,1,1.37,1.62,1.75,1.87,2,2.21,2.46,2.71,2.88,3.02,3.12,3.15,3.21,3.21,3.21,3.21,3.25,3.34,3.49,3.71,3.97,4.24,4.50,4.75,5.13,5.37,5.48,5.25,4.87,4.22,3.51,2.87,2.25,1.71,1.12,0.59,0,-0.88,-2.73,-4.18,-5.50,-6.54,-7.38,-7.98,-8.28,-8.38,-8.17,-7.77,-7.25,-6.64,-6.11,-5.63,-4.13,-2.63,-1.29,-0.25,0.50,1,1.25,1.37,1.38,1,1,1,1,2,2,2,2.01,2.89,3,3.11,3.87,4.12,4.12,4.84,5.14,5.83,6.14,6.83,7,7.25,7.57,7.83,8.10,8.37,8.71,9.09,9.50,9.87,10.25,10.59,10.87,11.21,11.61,12.11,12.71,13.37,14.10,14.75,15.32,15.62,15.75,15.62,15.32,14.88,14.50,14.12,13.85,13.71,13.72,13.87,14.25,14.75,15.27,15.97,16.63,17.12,17.64,17.73,17.63,17.62,16.09,14.98,13.96,13,12.34,12.23,12.27,12.27,12.82,13.25,14.11,14.75,15.10,15.13,15.12,15.10,16.01,16.99,18,19,19,20,20.99,20.98,20,19.87,19.65,19.02,18.57,18.24,18,17.82,17.59,17.13,16.62,16.10,15.50,14.89,14.40,14.37,14.61,14.97,14.82,14.26,13.50,12.50,11.49,10.50,9.76,9.37,9.24,9.34,9.61,10.07,10.70,11.50,12.37,13.36,14.25,15.07,15.73,16.25,16.76,17.37,18.25,19.59,19.75,20.59,19.87,19.61,18.12,16.63,15.12,13.63,12.21,10.72,9.25,8.02,7,6.12,7,7.96,7.99,-10,-9.66,-9.13,-8.50,-7.92,-7.25,-6.29,-5,-3.41,-1.87,-0.43,0.37,0.76,1.14,1.57,1.97,2.35,2.63,2.87,3,3.02,3.12,3.22,3.26,3.36,3.37,3.36,3.25,3.12,2.90,2.72,2.50,2.38,2.37,2.50,2.75,3.12,3.62,4.12,4.64,5.13,5.58,5.87,6.12,6.25,6.33,6.32,6.24,6.08,5.85,5.50,5.10,4.51,3.87,3.14,2.37,1.57,0.71,-0.14,-1,-1.62,-2.13,-2.66,-3.37,-4.16,-5.15,-6.26,-7.49,-8.68,-9.91,-11,-12,-13,-14,-14,-13,-12,-12,-10,-9.68,-8.75,-8.03,-7.61,-6.75,-6.18,-5.87,-5.67,-5.67,-5.75,-5.78,-5.75,-5.63,-5.38,-4.87,-4.05,-3.24,-2.39,-1.75,-1.15,-1,-1.13,-1.27,-2.63,-3.13,-3.38,-4.16,-5.17,-2.98,-2.23,-2.03,-1.92,-1.53,-0.76,0,0.60,1,1.25,1.46,1.58,1.73,1.90,2.20,2.46,2.64,2.82,2.90,3,3.02,3.08,3.10,3.12,3.20,3.27,3.46,3.62,3.83,4,4.25,4.52,4.87,5.21,5.37,5.22,4.76,4.12,3.47,2.76,2.14,1.61,1,0.36,-0.37,-1.42,-2.75,-4.36,-5.62,-6.63,-7.40,-8,-8.30,-8.41,-8.30,-8.02,-7.63,-7.11,-6.60,-6.05,-4.43,-2.90,-1.50,-0.37,0.61,1.25,1.70,1.95,2,2,2,2,2,3,3,3,3.08,3.87,4.11,4.12,4.87,5.13,5.83,6,6.21,6.76,7.21,7.76,8,8.26,8.58,8.84,9.09,9.35,9.62,9.99,10.37,10.75,11.12,11.40,11.72,11.98,12.25,12.62,13.10,13.62,14.24,14.85,15.37,15.75,15.95,15.89,15.72,15.37,15,14.62,14.25,14.07,13.99,14.08,14.34,14.74,15.22,16,16.82,17.64,18,18.62,17.87,17.09,16.12,15,14,13.13,12.34,12.27,12.32,12.75,13.26,14.10,14.97,15.75,16.20,16.83,16.86,16.10,16.07,17,18,19,19,20,20.99,20.98,20.97,20.07,19.59,18.75,18.02,17.50,17.13,16.97,16.77,16.48,15.86,15.24,14.61,13.97,13.38,13.25,13.58,13.97,14,13.61,12.99,12,11,10,9.38,9.20,9.15,9.40,9.87,10.52,11.37,12.37,13.71,14.65,15.64,16.20,16.87,17.62,18.07,18.62,19.33,19.95,20.61,20.61,19.98,18.97,17.75,16.35,15.08,13.65,12.25,10.73,9.24,8.01,7,6.12,6.89,7.97,8,-10,-10,-9.38,-8.80,-8.25,-7.50,-6.50,-5.13,-3.50,-1.88,-0.50,0.37,0.74,1.12,1.50,1.84,2.13,2.46,2.72,2.88,3.02,3.20,3.34,3.47,3.58,3.62,3.62,3.52,3.37,3.15,2.90,2.70,2.50,2.37,2.38,2.52,2.82,3.14,3.61,4.07,4.50,4.90,5.25,5.50,5.65,5.75,5.82,5.76,5.72,5.57,5.33,4.96,4.47,3.87,3.22,2.50,1.75,1,0.26,-0.38,-0.88,-1.63,-2.29,-3.10,-3.93,-4.93,-6.04,-7.26,-8.53,-9.85,-11,-12,-13,-14,-14,-13,-12,-11,-10,-8.73,-7.50,-6.51,-5.75,-4.99,-4.48,-4.25,-4.25,-4.49,-4.80,-5.14,-5.35,-5.25,-4.92,-4.30,-3.40,-2.50,-1.66,-1,-0.60,-0.38,-0.38,-0.74,-1.25,-1.88,-2.41,-3.13,-5.10,-3.38,-2.55,-2.42,-3.73,-2.74,-1.04,-0.18,0.40,0.87,1.12,1.35,1.50,1.64,1.87,2.12,2.34,2.52,2.72,2.84,2.89,2.98,3,3.02,3.12,3.22,3.35,3.48,3.60,3.70,3.76,3.87,4.11,4.37,4.63,4.90,4.86,4.50,3.87,3.25,2.61,1.98,1.37,0.72,-0.04,-1,-2.25,-3.53,-4.76,-5.90,-6.88,-7.63,-8.13,-8.42,-8.54,-8.50,-8.25,-7.85,-7.37,-6.79,-6.25,-4.63,-3,-1.50,-0.25,0.86,1.62,2.25,2.62,2.87,3,3,3,4,3.99,4,4,4.10,4.87,5.12,5.84,6.14,6.82,6.99,7.22,7.75,7.87,8.23,8.75,9,9.33,9.61,9.87,10.11,10.34,10.59,10.87,11.20,11.51,11.87,12.22,12.50,12.75,12.99,13.24,13.52,13.96,14.39,14.95,15.40,15.84,16.09,16.12,16.02,15.76,15.45,15.02,14.65,14.37,14.22,14.21,14.37,14.73,15.14,15.98,16.77,17.64,18,18.62,17.76,16.99,16,15.07,14.13,13.35,12.83,12.34,12.65,13.11,13.75,14.73,15.74,16.75,17.76,17.83,17.85,17.11,17.08,17,18,19,20,20.99,21,21,20.87,20.07,19.13,18.25,17.45,16.74,16.26,16.07,15.88,15.58,14.95,14.26,13.64,13,12.38,12.20,12.50,12.77,12.88,12.62,12.23,11.36,10.48,9.62,9.20,9.12,9.24,9.62,10.25,11.12,12.09,13.23,14.38,15.74,16.49,17.22,17.89,18.62,19.25,19.74,20.15,20.62,20.70,20.62,19.76,18.73,17.35,16.14,14.98,13.71,12.25,10.75,9.22,8.01,7,6.10,6.95,7,7,-10,-10,-9.54,-9,-8.38,-7.63,-6.63,-5.25,-3.63,-2,-0.63,0.25,0.73,1.11,1.48,1.76,2.07,2.36,2.62,2.87,3.08,3.25,3.46,3.62,3.77,3.87,3.88,3.86,3.72,3.50,3.22,2.89,2.64,2.48,2.37,2.39,2.57,2.82,3.12,3.50,3.90,4.27,4.62,4.87,5.02,5.13,5.23,5.25,5.23,5.12,4.95,4.62,4.15,3.62,3.02,2.39,1.75,1.12,0.50,-0.05,-0.63,-1.15,-2.12,-2.93,-3.85,-4.76,-5.88,-7.11,-8.38,-9.75,-11,-12,-13,-14,-14,-13,-12,-11,-9.25,-7.50,-5.99,-4.75,-3.67,-2.61,-2.52,-2.38,-2.53,-3,-3.79,-4.63,-5.14,-5.10,-4.53,-3.75,-2.77,-1.77,-1.04,-0.50,-0.14,0,0,-0.13,-0.49,-0.88,-1.25,-1.75,-1.88,-2.11,-1.88,-1.90,-1.91,-1.63,-0.85,-0.04,0.50,0.89,1.20,1.37,1.52,1.74,1.96,2.15,2.37,2.59,2.72,2.83,2.87,2.96,2.99,3.01,3.12,3.25,3.37,3.50,3.61,3.61,3.52,3.51,3.62,3.84,4.08,4.24,4.25,4,3.50,2.96,2.33,1.65,1,0.25,-0.43,-1.77,-3.25,-4.30,-5.39,-6.38,-7.18,-7.85,-8.25,-8.50,-8.62,-8.52,-8.30,-8,-7.53,-6.89,-6.13,-4.62,-2.90,-1.38,0.07,1.22,2.12,2.87,3.50,3.85,4,4,4,5,4.98,4.99,5,5.11,5.86,6.13,7,7.76,7.98,8.22,8.75,8.85,9,9.24,9.75,10,10.37,10.70,10.95,11.14,11.37,11.58,11.75,12,12.27,12.62,12.96,13.25,13.50,13.71,13.87,14.08,14.34,14.64,15.09,15.50,15.87,16.15,16.33,16.27,16.11,15.76,15.37,14.99,14.62,14.37,14.26,14.37,14.65,15.12,15.86,16.62,17.13,17.63,17.64,17.62,16.83,16.10,15.25,14.36,13.73,13.13,12.88,12.95,13.33,14,14.96,15.95,16.89,17.76,18.13,18.10,17.87,17.89,17.97,18,19,20,20.99,21.98,21.97,20.77,19.70,18.72,17.73,16.85,16.08,15.50,15.14,14.87,14.47,13.88,13.26,12.73,12.14,11.62,11.38,11.62,11.86,11.89,11.71,11.25,10.62,9.99,9.33,9.09,9.12,9.37,9.96,10.74,11.72,12.75,13.89,15.12,16.39,17.25,17.97,18.75,19.57,20.46,20.64,20.95,21.12,21,20.34,19.75,18.63,17.32,16.08,14.95,13.73,12.24,10.75,9.15,8.01,7,6.07,6.98,7,7,-10,-10,-9.66,-9.12,-8.42,-7.66,-6.66,-5.38,-3.78,-2.17,-0.75,0.21,0.70,1.09,1.47,1.75,2.01,2.33,2.62,2.87,3.10,3.33,3.52,3.76,4,4.12,4.21,4.15,4.07,3.85,3.52,3.22,2.87,2.62,2.45,2.37,2.37,2.51,2.75,3.09,3.38,3.73,4,4.23,4.37,4.50,4.60,4.62,4.62,4.58,4.38,4.12,3.74,3.25,2.76,2.25,1.75,1.22,0.71,0.13,-0.42,-1.13,-1.99,-2.88,-3.68,-4.62,-5.64,-6.86,-8.17,-9.63,-11,-12,-13,-13,-13,-12,-11,-10,-8.24,-6.26,-4.61,-3.13,-2.10,-0.88,-0.42,-0.25,-0.25,-1.43,-2.17,-4.55,-5.88,-5.13,-4.15,-3.05,-2.01,-1.25,-0.55,-0.13,0.12,0.26,0.34,0.25,0.10,-0.13,-0.28,-0.36,-0.50,-0.64,-0.78,-0.78,-0.74,-0.50,-0.11,0.39,0.87,1.13,1.37,1.52,1.72,1.88,2.12,2.36,2.52,2.70,2.77,2.87,2.89,2.96,3,3.02,3.12,3.26,3.46,3.57,3.62,3.50,3.37,3.25,3.25,3.37,3.50,3.62,3.65,3.50,3.09,2.60,2,1.37,0.62,-0.14,-1.17,-2.50,-4.13,-5.13,-6.04,-6.89,-7.61,-8.12,-8.42,-8.63,-8.67,-8.62,-8.39,-8.13,-7.63,-7.01,-6.15,-4.54,-2.78,-1.13,0.37,1.62,2.73,3.60,4.34,4.75,5,5,5,5,5.96,5.88,5.87,6.12,6.86,7.83,8.21,8.86,9.23,9.75,9.85,10,10.12,10.25,10.87,11.22,11.57,11.83,12.07,12.26,12.48,12.62,12.75,12.88,13.12,13.37,13.70,14,14.25,14.39,14.50,14.62,14.75,14.98,15.25,15.62,15.97,16.25,16.40,16.46,16.27,16,15.61,15.13,14.75,14.39,14.25,14.33,14.58,15,15.62,16.13,16.63,16.75,16.87,16.75,16.62,16.12,15.62,14.99,14.25,13.35,13.25,13.25,13.33,14.12,15,15.99,16.95,17.75,18.82,18.85,18.10,17.98,18,19,20,20,20.98,21,20.96,20.20,19.27,18.33,17.34,16.37,15.50,14.86,14.37,13.88,13.38,12.87,12.37,11.87,11.50,11.21,11.10,11.14,11.20,11.11,10.86,10.52,10.10,9.65,9.25,9.14,9.34,9.73,10.37,11.24,12.25,13.33,14.46,15.59,16.75,17.62,18.47,19.25,20.23,21.26,21.37,21.49,21.61,21.65,20.70,19.76,18.70,17.26,16.02,14.95,13.75,12.22,10.82,9.13,8.12,7,6,6.99,7,7,-10,-10,-9.75,-9.13,-8.50,-7.75,-6.78,-5.55,-4.05,-2.50,-1.02,0,0.62,1.02,1.47,1.75,2,2.32,2.62,2.87,3.11,3.36,3.62,3.87,4.14,4.37,4.49,4.50,4.39,4.23,3.89,3.57,3.15,2.84,2.52,2.37,2.32,2.37,2.50,2.72,2.97,3.21,3.39,3.61,3.75,3.87,3.97,4,4,3.96,3.82,3.59,3.25,2.87,2.49,2.08,1.62,1.24,0.77,0.33,-0.25,-0.98,-1.85,-2.88,-3.67,-4.54,-5.50,-6.62,-7.88,-9.26,-10,-11,-12,-13,-13,-12,-11,-9.36,-7.10,-4.93,-3.15,-1.78,-0.76,0.12,0.48,0.70,0.37,0.37,0.25,-1.63,-2.18,-2.88,-2.63,-1.93,-1.27,-0.67,-0.23,0.12,0.37,0.50,0.57,0.51,0.48,0.37,0.32,0.25,0.15,0.12,0.12,0.13,0.23,0.37,0.62,0.97,1.26,1.49,1.62,1.75,1.87,2.08,2.26,2.50,2.73,2.86,2.89,2.95,2.96,2.98,3,3.02,3.12,3.26,3.50,3.62,3.57,3.37,3.22,3.09,3,3.01,3.10,3.12,3.12,2.96,2.63,2.24,1.73,1.08,0.35,-0.54,-1.63,-3,-4.63,-5.76,-6.75,-7.50,-8.04,-8.42,-8.66,-8.79,-8.80,-8.73,-8.49,-8.13,-7.73,-7.25,-6.50,-4.75,-2.67,-0.78,0.75,2.11,3.25,4.23,5,5.61,6,6,6,6,6.07,6.10,6.12,6.85,7.83,8.76,9.75,10.08,10.75,10.86,11,11.12,11.25,11.72,12.11,12.72,12.75,12.99,13.23,13.46,13.62,13.75,13.83,13.87,14,14.15,14.46,14.73,14.97,15.12,15.14,15.20,15.22,15.27,15.49,15.75,16,16.25,16.46,16.48,16.35,16.02,15.62,15.13,14.70,14.33,14.11,14.11,14.36,14.75,15.14,15.62,15.64,15.71,15.82,15.90,15.98,16.09,16.01,15.62,14.87,14.13,13.72,13.34,13.72,14.25,15,15.99,16.95,17.75,18.14,18.10,17.87,17.89,18,19,20,20,20.98,20.97,20.01,19.75,19,18.07,17.08,16.08,15.20,14.38,13.74,13.10,12.50,11.98,11.62,11.32,11.14,11.07,11,10.97,10.86,10.62,10.34,10.13,9.83,9.51,9.36,9.46,9.72,10.21,10.88,11.76,12.75,13.75,14.83,15.86,16.88,17.85,18.72,19.52,20.37,21.01,21.50,21.75,21.82,21.61,20.87,19.87,18.72,17.25,16.07,14.97,13.76,12.15,10.87,9.87,8.09,7.02,6,7,7,7,-10,-10,-9.87,-9.25,-8.55,-7.88,-7,-5.88,-4.38,-2.78,-1.30,-0.13,0.60,1,1.45,1.75,1.99,2.26,2.62,2.87,3.11,3.37,3.63,3.98,4.26,4.51,4.72,4.76,4.75,4.60,4.32,3.90,3.50,3.08,2.72,2.46,2.27,2.25,2.33,2.45,2.61,2.75,2.90,3.08,3.21,3.33,3.38,3.48,3.48,3.38,3.25,3.09,2.83,2.50,2.15,1.85,1.50,1.21,0.87,0.47,-0.05,-0.74,-1.54,-2.50,-3.77,-4.25,-5.13,-6.13,-7.36,-8.73,-10,-11,-12,-13,-12,-11,-10,-8.35,-6.05,-3.89,-2.11,-0.67,0.50,0.75,1,1.12,1.12,1.12,0.75,0.12,-0.63,-1.03,-1.18,-0.93,-0.53,-0.15,0.13,0.38,0.58,0.65,0.73,0.74,0.72,0.65,0.62,0.61,0.59,0.61,0.62,0.72,0.77,0.90,1.12,1.38,1.70,1.86,1.88,1.97,2.01,2.20,2.38,2.64,2.90,3.07,3.07,3,3,2.99,3,3,3.11,3.25,3.37,3.46,3.37,3.25,3.09,2.90,2.83,2.75,2.72,2.70,2.62,2.50,2.25,1.95,1.49,0.87,0.07,-0.75,-1.88,-3.25,-4.63,-6.26,-7.35,-7.98,-8.38,-8.65,-8.80,-8.88,-8.85,-8.64,-8.38,-8,-7.63,-7.38,-7.14,-5,-2.50,-0.40,1.21,2.57,3.74,4.75,5.59,6.13,7,7,6.99,6.96,6.88,6.11,6.12,7.12,8.12,9.22,10.75,11.14,11.75,12.14,12.25,12.25,12.71,13,13.26,13.73,13.90,14.12,14.37,14.63,14.85,14.95,14.96,14.90,14.95,15.02,15.24,15.47,15.63,15.75,15.75,15.71,15.62,15.62,15.70,15.85,16.02,16.24,16.36,16.35,16.15,15.87,15.45,14.95,14.46,14.01,13.75,13.71,13.87,14.62,14.62,14.35,14.33,14.35,14.62,14.87,15.22,15.63,16.62,16.62,15.36,14.62,14.12,13.87,13.89,14.26,15.01,15.99,16.96,17.75,17.96,17.85,17.11,17.08,17,18,19,20,20.98,20,19.96,19.64,18.82,17.90,16.99,16.01,15.09,14.20,13.32,12.50,11.87,11.39,11.21,11.10,11.07,11.08,11.10,11.01,10.87,10.62,10.37,10.22,10,9.77,9.76,10,10.33,10.84,11.49,12.34,13.24,14.14,15.11,16.01,17,17.95,18.83,19.62,20.36,21,21.50,21.85,21.87,21.61,20.97,20,18.76,17.23,16.13,15,13.83,12.12,11.11,9.88,8.02,7,7,7,7,7,-10,-10,-9.89,-9.30,-8.66,-8,-7.15,-6.13,-4.65,-3.04,-1.51,-0.25,0.57,1,1.32,1.62,1.88,2.25,2.61,2.87,3.11,3.37,3.70,4,4.37,4.65,4.87,5.01,5.02,4.89,4.64,4.26,3.83,3.35,2.88,2.57,2.34,2.23,2.22,2.25,2.36,2.46,2.52,2.62,2.75,2.86,2.97,3,3,2.95,2.82,2.62,2.37,2.12,1.87,1.62,1.37,1.12,0.87,0.59,0.13,-0.40,-1.13,-1.98,-2.78,-3.75,-4.42,-5.40,-6.62,-7.99,-9.48,-10,-12,-12,-12,-11,-9.50,-7.38,-5.13,-3.03,-1.13,0.45,0.87,1.10,1.25,1.45,1.62,1.75,1.62,1.12,0.59,0.11,-0.13,-0.12,0.10,0.32,0.50,0.62,0.74,0.77,0.85,0.86,0.86,0.85,0.84,0.82,0.82,0.85,0.87,0.99,1.09,1.22,1.38,1.64,1.97,2.12,2.12,2.11,2.12,2.25,2.45,2.65,2.88,3.01,3.07,3.01,3,3,3,3.02,3.11,3.15,3.25,3.26,3.24,3.12,2.97,2.76,2.62,2.48,2.37,2.25,2.20,2.08,1.87,1.64,1.33,0.85,0.25,-0.38,-1.38,-2.87,-4.88,-6.38,-7.75,-8.38,-8.74,-8.88,-8.99,-8.98,-8.87,-8.63,-8.16,-7.63,-7.13,-6.75,-8.15,-4.38,-2,0,1.62,2.99,4.20,5.25,6.10,6.99,7,7,7,7.07,6.87,6.12,6.85,7.14,8.21,9.75,10.85,11.85,12.73,13.72,13.72,13.75,14,14.27,14.70,14.85,15,15.25,15.52,15.85,16.07,16.12,16.11,16,15.89,15.89,16,16.15,16.27,16.34,16.25,16.12,15.98,15.87,15.83,15.87,15.98,16.08,16.11,16,15.83,15.48,15,14.50,14,13.58,13.25,13.11,13.12,13.22,13.25,13.12,13.08,13.13,13.35,13.72,14.24,14.97,15.62,15.75,15.62,14.99,14.36,14.12,14.08,14.32,15.07,16,16.96,17.76,17.83,17.86,16.87,16.07,16.99,18,19,19.99,19.98,19.97,19.01,18.95,18.49,17.82,16.90,16.02,15.12,14.12,13.12,12.21,11.50,11.21,11.10,11.10,11.21,11.32,11.39,11.40,11.36,11.20,10.96,10.70,10.46,10.37,10.50,10.75,11.12,11.60,12.21,12.97,13.75,14.59,15.37,16.24,17.09,18,18.87,19.64,20.37,21.01,21.60,21.98,22.08,21.83,21.20,20.26,19.10,17.82,16.14,15.12,14.11,12.87,11.89,10.01,8.99,7,7,7,7,7,-10,-10,-10,-9.42,-8.76,-8.13,-7.37,-6.37,-4.93,-3.25,-1.50,-0.13,0.70,1,1.15,1.40,1.77,2.25,2.58,2.85,3.09,3.37,3.73,4.10,4.47,4.75,5,5.20,5.25,5.14,4.96,4.60,4.12,3.62,3.12,2.72,2.39,2.24,2.13,2.12,2.15,2.23,2.25,2.35,2.39,2.50,2.61,2.62,2.62,2.51,2.39,2.25,2.01,1.82,1.61,1.38,1.25,1.11,0.90,0.71,0.37,-0.04,-0.61,-1.25,-1.93,-2.67,-3.50,-4.49,-5.65,-7.10,-8.64,-10,-12,-13,-12,-10,-8.63,-6.43,-4.25,-2.15,-0.42,0.49,0.88,1.12,1.37,1.58,1.85,2.75,2.59,1.75,1.37,0.87,0.62,0.59,0.62,0.73,0.76,0.85,0.87,0.87,0.89,0.90,0.90,0.90,0.89,0.89,0.89,0.96,1,1.08,1.13,1.25,1.47,1.73,2,2.21,2.23,2.12,2.14,2.25,2.46,2.64,2.87,3,3.07,3.07,3.07,3.08,3.11,3.12,3.14,3.21,3.21,3.14,3.11,2.99,2.85,2.62,2.39,2.21,2,1.87,1.75,1.64,1.57,1.37,1.14,0.89,0.50,0.12,-0.01,-2.26,-4.50,-6.28,-7.67,-8.50,-8.88,-9,-9.02,-8.98,-8.75,-8.36,-7.68,-6.88,-6.03,-5.40,-4.50,-3,-1.13,0.50,2.09,3.37,4.59,5.70,6.85,7,7,7,7.97,7.08,6.87,6.87,7,7.15,8.22,9.85,11.75,12.12,13.14,14.72,14.73,14.96,15.25,15.70,15.84,15.96,16,16.25,16.61,16.97,17.22,17.26,17.20,17,16.85,16.75,16.75,16.84,16.86,16.76,16.62,16.37,16.13,15.96,15.84,15.75,15.75,15.75,15.70,15.50,15.25,14.87,14.37,13.87,13.37,12.95,12.60,12.37,12.23,12.08,12.07,12.01,12.02,12.09,12.21,12.36,13.14,13.98,14.62,15.12,15.61,15.24,14.87,14.36,14.25,14.32,15.14,16.01,16.97,17.75,17.84,16.87,16.10,16,16,17,18,19,19.98,19,18.96,18.36,18.01,17.48,16.70,16,15.24,14.12,13,11.98,11.39,11.10,11.21,11.39,11.75,12.10,12.32,12.38,12.36,12.12,11.84,11.50,11.23,11.22,11.37,11.70,12.02,12.47,12.99,13.62,14.25,14.97,15.70,16.48,17.25,18.12,18.99,19.75,20.50,21.15,21.76,22.25,22.45,22.25,21.62,20.73,19.75,18.12,17.11,15.87,14.89,13.02,12,11,9,8,7,7,7,7,-11,-10,-10,-9.63,-8.80,-8,-7.13,-6.02,-4.68,-3.12,-1.42,-0.12,0.70,0.97,1,1.25,1.60,2.07,2.47,2.75,3.01,3.37,3.75,4.12,4.50,4.83,5.07,5.25,5.34,5.32,5.12,4.84,4.37,3.87,3.36,2.87,2.51,2.27,2.13,2.11,2.10,2.10,2.12,2.12,2.21,2.26,2.34,2.34,2.27,2.23,2.10,1.89,1.74,1.52,1.37,1.25,1.13,1.08,0.98,0.84,0.62,0.34,-0.04,-0.52,-1.10,-1.74,-2.49,-3.38,-4.61,-6.05,-7.78,-9.49,-10,-12,-10,-9.38,-7.88,-6.18,-4.27,-2.25,-0.50,0.37,0.87,1.12,1.25,1.47,1.75,2.08,2.24,2.58,1.75,1.38,1.20,1.11,1.10,1.12,1.12,1.10,1.02,1,0.99,0.99,0.99,0.99,0.98,0.97,0.97,0.99,1,1.07,1.12,1.21,1.37,1.61,1.87,2.07,2.12,2.12,2.13,2.25,2.47,2.71,2.89,3.08,3.12,3.15,3.20,3.25,3.32,3.36,3.37,3.34,3.25,3.12,3,2.87,2.73,2.50,2.22,1.89,1.64,1.49,1.34,1.25,1.14,1.09,1,0.84,0.61,0.37,-0.17,-2.25,-4.02,-6.25,-7.63,-8.43,-8.88,-9.05,-9.04,-8.88,-8.43,-7.76,-6.87,-5.75,-4.61,-3.50,-2.38,-1.30,-0.13,1.20,2.50,3.82,5,6,6.87,7,7,7,7.96,7.09,7,7,7.14,7.77,8.75,9.97,11.11,12.12,13.25,14.71,15.23,15.73,16.65,16.65,16.65,16.73,16.85,17.12,17.50,17.87,18.21,18.27,18.12,17.87,17.62,17.50,17.39,17.37,17.26,17.11,16.84,16.50,16.13,15.87,15.63,15.50,15.38,15.26,15.12,14.87,14.50,14.10,13.62,13.12,12.62,12.23,11.87,11.59,11.35,11.08,11.02,11.07,11.13,11.26,11.36,11.37,12.23,12.99,13.64,14.26,14.75,15.61,15.62,14.74,14.35,14.83,15.32,16.22,16.90,17.76,16.85,16.11,15.08,15.01,16,17,18,18.99,19,18.96,18.01,17.95,17.49,16.77,16.12,15.58,14.88,13.76,12.77,11.98,11.62,11.39,11.62,12.10,12.64,13.13,13.52,13.63,13.61,13.26,12.87,12.48,12.15,12.15,12.37,12.64,13.01,13.45,13.87,14.34,14.84,15.37,16.07,16.82,17.57,18.36,19.13,19.96,20.75,21.48,22.12,22.64,22.98,22.98,22.36,21.25,20.02,18.87,17.89,16.90,15.01,14,13,13,10,9,8,8,8,7,-11,-11,-10,-9.88,-8.92,-8,-6.90,-5.76,-4.42,-2.89,-1.38,-0.04,0.71,0.88,1,1.12,1.33,1.76,2.25,2.62,2.97,3.36,3.75,4.21,4.58,4.84,5.02,5.22,5.34,5.35,5.24,4.99,4.60,4.12,3.60,3.11,2.71,2.37,2.21,2.10,2.02,2,2.01,2.02,2.10,2.12,2.12,2.12,2.07,1.97,1.83,1.63,1.49,1.34,1.22,1.12,1.10,1.08,1.02,1,0.87,0.71,0.45,0.11,-0.36,-0.88,-1.50,-2.29,-3.52,-5.14,-6.92,-8.73,-10,-10,-9.75,-8.43,-7.38,-6.17,-4.50,-2.53,-0.64,0.25,0.75,1,1.12,1.25,1.13,1.96,1.99,2.08,2,1.73,1.58,1.50,1.50,1.51,1.50,1.46,1.34,1.23,1.13,1.12,1.12,1.09,1.02,1,1,0.99,1,1,1.02,1.10,1.22,1.37,1.62,1.85,1.95,2,2.11,2.25,2.50,2.77,3.07,3.25,3.37,3.45,3.49,3.58,3.62,3.62,3.62,3.50,3.37,3.14,2.99,2.76,2.60,2.34,1.98,1.62,1.32,1.01,0.86,0.72,0.62,0.62,0.62,0.57,0.12,-0.54,-1.38,-2.93,-4.78,-6.52,-7.78,-8.60,-9.02,-9.24,-9.15,-8.85,-8.15,-7.17,-5.92,-4.50,-3.01,-1.27,-0.63,-0.04,0.75,1.75,2.87,3.98,5.12,6.85,6.87,7,7,7,7.96,7.09,7,7,7.14,8,8.97,9.99,11,12,13.24,14.71,15.25,16.65,16.72,16.90,16.96,17.13,17.32,17.62,18,18.45,18.82,18.97,18.82,18.49,18.23,18,17.87,17.75,17.57,17.25,16.85,16.38,15.98,15.61,15.32,15.09,14.87,14.63,14.37,14.07,13.64,13.24,12.75,12.33,11.87,11.48,11.12,10.82,10.57,10.25,10.26,10.27,10.33,10.97,11.12,11.25,11.37,12.15,12.82,13.37,14.09,14.62,14.87,14.83,14.84,15.11,15.70,16.73,16.83,16.77,16.14,15.12,14.89,14.97,15,17,18,18.99,18.98,18,17.96,17.64,16.82,16.01,15.36,14.75,14.12,13.27,12.50,12.09,12.10,12.10,12.39,13.01,13.64,14.34,14.75,15,14.87,14.45,13.95,13.48,13.14,13.12,13.33,13.63,14.08,14.47,14.83,15.12,15.37,15.82,16.40,17.15,18,18.63,19.40,20.35,21.12,21.87,22.60,23.25,23.70,23.59,22.82,21.71,20.62,19.12,18,16.99,16,15,14,13,11,9,9,8,8,8,-12,-11,-11,-10,-9.16,-8.13,-6.92,-5.75,-4.38,-2.88,-1.30,-0.02,0.72,0.86,0.96,0.99,1.12,1.46,1.96,2.37,2.83,3.26,3.77,4.25,4.61,4.76,4.98,5.12,5.25,5.26,5.24,5.02,4.74,4.27,3.82,3.33,2.87,2.51,2.25,2.12,2.01,2,2,2,2,2,2,1.96,1.87,1.75,1.60,1.45,1.27,1.15,1.11,1.08,1.09,1.12,1.13,1.15,1.12,1.07,0.87,0.62,0.26,-0.17,-0.80,-1.63,-2.87,-4.39,-6.13,-7.88,-9.68,-10,-9,-7.67,-7.13,-6.13,-4.79,-3,-1.38,-0.16,0.50,0.87,1,1.08,1,1,1.97,1.87,1.98,1.87,1.77,1.77,1.87,1.98,2,1.90,1.75,1.62,1.50,1.49,1.45,1.37,1.25,1.12,1.07,1,1,1,1,1,1.09,1.22,1.37,1.61,1.75,1.87,2.02,2.25,2.61,2.96,3.26,3.58,3.75,3.87,3.95,4,4,4,3.87,3.70,3.45,3.13,2.87,2.62,2.37,2.07,1.70,1.26,0.87,0.52,0.13,-0.14,-0.15,-0.15,-0.27,-0.73,-1.15,-1.88,-2.89,-4.28,-5.88,-7.28,-8.27,-8.89,-9.35,-9.53,-9.50,-9,-8.03,-6.66,-5.04,-3.30,-1.05,-0.03,0.37,0.75,1.35,2.10,3,3.87,4.75,5.87,5.98,6,7,7,7,7.09,6.99,7,7.14,8,8.97,9.97,10.96,11.95,13.07,14,14.95,15.72,16.62,16.70,16.87,17.12,17.57,17.70,18.07,18.50,18.89,19.12,19.01,18.75,18.50,18.27,18.12,17.95,17.62,17.22,16.71,16.12,15.62,15.15,14.82,14.50,14.22,13.88,13.58,13.21,12.75,12.36,11.89,11.50,11.12,10.75,10.40,10.12,9.75,9.85,10.02,10.26,10.77,11.12,11.37,11.37,11.37,11.39,12.21,12.83,13.37,13.96,14.38,14.75,15,15.25,15.65,16.12,16.75,16.76,15.83,15,14.07,14,15,16,18,18,18.98,18,17.96,16.87,16.07,15.14,14.50,13.97,13.50,12.97,12.62,12.62,12.87,13.12,13.50,14,14.57,15.12,15.62,15.87,15.86,15.48,14.89,14.39,14.08,14,14.15,14.58,15.09,15.59,15.86,15.88,15.97,16.21,16.75,17.50,18.40,19.22,20.11,20.87,21.63,22.40,23.11,23.87,24.22,24.12,23.11,21.99,20.63,19.22,18,17,16,15,14,12,11,10,9,9,9,9,-12,-11,-11,-10,-9.50,-8.38,-7.17,-5.88,-4.51,-3.02,-1.40,-0.13,0.62,0.75,0.75,0.84,0.87,1.14,1.62,2.12,2.59,3.13,3.72,4.22,4.52,4.65,4.84,4.98,5.11,5.15,5.14,5.02,4.82,4.46,4,3.52,3.09,2.70,2.37,2.15,2.07,2,2,1.99,1.97,1.95,1.87,1.82,1.71,1.57,1.39,1.25,1.14,1.10,1.02,1.02,1.11,1.20,1.27,1.37,1.40,1.37,1.26,1.10,0.77,0.37,-0.25,-1.14,-2.37,-3.80,-5.37,-7.15,-8.67,-8.65,-7.65,-7.05,-6.50,-6.62,-5.04,-3.29,-1.63,-0.25,0.49,0.84,0.97,1,1,1,1,2,2,1.89,1.87,1.95,2.12,2.35,2.48,2.46,2.36,2.25,2.15,2.12,2.07,1.87,1.64,1.45,1.25,1.12,1.02,1,0.99,0.99,1,1.09,1.21,1.37,1.58,1.75,2,2.27,2.70,3.12,3.51,3.89,4.21,4.37,4.47,4.49,4.39,4.25,4,3.65,3.34,2.99,2.64,2.36,2,1.63,1.25,0.87,0.39,-0.13,-0.87,-1.39,-1.75,-1.93,-2.11,-2.25,-2.75,-3.48,-4.50,-5.77,-7.14,-8.27,-9,-9.38,-9.73,-10,-10,-9.63,-8.24,-6.37,-4.18,-2.13,-0.51,0.37,0.75,1.12,1.50,2.10,2.75,3.33,3.98,4,4,5,6,6,6.96,6.88,6.87,6.87,7.14,7.87,8.75,9.75,10.73,11.72,12.71,13.65,14.23,15,15.72,16.25,16.58,16.87,17.14,17.37,17.72,18.12,18.51,18.82,18.77,18.62,18.40,18.25,18.11,17.87,17.50,17,16.38,15.75,15.14,14.62,14.21,13.82,13.46,13.10,12.72,12.32,11.87,11.50,11.12,10.75,10.47,10.14,9.87,9.60,9.24,9.25,10.25,10.87,11.34,11.87,12.09,12,11.75,11.45,12.07,12.45,13,13.45,14.21,14.77,15.15,15.37,15.34,15.71,15.85,15.75,15.13,14.87,14.07,14,15,16,17,17.99,18,17.97,17.01,16.25,15.37,14.61,14.08,13.74,13.50,13.27,13.21,13.39,13.75,14.23,14.57,14.87,15.25,15.62,16,16.37,16.50,16.33,15.75,15.22,14.83,14.70,14.87,15.35,16,16.62,16.85,16.70,16.48,16.50,16.95,17.62,18.52,19.52,20.63,21.52,22.33,23,23.63,24.33,24.63,24.22,23.22,21.99,20.75,19.26,18.09,17,16,15,14,12,11,10,9,10,10,10,-12,-11,-11,-10,-9.91,-8.80,-7.62,-6.26,-4.91,-3.50,-2,-0.02,0.37,0.25,0,0.13,0.48,0.71,1.13,1.64,2.23,2.87,3.48,4,4.35,4.50,4.62,4.75,4.88,5,5.07,5,4.85,4.57,4.15,3.75,3.25,2.86,2.50,2.25,2.11,2,1.99,1.97,1.89,1.87,1.76,1.65,1.51,1.38,1.25,1.13,1.10,1.02,1.01,1.08,1.13,1.27,1.48,1.62,1.72,1.73,1.63,1.49,1.21,0.75,0.14,-0.68,-1.88,-3.38,-5.10,-6.99,-8.14,-8.38,-7.53,-6.79,-6.50,-6.03,-5.25,-3.50,-1.66,-0.25,0.57,0.86,0.96,0.98,0.99,0.99,1,1,2,1.64,1.75,1.95,2.23,2.52,2.82,2.87,2.97,3,3.09,3.08,2.95,2.71,2.36,2,1.65,1.40,1.24,1.10,1,0.99,0.99,1,1.08,1.21,1.37,1.61,1.87,2.25,2.73,3.25,3.75,4.25,4.49,4.71,4.84,4.82,4.62,4.26,3.87,3.48,3.07,2.62,2.25,1.87,1.50,1.15,0.71,0.24,-0.13,-1.25,-2.17,-3.01,-3.60,-3.86,-3.79,-3.89,-4.30,-5,-5.98,-7.14,-8.30,-9.16,-9.63,-9.79,-9.93,-10,-9.98,-9.35,-8.11,-6.38,-4.14,-2.02,-0.50,0.34,0.75,1.12,1.45,1.75,2.12,2.38,2.62,3,3,4,4,5,5.96,5.88,6.12,6.85,7.09,7.76,8.23,9.24,10.25,11.14,12.07,12.77,13.35,14.26,15.02,15.65,16.14,16.50,16.72,16.87,17.12,17.48,17.84,18.11,18.15,18.12,18,17.89,17.76,17.57,17.15,16.62,16,15.27,14.62,14,13.50,13.07,12.62,12.25,11.85,11.45,11.07,10.71,10.37,10.12,9.88,9.72,9.50,9.21,9.23,10.14,10.98,11.65,12.25,12.75,13.59,12.75,12.37,12.27,12.36,12.47,13.07,13.46,14.37,15.02,15.60,15.61,15.36,15.25,15.15,14.87,14.12,14,13.89,14,15,16,17,17.99,18,17.97,17.01,16.21,15.37,14.57,14.26,14.15,14.08,13.98,14,14.22,14.62,15.12,15.46,15.61,15.75,15.97,16.26,16.65,17.01,16.95,16.39,15.77,15.37,15.21,15.37,15.90,16.65,17.37,17.57,17.25,16.87,16.75,17.02,17.65,18.52,19.75,20.99,21.87,22.75,23.52,24.22,24.63,24.63,24.11,23.11,21.99,20.87,19.75,18.84,18,16,15,14,13,12,10,10,10,11,11,-11,-11,-11,-11,-10,-9.38,-8.02,-6.80,-5.61,-4.38,-2.54,-2.53,-2.11,-1.76,-1.39,-1,-0.50,0,0.50,1.12,1.75,2.47,3.12,3.61,3.97,4.20,4.35,4.50,4.65,4.84,4.89,4.90,4.84,4.62,4.32,3.88,3.46,3,2.62,2.33,2.12,2.01,1.98,1.90,1.87,1.75,1.64,1.51,1.37,1.25,1.13,1.10,1.08,1.10,1.12,1.13,1.25,1.47,1.73,1.88,2,2.02,1.99,1.82,1.50,1.07,0.37,-0.51,-1.75,-3.26,-5.13,-7.11,-8.39,-8.60,-7.64,-6.75,-6.38,-5.93,-5.15,-3.51,-1.66,-0.15,0.62,0.87,0.96,0.98,0.98,0.99,1,1,1,1.37,1.51,1.86,2.24,2.62,2.90,3.21,3.50,3.77,4,4.09,3.95,3.62,3.24,2.77,2.37,1.98,1.60,1.32,1.12,1,0.99,0.99,1,1.08,1.21,1.38,1.72,2.10,2.61,3.14,3.75,4.22,4.61,4.87,5,5.09,4.71,4.14,3.62,3.12,2.62,2.12,1.64,1.25,0.87,0.48,-0.11,-0.90,-1.80,-2.75,-3.75,-4.77,-5.88,-5.54,-5.36,-5.39,-5.73,-6.30,-7.16,-8.18,-9.13,-9.73,-9.91,-9.98,-10,-10,-9.79,-9.15,-7.93,-6.50,-4.13,-2.13,-0.55,0.25,0.75,1,1.25,1.48,1.62,1.71,1.25,1,2,2,3,4,4.01,4.88,5.12,5.87,6.83,7.21,8.09,8.88,9.77,10.71,11.32,12.22,12.99,13.75,14.50,15.22,15.76,16.12,16.25,16.25,16.39,16.62,16.90,17.14,17.32,17.34,17.33,17.25,17.20,17,16.62,16.11,15.45,14.73,14,13.36,12.75,12.25,11.83,11.38,11,10.62,10.27,10,9.75,9.62,9.50,9.38,9.38,9.22,10.20,11.01,11.96,12.74,13.36,13.82,13.84,13.45,13.15,12.98,12.95,13.12,13.48,14.24,14.87,15.52,15.61,15.61,15.23,14.95,14.74,14.23,13.84,13.12,13.08,14.01,15,15.99,17,18,18.98,18,17.96,17.01,16.13,15.50,15.13,14.87,14.75,14.65,14.72,14.88,15.25,15.75,16.12,16.12,16.10,16.13,16.45,16.83,17.22,17.15,16.74,16.12,15.72,15.50,15.73,16.36,17.14,17.87,18.07,17.74,17.25,17.08,17.25,17.62,18.52,19.75,20.99,22,23,23.87,24.63,25,25,24.33,23.40,22.22,21.22,20.22,19.23,18,17,16,15,14,12,11,10,10,11,11,-11,-12,-11,-11,-10,-9.49,-8.41,-7.43,-6.50,-5.63,-4.93,-4.50,-4.18,-3.80,-3.29,-2.64,-1.79,-1.05,-0.38,0.46,1.25,1.99,2.62,3.10,3.50,3.75,4,4.22,4.39,4.60,4.74,4.82,4.75,4.62,4.37,4,3.60,3.12,2.73,2.37,2.14,2.01,1.96,1.87,1.75,1.64,1.51,1.37,1.25,1.13,1.10,1.09,1.12,1.24,1.35,1.45,1.39,1.77,2.07,2.25,2.36,2.37,2.25,2.09,1.75,1.25,0.57,-0.38,-1.63,-3.23,-5.13,-7.25,-8.98,-9.04,-7.63,-6.88,-6.42,-5.92,-5.13,-3.50,-1.75,-0.17,0.62,0.87,0.97,0.98,0.98,0.99,1,1,1,1.01,1.37,1.75,2.22,2.62,2.98,3.37,3.86,4.38,4.86,5,4.87,4.62,4.23,3.75,3.25,2.74,2.20,1.71,1.34,1.12,1,0.99,0.99,1,1.08,1.22,1.46,1.85,2.33,2.87,3.46,4,4.38,4.64,4.72,4.50,4.12,3.58,2.98,2.38,1.86,1.26,0.74,0.25,-0.13,-0.42,-1.12,-2.50,-3.52,-4.43,-5.29,-6.36,-6.63,-6.77,-6.52,-6.62,-6.80,-7.30,-8.01,-8.79,-9.43,-9.79,-9.89,-9.89,-9.91,-9.90,-9.68,-9,-7.75,-6.01,-3.91,-2.01,-0.54,0.25,0.57,0.75,0.96,1.12,1.24,1.24,1.12,1.13,1.20,1,2,3,3.01,3.88,4.11,5.12,6,6.77,7.75,8.75,9.25,10.13,11,11.76,12.58,13.36,14.11,14.82,15.39,15.75,15.75,15.61,15.49,15.74,15.95,16.12,16.25,16.37,16.37,16.37,16.36,16.22,15.87,15.37,14.74,14,13.27,12.62,12,11.48,11,10.62,10.25,9.95,9.64,9.45,9.25,9.23,9.25,9.37,9.21,10.22,11.08,12.02,13,13.87,14.62,15,14.89,14.40,14,13.72,13.48,13.83,14.45,15.12,15.62,15.75,15.63,15.36,15,14.64,14.21,13.76,13.14,13.12,13.09,13.95,14.96,15.98,16.99,17,17.99,18.98,18.97,17.96,16.87,16.59,15.99,15.64,15.40,15.26,15.32,15.50,15.84,16.24,16.50,16.51,16.38,16.33,16.51,16.87,17.20,17.14,16.76,16.27,15.90,15.75,16,16.65,17.50,18.21,18.36,18.07,17.62,17.50,17.72,18.11,19,20,20.99,22,23,24,24.87,25.33,25.33,24.75,23.87,22.63,21.52,20.63,19.87,19,18,17,16,16,13,11,10,10,11,11,-11,-11,-11,-10,-10,-9.48,-8.76,-8.03,-7.38,-6.88,-6.50,-6.27,-6.05,-5.66,-5.11,-4.25,-3.30,-2.28,-1.27,-0.25,0.65,1.47,2.09,2.57,2.97,3.27,3.58,3.77,4.09,4.33,4.50,4.62,4.65,4.60,4.37,4.09,3.70,3.25,2.83,2.46,2.15,2,1.87,1.76,1.64,1.51,1.37,1.25,1.13,1.09,1.08,1.12,1.25,1.50,1.75,1.90,2.12,2.25,2.50,2.63,2.74,2.71,2.57,2.32,1.95,1.38,0.65,-0.26,-1.50,-3.13,-5.10,-7.13,-8.85,-8.80,-7.68,-7.13,-6.63,-6.04,-5.13,-3.51,-1.75,-0.25,0.61,0.87,0.97,0.98,0.98,0.99,1,1,1,1.01,1.34,1.75,2.21,2.62,3,3.40,4,4.72,5.37,5.62,5.62,5.50,5.15,4.75,4.23,3.62,2.98,2.27,1.73,1.34,1.12,1,0.99,0.99,1,1.09,1.23,1.49,1.96,2.47,3.01,3.62,4.10,4.32,4.15,3.86,3.35,2.72,2.02,1.37,0.75,0.12,-0.53,-1.13,-1.63,-2.25,-3.25,-4.42,-5.39,-6.15,-6.75,-7.25,-7.38,-7.42,-7.38,-7.43,-7.63,-8,-8.50,-9.03,-9.43,-9.66,-9.75,-9.79,-9.88,-9.88,-9.65,-8.98,-7.63,-5.75,-3.63,-1.87,-0.50,0,0.25,0.37,0.58,0.75,0.87,1,1,1,1,1.12,1,2,2,3,3.87,4.86,5.13,6.15,7.14,7.99,8.76,9.70,10.57,11.37,12.15,12.97,13.74,14.46,15.09,15.37,15.25,14.98,14.72,14.72,14.89,15.07,15.14,15.25,15.32,15.35,15.32,15.22,14.90,14.47,13.87,13.15,12.49,11.83,11.22,10.70,10.25,9.88,9.61,9.37,9.14,9,8.97,9,9.24,9.20,10.21,11.09,12.10,13.12,14.15,15.20,16.08,16.59,16.58,15.61,14.88,14.37,14.24,14.47,15.25,16.51,16.52,16.02,15.63,15.20,14.72,14.24,13.77,13.23,13.12,13,13.11,13.89,14.02,15,16,17,17,17.98,17.97,17.96,17.12,16.95,16.71,16.38,16.08,15.85,15.85,16.02,16.35,16.71,17,17,16.75,16.62,16.75,16.98,17.11,17,16.73,16.36,16.07,15.98,16.25,16.90,17.72,18.37,18.58,18.37,18.12,18.12,18.38,18.87,19.63,20.33,21.11,22,23,24,25,25.52,25.75,25.33,24.52,23.33,22.22,21.33,20.70,20,19,18,17,17,14,11,11,10,10,10,-11,-11,-11,-10,-10,-9.62,-9.11,-8.60,-8.14,-7.80,-7.63,-7.50,-7.29,-6.93,-6.37,-5.50,-4.52,-3.42,-2.25,-0.89,0.25,1.08,1.47,1.89,2.38,2.71,3,3.33,3.62,3.89,4.15,4.37,4.49,4.47,4.27,4.01,3.71,3.27,2.86,2.47,2.15,1.99,1.83,1.65,1.51,1.37,1.25,1.12,1.08,1.02,1.09,1.24,1.50,1.85,2.22,2.57,2.64,2.85,3,3.12,3.12,3.07,2.87,2.52,2.11,1.50,0.75,-0.18,-1.40,-2.85,-5.04,-7.38,-9.13,-9.38,-8.23,-7.50,-6.91,-6.25,-5.25,-3.63,-1.77,-0.25,0.61,0.87,0.98,0.99,0.99,0.99,1,1,1,1.01,1.33,1.74,2.20,2.61,2.97,3.39,4.01,4.75,5.37,5.83,6.07,6.13,6,5.70,5.15,4.58,3.84,3.02,2.27,1.72,1.33,1.12,1,1,1,1,1.08,1.23,1.49,2,2.60,3.12,3.64,3.82,3.50,3.08,2.45,1.72,0.95,0.14,-0.61,-1.36,-2.10,-2.78,-3.54,-4.50,-5.61,-6.64,-7.42,-7.75,-7.86,-7.91,-7.88,-7.91,-7.90,-8,-8.13,-8.40,-8.75,-9.10,-9.37,-9.51,-9.65,-9.79,-9.93,-10,-9.75,-9.11,-7.86,-5.75,-3.75,-2.13,-1,-0.68,-0.42,-0.25,-0.04,0.25,0.57,0.75,0.87,0.98,1,1,1.12,1,1.98,2.07,3.10,4.10,4.87,5.83,6.76,7.23,8.12,9.02,10,10.87,11.70,12.50,13.35,14.12,14.73,14.99,14.75,14.33,13.99,13.85,13.87,13.96,14,14.07,14.12,14.12,14.12,14,13.76,13.37,12.84,12.22,11.58,10.96,10.38,9.95,9.58,9.25,9.08,8.89,8.77,8.75,8.86,9.11,9.20,10.12,11.01,12.02,13.13,14.25,15.37,16.58,17.57,18.51,17.51,16.52,15.62,15,14.46,15.23,15.95,16.51,16.62,16.27,15.75,15.10,14.34,13.90,13.25,13.14,13,13,13.12,13.87,14.02,14.96,15,16,17,17,17,17,17.01,17.23,17.61,17.01,16.65,16.40,16.37,16.50,16.82,17.13,17.47,17.36,17.14,17,17.07,17.12,17.12,16.96,16.64,16.37,16.12,16.12,16.47,17.11,17.86,18.50,18.76,18.76,18.73,18.87,19.22,19.63,20.22,20.75,21.40,22.33,23.33,24.33,25.22,25.87,26.22,26,25.22,24.11,23,22.11,21.33,21,20,19,18,16,14,12,11,10,10,10,-11,-11,-11,-10,-10,-9.75,-9.35,-8.99,-8.64,-8.50,-8.41,-8.27,-8.13,-7.77,-7.23,-6.39,-5.42,-4.38,-3.17,-1.91,-0.51,0.36,0.75,1.21,1.62,2.01,2.37,2.74,3.10,3.37,3.70,3.90,4.11,4.12,4.02,3.87,3.61,3.24,2.83,2.40,2.12,1.87,1.71,1.51,1.37,1.25,1.12,1.08,1,1,1.12,1.35,1.75,2.22,2.62,2.98,3.14,3.36,3.49,3.58,3.58,3.46,3.20,2.76,2.25,1.62,0.84,-0.16,-1.43,-3.11,-5.03,-7.03,-8.74,-8.79,-8.40,-7.78,-7.05,-6.17,-5.02,-3.61,-1.88,-0.25,0.61,0.87,0.97,0.98,0.98,0.99,1,1,1,1.07,1.32,1.65,2.09,2.50,2.87,3.32,3.87,4.51,5.13,5.63,6.11,6.47,6.62,6.37,6,5.37,4.62,3.84,3,2.25,1.71,1.33,1.12,1.01,1,1,1,1.09,1.26,1.63,2.13,2.62,3.01,3.12,2.82,2.25,1.50,0.62,-0.27,-1.24,-2.13,-2.93,-3.75,-4.51,-5.38,-6.42,-8,-8.53,-8.75,-8.67,-8.52,-8.38,-8.28,-8.25,-8.27,-8.38,-8.50,-8.64,-8.88,-9.11,-9.30,-9.53,-9.77,-10,-10,-10,-10,-9.50,-8.50,-7.02,-5.27,-3.66,-2.92,-2.50,-1.91,-1.50,-0.91,-0.37,0.23,0.60,0.82,0.87,0.96,1,1.07,1.25,1.99,2.01,2.88,3.87,4.12,5.09,5.86,6.75,7.25,8.33,9.27,10.21,11.12,12,12.95,13.73,14.25,14.52,14.12,13.59,13.20,12.97,12.87,12.84,12.83,12.83,12.86,12.87,12.86,12.75,12.50,12.14,11.70,11.13,10.60,10.08,9.61,9.23,8.96,8.75,8.62,8.60,8.62,8.74,8.97,9.21,10.11,10.97,11.87,12.90,14.12,15.62,16.58,17.57,18.52,18.50,17.75,16.87,16.10,15.45,15.46,15.83,16.57,16.89,16.90,16.60,15.82,15.02,14.34,13.75,13.25,13.02,13,13,13.12,13.12,13.88,14.02,15,15.99,17,16.99,16.99,17,17.97,17.87,17.73,17.61,17.15,16.88,16.76,16.87,17.12,17.50,17.77,17.72,17.51,17.38,17.37,17.33,17.15,16.95,16.62,16.37,16.22,16.25,16.62,17.25,18,18.65,19.09,19.26,19.45,19.72,20.11,20.40,20.87,21.40,22,22.75,23.63,24.63,25.52,26.22,26.52,26.33,25.63,24.63,23.75,22.75,21.99,21,20,19,18,16,14,12,11,10,10,10,-10,-10,-11,-10,-10,-9.79,-9.43,-9.13,-8.90,-8.86,-8.78,-8.80,-8.75,-8.48,-7.92,-7.10,-6.18,-5.23,-4.15,-3.05,-2,-1.12,-0.36,0.33,0.88,1.37,1.75,2.10,2.46,2.75,3,3.25,3.47,3.51,3.51,3.46,3.27,3,2.63,2.32,2,1.75,1.57,1.37,1.25,1.12,1.07,1,1,1,1.12,1.38,1.90,2.59,2.98,3.32,3.58,3.73,3.84,3.99,4,3.87,3.50,3.01,2.45,1.74,0.87,-0.16,-1.50,-3.15,-5.01,-6.80,-8.18,-8.75,-8.50,-8,-7.24,-6.26,-5.12,-3.66,-2.03,-0.17,0.62,0.87,0.87,0.87,0.87,0.86,0.87,0.87,0.95,1.01,1.25,1.57,1.87,2.25,2.62,3.07,3.58,4.12,4.65,5.23,5.77,6.32,6.64,6.65,6.50,5.89,5.24,4.50,3.70,2.88,2.20,1.62,1.27,1.12,1.01,0.99,0.98,1,1.12,1.37,1.75,2.12,2.38,2.37,2.09,1.50,0.62,-0.40,-1.53,-2.64,-3.66,-4.55,-5.37,-6.13,-7,-8,-9.05,-9.25,-9.37,-9.14,-8.92,-8.74,-8.60,-8.51,-8.53,-8.63,-8.66,-8.77,-8.91,-9.13,-9.38,-9.75,-10,-10,-10,-10,-10,-10,-9.42,-8.62,-7.25,-6.04,-5.25,-4.75,-4.14,-3.38,-2.13,-1.02,-0.15,0.37,0.62,0.75,0.85,0.87,1,1.25,1.83,2,2.07,3.10,3.87,4.12,5,5.85,6.72,7.59,8.50,9.50,10.46,11.45,12.37,13.24,13.52,13.64,13.21,12.65,12.25,11.98,11.77,11.65,11.60,11.52,11.58,11.59,11.52,11.46,11.25,10.90,10.50,10.02,9.60,9.15,8.85,8.59,8.37,8.35,8.35,8.40,8.60,8.77,9.22,9.87,10.75,11.75,12.71,13.63,14.75,16.59,16.96,17.76,18.50,18.50,17.84,17.07,16.35,15.89,15.90,16.37,16.87,17.59,17.59,16.62,15.86,15.02,14.34,13.74,13.25,13,13,13,13,13.12,13.11,14.07,15,15.99,17,17,16.99,17,17.97,17.97,17.96,17.83,17.57,17.13,16.95,17,17.27,17.73,18.12,18.02,17.87,17.75,17.62,17.50,17.25,16.97,16.63,16.38,16.26,16.40,16.87,17.50,18.24,18.96,19.50,19.87,20.20,20.52,20.87,21.22,21.52,22.11,22.63,23.33,24.11,25,25.87,26.63,27.11,26.87,26.11,25,24.11,23.48,22.33,22,20,19,18,16,14,12,11,10,10,10,-10,-11,-11,-10,-10,-9.78,-9.41,-9.13,-8.92,-8.88,-8.92,-9,-9,-8.79,-8.26,-7.65,-6.90,-6.04,-5.13,-4.23,-3.27,-2.39,-1.55,-0.77,-0.02,0.58,1.01,1.48,1.74,1.98,2.23,2.38,2.60,2.72,2.75,2.76,2.75,2.60,2.37,2.10,1.83,1.59,1.37,1.22,1.10,1,0.99,0.98,0.98,1,1.10,1.39,2,2.62,3.14,3.58,3.77,3.96,4.11,4.27,4.49,4.24,3.84,3.25,2.62,1.86,0.96,-0.14,-1.51,-3.16,-4.99,-6.65,-8.01,-8.63,-8.53,-8.13,-7.38,-6.42,-5.28,-3.91,-2.38,-0.50,0.59,0.62,0.60,0.61,0.50,0.60,0.62,0.74,0.82,0.89,1.11,1.36,1.62,1.95,2.25,2.62,3,3.50,4,4.61,5.25,5.87,6.35,6.45,6.39,6,5.50,4.87,4.14,3.38,2.62,1.99,1.50,1.24,1.08,0.98,0.90,0.96,1,1.20,1.40,1.63,1.84,1.75,1.46,0.85,-0.10,-1.48,-2.79,-4.11,-5.26,-6.24,-6.80,-7.50,-8.18,-8.88,-9.40,-9.51,-9.50,-9.38,-9.14,-8.92,-8.75,-8.68,-8.66,-8.75,-8.76,-8.78,-8.89,-9.13,-9.50,-10,-10,-10,-11,-11,-10,-10,-10,-10,-9.62,-8.66,-8.12,-7.63,-6.78,-5.63,-4.13,-2.25,-0.80,-0.02,0.25,0.38,0.50,0.62,0.85,1.12,1.37,1.87,2.11,2.87,2.89,3.12,4.12,5.11,6,6.87,7.77,8.75,9.73,10.70,11.60,12.24,12.37,12.34,11.99,11.52,11.13,10.87,10.65,10.50,10.37,10.32,10.26,10.25,10.26,10.21,10,9.74,9.35,8.90,8.58,8.32,8.12,8,7.97,8.02,8.24,8.22,8.75,9.22,9.75,10.24,11.22,12.09,12.98,13.96,15.02,16.10,17.02,17.85,18.50,18.50,17.76,17.11,16.50,16.12,16.12,16.49,17.23,17.12,16.95,16.48,15.76,15.07,14.37,13.72,13.25,13.02,13,13,13,13,13.12,14,15,15.99,17,17,17,17,17.98,17.97,17.97,17.85,17.71,17.07,16.87,16.90,17.26,17.82,18.37,18.37,18.12,18,17.86,17.62,17.34,16.99,16.65,16.40,16.37,16.62,17.13,17.77,18.50,19.25,19.87,20.45,20.99,21.33,21.63,22,22.33,22.75,23.22,23.63,24.22,24.87,25.75,26.52,27.11,26.87,25.87,24.63,23.75,22.87,22.22,22,20,19,18,16,14,12,11,10,10,10,-10,-10,-10,-10,-10,-9.68,-9.29,-9,-8.75,-8.75,-8.85,-8.93,-9.01,-8.88,-8.61,-8.13,-7.52,-6.80,-6.10,-5.28,-4.49,-3.64,-2.85,-2,-1.14,-0.42,0.12,0.50,0.87,1.12,1.32,1.45,1.61,1.72,1.85,1.97,2.01,2.01,1.97,1.77,1.60,1.37,1.13,1,0.87,0.87,0.87,0.88,0.95,0.99,1.07,1.37,1.99,2.62,3.25,3.62,3.87,4,4.25,4.58,4.62,4.49,4.02,3.48,2.75,1.98,1.01,-0.13,-1.50,-3.14,-4.88,-6.52,-7.88,-8.54,-8.61,-8.25,-7.51,-6.63,-5.61,-4.37,-2.92,-1.39,-0.01,-0.02,-0.13,-0.29,-0.37,-0.15,0.07,0.25,0.50,0.62,0.87,1.09,1.32,1.52,1.76,2.02,2.36,2.75,3.25,3.90,4.62,5.25,5.62,5.82,5.75,5.60,5.25,4.85,4.25,3.60,2.87,2.21,1.65,1.27,1.07,0.89,0.86,0.85,0.87,1,1.12,1.25,1.35,1.23,0.87,0.25,-0.93,-2.50,-4.11,-5.53,-6.78,-7.66,-8.12,-8.60,-9.02,-9.40,-9.65,-9.64,-9.61,-9.42,-9.25,-9.02,-8.85,-8.74,-8.68,-8.63,-8.74,-8.63,-8.64,-8.89,-9.36,-9.92,-10,-11,-11,-11,-10,-10,-11,-12,-11,-10,-10,-10,-9.75,-8.37,-6.50,-4.04,-2.04,-0.91,-0.50,-0.38,-0.13,0.12,0.50,0.84,1.12,1.38,1.75,2,2.23,2.25,3.13,4.71,5.33,6.15,7.10,8,8.89,9.72,10.36,10.75,10.87,10.76,10.51,10.21,9.88,9.64,9.49,9.35,9.23,9.12,9.12,9.09,9.08,9,8.87,8.62,8.23,7.72,7.48,7.45,7.40,7.39,7.50,7.87,8.22,8.75,9.23,9.75,10.25,11,11.73,12.32,13.21,14.10,15.08,16.08,17,17.85,18.37,18.25,17.74,17,16.37,16,15.98,16.32,16.64,16.86,16.70,16.32,15.75,15.11,14.50,13.95,13.38,13.13,13,13,13,13,13.12,14,14.99,15.99,17,17,17,18,17,17,16.98,16.97,16.86,16.74,16.37,16.65,17.10,17.72,18.27,18.37,18.25,18.22,18.10,17.77,17.40,17.02,16.73,16.48,16.50,16.84,17.37,18.07,18.75,19.50,20.21,21,21.63,22.11,22.22,22.33,22.52,22.87,23.33,23.63,24.11,24.52,25.22,26,26.63,26.33,25.33,24,23.11,22.33,21.73,21,20,19,18,16,14,12,11,10,10,10,-10,-10,-10,-10,-9.88,-9.55,-9.13,-8.76,-8.50,-8.50,-8.64,-8.85,-9,-8.99,-8.85,-8.51,-8.04,-7.53,-6.98,-6.29,-5.63,-4.88,-4.11,-3.28,-2.50,-1.75,-1.13,-0.63,-0.25,0.12,0.23,0.34,0.48,0.59,0.87,1.01,1.25,1.45,1.50,1.47,1.35,1.15,0.95,0.58,0.52,0.57,0.60,0.62,0.88,0.96,1,1.35,1.87,2.61,3.08,3.59,3.82,4,4.32,4.61,4.75,4.57,4.14,3.61,2.88,2.10,1.12,-0.03,-1.43,-3.05,-4.75,-6.38,-7.75,-8.50,-8.63,-8.36,-7.68,-6.90,-6.01,-5,-3.88,-2.64,-1.16,-1.13,-1.38,-1.80,-1.76,-1.43,-1,-0.50,-0.04,0.34,0.50,0.75,0.99,1.20,1.37,1.50,1.75,2.09,2.62,3.25,3.95,4.50,4.84,4.98,4.98,4.87,4.73,4.40,4,3.40,2.77,2.20,1.64,1.25,0.98,0.76,0.71,0.65,0.72,0.75,0.87,1,1,0.75,0.37,-0.48,-1.92,-3.62,-5.25,-6.80,-8.03,-8.79,-9.04,-9.35,-9.55,-9.75,-9.85,-9.75,-9.60,-9.38,-9.14,-8.91,-8.75,-8.50,-8.37,-8.25,-8.13,-8.13,-8.11,-8.38,-8.88,-9.49,-10,-11,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-11,-11,-8.63,-6.13,-3.91,-2.54,-2,-1.50,-1.01,-0.50,0,0.47,0.83,1.11,1.33,1.51,1.75,2.15,2.87,3.75,4.60,5.49,6.37,7.25,7.99,8.58,8.98,9.21,9.25,9.20,9,8.77,8.59,8.39,8.26,8.15,8.11,8.02,8,8,8,8,7.95,7.75,7.50,7.25,7.12,7.14,7.25,7.47,7.84,8.25,8.75,9.25,9.87,10.25,11,11.73,12.22,12.82,13.37,14.25,15.15,16.12,17.02,17.82,18.25,18.15,17.60,16.75,16.10,15.64,15.62,15.89,16.26,16.52,16.51,16.22,15.74,15.20,14.65,14.21,13.76,13.39,13.15,13,13,13,13.12,14,14.99,15.99,17,17,17,17,17,16,16,15.99,15.97,15.88,15.98,16.24,16.74,17.25,17.84,18.09,18.25,18.37,18.37,18,17.60,17.12,16.82,16.58,16.63,17,17.59,18.24,18.90,19.62,20.33,21.22,22.11,22.63,22.52,22.40,22.40,22.63,22.87,23.22,23.52,24,24.40,25.11,25.63,25.40,24.52,23.33,22.40,21.63,20.87,20,19,18,18,17,14,12,11,10,10,10,-9.38,-9.88,-10,-9.99,-9.76,-9.42,-9,-8.61,-8.25,-8.27,-8.49,-8.74,-8.93,-9.04,-9.03,-8.88,-8.60,-8.23,-7.75,-7.25,-6.68,-6.05,-5.38,-4.63,-3.88,-3.17,-2.53,-2,-1.63,-1.15,-1.13,-1.03,-0.89,-0.66,-0.41,0.10,0.50,0.85,1.11,1.13,1.12,1,0.87,0.25,-1.39,-3.23,-3.03,0.74,0.72,0.73,1,1.25,1.64,2.20,2.74,3.20,3.60,3.87,4.21,4.59,4.64,4.57,4.20,3.64,3,2.14,1.20,0.01,-1.36,-2.89,-4.53,-6.13,-7.60,-8.48,-8.73,-8.50,-7.98,-7.28,-6.62,-5.88,-5.10,-4.17,-3.13,-3.01,-3.30,-3.91,-3.88,-3.25,-2.37,-1.41,-0.75,-0.25,0.12,0.40,0.71,0.89,1.07,1.15,1.32,1.61,2.12,2.75,3.32,3.75,4,4.12,4.12,4.09,3.99,3.75,3.46,3,2.48,1.95,1.47,1.02,0.75,0.51,0.40,0.38,0.39,0.50,0.62,0.75,0.82,0.50,-0.11,-1.17,-2.88,-4.66,-6.38,-7.90,-9.04,-9.64,-9.75,-9.86,-9.89,-9.91,-9.88,-9.77,-9.50,-9.14,-8.80,-8.50,-8.25,-8,-7.51,-7.12,-6.88,-6.85,-6.80,-7.03,-7.75,-8.38,-7.29,-8.13,-8.04,-7.88,-8.12,-9.13,-10,-11,-11,-10,-10,-10,-11,-12,-9.50,-7.50,-5.51,-4.37,-3.54,-2.88,-2.12,-1.28,-0.54,0.07,0.48,0.75,0.96,1.12,1.37,1.85,2.40,3.12,3.95,4.75,5.62,6.37,6.98,7.36,7.61,7.74,7.75,7.71,7.58,7.39,7.25,7.15,7.12,7.10,7.08,7.01,7.01,7.07,7.08,7.09,7.12,7.12,7.12,7.11,7.12,7.25,7.48,7.87,8.37,8.88,9.25,10.11,10.73,11.25,11.75,12.26,12.76,13.27,13.87,14.40,15.46,16.39,17.20,17.77,18.11,17.87,17.24,16.37,15.62,15.21,15.15,15.58,16.02,16.38,16.50,16.23,15.75,15.25,14.84,14.48,14.08,13.63,13.26,13.09,13,13,13.12,13.90,14.89,15.97,17,17,17,17,16,15,15,15,14.99,15,15,15.87,16.23,16.77,17.35,17.82,18.26,18.58,18.70,18.26,17.87,17.37,17,16.75,16.85,17.12,17.70,18.27,19,19.63,20.33,21.33,22.33,22.87,22.40,21.99,21.75,21.87,22,22.33,22.63,23.22,23.63,24.33,24.75,24.52,23.75,22.63,21.75,20.87,20.11,19,18,18,17,16,14,12,11,10,10,10,-8.89,-9.51,-9.88,-10,-9.67,-9.29,-8.87,-8.50,-8.16,-8.25,-8.42,-8.73,-9,-9.17,-9.26,-9.25,-9.02,-8.76,-8.48,-8.11,-7.64,-7.13,-6.51,-5.88,-5.23,-4.60,-4.01,-3.54,-3.17,-2.91,-2.77,-2.63,-2.38,-2.02,-1.50,-1,-0.38,0.12,0.61,0.84,0.87,0.87,0.63,-0.10,-3.50,-9.87,-9.54,-3.01,-0.75,0.70,0.98,1.12,1.36,1.75,2.23,2.75,3.20,3.62,3.98,4.27,4.60,4.37,4.11,3.62,3,2.21,1.25,0.12,-1.15,-2.64,-4.25,-5.79,-7.28,-8.36,-8.75,-8.66,-8.26,-7.76,-7.28,-6.86,-6.36,-5.79,-5.38,-4.90,-5.63,-6.14,-5.90,-4.80,-3.41,-2.16,-1.26,-0.63,-0.27,0.22,0.50,0.75,0.88,1,1.12,1.40,1.86,2.35,2.76,3.12,3.32,3.37,3.37,3.32,3.22,3.02,2.76,2.39,1.99,1.50,1.07,0.63,0.35,0.12,0,-0.02,0,0.09,0.34,0.50,0.60,0.37,-0.41,-2.05,-3.92,-5.75,-7.38,-8.78,-9.76,-10,-10,-10,-10,-9.93,-9.78,-9.60,-9.26,-8.73,-8.15,-7.63,-7.13,-6.73,-6.13,-5.40,-4.85,-4.50,-4.38,-4.64,-4.39,-4.41,-5.02,-4.88,-4.88,-5.13,-5.75,-7.14,-9.13,-10,-9.28,-8.50,-8.13,-7.88,-8.25,-8.42,-8.04,-7.43,-6.37,-5.54,-5.05,-4.25,-3.26,-2.25,-1.27,-0.50,0,0.25,0.50,0.72,0.99,1.37,1.95,2.58,3.26,4.07,4.83,5.47,5.88,6.14,6.33,6.37,6.37,6.33,6.25,6.14,6.12,6.11,6.12,6.12,6.14,6.15,6.15,6.15,6.24,6.37,6.59,6.77,7,7.14,7.36,7.61,8,8.52,9.12,9.72,10.25,11,11.71,12.26,12.70,13.08,13.34,13.85,14.39,15.22,16.02,16.83,17.39,17.75,17.84,17.50,16.75,15.97,15.22,14.82,14.87,15.36,15.87,16.35,16.49,16.15,15.73,15.25,14.84,14.51,14.14,13.75,13.35,13.09,12.99,13,13.24,13.45,14.76,15.96,16.75,16.84,16.88,16,15,14,14,14,14,14,14.98,15,15.98,16.11,17.09,17.75,18.25,18.71,18.84,18.59,18.23,17.75,17.37,17.09,17,17.35,17.63,18.33,19,19.63,20.33,21.22,22.11,22.40,21.87,21.33,21,21,21,21.33,21.75,22.52,23.11,23.75,24.11,24,23.33,22.33,21.33,20.26,19.09,19,18,17,16,15,13,12,11,10,10,10,-8.50,-9.12,-9.53,-9.75,-9.50,-9.13,-8.75,-8.50,-8.28,-8.38,-8.60,-8.86,-9.13,-9.38,-9.52,-9.54,-9.43,-9.25,-9.03,-8.76,-8.43,-8.02,-7.52,-6.99,-6.38,-5.87,-5.38,-5.03,-4.79,-4.67,-4.38,-4.13,-3.75,-3.29,-2.80,-2.27,-1.75,-1.16,-0.63,0.08,0.37,0.50,0.21,-1.11,-3.64,-8.88,-7.30,-3.02,-0.75,0.72,0.96,1,1.12,1.36,1.75,2.22,2.62,3.10,3.61,3.96,4.12,4.12,3.89,3.50,2.96,2.20,1.26,0.25,-0.92,-2.28,-3.78,-5.35,-6.85,-8.11,-8.74,-8.85,-8.63,-8.28,-8,-7.75,-7.50,-7.25,-7.18,-6.85,-7.65,-7.42,-6.88,-5.54,-3.88,-2.38,-1.37,-0.64,-0.27,0.13,0.50,0.72,0.87,0.96,1.11,1.35,1.73,2.10,2.38,2.62,2.74,2.75,2.72,2.62,2.50,2.36,2.12,1.75,1.37,0.95,0.50,0.10,-0.25,-0.50,-0.64,-0.67,-0.67,-0.55,-0.38,-0.13,0.25,0.12,-1.66,-3.38,-5.25,-6.88,-8.26,-9.41,-10,-10,-10,-10,-10,-9.77,-9.50,-9.14,-8.66,-8.01,-7.23,-6.28,-5.50,-4.79,-4.25,-3.25,-2.16,-1.75,-1.63,-1.63,-1,-1,-1,-1.88,-2.04,-2.52,-3.39,-4.93,-6.43,-7,-6.55,-5.63,-4.88,-4.25,-4.50,-5.12,-5.52,-5.87,-5.93,-6.17,-6.43,-5.63,-4.50,-3.43,-2.29,-1.38,-0.75,-0.38,-0.13,0.20,0.50,0.96,1.45,2.02,2.71,3.37,4,4.50,4.87,5.08,5.13,5.14,5.14,5.13,5.12,5.12,5.14,5.24,5.33,5.39,5.49,5.50,5.50,5.50,5.73,6,6.49,6.87,7.22,7.50,7.84,8.25,8.77,9.37,10,10.63,11.33,11.98,12.62,13.12,13.60,13.65,13.89,14.37,15.11,15.87,16.64,17.35,17.71,17.75,17.48,16.98,16.25,15.51,14.87,14.57,14.73,15.23,15.76,16.26,16.37,16.07,15.52,15.08,14.64,14.36,14,13.62,13.25,13,12.88,12.99,13.13,13.62,14.71,15.85,16.58,16.21,15.72,15,14.11,14,14,14,14,14,15,15,15.99,16,17,17.99,18,18.99,19,18.99,18.75,18.22,17.75,17.40,17.33,17.52,17.87,18.40,19.11,19.63,20.33,20.87,21.40,21.40,20.87,20.33,20,20,20.11,20.40,21,21.75,22.52,23.22,23.52,23.33,22.63,21.63,20.63,19.75,19,18,17,16,16,14,12,11,11,10,10,10,-8,-8.75,-9.25,-9.40,-9.28,-8.99,-8.74,-8.61,-8.50,-8.62,-8.80,-9.10,-9.38,-9.73,-9.88,-9.93,-9.88,-9.74,-9.51,-9.30,-9.10,-8.75,-8.38,-7.89,-7.41,-7,-6.63,-6.38,-6.30,-6.03,-5.85,-5.50,-5.04,-4.60,-4.12,-3.63,-3.13,-2.60,-1.92,-1.24,-0.28,0.12,0,-0.75,-2.24,-2.91,-1.42,0.76,0.75,0.74,0.96,1,1,1.12,1.35,1.65,2,2.37,2.98,3.62,3.70,3.75,3.62,3.35,2.83,2.12,1.33,0.37,-0.63,-1.88,-3.25,-4.75,-6.25,-7.63,-8.52,-8.88,-8.90,-8.77,-8.63,-8.50,-8.38,-8.26,-8.25,-8.02,-7.85,-7.50,-6.75,-5.38,-3.67,-2.13,-1,-0.25,0.08,0.37,0.57,0.75,0.87,0.97,1.10,1.34,1.63,1.95,2.12,2.25,2.26,2.25,2.15,2.07,1.89,1.74,1.49,1.12,0.72,0.25,-0.25,-0.68,-1.11,-1.39,-1.60,-1.68,-1.75,-1.75,-1.75,-1.63,-1.75,-2.42,-3.60,-5.26,-6.78,-8.12,-9.13,-9.88,-10,-10,-10,-10,-9.77,-9.42,-9.01,-8.48,-7.66,-6.68,-5.50,-4.16,-2.88,-1.92,-1.43,-0.88,-0.26,0.25,0.86,1.21,1,1,1,0.88,0.25,-0.25,-1.63,-2.75,-3.50,-3.75,-3.43,-2.66,-1.90,-1.38,-1.50,-2.16,-2.92,-3.64,-4.62,-5.68,-6.87,-6.53,-5.67,-4.80,-3.75,-2.65,-1.88,-1.30,-0.88,-0.50,0,0.57,1.02,1.60,2.14,2.75,3.25,3.64,3.95,4.08,4.12,4.15,4.22,4.23,4.25,4.33,4.45,4.60,4.76,5,5.12,5.21,5.27,5.37,5.83,6.25,6.82,7.27,7.73,8.12,8.58,9.10,9.71,10.34,10.99,11.62,12.32,12.96,13.52,14,14.22,14.36,14.46,14.98,15.62,16.37,17.12,17.74,17.89,17.73,17.20,16.57,15.85,15.14,14.62,14.47,14.63,15.11,15.62,16.09,16.11,15.74,15.25,14.75,14.37,14,13.71,13.37,13.09,12.87,12.75,12.87,13.15,13.75,14.65,15.50,15.51,15.21,14.57,14,13.26,13.15,13.07,13,14,15,15,16,16,17,17,18,19,19,19,19.87,19,18.52,18.11,17.75,17.63,17.75,18.11,18.63,19.33,19.75,20.22,20.33,20.40,20.22,19.75,19.33,19,19,19.22,19.63,20.33,21.11,21.87,22.63,23.11,23,22.33,21.33,20.27,19.11,18,17,16,15,15,13,12,11,11,11,11,10,-7.38,-8.13,-8.55,-8.76,-8.78,-8.68,-8.79,-8.73,-8.74,-8.87,-9.10,-9.38,-9.75,-10,-10,-10,-10,-10,-10,-9.77,-9.63,-9.38,-9.05,-8.73,-8.36,-8,-7.68,-7.52,-7.36,-7.18,-6.99,-6.63,-6.17,-5.75,-5.29,-4.91,-4.55,-4.13,-3.50,-2.63,-1.61,-0.42,-0.12,-0.13,-0.40,-0.37,0.25,0.62,0.88,0.96,0.97,0.97,0.97,0.99,1.11,1.25,1.35,1.86,2.35,2.87,3.23,3.37,3.34,3.11,2.62,2.01,1.34,0.57,-0.28,-1.35,-2.62,-4.11,-5.63,-7.14,-8.26,-8.88,-9.13,-9.17,-9.13,-9.05,-9,-9,-9.04,-8.85,-8.49,-7.80,-6.50,-5.04,-3.38,-1.75,-0.55,0.09,0.25,0.50,0.70,0.77,0.89,1,1.12,1.37,1.62,1.84,1.96,1.97,1.89,1.84,1.72,1.58,1.37,1.15,0.87,0.48,-0.03,-0.62,-1.14,-1.68,-2.16,-2.53,-2.87,-3.11,-3.17,-3.43,-3.50,-3.38,-3.88,-4.85,-6.23,-7.48,-8.53,-9.39,-9.92,-10,-10,-10,-10,-9.75,-9.38,-9,-8.49,-7.66,-6.50,-5.11,-3.55,-1.78,-0.37,0.63,1.22,1.49,1.82,2.12,2.50,3.21,4,4,3,2,1.59,0.75,-0.13,-0.78,-1.05,-1.05,-0.79,-0.38,0.09,0.46,0.37,-0.05,-0.87,-1.38,-2.78,-4.53,-6.01,-6.40,-6.50,-6.12,-5.36,-4.37,-3.36,-2.41,-1.75,-1.13,-0.41,0.25,0.75,1.24,1.73,2.22,2.62,2.95,3.12,3.25,3.37,3.46,3.50,3.57,3.59,3.82,4,4.33,4.62,4.96,5.20,5.38,5.62,5.97,6.37,6.89,7.47,7.99,8.47,8.95,9.47,10.01,10.64,11.33,11.98,12.62,13.27,13.89,14.48,14.83,14.90,14.97,15.02,15.35,15.87,16.62,17.33,17.88,17.98,17.62,16.89,16.15,15.47,14.87,14.48,14.37,14.52,14.96,15.39,15.75,15.74,15.37,14.87,14.37,13.99,13.62,13.36,13.09,12.83,12.62,12.57,12.63,13,13.62,14.36,14.85,14.62,14.21,13.57,13.12,12.87,12.87,13.11,13.10,14,15,16,16,17,17,18,18,19,19,19,19,18.77,18.62,18.22,18,18,18.11,18.40,19,19.52,19.87,20,19.63,19.33,19,18.63,18.33,18,18,18.33,18.87,19.63,20.40,21.33,22.21,22.75,22.62,21.99,20.99,19.99,19,18,17,16,14,13,12,12,11,11,11,11,11,-6.63,-7.38,-7.90,-8.39,-8.80,-9.02,-9.04,-8.88,-8.88,-9,-9.29,-9.75,-10,-10,-11,-11,-11,-10,-10,-10,-10,-10,-9.78,-9.50,-9.18,-8.88,-8.63,-8.43,-8.23,-8.02,-7.79,-7.50,-7.11,-6.68,-6.38,-6.13,-6,-5.79,-5.25,-4.25,-2.85,-1.26,-0.40,0.12,0.45,0.63,0.75,0.83,0.89,0.95,0.89,0.87,0.86,0.85,0.87,0.96,1.13,1.46,1.87,2.32,2.74,2.99,3.01,2.86,2.46,1.88,1.32,0.71,0.11,-0.63,-1.79,-3.38,-5.05,-6.73,-8,-8.88,-9.29,-9.50,-9.50,-9.50,-9.49,-9.50,-9.66,-9.61,-9.30,-8.63,-7.39,-5.50,-3.53,-1.75,-0.50,0.20,0.37,0.58,0.74,0.87,0.96,1.10,1.25,1.39,1.60,1.75,1.75,1.65,1.58,1.39,1.25,1.08,0.87,0.62,0.25,-0.25,-0.88,-1.60,-2.27,-2.92,-3.50,-4,-4.39,-4.75,-5.13,-5.51,-5.64,-5.64,-5.90,-7.38,-8.67,-9.75,-10,-10,-10,-10,-10,-10,-9.64,-9.24,-8.75,-8.13,-7.41,-6.38,-4.88,-3,-1.38,-0.17,0.95,2.12,3.12,3.75,3.88,4.08,4.12,4.32,4,4,4,3,2.75,1.62,1,0.73,0.60,0.61,0.75,0.99,1.25,1.50,1.46,1.12,0.62,-0.13,-1.62,-3.53,-5.26,-6.50,-7.29,-7.50,-6.90,-5.77,-4.61,-3.50,-2.52,-1.66,-0.77,0,0.60,1,1.37,1.75,2.11,2.34,2.49,2.62,2.85,3,3.15,3.27,3.40,3.75,4.09,4.47,4.87,5.25,5.62,5.90,6.26,6.75,7.25,7.76,8.32,8.85,9.37,9.87,10.46,11.02,11.65,12.33,12.97,13.62,14.25,14.83,15.33,15.57,15.51,15.38,15.34,15.46,15.87,16.49,17.12,17.64,17.74,17.35,16.62,15.86,15.12,14.62,14.33,14.25,14.45,14.75,15.14,15.38,15.35,15,14.50,13.99,13.58,13.25,12.98,12.73,12.50,12.32,12.24,12.32,12.60,13.08,13.65,13.96,13.62,13.23,12.64,12.45,12.57,12.87,13.37,14.11,15,16,17,17,17,18,18,18,18,18,18,18,18,17.87,17.75,17.63,17.75,18.11,18.52,19.11,19.40,19.52,19.33,18.75,18.33,18,17.63,17.33,17,17.11,17.40,18.11,18.87,19.76,20.70,21.65,22.34,22.38,21.71,20.74,19.87,18.97,17.97,16.97,15,13.99,12.99,12,12,12,12,12,12,12,-6.25,-7.30,-8.14,-8.75,-9.14,-9.38,-9.40,-9.25,-8.90,-8.91,-9.40,-10,-10,-11,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.73,-9.38,-9.13,-8.85,-8.63,-8.38,-8.11,-7.76,-7.49,-7.25,-7.13,-7.14,-7.18,-6.77,-5.75,-4.13,-2.28,-1,-0.01,0.49,0.71,0.75,0.87,0.85,0.84,0.73,0.62,0.59,0.58,0.62,0.73,0.88,1.15,1.50,1.87,2.27,2.65,2.75,2.62,2.24,1.75,1.25,0.77,0.38,0.22,-0.87,-2.65,-4.52,-6.37,-7.85,-8.87,-9.42,-9.67,-9.75,-9.75,-9.75,-9.88,-9.98,-10,-9.88,-9.48,-8.41,-6.74,-4.25,-2.25,-0.87,-0.15,0.25,0.50,0.72,0.85,0.98,1.11,1.48,1.45,1.49,1.51,1.47,1.36,1.13,0.96,0.72,0.48,0.25,0,-0.38,-1,-1.80,-2.75,-3.63,-4.43,-5.13,-5.65,-6.13,-6.63,-7.25,-7.80,-8.50,-8,-8.53,-9.51,-10,-11,-12,-11,-11,-10,-10,-9.76,-9.23,-8.63,-7.93,-7.15,-6.23,-4.91,-3.25,-1.14,0.12,0.99,2,3.25,4.49,5.48,5.85,5.85,5.50,5.32,5,5,5,4,4,2.87,2.23,1.95,1.87,1.87,2,2,2.07,2,2.12,1.50,1.50,0.22,-1.17,-3.12,-5.13,-6.68,-7.88,-8.50,-8.11,-6.91,-5.61,-4.30,-3.16,-2.13,-1.01,-0.13,0.51,0.87,1.12,1.40,1.72,1.96,2.12,2.35,2.62,2.95,3.20,3.47,3.75,4.12,4.51,5,5.50,5.95,6.32,6.70,7.12,7.65,8.25,8.76,9.33,9.87,10.37,10.96,11.50,12.12,12.72,13.34,13.96,14.59,15.15,15.63,15.98,16,15.75,15.48,15.25,15.26,15.61,16.12,16.72,17.25,17.37,17,16.36,15.61,14.90,14.46,14.21,14.14,14.33,14.61,14.90,15.11,15,14.62,14.12,13.60,13.13,12.83,12.52,12.32,12.09,11.87,11.75,11.83,12,12.35,12.72,12.98,12.76,12.57,12.23,12.23,12.57,13.22,14.11,15,15.87,16.87,18,18,18,18,18,17,17,17,17,17,17,17,17,17,17.22,17.75,18.33,18.75,18.75,18.63,18.33,17.75,17.33,17,16.63,16.33,16,16.22,16.63,17.39,18.26,19.26,20.33,21.26,21.87,21.87,21.25,20.26,19.24,18.13,17.13,16.63,14.25,13.22,12.12,12,12,12,13,13,13,13,-6.75,-7.50,-8.25,-8.88,-9.27,-9.50,-9.52,-9.38,-9.04,-8.52,-9.75,-10,-11,-13,-14,-13,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.63,-9.26,-9,-8.75,-8.51,-8.26,-8.04,-7.89,-7.88,-7.98,-8.11,-7.77,-6.87,-5.29,-3.51,-1.90,-0.78,-0.25,0.10,0.20,0.23,0.87,0.64,0.14,0.08,0.07,0.11,0.23,0.37,0.62,0.88,1.20,1.50,1.86,2.20,2.72,2.37,1.90,1.49,1.08,0.75,0.61,0.38,-0.17,-1.88,-4.14,-6.17,-7.86,-9,-9.63,-9.88,-9.92,-9.91,-9.93,-10,-10,-10,-10,-10,-9.50,-7.98,-5.74,-2.75,-1.67,-0.75,-0.13,0.25,0.50,0.62,0.83,1,1.12,1.14,1.21,1.20,1.07,0.87,0.58,0.26,-0.03,-0.38,-0.67,-1,-1.42,-2.02,-3,-4.11,-5.17,-6.18,-7.04,-7.63,-7.88,-8.25,-9.41,-10,-9.50,-9.75,-10,-11,-12,-12,-13,-12,-11,-10,-10,-9.50,-8.75,-8,-7.13,-6.16,-5,-3.53,-1.75,0,1.11,2,3,4.07,5.12,6.25,6.84,7.09,6.86,6.50,6,6,6,5,5,4,3.12,3,2.98,2.98,3,2.87,2.58,2.12,1.72,1.37,0.82,0.60,-1.38,-3.38,-5.48,-7.04,-8.25,-8.93,-8.67,-7.63,-6.30,-4.98,-3.67,-2.39,-1.15,-0.13,0.57,0.77,1,1.20,1.48,1.77,2.12,2.46,2.86,3.25,3.62,4,4.39,4.87,5.37,5.89,6.46,6.95,7.35,7.73,8.20,8.73,9.27,9.86,10.40,11,11.58,12.12,12.63,13.22,13.75,14.35,14.95,15.50,16.07,16.35,16.38,16.12,15.71,15.25,15,14.96,15.15,15.63,16.22,16.70,16.87,16.65,16.13,15.47,14.82,14.36,14.12,14.10,14.21,14.45,14.71,14.84,14.71,14.32,13.75,13.22,12.75,12.37,12.08,11.82,11.58,11.37,11.24,11.23,11.33,11.57,11.87,12.12,12.12,12.23,12.23,12.57,13.12,14,15,15.87,16.63,17.24,17.90,18,18,17,17,16,16,16,16,16,16,16,15.87,15.87,16.33,16.87,17.40,17.63,17.52,17.33,17.11,16.63,16.33,15.87,15.52,15.22,15.11,15.45,16,16.84,17.74,18.77,19.87,20.87,21.40,21.35,20.64,19.70,18.50,17.37,16.37,15.26,14.25,13.14,12.37,12.25,12.12,13,14,15,15,15,-7,-7.75,-8.38,-8.77,-9.14,-9.38,-9.41,-9.27,-9,-9.28,-10,-11,-12,-13,-14,-13,-12,-11,-11,-12,-13,-13,-13,-13,-12,-11,-10,-9.99,-9.55,-9.26,-9.02,-8.85,-8.63,-8.50,-8.38,-8.38,-8.43,-8.50,-8.25,-7.50,-6.36,-4.89,-3.38,-2.37,-1.63,-1.13,-0.85,-0.75,-0.90,-0.75,-0.76,-0.77,-0.73,-0.54,-0.35,-0.01,0.32,0.62,0.87,1.12,1.37,1.62,1.75,1.75,1.50,1.08,0.73,0.51,0.60,0.84,0.22,-1.26,-4,-6.38,-8.17,-9.48,-10,-10,-10,-10,-9.93,-9.98,-10,-10,-10,-10,-10,-9.01,-6.75,-4.61,-2.75,-1.63,-0.50,-0.37,-0.13,0.22,0.37,0.49,0.57,0.62,0.62,0.64,0.52,-0.15,-0.49,-0.88,-1.38,-1.79,-2.17,-2.55,-3,-3.50,-4.40,-5.73,-6.89,-8,-9.37,-10,-9.13,-9.03,-9.50,-10,-10,-10,-11,-12,-12,-13,-13,-12,-11,-10,-10,-9.15,-8.28,-7.38,-6.30,-5.11,-3.64,-2.14,-0.43,0.75,1.82,2.75,3.82,4.83,5.73,6.62,7.25,7.62,7.62,7.83,7,7,7,6,6,5,4,4,4,4,3.87,3.75,2.73,1.88,1.12,0.60,0.50,-0.92,-1.51,-4.38,-6.16,-7.54,-8.54,-9.03,-8.88,-8.04,-6.85,-5.42,-4.01,-2.63,-1.25,-0.13,0.62,0.75,0.89,1.02,1.37,1.84,2.33,2.84,3.33,3.85,4.26,4.82,5.26,5.87,6.38,7,7.62,8.14,8.62,9,9.38,9.87,10.37,10.98,11.61,12.23,12.82,13.35,13.85,14.33,14.83,15.35,15.87,16.37,16.87,17,16.74,16.22,15.60,15,14.65,14.57,14.72,15.14,15.73,16.22,16.50,16.49,16.02,15.39,14.75,14.32,14.07,14,14.09,14.26,14.50,14.61,14.46,14.01,13.48,12.87,12.34,11.87,11.51,11.24,10.98,10.75,10.62,10.62,10.72,10.98,11.35,11.65,12,12.46,12.75,13.34,14,14.87,15.75,16.40,17,17.62,17.82,18,17,16,16,15,15,15,15,15,14,14,14,14.87,15.11,15.63,16.11,16.33,16.33,16.33,16.22,15.75,15.22,14.63,14.33,14.11,14.23,14.72,15.52,16.49,17.52,18.62,19.75,20.71,21.33,21.23,20.34,19,17.77,16.65,15.62,14.75,13.97,13.27,12.96,13.07,13.37,14.25,15.88,16,17,17,-7.14,-8,-8.64,-9.13,-9.38,-9.50,-9.40,-9.25,-9.38,-10,-11,-11,-11,-10,-10,-9.50,-9,-9.63,-9.88,-11,-12,-13,-14,-14,-13,-12,-11,-10,-9.76,-9.48,-9.23,-9.01,-8.89,-8.79,-8.75,-8.75,-8.76,-8.75,-8.53,-8.04,-7.26,-6.38,-5.28,-4.54,-3.89,-3.27,-2.75,-2.52,-2.11,-2.14,-2,-1.79,-1.63,-1.36,-0.99,-0.51,-0.05,0.32,0.52,0.72,0.84,0.90,0.99,0.96,0.84,0.48,0.13,0.08,0.25,0.62,0.20,-1.26,-3.90,-6.25,-8,-9.25,-9.89,-10,-9.99,-9.89,-9.86,-9.80,-9.87,-9.91,-10,-10,-9.88,-9,-7.50,-5.67,-3.93,-2.25,-2.16,-1.88,-1.63,-1.38,-1.13,-1,-0.91,-1,-1.16,-1.17,-1.38,-1.66,-1.92,-2.50,-3.25,-3.76,-4.16,-4.50,-4.88,-5.38,-6.27,-7.50,-8.75,-10,-10,-9.35,-9.24,-9.38,-10,-10,-11,-11,-12,-12,-13,-13,-13,-12,-11,-10,-9.75,-8.80,-7.91,-6.88,-5.65,-4.13,-2.50,-0.37,0.32,1.25,2.20,3.12,4.21,5.13,6.12,6.97,7.62,7.98,7.99,8,8,8,8,7,7,6,5,5,5,4,3.88,3.71,2.62,1.37,0.50,-0.50,-1.25,-1.92,-4.42,-6.01,-7.23,-8.23,-9,-9.37,-9.16,-8.42,-7.25,-5.79,-4.26,-2.75,-1.30,-0.15,0.59,0.75,0.87,1,1.37,1.96,2.62,3.33,3.96,4.58,5.12,5.70,6.25,6.87,7.50,8.20,8.87,9.50,10.01,10.39,10.75,11.12,11.58,12.12,12.75,13.46,14.01,14.52,14.99,15.37,15.82,16.25,16.75,17.15,17.59,17.50,17,16.25,15.48,14.75,14.37,14.14,14.26,14.74,15.26,15.84,16.24,16.35,16,15.45,14.77,14.26,14,13.87,13.95,14.12,14.35,14.40,14.25,13.84,13.23,12.52,11.89,11.37,10.90,10.58,10.27,10.12,10.09,10.12,10.35,10.72,11.25,11.65,12.35,13.11,13.64,14.32,14.87,15.62,16.21,16.52,16.75,16.87,17,16.87,16,15,15,14,14,14,13,13,13,13,13,13,13.90,14.20,14.70,14.63,14.87,15.45,15.37,14.52,13.87,13.33,13.11,13.12,13.60,14.36,15.37,16.39,17.52,18.63,19.71,20.59,21.12,21.02,19.58,18.25,17.01,15.98,15.10,14.39,13.89,13.62,13.62,14.01,14.74,15.85,17.70,18.86,18,18,-7.43,-8.38,-9.16,-9.75,-10,-10,-9.88,-9.52,-9.88,-10,-11,-11,-9.40,-7.17,-5.80,-4.78,-4.52,-5.38,-6,-6.63,-8.38,-10,-15,-17,-14,-12,-11,-10,-9.99,-9.61,-9.30,-9.13,-9.04,-9,-9,-9.02,-9.04,-9.03,-8.90,-8.63,-8.16,-7.67,-7.13,-6.66,-6.13,-5.42,-4.65,-4.25,-4,-3.55,-3.24,-2.90,-2.62,-2.18,-1.68,-1.12,-0.48,-0.02,0.10,0.15,0.21,0.12,0.12,0.10,0,-0.30,-0.54,-0.75,-0.25,0.38,0.10,-1.38,-4.13,-6.37,-8,-9.12,-9.74,-9.86,-9.86,-9.75,-9.65,-9.62,-9.60,-9.63,-9.63,-9.62,-9.37,-8.77,-7.87,-6.68,-5.26,-4.50,-4.01,-3.77,-3.50,-3.25,-2.93,-2.75,-2.65,-2.75,-3.29,-3.65,-4.13,-4.28,-4.63,-5.14,-5.79,-6.37,-6.75,-6.88,-7,-7.29,-8.01,-9.28,-9.93,-9.78,-9.50,-9.17,-9.25,-9.63,-10,-10,-11,-11,-12,-12,-13,-13,-12,-12,-11,-10,-9.37,-8.38,-7.39,-6.67,-4.85,-3.11,-1.25,0.12,0.96,1.62,2.37,3.25,4.37,5.36,6.25,6.87,7.50,7.87,8,8,8,8,8,8,8,7,6,6,5,4,3.75,3.63,1.88,0.84,-0.50,-1.50,-2.88,-4.42,-7.13,-7.88,-8.26,-8.93,-9.50,-9.78,-9.63,-8.88,-7.66,-6.13,-4.49,-2.86,-1.38,-0.13,0.62,0.82,0.88,1,1.37,2.08,2.96,3.84,4.61,5.27,5.88,6.52,7.22,7.87,8.59,9.25,10,10.76,11.45,11.85,12.13,12.46,12.77,13.27,13.89,14.60,15.22,15.65,16.01,16.37,16.70,17.07,17.45,17.90,18.02,17.76,17.07,16.21,15.35,14.57,14.07,13.82,13.88,14.34,14.88,15.50,16,16.25,16.07,15.50,14.85,14.26,13.89,13.75,13.75,13.98,14.22,14.33,14.13,13.72,13.01,12.25,11.50,10.86,10.32,9.87,9.62,9.50,9.61,9.87,10.32,10.87,11.57,12.24,13.12,13.98,14.62,15.32,15.75,16.32,16.39,16.33,16.11,16,15.87,15.76,15,14,14,13,13,12,12,12,12,12,12,12,12,13,12.87,13.11,13.26,13.75,13.63,13.11,12.40,12.11,12.12,12.49,13.24,14.27,15.52,16.75,17.87,18.85,19.63,20.40,20.51,19.98,18.75,17.45,16.24,15.35,14.65,14.24,14,14,14.32,14.87,15.73,16.86,18.12,19.64,19.85,18.99,-8.25,-9,-9.75,-10,-10,-10,-10,-10,-10,-11,-11,-10,-7.75,-5.38,-2.13,-1.50,-1.40,-1.38,-1.38,-1.29,-4.13,-7.26,-12,-15,-14,-13,-12,-10,-10,-9.73,-9.38,-9.17,-9.13,-9.13,-9.13,-9.18,-9.25,-9.29,-9.27,-9.17,-9,-8.88,-8.38,-8.13,-7.75,-7.16,-6.38,-5.88,-5.88,-4.88,-4.39,-4,-3.63,-3.13,-2.50,-1.77,-1.12,-0.67,-0.63,-0.55,-0.62,-0.86,-0.88,-0.92,-0.98,-1.23,-1.40,-1.38,-1,-0.29,-0.53,-2.02,-4.73,-6.76,-8.24,-9.15,-9.64,-9.75,-9.74,-9.63,-9.50,-9.38,-9.28,-9.26,-9.25,-9.18,-9.02,-8.73,-8.25,-7.64,-7.23,-6.64,-6.24,-5.88,-5.60,-5.29,-5,-4.80,-4.85,-5.13,-5.75,-6.38,-6.85,-7.01,-7.13,-7.50,-7.88,-8.30,-8.80,-8.93,-8.49,-8.29,-8.63,-9.13,-9.49,-9.51,-9.38,-9.35,-9.50,-9.93,-10,-11,-11,-11,-12,-12,-12,-12,-12,-11,-10,-9.93,-8.91,-7.80,-6.65,-5.73,-3.63,-1.75,-0.37,0.48,1.12,1.75,2.46,3.22,4.13,5.87,6.09,6.99,7,8,8,8,8,8,8,8,8,7.85,6.75,5.87,5,3.96,3.10,1.87,0.87,0.37,-1.25,-2.89,-4.13,-7.13,-8.41,-8.87,-9.25,-9.63,-10,-10,-10,-9.50,-8.16,-6.51,-4.64,-2.89,-1.28,0.25,0.73,0.87,0.90,1,1.37,2.15,3.33,4.37,5.25,5.99,6.63,7.35,8.08,8.77,9.50,10.23,11,11.84,12.62,13.12,13.49,13.74,14,14.39,14.97,15.60,16.21,16.61,16.87,17.09,17.27,17.51,17.75,18.13,18,17.62,16.87,16.01,15.12,14.32,13.75,13.46,13.51,14,14.61,15.25,15.82,16.13,16.01,15.50,14.87,14.25,13.84,13.62,13.62,13.83,14.10,14.25,14.12,13.63,12.89,12.01,11.12,10.35,9.72,9.26,9.02,9.09,9.36,9.87,10.59,11.37,12.25,13,14,14.86,15.50,16.10,16.39,16.62,16.32,15.87,15.33,14.99,14.63,14.22,13.88,13,12,12,11,11,11,11,11,11,11,11,11,11,11,11,11.88,11.87,11.75,11.25,11.11,11.12,11.33,12.23,13.25,14.51,15.90,17.26,18.47,19.21,19.51,19.75,19.62,18.97,17.88,16.71,15.71,14.89,14.45,14.12,14.13,14.39,14.87,15.61,16.48,17.50,18.64,19.62,20.14,19.87,-8.88,-9.63,-10,-10,-10,-10,-10,-10,-10,-12,-11,-9.75,-7.26,-4.63,-2.03,0.58,0.58,0.60,0.25,-2.13,-3.92,-7.28,-10,-13,-14,-14,-12,-11,-10,-9.77,-9.38,-9.13,-9.03,-9.03,-9.11,-9.16,-9.28,-9.41,-9.52,-9.62,-9.67,-9.75,-9.18,-8.88,-8.63,-8.25,-7.63,-6.76,-6.53,-6,-5.50,-5.12,-4.65,-4.12,-3.42,-2.68,-2.13,-1.86,-1.75,-1.75,-1.86,-2.13,-2.23,-2.25,-2.26,-2.30,-2.38,-2.29,-2,-1.52,-1.88,-3.40,-5.79,-7.61,-8.75,-9.38,-9.73,-9.74,-9.63,-9.50,-9.28,-9.13,-9.02,-8.99,-8.92,-8.88,-8.85,-8.75,-8.62,-8.51,-8.66,-8.35,-8.10,-7.73,-7.38,-7.03,-6.80,-6.63,-6.67,-7.01,-7.67,-8.74,-9.26,-9.38,-9.18,-9.02,-9.25,-9.38,-9.36,-9.14,-8.98,-8.86,-8.88,-9.10,-9.25,-9.38,-9.43,-9.53,-9.76,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.52,-8.53,-7.29,-5.65,-2.91,-1.75,-0.50,0.21,0.72,1.20,1.71,2.33,3.11,4.21,5.87,5.98,6,7,7,7,8,7,8,8,9,8.75,7.75,7,5.87,4.75,3.45,2,0.74,-0.28,-1.25,-2.13,-4.18,-7.25,-10,-9.41,-9.61,-9.85,-10,-10,-11,-11,-10,-8.85,-6.85,-4.85,-2.98,-1.23,0.62,0.86,0.95,0.89,1,1.37,2.37,3.73,5,5.87,6.63,7.37,8.12,8.87,9.62,10.26,10.99,11.75,12.60,13.46,14.12,14.62,14.87,15.10,15.37,15.84,16.37,16.89,17.23,17.37,17.46,17.50,17.59,17.70,17.76,17.59,17.22,16.61,15.77,14.88,14,13.39,13.11,13.22,13.71,14.35,15,15.61,15.97,15.88,15.40,14.77,14.13,13.65,13.45,13.45,13.65,14,14.24,14.13,13.64,12.85,11.83,10.76,9.87,9.20,8.75,8.65,8.88,9.38,10.13,11.10,12.09,13.08,14.09,14.98,15.75,16.27,16.51,16.62,16.39,15.87,15.22,14.40,13.75,13.11,12.62,12,11,11,10,10,9,9,9,9,9,9,9,9,9,9,10,10,10,10,10,10,10,11.09,12.12,13.37,14.84,16.34,17.87,18.96,18.98,18.90,18.95,18.75,18.21,17.25,16.13,15.36,14.77,14.40,14.25,14.46,14.87,15.50,16.27,17.21,18.22,19.24,20.14,20.90,21.70,-9.37,-10,-10,-10,-11,-11,-10,-10,-11,-11,-11,-10,-7.42,-5,-1.91,-0.88,0.45,-0.35,-1.75,-3.25,-5.40,-8,-10,-13,-14,-14,-13,-11,-10,-9.78,-9.26,-9,-8.87,-8.78,-8.79,-8.88,-9,-9.25,-9.50,-9.76,-10,-10,-9.79,-9.50,-9.27,-9.02,-8.63,-8.18,-7.29,-6.88,-6.50,-6.13,-5.67,-5.13,-4.50,-3.88,-3.42,-3.18,-3.13,-3.25,-3.50,-3.75,-3.80,-3.75,-3.65,-3.63,-3.61,-3.51,-3.43,-3.53,-4.02,-5.38,-7.16,-8.99,-9.37,-9.68,-9.85,-9.68,-9.54,-9.38,-9.18,-9.02,-8.91,-8.88,-8.86,-8.85,-8.79,-8.86,-8.90,-9.10,-9.18,-9.18,-9.03,-9,-8.66,-8.38,-8.13,-8.10,-8.13,-8.49,-9.13,-10,-11,-11,-10,-10,-9.75,-9.63,-9.50,-9.36,-9.16,-9.02,-9,-9.02,-9.14,-9.29,-9.50,-9.68,-9.98,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-9.98,-9.24,-8.26,-7,-5.13,-2.26,-0.75,-0.13,0.32,0.74,1.09,1.49,2,2.82,3.87,4.88,6,6,6,7,7,6,7,6.99,7.22,7.50,7.62,7.12,6.25,5.25,4.12,2.82,1.37,-0.14,-1.25,-2.60,-4.26,-6.15,-8.04,-9.26,-9.80,-9.91,-10,-10,-10,-11,-11,-10,-8.93,-6.91,-4.89,-3,-1.15,0.60,0.87,0.88,0.84,0.87,1.25,2.57,4.25,5.60,6.51,7.37,8.21,9,9.75,10.37,11,11.62,12.37,13.12,13.96,14.72,15.37,15.74,15.90,16.12,16.47,16.87,17.25,17.45,17.49,17.40,17.36,17.25,17.22,17.12,17.08,16.84,16.35,15.57,14.62,13.73,13.11,12.76,12.90,13.47,14.12,14.85,15.39,15.74,15.65,15.25,14.61,13.96,13.46,13.21,13.24,13.50,13.97,14.25,14.24,13.73,12.75,11.60,10.40,9.45,8.75,8.48,8.57,8.99,9.65,10.60,11.63,12.82,13.96,15.09,15.86,16.38,16.62,16.39,16.21,15.62,14.87,14,13.12,12.22,11.40,10.87,10.22,10,9,9,9,8,8,8,8,8,8,8,8,8,8,9,9,9,9,10,10,10.99,11.24,12.40,13.71,15.12,16.45,17.75,18.09,18.15,18.12,18.12,18.02,17.61,16.75,15.84,15.15,14.77,14.59,14.60,14.87,15.47,16.25,17.12,18.09,19,19.89,20.76,21.70,22.57,-9.53,-10,-10,-11,-11,-11,-10,-10,-10,-11,-11,-11,-8.64,-5.68,-3.75,-1.63,-2.26,-2.67,-3.52,-4.88,-6.73,-9,-11,-13,-14,-14,-13,-12,-10,-9.52,-9.05,-8.73,-8.50,-8.38,-8.28,-8.25,-8.30,-8.53,-9.05,-9.93,-10,-10,-10,-10,-10,-9.93,-9.75,-9,-8.25,-7.88,-7.53,-7.17,-6.76,-6.28,-5.77,-5.29,-4.93,-4.75,-4.75,-4.88,-5.25,-5.54,-5.63,-5.30,-5.05,-4.88,-4.76,-4.73,-4.75,-5,-5.54,-6.60,-8.25,-9.89,-9.88,-9.98,-9.87,-9.68,-9.50,-9.28,-9.12,-8.92,-8.85,-8.76,-8.77,-8.80,-8.88,-8.92,-9.13,-9.38,-9.55,-9.64,-9.60,-9.41,-9.38,-9.18,-9.05,-9.05,-9.13,-9.42,-9.99,-10,-11,-11,-11,-10,-10,-9.73,-9.62,-9.49,-9.35,-9.13,-9.02,-9.02,-9.13,-9.30,-9.61,-9.85,-10,-10,-10,-10,-10,-10,-11,-11,-10,-10,-10,-10,-9.65,-9.05,-8.25,-7.05,-5.35,-2.88,-1.27,-0.38,0.25,0.70,0.84,1.10,1.60,2.25,3.20,4.87,5,6,5.99,5.96,5.22,5.25,5.46,5.75,5.97,6.12,6.12,5.85,5.24,4.50,3.38,2.23,0.87,-0.53,-2.12,-3.77,-5.63,-7.43,-8.85,-9.63,-9.99,-10,-10,-10,-10,-10,-10,-10,-8.63,-6.76,-4.86,-2.92,-1.14,0.58,0.87,0.83,0.63,0.32,1.08,2.39,4.38,6.13,7.12,8.12,9.11,10,10.62,11.14,11.70,12.24,12.87,13.59,14.37,15.12,15.75,16.23,16.46,16.59,16.75,16.99,17.15,17.25,17.21,17.07,16.87,16.64,16.50,16.47,16.52,16.51,16.12,15.37,14.40,13.46,12.83,12.50,12.64,13.25,13.97,14.70,15.25,15.50,15.45,15,14.35,13.65,13.13,12.87,12.98,13.36,13.87,14.35,14.37,13.75,12.60,11.25,10,9,8.38,8.26,8.51,9.11,9.96,11,12.15,13.40,14.59,15.86,16.27,16.62,16.38,15.87,15.21,14.39,13.51,12.52,11.40,10.52,9.75,9.33,8.87,8,8,8,8,7,7,7,7,7,7,7,7,7,8,8,8,9,9,10,10,11,11.82,12.74,13.87,15.12,16.10,16.98,17.12,17.21,17.25,17.38,17.45,17.11,16.37,15.62,15.12,14.87,14.84,14.98,15.37,16.10,17,18.02,19.07,19.86,20.51,21.23,21.87,22.40,-9.53,-10,-10,-11,-11,-11,-10,-10,-10,-10,-12,-12,-10,-8.10,-6.53,-5.63,-5.25,-5.40,-5.91,-6.88,-8.25,-9.92,-11,-13,-14,-14,-13,-11,-10,-9.35,-8.67,-8.28,-8.03,-7.87,-7.63,-7.39,-7.25,-7.27,-7.80,-8.63,-9.28,-9.66,-10,-10,-11,-10,-9.89,-9.17,-9,-8.68,-8.42,-8.15,-7.79,-7.39,-7,-6.55,-6.25,-6.10,-6.05,-6.26,-6.80,-7,-6.75,-6.51,-6.25,-6.03,-5.88,-5.77,-5.80,-6.03,-6.51,-7.30,-8.36,-9.50,-9.98,-10,-9.86,-9.65,-9.43,-9.25,-9.02,-8.88,-8.77,-8.75,-8.77,-8.88,-8.98,-9.10,-9.24,-9.41,-9.63,-9.75,-9.75,-9.74,-9.66,-9.63,-9.63,-9.65,-9.75,-10,-10,-10,-11,-11,-11,-10,-10,-9.75,-9.64,-9.60,-9.50,-9.36,-9.24,-9.17,-9.25,-9.42,-9.74,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.87,-9.50,-9.04,-8.39,-7.50,-6.12,-4.25,-2.75,-1.63,-0.75,-0.13,0.12,0.50,1.10,1.75,2.37,3.23,3.95,4.25,4.25,4.11,3.99,3.97,4.12,4.37,4.62,4.74,4.74,4.50,4,3.37,2.62,1.62,0.50,-0.92,-2.66,-4.63,-6.53,-8.17,-9.27,-9.85,-10,-10,-10,-10,-10,-10,-10,-9.26,-8.02,-6.40,-4.63,-2.86,-1.13,0.58,0.86,0.73,0.32,0.25,0.25,2.25,4.57,6.39,7.73,8.95,10.09,10.89,11.48,11.88,12.25,12.73,13.26,13.96,14.64,15.38,16,16.45,16.62,16.64,16.65,16.71,16.72,16.71,16.62,16.45,16.22,15.95,15.75,15.83,16.07,16.25,16,15.25,14.25,13.25,12.57,12.22,12.37,13,13.76,14.52,15.12,15.36,15.21,14.75,14.09,13.37,12.83,12.51,12.62,13.10,13.74,14.37,14.39,13.60,12.21,10.76,9.50,8.60,8.10,8.12,8.50,9.22,10.14,11.32,12.57,13.76,14.87,15.98,16.20,16.20,15.62,14.99,13.99,12.99,11.87,10.75,9.75,9,8.40,8.11,7.75,7,7,7,7,7,7,7,7,7,7,7,7,7,7.96,8.01,8.07,9,9.90,10.07,10.89,11.26,12.12,12.97,13.87,14.75,15.50,15.97,16.24,16.37,16.60,16.87,17,16.75,16.15,15.57,15.14,15,15.02,15.27,15.82,16.61,17.59,18.70,19.60,20.14,20.51,21,21.57,21.33,-9.38,-10,-10,-10,-11,-11,-10,-10,-9.88,-10,-10,-11,-10,-9.73,-8.87,-8.25,-7.87,-7.74,-7.90,-8.48,-9.38,-10,-11,-13,-13,-13,-12,-11,-9.88,-8.88,-8.23,-7.75,-7.38,-7,-6.51,-5.99,-5.25,-5,-5.29,-5.89,-6.75,-7.76,-9.03,-10,-11,-11,-10,-9.54,-9.42,-9.35,-9.24,-9.03,-8.77,-8.43,-8.03,-7.66,-7.38,-7.17,-7.13,-7.28,-7.51,-7.65,-7.65,-7.50,-7.28,-7.05,-6.88,-6.74,-6.67,-6.85,-7.15,-7.67,-8.38,-9.01,-9.50,-9.74,-9.75,-9.61,-9.38,-9.16,-9,-8.88,-8.79,-8.79,-8.87,-8.93,-9.05,-9.23,-9.36,-9.50,-9.62,-9.75,-9.85,-9.88,-9.89,-9.91,-9.99,-10,-10,-10,-10,-10,-11,-11,-10,-10,-10,-9.85,-9.76,-9.75,-9.65,-9.54,-9.50,-9.49,-9.52,-9.66,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.98,-9.85,-9.66,-9.49,-9.17,-8.78,-8.17,-7.25,-5.63,-4.29,-3.25,-2.26,-1.43,-0.88,-0.16,0.58,1.25,1.82,2.25,2.60,2.75,2.73,2.58,2.50,2.62,2.75,3,3.23,3.25,3.25,3.07,2.73,2.22,1.57,0.96,0,-1.38,-3.25,-5.37,-7.13,-8.53,-9.41,-9.88,-10,-10,-10,-9.91,-9.87,-9.66,-9.36,-8.62,-7.48,-6,-4.38,-2.73,-1.04,0.58,0.86,0.62,0.32,0.09,0.12,1.12,4.25,6.62,8.37,9.62,10.73,11.50,12.01,12.37,12.71,13,13.51,14.15,14.87,15.50,16.09,16.39,16.50,16.37,16.25,16.10,16,15.88,15.83,15.64,15.50,15.24,15.09,15.25,15.62,15.87,15.87,15.21,14.21,13.11,12.33,11.90,12.11,12.75,13.51,14.36,14.96,15.12,14.96,14.47,13.75,13.01,12.38,12.08,12.13,12.63,13.36,14,13.96,12.99,11.52,10.12,8.96,8.12,7.83,8,8.49,9.25,10.25,11.47,12.71,13.87,14.77,15.62,15.50,15.20,14.39,13.62,12.57,11.46,10.35,9.34,8.57,7.87,7.40,7.11,6.87,7,6,6,6,7,7,7,7,7,7,7.01,7.07,7.08,7.88,8.10,8.87,9.11,10.11,10.87,11.22,11.85,12.47,13.13,13.86,14.48,15,15.34,15.50,15.75,16.27,16.71,16.87,16.64,16.14,15.62,15.25,15.12,15.24,15.50,16.01,16.76,17.75,18.73,19.47,19.75,20.12,20.62,21,21.24,-9,-9.66,-10,-10,-10,-10,-10,-9.93,-10,-10,-10,-10,-11,-10,-10,-10,-9.87,-9.52,-9.42,-9.63,-10,-10,-11,-12,-12,-11,-10,-10,-9.04,-8.25,-7.50,-6.98,-6.53,-6.15,-5.39,-4.50,-3.51,-2.67,-2.50,-3,-3.90,-5.38,-7.12,-9.13,-11,-11,-10,-9.87,-9.75,-9.75,-9.76,-9.75,-9.60,-9.29,-8.93,-8.55,-8.25,-8.05,-8,-8.11,-8.25,-8.39,-8.49,-8.43,-8.25,-8,-7.75,-7.52,-7.39,-7.41,-7.63,-7.93,-8.38,-8.88,-9.26,-9.51,-9.62,-9.50,-9.28,-9.13,-9,-8.90,-8.88,-8.90,-9,-9.10,-9.23,-9.38,-9.50,-9.63,-9.75,-9.88,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.93,-9.92,-9.90,-9.88,-9.79,-9.75,-9.75,-9.77,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.90,-9.86,-9.76,-9.74,-9.63,-9.48,-9.18,-9.18,-8.02,-6.75,-5.65,-4.75,-4,-3.13,-2.13,-1,0.11,0.87,1.25,1.50,1.57,1.49,1.32,1.12,1.08,1.12,1.33,1.50,1.61,1.75,1.71,1.57,1.25,0.87,0.35,-0.05,-0.92,-2.29,-4.13,-6.13,-7.67,-8.80,-9.50,-9.86,-9.91,-9.88,-9.76,-9.63,-9.48,-9.24,-8.75,-8.01,-6.98,-5.63,-4.13,-2.60,-1,0.60,0.87,0.62,0.25,0.07,0.12,1,4.11,7.75,8.75,9.86,10.85,11.37,11.84,12.20,12.50,12.85,13.33,13.99,14.62,15.24,15.75,16,16,15.82,15.52,15.26,15.10,14.99,14.88,14.86,14.70,14.50,14.52,14.77,15.22,15.51,15.62,15.14,14.13,12.98,12.09,11.62,11.75,12.37,13.13,14,14.59,14.76,14.60,14.09,13.37,12.61,11.87,11.50,11.52,12,12.63,13.23,13.02,12,10.71,9.37,8.34,7.74,7.62,7.87,8.47,9.25,10.34,11.50,12.74,13.84,14.62,15.09,14.75,14.09,13.24,12.33,11.24,10.12,9,8.12,7.46,7,6.70,6.48,6.37,6.01,6.01,6,7,7,8,8,8,8.01,8.07,8.09,8.10,8.11,8.12,8.86,9.12,9.99,10.85,11.12,11.75,12.25,12.85,13.39,13.98,14.39,14.75,15.15,15.40,15.87,16.39,16.84,17,16.82,16.37,15.87,15.50,15.35,15.38,15.63,16.11,16.71,17.37,18.07,18.62,19.12,19.62,20.25,20.76,20.14,-8.92,-9.50,-9.76,-9.91,-10,-9.98,-9.90,-9.90,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.55,-8.75,-7.88,-7.42,-6.54,-5.89,-5.63,-5.50,-5.25,-3.75,-2.27,-1,-0.29,-0.50,-1.37,-2.77,-4.88,-7.18,-9.30,-10,-10,-9.88,-9.88,-9.99,-10,-10,-10,-9.88,-9.55,-9.18,-8.90,-8.74,-8.65,-8.75,-8.91,-9.13,-9.26,-9.27,-9.16,-8.89,-8.60,-8.26,-8.02,-7.88,-7.93,-8.13,-8.38,-8.75,-9.14,-9.37,-9.43,-9.36,-9.17,-9.10,-9.02,-9.01,-9.03,-9.11,-9.15,-9.25,-9.38,-9.54,-9.68,-9.88,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.98,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.92,-9.99,-10,-10,-10,-10,-10,-9.93,-9.75,-9.29,-8.61,-7.65,-6.88,-6.05,-5.38,-4.53,-3.26,-1.75,-0.25,0.50,0.85,0.97,0.87,0.50,0,-0.37,-0.50,-0.50,-0.38,-0.25,-0.15,0,-0.01,-0.13,-0.38,-0.75,-1.37,-1.75,-2.68,-4,-5.51,-7.13,-8.29,-9.13,-9.55,-9.75,-9.75,-9.66,-9.51,-9.37,-9.13,-8.80,-8.35,-7.63,-6.62,-5.38,-3.99,-2.50,-0.98,0.62,0.87,0.63,0.25,0,0.09,1,5,7.90,8.87,9.75,10.60,10.87,11.09,11.27,11.62,12.09,12.62,13.25,13.83,14.37,14.87,15.14,15.21,15,14.64,14.35,14.12,14,13.98,13.90,13.87,13.87,14,14.37,14.84,15.20,15.32,14.87,14,12.75,11.82,11.25,11.34,11.87,12.62,13.38,14,14.22,14,13.50,12.83,12,11.26,10.82,10.86,11.25,11.83,12.12,11.87,11,9.83,8.62,7.74,7.37,7.45,7.82,8.46,9.32,10.37,11.58,12.75,13.75,14.40,14.75,14.09,13.22,12.12,11.12,10,9,8.01,7.25,6.73,6.50,6.27,6.20,6.20,6.09,6.88,7.07,7.95,8.01,8.98,9,9.01,9.89,9.87,9.87,9.86,9.12,9.12,9.14,9.86,10.82,11.15,11.82,12.25,12.76,13.27,13.77,14.26,14.74,15.12,15.59,16,16.47,16.89,17.25,17.37,17.21,16.75,16.25,15.87,15.65,15.65,15.85,16.12,16.50,16.96,17.40,17.95,18.50,19.33,20.22,21,21.09,-8.88,-9.27,-9.61,-9.75,-9.77,-9.78,-9.79,-9.88,-10,-10,-10,-11,-11,-11,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.76,-9.38,-8.76,-8,-7.23,-6.38,-5.66,-4.75,-4,-3.75,-4.63,-5,-2.78,-1.51,-0.27,0.48,0.32,-0.38,-1.53,-3.25,-5.41,-7.41,-9.12,-9.89,-9.66,-9.79,-9.99,-10,-10,-10,-10,-9.80,-9.50,-9.26,-9.13,-9.13,-9.25,-9.48,-9.76,-10,-10,-10,-9.75,-9.35,-8.91,-8.55,-8.29,-8.25,-8.27,-8.40,-8.67,-9,-9.15,-9.25,-9.14,-9.04,-9.04,-9.13,-9.23,-9.27,-9.37,-9.40,-9.50,-9.63,-9.79,-9.99,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.93,-9.38,-8.74,-8,-7.13,-6.38,-5.50,-4.10,-2.40,-0.88,-0.11,0.37,0.50,0.25,-0.38,-1.16,-1.88,-2.26,-2.38,-2.38,-2.28,-2.18,-2.01,-2.02,-2.14,-2.40,-2.87,-3.50,-4.13,-5.13,-6.25,-7.39,-8.38,-9.02,-9.41,-9.63,-9.66,-9.62,-9.48,-9.26,-9.10,-8.85,-8.50,-8.01,-7.30,-6.38,-5.16,-3.87,-2.42,-1,0.63,0.87,0.75,0.20,0.12,0,2,5,8,9,9.11,9.76,10,10,10.11,10.40,11,11.62,12.14,12.64,13.14,13.62,13.97,14.07,13.88,13.62,13.33,13.09,12.99,12.99,13,13.07,13.23,13.57,14,14.50,14.84,14.88,14.50,13.60,12.48,11.50,10.89,10.86,11.32,11.95,12.62,13.21,13.40,13.25,12.74,12.09,11.36,10.62,10.12,10.15,10.52,10.98,11.14,10.87,10.09,9,8,7.25,7.07,7.25,7.75,8.47,9.37,10.47,11.62,12.75,13.60,14.26,14.27,13.50,12.50,11.35,10.23,9.02,8.07,7.15,6.60,6.25,6.15,6.21,6.32,6.39,7.11,7.87,8.11,8.88,9.08,9.89,10,10.09,10.87,10.98,10.97,10.83,10.15,9.83,9.82,10.22,10.86,11.75,12.22,12.84,13.35,13.82,14.27,14.77,15.32,15.83,16.34,16.83,17.26,17.64,17.97,18,17.75,17.35,16.84,16.39,16.14,16.10,16.12,16.25,16.49,16.74,17,17.50,18.25,19.23,20.32,21.37,22.01,-8.63,-9.12,-9.38,-9.54,-9.63,-9.65,-9.75,-9.88,-10,-10,-10,-11,-11,-12,-12,-12,-12,-12,-11,-10,-10,-9.79,-9.17,-8.55,-7.92,-7.23,-6.38,-5.52,-4.63,-3.67,-2.68,-2,-1.75,-1.63,-1.93,-1.63,-0.80,-0.13,0.61,0.37,-0.25,-1.14,-2.50,-4.13,-5.92,-7.50,-8.80,-9.16,-9.50,-9.77,-10,-10,-10,-10,-9.79,-9.63,-9.43,-9.38,-9.41,-9.61,-9.88,-10,-10,-10,-10,-10,-10,-9.50,-9.03,-8.66,-8.49,-8.38,-8.40,-8.61,-8.79,-8.91,-8.98,-8.88,-8.88,-9.02,-9.25,-9.50,-9.63,-9.66,-9.73,-9.76,-9.89,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.92,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-10,-10,-9.80,-9.25,-8.38,-7.63,-6.75,-5.13,-3,-1.13,-0.50,-0.16,-0.10,-0.48,-1.27,-2.40,-3.60,-4.25,-4.52,-4.63,-4.51,-4.38,-4.26,-4.25,-4.37,-4.64,-5.16,-5.88,-6.64,-7.54,-8.53,-9.38,-10,-9.75,-9.67,-9.66,-9.60,-9.41,-9.24,-9.01,-8.79,-8.61,-8.28,-7.86,-7.14,-6.23,-5.04,-3.75,-2.39,-1.02,0.20,0.75,0.71,0.50,0.50,1,2,5,7,8,9,9,9,9,9,9.25,9.85,10.49,10.95,11.35,11.75,12.22,12.52,12.72,12.65,12.50,12.22,12.08,12,12.10,12.22,12.37,12.74,13.25,13.75,14.23,14.48,14.37,13.96,13.12,12.08,11.08,10.50,10.37,10.62,11.12,11.73,12.23,12.39,12.25,11.76,11.14,10.51,9.89,9.59,9.59,9.87,10.25,10.37,10.07,9.34,8.37,7.48,6.87,6.83,7.12,7.72,8.49,9.40,10.50,11.72,12.70,13.26,13.74,13.39,12.62,11.72,10.50,9.35,8.11,7.14,6.38,6,5.97,6.13,6.38,6.73,7.25,7.87,8.85,9.12,9.87,10.12,10.87,11,11.12,11.84,12.11,12.10,11.76,11.11,10.23,10.14,10.25,11,11.85,12.75,13.37,13.87,14.37,14.87,15.40,16,16.59,17.13,17.71,18.14,18.52,18.75,18.75,18.49,18,17.50,17.09,16.76,16.62,16.62,16.64,16.75,16.87,17.11,17.50,18.25,19.26,20.40,21.60,21.87,-8.53,-9,-9.25,-9.38,-9.49,-9.51,-9.63,-9.79,-10,-10,-10,-11,-11,-12,-12,-12,-12,-12,-11,-10,-9.88,-9.01,-8.13,-7.35,-6.50,-5.66,-4.79,-3.87,-2.92,-1.87,-1.14,-0.50,-0.13,0.11,-0.38,-0.43,-0.16,0.24,0.57,0.37,-0.13,-0.88,-1.89,-3.25,-4.75,-6.25,-7.67,-8.43,-9,-9.39,-9.67,-9.86,-9.86,-9.79,-9.74,-9.63,-9.53,-9.53,-9.63,-9.85,-10,-10,-10,-11,-11,-11,-10,-10,-9.48,-9,-8.65,-8.42,-8.35,-8.37,-8.65,-8.50,-8.43,-8.43,-8.63,-9,-9.41,-9.78,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.93,-9.93,-9.93,-9.93,-9.93,-9.93,-9.99,-10,-10,-10,-10,-10,-11,-11,-11,-12,-11,-11,-11,-10,-10,-9.73,-8.88,-7.79,-5.87,-3.15,-1.92,-1.39,-1.11,-1,-1.49,-2.50,-3.86,-5,-6.16,-6.73,-6.53,-6.48,-6.26,-6.13,-6.11,-6.18,-6.55,-7.13,-7.88,-9.01,-9.87,-10,-10,-11,-10,-9.88,-9.73,-9.50,-9.25,-8.98,-8.74,-8.52,-8.38,-8.17,-7.80,-7.15,-6.23,-5,-3.68,-2.37,-1.03,0.23,0.87,0.83,0.75,0.87,1.46,2.25,5,6,7,8,8,8,8,8,8,9,9.26,9.64,10,10.37,10.75,11.12,11.34,11.33,11.24,11.12,11.12,11.20,11.36,11.63,12,12.59,13.12,13.62,13.97,14.08,13.95,13.39,12.62,11.62,10.65,10.08,9.85,9.97,10.25,10.70,11.08,11.24,11.11,10.65,10.12,9.58,9.12,8.90,9,9.35,9.64,9.75,9.39,8.73,7.84,7.07,6.61,6.62,7.07,7.70,8.50,9.46,10.51,11.62,12.48,12.84,12.74,12.08,11.38,10.60,9.51,8.37,7.22,6.37,5.86,5.70,5.88,6.33,6.82,7.35,7.98,8.77,9.15,10.11,10.84,11.15,11.75,12,12.22,12.87,13.75,13.20,12.75,11.96,11.12,10.25,10.25,11.12,11.99,12.86,13.63,14.33,14.89,15.50,16.12,16.75,17.37,18,18.62,19.11,19.48,19.62,19.58,19.25,18.75,18.25,17.83,17.50,17.33,17.25,17.27,17.37,17.46,17.60,17.87,18.50,19.47,20.50,21.51,21.63,-8.65,-9,-9.23,-9.29,-9.37,-9.39,-9.50,-9.68,-10,-10,-10,-11,-11,-11,-12,-12,-11,-11,-10,-9.98,-8.99,-8,-7,-6.05,-5.13,-4.25,-3.29,-2.27,-1.25,-0.50,-0.16,0.24,0.62,0.50,0.49,0.32,0.36,0.50,0.62,0.48,0.08,-0.54,-1.39,-2.50,-3.76,-5.17,-6.63,-7.63,-8.38,-8.89,-9.26,-9.43,-9.61,-9.63,-9.63,-9.62,-9.61,-9.63,-9.75,-9.99,-10,-10,-11,-11,-11,-11,-10,-10,-9.76,-9.25,-8.75,-8.35,-8.02,-7.87,-8,-7.68,-7.63,-7.75,-8.13,-8.75,-9.48,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.98,-9.80,-9.74,-9.75,-9.76,-9.78,-9.86,-9.89,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-8.79,-6.88,-5.11,-3.60,-3.01,-2.73,-2.63,-3.13,-4.16,-5.42,-6.60,-7.52,-8.03,-8.24,-8.13,-7.90,-7.73,-7.61,-7.64,-8,-8.50,-9.23,-10,-11,-11,-12,-11,-10,-9.74,-9.48,-9.16,-8.89,-8.63,-8.38,-8.26,-8.18,-8.05,-7.75,-7.14,-6.17,-4.93,-3.63,-2.38,-1.04,0.25,0.87,0.88,0.88,1.13,1.75,2.87,4,5,6,6,7,7,7,7,7,8,8.12,8.36,8.71,9.07,9.37,9.62,9.87,9.99,9.99,10.22,10.34,10.62,10.87,11.40,12,12.61,13.15,13.50,13.64,13.62,13.37,12.86,12.12,11.23,10.34,9.61,9.35,9.25,9.37,9.61,9.84,9.90,9.82,9.49,9,8.57,8.25,8.25,8.50,8.88,9.23,9.25,8.87,8.21,7.36,6.63,6.33,6.50,6.99,7.63,8.47,9.37,10.39,11.33,11.85,11.84,11.33,10.58,9.87,9.20,8.35,7.37,6.39,5.84,5.46,5.52,5.98,6.65,7.34,7.99,8.65,9.23,10.12,10.98,11.75,12.25,12.74,13.10,13.25,13.99,14.74,14.11,13.75,12.73,11.76,11.12,10.96,11.25,12,12.95,13.85,14.64,15.39,16.12,16.77,17.50,18.20,18.87,19.50,20.08,20.40,20.50,20.33,19.98,19.49,19,18.52,18.23,18,17.98,18,18.11,18.15,18.25,18.50,19,19.75,20.57,21.23,21.50,-8.75,-9.10,-9.25,-9.28,-9.27,-9.28,-9.38,-9.60,-9.87,-10,-10,-10,-10,-11,-11,-11,-10,-10,-9.68,-8.73,-7.75,-6.74,-5.75,-4.80,-3.87,-2.91,-1.99,-0.98,0,0.25,0.46,0.62,0.75,0.75,0.75,0.72,0.70,0.72,0.75,0.58,0.25,-0.26,-1,-1.88,-3,-4.28,-5.63,-6.75,-7.65,-8.36,-8.77,-9.13,-9.38,-9.53,-9.63,-9.67,-9.74,-9.77,-9.88,-10,-10,-10,-10,-11,-11,-11,-11,-10,-9.93,-9.38,-8.67,-8,-7.48,-6.92,-6.77,-6.43,-6.38,-6.65,-7.25,-8.13,-9.15,-9.93,-10,-10,-10,-10,-10,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.92,-9.77,-9.65,-9.63,-9.62,-9.63,-9.66,-9.75,-9.87,-9.99,-10,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-12,-12,-11,-11,-10,-9.48,-8.10,-6.75,-5.76,-5.16,-4.88,-4.79,-5.25,-6.14,-7.13,-8.14,-8.93,-9.43,-9.63,-9.50,-9.17,-8.88,-8.61,-8.50,-8.65,-9.05,-9.66,-10,-11,-11,-11,-11,-10,-9.54,-9.18,-8.88,-8.54,-8.38,-8.25,-8.15,-8.13,-8,-7.73,-7.11,-6.13,-4.88,-3.55,-2.16,-1,-0.25,0.12,0.33,0.47,0.75,1.36,2.12,3.09,4,5,5,6,6,6,6,6,7,7,7.24,7.59,7.89,8.14,8.26,8.50,8.87,9.22,9.60,9.87,10.37,10.87,11.47,12.11,12.72,13.15,13.37,13.34,13.12,12.75,12.26,11.62,10.86,10.01,9.33,8.86,8.52,8.47,8.50,8.58,8.61,8.50,8.25,7.95,7.62,7.47,7.72,8.12,8.59,8.87,8.85,8.40,7.64,6.86,6.24,6.02,6.35,6.87,7.60,8.37,9.20,10.01,10.63,10.87,10.39,9.87,9.12,8.52,7.88,7.15,6.40,5.75,5.47,5.37,5.63,6.33,7.13,7.96,8.65,9.34,10.20,11.07,11.97,12.72,13.25,13.73,14.15,14.64,15.07,15.27,15.07,14.25,13.26,12.26,11.75,11.32,11.32,12.01,12.99,13.98,14.90,15.85,16.65,17.46,18.20,18.90,19.64,20.37,21,21.33,21.27,21,20.61,20.12,19.63,19.24,18.88,18.65,18.60,18.62,18.74,18.86,18.99,19.22,19.61,20.15,20.72,20.95,19.37,-9,-9.26,-9.38,-9.38,-9.26,-9.25,-9.28,-9.50,-9.75,-9.90,-10,-9.93,-9.88,-9.79,-9.88,-9.63,-9.24,-8.76,-8,-7.13,-6.25,-5.36,-4.50,-3.63,-2.73,-1.79,-0.76,0.25,0.57,0.70,0.75,0.85,0.87,0.87,0.88,0.87,0.87,0.87,0.83,0.62,0.37,-0.04,-0.65,-1.43,-2.41,-3.53,-4.75,-5.89,-6.92,-7.76,-8.38,-8.88,-9.25,-9.50,-9.65,-9.75,-9.86,-9.89,-10,-10,-10,-10,-10,-10,-11,-10,-10,-10,-9.99,-9.27,-8.40,-7.50,-6.50,-5.63,-4.99,-4.66,-4.75,-5.17,-5.92,-6.99,-8.13,-9.10,-9.65,-9.92,-10,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-13,-12,-13,-12,-11,-10,-10,-10,-10,-10,-10,-10,-10,-9.87,-9.74,-9.62,-9.52,-9.50,-9.50,-9.51,-9.62,-9.68,-9.80,-9.98,-10,-10,-10,-11,-11,-12,-12,-13,-13,-13,-13,-12,-12,-11,-11,-10,-9.87,-8.91,-8.14,-7.63,-7.36,-7.18,-7.18,-7.50,-8.05,-8.89,-9.79,-10,-10,-10,-10,-10,-9.66,-9.26,-9.03,-9.04,-9.36,-9.86,-10,-10,-11,-11,-10,-10,-9.50,-9.10,-8.74,-8.49,-8.25,-8.15,-8.16,-8.17,-8.12,-7.78,-7.15,-6.13,-4.75,-3.27,-1.75,-0.88,-0.38,-0.30,-0.28,-0.18,0.11,0.61,1.32,2.12,3.07,3.75,4,5,5,5,5,6,6,6.09,6.32,6.70,7.02,7.25,7.37,7.62,8.21,8.75,9.37,9.87,10.40,11.02,11.70,12.26,12.76,13.09,13.12,12.98,12.65,12.25,11.75,11.14,10.49,9.73,8.99,8.35,7.89,7.62,7.45,7.37,7.34,7.25,7.12,7,6.97,7,7.37,7.87,8.34,8.52,8.40,7.86,7.07,6.32,5.76,5.75,6.13,6.75,7.47,8.21,8.88,9.50,9.73,9.37,8.82,8.34,7.84,7.32,6.73,6.14,5.70,5.37,5.36,5.50,6,6.75,7.71,8.61,9.45,10.25,11.25,12.25,13.08,13.72,14.27,14.82,15.34,15.75,16.08,16.62,16.63,14.98,13.82,12.87,12.21,11.65,11.34,12.02,13,14.02,15.12,16.20,17.13,18,18.77,19.59,20.36,21.10,21.83,22.12,21.95,21.50,21.07,20.62,20.14,19.75,19.40,19.12,18.98,18.95,19.07,19.25,19.50,19.87,20.27,20.75,21.11,20.99,19.25,-9.38,-9.50,-9.55,-9.50,-9.30,-9.24,-9.26,-9.48,-9.63,-9.63,-9.38,-9,-8.62,-8.26,-8.02,-7.74,-7.35,-6.86,-6.18,-5.50,-4.75,-3.99,-3.28,-2.61,-1.77,-0.88,0,0.73,0.85,0.87,0.99,1,1.10,1.08,0.99,0.98,0.97,0.96,0.87,0.72,0.47,0.08,-0.50,-1.14,-2,-2.93,-3.92,-5.13,-6.24,-7.25,-8,-8.63,-9.13,-9.48,-9.73,-9.88,-9.93,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.74,-8.88,-7.80,-6.75,-5.53,-3.50,-2.93,-2.51,-2.63,-3.39,-4.17,-5.18,-6.38,-7.50,-8.48,-9.18,-9.87,-10,-11,-11,-12,-12,-12,-13,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-10,-10,-10,-10,-9.98,-9.85,-9.73,-9.63,-9.53,-9.50,-9.41,-9.41,-9.41,-9.43,-9.50,-9.61,-9.67,-9.80,-9.93,-10,-10,-10,-11,-11,-12,-12,-12,-13,-13,-12,-12,-11,-11,-10,-10,-9.75,-9.30,-9.05,-9.04,-9.25,-9.38,-9.38,-9.38,-9.78,-10,-11,-11,-12,-11,-11,-10,-10,-9.66,-9.29,-9.16,-9.42,-9.87,-10,-10,-10,-10,-10,-10,-9.53,-9.02,-8.87,-8.67,-8.63,-8.61,-8.53,-8.43,-8.24,-7.76,-7,-5.88,-4.48,-2.64,-1.50,-0.75,-0.50,-0.75,-0.89,-0.93,-0.75,-0.25,0.37,1.32,2.25,3.07,3.83,4,4,5,5,5,5,5,5.75,6,6.46,6.83,7.14,7.50,8.14,8.82,9.40,10,10.61,11.21,11.87,12.51,12.75,12.87,12.82,12.60,12.25,11.83,11.33,10.73,10.07,9.34,8.60,7.87,7.27,6.87,6.52,6.35,6.21,6.12,6.10,6.22,6.45,6.75,7.14,7.62,8,8.11,7.75,7.08,6.35,5.73,5.37,5.50,5.95,6.52,7.24,7.95,8.50,8.89,8.86,8.12,7.50,7.10,6.71,6.27,5.83,5.47,5.25,5.25,5.47,5.87,6.50,7.38,8.37,9.36,10.37,11.33,12.64,13.64,14.26,14.87,15.39,15.96,16.58,16.82,17.01,17.09,16.62,15.62,14.34,13.34,12.63,11.88,11.36,12.07,13,14.11,15.25,16.38,17.50,18.40,19.25,20.10,20.87,21.62,22.35,22.51,22.25,21.75,21.24,20.82,20.38,20.01,19.64,19.32,19.01,18.97,19.11,19.40,19.87,20.45,21,21.50,21.75,21.60,20.21,-9.68,-9.76,-9.75,-9.61,-9.38,-9.24,-9.25,-9.38,-9.50,-9.25,-8.54,-7.75,-7.10,-6.53,-6.12,-5.78,-5.43,-4.98,-4.43,-3.88,-3.38,-2.79,-2.29,-1.67,-1.12,-0.41,0.23,0.86,0.98,1,1.12,1.25,1.35,1.36,1.10,1,1,1,0.95,0.75,0.50,0.12,-0.38,-0.93,-1.63,-2.40,-3.38,-4.38,-5.51,-6.64,-7.66,-8.38,-8.93,-9.42,-9.77,-9.99,-10,-10,-10,-10,-10,-9.98,-9.93,-9.99,-10,-10,-10,-9.73,-9.26,-7.80,-6.39,-6.51,-4.63,-2.55,-0.87,-0.79,-0.79,-1.41,-2.15,-2.89,-4.13,-5.55,-7,-8.29,-9.48,-10,-11,-12,-12,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-10,-9.75,-9.63,-9.50,-9.38,-9.27,-9.25,-9.25,-9.25,-9.25,-9.26,-9.36,-9.38,-9.48,-9.52,-9.63,-9.75,-9.86,-9.93,-10,-10,-10,-10,-11,-11,-12,-12,-12,-12,-11,-11,-10,-10,-9.78,-9.50,-9.27,-9.18,-9.38,-9.78,-10,-11,-11,-10,-11,-11,-12,-13,-13,-12,-12,-11,-10,-9.87,-9.38,-9.25,-9.43,-9.86,-10,-10,-10,-10,-10,-10,-9.74,-9.36,-9.13,-9.13,-9.15,-9.16,-9.11,-8.88,-8.50,-7.88,-6.99,-5.78,-4.29,-2.63,-1.75,-1,-0.87,-1.25,-1.63,-1.75,-1.55,-1.13,-0.25,0.75,1.75,2.60,3.08,3,4,4,4,4,4,5,5,5.32,6.08,6.62,7.13,7.71,8.25,8.96,9.60,10.23,10.64,11.22,11.75,12.32,12.51,12.51,12.40,12.12,11.75,11.37,10.87,10.25,9.61,8.86,8.12,7.37,6.76,6.25,5.84,5.46,5.22,5.20,5.27,5.62,6.01,6.49,6.87,7.23,7.50,7.38,6.88,6.22,5.52,5.11,4.99,5.15,5.62,6.24,6.87,7.50,8.12,8.25,7.86,7,6.37,6,5.75,5.38,5.07,4.95,5,5.33,5.75,6.39,7.25,8.22,9.25,10.27,11.37,12.75,14.60,14.95,15.51,16,16.50,17.02,17.50,17.87,17.90,17.74,17.59,16,14.84,13.75,12.87,12.12,11.36,12.14,13.07,14.12,15.26,16.50,17.62,18.65,19.60,20.45,21.23,21.95,22.46,22.49,22.10,21.57,21.01,20.61,20.24,19.87,19.50,19.12,18.84,18.74,18.95,19.40,20.12,20.89,21.63,22.25,22.61,22.49,21.12,-9.75,-9.87,-9.88,-9.63,-9.38,-9.15,-9.11,-9.13,-9.01,-8.37,-7.25,-6.13,-5.29,-4.68,-4.25,-4,-3.68,-3.26,-2.88,-2.50,-2.13,-1.86,-1.50,-1.13,-0.63,-0.13,0.37,0.87,1,1.12,1.37,1.61,1.74,1.75,2,1,1.09,1.22,1.08,0.87,0.62,0.25,-0.18,-0.75,-1.38,-2.04,-2.88,-3.75,-4.68,-6,-7.25,-8.02,-8.75,-9.38,-9.85,-10,-10,-10,-10,-9.98,-9.85,-9.73,-9.61,-9.50,-9.39,-9.39,-9.38,-9,-8.66,-6.38,-3.02,-3.29,-2.39,-1.26,-0.25,0.24,0.13,-0.05,-0.30,-0.38,-1.76,-3,-5.37,-7.29,-9.13,-10,-11,-12,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-9.92,-9.50,-9.25,-9.02,-8.92,-8.86,-8.75,-8.78,-8.89,-9,-9.05,-9.14,-9.28,-9.39,-9.50,-9.63,-9.74,-9.79,-9.88,-9.98,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-9.93,-9.49,-9.10,-8.86,-8.66,-8.61,-8.65,-9.02,-9.74,-10,-11,-11,-11,-11,-12,-14,-14,-13,-12,-12,-11,-10,-9.79,-9.29,-9.25,-9.50,-9.89,-10,-10,-10,-10,-10,-10,-9.89,-9.63,-9.53,-9.63,-9.80,-9.92,-9.77,-9.39,-8.88,-8.12,-7.13,-5.91,-4.61,-3.18,-2.50,-1.90,-1.75,-2.04,-2.50,-2.63,-2.38,-1.75,-0.77,0.32,1.25,2,2.37,3,3,3,3,3,4,4,4,4.87,5.75,6.50,7.25,7.75,8.36,9,9.65,10.23,10.46,10.75,11.11,11.52,11.75,11.87,11.75,11.45,11.11,10.75,10.34,9.75,9.07,8.36,7.60,6.87,6.24,5.62,5.12,4.74,4.25,4.37,4.73,5.14,5.63,6.12,6.46,6.64,6.75,6.50,5.89,5.27,4.74,4.47,4.50,4.76,5.24,5.77,6.37,6.99,7.26,7.15,6.75,6.01,5.37,5.02,4.89,4.74,4.62,4.74,5.02,5.50,6.15,7.02,8.07,9.13,10.25,11.37,12.47,13.86,15.52,16,16.62,17.12,17.57,18,18.39,18.65,19.47,18.15,17.50,16.35,15.13,14.11,13.12,12.36,12,12.26,13.08,14.11,15.25,16.48,17.63,18.75,19.75,20.62,21.34,21.89,22.12,22,21.52,20.99,20.46,20,19.62,19.26,18.98,18.63,18.40,18.40,18.75,19.40,20.33,21.27,22.22,22.99,23.47,23.37,22.12,-9.54,-9.79,-9.86,-9.63,-9.36,-9.02,-8.75,-8.50,-7.89,-6.73,-5.26,-4.13,-3.30,-2.75,-2.54,-2.38,-2.14,-1.89,-1.63,-1.26,-1.13,-1,-0.88,-0.62,-0.25,0.12,0.50,0.87,1.07,1.25,1.62,2,2.25,2.13,2,2,1.98,1.50,1.32,1.08,0.75,0.37,-0.02,-0.51,-1.05,-1.66,-2.38,-3.14,-4,-5.13,-6.50,-7.50,-8.40,-9.25,-9.80,-10,-10,-10,-10,-9.88,-9.66,-9.49,-9.25,-9,-8.78,-8.67,-8.65,-8.17,-7.13,-4.87,-2.25,-0.51,-0.75,-0.25,0.35,0.62,0.75,0.62,0.50,0.22,-0.13,-1.65,-3.43,-6.63,-9.04,-11,-12,-13,-14,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-10,-10,-9.92,-9.38,-8.91,-8.68,-8.53,-8.48,-8.38,-8.35,-8.48,-8.63,-8.78,-8.92,-9.11,-9.27,-9.43,-9.61,-9.74,-9.85,-9.89,-9.99,-10,-10,-10,-10,-10,-10,-11,-10,-10,-10,-9.42,-8.87,-8.36,-8,-7.76,-7.65,-7.63,-7.62,-7.75,-8.13,-8.76,-9.74,-10,-10,-10,-11,-12,-14,-13,-12,-12,-11,-10,-10,-9.55,-9.17,-9.27,-9.63,-10,-10,-10,-10,-10,-10,-10,-10,-9.85,-9.79,-9.93,-10,-10,-10,-9.75,-9.16,-8.40,-7.50,-6.39,-5.16,-4.17,-3.78,-3.40,-3.25,-3.39,-3.63,-3.66,-3.38,-2.55,-1.42,-0.13,0.72,1.36,1.62,1.87,2,2.11,2.87,2,3,3,4,4.07,5.25,6.57,7.07,7.62,8.25,8.89,9.48,9.76,9.88,9.97,10.12,10.36,10.60,10.75,10.75,10.47,10.21,9.87,9.58,9.12,8.39,7.70,6.97,6.25,5.62,4.98,4.25,4,3.97,3.89,4.25,4.84,5.25,5.59,5.77,5.88,5.76,5.45,4.89,4.37,4,3.88,4,4.32,4.75,5.24,5.85,6.20,6.21,6.09,5.63,5.12,4.62,4.40,4.38,4.38,4.50,4.83,5.25,5.87,6.65,7.64,8.75,10,11.38,12.50,13.50,14.74,15.87,16.82,17.49,18.37,18.36,18.49,19.36,19.37,18.73,18.39,17.47,16.50,15.36,14.32,13.62,12.37,12.22,12.37,13.12,14.12,15.25,16.45,17.62,18.75,19.76,20.62,21.26,21.64,21.63,21.37,20.86,20.25,19.65,19.14,18.75,18.46,18.24,18.09,18.01,18.15,18.65,19.50,20.52,21.62,22.62,23.50,24.14,24.25,23.14,-9.77,-9.88,-9.88,-9.73,-9.37,-8.89,-8.40,-7.63,-6.25,-4.38,-2.75,-1.74,-1.13,-0.99,-0.93,-1,-0.90,-0.76,-0.53,-0.25,-0.25,-0.26,-0.25,-0.13,0.12,0.37,0.62,0.88,1.09,1.37,1.86,2.37,2.73,3,3,2,2,1.95,1.62,1.37,1.11,0.74,0.33,-0.14,-0.65,-1.25,-1.88,-2.55,-3.37,-4.25,-5.52,-6.76,-7.88,-8.91,-9.65,-10,-10,-10,-9.99,-9.75,-9.51,-9.25,-8.99,-8.61,-8.35,-8.10,-8.13,-7.54,-5.93,-4.15,-2.13,-0.50,0.10,0.37,0.70,0.87,0.98,0.87,0.73,0.37,-0.03,-1.88,-3.38,-6.48,-9.15,-11,-13,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-9.50,-8.93,-8.50,-8.29,-8.18,-8.14,-8.13,-8.13,-8.26,-8.50,-8.68,-8.88,-9.05,-9.26,-9.50,-9.64,-9.79,-9.91,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.30,-8.50,-7.68,-7,-6.50,-6.24,-6.23,-6.25,-6.25,-6.25,-6.38,-6.65,-7.15,-7.76,-8.38,-8.77,-9.11,-9.75,-10,-11,-11,-11,-10,-10,-9.87,-9.50,-9.16,-9.02,-9.35,-9.78,-10,-10,-11,-11,-10,-10,-10,-10,-9.86,-9.88,-10,-10,-10,-10,-9.91,-9.42,-8.75,-7.93,-7,-6.02,-5.38,-5.13,-5,-4.90,-5,-5.04,-5,-4.50,-3.63,-2.39,-1.13,-0.26,0.25,0.82,1.12,1.25,1.49,1.62,1.88,2.24,2.84,3,4,4.87,5.75,6.62,7.25,7.95,8.49,8.82,8.89,8.98,9,9.02,9.14,9.35,9.49,9.47,9.33,9.12,8.89,8.62,8.25,7.60,6.90,6.21,5.50,4.85,4.23,3.87,3,3,3,3.97,4.86,4.75,4.84,4.90,4.82,4.60,4.25,3.90,3.50,3.37,3.37,3.50,3.77,4.15,4.62,4.87,5,4.99,4.97,4.75,4.45,4.15,4.12,4.24,4.46,4.77,5.23,5.71,6.25,7.13,8.20,9.37,10.65,12.09,13.45,14.45,15.50,16.50,17.40,18.35,18.33,18.37,18.50,18.63,18.71,18.50,18.08,17.40,16.51,15.49,14.38,13.62,12.87,12.37,12.37,13.32,14.25,15.32,16.50,17.64,18.75,19.76,20.60,21.12,21.36,21.21,20.75,20.12,19.46,18.83,18.25,17.82,17.61,17.57,17.62,17.82,18.20,18.87,19.77,20.86,21.96,22.99,23.87,24.61,24.75,24.22,-10,-10,-10,-10,-9.63,-8.90,-8.03,-7.43,-4.67,-1.13,0.59,0.99,1,1,0.61,0.35,0.12,0.12,0.24,0.36,0.37,0.34,0.25,0.35,0.47,0.62,0.75,0.97,1.08,1.37,1.97,2.62,3.09,3.26,3.10,2.87,2.72,2.38,2.14,1.88,1.62,1.25,0.86,0.37,-0.13,-0.63,-1.25,-1.91,-2.63,-3.40,-4.37,-5.88,-7.17,-8.38,-9.26,-9.78,-10,-9.98,-9.79,-9.62,-9.38,-9.13,-8.80,-8.40,-8.15,-7.88,-8.13,-7.76,-6,-4.50,-2.13,-0.63,0.21,0.50,0.74,0.75,0.75,0.70,0.50,0.07,-1,-2.53,-4.40,-6.30,-9.39,-11,-13,-14,-14,-14,-13,-13,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.73,-9.17,-8.67,-8.25,-8.13,-8.10,-8.12,-8.13,-8.13,-8.28,-8.50,-8.65,-8.86,-9.03,-9.25,-9.43,-9.63,-9.80,-9.98,-10,-10,-10,-10,-10,-10,-9.99,-9.88,-9.65,-9,-7.99,-6.87,-5.86,-5.04,-4.42,-4.27,-4.39,-4.51,-4.55,-4.55,-4.63,-4.79,-5.13,-5.54,-6.01,-6.50,-7,-7.67,-8.49,-9.05,-9.23,-9.17,-9.11,-8.93,-8.76,-8.66,-8.66,-8.80,-9.29,-9.91,-10,-10,-11,-11,-10,-10,-10,-9.88,-9.74,-9.74,-9.90,-10,-10,-10,-10,-9.63,-9.11,-8.38,-7.55,-6.76,-6.50,-6.36,-6.36,-6.39,-6.43,-6.50,-6.38,-5.78,-4.75,-3.53,-2.42,-1.51,-0.77,-0.16,0.23,0.59,0.84,1.12,1.37,1.84,2.21,2.75,3,4,5.12,5.98,6.74,7.45,7.83,7.95,7.98,8,8,8,8.02,8.12,8.22,8.22,8.12,8.01,7.89,7.61,7.25,6.61,5.96,5.26,4.62,4.09,3.12,3,3,2,2.99,3,3.98,3.97,3.96,3.96,3.96,3.02,3.02,2.96,2.96,2.86,2.75,2.88,3.22,3.62,3.87,4,4,4,3.99,3.87,3.87,3.89,4.12,4.39,4.82,5.25,5.73,6.13,6.75,7.62,8.62,9.75,11.09,12.58,14.38,15.02,16.07,17.37,17.76,18.27,18.25,18.11,18.10,18.20,18.26,18.25,18,17.49,16.71,15.74,14.71,13.37,13.12,12.85,13.08,13.64,14.37,15.62,16.74,17.85,18.87,19.82,20.52,21,21.09,20.75,20.12,19.37,18.62,17.90,17.37,17,16.97,17.12,17.48,17.89,18.50,19.27,20.24,21.25,22.26,23.25,24.12,24.75,24.85,24.26,-10,-10,-10,-10,-10,-9.38,-8.51,-7.42,-4.25,-1,0.37,0.84,0.98,0.87,0.82,0.73,0.70,0.71,0.75,0.83,0.83,0.75,0.71,0.63,0.72,0.75,0.86,0.95,1.07,1.36,2,2.73,3.50,3.50,3.49,3.37,3.13,3,2.75,2.50,2.22,1.88,1.51,1.12,0.62,0.07,-0.55,-1.25,-1.93,-2.63,-3.38,-4.91,-6.26,-7.53,-8.54,-9.18,-9.50,-9.53,-9.50,-9.36,-9.16,-9,-8.78,-8.52,-8.41,-8.50,-8.79,-8.74,-7.99,-6.13,-3.01,-0.99,-0.65,0.12,0.37,0.36,0.08,-0.25,-0.38,-0.13,-1.88,-3.42,-5.38,-7.63,-10,-12,-13,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-9.89,-9.50,-9.05,-8.63,-8.27,-8.23,-8.23,-8.25,-8.28,-8.38,-8.43,-8.53,-8.64,-8.78,-9,-9.13,-9.29,-9.50,-9.66,-9.88,-10,-10,-10,-10,-10,-9.86,-9.60,-9.25,-9.13,-8.03,-6.63,-5,-3.75,-3,-2.63,-2.53,-2.54,-2.63,-2.65,-2.63,-2.63,-2.67,-2.88,-3.13,-3.52,-4,-4.60,-5.25,-5.92,-6.52,-6.90,-7.17,-7.38,-7.50,-7.54,-7.75,-8.10,-8.54,-9.24,-9.99,-10,-11,-11,-11,-10,-10,-10,-9.66,-9.48,-9.55,-9.77,-10,-10,-10,-10,-9.75,-9.23,-8.62,-8,-7.63,-7.42,-7.38,-7.43,-7.50,-7.63,-7.63,-7.48,-6.88,-5.79,-4.64,-3.63,-2.75,-1.92,-1.25,-0.63,-0.03,0.49,0.87,1.22,1.50,1.75,2.10,2.50,3.20,5,5.11,5.87,6.62,6.86,6.95,6.97,6.98,6.99,6.99,7,7.07,7.07,7.07,7.07,6.98,6.82,6.50,6.02,5.50,4.87,4.27,3.75,3.11,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1.99,1.98,2.09,2.20,2.71,2.87,3,3,3,3.11,3.23,3.36,3.51,3.82,4.25,4.75,5.36,5.95,6.37,6.76,7.32,8.10,8.97,10,11.25,12.63,14.37,15.11,16.37,17.36,17.51,18.25,17.75,17.62,17.62,17.75,18.02,18.22,18.12,17.72,17,16.02,14.99,14,13.38,13.27,13.62,14.27,15.21,16.14,17.20,18.14,19.09,19.87,20.50,20.86,20.87,20.33,19.58,18.71,17.87,17.12,16.62,16.50,16.65,17.09,17.61,18.24,18.98,19.77,20.72,21.62,22.57,23.39,24.12,24.50,24.37,23.38,-11,-11,-11,-10,-10,-9.62,-8.75,-7.63,-4.38,-1.13,0.25,0.75,0.97,0.96,0.87,0.87,0.87,1,1.12,1.13,1.12,1.08,0.99,0.87,0.87,0.87,0.89,0.98,1.08,1.37,1.90,2.64,3.25,3.65,3.73,3.64,3.57,3.47,3.27,3.07,2.85,2.61,2.32,1.95,1.46,0.87,0.23,-0.50,-1.25,-1.89,-2.63,-3.88,-5.13,-6.38,-7.43,-8.24,-8.63,-8.88,-8.93,-8.93,-8.89,-8.88,-8.88,-8.88,-9.10,-9.38,-9.68,-10,-9.75,-8.30,-5.90,-3.80,-1.63,-1.54,-1.40,-1.61,-2.01,-2.50,-2.80,-3.01,-2.75,-4.15,-6.76,-8.91,-11,-12,-14,-14,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.76,-9.50,-9.13,-8.80,-8.53,-8.49,-8.49,-8.50,-8.60,-8.64,-8.63,-8.55,-8.61,-8.66,-8.78,-8.88,-9,-9.13,-9.29,-9.52,-9.79,-10,-10,-10,-10,-9.49,-9,-8.42,-7.92,-6.75,-5.38,-3.88,-2.54,-1.65,-1.18,-1,-0.88,-0.77,-0.63,-0.52,-0.42,-0.40,-0.40,-0.61,-0.91,-1.41,-2.01,-2.74,-3.50,-4.13,-4.67,-5.14,-5.55,-5.88,-6.17,-6.65,-7.36,-8.16,-9,-9.87,-10,-10,-11,-10,-10,-10,-9.75,-9.48,-9.28,-9.36,-9.75,-10,-10,-10,-10,-9.98,-9.39,-8.89,-8.62,-8.38,-8.25,-8.25,-8.25,-8.27,-8.25,-8.13,-7.79,-7.42,-6.51,-5.63,-4.63,-3.79,-3.04,-2.28,-1.38,-0.53,0.12,0.70,1,1.25,1.48,1.73,2.09,2.63,3.33,4,4.77,5.24,5.63,5.83,5.87,5.95,5.98,5.99,6,6.10,6.15,6.25,6.12,5.95,5.62,5.24,4.75,4.25,3.75,3.20,2.87,2.07,1.87,1.87,1.09,1.07,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1.87,2,2,2.11,2.22,2.46,2.77,3.12,3.48,3.96,4.61,5.33,6.12,6.83,7.36,7.63,8.21,8.51,9.34,10.15,11.24,12.39,13.58,14.65,15.52,16.25,16.77,17,17.12,17.12,17.34,17.62,18,18.32,18.37,18.08,17.37,16.45,15.37,14.26,13.62,13.52,14.08,14.90,15.84,16.75,17.63,18.50,19.25,19.96,20.37,20.62,20.51,19.87,18.99,18.07,17.15,16.46,16.12,16.23,16.63,17.23,17.87,18.62,19.39,20.25,21.10,21.90,22.72,23.37,23.85,24,23.62,22.51,-11,-11,-11,-11,-10,-10,-8.88,-7.63,-4.63,-1.25,0.21,0.75,0.96,0.98,0.97,0.98,1,1.13,1.37,1.47,1.45,1.34,1.20,1.12,1.08,1.01,1,1,1.12,1.40,1.87,2.46,3,3.45,3.72,3.84,3.86,3.77,3.65,3.50,3.37,3.24,3.01,2.75,2.27,1.74,1.07,0.25,-0.42,-1.13,-1.75,-2.64,-3.75,-4.91,-6.03,-6.88,-7.50,-7.88,-8.16,-8.38,-8.50,-8.65,-8.88,-9.14,-9.51,-10,-10,-10,-10,-9.64,-8.38,-5.86,-4.48,-3.75,-3.79,-4.12,-4.52,-5.02,-5.50,-5.75,-5.53,-6.88,-8.36,-10,-12,-13,-14,-14,-14,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.90,-9.75,-9.55,-9.38,-9.13,-8.92,-8.77,-8.67,-8.67,-8.75,-8.78,-8.65,-8.49,-8.39,-8.38,-8.40,-8.49,-8.41,-8.50,-8.63,-8.88,-9.25,-9.75,-10,-10,-9.75,-8.77,-8,-7.38,-6.63,-5.50,-4.25,-2.89,-1.64,-0.67,-0.05,0.25,0.50,0.75,1.10,1.25,1.48,1.95,1.77,1.45,1.10,0.61,0.11,-0.48,-1.12,-1.86,-2.50,-3.12,-3.63,-4.13,-4.63,-5.30,-6.29,-7.63,-8.52,-9.55,-10,-10,-10,-10,-10,-9.85,-9.50,-9.26,-9.25,-9.40,-9.98,-10,-10,-11,-10,-10,-9.88,-9.50,-9.16,-9,-8.89,-8.91,-8.99,-8.98,-8.87,-8.63,-8.25,-7.68,-7,-6.25,-5.40,-4.76,-4.16,-3.13,-2,-0.91,-0.03,0.58,0.87,1.07,1.21,1.35,1.60,1.87,2.35,2.87,3.36,3.87,4.34,4.63,4.77,4.87,4.96,4.98,5,5.12,5.45,5.45,5.27,4.86,4.38,3.95,3.39,3,2.58,2.25,1.75,1.12,1.12,1.12,1.12,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1.09,1.13,1.75,2.25,2.64,3.25,3.74,4.38,5.23,6.12,7.12,7.89,8.52,9,9.27,9.50,9.61,10.38,11.21,12.12,13.12,14.02,14.87,15.52,16,16.27,16.50,16.74,17.12,17.60,18.12,18.60,18.83,18.59,17.87,16.88,15.82,14.61,13.98,14,14.62,15.50,16.39,17.33,18.12,18.87,19.45,19.85,20.12,20.21,19.96,19.23,18.35,17.40,16.60,16,15.90,16.23,16.75,17.40,18.14,18.90,19.73,20.50,21.27,21.96,22.50,22.95,23.25,23.35,22.89,21.71,-11,-11,-11,-11,-10,-10,-9,-7.65,-4.63,-2.75,0,0.75,0.95,0.96,0.99,1,1.08,1.25,1.61,1.74,1.72,1.62,1.49,1.37,1.33,1.25,1.20,1.15,1.26,1.51,1.95,2.37,2.87,3.32,3.62,3.85,3.90,3.90,3.87,3.85,3.82,3.75,3.65,3.49,3.12,2.62,1.99,1.25,0.50,-0.12,-0.63,-1.25,-2.12,-3.38,-4.49,-5.39,-6.13,-6.73,-7.17,-7.60,-7.91,-8.29,-8.75,-9.16,-9.75,-10,-10,-10,-10,-9.74,-8.50,-7.25,-6.27,-5.89,-6,-6.41,-7.10,-7.50,-8.10,-8.74,-8.93,-8.79,-9.65,-11,-12,-14,-14,-14,-13,-12,-12,-11,-11,-10,-10,-10,-10,-10,-9.91,-9.88,-9.78,-9.74,-9.63,-9.49,-9.27,-9,-8.75,-8.63,-8.63,-8.63,-8.43,-8.18,-7.93,-7.80,-7.73,-7.63,-7.61,-7.50,-7.60,-7.79,-8.25,-8.90,-9.62,-10,-8.78,-7.62,-6.68,-5.92,-5.13,-4.25,-3.13,-2,-0.88,0.09,0.75,1.25,1.62,1.95,2.35,2.61,2.87,3.33,3.38,3.20,2.84,2.45,1.99,1.58,0.88,0.25,-0.40,-0.89,-1.51,-2.13,-2.78,-3.65,-4.80,-6.35,-7.75,-8.80,-9.50,-9.77,-10,-9.98,-9.75,-9.48,-9.24,-9.12,-9.25,-9.63,-10,-11,-11,-11,-11,-11,-10,-10,-9.75,-9.53,-9.42,-9.40,-9.39,-9.38,-9.25,-9.02,-8.66,-8.15,-7.52,-6.76,-6.01,-5.38,-4.88,-3.63,-2.38,-1.15,-0.15,0.50,0.75,0.87,0.98,0.99,1,1.12,1.35,1.63,2.12,2.62,3.10,3.48,3.74,3.87,3.96,3.99,4,4.11,4.24,4.33,4.11,3.70,3.20,2.70,2.22,1.75,1.49,1.22,0.97,0.86,0.86,0.96,0.95,0.88,0.87,0.87,0.87,0.95,0.98,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,2,2,2.90,3.11,4.12,5.12,6.02,7.14,8.25,9.23,9.95,10.50,10.62,10.63,10.62,10.62,11.38,12.10,12.86,13.62,14.38,15.07,15.50,15.86,16.14,16.52,17.11,17.72,18.36,18.88,19.24,19.08,18.39,17.40,16.37,15.34,14.62,14.63,15.25,16.09,16.96,17.75,18.50,19.12,19.50,19.72,19.70,19.50,19.12,18.45,17.62,16.77,16.12,15.75,15.86,16.25,16.87,17.59,18.33,19.08,19.82,20.50,21.13,21.62,21.97,22.25,22.52,22.64,22.40,20.85,-11,-11,-11,-11,-10,-10,-8.93,-7.62,-5.39,-3,-0.01,0.62,0.72,0.95,0.97,1,1,1.12,2,2,2,1.82,1.75,1.65,1.62,1.50,1.45,1.39,1.50,1.75,2.11,2.50,2.89,3.27,3.62,3.85,3.99,4.02,4.10,4.12,4.20,4.24,4.24,4.12,3.90,3.52,3,2.37,1.71,1.09,0.59,0.25,-0.76,-1.89,-3,-3.88,-4.63,-5.38,-6,-6.61,-7.13,-7.68,-8.38,-8.88,-9.52,-9.93,-10,-10,-9.67,-9.13,-8.49,-7.86,-7.43,-7.39,-7.77,-8.26,-9.13,-9.35,-9.67,-9.88,-9.92,-9.91,-10,-11,-12,-13,-14,-13,-12,-12,-11,-11,-10,-10,-10,-9.91,-9.78,-9.73,-9.74,-9.77,-9.86,-9.88,-9.86,-9.68,-9.42,-8.89,-8.50,-8.17,-8.02,-7.99,-7.90,-7.62,-7.27,-6.91,-6.65,-6.38,-6.17,-6.11,-6.13,-6.36,-6.75,-7.41,-8.88,-8.50,-7,-5.88,-5.13,-4.50,-3.76,-3,-2.04,-1.13,-0.14,0.71,1.45,2,2.46,2.84,3.25,3.59,3.87,4.33,4.45,4.23,3.88,3.62,3.25,2.87,2.33,1.75,1.25,0.72,0.12,-0.50,-1,-1.65,-2.77,-4.60,-6.17,-7.50,-8.38,-8.79,-9.16,-9.27,-9.25,-9.01,-8.88,-8.89,-9.23,-9.87,-10,-11,-12,-12,-12,-11,-11,-10,-10,-10,-9.87,-9.78,-9.75,-9.67,-9.55,-9.38,-9.10,-8.63,-8.02,-7.29,-6.52,-5.76,-5.03,-3.90,-2.63,-1.30,-0.25,0.46,0.71,0.82,0.74,0.59,0.37,0.24,0.25,0.50,0.98,1.50,2.07,2.50,2.75,2.95,3,3,3,3,3,3,2.87,2.50,2.08,1.50,1.07,0.62,0.35,0.12,0,-0.01,0.62,0.62,0.25,0.25,0.25,0.48,0.73,0.87,0.98,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,2,2,3.02,4.10,5,6,7.08,8.25,9.62,10.62,11.50,11.87,12.08,12,11.84,11.75,11.89,12.27,12.85,13.50,14.25,14.87,15.38,15.77,16.22,16.72,17.36,18,18.64,19.24,19.58,19.47,18.87,18,17.01,16.14,15.63,15.62,15.98,16.70,17.48,18.22,18.85,19.26,19.49,19.45,19.20,18.75,18.22,17.57,16.82,16.12,15.62,15.50,15.75,16.25,16.89,17.62,18.34,19.02,19.75,20.35,20.76,21.10,21.33,21.52,21.83,22.07,22.12,20.87,-11,-11,-11,-11,-10,-9.87,-8.87,-7.54,-6.15,-3.38,-1.88,-0.75,0.62,0.73,0.95,0.99,1,1.12,2,2,1.95,1.90,1.88,1.87,1.84,1.75,1.73,1.73,1.84,2.07,2.37,2.74,3.10,3.40,3.72,3.95,4.12,4.25,4.37,4.50,4.62,4.73,4.76,4.75,4.65,4.45,4.08,3.57,2.98,2.37,1.75,1.12,0.75,-0.77,-1.75,-2.43,-3.13,-3.86,-4.54,-5.25,-5.98,-6.65,-7.50,-8.02,-8.64,-9,-9.13,-9.12,-8.88,-8.60,-8.25,-8,-7.99,-8.17,-8.75,-9.25,-10,-10,-10,-10,-9.99,-9.93,-10,-11,-12,-12,-12,-12,-11,-10,-10,-10,-9.79,-9.63,-9.42,-9.28,-9.25,-9.25,-9.38,-9.63,-9.74,-9.85,-9.76,-9.53,-9.10,-8.49,-7.74,-7.25,-6.99,-6.80,-6.73,-6.55,-6.25,-5.80,-5.38,-4.87,-4.41,-4.17,-4.16,-4.29,-4.52,-5.04,-5.39,-5.30,-4.60,-4.11,-3.60,-3.03,-2.48,-1.76,-1,-0.16,0.62,1.37,2,2.60,3.09,3.49,3.98,4.25,4.50,4.75,4.87,4.75,4.62,4.37,4.20,4,3.62,3.25,2.75,2.23,1.62,0.95,0.35,-0.41,-1.38,-2.25,-3.88,-5.63,-6.87,-7.38,-8,-8.50,-8.66,-8.50,-8.43,-8.62,-9.03,-9.88,-10,-12,-13,-13,-13,-12,-11,-11,-10,-10,-10,-10,-9.98,-9.89,-9.87,-9.75,-9.40,-9,-8.38,-7.63,-6.88,-6.03,-5.13,-4.04,-2.88,-1.68,-0.63,0.25,0.62,0.72,0.50,0.13,-0.38,-0.75,-1,-0.75,-0.14,0.58,1.22,1.62,1.97,2.12,2.12,2.12,2.10,2,2.12,2.12,1.98,1.62,1.12,0.57,-0.02,-0.52,-0.91,-1.25,-1.38,-1.50,-1.39,-1.15,-0.90,-0.75,-0.50,-0.02,0.49,0.82,0.87,0.97,0.96,0.97,0.97,0.98,0.98,0.98,0.99,0.99,0.99,1,1,1,2,3,3.96,4.88,5.99,7.10,8.13,9.27,10.62,12.57,12.71,13.46,13.47,13.38,13.14,12.96,12.84,12.87,13.23,13.75,14.47,15.12,15.63,16.12,16.62,17.14,17.83,18.48,19.10,19.61,19.87,19.82,19.35,18.62,17.82,17.02,16.59,16.51,16.87,17.37,18.07,18.65,19.12,19.36,19.33,19.07,18.60,18,17.35,16.62,15.97,15.39,15.09,15.20,15.61,16.20,16.87,17.58,18.25,19,19.62,20.12,20.47,20.60,20.64,20.86,21.15,21.60,21.87,20.90,-11,-11,-11,-11,-10,-9.75,-8.75,-7.52,-6.02,-4.65,-2.88,-1.54,-0.63,0.62,0.95,0.96,0.99,1.12,1,1.87,1.85,1.90,1.98,1.98,1.97,1.96,1.97,2,2.12,2.37,2.63,3,3.37,3.65,3.96,4.20,4.38,4.58,4.74,4.87,5.07,5.23,5.36,5.39,5.37,5.25,5.02,4.71,4.22,3.62,2.86,1.98,0.87,-0.79,-0.64,-1.05,-1.51,-2.14,-2.88,-3.64,-4.50,-5.25,-6.13,-6.67,-7.27,-7.65,-7.91,-8.04,-8.05,-8,-7.88,-7.87,-8,-8.35,-8.86,-9.38,-10,-10,-9.93,-9.75,-9.52,-9.41,-9.53,-9.99,-10,-10,-10,-10,-10,-9.54,-9.17,-8.88,-8.75,-8.68,-8.63,-8.51,-8.41,-8.51,-8.76,-9.15,-9.50,-9.38,-9.13,-8.74,-8.10,-7.27,-6.50,-5.88,-5.50,-5.29,-5.23,-5.10,-4.88,-4.49,-3.88,-3,-2.03,-1.86,-1.88,-1.99,-2.23,-1.92,-2.75,-2.86,-2.64,-2.38,-2.02,-1.64,-1.18,-0.63,0,0.71,1.37,2,2.60,3.11,3.57,3.98,4.37,4.62,4.85,4.96,4.97,4.96,4.87,4.87,4.87,4.87,4.83,4.71,4.25,3.61,2.86,2.08,1.37,0.50,-0.30,-1.25,-2.30,-3.50,-4.75,-5.52,-6.38,-7.35,-7.90,-7.80,-7.85,-8.11,-8.64,-9.55,-10,-12,-13,-13,-13,-12,-11,-11,-10,-10,-10,-10,-10,-10,-10,-9.88,-9.67,-9.25,-8.63,-7.98,-7.18,-6.36,-5.38,-4.35,-3.17,-2.04,-0.99,-0.14,0.32,0.57,0.25,-0.25,-1.12,-1.87,-2.28,-2.13,-1.25,-0.26,0.50,0.98,1.25,1.37,1.46,1.46,1.37,1.21,1.37,1.37,1.25,0.97,0.37,-0.41,-1.18,-1.88,-2.38,-2.76,-3.13,-3.40,-3.75,-3.38,-2.88,-2.25,-1.40,-0.51,0.25,0.62,0.86,0.87,0.87,0.87,0.87,0.87,0.95,0.97,0.98,0.99,0.99,0.99,1,1,2,3,4.01,5.88,6.87,7.87,9.75,10.24,11.62,12.62,13.60,14.47,14.75,14.74,14.48,14.12,13.90,13.76,13.90,14.34,14.98,15.59,16.13,16.70,17.23,17.75,18.37,19,19.59,20.01,20.25,20.23,19.85,19.24,18.57,17.90,17.50,17.40,17.70,18.13,18.74,19.20,19.38,19.36,19.09,18.62,18,17.32,16.50,15.75,15.13,14.62,14.49,14.75,15.35,16.02,16.77,17.50,18.25,18.99,19.62,20.09,20.26,20.26,20.25,20.23,20.63,21.15,21.76,22,-11,-11,-11,-11,-10,-9.65,-8.63,-7.42,-6.17,-4.88,-3.63,-2.25,-1.01,0.62,0.62,0.74,0.97,1,1.08,1.37,1.73,1.87,1.99,2,2.02,2.11,2.15,2.26,2.45,2.62,2.89,3.25,3.62,3.98,4.26,4.57,4.75,4.96,5.12,5.32,5.50,5.75,5.95,6.08,6.12,6.10,5.99,5.75,5.37,4.75,4.02,3,1.12,0.97,0.48,0.12,-0.25,-0.65,-1.30,-2.13,-2.90,-3.67,-4.41,-5.13,-5.67,-6.16,-6.55,-6.88,-7.13,-7.26,-7.36,-7.40,-7.63,-8,-8.48,-9,-9.63,-9.67,-9.50,-9.13,-8.76,-8.50,-8.41,-8.50,-8.68,-8.80,-8.76,-8.60,-8.26,-7.98,-7.68,-7.50,-7.39,-7.42,-7.90,-7.42,-7.18,-7.35,-7.78,-8.25,-8.51,-8.35,-7.86,-7.25,-6.52,-5.73,-4.85,-4.13,-3.74,-3.61,-3.55,-3.51,-3.38,-3.03,-2.39,-1.41,-0.42,-0.05,-0.05,-0.13,-0.15,-0.38,-0.60,-0.76,-0.79,-0.74,-0.54,-0.30,0,0.49,1.01,1.62,2.14,2.64,3.12,3.50,3.96,4.32,4.62,4.85,5,4.99,5,5,5.12,5.23,5.37,5.48,5.50,5.37,5,4.50,3.85,2.96,2.24,1.37,0.62,-0.15,-1,-1.79,-2.63,-3.39,-4.25,-5.53,-7,-6.80,-6.98,-7.36,-8,-8.92,-10,-11,-12,-12,-12,-12,-11,-11,-10,-10,-10,-10,-9.99,-10,-10,-10,-9.85,-9.41,-8.88,-8.26,-7.52,-6.67,-5.75,-4.75,-3.64,-2.55,-1.50,-0.68,-0.25,0.10,-0.15,-0.68,-1.88,-2.91,-3.63,-3.41,-2.38,-1.13,-0.13,0.37,0.57,0.63,0.75,0.82,0.87,0.87,0.75,0.71,0.50,0.23,-0.53,-1.55,-2.63,-3.27,-3.88,-4.50,-5,-5.38,-5.63,-5.87,-5,-3.88,-2.30,-1,0.12,0.37,0.58,0.61,0.61,0.62,0.62,0.72,0.62,0.62,0.71,0.75,0.86,0.88,1,1.36,2,3,4,5.90,6.97,8.12,9.75,10.70,11.71,13.57,13.82,14.71,16.35,16.12,15.50,15.25,15,14.87,14.84,15.10,15.60,16.12,16.73,17.25,17.83,18.37,18.96,19.57,20.12,20.51,20.75,20.65,20.37,19.86,19.25,18.73,18.37,18.25,18.47,18.87,19.37,19.75,19.70,19.37,18.89,18.32,17.59,16.74,15.86,15.01,14.37,13.87,13.87,14.25,15,15.87,16.74,17.50,18.32,19.10,19.75,20.21,20.33,20.22,20.07,20.08,20.32,20.83,21.48,21.07,-11,-11,-11,-11,-10,-9.63,-8.55,-7.41,-6.25,-5.05,-3.88,-2.65,-1.52,-0.75,-0.01,0.50,0.87,0.99,1,1.34,1.62,1.87,2,2.08,2.14,2.26,2.39,2.52,2.71,2.87,3.13,3.50,3.88,4.27,4.64,4.98,5.21,5.37,5.51,5.74,5.99,6.25,6.50,6.71,6.84,6.87,6.87,6.75,6.48,5.97,5.21,4.76,3.12,2.12,1.75,1.33,0.87,0.37,-0.25,-0.90,-1.63,-2.25,-2.88,-3.50,-4.05,-4.61,-5.11,-5.60,-6,-6.30,-6.51,-6.68,-6.92,-7.29,-7.76,-8.30,-9.04,-9.13,-8.75,-8.25,-7.75,-7.36,-7.05,-6.88,-6.88,-6.86,-6.75,-6.63,-6.42,-6.25,-6.10,-5.91,-5.80,-5.80,-5.98,-5.63,-5.50,-5.63,-6,-6.49,-6.64,-6.42,-5.98,-5.38,-4.75,-3.88,-3.03,-2.12,-1.87,-1.76,-1.88,-2,-2,-1.86,-1.49,-0.61,0.21,1,1.25,1.48,1.48,1.46,1.26,1.09,0.88,0.85,0.87,0.99,1.22,1.59,2.07,2.58,3,3.37,3.63,4,4.34,4.62,4.83,4.96,5,5,5,5.12,5.33,5.57,5.70,5.75,5.86,5.62,5.25,4.83,4.33,3.61,2.88,2.20,1.50,0.84,0.13,-0.43,-1.02,-1.52,-2.25,-2.65,-4.63,-5.48,-5.80,-6.36,-7.03,-7.99,-9.05,-10,-11,-11,-11,-11,-11,-10,-10,-10,-9.80,-9.75,-9.76,-9.88,-10,-10,-9.98,-9.61,-9.13,-8.55,-7.88,-7.11,-6.25,-5.28,-4.29,-3.30,-2.38,-1.63,-1.17,-0.93,-1,-1.50,-2.90,-4.05,-4.88,-4.75,-3.67,-2.29,-1.17,-0.53,-0.28,-0.25,-0.13,-0.02,0.12,0.74,-0.13,-0.38,-0.67,-1.25,-2.25,-3.15,-3.89,-4.53,-5.13,-5.65,-6.18,-6.62,-6.88,-7.16,-8.38,-5.25,-3.14,-1.38,-0.38,-0.63,-0.64,-0.90,-1,-1.03,-1,-0.87,-0.63,-0.38,-0.04,0.27,0.62,0.86,1.07,1.37,2,3,4,5.95,6.88,7.99,9.14,10.27,11.62,12.59,13.62,14.62,15.39,15.99,16.21,16.24,16.11,15.85,15.74,15.86,16.23,16.72,17.25,17.83,18.37,18.87,19.40,19.99,20.50,20.87,21.08,21.07,20.83,20.37,19.87,19.35,19,18.87,19.02,19.40,19.84,20.20,19.89,19.48,18.87,18.12,17.32,16.37,15.39,14.50,13.77,13.21,13.07,13.71,14.65,15.75,16.76,17.63,18.50,19.36,20.11,20.62,20.51,20.25,20,19.87,20,20.37,20.90,21.13,-11,-11,-11,-10,-10,-9.50,-8.51,-7.50,-6.38,-5.25,-4.04,-2.88,-1.87,-1.02,-0.26,0.37,0.85,0.89,1.09,1.33,1.62,1.87,2,2.13,2.33,2.50,2.62,2.75,2.89,3.12,3.37,3.76,4.22,4.62,5.07,5.38,5.62,5.82,5.98,6.15,6.47,6.75,7.08,7.33,7.50,7.62,7.72,7.70,7.48,7.10,6.65,5.75,4.82,3.84,3,2.47,1.87,1.33,0.74,0.11,-0.50,-1,-1.41,-2,-2.50,-3,-3.55,-4.13,-4.66,-5.13,-5.48,-5.75,-6,-6.38,-6.80,-7.36,-8.05,-8.13,-7.63,-7.04,-6.50,-6,-5.62,-5.25,-5.11,-4.98,-4.86,-4.75,-4.63,-4.50,-4.38,-4.25,-4.03,-3.88,-3.67,-3.41,-3.36,-3.48,-3.79,-4,-3.78,-3.51,-3.25,-3.04,-2.87,-2.38,-1.76,-1,-0.54,-0.38,-0.50,-0.68,-0.75,-0.63,-0.36,0.24,1.07,1.75,2.35,2.73,2.98,3.15,3.14,2.75,2.50,2.36,2.25,2.25,2.37,2.70,3.12,3.61,4,4.24,4.27,4.58,4.87,5,5.10,5.13,5.23,5.25,5.27,5.33,5.62,5.83,5.88,5.97,5.87,5.72,5.38,4.98,4.62,4.12,3.60,2.96,2.33,1.72,1.12,0.62,0.12,-0.37,-0.55,-1.75,-2.79,-3.80,-4.50,-5.13,-5.88,-6.75,-7.74,-8.75,-9.62,-10,-10,-10,-10,-9.88,-9.66,-9.51,-9.38,-9.38,-9.50,-9.68,-9.92,-10,-10,-9.74,-9.30,-8.79,-8.17,-7.50,-6.75,-5.98,-5.13,-4.28,-3.54,-3,-2.63,-2.61,-2.50,-3,-4.38,-5.50,-6.24,-6.13,-5.27,-4.13,-2.99,-2.24,-1.88,-1.77,-1.63,-1.38,-1.13,-1.17,-1.52,-2,-2.50,-3.38,-3.91,-4.61,-5.17,-5.75,-6.25,-6.74,-7.16,-7.53,-7.75,-7.87,-7.49,-6.50,-4.53,-3.11,-2.75,-2.65,-2.68,-2.76,-2.88,-2.93,-2.86,-2.52,-2.10,-1.51,-0.91,-0.36,0.23,0.75,1,1.37,2.08,3,4.12,5.01,6.08,7.87,8.76,9.77,10.87,11.99,13.02,14.09,15,15.83,16.46,16.83,16.87,16.70,16.52,16.59,16.84,17.24,17.72,18.23,18.73,19.15,19.62,19.99,20.36,20.64,20.87,20.95,20.83,20.50,20.12,19.65,19.34,19.21,19.27,19.59,20,20.33,20.12,19.62,18.95,18.12,17.25,16.25,15.21,14.14,13.36,12.87,12.71,13.34,14.39,15.62,16.77,17.87,18.87,19.75,20.48,20.87,20.62,20.25,19.90,19.64,19.62,19.84,20.25,20.25,-11,-11,-11,-10,-10,-9.43,-8.53,-7.53,-6.50,-5.39,-4.25,-2.93,-1.75,-0.76,-0.04,0.50,0.84,0.88,1.08,1.33,1.62,1.87,2.08,2.25,2.49,2.70,2.85,2.96,3.10,3.34,3.64,4.08,4.50,4.98,5.39,5.75,6.01,6.23,6.38,6.63,6.98,7.34,7.64,7.98,8.22,8.37,8.51,8.59,8.50,8.25,7.83,7.12,6.11,5.09,4.38,3.58,2.87,2.25,1.62,1.10,0.60,0.21,-0.13,-0.53,-1.01,-1.50,-2.05,-2.65,-3.26,-3.79,-4.25,-4.60,-4.89,-5.25,-5.63,-6.12,-6.61,-6.61,-6.16,-5.63,-5.04,-4.53,-4.11,-3.64,-3.39,-3.18,-3.03,-2.92,-2.88,-2.77,-2.67,-2.52,-2.26,-1.67,-1.38,-1.51,-1.75,-1.89,-1.99,-1.88,-1.65,-1.73,-1.67,-1.61,-1.38,-1.04,-0.63,-0.24,0.15,0.38,0.47,0.48,0.50,0.62,0.89,1.25,2,2.75,3.37,3.95,4.36,4.58,4.52,4.34,4.02,3.83,3.62,3.57,3.62,3.84,4.24,4.75,5.22,5.47,5.45,5.23,5.85,5.97,6,6,6,5.87,5.75,5.87,6.10,6.27,6.35,6.25,6.10,5.86,5.64,5.47,5.21,4.86,4.33,3.71,3.10,2.50,2,1.50,1.08,0.62,0,-0.68,-1.62,-2.41,-3.16,-3.87,-4.50,-5.27,-6.16,-7.01,-7.80,-8.38,-8.80,-9.03,-9.03,-8.92,-8.89,-8.88,-8.88,-8.93,-9.13,-9.42,-9.76,-10,-10,-9.75,-9.38,-8.92,-8.38,-7.85,-7.25,-6.63,-6,-5.38,-4.87,-4.50,-4.38,-4.50,-4.62,-5.13,-6.26,-7.16,-7.75,-7.77,-7.13,-6.15,-5.25,-4.60,-4.13,-3.89,-3.75,-3.51,-3.23,-2.64,-3.38,-3.80,-4.29,-4.77,-5.35,-5.86,-6.30,-6.75,-7.14,-7.53,-7.89,-8.16,-8.30,-8.25,-7.88,-7.16,-6.25,-5.42,-4.90,-4.68,-4.67,-4.79,-5.01,-5.13,-5,-4.50,-3.75,-2.88,-1.98,-1.12,-0.29,0.35,0.87,1.37,2,2.87,3.87,4.95,6.02,7.09,8.20,9.25,10.35,11.37,12.47,13.60,14.62,15.59,16.48,17.08,17.34,17.25,17.21,17.25,17.38,17.71,18.08,18.47,18.85,19.08,19.37,19.65,20,20.25,20.50,20.62,20.62,20.46,20.12,19.71,19.37,19.22,19.26,19.50,19.84,20.01,20.24,19.76,19.10,18.25,17.33,16.24,15.09,13.96,13.08,12.62,12.50,13.11,14.22,15.46,16.75,18,19.20,20.33,20.87,21.11,20.71,20.25,19.82,19.37,19.07,19.13,19.50,19.37,-10,-11,-11,-10,-10,-9.54,-8.63,-7.67,-6.66,-5.62,-4.37,-2.91,-1.50,-0.38,0.37,0.72,0.77,0.88,1.08,1.33,1.62,1.87,2.12,2.36,2.61,2.83,2.98,3.10,3.25,3.58,3.96,4.37,4.82,5.25,5.72,6.09,6.37,6.61,6.87,7.15,7.57,7.98,8.37,8.74,9,9.25,9.45,9.51,9.52,9.40,9.11,8.83,7.85,6.87,5.75,4.87,4.08,3.37,2.75,2.21,1.74,1.37,1.09,0.84,0.37,-0.13,-0.66,-1.28,-1.91,-2.50,-2.98,-3.35,-3.64,-4,-4.30,-4.68,-4.88,-4.86,-4.53,-4.11,-3.60,-3.11,-2.55,-2.13,-1.77,-1.50,-1.30,-1.24,-1.16,-1.13,-1.04,-0.90,-0.55,-0.13,-0.01,-0.25,-0.40,-0.51,-0.51,-0.38,-0.28,-0.29,-0.38,-0.36,-0.14,0.10,0.35,0.60,0.87,1.10,1.25,1.39,1.61,1.83,2.11,2.50,3.09,3.75,4.40,5.08,5.63,6,6.02,5.82,5.50,5.24,5,4.84,4.86,5.02,5.22,6,6.83,6.88,6.95,6.89,6.89,6.99,6.99,6.99,6.87,6.62,6.46,6.45,6.64,6.87,6.89,6.74,6.48,6.26,6.22,6.12,5.98,5.62,5.12,4.48,3.84,3.25,2.74,2.25,1.82,1.33,0.75,0.10,-0.62,-1.28,-1.92,-2.50,-3,-3.55,-4.27,-5.13,-6,-6.63,-7.12,-7.50,-7.73,-7.79,-7.99,-8.15,-8.27,-8.39,-8.64,-9.04,-9.50,-9.92,-9.90,-9.55,-9.25,-8.87,-8.40,-8,-7.54,-7.13,-6.73,-6.35,-6.03,-5.93,-6.03,-6.37,-6.88,-7.63,-8.38,-9.11,-9.50,-9.50,-8.77,-8,-7.25,-6.63,-6.13,-5.88,-5.75,-5.50,-5.26,-5.12,-5.13,-5.38,-5.75,-6.02,-6.43,-6.88,-7.23,-7.50,-7.80,-8.13,-8.38,-8.55,-8.64,-8.65,-8.49,-8.03,-7.51,-7.11,-6.66,-6.40,-6.38,-6.65,-6.88,-7.13,-6.90,-6.37,-5.48,-4.39,-3.17,-2.03,-1,-0.25,0.50,1,1.62,2.50,3.62,4.82,5.96,6.90,7.99,9,10,11,12.08,13.12,14.20,15.23,16.20,16.95,17.37,17.62,17.73,17.76,17.89,18.11,18.34,18.50,18.71,18.86,19,19.13,19.37,19.62,19.86,20.02,20.12,20,19.72,19.36,19.02,18.89,19,19.25,19.57,19.82,19.87,19.76,19.23,18.47,17.46,16.25,15,13.75,12.84,12.40,12.59,13.09,14.11,15.37,16.74,18.12,19.37,20.52,21,21.12,20.73,20.25,19.72,19.12,18.61,18.59,18.75,18.51,-10,-11,-10,-10,-10,-9.63,-8.75,-7.88,-6.79,-5.66,-4.38,-3,-1.54,-0.39,0.35,0.72,0.83,0.88,1.08,1.33,1.62,1.89,2.15,2.46,2.73,2.95,3.10,3.25,3.50,3.87,4.25,4.64,5.12,5.57,5.98,6.36,6.65,6.99,7.34,7.75,8.22,8.71,9.15,9.62,9.99,10.25,10.47,10.60,10.62,10.52,10.26,9.75,8.99,8.08,7.12,6.25,5.38,4.65,4.01,3.38,2.96,2.57,2.25,1.99,1.70,1.15,0.62,-0.03,-0.73,-1.27,-1.74,-2.04,-2.37,-2.63,-2.91,-3.13,-3.25,-3.14,-2.89,-2.52,-2.13,-1.65,-1.17,-0.63,-0.13,0.25,0.47,0.50,0.49,0.47,0.50,0.60,0.71,0.87,0.96,0.85,0.64,0.57,0.50,0.61,0.62,0.62,0.61,0.70,0.86,1.02,1.22,1.37,1.62,1.87,2.13,2.37,2.62,2.90,3.25,3.62,4.12,4.72,5.37,6.08,6.83,7.74,7.74,7.12,6.84,6.74,6.25,6.11,6,6.23,6.75,7.22,7.90,8.71,8.59,8.26,8.12,8.07,8,7.98,7.75,7.38,7.12,7.12,7.33,7.50,7.51,7.37,7.14,7.10,7.12,7.10,6.89,6.51,5.89,5.22,4.51,3.97,3.49,3,2.59,2.09,1.51,0.96,0.35,-0.25,-0.78,-1.25,-1.51,-1.76,-2.30,-3.25,-4,-4.67,-5.28,-5.77,-6.25,-6.49,-6.85,-7.35,-7.52,-7.74,-8,-8.48,-8.92,-9.50,-9.48,-9.10,-8.77,-8.43,-8.13,-7.80,-7.54,-7.29,-7.12,-6.98,-6.91,-7.05,-7.39,-7.92,-8.88,-9.88,-10,-10,-10,-10,-9.88,-9.48,-8.88,-8.18,-7.78,-7.62,-7.42,-7.36,-7.13,-6.89,-6.75,-6.68,-6.88,-7,-7.26,-7.54,-7.86,-8.11,-8.36,-8.61,-8.79,-8.92,-9,-9.02,-9.10,-8.87,-8.50,-8.13,-7.91,-7.65,-7.74,-8.14,-8.50,-9,-8.77,-8.12,-7.14,-5.91,-4.65,-3.37,-2.25,-1.29,-0.36,0.33,1,1.96,3.07,4.34,5.62,6.76,7.86,8.75,9.72,10.62,11.59,12.62,13.70,14.75,15.75,16.62,17.25,17.75,18.07,18.25,18.35,18.45,18.48,18.50,18.50,18.50,18.48,18.50,18.62,18.85,19.08,19.25,19.37,19.25,19.01,18.73,18.50,18.39,18.57,18.87,19.22,19.50,19.60,19.37,19,18.50,17.51,16.25,14.87,13.61,12.70,12.35,12.51,13.09,14.10,15.34,16.74,18.12,19.49,20.62,21.12,21.12,20.72,20.25,19.62,18.90,18.25,17.87,17.87,17.71,-10,-10,-10,-10,-10,-9.63,-8.88,-7.91,-6.93,-5.87,-4.52,-3.13,-1.75,-0.63,0.20,0.62,0.75,0.87,1.07,1.33,1.62,1.98,2.25,2.59,2.86,3.09,3.25,3.48,3.82,4.13,4.57,4.99,5.38,5.85,6.25,6.62,7,7.37,7.83,8.33,8.87,9.47,10.01,10.58,10.97,11.27,11.50,11.63,11.72,11.70,11.50,11.01,10.22,9.25,8.33,7.49,6.73,6,5.37,4.75,4.24,3.75,3.37,3.09,2.75,2.37,1.87,1.21,0.34,-0.25,-0.50,-0.75,-1,-1.25,-1.50,-1.67,-1.73,-1.60,-1.37,-1.02,-0.66,-0.26,0.11,0.72,1.25,1.75,1.97,1.99,1.87,1.82,1.77,1.76,1.86,1.88,1.87,1.75,1.61,1.47,1.37,1.37,1.37,1.37,1.45,1.59,1.75,1.97,2.09,2.20,2.47,2.75,3.07,3.36,3.62,3.98,4.32,4.64,5.10,5.52,6.11,6.83,7.72,8.72,8.72,8.25,8,7.85,7.72,7.25,7.13,7.25,7.87,8.75,9.12,9.57,9.70,9.51,9.37,9.20,9,8.84,8.50,8.12,7.76,7.76,7.99,8.21,8.34,8.36,8.37,8.37,8.35,8.24,7.96,7.40,6.65,5.88,5.25,4.64,4.23,3.84,3.37,2.88,2.37,1.83,1.25,0.75,0.26,-0.11,-0.30,-0.53,-0.89,-1.50,-2.16,-2.75,-3.29,-3.88,-4.50,-4.88,-5.35,-6.02,-6.38,-6.75,-7,-7.50,-8,-8.62,-8.53,-8.18,-7.92,-7.67,-7.48,-7.26,-7.14,-7.05,-7.01,-7.10,-7.28,-7.65,-8.23,-8.86,-10,-11,-10,-11,-11,-10,-10,-10,-9.80,-9.30,-8.99,-8.78,-8.78,-8.75,-8.30,-8.02,-7.77,-7.63,-7.63,-7.73,-7.90,-8.16,-8.38,-8.60,-8.75,-8.91,-9.13,-9.16,-9.23,-9.25,-9.41,-9.24,-8.91,-8.55,-8.50,-8.28,-8.48,-9.13,-9.63,-10,-10,-9.63,-8.73,-7.38,-6.11,-4.74,-3.60,-2.55,-1.73,-0.87,0.08,1.12,2.25,3.50,4.75,5.87,6.88,7.90,8.95,9.98,11,12.10,13.13,14.15,15.15,16.11,16.95,17.62,18.13,18.50,18.62,18.57,18.51,18.46,18.25,18.10,17.90,17.85,17.87,18.08,18.26,18.46,18.50,18.40,18.20,17.97,17.75,17.82,18.09,18.49,18.87,19.12,19.20,18.99,18.59,18.02,17.25,16,14.70,13.46,12.60,12.32,12.50,13.02,14.08,15.33,16.75,18.23,19.57,20.73,21.12,21.12,20.62,20.13,19.50,18.75,17.87,17.23,17,16.87,-10,-10,-10,-10,-10,-9.67,-8.87,-8,-7.13,-6,-4.76,-3.43,-2.17,-1.13,-0.25,0.37,0.62,0.85,1.02,1.34,1.65,2.01,2.37,2.74,3,3.25,3.50,3.75,4.12,4.49,4.87,5.27,5.74,6.13,6.58,6.98,7.37,7.84,8.34,8.87,9.50,10.13,10.75,11.36,11.87,12.25,12.50,12.64,12.74,12.74,12.62,12.25,11.37,10.37,9.39,8.65,8,7.37,6.75,6.12,5.50,4.96,4.50,4.12,3.85,3.50,3,2.32,1.36,1.08,0.75,0.57,0.37,0.23,-0.25,-0.38,-0.28,-0.13,0.12,0.37,0.73,1.09,1.52,2.08,2.62,3,3.24,3.24,3.12,3,2.95,2.89,2.89,2.89,2.84,2.64,2.46,2.25,2.12,2.11,2.12,2.13,2.25,2.45,2.70,2.87,3,3.09,3.36,3.70,4,4.34,4.62,4.99,5.25,5.75,5.89,6.25,6.75,7.25,8.15,8.85,9.20,9.26,9.24,9.08,8.75,8.39,8.25,8.48,9,9.62,10.15,10.51,10.72,10.71,10.57,10.36,10.09,9.73,9.26,8.77,8.47,8.45,8.62,8.95,9.25,9.58,9.82,9.75,9.62,9.39,8.97,8.25,7.38,6.61,5.99,5.49,5.07,4.71,4.25,3.77,3.25,2.73,2.22,1.75,1.35,1,0.75,0.61,0.25,-0.13,-0.62,-1,-1.38,-1.75,-2.03,-2.88,-3.39,-4.13,-4.85,-5.25,-5.63,-6.13,-6.63,-7.14,-7.14,-6.90,-6.74,-6.55,-6.42,-6.38,-6.37,-6.38,-6.48,-6.63,-6.98,-7.42,-8,-8.66,-10,-10,-10,-11,-11,-11,-11,-10,-10,-9.99,-9.73,-9.63,-9.66,-9.40,-9.17,-8.86,-8.53,-8.30,-8.23,-8.25,-8.38,-8.63,-8.77,-8.91,-9.03,-9.13,-9.24,-9.15,-9.11,-9,-9.15,-8.88,-8.52,-8.23,-8.25,-8.18,-8.50,-9.36,-10,-10,-11,-10,-9.91,-8.66,-7.42,-6.18,-5.03,-4.02,-3.04,-2.11,-1,0.21,1.49,2.75,3.87,4.99,5.99,7,8.12,9.25,10.37,11.49,12.52,13.59,14.59,15.50,16.45,17.25,17.88,18.37,18.48,18.50,18.46,18.25,17.99,17.70,17.39,17.25,17.24,17.37,17.52,17.65,17.71,17.59,17.37,17.12,17.07,17.24,17.62,18.15,18.61,18.85,18.75,18.48,18,17.40,16.62,15.62,14.46,13.34,12.57,12.25,12.46,12.95,13.95,15.26,16.75,18.23,19.57,20.72,21.10,21,20.50,19.96,19.25,18.37,17.32,16.26,16.12,16,-10,-10,-10,-10,-10,-9.50,-8.77,-8.05,-7.25,-6.25,-5.04,-3.88,-2.65,-1.63,-0.66,0.12,0.50,0.77,1,1.34,1.72,2.12,2.50,2.87,3.23,3.50,3.76,4.11,4.46,4.84,5.23,5.62,6.07,6.50,6.90,7.37,7.82,8.26,8.82,9.37,10,10.65,11.36,12,12.59,13.01,13.34,13.50,13.60,13.62,13.63,13.27,12.49,11.38,10.50,9.87,9.36,8.75,8.14,7.50,6.75,6.08,5.50,5.12,4.87,4.70,4.25,3.60,2.85,2.38,2.10,1.83,1.61,1.33,1.10,1.01,1.11,1.25,1.46,1.72,2.01,2.40,2.87,3.38,3.87,4.25,4.38,4.37,4.24,4.10,4,3.97,3.96,3.87,3.75,3.51,3.25,2.98,2.83,2.83,2.89,3,3.12,3.38,3.72,3.96,4.08,4.09,4.37,4.70,5,5.27,5.61,5.96,6.12,6.36,6.74,7,7.25,8,8.70,9.27,9.87,10.50,10.38,10.32,9.87,9.49,9.35,9.52,10.01,10.62,11.14,11.58,11.82,11.87,11.75,11.57,11.20,10.71,10.11,9.36,8.88,8.87,9.25,9.73,10.26,10.77,11.12,11.07,10.82,10.45,9.87,9.10,8.25,7.47,6.87,6.37,5.98,5.62,5.25,4.73,4.22,3.65,3.22,2.75,2.37,2.07,1.77,1.57,1.32,1,0.65,0.37,0.09,-0.24,-0.60,-1,-1.13,-1.62,-2.68,-3.26,-3.79,-4.40,-4.93,-5.38,-5.49,-5.38,-5.26,-5.23,-5.15,-5.16,-5.25,-5.36,-5.48,-5.63,-5.98,-6.38,-6.91,-7.53,-8.50,-9.25,-9.92,-10,-11,-11,-11,-11,-10,-10,-10,-10,-10,-9.88,-9.62,-9.27,-8.93,-8.67,-8.54,-8.54,-8.64,-8.88,-9,-9.10,-9.13,-9.05,-9.05,-8.85,-8.55,-8.27,-8.16,-7.75,-7.37,-7.12,-7.23,-7.38,-7.88,-8.78,-9.54,-10,-10,-10,-10,-9.64,-8.63,-7.63,-6.50,-5.38,-4.28,-3.13,-1.91,-0.63,0.71,1.97,3.08,4.08,5.07,6.10,7.14,8.75,9.73,10.85,11.90,12.99,13.99,14.95,15.84,16.64,17.34,17.77,18,18.15,18.13,17.97,17.62,17.27,16.98,16.75,16.65,16.75,16.87,16.96,16.90,16.82,16.62,16.45,16.49,16.82,17.37,17.99,18.45,18.61,18.45,18.07,17.52,16.96,16.22,15.26,14.23,13.25,12.51,12.24,12.37,12.77,13.83,15.25,16.75,18.24,19.50,20.50,20.82,20.71,20.21,19.51,18.75,17.70,16.25,15.88,15.98,16,-10,-10,-10,-10,-10,-9.26,-8.68,-8.12,-7.39,-6.50,-5.38,-4.13,-3,-1.92,-0.92,-0.12,0.38,0.75,1,1.36,1.75,2.21,2.62,3.07,3.40,3.75,4.11,4.46,4.82,5.20,5.59,5.99,6.38,6.86,7.32,7.75,8.25,8.75,9.25,9.84,10.40,11.11,11.75,12.46,13.02,13.52,13.87,14.11,14.22,14.26,14.33,14,13.25,12.39,11.74,11.24,10.74,10.22,9.58,8.76,7.95,7.10,6.48,6.11,5.95,5.87,5.59,5,4.33,3.83,3.37,3.07,2.75,2.60,2.47,2.39,2.49,2.61,2.75,2.97,3.25,3.70,4.14,4.63,5.02,5.26,5.37,5.34,5.23,5.12,5.01,5,4.95,4.85,4.71,4.37,4,3.64,3.50,3.51,3.73,3.90,4.15,4.50,4.87,5.13,5.26,5.37,5.50,5.75,5.99,6.25,6.50,6.82,7,7.15,7.34,7.72,8.12,8.70,9.26,9.98,10.65,11.26,11.50,11.26,10.87,10.50,10.37,10.59,11.07,11.62,12.21,12.62,12.95,13.08,13.01,12.82,12.37,11.75,11,10.21,9.58,9.48,9.84,10.46,11.13,11.75,12.12,12.02,11.76,11.35,10.75,10,9.25,8.50,7.86,7.32,6.87,6.50,6.13,5.71,5.22,4.71,4.25,3.84,3.40,3.11,2.83,2.58,2.33,2.10,1.85,1.61,1.37,1.11,0.76,0.47,0.12,-0.13,-0.50,-1.12,-1.90,-2.63,-3.13,-3.50,-3.68,-3.75,-3.68,-3.68,-3.75,-3.80,-3.92,-4.04,-4.14,-4.26,-4.48,-4.75,-5.16,-5.68,-6.38,-7.25,-8.23,-9.39,-10,-10,-11,-11,-11,-10,-10,-10,-10,-9.98,-9.67,-9.38,-9.04,-8.79,-8.67,-8.66,-8.75,-8.93,-9.01,-9,-8.93,-8.75,-8.61,-8.13,-7.63,-7.13,-6.68,-6.11,-5.63,-5.43,-5.62,-6,-6.65,-7.62,-8.48,-9.50,-10,-10,-10,-10,-9.63,-8.88,-7.86,-6.68,-5.49,-4.16,-2.79,-1.38,-0.01,1.25,2.37,3.35,4.25,5.27,6.12,7.77,9.02,10.24,11.37,12.46,13.45,14.36,15.14,15.87,16.50,16.95,17.33,17.57,17.62,17.50,17.25,16.88,16.60,16.35,16.24,16.24,16.25,16.25,16.24,16.12,15.98,15.89,16.12,16.62,17.32,17.96,18.38,18.50,18.32,17.86,17.32,16.73,15.99,15.12,14.12,13.20,12.50,12.14,12.25,12.62,13.72,15.25,16.72,18.25,19.46,20.25,20.45,20.22,19.75,19.11,18.32,17.23,16.10,15.07,15.01,14.98,-10,-10,-10,-10,-9.75,-9.13,-8.62,-8.02,-7.28,-6.38,-5.30,-4.15,-3.02,-2,-1,-0.25,0.35,0.71,1.01,1.37,1.83,2.26,2.75,3.23,3.62,4.01,4.40,4.83,5.20,5.58,5.95,6.35,6.75,7.23,7.70,8.15,8.64,9.13,9.64,10.20,10.75,11.37,12.02,12.71,13.33,13.84,14.21,14.47,14.62,14.75,14.76,14.50,13.98,13.39,12.96,12.60,12.12,11.59,10.83,10.08,9.09,8.15,7.37,7.07,6.98,6.87,6.62,6.12,5.70,5.23,4.72,4.25,4,3.87,3.87,3.87,3.89,3.99,4.02,4.14,4.46,4.87,5.37,5.83,6.12,6.25,6.32,6.27,6.25,6.15,6.10,6,5.96,5.84,5.59,5.23,4.75,4.37,4.22,4.34,4.58,4.87,5.25,5.70,6.12,6.47,6.62,6.65,6.73,6.82,6.89,7.11,7.37,7.70,7.90,8.02,8.20,8.25,8.75,9.25,9.88,10.62,11.37,12,12.36,12.14,11.83,11.50,11.37,11.62,12.11,12.71,13.25,13.75,14.10,14.25,14.27,14.12,13.65,12.86,11.90,10.98,10.14,9.96,10.39,11.12,11.87,12.52,12.87,12.90,12.70,12.27,11.75,11.12,10.39,9.65,8.95,8.25,7.74,7.35,7,6.70,6.25,5.77,5.36,4.87,4.49,4.12,3.85,3.59,3.36,3.12,2.89,2.71,2.48,2.22,1.90,1.62,1.32,0.97,0.50,0.02,-0.42,-0.92,-1.37,-1.63,-2,-2.03,-2.05,-2.13,-2.25,-2.38,-2.54,-2.65,-2.66,-2.65,-2.75,-2.80,-3.25,-3.64,-4.29,-5.13,-6.13,-7.16,-8.63,-9.25,-10,-11,-10,-10,-10,-10,-10,-9.78,-9.51,-9.24,-8.92,-8.75,-8.63,-8.63,-8.73,-8.85,-8.85,-8.75,-8.50,-8.14,-7.77,-7.13,-6.39,-5.65,-4.93,-4.13,-3.52,-3.38,-3.63,-4.28,-5.11,-5.99,-6.88,-7.93,-8.89,-9.66,-10,-10,-10,-10,-9.10,-7.89,-6.54,-5.12,-3.61,-2.11,-0.63,0.70,1.84,2.75,3.62,4.63,5.77,7,8.35,9.64,10.87,11.99,12.97,13.82,14.50,15.10,15.60,16.07,16.46,16.75,16.96,16.96,16.76,16.50,16.25,16,15.84,15.75,15.72,15.64,15.61,15.50,15.49,15.60,15.98,16.62,17.37,18.08,18.50,18.62,18.37,17.95,17.37,16.75,15.98,15.10,14.12,13.14,12.46,12.10,12.12,12.40,13.72,15.25,16.77,18.34,19.46,20.12,20.20,20,19.35,18.86,18,17,16,15.10,15,14.96,-10,-10,-10,-10,-9.64,-9.04,-8.43,-7.92,-7.25,-6.38,-5.27,-4.13,-2.91,-1.88,-0.90,-0.14,0.36,0.74,1.10,1.48,1.89,2.39,2.90,3.40,3.88,4.37,4.76,5.21,5.60,5.97,6.33,6.71,7.12,7.57,8.02,8.52,9.01,9.50,9.99,10.50,11,11.61,12.21,12.85,13.40,13.96,14.36,14.64,14.87,15.01,15.11,14.97,14.62,14.32,14.10,13.87,13.50,12.75,11.88,11.07,10.10,9.12,8.37,8,7.98,7.95,7.90,7,7,6.98,5.88,5.37,5.22,5.25,5.37,5.40,5.48,5.49,5.45,5.38,5.59,6,6.50,6.99,7.24,7.37,7.45,7.45,7.38,7.34,7.24,7.12,7,6.84,6.50,6.10,5.58,5.22,5.09,5.15,5.40,5.83,6.26,6.87,7.38,7.75,7.87,7.87,7.85,7.75,7.75,7.87,8.21,8.52,8.87,8.98,9.08,9.22,9.32,9.87,10.50,11.25,12,12.64,13,12.97,12.70,12.46,12.40,12.70,13.20,13.75,14.37,14.86,15.22,15.40,15.50,15.37,14.87,13.96,12.84,11.75,11,10.75,11.11,11.84,12.62,13.35,13.75,13.86,13.71,13.37,12.90,12.37,11.71,10.95,10.11,9.25,8.62,8.23,7.96,7.73,7.37,6.99,6.50,6,5.51,5.13,4.87,4.61,4.37,4.12,3.89,3.72,3.49,3.24,2.96,2.62,2.27,1.89,1.50,1.02,0.62,0.25,-0.02,-0.26,-0.54,-0.63,-0.51,-0.52,-0.65,-0.93,-1.17,-1.29,-1.25,-0.75,-0.87,-1.03,-1.50,-1.88,-2.38,-3,-3.86,-4.92,-6,-7.05,-8.36,-9.64,-9.88,-10,-10,-9.89,-9.75,-9.38,-9.13,-8.89,-8.67,-8.53,-8.50,-8.50,-8.52,-8.55,-8.49,-8.25,-7.86,-7.28,-6.65,-5.86,-4.93,-4.04,-3.13,-2.16,-1.13,-0.63,-1.43,-2.52,-3.27,-4.10,-5,-6.13,-7.37,-8.54,-9.66,-10,-11,-11,-10,-9.11,-7.63,-6,-4.38,-2.75,-1.18,0.24,1.46,2.37,3.33,4.26,5.35,6.12,7.77,9.12,10.39,11.50,12.48,13.24,13.83,14.32,14.75,15.13,15.52,15.87,16.14,16.32,16.25,16.11,15.87,15.64,15.48,15.33,15.22,15.12,15.07,15,15.12,15.39,15.98,16.74,17.52,18.32,18.75,18.85,18.60,18.13,17.59,16.87,16,15,14,13.02,12.25,11.89,11.99,12.20,13.75,15.22,16.87,18.75,19.75,20.21,20.21,20,19.82,18.87,18,17,16,15.11,15,14.90,-9.93,-10,-10,-9.87,-9.42,-8.88,-8.40,-8,-7.37,-6.41,-5.25,-3.92,-2.65,-1.53,-0.63,0.07,0.47,0.83,1.15,1.59,2.02,2.57,3.12,3.63,4.20,4.71,5.12,5.59,5.99,6.36,6.71,7.02,7.45,7.87,8.35,8.85,9.35,9.83,10.25,10.72,11.21,11.74,12.32,12.87,13.47,14,14.39,14.75,15.01,15.25,15.37,15.37,15.21,15.01,15,14.86,14.37,13.50,12.59,11.73,10.85,10,9.35,9,8.99,8.99,8.87,8.88,8.12,7.88,7.33,6.64,6.60,6.65,6.85,7,7.09,7.09,7,6.87,6.75,7.08,7.51,8.07,8.48,8.70,8.75,8.75,8.72,8.62,8.48,8.32,8.12,7.87,7.50,7,6.49,6.07,5.96,6.09,6.35,6.76,7.33,7.97,8.50,8.86,8.98,8.95,8.83,8.62,8.52,8.62,8.97,9.38,9.75,9.87,10,10.10,10.24,10.58,11.12,11.87,12.62,13.32,13.71,13.75,13.60,13.40,13.49,13.75,14.25,14.87,15.40,15.88,16.25,16.47,16.58,16.37,15.87,14.87,13.62,12.50,11.73,11.50,11.87,12.52,13.37,14.12,14.65,14.87,14.82,14.58,14.21,13.72,13.10,12.27,11.32,10.33,9.58,9.13,8.97,8.82,8.58,8.21,7.73,7.15,6.62,6.23,5.88,5.62,5.37,5.12,4.87,4.70,4.46,4.15,3.87,3.52,3.15,2.76,2.37,1.97,1.57,1.15,0.87,0.62,0.37,0.25,0.25,0.25,0.20,0.07,-0.05,-0.13,0,0.12,0.12,-0.01,-0.25,-0.40,-0.88,-1.27,-1.88,-2.65,-3.38,-4.53,-5.74,-7.03,-8.13,-8.93,-9.38,-9.13,-9.02,-8.75,-8.60,-8.43,-8.37,-8.29,-8.35,-8.37,-8.30,-8.24,-7.92,-7.50,-6.88,-6.28,-5.40,-4.40,-3.38,-2.35,-1.28,-0.24,0.37,0.12,-0.25,-0.85,-1.38,-1.85,-2.87,-4.03,-5.63,-7.35,-8.93,-10,-11,-12,-11,-10,-8.74,-6.93,-5.13,-3.38,-1.73,-0.18,1.20,2.12,3.09,4.01,5.01,6.10,7.37,8.63,9.85,10.89,11.87,12.62,13.22,13.62,14,14.35,14.71,15.08,15.37,15.62,15.74,15.71,15.57,15.37,15.13,14.96,14.75,14.62,14.58,14.62,14.86,15.33,16,16.87,17.75,18.58,19.02,19.09,18.77,18.33,17.63,16.82,15.75,14.65,13.61,12.70,11.97,11.65,11.88,12.22,13.76,15.23,17,18.84,20.75,20.75,20.75,20.21,19.87,19.15,18.14,17.13,16.12,15.12,15.10,14.89,-9.51,-9.64,-9.63,-9.41,-9,-8.50,-8.38,-8,-7.38,-6.42,-5.25,-3.88,-2.51,-1.37,-0.41,0.22,0.58,0.89,1.26,1.71,2.15,2.73,3.27,3.87,4.48,5.01,5.50,5.97,6.37,6.74,7.08,7.37,7.75,8.12,8.58,9.02,9.51,9.97,10.38,10.86,11.32,11.82,12.36,12.89,13.48,13.99,14.45,14.83,15.12,15.38,15.61,15.63,15.62,15.52,15.60,15.25,14.62,13.75,12.87,12.01,11.32,10.72,10.25,10,9.88,9.87,9.89,9.88,9.95,9.50,8.75,8.10,7.88,8,8.24,8.48,8.63,8.70,8.57,8.36,8.15,8.21,8.50,9.11,9.75,10.20,10.14,10.13,10.11,10,9.84,9.62,9.35,8.98,8.50,7.87,7.32,6.90,6.76,6.99,7.25,7.75,8.33,8.99,9.52,9.87,9.99,9.88,9.73,9.46,9.25,9.34,9.64,10.11,10.50,10.75,10.95,11.01,11.20,11.37,11.87,12.57,13.34,14,14.40,14.58,14.52,14.50,14.60,14.88,15.37,15.88,16.40,16.86,17.12,17.25,17.33,17.09,16.50,15.46,14.25,13.21,12.45,12.25,12.62,13.36,14.15,14.98,15.61,15.89,15.98,15.76,15.49,15.07,14.48,13.62,12.52,11.46,10.61,10.15,10,9.95,9.83,9.50,9,8.39,7.83,7.34,6.99,6.64,6.37,6.12,5.87,5.63,5.37,5.08,4.73,4.37,3.98,3.58,3.15,2.75,2.37,1.95,1.52,1.25,1,0.96,0.95,0.96,0.96,0.87,0.87,0.87,0.87,0.95,0.87,0.83,0.70,0.59,0.35,0,-0.38,-0.88,-1.25,-2.13,-3.25,-4.50,-5.89,-7.01,-7.78,-7.87,-7.93,-7.91,-7.88,-7.88,-7.92,-8.03,-8.15,-8.25,-8.15,-7.90,-7.39,-6.64,-5.75,-4.75,-3.66,-2.63,-1.63,-0.52,0.25,0.62,0.90,0.75,0.57,0.36,0.10,-0.25,-1,-2.04,-3.75,-5.88,-7.80,-9.79,-11,-12,-12,-11,-9.77,-7.88,-5.88,-3.98,-2.16,-0.53,0.87,1.95,2.87,3.87,4.87,5.95,7.12,8.25,9.37,10.38,11.37,12.13,12.75,13.12,13.39,13.70,13.98,14.33,14.64,14.97,15.15,15.25,15.24,15.10,14.87,14.62,14.40,14.25,14.15,14.27,14.62,15.25,16.02,16.96,17.88,18.75,19.22,19.21,18.83,18.15,17.34,16.26,15.10,13.89,12.87,12.08,11.50,11.48,11.88,12.86,14,15.24,17.12,18.99,20.75,21.13,21.10,20.75,20.22,19.76,18.82,17.87,16.99,16.12,15.12,14.87,-9.13,-9.13,-9.10,-8.90,-8.64,-8.37,-8,-7.63,-7.04,-6.62,-5.37,-3.88,-2.40,-1.14,-0.25,0.33,0.62,1,1.37,1.82,2.27,2.86,3.47,4.09,4.72,5.33,5.83,6.27,6.74,7.11,7.39,7.72,8,8.36,8.74,9.14,9.62,10.02,10.48,10.88,11.34,11.83,12.35,12.87,13.45,13.97,14.40,14.85,15.21,15.50,15.71,15.76,15.77,15.63,15.50,15.15,14.60,13.84,13,12.25,11.72,11.27,11,10.84,10.75,10.76,10.87,11.02,11.24,11.09,10.13,9.39,9.13,9.24,9.49,9.83,10.12,10.25,10.12,9.83,9.51,9.40,9.62,10.20,10.87,11.38,11.52,11.52,11.50,11.38,11.25,11,10.62,10.13,9.50,8.75,8.08,7.63,7.50,7.83,8.24,8.75,9.36,10,10.57,10.87,10.99,10.87,10.62,10.25,9.96,10,10.27,10.75,11.25,11.63,11.87,12,12.13,12.33,12.75,13.38,14.12,14.76,15.25,15.49,15.50,15.57,15.70,15.97,16.37,16.87,17.33,17.62,17.77,17.83,17.72,17.35,16.64,15.64,14.63,13.75,13.12,13,13.48,14.25,15.12,15.97,16.62,17,17.11,16.89,16.60,16.14,15.62,14.75,13.63,12.50,11.63,11.24,11.11,11.09,11.07,10.82,10.33,9.71,9.10,8.51,8.11,7.73,7.37,7.12,6.87,6.60,6.27,5.90,5.50,5.09,4.62,4.25,3.87,3.50,3.07,2.59,2.12,1.75,1.50,1.46,1.49,1.57,1.62,1.63,1.63,1.62,1.62,1.62,1.58,1.50,1.37,1.35,1.12,0.87,0.62,0.34,0.11,-0.29,-1.18,-2.28,-3.68,-4.79,-5.68,-6.16,-6.54,-6.79,-7.02,-7.25,-7.43,-7.75,-8.13,-8.25,-8.12,-7.65,-6.75,-5.63,-4.26,-3,-1.78,-0.67,0.25,0.71,0.96,1.12,1.36,1.35,1.27,1.14,1.02,0.89,0.25,-0.25,-2.25,-4.50,-6.63,-8.88,-11,-12,-13,-12,-10,-8.65,-6.63,-4.63,-2.68,-0.91,0.75,1.75,2.62,3.62,4.72,5.84,6.88,8,9.07,10.08,11,11.77,12.40,12.75,13,13.22,13.40,13.70,14,14.37,14.63,14.87,14.95,14.85,14.62,14.37,14.12,13.96,13.87,14.07,14.50,15.21,16.01,16.96,17.90,18.73,19.14,19.10,18.61,17.75,16.71,15.40,14.12,12.87,11.87,11.25,10.99,11.14,11.87,12.98,14.25,15.76,17.25,19.11,20.75,21.75,21.75,21.10,20.75,20.08,19.21,18.82,17.83,16.85,16.10,15.87,-8.74,-8.68,-8.64,-8.52,-8.38,-8.13,-7.77,-7.38,-6.86,-6.13,-5.50,-4,-2.51,-1.25,-0.28,0.25,0.62,1,1.40,1.87,2.37,2.96,3.58,4.23,4.87,5.52,6.10,6.61,7.02,7.40,7.75,8,8.25,8.52,8.87,9.24,9.62,10.01,10.46,10.86,11.26,11.75,12.25,12.83,13.37,13.87,14.37,14.83,15.22,15.50,15.75,15.75,15.74,15.62,15.37,14.98,14.37,13.73,13.02,12.48,12.07,11.83,11.62,11.52,11.50,11.61,11.75,12,12.14,11.90,11.35,10.70,10.25,10.34,10.62,11,11.46,11.65,11.62,11.25,10.88,10.71,10.84,11.26,11.87,12.60,12.75,12.82,12.77,12.75,12.65,12.47,12,11.36,10.50,9.59,8.75,8.34,8.33,8.62,9.15,9.84,10.50,11.12,11.62,11.87,11.99,11.87,11.59,11.12,10.74,10.61,10.89,11.45,12,12.50,12.86,13,13.15,13.36,13.75,14.37,15.07,15.70,16.21,16.46,16.50,16.51,16.63,16.88,17.25,17.73,18.09,18.25,18.32,18.12,17.75,17.20,16.50,15.72,14.89,14.20,13.75,13.84,14.37,15.25,16.20,17.09,17.75,18.09,18.12,17.84,17.38,16.87,16.34,15.50,14.49,13.45,12.62,12.25,12.20,12.23,12.25,12.07,11.62,11,10.37,9.82,9.25,8.77,8.39,8.11,7.84,7.52,7.23,6.75,6.24,5.74,5.25,4.87,4.50,4.12,3.64,3.12,2.58,2.12,1.84,1.83,1.95,2.12,2.32,2.37,2.37,2.36,2.25,2.23,2.12,2.11,2.07,1.98,1.85,1.62,1.38,1.12,0.96,0.62,0.25,-0.60,-1.65,-2.74,-3.61,-4.36,-4.98,-5.50,-5.92,-6.30,-6.63,-7,-7.39,-7.75,-9.25,-7.23,-5.43,-3.99,-2.25,-1,-0.27,0.34,0.83,1.12,1.34,1.50,1.75,1.88,2,1.87,1.70,1.38,1.01,0.22,-1.13,-3.24,-5.38,-7.79,-10,-12,-13,-12,-11,-9.43,-7.38,-5.25,-3.25,-1.36,0.34,1.48,2.32,3.25,4.37,5.61,6.74,7.87,8.95,9.90,10.77,11.52,12.11,12.39,12.63,12.82,12.95,13.12,13.45,13.76,14.13,14.48,14.62,14.62,14.45,14.13,13.87,13.72,13.65,13.88,14.39,15.12,15.97,16.86,17.75,18.50,18.87,18.75,18.23,17.25,16,14.50,13.07,11.77,10.89,10.50,10.38,10.85,11.34,12.99,14.75,16.21,17.75,19.25,20.74,21.25,21.75,21.13,20.75,20.75,19.76,18.76,18.08,17.13,16.86,15.87,-8.36,-8.36,-8.30,-8.25,-8.13,-7.92,-7.63,-7.23,-6.64,-6,-5.13,-4.16,-2.75,-1.50,-0.50,0.12,0.60,1,1.45,1.87,2.39,3,3.62,4.32,5,5.72,6.32,6.85,7.33,7.73,8.01,8.27,8.50,8.74,8.98,9.25,9.62,9.98,10.36,10.75,11.14,11.62,12.12,12.70,13.25,13.75,14.26,14.75,15.14,15.50,15.62,15.71,15.62,15.37,15.02,14.62,14.12,13.59,13.09,12.63,12.39,12.32,12.25,12.22,12.25,12.35,12.51,12.83,13,12.82,12.33,11.74,11.37,11.33,11.63,12.12,12.62,13,13,12.62,12.25,12,12.01,12.37,12.95,13.45,13.85,13.96,13.99,14,14.01,13.85,13.27,12.40,11.37,10.36,9.47,8.98,9,9.34,10.08,10.88,11.73,12.36,12.77,13,13.07,12.88,12.58,12.07,11.52,11.33,11.62,12.15,12.76,13.37,13.75,14,14.24,14.49,14.87,15.39,16.01,16.62,17.12,17.37,17.39,17.38,17.49,17.70,18,18.37,18.64,18.75,18.62,18.13,17.62,17,16.36,15.70,15.09,14.58,14.39,14.70,15.37,16.27,17.33,18.36,18.98,19.14,18.98,18.50,17.90,17.27,16.63,15.87,14.99,14.12,13.51,13.25,13.25,13.37,13.47,13.33,12.87,12.27,11.65,11.07,10.47,9.88,9.46,9.09,8.77,8.49,8.11,7.57,6.96,6.37,5.86,5.45,5.09,4.64,4.12,3.51,2.87,2.33,2,2.08,2.34,2.65,2.95,3.22,3.07,2.95,2.84,2.75,2.70,2.64,2.62,2.61,2.50,2.35,2.12,1.84,1.57,1.20,0.75,0.37,-0.15,-0.66,-1.49,-2.52,-3.30,-4.01,-4.63,-5.15,-5.50,-5.74,-5.80,-6,-5.75,-4.88,-3.50,-1.88,-0.75,0.12,0.58,0.86,1.12,1.37,1.61,1.84,2.12,2.35,2.50,2.37,2.20,1.87,1.59,0.65,-0.38,-2.16,-4.18,-6.88,-9.39,-11,-13,-13,-12,-10,-8.13,-5.99,-3.88,-1.93,-0.40,0.77,1.75,2.71,3.87,5.22,6.50,7.75,8.87,9.88,10.70,11.25,11.74,12.02,12.25,12.36,12.39,12.59,12.86,13.24,13.63,14.08,14.34,14.37,14.21,13.87,13.62,13.50,13.50,13.82,14.36,15.02,15.84,16.63,17.47,18.10,18.39,18.37,17.87,16.87,15.48,13.87,12.25,11,10.20,9.87,9.88,10.47,11.25,13,14.85,16.73,18.10,19.73,20.73,20.89,20.75,20.74,20.75,19.75,19.13,18.76,18.08,17.83,17.12,16.87,-8.01,-8.04,-8.11,-8.12,-8.02,-7.88,-7.60,-7.13,-6.54,-5.87,-5.04,-4.28,-2.92,-1.75,-0.75,0,0.57,1,1.40,1.87,2.40,3,3.63,4.36,5.09,5.83,6.46,7,7.50,7.96,8.27,8.57,8.75,8.90,9.11,9.32,9.59,9.87,10.24,10.60,11,11.46,11.96,12.49,13.02,13.61,14.12,14.62,15.07,15.34,15.50,15.51,15.37,15.02,14.63,14.24,13.83,13.40,13.10,12.87,12.76,12.75,12.82,12.85,12.88,13,13.22,13.48,13.63,13.51,13.13,12.65,12.38,12.45,12.70,13.23,13.75,14.14,14.21,13.87,13.50,13.25,13.24,13.50,13.96,14.45,14.75,14.99,15.01,15.11,15.13,14.90,14.25,13.25,12.11,11,10.12,9.61,9.62,10.08,10.87,11.90,12.90,13.71,14.08,14.23,14.23,14,13.61,13.01,12.50,12.24,12.49,12.97,13.59,14.13,14.62,15,15.33,15.62,16,16.50,17,17.60,18.02,18.25,18.14,18.10,18.10,18.24,18.50,18.72,18.84,18.77,18.50,17.97,17.38,16.84,16.23,15.62,15.21,14.95,15.08,15.51,16.33,17.26,18.37,19.38,20.01,20.07,19.62,18.98,18.25,17.51,16.84,16.11,15.37,14.75,14.37,14.25,14.35,14.50,14.65,14.52,14.12,13.52,12.90,12.25,11.61,10.99,10.46,10,9.71,9.36,8.95,8.34,7.65,7.08,6.50,6.09,5.62,5.13,4.58,3.77,3.07,2.37,2.12,2,2.88,3.09,3.75,3.75,3.62,3.50,3.37,3.25,3.20,3.20,3.22,3.24,3.15,3.01,2.75,2.49,2.07,1.62,1.21,0.85,0.50,0.21,-0.38,-0.88,-1.75,-2.50,-3.25,-3.77,-4.51,-4.13,-4,-3.68,-3,-2.42,-1.39,-0.55,0.25,0.96,1.25,1.37,1.57,1.74,1.87,2.08,2.25,2.57,2.84,2.75,2.60,2.46,2.12,1.25,0.25,-1.39,-3.38,-6.13,-8.67,-10,-12,-12,-12,-10,-8.88,-6.88,-4.88,-3,-1.37,-0.14,0.87,1.87,3.12,4.62,6.25,7.63,8.87,9.89,10.62,11.08,11.38,11.62,11.75,11.76,11.82,11.95,12.21,12.62,13.12,13.62,13.95,14,13.82,13.50,13.26,13.22,13.35,13.70,14.24,14.87,15.62,16.37,17.02,17.59,17.87,17.95,17.57,16.62,15.14,13.50,11.87,10.61,9.83,9.52,9.52,10.25,11.25,13,14.95,16.73,18.12,19.73,20.73,20.73,19.74,19.25,18.98,18.75,18.23,17.88,17.77,17.83,17.85,16.87,-7.80,-7.88,-8,-8.04,-8.04,-7.90,-7.63,-7.13,-6.51,-5.76,-4.98,-4.13,-2.92,-1.87,-0.87,-0.10,0.50,0.98,1.38,1.87,2.39,3,3.64,4.37,5.12,5.87,6.52,7.12,7.65,8.12,8.50,8.75,8.98,9.12,9.24,9.37,9.58,9.82,10.11,10.40,10.77,11.23,11.71,12.23,12.76,13.37,13.89,14.45,14.83,15.12,15.26,15.25,15,14.62,14.25,13.87,13.51,13.26,13.12,13.11,13.12,13.25,13.37,13.48,13.57,13.65,13.83,14,14.13,14.09,13.83,13.50,13.35,13.40,13.75,14.27,14.85,15.25,15.27,15,14.62,14.37,14.36,14.58,14.97,15.40,15.75,15.87,15.98,16,16,15.71,14.95,13.85,12.65,11.60,10.70,10.20,10.20,10.63,11.48,12.71,13.90,14.90,15.25,15.50,15.49,15.22,14.72,14.10,13.50,13.22,13.37,13.76,14.37,14.98,15.51,16,16.39,16.76,17.13,17.52,17.98,18.40,18.87,18.98,18.64,18.49,18.38,18.45,18.51,18.61,18.59,18.45,18.12,17.75,17.25,16.72,16.12,15.70,15.39,15.37,15.72,16.33,17.12,18.11,19.12,20.12,20.77,20.64,20,19.22,18.45,17.73,17.01,16.36,15.82,15.40,15.25,15.24,15.36,15.62,15.77,15.63,15.23,14.62,14,13.37,12.64,11.98,11.37,10.88,10.50,10.12,9.72,9.11,8.46,7.87,7.27,6.77,6.25,5.62,4.84,3.99,3.14,2.50,2.37,2.85,3,3.09,3.87,4.11,4.11,4.02,3.86,3.65,3.62,3.62,3.75,3.89,4,3.84,3.52,3.11,2.57,2,1.50,1.20,0.88,0.63,0.37,-0.04,-0.63,-1.15,-1.63,-2.05,-2.28,-2.41,-2.14,-1.79,-1.28,-0.65,-0.13,0.45,1.07,1.63,1.95,2.12,2.20,2.25,2.25,2.34,2.37,2.74,2.87,2.87,2.87,2.63,2.25,1.62,0.86,-1,-3,-5.65,-8.16,-10,-11,-12,-12,-11,-9.66,-7.76,-5.88,-4.16,-2.74,-1.42,-0.30,0.84,2.32,4.09,6.07,7.50,8.84,9.96,10.62,10.98,11.12,11.22,11.21,11.12,11.12,11.15,11.46,11.87,12.49,13,13.37,13.38,13.23,12.96,12.77,12.82,13,13.45,14,14.64,15.37,16,16.60,17.08,17.38,17.51,17.25,16.38,14.97,13.27,11.72,10.47,9.65,9.37,9.45,10.08,11.25,13,14.90,16.73,17.83,18.73,19.01,18.85,18.25,17.76,17.25,17.24,17.12,17.12,17.21,17.15,17.12,16.86,-7.75,-7.86,-8,-8.15,-8.23,-8.10,-7.75,-7.23,-6.50,-5.66,-4.77,-3.89,-2.76,-1.75,-0.78,-0.05,0.50,0.98,1.37,1.86,2.37,3,3.64,4.37,5.12,5.88,6.61,7.23,7.75,8.25,8.62,8.96,9.13,9.26,9.37,9.46,9.61,9.75,10,10.25,10.61,10.99,11.39,11.89,12.47,13.01,13.62,14.12,14.50,14.82,14.89,14.83,14.58,14.22,13.87,13.52,13.34,13.22,13.22,13.34,13.50,13.75,13.97,14.12,14.24,14.32,14.37,14.47,14.50,14.48,14.32,14.12,14.09,14.25,14.71,15.25,15.86,16.20,16.20,15.88,15.51,15.25,15.25,15.47,15.87,16.34,16.62,16.75,16.82,16.75,16.62,16.25,15.38,14.33,13.15,12.11,11.25,10.77,10.75,11.15,11.89,13.08,14.37,15.60,16.25,16.72,16.72,16.46,15.89,15.25,14.62,14.21,14.26,14.62,15.21,15.82,16.45,17,17.50,17.90,18.25,18.52,18.83,19.08,19.33,19.10,18.85,18.59,18.39,18.36,18.35,18.33,18.25,18.12,17.90,17.62,17.21,16.64,16.25,15.97,15.86,16,16.45,17.01,17.77,18.64,19.62,20.37,21.09,20.87,20.12,19.26,18.50,17.87,17.25,16.75,16.38,16.23,16.12,16.14,16.25,16.52,16.63,16.49,16.02,15.48,14.87,14.25,13.57,12.86,12.24,11.72,11.26,10.87,10.49,9.95,9.33,8.75,8.12,7.57,6.86,6,5.07,4.10,3.32,2.86,2.89,3.12,3.11,3.87,4.12,4.85,4.85,4.85,4.12,4.12,4.12,4.12,4.12,4.87,4.87,4.89,4.13,3.72,3.08,2.46,1.87,1.50,1.25,1.10,0.88,0.62,0.33,-0.04,-0.38,-0.25,-0.88,-0.93,-0.75,-0.18,-0.16,0.20,0.65,1.12,1.64,2.15,2.58,2.77,2.95,2.87,2.71,2.14,2.98,2.98,2.98,2.96,2.87,2.62,2.24,1.62,0.87,-0.87,-2.89,-5.48,-7.88,-10,-11,-12,-12,-11,-10,-8.60,-6.80,-5.25,-3.86,-2.66,-1.51,0,1.75,3.75,5.72,7.38,8.75,9.84,10.50,10.86,10.98,10.84,10.71,10.50,10.37,10.34,10.57,11,11.62,12.22,12.52,12.59,12.39,12.22,12.12,12.25,12.52,13.01,13.62,14.33,14.99,15.60,16.12,16.61,16.95,17.09,16.83,15.99,14.61,13,11.57,10.37,9.60,9.26,9.32,10.07,11.25,12.87,14.73,16.73,17.12,17.73,17.73,17.23,16.75,16.25,16.12,16.01,16.01,16.12,16.76,16.82,16.83,16.86,-7.77,-7.92,-8.16,-8.38,-8.49,-8.35,-7.92,-7.28,-6.50,-5.53,-4.54,-3.55,-2.50,-1.50,-0.63,0.02,0.52,0.98,1.37,1.83,2.37,3,3.65,4.37,5.12,5.89,6.62,7.25,7.83,8.33,8.75,9.08,9.27,9.45,9.50,9.57,9.64,9.75,9.96,10.14,10.45,10.75,11.12,11.60,12.10,12.62,13.22,13.65,14.08,14.33,14.37,14.26,14.02,13.76,13.51,13.33,13.22,13.22,13.35,13.62,13.95,14.26,14.60,14.82,14.90,14.97,14.95,14.87,14.77,14.70,14.57,14.49,14.52,14.86,15.32,15.87,16.57,16.77,16.75,16.45,16.08,15.86,15.87,16.12,16.61,17.09,17.39,17.50,17.50,17.46,17.20,16.71,15.84,14.75,13.64,12.62,11.87,11.49,11.39,11.72,12.25,13.22,14.37,15.60,16.71,17.50,17.84,17.62,17.15,16.51,15.85,15.32,15.25,15.51,16.01,16.62,17.26,17.99,18.61,19.02,19.35,19.49,19.50,19.48,19.34,19.08,18.75,18.49,18.25,18.12,18.10,18.07,18,17.96,17.84,17.62,17.37,17.07,16.83,16.71,16.72,16.89,17.25,17.75,18.37,19.08,19.85,20.50,21.02,20.82,20.01,19.27,18.59,18.02,17.62,17.37,17.21,17.10,17,17,17.02,17.15,17.14,16.90,16.51,16.02,15.50,14.90,14.25,13.60,12.96,12.37,11.97,11.59,11.24,10.75,10.21,9.62,8.96,8.21,7.38,6.34,5.23,4.23,3.62,3.37,3.47,3.73,4.12,4.85,5.10,5.14,5.15,5.15,5.12,5,5,5,5.12,5.12,5.12,5.10,4.73,4.12,3.51,2.87,2.34,1.87,1.62,1.58,1.50,1.37,1.12,0.87,0.62,0.37,0.12,0,0.12,0.33,0.52,0.86,1.25,1.75,2.25,2.75,3.23,3.46,3.51,3.48,3.14,3,2.95,2.99,2.97,2.88,2.75,2.50,2,1.47,0.73,-0.79,-2.91,-5.38,-7.74,-9.85,-11,-12,-12,-12,-10,-9.13,-7.50,-6,-4.73,-3.52,-2.64,-0.50,1.50,3.50,5.37,7.22,8.77,9.63,10.15,10.50,10.62,10.32,10.12,9.85,9.52,9.39,9.52,9.98,10.51,11.10,11.45,11.50,11.38,11.27,11.33,11.50,11.88,12.48,13.12,13.84,14.50,15.12,15.72,16.14,16.50,16.60,16.25,15.38,14.12,12.70,11.32,10.13,9.37,9.09,9.25,10.07,11.24,12.73,14.25,15.73,16.21,16.73,16.22,15.76,15.25,15.12,15,15,15,15.12,15.21,15.15,15.14,14.86,-7.98,-8.14,-8.43,-8.74,-8.78,-8.62,-8.12,-7.36,-6.38,-5.36,-4.25,-3.14,-2.03,-1.13,-0.30,0.22,0.62,0.98,1.32,1.77,2.36,3,3.64,4.37,5.12,5.89,6.62,7.25,7.86,8.37,8.77,9.12,9.37,9.57,9.62,9.71,9.75,9.86,9.99,10.12,10.35,10.60,10.88,11.25,11.72,12.21,12.70,13.12,13.47,13.63,13.73,13.62,13.50,13.37,13.25,13.15,13.21,13.35,13.60,13.98,14.38,14.85,15.24,15.50,15.62,15.62,15.47,15.25,15,14.76,14.62,14.52,14.64,15,15.50,16,16.61,16.87,16.77,16.49,16.14,16.02,16.12,16.45,16.98,17.51,17.97,18.12,18.12,18.02,17.73,17.12,16.26,15.25,14.23,13.32,12.63,12.27,12.15,12.33,12.57,13.22,14.12,15.26,16.60,17.61,18.25,18.37,18.37,17.87,17.22,16.73,16.46,16.50,16.84,17.37,18.07,18.86,19.61,20.13,20.37,20.26,20.02,19.72,19.36,18.98,18.62,18.27,18.07,17.89,17.86,17.86,17.87,17.88,17.95,17.90,17.87,17.82,17.75,17.75,17.77,17.95,18.13,18.47,18.87,19.37,19.89,20.39,20.77,20.58,19.98,19.34,18.65,18.27,18.12,18,17.90,17.87,17.82,17.70,17.51,17.50,17.33,17.08,16.74,16.36,15.95,15.39,14.77,14.12,13.50,12.98,12.50,12.12,11.87,11.47,11,10.25,9.50,8.62,7.62,6.40,5.32,4.36,3.87,3.75,3.97,4.38,5.11,5.77,6,6.02,6.02,6.07,6.02,6.01,6,6,6,6,5.87,5.86,5.12,4.62,3.99,3.37,2.87,2.48,2.25,2.23,2.21,2.12,1.97,1.72,1.37,1.09,0.77,0.62,0.63,0.82,1,1.35,1.76,2.25,2.77,3.25,3.75,4.07,4.23,4.08,3.87,3.12,3.11,3.08,3.07,2.88,2.65,2.32,1.75,1.12,0.35,-0.77,-2.91,-5.35,-7.62,-9.67,-11,-12,-12,-11,-10,-9.36,-7.88,-6.51,-5.25,-4.02,-2.89,-0.88,1.24,3.25,5.11,6.87,8.75,8.99,9.62,9.60,9.75,9.46,9.25,8.96,8.62,8.39,8.48,8.83,9.27,9.75,10.11,10.25,10.25,10.25,10.37,10.64,11.13,11.75,12.50,13.25,14,14.71,15.32,15.76,16.09,16.09,15.63,14.82,13.62,12.33,11,9.84,9,8.50,9.12,10.01,11.12,12.25,13.73,14.73,15.09,15.12,14.98,14.25,14.25,14.07,14,14,14,14,14,13.87,13.83,12.86,-8.16,-8.39,-8.75,-9,-9.05,-8.76,-8.13,-7.25,-6.15,-5.01,-3.88,-2.67,-1.62,-0.65,0.07,0.39,0.72,0.99,1.27,1.75,2.35,2.98,3.64,4.37,5.12,5.89,6.62,7.26,7.87,8.37,8.83,9.20,9.48,9.64,9.75,9.85,9.89,9.99,10.09,10.20,10.35,10.50,10.75,11,11.37,11.75,12.15,12.50,12.75,12.95,13,13.01,13,13,13,13.12,13.32,13.59,13.97,14.39,14.89,15.39,15.87,16.23,16.36,16.25,15.98,15.62,15.22,14.84,14.51,14.40,14.50,14.76,15.23,15.71,16.02,16.45,16.37,16.12,15.96,15.87,16.01,16.38,16.99,17.62,18.21,18.50,18.58,18.46,18.20,17.61,16.82,15.87,14.97,14.14,13.61,13.25,13.09,13,13,13.14,13.84,14.84,15.96,17.02,17.96,18.50,18.85,18.86,18.45,18.09,17.62,17.40,17.50,17.98,18.64,19.51,20.39,21.34,21.37,20.96,20.40,19.87,19.37,18.87,18.46,18.12,17.87,17.75,17.74,17.77,17.90,18.09,18.24,18.37,18.50,18.59,18.63,18.73,18.82,18.87,18.99,19.12,19.35,19.63,20,20.32,20.51,20.36,19.89,19.40,18.98,18.74,18.63,18.62,18.61,18.57,18.37,18.11,17.75,17.50,17.23,16.95,16.64,16.39,16.11,15.63,15.09,14.46,13.84,13.26,12.82,12.38,12.23,11.85,11.36,10.50,9.60,8.50,7.38,6.32,5.26,4.50,4.12,4.14,4.50,5.12,5.97,6.75,7.10,7.23,7.23,7.24,7.23,7.23,7.23,7.12,7,6.90,6.77,6.14,5.75,5.01,4.45,3.89,3.50,3.25,3.12,3.10,3.02,2.99,2.83,2.51,2.12,1.64,1.34,1.12,1.08,1.15,1.37,1.65,2.12,2.84,3.13,3.83,4.14,4.83,4.89,4.84,4.12,4,3.87,3.87,3.10,3.02,2.65,2.14,1.50,0.75,-0.02,-1.13,-2.89,-5.38,-7.50,-9.49,-10,-11,-11,-11,-10,-9.35,-8.11,-6.80,-5.52,-4.25,-2.85,-1.13,0.87,2.84,4.61,6.13,7.33,8.10,8.26,8.22,8.21,8.24,7.98,7.75,7.49,7.35,7.37,7.65,8.09,8.45,8.74,8.90,9.08,9.22,9.39,9.75,10.34,11,11.76,12.62,13.46,14.25,14.98,15.50,15.75,15.62,15.08,14.23,13.12,11.98,10.74,9.58,8.63,8.46,9,10,11,12.12,13.07,13.75,14,14.01,13.89,13.73,13.25,13.25,13.12,13,13,12.99,12.97,12.82,12.12,11.86,-8.35,-8.54,-8.88,-9.17,-9.18,-8.76,-7.93,-6.88,-5.75,-4.54,-3.38,-2.18,-1.13,-0.25,0.37,0.62,0.77,1,1.32,1.75,2.27,2.98,3.63,4.37,5.13,5.90,6.63,7.32,7.87,8.37,8.86,9.24,9.51,9.75,9.88,10,10.09,10.14,10.25,10.35,10.46,10.57,10.72,10.87,11.12,11.48,11.75,11.98,12.13,12.27,12.40,12.50,12.60,12.71,12.88,13.15,13.50,13.89,14.37,14.88,15.45,15.97,16.45,16.82,16.96,16.83,16.47,15.96,15.37,14.85,14.37,14.12,14.13,14.37,14.63,15.02,15.37,15.57,15.64,15.58,15.47,15.47,15.63,16.02,16.62,17.35,18,18.50,18.71,18.73,18.59,18.08,17.37,16.62,15.87,15.23,14.75,14.37,14.12,13.87,13.52,13.37,13.61,14.37,15.26,16.25,17.12,17.87,18.62,19.08,19.15,19.12,18.62,18.12,18,18.40,19.12,19.98,20.99,21.87,22.02,21.37,20.64,20,19.36,18.77,18.37,18.07,17.87,17.82,17.84,17.97,18.12,18.36,18.61,18.87,19.12,19.36,19.50,19.63,19.72,19.63,19.60,19.62,19.73,19.87,20.09,20.24,20.25,20.14,19.87,19.57,19.33,19.21,19.20,19.15,19.13,18.98,18.62,18.20,17.74,17.34,16.96,16.62,16.35,16.13,15.89,15.50,15,14.37,13.76,13.25,12.74,12.27,12.09,11.59,10.90,9.99,9,8.01,7.02,6.12,5.25,4.63,4.36,4.48,4.96,5.75,6.75,7.75,8.12,8.75,8.75,8.74,8.74,8.75,8.75,8.23,7.97,7.77,7.64,6.87,6.20,5.50,4.88,4.50,4.24,4.12,4.01,4,3.98,3.88,3.75,3.45,2.96,2.37,1.75,1.51,1.45,1.47,1.65,1.99,2.15,3.11,3.76,4.21,4.76,5.10,5.76,5.77,5.10,4.83,4.13,4.11,3.87,3.27,2.83,2.20,1.40,0.57,-0.40,-1.63,-3.25,-5.38,-7.35,-8.92,-10,-10,-10,-10,-10,-9.26,-8.23,-7,-5.75,-4.38,-2.90,-1.30,0.50,2.37,4.08,5.47,6.37,6.83,6.75,6.64,6.49,6.50,6.50,6.37,6.25,6.24,6.36,6.62,6.95,7.24,7.49,7.71,7.95,8.15,8.49,8.88,9.50,10.21,11,11.88,12.85,13.77,14.65,15.32,15.46,15.12,14.45,13.60,12.62,11.52,10.37,9.26,8.50,8.37,8.87,9.85,10.95,11.87,12.73,12.87,13.12,13.24,13.25,13.21,13,12.74,12.24,12.12,12,12,11.97,11.83,11.12,10.87,-8.26,-8.50,-8.79,-9.02,-8.88,-8.27,-7.30,-6.17,-5.03,-3.91,-2.85,-1.68,-0.64,0.12,0.62,0.75,0.87,1.01,1.33,1.75,2.32,2.98,3.63,4.37,5.12,5.95,6.70,7.37,7.87,8.38,8.87,9.25,9.61,9.86,10.01,10.14,10.25,10.37,10.49,10.58,10.63,10.74,10.83,10.90,11.08,11.33,11.49,11.61,11.72,11.86,12,12.15,12.36,12.58,12.88,13.32,13.75,14.25,14.82,15.37,15.88,16.40,16.88,17.25,17.40,17.27,16.87,16.26,15.62,14.90,14.34,13.96,13.77,13.87,14.01,14.26,14.50,14.72,14.87,14.85,14.82,14.85,15.02,15.47,16.01,16.75,17.49,18.11,18.50,18.63,18.77,18.47,17.95,17.37,16.82,16.34,15.88,15.52,15.23,14.76,14.25,13.72,13.60,14.01,14.76,15.59,16.40,17.25,18,18.62,19.09,19.37,19.01,18.61,18.40,18.75,19.38,20.15,21,21.75,21.97,21.45,20.75,20.01,19.37,18.77,18.37,18.14,18.08,18.08,18.12,18.25,18.40,18.62,18.88,19.25,19.51,19.70,19.82,19.90,19.97,19.89,19.89,19.95,20,20.11,20.13,20.13,20.09,19.95,19.75,19.61,19.50,19.52,19.62,19.63,19.45,19.01,18.57,18.01,17.50,17,16.58,16.15,15.86,15.62,15.37,15,14.51,13.96,13.36,12.77,12.25,11.75,11.35,10.74,10,9.22,8.35,7.50,6.72,6,5.37,4.90,4.62,4.75,5.27,6.15,7.46,8.21,9.12,9.75,10.09,10.02,9.97,9.89,9.73,9.25,8.87,8.58,8.12,7.49,6.75,6.08,5.50,5.25,5.12,5.01,5,4.98,4.90,4.87,4.65,4.33,3.74,3.01,2.38,2,1.84,1.76,1.99,2.20,2.87,3.75,4.22,4.75,5,5.23,5.75,5.86,5.75,5.21,5,4.83,4.12,3.75,3.11,2.35,1.50,0.51,-0.54,-1.80,-3.43,-5.38,-7.03,-8.28,-9.37,-10,-10,-10,-10,-9.30,-8.38,-7.24,-5.93,-4.60,-3.05,-1.43,0.25,2,3.60,4.62,5.25,5.50,5.47,5.25,5.12,5.12,5.12,5.12,5.10,5.13,5.35,5.62,5.88,6.15,6.37,6.62,6.88,7.21,7.58,8.02,8.62,9.37,10.20,11.12,12.12,13.14,14.08,14.73,14.87,14.46,13.73,12.86,11.96,11,9.97,9,8.33,8.20,8.23,9.75,10.75,11.74,12.08,12.25,12.25,12.77,12.98,12.87,12.74,12.10,11.75,11.24,11,11,10.97,10.83,10.12,9.87,-7.88,-8.11,-8.35,-8.36,-7.93,-7.15,-6.15,-5.12,-4.10,-3.13,-2.25,-1.25,-0.25,0.50,0.75,0.86,0.90,1.02,1.34,1.76,2.34,2.99,3.62,4.37,5.12,5.96,6.72,7.37,7.95,8.40,8.87,9.34,9.70,9.98,10.20,10.37,10.50,10.62,10.75,10.86,10.90,11,11.07,11.12,11.21,11.35,11.39,11.49,11.52,11.65,11.87,12.12,12.37,12.64,13.02,13.50,14,14.60,15.20,15.75,16.26,16.75,17.15,17.51,17.72,17.62,17.23,16.60,15.83,15.10,14.40,13.89,13.60,13.46,13.46,13.57,13.72,13.85,13.99,14,14,14.09,14.27,14.71,15.26,16,16.73,17.39,17.98,18.33,18.65,18.61,18.34,18,17.65,17.37,17.01,16.72,16.34,15.75,15.07,14.34,13.90,14,14.50,15.21,15.98,16.75,17.50,18.25,18.83,19.09,19.02,18.88,18.83,19.09,19.60,20.24,20.87,21.46,21.75,21.34,20.73,20.02,19.38,18.87,18.51,18.40,18.45,18.49,18.52,18.62,18.70,18.77,18.99,19.22,19.37,19.45,19.50,19.61,19.72,19.84,19.97,20.09,20.22,20.25,20.21,20.02,19.85,19.62,19.50,19.47,19.50,19.65,19.87,19.77,19.39,18.89,18.36,17.75,17.14,16.62,16.11,15.63,15.25,14.89,14.58,14.21,13.74,13.15,12.60,12,11.48,10.90,10.37,9.75,9.10,8.40,7.75,7.13,6.62,6.12,5.62,5.25,5,5.09,5.57,6.45,7.50,8.62,9.74,11.35,11.38,11.08,11,10.88,10.71,10.25,9.75,9.27,8.73,8.02,7.35,6.75,6.32,6.12,6.01,6,5.97,5.95,5.88,5.75,5.50,5.07,4.40,3.62,2.90,2.49,2.27,2.26,2.22,2.75,3.24,3.99,4.75,5.10,5.25,5.75,5.87,5.99,5.87,5.75,5.75,5.21,4.82,4.15,3.38,2.60,1.71,0.73,-0.38,-1.63,-3.25,-5.13,-6.63,-7.75,-8.78,-9.54,-10,-10,-10,-9.48,-8.61,-7.50,-6.23,-4.77,-3.25,-1.63,0.08,1.63,2.96,3.87,4.34,4.37,4.25,4.12,4,4,4,4,4,4.12,4.34,4.62,4.90,5.22,5.47,5.71,5.97,6.25,6.63,7.15,7.76,8.50,9.26,10.20,11.14,12.21,13.12,13.83,13.88,13.50,12.87,12.13,11.32,10.37,9.45,8.58,7.96,7.77,8.23,9.21,10.25,11.15,11.75,12,12.25,12.74,12.88,12.74,11.99,11.24,10.75,10.23,10,10,9.97,9.84,9.12,8.87,-7.14,-7.38,-7.50,-7.13,-6.38,-5.43,-4.51,-3.64,-2.88,-2.16,-1.41,-0.66,0.12,0.75,0.87,0.89,0.97,1.02,1.37,1.82,2.37,3,3.63,4.37,5.12,5.97,6.72,7.37,7.96,8.46,8.95,9.37,9.75,10.11,10.37,10.59,10.75,10.88,11.01,11.13,11.25,11.33,11.37,11.38,11.46,11.50,11.57,11.60,11.64,11.77,12.01,12.27,12.60,12.95,13.34,13.76,14.32,14.87,15.47,16,16.47,16.85,17.21,17.50,17.70,17.62,17.32,16.73,15.98,15.23,14.57,14,13.51,13.22,13,12.89,12.90,13,13.08,13.12,13.12,13.23,13.46,13.87,14.49,15.21,15.96,16.62,17.25,17.73,18.12,18.25,18.25,18.25,18.24,18.15,18.01,17.76,17.37,16.73,15.87,14.89,14.25,14,14.47,15.09,15.76,16.50,17.23,18.01,18.70,19.08,19.14,19.12,19.12,19.36,19.73,20.20,20.65,21.12,21.34,21.12,20.62,20.01,19.49,19,18.83,18.85,18.90,19,19,18.95,18.85,18.75,18.75,18.75,18.83,18.87,18.96,19.12,19.34,19.61,19.87,20.12,20.34,20.37,20.20,19.86,19.50,19.23,19.09,19.12,19.26,19.50,19.73,19.62,19.20,18.63,18,17.37,16.75,16.13,15.61,15.11,14.62,14.21,13.75,13.25,12.75,12.23,11.62,11.10,10.52,10,9.38,8.87,8.35,7.87,7.50,7.14,6.83,6.46,6.02,5.65,5.39,5.37,5.75,6.58,7.62,8.86,10.12,11.12,11.75,11.89,11.89,11.85,11.61,11.20,10.64,10.08,9.37,8.65,8,7.47,7.20,7.02,7,6.97,6.90,6.89,6.77,6.59,6.25,5.76,5.12,4.25,3.45,2.97,2.75,2.75,2.89,3.22,3.75,4.25,4.99,5.72,5.87,6.10,6.25,6.25,6.25,6.21,5.99,5.75,5.02,4.39,3.74,2.88,2,1.01,-0.01,-1.16,-2.75,-4.63,-6.03,-7.23,-8.30,-9.23,-9.88,-10,-10,-9.65,-8.88,-7.79,-6.53,-5.13,-3.53,-1.85,0,1.32,2.37,3.11,3.37,3.37,3.24,3.11,3,3,3.02,3.02,3,3.10,3.35,3.62,3.97,4.25,4.57,4.83,5.01,5.32,5.73,6.25,6.87,7.59,8.33,9.13,10.10,11.08,11.87,12.40,12.50,12.25,11.83,11.26,10.50,9.73,8.82,8,7.27,7.21,7.87,8.75,9.75,10.75,11.75,11.84,12.14,12.75,12.75,12.75,11.11,10.24,9.75,9.22,9,9,8.98,8.87,8.87,7.87,-5.64,-6.88,-6.79,-5.88,-4.26,-3.38,-2.50,-1.88,-1.50,-1.05,-0.63,-0.13,0.37,0.87,0.97,0.96,1,1.12,1.45,1.87,2.45,3.01,3.65,4.37,5.12,5.97,6.75,7.39,7.98,8.48,8.98,9.46,9.87,10.25,10.51,10.77,11,11.14,11.34,11.46,11.57,11.62,11.71,11.75,11.75,11.82,11.85,11.87,11.98,12.12,12.36,12.62,12.96,13.32,13.71,14.12,14.61,15.12,15.62,16.07,16.38,16.65,16.90,17.14,17.32,17.27,17,16.57,15.89,15.23,14.60,14.02,13.57,13.12,12.73,12.39,12.25,12.15,12.12,12.15,12.23,12.34,12.64,13.12,13.73,14.40,15.13,15.84,16.38,16.87,17.25,17.50,17.73,17.90,18.22,18.52,18.65,18.62,18.26,17.61,16.62,15.48,14.58,14.25,14.58,15.15,15.87,16.50,17.22,17.99,18.75,19.26,19.37,19.33,19.37,19.50,19.75,20.08,20.37,20.70,20.89,20.87,20.40,19.98,19.59,19.32,19.24,19.35,19.50,19.59,19.49,19.20,18.85,18.50,18.25,18.12,18.08,18.12,18.25,18.51,18.88,19.33,19.74,20.12,20.35,20.33,20,19.52,19.09,18.72,18.51,18.60,18.84,19.12,19.25,19.20,18.85,18.27,17.63,16.99,16.34,15.71,15.12,14.57,14,13.50,12.97,12.39,11.86,11.25,10.65,10.13,9.63,9.11,8.63,8.25,7.96,7.75,7.62,7.50,7.27,6.99,6.60,6.15,5.87,5.74,6,6.70,7.70,8.99,10.27,11.39,12.22,12.62,12.77,12.75,12.50,12.12,11.58,10.88,10.14,9.39,8.75,8.34,8.11,8,7.97,7.89,7.87,7.76,7.61,7.25,6.95,6.39,5.63,4.82,4,3.50,3.26,3.25,3.45,3.75,4.22,4.75,5.26,5.87,6.26,6.71,6.71,6.72,6.72,6.73,6.25,5.87,5.23,4.74,4.09,3.33,2.45,1.50,0.48,-0.63,-2.04,-3.93,-5.40,-6.65,-7.88,-8.89,-9.75,-10,-10,-9.88,-9.15,-8.16,-6.99,-5.62,-4,-2.18,-0.13,0.87,1.82,2.25,2.46,2.37,2.25,2.25,2.23,2.21,2.20,2.22,2.20,2.12,2.37,2.64,3,3.35,3.62,3.89,4.02,4.34,4.72,5.32,5.97,6.62,7.33,8.01,9,9.85,10.50,10.85,10.87,10.75,10.50,10.25,9.72,9.02,8.21,7.36,6.87,6.87,7.21,8.11,9,9.97,10.83,11.75,11.75,11.75,11.75,10.75,9.88,9.22,8.75,8.21,8,8,7.99,7.97,7.87,6.87,-6.88,-6.62,-5.75,-4.02,-2.50,-1.26,-0.75,-0.50,-0.38,-0.18,0,0.33,0.62,0.87,0.99,0.99,1,1.23,1.58,2,2.52,3.12,3.73,4.37,5.12,5.97,6.75,7.39,7.98,8.48,9,9.50,10,10.37,10.73,11,11.25,11.39,11.58,11.73,11.85,11.95,12,12.08,12.12,12.12,12.20,12.25,12.36,12.50,12.73,13,13.35,13.72,14.12,14.50,14.95,15.36,15.73,16,16.22,16.35,16.40,16.50,16.59,16.57,16.37,16.01,15.52,15,14.50,14,13.58,13.10,12.59,12.09,11.72,11.50,11.34,11.32,11.39,11.59,11.87,12.35,12.97,13.62,14.35,15,15.52,16,16.37,16.73,17.08,17.49,17.95,18.38,18.84,19.12,18.90,18.35,17.25,16,14.87,14.57,14.87,15.50,16.14,16.82,17.39,18.08,18.62,19.15,19.37,19.37,19.48,19.60,19.73,19.86,19.99,20.12,20.24,20.25,20.07,19.83,19.62,19.59,19.64,19.87,20.10,20.23,19.87,19.32,18.72,18.12,17.65,17.37,17.25,17.25,17.49,17.87,18.46,19.02,19.62,20.11,20.26,20.12,19.73,19.14,18.59,18.12,17.89,17.99,18.25,18.58,18.75,18.74,18.39,17.88,17.25,16.60,15.89,15.25,14.63,14.02,13.45,12.84,12.22,11.61,10.99,10.37,9.82,9.35,8.98,8.52,8.26,8.09,8,8.07,8.12,8.12,8,7.71,7.25,6.75,6.36,6.12,6.25,6.82,7.73,9.02,10.47,11.75,12.74,13.34,13.59,13.59,13.37,13,12.49,11.77,11,10.25,9.62,9.25,9.02,8.98,8.89,8.85,8.74,8.57,8.26,7.97,7.62,7.01,6.25,5.36,4.57,4.01,3.73,3.73,3.88,4.25,4.74,5.22,5.75,6.22,6.70,6.87,6.99,7,6.99,6.87,6.73,6.22,5.75,5.20,4.60,3.85,2.99,2.01,1,-0.04,-1.39,-3.13,-4.75,-6.10,-7.41,-8.61,-9.55,-10,-10,-10,-9.42,-8.53,-7.48,-6.23,-4.65,-2.86,-0.53,0.25,1,1.37,1.37,1.37,1.37,1.46,1.50,1.50,1.50,1.59,1.58,1.50,1.59,1.77,2.12,2.46,2.77,3,3,3.36,3.70,4.34,4.99,5.62,6.33,7,7.97,8.74,9.15,9.35,9.36,9.33,9.20,8.96,8.57,8.10,7.61,6.87,6.13,6.14,6.77,7.20,8.22,9.12,9.98,10.75,10.88,10.75,10.14,9.22,8.22,8.11,7.76,7.15,7,7,7,6.99,6.87,5.89,-7.88,-7.10,-5.75,-3.88,-1.92,-0.54,0.11,0.20,0.25,0.34,0.47,0.62,0.75,0.96,0.99,1,1,1.26,1.65,2.14,2.70,3.24,3.82,4.46,5.20,5.99,6.75,7.39,7.97,8.49,9,9.58,10.11,10.52,10.88,11.21,11.45,11.61,11.75,11.89,12.02,12.15,12.25,12.36,12.40,12.48,12.51,12.62,12.75,12.87,13.10,13.37,13.72,14.12,14.51,14.95,15.32,15.62,15.86,15.90,15.95,15.87,15.77,15.71,15.62,15.50,15.37,15.12,14.85,14.50,14.20,13.87,13.58,13.10,12.50,11.88,11.37,11,10.75,10.72,10.73,10.87,11.14,11.62,12.21,12.86,13.50,14.12,14.62,15.01,15.45,15.86,16.34,16.87,17.50,18.21,18.75,19.12,19.14,18.75,17.71,16.52,15.52,15.23,15.52,16.09,16.64,17.25,17.76,18.12,18.45,18.62,18.87,19.07,19.37,19.49,19.52,19.50,19.48,19.47,19.49,19.50,19.50,19.50,19.60,19.75,20,20.34,20.59,20.63,20.10,19.33,18.50,17.71,17,16.52,16.34,16.37,16.72,17.25,17.99,18.75,19.57,20.11,20.21,19.89,19.40,18.75,18.11,17.57,17.27,17.35,17.62,17.98,18.23,18.24,17.99,17.50,16.87,16.21,15.50,14.87,14.24,13.58,12.88,12.22,11.50,10.87,10.21,9.62,9.12,8.76,8.46,8.34,8.26,8.34,8.49,8.73,8.96,9.07,8.95,8.59,8.01,7.40,6.87,6.50,6.50,6.87,7.73,9.10,10.60,12.01,13.25,13.89,14.25,14.26,14.13,13.84,13.35,12.65,11.89,11.14,10.58,10.21,10,9.90,9.85,9.72,9.50,9.25,8.96,8.61,8.14,7.50,6.73,5.85,5.01,4.47,4.12,4.12,4.36,4.75,5.24,5.75,6.22,6.65,7,7.22,7.32,7.32,7.27,7.22,6.99,6.73,6.25,5.86,5.25,4.49,3.61,2.62,1.59,0.46,-0.80,-2.38,-3.99,-5.39,-6.88,-8.14,-9.25,-10,-10,-10,-9.61,-8.88,-7.93,-6.88,-5.50,-3.88,-1.63,-1,-0.17,0.22,0.24,0.36,0.50,0.75,0.97,1.10,1.12,1.12,1.21,1.12,1.20,1.24,1.46,1.76,2.10,2.27,2.36,2.52,2.77,3.36,4,4.64,5.33,6,6.97,7.62,7.97,8,8,8,7.87,7.62,7.35,7.08,6.75,6.12,5.87,5.87,6.14,6.87,7.77,8.20,9.11,9.75,9.83,9.75,8.87,8,7.21,7,6.82,6.14,6.13,6.12,6.12,6.11,5.88,4.90,-8.93,-8.18,-6.13,-4.24,-2.02,-0.51,0.21,0.25,0.37,0.48,0.61,0.74,0.87,0.97,1,1,1,1.26,1.75,2.32,2.87,3.37,3.96,4.57,5.25,6,6.75,7.39,7.97,8.49,9,9.61,10.14,10.65,11.10,11.38,11.62,11.76,11.90,12.08,12.23,12.36,12.49,12.59,12.65,12.75,12.87,13,13.11,13.24,13.39,13.65,14,14.45,14.87,15.35,15.70,15.83,15.88,15.86,15.64,15.39,15.12,14.87,14.65,14.50,14.35,14.21,14.02,13.89,13.82,13.63,13.40,13.02,12.50,11.87,11.25,10.76,10.37,10.22,10.14,10.25,10.50,10.90,11.46,12.01,12.62,13.15,13.62,14.07,14.49,14.98,15.57,16.25,17,17.87,18.62,19.10,19.13,18.87,18.10,17.14,16.40,16.11,16.33,16.76,17.25,17.70,18,18.12,18,17.99,18.07,18.25,18.60,18.96,19.40,19,18.87,18.75,18.70,18.74,18.87,19.09,19.37,19.75,20.22,20.61,20.87,20.75,20.20,19.26,18.26,17.25,16.37,15.75,15.48,15.51,15.95,16.62,17.48,18.46,19.40,19.97,20,19.70,19.12,18.45,17.65,17.07,16.72,16.75,17,17.37,17.65,17.75,17.51,17.10,16.49,15.77,15.11,14.45,13.75,13.09,12.37,11.62,10.87,10.22,9.59,9.07,8.70,8.45,8.35,8.40,8.60,8.86,9.22,9.62,10,10.14,10,9.58,8.87,8.12,7.48,6.97,6.77,6.95,7.77,9.09,10.59,12.12,13.40,14.23,14.62,14.76,14.75,14.50,14.10,13.49,12.75,12.09,11.50,11.14,10.98,10.85,10.72,10.51,10.26,9.99,9.62,9.20,8.72,8.01,7.25,6.37,5.51,4.87,4.50,4.50,4.75,5.22,5.73,6.24,6.75,7.11,7.33,7.64,7.64,7.64,7.65,7.70,7.26,7.11,6.87,6.75,5.97,5.15,4.24,3.23,2.12,1,-0.16,-1.50,-3.13,-4.62,-6.13,-7.61,-8.64,-9.49,-9.80,-9.87,-9.61,-9.13,-8.51,-7.54,-6.37,-5.10,-3.91,-2.78,-2.01,-1.48,-1.03,-0.75,-0.30,0.12,0.58,0.84,0.97,1,1,1,1,1,1.12,1.35,1.58,1.65,1.65,1.76,2,2.47,3.11,3.70,4.34,5,5.97,6.62,6.98,6.98,6.98,6.86,6.62,6.35,6.12,5.99,5.87,5.87,5.12,5.12,5.84,6.14,6.87,7.82,8.20,8.77,8.77,8.20,7.77,7,6.15,6,5.87,5.85,5.85,5.87,5.87,5.10,5.07,4.96,-8.75,-8.05,-6.55,-4.88,-2.79,-1.18,-0.38,-0.13,0.12,0.37,0.58,0.75,0.87,0.98,1,1,1,1.21,1.82,2.40,3,3.57,4.11,4.65,5.34,6.02,6.75,7.38,7.97,8.49,9,9.62,10.22,10.75,11.21,11.51,11.75,11.88,12,12.15,12.33,12.49,12.62,12.74,12.86,12.98,13.12,13.25,13.37,13.50,13.63,13.87,14.21,14.62,15.09,15.47,15.71,15.87,15.87,15.72,15.37,14.96,14.50,14.11,13.75,13.50,13.36,13.25,13.25,13.25,13.34,13.37,13.27,13,12.50,11.88,11.25,10.71,10.21,9.88,9.75,9.76,9.97,10.26,10.73,11.24,11.75,12.25,12.65,13.10,13.51,14.10,14.76,15.61,16.50,17.45,18.34,18.95,19.12,18.87,18.35,17.70,17.02,16.75,17,17.47,17.89,18.01,18.01,17.95,17.50,17.25,17.11,17.32,17.63,18.02,18.37,18.38,18.22,18,17.87,17.88,18.12,18.50,19,19.57,20.12,20.59,20.87,20.83,20.24,19.25,18.12,17,15.86,15.07,14.62,14.72,15.20,15.95,16.84,17.88,18.87,19.50,19.70,19.39,18.89,18.20,17.37,16.65,16.25,16.24,16.48,16.85,17.12,17.25,17.09,16.62,16,15.33,14.62,13.89,13.24,12.50,11.75,11,10.32,9.64,9.12,8.74,8.50,8.36,8.50,8.75,9.12,9.58,10.11,10.65,11.12,11.37,11.23,10.62,9.75,8.87,8.07,7.40,7.12,7.10,7.85,9,10.38,11.85,13.11,14.10,14.72,15.01,15.12,15,14.65,14.13,13.51,12.90,12.45,12.11,11.87,11.73,11.52,11.35,11.08,10.73,10.27,9.77,9.23,8.61,7.87,7.07,6.20,5.45,5,4.87,5.13,5.62,6.14,6.71,7.22,7.63,7.75,8,8.21,8.32,8.32,8.10,7.87,7.71,7.25,6.98,6.75,5.75,4.85,3.85,2.71,1.57,0.37,-0.79,-2.25,-3.64,-5.13,-6.63,-8.04,-8.80,-9.38,-9.52,-9.50,-9.28,-8.86,-8.12,-7.10,-6.12,-5.25,-4.24,-3.37,-2.74,-2.23,-1.75,-1.27,-0.51,0.13,0.62,0.87,0.97,0.99,0.99,0.98,1,1,1.12,1.24,1.27,1.34,1.35,1.46,1.76,2.34,2.76,3.35,4,4.98,5.62,5.98,5.98,5.86,5.62,5.35,5.12,5,4.99,4.99,4.87,4.87,4.87,5,5.12,6.11,6.87,7.83,7.84,7.82,7.15,6.82,6.11,5.13,5.12,5.12,5.12,5.12,5.11,5.10,4.90,4.96,3.98,-7.80,-7.61,-7,-5.88,-4.39,-2.67,-1.50,-0.80,-0.27,0.12,0.49,0.74,0.87,0.98,1,1,1,1.08,1.85,2.57,3.13,3.73,4.25,4.82,5.38,6.09,6.75,7.38,7.97,8.49,9,9.62,10.23,10.75,11.24,11.58,11.77,11.96,12.10,12.22,12.37,12.50,12.64,12.77,12.95,13.09,13.25,13.40,13.57,13.64,13.75,13.96,14.22,14.60,14.87,15.25,15.50,15.65,15.64,15.45,15,14.47,13.87,13.35,12.87,12.57,12.37,12.36,12.46,12.63,12.87,13.09,13.13,12.97,12.50,11.89,11.25,10.63,10.12,9.71,9.46,9.37,9.47,9.71,10.07,10.50,10.97,11.38,11.83,12.23,12.64,13.26,14.07,14.96,15.90,16.89,17.87,18.51,18.86,18.76,18.38,17.87,17.35,17.07,17.36,18.02,18.12,17.95,17.62,17.27,16.88,16.48,16.22,16.25,16.37,17.02,17.50,17.75,17.50,17.24,17,17.02,17.37,17.86,18.47,19.12,19.75,20.22,20.50,20.50,20.10,19.14,18.08,16.88,15.73,14.70,14,13.98,14.46,15.21,16.09,17.02,18.01,18.73,19.09,19.12,18.74,17.99,17.21,16.48,15.98,15.83,15.98,16.27,16.62,16.74,16.58,16.12,15.49,14.75,14,13.25,12.58,11.85,11.12,10.38,9.75,9.25,8.83,8.61,8.46,8.60,8.87,9.26,9.77,10.37,11.07,11.74,12.27,12.61,12.37,11.61,10.59,9.57,8.62,7.87,7.47,7.33,7.87,8.87,10.12,11.47,12.70,13.73,14.50,15,15.25,15.25,15.09,14.70,14.20,13.71,13.26,12.99,12.75,12.57,12.37,12.12,11.87,11.50,11.01,10.39,9.77,9.15,8.52,7.75,6.90,6.14,5.61,5.37,5.58,6,6.50,7.07,7.59,8.09,8.33,8.35,8.63,8.64,8.64,8.64,8.32,8.10,7.75,7.25,6.86,6.22,5.62,4.39,3.25,2.12,1,-0.13,-1.25,-2.54,-3.92,-5.38,-6.75,-7.63,-8.26,-8.63,-8.88,-8.92,-8.75,-8.25,-7.41,-6.55,-5.80,-4.86,-4.04,-3.50,-3.10,-2.63,-2.15,-1.25,-0.17,0.37,0.75,0.87,0.87,0.96,0.97,0.97,0.99,1,1,1,1,1,1.12,1.35,1.65,2,2.46,3.12,3.86,4.50,4.86,4.87,4.64,4.32,4.12,4.01,4,4,4.01,4.07,4.09,4.10,4.12,4.87,5.12,6.09,6.86,6.95,6.84,6.13,5.85,5.12,4.86,4.12,4.12,4.87,4.87,4.89,4.90,4.01,3.98,3,-6.85,-7.25,-7.62,-7.25,-6.13,-4.51,-2.88,-1.63,-0.75,-0.03,0.38,0.73,0.87,0.98,1,1,1,1,2,2.62,3.25,3.84,4.37,4.87,5.48,6.12,6.76,7.38,7.97,8.49,9,9.61,10.20,10.73,11.14,11.50,11.74,11.87,12.02,12.22,12.34,12.49,12.62,12.75,12.90,13.10,13.25,13.40,13.57,13.63,13.74,13.86,14,14.24,14.50,14.84,15.09,15.22,15.21,14.99,14.51,13.95,13.26,12.62,12.10,11.70,11.50,11.50,11.72,12.09,12.50,12.85,13,12.87,12.46,11.85,11.20,10.57,10,9.50,9.14,9,9,9.21,9.50,9.88,10.35,10.75,11.20,11.58,12,12.62,13.45,14.37,15.36,16.36,17.25,17.99,18.39,18.50,18.25,17.75,17.27,17.01,17.15,17.49,17.62,17.50,17.20,16.75,16.24,15.84,15.26,15.37,15.50,16.09,16.63,17.11,16.84,16.38,16.12,16.15,16.57,17.12,17.82,18.50,19.12,19.52,19.77,19.84,19.61,19,18.01,16.87,15.71,14.52,13.59,13.25,13.65,14.39,15.25,16.20,17.10,17.87,18.37,18.58,18.27,17.75,17.08,16.37,15.75,15.47,15.49,15.74,16,16.12,15.95,15.48,14.83,14.07,13.25,12.50,11.76,11.09,10.40,9.85,9.36,8.96,8.73,8.62,8.75,9.07,9.49,10,10.62,11.27,12,12.72,13.34,13.60,13.25,12.37,11.25,10.12,9.12,8.35,7.74,7.62,7.87,8.75,9.83,11,12.20,13.24,14.09,14.72,15.12,15.33,15.26,15.08,14.74,14.37,14.07,13.76,13.58,13.37,13.14,12.96,12.70,12.37,11.75,11.12,10.40,9.76,9.12,8.46,7.61,6.84,6.20,5.87,5.98,6.32,6.76,7.32,7.87,8.62,8.75,9,9.21,9.32,9.21,9,8.75,8.70,8.22,7.75,7.22,6.75,5.99,5.02,3.87,2.75,1.64,0.62,-0.25,-1.25,-2.64,-3.99,-5.25,-6.38,-7,-7.52,-7.91,-8.14,-8.14,-7.87,-7.48,-6.53,-5.75,-4.85,-4.05,-3.50,-3.05,-2.75,-2.38,-1.78,-1.01,0,0.38,0.50,0.63,0.82,0.87,0.97,1,0.99,0.99,0.99,0.99,1,1,1.12,1.23,1.46,1.64,2.23,2.75,3.33,3.62,3.65,3.32,3.13,3,3.12,3.26,3.63,3.83,3.89,3.96,4,4.12,4.25,4.82,5.12,5.87,5.97,5.87,5.12,5,4.87,4.12,4.11,4.10,4.10,4.08,4.07,3.96,3,2,2,-5.30,-7.04,-8.55,-9.28,-8.36,-6.12,-4.02,-2.28,-1.01,-0.13,0.37,0.74,0.87,0.98,1,1,1,1.99,2.20,2.73,3.27,3.87,4.45,4.97,5.50,6.12,6.76,7.38,7.96,8.47,9,9.57,10.12,10.62,11,11.35,11.58,11.75,11.90,12.09,12.23,12.37,12.52,12.72,12.87,13,13.20,13.32,13.39,13.50,13.50,13.58,13.61,13.73,13.89,14.13,14.37,14.50,14.50,14.36,13.96,13.37,12.70,12,11.37,10.97,10.75,10.77,11.12,11.60,12.12,12.62,12.87,12.73,12.25,11.62,10.99,10.36,9.75,9.25,8.87,8.64,8.62,8.82,9.11,9.50,9.96,10.40,10.87,11.32,11.75,12.27,13,13.87,14.86,15.83,16.73,17.45,17.90,18.08,17.87,17.45,17,16.75,16.86,17.02,17.22,17.14,16.85,16.35,15.75,15.14,14.97,14.75,14.64,15.22,15.65,16.12,15.87,15.50,15.25,15.34,15.75,16.37,17.10,17.75,18.33,18.70,18.87,18.97,18.87,18.58,17.99,16.97,15.71,14.49,13.37,12.76,13.01,13.62,14.40,15.34,16.25,17.21,17.75,17.89,17.74,17.40,16.99,16.33,15.62,15.09,14.96,15.11,15.33,15.37,15.14,14.70,14,13.23,12.39,11.62,10.90,10.32,9.75,9.37,9.09,8.87,8.87,9,9.35,9.76,10.32,10.89,11.58,12.25,12.96,13.60,14.12,14.25,13.86,12.90,11.75,10.62,9.61,8.74,8.12,7.87,8.10,8.64,9.57,10.61,11.65,12.65,13.52,14.25,14.84,15.21,15.37,15.34,15.15,14.97,14.75,14.51,14.34,14.12,13.95,13.72,13.48,13.02,12.51,11.86,11.12,10.40,9.75,9,8.21,7.37,6.70,6.27,6.25,6.58,7,7.50,8.12,8.75,9.27,9.62,9.63,9.64,9.63,9.33,9.32,9.10,8.75,8.25,7.87,7.23,6.76,5.62,4.52,3.46,2.37,1.45,0.62,-0.25,-1.25,-2.54,-3.75,-4.85,-5.64,-6.37,-6.88,-7.25,-7.35,-7.15,-6.76,-6.23,-5.52,-4.64,-3.88,-3.27,-2.88,-2.63,-2.38,-2.12,-1.75,-1.13,-0.75,-0.25,0.11,0.50,0.75,0.96,1,1,1,0.99,0.99,0.99,1,1,1,1.12,1.23,1.32,1.77,2.13,2.25,2.26,2.12,2,2.12,2.37,2.76,3.15,3.61,3.82,3.88,3.87,3.90,4.12,4.37,4.72,4.97,5.11,5,4.87,4.11,4.10,4.10,3.88,3.89,3.90,3.96,3.98,2.99,2,1,1,-4.54,-7,-9.26,-10,-9.75,-7.18,-4.63,-2.62,-1.13,-0.13,0.45,0.75,0.87,0.99,1,1,1,1.99,2.32,2.70,3.33,3.90,4.49,4.99,5.50,6.12,6.75,7.37,7.90,8.45,8.96,9.49,10,10.45,10.82,11.11,11.35,11.51,11.73,11.87,12.02,12.23,12.40,12.62,12.77,12.95,13.02,13.12,13.15,13.21,13.14,13.11,13.01,13.02,13.12,13.33,13.50,13.65,13.75,13.62,13.27,12.75,12.11,11.37,10.75,10.35,10.12,10.25,10.60,11.12,11.75,12.33,12.57,12.37,11.87,11.25,10.62,10,9.45,8.96,8.52,8.34,8.33,8.50,8.84,9.25,9.77,10.36,10.87,11.37,11.85,12.33,12.87,13.62,14.50,15.46,16.34,17.09,17.59,17.75,17.51,17.10,16.70,16.50,16.47,16.63,16.85,16.86,16.50,15.96,15.33,14.77,14.46,14.14,14.12,14.33,14.62,14.96,14.75,14.50,14.33,14.48,14.99,15.62,16.32,16.96,17.40,17.75,17.90,18,18,17.90,17.65,16.95,15.65,14.48,13.32,12.62,12.61,13,13.65,14.51,15.50,16.62,17.75,17.25,17.25,17.11,16.76,16.51,15.27,14.62,14.34,14.39,14.52,14.51,14.27,13.77,13.11,12.27,11.49,10.74,10.10,9.60,9.25,9.08,9,9.25,9.49,9.83,10.24,10.75,11.35,11.99,12.62,13.25,13.86,14.36,14.72,14.64,14.12,13.22,12.10,11,9.99,9.09,8.49,8.20,8.24,8.62,9.34,10.22,11.15,12.12,13,13.75,14.45,14.98,15.33,15.49,15.50,15.46,15.35,15.21,15.02,14.87,14.63,14.40,14.07,13.62,13.12,12.57,11.85,11.12,10.37,9.58,8.70,7.83,7.08,6.62,6.58,6.83,7.24,7.75,8.37,8.99,9.62,9.99,10.21,10.32,10.10,9.87,9.64,9.70,9.26,8.99,8.75,8,7.21,6.37,5.37,4.33,3.25,2.25,1.46,0.62,-0.25,-1.16,-2.17,-3.17,-4.13,-4.87,-5.53,-5.88,-6.13,-6.18,-6.10,-5.86,-5.25,-4.38,-3.61,-2.91,-2.50,-2.25,-2.13,-2.01,-2.16,-3.13,-1.53,-0.75,-0.39,-0.75,0.75,0.96,1,1,1,1,1,1,1,1,1,1,1,1,1.02,1.14,1.26,1.36,1.37,1.37,1.49,1.84,2.25,2.73,3.12,3.37,3.52,3.62,3.72,3.84,4,4.24,4.37,4.45,4.39,4.25,4.11,3.97,3.95,3.95,3.01,3,2.99,3,2,1,1,1,-5.10,-7,-9.28,-10,-9.77,-7.25,-4.62,-2.43,-0.92,-0.01,0.50,0.82,0.97,0.99,1,1,2,1.99,2.32,2.70,3.33,3.97,4.50,5,5.50,6.12,6.75,7.36,7.87,8.37,8.87,9.37,9.85,10.24,10.58,10.84,11.08,11.25,11.48,11.63,11.85,12.07,12.27,12.51,12.74,12.86,12.90,12.97,12.96,12.88,12.75,12.60,12.38,12.27,12.25,12.36,12.50,12.75,12.87,12.84,12.59,12.11,11.49,10.82,10.22,9.76,9.62,9.73,10.08,10.62,11.24,11.75,11.96,11.73,11.25,10.63,10.08,9.50,9,8.51,8.14,8,8.02,8.26,8.71,9.24,9.86,10.50,11.12,11.70,12.15,12.62,13.12,13.71,14.45,15.26,16.12,16.87,17.40,17.61,17.37,16.87,16.46,16.25,16.22,16.32,16.39,16.46,16.12,15.50,14.77,14.22,13.75,13.47,13.34,13.38,13.60,13.75,13.62,13.47,13.35,13.62,14.20,14.85,15.50,16.07,16.50,16.76,16.97,17.09,17.13,17.14,17.11,16.62,15.62,14.46,13.27,12.50,12.22,12.32,12.96,13.75,14.75,15.82,16.74,16.75,16.71,16.65,16.62,15.85,14.90,13.76,13.75,13.73,13.74,13.62,13.37,12.86,12.12,11.33,10.50,9.87,9.37,9,8.87,9.12,9.50,9.87,10.32,10.75,11.32,11.87,12.50,13.13,13.75,14.26,14.72,15,15.12,14.87,14.25,13.36,12.34,11.27,10.25,9.46,8.83,8.45,8.36,8.60,9.12,9.86,10.72,11.60,12.46,13.25,14,14.70,15.22,15.57,15.75,15.85,15.85,15.76,15.64,15.50,15.27,15,14.60,14.12,13.65,13.13,12.52,11.84,11.02,10.14,9.15,8.20,7.35,6.87,6.86,7.09,7.52,8.12,8.75,9.33,9.87,10.33,10.62,10.64,10.63,10.33,10.10,9.87,9.75,9.72,9.25,8.87,8.21,7.33,6.47,5.37,4.27,3.22,2.25,1.45,0.62,-0.13,-0.88,-1.55,-2.25,-2.93,-3.75,-4.37,-4.86,-5.15,-5.29,-5.25,-4.92,-4.12,-3.25,-2.49,-1.92,-1.66,-1.61,-1.62,-1.78,-3.50,-1.92,-0.50,-0.68,0.74,0.82,0.97,1,1,1,1,1,1,1,1,1,1,1,0.99,1,1,1,1,1.01,1.02,1.15,1.37,1.82,2.25,2.64,2.99,3.22,3.35,3.46,3.58,3.74,3.87,3.95,3.98,3.96,3.89,3.87,3.83,3.75,3.12,2.99,2,2,2,1,1,1,1,-5.25,-6.75,-8.73,-9.75,-8.99,-6.35,-3.88,-1.88,-0.53,0.22,0.62,0.87,0.97,0.99,1,1,2,2,2.26,2.70,3.33,3.99,4.60,5,5.50,6.09,6.72,7.27,7.84,8.32,8.75,9.24,9.63,10,10.27,10.52,10.75,10.99,11.20,11.38,11.62,11.87,12.13,12.38,12.62,12.75,12.83,12.82,12.73,12.59,12.35,12,11.72,11.48,11.35,11.36,11.49,11.64,11.86,11.97,11.75,11.37,10.83,10.22,9.63,9.25,9.11,9.20,9.50,9.97,10.48,10.88,11,10.77,10.37,9.88,9.37,8.88,8.47,8.08,7.84,7.71,7.84,8.14,8.64,9.27,10.01,10.82,11.51,12.15,12.65,13.11,13.50,14,14.62,15.35,16.12,16.87,17.47,17.63,17.37,16.87,16.37,16.11,16,15.98,15.88,15.77,15.57,14.89,14.12,13.46,12.98,12.62,12.40,12.38,12.50,12.63,12.51,12.46,12.39,12.85,13.45,14.09,14.70,15.22,15.61,15.87,16.02,16.20,16.33,16.45,16.45,16.14,15.46,14.48,13.38,12.40,11.86,11.61,12.21,12.96,13.89,14.87,15.75,16.07,16.23,16.33,16.15,15.62,14.37,13.72,13.25,13.07,12.89,12.73,12.37,11.87,11.14,10.37,9.62,9.10,8.86,8.87,9.15,9.71,10.22,10.75,11.25,11.82,12.37,13.01,13.73,14.36,14.87,15.27,15.57,15.62,15.48,15.01,14.37,13.50,12.58,11.57,10.62,9.82,9.12,8.65,8.47,8.51,8.89,9.50,10.25,11.11,11.95,12.76,13.62,14.37,15.02,15.58,15.95,16.13,16.25,16.25,16.15,16,15.75,15.45,15.01,14.62,14.15,13.73,13.15,12.51,11.75,10.82,9.65,8.58,7.65,7.23,7.15,7.40,7.95,8.58,9.21,9.75,10.22,10.75,11.10,11.21,11,10.64,10.32,10.12,10,9.87,9.87,9.75,9.76,8.84,7.76,6.73,5.57,4.25,3.20,2.25,1.50,0.84,0.25,-0.18,-0.50,-0.88,-1.75,-2.75,-3.39,-3.88,-4.27,-4.60,-4.68,-3.78,-2.88,-2,-1.38,-1.10,-0.99,-0.93,-0.98,0.13,0.37,0.50,0.74,0.75,0.95,0.98,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.02,1.25,1.50,1.87,2.25,2.61,2.87,3.10,3.25,3.38,3.50,3.60,3.62,3.62,3.60,3.60,3.61,3.50,2.97,2.27,2,1.90,1,1,1,1,1,1,-4.98,-6.13,-7.63,-8.51,-7.39,-5,-2.50,-0.75,0.08,0.57,0.82,0.88,0.97,0.99,1,1,2,2,2.24,2.65,3.33,3.99,4.60,5,5.39,6.01,6.63,7.25,7.75,8.24,8.64,9.10,9.47,9.76,10.02,10.25,10.49,10.71,10.90,11.15,11.45,11.72,11.99,12.25,12.49,12.62,12.72,12.63,12.49,12.23,11.86,11.39,10.99,10.61,10.36,10.27,10.38,10.58,10.75,10.85,10.87,10.58,10.12,9.59,9.10,8.74,8.57,8.60,8.82,9.13,9.51,9.82,9.87,9.75,9.45,9.08,8.63,8.25,7.88,7.62,7.49,7.46,7.71,8.12,8.74,9.48,10.32,11.20,12,12.74,13.25,13.63,14,14.37,14.87,15.50,16.21,16.88,17.57,17.84,17.59,17,16.39,16,15.77,15.61,15.36,15.02,14.62,14.01,13.25,12.51,12.02,11.72,11.48,11.37,11.39,11.46,11.49,11.50,11.60,12.12,12.77,13.40,14,14.48,14.84,15.10,15.25,15.37,15.58,15.82,15.90,15.85,15.37,14.58,13.62,12.62,11.70,11.45,11.12,12.12,13,13.96,14.75,15.25,15.87,16.12,16.10,15.62,14.37,13.40,12.83,12.37,12.02,11.73,11.34,10.85,10.24,9.60,8.98,8.65,8.88,9.36,9.90,10.51,11.12,11.74,12.26,12.87,13.48,14.14,14.87,15.50,16,16.33,16.38,16.25,15.87,15.32,14.60,13.75,12.83,11.87,11,10.20,9.48,8.89,8.59,8.50,8.75,9.23,9.87,10.62,11.48,12.35,13.23,14.10,14.87,15.58,16.09,16.40,16.62,16.64,16.61,16.45,16.15,15.85,15.47,15.08,14.70,14.27,13.83,13.23,12.39,11.38,10.13,8.98,8,7.57,7.50,7.84,8.37,9.08,9.73,10.22,10.75,11.22,11.63,11.63,11.33,11.12,10.75,10.27,10.12,10.12,10.24,10.75,10.82,9.85,9.12,8.74,6.84,5.36,4.12,3.12,2.33,1.62,1.08,0.73,0.50,0.09,-0.50,-1.41,-2.13,-2.67,-3.25,-3.79,-4.27,-3.52,-2.52,-1.63,-1,-0.63,-0.49,-0.37,-0.05,0.37,0.75,0.83,0.95,0.96,0.98,1,1,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.12,1.32,1.59,1.89,2.25,2.57,2.86,3.11,3.27,3.37,3.37,3.25,3.21,3.12,3.11,3,2.62,2.22,1.65,1.37,1.22,1.11,1,1,1,1,1,-4.51,-5.25,-6.12,-6.38,-5.24,-3.40,-1.38,-0.05,0.45,0.73,0.87,0.96,0.98,0.99,1,1,2,2,2.15,2.65,3.33,3.98,4.50,5,5.47,6,6.62,7.20,7.70,8.12,8.51,8.89,9.25,9.57,9.82,10,10.25,10.47,10.70,10.96,11.24,11.50,11.75,12,12.25,12.45,12.50,12.45,12.20,11.83,11.35,10.76,10.24,9.73,9.37,9.25,9.27,9.45,9.62,9.75,9.75,9.65,9.35,8.89,8.50,8.13,7.97,7.90,8.07,8.25,8.50,8.72,8.75,8.70,8.50,8.23,7.95,7.63,7.39,7.25,7.25,7.38,7.65,8.20,8.87,9.65,10.61,11.58,12.50,13.25,13.82,14.13,14.39,14.72,15.12,15.62,16.22,16.85,17.50,17.85,17.62,17.07,16.47,15.97,15.59,15.24,14.77,14.34,13.75,13.08,12.27,11.58,11.09,10.76,10.50,10.37,10.36,10.37,10.45,10.62,11,11.62,12.33,12.98,13.50,13.89,14.25,14.50,14.62,14.73,14.98,15.35,15.52,15.72,15.37,14.75,13.97,13.02,12,11.35,11.21,11.12,12.13,13,13.87,14.73,15.71,16.65,16,15.62,14.27,13.11,12.25,11.62,11.10,10.63,10.25,9.85,9.39,9.02,8.75,8.86,9.37,10.12,10.87,11.60,12.23,12.76,13.33,13.87,14.49,15.20,15.89,16.50,17,17.22,17.14,16.87,16.36,15.70,14.89,14.07,13.14,12.25,11.38,10.59,9.83,9.20,8.74,8.50,8.61,8.97,9.51,10.25,11.07,11.95,12.87,13.82,14.74,15.57,16.23,16.65,16.90,17,16.97,16.83,16.60,16.25,15.88,15.50,15.24,14.89,14.49,13.87,13,11.87,10.50,9.32,8.34,7.87,7.85,8.21,8.84,9.62,10.33,10.87,11.34,11.75,12.11,12.22,12.11,11.75,11.27,10.75,10.25,10.25,10.75,10.87,10.87,10.85,9.87,9.88,7.96,6.12,5,4,3.10,2.25,1.63,1.25,0.88,0.62,0.36,-0.41,-1.02,-1.63,-2.25,-2.98,-3.63,-3.01,-2.25,-1.41,-0.76,-0.38,-0.15,0.01,0.26,0.74,0.87,0.95,0.99,0.99,1,1,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.07,1.14,1.37,1.62,1.90,2.22,2.50,2.75,2.99,3.01,2.96,2.77,2.65,2.59,2.48,2.25,1.96,1.62,1.25,1.12,1,0.99,0.99,1,1,1,1,-3.87,-4.15,-4.53,-4.49,-3.40,-2,-0.50,0.36,0.62,0.85,0.88,0.97,0.99,1,1,1,2,2,2.11,2.71,3.33,3.95,4.49,4.97,5.45,6,6.60,7.12,7.62,8,8.37,8.75,9.08,9.36,9.62,9.86,10.08,10.25,10.50,10.75,11,11.26,11.51,11.75,11.95,12.11,12.14,12.11,11.84,11.38,10.84,10.14,9.50,8.87,8.48,8.25,8.24,8.34,8.49,8.62,8.73,8.70,8.57,8.25,7.87,7.58,7.35,7.25,7.26,7.38,7.58,7.71,7.75,7.74,7.62,7.50,7.35,7.20,7.09,7.09,7.20,7.48,7.76,8.36,9.02,9.87,10.87,11.88,12.88,13.74,14.25,14.49,14.62,14.83,15.11,15.50,16,16.52,17.14,17.50,17.45,16.97,16.38,15.87,15.38,14.89,14.35,13.74,13,12.23,11.37,10.70,10.25,10,9.75,9.61,9.49,9.27,9.40,9.87,10.49,11.22,12,12.73,13.35,13.76,14.09,14.27,14.36,14.47,14.75,15.02,15.24,15.37,15.24,14.90,14.46,13.60,12.52,11.38,11.14,11.12,11.14,12.12,12.97,13.89,14.87,15.70,15.64,15.62,13.73,12.50,11.50,10.70,10.02,9.58,9.25,9.01,8.87,8.77,9,9.57,10.25,11.09,11.88,12.64,13.27,13.84,14.32,14.82,15.37,16,16.70,17.25,17.72,17.87,17.77,17.46,16.89,16.13,15.26,14.40,13.58,12.71,11.86,11,10.22,9.50,8.95,8.60,8.51,8.75,9.25,9.95,10.73,11.60,12.52,13.58,14.61,15.58,16.37,16.95,17.25,17.37,17.35,17.24,17.01,16.75,16.45,16.14,15.87,15.58,15.22,14.50,13.48,12.11,10.65,9.46,8.50,8.12,8.14,8.60,9.33,10.23,11.01,11.64,12.22,12.33,12.87,13,13,12.70,12.10,11.25,10.87,10.75,10.87,10.98,10.98,10.86,10.11,9.08,8,7,6,5,4,3.12,2.33,1.63,1.25,1,0.83,0.47,-0.25,-0.75,-1.37,-2,-2.73,-2.85,-2,-1.25,-0.64,-0.25,0,0.21,0.48,0.70,0.84,0.95,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.10,1.23,1.38,1.62,1.86,2.08,2.26,2.47,2.50,2.37,2.25,2.12,2,1.88,1.74,1.47,1.21,1.01,1,1,0.99,0.99,0.99,1,1,1,-2.88,-3.03,-3.13,-2.87,-2,-0.80,0.13,0.70,0.87,0.98,0.98,0.99,1,1,1,1,2,2,2.07,2.71,3.33,3.87,4.39,4.89,5.39,5.97,6.52,7.08,7.50,7.87,8.24,8.58,8.87,9.15,9.47,9.72,9.90,10.12,10.35,10.58,10.82,11.07,11.25,11.45,11.52,11.62,11.62,11.52,11.32,10.95,10.32,9.51,8.75,8.10,7.61,7.34,7.25,7.25,7.39,7.59,7.73,7.76,7.75,7.61,7.32,6.99,6.73,6.60,6.58,6.62,6.75,6.87,6.96,7,7,6.99,6.96,6.96,7,7.12,7.37,7.72,8.08,8.62,9.26,10.12,11.09,12.12,13.14,14,14.48,14.59,14.61,14.62,14.77,15.09,15.49,15.96,16.46,16.84,16.89,16.64,16.25,15.82,15.32,14.74,14.09,13.35,12.49,11.60,10.75,10.12,9.75,9.57,9.37,9.14,8.90,8.73,8.85,9.32,10,10.86,11.75,12.62,13.37,13.90,14.26,14.49,14.52,14.63,14.84,14.95,14.95,14.87,14.87,14.87,14.77,14.25,12.99,11.82,11.25,10.87,10.89,11.20,11.99,12.85,13.73,14.71,14.65,13.64,12.62,11.40,10.45,9.62,9,8.62,8.46,8.60,8.73,9.07,9.62,10.35,11.12,12,12.89,13.75,14.47,14.86,15.25,15.65,16.14,16.73,17.34,17.87,18.34,18.49,18.33,17.87,17.27,16.51,15.63,14.76,13.98,13.13,12.35,11.50,10.64,9.87,9.23,8.75,8.50,8.65,9.10,9.71,10.46,11.33,12.26,13.36,14.47,15.57,16.50,17.23,17.60,17.75,17.75,17.65,17.52,17.36,17.12,16.86,16.58,16.23,15.75,14.97,13.75,12.12,10.62,9.37,8.52,8.25,8.46,9,9.85,10.87,11.86,12.65,13.22,13.65,14.10,14.22,13.99,13.71,12.75,12,11.25,11.11,11,10.99,10.99,10.87,10.10,9.95,8.99,8,7,6,5,4,3.12,2.34,1.75,1.37,1.12,0.95,0.57,-0.39,-0.27,-0.87,-1.85,-2.54,-1.75,-1.01,-0.50,-0.13,0.10,0.25,0.46,0.62,0.76,0.87,0.96,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.12,1.23,1.36,1.50,1.63,1.77,1.87,1.89,1.87,1.75,1.62,1.51,1.46,1.35,1.22,1.10,1,0.99,0.99,0.99,0.99,0.99,0.99,1,1,-1.88,-1.91,-1.88,-1.54,-0.93,-0.16,0.49,0.75,0.87,0.98,0.99,1,1,1,1,1,2,2,2.25,2.72,3.32,3.82,4.33,4.84,5.37,5.89,6.49,6.99,7.37,7.75,8.12,8.46,8.75,9.07,9.35,9.61,9.83,10,10.20,10.37,10.60,10.77,10.99,11.09,11.11,11.01,10.90,10.76,10.59,10.25,9.62,8.82,8,7.33,6.82,6.49,6.36,6.36,6.46,6.62,6.83,6.97,7,6.99,6.75,6.40,6.12,5.99,5.97,6,6.12,6.26,6.40,6.57,6.63,6.75,6.86,6.99,7.20,7.46,7.75,8.13,8.50,9,9.61,10.36,11.25,12.33,13.32,14.09,14.45,14.48,14.36,14.25,14.25,14.40,14.75,15.14,15.62,16.01,16.33,16.34,16.12,15.75,15.25,14.64,14,13.21,12.34,11.40,10.62,10.07,9.75,9.62,9.38,9.09,8.71,8.50,8.37,8.86,9.58,10.48,11.50,12.62,13.62,14.32,14.62,14.87,15.09,15.13,15.12,15,14.72,14.36,14.25,14.22,14.37,14.25,13.40,12.34,11.33,10.87,10.12,10.20,10.87,11.75,12.25,12.72,12.27,11.74,10.89,10,9.22,8.61,8.10,8,8.12,8.50,9,9.62,10.36,11.12,12,12.95,13.86,14.75,15.45,15.82,16.12,16.50,16.87,17.36,17.84,18.25,18.61,18.70,18.50,18.02,17.46,16.73,15.87,15.11,14.37,13.62,12.87,12.10,11.23,10.37,9.60,9,8.62,8.62,9,9.52,10.25,11.09,12.02,13.12,14.32,15.50,16.62,17.48,17.95,18.21,18.15,18.12,18.08,18,17.82,17.59,17.25,16.77,16.34,15.21,13.70,11.89,10.40,9.25,8.61,8.48,8.86,9.50,10.45,11.61,12.72,13.70,14.27,14.87,15.70,15.70,14.99,14.25,13.74,12.25,11.75,11.22,11.01,11,10.98,10.87,10.08,9.97,9,8,8,7,6,4.99,4,3,2.32,1.86,1.37,1.36,1,0.62,0.37,-0.38,-0.80,-1.13,-1,-0.62,-0.25,-0.02,0.12,0.25,0.39,0.62,0.75,0.87,0.96,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.10,1.13,1.25,1.33,1.37,1.46,1.48,1.45,1.36,1.25,1.22,1.15,1.12,1.08,1,1,0.99,0.99,0.99,0.99,0.99,0.99,1,1,-0.88,-0.88,-0.78,-0.55,-0.16,0.25,0.62,0.87,0.96,0.99,0.99,1,1,1,1,1,1.87,2,2.32,2.72,3.25,3.75,4.25,4.75,5.25,5.83,6.37,6.87,7.26,7.64,8,8.36,8.64,8.98,9.25,9.50,9.73,9.87,10.01,10.20,10.34,10.50,10.63,10.72,10.60,10.37,10.13,9.89,9.62,9.27,8.70,7.89,7.15,6.51,6.02,5.74,5.59,5.57,5.63,5.83,6,6.15,6.27,6.25,6.13,5.87,5.60,5.45,5.46,5.59,5.75,6,6.25,6.47,6.64,6.87,7.08,7.33,7.62,7.97,8.37,8.75,9.12,9.52,10,10.65,11.50,12.48,13.37,14.02,14.35,14.25,14,13.75,13.62,13.70,13.96,14.34,14.77,15.25,15.62,15.89,15.96,15.72,15.25,14.72,14.08,13.35,12.50,11.75,11.01,10.52,10.32,10.12,9.84,9.37,8.84,8.40,8.36,8.49,9.02,10.07,11.12,12.35,13.46,14.35,15,15.47,15.65,15.82,15.62,15.25,14.65,13.99,13.62,13.37,13.38,13.32,13.37,12.50,11.64,10.87,9.87,9.14,9.87,10.23,10.75,10.73,10.25,9.87,9.25,8.39,8.12,7.83,7.57,7.71,8.14,8.87,9.62,10.37,11.14,12,12.87,13.75,14.63,15.50,16.32,16.62,16.96,17.25,17.61,17.98,18.36,18.71,18.89,18.87,18.57,18.07,17.40,16.75,16.07,15.37,14.82,14.22,13.57,12.75,11.87,10.96,10.08,9.34,8.82,8.75,9,9.46,10.10,10.87,11.83,12.89,14.12,15.37,16.52,17.50,18.12,18.57,18.51,18.50,18.51,18.57,18.48,18.25,17.88,17.25,16.46,14.88,13.24,11.38,10.08,9.12,8.75,8.83,9.25,10.01,11.01,12.25,13.57,14.72,15.22,15.99,16.72,16.73,15.98,15.09,14,13.01,12.07,11.36,11.15,11.08,11,10.83,10.61,9.87,9.11,8.25,7.87,7.13,6.88,5.98,4.87,4.12,3.25,2.75,2.33,2,1.75,1.25,0.97,0.62,0.14,-0.02,-0.10,0,0.12,0.22,0.24,0.34,0.48,0.62,0.75,0.87,0.95,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.02,1.09,1.12,1.12,1.15,1.20,1.14,1.12,1.10,1.07,1.01,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,0,0,0.07,0.13,0.37,0.62,0.82,0.87,0.97,0.99,1,1,1,1,1,1.11,1.73,2,2.34,2.71,3.25,3.70,4.20,4.62,5.12,5.63,6.20,6.71,7.15,7.60,7.96,8.26,8.61,8.87,9.13,9.37,9.60,9.75,9.87,9.97,10.02,10.12,10.25,10.24,10,9.63,9.32,8.99,8.62,8.15,7.61,6.95,6.26,5.74,5.34,5.07,4.90,4.87,4.98,5.12,5.26,5.46,5.59,5.60,5.50,5.25,5.02,4.99,5.10,5.36,5.70,6.07,6.38,6.73,7,7.25,7.57,7.87,8.25,8.63,9.11,9.50,9.88,10.24,10.60,11.11,11.82,12.63,13.48,14.02,14.25,14.08,13.73,13.32,13,12.95,13.12,13.49,13.96,14.46,14.95,15.37,15.62,15.59,15.25,14.84,14.27,13.72,13.09,12.48,11.95,11.50,11.22,10.88,10.50,9.90,9.24,8.61,8.25,8.24,8.71,9.57,10.59,11.71,12.77,13.82,14.70,15.49,16.12,16.50,16.38,15.62,14.87,14.12,13.37,12.60,12.25,12.23,12.10,11.62,10.85,9.99,9.12,8.87,8.87,9.11,9.23,9.21,8.87,8.25,7.85,7.35,7.24,7.35,7.59,8.02,8.75,9.51,10.37,11.24,12.08,12.87,13.71,14.50,15.32,16.11,16.86,17.34,17.62,17.97,18.25,18.60,18.88,19.14,19.32,19.12,18.63,18.09,17.39,16.75,16.20,15.73,15.32,14.86,14.32,13.58,12.62,11.61,10.62,9.75,9.11,8.96,9.08,9.38,9.96,10.70,11.61,12.70,13.89,15.15,16.37,17.40,18.12,18.71,18.85,18.75,18.64,18.58,18.48,18.36,18.01,17.25,16.12,14.37,12.62,10.87,9.75,9.09,8.95,9.12,9.71,10.52,11.60,12.86,14.08,15.22,16.10,16.87,17.74,17.74,16.75,15.75,14.62,13.38,12.49,11.85,11.38,11.21,11.11,11,10.74,10.11,9.33,8.75,8.22,7.75,7.11,6.21,5.85,5,4.82,3.75,3.25,2.99,2.75,2.23,1.82,1.12,1.12,0.98,0.83,0.71,0.63,0.60,0.51,0.51,0.61,0.71,0.82,0.87,0.96,0.97,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1.01,1.01,1.01,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,0.62,0.62,0.62,0.62,0.74,0.84,0.87,0.96,0.98,1,1,1,1,1,0.99,1.25,1.63,2,2.33,2.64,3.14,3.57,4,4.49,4.97,5.48,6,6.51,7.02,7.50,7.87,8.22,8.50,8.76,9.02,9.25,9.45,9.59,9.64,9.71,9.72,9.70,9.62,9.60,9.27,8.84,8.37,8,7.62,7.12,6.51,5.95,5.37,4.97,4.62,4.45,4.35,4.34,4.37,4.49,4.62,4.75,4.87,4.88,4.87,4.73,4.62,4.65,4.95,5.37,5.87,6.39,6.87,7.25,7.62,7.95,8.25,8.61,9,9.47,9.89,10.37,10.75,11,11.26,11.62,12.20,12.87,13.60,14.10,14.24,13.98,13.51,13,12.50,12.25,12.35,12.65,13.12,13.62,14.15,14.64,15.08,15.25,15.15,14.97,14.62,14.24,13.77,13.37,12.95,12.52,12.15,11.83,11.34,10.61,9.76,8.96,8.40,8.10,8.34,9,9.90,10.95,12,13.11,14.15,15.15,16.08,16.51,16.52,15.88,15.24,14.25,13.25,12.36,11.59,11.24,10.75,10.33,9.65,8.95,8.10,7.99,7.99,8,8,7.98,7.75,7.25,6.87,6.36,6.50,7.25,7.89,8.62,9.48,10.37,11.32,12.22,13.01,13.75,14.48,15.13,15.86,16.57,17.22,17.75,18.22,18.58,18.87,19.13,19.39,19.65,19.73,19.37,18.82,18.15,17.49,16.90,16.50,16.23,15.90,15.59,15.09,14.37,13.35,12.26,11.25,10.34,9.62,9.25,9.15,9.37,9.85,10.50,11.38,12.50,13.72,14.99,16.20,17.25,18.01,18.62,18.75,18.57,18.25,18,17.90,17.90,17.49,16.50,15.12,13.60,12.02,10.50,9.60,9.12,9.12,9.47,10.07,10.99,12.09,13.37,14.75,15.87,16.98,17.75,18.15,17.95,17.25,16.23,15.10,13.97,12.99,12.25,11.70,11.34,11.23,11.25,10.98,10.34,9.75,9.23,8.75,8.22,7.52,6.87,6.21,5.75,5.13,4.86,4.12,3.87,3.84,3.12,2.87,2,2.12,1.89,1.72,1.48,1.32,1.09,0.87,0.75,0.75,0.77,0.87,0.89,0.96,0.97,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.87,0.87,0.87,0.87,0.87,0.95,0.97,0.98,0.99,1,1,1,1,1,0.99,1.33,1.62,1.99,2.33,2.65,3.08,3.45,3.87,4.27,4.75,5.25,5.82,6.36,6.87,7.35,7.75,8.09,8.37,8.62,8.87,9.09,9.25,9.37,9.40,9.39,9.35,9.23,9.02,8.83,8.40,7.90,7.45,7,6.60,6.09,5.50,5,4.58,4.25,4,3.87,3.84,3.84,3.87,3.95,4,4.12,4.25,4.32,4.33,4.25,4.35,4.61,5.02,5.64,6.35,7,7.58,8.01,8.40,8.75,9.11,9.47,9.87,10.34,10.76,11.25,11.62,11.87,12.02,12.25,12.62,13.13,13.74,14.15,14.26,14,13.50,12.87,12.23,11.77,11.75,12,12.37,12.85,13.37,13.89,14.39,14.75,14.98,15,14.95,14.75,14.58,14.25,13.88,13.50,13.12,12.73,12.12,11.26,10.33,9.38,8.65,8.21,8.22,8.51,9.22,10.09,11.14,12.37,13.57,14.64,15.46,15.88,15.88,15.36,14.77,13.90,12.95,11.84,11.07,10.32,9.63,9.11,8.26,7.98,7.02,7,7,7,7,6.97,6.75,6.25,6.32,6.37,6.37,7.51,8.46,9.36,10.25,11.26,12.27,13.24,14,14.63,15.21,15.75,16.33,16.89,17.50,18.11,18.62,19,19.35,19.60,19.82,20,20,19.59,18.95,18.26,17.70,17.25,17.01,16.85,16.71,16.25,15.63,14.87,14,12.97,11.88,10.87,10.01,9.48,9.25,9.37,9.74,10.36,11.25,12.32,13.51,14.82,16.08,17.12,17.90,18.50,18.62,18.25,17.74,17.25,17.07,16.83,16.26,15.27,14.10,12.76,11.50,10.27,9.51,9.25,9.34,9.75,10.46,11.46,12.61,13.89,15.27,16.75,17.75,18.75,18.75,18.65,17.59,16.59,15.50,14.40,13.45,12.62,11.96,11.38,11.36,11.27,11.21,10.57,10.10,9.62,9.21,8.62,7.99,7.33,6.75,6.34,6.10,5.87,5,5,4,4,4,4,3,3.10,2.85,2.47,2.09,1.59,1.15,0.96,0.87,0.87,0.88,0.95,0.96,0.97,0.98,0.98,0.99,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.98,0.98,0.98,0.98,0.98,0.98,0.98,0.99,1,1,1,1,1,0.99,0.99,1.33,1.63,1.99,2.33,2.64,3,3.34,3.72,4.12,4.50,5.07,5.62,6.13,6.62,7.11,7.50,7.87,8.20,8.47,8.71,8.87,9.02,9.13,9.15,9.12,9,8.75,8.46,8.02,7.58,7,6.49,6.01,5.62,5.12,4.61,4.14,3.86,3.62,3.49,3.39,3.39,3.45,3.48,3.50,3.52,3.62,3.72,3.77,3.89,4,4.25,4.72,5.34,6.12,6.90,7.72,8.37,8.87,9.33,9.70,10,10.37,10.75,11.22,11.65,12.12,12.57,12.75,12.85,12.87,13.08,13.40,13.87,14.25,14.38,14.12,13.58,12.87,12.21,11.61,11.36,11.47,11.72,12.11,12.59,13.12,13.65,14.15,14.59,14.95,15.08,15.20,15.26,15.14,14.76,14.35,13.82,13.25,12.59,11.74,10.76,9.87,9.01,8.33,8.10,8.20,8.51,9.22,10.33,11.61,12.87,13.87,14.34,14.58,14.47,14.12,13.70,12.90,12.02,11.07,10.12,9.38,8.63,8,7.25,6.99,6,6.08,6,6,6,6,6,6.07,6.13,6.37,6.99,7.90,9.26,9.98,10.97,12.01,13.14,14.12,14.88,15.38,15.86,16.25,16.75,17.25,17.84,18.37,18.89,19.35,19.63,19.87,20,20.12,20,19.52,18.89,18.36,17.87,17.62,17.50,17.51,17.25,16.72,15.87,15.14,14.47,13.65,12.57,11.32,10.33,9.59,9.25,9.36,9.65,10.27,11.12,12.15,13.37,14.62,15.95,17,17.87,18.47,18.49,18,17.27,16.62,16.14,15.76,15.14,14.25,13.13,12.08,11,10.15,9.62,9.45,9.62,10.12,10.95,11.99,13.22,14.50,16,17.38,18.70,19.02,19,18.60,17.87,16.90,15.87,14.83,13.77,12.87,12.13,11.61,11.50,11.45,11.32,10.75,10.39,9.99,9.51,8.87,8.23,7.64,7.34,7.11,7,6.73,6.12,6,5,5,5,6,5,5,4,3.95,2.87,2,1.36,1.01,0.96,0.90,0.95,0.96,0.97,0.97,0.98,0.99,1,1,1,1.02,1.02,1.01,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,0.99,1,1.33,1.63,1.99,2.33,2.63,2.98,3.27,3.62,4,4.37,4.87,5.45,5.96,6.39,6.85,7.25,7.62,7.96,8.25,8.50,8.70,8.85,8.89,8.89,8.84,8.62,8.33,7.87,7.37,6.75,6.13,5.58,5.13,4.74,4.25,3.82,3.49,3.25,3.12,3.08,3.10,3.12,3.15,3.22,3.23,3.25,3.26,3.36,3.48,3.62,3.85,4.25,4.86,5.62,6.50,7.47,8.35,9.11,9.72,10.21,10.60,10.89,11.24,11.59,12,12.50,12.98,13.40,13.62,13.62,13.50,13.50,13.72,14,14.34,14.50,14.25,13.72,13,12.26,11.64,11.24,11.12,11.23,11.48,11.86,12.36,12.87,13.46,13.98,14.40,14.75,15.12,15.50,15.50,15.13,14.61,13.90,13.25,12.57,11.84,11.08,10.23,9.37,8.61,8.10,7.87,7.99,8.51,9.59,10.75,11.87,12.57,12.75,12.88,12.83,12.62,12.25,11.71,10.95,9.96,9,8.33,7.63,7.11,6.25,6,5.99,5,5.07,5.10,5.12,5.12,5.21,5.95,6.22,6.37,7.25,8.24,9.33,10.32,11.34,12.50,13.52,14.50,15.37,15.89,16.33,16.71,17.12,17.62,18.14,18.71,19.20,19.59,19.86,20,20.08,20,19.75,19.27,18.75,18.25,17.87,17.75,17.85,17.85,17.25,16.50,15.75,15.12,14.61,13.95,12.88,11.50,10.46,9.61,9.25,9.34,9.62,10.23,11,12,13.12,14.40,15.72,16.86,17.75,18.27,18.35,17.77,17.07,16.23,15.60,15.01,14.37,13.50,12.50,11.51,10.70,10.09,9.73,9.72,10,10.62,11.50,12.62,13.87,15.27,16.75,18.12,19.50,19.50,19.25,18.72,17.98,17.09,16.12,15.10,14,13.08,12.25,11.76,11.75,11.63,11.39,11,10.57,10.21,9.62,9.10,8.57,8.23,8.10,7.99,8,7.75,7.25,6.87,6,5,6,6,7,7,6.96,5.09,3.99,2.13,1.20,1.07,1,0.97,0.97,0.97,0.97,0.98,0.99,1,1,1.07,1.10,1.12,1.12,1.11,1.08,1.02,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,0.99,0.99,1,1.33,1.62,1.99,2.32,2.62,2.98,3.25,3.52,3.87,4.24,4.63,5.23,5.75,6.15,6.58,6.97,7.35,7.70,8,8.25,8.48,8.61,8.63,8.62,8.50,8.24,7.85,7.33,6.73,6.11,5.45,4.87,4.38,3.99,3.58,3.21,2.98,2.85,2.76,2.82,2.87,3,3.09,3.12,3.13,3.12,3.12,3.20,3.25,3.48,3.75,4.23,4.87,5.74,6.73,7.75,8.76,9.62,10.37,10.96,11.37,11.65,11.90,12.24,12.62,13.11,13.58,14.14,14.37,14.26,14.02,13.87,13.87,14.07,14.26,14.46,14.35,13.83,13.14,12.45,11.76,11.26,11,10.88,10.99,11.23,11.61,12.10,12.62,13.14,13.64,14.12,14.51,15,15.13,14.75,14.12,13.37,12.70,12.02,11.50,11,10.37,9.62,8.82,8.09,7.62,7.51,7.99,8.82,9.70,10.46,10.86,11.07,11.12,11.15,11.12,11.01,10.50,9.72,8.71,7.76,7.23,6.75,6.33,5.76,5,5,5,5,5.02,5.09,5.12,5.82,6.14,6.27,6.90,7.47,8.37,9.33,10.32,11.37,12.46,13.50,14.50,15.38,16.02,16.51,16.99,17.46,17.97,18.50,19.01,19.49,19.84,20.01,20.12,20.07,19.86,19.50,19,18.47,17.99,17.62,17.50,17.62,17.38,16.74,15.95,15.21,14.62,14.26,13.62,12.60,11.37,10.37,9.61,9.24,9.25,9.58,10.11,10.82,11.73,12.77,14,15.25,16.50,17.37,17.96,18.02,17.62,16.88,16.14,15.39,14.74,14,13.13,12.15,11.25,10.51,10.10,9.88,10.01,10.49,11.20,12.12,13.25,14.51,16,17.50,18.89,19.65,19.97,19.58,18.87,18.08,17.12,16.20,15.12,14.02,13.12,12.58,12.33,12.20,11.97,11.62,11.27,10.76,10.27,9.64,9.23,8.75,8.64,8.64,8.75,8.87,8.87,8.60,7.75,6.90,6,6,6,7,7,7.90,6.87,5.85,3.12,1.23,1.12,1,0.99,0.98,0.98,0.98,0.98,0.99,1,1.07,1.12,1.15,1.23,1.23,1.20,1.12,1.11,1.07,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,1,1,1,1,1,1,0.99,1,1,1.33,1.62,1.98,2.26,2.61,2.87,3.12,3.38,3.73,4.07,4.48,4.98,5.50,5.90,6.26,6.62,7.01,7.40,7.75,8,8.23,8.34,8.35,8.25,8.07,7.74,7.25,6.73,6.11,5.48,4.85,4.27,3.84,3.38,3.02,2.75,2.62,2.58,2.61,2.70,2.85,3,3.12,3.23,3.25,3.24,3.15,3.14,3.23,3.37,3.63,4.12,4.82,5.63,6.70,7.82,8.89,9.89,10.76,11.47,11.96,12.24,12.38,12.60,12.87,13.25,13.82,14.46,14.75,14.64,14.32,14,13.87,13.97,14.12,14.25,14.25,13.87,13.25,12.59,11.90,11.37,10.98,10.73,10.62,10.71,10.89,11.26,11.75,12.25,12.74,13.20,13.62,13.87,13.97,13.62,13.12,12.50,11.87,11.34,10.86,10.51,10.12,9.51,8.87,7.87,7.33,7.20,7.45,7.97,8.52,9.02,9.33,9.38,9.50,9.62,9.65,9.60,9.13,8.37,7.47,6.65,6.23,5.87,5.63,5.12,5,5,5,5,5,5.95,6.11,6.13,6.82,7.20,7.40,7.95,8.51,9.27,10.14,11.12,12.13,13.20,14.20,15.10,15.87,16.50,17.07,17.62,18.23,18.83,19.37,19.82,20.12,20.25,20.23,20.02,19.73,19.25,18.70,18.11,17.60,17.21,16.98,16.87,16.62,15.98,15.12,14.37,13.83,13.33,12.61,11.76,10.97,10.23,9.62,9.34,9.33,9.52,9.98,10.59,11.37,12.35,13.47,14.61,15.75,16.74,17.37,17.59,17.36,16.82,16.21,15.51,14.84,14.01,13.12,12.12,11.15,10.50,10.12,10.10,10.37,10.95,11.75,12.75,13.87,15.22,16.65,18.21,19.49,20.12,20.36,19.97,19.12,18.20,17.20,16.21,15.15,14.12,13.35,12.87,12.65,12.58,12.35,12,11.51,11,10.46,9.87,9.51,9.33,9.32,9.32,9.39,9.62,9.87,9.63,8.75,7.20,6,6,6,7,7.01,7.87,7.86,5.82,3.21,2.10,1.25,1.07,1,0.99,0.98,0.98,0.99,1,1.01,1.11,1.20,1.25,1.34,1.34,1.32,1.25,1.15,1.12,1.08,1.01,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,0.99,0.99,1,1.08,1.34,1.62,1.95,2.24,2.50,2.77,3,3.25,3.57,3.87,4.23,4.65,5.20,5.62,5.97,6.33,6.71,7.09,7.46,7.74,7.88,7.97,7.89,7.75,7.50,7.12,6.62,6.10,5.50,4.87,4.32,3.77,3.36,2.98,2.65,2.50,2.39,2.45,2.51,2.70,2.87,3.12,3.32,3.45,3.49,3.46,3.37,3.25,3.25,3.37,3.58,4,4.62,5.48,6.48,7.61,8.75,9.82,10.75,11.52,12.11,12.37,12.47,12.50,12.63,12.97,13.45,14.01,14.37,14.39,14.12,13.83,13.63,13.65,13.76,13.87,13.90,13.72,13.15,12.60,11.98,11.38,10.95,10.59,10.35,10.25,10.27,10.50,10.84,11.24,11.65,12.11,12.47,12.65,12.63,12.37,11.97,11.46,10.89,10.45,10,9.72,9.40,8.90,8.22,7.39,6.87,6.75,6.87,7.10,7.50,7.85,8,8.09,8.14,8.25,8.25,8.12,7.75,7.12,6.36,5.76,5.45,5.33,5.22,5.09,5,6,6,6,6,6.97,7.09,7.12,7.84,8.12,8.26,8.48,8.77,9.27,9.98,10.77,11.74,12.72,13.70,14.62,15.47,16.25,16.97,17.63,18.36,19,19.62,20.11,20.37,20.50,20.37,20.10,19.62,19.08,18.39,17.75,17.12,16.62,16.32,16,15.63,15,14.21,13.45,12.84,12.25,11.62,10.99,10.49,10.09,9.73,9.50,9.50,9.64,9.97,10.37,11.01,11.87,12.87,13.90,14.99,15.95,16.65,17.01,17,16.73,16.26,15.74,15.08,14.25,13.25,12.21,11.21,10.50,10.20,10.25,10.65,11.37,12.34,13.36,14.50,15.85,17.26,18.71,19.87,20.51,20.74,20.32,19.37,18.33,17.24,16.23,15.24,14.24,13.65,13.46,13.35,13.20,12.87,12.46,11.87,11.27,10.65,10.12,9.76,9.65,9.65,9.64,9.87,10.21,10.51,10.39,9.52,8.27,7.11,6,6,6,7.07,7.87,7.84,6.76,4.23,2.25,1.26,1.24,1.10,1,1,0.99,0.99,1,1.07,1.12,1.25,1.37,1.40,1.46,1.39,1.36,1.25,1.21,1.12,1.10,1.02,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.02,1.07,1.12,1.24,1.34,1.23,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.12,1.35,1.62,1.87,2.14,2.39,2.63,2.87,3.12,3.37,3.62,3.97,4.36,4.75,5.21,5.61,5.99,6.36,6.73,7.09,7.37,7.50,7.50,7.38,7.20,6.87,6.48,5.99,5.46,4.87,4.36,3.82,3.36,2.96,2.62,2.45,2.35,2.36,2.45,2.59,2.76,3.02,3.33,3.58,3.75,3.83,3.75,3.62,3.50,3.37,3.37,3.49,3.87,4.45,5.21,6.12,7.23,8.36,9.45,10.40,11.22,11.74,11.98,12,11.90,11.96,12.13,12.51,12.90,13.27,13.45,13.37,13.24,13.13,13.20,13.25,13.36,13.36,13.22,12.87,12.37,11.84,11.26,10.76,10.37,10.01,9.82,9.72,9.75,9.95,10.22,10.57,10.88,11.21,11.36,11.32,11.09,10.72,10.26,9.86,9.46,9.09,8.74,8.38,7.95,7.32,6.75,6.38,6.26,6.32,6.46,6.62,6.85,6.99,7.07,7.09,7.11,7.08,6.90,6.61,6.12,5.70,5.34,5.11,5.11,5.20,5,6,7,7,7,7,7.97,8.02,8.87,9.09,9.25,9.24,9.13,9.14,9.37,9.76,10.45,11.25,12.15,13.12,14.10,15,15.87,16.73,17.50,18.33,19.09,19.75,20.32,20.62,20.73,20.57,20.20,19.62,18.98,18.25,17.50,16.73,16.12,15.70,15.26,14.75,14.07,13.25,12.51,11.89,11.34,10.75,10.37,10.20,10.09,9.96,9.87,9.87,9.98,10.12,10.37,10.84,11.50,12.26,13.25,14.26,15.25,16.02,16.57,16.75,16.65,16.39,16,15.37,14.50,13.46,12.27,11.25,10.50,10.25,10.46,11,11.87,12.90,14.02,15.13,16.49,17.89,19.20,20.21,20.87,21.02,20.62,19.62,18.45,17.25,16.24,15.34,14.58,14.24,14.12,14,13.98,13.62,13.09,12.35,11.62,10.87,10.35,10,10.09,10.20,10.27,10.39,10.62,10.87,10.87,10.40,9.22,8,7,6,6,6.88,7.87,8.83,6.76,4.87,3.25,2.20,1.57,1.25,1.12,1.01,1,1,1,1.08,1.14,1.27,1.40,1.50,1.57,1.51,1.48,1.37,1.27,1.23,1.13,1.11,1.07,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.08,1.14,1.25,1.57,1.77,2.10,1.75,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.12,1.35,1.60,1.86,2.09,2.27,2.50,2.75,2.97,3.15,3.38,3.70,4,4.37,4.76,5.21,5.62,6,6.35,6.62,6.87,7,6.97,6.82,6.58,6.24,5.84,5.37,4.87,4.34,3.85,3.36,2.96,2.62,2.38,2.32,2.32,2.37,2.50,2.73,2.97,3.25,3.58,3.87,4.12,4.24,4.15,4,3.77,3.59,3.48,3.46,3.72,4.20,4.86,5.72,6.72,7.75,8.75,9.73,10.37,10.85,11,11,10.88,10.87,11,11.25,11.60,11.88,12.12,12.26,12.37,12.45,12.50,12.60,12.63,12.62,12.50,12.25,11.87,11.45,10.96,10.48,10,9.62,9.36,9.12,9.02,9.09,9.22,9.40,9.64,9.87,9.99,9.90,9.75,9.47,9.12,8.75,8.40,8.10,7.75,7.37,6.88,6.39,6.02,5.84,5.75,5.75,5.82,5.87,6,6.10,6.12,6.13,6.14,6.12,6,5.85,5.58,5.35,5.34,5.33,5.25,5.87,6,7,8,8,8,9,9,9.90,10.11,10.59,10.58,10.37,9.97,9.62,9.50,9.63,10.12,10.85,11.72,12.63,13.62,14.59,15.50,16.39,17.27,18.14,19,19.75,20.37,20.75,20.87,20.70,20.25,19.64,18.95,18.12,17.37,16.62,15.89,15.34,14.73,14,13.22,12.39,11.75,11.15,10.71,10.37,10.23,10.23,10.25,10.34,10.37,10.46,10.50,10.59,10.65,10.77,11.12,11.82,12.70,13.71,14.70,15.51,16.15,16.51,16.62,16.50,16.20,15.59,14.71,13.59,12.38,11.35,10.62,10.37,10.73,11.37,12.60,13.76,14.95,16.02,17.34,18.62,19.87,20.71,21.25,21.32,20.83,19.77,18.57,17.34,16.33,15.35,14.87,14.87,14.98,14.86,14.75,14.27,13.75,12.86,11.98,11,10.35,10.12,10.35,10.50,10.65,10.87,11.10,11.21,11.10,10.62,10,9,7.88,7,6.01,6.87,7.12,7.15,6.75,5.21,3.87,2.76,2.07,1.59,1.33,1.13,1.08,1.01,1.01,1.10,1.20,1.33,1.48,1.59,1.62,1.62,1.59,1.50,1.38,1.34,1.25,1.20,1.12,1.09,1.01,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.08,1.14,1.36,1.62,2.13,2.62,3.10,3.70,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.12,1.33,1.52,1.77,1.99,2.14,2.37,2.58,2.75,2.98,3.15,3.39,3.71,4,4.37,4.76,5.21,5.62,5.95,6.20,6.37,6.40,6.37,6.22,5.96,5.62,5.23,4.75,4.32,3.83,3.37,2.96,2.62,2.38,2.26,2.25,2.37,2.50,2.70,2.90,3.21,3.50,3.87,4.25,4.50,4.65,4.62,4.39,4.13,3.87,3.62,3.49,3.60,3.90,4.47,5.21,6.08,7,7.87,8.70,9.22,9.50,9.62,9.62,9.62,9.62,9.65,9.87,10.20,10.50,10.83,11.12,11.37,11.60,11.74,11.83,11.87,11.84,11.73,11.50,11.21,10.83,10.37,9.96,9.50,9.13,8.84,8.58,8.37,8.26,8.25,8.35,8.47,8.59,8.62,8.60,8.47,8.25,8,7.75,7.47,7.13,6.83,6.47,6,5.62,5.37,5.25,5.25,5.25,5.25,5.27,5.35,5.37,5.38,5.40,5.48,5.49,5.47,5.45,5.46,5.50,5.73,5.87,6.14,7,7,8,9,9,10,10,10.96,11,11.32,11.83,12.25,11.50,10.83,10.12,9.70,9.62,9.90,10.52,11.37,12.27,13.25,14.24,15.15,16.11,17,17.88,18.75,19.60,20.25,20.75,20.87,20.70,20.25,19.62,18.87,18.12,17.35,16.61,15.89,15.20,14.39,13.50,12.59,11.75,11.12,10.62,10.35,10.24,10.32,10.47,10.65,10.87,11.10,11.25,11.34,11.34,11.25,11.12,11.25,11.60,12.25,13.23,14.32,15.22,15.90,16.39,16.62,16.60,16.25,15.64,14.75,13.64,12.50,11.50,10.71,10.62,11.14,12.14,13.47,14.74,15.90,17.02,18.25,19.46,20.62,21.34,21.60,21.39,20.84,19.85,18.64,17.50,16.52,15.76,15.46,15.62,15.75,15.62,15.27,14.75,14.20,13.20,12.20,11.12,10.58,10.46,10.62,10.87,11.09,11.27,11.51,11.39,11.21,10.87,10.46,9.75,8.84,7,7,6.87,6.99,6.76,6.23,5.73,4.26,3.33,2.62,2.07,1.64,1.38,1.24,1.12,1.10,1.12,1.22,1.35,1.50,1.62,1.71,1.72,1.65,1.61,1.50,1.45,1.37,1.26,1.23,1.13,1.10,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.08,1.13,1.32,1.57,1.98,2.58,3.35,3.63,3.73,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.11,1.25,1.48,1.71,1.87,2.02,2.22,2.37,2.59,2.75,2.98,3.20,3.40,3.71,4,4.37,4.75,5.13,5.50,5.72,5.84,5.87,5.77,5.62,5.37,5.02,4.64,4.25,3.77,3.37,2.99,2.62,2.37,2.26,2.25,2.35,2.50,2.70,2.90,3.21,3.50,3.87,4.25,4.63,4.96,5.12,5.09,4.87,4.57,4.22,3.89,3.62,3.58,3.73,4.10,4.63,5.37,6.12,6.84,7.38,7.76,8,8.12,8.21,8.25,8.34,8.37,8.62,8.87,9.23,9.61,10.01,10.38,10.70,10.87,11,11,10.99,10.87,10.64,10.37,10.01,9.63,9.25,8.87,8.57,8.25,8,7.75,7.59,7.46,7.37,7.37,7.37,7.37,7.37,7.26,7.13,7,6.82,6.59,6.32,6,5.64,5.25,4.99,4.85,4.77,4.76,4.76,4.76,4.77,4.82,4.84,4.87,5,5.12,5.25,5.36,5.50,5.71,6.01,6.38,6.75,7.02,8,8,9,10,10,11,11,11.96,12.15,12.57,13.01,13.12,12.70,11.58,10.62,9.96,9.64,9.87,10.40,11.22,12.12,13.07,14,14.88,15.82,16.70,17.57,18.40,19.25,19.97,20.46,20.62,20.50,20.12,19.51,18.83,18.07,17.33,16.62,15.98,15.24,14.35,13.37,12.36,11.45,10.73,10.34,10.24,10.33,10.51,10.87,11.25,11.63,11.97,12.20,12.34,12.37,12.12,11.75,11.49,11.60,12.12,13.08,14.09,15.02,15.86,16.45,16.74,16.73,16.37,15.75,14.87,13.75,12.62,11.65,11.02,11.07,11.84,13.02,14.37,15.71,16.89,18.01,19.13,20.25,21.25,21.83,21.84,21.37,20.62,19.72,18.75,17.76,16.96,16.37,16.12,16.27,16.27,16.09,15.50,14.87,14.27,13.27,12.27,11.24,10.76,10.76,11,11.23,11.39,11.62,11.87,11.75,11.39,11.12,10.75,10.33,9.75,8,7.07,7.12,6.98,6.76,6.21,5.25,4.75,3.98,3.26,2.71,2.23,1.84,1.51,1.33,1.21,1.15,1.24,1.36,1.50,1.62,1.73,1.75,1.75,1.70,1.62,1.52,1.48,1.37,1.33,1.24,1.13,1.10,1.01,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.09,1.13,1.26,1.48,1.75,2.13,2.64,3.20,3.58,3.75,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.08,1.21,1.37,1.59,1.75,1.90,2.09,2.23,2.37,2.59,2.75,2.97,3.14,3.38,3.70,4,4.37,4.73,5,5.24,5.35,5.36,5.25,5.10,4.85,4.50,4.12,3.75,3.35,2.97,2.64,2.37,2.25,2.25,2.35,2.49,2.70,2.95,3.24,3.59,3.96,4.37,4.75,5.13,5.45,5.59,5.52,5.35,5,4.63,4.26,3.89,3.71,3.62,3.82,4.21,4.71,5.25,5.77,6.21,6.46,6.51,6.62,6.75,6.95,7.02,7.23,7.47,7.75,8.10,8.50,9,9.45,9.76,10.01,10.14,10.21,10.12,10,9.76,9.50,9.21,8.86,8.50,8.20,7.88,7.62,7.38,7.14,6.95,6.73,6.57,6.45,6.37,6.36,6.34,6.26,6.23,6.12,6,5.84,5.62,5.36,5,4.72,4.50,4.39,4.37,4.38,4.38,4.39,4.46,4.49,4.52,4.64,4.87,5.12,5.39,5.64,6,6.37,6.82,7.32,7.72,8.12,9,9,10,10,11,12,12,12.96,13.24,13.58,14,14,13.27,12.08,11,10.20,9.76,9.87,10.37,11.13,12,12.87,13.76,14.62,15.48,16.27,17.12,17.98,18.75,19.48,20,20.25,20.21,19.87,19.33,18.62,17.89,17.23,16.59,16.13,15.45,14.37,13.25,12.48,11.25,10.51,10.25,10.33,10.52,10.96,11.48,12.02,12.52,12.89,13.25,13.48,13.59,13,12.35,11.87,11.82,12.25,13.08,14.09,15.07,15.88,16.50,16.77,16.75,16.37,15.75,14.87,13.87,12.84,12,11.58,11.62,12.50,13.77,15.12,16.48,17.71,18.90,20.01,20.98,21.82,22.24,21.98,21.25,20.40,19.58,18.75,18,17.37,16.95,16.75,16.75,16.50,16.27,15.62,14.98,14.20,13.20,12.24,11.35,11.12,11.24,11.46,11.58,11.76,11.87,12,11.87,11.64,11.45,11.12,10.75,9.87,9,8,7.12,7.11,6.76,6.23,5.72,5.20,4.63,4.08,3.50,3,2.49,2,1.62,1.37,1.26,1.26,1.37,1.50,1.62,1.73,1.75,1.75,1.75,1.72,1.62,1.59,1.50,1.38,1.32,1.22,1.12,1.07,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.01,1.10,1.15,1.32,1.49,1.72,1.99,2.26,2.62,2.98,3.20,2.84,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.12,1.25,1.46,1.62,1.83,1.97,2.10,2.24,2.37,2.57,2.74,2.88,3.12,3.37,3.64,4,4.33,4.60,4.76,4.87,4.87,4.76,4.61,4.36,4.01,3.65,3.32,2.97,2.63,2.46,2.25,2.25,2.35,2.49,2.65,2.95,3.25,3.62,4.02,4.50,4.97,5.37,5.75,6.01,6.12,6.09,5.87,5.57,5.15,4.75,4.35,4,3.77,3.75,3.87,4.22,4.60,4.96,5.21,5.32,5.33,5.34,5.50,5.75,5.99,6.20,6.45,6.73,7.08,7.50,8.02,8.50,8.90,9.22,9.37,9.37,9.33,9.12,8.90,8.63,8.37,8.02,7.75,7.48,7.23,7,6.77,6.58,6.34,6.10,5.87,5.71,5.60,5.51,5.50,5.50,5.49,5.45,5.37,5.25,5.10,4.87,4.59,4.36,4.25,4.25,4.25,4.26,4.26,4.32,4.37,4.49,4.62,4.86,5.21,5.58,6,6.37,6.84,7.27,7.87,8.38,8.88,9.25,9.87,10,10,11,12,13,13,13.86,14.12,14.37,14.46,14.12,13.39,12.25,11.25,10.40,9.96,9.99,10.46,11.13,11.97,12.76,13.61,14.37,15.12,15.87,16.62,17.39,18.21,18.87,19.46,19.75,19.82,19.52,19.01,18.37,17.65,16.98,16.34,15.75,15.24,14.26,13.10,11.88,11.12,10.37,10.23,10.47,10.87,11.46,12.15,12.96,13.59,13.98,14.15,14.25,14.25,13.48,12.65,12.12,12.01,12.37,13.25,14.25,15.26,16.12,16.72,16.98,16.87,16.48,15.77,14.96,14,13.08,12.32,11.96,12.01,12.85,14.12,15.48,16.77,18.12,19.48,20.71,21.50,22.23,22.46,22.07,21.20,20.26,19.45,18.85,18.25,17.85,17.50,17.27,17.20,16.75,16.27,15.50,14.75,13.87,13,12.24,11.58,11.58,11.76,12.10,12.24,12.34,12.35,12.35,12.34,12.23,12.10,11.75,11.33,10.70,9,8.89,8,7.14,6.87,6.25,6,5.65,5.25,4.87,4.47,3.95,3.34,2.70,2.12,1.72,1.48,1.37,1.39,1.50,1.61,1.70,1.75,1.75,1.75,1.75,1.74,1.65,1.61,1.50,1.37,1.25,1.15,1.10,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1.07,1.12,1.21,1.33,1.50,1.73,1.99,2.25,2.49,2.72,2.87,2.98,2.88,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.08,1.14,1.33,1.50,1.70,1.85,1.98,2.09,2.22,2.35,2.50,2.62,2.84,3.08,3.36,3.63,3.96,4.21,4.37,4.46,4.46,4.34,4.12,3.87,3.60,3.25,2.95,2.64,2.46,2.36,2.25,2.36,2.50,2.70,2.95,3.25,3.62,4.11,4.62,5.20,5.72,6.15,6.51,6.75,6.83,6.73,6.50,6.13,5.75,5.33,4.87,4.49,4.13,3.96,3.87,4,4.15,4.37,4.50,4.57,4.50,4.47,4.60,4.83,5.07,5.27,5.51,5.83,6.12,6.59,7.14,7.70,8.12,8.45,8.62,8.62,8.51,8.35,8.11,7.84,7.57,7.26,7,6.76,6.58,6.37,6.21,6,5.75,5.50,5.27,5.12,5,4.96,4.90,4.95,4.96,4.96,4.90,4.87,4.75,4.62,4.39,4.27,4.26,4.37,4.47,4.50,4.51,4.58,4.64,4.84,5.08,5.37,5.84,6.26,6.83,7.33,7.87,8.40,9.02,9.64,10.24,10.64,11,11.07,11,12,13,14,14,14.75,14.87,14.82,14.51,14.02,13.27,12.37,11.46,10.62,10.12,10.12,10.57,11.22,11.96,12.72,13.45,14.12,14.82,15.47,16.12,16.86,17.57,18.25,18.86,19.24,19.36,19.14,18.72,18.08,17.34,16.61,15.87,15.23,14.64,13.72,12.57,11.46,10.98,10.47,10.62,11,11.59,12.25,13.12,13.99,14.62,14.88,14.88,14.65,14.24,13.38,12.64,12.23,12.20,12.64,13.51,14.62,15.63,16.50,17,17.25,17.12,16.65,15.99,15.12,14.23,13.36,12.62,12.25,12.40,13.08,14.13,15.39,16.70,18,19.36,20.59,21.60,22.32,22.50,22,21.12,20.25,19.46,18.90,18.50,18.24,18,17.75,17.50,16.87,16.20,15.27,14.38,13.58,12.76,12.24,11.87,12.24,12.62,12.98,13,13,13,13,13,13,12.87,12.51,12,11.11,10,9.08,8.87,7.87,7.21,6.75,6.25,6,5.82,5.62,5.39,4.96,4.26,3.50,2.76,2.21,1.77,1.59,1.50,1.50,1.58,1.62,1.72,1.75,1.77,1.83,1.82,1.75,1.70,1.59,1.47,1.34,1.22,1.12,1.02,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1.02,1.09,1.12,1.23,1.35,1.50,1.74,2,2.27,2.59,2.82,2.98,3,3,3,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.10,1.22,1.37,1.51,1.72,1.85,1.95,2.01,2.12,2.25,2.37,2.52,2.76,3.07,3.36,3.62,3.84,3.99,4.02,4,3.88,3.72,3.47,3.21,2.88,2.63,2.48,2.37,2.37,2.37,2.50,2.72,2.96,3.25,3.62,4.09,4.63,5.27,5.98,6.60,7.10,7.45,7.61,7.62,7.47,7.20,6.84,6.39,5.97,5.50,5.07,4.63,4.34,4.12,4.09,4.10,4.12,4.15,4.20,4.13,4,4.12,4.25,4.37,4.60,4.87,5.12,5.40,5.87,6.46,6.96,7.37,7.72,7.87,7.88,7.76,7.59,7.35,7.09,6.83,6.59,6.37,6.13,5.98,5.77,5.62,5.45,5.24,5,4.85,4.71,4.62,4.58,4.58,4.61,4.64,4.73,4.75,4.72,4.73,4.71,4.62,4.60,4.64,4.87,5.02,5.13,5.20,5.22,5.27,5.47,5.75,6.10,6.52,7.12,7.75,8.39,9.07,9.65,10.39,11.20,11.86,12.21,12.37,12.82,12,13,14,15,15,15.70,15.50,15.21,14.76,14.20,13.45,12.57,11.62,10.86,10.37,10.37,10.75,11.36,12,12.72,13.37,13.98,14.51,15.10,15.64,16.33,16.99,17.62,18.21,18.62,18.84,18.74,18.35,17.71,16.95,16.12,15.37,14.61,13.82,12.90,11.95,11.25,11,11,11.26,11.87,12.59,13.39,14.27,15.12,15.65,15.77,15.36,14.62,13.83,13.07,12.48,12.20,12.38,12.96,13.98,15.10,16.12,16.97,17.45,17.62,17.46,17,16.27,15.48,14.60,13.74,13,12.62,12.65,13.08,14.12,15.25,16.39,17.62,18.77,19.89,21.01,21.90,22.25,21.87,21.09,20.27,19.62,19.13,18.84,18.60,18.37,18.01,17.75,16.98,16.09,14.99,14,13.24,12.76,12.58,12.58,12.99,13.50,13.86,14,14,14,13.99,13.99,13.87,13.62,13.32,12.75,12,11,10.07,9.12,8.13,7.76,7.22,6.73,6.27,6.25,6.35,6.25,5.88,5.25,4.40,3.59,2.85,2.25,1.87,1.64,1.59,1.58,1.62,1.65,1.75,1.83,1.87,1.87,1.85,1.75,1.62,1.50,1.37,1.25,1.12,1.07,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1.07,1.10,1.12,1.15,1.25,1.36,1.50,1.72,1.98,2.27,2.62,2.98,3.23,3.37,3.38,3.12,3,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.12,1.24,1.37,1.51,1.64,1.75,1.86,1.95,2.01,2.13,2.33,2.52,2.82,3.09,3.27,3.48,3.58,3.61,3.58,3.47,3.26,3.08,2.86,2.62,2.49,2.38,2.39,2.50,2.60,2.75,3,3.25,3.61,4.01,4.59,5.25,6,6.83,7.58,8.12,8.48,8.59,8.50,8.32,7.99,7.59,7.12,6.64,6.21,5.74,5.25,4.87,4.59,4.37,4.25,4.20,4.12,4,4,4,4,4.12,4.14,4.25,4.37,4.58,4.86,5.27,5.86,6.32,6.72,7,7.15,7.15,7.07,6.87,6.62,6.37,6.14,5.97,5.75,5.61,5.45,5.26,5.12,4.98,4.82,4.63,4.51,4.47,4.39,4.39,4.47,4.51,4.63,4.77,4.90,5.07,5.11,5.25,5.25,5.25,5.39,5.65,5.97,6.12,6.14,6.15,6.21,6.25,6.47,6.75,7.25,7.89,8.73,9.59,10.26,11,11.77,12.62,13.38,13.86,13.99,13.70,13.11,14,15,15.98,15.96,16.62,16.01,15.65,15.15,14.52,13.75,12.87,12,11.23,10.75,10.74,11.09,11.60,12.21,12.83,13.39,13.95,14.38,14.85,15.34,15.87,16.47,17.01,17.52,17.99,18.24,18.24,17.89,17.27,16.50,15.70,14.85,13.98,13.07,12.13,11.50,11.21,11.24,11.45,11.99,12.76,13.71,14.64,15.51,16.24,16.65,16.36,15.46,14.35,13.35,12.62,12.25,12.25,12.62,13.37,14.39,15.62,16.65,17.47,17.87,18,17.84,17.37,16.70,15.87,15.07,14.22,13.48,13,12.96,13.15,14.08,15.08,16.15,17.20,18.15,19.12,20.22,21.22,21.75,21.58,21,20.38,19.87,19.40,19.07,18.75,18.45,17.98,17.50,16.62,15.62,14.58,13.65,13.12,12.87,12.87,13.12,13.65,14.32,14.86,15.20,15.20,15.09,14.98,14.87,14.62,14.32,13.99,13.52,12.87,12,10.90,9.87,8.87,8.21,7.75,7,6.26,6.64,6.77,6.87,6.70,6.11,5.32,4.39,3.57,2.84,2.25,1.87,1.70,1.62,1.62,1.70,1.75,1.86,1.89,1.90,1.87,1.83,1.71,1.57,1.39,1.26,1.14,1.09,1,1,0.99,0.99,0.99,0.99,0.99,1,1,1.02,1.10,1.12,1.20,1.24,1.27,1.37,1.50,1.64,1.87,2.20,2.52,2.98,3.37,3.73,3.87,3.98,3.99,4,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.02,1.12,1.23,1.35,1.47,1.57,1.62,1.73,1.85,1.99,2.13,2.37,2.61,2.84,3,3.12,3.14,3.15,3.12,3.01,2.88,2.74,2.57,2.47,2.40,2.47,2.58,2.72,2.87,3.09,3.35,3.62,4,4.50,5.12,5.87,6.75,7.70,8.58,9.22,9.58,9.62,9.50,9.25,8.87,8.39,7.88,7.45,6.96,6.47,6,5.57,5.15,4.87,4.62,4.35,4.21,4.11,4.08,4,4,4.01,4.07,4.10,4.12,4.25,4.50,4.88,5.36,5.75,6.10,6.35,6.48,6.47,6.35,6.14,5.98,5.75,5.59,5.38,5.25,5.12,4.98,4.85,4.73,4.61,4.50,4.46,4.40,4.40,4.46,4.50,4.61,4.75,4.95,5.15,5.39,5.64,5.89,6.12,6.34,6.46,6.58,6.87,7.22,7.39,7.50,7.48,7.37,7.25,7.24,7.37,7.83,8.52,9.60,10.59,11.50,12.25,13.15,14.08,14.75,15.25,15.40,14.75,14.21,14,15,15.96,16.08,16.57,16.52,16.23,15.74,15.08,14.25,13.37,12.50,11.74,11.25,11.20,11.45,11.88,12.48,13.08,13.62,14.12,14.50,14.85,15.20,15.62,16.11,16.57,16.99,17.33,17.57,17.60,17.38,16.83,16.10,15.25,14.37,13.48,12.37,11.62,11.21,11.22,11.50,11.87,12.64,13.62,14.71,15.83,16.70,17.24,17.24,16.46,15.20,13.96,12.87,12.32,12.12,12.35,12.88,13.83,14.96,16.13,17.22,17.98,18.37,18.40,18.23,17.75,17.12,16.37,15.51,14.72,13.96,13.40,13.34,13.50,14.37,15.27,16.20,16.88,17.70,18.49,19.50,20.37,21.07,21.14,20.87,20.50,20.02,19.62,19.23,18.75,18.25,17.62,16.87,16,15.09,14.12,13.46,13,13.12,13.35,13.76,14.35,15.24,15.98,16.50,16.38,16.20,15.87,15.62,15.33,14.99,14.62,14.33,13.70,13,11.01,10.10,9.12,8.82,8,7.25,7,6.88,7.07,7.13,7.12,6.75,6.02,5.20,4.25,3.38,2.70,2.14,1.86,1.71,1.70,1.75,1.85,1.90,1.99,2,1.97,1.87,1.75,1.61,1.46,1.32,1.20,1.10,1,1,0.99,0.99,0.99,1,1,1,1.08,1.12,1.15,1.25,1.32,1.37,1.47,1.52,1.64,1.84,2.02,2.37,2.75,3.21,3.70,4.10,4.37,4.52,4.98,5,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.11,1.15,1.25,1.35,1.40,1.51,1.65,1.86,2.01,2.24,2.40,2.61,2.73,2.76,2.77,2.76,2.75,2.65,2.59,2.49,2.39,2.39,2.50,2.62,2.76,2.98,3.21,3.47,3.75,4.11,4.50,5,5.63,6.49,7.40,8.48,9.46,10.21,10.62,10.75,10.62,10.32,9.87,9.27,8.77,8.25,7.75,7.25,6.75,6.33,5.84,5.47,5.07,4.76,4.50,4.37,4.25,4.13,4.12,4.09,4.02,4.01,4.02,4.12,4.33,4.61,4.95,5.24,5.50,5.70,5.75,5.75,5.65,5.51,5.37,5.23,5.09,4.96,4.83,4.72,4.61,4.50,4.40,4.37,4.37,4.40,4.50,4.62,4.74,4.85,5,5.22,5.50,5.82,6.12,6.50,6.87,7.24,7.57,7.84,8.02,8.37,8.70,8.88,9.01,8.89,8.60,8.25,7.99,7.96,8.14,8.90,10.08,11.25,12.37,13.25,14.15,15.08,15.74,16.09,15.98,15.57,15.23,15.10,15.97,16.09,16.86,17.12,17.12,16.87,16.39,15.74,14.87,13.96,13.07,12.27,11.75,11.63,11.86,12.25,12.82,13.38,13.98,14.48,14.87,15.13,15.37,15.63,15.96,16.25,16.50,16.74,16.87,16.87,16.65,16.25,15.62,14.87,14.02,13.12,12.10,11.47,11.14,11.38,11.87,12.50,13.36,14.37,15.50,16.50,17.25,17.52,17.23,16.12,14.85,13.50,12.62,12.14,12.12,12.50,13.21,14.22,15.38,16.62,17.72,18.46,18.77,18.84,18.62,18.14,17.51,16.77,15.99,15.13,14.37,13.87,13.84,14.09,14.89,15.83,16.59,17.14,17.73,18.25,19.01,19.85,20.40,20.75,20.75,20.52,20.20,19.73,19.20,18.59,17.89,17.15,16.35,15.36,14.58,13.77,13.35,13,13.24,13.65,14.35,15.24,16.27,17.27,17.86,17.62,17.27,16.76,16.39,16,15.62,15.23,14.87,14.73,13,12,11,10.11,9.14,8.21,7.75,7.25,7.08,7.12,7.24,7.24,7.08,6.58,5.75,4.86,3.87,3.08,2.45,2,1.84,1.76,1.85,1.95,2,2.08,2.08,2,1.90,1.77,1.62,1.49,1.35,1.22,1.11,1.02,1,1,1,1,1,1.02,1.09,1.12,1.22,1.26,1.37,1.47,1.52,1.62,1.74,1.85,1.99,2.20,2.49,2.87,3.33,3.76,4.23,4.71,4.95,4.97,5,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.08,1.12,1.15,1.25,1.37,1.59,1.75,1.97,2.12,2.25,2.37,2.48,2.50,2.50,2.46,2.39,2.37,2.37,2.37,2.38,2.50,2.62,2.85,3.08,3.32,3.61,3.90,4.25,4.62,5,5.50,6.20,7,8,9.10,10.12,11,11.60,11.86,11.75,11.48,11,10.37,9.82,9.14,8.62,8.12,7.70,7.25,6.73,6.26,5.77,5.48,5.09,4.87,4.71,4.50,4.37,4.25,4.15,4.10,4.07,4.09,4.20,4.37,4.59,4.76,4.97,5.10,5.13,5.12,5.09,4.99,4.87,4.75,4.64,4.58,4.49,4.38,4.34,4.26,4.25,4.32,4.39,4.59,4.76,5,5.22,5.37,5.61,5.87,6.24,6.62,7.02,7.49,7.95,8.38,8.87,9.25,9.62,9.96,10.25,10.49,10.61,10.37,9.83,9.13,8.71,8.49,8.61,9.13,10.15,11.37,12.73,13.84,14.84,15.74,16.26,16.50,16.46,16.34,16.34,16.20,16.88,17.12,17.77,17.87,17.85,17.62,17.20,16.50,15.57,14.57,13.62,12.86,12.34,12.12,12.25,12.63,13.22,13.83,14.39,14.95,15.35,15.62,15.84,15.97,16.07,16.12,16.22,16.25,16.24,16.12,15.97,15.62,15.14,14.50,13.75,12.96,12.12,11.58,11.38,11.76,12.40,13.23,14.12,15.12,16.12,16.96,17.39,17.38,16.77,15.73,14.45,13.25,12.47,12.12,12.22,12.70,13.50,14.62,15.87,17.09,18.12,18.85,19.15,19.21,18.98,18.51,17.89,17.14,16.35,15.50,14.77,14.37,14.39,14.82,15.70,16.59,17.33,17.87,18.25,18.50,18.95,19.50,20.10,20.49,20.63,20.50,20.13,19.62,19,18.33,17.61,16.83,15.90,15,14.37,13.71,13.34,13.12,13.58,14.24,15.12,16.24,17.50,18.50,18.98,18.62,18.20,17.57,17.10,16.62,16.21,15.75,15.33,14.75,14,12.98,11.90,10.87,9.84,8.76,8,7.25,7.15,7.12,7.13,7.14,7.02,6.75,6.12,5.20,4.23,3.35,2.63,2.21,1.98,1.90,1.98,2.07,2.12,2.14,2.13,2.10,1.99,1.85,1.65,1.50,1.37,1.25,1.12,1.08,1.01,1,1.01,1.02,1.09,1.12,1.14,1.24,1.33,1.39,1.50,1.62,1.74,1.84,1.90,2,2.13,2.34,2.59,2.89,3.32,3.72,4.02,4.38,4.62,4.97,5,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.09,1.12,1.24,1.37,1.59,1.75,1.90,2.07,2.13,2.24,2.25,2.26,2.25,2.25,2.25,2.32,2.36,2.40,2.52,2.71,2.87,3.12,3.37,3.71,4.09,4.49,4.87,5.25,5.62,6.10,6.71,7.50,8.49,9.52,10.62,11.62,12.39,12.87,13,12.75,12.24,11.62,10.87,10.11,9.48,8.98,8.59,8.12,7.73,7.25,6.73,6.34,5.86,5.59,5.36,5.12,4.96,4.73,4.50,4.27,4.14,4.12,4.12,4.20,4.26,4.39,4.50,4.61,4.62,4.62,4.62,4.57,4.50,4.40,4.37,4.32,4.25,4.22,4.15,4.20,4.25,4.37,4.57,4.85,5.15,5.50,5.84,6.10,6.36,6.65,7.10,7.52,8,8.50,9.02,9.61,10.13,10.62,10.96,11.13,11.37,11.50,11.61,11.25,10.61,9.87,9.25,8.90,8.83,9.25,10.13,11.34,12.62,13.84,14.96,15.96,16.74,17.08,17.20,17.33,17.52,17.77,17.97,18.15,18.74,18.62,18.62,18.40,17.90,17.25,16.12,15.11,14.12,13.36,12.83,12.60,12.71,13.07,13.62,14.25,14.88,15.48,15.88,16.15,16.32,16.35,16.32,16.22,16.08,15.88,15.74,15.50,15.25,14.97,14.57,14.08,13.46,12.83,12.14,11.84,11.87,12.38,13.20,14.08,15,15.96,16.75,17.25,17.35,17,16.25,15.21,14.01,13,12.37,12.12,12.34,12.95,13.87,15.01,16.25,17.47,18.47,19.13,19.50,19.50,19.27,18.87,18.25,17.48,16.62,15.82,15.13,14.87,15.07,15.60,16.57,17.50,18.25,18.75,18.90,19,19.12,19.47,19.97,20.37,20.58,20.45,20,19.46,18.77,18.10,17.36,16.59,15.76,15,14.37,13.83,13.50,13.52,14.12,15,16,17.23,18.50,19.50,19.86,19.50,18.97,18.33,17.75,17.23,16.75,16.22,15.75,15,14,13,11.99,11.10,10.12,9.15,8.22,7.72,7.25,7.07,7,6.96,6.84,6.51,6.02,5.25,4.35,3.50,2.83,2.37,2.12,2.08,2.12,2.20,2.25,2.25,2.23,2.12,2,1.87,1.73,1.57,1.38,1.25,1.13,1.11,1.09,1.09,1.10,1.12,1.12,1.21,1.25,1.36,1.47,1.58,1.70,1.77,1.89,2,2.12,2.25,2.37,2.50,2.70,2.96,3.24,3.50,3.75,3.87,3.96,3.99,4,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.09,1.13,1.25,1.37,1.50,1.64,1.82,1.90,2,2.08,2.12,2.13,2.15,2.22,2.25,2.34,2.39,2.50,2.62,2.77,2.97,3.20,3.48,3.75,4.20,4.65,5.13,5.59,5.98,6.34,6.73,7.24,7.97,8.87,9.87,11,12.10,13.08,13.90,14.24,14.01,13.50,12.87,11.87,10.99,10.32,9.83,9.45,9.07,8.70,8.25,7.77,7.34,6.87,6.47,6.15,5.90,5.72,5.37,5.01,4.71,4.45,4.25,4.14,4.12,4.12,4.12,4.21,4.25,4.27,4.32,4.27,4.25,4.24,4.21,4.14,4.12,4.12,4.12,4.12,4.21,4.33,4.50,4.76,5.12,5.60,6.08,6.50,6.85,7.14,7.52,8,8.51,9.07,9.60,10.13,10.75,11.37,11.74,12.02,12.13,12.25,12.25,12.25,11.83,11.13,10.37,9.76,9.37,9.25,9.49,10.13,11.13,12.35,13.50,14.62,15.73,16.74,17.37,17.86,18.34,18.50,18.63,19.82,19.01,19.12,19.33,19.25,18.96,18.36,17.57,16.58,15.52,14.61,13.82,13.25,13,13.11,13.47,14,14.70,15.37,16,16.57,16.76,16.85,16.75,16.61,16.36,16.02,15.71,15.36,15,14.62,14.33,13.97,13.52,13.12,12.64,12.25,12.22,12.51,13.21,14.08,15,15.96,16.75,17.34,17.50,17.20,16.51,15.62,14.62,13.60,12.75,12.25,12.14,12.50,13.22,14.25,15.47,16.71,17.85,18.76,19.40,19.75,19.75,19.50,19.12,18.50,17.65,16.77,16,15.48,15.37,15.74,16.46,17.45,18.47,19.25,19.72,19.74,19.51,19.40,19.58,20,20.37,20.57,20.38,19.97,19.36,18.62,17.89,17.22,16.50,15.75,15.02,14.47,14,13.87,14.24,15,15.99,17,18.12,19.27,20.20,20.50,20.20,19.62,18.98,18.34,17.75,17.21,16.63,16.11,15.88,14,13,12,11.07,10.87,9.83,8.87,7.97,7.36,6.99,6.82,6.63,6.47,6.14,5.72,5.08,4.33,3.59,2.98,2.51,2.32,2.23,2.25,2.27,2.34,2.34,2.25,2.15,2.07,1.88,1.75,1.60,1.45,1.27,1.21,1.12,1.12,1.12,1.14,1.21,1.25,1.32,1.37,1.50,1.62,1.75,1.87,2,2.12,2.24,2.37,2.49,2.60,2.73,2.86,3,3.14,3.25,3.37,3.38,3.37,3,3,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.08,1.13,1.25,1.38,1.52,1.64,1.75,1.87,1.95,2,2,2.08,2.12,2.15,2.25,2.37,2.51,2.64,2.82,2.96,3.12,3.33,3.59,3.87,4.26,4.84,5.38,5.95,6.37,6.75,7.10,7.38,7.84,8.39,9.22,10.15,11.25,12.37,13.62,14.60,15.09,15.12,14.62,13.99,12.84,11.75,11.12,10.72,10.36,10,9.64,9.25,8.86,8.39,7.90,7.46,7.12,6.87,6.62,6.25,5.77,5.32,4.88,4.60,4.37,4.21,4.10,4.01,4.07,4.11,4.12,4.12,4.12,4.12,4.11,4.10,4.09,4.08,4.08,4.11,4.14,4.25,4.46,4.70,5,5.40,5.96,6.51,7.10,7.57,7.98,8.45,8.98,9.51,10.10,10.62,11.24,11.87,12.46,12.75,12.86,12.75,12.71,12.62,12.50,12.08,11.47,10.83,10.25,9.83,9.61,9.72,10.25,11.02,12.10,13.14,14.25,15.37,16.50,17.37,18.09,18.37,18.57,18.61,18.86,19.72,19.62,19.40,19.52,19.15,18.50,17.75,16.86,15.87,15,14.24,13.71,13.46,13.50,13.85,14.37,15.07,15.75,16.39,17.08,17.37,17.37,17.22,16.90,16.52,16.12,15.62,15.12,14.62,14.15,13.75,13.38,13.07,12.75,12.52,12.39,12.71,13.25,14.02,14.96,15.95,16.86,17.62,17.96,17.70,16.95,16,14.99,14,13.13,12.50,12.22,12.25,12.71,13.50,14.62,15.87,17.11,18.22,19.10,19.64,19.89,19.87,19.62,19.21,18.52,17.71,16.87,16.11,15.74,15.85,16.37,17.25,18.25,19.33,20.11,20.46,20.35,20,19.75,19.76,20.13,20.50,20.64,20.50,20.01,19.37,18.62,17.87,17.24,16.57,15.86,15.15,14.61,14.25,14.35,14.97,15.87,16.97,17.98,18.98,19.98,20.62,20.86,20.50,20.10,19.51,18.98,18.32,17.63,16.87,16.21,16,14,13,12.98,11.89,11.07,10.75,9.22,8.12,7.37,6.88,6.60,6.33,6.02,5.74,5.34,4.83,4.24,3.62,3.12,2.75,2.50,2.37,2.37,2.37,2.37,2.36,2.26,2.20,2.08,1.90,1.75,1.62,1.48,1.36,1.25,1.21,1.15,1.22,1.25,1.32,1.37,1.46,1.51,1.63,1.77,1.96,2.11,2.24,2.36,2.49,2.62,2.75,2.87,2.98,3.08,3.12,3.14,3.22,3.24,3.22,3.12,3,3,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.02,1.12,1.25,1.38,1.58,1.73,1.83,1.87,1.90,1.98,2,2,2.09,2.13,2.25,2.39,2.60,2.76,2.98,3.13,3.34,3.50,3.75,4,4.46,4.98,5.60,6.24,6.82,7.27,7.63,7.90,8.13,8.47,8.90,9.58,10.39,11.37,12.50,13.65,14.77,15.50,15.83,15.62,14.87,13.65,12.51,12.07,11.70,11.36,11,10.64,10.25,9.86,9.47,8.96,8.47,8.12,7.87,7.62,7.22,6.70,6.10,5.51,5.10,4.74,4.45,4.23,4.11,4.07,4.08,4.10,4.10,4.11,4.11,4.11,4.11,4.10,4.11,4.12,4.14,4.25,4.38,4.62,4.87,5.20,5.62,6.22,6.87,7.57,8.14,8.73,9.27,9.88,10.50,11.12,11.65,12.25,12.87,13.37,13.61,13.50,13.32,13.11,12.97,12.83,12.37,11.84,11.25,10.73,10.25,9.99,9.90,10.36,11.01,11.87,12.75,13.71,14.75,15.97,16.97,17.62,17.77,17.87,17.95,18.25,18.72,19.12,19.35,19.37,19.12,18.62,17.87,17.08,16.20,15.37,14.62,14.12,13.87,13.89,14.23,14.74,15.37,16.01,16.65,17.24,17.63,17.75,17.59,17.23,16.75,16.21,15.62,15,14.40,13.85,13.34,12.95,12.70,12.57,12.60,12.73,13.25,14,14.86,15.77,16.77,17.63,18.24,18.23,17.59,16.50,15.37,14.27,13.38,12.75,12.34,12.22,12.38,12.97,13.84,14.98,16.24,17.47,18.50,19.36,19.86,20,19.87,19.57,19.08,18.38,17.60,16.76,16.12,15.98,16.25,17,17.95,19,20,20.75,20.97,20.75,20.37,20.07,20.09,20.39,20.76,20.96,20.75,20.26,19.62,18.84,18.10,17.39,16.75,16.11,15.39,14.83,14.50,14.72,15.50,16.62,17.87,18.98,19.86,20.50,20.75,20.75,20.39,20.21,19.87,19.39,18.75,17.87,17,16.11,16,14,13,12.01,11.90,11.12,10.75,9.26,8.23,7.39,6.83,6.37,5.99,5.62,5.34,5,4.62,4.22,3.75,3.35,3,2.75,2.59,2.49,2.40,2.37,2.35,2.25,2.14,2.07,1.90,1.76,1.62,1.50,1.38,1.34,1.27,1.27,1.34,1.37,1.46,1.50,1.60,1.70,1.84,2,2.20,2.37,2.52,2.70,2.83,2.96,3.09,3.20,3.25,3.36,3.37,3.38,3.37,3.37,3.37,3.37,3.12,3,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.10,1.21,1.35,1.50,1.70,1.82,1.87,1.90,1.97,2,2,2.08,2.12,2.25,2.37,2.60,2.83,3.08,3.33,3.51,3.75,4,4.25,4.62,5.12,5.73,6.38,7.12,7.77,8.33,8.63,8.85,8.96,9.11,9.38,9.88,10.61,11.50,12.51,13.62,14.72,15.59,16.12,16.22,15.52,14.47,13.40,13.01,12.74,12.46,12.11,11.74,11.27,10.86,10.37,9.95,9.48,9.12,8.89,8.65,8.23,7.63,6.98,6.32,5.72,5.23,4.83,4.50,4.33,4.22,4.15,4.15,4.21,4.22,4.23,4.23,4.23,4.23,4.24,4.25,4.33,4.39,4.58,4.75,5,5.33,5.75,6.37,7.12,7.90,8.70,9.38,10.11,10.77,11.50,12.11,12.65,13.24,13.75,14.12,14.25,14.12,13.83,13.49,13.37,13.13,12.76,12.25,11.74,11.14,10.62,10.24,10.02,10.37,10.90,11.61,12.32,13.09,14.01,15.15,16.15,16.84,16.88,17,17.15,17.26,18,18.61,19.01,19.22,19.07,18.62,18,17.25,16.50,15.74,15.09,14.60,14.35,14.36,14.62,15.07,15.62,16.25,16.83,17.33,17.70,17.90,17.85,17.40,16.87,16.26,15.63,15,14.34,13.65,13.11,12.74,12.52,12.60,12.84,13.20,13.87,14.72,15.62,16.59,17.57,18.25,18.48,18.09,17.12,15.97,14.75,13.71,12.89,12.46,12.25,12.32,12.62,13.23,14.12,15.24,16.47,17.70,18.75,19.51,19.96,20,19.82,19.39,18.87,18.20,17.45,16.64,16.20,16.20,16.64,17.49,18.50,19.61,20.58,21.21,21.34,21.01,20.73,20.47,20.51,20.87,21.24,21.39,21.25,20.73,19.99,19.22,18.46,17.75,17.12,16.40,15.73,15.07,14.73,14.99,15.86,17.11,18.52,19.74,20.50,20.75,20.62,20.32,19.99,19.75,19.62,19.39,18.99,18.11,17.11,16,15.99,14.01,13.07,12.88,11.87,11.13,10.75,9.27,8.25,7.46,6.75,6.14,5.65,5.32,5.01,4.82,4.59,4.32,3.99,3.62,3.34,3.01,2.82,2.62,2.50,2.37,2.32,2.23,2.12,2.01,1.90,1.82,1.70,1.58,1.50,1.45,1.39,1.45,1.49,1.52,1.62,1.65,1.75,1.86,2,2.21,2.47,2.73,2.96,3.12,3.25,3.37,3.49,3.59,3.64,3.73,3.75,3.75,3.75,3.74,3.71,3.65,3.77,3,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.02,1.12,1.25,1.38,1.58,1.74,1.86,1.90,1.97,2,2,2.08,2.12,2.25,2.37,2.59,2.83,3.10,3.37,3.65,3.98,4.25,4.50,4.87,5.32,5.86,6.50,7.24,8,8.73,9.25,9.62,9.75,9.82,9.87,10.07,10.39,10.97,11.70,12.60,13.58,14.51,15.46,16.12,16.37,16.10,15.25,14.39,14.10,13.88,13.65,13.34,12.88,12.38,11.87,11.37,10.88,10.49,10.14,9.96,9.62,9.20,8.60,7.88,7.14,6.38,5.76,5.27,4.95,4.71,4.51,4.46,4.38,4.40,4.47,4.48,4.48,4.49,4.50,4.50,4.50,4.57,4.62,4.75,4.87,5.10,5.37,5.83,6.47,7.26,8.24,9.13,10.01,10.87,11.63,12.38,13.01,13.62,14.09,14.50,14.75,14.82,14.64,14.37,14.13,14,13.74,13.32,12.75,12.15,11.61,10.90,10.37,10.02,10.37,10.83,11.33,11.82,12.37,13.12,14.15,15.08,15.71,15.89,16.12,16.37,16.77,17.37,18.12,18.71,19.08,18.96,18.62,18.12,17.50,16.82,16.12,15.51,15.09,14.85,14.83,15,15.38,15.87,16.37,16.87,17.32,17.62,17.83,17.85,17.50,16.96,16.33,15.71,15,14.35,13.63,13.10,12.75,12.70,12.87,13.25,13.76,14.52,15.40,16.37,17.32,18.15,18.51,18.35,17.61,16.58,15.37,14.20,13.25,12.62,12.35,12.33,12.50,12.87,13.50,14.33,15.37,16.57,17.75,18.82,19.60,19.96,19.96,19.72,19.26,18.72,18.01,17.26,16.62,16.25,16.37,16.99,17.87,18.90,20.01,20.98,21.51,21.60,21.35,21.09,20.90,21.09,21.45,21.83,22,21.75,21.20,20.40,19.62,18.87,18.15,17.52,16.83,15.99,15.25,14.87,15.22,16.08,17.39,18.96,20.20,20.75,20.62,20.21,19.75,19.34,19.10,18.99,18.87,18.63,18.75,17.07,16,15.01,14.07,13.10,12.87,11.86,10.95,9.99,9.10,8.22,7.51,6.62,5.95,5.40,5.08,4.87,4.83,4.72,4.52,4.34,4.02,3.73,3.37,3.09,2.82,2.59,2.38,2.25,2.15,2.11,2,1.90,1.84,1.75,1.63,1.61,1.59,1.60,1.62,1.64,1.73,1.76,1.86,1.88,2,2.13,2.40,2.75,3.12,3.47,3.70,3.83,3.88,3.98,4.01,4.11,4.12,4.15,4.15,4.14,4.11,4.01,3.97,3.87,4,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.09,1.15,1.27,1.47,1.62,1.75,1.87,1.95,2,2.01,2.10,2.13,2.25,2.39,2.62,2.85,3.12,3.39,3.75,4.12,4.48,4.85,5.15,5.51,5.99,6.52,7.24,8,8.83,9.59,10.21,10.51,10.64,10.64,10.65,10.76,11.07,11.49,12.02,12.75,13.59,14.47,15.27,16.01,16.46,16.51,16,15.50,15.25,15.20,15,14.65,14.23,13.62,13.01,12.45,11.89,11.50,11.13,10.95,10.61,10.12,9.50,8.82,8,7.23,6.50,5.85,5.39,5.12,4.97,4.87,4.82,4.83,4.84,4.87,4.87,4.88,4.88,4.89,4.89,4.90,4.96,4.99,5.01,5.14,5.38,5.84,6.49,7.37,8.48,9.62,10.60,11.60,12.50,13.24,13.87,14.38,14.82,15.12,15.27,15.36,15.26,15.12,14.99,14.83,14.50,13.98,13.34,12.61,11.85,11.12,10.61,10.37,10.52,10.83,11.11,11.37,11.82,12.48,13.35,14.08,14.60,14.99,15.26,15.59,16.12,16.85,17.63,18.40,18.75,18.86,18.63,18.25,17.75,17.13,16.52,16,15.60,15.36,15.33,15.48,15.75,16.12,16.51,16.88,17.23,17.47,17.58,17.52,17.33,16.86,16.33,15.73,15.10,14.40,13.75,13.25,13,13,13.33,13.75,14.48,15.26,16.15,17.12,18.12,18.75,18.71,18.11,17.14,16.01,14.86,13.76,12.99,12.58,12.47,12.58,12.86,13.25,13.76,14.50,15.47,16.57,17.72,18.75,19.51,19.87,19.87,19.62,19.24,18.64,18,17.25,16.63,16.37,16.60,17.21,18.11,19.15,20.27,21.23,21.75,21.77,21.62,21.49,21.47,21.70,22,22.37,22.48,22.15,21.52,20.76,20,19.25,18.58,17.97,17.12,16.20,15.37,15.07,15.38,16.26,17.60,19.14,20.34,20.75,20.32,19.75,19.21,18.64,18.23,18,18,18,17.87,16.99,15.96,14.89,13.87,12.87,12.86,11.82,10.22,9.75,8.70,7.87,7.52,6.38,5.52,5.32,5.02,5.01,5,5,4.90,4.75,4.50,4.15,3.77,3.37,3,2.72,2.47,2.25,2.13,2.08,2,1.95,1.87,1.83,1.75,1.75,1.75,1.82,1.85,1.88,1.95,2,2.01,2.10,2.13,2.36,2.65,3.10,3.51,3.90,4.20,4.34,4.38,4.46,4.50,4.51,4.58,4.59,4.59,4.52,4.49,4.32,4.12,4,4,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.07,1.12,1.24,1.37,1.50,1.65,1.82,1.88,1.99,2.02,2.12,2.20,2.32,2.47,2.64,2.88,3.20,3.50,3.87,4.25,4.62,5.12,5.59,5.96,6.33,6.74,7.25,7.95,8.72,9.50,10.32,10.99,11.36,11.48,11.49,11.49,11.58,11.76,12.12,12.60,13.12,13.75,14.48,15.25,15.98,16.52,16.89,16.72,16.52,16.50,16.58,16.46,16.12,15.62,14.96,14.23,13.52,12.96,12.47,12.02,11.75,11.37,10.87,10.27,9.62,8.84,7.98,7.12,6.48,6,5.71,5.51,5.47,5.39,5.40,5.40,5.46,5.48,5.50,5.50,5.50,5.48,5.40,5.37,5.25,5.23,5.25,5.45,5.82,6.46,7.45,8.61,9.87,11.07,12.12,13.12,13.86,14.48,15,15.40,15.75,15.96,16.07,16.08,15.99,15.85,15.61,15.25,14.72,13.90,12.95,12.02,11.25,10.83,10.72,10.83,10.90,11.02,11.12,11.48,12,12.70,13.25,13.75,14.13,14.52,15,15.36,16.38,17.26,18.01,18.52,18.75,18.72,18.45,18,17.50,16.96,16.46,16.09,15.87,15.83,15.90,16.12,16.37,16.63,16.87,17.09,17.23,17.25,17.23,17,16.70,16.25,15.74,15.15,14.58,14,13.57,13.37,13.50,13.87,14.46,15.22,16.01,16.90,17.83,18.75,19.33,18.75,17.83,16.75,15.62,14.50,13.60,12.99,12.75,12.76,13,13.35,13.73,14.20,14.77,15.60,16.57,17.62,18.62,19.37,19.75,19.85,19.64,19.26,18.75,18.12,17.39,16.85,16.59,16.75,17.37,18.24,19.26,20.37,21.33,21.85,21.98,21.90,21.90,22.01,22.25,22.57,22.83,22.77,22.38,21.75,21,20.25,19.50,18.90,18.21,17.27,16.32,15.51,15.26,15.65,16.60,17.87,19.34,20.37,20.62,20.10,19.32,18.62,17.87,17.33,17,17,16.87,17,15.96,14.90,13.87,12.87,11.86,10.98,10.12,9.25,8.72,7.87,7.27,6.62,6.07,5.50,5.33,5.33,5.37,5.40,5.47,5.39,5.25,5,4.62,4.22,3.74,3.25,2.87,2.51,2.32,2.13,2.02,2,1.99,1.97,1.95,1.95,1.97,2,2.09,2.12,2.21,2.24,2.25,2.25,2.34,2.38,2.62,2.97,3.39,3.87,4.26,4.57,4.71,4.75,4.83,4.87,4.89,4.96,4.95,4.89,4.86,4.75,4.61,4.35,4.11,4,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.10,1.20,1.32,1.46,1.61,1.75,1.87,1.97,2.01,2.12,2.20,2.32,2.48,2.70,2.97,3.25,3.61,4,4.46,4.95,5.39,5.96,6.46,6.86,7.22,7.59,8.07,8.64,9.37,10.12,10.87,11.50,11.96,12.13,12.23,12.25,12.37,12.59,12.87,13.25,13.62,14.09,14.62,15.25,15.95,16.62,17.12,17.25,17.39,17.62,17.71,17.59,17.27,16.84,16.12,15.35,14.60,13.95,13.35,12.86,12.37,11.89,11.39,10.87,10.25,9.50,8.60,7.72,6.98,6.50,6.25,6.15,6.20,6.23,6.25,6.25,6.26,6.27,6.27,6.27,6.26,6.21,6.07,5.87,5.64,5.48,5.37,5.40,5.75,6.39,7.39,8.59,9.90,11.22,12.38,13.49,14.20,14.82,15.37,15.86,16.27,16.63,16.85,16.86,16.95,16.72,16.25,15.83,15.13,14.25,13.09,12.13,11.61,11.37,11.34,11.35,11.36,11.36,11.37,11.60,11.88,12.36,12.77,13.23,13.61,14,14.50,15.26,16.12,17,17.83,18.37,18.72,18.75,18.59,18.24,17.75,17.26,16.85,16.50,16.34,16.27,16.37,16.50,16.62,16.75,16.85,16.88,16.95,16.95,16.87,16.75,16.50,16.14,15.75,15.26,14.75,14.27,13.90,13.86,14.02,14.46,15.12,15.87,16.75,17.62,18.57,19.10,19.33,18.48,17.50,16.40,15.33,14.33,13.58,13.12,13.07,13.25,13.60,13.98,14.35,14.74,15.22,15.85,16.62,17.59,18.50,19.24,19.70,19.86,19.75,19.46,18.97,18.37,17.70,17.12,16.86,16.99,17.39,18.26,19.25,20.34,21.25,21.82,22.07,22.20,22.36,22.58,22.84,23.08,23.15,23,22.52,21.87,21.10,20.35,19.62,19,18.23,17.32,16.37,15.73,15.62,16.11,17.07,18.33,19.59,20.49,20.49,19.75,18.75,17.87,17,16.33,15.87,15.87,16,14.99,14.07,13.10,12,11.11,10.13,9.15,8.85,8.25,7.27,7.10,6.37,6.15,5.48,5.50,5.52,5.73,5.86,5.96,6,5.97,5.82,5.51,5.12,4.62,4.09,3.52,3.07,2.62,2.34,2.14,2.11,2.08,2.08,2.08,2.11,2.13,2.24,2.33,2.40,2.50,2.57,2.60,2.59,2.60,2.62,2.73,2.97,3.32,3.72,4.13,4.50,4.75,4.90,5,5.12,5.20,5.25,5.26,5.25,5.24,5.12,5.01,4.87,4.64,4.33,4,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.08,1.12,1.25,1.37,1.51,1.70,1.83,1.95,2.02,2.12,2.25,2.37,2.51,2.75,3.01,3.37,3.75,4.14,4.64,5.21,5.75,6.33,6.87,7.37,7.83,8.15,8.52,8.98,9.48,10.07,10.71,11.37,11.98,12.45,12.75,12.88,13,13.12,13.37,13.63,13.98,14.25,14.57,14.87,15.37,15.96,16.62,17.12,17.52,17.85,18.12,18.10,17.98,17.73,17.35,16.75,16.07,15.37,14.75,14.10,13.48,12.83,12.22,11.64,11.15,10.61,9.86,8.96,8.02,7.36,6.90,6.77,6.87,7.02,7.22,7.34,7.37,7.37,7.37,7.37,7.35,7.24,7.02,6.77,6.49,6.12,5.77,5.57,5.50,5.75,6.40,7.27,8.46,9.71,11,12.25,13.32,14.10,14.77,15.45,16.09,16.73,17.25,17.46,17.37,17.37,16.95,16.37,15.72,14.95,14.02,13.02,12.25,11.90,11.90,12.02,12.01,11.89,11.82,11.71,11.82,11.88,12.12,12.48,12.87,13.25,13.61,14.37,15.14,16.02,16.90,17.72,18.33,18.70,18.77,18.65,18.37,17.98,17.51,17.12,16.87,16.73,16.70,16.74,16.77,16.84,16.82,16.75,16.71,16.62,16.61,16.57,16.48,16.34,16.11,15.77,15.45,15,14.62,14.36,14.36,14.62,15.08,15.75,16.51,17.37,18.22,18.89,19.12,18.99,18.12,17.15,16.12,15.10,14.22,13.61,13.35,13.40,13.75,14.23,14.70,15.08,15.39,15.75,16.25,16.88,17.70,18.50,19.20,19.64,19.88,19.89,19.70,19.25,18.65,18.01,17.50,17.21,17.14,17.52,18.27,19.20,20.12,21,21.63,22.09,22.37,22.72,23.07,23.37,23.59,23.51,23.23,22.64,21.89,21.12,20.35,19.62,18.89,18.12,17.25,16.50,16.07,16.12,16.75,17.74,18.87,19.89,20.50,20.37,19.22,18.11,17.11,16.11,15.20,14.90,14,13.98,13.01,12.88,11.12,10.12,9.13,8.89,8.21,7.95,7.27,7,6.37,6.32,6.08,5.87,5.50,5.99,6.25,6.45,6.57,6.61,6.52,6.37,6.08,5.61,5.01,4.45,3.85,3.25,2.75,2.47,2.26,2.22,2.20,2.21,2.24,2.32,2.38,2.51,2.70,2.83,2.95,2.99,3,2.98,2.98,3,3.10,3.32,3.62,3.98,4.37,4.71,4.90,5.10,5.23,5.35,5.46,5.51,5.59,5.59,5.50,5.40,5.35,5.25,5.09,4.75,4,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.02,1.12,1.22,1.34,1.49,1.62,1.75,1.89,2.01,2.13,2.25,2.39,2.60,2.83,3.11,3.45,3.85,4.32,4.83,5.37,6,6.62,7.25,7.86,8.37,8.84,9.23,9.60,9.98,10.37,10.82,11.26,11.84,12.37,12.88,13.26,13.51,13.72,13.87,14.12,14.38,14.65,14.87,15.08,15.25,15.51,15.90,16.38,16.87,17.34,17.63,17.75,17.62,17.47,17.32,17.02,16.64,16.23,15.76,15.27,14.75,13.89,13.10,12.34,11.65,11.12,10.51,9.84,8.99,8.24,7.61,7.26,7.26,7.50,7.87,8.25,8.50,8.62,8.62,8.62,8.60,8.50,8.33,8.01,7.62,7.12,6.62,6.14,5.75,5.50,5.62,6.32,7.14,8.20,9.34,10.50,11.75,12.76,13.71,14.50,15.26,16.10,16.87,17.49,17.62,17.37,17.07,16.50,15.83,15.02,14.25,13.60,12.90,12.61,12.61,12.75,12.95,12.84,12.62,12.46,12.37,12.36,12.36,12.36,12.60,12.87,13.25,13.52,14.36,15.12,16.02,16.90,17.72,18.32,18.65,18.82,18.72,18.45,18.08,17.70,17.36,17.12,17,16.99,17,16.99,16.89,16.76,16.62,16.47,16.35,16.26,16.25,16.25,16.21,16.10,15.87,15.62,15.27,14.99,14.82,14.87,15.12,15.64,16.32,17,17.75,18.50,18.89,18.88,18.50,17.75,16.84,15.85,14.87,14.11,13.62,13.50,13.75,14.25,14.85,15.38,15.86,16.20,16.48,16.85,17.35,17.98,18.62,19.25,19.71,20,20.08,19.88,19.50,19,18.39,17.89,17.59,17.47,17.74,18.27,19.08,19.88,20.72,21.45,22,22.50,22.98,23.46,23.85,24,23.86,23.38,22.75,21.95,21.11,20.22,19.58,18.86,18.11,17.36,16.77,16.62,16.90,17.63,18.61,19.60,20.26,20.38,19.65,18.37,17.26,16.76,15.11,14,13,13,12,11.07,10.10,9.87,9.01,8.15,8.12,7.75,7.25,7.21,6.89,6.37,6.40,6.47,6.37,6.46,6.62,6.88,7.12,7.25,7.26,7.21,6.99,6.62,6.11,5.48,4.82,4.13,3.57,3.08,2.73,2.50,2.37,2.37,2.37,2.45,2.52,2.70,2.87,3.07,3.24,3.37,3.45,3.38,3.37,3.35,3.36,3.45,3.62,3.87,4.23,4.57,4.86,5.09,5.25,5.40,5.58,5.70,5.75,5.83,5.86,5.86,5.83,5.73,5.72,5.59,5.34,5,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.10,1.15,1.26,1.40,1.59,1.74,1.87,2,2.13,2.27,2.47,2.63,2.87,3.13,3.50,3.87,4.37,4.88,5.50,6.14,6.85,7.52,8.21,8.82,9.36,9.85,10.25,10.64,11,11.35,11.62,11.95,12.36,12.87,13.37,13.83,14.12,14.37,14.58,14.82,15.08,15.35,15.50,15.58,15.62,15.75,15.89,16.21,16.50,16.75,16.89,16.86,16.64,16.46,16.27,16.15,16.02,15.89,15.75,15.62,15.10,14.12,13.14,12.25,11.50,10.86,10.24,9.59,8.89,8.26,7.83,7.62,7.75,8.12,8.62,9.20,9.64,9.86,9.88,9.87,9.84,9.70,9.39,8.99,8.40,7.82,7.15,6.57,6,5.57,5.57,6.15,6.95,7.85,8.86,9.96,11.08,12.13,13.20,14.12,15,15.88,16.74,17.25,17.32,16.87,16.12,15.48,14.89,14.25,13.61,13.13,13.02,13.02,13.36,13.61,13.84,13.62,13.33,13.12,13.01,13,13,13,13.13,13.35,13.57,14.12,14.27,15.27,16.12,17.01,17.75,18.35,18.70,18.77,18.71,18.46,18.11,17.75,17.47,17.25,17.13,17.12,17.10,17,16.87,16.62,16.37,16.15,16.01,15.99,16,16.09,16.12,16.12,16,15.86,15.62,15.37,15.26,15.37,15.74,16.23,16.77,17.40,18.08,18.62,18.85,18.72,18.13,17.39,16.50,15.57,14.64,13.96,13.52,13.62,14,14.64,15.37,16.09,16.62,16.99,17.25,17.50,17.87,18.37,18.87,19.37,19.75,20.02,20.12,20,19.73,19.26,18.82,18.37,18,17.87,18,18.37,18.96,19.71,20.49,21.22,21.87,22.48,23.01,23.60,24,24.11,23.87,23.35,22.62,21.84,21.08,20.27,19.52,18.87,18.25,17.64,17.37,17.48,17.97,18.71,19.49,20.12,20.58,20.39,19.23,17.87,16.88,16,14,13,12,11,10.96,10,9.12,8.12,8.14,8.12,7.87,7.24,7.26,7.33,7.34,7.23,7.12,7.12,7.14,7.25,7.39,7.62,7.83,7.90,7.89,7.77,7.50,7.11,6.50,5.87,5.21,4.51,3.95,3.45,3.07,2.82,2.63,2.60,2.61,2.64,2.77,2.98,3.15,3.38,3.62,3.82,3.85,3.75,3.74,3.63,3.62,3.73,3.87,4.12,4.46,4.75,5.08,5.32,5.50,5.70,5.86,5.98,6,6.08,6.12,6.23,6.26,6.33,6.27,6.24,6.12,6,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.01,1.09,1.13,1.25,1.37,1.50,1.70,1.85,2,2.12,2.27,2.49,2.70,2.90,3.21,3.51,3.90,4.37,4.95,5.51,6.23,6.95,7.65,8.37,9.07,9.65,10.25,10.76,11.25,11.64,12.02,12.26,12.45,12.62,12.88,13.36,13.86,14.33,14.70,14.96,15.14,15.37,15.62,15.87,16,16,16,15.98,15.98,16,16.02,16.01,15.95,15.75,15.51,15.34,15.21,15.14,15.22,15.33,15.39,15.52,15.10,14.12,13.09,12.07,11.23,10.51,9.95,9.37,8.86,8.37,8.10,8.01,8.25,8.72,9.35,10,10.62,10.98,11.11,11.11,11,10.77,10.40,9.87,9.21,8.47,7.72,6.97,6.25,5.59,5.60,6.01,6.65,7.46,8.35,9.36,10.47,11.59,12.65,13.74,14.72,15.57,16.33,16.75,16.75,16.25,15.37,14.71,14.25,13.89,13.60,13.37,13.60,13.82,14.15,14.39,14.50,14.24,13.89,13.82,13.86,13.97,13.98,14,14.02,14.22,14.46,14.86,15.21,15.36,16.47,17.25,17.95,18.45,18.74,18.83,18.72,18.46,18.12,17.75,17.48,17.26,17.15,17.12,17.01,16.87,16.64,16.37,16.10,15.86,15.72,15.71,15.77,15.97,16.11,16.20,16.15,16.11,15.96,15.77,15.73,15.88,16.25,16.74,17.25,17.83,18.35,18.75,18.87,18.62,18,17.13,16.25,15.27,14.46,13.75,13.48,13.62,14.21,14.99,15.86,16.70,17.35,17.75,18,18.23,18.50,18.85,19.23,19.59,19.86,20.01,20.12,20.07,19.87,19.57,19.22,18.86,18.57,18.37,18.37,18.58,18.99,19.60,20.34,21,21.71,22.32,22.87,23.37,23.75,23.83,23.51,22.95,22.24,21.59,21,20.37,19.73,19.09,18.50,18.15,18.07,18.36,18.96,19.97,20.27,20.52,20.63,20.64,19,17,16,15,13,12,12,10,9.90,9.10,8.12,8.12,8,8,7.87,7.87,7.89,8.07,8.10,8.09,8.02,8.01,8.07,8.12,8.24,8.37,8.50,8.60,8.51,8.37,8.02,7.57,6.95,6.25,5.60,4.90,4.34,3.83,3.40,3.12,2.97,2.87,2.87,2.89,3.02,3.24,3.46,3.65,3.90,4.10,4.12,4.09,3.97,3.87,3.87,3.96,4.12,4.37,4.72,5.02,5.37,5.62,5.86,6.01,6.20,6.27,6.37,6.40,6.57,6.73,6.87,6.97,6.99,6.99,6.99,7,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.02,1.10,1.13,1.25,1.37,1.50,1.62,1.82,1.98,2.12,2.27,2.49,2.71,2.96,3.24,3.58,3.96,4.37,4.89,5.50,6.22,6.95,7.65,8.47,9.13,9.83,10.46,11.07,11.62,12.12,12.52,12.87,13.11,13.13,13.25,13.47,13.85,14.33,14.76,15.15,15.47,15.63,15.87,16.08,16.24,16.35,16.35,16.25,16.20,16.01,15.86,15.62,15.33,15,14.64,14.37,14.14,14.10,14.13,14.35,14.62,15,15.20,14.87,13.99,12.89,11.86,10.96,10.27,9.76,9.36,8.99,8.73,8.58,8.60,8.84,9.33,9.97,10.70,11.36,11.96,12.23,12.27,12.14,11.87,11.37,10.71,9.90,9.10,8.25,7.37,6.58,5.85,5.74,5.96,6.40,7.07,7.84,8.84,9.89,11,12.12,13.25,14.25,15.08,15.74,16.12,16.23,15.87,15.12,14.60,14.37,14.25,14.12,14.01,14.37,14.77,15.14,15.25,15.14,14.84,14.52,14.47,14.62,14.85,14.98,14.98,15.01,15.25,15.63,15.87,16.02,16.34,16.98,17.62,18.15,18.59,18.82,18.87,18.75,18.47,18.11,17.74,17.40,17.22,17.09,16.98,16.85,16.62,16.35,16,15.71,15.48,15.37,15.39,15.61,15.86,16.11,16.26,16.37,16.37,16.26,16.14,16.23,16.40,16.75,17.20,17.73,18.14,18.60,18.89,19,18.60,17.87,17,16.08,15.10,14.15,13.59,13.37,13.62,14.32,15.21,16.20,17.20,18,18.49,18.73,18.88,19.10,19.33,19.57,19.76,19.95,20.01,20.07,20.01,19.97,19.82,19.62,19.37,19.15,19,18.90,18.98,19.22,19.64,20.25,20.87,21.47,22,22.47,22.87,23.14,23.20,22.87,22.32,21.52,21.02,20.63,20.33,19.87,19.46,19.13,19,19.02,19.21,19.50,19.85,19.98,20,20,19.63,18,16,15,14,12,11,11,9.97,9,8.11,8.12,8.01,8.01,8.12,8.24,8.25,8.87,9.02,9.11,9.09,9.02,9,9,9,9.10,9.15,9.25,9.25,9.12,8.90,8.50,7.99,7.33,6.62,5.97,5.27,4.71,4.20,3.75,3.47,3.25,3.12,3.12,3.14,3.26,3.46,3.63,3.87,4.09,4.25,4.32,4.20,4.08,4,4,4.12,4.35,4.62,5,5.37,5.74,6,6.25,6.46,6.62,6.75,6.86,6.96,7.12,7.33,7.50,7.62,7.64,7.75,7.87,8,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.02,1.11,1.15,1.25,1.37,1.49,1.62,1.75,1.95,2.12,2.26,2.48,2.71,2.96,3.25,3.58,3.96,4.37,4.87,5.46,6.12,6.85,7.61,8.37,9.12,9.76,10.38,11,11.62,12.22,12.72,13.12,13.40,13.62,13.65,13.75,13.96,14.26,14.73,15.14,15.51,15.83,16,16.20,16.34,16.38,16.46,16.46,16.48,16.34,16.09,15.73,15.25,14.64,14.08,13.61,13.25,13.10,13.02,13.20,13.49,13.87,14.39,14.75,14.59,13.84,12.82,11.74,10.87,10.32,9.90,9.64,9.47,9.35,9.26,9.34,9.51,9.96,10.58,11.33,12.09,12.83,13.25,13.39,13.27,12.87,12.25,11.40,10.58,9.65,8.75,7.85,6.98,6.20,5.95,5.98,6.25,6.75,7.49,8.38,9.46,10.50,11.61,12.63,13.62,14.46,15.12,15.62,15.87,15.84,15.47,15.12,15,15.01,14.99,15.01,15.37,15.84,16.14,16.14,15.85,15.37,15,14.88,15.20,15.62,15.86,15.99,15.97,16.15,16.76,16.77,17.10,17.32,17.73,18.08,18.39,18.72,18.87,18.89,18.75,18.49,18.10,17.70,17.35,17.09,16.88,16.75,16.52,16.25,15.95,15.58,15.25,15,14.99,15.12,15.37,15.75,16.11,16.39,16.59,16.62,16.58,16.52,16.62,16.84,17.13,17.61,17.96,18.26,18.62,18.89,18.89,18.48,17.76,16.90,15.98,15,14.12,13.47,13.14,13.60,14.35,15.27,16.38,17.51,18.49,19.09,19.37,19.50,19.63,19.76,19.89,20,20.08,20.08,20.01,20,20.02,20.08,20.01,19.96,19.82,19.73,19.62,19.58,19.64,19.90,20.35,20.75,21.15,21.51,21.87,22.14,22.37,22.50,22.21,21.52,20.87,20.40,20.12,19.97,19.83,19.73,19.70,19.77,19.90,19.95,19.73,19.46,19.12,19,18.87,18.64,18,16,14,13,11,11,10,9.01,8.09,8.12,8.12,8.15,8.21,8.23,9.02,9.72,10.02,10.27,10.32,10.22,10.10,10,9.97,9.96,9.97,9.98,9.97,9.89,9.75,9.46,8.99,8.37,7.70,6.99,6.27,5.62,5.01,4.50,4.09,3.75,3.52,3.39,3.37,3.39,3.50,3.62,3.77,3.98,4.13,4.26,4.25,4.15,4.11,4.09,4.12,4.33,4.60,4.95,5.35,5.75,6.13,6.49,6.75,6.90,7.10,7.25,7.37,7.58,7.75,7.96,8.12,8.24,8.25,8.35,8.75,9,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.01,1.11,1.15,1.25,1.37,1.50,1.62,1.75,1.89,2.10,2.25,2.47,2.70,2.95,3.23,3.57,3.95,4.36,4.83,5.36,5.95,6.62,7.37,8.25,8.98,9.62,10.22,10.75,11.36,11.90,12.49,12.98,13.37,13.64,13.86,13.97,14.10,14.32,14.62,15.01,15.40,15.74,15.98,16.13,16.27,16.37,16.37,16.37,16.37,16.36,16.32,16.12,15.65,15,14.14,13.27,12.64,12.25,12.09,12.09,12.25,12.52,13.13,13.83,14.26,14.32,13.75,12.89,11.95,11.12,10.71,10.45,10.27,10.24,10.22,10.23,10.25,10.37,10.70,11.22,11.95,12.75,13.50,14.23,14.39,14.26,13.72,12.89,12,11.11,10.15,9.24,8.25,7.37,6.62,6.14,6.02,6.15,6.52,7.22,8.12,9.08,10.08,11.09,12.07,12.98,13.85,14.62,15.25,15.75,16.01,16.12,16,15.97,15.87,15.85,15.88,16.26,16.85,17.08,16.96,16.37,15.85,15.36,15.24,15.63,16.20,16.51,16.62,16.71,16.86,17.12,17.83,17.75,18.70,18.27,18.34,18.50,18.74,18.87,18.89,18.75,18.49,18.09,17.62,17.25,16.97,16.73,16.50,16.24,15.87,15.50,15.09,14.74,14.52,14.57,14.75,15.12,15.59,16.02,16.51,16.73,16.75,16.75,16.83,17,17.14,17.34,17.61,17.75,17.97,18.25,18.50,18.51,18.12,17.50,16.75,15.85,14.87,14,13.37,13.12,13.47,14.24,15.27,16.48,17.64,18.72,19.45,19.87,20.08,20.20,20.25,20.27,20.26,20.24,20.12,20.01,19.98,20,20.11,20.22,20.35,20.47,20.50,20.38,20.25,20.21,20.25,20.49,20.72,20.87,21,21.14,21.37,21.59,21.72,21.52,21.09,20.45,19.87,19.51,19.47,19.57,19.75,20,20.25,20.49,20.37,19.84,19.12,18.46,18.11,17.75,17.27,17,15,13,12,11,10,9,8.96,8.09,8.12,8.13,8.82,9.12,9.24,10.12,10.85,11.62,11.74,11.70,11.40,11.12,11,10.88,10.86,10.82,10.75,10.65,10.58,10.35,9.99,9.45,8.76,8.07,7.33,6.62,5.96,5.35,4.82,4.37,4.01,3.77,3.64,3.62,3.62,3.65,3.75,3.87,4,4.12,4.20,4.20,4.13,4.12,4.13,4.27,4.52,4.87,5.25,5.73,6.20,6.62,7,7.25,7.47,7.62,7.84,8,8.23,8.38,8.59,8.70,8.75,8.73,8.82,8.87,9,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.09,1.14,1.25,1.37,1.50,1.62,1.75,1.89,2.09,2.25,2.46,2.64,2.89,3.21,3.50,3.87,4.33,4.75,5.25,5.76,6.37,7,7.75,8.50,9.21,9.90,10.39,10.89,11.45,11.99,12.50,12.96,13.34,13.62,13.83,14,14.22,14.49,14.85,15.23,15.50,15.73,15.89,16.10,16.21,16.23,16.14,16.10,16.07,16.11,16.14,16.12,15.75,14.95,13.87,12.75,11.87,11.37,11.13,11.09,11.26,11.75,12.46,13.25,13.87,14.12,13.86,13.24,12.48,11.83,11.39,11.23,11.15,11.22,11.25,11.33,11.37,11.40,11.60,12,12.62,13.40,14.20,14.97,15.12,14.87,14.15,13.34,12.39,11.50,10.59,9.62,8.63,7.74,6.95,6.37,6.12,6.14,6.50,7.12,7.87,8.75,9.62,10.58,11.49,12.37,13.26,14.13,14.98,15.75,16.48,16.84,16.98,16.85,16.62,16.59,16.70,17.08,17.50,17.50,17.26,16.62,16.10,15.58,15.58,16,16.51,16.99,17.22,17.12,17.02,17.87,17.83,17.76,17.87,18.33,18.22,18.37,18.60,18.75,18.77,18.70,18.40,18.01,17.62,17.24,16.88,16.62,16.34,16,15.59,15.11,14.62,14.24,14.02,14.11,14.37,14.75,15.25,15.98,16.45,16.62,16.75,16.85,16.98,17.12,17.21,17.21,17.24,17.23,17.37,17.62,17.83,17.83,17.57,17.02,16.36,15.50,14.62,13.82,13.25,13.12,13.45,14.11,15.21,16.39,17.63,18.85,19.74,20.26,20.60,20.72,20.75,20.70,20.61,20.46,20.24,19.98,19.77,19.75,19.86,20.09,20.45,20.87,21.21,21.12,20.98,20.82,20.72,20.64,20.62,20.50,20.37,20.37,20.50,20.74,20.97,20.98,20.75,20.11,19.40,18.99,18.87,19.02,19.37,19.76,20.12,20.49,20.37,19.84,18.96,18.12,17.40,16.75,16.11,15,14,12,11,10,9,9,8.95,8.87,8.87,9.13,9.77,10.21,10.74,11.26,12.07,12.62,13.57,13.50,12.50,12.12,11.90,11.77,11.71,11.61,11.50,11.37,11.15,10.88,10.50,9.88,9.22,8.45,7.63,6.90,6.25,5.62,5.10,4.62,4.25,4,3.87,3.82,3.77,3.83,3.87,3.95,4,4.07,4.11,4.12,4.12,4.12,4.25,4.50,4.77,5.20,5.62,6.12,6.62,7.12,7.51,7.87,8.12,8.25,8.45,8.64,8.87,9.10,9.24,9.27,9.33,9.33,9.25,9,9,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.02,1.12,1.25,1.37,1.50,1.64,1.77,1.95,2.09,2.25,2.45,2.63,2.87,3.14,3.50,3.86,4.25,4.72,5.20,5.70,6.22,6.75,7.33,7.89,8.52,9.15,9.83,10.37,10.87,11.35,11.83,12.26,12.73,13.08,13.36,13.61,13.84,14.12,14.46,14.85,15.13,15.37,15.57,15.73,15.87,16,16,15.87,15.71,15.64,15.82,16,16.13,15.87,15,13.75,12.36,11.12,10.50,10.22,10.25,10.50,11.01,11.82,12.71,13.48,13.97,14,13.64,13.12,12.62,12.33,12.21,12.24,12.35,12.48,12.59,12.62,12.71,12.75,13,13.48,14.12,14.75,15.45,15.49,15.07,14.32,13.50,12.64,11.77,10.87,9.97,9,8.02,7.22,6.58,6.23,6.22,6.49,6.99,7.62,8.39,9.25,10.10,10.97,11.86,12.76,13.74,14.72,15.72,16.77,17.37,17.62,17.50,17.32,17.23,17.32,17.62,17.86,17.62,17.27,16.76,16.35,15.87,15.87,16.33,16.75,17.11,17.87,17.99,17.97,16.98,16.97,17,17.12,17.38,17.75,18.02,18.32,18.50,18.58,18.50,18.26,17.99,17.62,17.25,16.96,16.62,16.27,15.87,15.37,14.84,14.25,13.75,13.60,13.63,13.90,14.35,14.86,15.37,15.86,16.23,16.49,16.62,16.82,16.90,16.89,16.76,16.62,16.51,16.63,16.89,17.12,17.13,16.89,16.45,15.75,14.90,14.09,13.39,13.08,13.12,13.60,14.33,15.25,16.25,17.46,18.50,19.50,20.25,20.75,20.96,21.10,20.99,20.75,20.50,20.09,19.74,19.49,19.36,19.38,19.71,20.23,20.87,21.39,21.57,21.46,21.23,21,20.75,20.46,20.11,19.76,19.61,19.63,19.87,20.12,20.27,20.40,19.75,19.08,18.50,18.21,18.35,18.75,19.25,19.62,19.82,19.83,19.37,18.75,17.87,17,16,15,14,13,11,10,9,9,9,9.02,9.10,9.87,10.14,10.76,11.24,11.90,12.64,13.24,13.73,13.87,13.73,13.37,13,12.76,12.62,12.49,12.34,12.14,11.99,11.75,11.40,10.98,10.37,9.62,8.83,8,7.25,6.57,5.90,5.37,4.87,4.49,4.21,4,3.90,3.88,3.89,3.95,3.97,4,4,4.01,4.08,4.12,4.24,4.40,4.73,5.09,5.50,5.99,6.50,7.08,7.62,8.11,8.50,8.85,9.02,9.21,9.37,9.62,9.87,10,10.09,10.09,10.07,10.01,10,10,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.10,1.21,1.34,1.50,1.63,1.82,1.96,2.10,2.25,2.39,2.62,2.87,3.12,3.45,3.76,4.20,4.62,5.11,5.62,6.12,6.62,7.11,7.57,8.01,8.51,9.07,9.61,10.12,10.62,11.12,11.58,11.97,12.35,12.65,12.97,13.22,13.48,13.76,14.13,14.57,14.87,15.12,15.32,15.50,15.72,15.86,15.76,15.50,15.25,15.15,15.50,15.96,16.34,16.25,15.37,13.83,12.12,10.77,10.10,9.60,9.60,9.87,10.40,11.22,12.12,13,13.71,14.09,14,13.75,13.49,13.27,13.25,13.37,13.57,13.75,13.88,14,14.02,14.09,14.13,14.37,14.75,15.23,15.75,15.62,15,14.26,13.58,12.83,12,11.14,10.25,9.32,8.37,7.49,6.75,6.32,6.23,6.39,6.84,7.38,8.10,8.86,9.65,10.51,11.40,12.37,13.37,14.45,15.60,16.75,17.71,18.15,18.09,17.86,17.62,17.75,17.86,17.86,17.50,17.20,16.86,16.62,16.39,16.34,16.70,16.82,16.90,17,17,16,16.02,16,16.12,16.22,16.58,17.24,17.63,17.99,18.14,18.25,18.20,18.07,17.87,17.62,17.37,17.11,16.75,16.37,15.90,15.37,14.75,14.10,13.46,13.15,13.25,13.49,13.87,14.32,14.77,15.25,15.72,16,16.24,16.37,16.46,16.37,16.13,15.95,15.87,16,16.35,16.60,16.61,16.34,15.82,15.08,14.25,13.50,12.87,12.83,13.12,13.85,14.62,15.51,16.37,17.37,18.32,19.24,20,20.60,20.87,21.11,20.87,20.61,20.23,19.82,19.45,19.13,18.98,18.90,19.15,19.77,20.48,21.12,21.47,21.50,21.34,21,20.63,20.14,19.63,19.21,18.87,18.86,18.98,19.15,19.37,19.63,19.33,18.52,17.87,17.39,17.50,17.97,18.59,19.01,19.25,19.14,18.74,18.20,17.39,16.52,15.33,14.11,13,12,10,9,9,9,9,9.95,10.10,10.87,11.15,11.82,12.25,13.22,13.90,14.62,14.62,14.52,14.33,14,13.75,13.52,13.37,13.15,12.99,12.75,12.52,12.26,11.90,11.47,10.83,10.02,9.21,8.37,7.60,6.87,6.24,5.62,5.12,4.65,4.35,4.12,4,3.98,3.97,3.97,3.98,4,4,4,4.09,4.14,4.36,4.62,4.97,5.36,5.82,6.33,6.87,7.50,8.11,8.65,9.14,9.58,9.87,10.01,10.22,10.46,10.74,10.89,11,11,11,11,11,11,0.99,0.99,0.99,0.99,0.99,1,1,1.08,1.13,1.25,1.40,1.62,1.76,1.95,2.10,2.25,2.37,2.60,2.82,3.08,3.37,3.72,4.10,4.50,5,5.50,6.01,6.57,7.08,7.48,7.86,8.20,8.58,9,9.39,9.89,10.37,10.76,11.15,11.57,11.89,12.25,12.50,12.75,13,13.25,13.71,14.12,14.58,14.83,15.01,15.24,15.50,15.64,15.51,15.25,15.09,15.13,15.50,15.97,16.36,16.36,15.51,14,12.33,10.87,10,9.37,9.25,9.47,9.89,10.62,11.51,12.49,13.32,13.87,14.20,14.25,14.25,14.25,14.36,14.50,14.74,14.96,15.13,15.37,15.40,15.36,15.24,15.25,15.37,15.51,15.74,15.37,14.75,14.13,13.50,12.87,12.20,11.38,10.52,9.62,8.65,7.75,6.99,6.40,6.24,6.34,6.62,7.12,7.75,8.50,9.34,10.23,11.12,12.12,13.12,14.22,15.23,16.70,17.62,18.60,18.57,17.87,17.62,17.75,17.87,17.75,17.32,16.87,16.62,16.62,16.70,16.76,16.11,16,16,16,15,15,15.01,15.08,15.12,15.89,16.46,16.95,17.37,17.70,17.84,17.85,17.75,17.71,17.62,17.58,17.47,17.25,16.97,16.57,16.09,15.50,14.84,14.12,13.50,13,12.90,13.11,13.37,13.75,14.20,14.62,15.11,15.40,15.63,15.75,15.75,15.61,15.38,15.22,15.20,15.45,15.83,16.11,16.11,15.76,15.20,14.39,13.62,12.96,12.50,12.62,13.25,14.15,15.12,15.99,16.75,17.50,18.25,19,19.74,20.25,20.61,20.82,20.63,20.34,19.90,19.50,19.14,18.87,18.62,18.58,18.75,19.25,19.90,20.50,20.90,21.10,20.98,20.65,20.25,19.73,19.12,18.61,18.22,18.01,18.01,18.12,18.26,18.45,18.33,17.75,17.12,16.62,16.62,17,17.70,18.12,18.25,18.14,17.74,17.27,16.63,15.87,14.70,13.10,12,11,10,9,9,9,9,10.01,11.09,11.87,12.20,13,13.75,14.70,15.20,15.60,15.52,15.27,14.96,14.64,14.40,14.23,14,13.82,13.58,13.33,13.09,12.76,12.38,11.88,11.25,10.46,9.59,8.73,7.90,7.21,6.50,5.88,5.36,4.87,4.48,4.22,4.07,4,3.99,3.99,3.99,4,4,4.02,4.12,4.25,4.50,4.82,5.20,5.62,6.11,6.62,7.25,7.89,8.60,9.24,9.82,10.27,10.73,10.97,11.12,11.36,11.65,11.87,12,12,12,12,11.98,12,0.99,0.99,0.99,0.99,1,1,1.08,1.12,1.25,1.37,1.58,1.75,1.90,2.09,2.24,2.37,2.52,2.75,2.98,3.25,3.59,3.97,4.37,4.87,5.37,5.88,6.45,6.97,7.50,7.87,8.23,8.50,8.82,9.12,9.40,9.85,10.20,10.50,10.85,11.13,11.48,11.75,12.02,12.27,12.40,12.65,13.08,13.51,14.01,14.38,14.71,14.98,15.24,15.35,15.14,14.87,14.84,15.08,15.51,16,16.33,16.26,15.58,14.23,12.74,11.37,10.37,9.49,9.14,9.21,9.50,10.12,10.96,11.88,12.83,13.59,14.13,14.59,14.87,15.10,15.26,15.48,15.71,15.95,16.21,16.40,16.50,16.38,16.13,16,15.87,15.71,15.49,15,14.46,13.88,13.37,12.87,12.32,11.61,10.77,9.89,8.99,8.07,7.23,6.58,6.25,6.25,6.48,6.87,7.50,8.24,9.08,9.97,10.89,11.90,12.97,14,15.12,16.10,17.12,17.84,17.75,17.25,16.99,17.21,17.63,17.64,16.75,16.22,16,16,16,16,15,15,15,15,14,14,14,14.95,15.11,15.86,16.39,16.95,17.26,17.47,17.47,17.35,17.23,17.15,17.23,17.32,17.45,17.33,17.02,16.71,16.25,15.71,15.02,14.37,13.72,13.20,12.84,12.75,12.95,13.21,13.52,13.99,14.38,14.74,14.90,14.98,14.87,14.74,14.52,14.38,14.48,14.77,15.24,15.59,15.58,15.15,14.58,13.82,13.10,12.58,12.37,12.74,13.51,14.57,15.63,16.51,17.25,17.75,18.37,18.98,19.50,19.96,20.25,20.39,20.35,20.10,19.75,19.37,19.01,18.73,18.40,18.25,18.37,18.75,19.27,19.83,20.14,20.33,20.23,19.96,19.61,19.11,18.50,17.90,17.48,17.21,17.10,17.10,17.12,17.21,17.12,16.75,16.23,15.75,15.62,15.85,16.49,17.02,17.25,17.15,16.75,16.21,15.52,14.87,13.87,13,11,10,9,9,9,10,10,11.01,12.87,13.12,13.77,14.25,15.09,15.83,16.62,16.58,16.50,15.90,15.50,15.25,15,14.84,14.61,14.35,14.08,13.76,13.50,13.21,12.82,12.26,11.62,10.82,9.95,9.08,8.25,7.50,6.82,6.14,5.58,5.02,4.62,4.32,4.12,4.01,4,4,4,4,4.01,4.11,4.20,4.37,4.63,5,5.38,5.87,6.37,6.99,7.62,8.35,9.08,9.75,10.40,11,11.52,11.85,12.08,12.27,12.62,12.87,12.98,13,13,12.97,12.99,12,0.99,0.99,0.99,1,1.01,1.09,1.12,1.25,1.37,1.51,1.72,1.87,2.02,2.21,2.37,2.50,2.65,2.87,3.11,3.38,3.75,4.21,4.65,5.15,5.72,6.25,6.76,7.33,7.87,8.27,8.63,8.96,9.22,9.46,9.65,9.98,10.23,10.45,10.62,10.87,11.15,11.49,11.77,12.09,12.14,12.33,12.62,13.12,13.59,13.97,14.32,14.62,14.87,14.83,14.50,14.25,14.35,14.82,15.45,15.98,16.12,16,15.38,14.36,13.12,11.99,10.90,9.90,9.25,9.12,9.25,9.71,10.45,11.34,12.26,13.15,14,14.72,15.25,15.71,15.96,16.07,16.20,16.37,16.63,16.87,16.90,16.84,16.62,16.39,16.12,15.71,15.21,14.62,14.09,13.59,13.12,12.75,12.35,11.73,10.97,10.12,9.25,8.35,7.49,6.75,6.33,6.15,6.33,6.70,7.26,8,8.85,9.73,10.63,11.64,12.82,13.87,15.01,16.08,16.88,17.95,16.98,16,16,16,17,17,16,15,15,15,15,15,14,14,14,14,13,13,13.99,14,15.08,16.11,16.75,17.11,17.26,17.25,16.98,16.64,16.50,16.50,16.62,16.85,17,17.01,16.95,16.72,16.37,15.87,15.32,14.62,13.98,13.37,12.88,12.62,12.50,12.62,12.87,13.24,13.60,13.87,14.02,14.02,13.95,13.75,13.61,13.50,13.62,14,14.48,14.85,14.83,14.39,13.84,13.15,12.61,12.27,12.37,12.88,13.75,14.84,16,16.87,17.58,18,18.50,18.99,19.37,19.75,19.98,20.11,20.07,19.87,19.71,19.39,19.11,18.74,18.37,18.02,18.02,18.25,18.62,19,19.25,19.34,19.24,19,18.71,18.25,17.73,17.13,16.64,16.34,16.12,16.02,16,16.02,15.90,15.65,15.24,14.75,14.50,14.62,15.01,15.50,15.62,15.62,15.27,14.87,14.22,13.70,12.87,12,11,10,9,9,10,10,11,12.96,13.87,14.85,15.21,15.76,16.26,17,17.61,17.52,16.90,16.35,15.96,15.74,15.58,15.37,15.11,14.76,14.48,14.13,13.87,13.50,13.12,12.61,11.95,11.12,10.25,9.37,8.58,7.76,7.08,6.38,5.76,5.25,4.76,4.45,4.23,4.11,4.07,4.02,4.01,4.07,4.11,4.15,4.32,4.50,4.82,5.14,5.60,6.11,6.64,7.33,8,8.75,9.51,10.27,11,11.64,12.27,12.64,12.96,13.22,13.50,13.77,13.97,14,13.96,13.98,13,13,0.99,0.99,1,1.01,1.10,1.13,1.25,1.37,1.50,1.65,1.85,2,2.13,2.32,2.48,2.62,2.76,2.98,3.22,3.50,3.89,4.37,4.88,5.46,6,6.52,7.09,7.61,8.13,8.62,9.08,9.37,9.63,9.87,10.10,10.26,10.47,10.62,10.75,10.95,11.24,11.57,11.89,12.24,12.35,12.50,12.72,12.99,13.25,13.50,13.86,14.20,14.46,14.12,13.65,13.26,13.61,14.37,15.25,15.76,15.73,15.50,15,14.26,13.49,12.62,11.62,10.52,9.61,9.23,9.14,9.45,10.02,10.87,11.77,12.76,13.75,14.65,15.47,15.99,16.12,16.02,16,16.13,16.37,16.59,16.62,16.60,16.50,16.36,16,15.50,14.88,14.26,13.71,13.22,12.84,12.50,12.14,11.75,10.99,10.25,9.40,8.59,7.74,7,6.46,6.20,6.24,6.57,7.12,7.87,8.62,9.49,10.37,11.37,12.38,13.70,14.95,16.57,16.75,16.82,16.33,15.25,15.23,15.84,16.09,16,15,15,14,14,14,14,13,13,13,13,13,13,14,14.98,15.96,16.89,17.12,17.51,17.32,16.74,16.15,15.82,15.62,15.72,15.90,16.21,16.46,16.61,16.62,16.57,16.36,16.01,15.50,14.87,14.21,13.50,12.95,12.48,12.12,12.02,12.12,12.37,12.62,12.87,13,13,12.87,12.72,12.60,12.50,12.70,13.07,13.48,13.75,13.71,13.39,12.99,12.50,12.12,12,12.37,13.07,13.98,15,16.02,16.98,17.65,18.13,18.62,19,19.37,19.62,19.82,19.85,19.77,19.75,19.72,19.61,19.37,19,18.50,18.10,17.77,17.75,17.87,18.10,18.24,18.25,18.14,17.99,17.72,17.33,16.84,16.26,15.82,15.45,15.15,15.07,15,14.98,14.87,14.62,14.24,13.75,13.37,13.25,13.61,13.84,13.97,13.97,13.75,13.33,12.75,12.20,12,11,10,10,10,10,10,11,12,13.96,15.87,15.95,16.77,17.13,17.70,17.88,18.60,18.52,17.15,16.50,16.24,16.12,16.09,15.86,15.50,15.12,14.75,14.39,14.09,13.74,13.34,12.84,12.24,11.38,10.51,9.63,8.83,8,7.26,6.62,5.99,5.45,4.98,4.62,4.37,4.24,4.14,4.12,4.13,4.20,4.23,4.32,4.47,4.64,4.96,5.27,5.75,6.27,6.90,7.62,8.38,9.20,10,10.75,11.50,12.24,12.96,13.45,13.77,14.09,14.33,14.65,14.90,14.95,14.97,14,14,14,0.99,1,1,1.08,1.12,1.25,1.37,1.50,1.62,1.76,1.95,2.09,2.25,2.37,2.57,2.71,2.86,3.01,3.25,3.61,4,4.50,5.09,5.63,6.23,6.75,7.25,7.77,8.35,8.85,9.34,9.74,10,10.25,10.50,10.65,10.84,11,11.13,11.36,11.62,11.97,12.37,12.74,12.99,13.12,13.15,13.24,13.23,13.25,13.37,13.62,13.75,13.33,12.75,12.26,12.84,13.87,14.82,15.37,15.22,14.87,14.39,13.98,13.62,13.11,12.32,11.25,10.14,9.49,9.15,9.25,9.75,10.48,11.40,12.47,13.52,14.50,15.36,15.83,15.76,15.57,15.45,15.49,15.63,15.83,15.87,15.87,15.87,15.75,15.50,15.08,14.51,13.96,13.37,12.86,12.48,12.12,11.85,11.45,10.87,10.25,9.52,8.75,7.97,7.24,6.62,6.27,6.25,6.51,7.08,7.75,8.50,9.27,10.13,11.13,12.25,13.49,14.75,15.95,16.62,16.58,15.97,15.12,14.40,15,15.71,15.76,15,14,14,13,13,13,13,13,12,12,13,14,14,15,16,16.95,17.89,17.65,16.73,15.86,15.21,14.76,14.71,14.95,15.24,15.58,15.87,16.12,16.25,16.27,16.21,15.98,15.58,15,14.34,13.61,12.88,12.26,11.75,11.46,11.36,11.45,11.61,11.75,11.86,11.85,11.75,11.62,11.49,11.48,11.62,11.90,12.24,12.45,12.47,12.33,12.09,11.86,11.73,11.86,12.37,13.22,14.13,15.12,16.08,16.88,17.62,18.20,18.62,19,19.26,19.50,19.62,19.58,19.51,19.59,19.72,19.77,19.75,19.38,18.86,18.23,17.62,17.24,17.15,17.15,17.22,17.20,17.12,16.97,16.73,16.37,15.88,15.39,14.95,14.52,14.25,14.08,14,14,13.87,13.62,13.24,12.75,12.37,12.14,12.25,12.36,12.35,12.34,12.22,11.87,11.25,11,10,10,10,10,10,10,11,12,13,14,15.88,16.90,17.82,18.75,18.70,18.62,18.36,17.88,17.26,16.50,16.50,16.50,16.49,16.36,15.84,15.37,14.97,14.59,14.23,13.87,13.47,12.98,12.36,11.60,10.73,9.86,9,8.20,7.46,6.75,6.12,5.61,5.12,4.77,4.57,4.40,4.37,4.35,4.36,4.37,4.39,4.50,4.62,4.82,5.07,5.38,5.87,6.46,7.13,7.95,8.75,9.60,10.39,11.22,11.99,12.74,13.49,14.12,14.61,14.96,15.12,15.23,15.15,15.01,15,14.99,15,14,0.99,1,1,1.11,1.21,1.33,1.47,1.61,1.75,1.87,2,2.12,2.26,2.46,2.61,2.75,2.87,3.08,3.32,3.62,4.10,4.62,5.20,5.75,6.36,6.87,7.37,7.87,8.39,8.88,9.39,9.87,10.23,10.50,10.76,10.99,11.15,11.37,11.61,11.83,12.10,12.48,12.90,13.37,13.77,13.86,13.76,13.62,13.34,13.09,12.95,12.89,12.77,12.37,11.95,11.73,12.37,13.37,14.34,14.87,14.61,14.14,13.76,13.52,13.50,13.35,12.87,12.02,10.82,9.75,9.15,9.08,9.47,10.15,11.13,12.23,13.32,14.25,14.90,15.22,15,14.73,14.50,14.52,14.74,14.89,15,15,14.97,14.87,14.75,14.49,14.12,13.64,13.12,12.61,12.12,11.76,11.50,11.20,10.75,10.24,9.62,8.89,8.20,7.50,6.95,6.50,6.35,6.51,7.01,7.70,8.38,9.20,10.08,11.07,12.12,13.32,14.48,15.59,16.37,16.45,15.89,15.01,14.47,14.46,14.75,14.87,14.70,13.77,13.07,13,12,12,12,12,12,13,13,14,15,16,16,16.99,17.96,17.82,15.89,14.61,14.09,13.87,13.90,14.27,14.65,15.07,15.38,15.71,15.88,15.99,15.90,15.73,15.37,14.87,14.25,13.57,12.77,12.01,11.37,10.83,10.51,10.47,10.50,10.62,10.72,10.73,10.64,10.57,10.39,10.40,10.51,10.74,10.95,11.12,11.22,11.25,11.26,11.35,11.49,11.87,12.59,13.47,14.37,15.32,16.13,16.89,17.62,18.14,18.58,18.86,19.08,19.35,19.33,19.20,19.15,19.32,19.58,19.96,20.10,19.87,19.24,18.37,17.62,16.96,16.59,16.37,16.32,16.25,16.22,16.09,15.85,15.50,15.09,14.61,14.13,13.75,13.45,13.24,13.15,13.11,12.96,12.73,12.37,11.97,11.62,11.37,11.36,11.35,11.23,11.11,11,10.75,10.11,10,10,10,10,10,10,11,12,13,14,15,16.09,17.87,18.82,19.75,19.70,19,18.36,17.76,17.33,17,16.87,16.87,16.85,16.57,16.10,15.59,15.11,14.65,14.26,13.89,13.50,13,12.38,11.63,10.82,9.90,9.09,8.25,7.50,6.85,6.25,5.72,5.26,4.97,4.75,4.62,4.61,4.59,4.59,4.62,4.62,4.70,4.75,4.89,5.12,5.47,5.90,6.57,7.34,8.21,9.10,9.97,10.77,11.60,12.37,13.13,13.97,14.64,15.35,15.76,15.96,15.87,15.75,15.86,15.99,15,15,15,0.99,1,1.01,1.12,1.23,1.37,1.50,1.63,1.76,1.88,2,2.13,2.27,2.46,2.61,2.75,2.87,3.08,3.33,3.64,4.12,4.62,5.24,5.83,6.37,6.95,7.45,7.90,8.39,8.87,9.37,9.84,10.23,10.50,10.85,11.09,11.36,11.65,11.97,12.14,12.39,12.75,13.22,13.90,14.47,14.36,14.22,13.87,13.37,12.87,12.47,12.12,11.83,11.46,11.21,11.37,12.07,12.96,13.77,14.13,13.84,13.37,13.02,13,13.12,13.21,13.07,12.50,11.12,9.96,9.07,8.85,9.15,9.89,10.95,12,13,13.76,14.24,14.35,14.09,13.72,13.49,13.50,13.73,13.90,14,14.01,14,14,13.97,13.87,13.72,13.46,13.07,12.37,12,11.34,11.25,11.02,10.70,10.23,9.64,9.08,8.45,7.86,7.27,6.84,6.47,6.50,7,7.63,8.36,9.12,10,11,12.02,13.12,14.21,15.24,16.02,16.09,15.64,14.87,14.25,13.89,13.87,13.97,13.62,13,12.39,12.12,12,11.89,12.12,12.35,12.76,13.34,14.10,14.87,15.83,16.10,17,16.99,16.98,16.97,14.25,13.46,13.07,13.13,13.46,13.87,14.27,14.71,15.09,15.37,15.60,15.64,15.60,15.37,15.01,14.62,14.08,13.37,12.61,11.74,10.87,10.20,9.71,9.50,9.49,9.58,9.62,9.65,9.64,9.52,9.50,9.50,9.60,9.64,9.75,9.88,10.12,10.38,10.70,11.01,11.50,12.12,12.87,13.77,14.71,15.51,16.27,17,17.62,18.02,18.34,18.49,18.63,18.75,18.73,18.62,18.65,18.87,19.22,19.65,19.95,19.84,19.27,18.50,17.62,16.89,16.27,15.87,15.63,15.59,15.51,15.38,15.15,14.85,14.45,14,13.61,13.13,12.75,12.60,12.50,12.37,12.22,11.98,11.71,11.38,11.20,11.07,11,11,10.75,10.38,10.25,10.12,10,10,10,10,10,10,11,12,13,14,15,16,17.08,18.12,19.83,20.75,20.70,19.26,18.37,17.85,17.49,17.37,17.35,17.33,17.24,16.88,16.37,15.75,15.21,14.73,14.32,13.89,13.50,13,12.37,11.62,10.75,9.87,9.01,8.25,7.50,6.86,6.25,5.75,5.37,5.10,4.88,4.85,4.84,4.84,4.83,4.83,4.83,4.86,4.87,5,5.15,5.49,5.97,6.62,7.49,8.39,9.37,10.25,11.12,11.88,12.70,13.50,14.37,15.23,15.99,16.47,16.60,16.50,16.37,16.25,16.07,16,16,15,0.99,1,1.01,1.12,1.23,1.37,1.50,1.64,1.77,1.89,2,2.12,2.25,2.39,2.57,2.71,2.86,3.02,3.32,3.64,4.12,4.62,5.23,5.82,6.37,6.88,7.38,7.88,8.34,8.75,9.24,9.64,10.01,10.39,10.65,10.95,11.25,11.62,11.88,12.12,12.27,12.58,12.96,13.71,14.11,14,13.82,13.49,13,12.40,11.87,11.37,10.89,10.60,10.50,10.87,11.59,12.49,13.11,13.12,12.76,12.47,12.25,12.36,12.58,12.63,12.71,12.22,11.12,9.76,8.87,8.51,8.87,9.62,10.62,11.65,12.47,13.10,13.39,13.39,13.12,12.70,12.40,12.51,12.74,12.89,13,13,13.02,13.10,13.22,13.35,13.37,13.37,13.23,12.90,12.25,11.26,11.26,11.11,10.71,10.24,9.72,9.20,8.72,8.21,7.72,7.12,6.75,6.58,7.11,7.62,8.26,9.01,9.89,10.87,11.89,12.96,13.95,14.75,15.48,15.50,15.22,14.49,13.77,13.25,13.02,12.90,12.63,12.25,11.96,11.64,11.62,11.95,12.35,12.77,13.36,14.12,14.87,15.62,16.20,16.65,16.75,16.87,16,14.99,13.09,12.26,12.46,12.73,13.12,13.60,14.08,14.50,14.87,15.14,15.34,15.35,15.21,14.97,14.62,14.24,13.75,13.12,12.33,11.37,10.39,9.58,8.97,8.62,8.57,8.62,8.75,8.87,8.87,8.87,8.87,8.88,8.96,8.96,9,9.11,9.38,9.83,10.36,10.90,11.60,12.37,13.23,14.12,15,15.75,16.45,17,17.46,17.72,17.84,17.87,17.90,17.95,17.89,17.90,18,18.25,18.60,19,19.25,19.23,18.85,18.25,17.57,16.85,16.22,15.73,15.36,15.21,15.12,14.98,14.75,14.45,14.11,13.75,13.37,12.87,12.51,12.27,12.12,11.96,11.73,11.50,11.27,11.13,11.09,11,10.99,10.98,10.62,10.25,10,10,10,10,10,10,10,11,12,13,14,15,16,17,18,19,19.96,20.75,20.72,19.34,18.37,18,17.87,17.86,17.87,17.86,17.64,17.39,16.62,15.88,15.25,14.73,14.25,13.87,13.45,12.89,12.37,11.39,10.57,9.72,8.87,8.12,7.39,6.76,6.24,5.75,5.38,5.12,5,4.95,4.97,4.96,4.95,4.90,4.90,4.90,4.97,5,5.20,5.50,6,6.72,7.62,8.61,9.60,10.50,11.37,12.12,12.95,13.75,14.71,15.61,16.37,16.90,17.13,17.07,16.87,16.64,16.77,16,16,16,0.99,1,1,1.10,1.21,1.34,1.49,1.62,1.75,1.87,1.99,2.10,2.22,2.35,2.49,2.62,2.77,3,3.25,3.62,4.09,4.61,5.14,5.75,6.27,6.83,7.32,7.75,8.15,8.58,8.98,9.37,9.71,10.02,10.26,10.52,10.86,11.14,11.40,11.60,11.73,11.87,12.13,12.57,12.87,12.75,12.62,12.38,12.09,11.63,11.12,10.60,10.11,9.77,9.83,10.23,10.87,11.62,12.01,11.87,11.62,11.40,11.47,11.65,11.90,11.99,11.84,11.34,10.37,9.26,8.46,8.20,8.50,9.23,10.12,11,11.71,12.14,12.46,12.50,12.21,11.87,11.62,11.73,11.87,12.01,12.09,12.08,12.08,12.24,12.60,13.02,13.26,13.24,13.75,13.71,13.25,12.64,11.96,11.35,10.75,10.22,9.72,9.25,8.87,8.71,7.96,7.37,7.12,7.07,7.25,7.62,8.20,8.87,9.74,10.70,11.72,12.72,13.62,14.33,14.65,14.72,14.50,13.88,13.20,12.71,12.37,12.12,11.87,11.62,11.47,11.37,11.61,12.02,12.74,13.37,14.13,14.96,15.73,16.25,16.50,16.62,16.57,15.87,14.99,13.90,12,11.89,11.87,12.32,12.86,13.37,13.90,14.37,14.75,15,15.08,14.95,14.71,14.45,14.13,13.77,13.36,12.75,11.87,10.88,9.89,9,8.35,7.99,7.87,8,8.23,8.40,8.51,8.64,8.75,8.75,8.83,8.84,8.87,8.97,9.23,9.62,10.25,10.96,11.73,12.57,13.48,14.35,15.12,15.76,16.33,16.75,17,17.11,17.09,17,17,17.01,17.10,17.13,17.25,17.50,17.75,18.01,18.22,18.22,18,17.64,17.21,16.62,16.07,15.60,15.25,15.07,14.89,14.75,14.50,14.25,14,13.75,13.46,13.09,12.71,12.37,12.12,11.87,11.61,11.36,11.20,11.10,11.01,11,10.99,10.95,10.64,10.07,10,10,10,10,10,11,11,12,13,14,15,16,16.99,17.96,18.90,19.88,20.12,20.77,20.12,19.25,18.37,18.25,18.35,18.38,18.49,18.47,18,17.48,16.75,15.99,15.25,14.62,14.12,13.73,13.39,12.59,11.84,11.02,10.22,9.39,8.62,7.88,7.25,6.63,6.13,5.73,5.37,5.12,5,4.98,4.99,4.99,4.98,4.98,4.98,4.98,4.99,5.01,5.21,5.50,6.07,6.82,7.74,8.75,9.75,10.70,11.51,12.34,13.12,13.97,14.87,15.87,16.65,17.25,17.50,17.50,17.37,17.27,17.21,17,17,16,0.99,0.99,1,1.07,1.13,1.25,1.39,1.57,1.70,1.82,1.89,2,2.12,2.25,2.37,2.50,2.71,2.90,3.22,3.58,4,4.50,5.08,5.62,6.13,6.64,7.15,7.59,7.95,8.26,8.62,8.95,9.25,9.50,9.71,9.89,10.15,10.40,10.62,10.75,10.77,10.87,11,11.21,11.27,11.32,11.24,11.10,10.88,10.62,10.22,9.74,9.25,9,9,9.37,9.87,10.37,10.62,10.60,10.49,10.46,10.65,11.07,11.34,11.37,10.97,10.25,9.39,8.51,7.89,7.75,8.02,8.70,9.46,10.14,10.73,11.12,11.37,11.45,11.36,11.21,11.11,11.25,11.33,11.37,11.38,11.37,11.50,11.50,12.36,13.08,13.75,14.13,14.71,14.64,14.62,13.62,12.62,11.62,10.62,10,9.61,9.25,8.95,8.60,8.20,7.75,7.49,7.37,7.47,7.65,8.09,8.65,9.45,10.34,11.37,12.25,13.07,13.51,13.75,13.82,13.62,13.11,12.50,12.07,11.72,11.45,11.23,11.12,11.14,11.37,11.82,12.50,13.27,14.12,14.98,15.83,16.37,16.61,16.50,16.25,15.74,14.98,13.99,12.87,11.99,11,11.37,12,12.62,13.24,13.86,14.35,14.62,14.75,14.62,14.37,14.12,13.86,13.62,13.32,12.87,12.25,11.39,10.40,9.39,8.50,7.87,7.60,7.57,7.75,8,8.39,8.76,9.01,9.14,9.22,9.23,9.25,9.25,9.36,9.50,9.85,10.37,11.02,11.77,12.62,13.45,14.21,14.87,15.45,15.86,16.12,16.24,16.21,16.11,16,16,16.12,16.25,16.37,16.50,16.72,16.87,17.07,17.13,17.12,17.07,16.87,16.58,16.21,15.77,15.45,15.15,15,14.86,14.64,14.46,14.25,14.12,14,13.77,13.50,13.12,12.75,12.45,12.12,11.82,11.50,11.27,11.12,11.02,11,10.99,10.87,10.72,10.11,10,10,10,10,11,12,12,13,14,15,16,17,17.97,18.95,19.07,20.09,20.87,20.82,20.14,19.24,18.35,18.70,18.87,19.01,18.95,18.62,18.12,17.50,16.75,15.89,15.12,14.39,13.86,13.47,12.75,12.02,11.25,10.51,9.76,9.01,8.33,7.62,7,6.49,6.02,5.64,5.37,5.12,5,4.99,4.99,4.99,4.99,4.99,4.99,4.99,5,5.02,5.22,5.52,6.12,6.88,7.85,8.86,9.87,10.82,11.65,12.49,13.25,14.10,15,15.97,16.86,17.60,17.90,17.95,17.77,17.65,17.62,17.75,17,17,0.99,0.99,1,1.01,1.11,1.21,1.34,1.47,1.60,1.73,1.84,1.90,2,2.12,2.25,2.38,2.60,2.83,3.12,3.48,3.88,4.37,4.89,5.45,5.97,6.47,6.90,7.27,7.62,7.87,8.13,8.37,8.62,8.75,8.90,9.10,9.26,9.49,9.62,9.70,9.72,9.73,9.74,9.75,9.82,9.82,9.75,9.73,9.62,9.39,9.12,8.75,8.37,8.14,8.15,8.40,8.77,9.12,9.27,9.36,9.37,9.51,9.89,10.47,10.95,10.86,10.12,9.33,8.49,7.75,7.33,7.25,7.51,8.08,8.65,9.25,9.70,10.02,10.32,10.46,10.57,10.70,10.95,11.21,11.37,11.38,11.38,11.39,11.62,12,12.71,13.22,14.08,14.70,15.64,14.35,13.63,12.87,11.96,11.02,10.25,9.57,9.38,9.20,8.97,8.72,8.40,8.12,7.88,7.75,7.74,7.75,8,8.47,9.12,9.87,10.63,11.39,12.08,12.36,12.50,12.52,12.39,12.10,11.75,11.45,11.13,10.89,10.76,10.86,11.15,11.65,12.36,13.13,14.02,14.95,15.76,16.48,16.82,16.71,16.25,15.65,14.89,14,13,12.12,11.25,11,11.12,11.70,12.37,13.09,13.73,14.20,14.36,14.25,13.99,13.70,13.39,13.21,13,12.75,12.38,11.77,10.97,10,8.99,8.12,7.62,7.40,7.50,7.84,8.25,8.87,9.46,9.83,10,10.02,10.01,10.01,10.02,10.10,10.14,10.35,10.64,11.15,11.76,12.47,13.12,13.77,14.37,14.87,15.14,15.34,15.35,15.12,15,15,15.12,15.36,15.59,15.70,15.87,15.99,16.09,16.13,16.15,16.21,16.15,16.11,15.96,15.74,15.49,15.25,15.12,14.99,14.87,14.71,14.50,14.23,14.36,14.37,14.25,14,13.70,13.33,12.97,12.60,12.23,11.86,11.50,11.26,11.12,11.01,11,10.95,10.74,10.25,10.07,10,11,11,12,13,13,14,15,16,17,17,18,19.02,19.90,20.88,21.87,21.84,20.12,19.25,18.87,19,19.60,19.57,19.50,18.51,17.97,17.48,16.58,15.72,14.87,14.09,13.38,12.75,12.10,11.37,10.62,9.96,9.25,8.61,7.95,7.33,6.75,6.32,5.97,5.62,5.36,5.12,5,4.99,5,4.99,4.99,4.99,4.99,5,5,5.07,5.24,5.60,6.15,7,7.90,8.95,9.95,10.88,11.82,12.62,13.40,14.24,15.09,16.07,17.01,17.90,18.25,18.37,18.25,18.15,18.09,17.87,17.88,17,0.99,0.99,0.99,1,1.07,1.12,1.24,1.36,1.49,1.61,1.72,1.82,1.88,2,2.12,2.26,2.48,2.71,2.99,3.34,3.75,4.22,4.72,5.21,5.71,6.21,6.60,6.90,7.21,7.39,7.60,7.75,7.87,7.96,8.01,8.12,8.25,8.38,8.50,8.57,8.57,8.50,8.49,8.48,8.47,8.46,8.45,8.38,8.35,8.24,8.01,7.75,7.50,7.34,7.35,7.50,7.75,7.98,8.12,8.24,8.36,8.62,9.12,9.72,10.64,10.11,9.26,8.47,7.71,7.11,6.77,6.77,7.08,7.50,7.97,8.37,8.75,9.10,9.37,9.62,9.87,10.37,10.88,11.39,11.77,12,12.08,12.20,12.47,12.87,13.15,14,14.73,14.87,14.62,13.95,12.96,12.08,11.21,10.40,9.64,9.45,9.25,9.13,9.02,8.89,8.75,8.60,8.40,8.25,8.12,8.08,8.12,8.37,8.83,9.37,9.99,10.52,10.99,11.25,11.36,11.35,11.26,11.14,11.01,10.87,10.75,10.62,10.65,10.98,11.52,12.26,13.07,13.88,14.77,15.73,16.51,16.88,17,16.62,16.01,15.25,14.37,13.37,12.37,11.47,10.76,10.25,10.82,11.37,12.11,12.83,13.46,13.83,13.85,13.60,13.25,12.95,12.70,12.52,12.45,12.26,11.98,11.37,10.59,9.62,8.64,7.89,7.50,7.39,7.61,8.07,8.83,9.62,10.37,10.90,11.10,11.12,11.07,11,10.98,10.99,11,11,11.12,11.36,11.75,12.25,12.82,13.37,13.87,14.26,14.50,14.51,14.51,14.36,14.36,14.36,14.59,14.88,15.25,15.36,15.36,15.36,15.45,15.48,15.48,15.49,15.49,15.47,15.39,15.32,15.22,15.12,15.08,15,14.95,14.75,14.62,14.52,14.72,14.85,14.84,14.62,14.33,13.96,13.59,13.14,12.72,12.25,11.83,11.49,11.22,11.07,11,10.97,10.87,10.76,10.83,11,12,12,13,14,14,15,16,17,17,18,18.97,19.95,20.07,20.88,20.87,20.86,19.82,18.99,18.71,18.82,19.62,19.60,18.65,18.11,17.50,16.87,16.14,15.34,14.49,13.63,12.87,12.12,11.37,10.71,10,9.37,8.75,8.15,7.62,7.12,6.63,6.25,5.98,5.63,5.37,5.12,5.01,5,5,5,5,5,5,5,5.01,5.11,5.26,5.64,6.25,7.09,8,9,10,11,11.96,12.83,13.62,14.37,15.20,16.15,17.21,18.12,18.50,18.72,18.62,18.50,18.34,18.12,17.84,17,0.99,0.99,0.99,1,1,1.08,1.12,1.25,1.37,1.48,1.59,1.65,1.75,1.87,2,2.12,2.34,2.52,2.84,3.13,3.52,3.99,4.46,4.90,5.39,5.84,6.21,6.50,6.73,6.87,7,7.07,7.10,7.12,7.12,7.12,7.22,7.27,7.37,7.40,7.38,7.37,7.34,7.32,7.26,7.25,7.25,7.24,7.20,7.12,7,6.85,6.64,6.57,6.57,6.64,6.84,6.98,7.11,7.20,7.37,7.72,8.20,8.75,9.12,9,8.37,7.71,7.10,6.63,6.49,6.52,6.82,7.12,7.49,7.77,8.12,8.46,8.75,9.12,9.59,10.23,10.96,11.73,12.37,12.77,13.09,13.34,13.60,13.84,14.15,14.74,15,14.99,14.62,13.37,12.26,11.25,10.50,9.75,9.50,9.33,9.25,9.25,9.25,9.25,9.25,9.15,9.08,8.89,8.75,8.59,8.48,8.50,8.65,9,9.37,9.82,10.12,10.27,10.33,10.25,10.37,10.37,10.46,10.50,10.60,10.72,10.97,11.49,12.22,12.99,13.76,14.61,15.46,16.22,16.82,17,17,16.58,15.89,15.02,14.02,13.02,12.02,11.12,10.47,10.25,10.50,11.08,11.75,12.58,13.11,13.33,13.21,12.86,12.49,12.15,12,11.97,11.98,11.87,11.63,11.12,10.27,9.37,8.47,7.77,7.45,7.37,7.77,8.50,9.40,10.46,11.40,12.14,12.38,12.33,12.12,12.02,11.99,11.97,11.89,11.85,11.74,11.73,11.87,12.20,12.62,13.12,13.61,13.87,14.07,14.12,14.14,14,14.12,14.25,14.70,15,15.35,15.25,15.12,15,15,15,15,15,15,15.01,15.07,15.07,15.01,15.02,15.09,15.11,15.11,15,15,15.12,15.25,15.36,15.35,15.22,14.96,14.60,14.12,13.62,13.09,12.57,12.09,11.70,11.36,11.10,11.09,11.08,11.14,11.25,11.32,12.12,13,13,14,15,15,16,17,18,18,19,19,19.96,19.90,19.88,19.99,19.87,19,18.20,17.99,18.09,18.20,18.12,17.77,17.33,16.84,16.25,15.59,14.83,13.99,13.12,12.26,11.49,10.75,10.08,9.46,8.87,8.37,7.87,7.45,7.07,6.72,6.38,6.10,5.75,5.45,5.15,5.09,5.01,5,5,5,5,5.02,5.10,5.12,5.24,5.40,5.82,6.39,7.21,8.12,9.08,10.09,11.10,12.11,13,13.76,14.50,15.27,16.25,17.26,18.25,18.61,18.95,18.96,18.85,18.62,18.34,18,18,0.99,0.99,0.99,0.99,1,1,1.09,1.12,1.25,1.35,1.40,1.50,1.62,1.75,1.87,2,2.20,2.37,2.63,2.97,3.33,3.73,4.12,4.62,5.01,5.40,5.75,6,6.20,6.32,6.37,6.37,6.37,6.33,6.25,6.22,6.23,6.25,6.35,6.37,6.37,6.37,6.35,6.33,6.27,6.26,6.25,6.25,6.23,6.20,6.12,6.01,5.95,5.87,5.87,5.95,6.01,6.12,6.20,6.26,6.49,6.77,7.20,7.60,7.84,7.76,7.47,7,6.62,6.40,6.39,6.58,6.84,7.12,7.35,7.57,7.83,8.20,8.58,9,9.51,10.23,11.01,11.90,12.86,13.58,14.12,14.51,14.70,14.76,14.87,15.13,15.65,15.62,14.33,13.10,11.46,10.62,9.77,9.62,9.40,9.38,9.46,9.52,9.64,9.76,9.87,9.87,9.85,9.71,9.50,9.25,9.02,8.87,8.75,8.82,9,9.25,9.50,9.62,9.62,9.75,9.77,9.95,10.20,10.48,10.75,11.12,11.60,12.24,12.98,13.75,14.49,15.13,15.76,16.25,16.62,16.70,16.64,16.35,15.76,14.99,14.02,13.07,12.02,11.01,10.36,10.10,10.32,10.72,11.26,12,12.52,12.87,12.45,12.08,11.73,11.49,11.40,11.50,11.60,11.62,11.45,10.95,10.12,9.20,8.32,7.61,7.37,7.58,8.12,8.96,10,11.14,12.26,13.15,13.50,13.46,13.25,13.09,13,13,12.95,12.75,12.48,12.20,12.20,12.35,12.62,13.11,13.51,13.87,14,14.12,14.24,14.25,14.59,14.77,15.36,15.70,15.85,15.70,15.36,15.12,15,15,15,15,15,15,15,15,15.07,15.12,15.25,15.37,15.49,15.46,15.62,15.86,16.01,16.12,16.11,15.90,15.61,15.12,14.57,13.89,13.25,12.65,12.20,11.87,11.62,11.40,11.39,11.38,11.62,11.90,12.39,13.12,14,14,15,16,16,17,18,18,19,19,18.98,18.96,19,19,18.99,18.87,18.12,17.20,17.12,17.02,17.02,16.97,16.75,16.45,16,15.50,14.87,14.14,13.37,12.50,11.64,10.87,10.12,9.50,8.98,8.50,8.11,7.75,7.45,7.15,6.90,6.63,6.34,5.96,5.59,5.27,5.13,5.12,5.10,5.02,5.01,5.08,5.12,5.24,5.33,5.40,5.62,6,6.62,7.37,8.25,9.13,10.12,11.13,12.22,13.12,13.87,14.62,15.37,16.32,17.33,18.25,18.70,18.96,19.01,19.01,18.87,18.63,18.25,18,0.99,0.99,0.99,0.99,0.99,1,1,1.08,1.12,1.22,1.26,1.37,1.49,1.61,1.74,1.87,2.02,2.25,2.49,2.75,3.09,3.45,3.84,4.24,4.62,5,5.26,5.50,5.65,5.75,5.75,5.75,5.73,5.62,5.50,5.46,5.40,5.40,5.38,5.46,5.52,5.57,5.52,5.51,5.51,5.50,5.50,5.49,5.47,5.45,5.39,5.37,5.34,5.27,5.27,5.34,5.37,5.38,5.45,5.51,5.65,5.87,6.21,6.50,6.73,6.75,6.62,6.45,6.27,6.33,6.50,6.83,7.14,7.48,7.70,7.87,8.08,8.38,8.75,9.15,9.62,10.27,11.12,12.08,13.11,14.14,14.96,15.65,15.76,15.23,15.24,15.73,15.64,15.62,14.23,12.90,11.75,10.73,9.87,9.52,9.62,9.71,9.86,10.02,10.25,10.49,10.63,10.75,10.75,10.61,10.37,10.09,9.75,9.47,9.21,8.99,8.97,9.08,9.23,9.32,9.50,9.60,9.75,10,10.37,10.82,11.25,11.75,12.34,13,13.75,14.49,15.10,15.52,15.87,16.10,16.21,16.25,16.22,16.12,15.64,15,14.12,13.12,12.12,11.13,10.48,10,10.09,10.27,10.65,11.13,11.62,11.87,11.63,11.25,10.89,10.83,10.87,11.07,11.27,11.48,11.46,10.97,10,8.99,8.11,7.58,7.48,7.77,8.49,9.40,10.57,11.76,12.97,13.97,14.37,14.37,14.23,14.09,14,14,13.95,13.72,13.38,13.12,12.98,13,13.12,13.46,13.76,14.07,14.23,14.39,14.62,14.77,15.33,15.70,16.26,16.62,16.74,16.26,15.77,15.47,15.36,15.25,15.12,15.01,15.01,15.01,15,15.07,15.12,15.32,15.58,15.87,16.10,16.24,16.50,16.77,17,17.11,17.02,16.72,16.15,15.50,14.74,13.96,13.13,12.52,12.15,12.01,12,12.07,12.11,12.21,12.50,13.07,13.71,14.32,14.88,15,16,17,18,18,18,19,18,18,18,18,18,18,17.99,17.87,17.13,16.82,16.22,16.13,16.01,15.96,15.76,15.50,15.12,14.70,14.12,13.45,12.63,11.83,11,10.24,9.58,9,8.60,8.25,8,7.82,7.62,7.48,7.25,7,6.63,6.25,5.82,5.39,5.26,5.23,5.20,5.12,5.11,5.13,5.25,5.38,5.51,5.64,5.87,6.25,6.86,7.59,8.37,9.25,10.20,11.21,12.25,13.13,13.99,14.62,15.37,16.26,17.25,18.25,18.75,19.13,19.25,19.32,19.26,19.09,18.75,18,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.02,1.11,1.14,1.25,1.35,1.47,1.61,1.75,1.90,2.12,2.33,2.57,2.83,3.12,3.50,3.87,4.23,4.52,4.85,5.01,5.13,5.22,5.24,5.23,5.14,5.08,4.97,4.87,4.76,4.82,4.84,4.87,4.87,4.89,5,4.99,4.99,4.98,4.98,4.95,4.89,4.87,4.87,4.87,4.87,4.85,4.84,4.84,4.85,4.87,4.88,4.87,4.98,5.12,5.27,5.51,5.86,5.99,6,5.99,6.08,6.35,6.75,7.24,7.73,8.12,8.49,8.73,8.88,9.12,9.35,9.57,9.87,10.39,11.21,12.14,13.25,14.27,15.27,16.64,16.57,15.98,15.72,15.57,15.40,15.25,14,12.90,11.89,11,10.33,9.98,10.09,10.25,10.50,10.76,11.08,11.36,11.60,11.73,11.74,11.60,11.34,10.99,10.60,10.20,9.82,9.50,9.25,9.23,9.26,9.37,9.62,9.82,10.15,10.52,10.98,11.45,11.95,12.48,13.07,13.73,14.38,15.02,15.50,15.75,15.85,15.85,15.75,15.70,15.62,15.52,15.24,14.75,14,13.12,12.25,11.25,10.40,9.83,9.73,9.84,10.01,10.34,10.65,10.87,10.75,10.50,10.36,10.34,10.46,10.65,10.89,11.08,11.07,10.58,9.63,8.71,7.89,7.50,7.58,8.08,8.88,9.96,11.12,12.35,13.50,14.51,15.08,15.15,15.11,15,14.97,14.98,14.95,14.71,14.36,14.01,13.84,13.75,13.76,14,14.25,14.50,14.71,15,15.37,15.70,16.26,16.70,17.15,17.37,17.26,16.87,16.36,16.12,15.88,15.70,15.47,15.26,15.22,15.12,15.12,15.22,15.37,15.63,16.08,16.49,16.87,17.25,17.50,17.73,17.95,18.02,17.95,17.37,16.61,15.61,14.62,13.64,12.87,12.34,12.12,12.23,12.50,12.75,13,13.25,13.72,14.37,15.13,15.85,16.14,17,17,18,19,19,19,18,17,17,17,17,17,17,16.99,16.87,16.12,15.87,15.77,15.33,15.12,15,14.83,14.57,14.23,13.77,13.25,12.62,11.87,11.08,10.32,9.62,9.09,8.63,8.37,8.22,8.12,8.02,8,7.87,7.72,7.45,7.07,6.59,6.09,5.64,5.38,5.37,5.34,5.25,5.24,5.27,5.46,5.61,5.74,5.87,6.09,6.47,7.01,7.75,8.50,9.35,10.23,11.22,12.25,13.13,13.98,14.63,15.37,16.25,17.22,18.12,18.87,19.37,19.65,19.71,19.65,19.50,19.21,19,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1.08,1.12,1.22,1.34,1.49,1.63,1.84,2,2.14,2.37,2.61,2.87,3.20,3.50,3.84,4.12,4.37,4.57,4.64,4.73,4.75,4.74,4.71,4.62,4.49,4.38,4.37,4.46,4.50,4.52,4.59,4.60,4.61,4.61,4.64,4.64,4.64,4.62,4.62,4.58,4.58,4.58,4.57,4.57,4.52,4.52,4.52,4.49,4.50,4.58,4.61,4.62,4.75,4.95,5.21,5.46,5.61,5.75,6,6.47,7,7.70,8.37,9,9.50,9.87,10.10,10.14,10.12,10.11,10.15,10.57,11.25,12.23,13.26,14.34,15.36,16.12,16.62,16.46,15.95,15.39,15,14.50,13.76,12.95,12.12,11.37,10.87,10.72,10.76,11.01,11.36,11.65,12,12.35,12.61,12.75,12.75,12.62,12.34,11.90,11.48,11,10.51,10.12,9.82,9.62,9.62,9.75,10,10.33,10.70,11.12,11.62,12.11,12.62,13.12,13.71,14.34,14.98,15.51,15.88,15.99,15.85,15.59,15.32,15.07,14.95,14.87,14.63,14.34,13.64,12.76,12,11.01,10.25,9.57,9.32,9.27,9.37,9.58,9.75,9.88,9.96,9.87,9.88,10,10.13,10.33,10.40,10.40,10.25,9.76,9.02,8.25,7.62,7.40,7.70,8.38,9.39,10.52,11.73,12.87,13.99,14.96,15.61,15.85,15.87,15.85,15.84,15.95,15.83,15.57,15.20,14.87,14.62,14.52,14.60,14.82,15,15.24,15.50,15.90,16.39,16.88,17.38,17.85,18.15,18.15,17.85,17.47,17.12,16.87,16.62,16.33,16,15.71,15.49,15.37,15.37,15.50,15.75,16.12,16.63,17.14,17.62,18.15,18.37,18.37,18.37,18.37,18.12,17.49,16.49,15.25,14.12,13.11,12.37,12,12,12.37,12.96,13.50,13.87,14.25,14.75,15.48,16.36,17.51,17.75,18,18,18,18,18,18,17,16,16,16,16,16,16,15.99,15.87,15.12,14.97,14.76,14.51,14.25,14.01,13.85,13.59,13.25,12.87,12.37,11.75,11.02,10.33,9.63,9.11,8.72,8.47,8.36,8.35,8.37,8.46,8.47,8.37,8.22,7.88,7.47,6.89,6.37,5.89,5.62,5.52,5.50,5.46,5.40,5.50,5.62,5.75,5.87,6,6.22,6.58,7.13,7.86,8.62,9.37,10.25,11.24,12.24,13.14,13.96,14.63,15.36,16.14,17.10,18.09,19.01,19.83,20.25,20.25,20.15,19.98,19.63,19,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.08,1.20,1.37,1.58,1.75,1.89,2.07,2.22,2.38,2.62,2.88,3.21,3.48,3.74,3.96,4.12,4.22,4.25,4.25,4.26,4.26,4.25,4.23,4.24,4.25,4.35,4.39,4.50,4.58,4.61,4.60,4.59,4.57,4.51,4.51,4.51,4.40,4.40,4.40,4.40,4.40,4.40,4.40,4.45,4.47,4.50,4.51,4.58,4.59,4.59,4.62,4.76,5,5.25,5.46,5.75,6.12,6.64,7.36,8.13,9,9.87,10.62,11.22,11.49,11.37,11,10.65,10.51,10.76,11.46,12.36,13.37,14.37,15.26,16.07,17.09,17,15.87,15.15,14.62,14.14,13.61,12.99,12.36,11.83,11.50,11.48,11.62,11.95,12.27,12.65,13.02,13.37,13.62,13.84,13.87,13.64,13.32,12.86,12.35,11.82,11.26,10.82,10.39,10.12,10.11,10.24,10.50,10.85,11.25,11.75,12.25,12.75,13.25,13.75,14.25,14.84,15.37,15.87,16.12,16.10,15.76,15.36,14.87,14.50,14.23,14,13.83,13.46,12.83,12.02,11.24,10.50,9.82,9.15,8.87,8.75,8.82,8.87,8.98,9.12,9.25,9.36,9.50,9.73,9.87,9.87,9.75,9.52,9.25,8.82,8.25,7.70,7.34,7.35,7.85,8.82,10,11.23,12.37,13.45,14.45,15.35,16,16.39,16.52,16.60,16.61,16.62,16.50,16.25,15.97,15.65,15.47,15.40,15.51,15.75,15.95,16.20,16.51,17.07,17.62,18.15,18.62,18.97,18.97,18.74,18.36,18.12,17.99,17.74,17.37,16.97,16.50,16.08,15.76,15.65,15.75,15.89,16.25,16.70,17.25,17.77,18.24,18.73,18.73,18.37,18.07,17.83,17.49,16.83,15.83,14.61,13.40,12.37,11.83,11.74,11.89,12.50,13.32,14.09,14.62,15.02,15.57,16.25,17.01,17.62,18.09,18,18,18,18,17,17,16,16,16,16,15,15,15,15,14.88,14.12,14.10,13.87,13.62,13.35,13.09,12.86,12.61,12.27,11.90,11.48,10.88,10.25,9.62,9.11,8.73,8.50,8.48,8.52,8.70,8.85,8.97,9,8.88,8.70,8.27,7.77,7.21,6.62,6.13,5.86,5.75,5.71,5.63,5.62,5.70,5.75,5.87,5.98,6.11,6.27,6.65,7.25,7.90,8.63,9.45,10.27,11.25,12.25,13.12,13.88,14.62,15.32,16.07,17,18.07,19.12,20.02,20.61,20.62,20.50,20.27,19.99,20,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.02,1.13,1.34,1.51,1.74,1.87,2,2.12,2.27,2.49,2.74,2.98,3.21,3.38,3.60,3.73,3.83,3.87,3.89,4,4.08,4.12,4.21,4.26,4.37,4.50,4.62,4.75,4.86,4.90,4.90,4.89,4.88,4.87,4.87,4.87,4.75,4.75,4.75,4.75,4.75,4.75,4.75,4.75,4.76,4.83,4.85,4.87,4.87,4.87,4.96,5.07,5.25,5.48,5.72,6,6.34,6.98,7.70,8.58,9.59,10.63,11.63,12.37,12.83,12.50,11.75,11.15,10.87,11,11.62,12.59,13.59,14.51,15.37,16.01,16.37,16.25,15.62,14.89,14.37,13.96,13.52,13.10,12.62,12.27,12.14,12.25,12.51,12.87,13.27,13.72,14.09,14.37,14.62,14.82,14.87,14.62,14.21,13.65,13.12,12.58,12,11.47,11,10.72,10.62,10.72,11,11.37,11.86,12.36,12.87,13.37,13.87,14.33,14.75,15.23,15.63,16,16.14,16.02,15.64,15.12,14.52,13.99,13.51,13.22,12.95,12.63,12,11.12,10.35,9.72,9.12,8.71,8.37,8.25,8.25,8.25,8.34,8.48,8.71,8.97,9.25,9.50,9.62,9.37,8.97,8.50,8.12,7.76,7.45,7.12,7.02,7.37,8.12,9.32,10.63,11.96,13.08,14,14.90,15.75,16.48,16.97,17.20,17.25,17.26,17.25,17.14,16.95,16.64,16.46,16.36,16.37,16.52,16.72,16.85,17.10,17.50,18.11,18.77,19.50,19.85,19.97,19.74,19.37,19.10,18.97,18.97,18.62,18.15,17.50,16.85,16.32,15.97,15.88,16,16.25,16.62,17.14,17.71,18.14,18.49,18.85,18.50,17.87,17.35,16.87,16.35,15.64,14.75,13.72,12.64,11.84,11.37,11.50,11.90,12.70,13.60,14.39,15.10,15.57,16.08,16.70,17.32,17.87,18.32,19,18,18,17,17,16,16,15,15,15,14,14,14.01,14.07,13.89,13.87,13.24,12.88,12.62,12.37,12.12,11.87,11.62,11.37,11.01,10.62,10.14,9.62,9.12,8.74,8.50,8.50,8.75,9,9.24,9.40,9.57,9.58,9.45,9.12,8.62,8,7.37,6.82,6.35,6,5.87,5.87,5.84,5.83,5.85,5.87,5.97,6.02,6.15,6.37,6.75,7.33,7.98,8.70,9.47,10.32,11.24,12.13,13.01,13.76,14.50,15.24,16.01,16.95,17.98,19.12,20.02,20.72,20.84,20.85,20.62,20.27,20,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.08,1.15,1.35,1.52,1.74,1.87,2,2.10,2.23,2.37,2.58,2.75,2.98,3.13,3.27,3.38,3.45,3.50,3.62,3.82,4,4.21,4.37,4.60,4.75,4.90,5.10,5.25,5.39,5.51,5.61,5.60,5.59,5.52,5.52,5.51,5.38,5.37,5.37,5.35,5.34,5.34,5.35,5.37,5.37,5.38,5.39,5.39,5.39,5.45,5.49,5.60,5.75,6,6.25,6.50,6.77,7.26,7.96,8.89,10.02,11.32,12.62,13.50,13.87,13.20,12.20,11.35,11.12,11.40,12.12,13,13.90,14.83,15.58,16.09,16.25,16,15.38,14.75,14.25,13.90,13.62,13.32,13,12.87,12.87,13.12,13.40,13.85,14.26,14.73,15.09,15.35,15.50,15.62,15.62,15.37,14.87,14.33,13.75,13.20,12.62,12,11.52,11.22,11.09,11.21,11.50,11.89,12.38,12.90,13.46,13.96,14.38,14.84,15.21,15.50,15.76,15.98,16,15.85,15.47,14.87,14.21,13.51,12.96,12.50,12.10,11.65,11,10.14,9.37,8.84,8.37,8.07,7.86,7.75,7.74,7.75,7.75,7.96,8.20,8.51,8.87,9.15,9.14,8.73,8.07,7.50,7.11,6.87,6.75,6.74,6.96,7.60,8.62,9.87,11.32,12.63,13.73,14.62,15.40,16.21,16.88,17.46,17.73,17.77,17.86,17.96,17.84,17.59,17.26,17.13,17.15,17.35,17.39,17.38,17.38,17.62,18.09,18.74,19.62,20.37,20.85,20.74,20.26,19.87,19.63,19.62,19.62,19.26,18.74,17.85,17,16.36,16,16,16.13,16.45,16.86,17.37,17.83,18.12,18.26,18.37,17.84,17.10,16.37,15.75,15.12,14.40,13.62,12.76,12,11.37,11.14,11.46,12.01,12.87,13.77,14.64,15.35,15.88,16.40,17,17.62,18.13,18.62,19,18,18,17,17,16,15,15,14,14,13,13,13.97,13.02,12.98,12.89,12.32,11.98,11.72,11.46,11.22,11,10.76,10.52,10.26,9.99,9.62,9.25,8.83,8.61,8.61,8.90,9.27,9.62,9.95,10.12,10.23,10.14,9.99,9.47,8.84,8.12,7.48,6.87,6.39,6.12,5.98,5.98,5.97,5.96,5.97,5.99,6,6.11,6.25,6.50,6.90,7.45,8.02,8.74,9.48,10.25,11.13,12.08,12.87,13.62,14.36,15.12,15.97,16.84,17.75,18.71,19.61,20.25,20.62,20.85,20.86,20.72,20,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1,1.01,1.09,1.12,1.25,1.38,1.60,1.75,1.87,1.98,2.07,2.13,2.25,2.40,2.62,2.77,2.97,3.10,3.15,3.22,3.34,3.51,3.82,4.12,4.45,4.75,5.01,5.26,5.50,5.74,5.98,6.21,6.37,6.52,6.62,6.62,6.61,6.60,6.58,6.40,6.37,6.25,6.21,6.14,6.14,6.20,6.22,6.23,6.22,6.21,6.15,6.15,6.20,6.24,6.36,6.52,6.77,7.02,7.25,7.38,7.75,8.34,9.23,10.37,11.70,12.99,13.75,13.87,13.15,12.35,11.72,11.65,12.08,12.72,13.50,14.37,15.22,15.88,16.35,16.38,16.10,15.47,14.77,14.37,14.10,13.86,13.62,13.50,13.50,13.64,13.90,14.26,14.74,15.22,15.64,16,16.15,16.23,16.15,15.98,15.59,15.09,14.58,14.01,13.52,13,12.38,11.96,11.62,11.50,11.65,12,12.45,12.95,13.47,13.98,14.46,14.87,15.25,15.51,15.72,15.77,15.76,15.70,15.48,15.11,14.50,13.84,13.11,12.40,11.85,11.27,10.70,10,9.12,8.39,7.96,7.62,7.40,7.26,7.24,7.23,7.23,7.25,7.37,7.62,7.87,8.12,8.27,8.15,7.73,7.12,6.58,6.25,6.14,6.26,6.60,7.13,8.01,9.15,10.50,11.87,13.21,14.25,15.10,15.84,16.58,17.24,17.72,17.95,18,18.25,18.25,18.14,17.90,17.72,17.70,17.87,17.98,17.87,17.61,17.40,17.57,17.99,18.64,19.73,20.60,21.25,21.24,20.65,20.15,19.89,19.87,19.87,19.57,18.88,17.95,17.02,16.37,16,16,16.12,16.36,16.73,17.12,17.49,17.65,17.64,17.62,16.95,16.12,15.36,14.70,13.98,13.24,12.50,11.87,11.36,11.08,11.12,11.50,12.23,13.09,14.01,14.90,15.70,16.27,16.83,17.37,17.90,18.50,18.85,19,18,18,17,17,16,15,14,14,13,13,13,12.98,12,11.97,11.85,11.37,11.12,10.87,10.63,10.45,10.25,10.10,9.90,9.75,9.58,9.37,9.15,9.07,9.08,9.25,9.62,10.02,10.45,10.75,10.88,10.89,10.75,10.40,9.73,8.96,8.20,7.50,6.87,6.47,6.15,6.07,6.01,6.01,6.02,6.07,6.08,6.12,6.21,6.37,6.63,7.07,7.52,8.12,8.75,9.46,10.25,11.10,11.95,12.75,13.49,14.23,15,15.86,16.62,17.45,18.25,19,19.71,20.26,20.74,21.09,20.99,21,0.99,0.99,0.99,0.99,0.99,1,1,1,1.07,1.09,1.12,1.15,1.25,1.37,1.50,1.63,1.77,1.87,1.98,2.01,2.12,2.15,2.34,2.50,2.64,2.84,2.97,3.02,3.12,3.25,3.52,3.88,4.33,4.74,5.12,5.50,5.84,6.12,6.45,6.75,7.07,7.37,7.62,7.77,7.87,7.90,7.90,7.87,7.75,7.62,7.45,7.26,7.22,7.22,7.25,7.25,7.25,7.23,7.14,7.12,7.12,7.12,7.20,7.33,7.51,7.77,8.01,8.20,8.23,8.34,8.75,9.52,10.63,11.87,12.99,13.62,13.75,13.32,12.65,12.27,12.37,12.75,13.35,14.08,14.87,15.70,16.37,16.77,16.83,16.49,15.85,15.14,14.75,14.45,14.24,14.11,14.08,14.13,14.37,14.65,15.09,15.52,16.02,16.49,16.75,16.86,16.73,16.40,16,15.50,15,14.50,14,13.61,13.11,12.62,12.25,11.99,11.96,12.12,12.50,12.98,13.48,13.99,14.47,14.87,15.25,15.59,15.75,15.77,15.70,15.50,15.25,14.97,14.58,14,13.35,12.60,11.87,11.20,10.50,9.77,9,8.10,7.39,7.09,6.95,6.84,6.73,6.73,6.74,6.75,6.73,6.84,6.95,7.01,7.12,7.20,7,6.65,6.24,5.82,5.61,5.71,6.07,6.62,7.48,8.50,9.73,11,12.32,13.50,14.51,15.36,16.02,16.64,17.13,17.50,17.63,17.83,17.96,17.96,17.84,17.71,17.65,17.87,18.13,18.12,17.75,17.26,16.99,17,17.38,18.08,18.97,20.11,20.98,21.27,20.73,20.20,19.89,19.85,19.73,19.38,18.75,18.01,17.22,16.51,16.12,15.96,15.89,16,16.25,16.58,16.76,16.87,16.76,16.58,15.89,15.12,14.34,13.63,12.87,12.13,11.50,11.02,10.82,10.82,11.12,11.75,12.57,13.47,14.38,15.34,16.12,16.75,17.25,17.71,18.12,18.61,18.85,19,18,18,17,17,16,15,14,14,13,12,12,11.99,11,11.01,10.87,10.46,10.46,10.32,10.11,9.87,9.74,9.62,9.58,9.50,9.45,9.38,9.38,9.48,9.70,10,10.46,10.87,11.27,11.59,11.75,11.62,11.32,10.64,9.87,9,8.23,7.50,6.95,6.50,6.25,6.12,6.12,6.12,6.14,6.20,6.22,6.25,6.36,6.50,6.83,7.21,7.62,8.20,8.76,9.46,10.22,11.01,11.87,12.64,13.39,14.12,14.90,15.73,16.47,17.14,17.83,18.60,19.25,20.08,20.62,21.10,21.84,21,0.99,0.99,0.99,0.99,1,1,1.07,1.10,1.12,1.20,1.25,1.32,1.37,1.50,1.62,1.75,1.86,1.90,1.99,2.01,2.11,2.14,2.26,2.45,2.62,2.75,2.87,3,3.12,3.33,3.62,4,4.49,4.96,5.38,5.85,6.25,6.62,7,7.37,7.77,8.25,8.72,9,9.22,9.35,9.37,9.34,9.25,9.07,8.77,8.59,8.48,8.47,8.50,8.50,8.47,8.37,8.25,8.22,8.21,8.24,8.33,8.50,8.74,9,9.22,9.33,9.25,9.23,9.34,10,10.88,11.96,12.87,13.59,13.77,13.65,13.37,13.21,13.26,13.57,14,14.64,15.45,16.22,16.95,17.37,17.38,17.12,16.50,15.87,15.34,14.96,14.71,14.59,14.61,14.75,15,15.37,15.75,16.25,16.74,17.14,17.37,17.37,17.09,16.60,16,15.39,14.86,14.35,13.89,13.50,13.12,12.75,12.47,12.27,12.37,12.62,13.02,13.51,14.01,14.50,14.96,15.32,15.59,15.75,15.82,15.71,15.45,15.12,14.75,14.37,13.89,13.37,12.72,12,11.25,10.50,9.73,8.88,8.02,7.21,6.62,6.37,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.25,6.23,6.20,6.11,6.12,6,5.76,5.50,5.33,5.25,5.47,6,6.76,7.75,8.87,10.09,11.32,12.48,13.47,14.37,15.12,15.75,16.25,16.60,16.77,16.88,17,17,16.98,16.99,17.02,17.26,17.64,17.87,17.74,17.23,16.62,16.25,16.24,16.62,17.23,18.12,19.14,20.13,20.70,20.24,19.87,19.62,19.50,19.39,19.14,18.75,18.13,17.47,16.77,16.25,15.85,15.62,15.59,15.64,15.77,15.88,15.90,15.77,15.51,14.87,14.10,13.33,12.64,11.95,11.25,10.71,10.40,10.37,10.62,11.25,12.12,13.09,14.01,14.97,15.86,16.62,17.23,17.64,17.97,18.25,18.50,18.65,18,18,18,18,17,17,16,15,14,13,12,12,11,10.99,10,10.25,10.25,10.12,10,9.76,9.62,9.50,9.50,9.50,9.50,9.60,9.72,9.86,10.12,10.49,10.87,11.36,11.76,12.12,12.37,12.39,12.25,11.65,10.86,9.98,9.09,8.25,7.59,7.02,6.63,6.37,6.26,6.25,6.26,6.34,6.36,6.37,6.39,6.50,6.70,6.98,7.34,7.75,8.25,8.83,9.47,10.21,11,11.85,12.62,13.38,14.12,14.87,15.63,16.37,17,17.71,18.37,19.01,19.85,20.50,20.98,21.09,21,0.99,0.99,0.99,0.99,1,1.02,1.12,1.15,1.25,1.34,1.37,1.48,1.57,1.62,1.75,1.84,1.88,1.97,2,2.08,2.12,2.21,2.33,2.46,2.61,2.75,2.87,3,3.12,3.36,3.63,4.07,4.50,4.96,5.39,5.87,6.37,6.87,7.27,7.71,8.15,8.74,9.33,9.83,10.21,10.48,10.61,10.60,10.62,10.37,10.09,9.84,9.71,9.70,9.75,9.75,9.65,9.58,9.46,9.37,9.37,9.48,9.62,9.85,10.11,10.37,10.58,10.62,10.59,10.37,10.34,10.52,11.14,12,12.88,13.62,14.10,14.25,14.24,14.20,14.23,14.38,14.75,15.33,16,16.75,17.46,17.95,18.01,17.87,17.27,16.62,16,15.50,15.15,15,14.99,15.12,15.38,15.76,16.25,16.75,17.25,17.71,17.89,17.84,17.40,16.82,16.02,15.25,14.62,14.12,13.75,13.49,13.12,12.87,12.65,12.62,12.77,13.14,13.62,14.12,14.62,15.10,15.46,15.71,15.85,15.86,15.74,15.47,15.12,14.71,14.25,13.75,13.25,12.70,12.02,11.35,10.59,9.75,8.87,8,7.13,6.39,5.87,5.75,5.74,5.73,5.72,5.71,5.72,5.72,5.71,5.72,5.62,5.49,5.38,5.37,5.33,5.23,5.12,5.08,5.23,5.52,6.12,6.88,7.85,8.87,9.96,11,12,12.85,13.57,14.20,14.77,15.27,15.57,15.73,15.87,15.97,15.97,15.97,16,16.20,16.50,16.89,17,16.83,16.34,15.76,15.47,15.48,15.86,16.47,17.25,18.15,19.12,19.75,19.48,19.25,19.13,19.12,19.12,19,18.75,18.34,17.62,16.89,16.25,15.72,15.34,15.12,15,15,15,14.97,14.77,14.52,13.88,13.12,12.37,11.74,11.09,10.50,10.13,10.07,10.26,10.75,11.63,12.64,13.71,14.63,15.50,16.32,17.02,17.52,17.87,18.02,18.27,18.26,18.09,18,17,18,18,17,17,16,15,14,13,12,12,11,10,10,10.08,10.10,10.07,9.96,9.84,9.74,9.73,9.75,9.77,9.88,10.09,10.35,10.62,11,11.39,11.87,12.27,12.65,12.98,13.12,13.01,12.59,11.85,10.97,10,9.12,8.33,7.65,7.20,6.83,6.59,6.49,6.48,6.50,6.51,6.58,6.60,6.62,6.73,6.87,7.12,7.48,7.87,8.33,8.85,9.47,10.21,11,11.85,12.63,13.40,14.15,14.88,15.62,16.33,17,17.62,18.32,19,19.75,20.37,20.75,21,21,0.99,0.99,0.99,0.99,1,1.09,1.14,1.25,1.37,1.48,1.57,1.62,1.71,1.75,1.84,1.87,1.96,2,2.02,2.11,2.15,2.25,2.37,2.50,2.62,2.75,2.87,3,3.12,3.33,3.60,3.89,4.26,4.65,5.12,5.61,6.12,6.62,7.09,7.50,8,8.61,9.25,9.96,10.57,11.01,11.32,11.39,11.60,11.37,11.08,10.82,10.72,10.75,10.84,10.86,10.75,10.62,10.51,10.50,10.60,10.75,11,11.26,11.59,11.86,12.02,12.12,12,11.62,11.26,11.12,11.45,12.11,12.96,13.76,14.46,14.88,15.10,15.12,15.14,15.25,15.52,16,16.58,17.23,17.87,18.37,18.60,18.61,18,17.32,16.62,16,15.51,15.24,15.12,15.22,15.49,15.88,16.40,17,17.62,18.12,18.37,18.25,17.84,17.12,16.25,15.25,14.62,14.12,13.77,13.59,13.27,13.10,12.97,13,13.27,13.75,14.25,14.77,15.26,15.70,15.98,16.11,16.08,15.87,15.58,15.14,14.71,14.21,13.70,13.12,12.60,12,11.37,10.65,9.87,9,8.10,7.12,6.35,5.75,5.36,5.23,5.20,5.20,5.15,5.15,5.20,5.21,5.25,5.25,5.10,4.95,4.85,4.97,5.01,5,5.02,5.08,5.22,5.57,6.12,6.88,7.75,8.71,9.62,10.52,11.37,12.07,12.63,13.14,13.60,13.95,14.21,14.47,14.62,14.63,14.65,14.74,14.87,15.15,15.37,15.63,15.62,15.50,15.15,14.87,14.62,14.64,15.12,15.70,16.37,17.14,17.87,18.46,18.50,18.50,18.60,18.74,18.86,18.87,18.75,18.46,17.74,16.87,16.12,15.50,15,14.62,14.38,14.24,14.11,14,13.87,13.59,13,12.25,11.51,10.90,10.37,9.96,9.86,10.10,10.61,11.33,12.25,13.25,14.25,15.13,15.89,16.58,17.10,17.50,17.75,17.90,17.97,17.88,17.75,17,17,17,17,17,16,16,15,14,13,12,11,10,10,10,10.02,10.11,10.12,10.12,10.12,10.15,10.25,10.36,10.48,10.64,10.95,11.25,11.62,12,12.47,12.87,13.25,13.60,13.75,13.75,13.49,12.87,12,11.02,10,9.12,8.37,7.75,7.33,6.99,6.75,6.70,6.65,6.72,6.75,6.76,6.82,6.85,6.90,7.08,7.27,7.60,7.96,8.37,8.87,9.48,10.21,11,11.87,12.70,13.48,14.23,14.95,15.62,16.33,16.99,17.62,18.26,18.88,19.50,20.10,20.87,21,21,0.99,0.99,0.99,1,1,1.10,1.21,1.34,1.48,1.60,1.70,1.75,1.82,1.87,1.88,1.96,2,2,2.09,2.13,2.25,2.36,2.48,2.60,2.72,2.82,2.89,3,3.12,3.25,3.40,3.63,3.89,4.23,4.61,5.07,5.52,6.01,6.50,6.96,7.47,8.07,8.75,9.52,10.27,10.89,11.35,11.62,11.87,11.75,11.50,11.26,11.25,11.45,11.63,11.65,11.58,11.37,11.35,11.37,11.59,11.87,12.25,12.71,13.08,13.37,13.50,13.52,13.51,12.87,12.25,11.75,11.75,12.23,13,13.87,14.72,15.45,15.77,15.98,16,16.12,16.33,16.63,17.12,17.62,18.15,18.62,18.86,19.14,18.49,17.75,17,16.27,15.70,15.25,15,15.02,15.27,15.75,16.37,17.11,17.85,18.50,18.87,18.77,18.36,17.62,16.77,15.87,15.11,14.61,14.26,13.96,13.62,13.46,13.37,13.50,13.87,14.37,14.89,15.46,15.89,16.27,16.50,16.50,16.25,15.87,15.37,14.83,14.25,13.63,13.09,12.50,11.89,11.33,10.71,10,9.23,8.32,7.33,6.38,5.70,5.23,4.97,4.77,4.75,4.74,4.72,4.70,4.71,4.72,4.73,4.71,4.73,4.75,4.84,4.87,4.99,5,5.01,5.12,5.27,5.63,6.21,6.87,7.62,8.37,9.12,9.87,10.52,11.12,11.61,12,12.35,12.62,12.86,13.07,13.23,13.32,13.35,13.40,13.58,13.75,13.87,13.96,13.97,14,14.01,14,13.88,13.90,14.50,15,15.59,16.20,16.75,17.25,17.58,17.82,18.09,18.37,18.62,18.72,18.59,18.22,17.49,16.65,15.87,15.14,14.59,14.12,13.75,13.48,13.25,13.07,12.90,12.63,12.14,11.50,10.86,10.32,9.88,9.62,9.85,10.37,11.15,12.02,12.98,13.88,14.75,15.50,16.12,16.62,17,17.32,17.50,17.59,17.58,17.46,17.12,16.87,16,16,16,16,16,15,15,14,13,12,11,10,10,10.07,10.13,10.32,10.40,10.51,10.63,10.82,11,11.21,11.40,11.70,12,12.37,12.75,13.12,13.57,13.95,14.27,14.50,14.50,14.25,13.82,13.09,12.13,11.13,10.12,9.13,8.39,7.85,7.40,7.12,6.99,6.88,6.87,6.89,6.96,6.99,7,7.01,7.11,7.24,7.40,7.70,8,8.37,8.87,9.49,10.21,11,11.87,12.74,13.50,14.25,15,15.70,16.37,17,17.63,18.26,18.76,19.32,19.77,20,21,21,0.99,0.99,0.99,1,1,1.10,1.22,1.36,1.50,1.62,1.75,1.84,1.87,1.90,1.97,1.99,2,2.07,2.12,2.20,2.32,2.39,2.51,2.62,2.75,2.84,2.89,3,3.07,3.12,3.25,3.37,3.50,3.75,4.01,4.40,4.87,5.33,5.75,6.22,6.73,7.34,8,8.77,9.62,10.26,10.76,11.14,11.45,11.37,11.13,11.11,11.24,11.58,11.89,11.98,11.85,11.70,11.71,11.87,12.15,12.62,13.20,13.75,14.20,14.47,14.50,14.72,14.75,13.99,13.08,12.45,12.12,12.34,13,13.84,14.62,15.39,16.11,16.50,16.65,16.84,17,17.25,17.57,17.90,18.32,18.62,18.83,19.02,18.51,17.86,17.10,16.33,15.62,15.07,14.75,14.71,14.96,15.46,16.13,17,17.88,18.75,19.37,19.38,18.97,18.33,17.52,16.75,16.02,15.49,15,14.62,14.33,14.12,14.10,14.25,14.61,15.07,15.58,16.07,16.50,16.77,16.90,16.82,16.38,15.84,15.13,14.46,13.75,13.10,12.46,11.84,11.24,10.62,10,9.36,8.57,7.62,6.65,5.83,5.21,4.83,4.62,4.46,4.39,4.38,4.37,4.37,4.37,4.40,4.33,4.39,4.61,4.84,5,5.10,5.14,5.12,5.20,5.32,5.52,5.89,6.37,6.96,7.50,8.11,8.62,9.20,9.73,10.20,10.60,10.88,11.12,11.33,11.50,11.74,11.95,12.07,12,12.12,12.23,12.34,12.34,12.36,12.49,12.75,13.11,13.33,13.37,13.62,14.09,14.50,14.96,15.37,15.85,16.33,16.76,17.25,17.71,18.12,18.39,18.50,18.25,17.75,17.07,16.25,15.46,14.72,14.08,13.50,13.08,12.71,12.37,12.12,11.97,11.74,11.35,10.82,10.26,9.87,9.64,9.71,10.20,11,11.89,12.86,13.74,14.51,15.25,15.84,16.26,16.62,16.87,17,17.10,17.11,17.02,16.87,16.50,16,15.20,15.07,16,16,15,15,14,13,12,11,11,10.07,10.12,10.26,10.50,10.72,10.88,11.12,11.34,11.61,11.88,12.22,12.50,12.85,13.15,13.51,13.88,14.27,14.64,15,15.25,15.36,15.12,14.71,14.09,13.26,12.34,11.32,10.25,9.33,8.50,7.96,7.58,7.33,7.15,7.12,7.12,7.12,7.12,7.15,7.21,7.24,7.26,7.37,7.52,7.75,8.08,8.40,8.87,9.49,10.22,11.01,11.88,12.75,13.60,14.36,15.09,15.76,16.47,17.11,17.72,18.25,18.65,19.10,19.07,20,21,21,0.99,0.99,0.99,0.99,1,1.10,1.21,1.35,1.50,1.63,1.75,1.87,1.90,1.98,2,2,2.01,2.09,2.12,2.23,2.34,2.45,2.52,2.62,2.75,2.84,2.87,2.96,3,3.02,3.10,3.13,3.24,3.37,3.58,3.87,4.24,4.62,5,5.40,5.89,6.50,7.15,7.88,8.65,9.35,9.86,10.25,10.48,10.38,10.35,10.37,10.62,11.01,11.46,11.52,11.49,11.40,11.49,11.70,12.10,12.62,13.32,13.98,14.45,14.63,14.70,14.75,14.99,14.40,13.62,13,12.62,12.64,13.02,13.71,14.47,15.27,16.07,16.72,17.13,17.37,17.52,17.71,17.86,18.01,18.23,18.37,18.50,18.52,18.25,17.65,16.96,16.12,15.37,14.75,14.37,14.34,14.58,15.10,15.86,16.76,17.77,18.77,19.63,19.83,19.50,19.01,18.37,17.63,16.97,16.37,15.86,15.40,15.08,14.86,14.84,15,15.33,15.73,16.12,16.49,16.87,17.09,17.12,16.88,16.40,15.72,14.88,14.08,13.25,12.50,11.82,11.13,10.50,9.89,9.26,8.62,7.83,6.97,6.11,5.37,4.86,4.52,4.37,4.25,4.25,4.26,4.26,4.32,4.37,4.40,4.37,4.62,4.97,5.27,5.46,5.50,5.59,5.62,5.63,5.76,6.10,6.47,6.85,7.25,7.64,8.07,8.37,8.72,9.09,9.46,9.75,10,10.12,10.23,10.36,10.52,10.76,10.96,11.02,11,11,11,11.11,11.25,11.37,12.07,12.58,12.89,13.26,13.61,13.95,14.25,14.59,14.87,15.21,15.74,16.25,16.86,17.39,17.87,18.15,18.21,17.82,17.23,16.48,15.64,14.87,14.12,13.45,12.85,12.34,11.87,11.51,11.23,11,10.83,10.51,10.14,9.84,9.62,9.73,10.11,10.82,11.73,12.72,13.62,14.47,15.12,15.72,16.12,16.38,16.52,16.60,16.60,16.57,16.50,16.45,16.21,15.86,15.33,14.87,14.75,14.87,15,15,14,13,13,11,11,10,10.22,10.38,10.72,11,11.27,11.58,11.85,12.12,12.49,12.87,13.26,13.65,14.01,14.37,14.74,15.09,15.39,15.74,15.98,16.10,16,15.62,15.09,14.36,13.49,12.50,11.49,10.48,9.51,8.71,8.12,7.74,7.50,7.37,7.36,7.36,7.37,7.37,7.37,7.39,7.45,7.49,7.52,7.65,7.87,8.12,8.46,8.87,9.49,10.22,11.01,11.90,12.82,13.63,14.46,15.21,15.89,16.61,17.25,17.77,18.26,18.72,19.11,19,20,20,21,0.99,0.99,0.99,0.99,1,1.08,1.14,1.32,1.47,1.62,1.75,1.87,1.96,2,2,2.01,2.07,2.10,2.12,2.22,2.32,2.38,2.50,2.60,2.70,2.75,2.85,2.87,2.89,2.96,2.99,3,3.02,3.12,3.25,3.46,3.72,4,4.34,4.72,5.12,5.65,6.26,6.96,7.62,8.25,8.72,9.11,9.22,9.21,9.21,9.33,9.61,10,10.37,10.52,10.62,10.70,10.77,11,11.37,11.90,12.61,13.32,13.75,13.96,13.89,13.90,14.11,14.10,13.87,13.33,12.99,12.87,13.09,13.57,14.25,15.12,15.99,16.75,17.33,17.63,17.87,17.88,17.87,17.87,17.88,17.98,18,18,17.77,17.35,16.64,15.87,15.11,14.47,14.09,14,14.23,14.75,15.50,16.50,17.52,18.59,19.49,19.96,20,19.72,19.12,18.49,17.83,17.21,16.63,16.22,15.86,15.63,15.62,15.75,16.01,16.35,16.62,16.83,16.90,16.99,17,16.75,16.25,15.50,14.62,13.70,12.76,11.95,11.15,10.48,9.82,9.15,8.51,7.84,7.09,6.32,5.58,5,4.61,4.37,4.35,4.27,4.39,4.50,4.60,4.64,4.76,4.89,5.02,5.37,5.73,6.02,6.15,6.22,6.25,6.34,6.50,6.75,7,7.37,7.64,7.96,8.15,8.37,8.50,8.64,8.86,9.08,9.25,9.37,9.40,9.47,9.51,9.71,9.87,10.02,10.15,10.27,10.33,10.33,10.27,10.87,11.12,11.99,12.37,13,13.37,13.75,14.01,14.26,14.50,14.71,15,15.40,15.99,16.59,17.12,17.58,17.77,17.62,17.15,16.50,15.75,14.95,14.12,13.37,12.72,12.10,11.51,11.08,10.65,10.34,10.12,9.96,9.75,9.62,9.50,9.62,10,10.62,11.47,12.46,13.47,14.37,15.12,15.72,16.12,16.37,16.45,16.37,16.23,16.07,15.90,15.82,15.72,15.50,15.15,14.62,14.22,13.99,13.99,13.99,14,13,12,12,11,11,10.87,10.72,10.88,11.23,11.62,12,12.35,12.64,13,13.39,13.87,14.34,14.75,15.12,15.47,15.75,16.07,16.34,16.57,16.71,16.70,16.48,16,15.37,14.58,13.64,12.65,11.62,10.62,9.73,8.95,8.27,7.89,7.71,7.62,7.59,7.59,7.62,7.62,7.62,7.62,7.62,7.63,7.72,7.77,7.95,8.12,8.47,8.87,9.48,10.21,11.01,11.95,12.85,13.74,14.57,15.35,16.09,16.75,17.40,18,18.46,18.87,19,20,20,20,20,0.99,0.99,0.99,0.99,1,1.07,1.12,1.25,1.40,1.60,1.75,1.87,1.96,2,2.01,2.02,2.07,2.09,2.12,2.15,2.25,2.35,2.39,2.50,2.59,2.62,2.72,2.75,2.77,2.85,2.87,2.88,2.90,2.97,3,3.12,3.27,3.50,3.75,4.07,4.40,4.87,5.38,5.99,6.58,7.09,7.47,7.75,7.84,7.86,7.87,8.07,8.35,8.71,9.01,9.27,9.48,9.62,9.75,9.99,10.34,10.82,11.37,12,12.49,12.64,12.65,12.75,12.96,13.22,13.40,13.32,13.11,13.07,13.12,13.48,14.12,15,15.87,16.61,17.21,17.60,17.75,17.74,17.60,17.47,17.37,17.37,17.38,17.40,17.26,16.90,16.35,15.60,14.85,14.22,13.83,13.73,13.95,14.45,15.22,16.13,17.21,18.23,19.10,19.83,20.20,20.11,19.71,19.14,18.57,17.90,17.37,16.90,16.57,16.37,16.35,16.48,16.70,16.87,17,16.98,16.87,16.75,16.59,16.39,15.96,15.22,14.32,13.33,12.35,11.38,10.57,9.77,9.11,8.45,7.75,7.07,6.36,5.64,5.10,4.64,4.39,4.35,4.45,4.62,4.95,5.24,5.40,5.59,5.76,5.95,6.25,6.60,6.87,7.08,7.15,7.20,7.24,7.35,7.59,7.90,8.27,8.60,8.75,8.88,9,9.09,9.12,9.12,9.10,9.07,9.01,9.09,9.10,9.11,9.12,9.22,9.33,9.38,9.62,9.86,10.07,10,10.10,10.98,11.89,12.12,12.96,13.45,13.76,14.09,14.33,14.50,14.62,14.75,14.98,15.33,15.75,16.27,16.75,17.08,17.12,16.87,16.37,15.70,14.88,14.11,13.32,12.58,11.87,11.25,10.72,10.24,9.85,9.50,9.32,9.22,9.14,9.21,9.37,9.75,10.36,11.12,12.09,13.10,14.10,14.98,15.64,16.13,16.45,16.48,16.33,16.02,15.75,15.46,15.23,15.01,14.88,14.83,14.50,13.87,13.34,13,13,13,12.87,12,11,11,11,11,11,11.12,11.37,11.77,12.27,12.75,13.14,13.51,13.88,14.32,14.75,15.15,15.59,15.95,16.25,16.51,16.76,17.07,17.21,17.24,17.12,16.77,16.25,15.58,14.74,13.77,12.77,11.75,10.75,9.84,9.07,8.39,8.07,7.87,7.76,7.75,7.75,7.83,7.82,7.77,7.77,7.77,7.82,7.85,7.87,8,8.15,8.47,8.87,9.46,10.13,11,11.88,12.87,13.77,14.65,15.50,16.25,16.98,17.62,18.25,18.65,19.11,20,20,20,20,20,0.99,0.99,0.99,0.99,1,1.07,1.12,1.25,1.39,1.59,1.74,1.87,1.96,2,2.02,2.07,2.07,2.08,2.11,2.12,2.20,2.25,2.33,2.37,2.45,2.50,2.52,2.60,2.62,2.70,2.74,2.75,2.76,2.77,2.84,2.87,2.98,3.11,3.25,3.50,3.76,4.12,4.51,5,5.50,5.88,6.24,6.37,6.47,6.50,6.59,6.75,7,7.32,7.62,7.88,8.12,8.33,8.50,8.72,9,9.47,9.99,10.50,10.99,11.25,11.37,11.40,11.83,12.23,12.52,12.75,12.99,13.12,13.34,13.70,14.25,15,15.75,16.38,16.87,17.20,17.25,17.13,16.98,16.83,16.75,16.73,16.75,16.77,16.74,16.48,16,15.34,14.62,14,13.62,13.50,13.72,14.15,14.87,15.77,16.76,17.75,18.62,19.32,19.83,20,19.83,19.49,19.01,18.50,17.97,17.49,17.12,16.95,16.90,17.02,17.24,17.33,17.22,16.96,16.62,16.37,16.12,15.86,15.51,14.87,13.97,12.96,11.87,10.87,9.98,9.12,8.37,7.70,7,6.33,5.65,5.12,4.71,4.45,4.34,4.39,4.70,5.09,5.62,6.12,6.57,6.87,7.12,7.37,7.65,7.97,8.15,8.32,8.37,8.37,8.47,8.62,8.95,9.35,9.74,10.02,10.25,10.26,10.32,10.34,10.34,10.22,9.87,9.52,9.33,9.33,9.33,9.33,9.35,9.37,9.37,9.39,9.50,9.75,9.97,10,10,11.01,12.10,13.08,13.82,14.14,14.39,14.62,14.77,14.87,14.88,14.95,15.01,15.25,15.57,15.89,16.23,16.37,16.27,15.99,15.45,14.75,13.98,13.14,12.37,11.64,11,10.38,9.87,9.40,9.08,8.75,8.63,8.63,8.75,8.98,9.37,9.99,10.74,11.62,12.60,13.61,14.58,15.45,16.09,16.40,16.50,16.34,16,15.61,15.20,14.82,14.49,14.25,14.07,13.90,13.62,13.12,12.58,12.23,12.11,12,11.75,11.07,11,11,11,11,11.12,11.37,11.89,12.48,13.01,13.52,14,14.37,14.75,15.12,15.52,15.95,16.32,16.63,16.96,17.22,17.39,17.52,17.59,17.61,17.37,16.98,16.37,15.63,14.76,13.84,12.83,11.75,10.75,9.85,9.09,8.50,8.12,7.97,7.87,7.87,7.87,7.90,7.89,7.88,7.87,7.87,7.88,7.89,7.96,8,8.20,8.46,8.86,9.37,10.09,10.87,11.84,12.82,13.82,14.75,15.61,16.37,17.12,17.82,18.50,18.87,19.21,20,20,20,20,21,0.99,0.99,0.99,1,1.01,1.11,1.20,1.32,1.46,1.62,1.75,1.87,1.98,2,2.07,2.08,2.08,2.08,2.09,2.11,2.12,2.20,2.24,2.25,2.27,2.36,2.37,2.45,2.49,2.50,2.57,2.60,2.61,2.62,2.62,2.62,2.71,2.75,2.87,3.01,3.22,3.47,3.75,4.12,4.49,4.77,5,5.12,5.20,5.24,5.33,5.49,5.71,5.97,6.25,6.50,6.75,6.96,7.12,7.37,7.64,8.02,8.50,9,9.49,9.84,10.11,10.37,10.75,11.14,11.57,12,12.51,13.09,13.45,13.86,14.37,15,15.62,16.13,16.49,16.59,16.50,16.37,16.21,16.07,15.99,16,16.07,16.12,16.14,16,15.62,15.11,14.48,13.88,13.50,13.37,13.50,13.90,14.59,15.38,16.34,17.25,18.08,18.74,19.12,19.37,19.45,19.35,19.11,18.75,18.25,17.82,17.49,17.34,17.34,17.45,17.59,17.51,17.22,16.73,16.25,15.87,15.59,15.33,14.90,14.47,13.58,12.50,11.40,10.37,9.37,8.50,7.71,6.97,6.25,5.63,5.12,4.72,4.45,4.33,4.37,4.62,5.09,5.64,6.45,7.21,7.83,8.25,8.62,8.87,9.12,9.39,9.51,9.62,9.70,9.75,9.89,10.13,10.50,10.87,11.25,11.62,11.87,12,12,12,11.87,11.52,10.87,10.33,10,10,10,10,10,10,10,10,10.11,10.22,10.27,10.11,10.98,11.95,12.87,13.86,14.82,15.12,15.33,15.46,15.45,15.37,15.25,15.13,15.11,15.12,15.25,15.38,15.51,15.51,15.37,15,14.45,13.75,12.99,12.21,11.46,10.75,10.12,9.58,9.11,8.73,8.38,8.23,8.21,8.32,8.60,9,9.59,10.26,11.11,12,12.98,13.95,14.87,15.70,16.25,16.48,16.36,16,15.58,15.09,14.61,14.14,13.75,13.48,13.15,13.02,12.83,12.48,12,11.65,11.40,11.33,11.22,11.11,11,11,11,11.12,11.40,11.97,12.51,13.22,13.83,14.37,14.84,15.24,15.61,15.97,16.33,16.64,17,17.25,17.50,17.75,17.87,17.98,17.90,17.75,17.45,17,16.37,15.62,14.73,13.75,12.73,11.65,10.64,9.75,9,8.47,8.12,8,7.96,7.95,7.95,7.98,7.97,7.96,7.96,7.96,7.96,7.96,7.98,8.01,8.15,8.39,8.76,9.26,9.95,10.74,11.64,12.64,13.71,14.70,15.52,16.34,17.08,17.76,18.62,18.99,19.11,19,20,20,20,21,0.99,0.99,1,1.01,1.10,1.14,1.25,1.38,1.52,1.70,1.84,1.95,2,2.07,2.10,2.10,2.09,2.09,2.10,2.12,2.12,2.14,2.20,2.21,2.25,2.26,2.33,2.36,2.37,2.39,2.45,2.46,2.46,2.46,2.47,2.48,2.50,2.50,2.59,2.62,2.75,2.87,3.12,3.36,3.62,3.82,3.98,4.07,4.11,4.12,4.23,4.37,4.52,4.76,5,5.25,5.45,5.62,5.87,6.10,6.37,6.70,7.11,7.59,8.02,8.48,8.87,9.25,9.64,10.07,10.50,11.09,11.87,12.73,13.37,13.89,14.37,14.89,15.37,15.75,15.88,15.85,15.71,15.50,15.33,15.21,15.13,15.21,15.34,15.50,15.62,15.60,15.36,14.90,14.37,13.85,13.45,13.25,13.33,13.62,14.23,14.98,15.83,16.64,17.39,18,18.37,18.62,18.74,18.82,18.76,18.61,18.23,17.87,17.60,17.49,17.50,17.62,17.72,17.51,17.02,16.37,15.76,15.26,14.90,14.65,14.36,13.87,13.10,12,10.87,9.75,8.75,7.84,7,6.26,5.62,5.11,4.71,4.46,4.33,4.36,4.57,4.99,5.62,6.37,7.32,8.25,9.07,9.70,10.12,10.38,10.61,10.74,10.85,10.89,11.01,11.21,11.39,11.71,12.02,12.46,12.86,13.22,13.50,13.87,14,13.87,13.63,12.99,12.11,11.33,11,11,11,11,11,11,11,11,11,11,11,11.10,11,12.08,13.11,14.84,15.21,16.75,16.59,16.37,16.13,15.87,15.61,15.34,15.11,14.96,14.87,14.84,14.75,14.63,14.38,14,13.40,12.75,12,11.24,10.50,9.85,9.25,8.76,8.39,8.13,7.97,7.90,8.01,8.27,8.73,9.26,9.96,10.65,11.49,12.35,13.24,14.12,15,15.75,16.25,16.37,16.11,15.62,15.10,14.52,14,13.57,13.13,12.75,12.50,12.37,12.25,12.10,11.82,11.46,11.12,11,11,11,11,11,11,11.36,12,12.62,13.33,14,14.63,15.23,15.64,16.07,16.38,16.75,17.09,17.37,17.63,17.87,18.08,18.22,18.25,18.26,18.14,17.89,17.50,16.90,16.27,15.48,14.52,13.57,12.51,11.50,10.50,9.62,8.87,8.39,8.10,8,7.98,7.97,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.99,8.01,8.13,8.37,8.71,9.13,9.75,10.50,11.40,12.40,13.48,14.47,15.33,16.08,16.77,17.50,18.32,18.63,18.75,19,19,20,20,20,0.99,1,1,1.09,1.14,1.25,1.38,1.57,1.71,1.84,1.95,2,2.10,2.12,2.12,2.12,2.12,2.13,2.13,2.14,2.20,2.24,2.24,2.25,2.34,2.37,2.38,2.40,2.47,2.48,2.49,2.47,2.40,2.39,2.45,2.40,2.38,2.37,2.37,2.38,2.45,2.50,2.62,2.75,2.87,3.01,3.12,3.21,3.23,3.25,3.36,3.49,3.63,3.87,4.07,4.23,4.36,4.50,4.75,4.99,5.23,5.48,5.83,6.24,6.72,7.14,7.62,8.09,8.50,8.88,9.37,10.07,10.87,11.75,12.60,13.46,14.09,14.52,14.85,15.10,15.13,15,14.83,14.61,14.39,14.27,14.26,14.37,14.60,14.87,15.12,15.23,15.12,14.82,14.34,13.83,13.37,13.12,13.10,13.35,13.83,14.49,15.24,16,16.65,17.22,17.58,17.77,17.95,18.07,18.21,18.12,17.90,17.64,17.48,17.39,17.50,17.62,17.63,17.37,16.75,15.98,15.23,14.62,14.21,13.90,13.62,13.12,12.40,11.33,10.14,9.02,8.02,7.13,6.37,5.70,5.12,4.71,4.45,4.33,4.36,4.51,4.90,5.50,6.32,7.15,8.24,9.26,10.27,11.15,11.74,11.98,12,11.98,12,12.12,12.34,12.61,12.87,13.21,13.50,13.88,14.27,14.63,14.99,15.32,15.63,15.40,15,14.11,13.11,12.33,12,12,12,12,12,12,12,12,12,12,11.87,11.75,11.87,12.08,13.12,14.15,15.76,16.73,17.47,17.21,16.72,16.25,15.84,15.38,15,14.65,14.38,14.20,13.99,13.75,13.45,13,12.45,11.75,11,10.25,9.60,9,8.50,8.12,7.87,7.76,7.77,7.90,8.22,8.62,9.14,9.82,10.49,11.20,11.90,12.70,13.48,14.25,15.01,15.70,16.12,16.15,15.84,15.26,14.63,14.02,13.50,13.10,12.62,12.32,12.15,12.08,12.07,11.95,11.71,11.36,11,11,11,11,11.10,11,11.12,12.10,12.76,13.48,14.14,14.87,15.50,16.08,16.50,16.86,17.21,17.51,17.85,18.12,18.33,18.49,18.60,18.62,18.62,18.50,18.34,17.99,17.50,16.87,16.12,15.25,14.34,13.35,12.34,11.33,10.37,9.50,8.84,8.37,8.09,8,7.98,7.98,7.99,7.99,7.98,7.98,7.98,7.98,7.98,7.98,7.99,8,8.12,8.27,8.61,9,9.58,10.25,11.12,12.11,13.09,14.02,14.87,15.62,16.27,16.99,17.75,18.22,18.33,19,19,19,20,20,0.99,1,1.02,1.12,1.25,1.39,1.59,1.75,1.87,2,2.12,2.14,2.22,2.24,2.25,2.25,2.25,2.26,2.26,2.32,2.34,2.37,2.40,2.50,2.59,2.63,2.71,2.75,2.75,2.75,2.75,2.72,2.65,2.62,2.62,2.62,2.51,2.46,2.37,2.35,2.33,2.33,2.35,2.35,2.39,2.50,2.57,2.59,2.59,2.62,2.73,2.87,3.02,3.25,3.38,3.51,3.62,3.73,3.88,4.12,4.26,4.49,4.75,5.10,5.50,5.95,6.40,6.87,7.27,7.73,8.25,8.98,9.75,10.62,11.49,12.37,13.12,13.63,13.97,14.23,14.25,14.15,13.97,13.72,13.49,13.37,13.37,13.51,13.87,14.25,14.62,14.89,14.97,14.75,14.34,13.83,13.34,12.99,12.86,12.98,13.36,13.89,14.59,15.25,15.87,16.35,16.65,16.88,17.10,17.25,17.47,17.51,17.46,17.27,17.14,17.13,17.25,17.37,17.46,17.12,16.37,15.50,14.62,13.87,13.38,13.07,12.75,12.25,11.48,10.48,9.33,8.24,7.25,6.46,5.75,5.15,4.73,4.45,4.33,4.36,4.52,4.89,5.50,6.25,7.12,8.11,9.22,10.40,11.62,12.75,13.52,13.60,13.32,13.12,13.09,13.25,13.51,13.87,14.25,14.57,14.86,15.14,15.51,15.87,16.23,16.50,16.87,16.52,16,15,14,13.22,13,13,13,13,13,13.11,13.22,13.33,13.33,13.22,12.87,12.37,12.20,12.87,13.12,14.12,15.23,16.62,17.34,17.37,16.88,16.36,15.82,15.25,14.75,14.27,13.87,13.50,13.15,12.86,12.49,12,11.47,10.77,10.10,9.37,8.75,8.25,7.87,7.62,7.57,7.61,7.86,8.24,8.64,9.21,9.84,10.50,11.13,11.82,12.47,13.11,13.75,14.40,15.09,15.62,15.98,15.98,15.61,15,14.27,13.65,13.14,12.75,12.37,12.10,12,12,12,11.96,11.83,11.59,11.24,11.12,11,11.10,11.27,11.75,12.25,12.89,13.64,14.37,15.09,15.75,16.38,16.88,17.32,17.62,17.98,18.32,18.61,18.84,18.99,19.08,19.11,19.07,18.96,18.75,18.46,18.01,17.50,16.83,16,15.12,14.12,13.13,12.14,11.20,10.25,9.46,8.76,8.37,8.08,8,7.99,7.98,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8.08,8.24,8.50,8.87,9.37,10.01,10.84,11.72,12.62,13.51,14.35,15,15.70,16.37,17,17.52,18,18,19,19,19,19,0.99,1,1.07,1.15,1.37,1.58,1.76,1.99,2.12,2.25,2.34,2.37,2.37,2.39,2.45,2.46,2.48,2.50,2.50,2.50,2.58,2.71,2.76,2.87,3,3.12,3.22,3.25,3.32,3.33,3.33,3.25,3.25,3.22,3.14,3.07,2.87,2.73,2.59,2.48,2.37,2.27,2.20,2.15,2.20,2.22,2.24,2.23,2.23,2.25,2.35,2.49,2.63,2.85,3,3.11,3.15,3.25,3.37,3.50,3.61,3.74,3.95,4.21,4.40,4.87,5.36,5.75,6.12,6.50,7.12,7.87,8.62,9.40,10.25,11.09,11.84,12.47,12.96,13.25,13.39,13.36,13.12,12.86,12.59,12.46,12.40,12.73,13.13,13.65,14.21,14.62,14.87,14.73,14.36,13.84,13.26,12.85,12.59,12.58,12.83,13.26,13.87,14.49,15,15.46,15.75,16,16.22,16.39,16.62,16.83,16.86,16.76,16.72,16.73,16.86,17,17.09,16.75,15.99,15,14,13.13,12.61,12.20,11.82,11.32,10.50,9.50,8.37,7.33,6.47,5.75,5.21,4.75,4.46,4.32,4.35,4.50,4.90,5.50,6.24,7.11,8.07,9.08,10.25,11.58,13.11,14.45,15.33,15.08,14.51,14.12,14.02,14.25,14.61,15,15.45,15.72,15.97,16.25,16.57,16.88,17.24,17.49,17.64,17.33,16.52,15.52,14.63,14,13.75,13.75,13.87,14,14.11,14.33,14.52,14.63,14.63,14.40,13.87,13.22,12.87,12.87,13.12,14,15.10,16.12,17.25,17.02,16.60,16.07,15.49,14.87,14.34,13.75,13.25,12.75,12.36,11.97,11.52,11.08,10.50,9.87,9.22,8.59,8.01,7.62,7.38,7.35,7.47,7.75,8.15,8.70,9.34,9.97,10.62,11.26,11.95,12.51,13.10,13.62,14.14,14.72,15.23,15.62,15.87,15.82,15.40,14.75,14.07,13.34,12.99,12.71,12.37,12.11,12.10,12.09,12.08,12.14,12.13,12,11.70,11.34,11.22,11.35,11.83,12.40,13.12,13.88,14.62,15.34,16,16.63,17.25,17.73,18.10,18.38,18.73,19.02,19.33,19.50,19.62,19.62,19.52,19.38,19.21,18.89,18.52,18.08,17.48,16.75,15.95,15,14.07,13.07,12.09,11.12,10.23,9.40,8.76,8.36,8.08,8,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8,7.99,7.99,8,8.01,8.14,8.37,8.75,9.23,9.82,10.50,11.33,12.12,12.96,13.70,14.37,15.08,15.75,16.45,17.22,17.75,18,18,19,19,19,0.99,1,1.10,1.25,1.50,1.75,2,2.25,2.45,2.52,2.60,2.62,2.62,2.63,2.65,2.72,2.75,2.82,2.87,2.89,3,3.12,3.25,3.45,3.62,3.75,3.87,3.97,4,4.02,4.08,4.09,4.07,4,3.87,3.73,3.49,3.23,2.99,2.75,2.58,2.38,2.25,2.20,2.13,2.12,2.12,2.11,2.09,2.10,2.12,2.25,2.38,2.58,2.73,2.83,2.87,2.89,2.98,3.01,3.12,3.22,3.36,3.48,3.70,4,4.39,4.75,5.08,5.38,6.01,6.75,7.48,8.24,9.01,9.87,10.62,11.36,11.97,12.38,12.62,12.62,12.37,12.09,11.75,11.50,11.57,11.87,12.47,13.10,13.75,14.32,14.75,14.75,14.37,13.84,13.23,12.65,12.25,12.11,12.25,12.62,13.12,13.64,14.12,14.51,14.85,15.10,15.32,15.52,15.82,16.08,16.21,16.22,16.13,16.13,16.25,16.39,16.50,16.25,15.50,14.49,13.45,12.50,11.84,11.33,10.84,10.25,9.48,8.46,7.36,6.37,5.62,5.12,4.73,4.46,4.33,4.34,4.50,4.88,5.48,6.23,7.09,8,9,10.08,11.23,12.62,14.21,15.62,16.62,16.26,15.58,15,14.90,15.12,15.50,15.89,16.36,16.62,16.87,17.12,17.46,17.75,18.08,18.23,18.12,17.75,16.87,16,15.22,14.63,14.40,14.40,14.63,14.87,15.22,15.52,15.87,16,16,15.63,15,14.11,13.32,13.10,13.12,14,14.87,15.71,16.21,16.26,15.98,15.48,14.87,14.32,13.72,13.12,12.51,12,11.50,11.07,10.61,10.12,9.59,9,8.38,7.87,7.47,7.22,7.12,7.25,7.59,8.07,8.63,9.34,10.02,10.75,11.49,12.13,12.75,13.34,13.84,14.25,14.71,15.12,15.49,15.75,15.86,15.73,15.34,14.62,13.76,13.24,12.97,12.75,12.58,12.40,12.39,12.38,12.38,12.61,12.72,12.73,12.26,11.76,11.57,11.83,12.40,13.22,14.01,14.87,15.62,16.25,16.87,17.49,18.01,18.49,18.84,19.12,19.39,19.72,19.95,20.09,20.12,20.01,19.87,19.62,19.36,19,18.60,18.08,17.46,16.72,15.87,14.99,14,13.01,12.08,11.12,10.25,9.46,8.82,8.35,8.07,8,7.99,7.99,7.99,7.99,8,8,8.01,8.02,8.02,8.01,8,8,8.07,8.12,8.35,8.62,9.08,9.61,10.24,10.95,11.64,12.37,13.10,13.77,14.52,15.34,16.12,16.87,17.70,18,18,18,18,18,1,1.01,1.12,1.36,1.62,1.87,2.14,2.45,2.63,2.76,2.85,2.87,2.89,2.97,3,3.08,3.12,3.24,3.34,3.45,3.57,3.72,3.87,4.10,4.27,4.47,4.62,4.73,4.82,4.87,4.95,4.99,5,4.95,4.76,4.52,4.23,3.87,3.50,3.22,2.95,2.72,2.50,2.36,2.25,2.22,2.20,2.12,2.12,2.10,2.10,2.12,2.24,2.36,2.48,2.57,2.61,2.62,2.62,2.64,2.72,2.76,2.87,3.02,3.21,3.37,3.64,3.87,4.08,4.38,5,5.71,6.37,7.12,7.95,8.75,9.60,10.37,11.09,11.62,11.95,11.97,11.75,11.37,10.96,10.70,10.73,11.11,11.75,12.50,13.25,13.97,14.50,14.70,14.37,13.75,13.12,12.49,11.98,11.62,11.62,11.99,12.38,12.87,13.27,13.64,13.98,14.21,14.40,14.74,15.02,15.34,15.57,15.62,15.57,15.50,15.51,15.63,15.73,15.50,14.87,13.87,12.86,11.87,11.12,10.49,9.87,9.24,8.37,7.37,6.32,5.47,4.88,4.61,4.38,4.32,4.37,4.52,4.88,5.46,6.14,7,7.97,8.96,9.99,11,12.13,13.50,14.99,16.40,17.32,17.07,16.46,15.87,15.74,15.88,16.25,16.62,16.98,17.25,17.50,17.76,18.12,18.45,18.65,18.71,18.45,18,17.11,16.33,15.75,15.33,15.11,15.11,15.40,15.75,16.33,16.63,17,17,16.87,16.40,15.75,14.87,14.24,13.87,13.12,14,14.75,15.12,15.47,15.49,15.22,14.74,14.14,13.58,12.97,12.36,11.75,11.14,10.62,10.12,9.65,9.22,8.72,8.21,7.72,7.32,7.02,6.98,7.09,7.37,7.87,8.50,9.25,10,10.84,11.62,12.39,13.09,13.65,14.20,14.63,15,15.33,15.62,15.88,16,15.99,15.75,15.25,14.50,13.65,13.24,13.10,13,12.99,12.99,13.07,13.10,13.09,13.26,13.39,13.37,12.97,12.46,12.25,12.50,13.21,14.01,15,15.87,16.57,17.12,17.71,18.25,18.75,19.20,19.50,19.75,20,20.25,20.39,20.49,20.39,20.25,20,19.72,19.37,19,18.52,18,17.37,16.62,15.77,14.89,14,13.02,12.10,11.13,10.25,9.48,8.77,8.34,8.02,7.99,7.99,7.99,7.99,8,8.01,8.09,8.12,8.15,8.15,8.14,8.12,8.12,8.13,8.23,8.37,8.62,8.98,9.45,10,10.62,11.24,11.87,12.51,13.26,14.12,15.02,15.98,16.75,17.25,18,18,18,18,18,1,1.07,1.22,1.46,1.72,2,2.25,2.58,2.77,2.95,3.02,3.12,3.22,3.26,3.37,3.46,3.58,3.71,3.86,4,4.13,4.34,4.50,4.75,4.97,5.12,5.37,5.48,5.60,5.74,5.87,5.97,6.02,5.98,5.76,5.46,5.02,4.62,4.24,3.87,3.52,3.21,2.85,2.65,2.50,2.45,2.37,2.34,2.25,2.20,2.12,2.11,2.12,2.22,2.26,2.34,2.37,2.36,2.35,2.35,2.35,2.40,2.58,2.71,2.85,2.97,3.12,3.25,3.37,3.62,4.13,4.75,5.38,6.12,6.96,7.83,8.64,9.50,10.26,10.87,11.23,11.32,11.12,10.71,10.23,9.90,9.97,10.37,11.07,11.88,12.76,13.59,14.22,14.50,14.25,13.64,12.96,12.25,11.63,11.22,11.12,11.35,11.74,12.12,12.50,12.87,13.12,13.37,13.64,14,14.37,14.74,15,15.11,15,14.83,14.73,14.75,14.76,14.62,14.11,13.25,12.25,11.25,10.37,9.63,8.96,8.20,7.26,6.33,5.32,4.71,4.37,4.25,4.25,4.37,4.59,4.95,5.47,6.12,6.90,7.83,8.77,9.86,10.95,11.98,13.08,14.33,15.64,16.99,17.87,17.75,17.14,16.65,16.50,16.62,16.87,17.12,17.34,17.50,17.75,18.07,18.45,18.75,19,18.90,18.62,18.11,17.33,16.75,16.33,16.11,16,16,16.22,16.52,17.22,17.63,18,17.87,17.52,16.99,16.33,15.52,14.87,14.10,14,14,14.25,14.62,14.77,14.74,14.40,13.97,13.37,12.75,12.12,11.50,10.87,10.26,9.75,9.25,8.76,8.36,7.89,7.50,7.14,6.90,6.85,6.95,7.24,7.71,8.33,9.07,9.87,10.75,11.62,12.50,13.26,13.90,14.48,14.95,15.38,15.74,16,16.25,16.37,16.32,16.10,15.75,15.21,14.57,13.87,13.57,13.46,13.45,13.60,13.77,13.96,14.01,14.08,14.12,14.25,14.02,13.50,13,12.83,13.25,13.99,14.87,15.89,16.74,17.37,17.90,18.47,18.99,19.46,19.83,20.08,20.25,20.40,20.59,20.64,20.62,20.50,20.24,19.89,19.59,19.23,18.85,18.37,17.86,17.22,16.48,15.64,14.83,13.95,13,12.12,11.15,10.26,9.48,8.77,8.32,8,7.99,7.99,8,8,8.07,8.12,8.24,8.33,8.37,8.37,8.37,8.37,8.36,8.37,8.37,8.50,8.63,8.97,9.37,9.84,10.35,10.87,11.45,12.12,12.87,13.75,14.75,15.87,16.57,17,17,17,17,17,17,1,1.12,1.32,1.52,1.83,2.10,2.37,2.63,2.88,3.11,3.25,3.37,3.50,3.62,3.74,3.87,4,4.21,4.37,4.59,4.75,4.89,5.11,5.32,5.50,5.64,5.87,6,6.22,6.46,6.64,6.77,6.98,6.87,6.62,6.25,5.87,5.46,5.08,4.71,4.33,3.87,3.47,3.10,2.85,2.75,2.71,2.62,2.50,2.37,2.23,2.12,2.12,2.13,2.21,2.24,2.21,2.12,2,2,2,2.12,2.23,2.40,2.51,2.62,2.65,2.76,2.87,3.14,3.50,3.97,4.50,5.21,6,6.87,7.76,8.64,9.40,10,10.39,10.65,10.39,9.87,9.39,9.12,9.22,9.62,10.37,11.26,12.24,13.12,13.84,14.14,14,13.46,12.72,12,11.37,10.87,10.72,10.83,11.11,11.46,11.84,12.15,12.48,12.75,13.02,13.39,13.86,14.27,14.62,14.73,14.50,14.21,13.90,13.84,13.83,13.65,13.25,12.50,11.58,10.59,9.64,8.83,8,7.14,6.25,5.37,4.57,4.25,4.12,4.14,4.34,4.62,5.01,5.52,6.14,6.87,7.65,8.59,9.58,10.62,11.75,12.83,13.87,15.01,16.24,17.40,18.21,18.23,17.77,17.39,17.23,17.25,17.37,17.45,17.48,17.50,17.63,17.87,18.26,18.62,18.90,18.90,18.74,18.33,17.75,17.22,17,16.87,17,17,17.11,17.40,18,18.40,18.63,18.40,18,17.33,16.75,16.11,15.37,14.89,14.12,14.13,14.12,14.23,14.23,14.02,13.70,13.15,12.59,11.95,11.25,10.62,10,9.38,8.87,8.37,7.97,7.60,7.25,7,6.82,6.75,6.86,7.12,7.58,8.13,8.86,9.62,10.50,11.38,12.35,13.26,14.09,14.64,15.13,15.60,16,16.33,16.58,16.75,16.73,16.52,16.23,15.83,15.35,14.87,14.46,14.23,14.12,14.12,14.39,14.74,15,15.01,15,14.89,14.82,14.37,13.87,13.47,13.39,14,14.75,15.62,16.57,17.36,18,18.61,19.13,19.64,20.10,20.37,20.50,20.60,20.62,20.65,20.64,20.52,20.32,19.99,19.61,19.24,18.87,18.50,18.10,17.57,16.90,16.22,15.45,14.62,13.83,12.98,12.09,11.21,10.26,9.45,8.74,8.25,8,7.99,8,8,8.10,8.21,8.34,8.47,8.58,8.62,8.62,8.62,8.62,8.62,8.62,8.62,8.70,8.82,9,9.36,9.74,10.12,10.58,11.10,11.72,12.50,13.37,14.37,15.45,16.11,16.84,17,17,17,17,17,1.07,1.20,1.39,1.64,1.90,2.21,2.49,2.76,3.07,3.27,3.50,3.65,3.85,3.99,4.12,4.26,4.50,4.72,4.89,5.12,5.27,5.45,5.59,5.75,5.87,6.07,6.25,6.47,6.73,7,7.25,7.45,7.61,7.52,7.32,7,6.62,6.27,5.97,5.62,5.23,4.74,4.23,3.74,3.37,3.20,3.08,2.96,2.83,2.61,2.37,2.13,2.13,2.25,2.27,2.33,2.33,2.33,2.33,2.27,2.24,2.12,2,2.11,2.22,2.33,2.34,2.22,2.71,2.87,3.11,3.35,3.75,4.33,5.07,5.88,6.75,7.58,8.50,9.10,9.25,9.35,9.20,8.85,8.49,8.26,8.39,8.87,9.62,10.52,11.50,12.49,13.25,13.70,13.61,13.11,12.39,11.73,11.10,10.60,10.37,10.37,10.62,10.96,11.33,11.65,12,12.26,12.62,13,13.50,14,14.46,14.52,14.25,13.74,13.25,12.99,12.87,12.74,12.37,11.72,10.85,9.86,8.87,7.97,7.09,6.23,5.37,4.73,4.15,4.07,4.07,4.23,4.58,5.09,5.63,6.25,6.95,7.62,8.39,9.25,10.23,11.34,12.45,13.46,14.51,15.51,16.62,17.62,18.40,18.50,18.25,18,17.84,17.77,17.75,17.62,17.49,17.37,17.37,17.51,17.77,18.12,18.51,18.75,18.76,18.63,18.22,17.75,17.52,17.63,17.87,18,18,18.22,18.63,19.11,19.33,18.99,18.40,17.75,17.22,16.52,15.87,15.08,14.87,14.13,14.12,13.96,13.75,13.40,12.98,12.38,11.75,11.10,10.38,9.75,9.12,8.57,8.02,7.62,7.25,7,6.76,6.64,6.63,6.76,7.08,7.50,8.07,8.73,9.46,10.25,11.12,12,12.97,13.95,14.75,15.34,15.76,16.13,16.49,16.73,16.90,17.01,16.96,16.72,16.37,16,15.73,15.46,15.20,15,14.95,15,15.25,15.63,16,15.87,15.76,15.48,15.25,14.61,14.10,13.72,13.87,14.60,15.45,16.25,17.12,17.87,18.52,19.15,19.75,20.25,20.62,20.83,20.84,20.74,20.62,20.51,20.39,20.23,19.89,19.51,19.12,18.73,18.37,18,17.62,17.11,16.50,15.84,15.12,14.37,13.61,12.83,12,11.14,10.25,9.37,8.62,8.20,8,7.99,8,8.10,8.24,8.40,8.62,8.75,8.86,8.87,8.87,8.86,8.86,8.86,8.87,8.87,8.88,8.99,9.12,9.38,9.72,10.01,10.37,10.77,11.37,12.10,12.87,13.75,14.63,15.27,15.87,16,16,17,17,16,1.10,1.25,1.50,1.75,2,2.32,2.62,2.90,3.25,3.50,3.75,4,4.15,4.36,4.50,4.73,4.97,5.21,5.45,5.62,5.75,5.87,6,6.12,6.25,6.38,6.60,6.86,7.12,7.46,7.72,7.87,8,7.96,7.84,7.62,7.38,7.13,6.88,6.62,6.21,5.65,5.09,4.49,4,3.73,3.49,3.25,3.10,2.87,2.64,2.49,2.47,2.51,2.62,2.63,2.63,2.63,2.63,2.62,2.50,2.34,2.12,2,2,2,2,2.01,2.09,2.87,2.84,2.77,3,3.25,4.12,4.87,5.65,6.26,6.89,7.46,7.75,7.88,7.85,7.62,7.40,7.36,7.51,8,8.75,9.62,10.62,11.52,12.37,12.90,12.98,12.62,12,11.37,10.77,10.35,10.10,10.08,10.25,10.60,11,11.38,11.75,12.09,12.39,12.84,13.35,13.87,14.37,14.51,14.12,13.45,12.75,12.25,12,11.75,11.37,10.82,9.98,9,8.01,7.08,6.20,5.37,4.74,4.32,4.07,4.07,4.14,4.50,5.02,5.72,6.37,7.07,7.75,8.45,9.12,9.87,10.75,11.75,12.75,13.75,14.75,15.62,16.51,17.40,18.21,18.50,18.50,18.32,18.23,18.13,17.98,17.72,17.45,17.21,17.08,17.08,17.25,17.57,17.97,18.38,18.73,19,18.75,18.33,18.22,18.33,18.52,18.63,18.63,18.87,19.22,19.52,19.63,19.33,18.87,18.22,17.63,16.99,16.33,15.95,15.11,14.86,14.13,13.73,13.27,12.83,12.25,11.62,10.97,10.25,9.59,8.90,8.35,7.82,7.37,7,6.75,6.59,6.50,6.57,6.74,7.01,7.48,8.01,8.65,9.37,10.11,10.87,11.71,12.58,13.49,14.46,15.27,15.88,16.35,16.64,16.87,17,17.12,17.12,17.01,16.83,16.59,16.37,16.24,16.12,15.99,15.86,15.75,15.83,16.02,16.45,16.64,16.57,16.24,15.70,15.12,14.61,14.12,14,14.38,15.22,16.08,16.87,17.63,18.35,19,19.65,20.27,20.77,21.11,21.12,21,20.74,20.47,20.24,20,19.75,19.37,18.97,18.50,18.10,17.74,17.37,17,16.51,15.99,15.37,14.72,14,13.26,12.57,11.83,11.08,10.12,9.25,8.50,8.12,7.99,8,8.07,8.21,8.45,8.73,8.97,9.11,9.12,9.09,9,9,9,9.02,9.09,9.10,9.12,9.15,9.33,9.51,9.75,10,10.24,10.57,11.01,11.63,12.35,13.10,13.75,14.22,15,15,15,16,16,16,1.11,1.26,1.51,1.84,2.12,2.38,2.74,3.09,3.40,3.75,4.01,4.27,4.50,4.71,4.88,5.12,5.38,5.64,5.88,6.09,6.22,6.27,6.37,6.49,6.60,6.75,6.97,7.25,7.51,7.83,8.07,8.22,8.27,8.35,8.35,8.26,8.20,8.07,7.87,7.62,7.25,6.71,6,5.32,4.73,4.26,3.89,3.61,3.47,3.25,3.01,2.83,2.82,2.88,2.97,2.99,2.99,2.99,2.99,2.98,2.87,2.64,2.45,2.33,2.33,2.33,2.20,2.01,2.10,2.12,2.14,2.21,2.23,2.83,3.25,3.87,4.33,4.84,5.35,5.87,6.24,6.40,6.48,6.38,6.33,6.36,6.59,7.02,7.75,8.60,9.50,10.45,11.25,11.90,12.13,11.97,11.46,10.88,10.38,10,9.77,9.75,9.97,10.35,10.83,11.32,11.75,12.12,12.48,12.87,13.34,13.77,14.33,14.57,14.09,13.14,12.32,11.62,11.14,10.76,10.36,9.75,8.99,8.08,7.12,6.22,5.37,4.75,4.35,4.12,4.07,4.13,4.49,5.02,5.72,6.39,7.13,7.87,8.60,9.25,9.87,10.50,11.13,11.99,12.87,13.75,14.52,15.26,16.02,16.84,17.62,18.12,18.34,18.25,18.25,18.25,18,17.73,17.37,17.02,16.77,16.62,16.63,16.90,17.39,17.98,18.50,19,19,18.75,18.63,18.75,18.87,19,19,19.22,19.52,19.87,20,19.63,19.11,18.40,17.75,17.11,16.72,15.96,15.10,14.86,14.12,13.39,12.75,12.13,11.51,10.87,10.15,9.48,8.82,8.21,7.63,7.21,6.85,6.59,6.40,6.37,6.48,6.64,7,7.47,8.01,8.70,9.37,10.12,10.83,11.51,12.26,13.10,13.96,14.87,15.74,16.38,16.87,17.13,17.27,17.27,17.25,17.14,17.08,16.90,16.77,16.74,16.75,16.75,16.75,16.50,16.37,16.40,16.62,16.84,16.87,16.65,16.24,15.62,15,14.48,14.12,14.27,14.87,15.82,16.72,17.50,18.20,18.77,19.45,20.11,20.73,21.21,21.39,21.36,21.07,20.63,20.25,19.89,19.62,19.25,18.86,18.37,17.87,17.45,17.07,16.73,16.36,15.95,15.47,14.89,14.33,13.64,12.98,12.25,11.52,10.87,9.89,9.02,8.35,8.09,7.99,8,8.11,8.34,8.64,9.01,9.37,9.47,9.37,9.25,9.14,9.12,9.15,9.25,9.32,9.35,9.37,9.39,9.52,9.75,9.96,10.11,10.22,10.37,10.73,11.23,11.76,12.33,12.99,13.87,14,14,15,15,15,15,1.09,1.25,1.50,1.83,2.12,2.47,2.83,3.15,3.51,3.87,4.21,4.50,4.75,5,5.24,5.50,5.83,6.11,6.33,6.50,6.62,6.72,6.76,6.87,6.99,7.12,7.36,7.62,7.87,8.13,8.37,8.51,8.65,8.82,8.89,9,9,9,8.89,8.74,8.37,7.83,7.10,6.25,5.50,4.90,4.49,4.24,3.99,3.72,3.49,3.37,3.37,3.37,3.37,3.37,3.36,3.36,3.35,3.35,3.32,3.12,2.87,2.63,2.63,2.70,2.87,2.95,2.10,2.12,2.14,2.21,2.24,2.25,2.72,2.95,3.25,3.34,4.07,4.50,4.85,5.09,5.22,5.25,5.25,5.35,5.59,6,6.62,7.39,8.27,9.21,10.01,10.74,11.14,11.12,10.75,10.32,9.88,9.61,9.40,9.38,9.62,10.10,10.65,11.32,11.86,12.25,12.62,12.96,13.35,13.73,14.12,14.25,13.71,12.75,11.82,11,10.37,9.83,9.25,8.62,7.87,7.07,6.22,5.38,4.75,4.36,4.14,4.12,4.13,4.49,5.02,5.71,6.39,7.15,7.97,8.74,9.46,10.11,10.64,11.12,11.50,12.22,12.98,13.64,14.25,14.83,15.40,16.11,16.75,17.25,17.51,17.73,17.87,18,17.87,17.61,17.25,16.87,16.50,16.26,16.22,16.40,16.89,17.59,18.25,19,19.33,19.22,19.11,19,19,19,19,19.22,19.40,19.63,19.63,19.40,19,18.33,17.52,16.87,16.21,15.98,14.99,14.87,13.82,12.87,12.12,11.45,10.76,10.12,9.40,8.75,8.12,7.58,7.12,6.75,6.49,6.35,6.32,6.38,6.62,6.98,7.46,8.01,8.72,9.45,10.15,10.88,11.60,12.25,12.88,13.62,14.37,15.23,16.01,16.75,17.33,17.62,17.73,17.58,17.37,17.22,17.11,17.01,17,17,17.09,17.10,17.09,16.87,16.85,16.90,17.10,17.22,17.12,16.77,16.24,15.51,14.83,14.37,14.12,14.58,15.37,16.37,17.32,18.08,18.73,19.25,19.83,20.45,21.01,21.47,21.61,21.47,21.10,20.62,20.12,19.73,19.34,18.87,18.38,17.87,17.34,16.87,16.50,16.13,15.84,15.49,15.09,14.62,14.07,13.40,12.74,12,11.25,10.50,9.61,8.63,8.15,8,7.99,8,8.12,8.46,8.87,9.37,9.73,9.77,9.65,9.50,9.32,9.26,9.37,9.48,9.57,9.62,9.62,9.73,9.85,10,10.15,10.25,10.25,10.25,10.46,10.83,11.23,11.75,12.20,13,13,14,14,14,14,14,1.02,1.21,1.47,1.75,2.12,2.47,2.83,3.20,3.57,3.88,4.25,4.59,4.87,5.15,5.50,5.84,6.13,6.45,6.65,6.87,7,7.12,7.20,7.25,7.37,7.51,7.75,7.99,8.24,8.47,8.64,8.87,9.01,9.25,9.50,9.74,9.87,9.96,9.97,9.86,9.61,9.07,8.25,7.26,6.37,5.48,5.12,4.87,4.62,4.37,4.12,4.01,4.01,4.01,4.01,4,4,4,4,4,3.87,3.64,3.40,3.33,3.33,3.22,3,3.02,2.87,2.86,2.83,2.76,2.25,2.25,2.26,2.32,2.34,2.75,3.07,3.38,3.73,3.99,4.12,4.24,4.27,4.37,4.62,4.99,5.50,6.23,7,7.87,8.74,9.45,9.98,10.11,9.87,9.58,9.26,9.08,8.96,8.99,9.25,9.75,10.45,11.24,11.88,12.37,12.72,12.98,13.25,13.50,13.77,13.60,12.96,12.07,11.12,10.34,9.59,8.87,8.14,7.50,6.82,6.10,5.38,4.75,4.37,4.15,4.13,4.26,4.48,5.01,5.65,6.37,7.14,7.97,8.75,9.52,10.26,10.97,11.58,11.97,12.21,12.63,13.22,13.62,14.02,14.39,14.87,15.39,15.88,16.32,16.62,17,17.35,17.51,17.50,17.34,16.98,16.57,16.15,15.90,15.85,16.10,16.58,17.25,18,18.75,19.22,19.22,19,18.75,18.63,18.75,18.87,19.11,19.11,19.11,19,18.87,18.52,17.87,17,16.22,15.84,14.99,14.01,13.87,13,12.12,11.36,10.64,10,9.36,8.71,8.08,7.50,7.02,6.70,6.45,6.27,6.25,6.37,6.61,6.96,7.45,8,8.72,9.47,10.25,11,11.75,12.38,13,13.52,14.12,14.75,15.50,16.25,17.01,17.63,18,18.12,17.86,17.51,17.25,17.13,17.15,17.25,17.32,17.33,17.25,17.21,17.14,17.24,17.37,17.57,17.62,17.49,17,16.26,15.50,14.83,14.60,14.47,14.97,15.85,16.95,17.87,18.60,19.14,19.62,20.11,20.63,21.13,21.50,21.61,21.45,21.10,20.62,20.14,19.71,19.23,18.71,18.12,17.50,16.96,16.50,16.12,15.84,15.57,15.25,14.95,14.50,14,13.37,12.63,11.87,11.02,10.15,9.27,8.38,8.02,8,8,8.02,8.23,8.60,9.12,9.62,10,10.12,10,9.75,9.51,9.50,9.59,9.71,9.82,9.87,9.96,10,10.13,10.32,10.48,10.50,10.40,10.32,10.35,10.50,10.87,11.25,11.90,12,13,13,13,13,13,13,1,1.12,1.37,1.72,2.08,2.39,2.75,3.12,3.50,3.87,4.22,4.58,4.88,5.25,5.62,6.01,6.38,6.71,6.96,7.13,7.34,7.49,7.59,7.64,7.75,7.90,8.11,8.32,8.50,8.74,8.95,9.12,9.36,9.62,9.99,10.37,10.70,10.87,10.98,11.01,10.87,10.37,9.50,8.45,7.33,6.37,5.89,5.62,5.37,5.12,5.01,5,5,5,5,5,5,5,5,4.99,4.75,4.40,4.11,3.87,3.75,3.87,3.97,3.95,3.10,3.12,3.15,3.21,3,2.74,2.26,2.22,2.23,2.33,2.36,2.64,2.97,3.14,3.33,3.39,3.50,3.59,3.75,4,4.48,5.08,5.77,6.61,7.39,8.12,8.63,8.87,8.86,8.71,8.51,8.39,8.37,8.48,8.76,9.32,9.99,10.83,11.58,12.11,12.45,12.63,12.87,13.12,13.37,12.98,12.23,11.25,10.32,9.50,8.73,7.97,7.21,6.50,5.86,5.25,4.75,4.37,4.15,4.14,4.33,4.62,5.01,5.70,6.36,7.10,7.87,8.75,9.58,10.34,11.10,11.82,12.48,12.88,13.23,13.50,13.75,13.89,13.99,14.21,14.50,14.90,15.25,15.48,15.77,16.36,16.77,17.08,17.10,16.87,16.51,16.12,15.76,15.59,15.58,15.87,16.37,17.10,17.77,18.52,18.87,18.87,18.63,18.33,18.11,18.22,18.40,18.63,18.40,18.22,18,18,17.75,17.35,16.11,15.27,14.87,14,13,12.90,12.02,11.23,10.50,9.87,9.24,8.61,7.99,7.40,6.99,6.62,6.38,6.25,6.25,6.36,6.59,6.90,7.38,8,8.65,9.45,10.25,11.07,11.87,12.61,13.24,13.75,14.21,14.62,15.12,15.75,16.46,17.20,17.87,18.33,18.50,18.12,17.75,17.47,17.35,17.38,17.51,17.62,17.62,17.50,17.40,17.46,17.62,17.84,18,18.12,17.88,17.36,16.48,15.61,14.89,14.77,14.87,15.45,16.37,17.46,18.37,19.02,19.59,19.87,20.25,20.62,21.01,21.26,21.35,21.24,21,20.65,20.25,19.82,19.25,18.64,18,17.37,16.76,16.36,16.01,15.77,15.60,15.37,15.09,14.65,14.12,13.50,12.73,11.87,10.98,10,9.01,8.22,7.99,7.99,8,8.07,8.26,8.75,9.34,9.89,10.37,10.50,10.37,10.10,9.84,9.75,9.76,9.87,10,10.12,10.23,10.33,10.46,10.60,10.73,10.74,10.62,10.50,10.45,10.39,10.75,11.11,11,12,12,12,13,13,13,13,1,1.11,1.33,1.64,2,2.37,2.73,3.08,3.40,3.76,4.12,4.50,4.87,5.25,5.72,6.12,6.52,6.87,7.12,7.37,7.62,7.82,7.90,8,8.13,8.25,8.39,8.60,8.76,8.98,9.13,9.37,9.61,9.87,10.25,10.75,11.26,11.62,11.89,12.13,12.10,11.62,10.72,9.58,8.37,7.37,6.82,6.40,6.12,6.01,6,6,6,6,6,6,6,6.12,6.22,6.21,5.75,5.33,4.87,4.63,4.20,4,4,4.01,4.10,4,4,3.99,3.75,3.25,2.82,2.32,2.34,2.35,2.36,2.49,2.59,2.64,2.75,2.82,2.87,2.89,3,3.24,3.58,4.02,4.64,5.37,6.12,6.82,7.34,7.62,7.74,7.73,7.65,7.63,7.70,7.86,8.15,8.65,9.33,10.08,10.82,11.37,11.75,12,12.25,12.49,12.70,12.37,11.51,10.50,9.48,8.61,7.84,7.08,6.34,5.63,5.11,4.63,4.37,4.20,4.13,4.32,4.63,5.20,5.75,6.38,7,7.74,8.57,9.46,10.26,11.12,11.87,12.60,13.13,13.65,14.12,14.57,14.57,14.36,14.22,14.11,14.45,14.75,14.99,15.12,15.46,15.97,16.37,16.62,16.62,16.37,16.02,15.71,15.38,15.26,15.37,15.71,16.25,16.98,17.62,18.22,18.33,18.22,18,17.52,17.22,17.22,17.40,17.63,17.40,17.22,17,16.87,16.63,16,15.11,14.22,14,13,12,11.97,10.90,10.23,9.62,9.07,8.48,7.87,7.33,6.87,6.51,6.33,6.22,6.21,6.27,6.50,6.87,7.36,7.89,8.59,9.33,10.12,10.99,11.86,12.65,13.45,14.08,14.50,14.87,15.14,15.50,15.97,16.52,17.25,17.98,18.52,18.75,18.46,18.09,17.75,17.62,17.71,17.87,18.10,18,17.84,17.75,17.76,18,18.25,18.46,18.37,18.12,17.59,16.71,15.83,15.12,15.12,15.35,15.96,16.85,17.90,18.83,19.51,19.87,20.02,20.23,20.47,20.65,20.77,20.83,20.77,20.75,20.61,20.35,19.90,19.37,18.74,18.01,17.37,16.84,16.45,16.20,16,15.87,15.64,15.37,14.95,14.37,13.64,12.86,11.90,10.99,9.98,9,8.07,8,7.99,8,8.01,8.34,8.87,9.57,10.22,10.72,10.89,10.76,10.47,10.12,10,9.96,10,10.12,10.32,10.47,10.61,10.71,10.77,10.87,10.87,10.84,10.75,10.63,10.75,10.87,11,11,12,12,12,13,13,13,13,1,1.08,1.27,1.62,1.99,2.27,2.62,2.99,3.34,3.65,4.01,4.37,4.77,5.23,5.72,6.14,6.60,6.89,7.25,7.58,7.87,8.10,8.23,8.27,8.46,8.57,8.70,8.82,8.99,9.14,9.37,9.61,9.77,10.01,10.37,10.90,11.58,12.12,12.51,12.97,13,12.62,11.85,10.62,9.36,8.25,7.59,7.24,7,6.97,6.97,6.97,6.97,6.97,6.98,6.98,7.11,7.32,7.51,7.52,7.11,6.52,5.87,5.25,5.07,5,5,5,5,5,5,4.96,4.75,4.11,3.25,2.89,2.70,2.64,2.62,2.58,2.50,2.40,2.37,2.37,2.37,2.39,2.49,2.61,2.84,3.14,3.63,4.25,4.88,5.50,6,6.37,6.58,6.64,6.74,6.76,6.87,7.10,7.38,7.87,8.47,9.12,9.75,10.33,10.75,11.12,11.45,11.71,11.89,11.70,10.96,9.86,8.72,7.74,6.98,6.25,5.61,5,4.50,4.26,4.12,4.12,4.25,4.62,5.25,5.87,6.70,7.09,7.75,8.13,9.07,9.98,10.96,11.96,12.72,13.25,13.75,14.25,14.88,15.34,15.23,14.87,14.51,14.40,14.59,14.85,15,15.11,15.37,15.75,16.12,16.25,16.12,15.85,15.50,15.25,15.09,15,15.13,15.50,16.12,16.87,17.59,18,18,17.75,17.40,16.87,16.40,16.22,16.22,16.33,16.22,16.11,15.87,15.63,15.22,14.63,13.87,13.11,13,12,11,10,9.96,9.10,8.75,8.27,7.74,7.13,6.65,6.35,6.12,6.01,6,6.11,6.34,6.70,7.14,7.74,8.37,9.07,9.83,10.64,11.58,12.50,13.45,14.22,14.84,15.25,15.48,15.61,15.75,16,16.50,17.15,17.89,18.64,18.87,18.70,18.36,18,17.87,17.97,18.25,18.45,18.36,18.12,18,18.08,18.35,18.62,18.76,18.72,18.36,17.73,16.87,15.89,15.25,15.24,15.62,16.39,17.35,18.34,19.14,19.87,20.01,20.09,20.12,20.14,20.21,20.15,20.14,20.21,20.25,20.32,20.22,19.87,19.37,18.73,18.01,17.40,16.97,16.63,16.48,16.36,16.22,15.97,15.62,15.12,14.50,13.75,12.88,11.97,10.99,9.99,9,8,8,8,7.99,8,8.34,8.96,9.75,10.51,11.11,11.35,11.22,10.84,10.46,10.14,10,10.02,10.21,10.47,10.70,10.83,10.87,10.90,10.96,10.97,10.98,11.11,11.11,11.11,11,11,12,12,12,13,13,13,13,12,1,1.01,1.25,1.58,1.89,2.21,2.50,2.76,3.10,3.38,3.72,4.01,4.38,4.88,5.36,5.87,6.25,6.62,6.97,7.40,7.87,8.13,8.37,8.50,8.52,8.61,8.62,8.83,9,9.34,9.57,9.76,9.88,9.89,10.25,10.89,11.62,12.25,12.83,13.34,13.62,13.40,12.86,11.62,10.15,8.97,8.26,7.97,7.74,7.62,7.74,7.85,7.98,7.86,7.75,7.75,8.10,8.51,8.87,8.87,8.40,7.75,6.75,6.11,6,6,5.98,5.99,5.99,5.98,5.98,5.95,5.75,4.97,4.11,3.26,3,2.87,2.82,2.65,2.50,2.32,2.12,2.01,2,2,2.08,2.12,2.25,2.48,2.77,3.25,3.75,4.26,4.73,5.07,5.37,5.50,5.63,5.75,5.90,6.12,6.39,6.77,7.35,7.83,8.39,8.87,9.37,9.74,10.23,10.75,11.12,11.01,10.37,9.12,7.72,6.72,5.96,5.37,4.74,4.32,4,3.88,3.90,3.95,4.22,4.88,5.76,6.87,7,7.99,8,9,9,10.21,11.57,12.74,13.50,13.95,14.25,14.59,15.12,15.58,15.64,15.23,14.75,14.52,14.75,15,15.22,15.11,15.32,15.58,15.96,15.82,15.50,15.12,14.87,14.73,14.62,14.62,14.70,15,15.65,16.75,17.63,18,18,17.63,17.11,16.33,15.75,15.40,15.33,15.33,15.33,15.22,15,14.52,14.11,13.37,13,12,11,10,10,9,8.99,8.02,8.07,7.62,6.98,6.39,5.97,5.73,5.64,5.62,5.60,5.74,6.10,6.65,7.25,7.90,8.60,9.27,10,10.97,11.97,12.95,13.74,14.47,15.11,15.49,15.75,15.82,15.75,15.75,16,16.64,17.75,18.46,18.65,18.58,18.23,17.85,17.62,18,18.46,18.75,18.57,18.23,17.87,18.12,18.58,19,19.24,19,18.71,17.90,17.07,15.97,15.27,15.32,15.87,16.75,17.61,18.50,19.45,19.98,19.97,19.95,19.83,19.72,19.50,19.27,19.21,19.25,19.45,19.63,19.75,19.59,19.11,18.37,17.65,17.13,16.86,16.65,16.61,16.59,16.40,16.11,15.51,14.87,14.24,13.51,12.75,11.87,10.95,9.98,9,8,8,8,8,7.99,8.22,8.98,9.88,10.75,11.36,11.61,11.50,11.11,10.65,10.22,9.98,9.87,10.10,10.38,10.70,10.77,10.83,10.85,10.87,10.89,11,11.11,11.90,11,12,12,12,12,12,12,12,12,12,12,0.99,1,1.15,1.37,1.62,1.85,2.08,2.26,2.50,2.74,2.95,3.14,3.40,3.75,4.10,4.40,5.23,5.33,5.47,6.61,7.73,7.82,7.88,7.87,7.89,7.97,8.02,8.13,9.25,9.24,9.24,9.25,9.25,9.27,9.36,10.39,11.50,11.59,12.57,13.50,13.50,13.40,13.33,12.23,10.12,8.09,8,7.99,6.97,6.95,6.90,7.95,7.97,7.99,7.01,7.10,8.13,9.25,9.35,9.46,9.58,8.72,7.87,6,6,6,6.99,6.97,6.89,6.87,6.85,6.82,6.75,5.75,4.73,3.71,2.65,2.64,2.62,2.57,2.34,2.12,1.87,1.75,1.73,1.74,1.75,1.77,1.86,1.95,2.12,2.38,2.75,3.12,3.48,3.73,3.87,4,4.09,4.15,4.32,4.48,4.71,4.95,5.25,5.59,5.90,6.61,6.70,7.76,7.95,9.12,9.20,9.20,8.21,7.23,5.46,4.75,4.36,3.87,3.46,3.22,3.07,3,2.99,3.13,3.34,4.50,6.75,7,8,9,9,9,9,9.87,11.63,13.48,13.32,14.13,14,13.89,13.82,14.72,14.62,14.59,13.50,13.49,13.47,14.45,14.45,14.45,13.47,14.49,14.47,14.34,13.24,13.13,13.12,13.12,13.12,13.15,13.25,13.37,14.50,15.64,16.75,16.75,16.75,16.75,15.75,14.76,13.84,13.87,13.95,14,14.11,14.21,13.32,13.45,12.59,12.75,11.90,12,11,10,9,9,8,7.99,7.95,6.70,6.40,5.23,5.01,4.87,4.75,4.61,4.32,4.36,4.84,5.62,6.48,6.36,7.25,8.15,8.12,9.10,11.10,11.12,12.21,13.27,13.38,14.50,14.63,14.82,14.99,14.15,14.39,15.50,16.62,17.50,17.49,17.49,17.50,16.57,16.62,16.74,17.65,17.62,17.60,16.58,16.57,16.57,17.57,18.60,18.62,18.63,17.73,17.75,15.87,14.97,14.09,14.21,15.33,16.40,17.35,18.26,19.25,19.11,18.95,18.77,18.63,18.51,17.45,17.36,17.14,16.95,16.75,17.60,17.47,17.36,17.25,16.23,15.21,15.20,15.23,15.25,15.35,15.40,15.52,14.72,13.87,13.11,12.34,12.61,11.89,11.25,10.62,10,9,8,8,8,8,8,8,8.87,9.75,10.63,11.47,11.25,11.12,11.01,9.96,9.87,8.87,8.87,8.89,9.98,10.02,10.14,10.32,10.49,10.70,10.75,10.87,11,11,12,12,12,12,12,12,12,12,12,12,12,];
}

function getTileMap()
{
	return [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,3,3,3,5,5,5,5,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,5,5,5,5,5,5,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,3,3,3,3,5,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,5,5,5,5,5,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,3,3,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,3,3,5,3,5,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,3,3,3,3,3,5,1,5,5,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,4,4,4,4,4,1,3,3,5,5,5,5,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,5,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,2,2,2,2,2,2,2,2,1,1,4,4,4,4,4,3,3,3,3,3,1,5,1,5,5,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,6,6,6,6,6,6,6,6,1,4,4,4,4,4,4,4,1,1,1,3,5,5,5,5,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,2,2,5,5,2,2,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,5,5,1,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,5,5,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,6,6,6,6,6,6,6,1,4,4,4,4,4,4,4,1,1,3,3,5,5,5,5,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,2,2,5,2,2,5,5,2,2,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,5,5,1,5,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,3,3,3,3,3,4,4,4,4,4,4,4,4,3,3,4,4,3,3,3,3,5,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,3,3,3,1,6,6,6,6,6,4,4,4,4,4,1,1,4,4,1,1,1,3,5,5,3,3,3,3,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,2,2,2,2,5,2,5,5,5,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,5,3,5,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,3,3,3,3,3,3,3,3,3,2,2,3,3,3,4,4,4,3,3,1,5,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,3,3,3,3,1,1,1,3,3,3,1,1,1,1,1,1,1,6,6,6,6,3,1,1,6,6,6,6,6,6,4,4,4,4,4,4,4,4,4,1,1,1,3,3,3,3,3,1,1,3,3,3,3,3,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,2,2,2,2,2,2,2,5,5,5,5,5,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,3,3,3,5,3,5,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,6,6,6,2,2,2,2,2,2,3,3,3,2,2,3,3,3,4,4,3,3,3,5,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,3,3,3,3,1,1,1,3,3,3,1,1,1,1,1,1,3,6,6,6,6,3,1,6,6,6,6,1,3,3,3,3,1,1,4,4,4,4,1,1,3,3,3,1,3,3,3,3,3,3,3,3,3,3,1,1,1,4,4,4,4,4,4,4,4,4,4,1,4,4,4,4,4,1,1,1,1,1,2,2,2,2,2,2,2,2,5,5,5,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,3,3,3,5,3,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,6,6,6,2,2,2,2,2,2,2,2,2,2,3,3,3,3,4,4,3,3,5,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,3,3,3,6,6,6,3,6,6,6,6,6,6,1,1,3,3,3,3,1,1,1,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,4,4,4,1,1,1,1,4,4,4,4,4,1,4,4,4,4,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,3,3,5,5,5,5,5,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,6,6,2,2,2,2,2,2,2,2,2,2,3,3,3,3,4,4,4,5,5,4,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,3,3,3,6,6,6,6,6,6,6,6,6,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,4,4,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,3,3,5,5,3,5,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,6,6,6,2,2,1,2,2,2,2,2,2,2,3,3,3,3,3,4,4,5,4,4,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,3,3,3,6,6,6,6,6,6,6,6,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,4,4,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,6,6,6,2,2,2,2,2,2,2,2,2,2,3,3,3,3,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,3,3,3,3,1,3,3,6,6,6,3,3,3,1,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,3,3,3,1,1,1,1,2,2,2,6,6,6,6,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,3,3,3,3,3,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,6,6,6,6,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,6,6,3,3,3,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,3,3,3,3,1,1,1,1,2,2,2,6,6,6,6,2,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,3,3,3,3,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,6,6,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,3,3,3,3,1,1,6,6,6,2,6,6,6,6,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,6,6,6,6,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,3,3,3,3,3,3,3,3,1,1,1,1,1,1,2,2,2,2,2,2,2,6,6,6,6,6,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,3,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,2,2,2,2,2,2,2,6,6,2,6,6,2,2,2,2,2,2,2,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,3,6,6,6,6,6,6,1,6,6,6,6,6,6,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,2,2,2,2,2,2,2,6,6,2,6,6,2,2,2,2,2,2,2,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,6,6,6,6,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,6,6,6,6,6,6,2,6,6,2,2,2,2,2,2,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,6,6,6,6,6,6,2,6,6,2,2,2,2,2,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,3,6,6,6,6,6,6,6,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,6,6,6,6,6,6,6,6,6,6,6,2,2,2,2,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,1,3,3,3,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,4,4,1,1,1,3,6,6,6,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,6,6,2,6,6,6,6,6,6,6,2,2,2,2,1,4,4,4,4,1,4,4,4,4,4,4,4,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,6,6,6,6,6,6,6,6,6,6,6,2,2,2,1,1,4,4,4,4,4,4,4,4,1,1,4,4,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,2,2,2,2,2,2,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,3,3,4,4,4,3,3,3,3,3,3,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,3,3,3,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,3,3,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,3,3,3,3,3,1,1,1,1,4,4,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,3,3,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,3,3,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,3,3,3,3,3,1,1,1,4,4,4,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,5,5,5,5,4,4,4,4,4,4,4,4,4,4,3,3,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,4,4,1,1,1,1,4,4,4,4,4,4,3,3,3,3,3,3,1,1,1,4,4,4,4,5,4,4,4,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,4,4,4,4,4,4,4,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,3,3,3,3,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,3,4,4,3,1,1,1,4,4,4,4,4,5,4,4,4,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,5,4,4,4,4,1,1,1,1,1,3,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,3,3,3,4,4,4,4,4,4,4,3,3,4,4,4,4,3,4,4,4,4,4,4,4,4,4,4,5,4,4,5,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,5,4,4,1,1,1,1,1,3,3,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,1,1,4,4,4,4,4,4,1,1,1,5,5,1,1,5,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,5,1,1,5,1,5,1,1,1,1,1,1,1,3,4,4,4,4,4,3,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,3,3,3,3,3,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,3,3,3,3,3,3,3,3,3,3,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,5,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,3,4,4,3,3,3,3,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,3,3,3,3,3,3,3,1,1,1,4,4,4,1,4,4,1,1,1,1,1,1,1,1,5,1,5,5,1,1,1,5,5,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,5,5,5,1,1,3,3,3,4,4,3,3,3,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,3,3,3,3,3,3,3,3,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,5,1,5,5,1,1,1,5,5,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,3,3,3,3,3,3,3,3,1,1,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,4,4,4,4,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,5,1,5,1,1,1,1,5,5,5,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,6,6,6,6,6,6,6,6,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,5,5,2,2,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,3,3,3,3,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,4,4,3,3,3,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,5,5,5,5,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,2,5,5,5,5,2,2,2,1,1,1,6,6,6,1,6,6,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,4,4,4,4,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,5,5,1,1,1,1,5,5,5,5,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,5,5,5,2,2,2,2,2,2,2,2,1,6,6,6,6,6,6,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,4,4,1,1,1,1,1,1,1,1,5,5,1,1,1,1,5,5,1,1,5,5,5,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,5,5,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,5,1,2,5,2,2,2,2,2,2,2,2,2,2,2,6,6,6,6,6,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,4,4,4,4,1,1,4,4,4,1,1,1,1,1,1,1,1,5,1,5,5,5,5,5,1,1,1,1,5,5,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,5,5,3,3,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,6,6,6,6,2,2,2,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,4,4,4,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,5,5,5,5,5,5,3,3,5,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,6,6,6,6,2,2,2,4,4,4,4,4,4,4,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,5,5,3,3,3,3,5,5,5,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,6,6,6,1,2,2,2,2,4,4,4,4,4,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,4,4,1,4,4,4,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,5,3,3,3,5,5,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,2,2,2,2,2,2,2,2,6,6,6,6,6,2,2,2,4,4,4,4,4,2,2,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,4,4,4,3,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,2,2,2,2,2,2,6,6,6,6,6,2,2,2,4,4,4,4,4,4,2,2,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,2,2,2,2,2,2,2,6,6,6,6,2,2,2,2,4,4,4,4,4,4,2,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,3,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,2,2,2,2,2,2,1,6,6,6,2,2,2,2,2,4,4,4,4,4,4,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,6,6,0,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,2,2,2,2,2,2,6,6,6,6,6,1,2,2,2,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,3,3,3,3,3,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,5,5,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,2,2,2,2,2,2,6,6,6,6,6,1,1,2,2,1,4,4,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,3,3,3,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,5,5,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,3,3,3,1,1,1,3,3,3,3,3,3,3,3,1,1,2,2,2,2,2,2,2,2,2,6,6,6,6,1,1,1,1,2,4,4,4,1,1,1,1,3,3,3,3,3,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,2,2,2,2,6,6,6,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,6,6,6,6,6,0,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,5,5,5,5,1,1,1,1,1,1,6,6,6,6,1,1,6,6,6,6,3,3,1,1,4,4,4,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,6,6,6,6,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,2,1,3,3,3,3,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,2,3,3,3,3,3,2,2,2,2,2,6,6,6,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,6,6,6,1,1,1,1,6,6,3,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,6,6,6,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,3,5,5,5,5,5,5,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,3,3,3,3,3,2,2,2,2,2,2,6,6,6,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,5,5,5,3,5,5,5,3,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,6,6,6,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,3,3,3,5,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,6,6,6,6,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,5,3,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,6,6,6,2,2,2,2,2,2,2,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,4,4,4,3,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,6,6,2,2,2,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,4,4,4,4,3,3,3,3,4,4,4,4,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,4,4,4,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,5,5,5,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,6,6,6,2,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,6,6,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,3,3,3,3,3,4,4,4,4,4,4,3,3,4,4,4,4,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,4,4,4,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,6,6,6,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,1,1,1,1,3,3,4,4,4,3,3,4,4,4,4,4,4,4,3,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,4,4,4,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,5,5,1,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,6,6,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,1,1,1,3,3,4,4,4,1,3,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,5,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,2,1,1,2,2,2,2,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,2,2,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,1,5,5,1,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,3,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,6,5,5,5,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,6,6,1,6,6,5,5,5,6,6,6,6,6,6,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,4,4,4,4,3,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,6,6,1,1,1,6,6,6,6,5,5,5,6,6,6,6,6,6,6,6,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,4,4,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,4,4,1,1,3,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,6,6,6,6,5,5,5,1,6,6,6,6,6,6,6,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,5,5,5,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,4,4,4,4,5,5,5,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,4,4,5,4,5,1,5,5,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,5,1,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,4,5,4,5,5,1,5,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,4,4,5,5,5,5,1,5,5,5,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,4,4,4,4,4,1,5,1,5,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,4,4,4,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,3,3,3,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,4,4,4,4,4,4,4,5,5,5,5,5,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,3,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,4,4,4,4,4,4,5,5,5,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,4,4,4,4,4,3,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,4,4,1,1,1,1,5,1,5,5,5,5,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,3,3,3,1,1,1,1,1,1,6,6,1,1,1,1,1,3,3,3,3,4,4,4,4,3,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,5,5,5,5,1,5,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,3,3,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,3,3,3,3,4,4,4,4,3,4,4,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,3,4,4,4,4,4,3,3,3,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,6,6,1,1,1,1,1,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,3,4,4,4,4,4,3,3,3,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,6,6,1,1,1,1,1,1,3,3,3,4,4,4,4,4,4,4,3,4,4,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,3,3,3,4,4,4,4,3,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,6,6,1,1,1,3,3,3,3,3,3,3,3,3,3,4,4,4,3,3,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,3,3,3,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,6,6,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,5,3,3,3,3,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,6,6,6,1,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,5,5,5,5,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,6,2,2,2,2,3,3,3,3,3,3,3,2,2,2,2,2,4,4,4,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,3,3,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,5,5,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,5,5,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,6,6,6,6,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,5,3,5,5,3,3,1,1,1,1,1,3,3,3,3,2,2,2,2,2,2,6,6,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,2,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,3,3,3,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,3,5,3,5,1,1,1,1,1,1,3,3,3,2,2,2,2,2,2,2,2,6,6,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,5,5,1,2,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,3,5,5,5,3,5,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,6,6,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,5,2,2,2,2,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,3,3,3,1,1,5,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,6,6,6,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,5,5,2,2,5,5,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,1,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,6,6,6,6,6,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,5,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,6,6,6,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,6,6,6,6,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,2,3,3,3,3,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,3,3,3,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,5,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,4,4,1,1,4,4,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,2,2,2,3,3,3,3,3,3,3,3,3,3,4,4,1,1,1,1,4,4,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,5,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,1,4,4,1,4,4,5,1,5,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,3,5,3,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,5,5,5,5,5,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,2,2,2,3,3,3,2,2,2,2,3,3,3,3,3,3,3,3,3,1,4,4,1,1,1,5,5,5,1,1,1,1,1,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,3,3,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,2,2,2,3,3,3,2,2,2,2,2,1,1,1,1,1,1,4,4,4,1,1,2,2,2,2,5,5,1,5,5,1,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,5,5,3,5,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,2,2,2,2,4,4,1,1,1,4,4,4,4,4,2,2,2,2,2,2,5,5,5,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,5,5,5,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,4,1,1,1,4,4,2,2,2,2,2,2,2,5,5,5,5,5,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,2,2,2,2,2,2,2,2,2,4,4,2,2,1,2,2,2,4,4,2,2,2,5,5,5,5,5,5,5,2,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,6,6,6,6,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,2,2,2,2,2,2,1,2,2,4,4,2,2,2,2,2,4,4,4,2,2,2,5,5,2,2,2,5,2,2,2,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,2,1,1,1,1,2,2,2,2,2,2,2,2,2,4,4,4,2,2,2,2,2,2,2,2,5,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,4,4,4,4,4,2,2,2,2,2,2,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,1,1,1,1,1,2,2,2,2,2,2,2,4,4,4,4,4,2,2,2,2,2,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,2,4,4,4,4,4,4,4,2,2,5,2,5,2,5,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,1,1,1,1,4,4,2,2,2,4,4,4,4,4,4,2,2,2,2,2,2,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,6,6,6,6,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,2,2,2,2,2,4,4,4,4,4,4,2,2,5,2,2,2,2,2,2,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,1,1,1,1,1,4,4,2,2,4,4,4,4,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,6,6,6,1,1,1,6,6,6,6,6,6,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,2,2,5,5,2,2,2,2,2,2,2,2,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,1,1,1,1,4,4,2,2,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,6,6,6,6,1,6,6,6,6,6,6,6,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,2,2,2,2,2,5,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,4,4,4,2,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,6,6,1,1,1,1,1,2,2,2,4,4,2,4,4,4,4,4,4,4,4,4,2,2,2,2,2,5,5,2,2,2,2,2,2,2,2,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,4,4,4,4,2,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,2,2,4,4,2,2,4,4,4,2,2,2,2,4,4,4,2,2,2,2,5,5,5,5,5,2,5,2,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,6,6,6,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,2,2,4,4,2,2,2,2,2,2,2,2,5,2,5,5,2,2,5,5,5,2,2,5,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,2,2,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,6,6,6,6,6,6,6,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,2,2,2,4,4,5,5,5,5,5,5,5,5,5,5,5,5,2,5,2,2,2,2,2,2,5,5,2,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,6,6,6,6,6,6,6,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,2,2,4,4,4,2,2,2,2,5,5,5,5,5,2,2,5,2,5,5,5,5,2,5,5,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,6,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,4,4,4,4,4,4,1,1,1,1,4,4,2,2,4,4,4,4,2,2,2,2,5,5,5,5,5,1,5,5,5,5,5,5,5,5,1,5,3,3,3,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,6,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,4,4,4,4,1,1,1,1,1,1,4,4,2,2,2,2,2,5,2,2,5,2,2,5,5,5,5,5,5,5,3,5,5,5,5,5,5,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,4,4,1,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,2,2,5,5,2,2,5,5,5,5,5,1,1,5,5,5,5,5,5,5,5,3,5,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,1,1,2,2,2,5,3,3,5,5,5,5,5,5,5,1,5,5,3,3,3,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,2,2,5,3,5,5,5,5,5,1,1,5,3,3,3,3,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,5,5,5,5,3,5,1,5,3,3,3,1,1,1,1,1,1,1,5,5,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,0,0,0,0,0,0,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,5,5,5,5,5,5,3,3,3,3,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,5,5,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,3,3,5,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,5,5,5,1,5,5,5,5,5,5,5,5,5,5,5,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,5,5,5,5,5,5,5,5,5,5,5,1,5,1,1,5,5,3,5,5,5,5,5,5,5,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,5,2,5,5,5,5,5,5,1,5,5,5,1,1,1,3,3,5,5,5,5,3,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,5,5,5,2,5,5,5,2,5,5,5,2,2,2,2,2,2,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,2,5,5,5,5,5,5,2,5,5,5,5,5,2,2,2,2,2,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,2,4,4,4,5,5,5,5,5,5,5,2,2,5,5,2,2,2,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,2,4,4,4,4,5,5,5,5,5,5,5,5,2,5,5,2,2,2,2,2,2,2,2,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,3,3,3,3,3,2,4,5,5,5,5,5,2,5,5,5,5,5,2,2,5,2,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,3,3,3,1,1,1,3,3,3,3,3,5,5,5,4,5,4,5,5,5,5,5,5,5,5,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,3,3,3,3,3,2,2,1,3,3,3,3,5,5,5,5,5,5,5,5,4,4,5,5,2,2,2,2,5,5,2,2,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,1,1,7,7,7,7,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,3,3,3,2,2,2,2,2,3,3,3,2,5,5,5,5,5,5,5,4,4,4,5,4,2,2,2,2,2,5,2,2,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,3,3,3,3,3,3,2,2,2,2,2,3,3,3,5,5,5,4,2,2,5,2,5,2,5,2,2,2,2,2,2,2,2,5,2,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,3,3,1,3,3,3,1,2,2,2,2,2,2,2,3,3,3,5,5,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,5,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,3,3,3,3,1,3,3,3,3,3,3,2,3,3,3,3,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,5,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,3,3,3,4,4,4,3,3,3,3,1,3,3,3,3,3,3,2,3,4,4,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,5,5,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,3,3,3,4,4,3,3,3,3,1,3,3,3,3,4,4,4,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,7,7,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,4,4,4,3,3,3,3,3,3,3,1,1,1,1,2,2,2,4,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,3,3,3,3,3,3,3,1,1,1,1,1,1,2,2,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,7,7,7,7,0,0,0,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,4,4,4,4,4,4,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,2,2,2,2,2,1,6,6,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,5,5,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,5,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,5,5,1,5,5,5,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,5,5,5,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,5,5,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,6,6,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,6,6,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,2,2,2,2,4,4,4,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,2,2,2,3,3,3,3,3,3,2,2,2,3,3,3,3,2,2,2,2,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,2,2,2,2,4,4,4,4,4,4,4,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,6,6,1,2,2,2,2,4,4,4,4,4,4,4,4,2,2,2,2,2,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,2,2,2,4,4,4,4,4,2,4,4,4,4,2,2,2,2,2,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,2,2,4,4,4,4,2,4,4,4,4,4,2,2,2,2,2,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,2,2,2,4,4,4,4,2,4,4,4,4,2,2,2,2,2,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,6,6,1,1,1,2,4,4,4,4,2,4,4,4,4,4,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,5,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,6,6,1,1,1,4,4,4,4,4,4,4,4,4,4,4,2,2,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,5,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,6,6,6,1,6,6,1,1,1,4,4,4,4,4,4,4,4,4,4,4,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,4,4,4,4,4,4,4,4,4,4,4,2,2,2,2,2,2,2,1,1,1,1,2,2,2,2,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,3,4,4,4,4,4,3,3,4,4,4,4,2,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,3,4,4,4,4,4,4,3,3,3,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,1,1,6,6,6,6,6,6,1,1,1,3,3,3,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,6,6,6,6,6,1,3,3,3,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,5,4,4,4,4,4,4,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,5,5,4,4,4,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,3,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,5,4,5,3,3,3,3,3,3,3,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,3,3,3,3,3,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,3,3,3,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,3,3,5,5,5,3,3,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,3,5,3,5,3,5,5,3,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,4,4,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,3,3,5,3,5,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,3,3,3,3,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,2,3,3,3,3,2,2,2,2,2,2,2,2,3,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,3,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,4,4,4,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,3,3,3,3,3,3,3,1,1,1,4,4,5,5,5,1,5,5,5,5,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,3,3,3,3,3,3,3,3,1,1,4,4,4,5,5,1,1,5,5,5,5,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,3,3,3,3,3,3,3,3,1,4,4,4,4,4,1,1,5,5,1,5,5,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,3,3,3,3,3,3,3,3,4,4,4,4,4,4,1,1,1,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,4,4,1,1,1,1,1,1,1,1,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,6,6,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,4,4,4,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,4,4,4,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,2,2,2,2,1,1,4,4,5,5,4,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,6,6,6,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,2,2,2,5,4,4,4,5,5,5,5,5,5,5,5,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,6,6,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,6,6,6,1,1,6,6,6,6,6,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,5,1,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,2,2,2,5,5,5,5,5,5,5,4,5,5,4,4,4,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,2,6,6,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,4,4,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,4,4,4,4,4,4,5,5,2,2,5,5,5,1,1,6,6,4,4,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,3,4,4,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,2,6,6,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,4,4,4,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,4,4,4,4,4,5,5,5,5,5,1,5,5,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,4,4,4,4,4,3,3,3,3,4,4,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,2,2,2,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,4,4,4,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,2,2,2,5,5,5,5,2,5,5,5,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,4,4,4,4,4,3,3,3,4,4,3,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,2,2,2,2,2,2,4,4,1,1,1,3,3,3,3,3,2,2,3,3,3,2,6,6,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,6,6,6,6,6,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,2,2,2,5,2,5,5,5,5,5,2,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,4,4,3,4,4,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,2,2,4,4,4,4,2,2,3,3,3,3,2,2,2,2,3,3,3,2,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,6,6,6,6,6,6,6,6,6,6,6,6,6,6,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,4,5,5,5,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,5,5,5,1,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,5,5,2,5,5,5,2,2,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,4,4,3,3,4,4,4,4,3,4,4,3,3,3,3,3,2,2,2,2,2,2,2,2,2,3,3,3,2,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,2,2,3,3,3,3,2,2,2,2,3,3,3,2,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,2,2,6,6,6,6,6,6,6,6,6,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,5,5,4,5,4,5,4,4,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,5,1,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,5,5,3,5,5,5,2,2,2,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,4,4,3,3,3,4,4,4,4,4,4,3,3,3,3,3,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,2,4,4,4,2,2,2,2,2,3,3,3,3,2,2,2,2,2,2,2,2,2,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,5,3,5,1,5,5,5,5,4,4,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,5,5,5,5,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,5,5,5,5,5,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,3,3,3,3,3,3,3,3,4,4,4,3,3,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,4,4,4,4,2,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,2,2,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,4,4,1,3,3,3,3,3,5,3,5,1,5,4,5,5,4,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,5,5,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,3,3,3,3,3,4,4,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,4,4,4,3,2,2,2,2,2,3,3,3,3,2,2,2,2,3,3,3,2,2,2,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,6,6,6,6,6,6,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,5,5,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,5,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,2,2,3,3,4,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,4,4,4,4,4,3,3,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,6,6,6,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,5,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,4,4,4,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,2,2,4,4,4,4,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,3,3,3,3,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,5,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,4,4,4,2,2,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,4,4,4,4,3,3,3,3,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,4,4,4,4,2,2,2,2,2,2,2,2,3,3,3,3,3,2,2,2,2,2,2,2,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,4,4,1,1,4,4,1,1,1,1,1,1,1,3,3,3,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,6,6,1,1,1,4,4,1,1,1,2,2,2,2,3,3,3,3,3,3,3,3,3,3,2,2,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,2,2,2,2,2,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,4,4,4,1,1,1,1,1,3,3,3,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,6,6,1,1,1,4,4,1,1,1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,3,2,2,3,3,3,3,1,2,2,2,2,2,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,3,3,3,4,4,3,3,3,3,1,3,3,3,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,6,6,1,1,1,4,4,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,4,4,4,4,4,4,4,3,3,2,2,2,2,2,2,2,2,2,2,2,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,4,4,4,4,4,1,1,3,3,3,4,4,4,4,4,4,4,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,4,4,1,1,1,1,3,4,4,3,3,3,3,1,1,1,3,3,3,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,4,4,1,1,1,3,3,3,3,3,2,2,3,3,3,3,3,3,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,3,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,2,3,4,4,4,4,3,3,2,2,2,2,2,2,2,2,2,2,2,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,4,4,4,4,4,4,4,3,4,4,4,4,4,4,4,4,4,4,3,3,2,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,3,3,3,3,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,6,6,1,1,4,4,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,6,6,6,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,3,3,3,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,6,6,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,4,4,1,1,3,3,3,3,3,3,3,3,3,3,3,3,2,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,6,6,6,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,3,3,3,2,4,4,4,4,2,2,2,2,2,2,2,2,2,2,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,4,4,4,4,4,1,4,4,4,4,3,3,3,3,3,4,4,4,3,3,3,2,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,4,4,1,1,1,1,3,3,3,3,3,3,3,3,3,3,2,2,2,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,2,6,6,6,6,6,2,2,2,2,2,2,2,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,4,4,4,4,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,4,4,4,4,4,4,1,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,2,2,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,4,4,4,1,1,1,1,1,1,3,3,3,1,2,2,2,2,2,2,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,2,2,2,2,6,6,6,6,6,6,2,2,2,2,2,2,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,4,4,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,3,3,3,1,1,1,1,2,2,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,2,2,2,2,2,6,6,6,6,6,6,6,2,2,2,2,2,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,2,2,2,2,2,2,2,4,4,4,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,1,3,3,3,6,6,6,6,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,4,4,1,1,1,1,3,3,3,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,2,2,2,2,2,2,2,2,2,2,6,6,6,6,2,2,2,2,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,4,4,4,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,4,4,4,1,4,4,4,4,1,1,1,3,3,3,6,6,6,6,6,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,4,4,1,1,1,1,3,3,3,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,2,2,2,2,2,2,2,2,2,2,6,6,6,6,2,2,2,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,6,6,6,6,6,6,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,6,6,6,2,2,2,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,1,1,1,2,2,2,2,2,2,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,6,6,6,6,6,6,6,6,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,6,6,3,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,2,2,2,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,6,6,2,3,3,3,2,2,2,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,6,2,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,2,6,6,6,2,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,6,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,2,6,6,6,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,6,6,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,2,3,3,3,3,3,3,3,2,2,2,2,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,6,6,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,3,3,3,3,3,3,2,2,2,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,3,3,3,3,3,3,3,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,6,6,6,3,3,3,3,2,2,2,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,6,6,6,6,6,2,3,3,3,3,3,3,3,3,2,2,2,2,2,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,6,6,6,1,6,6,6,6,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,3,3,1,1,1,1,1,3,3,3,3,3,3,3,3,2,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,1,3,3,3,3,3,3,3,3,6,6,6,3,3,3,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,6,6,3,3,3,3,2,2,2,2,2,3,3,3,3,3,3,3,3,3,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,3,3,3,2,3,3,3,3,3,3,3,3,2,2,2,2,2,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,6,6,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,6,6,3,3,3,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,6,6,6,3,2,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,6,6,6,6,1,6,6,6,6,1,1,1,1,1,1,1,1,1,6,6,2,2,2,2,2,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,6,6,3,3,3,2,2,2,2,2,2,2,2,2,2,3,3,3,3,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,6,6,6,6,6,3,3,2,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,6,6,6,1,1,1,1,6,6,6,6,6,1,1,1,1,1,6,6,6,2,2,2,2,2,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,3,3,1,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,3,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,3,3,3,3,2,2,2,3,3,3,3,1,1,2,2,2,2,2,2,2,2,2,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,6,6,6,1,1,1,1,6,6,6,6,6,6,1,1,1,6,6,6,1,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,3,3,3,3,3,3,3,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,6,6,6,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,1,6,6,6,6,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,2,2,3,3,3,3,3,3,3,3,3,3,2,2,2,1,2,2,2,2,2,2,2,2,4,4,4,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,3,6,6,6,6,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,3,3,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,2,2,6,6,6,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,6,6,6,6,6,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,2,2,2,2,1,2,2,2,2,2,2,4,4,4,4,2,2,2,2,2,1,1,1,1,1,1,3,3,3,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,2,2,2,2,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,2,2,2,3,3,3,3,3,3,2,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,3,3,3,1,1,1,3,3,1,3,3,3,3,3,3,3,3,3,3,3,2,2,2,6,6,6,6,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,2,2,2,2,2,1,2,2,2,2,2,2,4,4,4,2,2,2,2,2,2,2,1,1,1,1,1,3,3,6,6,6,6,6,6,6,6,6,6,6,3,3,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,6,6,6,6,6,6,1,1,1,1,2,2,2,2,3,3,3,3,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,3,3,3,3,3,1,1,3,1,3,3,3,3,3,3,3,3,3,3,3,2,2,2,6,6,6,6,6,6,6,3,3,3,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,4,4,4,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,6,6,3,3,3,3,6,6,6,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,6,6,6,1,1,1,1,2,2,2,2,3,3,3,3,3,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,2,2,2,2,2,2,2,6,6,6,6,6,6,6,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,4,4,4,4,2,2,2,2,2,2,2,2,2,1,1,1,1,6,6,1,1,3,3,3,3,6,6,6,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,1,1,1,1,2,2,2,3,3,3,3,3,3,3,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,2,3,3,3,3,3,3,3,2,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,6,6,2,2,6,6,6,6,6,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,1,1,1,2,2,4,4,4,2,2,2,2,2,2,2,2,2,2,1,1,6,6,6,6,1,1,1,1,1,6,6,6,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,1,1,2,2,2,3,3,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,2,2,2,2,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,6,6,6,6,6,6,3,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,1,6,6,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,2,2,2,2,2,2,2,1,1,6,6,6,1,1,1,1,1,6,6,6,6,6,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,3,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,6,6,6,3,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,6,6,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,6,6,6,1,1,1,1,1,1,6,6,1,1,1,1,6,6,6,6,6,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,3,3,3,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,0,1,1,1,6,6,6,6,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,2,2,2,2,2,2,2,2,6,6,6,3,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,3,3,6,6,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,6,6,6,6,1,1,1,1,6,6,1,1,1,1,6,6,6,6,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,3,3,3,1,4,4,4,2,2,2,2,2,2,2,2,2,2,1,1,1,6,6,6,6,6,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,3,3,3,3,6,6,6,6,3,3,3,6,6,6,6,6,6,1,1,1,1,6,6,6,6,6,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,6,6,6,1,1,1,6,6,6,6,1,1,5,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,3,1,4,4,4,4,3,3,2,2,4,4,2,2,2,1,1,6,6,6,6,6,6,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,6,6,6,6,6,6,6,6,6,6,6,6,6,3,6,6,6,6,6,6,1,6,6,6,6,6,6,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,1,1,1,6,6,6,3,3,3,5,5,5,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,3,3,3,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,3,3,2,2,4,4,2,2,2,1,6,6,6,6,6,6,6,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,6,6,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,1,6,6,6,6,6,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,5,3,5,5,4,4,4,1,1,1,4,4,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,3,3,3,3,3,1,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,2,2,2,1,6,6,6,6,6,6,6,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,6,6,3,3,6,6,6,6,3,3,3,3,3,3,3,6,6,6,3,3,3,6,6,6,6,6,6,1,6,6,6,6,6,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,6,6,6,6,6,3,3,3,3,3,5,3,1,1,5,5,4,1,1,4,4,4,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,2,2,2,1,6,6,6,6,6,6,6,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,3,3,3,3,5,1,5,5,5,5,4,4,4,4,4,4,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,3,4,4,4,4,2,2,2,2,2,1,1,6,6,1,1,6,6,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,6,6,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,5,5,5,4,4,4,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,4,4,3,4,4,4,4,4,4,4,4,4,4,4,2,2,1,1,1,1,1,1,6,6,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,4,5,5,4,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,4,4,2,2,2,4,4,4,4,4,4,4,4,4,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,4,4,3,3,3,3,3,3,3,3,3,3,3,1,1,1,6,6,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,4,4,4,4,4,4,4,4,2,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,4,4,3,1,1,1,1,1,3,3,3,3,1,1,1,1,6,6,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,5,5,5,5,5,5,5,5,5,5,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,2,2,4,4,4,4,2,4,4,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,4,4,4,4,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,2,5,5,5,4,4,5,5,1,1,1,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,3,3,3,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,4,4,4,4,4,1,1,1,2,2,2,2,2,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,4,4,4,4,4,4,4,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,5,5,5,5,2,5,5,5,5,5,5,1,5,5,5,5,5,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,3,3,3,3,3,3,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,5,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,4,4,4,4,4,2,4,4,4,4,4,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,4,4,4,4,4,1,1,1,2,2,2,2,2,2,2,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,4,4,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,5,2,1,1,1,1,1,1,1,1,1,1,5,5,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,5,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,6,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,4,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,2,2,2,2,2,2,2,2,2,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,2,2,2,2,2,2,2,5,5,5,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2,5,5,5,5,5,5,1,2,2,2,2,2,2,2,2,2,2,2,2,6,6,6,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,2,4,4,2,2,2,2,2,3,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,5,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,2,2,2,2,2,2,2,2,2,2,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,2,4,4,4,2,4,4,4,4,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,6,6,1,1,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,2,2,2,2,2,2,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,3,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,2,2,2,6,6,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,4,4,4,4,4,2,3,3,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,5,5,5,5,5,5,2,2,2,1,1,1,1,1,1,1,1,1,2,6,6,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,4,4,3,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,4,4,2,2,2,2,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,5,5,5,2,5,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,6,6,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,3,3,4,4,4,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,1,1,1,1,1,1,3,3,3,1,3,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,5,5,2,5,5,2,2,2,2,2,2,2,2,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,4,4,4,3,3,3,3,3,3,3,3,3,3,1,4,4,4,4,4,1,1,1,3,3,3,3,3,3,1,3,3,3,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,2,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,2,1,1,1,1,6,6,2,2,2,2,2,2,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,4,4,3,3,3,3,3,3,3,3,3,3,1,1,1,4,4,4,4,1,1,3,3,3,3,3,3,3,1,3,3,3,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,2,6,6,6,2,2,2,2,2,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,6,6,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,6,6,2,2,2,2,2,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,2,2,2,3,3,3,6,6,6,6,2,2,2,2,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,6,6,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,4,4,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,2,2,2,2,2,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,2,2,1,1,3,6,6,6,2,2,2,2,4,4,4,4,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,3,3,3,1,1,3,3,3,1,1,1,1,1,1,1,1,2,2,2,2,1,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,2,5,5,2,2,2,2,5,5,2,2,2,2,1,3,3,3,3,3,3,3,3,3,3,3,1,6,6,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,4,4,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,2,2,3,3,3,2,1,1,6,6,6,6,2,2,2,2,4,4,4,4,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,3,3,3,1,1,3,3,3,3,3,1,1,1,1,1,2,2,2,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,2,2,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,5,5,1,1,1,1,5,2,5,2,2,5,2,2,5,5,2,2,2,2,2,3,3,3,3,3,3,3,3,1,1,1,3,3,3,3,6,6,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,6,6,6,1,1,1,3,3,3,3,3,3,1,4,4,1,1,1,4,4,1,4,4,4,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,2,2,2,2,1,1,3,3,6,6,6,2,2,2,2,4,4,4,4,4,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,3,3,3,3,1,1,1,3,3,3,1,1,1,1,1,2,2,2,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,2,2,2,2,3,3,3,3,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,5,3,3,3,3,3,3,1,5,1,5,5,5,1,5,5,5,5,5,5,5,2,5,5,5,2,2,2,2,3,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,6,6,3,3,3,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,6,6,6,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,2,2,2,2,1,1,1,3,6,6,6,1,2,2,4,4,4,4,4,4,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,3,3,3,1,1,3,3,3,1,1,1,3,3,3,3,3,3,1,1,2,2,6,6,6,6,6,6,6,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,2,2,2,2,2,3,3,3,3,3,2,2,2,2,2,2,3,3,3,1,1,1,1,1,1,1,1,1,5,5,3,3,3,5,5,5,1,5,5,5,5,5,5,5,5,5,2,5,5,5,5,2,2,2,2,2,2,3,3,3,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,6,6,6,3,3,1,1,4,4,4,4,4,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,3,3,3,1,1,1,1,1,1,3,3,3,1,1,2,2,6,6,6,6,6,6,6,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3,2,2,2,2,3,3,3,3,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,1,5,5,5,2,2,2,2,2,2,2,2,2,3,3,3,1,1,1,1,1,1,1,1,3,3,3,3,3,3,6,6,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,6,6,6,6,6,6,3,3,3,4,4,4,3,4,4,3,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,3,3,3,1,1,1,2,2,6,6,6,2,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,1,5,5,5,1,5,1,1,5,1,1,1,1,1,2,2,5,2,2,2,3,3,3,1,1,1,1,1,1,1,1,3,3,3,3,3,3,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,6,6,6,6,6,6,6,3,3,3,3,4,4,4,4,4,4,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,5,1,1,1,5,5,1,1,1,5,5,5,5,1,1,1,1,1,5,5,5,2,2,2,2,2,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,4,4,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,6,6,6,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,6,6,1,3,3,4,4,4,4,4,4,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,3,3,3,1,3,3,3,3,1,1,1,3,3,3,3,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,5,5,5,5,1,1,1,5,1,1,1,5,2,2,2,1,5,5,1,1,1,1,1,1,1,3,3,3,3,3,3,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,3,3,3,3,1,4,4,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,6,6,6,2,6,6,2,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,3,4,4,4,4,4,4,3,3,3,3,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,5,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,6,6,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,4,4,4,4,4,4,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,4,4,4,4,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,5,5,5,1,5,1,1,5,5,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,6,6,6,1,1,6,6,6,6,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,2,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,4,4,4,4,4,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,4,4,1,1,1,6,6,1,1,6,6,6,6,1,1,1,1,1,1,3,3,3,3,3,1,3,3,3,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,2,6,6,2,2,2,2,6,6,2,2,2,1,1,1,4,4,4,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,6,6,6,6,1,6,6,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,2,2,6,6,6,2,2,6,6,6,2,6,6,2,2,2,2,6,6,2,2,2,2,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,3,3,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,4,4,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,2,2,2,2,2,2,2,2,2,2,2,2,6,6,2,2,2,6,6,6,2,2,2,2,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,1,6,6,1,6,6,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,2,2,2,2,2,6,6,6,2,6,6,6,6,2,2,2,2,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,2,3,3,3,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,6,6,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,2,2,2,2,6,6,2,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,2,2,2,6,6,6,6,6,6,6,2,2,2,2,2,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,2,2,2,3,3,3,3,3,3,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,6,6,6,6,6,2,4,4,2,2,2,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,3,3,2,2,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,2,2,2,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,6,6,6,2,2,2,2,6,6,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,6,6,6,4,4,2,4,4,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,5,5,1,1,1,1,5,1,5,5,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,6,6,6,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,2,4,4,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,2,2,2,2,2,2,2,2,1,1,1,3,3,3,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,5,5,1,1,1,5,5,5,5,5,5,1,1,5,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,2,2,2,6,6,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,4,4,1,4,4,4,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,4,4,4,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,2,2,3,3,3,3,3,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,3,1,3,4,4,4,4,4,4,4,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,3,3,3,3,3,3,3,5,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,2,2,2,6,6,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,4,4,1,4,4,4,1,3,4,4,3,4,4,4,1,1,1,1,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,2,3,3,3,3,3,3,2,2,2,2,1,3,3,3,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,3,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,1,1,1,1,1,3,3,3,3,3,3,3,3,3,5,1,1,1,1,1,1,1,1,1,5,5,5,1,5,5,5,5,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,1,4,4,1,1,3,3,3,4,4,4,4,4,4,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,3,3,3,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,3,4,4,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,3,3,3,1,1,1,1,3,3,3,3,3,3,3,3,5,5,3,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,1,5,5,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,1,5,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,6,6,6,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,2,2,2,1,1,1,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,2,3,3,3,3,2,2,3,3,3,3,3,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,3,4,4,3,3,2,2,2,4,4,4,4,4,4,4,4,4,4,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,1,5,5,5,5,5,3,3,3,5,5,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,6,6,6,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,1,1,1,2,2,2,2,2,2,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,6,6,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,2,2,3,3,3,2,2,3,3,3,3,3,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,3,4,4,3,3,3,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,3,3,3,3,5,3,3,5,5,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,1,1,3,3,3,1,1,1,1,1,1,1,1,5,5,5,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,6,6,2,2,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,4,4,4,4,4,4,3,3,4,4,4,4,4,2,2,1,1,2,2,2,2,2,2,2,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,2,2,2,2,6,6,6,1,1,1,1,1,1,4,4,4,4,4,4,4,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,2,2,2,2,2,2,2,2,3,3,3,3,3,1,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,3,3,3,3,3,5,5,5,1,1,1,1,1,1,1,1,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,1,1,1,5,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,4,4,4,4,4,4,3,3,2,2,4,4,4,2,2,2,1,2,2,2,2,2,2,2,2,6,6,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,4,4,4,4,4,4,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,3,3,3,3,3,1,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,3,3,3,5,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,1,1,4,4,1,1,1,5,5,5,1,5,5,5,1,1,1,1,1,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,1,1,1,5,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,6,6,6,6,6,2,2,1,1,6,6,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,4,4,4,4,4,4,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,2,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,2,6,6,2,2,2,2,2,2,2,1,1,1,1,1,1,4,4,4,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,5,3,3,3,5,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,1,1,5,1,1,5,5,1,1,1,1,1,3,3,3,1,1,1,1,1,3,3,3,3,3,1,1,5,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,6,6,6,6,6,6,6,6,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,4,4,4,2,4,4,2,2,4,4,2,2,2,2,2,6,6,6,6,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,6,6,2,2,2,2,2,2,2,1,1,1,1,3,3,3,1,1,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,5,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,4,4,4,4,4,5,4,4,1,1,1,1,1,1,1,5,1,5,5,5,1,1,5,5,3,3,3,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,6,6,6,6,6,6,6,6,2,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,4,4,2,4,4,4,2,2,2,6,6,6,6,2,2,2,3,3,3,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,3,3,3,3,1,1,2,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,2,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,2,2,2,2,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,4,4,4,1,1,1,1,1,1,5,5,1,1,1,1,1,5,5,3,3,3,1,1,1,1,5,5,5,5,5,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,6,6,2,2,2,6,6,2,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,4,4,4,6,6,6,6,6,6,2,2,2,2,3,3,3,1,1,1,1,1,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,2,2,2,2,2,2,2,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,3,3,3,2,2,2,2,2,1,1,1,1,3,3,3,3,3,3,3,3,1,1,1,2,2,2,2,2,2,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,5,1,5,5,4,4,4,4,1,1,1,1,1,1,1,1,5,1,5,3,3,5,5,1,1,5,5,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,2,2,6,6,6,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,2,2,2,2,2,2,2,1,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,1,2,6,6,6,6,2,2,2,2,2,2,2,3,3,3,1,1,1,1,1,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,2,2,2,2,2,2,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,2,2,3,3,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,1,5,4,4,4,4,4,4,4,4,4,4,1,1,5,5,5,5,3,3,5,1,5,5,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,6,6,6,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,1,1,3,3,3,2,2,2,2,2,2,2,2,2,2,6,6,6,6,6,6,2,2,2,2,2,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,2,2,2,3,4,4,4,4,4,4,3,3,3,2,3,3,3,3,2,2,1,1,1,6,6,6,6,6,1,1,1,1,1,1,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,1,5,5,5,1,1,4,5,5,4,4,4,4,1,1,3,5,5,5,3,3,5,5,5,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,4,4,3,4,4,4,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,6,6,6,6,1,1,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,1,3,3,3,2,2,2,2,2,2,2,2,2,6,6,6,6,6,6,6,2,2,2,2,2,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,2,2,2,2,2,4,4,4,4,4,4,2,2,2,2,2,2,2,2,2,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,5,5,1,5,5,4,5,5,5,4,4,3,3,3,5,3,5,3,3,3,5,1,5,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,6,6,1,1,1,1,1,5,1,5,1,1,1,1,4,4,1,1,4,4,1,4,4,4,4,4,4,3,3,3,3,3,1,1,3,3,3,3,3,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,3,3,3,1,3,3,3,2,2,2,2,2,2,2,6,6,6,2,2,2,2,2,2,2,2,1,1,1,1,2,2,2,2,3,3,3,3,3,3,3,2,2,2,3,3,3,3,3,3,3,3,3,3,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,1,1,1,1,2,2,2,2,4,4,2,1,4,4,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,5,5,1,1,4,4,1,5,5,3,3,3,3,5,3,5,3,3,3,3,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,6,6,1,1,1,1,1,1,1,5,5,5,4,4,4,1,4,4,1,1,4,4,1,4,5,4,4,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,6,6,6,2,2,2,2,2,2,1,1,1,1,1,1,2,2,3,3,3,3,3,3,3,3,2,2,2,2,2,3,3,3,3,3,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,5,5,5,2,5,2,1,1,3,3,3,3,5,5,3,3,3,5,3,5,3,3,3,3,3,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,6,6,6,6,1,1,1,1,1,1,1,5,5,1,4,4,4,4,4,4,1,1,1,1,1,1,5,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,3,3,3,3,3,3,3,1,2,2,2,2,2,2,6,6,6,2,2,2,2,2,1,1,1,1,1,1,1,2,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,6,6,3,3,3,6,6,6,6,2,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,3,3,3,3,5,3,5,3,3,3,3,5,5,3,3,5,5,3,3,5,3,5,3,3,3,3,3,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,1,6,6,6,1,1,1,1,1,1,1,1,1,5,1,1,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,2,2,2,2,2,6,6,2,2,2,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,6,6,3,3,6,6,3,6,6,6,6,2,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,5,5,5,5,3,3,3,3,5,3,5,5,3,3,5,3,5,3,5,3,3,3,3,3,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,5,5,1,1,4,4,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,1,1,1,2,2,2,6,6,2,2,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,3,3,6,6,3,3,6,6,6,6,6,6,6,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,3,3,5,5,5,3,3,5,3,3,3,3,3,5,3,5,5,5,1,5,1,1,1,5,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,1,5,5,1,1,1,1,5,5,1,1,1,1,1,5,1,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,3,3,3,5,5,5,3,3,3,3,3,3,3,1,1,5,5,5,5,1,5,1,5,5,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,5,5,5,1,5,1,5,5,5,5,1,1,1,1,1,5,5,1,1,1,1,1,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,6,6,6,1,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,1,1,1,1,1,3,3,3,3,3,3,3,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3,3,5,3,5,3,5,5,5,3,3,3,1,1,1,1,1,1,1,1,5,5,5,5,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,1,1,5,5,1,1,1,5,1,1,5,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,1,1,1,1,1,2,2,3,3,3,2,2,6,6,6,6,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,3,3,3,3,3,3,3,3,3,3,5,3,3,5,5,1,1,1,1,1,1,1,1,1,1,1,5,5,5,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,5,5,1,1,1,5,1,1,1,1,1,1,1,5,1,1,5,1,1,1,1,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,5,5,5,3,5,5,5,5,5,1,1,2,2,2,2,2,2,2,6,6,6,6,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,3,3,3,3,2,2,3,5,5,3,5,5,3,5,5,5,1,1,1,1,1,1,1,1,1,5,1,5,5,5,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,1,1,1,5,1,1,1,1,1,1,1,5,5,5,1,5,1,1,1,5,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,5,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,3,3,3,3,3,1,1,1,5,5,1,1,1,1,1,1,1,1,5,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,5,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,5,5,5,5,3,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,6,6,1,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,6,6,6,1,6,6,1,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,5,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,];
}

function getTilePallet()
{
	return ["snow forest","snow rough","snow grass 100","snow","snow rocks","snow_new","snow grass 75","polar_ice_cracked",];
}
