// Coordinates: 21.824205, 40.289810
// Map Width: 2900km

RMS.LoadLibrary("rmgen");
RMS.LoadLibrary("rmgen2");

InitMap();

log("Initializing biome...");
setBiome(3);
initMapSettings();
initTileClasses();

setSunColor(0.733, 0.746, 0.574);

setWindAngle(-0.43);
setWaterTint(0.161, 0.286, 0.353);
setWaterColor(0.129, 0.176, 0.259);
setWaterWaviness(8);
setWaterMurkiness(0.87);
setWaterType("lake");

setTerrainAmbientColor(0.58, 0.443, 0.353);

setSunRotation(PI * 1.1);
setSunElevation(PI / 7);

setFogFactor(0);
setFogThickness(0);
setFogColor(0.69, 0.616, 0.541);

setPPEffect("hdr");
setPPContrast(0.67);
setPPSaturation(0.42);
setPPBloom(0.23);

g_Terrains.mainTerrain = "desert_dirt_rocks_2";
g_Terrains.forestFloor1 = "desert_grass_a_sand";
g_Terrains.forestFloor2 = "desert_grass_a_sand";
g_Terrains.tier1Terrain = "desert_dirt_rocks_2";
g_Terrains.tier2Terrain = "desert_dirt_rough";
g_Terrains.tier3Terrain = "desert_dirt_rough";
g_Terrains.tier4Terrain = "desert_sand_stones";
g_Terrains.roadWild = "road2";
g_Terrains.road = "road2";
g_Gaia.tree1 = "gaia/flora_tree_date_palm";
g_Gaia.tree2 = "gaia/flora_tree_senegal_date_palm";
g_Gaia.tree3 = "gaia/flora_tree_fig";
g_Gaia.tree4 = "gaia/flora_tree_cretan_date_palm_tall";
g_Gaia.tree5 = "gaia/flora_tree_cretan_date_palm_short";
g_Gaia.fruitBush = "gaia/flora_bush_grapes";
g_Decoratives.grass = "actor|props/flora/grass_field_dry_tall_b.xml";
g_Decoratives.grassShort = "actor|props/flora/grass_field_parched_short.xml";
g_Decoratives.rockLarge = "actor|geology/stone_desert_med.xml";
g_Decoratives.rockMedium = "actor|geology/stone_savanna_med.xml";
g_Decoratives.bushMedium = "actor|props/flora/bush_desert_dry_a.xml";
g_Decoratives.bushSmall = "actor|props/flora/bush_medit_sm_dry.xml";
g_Decoratives.dust = "actor|particle/dust_storm_reddish.xml";
initBiome();

log("Resetting terrain...");
resetTerrain(g_Terrains.mainTerrain, g_TileClasses.land, 1);
RMS.SetProgress(10);

log("Copying heightmap...");
var scale = paintHeightmap(getHeightMap(), getTileMap(), getTilePallet(), (tile, x, y) => {
	if (tile.indexOf("cliff") >= 0)
		addToClass(x, y, g_TileClasses.mountain);
});
RMS.SetProgress(30);

log("Rendering water...");
paintTileClassBasedOnHeight(-100, -1, 3, g_TileClasses.water);
RMS.SetProgress(40);

log("Placing players...");
// Coordinate system of the heightmap
var singleBases = [
	[175, 30],
	[45, 210],
	[280, 180],
	[180, 180],
	[230, 115],
	[130, 280],
	[200, 253],
	[90, 115],
	[45, 45]
];
var strongholdBases = [
	[50, 160],
	[100, 50],
	[170, 260],
	[260, 160]
];
randomPlayerPlacementAt(singleBases, strongholdBases, scale, 0.04);
RMS.SetProgress(50);

log("Adding mines and forests...");
addElements(shuffleArray([
	{
		"func": addMetal,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 10,
			g_TileClasses.metal, 20,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["normal", "many"]
	},
	{
		"func": addStone,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 3,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 30,
			g_TileClasses.rock, 20,
			g_TileClasses.metal, 10,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["normal", "many"]
	},
	{
		"func": addForests,
		"avoid": [
			g_TileClasses.berries, 3,
			g_TileClasses.forest, 20,
			g_TileClasses.metal, 3,
			g_TileClasses.mountain, 3,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 3,
			g_TileClasses.water, 2
		],
		"sizes": ["big"],
		"mixes": ["similar"],
		"amounts": ["few"]
	}
]));
RMS.SetProgress(60);

log("Ensure initial forests...");
addElements([{
	"func": addForests,
	"avoid": [
		g_TileClasses.berries, 2,
		g_TileClasses.forest, 25,
		g_TileClasses.metal, 3,
		g_TileClasses.mountain, 5,
		g_TileClasses.player, 15,
		g_TileClasses.rock, 3,
		g_TileClasses.water, 2
	],
	"sizes": ["small"],
	"mixes": ["similar"],
	"amounts": ["tons"]
}]);
RMS.SetProgress(65);

log("Adding berries and animals...");
addElements(shuffleArray([
	{
		"func": addBerries,
		"avoid": [
			g_TileClasses.berries, 30,
			g_TileClasses.forest, 5,
			g_TileClasses.metal, 10,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 10,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["normal", "many"]
	},
	{
		"func": addAnimals,
		"avoid": [
			g_TileClasses.animals, 20,
			g_TileClasses.forest, 2,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 1,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["many"]
	},
	{
		"func": addFish,
		"avoid": [
			g_TileClasses.fish, 12,
			g_TileClasses.player, 8
		],
		"stay": [g_TileClasses.water, 4],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["many"]
	},
	{
		"func": addStragglerTrees,
		"avoid": [
			g_TileClasses.berries, 5,
			g_TileClasses.forest, 15,
			g_TileClasses.metal, 2,
			g_TileClasses.mountain, 1,
			g_TileClasses.player, 20,
			g_TileClasses.rock, 2,
			g_TileClasses.water, 5
		],
		"sizes": ["normal"],
		"mixes": ["same"],
		"amounts": ["many"]
	}
]));
RMS.SetProgress(70);

log("Adding decoration...");
addElements([
	{
		"func": addLayeredPatches,
		"avoid": [
			g_TileClasses.dirt, 5,
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["normal"],
		"amounts": ["many"]
	},
	{
		"func": addDecoration,
		"avoid": [
			g_TileClasses.forest, 2,
			g_TileClasses.mountain, 2,
			g_TileClasses.player, 12,
			g_TileClasses.water, 3
		],
		"sizes": ["normal"],
		"mixes": ["similar"],
		"amounts": ["many"]
	}
]);
RMS.SetProgress(80);

log("Adding reeds...");
createObjectGroups(
	new SimpleGroup(
		[
			new SimpleObject(g_Decoratives.reeds, 5, 12, 1, 4),
			new SimpleObject(g_Decoratives.rockMedium, 1, 2, 1, 5)
		],
		true,
		g_TileClasses.dirt
	),
	0,
	[
		stayClasses(g_TileClasses.water, 1),
		borderClasses(g_TileClasses.water, scaleByMapSize(2,8), scaleByMapSize(2,5))
	],
	scaleByMapSize(100, 1000),
	500
);
RMS.SetProgress(85);

log("Adding dust...");
createObjectGroups(
	new SimpleGroup(
		[new SimpleObject(g_Decoratives.dust, 1, 1, 1, 4)],
		false
	),
	0,
	[
		stayClasses(g_TileClasses.dirt, 1),
		avoidClasses(
			g_TileClasses.player, 10,
			g_TileClasses.water, 3
		)
	],
	Math.pow(scaleByMapSize(5, 20), 2),
	500
);
RMS.SetProgress(90);

ExportMap();

function getHeightMap()
{
	return [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,7,7,8,8,8,8,8,8,8,9,9,9,9,8,8,8,8,8,8,8,8,8,9,9,9,8,8,8,8,8,8,7.98,7.97,7,7,7,7,7,7,7,6.99,6.99,6.99,6.99,6.99,7,7.12,7.87,7.87,7.97,7.87,7.87,7.08,7,7,7,7,8,7,7,7,7,7,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,7,7,7,7,7,7,7,7,6,6,6,7,7,7,8,8,7,7,7,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.98,3.97,3.97,3.97,3,3,2.99,2.99,2.99,2.99,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,2.99,2.98,2.87,2.83,2.61,2.12,1.12,0.12,-1,-1.88,-2.42,-2.78,-3,-3,-3.02,-3.09,-3.23,-3.50,-4,-4.88,-5.73,-6.48,-7.02,-7.37,-7.49,-7.47,-7.36,-7.24,-7.16,-7.10,-6.88,-6.04,-5.86,-5.62,-5.17,-4.60,-4.21,-4.15,-4.28,-4.24,-4.25,-4.30,-4.37,-4.28,-4.05,-3.89,-3.67,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,7,7,7,7,8,8,8,8,8,8,9,9,9,8,8,8,8,8,8,8,8,8,8,8,9,8,8,8,8,8,8,7.97,7.96,7.07,7.08,7,6.99,6.99,6.99,6.99,6.99,6.99,6.99,6.99,6.99,6.98,6.99,7.12,7.12,7.86,7.87,7.87,7.12,7.11,7,7,7,7,7,7,7,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,7,7,7,7,7,7,6,6,6,6,6,7,7,7,7,7,7,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.97,3.87,3.75,3.62,3.37,3.20,3,2.99,2.98,2.97,2.97,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,2.99,2.97,2.87,2.74,2.37,2.10,0.86,-0.25,-1.16,-2,-2.50,-2.80,-3,-3,-3.03,-3.13,-3.36,-3.78,-4.40,-5.35,-6.13,-6.80,-7.34,-7.67,-7.88,-7.88,-7.86,-7.85,-7.89,-7.84,-7.62,-7.36,-7.05,-6.76,-6.40,-5.99,-5.51,-5.11,-5.42,-5.49,-5.51,-5.52,-5.47,-5.29,-5.02,-4.62,-3.75,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,9,9,8,8,8,8,8,8,8,9,8,8,8,8,8,8,7.99,7.98,7.98,7.98,7.95,7.87,7.10,7.10,7,7,6.99,6.99,6.99,6.99,6.99,6.99,6.98,6.98,6.97,6.96,6.97,6.99,7.12,7.21,7.84,7.12,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,7,7,7,7,6,6,6,6,6,6,6,7,7,7,7,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.87,3.75,3.61,3.37,3.23,3.10,3,2.98,2.96,2.87,2.84,2.12,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,2.99,2.95,2.82,2.50,2.11,1.25,0.34,-0.65,-1.50,-2.14,-2.63,-2.88,-3,-3,-3.13,-3.36,-3.75,-4.36,-5.11,-5.86,-6.61,-7.25,-7.76,-8.13,-8.37,-8.51,-8.62,-8.62,-8.63,-8.63,-8.52,-8.38,-8.17,-7.92,-7.62,-7.25,-6.90,-6.65,-6.63,-6.67,-6.71,-6.67,-6.55,-6.33,-5.96,-5.37,-4.05,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,9,8,8,8,9,9,9,8,8,9,8,8,7.99,7.98,7.97,7.86,7.75,7.72,7.70,7.62,7.37,7.33,7.12,7,7,6.99,6.99,6.99,6.98,6.98,6.98,6.98,6.97,6.96,6.87,6.87,6.87,6.87,6.95,7.09,7.12,7.12,7,6.99,6.99,6.98,6.99,6.99,6.99,6.99,6.99,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.98,3.87,3.62,3.37,3.23,3.11,3,3,2.97,2.87,2.84,2.62,2.35,2.11,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,2.99,2.98,2.87,2.74,2.32,1.57,0.62,-0.30,-1.13,-1.88,-2.38,-2.75,-2.90,-3,-3.08,-3.23,-3.54,-4.10,-4.86,-5.60,-6.35,-7.04,-7.67,-8.17,-8.55,-8.88,-9.13,-9.22,-9.28,-9.36,-9.38,-9.36,-9.26,-9.13,-8.96,-8.72,-8.42,-8.15,-7.96,-7.85,-7.84,-7.79,-7.73,-7.53,-7.24,-6.78,-6.05,-4.33,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,9,9,9,9,9,8,8,8.09,7.99,7.96,7.96,7.85,7.62,7.45,7.37,7.36,7.25,7.21,7.12,7.07,7,7,6.99,6.99,6.98,6.98,6.98,6.97,6.97,6.95,6.87,6.87,6.82,6.75,6.74,6.75,6.86,6.87,6.98,6.98,6.98,6.87,6.86,6.87,6.87,6.87,6.87,6.95,6.97,7,7,7,7,6,6,6,6,6,6,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.87,3.84,3.37,3.24,3.11,3,3,2.99,2.96,2.87,2.75,2.61,2.36,2.12,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,2.99,2.99,2.98,2.87,2.70,2.12,1.23,-0.02,-0.79,-1.53,-2.13,-2.54,-2.80,-3,-3.01,-3.11,-3.33,-3.75,-4.49,-5.25,-6.02,-6.78,-7.50,-8.11,-8.60,-8.96,-9.29,-9.61,-9.66,-9.79,-9.89,-9.98,-10,-9.99,-9.91,-9.79,-9.64,-9.43,-9.23,-9.03,-8.93,-8.88,-8.78,-8.65,-8.39,-8,-7.48,-6.61,-4.77,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,9,9,9,8.99,8.08,8,7.96,7.96,7.84,7.73,7.50,7.36,7.12,7.09,7.10,7.11,7.07,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.96,6.87,6.87,6.86,6.75,6.62,6.60,6.50,6.58,6.62,6.83,6.87,6.86,6.82,6.83,6.12,6.12,6.12,6.12,6.10,6.08,6,6,6,6,6,6,6,6,6,6,6.09,6.07,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.87,3.87,3.12,3.22,3.11,3,3,3,2.98,2.96,2.87,2.75,2.60,2.37,2.12,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,2.99,2.98,2.87,2.84,2.62,2.11,1,-0.13,-1.05,-1.77,-2.30,-2.67,-2.88,-3,-3.02,-3.13,-3.49,-4,-4.77,-5.60,-6.37,-7.14,-7.88,-8.49,-8.92,-9.25,-9.58,-9.88,-9.96,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.93,-9.88,-9.83,-9.67,-9.48,-9.13,-8.64,-7.99,-6.93,-5.13,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8.12,8.12,7.96,7.84,7.73,7.57,7.37,7.25,7.12,7.07,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.96,6.87,6.87,6.83,6.75,6.62,6.50,6.37,6.36,6.37,6.47,6.62,6.75,6.75,6.21,6.12,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.73,4.25,4,4,4,4,4,4,3.99,4,4,4,4,4,4,4,4,4,3.99,3.99,3.87,3.86,3.12,3.12,3,3,3,3,2.99,2.98,2.95,2.87,2.75,2.60,2.37,2.12,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,2.99,2.96,2.87,2.75,2.46,2.11,0.87,-0.13,-1.13,-1.88,-2.38,-2.75,-2.92,-3,-3.03,-3.24,-3.58,-4.26,-5,-5.76,-6.52,-7.25,-7.97,-8.75,-9.10,-9.37,-9.68,-9.96,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.75,-9.14,-8.35,-7.11,-5.28,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7.98,7.97,7.96,7.95,7.84,7.62,7.37,7.25,7.12,7.08,7,7,7,7,7,7,7,6.99,6.99,6.99,6.99,6.98,6.97,6.96,6.87,6.87,6.82,6.74,6.62,6.50,6.37,6.25,6.21,6.20,6.25,6.25,6.23,6.23,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.97,4.75,4.46,4.12,4,4,4,4,4,3.99,3.99,3.99,3.99,3.99,4,4,4,4,3.99,3.99,3.87,3.85,3.12,3.12,3,3,3,3,3,2.99,2.98,2.96,2.87,2.75,2.60,2.37,2.12,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,2.99,2.98,2.95,2.86,2.62,2.24,1.57,0.75,-0.18,-1.13,-1.88,-2.39,-2.75,-2.88,-3.01,-3.16,-3.42,-3.87,-4.47,-5.15,-5.89,-6.63,-7.33,-7.99,-8.67,-9.03,-9.28,-9.58,-9.80,-9.88,-10,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-10,-9.52,-8.58,-7.12,-5.22,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7.98,7.97,7.85,7.73,7.62,7.50,7.36,7.12,7.08,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.98,6.98,6.96,6.87,6.87,6.83,6.74,6.62,6.50,6.37,6.25,6.12,6.11,6.08,6.07,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.98,5.96,5.95,5.95,5.97,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.97,4.96,4.97,4.95,4.85,4.62,4.36,4.12,4,4,4,4,3.99,3.99,3.97,3.95,3.95,3.95,3.96,3.99,3.99,3.99,3.87,3.85,3.12,3.12,3,3,3,3,3,3,2.99,2.98,2.96,2.87,2.75,2.62,2.37,2.12,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,2.99,2.99,2.98,2.95,2.62,2.35,1.85,1.20,0.37,-0.40,-1.17,-1.88,-2.38,-2.66,-2.88,-3.02,-3.23,-3.53,-4,-4.61,-5.26,-5.98,-6.64,-7.28,-7.88,-8.43,-8.79,-9.05,-9.28,-9.46,-9.58,-9.75,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.53,-8.39,-6.85,-5.05,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,7.87,7.75,7.62,7.50,7.37,7.34,7.24,7.12,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.98,6.98,6.97,6.87,6.87,6.83,6.74,6.62,6.50,6.37,6.25,6.12,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.98,5.95,5.84,5.74,5.74,5.85,6,5.99,5.99,6,6,6,6,5.99,5.99,5.97,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.95,4.87,4.86,4.87,4.95,4.87,4.75,4.50,4.24,4.07,4,4,4,3.99,3.99,3.87,3.86,3.75,3.62,3.62,3.74,3.86,3.87,3.84,3.12,3.12,3,3,3,3,3,3,3,2.99,2.99,2.97,2.87,2.83,2.62,2.37,2.22,2.09,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2.99,2.99,2.99,2.87,2.82,2.58,2.12,1.62,0.87,0.12,-0.63,-1.38,-1.92,-2.38,-2.68,-2.88,-3.03,-3.26,-3.62,-4.12,-4.73,-5.37,-6.02,-6.64,-7.21,-7.72,-8.24,-8.49,-8.71,-8.86,-8.99,-9.13,-9.33,-9.58,-9.87,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-10,-10,-9.42,-8.25,-6.60,-4.68,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,7.87,7.22,7.36,7.32,7.25,7.12,7.07,7.07,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.99,6.98,6.97,6.95,6.87,6.84,6.75,6.62,6.50,6.37,6.25,6.20,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,6,5.98,5.95,5.83,5.62,5.36,5.32,5.75,5.87,5.98,5.99,6,6,6,5.99,5.99,5.87,5.87,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.95,4.82,4.71,4.62,4.75,4.87,4.98,4.87,4.62,4.25,4.09,4,3.99,3.99,3.99,3.98,3.87,3.75,3.50,3.37,3.37,3.37,3.62,3.75,3.12,3.12,3,3,3,3,3,3,3,3,2.99,2.99,2.98,2.95,2.87,2.72,2.50,2.25,2.12,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2.97,2.99,2.97,2.87,2.75,2.50,2.10,1.49,0.74,-0.13,-0.88,-1.53,-2.13,-2.50,-2.75,-2.90,-3.09,-3.34,-3.72,-4.24,-4.86,-5.49,-6.11,-6.63,-7.10,-7.50,-7.87,-8.12,-8.26,-8.38,-8.48,-8.62,-8.79,-9.05,-9.38,-9.74,-10,-10,-10,-10,-11,-11,-11,-11,-10,-10,-10,-9.88,-9.03,-7.85,-6.17,-4.22,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.20,7.12,7,7,7.07,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.99,6.98,6.97,6.95,6.87,6.85,6.75,6.62,6.50,6.37,6.25,6.12,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.96,5.84,5.62,5.35,5.12,5.12,5.22,5.87,5.87,5.99,6,6,5.99,5.99,5.87,5.86,5.09,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.87,4.75,4.61,4.37,4.50,4.72,4.87,4.98,4.87,4.62,4.25,4.09,4,3.99,3.99,3.99,3.98,3.87,3.62,3.37,3.12,3.11,3.21,3.32,3.25,3.12,3,3,3,3,3,3,3,3,3,2.99,2.99,2.99,2.97,2.87,2.82,2.62,2.37,2.23,2.09,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2.96,2.99,2.87,2.87,2.74,2.48,2,1.37,0.61,-0.25,-1.04,-1.75,-2.25,-2.63,-2.79,-2.96,-3.14,-3.42,-3.86,-4.39,-5.01,-5.65,-6.23,-6.63,-6.97,-7.25,-7.53,-7.74,-7.86,-7.92,-7.97,-8.01,-8.24,-8.50,-8.84,-9.22,-9.61,-9.97,-10,-10,-10,-10,-10,-10,-10,-10,-9.92,-9.35,-8.51,-7.35,-5.72,-3.77,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,7.12,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.99,6.99,6.99,6.99,6.99,6.99,6.98,6.97,6.95,6.87,6.85,6.75,6.62,6.50,6.37,6.25,6.12,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.98,5.96,5.97,5.85,5.70,5.34,5.12,5,5,5.12,5,5.87,5.99,5.99,5.99,5.99,5.87,5.82,5.12,5.11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.87,4.75,4.61,4.37,4.21,4.37,4.62,4.87,4.87,4.75,4.50,4.24,4.07,4,3.99,3.99,3.98,3.97,3.87,3.62,3.36,3.12,3.08,3.10,3.12,3.12,3.08,3,3,3,3,3,3,3,3,3,3,3,2.99,2.99,2.97,2.87,2.75,2.50,2.34,2.12,2.12,2.12,2.10,2.08,2,2,2,2,2,2,2,2,2,2,2.95,2.87,2.87,2.85,2.71,2.37,1.97,1.25,0.49,-0.38,-1.25,-1.88,-2.38,-2.67,-2.88,-3.01,-3.24,-3.58,-4.05,-4.63,-5.24,-5.85,-6.49,-6.75,-6.73,-7,-7.25,-7.39,-7.49,-7.50,-7.49,-7.50,-7.58,-7.90,-8.26,-8.65,-9.08,-9.46,-9.78,-10,-10,-10,-10,-10,-10,-9.87,-9.40,-8.78,-7.93,-6.80,-5.25,-3.46,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.08,7.12,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.99,6.99,6.99,6.99,6.98,6.98,6.97,6.95,6.87,6.86,6.75,6.62,6.50,6.37,6.25,6.12,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.98,5.96,5.87,5.82,5.75,5.25,5.12,5,5,5,5,5,5.87,5.87,5.98,5.98,5.87,5.75,5.12,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.96,4.85,4.62,4.37,4.12,4.11,4.34,4.62,4.87,4.75,4.60,4.35,4.12,4,4,3.99,3.99,3.98,3.96,3.84,3.62,3.37,3.12,3.10,3.09,3.09,3.09,3.07,3,3,3,3,3,3,3,3,3,3,3,3,2.99,2.99,2.96,2.87,2.70,2.48,2.37,2.36,2.35,2.35,2.25,2.12,2,2,2,2,2,2,2,2,2,2.95,2.87,2.87,2.75,2.62,2.35,1.87,1.20,0.37,-0.51,-1.38,-2,-2.50,-2.75,-2.90,-3,-3.25,-3.66,-4.25,-4.92,-5.50,-5.93,-6.40,-6.55,-6.54,-6.83,-7.02,-7.13,-7.17,-7.15,-7.11,-7.08,-7.13,-7.33,-7.65,-8.09,-8.52,-8.96,-9.33,-9.62,-9.83,-9.93,-9.99,-9.92,-9.73,-9.41,-8.97,-8.33,-7.48,-6.38,-4.89,-3.24,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.98,6.98,6.98,6.98,6.97,6.95,6.87,6.86,6.75,6.62,6.50,6.37,6.25,6.12,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.97,5.87,5.87,5.75,5.62,5.35,5.12,5,5,5,5,5,5,5.08,5.87,5.87,5.87,5.82,5.12,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.87,4.74,4.46,4.22,4,4.12,4.32,4.60,4.75,4.61,4.37,4.12,4,4,4,3.99,3.99,3.97,3.87,3.83,3.62,3.37,3.25,3.12,3.12,3.12,3.12,3.12,3.10,3.08,3,3,3,3,3,3,3,3,3,3,3,2.99,2.98,2.87,2.82,2.72,2.62,2.62,2.62,2.62,2.62,2.25,2.12,2,2,2,2,2,2,2,2,2.95,2.87,2.84,2.73,2.50,2.21,1.71,1,0.21,-0.66,-1.50,-2.13,-2.54,-2.80,-2.93,-3,-3.36,-3.89,-4.51,-5.16,-6,-5.89,-5.72,-6.12,-6.47,-6.72,-6.88,-6.97,-6.97,-6.90,-6.84,-6.78,-6.83,-7,-7.28,-7.66,-8.09,-8.49,-8.85,-9.13,-9.37,-9.51,-9.58,-9.52,-9.35,-9.03,-8.58,-7.92,-7.10,-6.01,-4.62,-3.05,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.98,6.98,6.97,6.96,6.87,6.87,6.85,6.75,6.62,6.50,6.37,6.25,6.12,6.10,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.98,5.96,5.87,5.86,5.75,5.59,5.37,5.12,5,5,5,5,5,5,5,5,5.09,5.87,5.86,5.12,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.87,4.62,4.34,4.11,4,4.12,4.25,4.50,4.50,4.37,4.12,4,4,4,4,3.99,3.99,3.97,3.87,3.84,3.62,3.50,3.37,3.32,3.25,3.25,3.23,3.21,3.12,3.12,3.11,3,3,3,3,3,3,3.12,3.12,3.12,3,2.99,2.98,2.96,2.87,2.87,2.87,2.87,2.87,2.87,2.75,2.75,2.12,2.12,2,2,2,2,2,2,2,2.95,2.86,2.75,2.60,2.36,2,1.47,0.75,-0.13,-0.88,-1.63,-2.13,-2.53,-2.78,-2.92,-3.03,-3.55,-4.11,-4.68,-5.25,-5.63,-5.79,-5.76,-6.15,-6.47,-6.68,-6.83,-6.87,-6.84,-6.75,-6.66,-6.62,-6.64,-6.78,-7.12,-7.42,-7.77,-8.13,-8.47,-8.75,-8.99,-9.13,-9.23,-9.21,-9.02,-8.74,-8.27,-7.64,-6.83,-5.75,-4.46,-2.98,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.98,6.97,6.96,6.95,6.87,6.87,6.83,6.75,6.62,6.50,6.37,6.25,6.12,6.11,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.98,5.98,5.96,5.87,5.87,5.84,5.73,5.58,5.37,5.12,5,5,5,5,5,5,5,5,5,5,5.08,5.09,5.11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.87,4.75,4.50,4.25,4.12,4.12,4.22,4.33,4.37,4.32,4.12,4,4,4,4,4,3.99,3.99,3.97,3.87,3.86,3.75,3.62,3.50,3.47,3.37,3.37,3.35,3.25,3.25,3.25,3.12,3.12,3,3.12,3.12,3.23,3.12,3.24,3.73,3.12,3,2.99,2.99,2.98,2.98,2.97,2.97,2.97,2.97,2.96,2.95,2.85,2.85,2.12,2.11,2,2,2,2,2,2,2.96,2.75,2.62,2.37,2.12,1.74,1.12,0.37,-0.38,-1.13,-1.75,-2.25,-2.63,-2.88,-2.93,-3.15,-3.75,-4.26,-4.77,-5.21,-5.52,-5.75,-5.89,-6.26,-6.54,-6.75,-6.85,-6.86,-6.78,-6.71,-6.60,-6.52,-6.53,-6.73,-6.92,-7.18,-7.50,-7.84,-8.13,-8.42,-8.66,-8.85,-8.93,-8.96,-8.79,-8.51,-8.09,-7.48,-6.67,-5.65,-4.42,-3.05,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.99,6.98,6.98,6.98,6.97,6.96,6.95,6.87,6.87,6.82,6.74,6.62,6.50,6.37,6.25,6.20,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.98,5.98,5.97,5.95,5.87,5.87,5.75,5.71,5.57,5.37,5.22,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.87,4.75,4.60,4.37,4.23,4.22,4.25,4.37,4.37,4.35,4.20,4.07,4,4,4,4,4,3.99,3.99,3.97,3.95,3.87,3.82,3.74,3.62,3.62,3.59,3.50,3.47,3.37,3.34,3.25,3.22,3.12,3,3.12,3.72,3.24,3.72,3.24,3.12,3.12,3,2.99,2.99,2.99,2.99,2.99,2.99,2.99,2.99,2.99,2.98,2.98,2.87,2.86,2.12,2,2,2,2,2,2,2.97,2.57,2.45,2.24,1.87,1.37,0.75,0.07,-0.65,-1.38,-1.92,-2.38,-2.68,-2.89,-3.14,-3.50,-3.90,-4.38,-4.85,-5.23,-5.53,-5.84,-6.10,-6.46,-6.73,-6.88,-6.93,-6.91,-6.84,-6.71,-6.59,-6.50,-6.53,-6.63,-6.77,-7,-7.27,-7.59,-7.88,-8.17,-8.41,-8.62,-8.74,-8.75,-8.64,-8.39,-8,-7.41,-6.66,-5.71,-4.55,-3.33,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.99,6.99,6.99,6.98,6.98,6.97,6.96,6.95,6.87,6.87,6.82,6.73,6.62,6.50,6.37,6.32,6.21,6.12,6.07,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.98,5.97,5.95,5.87,5.85,5.75,5.62,5.50,5.37,5.23,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.96,4.85,4.62,4.37,4.22,4.12,4.32,4.50,4.62,4.60,4.37,4.12,4,4,4,4,4,4,3.99,3.99,3.98,3.96,3.87,3.87,3.84,3.75,3.75,3.72,3.62,3.58,3.47,3.37,3.25,3.21,3.12,3.10,3.23,3.24,3.25,3.12,3.12,3,3,3,3,3,3,3,3,3,2.99,2.99,2.99,2.99,2.99,2.99,2.86,2.12,2,2,2,2,2,2,2,2.35,2.25,2,1.62,1.09,0.45,-0.26,-1,-1.63,-2.13,-2.51,-2.76,-2.96,-3.24,-3.61,-4.03,-4.50,-4.92,-5.28,-5.62,-5.97,-6.36,-6.71,-6.96,-7.09,-7.11,-7.03,-6.91,-6.76,-6.61,-6.49,-6.50,-6.54,-6.66,-6.86,-7.12,-7.39,-7.71,-8,-8.25,-8.47,-8.60,-8.64,-8.61,-8.36,-7.99,-7.42,-6.73,-5.86,-4.86,-3.89,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.99,6.98,6.98,6.97,6.97,6.96,6.95,6.87,6.87,6.82,6.73,6.62,6.50,6.37,6.25,6.22,6.12,6.07,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.97,5.95,5.87,5.85,5.75,5.62,5.50,5.37,5.25,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.87,4.74,4.46,4.22,4.09,4.12,4.35,4.60,4.75,4.74,4.50,4.25,4.07,4,4,4,4,4,3.99,3.99,3.98,3.97,3.96,3.87,3.87,3.87,3.86,3.83,3.75,3.62,3.50,3.37,3.25,3.12,3.12,3.21,3.25,3.72,3.12,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2.99,2.86,2.12,2.10,2,2,2,2,2,2,2.25,2.12,1.86,1.37,0.84,0.12,-0.55,-1.25,-1.88,-2.30,-2.63,-2.88,-3,-3.26,-3.62,-4.03,-4.50,-4.96,-5.38,-5.74,-6.21,-6.66,-7.02,-7.25,-7.37,-7.30,-7.22,-7.05,-6.87,-6.65,-6.50,-6.50,-6.50,-6.59,-6.75,-6.99,-7.26,-7.58,-7.87,-8.13,-8.35,-8.50,-8.59,-8.59,-8.40,-8.02,-7.54,-6.90,-6.11,-5.22,-4.36,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.99,6.98,6.98,6.98,6.98,6.97,6.96,6.95,6.87,6.87,6.82,6.73,6.62,6.50,6.37,6.25,6.21,6.12,6.08,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.97,5.95,5.87,5.86,5.75,5.62,5.50,5.37,5.25,5.12,5.07,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,5,5,4.99,4.99,5,5,5,5,4.99,4.99,4.99,4.99,4.99,4.99,4.99,4.99,4.98,4.87,4.62,4.34,4.12,4.09,4.24,4.48,4.72,4.87,4.84,4.62,4.25,4.09,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.96,3.95,3.87,3.87,3.87,3.84,3.75,3.62,3.46,3.25,3.12,3.12,3.22,3.62,3.25,3.12,3.12,3.12,3.12,3,3,3,3,3,3,3,3,3,3,3,3,3,2.99,2.87,2.87,2.10,2.09,2,2,2,2,3,2.34,2,1.72,1.25,0.62,-0.05,-0.78,-1.50,-2.02,-2.50,-2.75,-2.88,-3,-3.26,-3.60,-3.99,-4.46,-4.96,-5.47,-5.93,-6.50,-6.99,-7.34,-7.53,-7.62,-7.59,-7.40,-7.22,-6.99,-6.75,-6.54,-6.50,-6.48,-6.53,-6.66,-6.88,-7.16,-7.48,-7.76,-8.03,-8.25,-8.42,-8.53,-8.55,-8.39,-8.13,-7.71,-7.12,-6.39,-5.60,-4.83,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.99,6.98,6.98,6.98,6.98,6.96,6.95,6.87,6.87,6.83,6.74,6.62,6.50,6.37,6.25,6.21,6.12,6.08,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.98,5.96,5.87,5.86,5.75,5.62,5.50,5.37,5.25,5.12,5.09,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.98,4.87,4.87,4.87,4.97,4.99,4.99,5,5,5,4.99,4.99,4.98,4.97,4.97,4.97,4.97,4.87,4.87,4.75,4.50,4.24,4.11,4.12,4.45,4.75,4.98,5,4.87,4.62,4.33,4.11,4,4,4,4,4,3.99,3.99,3.98,3.98,3.98,3.97,3.97,3.96,3.95,3.87,3.87,3.82,3.62,3.50,3.34,3.20,3.12,3.12,3.12,3.12,3,3.12,3.72,3.12,3,3,3,3,3,3,3,3,3,3,3,3,3,2.99,2.99,2.87,2.87,2.09,2.07,2,2,2,3,2.25,2,1.62,1.12,0.50,-0.17,-0.92,-1.63,-2.14,-2.53,-2.77,-2.91,-3,-3.23,-3.50,-3.88,-4.38,-4.93,-5.53,-6.16,-6.75,-7.25,-7.60,-7.77,-7.84,-7.76,-7.62,-7.37,-7.11,-6.85,-6.61,-6.51,-6.48,-6.50,-6.63,-6.84,-7.11,-7.40,-7.68,-7.93,-8.16,-8.36,-8.49,-8.52,-8.41,-8.21,-7.85,-7.33,-6.65,-5.91,-5.22,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.98,6.98,6.97,6.97,6.95,6.87,6.87,6.83,6.74,6.62,6.50,6.37,6.25,6.22,6.12,6.08,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.97,5.87,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.97,4.83,4.75,4.12,4.85,4.87,4.87,4.98,4.99,5,5,4.99,4.96,4.87,4.87,4.87,4.87,4.87,4.85,4.73,4.50,4.36,4.12,4.10,4.25,4.70,5.12,5.37,5.25,5,4.70,4.33,4.11,4,4,4,4,4,3.99,3.99,3.99,3.98,3.98,3.98,3.98,3.97,3.97,3.95,3.87,3.85,3.72,3.50,3.36,3.21,3.12,3.09,3.08,3,3,3.12,3.12,3.12,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2.99,2.99,2.87,2.87,2.07,2,2,2,2,2,1.96,1.62,1.20,0.58,-0.16,-0.88,-1.53,-2.13,-2.50,-2.75,-2.89,-3,-3.15,-3.38,-3.75,-4.28,-4.90,-5.59,-6.30,-6.90,-7.39,-7.74,-7.91,-7.96,-7.88,-7.72,-7.50,-7.25,-6.89,-6.63,-6.53,-6.50,-6.51,-6.63,-6.83,-7.08,-7.36,-7.62,-7.87,-8.09,-8.27,-8.42,-8.50,-8.40,-8.24,-7.90,-7.43,-6.85,-6.16,-5.51,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.99,6.98,6.98,6.98,6.98,6.97,6.96,6.87,6.87,6.83,6.74,6.62,6.50,6.37,6.32,6.23,6.12,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.98,5.96,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.96,4.87,4.75,4.62,4.37,4.32,4.25,4.22,4.83,4.87,4.99,5,4.99,4.98,4.87,4.75,4.71,4.75,4.75,4.75,4.70,4.50,4.37,4.23,4.12,4.12,4.36,4.84,5.37,5.72,5.50,5.12,4.73,4.33,4.11,4,4,4,4,4,4,3.99,3.99,3.99,3.99,3.98,3.98,3.98,3.97,3.96,3.87,3.85,3.73,3.57,3.37,3.22,3.11,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3.12,3.12,3.12,3,3,3,3,2.99,2.99,2.87,2.07,2,2,2,2,2,1.97,1.72,1.32,0.72,0,-0.75,-1.38,-2,-2.38,-2.67,-2.88,-3,-3.10,-3.26,-3.63,-4.18,-4.88,-5.59,-6.29,-6.89,-7.38,-7.74,-7.89,-7.92,-7.86,-7.72,-7.55,-7.28,-6.93,-6.67,-6.58,-6.52,-6.54,-6.64,-6.83,-7.04,-7.28,-7.52,-7.76,-8,-8.18,-8.36,-8.43,-8.38,-8.22,-7.91,-7.49,-6.92,-6.28,-5.65,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.99,6.99,6.98,6.98,6.97,6.97,6.96,6.95,6.87,6.84,6.75,6.62,6.50,6.37,6.33,6.24,6.12,6.12,6.09,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.98,5.87,5.84,5.71,5.50,5.37,5.25,5.12,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.97,4.95,4.87,4.75,4.61,4.37,4.23,4.12,4.10,4.20,4.37,4.72,4.87,4.98,4.98,4.86,4.75,4.45,4.47,4.50,4.57,4.50,4.48,4.36,4.23,4.12,4.11,4.12,4.37,4.97,5.50,5.84,5.62,5.12,4.75,4.33,4.11,4,4,4,4,4,4,3.99,3.99,3.99,3.99,3.99,3.98,3.98,3.97,3.96,3.87,3.84,3.71,3.50,3.37,3.24,3.12,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3.12,3.24,3.75,3.21,3.12,3,3,3,3,2.99,2.87,2.07,2,2,2,2,2,2,1.87,1.50,1,0.33,-0.39,-1.13,-1.75,-2.25,-2.63,-2.88,-3,-3.03,-3.22,-3.54,-4.13,-4.92,-5.64,-6.25,-6.73,-7.18,-7.52,-7.71,-7.77,-7.74,-7.65,-7.43,-7.23,-6.90,-6.67,-6.60,-6.54,-6.58,-6.65,-6.80,-7,-7.22,-7.43,-7.66,-7.89,-8.11,-8.25,-8.33,-8.28,-8.13,-7.84,-7.41,-6.88,-6.26,-5.68,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.07,7.09,7.10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.98,6.98,6.98,6.98,6.97,6.96,6.95,6.87,6.87,6.75,6.62,6.57,6.37,6.33,6.24,6.12,6.12,6.12,6.09,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.98,5.96,5.87,5.75,5.60,5.37,5.25,5.12,5.09,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.95,4.87,4.75,4.60,4.37,4.24,4.12,4.07,4,4.08,4.25,4.50,4.75,4.87,4.75,4.75,4.23,4.25,4.24,4.25,4.33,4.32,4.25,4.20,4.12,4.11,4.12,4.36,4.62,5.12,5.58,5.82,5.62,5.22,4.75,4.33,4.11,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.98,3.98,3.87,3.87,3.82,3.62,3.50,3.37,3.24,3.12,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3.23,3.75,3.75,3.75,3.20,3.12,3,3,3,2.99,2.87,2,2,2,2,2,2,2,1.87,1.72,1.25,0.71,-0.01,-0.75,-1.50,-2.04,-2.50,-2.78,-2.93,-3,-3.14,-3.49,-4.12,-4.89,-5.74,-6.25,-6.48,-6.92,-7.25,-7.47,-7.53,-7.51,-7.40,-7.25,-7.08,-6.83,-6.64,-6.54,-6.54,-6.59,-6.65,-6.77,-6.96,-7.13,-7.36,-7.59,-7.80,-8.02,-8.17,-8.25,-8.24,-8.08,-7.78,-7.38,-6.84,-6.18,-5.58,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.10,7.87,7.12,7.12,7.12,7.12,7.12,7.12,7.12,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.98,6.98,6.98,6.98,6.97,6.97,6.96,6.87,6.87,6.85,6.74,6.62,6.49,6.36,6.25,6.12,6.12,6.12,6.11,6.08,6,6,6,6,6,6,5.99,5.99,5.98,5.98,5.98,5.98,5.98,5.98,5.98,5.98,5.98,5.97,5.87,5.85,5.62,5.48,5.25,5.12,5.08,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.95,4.87,4.75,4.60,4.37,4.25,4.12,4,4,4,4,4.12,4.37,4.61,4.62,4.61,4.37,4.12,4.07,4.10,4.12,4.12,4.12,4.12,4.09,4.09,4.12,4.33,4.60,4.98,5.37,5.71,5.75,5.62,5.23,4.75,4.36,4.12,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.98,3.96,3.87,3.87,3.75,3.62,3.50,3.37,3.24,3.12,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3.24,3.75,3.98,3.87,3.75,3.12,3.12,3,3,2.99,2.87,2,2,2,2,2,2,2,1.96,1.85,1.59,1.11,0.45,-0.28,-1.02,-1.75,-2.29,-2.68,-2.90,-3,-3.10,-3.38,-3.97,-4.74,-5.50,-5.97,-6,-6.43,-6.77,-7,-7.13,-7.15,-7.12,-7,-6.87,-6.68,-6.58,-6.51,-6.51,-6.58,-6.63,-6.74,-6.88,-7.05,-7.27,-7.52,-7.76,-8,-8.14,-8.22,-8.17,-8.01,-7.72,-7.26,-6.71,-6.02,-5.36,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.12,7.12,7.82,7.86,7.98,7.98,7.86,7.75,7.22,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.98,6.98,6.98,6.97,6.97,6.96,6.95,6.87,6.87,6.83,6.71,6.58,6.37,6.25,6.20,6.12,6.11,6.10,6.09,6.07,6,6,6,6,6,6,5.99,5.99,5.98,5.98,5.98,5.98,5.98,5.98,5.97,5.97,5.96,5.95,5.87,5.75,5.61,5.37,5.21,5.08,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.96,4.87,4.75,4.61,4.37,4.24,4.12,4.07,4,4,4,4,4.07,4.12,4.35,4.37,4.35,4.20,4.07,4,4,4,4,4,4,4,4.10,4.25,4.50,4.87,5.25,5.60,5.84,5.75,5.62,5.25,4.85,4.46,4.22,4,4,4,4,4,4,4,4,4,4,3.98,3.98,3.97,3.96,3.87,3.87,3.75,3.62,3.50,3.37,3.24,3.12,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3.23,3.75,3.98,3.99,3.87,3.84,3.12,3.11,3,2.99,2.87,2,2,2,2,2,2,2,1.97,1.87,1.75,1.37,0.87,0.12,-0.53,-1.25,-1.88,-2.38,-2.68,-2.88,-3,-3.25,-3.74,-4.38,-5,-5.40,-5.52,-5.96,-6.29,-6.54,-6.72,-6.79,-6.80,-6.76,-6.66,-6.53,-6.46,-6.43,-6.48,-6.52,-6.60,-6.66,-6.85,-7.02,-7.25,-7.50,-7.76,-8,-8.16,-8.24,-8.18,-8.01,-7.68,-7.22,-6.59,-5.84,-5.08,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.86,8.75,8.75,8.75,8.75,7.75,7.24,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.98,6.98,6.98,6.97,6.97,6.96,6.95,6.87,6.87,6.87,6.75,6.62,6.50,6.37,6.25,6.12,6.11,6.08,6.08,6.07,6,6,6,6,6,6,6,5.99,5.99,5.98,5.98,5.97,5.97,5.97,5.97,5.96,5.95,5.87,5.87,5.83,5.71,5.50,5.33,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.98,4.95,4.87,4.75,4.62,4.37,4.23,4.11,4,4,4,4,4,4,4,4.08,4.12,4.12,4.12,4.07,4,4,4,4,3.99,3.99,3.99,4,4.12,4.36,4.70,5.11,5.49,5.75,5.86,5.75,5.61,5.25,4.96,4.62,4.36,4.12,4,4,4,4,4,4,4,4,3.99,3.98,3.98,3.97,3.96,3.87,3.87,3.75,3.62,3.50,3.37,3.24,3.12,3,3,3,3,3,3,3,3,3,3,3,3,3,3.07,3.25,3.75,3.99,3.99,3.99,3.87,3.86,3.12,3,2.99,2.87,2,2,2,2,3,2,2,1.98,1.95,1.85,1.59,1.12,0.59,-0.13,-0.80,-1.50,-2.05,-2.50,-2.77,-2.90,-3.12,-3.49,-3.98,-4.49,-4.87,-5.09,-5.50,-5.85,-6.12,-6.33,-6.46,-6.52,-6.53,-6.50,-6.47,-6.41,-6.43,-6.49,-6.52,-6.59,-6.67,-6.86,-7.04,-7.29,-7.58,-7.86,-8.09,-8.25,-8.29,-8.25,-8.04,-7.71,-7.17,-6.48,-5.61,-4.68,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.22,7.98,8.75,8.75,8.74,8.25,7.75,7.25,7,7,7,7,7,7,7,7.12,7.23,7.22,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.98,6.98,6.98,6.97,6.96,6.96,6.95,6.87,6.87,6.86,6.75,6.62,6.50,6.37,6.24,6.12,6.08,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.98,5.97,5.97,5.97,5.96,5.95,5.87,5.87,5.83,5.74,5.61,5.45,5.25,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.98,4.97,4.95,4.87,4.85,4.75,4.60,4.37,4.23,4.10,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.97,3.97,3.95,3.87,3.98,4.12,4.37,4.83,5.25,5.62,5.85,5.87,5.75,5.60,5.33,5,4.75,4.50,4.24,4.07,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.96,3.87,3.87,3.75,3.62,3.50,3.37,3.24,3.12,3,3,3,3,3,3,3,3,3,3,3,3,3,3.09,3.25,3.75,3.98,3.99,3.99,3.99,3.86,3.12,3,2.99,2.95,2,2,2,3,3,2,2,1.99,1.97,1.87,1.62,1.35,0.87,0.25,-0.38,-1.13,-1.75,-2.25,-2.63,-2.77,-2.99,-3.33,-3.72,-4.15,-4.61,-5,-5.25,-5.42,-5.74,-5.97,-6.14,-6.27,-6.35,-6.37,-6.39,-6.40,-6.47,-6.51,-6.55,-6.64,-6.75,-6.96,-7.16,-7.42,-7.72,-8,-8.23,-8.37,-8.40,-8.34,-8.13,-7.75,-7.18,-6.40,-5.38,-4.18,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.24,7.99,8.74,8.73,8.25,8.09,7.71,7.25,7,7,7,7,7,7,7,7.24,7.74,7.75,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.98,6.97,6.97,6.96,6.95,6.87,6.87,6.87,6.84,6.75,6.62,6.50,6.36,6.23,6.12,6.07,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.98,5.97,5.97,5.96,5.95,5.87,5.87,5.84,5.75,5.62,5.50,5.37,5.22,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.99,4.99,4.98,4.97,4.87,4.87,4.82,4.72,4.59,4.37,4.25,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.97,3.95,3.87,3.87,3.84,3.87,4,4.37,4.87,5.35,5.70,5.87,5.87,5.75,5.58,5.33,5.07,4.85,4.62,4.25,4.09,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.96,3.87,3.87,3.75,3.70,3.50,3.37,3.24,3.12,3,3,3,3,3,3,3,3,3,3,3,3,3,3.08,3.25,3.75,3.84,3.99,3.99,3.99,3.87,3.10,3.09,3,2.97,2,2,3,3,3,2,2,1.99,1.98,1.87,1.75,1.46,1.08,0.50,-0.13,-0.75,-1.30,-1.88,-2.38,-2.62,-2.85,-3.13,-3.47,-3.92,-4.43,-4.88,-5.11,-5.09,-5.39,-5.66,-5.89,-6.05,-6.18,-6.28,-6.38,-6.46,-6.53,-6.60,-6.66,-6.76,-6.88,-7.09,-7.36,-7.63,-7.92,-8.18,-8.39,-8.51,-8.54,-8.47,-8.23,-7.83,-7.24,-6.40,-5.25,-3.73,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.24,7.74,7.97,8.21,8.23,8.10,7.87,7.62,7.25,7,7,7,7,7,7,7,7.24,7.73,7.25,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.97,6.96,6.95,6.87,6.87,6.87,6.87,6.83,6.75,6.62,6.50,6.36,6.23,6.12,6.07,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.98,5.98,5.97,5.97,5.95,5.87,5.87,5.84,5.75,5.62,5.50,5.37,5.25,5.12,5.08,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.98,4.98,4.98,4.97,4.96,4.87,4.87,4.75,4.62,4.57,4.37,4.25,4.12,4.07,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.98,3.97,3.95,3.87,3.83,3.74,3.62,3.71,3.87,4.25,4.75,5.25,5.62,5.75,5.75,5.62,5.50,5.25,5,4.85,4.62,4.33,4.11,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.96,3.87,3.87,3.75,3.62,3.50,3.37,3.24,3.12,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3.12,3.25,3.75,3.84,3.99,3.99,3.87,3.87,3.08,3,2.98,3,2,3,3,3,2,2,1.99,1.98,1.87,1.75,1.50,1.12,0.72,0.21,-0.38,-1,-1.53,-2.04,-2.50,-2.71,-2.96,-3.27,-3.76,-4.23,-4.62,-4.87,-5.04,-5.18,-5.41,-5.67,-5.90,-6.11,-6.25,-6.40,-6.53,-6.64,-6.74,-6.83,-6.91,-7.05,-7.28,-7.58,-7.88,-8.16,-8.40,-8.60,-8.71,-8.72,-8.61,-8.35,-7.91,-7.30,-6.46,-5.29,-3.47,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.24,7.72,7.85,7.97,7.98,7.86,7.62,7.34,7.12,7,7,7,7,7,7,7,7.12,7.12,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.97,6.96,6.95,6.87,6.87,6.87,6.86,6.82,6.74,6.62,6.50,6.36,6.23,6.12,6.07,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.98,5.98,5.97,5.96,5.87,5.87,5.86,5.75,5.71,5.60,5.47,5.33,5.21,5.11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.98,4.98,4.97,4.96,4.87,4.87,4.75,4.62,4.50,4.37,4.25,4.12,4.10,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.96,3.87,3.83,3.71,3.59,3.48,3.50,3.62,4,4.50,5,5.49,5.50,5.50,5.45,5.34,5.12,5,4.82,4.61,4.25,4.10,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.97,3.96,3.87,3.87,3.75,3.62,3.50,3.37,3.24,3.12,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3.07,3.12,3.25,3.75,3.85,3.99,3.99,3.87,3.07,3,3,3,2,2,3,2,2,2,1.99,1.99,1.87,1.75,1.50,1.22,0.87,0.37,-0.13,-0.63,-1.25,-1.75,-2.25,-2.54,-2.80,-3.12,-3.58,-4.01,-4.43,-4.78,-5.02,-5.17,-5.25,-5.54,-5.80,-6.04,-6.25,-6.46,-6.62,-6.75,-6.88,-6.98,-7.09,-7.25,-7.49,-7.78,-8.10,-8.38,-8.62,-8.79,-8.88,-8.88,-8.75,-8.48,-8.02,-7.38,-6.52,-5.41,-3.38,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.25,7.62,7.82,7.82,7.62,7.35,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.97,6.96,6.95,6.87,6.87,6.87,6.86,6.75,6.73,6.62,6.50,6.36,6.23,6.12,6.08,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.98,5.98,5.97,5.95,5.87,5.87,5.82,5.74,5.62,5.50,5.37,5.25,5.12,5.07,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.98,4.98,4.98,4.97,4.96,4.87,4.87,4.75,4.62,4.50,4.37,4.25,4.20,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.96,3.87,3.84,3.71,3.57,3.37,3.35,3.25,3.46,3.75,4.12,4.59,4.87,5,5.08,5.10,5.09,5,4.87,4.70,4.49,4.25,4.10,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.97,3.96,3.95,3.87,3.87,3.75,3.62,3.50,3.37,3.24,3.12,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3.10,3.23,3.82,3.87,3.99,3.87,3,3,3,3,2,2,2,2,2,2,2,1.99,1.87,1.74,1.50,1.25,0.96,0.60,0.12,-0.38,-0.90,-1.50,-2,-2.39,-2.68,-2.99,-3.39,-3.83,-4.29,-4.74,-5.08,-5.21,-5.14,-5.46,-5.75,-6.01,-6.26,-6.50,-6.68,-6.87,-7,-7.11,-7.22,-7.39,-7.63,-7.96,-8.28,-8.61,-8.83,-8.98,-9.05,-9.03,-8.90,-8.61,-8.13,-7.49,-6.62,-5.54,-3.67,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.33,7.62,7.62,7.35,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.97,6.96,6.95,6.87,6.87,6.87,6.86,6.75,6.73,6.62,6.50,6.36,6.23,6.12,6.09,6.07,6.07,6,6,6,6,6,6,6,5.99,5.99,5.98,5.98,5.97,5.96,5.87,5.87,5.85,5.75,5.62,5.50,5.37,5.25,5.12,5.09,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.98,4.98,4.97,4.96,4.87,4.87,4.75,4.62,4.50,4.37,4.25,4.20,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.97,3.87,3.85,3.73,3.58,3.37,3.25,3.20,3.12,3.25,3.48,3.75,4,4.22,4.37,4.50,4.71,4.82,4.82,4.72,4.50,4.35,4.12,4.07,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.97,3.96,3.87,3.87,3.85,3.75,3.62,3.50,3.37,3.24,3.12,3,3,3,3,3,3,3,3,3,3,3,3,2.99,2.98,2.95,2.85,2.75,2.82,3.12,3.87,3.87,3.87,3,3,3,3,2,2,2,2,2,2,2,1.99,1.87,1.74,1.50,1.25,1,0.74,0.36,-0.13,-0.64,-1.25,-1.80,-2.25,-2.59,-2.88,-3.27,-3.68,-4.12,-4.52,-4.85,-5.03,-5.05,-5.39,-5.72,-6,-6.27,-6.53,-6.75,-6.93,-7.10,-7.22,-7.30,-7.48,-7.73,-8.05,-8.38,-8.68,-8.92,-9.11,-9.18,-9.17,-9.03,-8.75,-8.26,-7.60,-6.73,-5.61,-3.76,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.25,7.25,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.97,6.97,6.96,6.95,6.87,6.87,6.87,6.86,6.75,6.74,6.62,6.50,6.37,6.23,6.12,6.09,6.08,6.08,6.07,6,6,6,6,6,6,5.99,5.99,5.98,5.98,5.97,5.96,5.87,5.87,5.75,5.71,5.60,5.47,5.33,5.21,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.98,4.98,4.97,4.96,4.87,4.87,4.82,4.71,4.57,4.37,4.25,4.20,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.98,3.98,3.87,3.87,3.75,3.59,3.37,3.25,3.12,3.10,3.10,3.12,3.24,3.37,3.50,3.62,3.83,4.07,4.34,4.50,4.58,4.50,4.37,4.24,4.11,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.97,3.96,3.87,3.87,3.85,3.75,3.62,3.50,3.37,3.25,3.12,3,3,3,3,3,3,3,3,3,3,3,3,2.99,2.98,2.87,2.71,2.25,2.12,2.20,3.11,3.87,3.97,3,3,3,3,2,2,2,2,2,2,2,1.99,1.87,1.74,1.50,1.34,1.10,0.84,0.50,0.09,-0.43,-1.03,-1.63,-2.13,-2.51,-2.79,-3.16,-3.53,-3.92,-4.33,-4.65,-4.88,-5.11,-5.38,-5.67,-5.99,-6.27,-6.53,-6.77,-7,-7.15,-7.27,-7.35,-7.50,-7.74,-8.04,-8.38,-8.67,-8.97,-9.14,-9.27,-9.29,-9.18,-8.90,-8.43,-7.75,-6.87,-5.72,-3.85,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.08,7.11,7.12,7.12,7.12,7,7,7,7,7,7,7.07,7.12,7.20,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.96,6.95,6.87,6.87,6.87,6.87,6.82,6.75,6.62,6.50,6.37,6.24,6.12,6.09,6.08,6.07,6,6,6,6,6,6,6,5.99,5.99,5.98,5.98,5.97,5.95,5.87,5.85,5.75,5.62,5.50,5.36,5.24,5.12,5.07,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.99,4.98,4.98,4.98,4.97,4.95,4.87,4.85,4.74,4.61,4.46,4.25,4.20,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.98,3.96,3.87,3.75,3.61,3.37,3.25,3.12,3.07,3,3,3,3.09,3.12,3.22,3.25,3.46,3.74,4,4.25,4.35,4.33,4.24,4.12,4.07,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.97,3.96,3.87,3.87,3.85,3.75,3.62,3.50,3.37,3.25,3.12,3,3,3,3,3,3,3,3,3,3,3,3,2.99,2.98,2.87,2.62,2.12,1.24,1.12,2.86,3.87,3.98,3,3,3,3,2,2,2,2,2,2,2,2,1.87,1.73,1.50,1.35,1.12,0.87,0.60,0.22,-0.28,-0.88,-1.50,-2.04,-2.43,-2.75,-3.08,-3.47,-3.85,-4.21,-4.51,-4.79,-5.04,-5.36,-5.64,-5.97,-6.25,-6.53,-6.78,-7.02,-7.18,-7.30,-7.37,-7.50,-7.68,-7.98,-8.28,-8.62,-8.91,-9.14,-9.33,-9.38,-9.35,-9.11,-8.64,-7.98,-7.04,-5.98,-4.77,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.09,7.87,7.84,7.82,7.22,7.24,7.25,7.25,7.25,7.32,7.33,7.34,7.35,7.62,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.97,6.96,6.95,6.87,6.87,6.87,6.84,6.75,6.62,6.50,6.37,6.25,6.12,6.08,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.98,5.98,5.96,5.87,5.87,5.82,5.71,5.50,5.37,5.25,5.12,5.07,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.98,4.98,4.98,4.97,4.96,4.87,4.87,4.75,4.62,4.50,4.36,4.22,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.98,3.87,3.87,3.71,3.48,3.25,3.12,3,3,3,3,3,3,3,3.08,3.12,3.32,3.59,3.87,4.10,4.12,4.20,4.12,4.08,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.97,3.96,3.95,3.87,3.86,3.75,3.62,3.50,3.37,3.25,3.12,3,3,3,3,3,3,3,3,3,3,3,3,2.99,2.98,2.87,2.70,1.99,1.23,1.20,2.12,3.08,3.98,3,3,3,3,2,2,2,2,2,2,2,2,1.87,1.74,1.57,1.36,1.12,0.87,0.62,0.25,-0.16,-0.75,-1.38,-1.93,-2.40,-2.72,-3.05,-3.43,-3.80,-4.16,-4.48,-4.75,-5,-5.29,-5.61,-5.91,-6.23,-6.50,-6.76,-7.01,-7.16,-7.29,-7.35,-7.42,-7.60,-7.85,-8.13,-8.42,-8.74,-9.02,-9.25,-9.37,-9.37,-9.15,-8.75,-8.12,-7.25,-6.27,-4.87,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.07,7.11,7.86,8.84,7.99,7.75,7.75,7.73,7.71,7.70,7.62,7.62,7.62,7.62,7.35,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.97,6.96,6.95,6.87,6.87,6.87,6.86,6.75,6.70,6.57,6.37,6.25,6.12,6.08,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.98,5.98,5.96,5.87,5.87,5.75,5.62,5.45,5.25,5.12,5.07,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.98,4.98,4.97,4.97,4.96,4.87,4.87,4.75,4.62,4.45,4.25,4.12,4.07,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.98,3.87,3.84,3.62,3.37,3.12,3,3,3,3,3,3,3,3.07,3.09,3.12,3.33,3.59,3.86,4,4.12,4.12,4.09,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.97,3.96,3.95,3.87,3.87,3.75,3.62,3.50,3.37,3.25,3.12,3.07,3,3,3,3,3,3,3,3,3,3,3,2.99,2.98,2.87,2.62,1.98,1.24,1.12,2,2.87,3,3,3,3,3,2,2,2,2,2,2,2,2,1.87,1.75,1.58,1.37,1.12,0.96,0.71,0.37,-0.05,-0.63,-1.25,-1.88,-2.38,-2.67,-3.03,-3.46,-3.85,-4.22,-4.49,-4.72,-4.96,-5.25,-5.54,-5.87,-6.16,-6.43,-6.71,-6.93,-7.10,-7.23,-7.25,-7.33,-7.43,-7.66,-7.91,-8.22,-8.51,-8.83,-9.10,-9.28,-9.34,-9.17,-8.80,-8.24,-7.47,-6.52,-5.16,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.87,7.11,7.85,7.99,8.21,8.22,8.25,8.25,8.25,8.20,8.09,7.97,7.87,7.62,7.34,7.07,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.08,7.12,7.10,7,7,6.98,6.97,6.96,6.95,6.87,6.87,6.87,6.82,6.73,6.61,6.47,6.32,6.20,6.10,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.98,5.98,5.96,5.87,5.87,5.75,5.60,5.37,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.98,4.98,4.97,4.96,4.87,4.87,4.84,4.73,4.59,4.37,4.24,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.87,3.85,3.62,3.37,3.22,3.12,3.08,3.07,3.08,3.11,3.12,3.12,3.23,3.25,3.34,3.49,3.74,3.96,4.09,4.12,4.12,4.09,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.98,3.97,3.97,3.95,3.87,3.87,3.75,3.70,3.57,3.37,3.25,3.12,3.08,3,3,3,3,3,3,3,3,3,3,3,2.99,2.98,2.87,2.71,1.99,1.22,1.12,2,2.87,3,3.99,3,3,3,3,2,2,2,2,2,2,2,1.87,1.75,1.59,1.37,1.12,0.98,0.75,0.48,0.08,-0.50,-1.13,-1.75,-2.25,-2.63,-3,-3.46,-3.88,-4.25,-4.50,-4.67,-4.89,-5.17,-5.49,-5.78,-6.09,-6.36,-6.61,-6.84,-6.97,-7.09,-7.11,-7.15,-7.25,-7.47,-7.71,-7.99,-8.28,-8.62,-8.89,-9.12,-9.17,-9.09,-8.76,-8.27,-7.63,-6.86,-5.62,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.09,7.12,7.12,7.82,8.22,8.75,8.75,8.87,8.75,8.62,8.24,8,7.87,7.62,7.33,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.10,7.12,7.12,7.09,7,6.99,6.97,6.97,6.96,6.95,6.87,6.87,6.83,6.75,6.62,6.50,6.37,6.25,6.12,6.10,6.07,6,6,6,6,6,6,5.99,5.99,5.99,5.98,5.98,5.96,5.87,5.87,5.75,5.58,5.32,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.98,4.98,4.97,4.97,4.96,4.87,4.87,4.83,4.71,4.57,4.37,4.23,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.96,3.87,3.75,3.62,3.45,3.33,3.24,3.22,3.24,3.32,3.37,3.48,3.57,3.62,3.62,3.83,4,4.12,4.23,4.23,4.12,4.11,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.98,3.97,3.97,3.96,3.87,3.87,3.83,3.73,3.61,3.47,3.33,3.12,3.10,3,3,3,3,3,3,3,3,3,3,3,2.99,2.99,2.87,2.73,2.10,1.21,1.12,2.12,2.87,3,3,3,3,3,3,2,2,2,2,2,2,2,1.87,1.75,1.60,1.37,1.12,1,0.83,0.59,0.24,-0.25,-0.88,-1.52,-2.13,-2.54,-2.96,-3.41,-3.87,-4.24,-4.49,-4.63,-4.83,-5.10,-5.38,-5.71,-5.99,-6.25,-6.48,-6.66,-6.79,-6.88,-6.91,-6.98,-7.10,-7.27,-7.52,-7.80,-8.10,-8.41,-8.72,-8.92,-9.02,-8.97,-8.73,-8.33,-7.78,-7.22,-5.93,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.82,8.10,8.75,9.73,9.12,9.62,8.73,8.33,8,7.87,7.62,7.33,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.08,7.12,7.12,7.07,7,6.99,6.98,6.97,6.97,6.96,6.87,6.87,6.86,6.75,6.70,6.57,6.46,6.34,6.25,6.12,6.12,6.12,6.10,6.08,6,6,6,6,5.99,5.98,5.99,5.98,5.97,5.95,5.87,5.75,5.50,5.25,5.09,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.98,4.98,4.97,4.97,4.95,4.87,4.87,4.75,4.70,4.50,4.37,4.22,4.10,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.98,3.97,3.87,3.87,3.84,3.62,3.50,3.49,3.50,3.62,3.75,3.87,3.99,4,4.10,4.12,4.25,4.37,4.37,4.36,4.25,4.12,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.97,3.96,3.95,3.87,3.86,3.75,3.62,3.50,3.37,3.25,3.12,3.07,3,3,3,3,3.07,3.07,3,3,3,3,2.99,2.99,2.95,2.74,2.21,1.75,1.83,2.12,2.87,2.87,3,4,3,3,3,2,2,2,2,2,2,2,1.95,1.75,1.60,1.37,1.12,1,0.87,0.71,0.37,-0.04,-0.65,-1.38,-2,-2.41,-2.88,-3.35,-3.77,-4.14,-4.39,-4.53,-4.66,-4.96,-5.28,-5.61,-5.89,-6.13,-6.35,-6.50,-6.62,-6.67,-6.75,-6.83,-6.96,-7.14,-7.38,-7.64,-7.98,-8.27,-8.55,-8.78,-8.89,-8.86,-8.67,-8.38,-7.97,-7.43,-6.17,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.20,7.75,8.24,8.73,8.87,8.75,8.62,8.24,8,7.87,7.62,7.35,7.09,7,7,7,7,7,7.25,7.25,7.25,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.97,6.96,6.96,6.95,6.87,6.87,6.75,6.73,6.62,6.50,6.37,6.35,6.25,6.24,6.21,6.12,6.12,6.11,6.08,6,6,5.99,5.98,5.98,5.97,5.96,5.87,5.87,5.73,5.50,5.25,5.07,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.98,4.98,4.97,4.97,4.95,4.87,4.87,4.75,4.62,4.50,4.37,4.23,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,4,4,4.08,4.12,4.12,3.97,3.85,3.87,3.97,4.09,4.20,4.34,4.37,4.46,4.46,4.50,4.59,4.62,4.59,4.47,4.33,4.12,4.09,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.97,3.97,3.96,3.87,3.87,3.83,3.73,3.61,3.47,3.34,3.22,3.12,3.08,3,3,3.12,3.25,3.25,3.12,3,3,3,2.99,2.99,2.96,2.74,2.23,2,2,2.12,2.11,2.87,2.96,3,3,3,2,2,2,2,2,2,2,2,1.96,1.82,1.62,1.37,1.20,1,0.87,0.72,0.37,0,-0.63,-1.25,-1.88,-2.36,-2.79,-3.24,-3.66,-4.02,-4.27,-4.43,-4.58,-4.90,-5.23,-5.52,-5.79,-6.02,-6.22,-6.36,-6.42,-6.50,-6.59,-6.67,-6.83,-7.02,-7.27,-7.59,-7.88,-8.18,-8.48,-8.67,-8.79,-8.79,-8.65,-8.40,-8.03,-7.47,-6.28,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.22,7.75,8.09,8.25,8.25,8.22,8.12,8,7.87,7.74,7.37,7.35,7.33,7.33,7.25,7.12,7.10,7.25,8.58,7.25,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.97,6.97,6.96,6.95,6.87,6.87,6.84,6.75,6.62,6.60,6.50,6.45,6.37,6.35,6.32,6.25,6.23,6.12,6.12,6.07,6,5.99,5.98,5.97,5.95,5.87,5.87,5.82,5.62,5.37,5.21,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.98,4.98,4.97,4.96,4.95,4.87,4.86,4.75,4.62,4.50,4.37,4.23,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.09,4.12,4.25,4.25,4.22,4.12,4.25,4.37,4.47,4.50,4.62,4.62,4.62,4.70,4.71,4.74,4.73,4.62,4.50,4.37,4.23,4.12,4.08,4.09,4.11,4.12,4.10,4.07,4,4,3.99,3.98,3.98,3.98,3.98,3.97,3.97,3.95,3.87,3.87,3.75,3.71,3.59,3.46,3.35,3.25,3.21,3.12,3.22,3.37,3.58,3.58,3.37,3.12,3,3,3,3,2.98,2.75,2.24,2.12,2,2,2.12,2.09,2,2,2,2,2,2,2,2,2,2,2,2,1.99,1.84,1.62,1.37,1.20,1,0.87,0.75,0.47,0,-0.63,-1.29,-1.87,-2.33,-2.74,-3.13,-3.49,-3.83,-4.10,-4.28,-4.53,-4.88,-5.18,-5.48,-5.74,-5.96,-6.13,-6.25,-6.29,-6.38,-6.48,-6.60,-6.75,-6.97,-7.24,-7.52,-7.84,-8.13,-8.39,-8.61,-8.73,-8.73,-8.62,-8.37,-7.98,-7.25,-5.84,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.25,7.73,7.71,7.75,7.87,7.98,7.99,7.96,7.86,7.75,7.72,7.72,7.72,7.61,7.37,7.21,7.25,7.25,7.25,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.97,6.96,6.95,6.87,6.87,6.85,6.75,6.72,6.62,6.58,6.50,6.48,6.45,6.37,6.36,6.25,6.22,6.12,6.08,6,5.99,5.97,5.96,5.87,5.87,5.82,5.71,5.50,5.33,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.98,4.97,4.97,4.96,4.95,4.87,4.86,4.75,4.62,4.50,4.37,4.23,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.09,4.11,4.12,4.25,4.36,4.37,4.37,4.47,4.50,4.62,4.72,4.75,4.75,4.83,4.84,4.85,4.85,4.85,4.82,4.74,4.61,4.45,4.25,4.12,4.12,4.12,4.22,4.23,4.20,4.12,4.07,4,4,3.99,3.98,3.98,3.98,3.98,3.97,3.96,3.95,3.87,3.87,3.75,3.71,3.61,3.50,3.46,3.37,3.37,3.37,3.62,3.83,3.82,3.62,3.25,3,3,3.12,3.12,3.12,2.87,2.75,2.22,2.12,2.12,2.12,2.09,2,2,2,2,2,2,2,2,2,2,2,2,2,1.87,1.62,1.37,1.21,1,0.87,0.62,0.37,-0.13,-0.75,-1.36,-1.89,-2.33,-2.71,-3.04,-3.38,-3.68,-3.99,-4.29,-4.61,-4.90,-5.22,-5.50,-5.75,-5.96,-6.11,-6.21,-6.27,-6.36,-6.41,-6.54,-6.74,-6.96,-7.23,-7.50,-7.79,-8.08,-8.34,-8.51,-8.62,-8.61,-8.48,-8.22,-7.72,-6.76,-5.27,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.24,7.25,7.32,7.62,7.83,7.95,7.98,8,8.10,8.20,8.25,8.25,8.12,7.86,7.37,7.12,7.09,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.98,6.97,6.96,6.95,6.87,6.87,6.83,6.75,6.72,6.62,6.60,6.57,6.50,6.50,6.47,6.37,6.34,6.24,6.12,6.08,6,5.99,5.97,5.95,5.87,5.86,5.75,5.62,5.46,5.25,5.09,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.98,4.97,4.97,4.96,4.95,4.87,4.86,4.75,4.62,4.50,4.37,4.23,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.10,4.12,4.20,4.25,4.25,4.37,4.50,4.58,4.62,4.70,4.75,4.83,4.86,4.87,4.87,4.87,4.87,4.87,4.87,4.87,4.87,4.75,4.62,4.49,4.34,4.23,4.20,4.24,4.33,4.36,4.25,4.20,4.10,4,4,3.99,3.99,3.98,3.98,3.98,3.98,3.97,3.96,3.95,3.87,3.87,3.82,3.75,3.70,3.62,3.62,3.74,3.87,4,4.09,3.96,3.62,3.34,3.09,3.12,3.33,3.70,3.25,3.25,3.23,3.12,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,1.86,1.62,1.37,1.21,1,0.86,0.62,0.25,-0.25,-0.88,-1.41,-1.93,-2.34,-2.71,-3.04,-3.38,-3.68,-4,-4.34,-4.64,-4.98,-5.27,-5.55,-5.79,-6,-6.13,-6.23,-6.27,-6.36,-6.41,-6.59,-6.76,-6.99,-7.24,-7.50,-7.77,-8.03,-8.25,-8.42,-8.50,-8.46,-8.25,-7.88,-7.25,-6.15,-4.46,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.34,7.62,7.83,7.98,8.12,8.37,8.60,8.72,8.72,8.62,8.58,7.75,7.25,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.95,6.87,6.87,6.84,6.75,6.72,6.62,6.61,6.57,6.50,6.50,6.50,6.47,6.37,6.33,6.23,6.12,6.07,6,5.98,5.96,5.87,5.87,5.83,5.72,5.58,5.37,5.23,5.07,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.98,4.97,4.97,4.96,4.95,4.87,4.86,4.75,4.62,4.50,4.37,4.24,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.08,4.12,4.22,4.25,4.36,4.37,4.50,4.58,4.62,4.75,4.75,4.85,4.87,4.87,4.87,4.87,4.95,4.95,4.96,4.96,4.96,4.87,4.87,4.82,4.62,4.50,4.37,4.25,4.23,4.25,4.37,4.59,4.35,4.22,4.11,4,4,4,3.99,3.99,3.98,3.98,3.98,3.98,3.98,3.97,3.96,3.87,3.87,3.87,3.85,3.87,3.87,4.07,4.24,4.58,4.34,4.11,3.75,3.37,3.36,3.34,3.62,3.86,3.98,3.99,4,4,4,3.99,3.98,3.97,3.97,4,3.97,3.97,3,2.98,2,2,2,2,2,2,1.98,1.87,1.62,1.37,1.20,1,0.75,0.50,0.12,-0.38,-0.90,-1.49,-1.99,-2.37,-2.72,-3.05,-3.38,-3.72,-4.03,-4.39,-4.74,-5.08,-5.38,-5.67,-5.91,-6.11,-6.23,-6.30,-6.36,-6.41,-6.49,-6.63,-6.80,-7.01,-7.25,-7.51,-7.77,-8,-8.21,-8.33,-8.37,-8.25,-7.98,-7.49,-6.68,-5.64,-3.84,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.35,7.62,7.87,8.22,8.62,9,9.37,9.37,9.25,8.74,8.11,7.37,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.96,6.87,6.87,6.84,6.75,6.62,6.62,6.50,6.50,6.48,6.46,6.46,6.37,6.37,6.35,6.25,6.12,6.10,6,6,5.97,5.96,5.87,5.87,5.75,5.70,5.50,5.37,5.22,5.08,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.98,4.97,4.97,4.96,4.95,4.87,4.86,4.75,4.62,4.50,4.37,4.24,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4.09,4.12,4.25,4.37,4.46,4.50,4.60,4.62,4.74,4.82,4.87,4.87,4.95,4.97,4.97,4.97,4.97,4.97,4.97,4.97,4.97,4.97,4.96,4.87,4.84,4.72,4.50,4.37,4.25,4.22,4.24,4.32,4.34,4.25,4.20,4.11,4,4,4,4,4,3.99,4,4,4,4,4,4,4,4,3.99,4,4,4.12,4.36,4.58,4.62,4.62,4.33,4,3.75,3.62,3.75,3.87,4.12,4.72,4.73,4.84,4.95,4.96,4.96,4.95,4.87,4.87,4.96,4.96,4,3.96,3,2.96,2,2,2,2,2,1.99,1.87,1.62,1.37,1.12,0.96,0.71,0.37,0,-0.43,-1,-1.54,-2.01,-2.39,-2.75,-3.10,-3.43,-3.77,-4.12,-4.50,-4.87,-5.22,-5.54,-5.85,-6.09,-6.26,-6.38,-6.46,-6.48,-6.51,-6.59,-6.68,-6.85,-7.03,-7.26,-7.52,-7.78,-8.01,-8.18,-8.26,-8.24,-8.08,-7.71,-7.12,-6.22,-4.89,-3.25,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.35,7.75,8.25,8.87,9.60,9.75,10.59,9.62,9.08,8.37,7.71,7.25,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.96,6.87,6.87,6.84,6.75,6.62,6.57,6.49,6.37,6.37,6.35,6.34,6.33,6.32,6.25,6.24,6.12,6.11,6,6,5.98,5.97,5.95,5.87,5.87,5.75,5.62,5.50,5.36,5.21,5.08,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.07,5,5,5,5,5,5,5,4.99,4.99,4.98,4.98,4.97,4.97,4.96,4.95,4.87,4.86,4.75,4.62,4.50,4.37,4.23,4.12,4,4,4,4,4,4,4,4,4,4,4,4.08,4.12,4.12,4.25,4.37,4.50,4.62,4.62,4.75,4.75,4.86,4.87,4.98,5,5,5,5,5,4.99,4.99,4.99,4.98,4.98,4.98,4.96,4.87,4.86,4.74,4.57,4.37,4.24,4.12,4.12,4.21,4.22,4.20,4.12,4.12,4.10,4.09,4.08,4,4,4,4,4.08,4.11,4.12,4.12,4.12,4.12,4.12,4.12,4.12,4.25,4.45,4.62,4.84,4.87,4.86,4.62,4.34,4.11,3.99,3.99,4.12,4.32,4.87,5.25,5.72,5.82,5.87,5.83,5.75,5.85,5.12,5.07,4.87,4.87,3.87,3.07,2.95,2,2,2,2,1.99,1.97,1.85,1.61,1.37,1.12,0.87,0.62,0.25,-0.13,-0.54,-1.13,-1.62,-2.08,-2.43,-2.77,-3.16,-3.52,-3.88,-4.24,-4.63,-5.01,-5.39,-5.75,-6.04,-6.29,-6.49,-6.60,-6.63,-6.64,-6.65,-6.67,-6.75,-6.88,-7.05,-7.29,-7.58,-7.85,-8.08,-8.24,-8.27,-8.18,-7.96,-7.49,-6.79,-5.79,-4.43,-2.79,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.25,7.62,8.22,8.96,9.61,10,9.87,9.70,9.59,8.59,7.75,7.33,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.98,6.96,6.87,6.87,6.84,6.75,6.62,6.50,6.37,6.35,6.25,6.23,6.21,6.20,6.20,6.12,6.12,6.12,6.09,6,6,5.99,5.97,5.96,5.95,5.87,5.87,5.75,5.62,5.50,5.35,5.20,5.08,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.07,5.11,5.07,5,5,5,5,5,5,4.99,4.99,4.98,4.98,4.97,4.97,4.96,4.95,4.87,4.87,4.75,4.62,4.50,4.36,4.23,4.12,4,4,4,4,4,4,4,4,4,4.10,4.12,4.12,4.24,4.33,4.37,4.50,4.62,4.75,4.82,4.86,4.87,4.96,5,5.08,5.12,5.12,5.12,5.09,5,5,5,5,5,4.99,4.98,4.97,4.87,4.87,4.75,4.59,4.37,4.20,4.12,4.11,4.12,4.12,4.12,4.12,4.12,4.22,4.24,4.23,4.12,4.12,4.12,4.12,4.24,4.25,4.34,4.37,4.37,4.37,4.46,4.49,4.50,4.50,4.75,5,5.20,5.25,5.20,4.98,4.62,4.36,4.12,4.10,4.25,4.70,5.22,5.75,6.20,6.73,6.74,6.75,6.12,5.85,5.87,5.09,5,4.87,4,3.08,2.87,2.08,2,2,2,1.98,1.87,1.75,1.58,1.35,1.10,0.84,0.50,0.22,-0.17,-0.64,-1.16,-1.68,-2.13,-2.50,-2.83,-3.25,-3.63,-4,-4.38,-4.77,-5.18,-5.60,-5.98,-6.29,-6.54,-6.74,-6.85,-6.87,-6.85,-6.80,-6.77,-6.80,-6.91,-7.10,-7.34,-7.63,-7.91,-8.16,-8.34,-8.36,-8.23,-7.96,-7.41,-6.64,-5.59,-4.21,-2.58,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.35,8.11,8.85,9.62,9.82,9.71,9.37,8.84,8.25,7.62,7.25,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.98,6.97,6.95,6.87,6.85,6.75,6.62,6.50,6.37,6.25,6.22,6.12,6.12,6.10,6.09,6.09,6.09,6.07,6,6,6,5.99,5.98,5.97,5.96,5.95,5.87,5.86,5.75,5.62,5.50,5.35,5.12,5.08,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.11,5.11,5.09,5,5,5,5,5,4.99,4.99,4.98,4.98,4.97,4.97,4.96,4.95,4.87,4.87,4.75,4.62,4.50,4.37,4.22,4.11,4,4,4,4,4,4,4,4,4.12,4.20,4.25,4.35,4.37,4.50,4.59,4.62,4.75,4.85,4.87,4.87,4.98,5,5.11,5.20,5.25,5.25,5.25,5.22,5.12,5.09,5.07,5,5,5,5,4.97,4.87,4.87,4.75,4.59,4.36,4.12,4.08,4.07,4.08,4.10,4.12,4.12,4.25,4.37,4.50,4.45,4.37,4.37,4.37,4.37,4.50,4.57,4.62,4.62,4.74,4.84,4.87,5,5,5.12,5.25,5.46,5.62,5.75,5.62,5.35,5,4.62,4.35,4.25,4.36,5,5.62,6.21,6.74,7.08,7.12,6.75,6.21,5.83,5.87,5.10,5,4.87,4,3.10,2.87,2.09,2,2,2,1.97,1.87,1.75,1.50,1.32,1.07,0.75,0.47,0.11,-0.30,-0.77,-1.28,-1.79,-2.22,-2.55,-2.88,-3.33,-3.73,-4.12,-4.50,-4.91,-5.37,-5.80,-6.22,-6.54,-6.84,-7.02,-7.13,-7.13,-7.04,-6.93,-6.87,-6.87,-6.93,-7.12,-7.38,-7.71,-8.01,-8.28,-8.47,-8.48,-8.34,-8.05,-7.49,-6.66,-5.58,-4.16,-2.60,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.25,7.82,8.62,9.12,9.62,9.61,8.84,8.24,7.75,7.37,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.96,6.87,6.87,6.75,6.62,6.50,6.37,6.25,6.20,6.12,6.08,6,6,6,6,6,6,6,6,5.99,5.98,5.97,5.97,5.96,5.95,5.87,5.87,5.75,5.62,5.50,5.35,5.20,5.08,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.12,5.22,5.22,5.12,5.07,5,5,5,4.99,4.99,4.98,4.98,4.97,4.97,4.97,4.96,4.87,4.87,4.75,4.62,4.50,4.37,4.22,4.10,4,4,4,4,4,4,4,4.09,4.20,4.33,4.45,4.50,4.61,4.62,4.74,4.75,4.86,4.87,4.95,4.98,5,5.10,5.21,5.34,5.46,5.50,5.48,5.37,5.25,5.12,5.12,5.12,5.12,5.09,5,4.99,4.87,4.84,4.72,4.50,4.25,4.11,4,4,4.09,4.12,4.20,4.25,4.37,4.58,4.62,4.73,4.72,4.74,4.75,4.75,4.85,4.87,4.97,5,5.12,5.25,5.47,5.57,5.62,5.62,5.75,5.87,6.12,6.57,6.25,5.87,5.36,5,4.72,4.37,4.73,5.23,5.87,6.62,7.20,7.71,7.74,7,6.21,5.12,5.12,5.11,5,4.87,4.11,3.11,2.87,2.10,2.10,2,2,1.96,1.87,1.73,1.50,1.25,1,0.72,0.37,-0.03,-0.50,-1,-1.50,-1.93,-2.34,-2.65,-2.97,-3.33,-3.83,-4.14,-4.60,-5.08,-5.54,-6,-6.46,-6.80,-7.10,-7.35,-7.48,-7.40,-7.28,-7.08,-6.91,-6.88,-6.93,-7.13,-7.40,-7.75,-8.12,-8.40,-8.59,-8.61,-8.47,-8.22,-7.63,-6.79,-5.68,-4.29,-2.75,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.34,8.11,8.62,8.86,8.72,8.32,7.75,7.37,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.98,6.97,6.95,6.87,6.83,6.73,6.60,6.45,6.32,6.20,6.12,6.07,6,6,6,6,6,6,5.99,5.99,5.99,5.98,5.98,5.97,5.97,5.96,5.95,5.87,5.87,5.75,5.62,5.50,5.36,5.20,5.08,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.08,5.25,5.37,5.48,5.34,5.12,5,5,5,4.99,4.99,4.99,4.98,4.98,4.98,4.97,4.97,4.95,4.87,4.83,4.71,4.50,4.37,4.22,4.10,4,4,4,4,4,4,4,4.12,4.25,4.37,4.60,4.71,4.75,4.82,4.84,4.87,4.87,4.96,4.98,5,5.08,5.12,5.25,5.47,5.62,5.70,5.62,5.50,5.37,5.25,5.25,5.32,5.25,5.22,5.11,5,4.87,4.75,4.58,4.37,4.20,4.08,4,4.07,4.12,4.25,4.37,4.48,4.62,4.75,4.87,5,5.08,5.12,5.20,5.23,5.25,5.25,5.35,5.37,5.50,5.75,5.97,6.12,6.12,6.22,6.25,6.37,6.62,6.83,6.87,6.62,6.12,5.37,5.12,5,4.98,5.36,6.12,7,7.62,8,8,7.75,6.12,5.12,5,5,5,4.87,4.12,3.87,3.11,2.87,2.11,2,2,1.96,1.87,1.71,1.50,1.25,0.97,0.62,0.25,-0.25,-0.68,-1.17,-1.66,-2.13,-2.50,-2.75,-3.04,-3.39,-3.78,-4.24,-4.72,-5.21,-5.68,-6.21,-6.62,-6.99,-7.28,-7.46,-7.53,-7.51,-7.35,-7.13,-6.96,-6.88,-6.93,-7.10,-7.39,-7.77,-8.15,-8.48,-8.66,-8.73,-8.62,-8.38,-7.83,-7,-5.89,-4.52,-3,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.25,7.70,8.09,8.25,8.09,7.75,7.37,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.97,6.96,6.87,6.87,6.75,6.62,6.50,6.37,6.24,6.12,6.07,6,6,6,6,6,5.99,5.99,5.99,5.99,5.98,5.98,5.98,5.97,5.97,5.96,5.95,5.87,5.87,5.75,5.70,5.50,5.36,5.20,5.08,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.12,5.37,5.62,5.75,5.50,5.25,5.08,5,5,5,5,5,5,4.99,4.99,4.98,4.97,4.96,4.87,4.85,4.72,4.50,4.37,4.21,4.09,4,4,4,4,4,4,4,4.12,4.33,4.50,4.70,4.82,4.87,4.87,4.87,4.95,4.98,5,5,5,5.12,5.23,5.37,5.58,5.74,5.83,5.82,5.71,5.58,5.48,5.47,5.50,5.49,5.37,5.21,5,4.87,4.62,4.45,4.23,4.11,4,4,4.08,4.22,4.50,4.50,4.70,4.86,5,5.21,5.32,5.37,5.50,5.59,5.62,5.70,5.74,5.75,5.84,5.98,6.12,6.48,6.60,6.62,6.72,6.75,6.87,7,7.25,7.62,7.62,7.12,6.37,5.98,5.37,5.25,5.36,6.62,7.21,8.12,8.71,8.72,7.75,5.22,4.87,4.86,4.86,4.87,4.86,4.12,3.86,3.12,2.87,2.12,2,2,1.96,1.86,1.71,1.50,1.23,0.87,0.50,0.08,-0.41,-0.93,-1.50,-1.91,-2.29,-2.63,-2.89,-3.22,-3.59,-3.98,-4.39,-4.85,-5.33,-5.80,-6.27,-6.74,-7.09,-7.33,-7.49,-7.53,-7.48,-7.29,-7.09,-6.90,-6.84,-6.88,-7.03,-7.33,-7.73,-8.13,-8.49,-8.73,-8.80,-8.76,-8.58,-8.04,-7.25,-6.17,-4.83,-3.36,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.32,7.62,7.75,7.62,7.35,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.97,6.96,6.87,6.86,6.75,6.62,6.46,6.25,6.12,6.09,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.98,5.98,5.98,5.97,5.97,5.96,5.96,5.87,5.87,5.83,5.72,5.50,5.36,5.12,5.07,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.12,5.36,5.62,5.82,5.87,5.62,5.32,5.10,5,5,5,5,5.07,5,5,5,5,4.99,4.97,4.87,4.86,4.74,4.57,4.37,4.21,4.09,4,4,4,4,4,4,4,4.12,4.34,4.50,4.74,4.87,4.87,4.87,4.97,4.99,5,5,5.07,5.10,5.12,5.25,5.46,5.62,5.82,5.87,5.87,5.83,5.74,5.62,5.62,5.62,5.62,5.50,5.25,5.08,4.87,4.62,4.37,4.12,4.08,4,4,4.09,4.22,4.37,4.62,4.87,5.10,5.25,5.50,5.59,5.62,5.75,5.87,6,6.12,6.12,6.23,6.25,6.37,6.59,6.75,6.99,7.12,7.21,7.25,7.32,7.37,7.75,8.24,8.62,8.37,7.87,7.22,6.37,5.37,5.37,5.35,7.62,8.62,9.72,9.73,7.75,5.21,4.12,3.87,4.11,4.85,4.85,4.12,3.85,3.86,2.86,2.12,2,2,1.96,1.87,1.70,1.48,1.12,0.82,0.37,-0.13,-0.66,-1.25,-1.75,-2.15,-2.50,-2.73,-3.03,-3.39,-3.83,-4.25,-4.62,-5.01,-5.43,-5.88,-6.33,-6.72,-7.02,-7.26,-7.43,-7.49,-7.39,-7.21,-6.98,-6.78,-6.72,-6.76,-6.92,-7.21,-7.60,-8.01,-8.40,-8.72,-8.88,-8.91,-8.86,-8.40,-7.65,-6.58,-5.22,-3.47,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.32,7.62,7.33,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.97,6.95,6.87,6.84,6.73,6.58,6.37,6.25,6.12,6.07,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.98,5.98,5.98,5.97,5.97,5.97,5.96,5.95,5.87,5.85,5.74,5.57,5.36,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.07,5.24,5.50,5.75,5.87,5.87,5.62,5.37,5.11,5,5,5.07,5.12,5.12,5.12,5.12,5.10,5,5,4.98,4.95,4.87,4.75,4.57,4.37,4.21,4.09,4,4,4,4,4,4,4,4.12,4.33,4.50,4.73,4.86,4.87,4.87,4.96,4.98,5,5,5.09,5.12,5.22,5.35,5.50,5.62,5.82,5.87,5.87,5.87,5.85,5.82,5.75,5.75,5.73,5.50,5.32,5.07,4.87,4.62,4.37,4.21,4.08,4,4.07,4.12,4.25,4.47,4.74,5,5.25,5.50,5.62,5.75,5.87,6,6.12,6.33,6.50,6.58,6.62,6.73,6.82,6.95,7.12,7.33,7.59,7.70,7.73,7.62,7.75,8.12,8.62,9.62,9.62,9.62,8.75,7.62,6.37,5.36,5.35,6.33,8.62,9.71,9.74,6.75,4.21,2.84,2.12,3.12,4,4.84,4.11,3.84,3.12,2.85,2.12,2,2,1.96,1.87,1.71,1.46,1.12,0.71,0.20,-0.38,-0.92,-1.50,-2,-2.38,-2.65,-2.86,-3.17,-3.61,-4.15,-4.62,-4.92,-5.16,-5.54,-5.96,-6.36,-6.71,-6.99,-7.18,-7.30,-7.33,-7.24,-7.04,-6.80,-6.63,-6.54,-6.61,-6.76,-7.03,-7.39,-7.85,-8.28,-8.65,-8.92,-9.13,-9.05,-8.67,-7.99,-6.93,-5.41,-3.60,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.12,7.12,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.97,6.95,6.87,6.83,6.71,6.50,6.37,6.24,6.12,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.98,5.98,5.98,5.98,5.97,5.97,5.97,5.96,5.87,5.87,5.75,5.59,5.37,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.08,5.25,5.62,5.87,5.98,5.87,5.74,5.48,5.23,5.12,5.12,5.12,5.25,5.37,5.37,5.34,5.23,5.12,5.07,5,4.97,4.87,4.75,4.58,4.37,4.21,4.09,4,4,4,4,4,4,4,4.12,4.25,4.46,4.62,4.75,4.82,4.86,4.87,4.96,5,5,5.08,5.12,5.22,5.35,5.50,5.62,5.75,5.85,5.86,5.84,5.75,5.75,5.75,5.75,5.62,5.37,5.12,4.96,4.85,4.62,4.48,4.22,4.10,4.08,4.12,4.25,4.46,4.62,4.87,5.12,5.37,5.62,5.82,5.95,6.07,6.21,6.37,6.50,6.73,6.87,7,7.12,7.21,7.25,7.36,7.50,7.85,8.50,7.99,7.87,8,8.25,8.84,9.62,10.62,10.62,10.62,9.62,7.36,6,5.33,5.33,7.70,8.72,7.36,4.35,2.50,1.24,1.25,1.12,3.83,4.83,3.12,3.11,2.84,2.12,2.12,2.12,2.12,2.10,1.87,1.75,1.46,1.07,0.59,0,-0.63,-1.17,-1.75,-2.25,-2.55,-2.77,-2.97,-3.29,-3.75,-4.35,-5.21,-5.11,-5.29,-5.63,-6.01,-6.40,-6.72,-6.98,-7.14,-7.24,-7.23,-7.13,-6.96,-6.75,-6.59,-6.50,-6.51,-6.58,-6.84,-7.15,-7.63,-8.13,-8.58,-8.97,-9.22,-9.21,-8.89,-8.25,-7.22,-5.67,-3.75,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.95,6.87,6.82,6.70,6.50,6.37,6.23,6.12,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.98,5.98,5.98,5.98,5.98,5.98,5.97,5.95,5.87,5.75,5.61,5.37,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.08,5.33,5.62,5.87,5.99,5.95,5.84,5.62,5.49,5.37,5.37,5.37,5.50,5.60,5.62,5.50,5.37,5.25,5.12,5.07,4.99,4.87,4.75,4.58,4.37,4.21,4.09,4,4,4,4,4,4,4,4.09,4.20,4.34,4.48,4.61,4.62,4.75,4.82,4.87,4.87,4.98,5,5,5.12,5.25,5.37,5.59,5.72,5.75,5.75,5.62,5.62,5.60,5.62,5.57,5.37,5,4.75,4.73,4.75,4.73,4.50,4.25,4.10,4.09,4.21,4.50,4.62,4.85,5.12,5.35,5.58,5.75,5.87,6,6.21,6.37,6.57,6.62,6.82,7,7.25,7.50,7.50,7.50,7.47,7.62,7.96,8.08,8.09,8,8.07,8.32,8.62,9,9.62,9.12,9.62,9.62,8.62,5.85,4.62,4.32,4.95,5.73,2.12,2.21,0.85,-0.17,0,0.96,1.12,2.12,2.83,2.83,2.12,2.12,2.12,2.84,2.85,2.12,2.12,1.86,1.50,1,0.49,-0.13,-0.77,-1.38,-2,-2.38,-2.68,-2.88,-3.03,-3.38,-3.80,-4.37,-4.85,-5.13,-5.37,-5.72,-6.10,-6.47,-6.75,-6.98,-7.13,-7.18,-7.16,-7.08,-6.88,-6.71,-6.53,-6.43,-6.42,-6.50,-6.62,-6.91,-7.41,-7.97,-8.48,-8.93,-9.23,-9.27,-9.02,-8.43,-7.47,-5.93,-4,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.95,6.87,6.75,6.62,6.50,6.37,6.22,6.11,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.98,5.98,5.98,5.98,5.98,5.96,5.87,5.83,5.62,5.37,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.08,5.33,5.62,5.87,6,6,6,5.95,5.85,5.75,5.75,5.75,5.85,5.87,5.86,5.75,5.62,5.45,5.25,5.12,5,4.87,4.75,4.59,4.37,4.21,4.09,4,4,4,4,4,4,4,4,4.12,4.23,4.35,4.45,4.50,4.61,4.62,4.75,4.82,4.85,4.87,4.87,4.97,5.07,5.21,5.37,5.50,5.50,5.47,5.36,5.25,5.25,5.12,5.33,4.87,4.60,4.37,4.37,4.59,4.62,4.50,4.25,4.10,4.09,4.20,4.37,4.71,5,5.25,5.57,5.70,5.75,5.87,6.11,6.33,6.50,6.62,6.62,6.71,6.87,7.50,7.57,7.50,7.50,7.37,7.62,7.87,8,8,7.95,7.95,8,8.62,7.87,7.35,7.25,6.84,7.62,6.62,4.62,3.32,2.95,2.75,2.12,1.37,0.12,-0.63,-1.88,-0.88,0.37,1.25,1.86,2.12,2.12,2.82,2.83,2.83,2.87,2.87,2.85,2.37,2,1.61,1.08,0.46,-0.25,-0.90,-1.54,-2.13,-2.50,-2.77,-2.91,-3.10,-3.40,-3.79,-4.25,-4.68,-5.04,-5.40,-5.78,-6.16,-6.52,-6.78,-7,-7.13,-7.18,-7.15,-7.05,-6.89,-6.72,-6.55,-6.43,-6.39,-6.42,-6.54,-6.68,-7.18,-7.78,-8.38,-8.88,-9.22,-9.28,-9.09,-8.52,-7.60,-6.15,-4.28,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.87,6.87,6.75,6.62,6.50,6.36,6.22,6.11,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.98,5.98,5.97,5.95,5.86,5.62,5.37,5.21,5.07,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.07,5,5,5,5.08,5.33,5.62,5.87,6.08,6.12,6.25,6.25,6.25,6.23,6.21,6.22,6.22,6.12,6.10,5.97,5.75,5.61,5.37,5.23,5.08,4.87,4.75,4.59,4.37,4.21,4.09,4,4,4,4,4,4,4,4,4.07,4.12,4.22,4.25,4.37,4.46,4.50,4.60,4.62,4.62,4.62,4.70,4.73,4.75,4.87,5,5.12,5.23,5,4.87,4.82,4.71,4.70,4.61,4.48,4.25,4.12,4.22,4.37,4.59,4.50,4.35,4.10,4,4.11,4.25,4.59,4.99,5.50,5.62,5.70,5.62,5.74,6,6.50,6.57,6.59,6.60,6.37,6.37,6.75,6.96,7.07,7.20,7.37,7.62,7.87,8,7.95,7.75,7.62,7.62,7.12,6.62,5.75,4.99,4.62,1.34,1.33,2.08,1.62,1.25,0.96,0.49,-0.13,-0.88,-0.80,-0.80,-0.80,0.62,1.50,2.08,2.20,2.75,2.87,3,3,3,3,2.87,2.62,2.23,1.75,1.12,0.50,-0.25,-0.90,-1.63,-2.13,-2.54,-2.80,-2.93,-3.13,-3.38,-3.74,-4.17,-4.64,-5.04,-5.48,-5.87,-6.25,-6.61,-6.86,-7.03,-7.15,-7.21,-7.17,-7.09,-6.93,-6.78,-6.63,-6.50,-6.43,-6.46,-6.52,-6.59,-7.13,-7.71,-8.33,-8.86,-9.21,-9.28,-9.08,-8.53,-7.63,-6.27,-4.52,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.98,6.96,6.87,6.87,6.75,6.62,6.50,6.36,6.21,6.10,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.98,5.96,5.87,5.73,5.50,5.25,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.07,5.11,5.07,5,5,5.08,5.33,5.62,5.87,6.12,6.25,6.47,6.58,6.62,6.62,6.62,6.62,6.58,6.48,6.32,6.12,5.87,5.74,5.50,5.32,5.12,4.96,4.75,4.61,4.37,4.22,4.09,4,4,4,4,4,4,4,4,4,4.07,4.11,4.12,4.24,4.25,4.37,4.37,4.47,4.48,4.48,4.47,4.47,4.49,4.50,4.60,4.62,4.62,4.59,4.49,4.37,4.34,4.25,4.24,4.21,4.12,4.12,4.12,4.23,4.37,4.45,4.25,4.08,4,4.07,4.20,4.48,4.86,5.23,5.50,5.50,5.34,5.37,5.71,6.58,6.59,6.25,6.25,6.24,6.25,6.37,6.37,6.37,6.87,7.32,7.62,8,8.11,7.98,7.61,7.12,6.59,5.96,4.87,3.96,2.95,1.33,1,0.35,-0.02,-0.25,-0.26,-0.38,-0.78,-0.80,-0.17,0.20,0.75,1.07,1.21,2.21,2.83,3.11,3.20,3.20,3.20,3.12,3.12,3.12,3,2.75,2.37,1.95,1.33,0.62,-0.13,-0.79,-1.43,-2,-2.39,-2.67,-2.88,-3.13,-3.39,-3.77,-4.26,-4.88,-5.24,-5.50,-5.96,-6.36,-6.71,-6.91,-7.10,-7.21,-7.24,-7.21,-7.12,-7,-6.87,-6.74,-6.62,-6.53,-6.53,-6.61,-6.63,-7.21,-7.79,-8.39,-8.89,-9.22,-9.29,-9.09,-8.52,-7.66,-6.40,-4.73,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.97,6.96,6.87,6.87,6.75,6.62,6.50,6.36,6.21,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.98,5.97,5.87,5.75,5.59,5.37,5.24,5.12,5.10,5.09,5.10,5.09,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.07,5,5,5,5.08,5.36,5.62,5.87,6.11,6.25,6.57,6.75,6.87,6.87,6.87,6.86,6.83,6.72,6.47,6.23,6,5.83,5.62,5.37,5.12,4.99,4.83,4.62,4.37,4.24,4.10,4,4,4,4,4,4,4,4,4,4,4,4.09,4.12,4.12,4.23,4.25,4.25,4.25,4.25,4.25,4.25,4.25,4.25,4.25,4.25,4.25,4.23,4.12,4.12,4.11,4.09,4.08,4.10,4.12,4.12,4.12,4.12,4.20,4.20,4.12,4,4,4,4.11,4.37,4.62,4.87,4.97,4.87,4.83,4.86,5.12,5.37,5.75,5.95,6,6.12,6.12,6.25,6.37,6.37,6.87,7.25,7.62,8.09,8.58,8,7.50,6.37,5.50,4.58,3.62,1.32,1.25,0.50,-0.18,-0.67,-1.17,-1.75,-1.76,-0.78,-0.80,0.10,0.75,1.37,2,2.75,3.21,3.87,4.21,4.21,4.11,4,4,4,3.87,3.82,3.12,3,2.62,2.12,1.50,0.75,0.07,-0.64,-1.29,-1.88,-2.28,-2.61,-2.88,-3.13,-3.46,-3.84,-4.29,-4.88,-5.17,-5.61,-6.02,-6.41,-6.75,-7.01,-7.15,-7.26,-7.29,-7.25,-7.15,-7.03,-6.91,-6.80,-6.73,-6.65,-6.65,-6.75,-6.90,-7.40,-7.99,-8.55,-9.03,-9.37,-9.39,-9.13,-8.60,-7.74,-6.60,-5.04,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.97,6.96,6.87,6.87,6.75,6.62,6.50,6.36,6.21,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.97,5.87,5.83,5.62,5.50,5.37,5.25,5.25,5.25,5.25,5.25,5.33,5.09,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.12,5.37,5.73,5.87,6,6.12,6.37,6.59,6.75,6.87,6.95,6.87,6.85,6.72,6.47,6.22,6,5.86,5.62,5.47,5.25,5,4.87,4.62,4.48,4.25,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4.09,4.12,4.12,4.12,4.12,4.12,4.12,4.11,4.10,4.09,4.09,4.08,4.07,4,4,4,4,4,4,4.08,4.12,4.36,4.20,4.12,4.11,4.07,4,4,4,4,4.10,4.25,4.50,4.50,4.46,4.37,4.37,4.37,4.37,5,5.37,5.34,6,6.25,6.33,6.34,6.75,6.87,7,7.25,7.62,7.87,8.50,8.50,6.62,5.37,4.35,3.57,1.37,0.87,0,-0.53,-1.13,-1.75,-1.75,-1.77,-1,-0.30,0.50,1.34,2.11,2.75,3.21,4.11,5.75,5.75,5.75,5.75,5.11,5,4.87,4.75,4.75,4.12,3.83,3.12,2.87,2.37,1.71,0.98,0.23,-0.51,-1.18,-1.76,-2.25,-2.58,-2.86,-3.13,-3.46,-3.85,-4.29,-4.71,-5.17,-5.64,-6.05,-6.42,-6.75,-7,-7.13,-7.24,-7.26,-7.23,-7.13,-7,-6.90,-6.83,-6.76,-6.74,-6.77,-6.89,-7.11,-7.59,-8.16,-8.75,-9.25,-9.62,-9.66,-9.37,-8.74,-7.88,-6.74,-5.38,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.97,6.96,6.87,6.87,6.75,6.62,6.50,6.36,6.21,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.97,5.87,5.87,5.75,5.62,5.58,5.50,5.46,5.47,5.50,5.62,5.74,5.87,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.07,5.25,5.60,5.86,5.98,6,6,6.12,6.37,6.61,6.75,6.87,6.87,6.75,6.50,6.25,6,5.87,5.83,5.71,5.50,5.32,5.12,4.87,4.74,4.50,4.33,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.07,4.07,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.12,4.21,4.22,4.12,4.11,4,4,4,4,4.07,4.12,4.23,4.32,4.37,4.37,4.37,4.37,4.37,4.37,4.98,5.34,5.85,6.25,6.72,7.07,7.24,7.25,7.71,6.98,6.99,7.73,7.24,7.12,7.50,5.50,4.20,3.09,1.99,0.99,-0.02,-0.75,-1.75,-1.75,-1.76,-1.77,-1,-0.29,0.75,1.86,3,3.75,4.21,4.75,5.22,5.87,6.75,6.75,6.22,6.11,5.87,5.75,5.20,4.87,4.82,4.12,3.85,3.25,2.62,1.87,1.12,0.37,-0.38,-1.13,-1.75,-2.25,-2.55,-2.84,-3.13,-3.48,-3.92,-4.46,-4.77,-5.22,-5.62,-6.01,-6.37,-6.66,-6.91,-7.03,-7.13,-7.15,-7.11,-7,-6.88,-6.79,-6.75,-6.73,-6.75,-6.83,-6.99,-7.25,-7.74,-8.33,-8.91,-9.61,-10,-10,-9.91,-9.05,-8.10,-6.88,-5.67,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.97,6.96,6.87,6.87,6.75,6.62,6.50,6.36,6.22,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.97,5.95,5.87,5.86,5.75,5.74,5.62,5.62,5.62,5.75,5.87,5.87,5.62,5.32,5.07,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.12,5.37,5.82,6,6,5.95,5.87,5.98,6.12,6.37,6.62,6.75,6.62,6.46,6.12,5.87,5.74,5.62,5.61,5.50,5.48,5.33,5.12,4.98,4.75,4.59,4.35,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.11,4.21,4.25,4.24,4.12,4.07,4,4,4,4.12,4.22,4.24,4.25,4.37,4.57,4.62,4.72,4.74,4.87,5.25,5.75,6.24,6.75,7.12,7.75,8.74,7.75,6.87,6.74,6.24,6.24,6.62,5.75,4.87,3.87,2.75,1.75,0.87,0.12,-0.55,-1.76,-1.77,-1.78,-1.27,-0.78,-0.25,0.86,1.20,3.75,4.98,5.75,6.11,6.22,6.75,6.22,6.22,6.22,6.75,6.75,6.75,5.75,5.21,5,4.87,4.82,4.49,3.70,2.87,2.12,1.37,0.50,-0.25,-1.01,-1.66,-2.25,-2.54,-2.83,-3.13,-3.50,-4,-4.68,-5.41,-5.46,-5.50,-5.89,-6.23,-6.50,-6.77,-6.84,-6.90,-6.92,-6.88,-6.76,-6.65,-6.60,-6.58,-6.59,-6.65,-6.78,-7,-7.30,-7.80,-8.68,-9.40,-10,-10,-10,-10,-9.63,-8.39,-6.85,-5.28,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.97,6.96,6.87,6.87,6.75,6.62,6.50,6.37,6.22,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.98,5.97,5.96,5.87,5.87,5.86,5.83,5.83,5.86,5.95,6.09,6.07,5.73,5.37,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.23,5.50,5.87,6,5.87,5.75,5.71,5.75,5.97,6.25,6.47,6.58,6.36,6.09,5.75,5.50,5.37,5.35,5.34,5.33,5.25,5.22,5.11,4.99,4.85,4.62,4.36,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.10,4.23,4.33,4.35,4.12,4.08,4,4,4.07,4.20,4.49,4.32,4.37,4.62,4.86,5.07,5.20,5.33,5.32,5.82,6.25,6.75,7.12,7.75,7.75,7.75,6.87,6.22,5.75,5.22,5.21,4.87,4.25,3.25,1.50,1.37,0.62,-0.28,-0.75,-0.79,-0.80,-0.50,-0.25,-0.13,0.10,0.87,1.20,4.75,5.75,6.75,7.75,7.75,7.75,7.11,6.75,6.22,6.11,6.22,6.22,6.22,5.87,5.21,5.20,5.20,5,4.70,3.97,3.12,2.37,1.50,0.71,-0.14,-0.93,-1.63,-2.18,-2.54,-2.83,-3.11,-3.46,-3.97,-4.72,-5.98,-5.88,-5.38,-5.74,-6.02,-6.25,-6.48,-6.50,-6.53,-6.54,-6.50,-6.39,-6.30,-6.26,-6.27,-6.35,-6.48,-6.66,-6.98,-7.26,-8.16,-8.99,-9.68,-10,-11,-11,-10,-10,-9.02,-7.21,-4.78,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.97,6.96,6.87,6.87,6.75,6.62,6.50,6.37,6.22,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.98,5.98,5.98,5.97,5.96,5.87,5.87,5.87,5.97,6,6.12,6,5.75,5.47,5.22,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.22,5.50,5.87,5.87,5.71,5.49,5.37,5.46,5.70,6,6.25,6.25,5.98,5.71,5.37,5.22,5.11,5.11,5.11,5.11,5.11,5.10,5,4.98,4.87,4.62,4.36,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.09,4.20,4.33,4.25,4.12,4.08,4,4,4.09,4.21,4.32,4.47,4.62,4.87,5.12,5.37,5.62,5.95,6.25,6.25,6.96,7.20,7.12,7.86,7.85,6.83,5.87,5.12,4.87,4.84,4.12,3.75,2.99,1.87,1,0.20,-0.27,-0.75,-0.38,-0.13,0.49,1.09,1.57,1.82,1.12,1.12,4.75,6.75,7.75,7.87,7.99,7.99,7.87,7.75,6.87,6.22,6,6,6,6,6,5.87,5.75,5.20,5.82,4.82,4.08,3.32,2.50,1.62,0.83,-0.05,-0.88,-1.63,-2.18,-2.54,-2.84,-3.09,-3.37,-3.76,-4.39,-5.08,-5.16,-5.17,-5.41,-5.68,-5.88,-6,-6.08,-6.05,-6.04,-6,-5.91,-5.87,-5.86,-5.90,-6.01,-6.21,-6.48,-6.84,-7.42,-8.30,-9.11,-10,-10,-11,-11,-10,-10,-8.89,-7.22,-5.02,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.97,6.96,6.87,6.87,6.75,6.62,6.50,6.37,6.22,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.98,5.98,5.98,6,6,6.08,6,5.87,5.62,5.37,5.20,5.07,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.12,5.37,5.50,5.50,5.37,5.12,5.07,5.12,5.37,5.61,5.75,5.73,5.59,5.37,5.20,5.08,5,5,5,5,5,5,5,4.97,4.87,4.62,4.35,4.08,4,4,4,4,4,4,4.08,4.09,4.09,4.08,4,4,4,4,4,4.09,4.09,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.12,4.12,4.12,4.10,4.07,4.07,4.11,4.21,4.33,4.48,4.75,5.11,5.36,5.37,5.82,6.25,6.85,7.25,7.73,7.83,7.84,7.87,7,6.87,5.12,4.87,4.12,3.97,3.87,3.87,2.87,1.87,0.97,0,-0.63,-1.78,-0.50,0,0.75,1.74,2.85,3.84,3.87,4.82,5,6.20,7.75,8.75,8.75,8.11,7.99,7.87,7.75,6.87,6.22,6,6,6,6,6.21,6.75,6.21,5.75,5.12,4.73,4.08,3.37,2.62,1.75,0.87,0,-0.88,-1.63,-2.17,-2.63,-2.88,-3.03,-3.25,-3.51,-3.96,-4.35,-4.63,-4.83,-5,-5.17,-5.34,-5.47,-5.50,-5.51,-5.48,-5.41,-5.37,-5.35,-5.37,-5.46,-5.62,-5.85,-6.13,-6.65,-7.37,-8.21,-9.13,-10,-10,-11,-11,-10,-9.98,-8.80,-7.28,-5.53,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.97,6.96,6.87,6.87,6.75,6.62,6.50,6.37,6.23,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,6,6,6,6,6,6,6,6,6,6,5.87,5.75,5.50,5.25,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.12,5.25,5.32,5.25,5.12,5,5,5,5.12,5.25,5.34,5.33,5.25,5.12,5.07,5,5,5,5,5,5,5,4.99,4.97,4.87,4.62,4.34,4.07,4,4,4,4,4.08,4.12,4.25,4.36,4.36,4.25,4.12,4,4,4.08,4.12,4.25,4.25,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.08,4.10,4.09,4.08,4.08,4.12,4.25,4.37,4.71,5,5.37,5.75,5.99,6.11,6.35,6.85,7.70,8.73,8.75,8.75,8.84,7.21,6.25,5.25,4.25,3.24,3,2.87,2.95,2,1.73,0.95,0,-1,-1.93,-0.75,-0.13,0.75,1.12,3.12,4.85,5.12,6,6.82,7,7.75,8.75,8.75,8.21,8.11,7.99,7.75,7.22,6.75,6.22,6,6,6,6,6.21,6.75,6.75,5.75,5.12,4.50,3.99,3.37,2.70,1.87,1,0.11,-0.77,-1.53,-2.15,-2.63,-2.88,-3,-3.13,-3.28,-3.59,-3.93,-4.27,-4.51,-4.66,-4.76,-4.86,-4.90,-4.93,-4.97,-5.05,-5.30,-5.51,-5,-4.84,-5.26,-6.13,-5.61,-5.77,-6.38,-7.14,-8.04,-9.02,-9.88,-10,-10,-11,-10,-10,-8.96,-7.51,-5.85,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.97,6.96,6.87,6.87,6.75,6.62,6.50,6.37,6.23,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.98,5.85,5.62,5.37,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.07,5.12,5.12,5.12,5.12,5,5,5,5,5,5,5,5,5.07,5,5,5,5,5,5,5,5,5,4.99,4.97,4.87,4.62,4.34,4,4,4,4,4.07,4.20,4.36,4.62,4.62,4.62,4.62,4.25,4.11,4.11,4.21,4.36,4.49,4.45,4.25,4.10,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4.08,4.12,4.12,4.12,4.12,4.20,4.25,4.47,4.84,5.22,5.62,6.12,6.59,6.73,6.62,6.87,7.25,7.87,8.74,8.87,9.83,7.87,6.59,5.24,4.12,3.23,2.57,1.25,1.12,1,1,0.50,0.12,-0.63,-2,-0.88,-0.25,0.73,1.75,3.12,5,6.85,7.12,7.83,7.87,8.12,9,9.75,9,8.21,8.11,7.99,7.75,7.22,6.75,6.22,6,6,6,6,6,6,5.87,5.75,4.87,4.32,3.87,3.37,2.75,2,1.12,0.24,-0.64,-1.42,-2.13,-2.53,-2.79,-2.96,-3.03,-3.13,-3.33,-3.72,-4.05,-4.24,-4.34,-4.37,-4.40,-4.41,-4.43,-4.47,-4.63,-4.92,-5.28,-5.35,-4.40,-5.63,-6.43,-5.91,-5.36,-6,-6.84,-7.78,-8.83,-9.75,-10,-10,-11,-10,-10,-9.25,-7.87,-6.46,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.97,6.96,6.87,6.87,6.75,6.62,6.50,6.37,6.23,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.87,5.62,5.37,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.07,5.09,5.12,5.09,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.98,4.87,4.62,4.25,4,4,4,4,4.12,4.32,4.62,4.75,4.87,4.87,4.71,4.37,4.37,4.37,4.46,4.59,4.62,4.59,4.35,4.12,4,4,4,4,4,4,4,4,4,4,4,4.07,4.11,4.12,4.24,4.32,4.37,4.37,4.37,4.47,4.58,4.87,5.25,5.75,6.32,6.84,7.60,7.12,7.08,7.08,7.70,7.72,7.96,8.75,8.73,7.50,5.50,4.12,3.07,2.12,1.37,0.75,0.25,0.08,-0.02,-0.27,-0.50,-1,-1,-0.13,0.87,1.10,3.11,5.12,7.11,8.85,9,9.11,9.12,9.12,10.75,10,9.21,8.75,8.22,8.11,7.75,7.22,6.75,6.22,6,6,6,5.87,5.75,5.21,5.20,4.99,4.12,4.12,3.87,3.46,2.87,2.12,1.33,0.45,-0.43,-1.25,-1.92,-2.42,-2.75,-2.89,-2.92,-3,-3.14,-3.51,-3.88,-3.96,-4,-4,-4,-4,-4,-4.04,-4.21,-4.40,-4.63,-4.34,-4.24,-4.53,-5.23,-4.71,-4.90,-5.59,-6.43,-7.41,-8.52,-9.53,-10,-10,-11,-10,-10,-9.46,-8.18,-6.91,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.97,6.96,6.87,6.87,6.75,6.62,6.50,6.37,6.24,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.87,5.62,5.37,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.98,4.96,4.70,4.12,4,4,4,4.07,4.25,4.71,4.75,4.87,4.95,4.87,4.84,4.74,4.62,4.62,4.72,4.75,4.75,4.62,4.36,4.12,4,4,4,4,4,4,4,4,4,4,4.11,4.12,4.25,4.37,4.50,4.62,4.73,4.75,4.75,4.87,5,5.25,5.62,6.10,6.62,7.62,7.25,7.62,7,6.87,6.87,6.95,7.20,6.82,6.34,5.37,4.20,2.97,1.84,1,0.36,-0.17,-0.63,-0.93,-1,-1.01,-1,-0.38,0.32,1.21,2.50,4.10,5.11,7.87,9.86,10.12,10.84,10.84,10.12,10.82,11,10.75,10.11,9.21,8.75,8.22,7.75,7.22,6.75,6.22,6,6,6,5.75,5.21,5.11,5,4.75,4.12,4.21,3.96,3.50,3,2.33,1.57,0.72,-0.13,-1,-1.66,-2.25,-2.63,-2.75,-2.88,-2.91,-3,-3.28,-3.54,-3.64,-3.66,-3.64,-3.63,-3.63,-3.64,-3.68,-3.78,-3.88,-3.93,-3.89,-3.88,-4.03,-3.84,-4.09,-4.48,-5.13,-5.98,-6.98,-8.14,-9.25,-10,-10,-11,-10,-10,-9.47,-8.29,-7.25,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.96,6.87,6.87,6.75,6.62,6.50,6.37,6.24,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.98,5.87,5.62,5.36,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.97,4.87,4.08,4,4,4,4.12,4.25,4.73,4.87,4.96,4.98,4.97,4.96,4.87,4.87,4.87,4.87,4.87,4.85,4.62,4.37,4.12,4,4,4,4,4,4,4,4.08,4.11,4.12,4.25,4.37,4.50,4.72,4.87,5,5.12,5.23,5.25,5.36,5.49,5.62,5.98,6.35,6.84,6.96,6.96,6.70,6.62,6.12,5.97,5.82,5.50,5.12,4.48,3.62,2.71,1.62,0.70,-0.25,-0.65,-1.25,-1.64,-2,-2,-2,-1,0.25,1.50,2.49,5.08,7.09,9.87,11.11,11.87,11.87,11.85,11.12,11.12,11.82,12,11.75,10.75,9.75,8.87,8.21,7.75,7.22,6.75,6.22,6,6,6,5.75,5.21,5,5,4.87,4.82,4.37,4.10,3.62,3.12,2.50,1.82,1,0.24,-0.63,-1.38,-1.93,-2.25,-2.50,-2.75,-2.83,-2.90,-3.03,-3.24,-3.34,-3.37,-3.35,-3.35,-3.36,-3.37,-3.38,-3.46,-3.51,-3.61,-3.74,-3.96,-4,-3.99,-4.04,-4.36,-4.89,-5.61,-6.47,-7.64,-8.80,-9.78,-10,-10,-10,-9.97,-9.23,-8.16,-7.25,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.98,6.96,6.87,6.87,6.75,6.70,6.50,6.37,6.24,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,6,6,6,6,5.98,5.87,5.62,5.34,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.12,5.12,5.10,5,4.99,4.98,4.96,4,4.09,4.12,4.12,4.12,4.75,4.87,4.99,5,5,4.99,4.99,4.99,4.98,4.98,4.98,4.96,4.87,4.71,4.46,4.21,4.07,4,4,4.07,4.10,4.12,4.12,4.23,4.25,4.37,4.50,4.72,4.87,5.08,5.25,5.47,5.61,5.70,5.75,5.75,5.86,5.87,6.09,6.60,6.62,6.62,6.20,5.84,5.48,5.12,4.75,4.50,4,3.48,2.86,2.12,1.25,0.48,-0.38,-1.13,-1.64,-2.13,-2.88,-3,-2,-1.04,-0.02,1.37,2.73,5,8.08,11.09,13.87,15.87,14,13.12,12.85,12.12,12.12,12.83,12.82,12.75,11.20,10.20,9.21,8.21,7.75,7.21,6.75,6.21,6.11,6,6,5.75,5.20,5,5,5,4.87,4.62,4.25,3.75,3.25,2.72,2.10,1.37,0.62,-0.13,-0.88,-1.38,-1.88,-2.18,-2.50,-2.68,-2.80,-2.91,-2.97,-3.11,-3.13,-3.13,-3.13,-3.14,-3.14,-3.15,-3.18,-3.25,-3.39,-3.64,-3.98,-4.13,-4.13,-4.08,-4.17,-4.55,-5.18,-6.01,-7.02,-8.12,-9.13,-9.83,-10,-10,-9.48,-8.77,-7.83,-6.98,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.97,6.95,6.87,6.82,6.70,6.50,6.37,6.23,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,6,6,5.99,5.99,5.96,5.84,5.62,5.36,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.12,5.23,5.59,5.11,5,4.99,5,4.98,4.98,4.87,4.87,4.86,4.87,5.10,5.22,5.23,5.12,5,5,4.99,4.99,4.99,4.99,4.99,4.98,4.87,4.75,4.50,4.25,4.10,4,4.09,4.12,4.25,4.35,4.37,4.46,4.57,4.71,4.87,5.08,5.25,5.45,5.62,5.85,6,6.12,6.23,6.24,6.12,6,5.96,5.87,5.87,5.62,5.25,4.70,4.20,3.74,3.34,2.87,2.48,1.96,1.37,0.72,0,-0.63,-1.26,-1.88,-2.50,-2.67,-2.90,-3,-1.53,-0.25,1.34,2.75,5,8.96,12.87,14.87,16.87,17.87,15.87,13.87,13.11,12.85,12.84,12.83,13.82,12.82,11.75,10.75,9.75,8.75,7.87,7.21,6.87,6.75,6.21,6.11,6,5.75,5.20,5,5,5,4.97,4.84,4.35,3.86,3.37,2.87,2.37,1.75,1.12,0.37,-0.27,-0.80,-1.38,-1.77,-2.15,-2.50,-2.75,-2.84,-2.90,-2.96,-2.97,-2.98,-2.98,-2.98,-2.97,-2.96,-2.98,-3.02,-3.18,-3.46,-3.76,-4.10,-4.10,-3.92,-3.88,-4.17,-4.72,-5.47,-6.38,-7.34,-8.15,-8.83,-9.11,-9.26,-8.80,-8.16,-7.29,-6.50,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.97,6.95,6.87,6.82,6.70,6.50,6.37,6.23,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,6,6,5.99,5.98,5.95,5.83,5.62,5.36,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.12,5.24,5.35,5.35,5.35,5.24,5.12,5.12,5.34,5.62,5.24,5.11,5,5,5,5,5,5,5,5.10,5.12,5.82,5.75,5.75,5.25,5.12,5,5,5,5,5,4.99,4.98,4.95,4.86,4.62,4.36,4.12,4.11,4.22,4.37,4.50,4.60,4.62,4.73,4.85,5,5.23,5.37,5.62,5.75,6,6.23,6.37,6.61,6.74,6.62,6.50,5.87,5.61,5.25,4.98,4.57,4,3.37,2.75,2.25,1.75,1.37,0.99,0.50,0,-0.55,-1.13,-1.55,-2.01,-2.51,-2.75,-2.91,-3,-3,-1.38,0.49,2.58,5,7.98,10.96,12.95,14.87,15.87,15.87,14.87,13.87,12.87,12.85,12.11,12.11,12.12,12.82,11.82,10.87,9.99,9,8.11,7.20,7.11,6.87,6.75,6.20,6,5.75,5.20,5,5,5,5,4.84,4.20,4,3.59,3.12,2.62,2.12,1.60,0.98,0.37,-0.18,-0.75,-1.25,-1.68,-2.13,-2.50,-2.75,-2.88,-2.89,-2.90,-2.90,-2.91,-2.89,-2.88,-2.85,-2.85,-2.88,-3,-3.15,-3.38,-3.66,-3.68,-3.60,-3.54,-3.77,-4.24,-4.88,-5.68,-6.51,-7.26,-7.90,-8.18,-8.22,-7.91,-7.40,-6.65,-5.88,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.97,6.95,6.87,6.82,6.70,6.50,6.37,6.23,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,6,6,5.99,5.99,5.99,5.97,5.85,5.62,5.34,5.11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.12,5.46,5.62,5.87,5.87,5.87,5.62,5.34,5.23,5.74,5.83,5.07,5,5,5,5,6,6,5,5.10,5.12,5.84,6.10,6.22,6.10,5.75,5.25,5.25,5.24,5.12,5,5,5,5,4.97,4.87,4.62,4.37,4.21,4.24,4.37,4.59,4.74,4.85,4.87,5,5.11,5.25,5.50,5.72,5.87,6.12,6.37,6.62,6.87,7.07,7.12,7.49,6.25,5.58,4.87,4.62,3.87,3.25,2.62,2,1.37,0.85,0.37,-0.01,-0.39,-0.75,-1.13,-1.53,-2.03,-2.38,-2.63,-2.88,-3,-3,-3,-3,-1.16,0.50,4,7,9.99,9.97,11.95,12.07,13.87,13.87,13.11,12.87,11.87,11.12,11.12,11.11,11.12,11.83,11.12,10.82,9.87,9.11,8.20,7.75,7.20,7.11,6.75,6.20,6,5.82,5.12,5.12,5.12,5.12,5.12,5.11,4.86,4.12,3.87,3.37,3,2.50,2.07,1.50,1,0.49,-0.02,-0.52,-1.03,-1.52,-2,-2.38,-2.63,-2.75,-2.76,-2.78,-2.79,-2.87,-2.71,-2.67,-2.66,-2.72,-2.79,-2.89,-2.99,-3.18,-3.23,-3.21,-3.17,-3.42,-3.77,-4.33,-5,-5.74,-6.39,-6.93,-7.22,-7.33,-7.10,-6.61,-5.96,-5.18,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.97,6.95,6.87,6.82,6.70,6.50,6.37,6.23,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.98,5.98,5.98,5.87,5.62,5.34,5.09,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.12,5.34,5.75,6.50,6.37,6.60,6.62,6.22,5.75,5.12,5.08,5,5,5,5,5,5,5,5,5,5.10,5.87,6,6.75,6.75,6.75,6.21,5.87,5.70,5.62,5.25,5.12,5.12,5.12,5,4.98,4.87,4.72,4.50,4.37,4.47,4.61,4.75,4.87,5,5.12,5.25,5.37,5.50,5.72,5.87,6.12,6.37,6.74,7,7.25,7.46,7.48,6.82,5.87,4.75,3.99,3.25,2.62,1.96,1.25,0.62,0.09,-0.40,-0.88,-1.25,-1.52,-1.78,-2,-2.25,-2.63,-2.77,-2.88,-3,-3,-3,-3,-3,-1,1,1,6,7,7.98,7.96,8.95,10.08,12.87,11.87,10.87,10.12,10.12,10.86,10.12,10.12,10.84,10.83,10.11,9.82,9.11,8.82,8.12,7.82,7.12,6.82,6.12,6.11,5.87,5.87,5.87,6,6,6,5.87,5.12,4.87,4.12,3.83,3.35,2.95,2.50,2.11,1.62,1.20,0.75,0.32,-0.25,-0.75,-1.25,-1.68,-2.03,-2.25,-2.38,-2.39,-2.43,-2.38,-2.38,-2.38,-2.41,-2.50,-2.63,-2.75,-2.79,-2.79,-2.83,-2.87,-2.92,-3.10,-3.37,-3.77,-4.35,-4.97,-5.54,-6.04,-6.29,-6.37,-6.16,-5.75,-5.13,-4.43,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.98,6.95,6.87,6.75,6.62,6.50,6.37,6.23,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.97,5.87,5.87,5.62,5.33,5.09,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.12,5.36,5.70,6.08,6.25,6.75,6.87,6.87,6.87,6,6,5,5,5,5,5,5,5,5,6,5,5.10,5.87,6.11,6.12,6.75,6.75,6.73,6.12,5.96,5.62,5.34,5.12,5.62,5.12,5,4.98,4.87,4.83,4.72,4.62,4.71,4.75,4.87,5,5.12,5.36,5.50,5.62,5.75,5.87,6.12,6.37,6.62,7,7.37,7.59,7.50,7.50,6.98,4.99,3.75,2.75,1.99,1.25,0.62,0,-0.54,-1.03,-1.50,-1.79,-2.05,-2.38,-2.50,-2.63,-2.75,-2.89,-3,-3,-3,-3,-3,-3,-3,-1,-1,1.20,2.75,5,4,1,1,7.87,9.87,8.87,7.87,8.12,8.87,9.86,9.11,8.87,9.12,9.84,9.12,9.12,9.11,8.87,8.82,7.87,7.12,6.87,6.83,6.12,6,6.12,6.84,7,7.12,7.12,7,6.87,5.12,4.87,4.10,3.87,3.07,3,2.97,2,2,1.62,1.25,0.75,0.25,-0.28,-0.77,-1.25,-1.50,-1.63,-1.75,-1.77,-1.75,-1.75,-1.80,-1.90,-2.04,-2.25,-2.39,-2.54,-2.54,-2.63,-2.62,-2.65,-2.77,-2.98,-3.28,-3.72,-4.23,-4.74,-5.17,-5.42,-5.52,-5.38,-5,-4.37,-3.52,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.96,6.87,6.75,6.62,6.50,6.37,6.23,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.97,5.87,5.87,5.62,5.33,5.09,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.10,5.10,5.87,6,6.09,6.87,6.87,6.95,6.96,6.98,6,6,5,5,5,5,6,5,5,5,5,5,5.87,5.87,6,6.12,6.21,6.24,6.24,6.12,5.98,5.62,5.34,5.12,5.12,5.12,5,4.99,4.97,4.87,4.87,4.87,4.87,4.87,5,5.11,5.25,5.50,5.75,5.87,6,6.11,6.25,6.49,6.72,6.97,7.45,8.46,6.87,6.48,5.10,3.82,2.50,1.48,0.62,-0.02,-0.63,-1.13,-1.54,-1.90,-2.25,-2.43,-2.63,-2.76,-2.88,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-1,0.07,1.11,1.37,1.25,0.62,0.87,1,1.08,1.09,4.87,6.87,6.87,7.87,6.86,7.86,7.12,8.11,8.84,8.87,9,9,8.83,8,7.12,7,6.83,6.12,6,6.12,7,7.85,8.86,8.86,8.87,7.12,6.11,5.87,5.09,4.08,3.95,3.96,3,3,2.87,2.62,2.25,1.75,1.34,0.83,0.34,-0.13,-0.39,-0.63,-0.88,-0.88,-0.88,-1,-1.05,-1.25,-1.39,-1.63,-1.89,-2.13,-2.13,-2.17,-2.27,-2.38,-2.50,-2.63,-2.76,-3.08,-3.49,-3.97,-4.35,-4.61,-4.74,-4.65,-4.33,-3.64,-2.59,7,7,7,7,7,7,7,7,7,7,7,7,7,7.07,7.08,7.07,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.97,6.95,6.87,6.75,6.62,6.50,6.37,6.23,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.96,5.87,5.82,5.61,5.36,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.10,5.11,5.11,5.12,5.12,5.12,5.12,5.87,5.87,6.12,6.87,6.87,7,7,6.99,6.87,6,5.97,5.99,5,5,5,5,5,5,5,5,5,5.08,5.87,6,6,6,6,6,6,5.98,5.62,5.34,5,5,5,5,4.99,4.99,4.98,4.98,4.98,4.98,5,5.07,5.22,5.47,5.75,6,6.24,6.33,6.34,6.37,6.37,6.37,6.37,6.47,6.12,5.61,4.62,3.60,2.37,1.12,0.21,-0.51,-1.13,-1.53,-1.92,-2.29,-2.53,-2.75,-2.88,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-1,-1,-0.18,-0.05,-0.15,-0.38,-0.38,-0.63,-0.04,0.87,2,2.74,2.62,1.25,2.82,2.62,5.86,6.86,7.85,8.85,8.84,8.84,8.84,8,7.12,7.11,6.84,6.12,6,6.12,7.11,8.86,8.12,8.87,8.87,7.87,6.87,6.87,5.87,4.95,4,4,4,4,3.87,3.62,3.34,2.87,2.50,2,1.58,1.12,0.86,0.57,0.25,0.22,0.10,-0.02,-0.15,-0.38,-0.63,-0.88,-1.25,-1.38,-1.50,-1.63,-1.75,-1.88,-2.04,-2.25,-2.38,-2.50,-2.77,-3.18,-3.58,-3.83,-3.98,-3.97,-3.72,-3.04,-1.80,7,7,7,7,7,7,7,7,7,7,7.08,7.12,7.12,7.22,7.23,7.20,7.11,7.07,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.11,7.22,7.33,7.22,7.11,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.97,6.87,6.87,6.82,6.62,6.50,6.37,6.23,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.98,5.95,5.87,5.82,5.61,5.36,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.09,5.10,5.11,5.12,5.86,5.86,5.85,5.85,5.84,5.84,5.87,6,6.12,6.85,7.10,7.11,7,6.99,6.87,6.09,6,5.96,5,5,5,5,5,5,5,5,5,5.87,5.87,6,6.12,6.21,6.23,6.24,6.12,5.98,5.62,5.34,5,5,5,5,4.99,4.99,5,5,5,5.07,5.09,5.20,5.37,5.62,6,6.32,6.50,6.73,6.62,6.37,6.08,5.75,5.49,5.11,4.61,3.87,3.07,2.11,1.10,0.10,-0.88,-1.50,-1.92,-2.25,-2.55,-2.75,-2.88,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-1,1,-1,-1,-1,-1,-1,-1.02,-0.75,-0.25,0.12,0.08,-0.25,0.50,0.25,0.73,1.87,2.50,3.62,4.75,7.85,7.85,7.87,7.87,7.85,7.12,6.85,6.12,6,6.12,6.87,7.87,7.87,7.87,7.87,7.87,7,6.08,5.87,5,4.97,4.99,5,5,4.87,4.75,4.50,4.20,3.82,3.37,2.96,2.57,2.23,1.87,1.50,1.36,1.12,0.99,0.83,0.62,0.37,0,-0.29,-0.43,-0.63,-0.76,-1,-1.17,-1.39,-1.63,-1.78,-2,-2.13,-2.29,-2.78,-3.02,-3.23,-3.29,-3.17,-2.71,-1.43,7,7,7,7,7,7.08,7.10,7.11,7.10,7.12,7.25,7.37,7.60,7.74,7.73,7.50,7.37,7.12,7.07,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7.11,7.37,7.75,7.87,7.50,7.22,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.97,6.87,6.87,6.75,6.62,6.50,6.37,6.23,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.97,5.87,5.87,5.75,5.60,5.36,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.10,5.12,5.87,5.12,5.12,5.83,5.99,6,6.11,6.11,6.11,6,6.11,6.20,6.87,7.82,7.11,7,6.99,6.87,6.12,6,5.87,5.95,5,5,5,5,5,5,5,5.97,5.87,5.99,6,6.12,6.75,6.75,6.75,6.24,5.99,5.75,5.32,5.34,5.24,5.12,5,5,5,5,5.12,5.25,5.37,5.37,5.50,5.62,5.87,6.20,6.50,6.75,6.95,7.47,6.20,5.47,4.86,4.25,3.70,3.09,2.37,1.61,0.75,-0.04,-0.88,-1.65,-2.17,-2.53,-2.68,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-1,-1,-1,-1,-0.38,-0.13,-0.14,-0.17,-1,-1,-1.13,-1.30,-1.29,-1.25,-1.42,-0.88,-0.52,-0.50,0,0.75,0.37,5.70,6.86,7.86,7.86,7.11,6.86,6.11,5.87,5.87,6,6.12,6.87,7,7.10,7,6.87,6,5.96,5,5,5,6,6,5.97,5.75,5.62,5.50,5.12,4.75,4.37,4,3.62,3.25,2.87,2.50,2.21,1.97,1.75,1.57,1.33,1,0.75,0.62,0.49,0.25,0.08,-0.25,-0.50,-0.77,-1,-1.25,-1.50,-1.75,-1.93,-2.25,-2.50,-2.67,-2.74,-2.52,-2,7,7,7,7,7.10,7.22,7.32,7.32,7.25,7.34,7.62,8,8.37,8.62,8.58,8.12,7.70,7.33,7.12,7.08,7,7.07,7.07,7,7,7.07,7.09,7.11,7.12,7.11,7.08,7,7,7.22,7.62,8.11,8.22,7.75,7.33,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.97,6.87,6.87,6.75,6.62,6.50,6.37,6.22,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.97,5.87,5.87,5.75,5.59,5.36,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.11,5.86,5.12,5.12,5.20,5.75,5.99,6,6.12,6.75,6.12,6,6.22,6.75,6.99,7.11,7.11,7,6.99,6.84,6.12,6,5.99,5.87,5,5,5,5,5,5,6,5.99,6,6,6,6.12,6.82,7.75,6.75,6.25,6,5.86,5.75,5.62,5.62,5.35,5.12,5,5,5.12,5.37,5.62,5.87,6,6,5.98,6,6.25,6.73,6.98,6.97,6.50,5.62,4.61,3.75,2.98,2.32,1.62,1,0.34,-0.38,-1,-1.63,-2.26,-2.64,-2.88,-2.91,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-1,0.22,0.75,0.97,1,1.25,1.50,1.75,1.75,-0.75,1.75,0.87,0,-0.42,-0.27,-0.88,-2.53,-1.76,1.62,1.71,5.87,6.87,6.87,6.12,5.87,5.12,5.12,5.11,5.11,5.87,6,5.99,6.87,5.95,5,4.97,5,6,6,6,7,6,5.86,6.97,5.75,5.50,6.12,5.74,5.37,5.07,4.62,4.12,3.57,3.12,2.82,2.50,2.33,2.12,1.87,1.83,1.75,1.72,1.60,1.35,1,0.62,0.37,0.08,-0.25,-0.50,-0.79,-1.13,-1.50,-1.80,-2.13,-2.38,-2.53,-2.39,7,7,7,7.08,7.24,7.50,7.75,7.83,7.75,7.86,8.25,8.95,9.50,9.87,9.60,8.75,8.11,7.58,7.25,7.20,7.21,7.24,7.25,7.24,7.24,7.25,7.25,7.34,7.35,7.33,7.24,7.12,7,7.22,7.50,7.87,7.87,7.50,7.22,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.97,6.87,6.87,6.75,6.62,6.50,6.37,6.22,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.97,5.87,5.87,5.75,5.59,5.37,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.11,5.12,5.75,5.21,5.22,5.75,5.99,6,6.11,6.12,6.12,6.12,6.24,6.75,6.99,7,7,7,6.99,6.75,6.12,6,5.99,5.87,5.87,5.07,5,5,5,6,6,6,6,6.08,6.11,6.12,6.83,6.75,6.75,6.24,6,5.98,5.96,5.95,5.84,5.62,5.35,5.12,5.08,5.25,5.82,6.37,6.82,6.75,6.59,6.21,6,6.12,6.50,7.50,6.50,5.58,4.50,3.37,2.37,1.62,1,0.37,-0.17,-0.75,-1.28,-1.77,-2.25,-2.66,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-1,1,2,2,3,3.22,3.86,4.45,4.85,7.50,5.50,4.60,2.37,2.25,2.12,1.70,1.12,0.62,0,1.70,4.07,5.12,5.12,5.87,5.87,5.11,5,5,5,5,4.87,4.87,4,4,4,4,4,5,6,6,6.13,6.07,5.85,5.50,5.13,5.12,5.82,6.75,6.36,6.11,5.75,5.12,4.37,3.85,3.37,3.09,2.75,2.62,2.60,2.70,2.87,3.11,3.11,2.75,2.37,2.11,1.75,1.50,1.12,0.87,0.60,0,-0.51,-1.13,-1.50,-1.88,-2.25,-2.38,7,7,7,7.12,7.37,7.96,8.50,8.62,8.62,8.62,9.25,10,10.73,10.96,10.25,9.37,8.60,7.97,7.62,7.50,7.62,7.70,7.72,7.72,7.70,7.71,7.73,7.74,7.71,7.62,7.46,7.25,7.11,7.12,7.22,7.33,7.33,7.22,7.11,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.97,6.87,6.87,6.75,6.62,6.50,6.37,6.22,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.97,5.95,5.87,5.75,5.60,5.37,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.23,5.22,5.75,5.75,5.87,5.99,6,6,6,6.12,6.25,6.73,6.87,6.99,7,7,7,6.99,6.75,6.21,6,6,5.99,5.87,5.10,5.07,5,5.99,6,6,6,6.97,6.87,6.10,6.12,6.12,6.12,6.21,6.12,6,6,6,5.98,5.96,5.84,5.62,5.35,5.36,5.37,6.37,7.62,7.95,7.70,6.85,6.20,5.75,5.71,5.75,5.62,5,4.60,3.48,1.60,1.12,0.37,-0.17,-0.75,-1.15,-1.63,-2.01,-2.38,-2.65,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-1,1,2,3,4,5,6,6.99,7.97,8.96,9.95,9.95,7.87,6.87,5.09,5.50,5.22,4.88,5.36,1.10,5.87,6.10,5.10,5.10,5.10,5.09,5.09,4.87,4.74,4.07,4,3,3,3,3,3,3,4,3.99,4.99,4.12,3.22,4,4,3.62,3.50,5.25,6,5.97,5.87,5.87,5.12,4.45,3.87,3.84,3.21,2.99,2.87,2.87,3.12,3.57,5,4.87,4.12,3.87,3.75,3.62,3.24,3.09,2.87,2.62,1.86,0.34,-0.25,-0.88,-1.15,-1.14,-0.50,7.12,7.12,7.12,7.35,7.75,8.59,9.37,9.71,9.73,9.71,10.35,11.25,11.83,11.62,10.87,10,9.25,8.62,8.33,8.25,8.37,8.49,8.50,8.50,8.46,8.37,8.33,8.24,8.11,7.87,7.62,7.37,7.21,7.08,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.97,6.87,6.87,6.75,6.62,6.50,6.37,6.23,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.87,5.75,5.58,5.37,5.12,5.07,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5.12,5.25,5.72,5.85,5.99,5.99,6,6.12,6.23,6.25,6.25,6.71,6.87,6.99,6.99,7,7,7,6.99,6.75,6.22,6.12,6,6,5.87,5.87,5.87,5.95,5.97,6,6,6,6.99,7.96,6.87,6.11,6,6,6,6,5.98,5.97,5.98,5.99,5.98,5.96,5.86,5.75,5.82,6.25,7.32,8.62,10.62,8.12,6.87,5.82,5.12,4.83,4.62,3.87,3.62,1.35,1.37,0.58,-0.13,-0.66,-1.16,-1.63,-1.91,-2.25,-2.51,-2.75,-2.90,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-1,1,2,4,5,6,7,8,8,9,10,10,10.95,9.95,9.87,8.87,9.87,9.87,7.87,7.09,7.87,8.87,8.87,7.09,6.08,6.25,6.25,5.72,6.32,5.63,4,3,2,2,2,2,1,1,1,1,1,0.23,0.23,1,0.12,2.86,3.74,3.96,4.12,4.46,4.35,4.12,3.71,3.47,3.20,3,2.98,2.98,2.87,3.11,3.74,4.50,5.10,5.25,5.37,5.58,5.70,5.87,6,6.08,5.75,4.73,2.25,0.12,-0.01,-0.13,-0.25,0.37,7.50,7.50,7.57,7.83,8.46,9.37,10.37,10.84,10.87,10.87,11.58,12.25,12.62,12.12,11.50,10.75,10.10,9.60,9.36,9.37,9.49,9.59,9.62,9.50,9.37,9.24,9,8.75,8.50,8.21,7.87,7.59,7.34,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.97,6.95,6.87,6.82,6.70,6.50,6.37,6.23,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.87,5.75,5.58,5.37,5.12,5.07,5,5,5,5,5,5,5,5,5,5,5,5,5,5.11,5.25,5.62,5.75,5.87,6,6,6.12,6.25,6.62,6.62,6.75,6.87,6.99,7,7,7,7,7,7,6.87,6.75,6.23,6.21,6.20,6.12,6.12,6.12,6.09,6,6,6,6,7,6.99,6.87,6.10,6,5.98,5.97,5.86,5.75,5.75,5.87,6,6,6,6,6.11,6.34,6.87,7.87,9.62,9.62,8.62,6.32,5,4.23,3.62,2.97,1.85,1.34,0.72,-0.63,-0.67,-1.13,-1.63,-1.93,-2.25,-2.43,-2.63,-2.77,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-1.38,-0.63,1,3,5,7,8,9,9,10,11,11,11,11.97,11.96,11.96,11,11.95,10.87,9.87,9.87,9.07,9.87,9.87,9.11,8.99,9.12,9,7.98,7.37,7.60,6.85,4,3,1.95,1.75,0.85,1,0.95,0.59,-0.63,0.95,0.87,-0.93,-0.55,0.50,1.08,1.08,1.08,2.08,2.08,2.87,2.07,3.09,3.12,2.37,2.61,3.12,3.12,2.99,2.25,3.48,4.62,5.50,6.24,6.85,7.37,7.87,8.32,9.21,9.37,9.50,8.62,6.75,5.25,1.87,1.82,1.72,1.50,8.25,8.25,8.32,8.62,9.46,10.62,11.62,12.07,12.12,12.25,12.75,13.25,13.20,12.75,12.22,11.61,11.08,10.72,10.58,10.61,10.72,10.75,10.75,10.62,10.37,10.07,9.62,9.25,8.86,8.46,8.08,7.74,7.46,7.25,7.11,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.95,6.87,6.83,6.71,6.50,6.37,6.23,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.97,5.87,5.75,5.59,5.36,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5.10,5.22,5.37,5.70,5.87,6,6.09,6.12,6.35,6.62,6.87,7,7,7,7,7.12,7.23,7.32,7.32,7.25,7.25,7.22,7,6.75,6.75,6.75,6.75,6.84,6.86,6.87,6.87,6.96,6.99,7,7,6.99,6,6.08,5.87,5.86,5.84,5.82,5.21,5.23,5.75,6.10,6.12,6.12,6.12,6.25,6.75,7.25,8.10,8.62,8.62,6.74,5.21,3.87,3,2.34,1.50,0.72,-0.18,-0.75,-1.26,-1.75,-2.03,-2.26,-2.50,-2.63,-2.75,-2.88,-2.91,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-3,-2,-1.38,-0.53,0.62,1,4,7,8,10,11,12,13,13,12,13,12,12,12.97,12.97,12,11.96,11,10,10,10,10,10,10.83,11.75,9.60,7.98,7.12,6.38,6.74,5.13,2.50,2.12,2.82,2.37,1.87,0.87,-0.88,-0.53,0.87,0.73,-0.91,-0.52,-0.52,0.87,0.10,0.10,0.10,1.10,2.10,2.09,3.09,3.21,3.33,3.49,3.62,3.72,3.45,3.12,3.24,5.07,6.12,7.12,8.12,9.25,10,10.62,10.75,11,11.62,10.75,10.87,10,10.12,8.23,7.46,6.50,9.85,9.87,9.97,10.24,11.07,12.25,13.24,13.50,13.47,13.59,13.87,14,13.71,13.36,12.87,12.37,12,11.75,11.71,11.75,11.86,11.87,11.83,11.59,11.21,10.72,10.12,9.62,9.12,8.62,8.23,7.86,7.50,7.32,7.12,7.07,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.98,6.97,6.87,6.83,6.71,6.50,6.37,6.24,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.97,5.87,5.75,5.59,5.36,5.12,5,5,5,5,5,5,5,5,5,5,5,5.10,5.12,5.23,5.37,5.60,5.82,6,6.12,6.32,6.37,6.70,6.96,7.22,7.33,7.33,7.23,7.23,7.34,7.62,7.62,7.62,7.75,7.87,7.75,7.25,7.22,7.11,7,7.11,7.12,7.85,7.12,7.10,7.07,7,7,7,7,6,5.99,5.87,5.11,5.10,4.87,4.87,5.11,5.75,6.11,6.75,6.25,6.25,6.72,6.87,7.70,7.62,8.20,6.45,5.09,3.62,2.61,1.75,1.08,0.37,-0.38,-1.15,-1.75,-2.17,-2.75,-2.66,-2.75,-2.78,-2.88,-2.90,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.68,-2.75,-1.66,-0.90,-0.17,0.62,1,3,5,7,9,11,13,14,15,14,13,13,12,13,13.99,13.99,13,12.98,11,10.97,10,10,10.87,11.75,12.25,12.12,10.10,8.37,6.61,6.33,7.71,4.38,2.25,2.83,3.75,5.25,6.07,0.50,0.37,0.60,0.75,0.74,0.88,1.11,0.22,0,0.88,0.86,0.96,2.98,4.87,5.87,5.87,5.87,5.75,5.62,5.12,4.62,4.25,4.25,4.75,5.75,6.87,7.96,9.07,10.59,13.57,12.25,12.22,12.12,12.12,12,12.12,14.11,14.20,13.25,13.37,12.58,12.08,12.22,12.37,12.62,13.25,14.12,14.86,14.86,14.57,14.50,14.62,14.47,14.21,13.87,13.50,13.12,12.85,12.62,12.62,12.62,12.72,12.71,12.50,12.12,11.62,11.07,10.37,9.83,9.25,8.75,8.34,7.96,7.62,7.37,7.21,7.10,7,7,7,7,7.12,7.12,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.96,6.87,6.84,6.71,6.50,6.37,6.24,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.87,5.84,5.61,5.35,5.12,5,5,5,5,5,5,5,5,5,5.08,5.12,5.25,5.36,5.45,5.60,5.75,5.96,6.12,6.45,6.62,6.85,7,7.25,7.60,7.62,7.62,7.62,7.24,7.62,7.62,7.86,7.98,8.21,8.62,8.62,7.99,7.72,7.25,7.24,7.22,7.75,7.87,7.87,7.87,7.87,7.96,7.99,8,7,6,5.97,5.87,5,4.11,4.12,4.12,4.82,5.21,5.98,6.75,6.75,6.74,6.73,6.70,6.45,6.25,5.62,4.73,3.46,2.25,1.25,0.50,-0.13,-0.66,-1.27,-1.92,-2.76,-2.78,-2.88,-2.92,-2.92,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.78,-2.63,-2,-1.30,-0.63,0.35,1.12,1,4,5,7,8,10,12,13,15,14,14,13,13,13,14,15,14,14,12,11,10,10,10.97,11.95,12.82,13.50,12.82,11.86,10.37,9.50,9.23,7.58,5.12,5.25,5.07,5.49,7,6.84,6.38,5.58,4.86,5.87,6.11,5.50,4.75,3.75,3.50,4.20,3.12,3.20,4.62,6.97,6.98,6.99,7.87,7.87,7.75,6.70,5.37,5.12,5.25,5.73,6.50,8,8.37,9.48,10.98,12.87,13.97,12.97,12.98,12.75,12.86,12.83,13.50,14.25,15.37,16.50,16.58,14.59,14.82,15.12,15.37,15.86,16.12,16.23,15.75,15.25,15.09,14.99,14.75,14.59,14.25,13.99,13.71,13.48,13.33,13.25,13.22,13.12,13,12.74,12.25,11.71,11.08,10.37,9.85,9.32,8.84,8.37,8,7.71,7.45,7.25,7.12,7.08,7,7,7.07,7.12,7.21,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.97,6.87,6.85,6.70,6.50,6.37,6.24,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.96,5.87,5.74,5.24,5.08,5,5,5,5,5,5,5,5,5.09,5.21,5.37,5.50,5.61,5.62,5.75,5.87,6,6.25,6.62,7.47,7,7.12,7.50,7.62,7.82,7.62,7.34,7.23,7.23,7.37,7.62,7.87,8.32,8.62,8.62,8.32,7.87,7.75,7.74,7.75,8,8.20,8.84,8.11,7.99,7.99,8,9,8,6,6,5,4.87,4.10,4,4.08,4.12,4.87,5.75,6.12,6.75,6.75,6.73,5.72,5.09,4.58,3.95,3.10,2.10,1.09,0.20,-0.51,-1.13,-1.53,-2,-2.50,-2.79,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.77,-2.63,-1.68,-0.91,-0.25,0.71,1.25,3,4,6,8,10,10,12,12,13,13,14,13,13,13,14,14,13,13,13,12,10.99,10,10,10.99,11.98,13.87,12.99,12.72,12.49,12.12,12,9.75,8.88,8.35,6.87,7.88,6,6,7.38,8.22,6.50,5.95,7.12,8.25,8.46,6.58,4.86,5.37,5.82,5.50,5.83,6.49,7.97,7.87,7.12,7.99,8.87,7.87,6.87,6.12,5.73,5.87,6.32,7,7.75,8.49,9.32,10.32,11.25,11.96,12.37,12.75,13.37,13.75,13.74,13.62,13.60,14.47,15.50,17.57,16.46,16.75,17.12,17.62,18,17.87,17.22,16.34,15.75,15.45,15.24,15,14.84,14.61,14.36,14.12,13.87,13.74,13.58,13.37,13.22,12.87,12.50,12,11.37,10.84,10.25,9.73,9.25,8.82,8.37,8.07,7.75,7.50,7.36,7.24,7.12,7.11,7.08,7.09,7.12,7.12,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.97,6.87,6.82,6.70,6.50,6.37,6.25,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,6,6,6,5.99,5.99,5.99,5.98,5.95,5.75,5.23,5,5,5,5,5,5,5,5.08,5.12,5.22,5.37,5.59,5.74,5.84,5.87,5.87,5.98,6.10,6.32,6.62,6.87,6.99,7,7.20,7.50,7.50,7.25,7.11,7,7,7.11,7.33,7.62,8.10,8.62,8.62,8.33,8.12,8.22,8.25,8.25,8.23,8.75,8.12,8.12,7.87,7.87,7.96,8,8,6,5,4.99,4.97,3.99,3.87,3.75,3.75,4.12,4.87,5.62,5.62,5.75,4.32,3.87,3.50,3,2.50,1.75,0.87,0.09,-0.75,-1.38,-1.88,-2.25,-2.50,-2.75,-2.91,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.75,-2.63,-1.53,-0.75,0.25,1.23,1.25,3.87,5,6,7,10,11,12,11,12,12,13,13,13,13,13,13,13,12,12,11,10.98,10,10.07,10.08,10.99,11.87,12.12,12.12,12,11.85,11.12,10.35,9.37,8.21,7.99,8,7.25,6.82,6.75,8.33,7.95,7.11,6.88,7.87,8.62,7.84,7.75,6.83,6.75,7.45,7.87,7.12,7.75,8.12,7.99,7.87,8.12,8.87,7.98,7.11,6.10,6.10,6.09,6.87,7.12,7.84,8.12,8.75,9.33,9.96,10.62,11.33,12.49,13.84,15.37,15.45,14.50,13.46,13.46,14.46,15.58,17.10,17.37,17.87,18.34,18.75,18.87,17.62,16.62,16.08,15.62,15.37,15.12,15,14.82,14.62,14.37,14.20,13.97,13.71,13.37,13,12.60,12.12,11.58,11,10.49,9.99,9.50,9.12,8.75,8.37,8.12,7.85,7.62,7.49,7.37,7.25,7.23,7.12,7.12,7.10,7.08,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.97,6.97,6.87,6.82,6.70,6.50,6.37,6.24,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.99,5.98,5.97,5.87,5.75,5.25,5,5,5,5,5,5.07,5.12,5.25,5.37,5.47,5.62,5.75,5.87,5.97,5.99,6,6,6.10,6.25,6.46,6.61,6.62,6.73,6.82,6.87,6.87,6.83,6.70,6.62,6.62,6.62,6.87,7.22,7.75,8.21,8.62,8.22,8.24,8.70,9.12,9.23,9.22,8.87,8.75,7.99,7.87,7.10,6.95,6.99,6,5,4,4,3.70,3.34,3,2.87,2.87,3.12,3.61,5.58,4.62,1.25,1.96,2,1.97,1.74,1.25,0.62,-0.01,-0.75,-1.42,-2,-2.38,-2.63,-2.80,-2.91,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-1.88,-1.25,-0.50,0.37,1.37,2.71,4.75,5.87,9,9,8,9,11,11,11,11,12,13,13,13,12,12,12,11,11,11,10,9.96,9.87,9.87,10.11,10.87,11.86,11.12,11.12,11.12,10.87,10.82,9.99,9,8.12,8.12,8.87,8.75,8.47,9.50,9.73,9.46,8.62,8.37,9,8.84,8.58,8,8.20,8.12,8.62,8.50,8.62,8.12,8.11,7.99,8,8.12,8.86,7.87,7.12,6.87,6.87,6.87,6.87,7.10,7.10,7.87,8.11,8.12,8.87,9.12,10.21,11.25,14.62,16.62,16.60,16.60,15.87,15.37,14.37,12.60,16.48,16.75,17.12,17.62,18.12,18.12,17.46,16.73,16.12,15.75,15.49,15.25,15.12,14.98,14.83,14.62,14.37,14.09,13.72,13.25,12.75,12.23,11.62,11.12,10.61,10.12,9.70,9.32,8.99,8.62,8.37,8.12,7.97,7.75,7.70,7.60,7.50,7.37,7.32,7.21,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.98,6.97,6.87,6.87,6.82,6.70,6.50,6.37,6.24,6.12,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.97,5.87,5.71,5.25,5.25,5.25,5.25,5.32,5.33,5.34,5.37,5.62,5.75,5.84,5.85,5.96,6,6.11,6.12,6.09,6.07,6.09,6.12,6.25,6.34,6.37,6.37,6.37,6.37,6.37,6.37,6.37,6.33,6.33,6.34,6.37,6.75,7.22,7.62,7.75,7.87,8.22,9.10,10.71,10.73,9.98,9.75,8.20,7.83,6.87,6.11,5.87,5,5,4,4,3.12,2.74,2.32,2,1.87,1.75,1.75,1.87,1.46,1.37,0.84,0,0.47,0.74,0.62,0.34,-0.25,-0.79,-1.40,-2,-2.42,-2.68,-2.88,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-1.75,-1.25,-0.63,-0.04,0.62,1.34,2.82,4.25,5.83,7,10,9,9,10,11,11,11,11,12,12,12,12,11,11,10,10,10,9.98,9,9.08,9.09,9.87,10.10,10.85,10.84,10.83,10.82,10.12,10.20,10.21,10.22,9.38,9.45,9.83,9.82,10.25,10.21,10.08,10,9.87,9.62,9.25,9,8.96,8.82,8.75,8.75,8.75,8.84,8.84,8.83,8.12,8,7.99,7.99,8.11,8.10,7.87,7.12,7.12,7.11,7.10,7.12,7.12,7.12,7.12,7.85,7.86,8,8.12,9.12,10.75,12.83,15.62,16.62,17.61,18.61,17.61,15.87,13.62,15.10,15.37,15.87,16.37,16.87,17.12,16.95,16.57,16.12,15.82,15.50,15.37,15.25,15.12,15,14.82,14.50,14.12,13.62,13.09,12.49,11.87,11.25,10.74,10.24,9.82,9.46,9.12,8.87,8.62,8.37,8.25,8.12,8,7.96,7.87,7.75,7.62,7.50,7.35,7.20,7.10,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.96,6.87,6.87,6.75,6.62,6.50,6.37,6.23,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.98,5.87,5.82,5.71,5.62,5.62,5.62,5.62,5.62,5.62,5.75,5.87,6.50,6.08,6,6.12,6.25,6.32,6.32,6.25,6.12,6.09,6.07,6.10,6.12,6.12,6.12,6.12,6.12,6.12,6.11,6.09,6,6,6,6.12,6.35,6.62,6.87,7.10,7.34,7.87,8.87,10.70,10.72,10.74,9.75,8.11,7,6.12,5.11,4.87,4,4,3,2.75,2.33,1.75,1.35,1,0.75,0.59,0.37,0.09,-0.55,-0.63,-0.67,-0.65,-0.38,-0.04,-0.13,-0.40,-0.90,-1.43,-1.93,-2.38,-2.75,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-1.75,-0.88,0.21,0.87,1.24,1.37,2.75,4,5.57,6.62,8.10,9.70,10.07,10.72,10.75,10.99,11.12,11.87,11.97,12,11,11,11,10,10,9,9,9,9,9.08,9,9.12,9.12,9.85,10.10,10.12,10.20,10.10,9.87,9.75,9.75,9.75,9.83,10,10.21,10.25,10.12,10.08,10,9.98,9.87,9.62,9.34,9.09,8.99,8.87,8.87,8.87,8.87,8.82,8.75,8.21,8.12,8,7.99,7.99,8,8,7.87,7.86,7.87,7.87,7.97,7.87,7.83,7.12,7.12,7.12,7.12,7.12,7.83,8.20,9.20,11.23,13.25,15.71,16.62,18.62,18.62,17.62,16.71,13.87,14.12,14.61,15.25,16,16.37,16.48,16.33,16.08,15.82,15.61,15.50,15.37,15.33,15.12,14.97,14.62,14.12,13.50,12.87,12.23,11.59,11,10.47,10,9.62,9.34,9.09,8.87,8.62,8.50,8.37,8.25,8.25,8.24,8.21,8.10,7.87,7.72,7.50,7.25,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.96,6.87,6.86,6.75,6.62,6.50,6.36,6.21,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,6,6,5.99,5.99,5.98,5.97,5.95,5.87,5.87,5.87,5.87,5.95,5.87,5.97,6.10,6.12,6.12,6.12,6.25,6.46,6.57,6.50,6.37,6.25,6.11,6,6,6,6,6,6,6,6,6,6.12,6.12,6.12,6,6,6.12,6.23,6.35,6.37,6.62,7.23,8.10,8.87,9.25,9.21,8.75,7.22,6.12,5.85,4.87,4.09,3.96,3,2.46,1.87,1.37,0.87,0.37,0,-0.30,-0.63,-0.88,-1.25,-1.65,-1.88,-1.75,-1.38,-0.88,-0.41,-0.52,-1,-1.50,-2,-2.38,-2.66,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-1.75,-1,0.07,0.87,1.75,2.70,3.11,3.97,5.12,6.12,7.36,8.50,9.74,10.61,10.87,11.07,11.21,11.62,11.70,11.75,11,10.07,10,10,10,9,9,9,9,9,9,9,9,9.12,9.12,9.75,9.75,9.75,9.75,9.23,9.24,9.25,9.25,9.25,9.62,9.87,10,10,10,10,9.97,9.87,9.62,9.36,9.11,9,8.95,8.87,8.75,8.72,8.75,8.23,8.12,8,7.99,7.99,8,8.11,8.12,8.12,8.12,8.12,8.87,8.96,8.75,8.21,7.82,7.22,7.12,7.07,7.12,7.21,7.75,8.22,9.22,11.75,13.24,15.12,16.75,17.75,17.75,16.75,13.25,13.50,13.97,14.62,15.49,15.87,16.12,16.12,16,15.86,15.74,15.62,15.62,15.50,15.37,15.09,14.62,14.07,13.37,12.62,11.99,11.36,10.75,10.34,9.96,9.62,9.37,9.22,9,8.84,8.62,8.57,8.50,8.50,8.50,8.49,8.37,8.12,7.87,7.62,7.37,7.21,7.09,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.98,6.96,6.87,6.86,6.75,6.62,6.50,6.35,6.21,6.09,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,6,6,6,6,6.12,6.12,6.12,6.12,6.12,6.10,6.08,6.08,6.11,6.12,6.12,6.20,6.25,6.49,6.70,6.75,6.75,6.57,6.34,6.12,6,6,6,6,6,6,6,6,6,6.12,6.50,6.12,6,6,6,6,6,6.12,6.24,6.36,7,7.62,7.75,7.75,7.75,6.22,5.75,4.99,4.12,3.87,3,2.48,1.75,1.12,0.59,0,-0.50,-0.88,-1.18,-1.53,-1.88,-2.13,-2.64,-2.75,-2.78,-1.92,-1.25,-0.67,-0.90,-1.50,-2.02,-2.50,-2.68,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-1,-0.75,0,0.75,1.62,2.37,3.25,4.11,5.37,5.84,6.84,7.97,9.25,10.37,11.12,11.25,11.25,11.37,11.25,11.12,10.87,10.36,10.12,10,9.99,10,9,9,9,9,9,9,9,9,9,9.12,9.21,9.22,9.24,9.24,9.12,9,9,9.10,9.23,9.35,9.72,9.87,9.98,9.99,9.98,9.96,9.87,9.62,9.37,9.12,9,8.87,8.75,8.62,8.32,8.25,8.12,8,8,7.99,8,8.12,8.12,8.84,9,9.12,9.87,10.12,10.12,9.75,9.12,8.25,7.82,7.24,7.12,7,7.12,7.23,8.12,9.24,10.25,11.75,13.23,14.75,15.25,15.25,14.75,13.49,13.62,14,14.62,15.25,15.71,15.87,16,15.99,15.87,15.87,15.87,15.83,15.74,15.50,15.12,14.62,13.87,13.12,12.46,11.75,11.20,10.73,10.37,10.12,9.87,9.75,9.59,9.37,9.12,8.97,8.83,8.75,8.74,8.74,8.70,8.58,8.36,8.07,7.75,7.48,7.25,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.97,6.96,6.87,6.86,6.75,6.62,6.49,6.34,6.20,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6.11,6.25,6.50,6.37,6.37,6.36,6.36,6.36,6.36,6.34,6.35,6.36,6.37,6.57,6.75,7,7,6.87,6.62,6.37,6.12,6,6,6,6,6,6,6,6,6,6.11,6.12,6.11,6,6,6,6,6,6,6,6,6.12,6.23,6.25,6.73,6.11,5.22,4.87,4.12,3.87,3.10,2.95,1.82,1.08,0.37,-0.18,-0.75,-1.25,-1.63,-1.91,-2.25,-2.50,-2.63,-2.88,-3,-2.88,-2.93,-1.51,-1.38,-1.50,-2.13,-2.55,-2.80,-2.92,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-1.50,-0.54,0.37,1,1.45,2.25,3.10,3.87,4.75,5.50,6.33,7.36,8.75,10.23,11.36,11.87,11.72,11.37,11.09,10.87,10.62,10.37,10.12,10,10,9.97,9.86,9,9,9,9,9,9,9,9,9,9,9.08,9.12,9.20,9.12,9.07,9,9,9,9.12,9.37,9.62,9.86,9.96,9.97,9.96,9.87,9.85,9.72,9.58,9.25,9,8.82,8.62,8.36,8.20,8.08,8,8,7.99,8,8.12,8.12,8.82,9.12,10,10.82,11.75,11.75,11.75,11.20,10.23,9.23,8.25,7.73,7.25,7.07,7,7.25,8,9,9.87,10.25,11.25,12.72,13.25,13.75,13.74,13.87,14.12,14.48,14.97,15.37,15.71,15.87,16,16,16,16.07,16,16,15.87,15.62,15.12,14.50,13.74,12.97,12.25,11.62,11.12,10.82,10.62,10.50,10.46,10.36,10.21,9.97,9.62,9.37,9.12,9,8.87,8.87,8.84,8.71,8.48,8.12,7.85,7.50,7.33,7.12,7.07,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.98,6.98,6.97,6.96,6.87,6.87,6.84,6.75,6.62,6.49,6.34,6.20,6.09,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6.12,6.12,6.12,6,6,6,6,6,6,6,6,6.07,6.12,6.37,6.50,6.62,6.62,6.62,6.62,6.62,6.62,6.62,6.62,6.62,6.73,6.87,7.25,7.45,7.37,7.12,6.83,6.50,6.25,6.12,6,6,6,6,6,6,6,6,6,6.07,6,6,6,6,6,6,5.99,5.87,5.62,5.34,5.32,5.25,5.25,5.25,4.87,4.20,3.87,3.12,2.87,2,1.37,0.50,-0.26,-0.91,-1.50,-1.88,-2.18,-2.41,-2.66,-2.88,-2.88,-3,-3,-3,-3,-3,-2,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.89,-2.67,-3,-1.93,-1.25,-0.50,0.50,1.37,2.48,2.46,2.97,3.75,4.57,5.24,5.86,6.47,7.62,9.36,11.25,12.62,12.87,12.23,11.47,10.75,10.50,10.32,10.12,10.07,10,9.99,9.96,9.70,9.20,9,9,9,9,9.12,9.12,9.20,9.12,9.08,9.12,9.25,9.72,9.25,9.12,9.07,9,9,9.12,9.37,9.62,9.86,9.95,9.87,9.87,9.85,9.74,9.62,9.57,9.23,8.96,8.71,8.37,8.22,8.08,8,8,7.99,7.99,8,8.22,8.75,9.12,10.10,10.99,11.87,12.75,13.75,13.74,12.73,11.72,9.73,8.72,7.87,7.25,7.12,7.25,7.25,8.11,8.87,9.72,9.87,10.25,11.24,12,12.71,12.72,14.61,14.82,15,15.36,15.62,15.86,16,16.12,16.12,16.23,16.24,16.20,16.12,15.96,15.60,15,14.25,13.50,12.75,12.08,11.50,11.21,11,11,11.11,11.12,11.12,11,10.74,10.36,9.95,9.58,9.25,9.12,9,8.96,8.77,8.55,8.28,7.97,7.67,7.43,7.25,7.12,7.03,7.01,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.97,6.96,6.87,6.87,6.84,6.75,6.62,6.48,6.34,6.21,6.09,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6.12,6.47,6.12,6.10,6.07,6.07,6,6,6,6,6.08,6.12,6.25,6.49,6.70,6.85,6.95,6.98,7,7,7,6.99,7,7,7.07,7.25,7.59,8.32,7.70,7.37,7,6.73,6.47,6.25,6.12,6.12,6.12,6.12,6.12,6.12,6.12,6.12,6.12,6.11,6.08,6,6,6,6,6,5.98,5.75,5.36,5.12,5,5,5,4.99,4.75,4.20,3.84,3.12,2.87,1.95,0.99,0,-0.88,-1.54,-2.02,-2.38,-2.63,-2.75,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.78,-2.63,-2.38,-2.25,-1.90,-1.38,-0.76,-0.05,0.62,1.37,2.37,2.75,3.22,3.74,4.37,5.12,5.70,6.12,6.75,7.87,9.82,11.85,13.85,13.86,12.50,11.50,10.61,10.25,10.12,10,10,9.99,9.98,9.87,9.62,9.34,9.07,9,9,9.12,9.21,9.75,9.75,9.25,9.25,9.25,9.62,9.70,9.62,9.35,9.12,9.11,9.12,9.23,9.37,9.70,9.86,9.87,9.87,9.75,9.62,9.50,9.37,9.25,9.07,8.83,8.59,8.25,8.11,8,8,7.99,7.99,7.99,8,8.22,8.87,9.75,10.82,11.75,12.75,13.75,14.73,13.73,12.70,10.96,9.82,8.83,8.08,7.32,7.25,7.72,7.87,8.23,8.75,9.10,9.25,9.87,10.25,11,11.25,11.71,15.36,15.47,15.62,15.75,15.97,16.12,16.23,16.25,16.35,16.37,16.37,16.25,16.12,15.86,15.37,14.75,14,13.25,12.58,11.99,11.59,11.37,11.37,11.59,11.82,12,12.10,11.97,11.62,11.10,10.50,10,9.62,9.37,9.24,9.13,8.97,8.74,8.47,8.15,7.85,7.59,7.38,7.21,7.12,7.05,7.02,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.97,6.96,6.87,6.87,6.84,6.75,6.62,6.49,6.34,6.21,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6.12,6.12,6.12,6.12,6.12,6.12,6.12,6.09,6.08,6.12,6.20,6.32,6.48,6.62,6.87,7.10,7.25,7.34,7.37,7.37,7.36,7.35,7.34,7.35,7.37,7.50,7.75,7.87,7.87,7.59,7.25,7,6.73,6.50,6.37,6.37,6.37,6.37,6.37,6.37,6.37,6.37,6.37,6.37,6.25,6.12,6,6,6,6,5.98,5.62,5.34,5,5,5,5,4.99,4.75,4.20,3.84,3.10,2.10,1.95,0.62,-0.38,-1.38,-2.03,-2.43,-2.67,-2.88,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.50,-2.02,-1.63,-1.38,-0.91,-0.25,0.75,1.08,1.50,2.37,2.75,3.32,3.83,4.46,5.12,5.75,6.25,6.61,7.09,8.12,10.12,12.25,13.75,13.87,12.62,11.49,10.50,10.12,10,10,9.99,9.98,9.97,9.87,9.62,9.37,9.12,9.21,9.25,9.23,9.75,9.87,9.87,9.82,9.73,9.82,9.87,9.95,9.82,9.61,9.37,9.25,9.20,9.35,9.50,9.75,9.87,9.87,9.75,9.60,9.45,9.25,9.12,9,8.83,8.62,8.37,8.20,8.07,8,7.99,7.99,7.99,7.99,8,8.23,9,9.96,10.85,11.75,12.74,13.74,13.72,12.25,11.24,10.24,9.32,8.62,8.12,7.75,7.75,7.87,8.10,8.71,8.25,8.71,9.23,9.62,10.12,10.32,10.62,9.70,16.08,16.09,16.12,16.25,16.35,16.37,16.47,16.50,16.50,16.47,16.37,16.20,15.97,15.60,15.08,14.37,13.73,13,12.45,11.99,11.73,11.70,11.87,12.12,12.50,12.87,13.08,12.87,12.48,11.83,11.12,10.50,10,9.74,9.55,9.41,9.25,9.02,8.75,8.42,8.10,7.82,7.58,7.39,7.25,7.15,7.09,7.05,7.03,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.97,6.96,6.87,6.87,6.85,6.75,6.62,6.49,6.35,6.21,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6.07,6.09,6.11,6.12,6.22,6.34,6.22,6.12,6.12,6.22,6.33,6.50,6.72,6.87,7.12,7.37,7.61,7.75,7.75,7.75,7.75,7.73,7.70,7.62,7.62,7.74,7.85,7.87,7.87,7.75,7.50,7.25,7,6.83,6.70,6.62,6.62,6.62,6.75,6.75,6.82,6.83,6.82,6.84,6.62,6.45,6.12,6,6,6,5.98,5.62,5.33,5,5.12,5.23,5.25,5.22,4.87,4.75,3.85,2.75,1.98,1.11,0.23,-0.80,-1.63,-2.38,-2.75,-2.88,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.91,-2.88,-2.89,-2.68,-2.13,-1.50,-0.75,-0.38,0.12,0.75,1.37,2.50,2.49,2.86,3.32,3.75,4.37,5.22,6,6.73,7.12,7.37,7.87,8.87,10.62,12.47,13.62,13.58,12.50,11.47,10.62,10.22,10,10,9.99,9.98,9.96,9.86,9.62,9.45,9.25,9.45,9.62,9.97,10.12,10.25,10.33,10.33,10.32,10.25,10.24,10.12,10,9.82,9.62,9.47,9.37,9.49,9.62,9.82,9.87,9.82,9.62,9.45,9.24,9.09,8.97,8.75,8.61,8.37,8.22,8.09,8,7.99,7.99,7.99,7.99,7.99,8,8.24,8.75,9.75,10.75,11,11.73,11.74,11.25,10.85,10.09,9.34,8.83,8.35,8.12,7.99,7.95,7.98,8.11,8.12,8.24,8.32,9.11,9.62,9.99,10.12,10.10,9.62,16.62,16.62,16.70,16.73,16.74,16.73,16.70,16.62,16.60,16.49,16.33,15.99,15.62,15.22,14.62,14.09,13.47,12.87,12.37,12.09,11.97,12,12.33,12.75,13.23,13.62,13.87,13.72,13.12,12.37,11.62,10.99,10.49,10.16,9.96,9.80,9.63,9.41,9.13,8.80,8.46,8.13,7.86,7.64,7.49,7.36,7.24,7.20,7.15,7.11,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.97,6.96,6.95,6.87,6.86,6.75,6.62,6.50,6.35,6.22,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6.11,6.12,6.24,6.32,6.34,6.33,6.25,6.25,6.36,6.50,6.70,6.95,7.12,7.37,7.62,7.87,8.37,8.12,8.12,8.12,8.12,8,7.99,7.95,7.87,7.96,7.98,7.98,7.87,7.75,7.58,7.34,7.12,6.99,6.87,6.87,6.97,7.08,7.34,7.12,7.12,7.37,7.11,7.49,6.62,6.23,6,6,6,6,5.75,5.34,5.33,5.25,5.87,5.99,5.75,5,4.24,3.33,2.36,1.46,0.60,-0.28,-1.25,-2,-2.50,-2.91,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-1,-1,-1.13,-2.88,-2.52,-2.25,-1.63,-0.77,-0.01,0.60,1.10,1.59,2.12,2.71,3.12,3.37,3.75,4.24,5,6.12,7.12,8,8.57,8.87,9.37,10.37,11.87,13.12,13.75,13.25,12.36,11.37,10.62,10.24,10,10,9.99,9.98,9.97,9.87,9.75,9.62,9.58,9.83,10.12,10.50,10.75,10.86,10.87,10.95,10.95,10.85,10.62,10.37,10.12,9.99,9.83,9.70,9.62,9.62,9.75,9.83,9.82,9.72,9.50,9.25,9.09,8.87,8.75,8.60,8.37,8.22,8.10,8,8,7.99,7.99,7.99,7.99,7.99,8,8.12,8.23,9.11,9.75,10.12,10.25,10.25,10.09,9.33,9.25,8.82,8.35,8.12,8,8,7.98,7.99,8,8,8,8.34,9,9.62,9.98,10,10,9.62,17.20,17.21,17.20,17.12,17.07,16.97,16.86,16.73,16.59,16.37,16,15.62,15.25,14.75,14.25,13.75,13.25,12.75,12.45,12.25,12.24,12.37,12.75,13.22,13.73,14.12,14.37,14.20,13.62,12.86,12.10,11.38,10.92,10.59,10.42,10.27,10.12,9.90,9.62,9.27,8.90,8.54,8.24,8.01,7.84,7.72,7.62,7.49,7.45,7.30,7.13,7.07,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.97,6.96,6.95,6.87,6.87,6.75,6.62,6.50,6.36,6.22,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6.07,6.12,6.23,6.34,6.37,6.48,6.48,6.46,6.45,6.47,6.50,6.62,6.87,7.12,7.37,7.59,7.75,8.08,8.32,8.49,8.50,8.58,8.50,8.37,8.25,8.22,8.12,8.11,8.12,8.12,8.10,8,7.87,7.62,7.37,7.25,7.21,7.12,7.12,7.25,7.34,7.36,7.25,7.12,7.20,7,6.82,6.37,6.12,6,6.12,6.23,6.34,6.34,6.32,6.25,6.87,7.74,6.23,5.08,3.86,2.72,1.62,0.75,-0.13,-0.88,-1.63,-2.27,-2.80,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.38,-1.63,-0.79,-1.25,-1.52,-1.79,-1.63,-0.88,-0.13,0.75,1.34,1.87,2.37,2.86,3.25,3.62,3.87,4.12,4.74,5.75,7.12,8.50,9.60,10.25,10.84,11.50,12.37,13.25,13.87,13.75,13.10,12.12,11.25,10.60,10.22,10,10,9.99,9.99,9.98,9.95,9.87,9.87,9.98,10.22,10.50,10.87,11.49,11.37,11.58,11.62,11.60,11.50,11,10.70,10.37,10.12,9.99,9.87,9.84,9.83,9.83,9.75,9.71,9.57,9.37,9.12,8.96,8.75,8.59,8.37,8.23,8.10,8,8,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8.12,8.22,8.95,9.25,9.25,9.32,9.33,9.12,8.75,8.37,8.20,8.07,8,7.99,7.99,7.99,7.99,7.99,8,8.34,9,9.62,9.98,10,10.11,9.62,17.73,17.72,17.62,17.50,17.32,17.11,16.87,16.62,16.37,16.10,15.74,15.33,14.87,14.45,14,13.58,13.12,12.84,12.60,12.50,12.57,12.75,13.12,13.57,14,14.37,14.50,14.34,13.82,13.12,12.37,11.84,11.40,11.12,10.93,10.80,10.66,10.45,10.16,9.79,9.41,9.03,8.72,8.49,8.34,8.24,8.17,8.08,7.93,7.71,7.41,7.12,7.09,7.07,7.12,7.09,7.11,7.12,7.11,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.97,6.96,6.96,6.87,6.87,6.75,6.62,6.50,6.37,6.22,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6.08,6.12,6.25,6.37,6.62,6.74,6.75,6.71,6.62,6.62,6.62,6.75,6.86,7,7.25,7.50,7.74,7.95,8.12,8.37,8.71,8.87,8.96,8.87,8.75,8.62,8.50,8.37,8.35,8.35,8.37,8.37,8.36,8.24,8,7.83,7.62,7.57,7.47,7.37,7.32,7.25,7.25,7.12,7.11,7.07,7,6.87,6.62,6.37,6.35,6.37,6.62,7,7.62,7.62,7.75,7.86,7.75,6.75,4.97,3.37,2.09,0.96,0,-0.75,-1.41,-2.01,-2.65,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.80,-2.40,-1.75,-1.25,-0.93,-0.92,-0.78,-0.50,0,0.62,1.37,2,2.59,3.09,3.50,3.87,4.20,4.37,4.70,5.25,6.50,8.21,9.87,11.20,11.87,12.61,13.37,14.25,14.62,14.48,13.75,12.99,12.07,11.21,10.50,10.12,10,10,10,10,10,10.07,10.10,10.12,10.35,10.60,10.87,11.23,11.50,11.75,12,12.50,12,11.71,11.37,11,10.62,10.25,10.09,9.98,9.87,9.87,9.75,9.71,9.50,9.37,9.12,8.98,8.75,8.59,8.37,8.23,8.10,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8.12,8.25,8.82,9,9.09,9.07,8.96,8.62,8.36,8.09,8,7.99,7.99,7.99,7.99,7.99,7.99,8,8.35,8.99,9.62,9.98,10.12,10.21,10.62,18.24,18.12,18,17.75,17.45,17.12,16.75,16.48,16.12,15.75,15.37,14.98,14.57,14.12,13.75,13.48,13.21,13,12.87,12.85,12.95,13.12,13.45,13.75,14.12,14.45,14.50,14.25,13.86,13.25,12.67,12.22,11.86,11.62,11.47,11.36,11.22,11.01,10.72,10.35,9.95,9.57,9.26,9.04,8.95,8.91,8.89,8.82,8.60,8.24,7.82,7.51,7.35,7.32,7.12,7.87,7.87,7.86,7.87,7.12,7.20,7.12,7,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.97,6.97,6.96,6.87,6.87,6.83,6.70,6.50,6.37,6.22,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6.08,6.12,6.25,6.45,6.62,6.87,7.25,7,6.87,6.87,6.87,6.87,6.97,7,7.12,7.36,7.62,7.87,8.12,8.34,8.60,8.87,9.34,9.25,9.21,9.10,8.95,8.75,8.62,8.62,8.62,8.62,8.75,8.82,8.75,8.50,8.34,8.21,8.07,7.87,7.62,7.47,7.32,7.20,7.11,7,7,7.08,7.11,7.11,7.10,6.87,7,7.11,7.62,7.98,8.70,8.85,8.73,7.75,6.75,4.45,2.75,1.37,0.23,-0.75,-1.39,-1.92,-2.39,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.50,-2,-1.25,-0.75,-0.38,-0.01,0.25,0.75,1.37,2,2.62,3.25,3.75,4.25,4.62,4.95,5.12,5.45,6.08,7.37,9.12,11,12.37,13.10,13.97,14.62,15.12,14.96,14.49,13.73,12.87,11.98,11.12,10.50,10.12,10,10.08,10.11,10.12,10.12,10.25,10.36,10.50,10.72,10.87,11.12,11.37,11.62,11.87,12.24,12.50,12.12,11.84,11.50,11.47,10.75,10.37,10.12,9.99,9.87,9.82,9.71,9.50,9.37,9.12,8.98,8.75,8.60,8.37,8.24,8.11,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8.12,8.25,8.75,9,9.08,9,8.87,8.62,8.34,8.08,8,7.99,7.99,7.99,7.99,7.99,7.99,8,8.34,8.87,9.62,9.86,10.08,10.62,9.61,18.62,18.59,18.25,17.87,17.37,17,16.62,16.25,15.87,15.50,15.10,14.62,14.32,13.98,13.73,13.50,13.37,13.32,13.25,13.25,13.37,13.50,13.74,13.99,14.23,14.37,14.37,14.21,13.86,13.38,12.97,12.60,12.32,12.12,11.99,11.89,11.75,11.54,11.25,10.87,10.47,10.10,9.80,9.64,9.60,9.66,9.74,9.70,9.41,8.89,8.34,7.87,7.72,7.75,7.87,7.87,8,8.09,8,7.87,7.75,7.23,7.12,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.97,6.97,6.97,6.97,6.95,6.87,6.84,6.72,6.57,6.37,6.23,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6.11,6.24,6.37,6.58,6.75,7,7.25,7.12,7.10,7.08,7.11,7.12,7.20,7.25,7.25,7.50,7.84,8.12,8.37,8.61,8.84,9.12,9.34,9.48,9.47,9.37,9.22,9,8.87,8.75,8.84,8.87,9,9.25,9.25,9,8.95,8.87,8.75,8.49,8.12,7.75,7.50,7.25,7.12,7.09,7.09,7.12,7.37,7.62,7.75,7.62,7.32,7.62,7.33,7.73,8.71,9.73,9.75,7.75,5.21,3.50,1.87,0.62,-0.50,-1.28,-1.91,-2.38,-2.66,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.88,-2.75,-2.50,-2.26,-1.63,-1,-0.38,0.23,0.70,1,1.50,2,2.70,3.35,3.99,4.58,5.12,5.59,5.95,6.24,6.50,7.12,8.37,10,11.62,12.85,13.74,14.45,14.95,14.98,14.62,14.12,13.50,12.74,11.87,11.11,10.50,10.12,10.10,10.12,10.25,10.36,10.37,10.49,10.62,10.83,11,11.12,11.25,11.37,11.61,11.87,12.23,12.35,12.12,11.75,11.48,11.10,10.62,10.33,10.10,9.96,9.84,9.71,9.50,9.37,9.12,8.98,8.75,8.60,8.37,8.24,8.12,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8.12,8.25,8.75,9.08,9.25,9.23,9.08,8.83,8.62,8.25,8.07,8,7.99,7.99,7.99,7.99,7.99,7.99,8,8.33,8.75,9.25,9.62,9.85,9.75,9.58,18.84,18.75,18.37,17.85,17.35,16.87,16.47,16.08,15.62,15.25,14.87,14.47,14.11,13.97,13.83,13.75,13.74,13.74,13.75,13.75,13.83,13.87,14,14.12,14.25,14.34,14.32,14.12,13.90,13.60,13.29,13.01,12.82,12.64,12.51,12.38,12.23,12,11.71,11.35,10.97,10.64,10.39,10.26,10.26,10.40,10.61,10.76,10.34,9.60,8.80,8.30,8.21,8.12,8.12,8.12,8.12,8.12,8.84,8.12,8.07,7.75,7.25,7,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.98,6.97,6.97,6.97,6.96,6.87,6.86,6.75,6.60,6.37,6.25,6.12,6.08,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6.12,6.25,6.37,6.60,6.75,6.99,7.12,7.12,7.20,7.25,7.33,7.37,7.37,7.48,7.50,7.75,8.08,8.37,8.74,8.98,9.12,9.35,9.50,9.61,9.62,9.59,9.37,9.12,8.96,8.84,8.86,8.97,9.12,9.32,9.37,9.37,9.50,9.62,9.60,9.25,8.75,8.23,7.83,7.50,7.36,7.24,7.12,7.25,7.58,8.09,8.62,7.86,7.25,6.82,6.70,6.72,7,7.12,6.74,5.58,4,2.37,0.99,-0.15,-1.13,-1.77,-2.29,-2.63,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.92,-2.88,-2.65,-2.38,-2,-1.63,-1.05,-0.42,0.24,0.84,1.25,1.70,2.12,2.73,3.37,4.12,4.86,5.50,6.23,6.82,7.25,7.60,7.87,8.46,9.50,10.82,12.08,13.12,13.98,14.62,14.75,14.61,14.24,13.73,13.12,12.50,11.75,11,10.48,10.12,10.12,10.25,10.46,10.59,10.62,10.72,10.85,11,11.12,11.22,11.24,11.25,11.45,11.71,12.33,12.47,11.87,11.57,11.20,10.82,10.46,10.22,10,9.86,9.71,9.50,9.36,9.12,8.98,8.75,8.60,8.37,8.25,8.12,8,8,7.99,7.99,7.99,7.99,7.99,8,8,8,8,8,8,8.12,8.25,8.75,9.08,9.72,9.62,9.62,8.97,8.62,8.37,8.12,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8.24,8.62,8.99,9.25,9.59,9.36,8.50,18.82,18.62,18.25,17.73,17.24,16.75,16.37,15.98,15.59,15.12,14.75,14.37,14.12,14.12,14.09,14.12,14.12,14.23,14.25,14.25,14.25,14.25,14.25,14.33,14.34,14.35,14.32,14.22,14.07,13.87,13.67,13.49,13.32,13.17,13.04,12.90,12.72,12.49,12.17,11.84,11.49,11.17,10.93,10.84,10.87,11.04,11.34,11.66,11.58,10.13,9.22,8.51,8.75,8.85,8.85,8.12,8.20,8.82,8.87,8.85,8.75,7.87,7.25,7.08,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.98,6.98,6.98,6.98,6.98,6.98,6.97,6.95,6.87,6.75,6.62,6.50,6.36,6.23,6.12,6.08,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6.10,6.21,6.36,6.50,6.70,6.87,7,7.12,7.25,7.37,7.50,7.62,7.72,7.75,7.75,8,8.33,8.72,9.08,9.34,9.49,9.59,9.62,9.70,9.70,9.62,9.37,9.12,8.87,8.72,8.71,8.87,9.11,9.33,9.48,9.61,9.87,10.33,10.34,10.36,9.25,8.60,8.12,7.87,7.73,7.50,7.37,7.33,7.60,7.98,8.62,7.62,6.62,5.87,5.49,5.25,5.12,4.96,4.50,3.71,2.62,1.37,0.20,-0.88,-1.63,-2.18,-2.63,-2.80,-2.92,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.75,-2.75,-2.63,-2.27,-1.88,-1.38,-0.89,-0.38,0.25,0.87,1.37,1.87,2.25,2.74,3.35,4.11,5,5.87,6.83,7.62,8.25,8.75,9.08,9.35,9.75,10.50,11.46,12.37,13.25,13.96,14.35,14.37,14.12,13.73,13.24,12.72,12.12,11.50,10.95,10.46,10.12,10.12,10.33,10.50,10.71,10.75,10.75,10.87,11,11.10,11.08,11,11,11.12,11.33,11.50,11.62,11.50,11.22,10.87,10.57,10.25,10.09,9.87,9.73,9.50,9.36,9.12,8.98,8.75,8.60,8.37,8.25,8.12,8,8,7.99,7.99,7.99,7.99,7.99,8,8,8.08,8.09,8.09,8.09,8.12,8.25,8.75,8.95,9.72,9.25,9.25,9,8.75,8.37,8.12,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8.12,8.37,8.62,8.97,9,8.87,8.50,18.62,18.37,17.99,17.50,17.12,16.75,16.37,16,15.62,15.24,14.87,14.62,14.37,14.33,14.37,14.50,14.62,14.75,14.82,14.83,14.75,14.62,14.60,14.50,14.46,14.37,14.41,14.38,14.33,14.23,14.13,14.01,13.89,13.76,13.62,13.46,13.25,13,12.70,12.36,12.02,11.72,11.50,11.40,11.40,11.51,11.73,12.13,11.33,10.39,9.55,9.07,8.87,8.99,8.87,8.87,8.99,9.12,9.12,9.75,8.75,8,7.32,7.10,7,7,7,7,7,7,7,7,7,7,7,6.99,6.99,6.99,6.99,6.99,6.99,6.99,6.99,6.99,6.99,6.97,6.87,6.82,6.62,6.50,6.37,6.25,6.12,6.10,6,6,6,6.07,6.07,6,6,6,6,6,6,6,6,6,6,6,6.12,6.24,6.37,6.57,6.75,6.98,7.20,7.37,7.62,7.84,7.98,8.07,8.09,8.11,8.25,8.58,8.97,9.34,9.60,9.73,9.75,9.72,9.62,9.57,9.50,9.34,9,8.62,8.37,8.37,8.60,8.99,9.37,9.50,9.58,9.73,10.36,10.36,10.37,9.37,8.62,8.25,8.24,8.25,8.10,7.59,7.12,7,7.62,6.75,6.12,5.25,4.50,4,3.62,3.37,3.09,2.62,2.09,1.32,0.37,-0.63,-1.50,-2.13,-2.63,-2.79,-2.91,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.27,-2.26,-2.25,-2.05,-1.64,-1.18,-0.64,-0.13,0.47,1,1.50,2,2.37,2.75,3.25,3.97,4.86,5.99,7.12,8.25,9.23,9.87,10.25,10.37,10.50,10.87,11.37,12,12.70,13.34,13.82,14,13.98,13.62,13.23,12.75,12.25,11.75,11.32,10.85,10.45,10.22,10.12,10.25,10.48,10.61,10.62,10.70,10.75,10.84,10.86,10.82,10.75,10.71,10.74,10.84,10.95,10.99,10.99,10.83,10.62,10.37,10.12,9.96,9.75,9.50,9.36,9.12,8.98,8.75,8.60,8.37,8.25,8.12,8,8,7.99,7.99,7.99,7.99,7.99,8,8,8.12,8.25,8.35,8.25,8.21,8.22,8.73,8.75,9,9,8.98,8.75,8.62,8.34,8.12,8.07,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8.12,8.37,8.62,8.73,8.50,7.50,18.36,18,17.62,17.37,17.12,16.87,16.61,16.25,15.87,15.50,15.20,14.87,14.73,14.62,14.83,14.98,15.12,15.25,15.34,15.32,15.22,15.07,14.87,14.73,14.62,14.59,14.62,14.66,14.68,14.68,14.65,14.59,14.49,14.38,14.23,14.05,13.84,13.57,13.26,12.93,12.61,12.33,12.11,11.98,11.93,11.92,11.90,11.70,11.14,10.39,9.73,9.32,9.12,9.12,9.12,9.20,9.82,9.75,9.82,9.22,8.75,8.12,7.34,7.22,7.10,7.07,7.09,7.12,7.12,7.12,7.12,7.12,7.08,7,7,7,7,7,7,7,7,7,7,7,7.08,7.10,7.10,7,6.95,6.75,6.62,6.48,6.33,6.21,6.12,6.11,6.12,6.12,6.12,6.12,6.12,6.09,6.08,6.08,6.08,6.08,6,6,6,6,6.07,6.12,6.25,6.46,6.71,6.98,7.25,7.59,7.87,8.21,8.37,8.50,8.50,8.50,8.62,8.87,9.22,9.50,9.74,9.83,9.75,9.62,9.45,9.24,9.10,9.36,8.50,8.12,7.96,7.87,8.10,8.59,9.37,9.37,9.37,8.83,8.95,9.37,8.85,8.46,8.37,7.87,8.12,9.49,9.25,7.50,6.50,6,5.70,5.22,4.48,3.72,3,2.48,2.09,1.75,1.45,1.08,0.62,0.11,-0.55,-1.38,-2.03,-2.63,-2.88,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.89,-1,-1.50,-1.41,-1.50,-1.25,-0.88,-0.38,0.22,0.75,1.33,1.84,2.25,2.57,2.87,3.25,3.87,4.62,5.74,7,8.37,9.75,10.75,11.25,11.25,11.24,11.34,11.61,12,12.48,12.98,13.37,13.71,13.75,13.58,13.22,12.75,12.25,11.85,11.47,11.12,10.75,10.50,10.25,10.21,10.23,10.32,10.37,10.45,10.48,10.50,10.58,10.59,10.50,10.48,10.37,10.37,10.37,10.46,10.47,10.37,10.37,10.34,10.37,10,9.75,9.59,9.37,9.12,8.98,8.75,8.60,8.37,8.25,8.12,8.07,8,7.99,7.99,7.99,7.99,7.99,7.99,8,8.09,8.25,8.59,8.71,8.62,8.25,8.22,8.25,8.75,8.74,8.73,8.71,8.25,8.25,8.12,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8.12,8.36,8.50,8.23,7.48,17.86,17.48,17.25,17.25,17.21,17.10,16.87,16.61,16.25,15.87,15.58,15.25,15.11,15.09,15.24,15.37,15.61,15.75,15.82,15.75,15.62,15.37,15.12,14.98,14.86,14.84,14.92,15.02,15.14,15.21,15.23,15.21,15.15,15.04,14.89,14.71,14.47,14.20,13.89,13.58,13.28,13.02,12.80,12.64,12.53,12.39,12.15,11.76,11.13,10.26,9.85,9.67,9.50,9.33,9.22,9.83,10.09,10.21,10.75,9.22,8.75,8.25,7.86,7.37,7.25,7.20,7.25,7.37,7.37,7.37,7.37,7.25,7.20,7.12,7.12,7.11,7.12,7.12,7.12,7.12,7.11,7.12,7.12,7.12,7.23,7.25,7.37,7.37,7.25,7.12,6.95,6.74,6.50,6.36,6.25,6.21,6.25,6.33,6.37,6.37,6.33,6.25,6.22,6.23,6.23,6.22,6.12,6.12,6.07,6,6,6,6.12,6.36,6.62,6.98,7.37,7.75,8.25,8.70,9,9.12,9.20,9.11,9.12,9.25,9.49,9.70,9.82,9.75,9.62,9.37,9,8.70,8.37,8.12,7.83,7.49,7.25,7.23,7.34,7.62,8.37,7.85,7.50,7.33,7.32,7.37,7.24,7,6.87,6.87,7.37,8.10,8.86,6.50,5.37,4.71,4.12,3.59,2.95,2.25,1.59,1,0.62,0.36,0,-0.30,-0.63,-1,-1.50,-2.05,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.90,-2.88,-2.67,-2.43,-2.04,-1.26,-0.89,-0.02,-0.43,-0.50,-0.30,0.10,0.62,1.20,1.71,2.25,2.72,3.07,3.24,3.37,3.83,4.60,5.50,6.73,8.08,9.50,10.87,11.62,11.75,11.50,11.50,11.73,12.07,12.48,12.87,13.25,13.50,13.62,13.50,13.21,12.75,12.33,11.87,11.50,11.24,11,10.83,10.61,10.37,10.25,10.21,10.12,10.20,10.23,10.25,10.33,10.36,10.36,10.33,10.25,10.20,10.12,10.10,10.07,10,9.87,9.95,10,9.98,9.86,9.62,9.37,9.20,8.99,8.75,8.60,8.37,8.25,8.12,8.07,8,7.99,7.99,7.99,7.99,7.99,8,8,8,8.12,8.37,8.83,9.62,8.75,8.33,8.11,8.12,8.23,8.25,8.25,8.25,8.12,8.08,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8.12,8.12,8,7.46,17,16.75,16.87,17.12,17.32,17.37,17.21,16.96,16.62,16.33,15.99,15.72,15.50,15.50,15.62,15.87,16.07,16.21,16.25,16.20,16,15.75,15.48,15.25,15.12,15.12,15.30,15.49,15.65,15.78,15.86,15.88,15.85,15.75,15.61,15.40,15.16,14.88,14.59,14.29,14.02,13.78,13.59,13.41,13.23,12.99,12.63,12.12,11.45,10.71,10.21,10.05,9.98,9.96,10.10,10.24,10.75,10.84,10.20,9.23,8.87,8.62,8.25,7.87,7.49,7.50,7.50,7.72,7.82,7.82,7.70,7.50,7.37,7.32,7.25,7.25,7.33,7.35,7.35,7.34,7.35,7.35,7.36,7.37,7.46,7.60,7.72,7.74,7.62,7.46,7.24,7,6.75,6.50,6.37,6.33,6.37,6.50,6.62,6.62,6.59,6.49,6.47,6.49,6.50,6.48,6.37,6.25,6.12,6,5.98,5.96,6,6.22,6.50,6.87,7.37,7.96,8.59,9.32,9.86,10,9.87,9.74,9.62,9.70,9.82,9.87,9.87,9.71,9.35,8.87,8.37,7.87,7.50,7.12,6.82,6.57,6.37,6.45,6.25,6.25,6.24,6.07,5.75,5.57,5.50,5.50,5.49,5.37,5.33,5.37,5.57,5.75,5.48,4.83,3.87,3.25,2.71,2.12,1.59,0.98,0.35,-0.16,-0.54,-0.88,-1.13,-1.50,-1.63,-1.88,-2.25,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.92,-2.88,-2.67,-2.50,-2.25,-1.80,-1.18,-0.43,0.83,0.60,0.62,0.62,0.87,1.25,1.74,2.25,2.83,3.37,3.75,3.99,4,4.12,4.50,5.48,6.50,7.62,8.99,10.25,11.25,11.62,11.57,11.48,11.50,11.87,12.33,12.75,13.12,13.37,13.50,13.47,13.22,12.83,12.37,11.87,11.57,11.25,11.11,10.99,10.87,10.74,10.58,10.37,10.24,10.12,10.10,10.11,10.12,10.12,10.12,10.12,10.12,10.11,10,9.97,9.87,9.75,9.62,9.50,9.50,9.62,9.62,9.60,9.37,9.22,9,8.83,8.62,8.37,8.25,8.12,8.07,8,8,7.99,7.99,7.99,8,8,8.07,8.10,8.12,8.12,8.33,8.75,9.62,8.75,8.33,8.09,8,8,8,8.07,8,8,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8,7.87,7.45,16.12,16.23,16.70,17.12,17.49,17.59,17.47,17.25,17,16.74,16.45,16.20,16,16,16.12,16.35,16.50,16.62,16.62,16.57,16.35,16.08,15.75,15.58,15.49,15.50,15.75,15.99,16.22,16.40,16.53,16.59,16.58,16.49,16.34,16.14,15.89,15.61,15.33,15.07,14.83,14.61,14.42,14.24,14.02,13.73,13.32,12.77,12.05,11.24,10.93,10.65,10.58,10.61,10.75,11.12,11.75,11.82,10.75,9.23,9,8.87,8.70,8.37,8.08,7.87,7.99,8.12,8.32,8.25,8.07,7.85,7.62,7.58,7.59,7.62,7.71,7.75,7.75,7.75,7.75,7.73,7.72,7.74,7.75,7.87,8.09,8.10,7.87,7.71,7.50,7.25,6.99,6.72,6.50,6.37,6.50,6.75,7.24,7,6.85,6.75,6.75,6.87,6.87,6.87,6.72,6.49,6.25,6.07,5.87,5.84,5.85,6,6.25,6.72,7.25,7.87,8.75,9.75,11.25,11.25,10.59,10.25,10.08,10.07,10.12,10.12,10,9.57,8.87,8.12,7.50,6.87,6.37,6,5.62,5.37,5.24,5.07,4.87,4.71,4.50,4.25,4.09,3.87,3.83,3.82,3.82,3.75,3.71,3.62,3.62,3.50,3.25,2.75,2.25,1.84,1.37,0.98,0.45,-0.13,-0.68,-1.15,-1.50,-1.75,-2,-2.28,-2.38,-2.50,-2.68,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.80,-2.55,-2.25,-1.88,-1.50,-1,-0.26,0.62,1.20,1.85,1.87,2.12,2.25,2.50,2.87,3.37,4,4.62,4.95,4.95,5,5.12,5.75,6.62,7.50,8.50,9.60,10.49,11,11.12,11.12,11.22,11.46,11.87,12.37,12.87,13.22,13.34,13.32,13.12,12.83,12.37,11.99,11.62,11.34,11.12,11,10.98,10.87,10.84,10.71,10.50,10.34,10.12,10.10,10.07,10.07,10.08,10.08,10.08,10,10,9.95,9.85,9.72,9.58,9.37,9.24,9.25,9.37,9.37,9.36,9.22,9,8.87,8.62,8.47,8.25,8.12,8.07,8,8,7.99,7.99,7.99,8,8,8.10,8.21,8.25,8.25,8.24,8.25,8.37,8.62,8.62,8.25,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.97,7.86,7.37,15.50,15.96,16.60,17.12,17.50,17.61,17.62,17.50,17.37,17.12,16.87,16.70,16.50,16.50,16.62,16.82,16.98,17.09,17,16.87,16.62,16.37,16.12,15.87,15.87,15.97,16.23,16.53,16.80,17.04,17.22,17.32,17.32,17.24,17.09,16.88,16.61,16.34,16.08,15.83,15.61,15.41,15.25,15.08,14.86,14.55,14.13,13.59,12.91,12.12,11.67,11.47,11.25,11.32,11.46,11.71,12.61,11.21,10.20,9.25,9.12,9.12,9.50,8.75,8.50,8.37,8.48,8.62,8.73,8.62,8.49,8.24,8,7.87,8,8.12,8.25,8.33,8.35,8.34,8.25,8.24,8.12,8.12,8.12,8.12,8.21,8.21,8.08,7.87,7.62,7.45,7.12,6.85,6.59,6.48,6.50,6.86,7.25,7.22,7,6.95,7.11,7.33,7.50,7.36,7.11,6.71,6.36,6.08,5.84,5.62,5.62,5.72,5.95,6.34,6.87,7.61,8.50,10.25,11.25,11.32,10.75,10.50,10.25,10.12,10.33,10.32,10.32,9.33,8.22,7.25,6.37,5.75,5.21,4.75,4.37,4.09,3.85,3.62,3.37,3.21,2.97,2.74,2.50,2.37,2.25,2.25,2.25,2.24,2.12,1.97,1.83,1.62,1.37,1.10,0.75,0.61,0.36,0,-0.50,-1,-1.50,-1.90,-2.17,-2.38,-2.51,-2.75,-2.77,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.63,-2.16,-1.63,-1.13,-0.54,0.07,0.82,1.62,2.74,3.12,3.62,3.62,3.74,3.86,4.10,4.50,5.24,5.85,5.87,5.75,5.87,6.36,7.11,7.72,8.47,9.23,9.87,10.35,10.50,10.62,10.73,10.87,11.32,11.83,12.34,12.72,12.87,12.87,12.86,12.62,12.36,11.99,11.62,11.36,11.12,11.07,11,10.98,10.95,10.87,10.75,10.62,10.46,10.25,10.12,10.10,10.08,10,10,10,10,9.96,9.87,9.75,9.62,9.46,9.25,9.12,9.12,9.12,9.21,9.12,9.07,8.87,8.75,8.50,8.35,8.12,8.08,8,8,7.99,7.99,7.99,7.99,8,8.09,8.21,8.34,8.37,8.37,8.34,8.25,8.32,8.35,8.25,8.12,8,8,7.99,7.99,7.99,7.99,8,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.98,7.95,7.85,7.37,15.61,16.11,16.60,17,17.37,17.61,17.72,17.73,17.62,17.50,17.37,17.23,17.12,17.10,17.12,17.33,17.45,17.50,17.46,17.25,17,16.72,16.47,16.32,16.25,16.37,16.74,17.08,17.40,17.70,17.91,18.04,18.05,17.98,17.83,17.57,17.32,17.05,16.79,16.55,16.36,16.18,16.04,15.89,15.71,15.42,15.02,14.53,13.95,13.17,12.84,12.62,12.47,12.23,12.12,12.11,11.75,11.12,10.11,9.25,9.21,9.25,9.25,9.12,9,8.98,9.07,9.21,9.25,9.24,9,8.71,8.49,8.45,8.57,8.82,8.98,9,9,9,8.99,8.86,8.62,8.50,8.46,8.37,8.37,8.25,8.12,7.98,7.75,7.50,7.23,6.87,6.62,6.48,6.50,6.75,7.23,7.22,6.95,6.87,7.12,8.12,7.75,8.12,7.35,6.75,6.37,6,5.72,5.50,5.37,5.37,5.58,5.75,6.35,7,7.87,8.87,10.32,10.11,10.36,10.37,10.35,9.70,9.62,10.35,9.34,8.34,7.36,6,5.12,4.37,3.87,3.37,3,2.70,2.45,2.23,2,1.75,1.50,1.32,1.11,0.97,0.87,0.86,0.85,0.75,0.62,0.48,0.10,0.09,-0.13,-0.27,-0.39,-0.43,-0.55,-0.88,-1.27,-1.75,-2.13,-2.42,-2.63,-2.75,-2.80,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.41,-1.79,-1.13,-0.38,0.37,1.12,1.96,2.87,3.87,4.75,5.23,5.36,5.35,5.37,5.49,5.75,6.34,6.62,6.60,6.23,6.37,7,8,8.58,9.25,9.74,10,10.10,10.12,10.12,10.33,10.62,11.11,11.57,11.87,12.12,12.25,12.33,12.25,12.12,11.87,11.62,11.37,11.20,11.08,11,10.99,10.98,10.96,10.87,10.86,10.74,10.58,10.37,10.25,10.20,10.12,10.09,10,10,9.98,9.87,9.87,9.75,9.59,9.37,9.23,9,9,9,9.07,9,8.97,8.84,8.62,8.37,8.25,8.12,8,8,7.99,7.99,7.99,7.99,8,8,8.12,8.25,8.37,8.50,8.46,8.35,8.32,8.25,8.25,8.12,8.11,8,8,8,8,8,8,8,8,8,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.98,7.95,7.84,7.37,16.22,16.37,16.72,17.09,17.37,17.60,17.75,17.87,17.87,17.87,17.86,17.75,17.73,17.73,17.75,17.87,17.87,17.87,17.82,17.61,17.33,17,16.75,16.70,16.73,16.87,17.25,17.62,17.98,18.33,18.59,18.73,18.76,18.67,18.48,18.23,17.98,17.72,17.47,17.24,17.04,16.88,16.76,16.63,16.47,16.24,15.90,15.50,15.07,14.71,14.41,14.13,13.75,13.36,12.95,12.49,11.87,11.12,10.33,9.32,9.37,9.47,9.50,9.58,9.62,9.62,9.75,9.98,10.10,9.98,9.62,9.25,8.99,8.87,9.11,9.37,9.87,9.62,9.62,9.62,9.96,9.37,9.09,8.87,8.75,8.62,8.58,8.37,8.24,8,7.75,7.50,7.21,6.87,6.61,6.37,6.37,6.50,6.70,6.75,6.72,6.72,6.96,7.24,7.59,8.12,7.20,6.62,6.22,5.86,5.57,5.34,5.21,5.12,5.24,5.37,5.71,6.35,7,7.70,8.32,8.73,8.95,9.37,8.84,8.57,8.37,8.33,7.45,6.48,5.47,4.50,3.62,3,2.49,2,1.62,1.34,1.07,0.85,0.62,0.49,0.25,0,-0.17,-0.38,-0.42,-0.50,-0.50,-0.51,-0.63,-0.77,-1,-1.16,-1.28,-1.38,-1.38,-1.38,-1.40,-1.64,-2,-2.38,-2.63,-2.75,-2.88,-2.90,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.76,-2.28,-1.52,-0.67,0.21,1.09,2,3,4.11,5.36,6.59,7.22,7.25,7.12,7,7.10,7.23,7.25,7.09,6.62,6.32,6.57,7.25,8.34,8.99,9.62,9.95,9.96,9.75,9.62,9.71,9.95,10.35,10.75,11.12,11.37,11.50,11.62,11.62,11.70,11.62,11.50,11.35,11.20,11.09,11,11,10.98,10.97,10.96,10.87,10.87,10.82,10.70,10.57,10.45,10.34,10.24,10.12,10.09,10,9.98,9.87,9.86,9.74,9.57,9.37,9.21,9,9,9,8.99,8.95,8.86,8.72,8.50,8.33,8.12,8.08,8,7.99,7.99,7.99,7.99,7.99,8,8,8.12,8.25,8.37,8.46,8.37,8.32,8.25,8.25,8.25,8.12,8.12,8.20,8.24,8.12,8.12,8.12,8.22,8.24,8.25,8.25,8.12,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.98,7.95,7.84,7.37,16.99,16.97,17,17.23,17.37,17.62,17.84,18,18.12,18.25,18.34,18.36,18.36,18.37,18.37,18.48,18.46,18.37,18.12,17.87,17.60,17.32,17.11,17.08,17.12,17.37,17.76,18.15,18.54,18.90,19.20,19.36,19.40,19.29,19.07,18.84,18.59,18.33,18.07,17.84,17.64,17.48,17.36,17.25,17.11,16.92,16.67,16.40,16.17,16.03,15.96,15.78,15.12,14.49,13.82,13.12,12.37,11.50,10.50,10.24,10,10.10,10.25,10.37,10.50,10.62,10.84,10.99,11,11,10.33,9.75,9.46,9.36,9.50,9.87,9.96,10,10,10,9.87,9.71,9.37,9.21,9,8.87,8.75,8.58,8.33,8,7.75,7.47,7.12,6.84,6.57,6.37,6.32,6.34,6.37,6.37,6.37,6.45,6.57,6.75,6.98,6.96,6.62,6.25,5.87,5.62,5.37,5.12,5,4.97,4.98,5.08,5.32,5.62,6.12,6.59,6.87,7.25,7.46,7.37,7.24,6.95,6.62,6.12,5.37,4.50,3.61,2.84,2.12,1.62,1.12,0.74,0.37,0.07,-0.25,-0.42,-0.63,-0.68,-0.88,-1.13,-1.28,-1.50,-1.63,-1.63,-1.63,-1.63,-1.64,-1.75,-1.89,-2.17,-2.14,-2.18,-2.16,-2.15,-2.25,-2.38,-2.67,-2.76,-2.90,-2.92,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.67,-2.13,-1.38,-0.38,0.62,1.61,2.72,3.87,5.20,6.75,8.50,9.37,9.24,9.08,8.85,8.72,8.37,8,7.25,6.62,6.25,6.50,7.12,8.12,8.87,9.50,9.73,9.62,9.36,9.23,9.25,9.58,9.98,10.37,10.62,10.84,10.95,11,11.12,11.25,11.25,11.25,11.12,11.09,11,11,10.99,10.98,10.97,10.97,10.95,10.87,10.87,10.75,10.71,10.61,10.49,10.37,10.24,10.12,10,9.99,9.87,9.86,9.73,9.57,9.37,9.20,9,8.99,8.97,8.87,8.86,8.74,8.50,8.37,8.22,8.11,8,8,7.99,7.99,7.99,7.99,7.99,8,8,8.12,8.25,8.37,8.37,8.37,8.25,8.33,8.33,8.35,8.33,8.37,8.46,8.61,8.74,8.85,8.83,8.75,8.75,8.75,8.75,8.25,8.12,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.98,7.95,7.84,7.37,17.75,17.50,17.37,17.37,17.50,17.71,17.87,18.20,18.46,18.62,18.84,18.95,19,19,19.07,19,18.97,18.75,18.50,18.12,17.84,17.58,17.37,17.37,17.50,17.85,18.25,18.67,19.08,19.45,19.75,19.91,19.97,19.82,19.61,19.38,19.12,18.85,18.59,18.35,18.14,17.97,17.84,17.73,17.61,17.47,17.29,17.14,17.07,17.14,17.38,17.36,16.43,15.59,14.71,13.85,13,12.12,11.49,10.97,10.47,11,11.33,11.50,11.70,11.87,12.11,12.12,12,11.58,10.95,10.32,9.87,9.70,9.75,9.87,10.07,10.12,10.12,10.12,10,9.85,9.62,9.37,9.25,9.12,8.95,8.70,8.37,8,7.72,7.37,7.08,6.75,6.50,6.35,6.24,6.21,6.23,6.25,6.25,6.25,6.35,6.37,6.47,6.37,6.12,5.83,5.61,5.37,5.23,5,4.87,4.75,4.75,4.75,4.87,5.10,5.37,5.61,5.85,6,6.08,5.87,5.58,5.35,4.96,4.37,3.58,2.61,1.87,1.25,0.75,0.25,-0.13,-0.43,-0.75,-1.02,-1.38,-1.50,-1.63,-1.75,-1.79,-2,-2.17,-2.28,-2.50,-2.63,-2.50,-2.43,-2.41,-2.42,-2.52,-2.63,-2.68,-2.68,-2.75,-2.76,-2.89,-2.89,-2.90,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.53,-1.89,-1,0,0.99,1.87,3.11,4.50,6.25,7.87,9.46,9.83,10.12,10.12,9.87,9.62,9,8.23,7.21,6.47,6.23,6.50,7,7.83,8.37,8.87,9.07,8.98,8.87,8.75,8.87,9.24,9.62,10.07,10.34,10.50,10.61,10.73,10.87,10.99,11.07,11.09,11.07,11,11,10.99,10.98,10.98,10.97,10.97,10.96,10.95,10.87,10.87,10.82,10.73,10.61,10.47,10.32,10.12,10.07,10,9.87,9.85,9.73,9.50,9.37,9.12,9,8.98,8.87,8.86,8.74,8.50,8.37,8.24,8.12,8,8,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8.12,8.25,8.37,8.37,8.46,8.45,8.37,8.37,8.50,8.57,8.62,8.73,8.83,8.87,8.87,8.87,8.87,8.87,8.87,8.83,8.75,8.25,8.12,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.98,7.95,7.83,7.37,18.62,17.95,17.72,17.62,17.70,17.85,18.09,18.37,18.75,19.09,19.34,19.50,19.60,19.62,19.61,19.50,19.37,19.09,18.73,18.32,18,17.75,17.62,17.73,17.87,18.25,18.73,19.16,19.59,19.95,20.24,20.39,20.40,20.25,20.08,19.84,19.58,19.29,19.02,18.76,18.53,18.35,18.20,18.07,17.95,17.84,17.74,17.67,17.68,17.79,17.99,17.84,17.26,16.46,15.50,14.57,13.62,12.87,12.25,11.73,11.59,12.37,12.86,12.75,13.12,13.37,13.59,13.46,12.98,12.23,11.37,10.74,10.24,9.97,9.87,9.97,10.09,10.12,10.22,10.12,10.09,9.87,9.75,9.60,9.37,9.24,9,8.83,8.37,8,7.62,7.34,7,6.75,6.50,6.34,6.24,6.20,6.21,6.24,6.25,6.32,6.35,6.35,6.32,6.12,5.75,5.62,5.45,5.25,5.12,5,4.85,4.70,4.59,4.50,4.58,4.62,4.58,4.87,4.98,5,4.96,4.72,4.37,4,3.50,2.99,2.12,1.12,0.34,-0.13,-0.50,-0.88,-1.15,-1.50,-1.66,-1.88,-2.13,-2.38,-2.52,-2.42,-2.50,-2.53,-2.63,-2.75,-2.80,-2.88,-2.88,-2.78,-2.77,-2.79,-2.88,-2.88,-2.91,-2.92,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.80,-2.38,-1.50,-0.50,0.49,1.25,2.12,3,5.10,7.12,9.50,9.32,9.62,9.87,10.10,9.98,9.71,8.97,8.12,7.11,6.45,6.21,6.37,6.71,7.20,7.73,8.11,8.33,8.37,8.37,8.47,8.62,9,9.50,9.87,10.21,10.37,10.50,10.62,10.75,10.87,10.96,11,11,11,10.99,10.98,10.98,10.98,10.97,10.97,10.96,10.96,10.95,10.87,10.87,10.75,10.62,10.50,10.35,10.20,10.08,10,9.87,9.84,9.71,9.50,9.36,9.12,9,8.95,8.87,8.74,8.57,8.37,8.25,8.12,8.07,8,8,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8.12,8.24,8.37,8.50,8.58,8.61,8.62,8.62,8.70,8.75,8.87,8.87,8.95,8.97,8.98,8.98,8.97,8.98,8.97,8.87,8.83,8.75,8.23,8.12,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.98,7.95,7.83,7.37,18.37,18.12,17.96,17.87,17.87,18,18.33,18.71,19.12,19.50,19.83,20,20.10,20.09,19.99,19.83,19.58,19.22,18.75,18.37,18.09,17.87,17.87,18,18.25,18.71,19.20,19.65,20.07,20.41,20.67,20.82,20.77,20.64,20.46,20.23,19.96,19.67,19.37,19.11,18.88,18.68,18.52,18.38,18.27,18.20,18.14,18.13,18.20,18.30,18.38,18.29,17.98,17.27,16.33,15.25,14.24,13.37,12.87,12.75,12.75,14.25,15.24,14.84,14.71,15,14.97,14.87,13.87,12.60,11.73,11,10.50,10.12,10.07,10.08,10.12,10.22,10.24,10.21,10.12,10,9.87,9.73,9.50,9.25,9,8.71,8.35,7.98,7.62,7.32,7,6.75,6.50,6.37,6.33,6.32,6.33,6.37,6.48,6.50,6.57,6.50,6.46,6.25,6,5.72,5.49,5.32,5.20,5.09,4.87,4.72,4.50,4.37,4.35,4.34,4.35,4.37,4.33,4.23,4.07,3.87,3.50,3.12,2.71,2,1.20,0.25,-0.63,-1.14,-1.43,-1.75,-2,-2.25,-2.38,-2.50,-2.63,-2.75,-2.88,-2.88,-2.88,-2.88,-2.89,-2.92,-3,-3,-3,-3,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.63,-2,-1,0,0.87,1.75,2.12,3,5.85,8.62,8.62,9.21,9.34,9.46,9.45,9.34,9.10,8.62,8,7.12,6.37,6.11,6.12,6.32,6.60,7.12,7.50,7.75,7.87,8.08,8.25,8.62,9.07,9.50,9.98,10.25,10.47,10.58,10.62,10.75,10.85,10.87,10.96,10.98,10.98,10.98,10.98,10.98,10.97,10.97,10.97,10.96,10.96,10.95,10.87,10.87,10.82,10.70,10.50,10.36,10.20,10.08,9.99,9.87,9.82,9.62,9.50,9.34,9.12,9,8.87,8.75,8.60,8.37,8.25,8.12,8.07,8,8,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8,8.12,8.24,8.37,8.57,8.73,8.75,8.83,8.85,8.87,8.87,8.87,8.96,8.97,8.99,8.99,8.99,8.99,8.98,8.98,8.97,8.96,8.85,8.75,8.21,8.12,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.98,7.95,7.83,7.37,18.22,18.12,18.12,18.12,18.21,18.36,18.62,19.11,19.57,19.98,20.25,20.37,20.37,20.34,20.12,19.87,19.57,19.12,18.62,18.25,18.09,18,18.11,18.34,18.70,19.12,19.70,20.15,20.54,20.87,21.09,21.18,21.10,20.98,20.79,20.54,20.27,19.97,19.68,19.42,19.18,18.99,18.82,18.68,18.59,18.52,18.50,18.54,18.64,18.78,18.92,18.99,18.79,18.26,17.24,15.95,14.62,13.75,13.37,13.74,14.87,16.37,18.12,16.57,15.84,15.95,16.87,14.58,13.49,12.50,11.75,11.12,10.62,10.37,10.25,10.24,10.25,10.25,10.25,10.25,10.12,10.11,10,9.83,9.60,9.32,8.98,8.62,8.25,7.87,7.62,7.35,7.09,6.83,6.62,6.50,6.50,6.62,6.70,6.62,6.96,7,6.98,6.87,6.86,6.62,6.37,6,5.70,5.49,5.37,5.33,5.24,5.08,4.62,4.62,4.59,4.50,4.37,4.25,3.97,3.49,3.45,3.25,3,2.62,2.11,1.37,0.50,-0.38,-1.18,-1.75,-2.13,-2.30,-2.50,-2.63,-2.75,-2.76,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.92,-2.77,-2.51,-2.03,-1.38,-0.42,0.57,1.35,2,3,4,6.12,7.70,8.50,8.87,9.12,9.12,8.87,8.70,8.49,8.23,7.75,7,6.37,6.08,6,6.09,6.22,6.73,7.12,7.50,7.75,8,8.37,8.84,9.33,9.82,10.22,10.49,10.62,10.72,10.75,10.82,10.87,10.87,10.95,10.97,10.97,10.98,10.97,10.97,10.97,10.97,10.97,10.96,10.95,10.87,10.87,10.87,10.75,10.62,10.50,10.34,10.12,10.07,9.98,9.87,9.75,9.62,9.49,9.25,9.12,8.99,8.87,8.62,8.49,8.32,8.12,8.07,8,8,7.99,7.99,7.99,7.99,7.99,8,8,8,8,8.10,8.12,8.25,8.37,8.62,8.75,8.87,8.87,8.87,8.87,8.95,8.97,8.98,8.98,8.99,8.99,8.99,8.99,8.99,8.98,8.98,8.98,8.97,8.86,8.83,8.20,8.12,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.98,7.95,7.83,7.37,18.12,18.24,18.36,18.49,18.62,18.86,19.20,19.62,20,20.37,20.61,20.62,20.50,20.36,20.10,19.75,19.34,18.87,18.37,18.12,18,18.09,18.25,18.62,19.12,19.62,20.23,20.67,21.05,21.32,21.48,21.54,21.42,21.27,21.08,20.83,20.52,20.24,19.96,19.71,19.48,19.27,19.11,18.98,18.89,18.85,18.86,18.93,19.09,19.30,19.54,19.75,19.85,19.46,18.50,16.87,15.23,14.10,13.22,14.62,16.09,19,20.08,17,16,15.87,14.84,13.87,12.87,12.12,11.50,11.09,10.73,10.50,10.37,10.37,10.45,10.37,10.37,10.34,10.25,10.22,10.11,9.95,9.62,9.34,8.95,8.50,8.21,7.87,7.62,7.37,7.24,7,6.83,6.75,6.70,7.22,7.46,7.58,7.62,7.62,7.50,7.37,7.32,7.25,6.82,6.46,6.10,5.72,5.70,5.75,5.75,5.70,5.50,5.36,5.32,5.20,4.97,4.49,4,3.46,3.08,2.84,2.50,2.12,1.61,0.87,0.08,-0.77,-1.53,-2.13,-2.50,-2.66,-2.77,-2.88,-2.89,-2.92,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.88,-2.66,-2.38,-2,-1.40,-0.68,0.12,0.97,1.72,2.35,3.25,5.70,7.08,8,8.21,8.59,8.85,8.87,8.62,8.37,8.07,7.75,7.36,6.83,6.25,6,6,6,6.12,6.62,7.12,7.59,7.87,8.25,8.75,9.25,9.75,10.24,10.57,10.75,10.85,10.87,10.87,10.87,10.87,10.87,10.96,10.97,10.97,10.98,10.97,10.97,10.97,10.96,10.96,10.96,10.87,10.87,10.87,10.82,10.72,10.59,10.37,10.25,10.12,10,9.96,9.87,9.75,9.62,9.45,9.25,9.11,8.97,8.83,8.62,8.37,8.24,8.10,8,8,7.99,7.99,7.99,7.99,7.99,8,8,8.07,8.11,8.12,8.21,8.25,8.34,8.50,8.62,8.82,8.87,8.95,8.97,8.97,8.98,8.98,8.98,8.99,8.99,9,9,9,9,9,8.99,8.99,8.98,8.98,8.87,8.83,8.22,8.12,8,7.99,7.99,7.99,7.99,7.99,7.99,7.98,7.98,7.95,7.83,7.45,18.10,18.33,18.62,18.97,19.25,19.50,19.86,20.21,20.50,20.75,20.75,20.62,20.45,20.12,19.82,19.37,18.98,18.50,18.12,17.87,17.87,18.09,18.48,18.99,19.58,20.20,20.83,21.24,21.57,21.78,21.88,21.88,21.73,21.54,21.33,21.04,20.76,20.49,20.22,19.97,19.75,19.55,19.40,19.27,19.20,19.17,19.21,19.32,19.51,19.79,20.16,20.57,20.86,20.91,20.04,18.50,16.37,14.87,14.33,15.25,16.84,17.87,17.37,16.37,15.25,14.46,13.71,12.87,12.12,11.60,11.23,10.87,10.75,10.62,10.62,10.62,10.62,10.62,10.57,10.49,10.37,10.35,10.25,10.08,9.75,9.37,8.97,8.50,8.22,7.97,7.75,7.62,7.50,7.37,7.37,7.60,7.62,8.12,8.37,8.49,8.37,8.25,8.37,7.62,7.47,7.37,7.33,6.95,6.62,6.37,6.36,6.37,6.57,6.62,6.59,6.50,6.50,6.48,5.87,5.11,4.50,3.37,2.87,2.49,2.12,1.71,1.11,0.37,-0.38,-1.15,-1.88,-2.39,-2.75,-2.88,-2.92,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.88,-2.64,-2.38,-2,-1.43,-0.77,-0.13,0.62,1.45,2.12,2.87,4.22,6.09,10.20,8,7.95,8.12,8.34,8.50,8.37,8.12,7.83,7.37,6.87,6.48,6.20,6,6,6.08,6.33,6.87,7.37,7.85,8.25,8.75,9.25,9.87,10.37,10.74,10.96,11,11,11,10.99,10.96,10.96,10.96,10.96,10.97,10.97,10.98,10.97,10.97,10.96,10.96,10.95,10.95,10.87,10.87,10.83,10.74,10.62,10.50,10.36,10.23,10.11,10,9.95,9.86,9.74,9.59,9.37,9.24,9.08,8.97,8.75,8.61,8.37,8.20,8.08,8,7.99,7.99,7.99,7.99,7.99,8,8,8.08,8.12,8.24,8.33,8.37,8.45,8.50,8.62,8.75,8.87,8.87,8.96,8.98,8.98,8.99,8.99,8.99,8.99,9,9,9.12,9.24,9.23,9.12,9,8.99,8.99,8.99,8.98,8.87,8.82,8.22,8,7.99,7.99,7.99,7.99,7.99,7.98,7.98,7.97,7.87,7.83,7.47,18.10,18.48,19,19.50,20,20.33,20.59,20.75,20.87,20.87,20.75,20.48,20.12,19.75,19.37,19,18.50,18.11,17.84,17.70,17.75,18.12,18.70,19.37,20.08,20.75,21.48,21.86,22.10,22.26,22.29,22.22,22.01,21.79,21.52,21.25,20.98,20.72,20.47,20.24,20.03,19.85,19.70,19.58,19.51,19.49,19.54,19.67,19.90,20.22,20.66,21.21,21.72,22.09,21.92,20.25,18.48,16.50,15.87,16.12,16.59,16.60,16.07,15.12,14.20,13.25,12.74,12.07,11.37,11.20,10.99,10.87,10.82,10.82,10.86,10.87,10.87,10.87,10.75,10.71,10.61,10.50,10.37,10.23,9.97,9.50,9.08,8.62,8.25,8.08,7.97,7.87,7.87,7.85,8.12,8.70,9.25,9.60,9.61,9.50,9.25,8.87,8.25,7.75,7.50,7.50,7.50,7.49,7.37,7.37,6.62,7.60,7.60,7.57,8.37,8.86,8.84,8.50,6.99,5.75,4.45,3.37,2.70,2.12,1.70,1.20,0.61,-0.13,-0.79,-1.63,-2.25,-2.67,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.01,-3.01,-3,-3,-3,-3,-3,-3,-3,-3.04,-3.08,-3.05,-3.03,-3.01,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.63,-2.38,-1.93,-1.40,-0.88,-0.18,0.49,1.12,1.86,2.50,3.33,4.37,6.08,7.12,7.62,7.50,7.62,7.87,8.12,8.25,8.09,7.72,7.23,6.72,6.34,6.12,6.07,6.08,6.22,6.61,7.25,7.75,8.23,8.75,9.34,9.97,10.50,10.99,11.24,11.33,11.32,11.24,11.12,11.08,11,10.99,10.97,10.97,10.97,10.97,10.98,10.97,10.97,10.96,10.96,10.95,10.87,10.87,10.85,10.75,10.62,10.50,10.37,10.25,10.12,10.08,10,9.87,9.84,9.73,9.57,9.37,9.22,9,8.95,8.75,8.59,8.37,8.20,8.07,8,7.99,7.99,7.99,7.99,8,8,8.07,8.12,8.25,8.45,8.59,8.62,8.62,8.72,8.75,8.85,8.87,8.95,8.97,8.98,8.99,8.99,8.99,8.99,8.99,9,9.11,9.34,9.50,9.48,9.23,9,8.99,9,9,8.99,8.97,8.83,8.20,8,7.99,7.99,7.99,7.99,7.98,7.98,7.98,7.96,7.87,7.75,7.48,18.11,18.73,19.50,20.24,20.83,21.12,21.32,21.32,21.20,20.95,20.58,20.12,19.70,19.32,18.96,18.59,18.12,17.75,17.60,17.50,17.75,18.25,18.98,19.75,20.61,21.37,22.20,22.49,22.68,22.73,22.67,22.54,22.26,22.01,21.73,21.45,21.18,20.93,20.71,20.50,20.30,20.14,20,19.89,19.83,19.80,19.86,19.99,20.20,20.50,20.92,21.48,22.10,22.84,22.93,22.07,20.37,18.87,17.48,17.25,16.84,16.12,15.08,14.12,13.62,12.87,12.24,11.37,11.25,11,10.99,10.97,11,11.10,11.20,11.25,11.25,11.23,11.12,11,10.87,10.75,10.61,10.37,10.12,9.75,9.21,8.73,8.37,8.25,8.25,8.36,8.49,8.62,8.74,9.87,11.37,11.37,11,10.50,10.47,9.32,8.50,7.50,7.50,7.87,7.96,8,8.20,8.59,9.45,10.12,10.46,9.50,10.50,11.50,12.50,9.75,8,6.33,4.75,3.37,2.48,1.82,1.24,0.70,0.11,-0.54,-1.25,-2,-2.75,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.01,-3.01,-3.01,-3,-3,-3,-3,-3,-3,-3.16,-3.23,-3.18,-3.10,-3.03,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.92,-2.75,-2.38,-1.88,-1.38,-0.78,-0.25,0.37,1,1.62,2.25,2.87,3.58,4.37,5.49,6.36,6.84,7.12,7.46,7.87,8.25,8.37,8.22,7.75,7.23,6.70,6.32,6.12,6.12,6.22,6.50,7,7.62,8.12,8.62,9.25,9.96,10.62,11.24,11.59,11.62,11.62,11.50,11.37,11.25,11.12,11.07,11,10.99,10.98,10.97,10.97,10.98,10.97,10.97,10.96,10.96,10.87,10.87,10.87,10.75,10.71,10.58,10.37,10.25,10.20,10.11,10,9.98,9.87,9.83,9.71,9.50,9.37,9.20,9,8.87,8.75,8.59,8.37,8.20,8.07,8,7.99,7.99,7.99,7.99,8,8.07,8.12,8.25,8.49,8.71,8.87,8.96,8.95,8.87,8.87,8.87,8.95,8.96,8.98,8.98,8.99,8.99,8.99,9,9,9,9.12,9.32,9.50,9.37,9.22,9,9,9,9,8.99,8.98,8.86,8.12,8,7.99,7.99,7.99,7.98,7.98,7.98,7.96,7.87,7.86,7.62,7.50,18.33,19,20,20.97,21.70,22,21.98,21.75,21.37,20.87,20.35,19.75,19.25,18.87,18.61,18.25,17.87,17.50,17.37,17.49,17.85,18.48,19.25,20.21,21.12,22.11,22.97,23.13,23.24,23.23,23.02,22.80,22.48,22.18,21.88,21.62,21.37,21.14,20.95,20.76,20.59,20.43,20.30,20.21,20.13,20.10,20.13,20.22,20.36,20.58,20.88,21.32,21.87,22.36,22.61,22.64,22.25,20.75,19.72,18.75,17.71,16.33,15.12,14.20,13.50,12.87,12.22,11.70,11.37,11.25,11.25,11.33,11.37,11.50,11.62,11.75,11.75,11.70,11.57,11.37,11.23,11,10.86,10.61,10.25,9.84,9.33,8.84,8.50,8.46,8.61,8.87,9.36,9.70,9.62,11.12,12.37,13.37,12.47,11.50,10.49,9.46,9.20,8.48,8.37,8.37,8.48,8.50,9,9.50,11.49,14.50,13.50,12.48,13.50,14.50,13.50,10.87,8.71,6.87,5,3.37,2.25,1.37,0.75,0.12,-0.40,-1.02,-1.65,-2.27,-2.78,-3,-3,-3,-3,-3,-3,-3,-3.01,-3.01,-3.01,-3.02,-3.02,-3.05,-3.05,-3.05,-3.04,-3.03,-3.03,-3.03,-3.04,-3.04,-3.08,-3.15,-3.26,-3.34,-3.29,-3.21,-3.08,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.65,-2.30,-1.88,-1.25,-0.68,-0.13,0.45,1,1.62,2.25,2.85,3.37,4,4.62,5.35,6.12,6.62,7.12,7.72,8.25,8.75,8.87,8.60,8,7.35,6.75,6.37,6.21,6.23,6.37,6.86,7.47,8,8.46,9.10,9.82,10.50,11.25,11.75,12,11.98,11.86,11.62,11.50,11.33,11.20,11.10,11,11,10.98,10.98,10.98,10.98,10.97,10.97,10.96,10.95,10.87,10.87,10.85,10.75,10.62,10.50,10.36,10.23,10.12,10,10,9.96,9.87,9.83,9.71,9.50,9.37,9.12,9,8.87,8.75,8.58,8.37,8.20,8.08,8,7.99,7.99,7.99,8,8,8.12,8.25,8.37,8.62,8.98,9.12,9.25,9.12,9.09,9,8.98,8.97,8.98,8.98,8.98,8.99,8.99,9,9,9,9,9.09,9.20,9.32,9.21,9.11,9,9,9,9,8.99,8.98,8.87,8.12,8,7.99,7.99,7.98,7.98,7.98,7.97,7.87,7.87,7.74,7.50,6.50,18.62,19.45,20.50,21.62,22.45,22.75,22.50,22.12,21.62,20.96,20.25,19.59,19.07,18.74,18.46,18.12,17.75,17.37,17.36,17.48,17.87,18.62,19.58,20.62,21.70,22.74,23.62,23.77,23.72,23.60,23.35,22.99,22.62,22.32,22.01,21.75,21.53,21.34,21.16,21.01,20.87,20.73,20.61,20.51,20.42,20.36,20.34,20.35,20.39,20.47,20.60,20.82,21.15,21.57,21.91,22.13,22.51,22.35,21.49,20.45,19.10,17.36,15.95,14.75,13.86,13.12,12.50,12.07,11.82,11.75,11.82,11.87,12.09,12.24,12.36,12.37,12.37,12.25,12.10,11.87,11.62,11.46,11.20,10.87,10.46,9.96,9.37,8.97,8.71,8.72,8.87,9.72,10.37,11.09,11.62,12.59,13.57,14.46,13.25,12.37,11.59,10.74,10.62,9.37,9.37,9.34,8.46,9.22,9.60,10.59,12.11,14.50,15.50,14.50,16.50,15.50,13.50,11,9.59,6.73,5.61,3.37,1.99,1,0.33,-0.38,-0.90,-1.50,-2.02,-2.50,-2.88,-3,-3,-3,-3,-3,-3.04,-3.08,-3.10,-3.10,-3.11,-3.12,-3.13,-3.13,-3.12,-3.11,-3.09,-3.09,-3.10,-3.12,-3.13,-3.16,-3.17,-3.26,-3.38,-3.42,-3.39,-3.26,-3.13,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.92,-2.88,-2.88,-2.75,-2.63,-2.38,-1.75,-1.14,-0.55,0,0.59,1.12,1.70,2.25,2.87,3.50,4.12,4.75,5.25,5.75,6.50,7.10,7.71,8.37,9,9.50,9.50,9,8.25,7.50,6.87,6.50,6.37,6.37,6.70,7.12,7.75,8.37,8.87,9.57,10.32,11.12,11.82,12.21,12.25,12.12,11.99,11.75,11.57,11.37,11.24,11.12,11,11,10.99,10.98,10.98,10.98,10.97,10.97,10.96,10.95,10.87,10.87,10.84,10.74,10.61,10.46,10.25,10.12,10.09,10,9.99,9.95,9.87,9.82,9.70,9.50,9.37,9.12,9,8.87,8.75,8.58,8.37,8.20,8.07,8,7.99,7.99,7.99,8,8.08,8.20,8.36,8.57,8.82,9.10,9.24,9.33,9.22,9.12,9,9,8.98,8.98,8.99,8.99,8.99,8.99,9,9,9,9,9,9,9,9,9,9,9,9,9,8.99,8.98,8.87,8.12,8,7.99,7.98,7.98,7.98,7.97,7.87,7.87,7.75,7.58,7.20,6.57,19.08,19.86,20.97,22.12,22.98,23.25,23,22.57,21.87,21.23,20.48,19.75,19.24,18.87,18.58,18.24,17.84,17.45,17.37,17.50,18,18.83,19.82,20.87,22.09,23.21,24.25,24.17,24.17,23.80,23.48,23.11,22.70,22.38,22.09,21.85,21.66,21.50,21.36,21.24,21.12,21.01,20.90,20.78,20.67,20.58,20.48,20.39,20.32,20.23,20.16,20.15,20.28,20.57,20.97,21.46,21.93,22.35,22.75,22.37,20.95,18.87,16.87,15.37,14.37,13.61,13,12.61,12.37,12.46,12.60,12.75,12.96,13.12,13.22,13.21,13.10,12.87,12.70,12.46,12.22,11.95,11.62,11.23,10.73,10.12,9.60,9.09,8.95,8.99,9.47,10.33,12.23,12.33,13.37,14.12,15.46,14.58,13.45,13.59,12.62,11.62,10.33,11.34,11.23,10.37,10.12,9.37,10.25,10.37,12.35,13.37,13.37,14.25,14.57,13.58,13.58,9.70,7.61,5.87,4.25,2.87,1.62,0.70,-0.13,-0.76,-1.38,-1.89,-2.38,-2.67,-2.89,-3,-3,-3,-3,-3.11,-3.16,-3.22,-3.24,-3.25,-3.25,-3.25,-3.25,-3.23,-3.22,-3.16,-3.14,-3.15,-3.18,-3.26,-3.33,-3.35,-3.36,-3.40,-3.49,-3.50,-3.43,-3.33,-3.15,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.76,-2.63,-2.43,-2.27,-2.13,-1.63,-1.01,-0.38,0.24,0.84,1.37,1.87,2.37,2.96,3.61,4.34,5.08,5.75,6.32,6.83,7.47,7.99,8.57,9.20,9.75,10.10,9.87,9.25,8.37,7.62,7.12,6.83,6.72,6.75,7,7.37,7.99,8.62,9.35,10,10.75,11.50,12.12,12.46,12.37,12.25,12,11.84,11.62,11.37,11.25,11.12,11.07,11,11,10.99,10.98,10.98,10.97,10.97,10.96,10.95,10.87,10.87,10.83,10.72,10.58,10.37,10.25,10.12,10.07,10,9.98,9.95,9.87,9.82,9.70,9.50,9.37,9.21,9.07,8.87,8.75,8.58,8.37,8.12,8.07,8,7.99,7.99,8,8,8.10,8.23,8.37,8.62,8.87,9,9.12,9.21,9.12,9.10,9,9,8.99,8.99,8.99,8.99,8.99,8.99,9,9,9,9,9,9,9,8.99,8.99,8.99,9,9,8.99,8.99,8.97,8.87,8.10,8,7.99,7.98,7.98,7.97,7.95,7.87,7.75,7.62,7.36,7,6.60,19.49,20.32,21.37,22.45,23.25,23.61,23.37,22.96,22.37,21.73,21,20.35,19.75,19.33,18.87,18.50,18,17.58,17.48,17.61,18.12,18.95,19.95,21.08,22.25,23.37,24.50,24.32,24.20,23.92,23.43,23.04,22.71,22.37,22.12,21.91,21.76,21.63,21.53,21.45,21.36,21.26,21.15,21.02,20.88,20.73,20.55,20.37,20.16,19.92,19.68,19.50,19.46,19.63,20.08,20.72,21.58,22.53,23.57,24.37,23.50,20.75,17.12,16.24,15.12,14.25,13.62,13.25,13.12,13.25,13.50,13.75,13.97,14.12,14.23,14.12,13.85,13.57,13.25,13,12.75,12.50,12.12,11.70,11.12,10.48,9.87,9.37,9.25,9.37,9.87,10.75,11.73,13.35,14.37,15.48,16.50,15.10,14.59,14.62,12.25,11.25,12.75,13.73,13.71,12.75,12,10.36,11.32,11.83,12.37,13.60,13.60,12.59,12.60,11.60,9.37,7.37,5.37,4.50,3.25,2.12,1.12,0.24,-0.51,-1.18,-1.78,-2.25,-2.63,-2.88,-2.93,-3,-3,-3,-3.09,-3.24,-3.36,-3.41,-3.46,-3.46,-3.43,-3.42,-3.41,-3.39,-3.36,-3.28,-3.25,-3.27,-3.37,-3.47,-3.53,-3.58,-3.55,-3.55,-3.59,-3.58,-3.49,-3.35,-3.17,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.90,-2.88,-2.79,-2.43,-2.13,-1.88,-1.54,-1.25,-0.75,-0.16,0.50,1.12,1.73,2.24,2.62,3.12,3.62,4.37,5.25,6.20,7,7.74,8.25,8.62,9,9.37,9.75,10.10,10.12,9.75,9.08,8.34,7.75,7.46,7.25,7.24,7.25,7.37,7.70,8.12,8.75,9.50,10.34,11.11,11.82,12.37,12.60,12.50,12.25,12.09,11.86,11.62,11.46,11.25,11.12,11.09,11,11,11,10.99,10.98,10.97,10.97,10.96,10.95,10.87,10.87,10.82,10.71,10.50,10.37,10.25,10.12,10,10,9.97,9.87,9.87,9.82,9.71,9.57,9.37,9.22,9.08,8.95,8.75,8.58,8.36,8.12,8.07,8,8,8,8,8,8.11,8.23,8.37,8.62,8.86,9,9.08,9.09,9.08,9,9,9,8.99,8.99,8.99,9,9,9,9,9,9,9,9,9,8.98,8.98,8.87,8.75,8.62,8.73,8.87,9,9,8,8.07,8,7.98,7.98,7.98,7.95,7.87,7.75,7.62,7.34,7.12,6.96,6.62,20,20.75,21.74,22.62,23.37,23.70,23.60,23.25,22.87,22.37,21.75,21.12,20.50,19.97,19.37,18.87,18.35,17.84,17.70,17.75,18.23,19,19.97,21,22.12,23.25,24.25,24.05,23.89,23.61,23.25,22.87,22.57,22.30,22.10,21.93,21.83,21.74,21.67,21.61,21.54,21.47,21.36,21.22,21.04,20.84,20.60,20.30,19.98,19.62,19.25,18.93,18.77,18.88,19.34,20.13,21.32,22.77,24.55,26,26.50,23.35,19.12,17.24,16.10,15,14.25,13.87,13.87,14.12,14.50,14.75,15,15.12,15.46,14.87,14.50,14.12,13.87,13.62,13.45,13.21,12.84,12.25,11.62,10.87,10.21,9.75,9.60,9.75,10.25,10.75,12.25,13.62,15.37,16.49,15.98,15.50,14.37,14.35,14.70,13.25,14.21,15.75,14.25,15.71,14.62,13.25,12.62,12.62,12.62,12.62,11.37,10.37,9.62,8.37,7,5.36,4.34,3.25,2.25,1.33,0.46,-0.38,-1,-1.63,-2.17,-2.63,-2.80,-2.91,-3,-3,-3.08,-3.16,-3.35,-3.51,-3.65,-3.75,-3.76,-3.75,-3.72,-3.67,-3.64,-3.62,-3.54,-3.48,-3.46,-3.49,-3.58,-3.66,-3.76,-3.78,-3.75,-3.71,-3.66,-3.61,-3.50,-3.35,-3.16,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.91,-2.88,-2.80,-2.88,-2.88,-2.80,-2.79,-2.77,-2.79,-2.64,-2.63,-2.41,-1.93,-1.50,-1.04,-0.67,-0.26,0.23,0.83,1.50,2.12,2.72,3.12,3.50,3.87,4.46,5.24,6.24,7.37,8.50,9.37,9.82,9.85,9.87,9.87,9.97,9.87,9.62,9.12,8.62,8.21,7.99,7.87,7.87,7.86,7.84,7.86,8,8.33,8.84,9.50,10.25,11.12,12,12.48,12.60,12.50,12.25,12.08,11.87,11.62,11.50,11.34,11.22,11.12,11.08,11,11,11,10.99,10.98,10.97,10.96,10.95,10.87,10.87,10.75,10.70,10.50,10.37,10.25,10.12,10,10,9.97,9.87,9.87,9.82,9.72,9.58,9.37,9.24,9.10,8.96,8.75,8.58,8.36,8.12,8.07,8,8,8.08,8.08,8.09,8.12,8.22,8.37,8.62,8.85,8.97,9,9,9,9,9,8.99,8.98,8.95,8.95,8.95,8.96,8.96,8.96,8.96,8.97,8.97,8.97,8.97,8.98,8.86,8.62,8.45,8.33,8.32,8.12,8,8,8,8,7.99,7.98,7.98,7.96,7.87,7.75,7.74,7.25,7.20,7,6.87,6.62,20.75,21.37,22.10,22.74,23.25,23.58,23.60,23.50,23.33,23,22.59,22,21.33,20.62,20,19.37,18.75,18.23,18,18,18.37,19,19.86,20.82,21.82,22.75,23.60,23.50,23.34,23.10,22.87,22.62,22.38,22.18,22.03,21.92,21.85,21.80,21.77,21.74,21.70,21.63,21.52,21.37,21.16,20.90,20.60,20.23,19.80,19.35,18.89,18.50,18.27,18.35,18.80,19.70,21.11,23,25.40,28.35,29.50,26.62,23,19.24,17.33,15.96,14.87,14.45,14.50,15,15.50,15.84,15.96,15.98,15.75,15.50,15,14.61,14.36,14.22,14.11,13.99,13.62,13.08,12.25,11.37,10.62,10,9.96,10.20,10.71,11.50,12.72,14.35,15.37,16.50,16.20,15.37,15.61,15.62,15.71,15.87,16.20,16.75,17.75,16.12,16.72,14.70,13.70,12.62,12.62,10.62,9.35,8.32,7.24,5.35,5.12,4.20,3.12,2.25,1.35,0.50,-0.29,-1,-1.53,-2.13,-2.63,-2.89,-2.92,-3,-3,-3.09,-3.18,-3.38,-3.63,-3.87,-4.01,-4.10,-4.11,-4.09,-4.02,-3.98,-3.91,-3.87,-3.79,-3.74,-3.71,-3.72,-3.76,-3.86,-3.90,-3.91,-3.88,-3.79,-3.72,-3.59,-3.43,-3.28,-3.14,-3,-3,-3,-3,-3,-3,-3,-2.89,-2.80,-2.75,-2.63,-2.53,-2.50,-2.51,-2.54,-2.50,-2.43,-2.38,-2.38,-2.14,-2.01,-1.88,-1.28,-0.78,-0.25,0.12,0.71,1.25,2,2.71,3.34,3.84,4.12,4.37,4.73,5.25,6.08,7.12,8.37,9.87,11.25,11.22,10.83,10.33,10,9.75,9.37,9,8.62,8.35,8.25,8.25,8.37,8.50,8.50,8.37,8.25,8.25,8.37,8.82,9.37,10.09,10.87,11.84,12.37,12.48,12.37,12.24,12,11.87,11.71,11.50,11.37,11.25,11.12,11.12,11.08,11,11,11,10.98,10.97,10.96,10.87,10.87,10.87,10.75,10.62,10.50,10.37,10.24,10.12,10,10,9.97,9.87,9.87,9.84,9.75,9.59,9.37,9.25,9.11,8.96,8.75,8.57,8.35,8.12,8.08,8.07,8.10,8.12,8.12,8.12,8.12,8.25,8.46,8.62,8.85,8.95,8.98,8.99,8.99,8.99,8.98,8.96,8.87,8.84,8.75,8.62,8.62,8.62,8.62,8.62,8.62,8.62,8.62,8.62,8.62,8.50,8.35,8.12,8,7.99,7.99,8,8,7.99,7.99,7.99,7.99,7.98,7.96,7.84,7.82,7.21,7.12,7,7,6.87,6.70,21.75,22.11,22.49,22.85,23.12,23.34,23.48,23.57,23.61,23.50,23.25,22.73,22,21.25,20.50,19.87,19.25,18.75,18.50,18.37,18.59,19,19.62,20.45,21.25,22,22.67,22.73,22.66,22.55,22.43,22.29,22.15,22.02,21.95,21.89,21.86,21.85,21.84,21.84,21.80,21.74,21.63,21.47,21.24,20.95,20.59,20.15,19.66,19.14,18.62,18.18,17.93,17.98,18.41,19.30,20.78,22.88,26,29.34,30.50,29.62,25.84,22.75,19.12,16.87,15.37,14.46,15.12,15.75,16.47,16.75,16.75,16.58,16.21,15.72,15.25,14.87,14.75,14.75,14.75,14.75,14.75,13.87,13,12,11,10.75,10.62,10.85,10.75,12.37,13.50,14.50,15.33,15.99,16.50,16.59,15.97,16,17.70,17.74,17.75,17.75,17.75,16.75,14.87,13.74,12.12,11.20,10.71,8.25,7.32,6.34,5.50,4.62,3.75,2.99,2.12,1.25,0.47,-0.38,-1.04,-1.63,-2.13,-2.52,-2.75,-2.92,-3,-3,-3.03,-3.24,-3.46,-3.79,-4.12,-4.34,-4.43,-4.47,-4.46,-4.39,-4.34,-4.26,-4.18,-4.12,-4.04,-4,-3.91,-3.88,-3.88,-3.91,-3.92,-3.91,-3.90,-3.83,-3.66,-3.50,-3.30,-3.17,-3.08,-3,-3,-3,-3,-2.90,-2.88,-2.88,-2.63,-2.39,-2.25,-2.05,-2,-2,-2,-2.01,-1.93,-1.88,-1.78,-1.66,-1.43,-1.25,-1.02,-0.63,-0.13,0.37,0.97,1.60,2.37,3.12,4,4.62,5.09,5.25,5.37,5.62,6.12,6.87,7.87,9.08,10.48,11.34,11.50,10.87,10.24,9.75,9.37,9,8.70,8.45,8.36,8.47,8.70,8.87,9,9,8.87,8.70,8.50,8.57,8.75,9.24,9.87,10.62,11.50,12.12,12.33,12.25,12.12,12,11.87,11.74,11.60,11.47,11.36,11.25,11.20,11.12,11.09,11,11,10.99,10.97,10.96,10.87,10.87,10.87,10.75,10.62,10.50,10.37,10.24,10.12,10,10,9.97,9.87,9.87,9.86,9.75,9.60,9.37,9.25,9.11,8.96,8.75,8.57,8.35,8.12,8.08,8.08,8.12,8.12,8.12,8.12,8.23,8.36,8.50,8.70,8.84,8.87,8.87,8.95,8.95,8.87,8.87,8.87,8.75,8.62,8.48,8.37,8.33,8.32,8.32,8.32,8.32,8.32,8.32,8.32,8.25,8.24,8.12,8,8,7.99,7.99,8,8,8,7.99,7.99,7.99,7.87,7.87,7.87,7.12,7.12,7,7,6.99,6.95,6.75,22.87,22.96,22.96,22.95,22.98,23.08,23.25,23.49,23.73,23.86,23.75,23.25,22.59,21.75,21,20.37,19.86,19.37,19.12,18.87,18.87,19.09,19.47,19.99,20.59,21.12,21.63,21.86,21.98,22.01,22.01,21.98,21.92,21.87,21.86,21.85,21.85,21.86,21.88,21.89,21.87,21.82,21.71,21.53,21.29,20.98,20.58,20.11,19.58,19.01,18.45,17.99,17.72,17.71,18.07,18.85,20.20,22.18,25.03,29.33,31.50,30.62,28.84,23.75,20.12,17.50,15.87,15.36,15.61,16.37,17.12,17.57,17.50,17.07,16.49,15.87,15.37,15.22,15.21,15.25,15.37,15.50,15.35,14.86,14,13,11.99,11.87,11.85,11.84,12.62,13.50,14.37,14.98,15.25,15.50,16.57,16.60,15.62,15.62,15.71,15.24,15.75,15.75,15.75,14.75,13.82,11.75,10.23,9.12,8.07,7,5.95,5.11,4.25,3.47,2.62,1.87,1.12,0.37,-0.38,-1.13,-1.78,-2.42,-2.63,-2.76,-2.89,-3,-3,-3.11,-3.25,-3.52,-3.88,-4.29,-4.67,-4.87,-4.87,-4.84,-4.76,-4.68,-4.62,-4.51,-4.41,-4.33,-4.22,-4.11,-4,-3.90,-3.86,-3.85,-3.84,-3.80,-3.78,-3.71,-3.52,-3.34,-3.14,-3.02,-2.93,-2.90,-2.88,-2.89,-2.75,-2.63,-2.63,-2.43,-2.13,-1.75,-1.43,-1.30,-1.27,-1.25,-1.26,-1.26,-1.25,-1.13,-1.04,-0.89,-0.64,-0.41,-0.17,0.12,0.62,1.10,1.62,2.35,3.24,4.50,5.11,5.83,6.37,6.50,6.50,6.70,7.12,7.75,8.59,9.45,10.24,10.82,10.82,10.33,9.84,9.37,9.07,8.82,8.62,8.50,8.62,8.82,9.08,9.33,9.46,9.37,9.25,9,8.84,8.75,8.87,9.22,9.74,10.37,11.12,11.62,12,12.08,12,11.99,11.87,11.75,11.62,11.50,11.45,11.36,11.25,11.21,11.12,11.08,11,11,10.98,10.96,10.87,10.87,10.87,10.75,10.62,10.50,10.37,10.24,10.12,10,9.99,9.97,9.96,9.87,9.86,9.75,9.60,9.37,9.25,9.11,8.95,8.75,8.50,8.34,8.12,8.08,8.07,8.11,8.12,8.12,8.12,8.25,8.37,8.50,8.70,8.75,8.85,8.85,8.84,8.83,8.83,8.75,8.72,8.58,8.37,8.21,8,8,8,8,8,8,8,8,8,8,8,8,8,7.99,7.99,7.99,8,8,8,7.99,7.99,7.96,7.87,7.09,7.11,7.12,7,7,6.99,6.97,6.83,6.75,24.37,24.07,23.50,23,22.84,22.83,23,23.35,23.73,23.99,24,23.62,22.99,22.21,21.48,20.87,20.47,20.12,19.75,19.37,19.21,19.12,19.25,19.50,19.87,20.25,20.70,21.04,21.30,21.50,21.64,21.72,21.75,21.76,21.78,21.83,21.85,21.88,21.91,21.92,21.91,21.86,21.75,21.58,21.33,21,20.60,20.11,19.57,18.97,18.39,17.92,17.62,17.53,17.73,18.27,19.29,20.85,23.25,26.33,30.58,31.71,27.85,23.36,19.87,17.61,16.21,15.37,16.10,16.87,17.74,18.50,18.08,17.48,16.74,16.08,15.62,15.50,15.62,15.83,16,16.21,16.20,15.87,15.35,14.71,14.24,13.87,13.85,13.75,13.75,15.25,15.61,15.62,15.46,14.46,14.37,14.34,14.62,13.62,12.99,12.24,11.87,11.12,11.12,11.12,10.82,9.12,8,7,6.22,5.22,4.75,3.87,3.12,2.37,1.62,0.87,0.21,-0.50,-1.18,-1.88,-2.52,-2.75,-2.88,-2.92,-3,-3.09,-3.23,-3.38,-3.53,-3.90,-4.34,-4.80,-5.17,-5.29,-5.24,-5.13,-5.05,-4.97,-4.84,-4.73,-4.61,-4.47,-4.30,-4.14,-3.98,-3.84,-3.75,-3.67,-3.65,-3.62,-3.58,-3.49,-3.33,-3.14,-2.98,-2.85,-2.73,-2.65,-2.50,-2.38,-2.25,-2.05,-2,-1.76,-1.27,-0.88,-0.54,-0.50,-0.43,-0.43,-0.42,-0.40,-0.38,-0.30,-0.25,-0.13,0.12,0.37,0.61,0.87,1.25,1.70,2.24,2.87,3.70,4.50,5.49,6.25,7,7.50,7.57,7.75,8.21,8.70,9.20,9.62,10,10.12,10.08,9.73,9.37,9.12,8.95,8.85,8.82,8.86,8.98,9.12,9.37,9.62,9.72,9.70,9.50,9.37,9.20,9.12,9.12,9.37,9.75,10.32,10.87,11.37,11.75,11.95,12,11.98,11.87,11.83,11.73,11.62,11.50,11.47,11.37,11.25,11.20,11.12,11,11,10.99,10.97,10.95,10.87,10.87,10.75,10.62,10.50,10.37,10.24,10.12,10,9.99,9.97,9.97,9.87,9.86,9.75,9.59,9.37,9.24,9.09,8.87,8.75,8.50,8.34,8.12,8.07,8,8,8.08,8.10,8.12,8.24,8.37,8.50,8.62,8.70,8.70,8.62,8.62,8.62,8.60,8.57,8.49,8.36,8.22,8.09,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8,7.99,7.98,7.96,7,7.07,7,7,7,6.99,6.98,6.85,6.75,5.75,26.74,25.32,24.10,23.12,22.62,22.59,22.82,23.22,23.70,24.07,24.12,23.87,23.25,22.50,21.86,21.37,21.12,20.87,20.37,19.95,19.50,19.20,19.08,19.12,19.25,19.50,19.90,20.32,20.73,21.09,21.35,21.54,21.65,21.72,21.78,21.84,21.88,21.91,21.95,21.97,21.96,21.90,21.79,21.61,21.36,21.03,20.63,20.16,19.62,19.04,18.48,18.01,17.66,17.48,17.46,17.67,18.26,19.09,20.63,22.78,24.86,26.75,25.84,21.22,18.75,17.10,16.10,15.87,16.37,17.25,18.23,18.62,18.59,17.75,16.87,16.25,15.87,15.87,16,16.35,16.62,16.96,17.10,17,16.75,16.50,16.37,16.37,16.25,16.11,16.12,16.46,16.85,17.37,15.25,13.37,12.37,12.36,12.09,11.71,10.25,9.23,8.12,8.12,8.82,8.12,7.83,6.87,5.12,5.12,4.84,3.97,3.21,2.62,2,1.32,0.61,-0.13,-0.75,-1.38,-1.91,-2.75,-2.76,-2.93,-3,-3.04,-3.14,-3.29,-3.50,-3.71,-3.97,-4.28,-4.66,-5.13,-5.43,-5.53,-5.50,-5.40,-5.29,-5.15,-5.01,-4.88,-4.73,-4.53,-4.34,-4.11,-3.88,-3.68,-3.55,-3.49,-3.42,-3.38,-3.33,-3.23,-3.10,-2.97,-2.78,-2.61,-2.41,-2.14,-1.88,-1.52,-1.38,-1.25,-1.02,-0.75,-0.38,0,0.34,0.37,0.37,0.37,0.37,0.46,0.48,0.50,0.50,0.62,0.87,1.12,1.32,1.50,1.83,2.24,2.75,3.33,3.95,4.62,5.37,6.32,7.24,7.97,8.50,8.87,9.25,9.50,9.72,9.75,9.75,9.72,9.50,9.25,9.11,9,8.99,9,9.10,9.21,9.34,9.50,9.70,9.85,9.87,9.87,9.86,9.74,9.62,9.60,9.62,9.75,10,10.47,10.95,11.37,11.73,11.87,12,12,11.96,11.87,11.75,11.73,11.62,11.57,11.47,11.36,11.25,11.12,11.08,11,11,10.98,10.96,10.87,10.87,10.75,10.70,10.50,10.37,10.23,10.11,10,9.99,9.98,9.97,9.87,9.86,9.74,9.58,9.37,9.23,9.07,8.87,8.73,8.50,8.34,8.12,8.07,8,8,8,8,8.10,8.12,8.25,8.37,8.49,8.50,8.50,8.45,8.37,8.37,8.36,8.33,8.25,8.12,8.09,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8,8,7.98,7,7,7,7,7,6.99,6.98,6.86,6.82,6.20,5.75,28.87,26.50,24.50,23.12,22.47,22.37,22.62,23.12,23.72,24.12,24.25,24,23.48,22.75,22.21,21.87,21.75,21.60,21.12,20.37,19.75,19.24,18.87,18.75,18.82,18.96,19.21,19.61,20.32,20.84,21.22,21.48,21.66,21.77,21.83,21.90,21.95,21.99,22.01,22.01,21.99,21.93,21.82,21.64,21.40,21.09,20.71,20.26,19.76,19.23,18.71,18.24,17.85,17.53,17.30,17.22,17.35,17.45,18.05,18.54,20.37,21.20,20.46,18.23,17.47,16.50,15.32,16.07,16.70,17.50,18.37,19.60,18.72,17.99,17.12,16.32,16.12,16.12,16.45,16.75,17.21,17.62,17.99,18.12,18.21,18.25,18.50,18.70,19.23,18.12,17.75,17.57,18.37,17.48,15.50,12.87,11.37,10.62,10,9.20,8.25,7.22,6.87,6.83,6.12,6.12,5.12,4.87,4.20,3.59,3.11,2.50,1.98,1.37,0.87,0.25,-0.38,-1.13,-1.64,-2.13,-2.50,-3,-3,-3,-3.11,-3.22,-3.36,-3.54,-3.79,-4.04,-4.33,-4.62,-4.97,-5.27,-5.55,-5.68,-5.71,-5.63,-5.49,-5.33,-5.14,-4.98,-4.78,-4.58,-4.33,-4.03,-3.75,-3.52,-3.38,-3.29,-3.21,-3.15,-3.10,-2.99,-2.88,-2.78,-2.65,-2.25,-1.88,-1.50,-1,-0.50,-0.39,-0.25,0,0.33,0.62,0.87,1.12,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.25,1.37,1.61,1.86,2,2.09,2.25,2.75,3.25,3.75,4.25,4.74,5.32,6.37,7.57,8.62,9.37,9.87,10.12,10.12,10,9.87,9.62,9.45,9.25,9.08,8.98,9,9.12,9.25,9.37,9.50,9.70,9.84,9.98,10.11,10.20,10.23,10.23,10.21,10.20,10.21,10.25,10.37,10.58,10.87,11.23,11.58,11.86,12,12.10,12.09,12,11.96,11.87,11.75,11.73,11.62,11.50,11.37,11.25,11.12,11.10,11,11,11,10.98,10.95,10.87,10.82,10.70,10.50,10.37,10.22,10.09,10,9.99,9.98,9.97,9.87,9.87,9.74,9.57,9.37,9.21,9,8.87,8.72,8.50,8.34,8.12,8.08,8,8,8,8,8,8.12,8.20,8.25,8.32,8.33,8.25,8.24,8.20,8.12,8.12,8.12,8.10,8.07,8,8,7.99,7.99,7.98,7.98,7.98,7.98,7.98,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8,8,7,7,7,7,7,6.99,6.99,6.87,6.86,6.12,6.10,5.75,26.87,26.72,24.37,22.87,22.12,22.12,22.50,23.12,23.75,24.25,24.46,24.23,23.62,23,22.59,22.37,22.37,22.25,21.75,20.74,19.87,19.21,18.75,18.50,18.49,18.59,18.84,19.35,20.15,20.78,21.25,21.59,21.80,21.93,21.99,22.05,22.08,22.10,22.10,22.09,22.04,21.97,21.86,21.68,21.45,21.16,20.82,20.41,19.97,19.50,19.03,18.59,18.15,17.74,17.35,17.03,16.80,16.43,16.05,15.41,17.12,17.12,17.12,16.71,16.37,16.11,16,16.23,16.86,17.62,18.37,18.87,18.75,18.12,17.37,16.72,16.25,16.46,16.75,17.12,17.57,18.09,18.96,18.99,19.12,20.09,20.12,21.12,20.25,19.50,19.34,18.37,16.50,16.50,13.58,11.61,9.70,8.70,7.97,7.21,6.24,5.84,5.12,5.07,4.84,4.12,3.84,3.25,2.75,2.20,1.62,1.12,0.71,0.25,-0.25,-0.75,-1.27,-1.88,-2.30,-2.68,-2.88,-3,-3,-3.03,-3.29,-3.43,-3.62,-3.85,-4.12,-4.38,-4.65,-4.92,-5.22,-5.48,-5.71,-5.85,-5.87,-5.76,-5.63,-5.42,-5.24,-5.02,-4.80,-4.55,-4.28,-3.98,-3.65,-3.39,-3.24,-3.14,-3.08,-3.03,-2.93,-2.80,-2.63,-2.39,-2.13,-1.63,-1.13,-0.63,-0.13,0.33,0.58,0.73,0.87,1.23,1.50,1.82,2,2.11,2.12,2.12,2.12,2.11,2.11,2,1.99,2,2,3,3,2.87,3,3.37,3.86,4.33,4.75,5.23,5.84,7,8.37,9.62,10.35,10.61,10.57,10.37,10.12,9.87,9.59,9.33,9.12,9,9,9.12,9.32,9.50,9.72,9.87,10,10.12,10.25,10.37,10.50,10.62,10.70,10.75,10.87,10.96,11,11.12,11.25,11.46,11.62,11.87,12.12,12.25,12.25,12.22,12.12,12,11.95,11.87,11.75,11.62,11.58,11.37,11.25,11.20,11.12,11.07,11,11,11,10.97,10.87,10.84,10.72,10.57,10.37,10.20,10.09,10,9.99,9.98,9.97,9.87,9.87,9.74,9.57,9.37,9.20,9,8.87,8.71,8.50,8.34,8.12,8.08,8,7.99,7.99,8,8,8,8.10,8.12,8.12,8.12,8.12,8.10,8.07,8,8,8,8,8,7.99,7.98,7.98,7.98,7.98,7.98,7.97,7.97,7.96,7.96,7.97,7.98,7.98,7.99,7.99,7.99,7.99,7.99,8,8,8,7,7,7,7,7,7,6.99,6.87,6.87,6.12,6.12,5.99,5.82,24.09,24.83,23.12,22.12,21.71,21.87,22.37,23.12,23.87,24.45,24.62,24.47,23.98,23.37,23,22.87,22.87,22.75,22.10,20.84,19.83,19.08,18.59,18.34,18.25,18.37,18.78,19.50,20.23,20.91,21.46,21.86,22.11,22.25,22.29,22.30,22.28,22.25,22.22,22.17,22.11,22.02,21.89,21.73,21.51,21.25,20.93,20.60,20.23,19.84,19.43,19.01,18.57,18.08,17.58,17.10,16.60,16.07,15.66,15.38,15.20,15.12,14.21,15.25,15.87,16.12,16.25,16.50,16.99,17.62,18.25,18.75,18.83,18.37,17.75,17.12,16.74,16.62,16.87,17.25,17.62,18.20,18.70,19.11,19.50,19.96,20.50,21.22,21.25,20.35,18.37,16.45,14.50,11.86,10.37,8.46,7.49,6.50,6.07,5.45,4.87,4.34,3.87,3.58,3.24,2.86,2.37,1.96,1.45,0.87,0.35,-0.13,-0.52,-0.88,-1.25,-1.63,-2.13,-2.42,-2.78,-2.85,-2.96,-3.04,-3.23,-3.39,-3.58,-3.73,-3.90,-4.14,-4.42,-4.73,-4.99,-5.21,-5.46,-5.66,-5.88,-6,-6.01,-5.86,-5.72,-5.50,-5.26,-5.03,-4.78,-4.52,-4.24,-3.90,-3.59,-3.30,-3.13,-3.04,-3,-3,-2.90,-2.53,-2.17,-1.78,-1.38,-0.88,-0.38,0.12,0.62,1,1.35,1.62,1.84,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3.12,3.83,4.20,4.50,5.07,5.58,6.12,6.87,7.98,9.25,10.37,10.87,10.87,10.71,10.48,10.12,9.86,9.57,9.32,9.12,9,9.07,9.21,9.45,9.71,9.95,10.12,10.25,10.45,10.59,10.74,10.87,11.09,11.25,11.46,11.62,11.75,11.87,12,12.07,12.12,12.22,12.36,12.50,12.57,12.50,12.37,12.21,12.07,11.96,11.87,11.75,11.71,11.58,11.37,11.25,11.12,11.12,11.09,11.08,11,11,11,10.97,10.87,10.75,10.58,10.37,10.20,10.09,10,9.99,9.98,9.97,9.87,9.87,9.75,9.57,9.37,9.20,9,8.87,8.70,8.50,8.34,8.12,8.08,8,7.99,7.99,7.99,8,8,8,8,8.07,8,8,8,8,7.99,7.99,7.98,7.97,7.97,7.96,7.96,7.95,7.95,7.87,7.87,7.87,7.87,7.87,7.87,7.87,7.87,7.97,7.97,7.98,7.98,7.99,7.99,8,8,7,7,7,7,7,6.97,6.96,6.95,6.87,6.09,6.11,6,5.98,5.84,22.09,21.87,21.25,21.12,21.12,21.50,22.23,23.09,23.95,24.62,24.87,24.75,24.37,23.87,23.57,23.37,23.25,22.87,21.96,20.62,19.59,18.83,18.36,18.12,18.12,18.34,18.80,19.66,20.48,21.22,21.83,22.27,22.55,22.68,22.71,22.64,22.57,22.47,22.37,22.28,22.18,22.08,21.95,21.78,21.58,21.35,21.08,20.79,20.50,20.20,19.87,19.48,19.03,18.51,17.96,17.37,16.73,16.12,15.65,15.25,15.20,15.09,15.12,15.49,16,16.45,16.73,16.87,17.12,17.62,18.24,18.73,18.95,18.75,18.25,17.62,17.12,16.87,16.95,17.20,17.50,18,18.50,18.98,19.37,19.71,20.23,20.25,20.36,17.37,14.07,10.50,8.47,8.33,6.47,6.25,5.48,4.85,4.25,3.85,3.37,2.87,2.50,2.20,1.86,1.50,1.12,0.70,0.25,-0.25,-0.75,-1.25,-1.66,-2,-2.13,-2.38,-2.64,-2.78,-2.88,-3.03,-3.18,-3.36,-3.53,-3.73,-3.89,-4.05,-4.23,-4.46,-4.72,-4.99,-5.23,-5.43,-5.66,-5.87,-6,-6.04,-6.03,-5.88,-5.74,-5.50,-5.25,-5,-4.73,-4.43,-4.14,-3.83,-3.50,-3.25,-3.10,-3,-2.92,-2.88,-2.67,-2.13,-1.55,-1.01,-0.50,-0.02,0.37,0.87,1.25,1.71,2,2.36,2.97,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4.25,4.82,5.12,5.48,5.98,6.50,7.12,7.87,8.75,9.85,10.62,10.85,10.85,10.62,10.37,10.12,9.87,9.60,9.36,9.12,9.10,9.11,9.25,9.50,9.75,10.09,10.32,10.50,10.62,10.86,11.08,11.33,11.59,11.87,12.12,12.37,12.62,12.83,12.87,12.84,12.75,12.71,12.74,12.82,12.84,12.73,12.50,12.25,12.09,11.87,11.82,11.71,11.60,11.47,11.34,11.23,11.12,11.12,11.11,11.10,11.10,11.07,11,10.97,10.87,10.75,10.58,10.37,10.20,10.09,10,9.99,9.98,9.97,9.87,9.87,9.75,9.58,9.37,9.12,9,8.86,8.62,8.50,8.34,8.20,8.09,8,7.99,7.99,7.99,7.99,7.99,8,8,8,8,8,7.99,7.98,7.97,7.96,7.95,7.87,7.87,7.87,7.87,7.87,7.85,7.83,7.82,7.75,7.75,7.70,7.62,7.62,7.62,7.62,7.62,7.62,7.62,7.62,7.75,8,7,7,7,7,7,6.99,6.98,6,6,6,6.07,6,5.99,5.87,5.86,20.08,20.10,20.12,20.22,20.50,21.12,21.97,22.95,23.98,24.75,25.21,25.12,24.87,24.47,24.08,23.75,23.35,22.62,21.50,20.25,19.12,18.58,18.20,18,18.10,18.36,18.91,19.92,20.85,21.66,22.33,22.80,23.10,23.21,23.17,23.05,22.88,22.71,22.55,22.41,22.28,22.14,22,21.84,21.65,21.45,21.23,21,20.78,20.57,20.29,19.95,19.51,18.99,18.41,17.78,17.11,16.43,15.62,15.49,15.50,15.62,15.82,16.10,16.50,17.10,17.46,17.50,17.25,17.71,18.20,18.72,19.11,19.21,18.87,18.25,17.60,17.12,16.95,17.07,17.37,17.87,18.35,18.75,19.12,19.22,18.72,18.33,16.37,13.25,9.50,6.47,5.37,5.37,4.85,4.12,3.62,3.09,2.62,2.32,1.97,1.59,1.23,0.87,0.59,0.25,-0.05,-0.42,-0.80,-1.25,-1.67,-2.13,-2.38,-2.63,-2.66,-2.88,-2.90,-2.97,-3.11,-3.25,-3.46,-3.64,-3.85,-4.03,-4.23,-4.39,-4.58,-4.75,-4.98,-5.21,-5.41,-5.62,-5.83,-5.96,-6.02,-6.04,-6.01,-5.85,-5.66,-5.43,-5.17,-4.90,-4.62,-4.30,-4,-3.68,-3.40,-3.17,-3.04,-2.93,-2.88,-2.63,-2.25,-1.50,-0.88,-0.25,0.33,0.75,1.12,1.57,1.95,2,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5.84,6.12,6.25,6.50,7,7.59,8.12,8.72,9.37,10,10.57,10.75,10.75,10.60,10.37,10.12,9.87,9.62,9.45,9.25,9.12,9.12,9.25,9.50,9.83,10.12,10.37,10.61,10.84,11.08,11.36,11.70,12.07,12.45,12.83,13.12,13.37,13.60,13.60,13.37,13.21,13,12.98,13,12.98,12.85,12.58,12.25,12,11.87,11.71,11.58,11.46,11.34,11.24,11.12,11.12,11.10,11.11,11.11,11.12,11.08,11,10.97,10.87,10.75,10.58,10.37,10.20,10.09,10,9.99,9.98,9.97,9.95,9.87,9.75,9.58,9.37,9.12,9,8.85,8.62,8.50,8.34,8.20,8.09,8,7.99,7.98,7.98,7.98,7.98,7.98,7.99,7.98,7.98,7.98,7.97,7.96,7.95,7.87,7.87,7.86,7.82,7.75,7.75,7.72,7.62,7.62,7.61,7.58,7.50,7.46,7.37,7.37,7.36,7.34,7.33,7.33,7.33,7.33,7.12,7,7,7,7,7,7,7,6,6,6,6,6,5.99,5.87,5.87,4.87,18.07,18.87,19.10,19.25,19.96,20.62,21.62,22.75,23.83,24.82,25.37,25.59,25.36,24.98,24.50,24,23.37,22.50,21.34,19.96,18.85,18.37,18.21,18.12,18.20,18.50,19.13,20.32,21.33,22.21,22.92,23.42,23.71,23.77,23.67,23.47,23.22,22.97,22.73,22.53,22.35,22.20,22.03,21.88,21.71,21.52,21.35,21.17,21.02,20.87,20.66,20.36,19.95,19.47,18.95,18.33,17.67,16.96,16.36,15.87,16.12,16.37,16.62,16.87,17.22,17.97,18.75,18.32,17.98,17.87,18.22,18.75,19.35,19.62,19.82,18.96,18.12,17.50,17,17,17.50,17.97,18.37,18.60,18.37,17.74,17.12,16.37,13.12,8.50,6.47,5.45,4.34,3.34,3.12,2.57,1.60,1.37,1.09,0.86,0.62,0.33,0,-0.28,-0.55,-0.80,-1.13,-1.39,-1.67,-2.01,-2.38,-2.68,-2.80,-2.92,-2.91,-2.97,-3.03,-3.22,-3.37,-3.54,-3.75,-3.98,-4.17,-4.38,-4.55,-4.73,-4.88,-5.03,-5.23,-5.40,-5.58,-5.73,-5.88,-5.91,-5.97,-5.96,-5.88,-5.71,-5.52,-5.30,-5.04,-4.75,-4.43,-4.13,-3.83,-3.53,-3.29,-3.11,-2.98,-2.90,-2.63,-2.15,-1.50,-0.76,-0.13,0.50,1,1.37,1.62,1.97,2,3,3,3,3,4,3,3,4,5,4,4,4,5,5,5,6,6,7,7,7,7.62,7.62,7.73,7.84,8.21,8.61,9,9.37,9.84,10.25,10.62,10.75,10.75,10.61,10.37,10.23,10,9.75,9.50,9.34,9.20,9.12,9.25,9.49,9.75,10.09,10.37,10.62,10.87,11.20,11.50,11.96,12.37,12.86,13.25,13.62,13.87,14,13.95,13.70,13.37,13.12,13,13,12.96,12.75,12.50,12.24,11.98,11.75,11.58,11.37,11.32,11.22,11.12,11.10,11.08,11.08,11.09,11.11,11.10,11.07,11,10.97,10.87,10.75,10.58,10.37,10.20,10.09,10,9.99,9.98,9.97,9.95,9.87,9.75,9.58,9.37,9.20,9,8.85,8.62,8.50,8.34,8.20,8.09,8,7.99,7.98,7.98,7.98,7.98,7.98,7.98,7.98,7.97,7.96,7.95,7.87,7.87,7.87,7.82,7.74,7.62,7.62,7.57,7.50,7.46,7.37,7.37,7.34,7.25,7.23,7.12,7.12,7.07,7,7,7,7,7,7,7,7,7,7,6,6,6,6,6,6,6,6,5.95,5.87,5.09,4.87,17.87,18,18.10,18.87,19.25,20.35,21.37,22.50,23.62,24.71,25.58,25.87,25.82,25.37,24.87,24.36,23.62,22.62,21.45,20.11,19.09,18.50,18.50,18.47,18.59,18.95,19.60,20.86,21.92,22.84,23.58,24.09,24.33,24.32,24.13,23.84,23.51,23.17,22.88,22.61,22.39,22.20,22.03,21.87,21.71,21.55,21.41,21.29,21.21,21.11,20.93,20.67,20.32,19.97,19.49,18.96,18.37,17.73,16.87,16.58,16.87,17.36,17.60,17.70,18,18.75,19.75,19.20,18.50,18.22,18.22,19.09,19.75,20.23,20.20,19.72,18.95,18,17.72,17.62,17.87,18.49,18.82,18.62,18,17,15.70,13.62,10.50,7.99,5.74,4.25,3.21,2.37,1.75,1.12,0.50,-0.50,-0.50,-0.50,-0.63,-0.88,-1.05,-1.38,-1.55,-1.75,-1.89,-2.14,-2.38,-2.63,-2.80,-2.92,-3,-3,-3,-3.14,-3.26,-3.50,-3.72,-3.91,-4.13,-4.36,-4.54,-4.74,-4.90,-5.05,-5.22,-5.35,-5.48,-5.60,-5.67,-5.75,-5.80,-5.83,-5.80,-5.75,-5.65,-5.49,-5.30,-5.10,-4.86,-4.53,-4.23,-3.89,-3.62,-3.37,-3.17,-3.01,-2.88,-2.68,-2.16,-1.38,-0.63,0,0.62,1.12,1.75,2.10,2,2,3,3,3,3,4,4,4,4,5,5,5,5,5,5,6,6.99,7,8.95,9.07,9.87,9.11,9.12,9.25,9.25,9.25,9.37,9.62,9.75,10,10.25,10.50,10.75,10.87,10.86,10.71,10.50,10.25,10.10,9.86,9.62,9.37,9.23,9.12,9.25,9.45,9.71,10,10.25,10.57,10.86,11.21,11.60,12,12.50,13,13.37,13.74,13.87,13.99,13.86,13.60,13.25,13,12.87,12.84,12.75,12.62,12.37,12.10,11.84,11.62,11.37,11.25,11.21,11.12,11.08,11,11,11,11,11.07,11,11,11,10.96,10.87,10.75,10.58,10.37,10.20,10.09,10,9.99,9.98,9.97,9.95,9.87,9.75,9.58,9.37,9.12,9,8.84,8.62,8.49,8.33,8.12,8.09,8,7.99,7.98,7.97,7.97,7.97,7.97,7.97,7.97,7.96,7.95,7.87,7.87,7.85,7.75,7.70,7.60,7.50,7.37,7.36,7.25,7.25,7.21,7.12,7.12,7.11,7.08,7,7,7,6.99,6.98,6.99,6.99,7,7,7,7,7,6,6,6,6,6,6,5.99,5.99,5.95,5.87,5.08,5.09,4.87,17,17.07,17.87,18.10,19.12,20.12,21.25,22.37,23.47,24.50,25.48,26,26.08,25.70,25.25,24.73,24,23.12,22,20.83,19.75,19.20,19,19.12,19.35,19.75,20.37,21.58,22.61,23.52,24.29,24.79,24.93,24.79,24.50,24.12,23.71,23.30,22.95,22.64,22.36,22.14,21.96,21.78,21.64,21.51,21.40,21.32,21.27,21.21,21.08,20.87,20.65,20.36,20.02,19.64,19.18,18.64,18.04,17,17.99,18.50,18.87,18.62,18.12,19.50,20.75,19.95,19.20,18.20,19,19.62,20.37,20.87,20.96,20.58,19.87,19.25,18.75,17.95,18.87,19.50,19.74,19.22,17.87,16.35,14.37,12.48,9.22,6.62,4.62,3.22,2.12,1.35,0.62,0,-0.63,-1.15,-1.52,-1.64,-1.65,-1.75,-2,-2.13,-2.28,-2.38,-2.50,-2.63,-2.75,-2.88,-2.90,-3,-3.10,-3.21,-3.35,-3.50,-3.72,-3.92,-4.13,-4.38,-4.59,-4.77,-4.97,-5.13,-5.27,-5.41,-5.53,-5.64,-5.71,-5.73,-5.74,-5.74,-5.72,-5.64,-5.60,-5.50,-5.38,-5.21,-5.01,-4.83,-4.55,-4.27,-3.97,-3.63,-3.37,-3.16,-3.04,-2.93,-2.75,-2.63,-1.40,-0.53,0.33,0.87,1.33,1.75,2.22,2.97,3,3,3,3,4,4,4,4,4,5,5,5,6,6,6,6,7,7,8.87,10.87,11.87,10.85,10.12,10.57,10.73,10.75,10.75,10.62,10.58,10.50,10.50,10.62,10.87,11,11.11,11,10.84,10.60,10.36,10.12,9.87,9.62,9.37,9.25,9.12,9.23,9.37,9.61,9.87,10.12,10.37,10.75,11.12,11.50,11.98,12.45,12.87,13.24,13.48,13.60,13.60,13.47,13.24,12.99,12.75,12.62,12.50,12.48,12.34,12.12,11.87,11.62,11.47,11.32,11.21,11.12,11.08,11,11,11,11,11,11,11,11,10.99,10.96,10.87,10.75,10.58,10.37,10.20,10.09,10,9.99,9.98,9.97,9.95,9.87,9.75,9.58,9.37,9.12,8.99,8.82,8.62,8.47,8.32,8.12,8.09,8,7.99,7.98,7.97,7.97,7.97,7.97,7.97,7.96,7.95,7.87,7.87,7.84,7.75,7.62,7.50,7.37,7.33,7.25,7.20,7.12,7.10,7,7,6.99,6.98,6.97,6.96,6.96,6.96,6.87,6.87,6.95,6.99,7,6.99,7,7,6,6,6,6,6,5.99,5.98,5.87,5.87,5.87,5.10,5.11,5,4.87,17,17.07,17.87,18.09,19,20.09,21.20,22.24,23.25,24.10,25.07,25.95,26.10,25.87,25.59,25.12,24.57,23.75,22.75,21.62,20.62,20,19.75,20,20.37,20.87,21.37,22.41,23.37,24.24,24.98,25.40,25.42,25.16,24.74,24.25,23.77,23.32,22.90,22.55,22.26,22.02,21.83,21.65,21.51,21.42,21.33,21.24,21.22,21.30,21.13,20.96,20.80,20.65,20.50,20.33,20.07,19.74,19.25,18.86,19.09,19.97,19.87,19.57,19.48,19.87,20.84,20.84,19.86,19.60,19.84,20.50,21.25,21.75,21.87,21.59,21,20.50,20,19.87,20.12,21.12,21.21,20.25,17.34,15.37,12.50,9.95,7.50,5.25,3.37,2.11,1.11,0.34,-0.38,-1.01,-1.63,-2.01,-2.63,-2.40,-2.40,-2.50,-2.63,-2.63,-2.75,-2.75,-2.78,-2.88,-2.91,-2.96,-3.01,-3.10,-3.25,-3.43,-3.66,-3.90,-4.13,-4.38,-4.63,-4.87,-5.08,-5.25,-5.39,-5.53,-5.65,-5.75,-5.85,-5.92,-5.87,-5.79,-5.75,-5.65,-5.55,-5.43,-5.35,-5.23,-5.09,-4.88,-4.67,-4.47,-4.24,-3.96,-3.65,-3.37,-3.13,-2.99,-2.88,-2.88,-2.76,-1.38,-0.65,0.62,1.07,1.75,1.87,2,3,3,3,3,4,4,4,5,5,5,5,5,6,6,6,7,7,7.97,8,9.08,10,10.95,11.83,11.75,11.75,11.72,12,12.12,12.10,11.75,11.37,11.10,10.98,11,11.12,11.25,11.25,11.12,10.87,10.62,10.36,10.11,9.87,9.62,9.37,9.25,9.12,9.21,9.32,9.50,9.73,9.99,10.25,10.60,10.96,11.36,11.75,12.20,12.57,12.85,13,13.11,13.08,12.97,12.75,12.61,12.37,12.25,12.21,12.12,12,11.85,11.62,11.48,11.34,11.23,11.12,11.10,11.07,11,11,11,11,11,11,11,11,10.98,10.96,10.87,10.75,10.58,10.37,10.20,10.09,10,9.99,9.98,9.97,9.95,9.87,9.74,9.57,9.36,9.12,8.96,8.75,8.60,8.37,8.25,8.12,8.08,8,7.99,7.97,7.97,7.96,7.96,7.96,7.95,7.95,7.87,7.87,7.84,7.75,7.62,7.50,7.37,7.25,7.20,7.12,7.08,7,6.99,6.95,6.87,6.86,6.84,6.83,6.84,6.85,6.83,6.75,6.72,6.62,6.70,6.85,7,6.99,6,6,6,6,6,5.99,5.98,5.87,5.87,5.09,5.10,5.11,5,4.98,4.87,16.99,17,17.87,18.08,19.10,20.10,21.12,22.12,22.84,23.45,24.25,25.25,26,26.12,25.87,25.50,25,24.48,23.47,22.32,21.35,20.74,20.50,20.98,21.60,22.11,22.59,23.28,24.08,24.86,25.50,25.83,25.72,25.32,24.79,24.21,23.66,23.16,22.73,22.35,22.03,21.77,21.57,21.40,21.28,21.18,21.08,21,20.98,21.05,20.92,20.83,20.78,20.80,20.88,20.96,21.09,20.89,20.64,20.25,19.97,20.37,20.97,20.33,20.09,20.12,20.58,20.62,20.48,20.37,20.75,21.37,22.20,22.96,22.98,22.37,22.07,21.50,21.32,21.12,21.12,21.22,20.25,18.25,16.36,13.37,10.12,7.62,5.48,3.71,2.24,1,0.12,-0.63,-1.25,-1.88,-2.75,-2.75,-2.75,-2.88,-2.88,-2.91,-2.88,-2.88,-2.89,-2.91,-2.91,-2.97,-3.01,-3.10,-3.21,-3.36,-3.55,-3.79,-4.05,-4.34,-4.60,-4.86,-5.12,-5.37,-5.58,-5.74,-5.87,-5.97,-6.03,-6.03,-6.04,-6.01,-5.93,-5.80,-5.68,-5.53,-5.37,-5.22,-5.05,-4.91,-4.75,-4.55,-4.34,-4.11,-3.87,-3.62,-3.37,-3.14,-2.97,-2.84,-2.79,-2.40,-1.63,-0.75,0.73,0.87,1.75,1.97,2,3,3,4,4,4,4,5,5,5,6,6,6,6,7,7,7,7.99,8,8.95,9.87,10.87,11,11.20,11.75,11.97,12.12,12.47,13.10,12.96,12.75,12.32,11.75,11.45,11.25,11.23,11.25,11.36,11.33,11.12,10.87,10.59,10.32,10.07,9.84,9.61,9.37,9.25,9.12,9.12,9.24,9.37,9.60,9.83,10.11,10.37,10.75,11.12,11.50,11.87,12.20,12.37,12.58,12.62,12.60,12.50,12.37,12.22,12.07,11.95,11.85,11.75,11.62,11.57,11.37,11.32,11.23,11.12,11.12,11.11,11.09,11,11,11,11,11,11,11,10.99,10.98,10.96,10.87,10.75,10.58,10.37,10.20,10.09,10,9.99,9.98,9.97,9.87,9.85,9.71,9.50,9.32,9.11,8.87,8.71,8.50,8.37,8.25,8.12,8.07,8,7.98,7.97,7.96,7.96,7.95,7.95,7.87,7.87,7.87,7.83,7.75,7.62,7.50,7.37,7.25,7.12,7.09,7,6.99,6.96,6.87,6.84,6.75,6.70,6.62,6.62,6.62,6.62,6.59,6.50,6.37,6.37,6.24,6.09,6,6,6,6,6,6,5.99,5.97,5.87,5.87,5.12,5.12,5,5,5,4.97,4.87,16.98,16.96,17,18.87,19.87,20.87,21.87,21.85,22.70,22.50,22.60,24.62,26.12,26.45,26.25,25.86,25.35,24.73,23.75,22.72,21.83,21.20,21.24,21.99,22.84,23.62,23.62,24.09,24.65,25.27,25.80,25.99,25.76,25.23,24.61,23.97,23.38,22.85,22.39,22.01,21.68,21.42,21.22,21.05,20.91,20.78,20.68,20.60,20.57,20.63,20.54,20.52,20.58,20.73,21.01,21.49,21.80,22.11,21.93,21.73,21.07,20.87,21,20.75,20.60,20.62,20.74,20.83,20.87,21.08,21.59,22.24,23,24,23.34,23.08,22.25,22.12,22.12,22.20,21.23,19.37,17.60,15.37,12.59,9.97,7.24,4.97,3.45,2.22,1.11,0.12,-0.66,-1.41,-1.91,-2.38,-2.91,-2.93,-3,-3,-3,-3,-3,-3,-3,-2.99,-3,-3.05,-3.13,-3.26,-3.41,-3.62,-3.87,-4.15,-4.47,-4.76,-5.05,-5.33,-5.59,-5.85,-6.04,-6.21,-6.29,-6.36,-6.28,-6.25,-6.15,-6.08,-5.91,-5.75,-5.59,-5.38,-5.14,-4.93,-4.76,-4.60,-4.41,-4.23,-3.99,-3.74,-3.50,-3.28,-3.10,-2.91,-2.77,-2.66,-2.43,-1.88,-1.13,0,0.72,1,2,2,3,3,4,5,6,6,6,6,6,6,6,7,7,7,8,8,8,8.96,9.08,10,10.97,11.84,12,12,11.95,12,12.25,12.62,13.09,13,12.75,12.25,11.87,11.50,11.35,11.25,11.25,11.25,11.23,11,10.75,10.50,10.24,10,9.75,9.59,9.37,9.24,9.12,9.12,9.12,9.25,9.47,9.62,9.95,10.24,10.57,10.87,11.25,11.61,11.87,12.09,12.20,12.24,12.21,12.12,11.99,11.86,11.73,11.61,11.50,11.37,11.37,11.25,11.24,11.12,11.12,11.12,11.12,11.12,11.12,11.10,11,11,11,11,11,11,10.99,10.98,10.96,10.87,10.75,10.58,10.37,10.20,10.09,10,9.99,9.97,9.95,9.87,9.75,9.62,9.46,9.24,9,8.83,8.62,8.47,8.33,8.20,8.11,8,8,7.98,7.97,7.96,7.95,7.87,7.87,7.87,7.87,7.82,7.74,7.62,7.50,7.37,7.25,7.12,7.09,7,6.98,6.87,6.87,6.75,6.71,6.60,6.50,6.37,6.37,6.37,6.36,6.33,6.25,6.12,6.07,6,6,6,6,6,6,6,5.99,5.97,5.87,5.87,5.12,5.12,5,5,5,4.99,4.97,4.86,16,16,16.96,17,18.07,19.87,19.87,20.10,20.87,20.25,22.37,24.36,25.96,27.25,26.50,26.08,25.46,24.75,23.87,22.99,22,21.62,22.09,23,23.87,24.46,24.60,24.74,25.05,25.46,25.77,25.80,25.46,24.84,24.20,23.54,22.93,22.40,21.93,21.54,21.21,20.95,20.73,20.53,20.37,20.23,20.12,20.03,20,20.05,20,20.01,20.12,20.37,20.83,21.43,22.32,22.78,23.10,22.71,21.50,20.97,20.87,20.87,21.08,21.11,21.12,21.12,21.34,21.75,22.37,23.07,23.49,24.08,23.11,22.21,22.12,21.21,21.23,21.25,20.25,17.50,15.37,12.61,9.50,6.50,4.20,2.62,1.75,0.98,0.12,-0.54,-1.25,-2,-2.50,-2.63,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3.03,-3.10,-3.18,-3.33,-3.50,-3.68,-3.91,-4.21,-4.51,-4.86,-5.17,-5.50,-5.77,-6.04,-6.29,-6.50,-6.60,-6.62,-6.59,-6.48,-6.30,-6.17,-6.01,-5.83,-5.62,-5.40,-5.16,-4.89,-4.65,-4.43,-4.25,-4.08,-3.88,-3.67,-3.48,-3.26,-3.10,-2.93,-2.76,-2.63,-2.38,-1.92,-1.38,-0.63,0.20,0.99,2,2,3,4,4,5,6,8,8,8,8,7,7,7,8,8,8,9.96,9.11,9.20,9.72,10.20,10.95,11.86,12.49,13.45,12.37,12,11.99,12.12,12.36,12.50,12.50,12.32,12,11.73,11.47,11.25,11.23,11.20,11.12,11,10.87,10.62,10.37,10.12,9.96,9.75,9.57,9.37,9.23,9.12,9.10,9.12,9.22,9.37,9.58,9.84,10.12,10.37,10.75,11.09,11.37,11.62,11.82,11.87,11.87,11.87,11.75,11.62,11.50,11.37,11.32,11.22,11.12,11.11,11.09,11.09,11.09,11.11,11.12,11.12,11.12,11.12,11.12,11.11,11.07,11,11,11,11,10.99,10.98,10.96,10.87,10.75,10.58,10.37,10.20,10.08,10,9.98,9.96,9.87,9.85,9.74,9.58,9.37,9.12,8.87,8.72,8.50,8.37,8.25,8.12,8.08,8,7.99,7.97,7.96,7.95,7.87,7.87,7.87,7.85,7.75,7.73,7.62,7.50,7.37,7.25,7.12,7.09,7,6.98,6.87,6.87,6.75,6.62,6.57,6.37,6.33,6.25,6.12,6.12,6.12,6.11,6.09,6,6,6,6,6,5.99,5.98,5.97,5.97,5.96,5.85,5.85,5.12,5.12,5,5,5,5,4.98,4.95,4.85,16,16,16,16,16.95,17.07,18,18.09,19,20.11,22.12,24.70,26.12,26.62,26.50,26.07,25.60,24.75,24.25,23.47,22.75,22.08,23.37,24.25,24.95,25.23,25.25,25.26,25.28,25.36,25.40,25.24,24.77,24.15,23.50,22.86,22.28,21.76,21.32,20.92,20.59,20.30,20.05,19.85,19.67,19.52,19.39,19.30,19.29,19.28,19.25,19.28,19.42,19.70,20.13,20.79,21.90,22.36,23.20,23.11,21.20,20.47,20.36,21.11,21.10,22.07,21.32,21.25,21.71,22.37,23.21,24.09,24.11,22.46,21.58,21.21,19.37,18.50,18.25,18.25,16.59,15.37,13.37,10.49,6.46,3.37,2.37,1.50,0.87,0.25,-0.39,-1,-1.53,-2.25,-2.38,-2.55,-2.75,-2.88,-2.92,-3,-3,-3,-3,-3,-3.03,-3.13,-3.26,-3.43,-3.63,-3.83,-4.03,-4.28,-4.55,-4.88,-5.23,-5.59,-5.90,-6.21,-6.49,-6.75,-6.86,-6.88,-6.85,-6.75,-6.52,-6.29,-6.10,-5.88,-5.63,-5.39,-5.16,-4.90,-4.62,-4.33,-4.11,-3.90,-3.74,-3.58,-3.40,-3.25,-3.11,-2.96,-2.80,-2.63,-2.38,-2,-1.51,-0.92,-0.38,0.45,1.32,2,3,4,5,6,7,6,8,11,12,11,10,9,9,10,10,9.99,10,10.09,10.09,10.33,10.83,11.45,12.32,13.25,12.50,12.25,11.87,11.75,11.84,11.95,12,12,11.87,11.70,11.50,11.33,11.21,11.12,11.08,11,10.87,10.73,10.50,10.32,10.11,9.87,9.74,9.57,9.37,9.23,9.12,9.09,9.10,9.12,9.34,9.50,9.75,10.07,10.37,10.62,10.98,11.25,11.48,11.62,11.72,11.73,11.62,11.57,11.37,11.25,11.12,11,10.96,10.87,10.87,10.87,10.97,11,11.08,11.12,11.12,11.23,11.25,11.25,11.21,11.12,11.09,11,11,11,10.99,10.98,10.96,10.87,10.75,10.58,10.37,10.20,10.08,10,9.97,9.87,9.87,9.75,9.62,9.46,9.25,9,8.75,8.61,8.37,8.25,8.12,8.10,8,8,7.98,7.97,7.96,7.87,7.87,7.87,7.85,7.75,7.72,7.62,7.50,7.37,7.25,7.12,7.10,7,6.98,6.87,6.87,6.75,6.62,6.50,6.37,6.25,6.12,6.11,6.07,6,6,6,6,6,5.99,6,6,5.99,5.97,5.87,5.86,5.85,5.84,5.83,5.12,5.12,5,5,5,5,4.98,4.96,4.82,4.83,16,16,15.99,15.98,15,15.95,16.07,16.87,17.09,19,21.87,25.87,26.82,26.72,25.75,25.87,25.87,25.50,24.87,24.20,23.75,23.97,24.84,25.62,26.12,26.12,25.96,25.74,25.28,24.95,24.66,24.28,23.76,23.15,22.53,21.93,21.39,20.91,20.49,20.12,19.79,19.50,19.25,19.03,18.84,18.66,18.52,18.42,18.39,18.30,18.26,18.30,18.43,18.70,19.10,19.71,20.52,20.91,21.04,21.12,19.98,19.35,19.25,19.62,21.12,21.12,21.12,21.12,21.35,23.11,24.12,24.12,22.21,20.35,19.25,18.25,16.37,14.62,14.45,14.37,13,11.50,9.62,6.96,2.37,2.33,1.50,1,0.50,-0.04,-0.63,-1.13,-1.50,-1.79,-2.13,-2.38,-2.55,-2.67,-2.79,-2.89,-3,-3,-3,-3.03,-3.14,-3.29,-3.50,-3.72,-3.92,-4.14,-4.37,-4.62,-4.89,-5.24,-5.58,-5.92,-6.27,-6.55,-6.85,-7.04,-7.12,-7.08,-6.97,-6.76,-6.49,-6.18,-5.91,-5.63,-5.37,-5.11,-4.85,-4.58,-4.28,-4,-3.75,-3.53,-3.38,-3.26,-3.13,-3.03,-2.98,-2.88,-2.71,-2.50,-2.13,-1.64,-1.13,-0.50,0.12,0.87,1.73,3,3,4,5,7,8,7,8,11,15,16,14,14,12.87,12.84,11.87,11.32,10.87,10.75,10.71,10.82,11.08,11.47,11.87,12.11,12.08,11.84,11.62,11.50,11.50,11.59,11.62,11.61,11.50,11.37,11.25,11.12,11.10,11,10.98,10.87,10.75,10.62,10.37,10.25,10.08,9.87,9.73,9.50,9.37,9.24,9.12,9.10,9.12,9.21,9.36,9.50,9.75,10.08,10.36,10.62,10.87,11.12,11.35,11.48,11.50,11.50,11.48,11.37,11.23,11.09,10.96,10.85,10.75,10.62,10.71,10.75,10.87,10.98,11,11.12,11.20,11.25,11.34,11.36,11.34,11.25,11.12,11.10,11,11,11,10.99,10.96,10.87,10.75,10.58,10.37,10.20,10.08,9.99,9.87,9.87,9.75,9.62,9.50,9.32,9.10,8.87,8.62,8.48,8.33,8.21,8.12,8.07,8,7.99,7.97,7.96,7.95,7.87,7.87,7.85,7.75,7.72,7.62,7.50,7.37,7.25,7.12,7.10,7,6.98,6.87,6.87,6.75,6.62,6.50,6.37,6.25,6.12,6.10,6,6,6,5.99,5.99,5.99,5.99,5.98,5.99,5.99,5.97,5.87,5.85,5.12,5.12,5.12,5.12,5.12,5,5,5,5,4.98,4.96,4.84,4.75,3.75,17,16,15,14.99,14,14,14.95,15.07,15.87,17.08,19.09,21.87,23.87,23.87,24.12,25.75,26.72,26.61,25.50,24.75,24.37,24.82,25.87,26.86,27.25,27.12,26.71,26.09,25.04,24.14,23.55,23.03,22.48,21.92,21.37,20.84,20.35,19.91,19.52,19.17,18.86,18.58,18.33,18.10,17.88,17.70,17.53,17.45,17.30,17.20,17.14,17.15,17.25,17.47,17.79,18.21,18.73,18.95,18.96,18.62,18.12,17.71,17.62,17.85,18.37,19.23,19.21,19.21,20.21,21.23,21.23,20.24,18.50,17.37,16.35,15.37,13.12,10.59,10.57,10.12,9.34,8.25,6.37,4.48,2.49,1.75,1.20,0.72,0.25,-0.17,-0.63,-1,-1,-1.25,-1.75,-2.03,-2.26,-2.43,-2.63,-2.76,-2.89,-3,-3.01,-3.12,-3.26,-3.50,-3.75,-4,-4.22,-4.42,-4.64,-4.89,-5.18,-5.52,-5.87,-6.23,-6.54,-6.79,-7.09,-7.23,-7.23,-7.11,-6.91,-6.64,-6.30,-5.98,-5.65,-5.35,-5.02,-4.75,-4.48,-4.22,-3.96,-3.71,-3.48,-3.29,-3.18,-3.11,-3.04,-2.99,-2.91,-2.78,-2.63,-2.25,-1.80,-1.30,-0.75,-0.13,0.59,1.25,2.09,3,4,4,5,7,8,9,9,14,18,18,17.99,16.87,15.75,14.62,13.47,12.37,11.75,11.37,11.20,11.12,11.20,11.36,11.50,11.61,11.58,11.49,11.37,11.25,11.25,11.25,11.34,11.33,11.25,11.23,11.12,11.09,11,10.98,10.87,10.84,10.72,10.57,10.37,10.22,10,9.87,9.73,9.57,9.37,9.25,9.12,9.12,9.12,9.25,9.37,9.62,9.87,10.12,10.37,10.62,10.87,11.08,11.23,11.34,11.37,11.37,11.25,11.12,11,10.87,10.75,10.62,10.60,10.50,10.58,10.62,10.84,10.95,11,11.11,11.22,11.33,11.37,11.49,11.48,11.37,11.25,11.21,11.12,11.07,11,11,10.97,10.87,10.75,10.58,10.37,10.20,10.07,9.97,9.87,9.75,9.62,9.50,9.36,9.12,8.87,8.71,8.50,8.36,8.22,8.12,8.07,8,7.99,7.98,7.96,7.95,7.87,7.87,7.86,7.75,7.73,7.62,7.50,7.37,7.25,7.20,7.11,7,6.98,6.87,6.87,6.75,6.62,6.50,6.37,6.25,6.12,6.11,6,6,5.99,5.98,5.98,5.98,5.97,5.97,5.98,5.96,5.95,5.85,5.85,5.12,5.12,5,5,5,5,4.98,4.95,4.95,4.95,4.87,4.83,4.75,4.23,3.75,19,17,14,14,14,13.98,13.97,13,14,15.07,16.07,18.08,19.09,20.09,21.10,24.87,26.84,26.62,26.50,24.37,24.25,24.50,26,27.97,27.87,27.85,26.75,25.62,24.03,22.90,22.10,21.53,21.02,20.53,20.05,19.61,19.18,18.80,18.45,18.13,17.83,17.55,17.30,17.07,16.85,16.64,16.50,16.30,16.14,16.01,15.92,15.89,15.92,16.04,16.25,16.52,16.86,17.02,16.99,16.62,15.85,15.82,15.71,15.82,16.24,16.21,16.12,15.99,15.70,16.24,16.12,14.62,14.75,14,13.07,11.74,9.50,8.50,7.50,6.46,5.45,5.37,5.50,3.60,2.32,1.37,0.75,0.37,0,-0.38,-0.63,-0.64,-1,-1.17,-1.50,-1.75,-2,-2.18,-2.39,-2.63,-2.80,-2.97,-3.11,-3.25,-3.47,-3.71,-3.97,-4.21,-4.42,-4.65,-4.88,-5.12,-5.40,-5.75,-6.08,-6.40,-6.71,-6.89,-7.10,-7.14,-7.09,-6.92,-6.68,-6.38,-6.01,-5.66,-5.35,-5,-4.65,-4.37,-4.10,-3.85,-3.63,-3.42,-3.26,-3.14,-3.08,-3.02,-3,-2.96,-2.89,-2.75,-2.38,-1.93,-1.50,-0.92,-0.38,0.25,0.96,1.62,2.32,3,4,5,6,7,8,9,11,16,18,18.95,17.12,16.62,15.72,14.86,14.12,13,12.36,11.87,11.50,11.34,11.25,11.24,11.25,11.25,11.25,11.23,11.12,11.12,11.10,11.12,11.12,11.12,11.12,11.10,11.07,11,10.99,10.95,10.87,10.75,10.62,10.50,10.37,10.21,10,9.87,9.74,9.58,9.37,9.25,9.21,9.20,9.25,9.37,9.50,9.75,9.99,10.22,10.46,10.62,10.86,11,11.12,11.12,11.21,11.12,11.12,11,10.87,10.75,10.62,10.50,10.45,10.37,10.50,10.62,10.75,10.87,11,11.11,11.24,11.37,11.50,11.60,11.62,11.50,11.46,11.34,11.23,11.12,11.10,11,10.99,10.87,10.75,10.50,10.36,10.12,10,9.87,9.83,9.70,9.50,9.37,9.12,8.96,8.74,8.50,8.37,8.24,8.12,8.07,8,8,7.98,7.97,7.96,7.87,7.87,7.87,7.82,7.74,7.62,7.50,7.37,7.25,7.21,7.11,7,6.98,6.87,6.87,6.75,6.70,6.57,6.37,6.25,6.20,6.11,6,6,5.99,5.98,5.97,5.97,5.97,5.96,5.95,5.87,5.87,5.75,5.82,5.20,5.12,5,5,5,4.98,4.96,4.84,4.75,4.75,4.75,4.75,4.75,4.25,4.10,3.75,21,18,16,14,13,13.99,13,12.98,12,13,14,15,16.07,16.07,18.87,20.86,22.62,23.50,23.37,22.25,21.58,22,23.87,24.84,26.75,26.72,25.62,23.24,21.88,20.93,20.36,19.86,19.43,19.04,18.66,18.29,17.95,17.61,17.30,17.01,16.73,16.47,16.22,15.99,15.76,15.55,15.34,15.12,14.93,14.77,14.64,14.54,14.50,14.52,14.60,14.76,14.99,15.23,15.24,15.12,14.37,13.97,13.75,13.62,13.60,13.45,13.12,12.62,11.61,12.21,11.57,11.50,11.23,10.49,10.50,8.46,7.45,6.37,5.37,4.35,3.33,3.36,3.37,2.62,1.60,0.75,0.21,-0.14,-0.40,-0.63,-0.75,-0.88,-0.90,-1.14,-1.38,-1.63,-1.88,-2.02,-2.25,-2.50,-2.76,-2.98,-3.14,-3.36,-3.61,-3.88,-4.13,-4.38,-4.60,-4.78,-5.02,-5.25,-5.54,-5.84,-6.12,-6.39,-6.60,-6.75,-6.87,-6.88,-6.75,-6.60,-6.33,-6,-5.63,-5.29,-4.98,-4.63,-4.29,-3.97,-3.67,-3.47,-3.29,-3.17,-3.09,-3,-3,-2.98,-2.93,-2.90,-2.77,-2.50,-2.02,-1.55,-1.03,-0.50,0.11,0.72,1.32,1.96,2.97,3,4,5,6,7,8,10,12,16,17.87,17.25,16.87,16.12,15.50,14.83,14,13.34,12.71,12.21,11.75,11.48,11.25,11.12,11.12,11.12,11.11,11.09,11.07,11,11,11,11,11,11,11,11,11,10.97,10.87,10.87,10.75,10.62,10.50,10.36,10.20,10,9.87,9.75,9.60,9.47,9.35,9.25,9.25,9.37,9.50,9.62,9.87,10.11,10.32,10.50,10.70,10.84,10.95,11,11,11,11,10.95,10.85,10.73,10.61,10.50,10.37,10.34,10.37,10.50,10.62,10.82,10.87,11,11.11,11.25,11.37,11.58,11.70,11.73,11.70,11.60,11.49,11.37,11.25,11.21,11.12,11,10.87,10.73,10.50,10.33,10.12,9.99,9.86,9.72,9.57,9.37,9.12,8.97,8.75,8.57,8.37,8.25,8.12,8.08,8,8,7.98,7.97,7.96,7.95,7.87,7.87,7.84,7.75,7.62,7.57,7.45,7.33,7.22,7.12,7,6.99,6.87,6.86,6.75,6.70,6.58,6.46,6.33,6.21,6.12,6,6,6,5.98,5.97,5.96,5.96,5.95,5.87,5.87,5.82,5.73,5.75,5.23,5.12,5.07,5,4.99,4.98,4.96,4.83,4.75,4.25,4.25,4.25,4.25,4.25,4.12,3.98,3.75,22,19,16,14,13,13,12,12,12,12,12,13.96,13,14.95,15.87,17.25,18.25,18.85,18.75,18.62,18,18.59,19.12,20.87,21.75,22.12,21.48,20.37,19.15,18.77,18.37,18.08,17.78,17.49,17.21,16.92,16.65,16.37,16.11,15.85,15.60,15.35,15.11,14.88,14.65,14.41,14.17,13.96,13.75,13.54,13.37,13.21,13.07,12.95,12.91,12.95,13.09,13.46,14.12,13.12,12.62,12.12,11.85,11.50,11.22,10.62,10.35,9.59,9.35,9,8.47,8.46,8.37,8.12,7.37,6.62,5.62,5.62,3.32,2.25,2.24,2.25,2.37,1.62,0.70,-0.18,-0.53,-0.88,-1,-1.01,-1,-0.92,-1,-1.16,-1.38,-1.63,-1.78,-2,-2.25,-2.50,-2.76,-3,-3.23,-3.46,-3.72,-3.99,-4.24,-4.47,-4.67,-4.88,-5.10,-5.30,-5.55,-5.80,-6.08,-6.28,-6.42,-6.50,-6.52,-6.49,-6.35,-6.13,-5.85,-5.51,-5.17,-4.87,-4.58,-4.26,-3.96,-3.65,-3.41,-3.25,-3.13,-3.05,-3,-2.98,-2.96,-2.91,-2.88,-2.75,-2.50,-2.13,-1.63,-1.13,-0.55,0,0.60,1.12,1.75,2,3,4,5,6,7,7,9,11,12,15.09,16.75,16.95,16.37,15.83,15.20,14.58,13.97,13.37,12.86,12.37,11.87,11.50,11.25,11.12,11.07,11,11,11,11,11,11,11,11,11,11,11,11,10.99,10.97,10.87,10.87,10.75,10.62,10.50,10.35,10.20,10,9.87,9.75,9.62,9.50,9.45,9.37,9.37,9.50,9.62,9.84,10,10.22,10.37,10.58,10.72,10.82,10.87,10.87,10.87,10.87,10.87,10.75,10.62,10.58,10.47,10.37,10.32,10.25,10.37,10.50,10.72,10.82,10.87,10.99,11.11,11.25,11.47,11.62,11.75,11.75,11.75,11.72,11.62,11.50,11.37,11.33,11.21,11,10.87,10.62,10.47,10.25,10.08,9.87,9.75,9.58,9.37,9.12,8.97,8.75,8.57,8.37,8.25,8.12,8.09,8,8,7.99,7.98,7.97,7.96,7.87,7.87,7.86,7.75,7.70,7.59,7.47,7.35,7.24,7.12,7,6.99,6.87,6.86,6.75,6.70,6.59,6.47,6.35,6.23,6.12,6.07,6,6,5.98,5.97,5.97,5.96,5.87,5.87,5.87,5.75,5.62,5.50,5.25,5.21,5.09,5,4.99,4.96,4.95,4.83,4.73,4.25,4.12,4,4,4,4,3.98,3.75,3.73,23,20,17,15,13,12,12,12,12,11,11,11,11.99,12,13.23,14.10,14.59,14.75,15.37,15.47,15.37,15.24,16,16.87,17.75,18.12,18,17.50,16.87,16.66,16.45,16.27,16.09,15.93,15.75,15.55,15.35,15.13,14.90,14.67,14.46,14.23,14,13.77,13.53,13.29,13.07,12.84,12.61,12.38,12.15,11.91,11.67,11.41,11.22,11.09,11.05,11.37,11.45,11.23,10.75,10.37,10,9.58,9.07,8.50,7.87,7.34,6.87,6.37,6.25,6.10,5.87,5.74,5.74,4.25,3.24,2.23,2.22,2.12,2,1.87,1.50,0.85,-0.25,-0.88,-1.38,-1.65,-1.75,-1.66,-1,-1.03,-1.13,-1.28,-1.50,-1.66,-1.88,-2.13,-2.30,-2.62,-2.86,-3.08,-3.29,-3.53,-3.79,-4.04,-4.28,-4.50,-4.68,-4.88,-5.09,-5.27,-5.48,-5.67,-5.88,-6.02,-6.12,-6.14,-6.14,-6.08,-5.88,-5.63,-5.30,-4.99,-4.66,-4.40,-4.14,-3.88,-3.63,-3.39,-3.23,-3.12,-3.03,-2.99,-2.93,-2.90,-2.86,-2.80,-2.64,-2.38,-2.02,-1.50,-1,-0.50,0,0.59,1.12,1.75,2,3,3,4,5,8,9,10,10,13,14.11,16.61,17.36,16.70,16.11,15.47,14.87,14.32,13.82,13.34,12.87,12.45,11.99,11.60,11.32,11.12,11,11,11,11,11,11,11,11,11,11,11,11,11,11,10.99,10.95,10.87,10.75,10.62,10.50,10.35,10.20,10,9.87,9.82,9.72,9.62,9.57,9.50,9.60,9.70,9.84,10,10.12,10.33,10.48,10.61,10.71,10.75,10.75,10.82,10.75,10.75,10.72,10.62,10.50,10.37,10.35,10.25,10.21,10.25,10.37,10.57,10.74,10.75,10.85,10.96,11.12,11.25,11.50,11.62,11.75,11.84,11.84,11.75,11.73,11.62,11.50,11.37,11.25,11.08,10.85,10.61,10.37,10.12,9.98,9.75,9.61,9.37,9.12,8.96,8.75,8.50,8.37,8.25,8.12,8.09,8,8,7.99,7.98,7.98,7.97,7.96,7.87,7.87,7.83,7.74,7.62,7.50,7.37,7.25,7.12,7.07,6.99,6.87,6.87,6.75,6.71,6.60,6.49,6.37,6.25,6.12,6.08,6,6,5.99,5.97,5.97,5.96,5.87,5.87,5.87,5.75,5.62,5.50,5.37,5.22,5.10,5,4.98,4.95,4.87,4.75,4.71,4.25,4.12,4,4,4,3.98,3.95,3.83,3.73,2.73,24,22,19,15,14,13,12,12,11,10,10,10,10,11,11.37,11.50,12.12,12.62,12.99,13.32,13.34,13.47,13.75,14.36,14.87,15.12,15.25,15.12,14.87,14.77,14.62,14.50,14.45,14.37,14.29,14.18,14.04,13.88,13.71,13.52,13.33,13.12,12.91,12.71,12.48,12.25,12.02,11.79,11.55,11.32,11.04,10.74,10.35,10.01,9.61,9.24,8.85,8.86,9.34,9.25,9,8.62,8.24,7.70,7.10,6.49,5.59,5.35,4.46,4.37,4.24,4.07,3.87,3.23,2.22,2.20,2.12,2.12,2,2,1.97,1.72,1.21,0.36,-0.51,-1.38,-1.92,-2.38,-2.50,-1.88,-1,-1.15,-1.29,-1.43,-1.65,-1.88,-2.03,-2.25,-2.50,-2.75,-2.97,-3.16,-3.38,-3.61,-3.85,-4.08,-4.28,-4.50,-4.65,-4.84,-5,-5.16,-5.33,-5.49,-5.62,-5.68,-5.74,-5.74,-5.73,-5.63,-5.46,-5.13,-4.77,-4.43,-4.15,-3.91,-3.72,-3.50,-3.30,-3.11,-3.03,-3.01,-2.99,-2.92,-2.85,-2.75,-2.75,-2.53,-2.29,-1.90,-1.38,-0.68,-0.13,0.48,0.86,1,2,2,3,3,4,5,7,8,10,11,13,15.87,18.62,17.50,17.21,16.50,15.75,15.12,14.57,14.09,13.62,13.25,12.87,12.45,12,11.62,11.33,11.12,11,11,10.99,10.99,10.99,10.99,10.99,11,11,11,11,11,11,11,11,10.96,10.87,10.75,10.62,10.49,10.34,10.12,10.07,9.96,9.86,9.75,9.73,9.71,9.72,9.75,9.87,10,10.12,10.25,10.37,10.50,10.61,10.62,10.62,10.70,10.62,10.62,10.62,10.57,10.49,10.37,10.32,10.23,10.12,10.12,10.25,10.37,10.50,10.62,10.71,10.75,10.87,11.11,11.33,11.50,11.62,11.75,11.82,11.83,11.75,11.75,11.62,11.61,11.48,11.25,11,10.75,10.50,10.25,10,9.84,9.62,9.37,9.12,8.96,8.74,8.50,8.37,8.25,8.12,8.08,8,8,7.99,7.98,7.98,7.97,7.97,7.96,7.87,7.87,7.75,7.62,7.50,7.37,7.25,7.12,7.09,7,6.87,6.87,6.75,6.71,6.61,6.50,6.37,6.25,6.12,6.10,6,6,5.99,5.98,5.97,5.96,5.95,5.87,5.86,5.75,5.62,5.50,5.37,5.24,5.12,5,4.99,4.87,4.87,4.75,4.62,4.25,4.12,4,4,4,3.98,3.95,3.83,3.71,3.25,2.71,22,23,20,18,15,13,13,12,11,10,10,10,10.07,10.25,10.37,10.57,10.82,11.12,11.37,11.62,11.75,11.87,12.20,12.50,12.75,12.97,13.11,13.12,13.05,13.02,12.95,12.89,12.87,12.91,12.89,12.87,12.79,12.70,12.57,12.42,12.26,12.09,11.90,11.71,11.50,11.29,11.07,10.85,10.61,10.36,10.07,9.65,9.29,8.87,8.33,7.45,6.82,7.57,7.74,7.72,7.37,6.99,6.47,5.87,5.35,4.62,4.32,3.50,3.37,3.08,2.25,2.25,2.24,2.20,2.12,2,2,2,2,2,2,1.85,1.12,0.34,-0.65,-1.63,-2.38,-2.65,-2.75,-2.80,-1,-1.38,-1.63,-1.75,-1.89,-2.13,-2.25,-2.43,-2.68,-2.88,-3.08,-3.25,-3.43,-3.65,-3.88,-4.08,-4.25,-4.42,-4.59,-4.73,-4.87,-5,-5.13,-5.24,-5.29,-5.33,-5.30,-5.27,-5.25,-5.16,-4.99,-4.63,-4.26,-3.93,-3.71,-3.51,-3.36,-3.22,-3.10,-3,-2.98,-2.98,-2.99,-2.88,-2.64,-2.51,-2.38,-2.13,-1.79,-1.30,-0.75,0,0.61,1,1.35,2,2,3,3,4,5,6,8,9,10,13,17.87,19.62,19.36,18.10,17.07,16.22,15.47,14.83,14.32,13.87,13.50,13.12,12.84,12.37,12,11.62,11.34,11.12,11,11,10.99,10.99,10.99,10.99,10.99,11,11,11,11,11.07,11.08,11.07,11,10.98,10.87,10.75,10.62,10.47,10.32,10.12,10.07,9.98,9.87,9.86,9.84,9.84,9.87,9.96,10,10.12,10.25,10.37,10.47,10.50,10.57,10.58,10.58,10.57,10.50,10.50,10.47,10.37,10.35,10.25,10.20,10.12,10.08,10.11,10.20,10.25,10.37,10.50,10.57,10.62,10.84,11.08,11.32,11.50,11.62,11.71,11.74,11.74,11.72,11.62,11.62,11.50,11.37,11.21,10.95,10.62,10.37,10.12,9.87,9.62,9.37,9.20,8.96,8.73,8.50,8.36,8.23,8.12,8.08,8,8,7.99,7.98,7.98,7.98,7.97,7.96,7.95,7.87,7.86,7.75,7.62,7.49,7.36,7.23,7.12,7,6.96,6.87,6.75,6.72,6.62,6.50,6.37,6.25,6.20,6.11,6,6,5.99,5.98,5.97,5.97,5.95,5.87,5.85,5.75,5.62,5.50,5.37,5.25,5.12,5,4.99,4.87,4.86,4.75,4.62,4.36,4.20,4.07,4,4,3.98,3.95,3.83,3.62,3.32,3.10,2.71,19,19,21,20,18,15,14,13,11,10,10,10,10,10,10.08,10.08,10.11,10.12,10.25,10.34,10.37,10.57,10.74,10.87,11.07,11.27,11.35,11.38,11.37,11.43,11.45,11.45,11.48,11.52,11.61,11.63,11.63,11.60,11.51,11.41,11.28,11.14,10.98,10.80,10.62,10.42,10.22,10,9.78,9.52,9.22,8.85,8.51,8.11,7.55,6.73,6.62,6.74,6.75,6.57,6.12,5.50,4.71,4.37,3.62,3.50,3.20,2.87,2.37,2.35,2.21,2.07,2,2,2,2,2,2,2,2,2,1.95,1.50,0.36,-0.67,-1.75,-2.50,-2.88,-2.91,-3,-1,-1.79,-2,-2.13,-2.25,-2.38,-2.51,-2.66,-2.85,-3,-3.16,-3.34,-3.50,-3.68,-3.88,-4.04,-4.22,-4.37,-4.50,-4.61,-4.72,-4.80,-4.89,-4.96,-4.98,-4.93,-4.88,-4.80,-4.75,-4.65,-4.47,-4.13,-3.77,-3.49,-3.30,-3.16,-3.05,-2.98,-2.92,-2.90,-2.89,-2.88,-2.88,-2.63,-2.38,-2.13,-1.88,-1.54,-1.14,-0.66,-0.13,0.47,0.95,1.33,1.97,2,3,3,4,4,5,6,7,9,11,16.87,18.73,19.37,18.37,17.57,16.60,15.75,15.08,14.50,14.11,13.75,13.37,13.12,12.82,12.37,12,11.62,11.34,11.12,11,11,10.99,10.98,10.98,10.98,10.99,11,11,11,11.09,11.10,11.11,11.10,11,10.97,10.87,10.73,10.58,10.37,10.25,10.12,10.07,9.99,9.95,9.87,9.87,9.95,10,10.10,10.21,10.25,10.37,10.45,10.48,10.49,10.48,10.46,10.37,10.37,10.37,10.36,10.32,10.25,10.22,10.12,10.11,10,10,10.07,10.12,10.20,10.25,10.33,10.37,10.50,10.73,11,11.25,11.37,11.50,11.60,11.62,11.61,11.59,11.50,11.50,11.37,11.25,11,10.75,10.50,10.23,9.96,9.70,9.46,9.20,8.96,8.72,8.50,8.35,8.22,8.12,8.07,8,8,7.99,7.98,7.98,7.98,7.97,7.97,7.96,7.87,7.87,7.83,7.72,7.58,7.37,7.25,7.12,7.07,6.98,6.87,6.83,6.74,6.62,6.50,6.37,6.25,6.20,6.12,6.07,6,6,5.98,5.98,5.97,5.95,5.87,5.85,5.75,5.62,5.50,5.37,5.25,5.12,5.07,5,4.95,4.86,4.75,4.60,4.37,4.23,4.09,4,3.99,3.97,3.95,3.83,3.62,3.32,3.12,2.98,2.62,16,18,19,22,20,17,15,13,12,11,10,10.07,10,10,10,9.87,9.82,9.62,9.47,9.37,9.36,9.45,9.50,9.62,9.83,9.91,9.95,9.97,9.99,10.10,10.15,10.23,10.27,10.34,10.41,10.52,10.57,10.57,10.54,10.49,10.40,10.28,10.15,10,9.83,9.65,9.47,9.26,9.04,8.80,8.57,8.25,7.99,7.80,7.41,6.73,6.62,6.50,6.25,5.75,5.12,4.45,3.62,3.33,3,2.50,2.50,2.46,2.33,2.12,2.10,2,2,2,2.12,2.11,2.09,2.08,2.12,2,1.87,1.73,1.34,0.37,-0.68,-1.88,-2.88,-3,-3,-3,-3,-2.13,-2.43,-2.54,-2.63,-2.75,-2.77,-2.88,-3,-3.13,-3.27,-3.41,-3.55,-3.72,-3.87,-4,-4.14,-4.27,-4.38,-4.49,-4.54,-4.61,-4.63,-4.64,-4.63,-4.54,-4.43,-4.34,-4.24,-4.12,-3.93,-3.64,-3.29,-3.18,-3.12,-3.04,-2.97,-2.87,-2.76,-2.74,-2.75,-2.75,-2.63,-2.25,-1.90,-1.63,-1.25,-0.88,-0.50,0,0.50,0.95,1,2,2,3,4,4,4,4,5,6,8,11,14,16.82,17.75,17.75,17.37,16.62,15.95,15.25,14.70,14.25,13.97,13.62,13.37,13.12,12.83,12.37,12,11.62,11.35,11.12,11,11,10.98,10.98,10.98,10.98,10.98,11,11,11.07,11.12,11.12,11.12,11.11,11,10.95,10.83,10.62,10.50,10.37,10.24,10.12,10,10,9.97,9.97,9.98,10,10.10,10.20,10.25,10.37,10.37,10.45,10.37,10.37,10.37,10.33,10.25,10.25,10.24,10.22,10.12,10.12,10.12,10.08,10,10,10,10,10,10.10,10.12,10.12,10.25,10.37,10.61,10.87,11.12,11.32,11.37,11.46,11.47,11.45,11.37,11.37,11.32,11.22,11.07,10.86,10.60,10.32,10,9.75,9.48,9.21,8.96,8.72,8.50,8.33,8.21,8.11,8,8,8,7.99,7.98,7.98,7.98,7.97,7.97,7.96,7.95,7.87,7.87,7.75,7.62,7.50,7.37,7.22,7.10,7,6.87,6.86,6.75,6.62,6.50,6.37,6.25,6.20,6.11,6,6,6,5.99,5.98,5.97,5.96,5.87,5.86,5.75,5.62,5.50,5.37,5.25,5.12,5.07,5,4.87,4.86,4.74,4.59,4.37,4.24,4.11,4,3.98,3.96,3.87,3.82,3.62,3.33,3.12,3,2.95,2.62,16,17,18,19,21,19,16,14,13,12,11,10.12,10.25,10.21,10.08,9.87,9.62,9.36,9,8.75,8.62,8.62,8.71,8.88,8.93,8.97,8.99,9,9.03,9.17,9.26,9.29,9.32,9.37,9.43,9.52,9.63,9.67,9.68,9.66,9.60,9.51,9.39,9.26,9.12,8.96,8.79,8.62,8.42,8.25,8.05,7.82,7.64,7.58,8.32,7.12,6.87,6.62,6.12,5.36,4.47,3.62,3.08,2.60,2.50,2.50,2.47,2.37,2.36,2.22,2.09,2,2,2.11,2.09,2.87,2.87,2.96,2.37,2,1.62,1.25,0.87,0.12,-0.88,-1.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.13,-3.25,-3.38,-3.50,-3.62,-3.73,-3.84,-3.96,-4.08,-4.17,-4.27,-4.36,-4.38,-4.38,-4.38,-4.34,-4.26,-4.15,-4.02,-3.89,-3.76,-3.64,-3.48,-3.29,-3.10,-3.03,-3,-2.99,-3,-2.67,-2.50,-2.40,-2.50,-2.42,-2.29,-1.88,-1.42,-1.01,-0.63,-0.17,0.25,0.62,1.07,1.37,2,2,3,4,5,5,5,5,6,7,10,14.99,17.85,17.62,17,16.73,16.32,15.75,15.25,14.75,14.37,14.11,13.87,13.62,13.37,13.12,12.86,12.47,12,11.62,11.36,11.12,11,10.99,10.98,10.98,10.97,10.97,10.97,10.98,11,11,11.10,11.12,11.12,11.10,11,10.87,10.75,10.60,10.45,10.25,10.20,10.10,10,10,9.99,9.99,10,10.07,10.12,10.23,10.32,10.37,10.37,10.37,10.36,10.32,10.25,10.21,10.12,10.12,10.12,10.11,10.09,10.08,10,10,10,10,10,10,10,10,10,10.08,10.12,10.25,10.47,10.72,10.96,11.12,11.25,11.25,11.32,11.25,11.25,11.21,11.12,11,10.86,10.62,10.37,10.10,9.75,9.50,9.23,8.96,8.71,8.49,8.32,8.12,8.10,8,8,7.99,7.98,7.98,7.98,7.97,7.97,7.97,7.96,7.95,7.87,7.87,7.84,7.74,7.61,7.46,7.25,7.12,7,6.96,6.87,6.75,6.70,6.58,6.45,6.33,6.21,6.12,6,6,5.99,5.98,5.98,5.97,5.96,5.87,5.86,5.75,5.62,5.50,5.37,5.25,5.12,5.07,5,4.95,4.86,4.74,4.58,4.37,4.24,4.11,4,3.98,3.87,3.87,3.75,3.62,3.34,3.12,3,3,2.87,2.62,16,16,17,18,19,19,17,16,14,13,12,11.25,10.98,10.58,10.25,9.97,9.62,9.25,8.87,8.57,8.37,8.35,8.42,8.43,8.46,8.46,8.49,8.50,8.51,8.61,8.66,8.65,8.64,8.64,8.67,8.73,8.80,8.87,8.91,8.92,8.90,8.84,8.75,8.63,8.50,8.36,8.21,8.07,7.93,7.80,7.66,7.48,7.35,7.25,7.23,7.35,6.75,7.34,6.35,4.87,3.87,3.12,2.58,2.37,2.37,2.62,2.70,2.62,2.62,2.23,2.11,2.07,2.10,2.08,2.87,3,3,3,2.73,2.09,1.37,0.87,0.35,-0.25,-1.14,-2.13,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.09,-3.25,-3.38,-3.50,-3.58,-3.64,-3.72,-3.78,-3.88,-3.98,-4.08,-4.15,-4.22,-4.22,-4.15,-4.10,-4,-3.90,-3.77,-3.64,-3.51,-3.39,-3.29,-3.21,-3.11,-3.02,-3,-2.99,-2.92,-2.88,-2.38,-2.03,-1.88,-1.92,-2,-1.88,-1.38,-0.91,-0.50,0,0.48,0.87,1.25,1.62,1.98,2,3,4,4,5,6,6,7,8,11,13,16.87,17.75,16.87,16.37,15.87,15.45,15,14.62,14.37,14.12,13.99,13.83,13.62,13.47,13.24,12.87,12.50,12.08,11.70,11.37,11.12,11,11,10.97,10.96,10.96,10.95,10.87,10.87,10.96,10.98,11,11.08,11.11,11,10.87,10.75,10.62,10.49,10.36,10.24,10.12,10.07,10,10,9.99,10,10,10.07,10.12,10.21,10.25,10.33,10.34,10.32,10.25,10.21,10.12,10.11,10.08,10,10,10,10,10,10,10,9.99,9.99,9.99,9.99,10,10,10,10,10.08,10.12,10.35,10.57,10.75,11,11.12,11.12,11.20,11.12,11.12,11.08,10.99,10.85,10.62,10.37,10.12,9.85,9.50,9.25,8.98,8.72,8.49,8.25,8.12,8.09,8,8,7.99,7.98,7.98,7.98,7.97,7.97,7.97,7.96,7.95,7.87,7.87,7.86,7.75,7.62,7.50,7.37,7.24,7.11,7,6.87,6.82,6.72,6.61,6.48,6.35,6.23,6.12,6.07,6,5.99,5.98,5.97,5.97,5.95,5.87,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.07,5,4.95,4.86,4.74,4.58,4.37,4.23,4.11,4,3.98,3.87,3.86,3.75,3.62,3.37,3.12,3,3,3,2.87,2.62,16,16,16,17,18,18,19,18,16,14,13.12,12.75,12.12,11.45,10.62,10.12,9.62,9.25,8.87,8.61,8.47,8.41,8.38,8.33,8.28,8.26,8.24,8.24,8.25,8.30,8.29,8.26,8.21,8.15,8.13,8.14,8.18,8.24,8.29,8.33,8.33,8.28,8.21,8.10,7.98,7.84,7.72,7.61,7.51,7.43,7.36,7.24,7.09,6.95,6.75,6.48,6.25,5.85,5.25,4.37,3.47,2.50,2.33,2.23,2.33,2.57,3.60,2.62,2.32,2.22,2.21,2.12,2.08,3,3.98,4,4,4,3.25,2.10,1.20,0.37,-0.25,-0.88,-1.63,-2.38,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.13,-3.36,-3.50,-3.58,-3.62,-3.64,-3.67,-3.73,-3.77,-3.86,-3.92,-4,-4.03,-4.01,-3.91,-3.79,-3.67,-3.55,-3.43,-3.34,-3.24,-3.14,-3.10,-3.03,-3,-3,-2.98,-2.93,-2.88,-2.66,-2.13,-1.63,-1.25,-1.38,-1.29,-1.17,-0.88,-0.39,0.09,0.62,1.12,1.50,1.86,2,3,3,4,5,6,6,8,8,10,14,15,17.99,16.86,16.74,16.25,15.62,15.12,14.75,14.50,14.25,14.12,13.98,13.85,13.73,13.61,13.48,13.25,12.98,12.50,12.09,11.70,11.37,11.12,11,10.99,10.96,10.95,10.87,10.87,10.87,10.86,10.86,10.86,10.87,10.87,10.87,10.87,10.75,10.62,10.50,10.37,10.25,10.12,10.10,10,10,9.99,9.99,10,10,10,10.11,10.12,10.21,10.24,10.24,10.22,10.12,10.12,10.09,10,10,10,10,10,10,9.99,9.99,9.99,9.99,9.99,9.99,9.99,9.99,9.99,10,10,10,10.12,10.25,10.46,10.70,10.87,11,11.10,11.12,11.11,11.07,10.98,10.85,10.62,10.45,10.12,9.87,9.59,9.25,9,8.74,8.50,8.25,8.12,8.08,8,8,7.99,7.98,7.98,7.98,7.97,7.97,7.97,7.96,7.95,7.87,7.87,7.87,7.75,7.71,7.59,7.45,7.25,7.12,7,6.95,6.84,6.74,6.62,6.50,6.37,6.25,6.12,6.08,6,6,5.98,5.97,5.96,5.95,5.87,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.08,5,4.87,4.86,4.74,4.58,4.37,4.23,4.11,4,3.98,3.87,3.85,3.73,3.58,3.37,3.21,3.07,3,3,3,2.87,2.62,15.98,15.98,16,16,17,17,18.98,19.98,18,16,14.12,13.87,14.37,12.12,11.07,10.34,9.75,9.34,9,8.75,8.71,8.60,8.48,8.37,8.27,8.20,8.16,8.15,8.14,8.14,8.10,8.02,7.93,7.85,7.77,7.74,7.74,7.76,7.80,7.84,7.84,7.82,7.74,7.64,7.51,7.38,7.27,7.20,7.16,7.15,7.14,7.08,6.96,6.71,6.32,5.82,5.33,4.87,4.45,3.96,3.24,2.50,2.12,2.12,2.20,2.37,2.37,2.33,2.25,2.23,2.12,2.87,3,4,5,5,5,4,3.21,2.12,0.95,-0.13,-0.88,-1.52,-2.13,-2.79,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.15,-3.38,-3.52,-3.58,-3.61,-3.61,-3.62,-3.63,-3.65,-3.72,-3.77,-3.84,-3.85,-3.78,-3.66,-3.51,-3.38,-3.21,-3.08,-3.05,-3.01,-2.98,-2.96,-2.96,-2.96,-2.92,-2.90,-2.88,-2.75,-2.43,-1.76,-1.17,-0.75,-0.64,-0.63,-0.39,-0.14,0.12,0.61,1.11,1.87,2,2,3,3,4,5,7,8,8,9,12,14,17,19,18.87,17.25,16.36,15.72,15.12,14.72,14.37,14.23,14.09,13.95,13.82,13.70,13.60,13.50,13.37,13.24,12.96,12.50,12.09,11.70,11.37,11.12,11,10.98,10.95,10.87,10.87,10.83,10.75,10.74,10.71,10.70,10.70,10.70,10.70,10.62,10.59,10.48,10.37,10.25,10.12,10.11,10,10,10,9.99,9.99,9.99,10,10,10.07,10.10,10.12,10.12,10.12,10.12,10.10,10.07,10,10,10,9.99,9.99,9.99,9.98,9.99,9.99,9.98,9.98,9.98,9.98,9.98,9.98,9.99,9.99,10,10,10.08,10.21,10.37,10.62,10.84,10.99,11,11.07,11,11,10.87,10.71,10.49,10.22,9.87,9.61,9.32,9,8.75,8.50,8.33,8.12,8.08,8,8,7.99,7.98,7.98,7.98,7.97,7.97,7.97,7.96,7.95,7.87,7.87,7.87,7.82,7.73,7.62,7.49,7.35,7.22,7.10,6.98,6.87,6.75,6.62,6.50,6.37,6.25,6.12,6.09,6,6,5.98,5.97,5.95,5.87,5.87,5.86,5.75,5.62,5.50,5.37,5.25,5.12,5.08,5,4.87,4.84,4.73,4.57,4.37,4.23,4.11,4,3.99,3.87,3.86,3.73,3.58,3.37,3.23,3.09,3,3,3,3,2.87,2.62,15.87,15.87,15.87,16.09,16.87,17.87,18.07,18.95,18.96,17,15.75,14.82,13.83,12.75,11.57,10.62,9.96,9.37,9.11,8.97,8.98,8.76,8.61,8.46,8.32,8.22,8.15,8.12,8.10,8.05,7.98,7.89,7.78,7.66,7.55,7.48,7.45,7.43,7.45,7.47,7.46,7.42,7.35,7.24,7.11,6.98,6.89,6.86,6.88,6.93,7,7.07,6.87,6.58,6,5.25,4.57,4.12,3.84,3.58,3.50,2.48,2.12,2.12,2.12,2.12,2.12,2.25,2.24,2.96,3.12,4.09,4.97,5,6,6,6,5,3.83,2.21,0.75,-0.68,-1.68,-2.13,-2.75,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.13,-3.34,-3.46,-3.50,-3.50,-3.50,-3.50,-3.50,-3.51,-3.54,-3.60,-3.63,-3.63,-3.55,-3.43,-3.26,-3.15,-3.08,-3.03,-3,-2.96,-2.87,-2.80,-2.88,-2.90,-2.80,-2.80,-2.63,-2.50,-2.13,-1.40,-0.88,-0.38,-0.01,0.21,0.37,0.72,1.07,1,2,2,2,3,3,4,4,5,6,7,9,11,15,18,19,18.99,18.83,17.12,16.12,15.45,14.87,14.50,14.25,14.11,13.96,13.82,13.62,13.50,13.37,13.34,13.24,13.10,12.84,12.47,12.08,11.70,11.37,11.12,11,10.97,10.87,10.87,10.82,10.74,10.62,10.60,10.50,10.50,10.49,10.48,10.47,10.37,10.37,10.32,10.23,10.12,10.11,10,10,10,9.99,9.99,9.99,9.99,10,10,10,10,10.07,10.08,10.08,10,10,10,10,9.99,9.99,9.98,9.98,9.99,9.99,9.98,9.98,9.98,9.97,9.97,9.96,9.96,9.97,9.97,9.99,10,10,10.07,10.12,10.36,10.58,10.75,10.87,10.99,11,10.99,10.87,10.75,10.50,10.25,9.96,9.62,9.33,9,8.75,8.50,8.36,8.20,8.09,8,8,7.99,7.98,7.98,7.98,7.98,7.97,7.97,7.96,7.95,7.87,7.87,7.87,7.75,7.73,7.62,7.50,7.37,7.25,7.12,7,6.87,6.75,6.62,6.50,6.37,6.25,6.12,6.10,6,6,5.98,5.97,5.95,5.87,5.87,5.85,5.75,5.62,5.50,5.37,5.25,5.12,5.08,5,4.87,4.83,4.71,4.50,4.37,4.23,4.11,4,3.99,3.87,3.86,3.74,3.58,3.37,3.24,3.11,3,3,3,3,3,2.87,2.62,15.87,15.12,15.87,16.12,16.87,17.11,18.10,18.87,18.87,17.87,16.62,15.37,14.12,13.09,12,11,10.22,9.59,9.22,9.09,9.04,8.87,8.71,8.53,8.37,8.24,8.15,8.10,8.05,8,7.90,7.79,7.67,7.54,7.42,7.33,7.26,7.23,7.21,7.20,7.17,7.11,7.02,6.89,6.75,6.64,6.58,6.59,6.70,6.85,7,7.12,7,6.50,5.75,4.83,4,3.50,3.37,3.25,3,2.48,2.37,2.25,2.20,2.12,2.21,2.25,3.12,4,4.99,5.87,6,7,8,7,7,6,3.86,2.08,0.73,-0.75,-1.80,-2.75,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.09,-3.21,-3.26,-3.33,-3.35,-3.37,-3.36,-3.35,-3.36,-3.37,-3.39,-3.40,-3.38,-3.34,-3.24,-3.15,-3.09,-3.03,-3.01,-2.98,-2.87,-2.68,-2.50,-2.41,-2.50,-2.50,-2.50,-2.18,-1.93,-1.54,-1.02,-0.40,0.09,0.50,0.87,1.24,1.50,1.97,2,2,3,3,3,4,5,5,6,7,7,10,14,19,19,19,18,17.25,16.72,15.87,15.25,14.75,14.37,14.20,14,13.87,13.71,13.50,13.37,13.25,13.21,13.12,12.97,12.74,12.37,12,11.62,11.37,11.12,11,10.95,10.87,10.82,10.73,10.62,10.50,10.46,10.37,10.33,10.25,10.25,10.25,10.25,10.22,10.12,10.12,10.08,10,10,10,10,9.99,9.99,9.99,9.99,10,10,10,10,10,10,10,10,10,9.99,9.99,9.99,9.98,9.99,9.98,9.98,9.98,9.98,9.97,9.97,9.96,9.87,9.87,9.87,9.87,9.87,9.97,9.99,10,10.07,10.12,10.25,10.50,10.62,10.75,10.85,10.86,10.84,10.75,10.58,10.25,10,9.62,9.35,9,8.75,8.50,8.37,8.22,8.11,8,8,7.99,7.98,7.98,7.98,7.97,7.97,7.97,7.96,7.95,7.87,7.87,7.86,7.75,7.72,7.62,7.50,7.37,7.25,7.12,7,6.96,6.85,6.73,6.60,6.45,6.32,6.20,6.11,6,6,5.98,5.97,5.95,5.87,5.87,5.83,5.75,5.62,5.50,5.37,5.25,5.12,5.08,4.99,4.87,4.82,4.62,4.50,4.37,4.22,4.11,4,3.99,3.87,3.86,3.74,3.58,3.37,3.24,3.12,3,3,3,3,3,3,2.87,2.62,15.12,15.12,15.84,16.84,16.12,17,17.87,18.87,18.96,18.87,17.37,16,14.73,13.61,12.50,11.47,10.50,9.75,9.33,9.18,9.08,8.91,8.75,8.58,8.40,8.27,8.16,8.09,8.01,7.95,7.85,7.72,7.60,7.47,7.34,7.23,7.14,7.09,7.04,7.01,6.96,6.86,6.74,6.60,6.45,6.34,6.33,6.40,6.54,6.84,7.09,7.25,7,6.37,5.50,4.50,3.50,3.25,3.12,3,2.87,2.87,2.87,2.62,2.37,2.23,2.32,2.87,3.75,4.98,6.86,7.87,7,8,7.97,6.87,5.75,4.37,2.87,1.37,0.25,-0.90,-2,-2.77,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.15,-3.18,-3.17,-3.15,-3.17,-3.18,-3.18,-3.17,-3.15,-3.13,-3.11,-3.08,-3.03,-3.02,-3,-2.96,-2.78,-2.50,-2,-1.75,-1.92,-2,-1.90,-1.63,-1.25,-0.88,-0.38,0.11,0.58,0.97,1.46,2,2,2,2,3,3,4,4,5,6,7,8,8,9,12,18,19,19,18,17.12,16.70,16.12,15.59,15.08,14.62,14.34,14.12,13.97,13.82,13.62,13.47,13.25,13.12,13.10,13,12.87,12.62,12.37,12,11.62,11.37,11.12,11,10.87,10.82,10.73,10.62,10.50,10.37,10.32,10.24,10.20,10.12,10.12,10.12,10.12,10.10,10.08,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9.99,9.99,9.99,9.99,9.99,9.98,9.98,9.98,9.97,9.97,9.96,9.95,9.87,9.87,9.87,9.85,9.84,9.86,9.87,9.95,10,10.07,10.12,10.24,10.37,10.50,10.58,10.61,10.61,10.57,10.47,10.25,10,9.62,9.36,9,8.75,8.50,8.36,8.23,8.12,8,8,7.99,7.98,7.98,7.98,7.97,7.97,7.97,7.96,7.95,7.87,7.87,7.86,7.75,7.72,7.62,7.50,7.37,7.25,7.12,7.09,7,6.87,6.75,6.62,6.50,6.37,6.24,6.12,6,6,5.99,5.97,5.95,5.87,5.87,5.83,5.75,5.62,5.50,5.37,5.25,5.12,5.07,4.99,4.87,4.75,4.62,4.50,4.36,4.21,4.10,4,3.98,3.87,3.86,3.74,3.58,3.37,3.24,3.12,3,3,3,3,3,3,3,2.87,2.62,15,15.20,15.75,15.87,16.12,16.83,17.12,18.84,19.12,19.87,18.34,17,15.62,14.32,13.12,11.95,10.87,10,9.50,9.25,9.10,8.92,8.76,8.59,8.43,8.29,8.17,8.08,7.99,7.89,7.78,7.66,7.52,7.39,7.26,7.14,7.05,6.98,6.92,6.86,6.77,6.65,6.50,6.34,6.18,6.10,6.09,6.24,6.49,6.83,7.09,7.22,6.87,6.25,5.25,4.25,3.50,3.12,3,2.99,2.99,3.09,3.50,3.60,2.37,2.34,2.85,3.25,4.22,5.83,6.87,7.87,7.95,8,7.49,6,4.58,3.12,1.75,0.58,-0.50,-1.38,-2.17,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.04,-3.03,-2.99,-2.96,-2.93,-2.96,-2.99,-3.02,-3.03,-3,-3,-3,-2.79,-2.38,-1.65,-1.13,-1.38,-1.50,-1.25,-0.91,-0.50,0,0.50,1,1.37,1.50,2,3,3,3,3,3,4,4,5,7,7,8,9,9,12,17,18,18,19,17,16.12,16,15.62,15.20,14.75,14.46,14.21,14,13.87,13.75,13.61,13.37,13.25,13.12,13,12.97,12.84,12.62,12.34,11.99,11.62,11.36,11.12,10.96,10.84,10.73,10.62,10.50,10.37,10.25,10.21,10.12,10.10,10.08,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9.99,9.99,9.99,9.99,9.98,9.98,9.97,9.97,9.96,9.95,9.87,9.87,9.84,9.75,9.75,9.74,9.75,9.75,9.87,9.95,10,10.08,10.12,10.22,10.25,10.33,10.32,10.25,10.22,10.11,9.87,9.62,9.36,9.07,8.75,8.50,8.36,8.22,8.12,8,8,7.99,7.98,7.98,7.97,7.97,7.97,7.97,7.96,7.95,7.87,7.87,7.86,7.75,7.72,7.62,7.50,7.37,7.25,7.20,7.11,7,6.97,6.87,6.75,6.62,6.46,6.25,6.12,6.09,6,5.99,5.97,5.95,5.87,5.87,5.83,5.74,5.62,5.50,5.37,5.25,5.12,5.07,4.98,4.87,4.75,4.62,4.50,4.36,4.22,4.10,4,3.98,3.87,3.86,3.74,3.58,3.37,3.24,3.12,3,3,3,3,3,3,3,3,2.87,2.62,14.98,15.09,15.23,15.22,15.87,16.21,17.12,18.77,18.76,19.48,19.02,17.85,16.68,15.38,14,12.67,11.45,10.48,9.77,9.35,9.11,8.95,8.78,8.61,8.46,8.33,8.20,8.08,7.97,7.85,7.72,7.59,7.46,7.30,7.17,7.05,6.96,6.87,6.80,6.72,6.61,6.47,6.29,6.11,5.97,5.88,5.89,6.12,6.45,6.75,7,7.09,6.75,6.09,5.12,4.24,3.50,3.12,3,3,3,3.12,3.25,3.12,3,3.07,3.25,4.12,5.12,6.11,7.87,7.10,7.95,7,5.72,4.57,3.25,1.87,0.72,-0.38,-1.25,-2,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.13,-3,-2.77,-2.63,-2.64,-2.63,-2.79,-3,-3.13,-3,-3,-3,-2.78,-2.38,-1.79,-1.30,-1.13,-0.88,-0.53,-0.14,0.25,0.87,1.60,2.25,2.62,3,3,4,4,4,4,5,5,5,6,6,7,7,8,11,14,17,18,17,17,16,15.85,15.37,15.12,14.82,14.49,14.23,14,13.87,13.83,13.73,13.60,13.45,13.25,13.12,13,12.96,12.83,12.62,12.32,11.97,11.62,11.32,11.08,10.87,10.75,10.62,10.50,10.37,10.25,10.20,10.12,10.07,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9.99,9.99,9.99,9.99,9.98,9.98,9.97,9.97,9.95,9.87,9.87,9.83,9.75,9.70,9.62,9.60,9.61,9.62,9.75,9.87,9.95,9.99,10,10,10.07,10.07,10,9.95,9.85,9.72,9.50,9.25,9,8.75,8.50,8.36,8.21,8.11,8,8,7.99,7.98,7.98,7.98,7.97,7.97,7.96,7.96,7.95,7.87,7.87,7.87,7.75,7.72,7.62,7.50,7.37,7.25,7.20,7.12,7,6.99,6.87,6.85,6.73,6.58,6.37,6.25,6.12,6,6,5.98,5.95,5.87,5.87,5.83,5.74,5.62,5.50,5.37,5.25,5.12,5.07,4.98,4.87,4.75,4.62,4.50,4.36,4.22,4.11,4,3.99,3.87,3.86,3.74,3.58,3.37,3.24,3.12,3,3,3,3,3,3,3,3,3,2.87,2.62,14.84,14.75,14.75,15.09,15.75,15.75,16.40,17.26,18.11,18.65,18.93,18.73,17.80,16.41,14.86,13.36,11.99,10.89,10.11,9.58,9.16,8.99,8.82,8.65,8.51,8.37,8.24,8.11,7.97,7.83,7.67,7.52,7.37,7.23,7.08,6.95,6.83,6.74,6.65,6.57,6.45,6.29,6.11,5.92,5.76,5.70,5.83,6.10,6.46,6.75,6.96,6.87,6.50,5.98,5.32,4.50,3.50,3.25,3.07,3,3,3.10,3.12,3.25,3.35,3.83,4.25,4.87,5.75,6.84,6.12,6.10,5.95,5,4.07,3,1.87,0.74,-0.29,-1.17,-1.89,-2.50,-3,-3,-3,-3,-3,-3,-3,-3.02,-3.14,-3.25,-3.25,-3.13,-3.05,-3.01,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.50,-2.13,-1.88,-1.79,-2,-2.25,-2.67,-3.02,-3.01,-3,-3,-2.75,-2.40,-1.88,-1.30,-0.76,-0.25,0.25,0.62,1.25,1.87,2.87,3.50,4,4,4,5,5,5,5,5,7,6,6,7,7,8,9,11,16,17,17,17,16,15.96,15.25,15,14.73,14.37,14.12,13.97,13.83,13.75,13.71,13.62,13.59,13.47,13.33,13.21,13.09,12.97,12.82,12.60,12.25,11.87,11.58,11.25,11,10.82,10.62,10.50,10.37,10.25,10.21,10.12,10.07,10,10,10,10,10,10,10,10,10,10,10,10,10.07,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9.99,9.99,9.99,9.99,9.98,9.98,9.97,9.96,9.87,9.87,9.84,9.75,9.62,9.57,9.48,9.37,9.46,9.50,9.62,9.75,9.85,9.87,9.87,9.87,9.86,9.82,9.75,9.62,9.50,9.36,9.12,8.98,8.75,8.50,8.36,8.21,8.11,8,8,7.99,7.98,7.98,7.98,7.97,7.97,7.97,7.96,7.95,7.87,7.87,7.87,7.82,7.74,7.62,7.50,7.37,7.25,7.20,7.12,7,7,6.97,6.87,6.83,6.71,6.50,6.37,6.24,6.12,6,5.99,5.96,5.87,5.87,5.83,5.74,5.62,5.50,5.37,5.25,5.12,5.07,4.98,4.87,4.75,4.62,4.50,4.35,4.22,4.11,4,3.99,3.87,3.86,3.74,3.58,3.37,3.24,3.12,3,3,3,3,3,3,3,3,3,3,2.87,2.62,14.73,14.25,14.25,14.73,14.87,15.20,15.67,16.42,17.39,18.33,19.12,19.38,18.90,17.32,15.66,14.04,12.58,11.36,10.45,9.82,9.38,9.05,8.87,8.72,8.58,8.45,8.30,8.16,8,7.83,7.65,7.48,7.30,7.13,6.97,6.82,6.68,6.59,6.51,6.41,6.29,6.14,5.96,5.74,5.62,5.62,5.85,6.12,6.48,6.75,6.87,6.72,6.37,5.95,5.49,5.46,4.24,3.50,3.10,3,3.09,3.24,3.37,3.37,4.25,4.83,5.25,5.86,6.12,6.10,5.87,4.98,4.11,3.32,2.37,1.62,0.73,-0.25,-1.13,-1.88,-2.42,-2.79,-3,-3,-3,-3,-3,-3,-3.18,-3.38,-3.63,-3.67,-3.68,-3.63,-3.38,-3.15,-3.13,-3,-3,-3,-3,-3,-3,-3,-2.90,-3,-1.88,-1.63,-1.40,-1.38,-1.51,-1.88,-2.38,-2.78,-2.91,-2.91,-2.91,-2.67,-2.38,-1.79,-1.13,-0.38,0.37,1.12,1.97,3,4,4,5,5,5,5,5,5,5,5,6,6,7,7,8,9,11,12,13,15,17,17,16,15.98,15.07,14.99,14.62,14.34,14.08,13.86,13.70,13.59,13.50,13.50,13.50,13.50,13.46,13.36,13.24,13.11,12.97,12.75,12.50,12.22,11.86,11.49,11.12,10.87,10.71,10.50,10.37,10.25,10.21,10.12,10.08,10,10,10,10,10,10,10,10,10,10,10,10,10.07,10.07,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9.99,9.99,9.99,9.98,9.98,9.97,9.95,9.87,9.87,9.75,9.62,9.50,9.37,9.33,9.25,9.25,9.37,9.50,9.62,9.71,9.75,9.74,9.71,9.62,9.57,9.48,9.36,9.21,9,8.87,8.62,8.50,8.34,8.21,8.11,8,8,7.98,7.98,7.98,7.98,7.98,7.97,7.97,7.96,7.96,7.87,7.87,7.87,7.82,7.74,7.62,7.50,7.37,7.25,7.20,7.12,7,7,6.98,6.95,6.87,6.75,6.62,6.50,6.36,6.22,6.10,6,5.97,5.87,5.87,5.83,5.74,5.62,5.50,5.37,5.25,5.12,5.08,4.99,4.87,4.75,4.62,4.50,4.34,4.21,4.11,4,3.99,3.95,3.87,3.74,3.58,3.37,3.23,3.11,3,3,3,3,3,3,3,2.99,3,3,3,2.87,2.62,14.71,13.87,13.25,13.83,14.24,14.60,15.14,15.91,16.97,18.09,19.26,19.86,19.43,18.03,16.38,14.71,13.14,11.83,10.80,10.08,9.57,9.22,8.95,8.78,8.65,8.52,8.38,8.22,8.04,7.85,7.64,7.43,7.24,7.03,6.84,6.66,6.51,6.39,6.29,6.22,6.12,6.02,5.89,5.73,5.73,5.75,5.97,6.23,6.50,6.72,6.74,6.57,6.25,5.87,5.60,5.12,5.49,3.50,3.12,3.20,3.37,3.37,4.37,5,5.33,6.12,6.74,6.84,6.82,6,4.99,3.96,2.87,1.84,1.08,0.37,-0.38,-1.13,-1.75,-2.29,-2.76,-2.93,-3,-3,-3,-3,-3,-3.18,-3.50,-3.75,-3.89,-4,-4,-3.92,-3.75,-3.43,-3.17,-3.13,-3,-3,-3,-3,-3,-3,-2.90,-1.50,-1.63,-1.25,-1.05,-1,-1.15,-1.53,-2.13,-2.75,-2.88,-2.88,-2.88,-2.63,-2.05,-1.38,-0.55,0.32,1.07,1.85,2.97,4,5,6,7,6,5,5,5,5,5,6,6,7,8,9,10,13,17,17,17,17,17,17,16,15.96,15.10,14.62,14.25,13.98,13.74,13.57,13.37,13.34,13.25,13.32,13.35,13.37,13.37,13.25,13.21,13.07,12.87,12.70,12.37,12.10,11.73,11.37,11,10.75,10.60,10.37,10.25,10.21,10.12,10.08,10,10,10,10,10,10,10,10,10,10,10,10,10,10.07,10.07,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9.99,9.99,9.98,9.98,9.97,9.95,9.87,9.83,9.73,9.59,9.37,9.25,9.21,9.12,9.12,9.25,9.37,9.47,9.50,9.58,9.57,9.50,9.37,9.34,9.23,9.11,8.96,8.75,8.62,8.47,8.32,8.12,8.11,8,8,7.98,7.97,7.97,7.97,7.97,7.97,7.97,7.97,7.96,7.95,7.87,7.87,7.82,7.74,7.62,7.50,7.37,7.25,7.12,7.10,7,7,6.99,6.97,6.87,6.86,6.75,6.62,6.48,6.33,6.12,6.08,6,5.95,5.87,5.83,5.74,5.62,5.50,5.37,5.25,5.12,5.08,5,4.87,4.75,4.62,4.50,4.34,4.21,4.11,4,4,3.95,3.87,3.75,3.58,3.37,3.23,3.11,3,3,3,3,3,2.99,2.99,2.99,2.99,2.99,2.99,3,2.87,2.62,13.75,13.32,13.32,13.49,13.80,14.28,14.86,15.65,16.62,17.77,19,19.70,19.62,18.51,17.02,15.35,13.71,12.28,11.15,10.33,9.75,9.35,9.07,8.86,8.73,8.60,8.46,8.28,8.09,7.87,7.65,7.41,7.18,6.95,6.72,6.51,6.33,6.20,6.11,6.04,6,5.98,5.95,5.87,5.98,6,6.12,6.35,6.50,6.62,6.60,6.37,6.12,5.75,5.48,4.96,4.20,3.47,3.12,3.37,4.09,5.12,6.25,7.12,7.32,7.75,7.75,7.75,7.82,5.82,4.25,2.87,1.84,0.87,0.12,-0.52,-1.18,-1.77,-2.27,-2.65,-2.93,-3,-3,-3,-3,-3,-3.02,-3.38,-3.63,-4,-4.13,-4.25,-4.25,-4.17,-4,-3.75,-3.27,-3.15,-3.01,-3,-3,-3,-3,-3,-2.88,-1.75,-1.50,-1.25,-1.13,-1.04,-1.25,-1.55,-2,-2.65,-2.88,-2.88,-2.75,-2.41,-1.75,-0.91,0.11,0.99,2,2,3,5,7,7,7,6,6,6,6,6,6,7,8,8,10,12,14,19,19,19,19,18,17,16.99,16.97,15.95,14.87,14.25,13.87,13.62,13.37,13.25,13.12,13.10,13,13,13.09,13.12,13.12,13.12,13,12.87,12.73,12.50,12.23,11.87,11.50,11.21,10.87,10.62,10.47,10.32,10.21,10.12,10.08,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9.98,9.97,9.96,9.87,9.87,9.75,9.62,9.49,9.33,9.20,9.11,9.08,9.10,9.12,9.24,9.32,9.37,9.37,9.37,9.32,9.23,9.12,9,8.87,8.75,8.60,8.45,8.25,8.12,8.10,8,8,7.98,7.97,7.97,7.97,7.97,7.97,7.97,7.97,7.96,7.95,7.87,7.87,7.82,7.74,7.62,7.50,7.37,7.25,7.12,7.09,7,7,6.99,6.97,6.95,6.87,6.83,6.72,6.59,6.37,6.25,6.12,6,5.97,5.87,5.83,5.74,5.62,5.50,5.37,5.25,5.12,5.09,5,4.87,4.75,4.62,4.50,4.33,4.20,4.10,4,4,3.96,3.87,3.75,3.59,3.37,3.23,3.11,3,3,3,3,3,2.99,2.99,2.99,2.99,2.99,2.99,2.99,3,2.87,2.70,13.12,13.34,13.58,13.58,13.83,14.22,14.78,15.48,16.35,17.41,18.52,19.40,19.65,18.95,17.63,15.99,14.28,12.75,11.52,10.59,9.93,9.48,9.16,8.95,8.79,8.66,8.51,8.34,8.13,7.90,7.66,7.41,7.14,6.87,6.61,6.38,6.18,6.05,5.98,5.97,6,6.05,6.15,6.25,6.37,6.37,6.37,6.47,6.50,6.50,6.46,6.34,6.10,5.71,5.12,4.47,3.75,3.37,3.25,3.37,4.61,6.62,8.62,9.62,10.71,9.25,8.75,7.82,6.83,5.21,3.50,2.09,0.87,-0.02,-0.75,-1.30,-1.88,-2.38,-2.64,-2.88,-3,-3,-3,-3,-3,-3,-3.14,-3.50,-3.77,-4.13,-4.26,-2.38,-2.38,-2.28,-4.13,-3.88,-3.42,-3.25,-3.05,-3,-3,-3,-3,-3,-2.28,-1.80,-1.40,-1.16,-1.03,-1.05,-1.25,-1.67,-2.15,-2.63,-2.75,-2.77,-2.63,-2.18,-1.40,-0.39,0.62,1.87,2,3,4,5,8,8,7,7,7,8,7,7,7,10,12,13,15,17,20,19,19,18,18,18,16.99,16,15.95,15.08,14.12,13.87,13.50,13.34,13.20,13.08,12.97,12.87,12.75,12.75,12.75,12.75,12.75,12.75,12.72,12.61,12.45,12.23,11.96,11.62,11.32,11,10.73,10.50,10.35,10.22,10.12,10.08,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.07,10.09,10.11,10.11,10.09,10.07,10,10,9.99,9.97,9.96,9.87,9.85,9.74,9.59,9.37,9.24,9.12,9,9,9,9.08,9.12,9.12,9.22,9.22,9.12,9.12,9,8.95,8.84,8.71,8.58,8.37,8.25,8.12,8.09,8,8,7.98,7.97,7.97,7.97,7.96,7.97,7.97,7.97,7.96,7.95,7.87,7.87,7.83,7.75,7.62,7.50,7.37,7.25,7.12,7.10,7,7,6.99,6.98,6.96,6.87,6.87,6.75,6.62,6.50,6.37,6.23,6.11,6,5.87,5.84,5.74,5.62,5.50,5.37,5.25,5.12,5.09,5,4.87,4.75,4.62,4.50,4.33,4.12,4.09,4,4,3.96,3.87,3.75,3.60,3.37,3.23,3.11,3,3,3,3,3,2.99,2.99,2.99,2.99,2.98,2.98,2.98,2.97,2.96,2.87,2.62,12.36,13.62,13.47,13.62,13.87,14.26,14.79,15.41,16.18,17.15,18.27,19.25,19.76,19.45,18.24,16.62,14.86,13.24,11.90,10.87,10.13,9.61,9.26,9.02,8.85,8.71,8.57,8.38,8.17,7.95,7.68,7.40,7.12,6.82,6.53,6.27,6.08,5.96,5.92,5.98,6.11,6.27,6.50,6.73,6.75,6.62,6.57,6.50,6.37,6.34,6.25,6.25,6.12,5.62,4.87,4.12,3.45,3.33,3.59,3.37,4.75,6.36,8.62,11.71,11.74,10.75,8.82,7.75,6.12,4.48,2.75,1.25,0.12,-0.76,-1.42,-1.91,-2.38,-2.75,-2.88,-3,-3,-3,-3,-3,-3,-3,-3.18,-3.52,-3.88,-4.13,-4.38,-2.38,-0.41,-2.38,-3.15,-3.89,-3.50,-3.25,-3.13,-3,-3,-3,-2.88,-2.66,-2.13,-1.55,-1.25,-1.13,-1.01,-1.13,-1.43,-1.75,-2.15,-2.50,-2.63,-2.50,-2.25,-1.64,-0.80,0.12,1.12,1.96,3,4,4,6,8,9,9,8,8,9,9,10,11,14,18,19,19,20,20,19,18,17,17,16,15.98,15,14.87,14.09,13.86,13.37,13.25,13.12,13,12.87,12.75,12.62,12.50,12.47,12.37,12.37,12.37,12.36,12.25,12.22,12.08,11.87,11.62,11.35,11,10.75,10.50,10.36,10.23,10.12,10.08,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.09,10.12,10.12,10.20,10.20,10.12,10.12,10.08,10,10,9.98,9.96,9.87,9.84,9.70,9.50,9.33,9.12,9.08,9,9,9,9,9,9.07,9.08,9.07,9,8.96,8.87,8.75,8.62,8.50,8.37,8.25,8.12,8.09,8,8,7.98,7.97,7.97,7.96,7.96,7.96,7.97,7.97,7.96,7.96,7.95,7.87,7.86,7.75,7.62,7.50,7.37,7.25,7.12,7.11,7,7,6.99,6.98,6.97,6.95,6.87,6.84,6.71,6.58,6.37,6.25,6.12,6,5.87,5.84,5.74,5.62,5.50,5.37,5.25,5.12,5.09,5,4.87,4.75,4.62,4.50,4.33,4.12,4.08,4,3.99,3.97,3.87,3.75,3.60,3.37,3.23,3.12,3,3,3,3,3,2.99,2.99,2.99,2.99,2.98,2.98,2.97,2.96,2.87,2.87,2.75,2.70,12.87,13.11,13.38,13.59,13.89,14.32,14.86,15.48,16.23,17.16,18.27,19.34,20.09,20,18.90,17.21,15.40,13.72,12.29,11.17,10.35,9.76,9.36,9.09,8.88,8.75,8.60,8.41,8.21,7.98,7.71,7.41,7.11,6.78,6.49,6.22,6.02,5.93,5.95,6.08,6.29,6.62,6.87,7.07,6.84,6.62,6.50,6.48,6.32,6.12,6.10,6.20,6.20,5.58,4.87,4.10,3.37,3.37,3.37,4,4.35,5.87,7.25,8.73,9.74,8.95,8.75,7.75,5.75,3.62,2.09,0.70,-0.50,-1.38,-1.93,-2.38,-2.65,-2.91,-3,-3,-3,-3,-3,-3,-3,-3,-3.14,-3.50,-3.77,-4.13,-4.26,-2.38,-2.38,-2.28,-3.13,-3.88,-3.42,-3.25,-3.05,-3,-3,-2.63,-2.29,-2.02,-1.66,-1.25,-1.02,-0.92,-1,-1.18,-1.50,-1.75,-2.02,-2.25,-2.26,-2,-1.63,-1,-0.17,0.72,1.57,2.09,3,4,5,7,9,11,11,10,11,13,15,16,17,19,20,20,21,20,20,18,17,16,16,15,14.97,14,14.09,13.87,13.12,13.21,13.09,13,12.87,12.75,12.61,12.46,12.32,12.20,12.11,12,11.98,11.87,11.87,11.75,11.62,11.50,11.25,11,10.75,10.50,10.37,10.23,10.12,10.08,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.07,10.11,10.12,10.12,10.12,10.10,10.08,10.07,10.10,10.12,10.23,10.25,10.33,10.33,10.25,10.21,10.12,10.07,10,9.98,9.96,9.87,9.75,9.62,9.46,9.25,9.12,9,9,8.99,8.98,8.99,8.99,8.98,8.97,8.87,8.87,8.82,8.73,8.62,8.50,8.37,8.25,8.20,8.10,8,8,7.98,7.97,7.97,7.96,7.96,7.96,7.96,7.96,7.96,7.95,7.95,7.87,7.86,7.75,7.62,7.50,7.37,7.25,7.12,7.11,7,7,6.99,6.98,6.97,6.96,6.87,6.85,6.75,6.62,6.48,6.34,6.21,6.08,5.96,5.85,5.74,5.62,5.50,5.37,5.25,5.12,5.09,5,4.87,4.75,4.62,4.50,4.33,4.12,4.08,4,3.99,3.97,3.87,3.75,3.61,3.37,3.23,3.11,3,3,3,3,3,2.99,2.99,2.99,2.99,2.98,2.98,2.97,2.95,2.87,2.87,2.75,2.62,2,12.98,13,13.26,13.52,13.88,14.34,14.91,15.58,16.36,17.30,18.36,19.41,20.29,20.30,19.28,17.53,15.82,14.20,12.73,11.52,10.58,9.92,9.47,9.15,8.92,8.77,8.62,8.45,8.24,8,7.74,7.43,7.11,6.78,6.47,6.20,6.01,5.95,5.98,6.15,6.50,6.83,7,6.75,6.58,6.37,6.36,6.25,6.12,5.87,5.85,6.07,6.25,6,5.25,4.37,3.37,3.73,3.87,4.25,4.75,5.25,6.12,6.87,7.25,7.23,6.74,5.73,4.25,2.75,1.33,0.11,-1,-1.77,-2.38,-2.65,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.02,-3.38,-3.63,-4,-4.13,-4.25,-3.25,-3.17,-4,-3.75,-3.27,-3.15,-3.01,-3,-3,-1.88,-1.63,-1.29,-1.13,-0.88,-0.76,-0.88,-1.03,-1.25,-1.38,-1.52,-1.79,-1.88,-1.75,-1.25,-0.78,-0.18,0.50,1.22,1.87,2.95,4,5,7,10,12,14,15,14,14,19,21,21,21,21,20,20,20,19,18,17,16,16,15,14.98,14,14,13.87,13.12,13.12,13,13,12.87,12.75,12.62,12.47,12.25,12.11,11.96,11.84,11.73,11.62,11.57,11.50,11.37,11.32,11.12,10.97,10.74,10.50,10.35,10.22,10.12,10.07,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.07,10.12,10.24,10.25,10.34,10.25,10.20,10.12,10.12,10.12,10.25,10.36,10.37,10.49,10.48,10.37,10.32,10.21,10.11,10,9.99,9.96,9.87,9.75,9.60,9.37,9.24,9.11,9,8.99,8.98,8.97,8.96,8.95,8.87,8.87,8.83,8.75,8.62,8.59,8.49,8.37,8.25,8.20,8.11,8,8,7.98,7.97,7.97,7.96,7.96,7.95,7.95,7.87,7.95,7.87,7.87,7.87,7.83,7.75,7.62,7.50,7.37,7.25,7.12,7.10,7,7,6.99,6.97,6.96,6.87,6.87,6.84,6.75,6.62,6.50,6.37,6.23,6.11,5.98,5.86,5.74,5.62,5.50,5.37,5.25,5.12,5.09,4.99,4.87,4.75,4.62,4.50,4.34,4.12,4.08,4,3.99,3.98,3.87,3.75,3.61,3.37,3.22,3.11,3,3,3,3,3,2.99,2.99,2.99,2.99,2.98,2.98,2.97,2.87,2.87,2.86,2.75,2.62,2.25,1.82,13,13,13.18,13.46,13.83,14.32,14.91,15.62,16.43,17.35,18.35,19.32,20.16,20.21,19.27,17.71,16.12,14.54,13.12,11.89,10.89,10.13,9.60,9.24,8.95,8.80,8.65,8.48,8.27,8.04,7.77,7.47,7.13,6.79,6.48,6.21,6.03,5.96,6,6.15,6.50,6.50,6.50,6.46,6.25,6.22,6.25,6.12,6,5.75,5.62,5.87,6.37,6.61,5.87,5.24,4.70,4.35,4.34,4.87,5.21,5.25,5.25,5.25,5.75,5.75,5,4.10,2.87,1.62,0.50,-0.53,-1.39,-2.05,-2.63,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.18,-3.50,-3.75,-3.89,-4,-4,-3.92,-3.75,-3.43,-3.17,-3.13,-3,-3,-1.90,-1.15,-0.75,-0.63,-0.64,-0.75,-0.90,-1,-1.03,-1.13,-1.15,-1.25,-1.38,-1.50,-1,-0.43,0,0.62,1.12,1.74,2.09,3,5,6,9,12,16,18,19,17,18,21,22,21,21,21,20,20,19,18,17,17,16,15,14.99,14,14,13.87,13.10,13.12,13,12.98,12.87,12.83,12.62,12.50,12.25,12.11,11.87,11.75,11.61,11.48,11.37,11.25,11.22,11.12,11,10.86,10.62,10.50,10.34,10.21,10.11,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.08,10.09,10.09,10.07,10,10.07,10.12,10.24,10.37,10.57,10.62,10.59,10.25,10.12,10.12,10.25,10.37,10.50,10.62,10.62,10.62,10.50,10.37,10.25,10.12,10.07,10,9.87,9.86,9.74,9.58,9.37,9.23,9.11,9,8.99,8.97,8.96,8.87,8.87,8.85,8.75,8.71,8.62,8.50,8.45,8.36,8.25,8.12,8.11,8,8,7.98,7.97,7.97,7.96,7.96,7.95,7.95,7.87,7.87,7.87,7.87,7.87,7.83,7.74,7.62,7.50,7.37,7.25,7.20,7.12,7,7,6.99,6.97,6.87,6.87,6.87,6.84,6.75,6.62,6.50,6.37,6.25,6.12,5.99,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.09,4.99,4.87,4.75,4.62,4.50,4.34,4.20,4.10,4,4,3.98,3.95,3.83,3.62,3.37,3.21,3.09,3,3,3,3,3,2.99,2.99,2.99,2.99,2.98,2.98,2.97,2.87,2.87,2.84,2.74,2.62,2.36,2.09,1.71,13,13,13.12,13.36,13.74,14.22,14.83,15.53,16.34,17.22,18.13,18.96,19.60,19.62,18.90,17.72,16.32,14.85,13.47,12.23,11.21,10.41,9.79,9.34,8.99,8.85,8.70,8.51,8.32,8.09,7.82,7.51,7.17,6.83,6.50,6.23,6.03,5.93,5.95,6.07,6.12,6.11,6.09,6.21,6.25,6.32,6.33,6.23,6,5.71,5.50,5.62,6,6.62,6.62,5.95,5.62,5.22,5.24,5.70,5.73,5.72,5.12,4.86,4.75,4.20,3.70,2.75,1.37,0.62,-0.38,-1.15,-1.88,-2.38,-2.79,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.18,-3.38,-3.63,-3.67,-3.68,-3.63,-3.38,-3.15,-3.13,-3,-3,-2,-1.15,-0.67,-0.50,-0.50,-0.75,-0.93,-1,-1.04,-1.04,-1,-0.90,-0.88,-0.75,-0.63,-0.15,0.37,0.96,1.37,2,2,3,4,6,8,10,14,18,22,21,20,21,21,20,20,19,19,19,19,18,17,17,16,16,15,14.98,14,13.99,13.87,13.11,13,12.99,12.87,12.86,12.73,12.50,12.35,12.12,11.95,11.75,11.59,11.37,11.25,11.20,11.11,11,10.87,10.75,10.62,10.47,10.32,10.12,10.10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.07,10.11,10.12,10.12,10.12,10.12,10.12,10.12,10.12,10.34,10.50,10.71,10.71,10.57,10.34,10.23,10.25,10.37,10.50,10.62,10.75,10.75,10.75,10.62,10.50,10.35,10.22,10.10,10,9.87,9.84,9.72,9.50,9.37,9.23,9.10,9,8.98,8.95,8.87,8.87,8.84,8.75,8.62,8.58,8.49,8.37,8.32,8.23,8.12,8.10,8,8,7.98,7.97,7.97,7.96,7.96,7.95,7.87,7.87,7.87,7.87,7.87,7.85,7.75,7.72,7.62,7.50,7.37,7.25,7.20,7.12,7.07,7,6.99,6.96,6.87,6.87,6.86,6.75,6.72,6.62,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.08,4.99,4.87,4.75,4.62,4.49,4.34,4.20,4.10,4,4,3.98,3.96,3.87,3.71,3.37,3.21,3.08,3,3,3,3,3,2.99,2.99,2.99,2.99,2.98,2.98,2.97,2.87,2.87,2.83,2.73,2.62,2.37,2.12,1.97,1.62,12.87,12.87,12.99,13.23,13.59,14.07,14.67,15.36,16.12,16.93,17.75,18.46,18.92,18.97,18.52,17.63,16.46,15.13,13.82,12.59,11.53,10.68,10.03,9.51,9.08,8.89,8.74,8.57,8.38,8.16,7.90,7.59,7.24,6.87,6.52,6.23,6.02,5.90,5.85,5.87,5.75,5.62,5.87,6.12,6.37,6.37,6.49,6.37,6.11,5.72,5.37,5.50,5.82,6.23,6.34,6.62,5.99,5.75,5.75,6.08,6.72,5.70,4.84,4.22,3.71,3.20,2.50,1.75,0.75,-0.55,-1.04,-1.75,-2.25,-2.64,-2.92,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.02,-3.14,-3.25,-3.25,-3.13,-3.05,-3,-2.88,-2.50,-1.88,-1.25,-0.75,-0.38,-0.38,-0.63,-1,-1.13,-1.14,-1.13,-0.90,-0.75,-0.53,-0.38,-0.13,0.23,0.62,1.09,1.50,1.87,2,3,4,5,7,9,13,17,20,22,21,20,20,20,19,19,19,18,18,18,17,17,17,17,16,15,14.98,14,13.99,13.87,13.12,13,12.97,12.87,12.75,12.60,12.37,12.12,11.97,11.75,11.59,11.37,11.25,11.12,11,10.96,10.86,10.73,10.59,10.37,10.25,10.12,10.10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.07,10.12,10.12,10.25,10.25,10.25,10.25,10.21,10.12,10.22,10.37,10.62,10.72,10.70,10.37,10.33,10.25,10.37,10.50,10.70,10.82,10.83,10.75,10.74,10.62,10.50,10.37,10.23,10.12,10,9.87,9.83,9.70,9.50,9.37,9.23,9.11,9,8.96,8.87,8.87,8.83,8.75,8.62,8.50,8.45,8.35,8.25,8.20,8.12,8.08,8,8,7.98,7.97,7.96,7.96,7.96,7.95,7.87,7.87,7.87,7.87,7.87,7.84,7.75,7.72,7.62,7.50,7.37,7.25,7.21,7.12,7.07,7,6.99,6.96,6.87,6.87,6.84,6.75,6.70,6.61,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.08,4.99,4.87,4.75,4.62,4.49,4.34,4.20,4.10,4,4,3.98,3.95,3.87,3.75,3.58,3.25,3.09,3,3,3,3,3,2.99,2.99,2.99,2.99,2.98,2.98,2.97,2.87,2.87,2.82,2.72,2.60,2.37,2.21,2.07,1.87,1.62,12.62,12.62,12.79,13.05,13.41,13.89,14.47,15.11,15.82,16.55,17.27,17.90,18.34,18.46,18.20,17.55,16.59,15.42,14.18,12.98,11.90,11,10.28,9.71,9.20,8.96,8.79,8.63,8.43,8.22,7.96,7.65,7.30,6.95,6.60,6.29,6.05,5.86,5.71,5.50,5.36,5.25,5.47,6.37,6.10,6.25,6.48,6.87,6.07,5.62,5.37,5.37,5.87,6.12,6.25,6.12,6.09,5.87,5.95,6.09,6.74,5.22,4.23,3.37,2.75,2.20,1.60,0.87,0.09,-0.79,-1.65,-2.25,-2.75,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.88,-2.67,-2.63,-2.51,-2.13,-1.50,-0.92,-0.64,-0.38,-0.75,-1.01,-1.15,-1.25,-1.25,-1.03,-0.78,-0.50,-0.15,0.12,0.50,0.87,1.36,1.74,2.09,2,3,4,5,7,8,11,13,18,21,21,20,20,20,19,19,19,18,18,18,17,17,17,16,16,15,15,14.97,14,13.99,13.87,13.12,13,12.97,12.87,12.71,12.47,12.21,11.98,11.75,11.59,11.37,11.25,11.12,11,10.87,10.82,10.71,10.57,10.37,10.25,10.12,10.09,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.11,10.12,10.25,10.35,10.37,10.37,10.37,10.25,10.22,10.21,10.33,10.74,10.75,10.25,10.37,10.37,10.48,10.58,10.72,10.75,10.82,10.82,10.75,10.70,10.60,10.48,10.35,10.23,10.12,10,9.87,9.83,9.70,9.50,9.37,9.23,9.10,9,8.87,8.87,8.83,8.75,8.62,8.50,8.37,8.33,8.23,8.12,8.10,8,8,8,7.98,7.97,7.96,7.95,7.95,7.95,7.87,7.87,7.87,7.87,7.87,7.84,7.75,7.71,7.62,7.50,7.37,7.25,7.21,7.12,7.08,7,6.99,6.96,6.87,6.87,6.83,6.75,6.70,6.60,6.49,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.09,4.99,4.87,4.75,4.62,4.49,4.34,4.21,4.10,4,4,3.99,3.96,3.87,3.75,3.62,3.37,3.20,3,3,3,3,3,2.99,2.99,2.99,2.98,2.98,2.97,2.96,2.87,2.86,2.75,2.62,2.50,2.37,2.25,2.11,2,1.87,1.62,12.33,12.34,12.58,12.87,13.23,13.73,14.25,14.85,15.49,16.15,16.80,17.39,17.83,18.04,17.97,17.53,16.76,15.73,14.55,13.38,12.29,11.36,10.59,9.95,9.40,9.05,8.89,8.72,8.52,8.29,8.03,7.73,7.39,7.04,6.71,6.39,6.11,5.83,5.50,5.23,4.97,4.75,4.62,4.61,5.09,5.62,6.12,6,5.57,5.35,5.37,5.70,6.09,6.70,6.25,6.12,5.87,5.75,5.74,5.71,5.20,4.45,3.45,2.59,1.86,1.24,0.62,0,-0.63,-1.38,-2.13,-2.75,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.39,-2.29,-2.38,-2.25,-2.18,-2.13,-2.05,-1.88,-1.50,-1.25,-1.13,-1,-1.05,-1.29,-1.25,-1.25,-1.13,-0.88,-0.50,-0.13,0.23,0.62,1,1.73,2,2,3,3,4,5,6,7,10,13,14,18,20,20,20,20,20,19,19,19,18,18,18,17,17,16,16,16,15,14.98,14.97,14,13.99,13.87,13.12,13,12.97,12.82,12.60,12.25,12,11.75,11.59,11.37,11.25,11.11,11,10.87,10.75,10.62,10.50,10.37,10.25,10.12,10.09,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.08,10.12,10.23,10.34,10.37,10.50,10.50,10.48,10.36,10.23,10.12,10.21,10.21,10.12,10.25,10.37,10.50,10.71,10.74,10.74,10.75,10.74,10.71,10.62,10.59,10.50,10.37,10.25,10.20,10.10,10,9.87,9.82,9.62,9.50,9.37,9.22,9.08,8.98,8.87,8.82,8.73,8.62,8.50,8.37,8.32,8.22,8.12,8.08,8,8,7.99,7.98,7.97,7.96,7.95,7.87,7.87,7.87,7.87,7.87,7.87,7.87,7.84,7.75,7.71,7.62,7.50,7.37,7.25,7.21,7.12,7.08,7,6.99,6.95,6.87,6.87,6.83,6.75,6.62,6.59,6.49,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.08,4.99,4.87,4.75,4.62,4.50,4.35,4.22,4.11,4,4,3.99,3.97,3.87,3.75,3.62,3.47,3.25,3.12,3,3,3,2.99,2.99,2.98,2.98,2.98,2.97,2.95,2.87,2.87,2.86,2.75,2.62,2.50,2.37,2.25,2.12,2,1.96,1.85,1.62,12.07,12.09,12.42,12.75,13.15,13.59,14.08,14.61,15.18,15.78,16.38,16.95,17.41,17.73,17.82,17.58,16.97,16.04,14.93,13.78,12.70,11.74,10.92,10.24,9.68,9.25,9.02,8.84,8.63,8.38,8.11,7.80,7.48,7.15,6.85,6.55,6.23,5.87,5.46,5,4.60,4.07,3.50,2.34,3.23,5.87,5.48,4.83,4.62,5.12,5.25,5.72,6.25,6.75,6.75,6.23,5.74,5.25,5.22,4.87,4.37,3.50,2.62,1.74,0.97,0.32,-0.25,-0.88,-1.42,-2.02,-2.76,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.92,-2.75,-2.42,-1.13,-1.13,-1.13,-1.38,-1.50,-1.51,-1.52,-1.55,-1.63,-1.63,-1.63,-1.50,-1.39,-1.29,-1.27,-1.38,-1.13,-0.93,-0.75,-0.42,-0.13,0.32,0.62,1.09,1.58,1.96,2,3,3,4,5,6,7,8,9,13,17.95,19.95,19.96,20,20,19.99,20,19,19,18,18,18,17,17,16,16,16,15,15,14.98,14,14,13.87,13.87,13.12,12.99,12.86,12.75,12.32,12.07,11.82,11.60,11.37,11.24,11.11,10.98,10.86,10.74,10.61,10.49,10.36,10.25,10.12,10.09,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.10,10.12,10.25,10.37,10.48,10.57,10.58,10.49,10.35,10.21,10.11,10.07,10,10.10,10.25,10.49,10.74,10.86,10.75,10.70,10.62,10.58,10.50,10.49,10.37,10.37,10.25,10.23,10.12,10.07,9.99,9.87,9.82,9.62,9.50,9.36,9.20,9,8.87,8.84,8.74,8.62,8.50,8.37,8.32,8.22,8.12,8.07,8,8,7.98,7.97,7.97,7.96,7.95,7.87,7.87,7.87,7.87,7.87,7.87,7.86,7.84,7.75,7.70,7.61,7.50,7.37,7.25,7.21,7.12,7.07,7,6.99,6.96,6.87,6.87,6.82,6.75,6.62,6.59,6.48,6.36,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.08,4.98,4.87,4.75,4.62,4.50,4.35,4.23,4.12,4,4,3.99,3.97,3.87,3.85,3.72,3.50,3.36,3.20,3.09,3,3,3,2.99,2.98,2.98,2.97,2.96,2.95,2.87,2.87,2.84,2.75,2.62,2.50,2.37,2.25,2.12,2,1.99,1.87,1.82,1.60,12.07,12.09,12.39,12.72,13.12,13.51,13.95,14.42,14.93,15.47,16.03,16.59,17.09,17.49,17.70,17.62,17.15,16.33,15.27,14.16,13.09,12.13,11.29,10.58,10,9.52,9.23,9.01,8.77,8.50,8.21,7.89,7.59,7.32,7.05,6.78,6.49,6.14,5.62,5.12,4.46,3.50,2.25,2.12,3.07,4.87,5.57,4.62,5.24,5.25,5.25,5.87,6.25,7.74,7.74,6.25,5.24,4.87,4.75,4.21,3.61,2.75,1.85,0.87,0.09,-0.54,-1.13,-1.65,-2.15,-2.90,-2.90,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.91,-2.92,-2.93,-2.88,-2.43,-1.63,-0.66,0.74,-0.13,-0.50,-0.75,-0.77,-0.78,-0.92,-1.13,-1.25,-1.40,-1.50,-1.41,-1.27,-1.13,-1.04,-0.68,-0.50,-0.18,0.12,0.50,0.85,1.12,1.50,1.95,2,2.98,3,4,5.07,6.87,7.87,8.87,8.10,11,14.87,19.87,20.87,20.08,20.08,20,20,19.96,19,18.99,18,18,17,17,16,16,15.87,15.84,15.11,14.75,14.25,14.12,13.96,13.74,13.37,13.12,12.83,12.61,12.37,12.10,11.85,11.62,11.37,11.24,11.10,10.98,10.85,10.72,10.58,10.37,10.32,10.21,10.12,10.07,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.07,10.12,10.12,10.25,10.37,10.45,10.50,10.48,10.37,10.25,10.12,10,10,10,10,10.25,10.50,10.62,10.72,10.62,10.50,10.37,10.37,10.34,10.32,10.25,10.24,10.12,10.12,10.09,10,9.97,9.87,9.75,9.62,9.50,9.34,9.12,9,8.87,8.75,8.62,8.50,8.37,8.32,8.22,8.12,8.07,8,7.99,7.98,7.97,7.96,7.96,7.95,7.87,7.87,7.87,7.87,7.87,7.87,7.86,7.83,7.75,7.70,7.61,7.50,7.37,7.25,7.21,7.12,7.07,7,6.99,6.96,6.87,6.87,6.82,6.75,6.62,6.59,6.48,6.36,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.08,4.97,4.87,4.75,4.62,4.49,4.36,4.23,4.12,4,4,3.99,3.98,3.95,3.87,3.75,3.62,3.37,3.25,3.12,3,3,3,2.99,2.99,2.98,2.97,2.97,2.95,2.87,2.87,2.83,2.75,2.62,2.50,2.37,2.25,2.12,2,1.99,1.87,1.86,1.73,1.50,12.33,12.34,12.41,12.79,13.13,13.49,13.87,14.29,14.75,15.24,15.76,16.29,16.82,17.26,17.55,17.59,17.24,16.51,15.53,14.48,13.46,12.51,11.67,10.96,10.36,9.90,9.49,9.24,8.96,8.64,8.30,7.98,7.71,7.48,7.32,7.15,6.93,6.61,6.12,5.50,4.62,3.35,2.08,2,4.24,5.84,6.50,6.48,6.23,6.12,6.12,6.24,6.75,7.08,7.75,6.12,5.12,4.21,3.87,3.37,2.84,1.98,1.07,0.12,-0.68,-1.38,-1.88,-2.39,-2.75,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.92,-2.89,-2.88,-2.75,-2.67,-2.75,-2.75,-2.63,-2.05,-1.25,0.09,0.62,0.23,-0.13,-0.13,-0.13,-0.13,-0.26,-0.50,-0.75,-1,-1.13,-1.03,-0.88,-0.63,-0.38,-0.05,0.21,0.49,0.82,1.12,1.46,1.62,1.96,2.07,2.95,3.07,4.08,5.10,7.11,8.87,9.87,9.87,9.12,11.12,15.11,18.87,20.87,20.87,20.11,20.11,20.10,19.87,19.07,18.95,18,17,17,16.08,16,15.75,15.70,15.20,14.75,14.36,14.11,13.87,13.82,13.50,13.20,12.87,12.61,12.36,12.11,11.86,11.62,11.37,11.24,11.10,10.98,10.86,10.72,10.57,10.37,10.25,10.12,10.10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.07,10.10,10.12,10.20,10.25,10.32,10.36,10.36,10.33,10.25,10.12,10.07,10,10,10,10,10.22,10.37,10.50,10.50,10.45,10.34,10.25,10.21,10.12,10.12,10.12,10.12,10.10,10.07,10,9.99,9.95,9.87,9.75,9.62,9.47,9.25,9.11,8.87,8.75,8.62,8.50,8.37,8.25,8.22,8.12,8.08,8,7.99,7.98,7.97,7.96,7.96,7.95,7.87,7.87,7.87,7.87,7.87,7.87,7.85,7.82,7.75,7.70,7.61,7.50,7.37,7.25,7.20,7.12,7.07,7,6.99,6.96,6.87,6.87,6.83,6.75,6.62,6.58,6.47,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.08,4.97,4.87,4.75,4.62,4.49,4.36,4.24,4.12,4.07,4,4,3.98,3.96,3.87,3.84,3.62,3.50,3.35,3.20,3.09,3,3,2.99,2.98,2.98,2.98,2.97,2.96,2.87,2.87,2.84,2.75,2.62,2.50,2.37,2.25,2.12,2.07,2,1.87,1.86,1.73,1.50,1.37,12.62,12.62,12.75,12.91,13.20,13.50,13.84,14.22,14.62,15.07,15.55,16.07,16.58,17.02,17.35,17.43,17.17,16.55,15.68,14.73,13.77,12.87,12.05,11.36,10.76,10.28,9.85,9.51,9.15,8.77,8.40,8.08,7.84,7.70,7.66,7.63,7.54,7.21,6.71,6.09,4.87,3.25,1.87,3.37,5.50,8.37,8.50,7.87,7.75,7.22,6.87,6.75,6.75,6.75,6.21,5.75,4.75,3.82,3.08,2.50,1.87,1.12,0.25,-0.53,-1.38,-1.92,-2.38,-2.79,-3,-3,-3,-3,-1.03,-1.50,-1.78,-2.43,-2.79,-2.79,-2.75,-2.63,-2.42,-2.27,-2.25,-2.25,-2.25,-2.02,-1.63,-0.77,0.07,0.62,0.11,0.21,0.37,0.50,0.50,0.37,0.21,-0.02,-0.25,-0.38,-0.25,-0.04,0.24,0.50,0.71,0.95,1.22,1.50,1.87,2.12,2.25,2.08,2.87,3.08,4.10,5.12,6.87,8.99,11.85,12.85,10.87,10.12,11.12,14.12,19.84,20.84,21.12,20.99,20.86,20.11,19.87,19,18.08,17.87,17.11,16.75,16.12,15.72,15.37,15.12,14.75,14.37,14,13.83,13.62,13.48,13.25,12.87,12.62,12.37,12.11,11.86,11.62,11.37,11.24,11.10,10.97,10.85,10.73,10.57,10.37,10.25,10.12,10.09,10,10,10,10,10,10.07,10.11,10.12,10.12,10.12,10.12,10.12,10.12,10.12,10.12,10.12,10.12,10.12,10.12,10.12,10.12,10.21,10.23,10.24,10.24,10.22,10.12,10.10,10,10,10,10,10,10,10.12,10.25,10.33,10.32,10.25,10.12,10.12,10.09,10.07,10.07,10,10,10,10,9.99,9.96,9.87,9.83,9.72,9.58,9.37,9.22,9,8.85,8.62,8.50,8.37,8.25,8.21,8.12,8.07,8,8,7.98,7.97,7.96,7.96,7.95,7.95,7.87,7.87,7.87,7.87,7.87,7.85,7.82,7.75,7.70,7.61,7.50,7.37,7.25,7.20,7.12,7.07,7,6.99,6.96,6.87,6.87,6.83,6.75,6.62,6.59,6.48,6.36,6.24,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.08,4.97,4.87,4.75,4.62,4.49,4.36,4.24,4.12,4.07,4,4,3.98,3.97,3.87,3.87,3.75,3.61,3.37,3.25,3.12,3,3,2.99,2.98,2.97,2.97,2.97,2.96,2.87,2.87,2.85,2.75,2.62,2.50,2.37,2.25,2.12,2.07,2,1.87,1.85,1.73,1.57,1.37,1.23,12.86,12.86,12.87,13.03,13.25,13.53,13.85,14.18,14.55,14.97,15.41,15.89,16.37,16.79,17.09,17.17,16.98,16.48,15.75,14.91,14.04,13.21,12.43,11.76,11.17,10.66,10.22,9.83,9.38,8.91,8.47,8.11,7.91,7.88,7.97,8.17,8.11,7.75,7.21,6.50,5.12,2.75,1.73,3.37,7.49,9.62,9.75,8.96,8.82,8.09,7.82,6.98,6.12,6.11,5.82,4.99,4.12,3.12,2.12,1.50,0.87,0.25,-0.50,-1.18,-1.88,-2.38,-2.75,-3,-3,-3,-3,-3,-1.50,0.09,-1.38,-2,-2.42,-2.41,-2.30,-2,-1.75,-1.51,-1.50,-1.50,-1.39,-1.15,-0.75,-0.13,0.37,0.62,0.62,0.75,0.87,1,1.08,1,0.87,0.75,0.62,0.62,0.75,0.87,1.09,1.25,1.47,1.71,1.87,2.22,2.62,2.98,3,3.08,3.87,4.12,5.12,6.12,8.12,10.84,12.83,12.12,11.87,11.20,13.20,16.20,19.20,21.75,21.86,21.83,20.87,20.11,19.12,18.87,18.12,17.24,16.96,16.37,15.87,15.48,15.12,14.75,14.47,14.12,13.83,13.50,13.25,13.09,12.86,12.61,12.36,12.12,11.87,11.62,11.37,11.23,11.09,10.97,10.85,10.71,10.50,10.37,10.25,10.12,10.08,10,10,10,10,10,10.09,10.12,10.23,10.25,10.34,10.35,10.33,10.25,10.25,10.25,10.25,10.25,10.25,10.23,10.20,10.12,10.20,10.21,10.21,10.12,10.12,10.10,10,10,10,10,10,10,10,10,10.08,10.12,10.12,10.12,10.12,10.08,10,10,10,10,10,10,9.99,9.98,9.96,9.87,9.86,9.75,9.62,9.49,9.25,9.11,8.87,8.73,8.57,8.37,8.25,8.21,8.12,8.07,8,7.99,7.98,7.97,7.96,7.95,7.95,7.95,7.87,7.87,7.87,7.87,7.87,7.84,7.82,7.75,7.62,7.60,7.50,7.37,7.25,7.12,7.11,7,7,6.99,6.96,6.87,6.87,6.84,6.75,6.62,6.59,6.48,6.36,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.07,4.96,4.86,4.74,4.62,4.50,4.37,4.25,4.12,4.08,4,4,3.99,3.97,3.87,3.87,3.75,3.62,3.50,3.35,3.20,3.09,3,3,2.98,2.97,2.97,2.97,2.96,2.87,2.87,2.85,2.75,2.62,2.50,2.37,2.25,2.12,2.08,2,1.87,1.84,1.73,1.57,1.37,1.23,1.11,12.62,12.62,12.75,13,13.26,13.55,13.86,14.17,14.52,14.90,15.33,15.76,16.20,16.58,16.83,16.90,16.74,16.34,15.75,15.03,14.27,13.51,12.79,12.14,11.57,11.04,10.57,10.11,9.58,9.03,8.52,8.13,7.92,7.91,8.14,8.48,8.48,8.09,7.57,6.97,5.45,2.58,1.49,1.37,1.25,7.86,8.85,9.85,9.12,8.85,8,7.12,6.12,5.87,5.12,4.12,3.87,2.87,1.12,0.62,0,-0.63,-1.25,-1.88,-2.38,-2.68,-2.89,-3,-3,-3,-3,-2.51,-1.75,-1.38,-1.38,-1.63,-1.75,-1.64,-1.50,-1.25,-1,-0.80,-0.75,-0.63,-0.50,-0.25,0.12,0.50,0.87,1.12,1.24,1.34,1.37,1.50,1.59,1.57,1.50,1.46,1.37,1.45,1.50,1.60,1.62,1.75,1.99,2.22,2.46,2.75,3.07,3.87,4.09,5.11,5.12,6.12,6.12,8.12,10,11.98,13.75,13.22,13.12,12.22,14.22,18.12,21.75,22.75,22.75,21.75,20.98,20,19.12,18.75,18.07,17.37,16.75,16.25,15.75,15.34,14.87,14.50,14.24,13.87,13.62,13.33,12.98,12.74,12.50,12.25,12.11,11.87,11.62,11.37,11.22,11.08,10.98,10.86,10.72,10.50,10.37,10.25,10.12,10.07,10,10,10,10,10,10.08,10.12,10.25,10.37,10.50,10.50,10.57,10.50,10.50,10.48,10.46,10.46,10.45,10.37,10.35,10.25,10.23,10.21,10.20,10.12,10.12,10.08,10,10,10,10,10,11,10.08,10,10,10,10,10.07,10,10,10,10,10,10,9.99,9.99,9.99,9.98,9.97,9.87,9.87,9.75,9.70,9.50,9.37,9.12,8.98,8.75,8.60,8.37,8.25,8.21,8.12,8,8,7.99,7.97,7.96,7.96,7.95,7.95,7.87,7.87,7.87,7.87,7.87,7.87,7.84,7.75,7.75,7.62,7.60,7.50,7.37,7.25,7.12,7.11,7,7,6.99,6.96,6.87,6.87,6.84,6.75,6.62,6.59,6.48,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.07,4.96,4.85,4.74,4.62,4.50,4.37,4.25,4.12,4.09,4,4,3.99,3.97,3.95,3.87,3.85,3.74,3.60,3.37,3.25,3.12,3,3,2.99,2.97,2.97,2.96,2.95,2.87,2.87,2.85,2.75,2.62,2.50,2.37,2.25,2.12,2.08,2,1.87,1.83,1.72,1.57,1.37,1.24,1.11,1,12.33,12.35,12.37,12.90,13.24,13.55,13.86,14.17,14.52,14.88,15.27,15.67,16.05,16.39,16.61,16.66,16.53,16.21,15.73,15.12,14.46,13.77,13.11,12.49,11.91,11.38,10.88,10.37,9.74,9.10,8.50,8.03,7.77,7.76,7.98,8.32,8.35,7.87,7.61,7.50,6.59,4.62,1.24,-0.88,-0.91,1.10,6.87,9.87,9.87,8.98,8.12,7.87,6.87,5.87,5.11,4.11,3.10,2.09,1.09,0.22,-0.51,-1.25,-2,-2.43,-2.63,-2.79,-2.92,-3,-3,-3,-2.91,-2.63,-2.05,-1.63,-1.38,-1.25,-1.13,-0.89,-0.66,-0.50,-0.25,-0.13,0,0.20,0.37,0.60,0.87,1.20,1.48,1.62,1.75,1.82,1.85,1.99,2.12,2.23,2.09,2.25,2.24,2.25,2.25,2.25,2.25,2.25,2.50,3,3,3,4.07,5.10,6.12,7.87,8.84,9.12,9.20,10.21,11.22,13.75,14.75,15,15,15.25,17.25,20.75,22.75,22.75,22.09,21.75,20.85,20,19.25,18.61,18,17.36,16.75,16.24,15.73,15.21,14.74,14.32,13.99,13.71,13.46,13.12,12.82,12.49,12.24,12.08,11.87,11.71,11.46,11.24,11.08,10.98,10.87,10.73,10.57,10.37,10.25,10.12,10.08,10,10,9.99,9.99,10,10,10.12,10.25,10.45,10.61,10.72,10.75,10.75,10.75,10.75,10.71,10.62,10.62,10.62,10.50,10.46,10.33,10.24,10.12,10.12,10.12,10.11,10,10,10,10,10,10,10,10.12,10,10,10,10,10,10,10,10,10,10,10,9.99,9.98,9.98,9.97,9.95,9.87,9.83,9.73,9.59,9.37,9.22,9,8.82,8.62,8.46,8.32,8.21,8.12,8,8,7.99,7.97,7.96,7.95,7.95,7.87,7.87,7.87,7.87,7.87,7.87,7.87,7.84,7.75,7.74,7.62,7.60,7.50,7.37,7.25,7.12,7.11,7,7,6.98,6.96,6.87,6.87,6.85,6.75,6.70,6.60,6.49,6.37,6.25,6.12,5.99,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.07,4.96,4.85,4.74,4.62,4.50,4.37,4.25,4.20,4.12,4,4,3.99,3.97,3.95,3.87,3.87,3.75,3.62,3.50,3.34,3.20,3.09,3,3,2.98,2.96,2.96,2.87,2.87,2.87,2.84,2.75,2.62,2.50,2.37,2.25,2.12,2.07,2,1.87,1.83,1.71,1.57,1.37,1.25,1.12,1.10,1.08,12.12,12.12,12.37,12.80,13.20,13.53,13.85,14.17,14.51,14.87,15.24,15.61,15.96,16.24,16.42,16.48,16.37,16.10,15.70,15.17,14.59,13.98,13.36,12.77,12.21,11.66,11.14,10.57,9.85,9.12,8.41,7.80,7.42,7.36,7.58,7.75,7.62,7.34,7.12,7.73,7.83,4.87,1,-1,-0.65,1.37,5.62,8.87,9.87,8.87,8.87,7.87,6.87,5.87,4.87,4.87,2.95,1.95,0.75,-0.13,-1,-1.75,-2.43,-2.75,-2.88,-2.91,-3,-3,-2.93,-2.88,-2.67,-2.50,-2,-1.50,-1.13,-0.75,-0.42,-0.16,0.07,0.25,0.47,0.62,0.75,0.96,1.12,1.37,1.62,1.87,2.12,2.37,2.46,2.35,2.22,2.12,2.85,3,3.12,3.12,3.37,3.37,3.37,3.37,3.35,3.33,3,4,4.97,5.07,5.10,6.12,9.12,11.84,12.83,12.21,12.75,12.23,14.25,16.75,16.25,17.11,17.25,18.23,19.25,21.73,21.96,21.87,21.25,20.98,20.75,19.75,19.07,18.46,17.87,17.25,16.75,16.22,15.62,15.10,14.58,14.10,13.72,13.45,13.25,13,12.72,12.37,12.12,11.96,11.75,11.57,11.32,11.12,10.99,10.87,10.75,10.58,10.37,10.24,10.12,10,9.99,9.95,9.87,9.96,9.96,9.97,10,10.12,10.36,10.59,10.75,10.87,10.96,10.98,10.98,10.95,10.87,10.86,10.83,10.75,10.62,10.50,10.36,10.23,10.12,10.12,10.10,10.07,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9.99,9.98,9.96,9.87,9.85,9.75,9.62,9.45,9.25,9,8.84,8.62,8.47,8.33,8.21,8.12,8,8,7.98,7.97,7.96,7.95,7.95,7.87,7.87,7.87,7.87,7.87,7.87,7.87,7.85,7.75,7.74,7.62,7.60,7.50,7.37,7.25,7.20,7.11,7,7,6.98,6.96,6.87,6.87,6.85,6.75,6.71,6.60,6.49,6.37,6.24,6.12,5.99,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.96,4.85,4.74,4.62,4.50,4.37,4.25,4.21,4.12,4.07,4,3.99,3.97,3.87,3.87,3.87,3.75,3.71,3.58,3.37,3.25,3.12,3,3,2.99,2.97,2.95,2.87,2.87,2.87,2.83,2.75,2.62,2.50,2.37,2.25,2.12,2.07,1.99,1.87,1.83,1.70,1.50,1.37,1.25,1.12,1.12,1.12,1.12,12.34,12.36,12.37,12.85,13.18,13.49,13.82,14.15,14.51,14.86,15.22,15.57,15.88,16.12,16.28,16.32,16.22,15.99,15.64,15.18,14.66,14.10,13.53,12.97,12.42,11.88,11.33,10.71,9.89,9.05,8.24,7.47,6.87,6.75,6.84,6.87,6.84,6.83,6.12,6,6,5,1,-1,-0.88,0.50,2.75,5.75,7.95,7,7,6.95,6.95,5,4,3,2,1.49,0.48,-0.43,-1.25,-2,-3,-2.88,-2.89,-2.91,-2.92,-2.79,-2.63,-2.43,-2.25,-1.89,-1.43,-1,-0.50,-0.13,0.25,0.58,0.75,1,1.12,1.33,1.50,1.71,1.87,2.20,2.46,2.73,3,3.34,3.57,3.61,3.49,3.33,3.87,4.12,4.12,4.87,5.10,5.11,5.09,5.07,5,5,5,6,7,8,9.12,10.12,13.10,15.75,15.21,15.75,16.09,16.75,17.74,18.73,19.73,19.25,19.75,20.70,21.70,21.70,21.75,21.25,20.87,20.25,19.87,19.37,18.75,18.12,17.62,17.12,16.62,16.12,15.60,15,14.50,13.95,13.57,13.22,13.12,12.87,12.62,12.34,12.10,11.87,11.72,11.45,11.21,11,10.87,10.75,10.61,10.37,10.23,10.11,10,9.96,9.87,9.84,9.83,9.84,9.87,9.87,9.96,10.12,10.37,10.62,10.87,11,11.08,11.09,11.09,11.07,11,10.99,10.87,10.86,10.74,10.50,10.36,10.12,10.10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.08,10.10,10.10,10.08,10,10,9.99,9.97,9.87,9.87,9.75,9.62,9.47,9.25,9.07,8.85,8.62,8.47,8.33,8.21,8.12,8,8,7.98,7.97,7.96,7.96,7.95,7.95,7.87,7.87,7.87,7.87,7.87,7.87,7.86,7.75,7.75,7.62,7.59,7.50,7.37,7.25,7.20,7.11,7,7,6.98,6.96,6.87,6.87,6.85,6.75,6.71,6.61,6.50,6.37,6.25,6.12,5.99,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.95,4.85,4.74,4.62,4.50,4.37,4.25,4.21,4.12,4.08,4,4,3.97,3.95,3.87,3.87,3.83,3.74,3.62,3.48,3.33,3.20,3.09,3,3,2.97,2.96,2.87,2.87,2.87,2.82,2.74,2.62,2.50,2.37,2.25,2.12,2,1.99,1.87,1.82,1.70,1.50,1.37,1.25,1.20,1.12,1.25,1.32,1.33,12.62,12.75,12.87,13,13.15,13.42,13.76,14.12,14.49,14.85,15.20,15.52,15.79,16.01,16.14,16.16,16.08,15.87,15.57,15.15,14.68,14.16,13.62,13.08,12.53,11.99,11.41,10.84,9.91,8.96,8.01,7.12,6,6,6,6,6,6,5,5,5,4,1,-1,-1.75,-0.52,1,2.50,6,5,6,6,5,4,3,2,1,0.75,-0.03,-0.76,-1.41,-2,-3,-2.80,-2.75,-2.66,-2.63,-2,-1.88,-1.65,-1.39,-1.04,-0.63,-0.15,0.25,0.72,1.08,1.37,1.61,1.75,1.87,2.08,2.25,2.50,2.86,3.12,3.47,3.74,4.12,4.72,5.22,5.48,5.49,5.34,5.23,5.24,6.83,6.83,7.12,7.12,8,8.11,7.99,7.07,7.07,7.95,9.09,11,13.10,15.84,17.75,17.87,18.23,18.75,19.74,19.73,20.72,20.71,20.70,21.70,21.62,21.62,21.62,21.74,21.62,21.21,20.75,20.25,19.48,19.07,18.46,17.84,17.25,16.82,16.37,16,15.57,15.09,14.59,14.09,13.71,13.36,13.12,12.95,12.62,12.34,12.10,11.87,11.62,11.37,11.12,11,10.87,10.71,10.47,10.25,10.10,10,9.96,9.87,9.75,9.62,9.62,9.62,9.73,9.74,9.83,10,10.36,10.70,10.96,11.10,11.12,11.12,11.12,11.11,11.08,11,10.98,10.87,10.75,10.50,10.34,10.12,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.09,10.12,10.12,10.20,10.12,10.12,10.11,10,10,9.95,9.87,9.75,9.62,9.48,9.25,9.08,8.86,8.62,8.47,8.32,8.20,8.11,8,8,7.99,7.97,7.96,7.96,7.95,7.95,7.87,7.87,7.87,7.87,7.87,7.87,7.85,7.82,7.75,7.62,7.59,7.49,7.37,7.25,7.20,7.11,7,7,6.98,6.96,6.87,6.87,6.85,6.75,6.71,6.61,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.95,4.84,4.73,4.62,4.50,4.37,4.25,4.22,4.12,4.08,4,4,3.98,3.96,3.87,3.87,3.83,3.75,3.62,3.50,3.37,3.25,3.12,3,3,2.98,2.96,2.95,2.87,2.87,2.82,2.73,2.62,2.50,2.37,2.25,2.12,2,1.98,1.87,1.82,1.70,1.50,1.37,1.25,1.12,1.12,1.23,1.37,1.50,1.46,12.87,12.98,13.61,13,13,13.34,13.70,14.08,14.46,14.82,15.15,15.46,15.71,15.89,16,16.01,15.92,15.74,15.46,15.08,14.64,14.15,13.63,13.10,12.53,11.97,11.33,10.72,9.72,8.70,7.68,6.67,6,5,5,5,5,5,4.23,4,3.57,2.57,0.87,-0.77,-2,-1.13,-0.27,1,1,3,4,5,4,4,3,1.33,0.50,-0.15,-0.75,-1.25,-2,-2,-2,-1.38,-1.27,-1.14,-1.03,-0.88,-0.75,-0.53,-0.27,0.08,0.37,0.75,1.23,1.62,1.98,2.25,2.50,2.71,2.85,2.87,3.12,3.50,4,4.37,4.74,5.12,5.62,6.37,7.10,7.87,7.62,7.34,6.62,6.46,7.25,8.75,9.75,10.12,11.85,11.87,10.87,10.87,9.11,9.12,11.11,13.86,16.84,19.75,20.75,20.75,20.75,20.74,19.97,20.09,20.25,20.62,21.07,21.62,21.62,21.33,21.34,21.62,21.25,21.08,20.75,20.50,19.70,18.96,18.25,17.57,16.96,16.50,16.23,15.96,15.62,15.25,14.84,14.37,14,13.62,13.35,13,12.70,12.34,12.10,11.87,11.62,11.35,11.12,10.98,10.86,10.62,10.37,10.12,10,9.96,9.87,9.75,9.61,9.50,9.46,9.48,9.50,9.50,9.62,9.95,10.32,10.62,10.95,11.08,11.11,11.10,11.09,11.09,11.07,11,10.96,10.87,10.70,10.50,10.25,10.11,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10.11,10.20,10.25,10.33,10.35,10.32,10.25,10.12,10.08,9.99,9.87,9.75,9.62,9.50,9.25,9.08,8.86,8.62,8.46,8.25,8.12,8.10,8,8,7.99,7.98,7.97,7.96,7.96,7.96,7.95,7.87,7.87,7.87,7.87,7.87,7.84,7.75,7.75,7.62,7.60,7.50,7.37,7.25,7.21,7.11,7,7,6.99,6.96,6.87,6.87,6.85,6.75,6.71,6.61,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.87,4.83,4.73,4.62,4.50,4.37,4.25,4.22,4.12,4.08,4,4,3.98,3.97,3.87,3.87,3.85,3.75,3.62,3.57,3.37,3.25,3.12,3.09,3,2.99,2.97,2.95,2.87,2.87,2.83,2.74,2.62,2.50,2.37,2.25,2.12,2,1.98,1.87,1.82,1.70,1.50,1.37,1.25,1.12,1.12,1.12,1.25,1.48,1.61,1.50,12.62,12.75,12.75,12.85,12.87,13.24,13.64,14.03,14.41,14.77,15.10,15.38,15.60,15.76,15.85,15.85,15.76,15.59,15.32,14.97,14.55,14.09,13.58,13,12.41,11.76,11.07,10.45,9.40,8.33,7.26,6.27,5,5,4,4,4,3.84,3.58,3.12,2.50,1.50,0.46,-0.88,-1.77,-1.88,-0.89,-0.01,1.10,2,3,4,3,2,1,0.50,-0.25,-1,-2,-2,-2,-1,-1,-0.67,0.34,0.22,0.34,0.48,0.62,0.84,1.07,1.34,1.62,1.97,2.25,2.62,3,3.37,3.62,3.86,4,4.25,4.60,5.12,5.59,5.87,6.25,6.73,7.37,8.12,9,9.73,9.87,9.62,8.87,9.12,9.50,10.25,11.75,13.75,12.83,13.85,13.87,11.97,11.12,11.12,13,15.84,17.83,19.75,20.75,21.75,20.74,20.10,19.75,19.75,19.99,20.32,20.62,20.86,20.85,20.74,20.73,20.74,20.74,20.62,20.59,20.37,19.62,18.87,18.12,17.37,16.75,16.37,16.12,15.99,15.75,15.50,15.12,14.70,14.25,13.87,13.50,13.11,12.73,12.34,12.10,11.87,11.62,11.34,11.11,10.98,10.85,10.62,10.35,10.12,9.97,9.87,9.75,9.58,9.37,9.25,9.25,9.32,9.37,9.47,9.60,9.87,10.25,10.61,10.84,10.96,11,11,11,11,11,10.99,10.87,10.75,10.61,10.25,10.21,10.11,10.09,10,10,10,10,10,10,10,10,10,10,10,10,10,10.11,10.22,10.34,10.45,10.50,10.50,10.45,10.34,10.21,10.08,9.95,9.83,9.62,9.50,9.25,9.09,8.86,8.62,8.46,8.25,8.12,8.09,8,8,7.99,7.98,7.97,7.97,7.97,7.97,7.96,7.95,7.87,7.87,7.87,7.87,7.84,7.75,7.75,7.62,7.60,7.50,7.37,7.25,7.21,7.12,7,7,6.99,6.97,6.87,6.87,6.85,6.75,6.71,6.61,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.87,4.83,4.72,4.61,4.50,4.37,4.25,4.22,4.12,4.08,4,4,3.99,3.97,3.96,3.87,3.87,3.82,3.72,3.61,3.48,3.35,3.23,3.12,3,3,2.98,2.95,2.87,2.87,2.83,2.75,2.62,2.50,2.37,2.25,2.12,2,1.98,1.87,1.82,1.70,1.50,1.37,1.25,1.12,1.09,1.11,1.22,1.37,1.60,1.62,1.61,12.33,12.34,12.36,12.36,12.75,13.18,13.62,14.01,14.38,14.73,15.03,15.28,15.48,15.62,15.68,15.68,15.59,15.41,15.16,14.84,14.43,13.97,13.42,12.84,12.20,11.46,10.70,9.91,8.97,7.88,6.82,5.74,5,4,4,3,3,3,2.75,2.32,1.62,0.75,-0.38,-1.15,-1.88,-2,-1.41,-0.50,0.50,2,2,1,1,0.62,0.25,-0.28,-0.75,-1.25,-2,-2,-1.13,-0.50,0.21,0.73,1.12,1.45,1.62,1.84,2,2.32,2.57,2.75,3,3.25,3.57,3.95,4.34,4.71,5,5.47,6,6.62,7.08,7.32,7.47,7.62,7.97,8.48,9.12,10,10.87,11.75,12.25,12.37,12.12,11.87,11.75,11.50,12.21,12.23,13.20,13.86,13.86,13.12,12.95,13.21,14.22,16.11,17.86,19.08,19.87,20.10,19.87,19.25,19.32,19.33,19.62,19.75,19.99,20.09,19.97,19.75,19.73,19.84,19.87,19.87,19.85,19.62,19.21,18.58,17.87,17.25,16.62,16.25,16,15.96,15.97,15.75,15.24,14.75,14.37,13.98,13.49,13.07,12.62,12.25,12.09,11.87,11.62,11.34,11.11,10.96,10.83,10.60,10.32,10.08,9.87,9.75,9.59,9.37,9.24,9.12,9.12,9.25,9.37,9.50,9.72,10.07,10.33,10.50,10.50,10.70,10.84,10.97,11,11,10.99,10.96,10.75,10.72,10.20,10.12,10.12,10.87,10.07,10,10,10,10,10,10,10,10,10,10,10,10,10.09,10.20,10.36,10.50,10.61,10.62,10.60,10.50,10.36,10.20,10,9.87,9.70,9.50,9.25,9.09,8.86,8.62,8.45,8.25,8.12,8.09,8,8,7.99,7.98,7.98,7.98,7.98,7.98,7.98,7.97,7.96,7.87,7.87,7.87,7.84,7.75,7.73,7.62,7.61,7.50,7.37,7.25,7.22,7.12,7,7,6.99,6.96,6.95,6.87,6.86,6.75,6.71,6.61,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.87,4.82,4.71,4.61,4.50,4.37,4.25,4.22,4.12,4.08,4,4,3.99,3.98,3.96,3.95,3.87,3.85,3.75,3.62,3.50,3.37,3.25,3.12,3.08,3,2.99,2.96,2.87,2.87,2.83,2.75,2.62,2.50,2.37,2.25,2.12,2,1.98,1.87,1.82,1.70,1.50,1.37,1.25,1.12,1.08,1.07,1.12,1.25,1.50,1.74,1.87,1.72,12,12.09,12.20,12.35,12.75,13.24,13.64,14.02,14.37,14.68,14.96,15.18,15.36,15.47,15.52,15.51,15.41,15.24,14.99,14.66,14.26,13.78,13.23,12.62,11.89,11.10,10.26,9.39,8.46,7.37,6.32,5.32,4,4,3,2.87,2.58,2.32,1.99,1.50,0.87,0.12,-0.75,-1.63,-2.25,-3,-1.91,-1.13,-0.25,1,1,0.75,-0.75,-0.63,-0.79,-1,-1,-1,-0.63,-0.50,-0.13,0.46,1.20,1.75,2.22,2.57,2.87,3.21,3.50,3.87,4.21,4.37,4.57,4.74,4.99,5.37,5.75,6.25,6.75,7.50,8.59,9.50,9.87,9.75,9.50,9.50,9.75,10.36,11.08,11.87,12.83,13.86,14.87,15.50,15.62,15.12,14,13.74,12.57,12.25,13.23,14.20,15.75,14.24,14.23,14.75,15.25,16.75,17.75,18.75,19.12,19.25,19.25,19.12,19,19.11,19.11,19.12,19.24,19.62,19,18.37,18.37,18.62,18.62,18.71,18.75,18.62,18.37,17.96,17.37,16.87,16.47,16.09,15.83,15.71,15.61,15.49,15,14.59,14.12,13.71,13.25,12.87,12.50,12.25,12,11.87,11.62,11.33,11.09,10.87,10.74,10.50,10.23,9.99,9.75,9.59,9.37,9.22,9.11,9.08,9.12,9.25,9.48,9.62,9.87,10.12,10.73,10.25,10.25,10.25,10.74,10.84,10.97,10.98,10.97,10.84,10.82,10.12,10.12,10,10.10,10.09,10,10,10,10,10,10,10,10,9.99,9.99,9.99,10,10,10.12,10.25,10.49,10.62,10.62,10.62,10.59,10.46,10.25,10.11,9.87,9.73,9.50,9.32,9.09,8.86,8.62,8.45,8.25,8.12,8.08,8,8,7.99,7.98,7.98,7.98,7.99,8,8,8,7.99,7.96,7.87,7.87,7.85,7.75,7.73,7.62,7.59,7.50,7.37,7.25,7.22,7.12,7.07,7,6.99,6.96,6.87,6.87,6.85,6.75,6.71,6.61,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.87,4.82,4.71,4.60,4.50,4.37,4.25,4.22,4.12,4.08,4,4,3.99,3.98,3.97,3.96,3.87,3.87,3.82,3.72,3.60,3.47,3.33,3.21,3.12,3,2.99,2.97,2.87,2.87,2.83,2.75,2.62,2.50,2.37,2.25,2.12,2.07,1.99,1.87,1.82,1.70,1.50,1.37,1.25,1.12,1.07,1,1.08,1.20,1.37,1.62,1.87,2.08,1.87,12,12,12.25,12.62,13,13.37,13.74,14.05,14.36,14.62,14.87,15.07,15.21,15.30,15.34,15.32,15.22,15.04,14.78,14.46,14.04,13.57,12.99,12.29,11.53,10.70,9.82,8.88,7.90,6.83,5.82,4.88,4,3,2.75,2.37,2.10,1.62,1.25,0.75,0.20,-0.52,-1.30,-2.02,-2.63,-3,-2.50,-1.88,-1.25,-1,-1,-0.91,-1.38,-1.67,-1.88,-1.63,-1,-0.38,0,0.50,1.08,1.46,2.23,2.75,3.25,3.73,4.12,4.62,5.12,5.62,5.98,6.12,6.25,6.37,6.57,6.87,7.36,7.87,8.60,9.50,10.85,13.49,13.50,11.97,11.48,11.34,11.74,12.33,13,13.72,14.62,15.96,17.48,19.24,19.37,18.75,17.75,16,14.75,15.37,15.25,15.25,15.23,15.75,15.25,16.08,16.72,17.25,17.85,18.25,18.75,19,19,19,19,18.87,18.62,18.37,18.37,18.62,18.21,17.37,17.25,17.25,17.37,17.48,17.60,17.60,17.37,17.11,16.74,16.36,15.99,15.62,15.37,15.21,15.07,14.84,14.50,14.12,13.74,13.34,12.95,12.62,12.33,12.10,11.87,11.75,11.58,11.25,11,10.75,10.58,10.33,10.08,9.83,9.60,9.37,9.22,9.10,9,9,9.12,9.25,9.50,9.75,9.87,10.11,10.12,10.12,10,10.12,10.24,10.75,10.85,10.95,10.85,10.82,10.12,10.12,10,10,10,10,10,10,10,10,10,10,10,10,9.97,9.95,9.95,9.98,10,10.12,10.32,10.50,10.62,10.62,10.58,10.47,10.32,10.12,9.95,9.75,9.50,9.32,9.09,8.86,8.62,8.37,8.25,8.12,8.07,8,8,7.99,7.98,7.99,7.99,8,8,8,8,8,8,7.97,7.87,7.87,7.75,7.74,7.62,7.58,7.49,7.37,7.25,7.22,7.12,7.07,7,6.99,6.96,6.87,6.87,6.85,6.75,6.71,6.61,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.87,4.82,4.71,4.60,4.50,4.37,4.25,4.22,4.12,4.09,4,4,3.99,3.98,3.97,3.96,3.95,3.87,3.86,3.75,3.62,3.50,3.37,3.25,3.12,3.07,3,2.96,2.87,2.87,2.83,2.75,2.62,2.50,2.37,2.25,2.12,2.07,1.98,1.87,1.82,1.70,1.50,1.37,1.25,1.12,1.07,1,1,1.11,1.25,1.50,1.83,2.12,2.33,2.08,12,12,12.32,12.70,13.12,13.70,13.82,14.07,14.33,14.57,14.74,14.91,15.03,15.11,15.13,15.09,14.99,14.80,14.54,14.21,13.82,13.28,12.65,11.93,11.14,10.28,9.38,8.36,7.33,6.26,5.29,4.42,3.97,2.87,2.32,1.96,1.50,1,0.50,-0.01,-0.63,-1.26,-1.90,-2.50,-2.78,-3,-3,-3,-2,-2,-2,-2.02,-2.25,-2.75,-3,-3,-1.50,-0.50,0.37,1.25,2.12,2.87,3.25,3.87,4.37,4.87,5.62,6.25,6.87,7.37,7.75,7.96,8.07,8.12,8.25,8.50,8.87,9.50,10.25,11.25,12.60,13.98,14.37,13.62,13.12,13.12,13.50,14.37,14.87,15.60,16.34,18,19.75,22.07,23.22,22.37,20.58,19.25,18.59,18.25,18.50,16.25,15.32,15.25,16.87,17.62,17.62,17.70,17.75,18.22,18.72,18.98,18.99,19,19.10,18.87,18.37,17.37,17.75,17.73,17.60,17,16.37,16.21,16.12,16.25,16.46,16.50,16.37,16.12,15.87,15.62,15.25,15,14.75,14.58,14.37,14.20,13.87,13.61,13.25,12.87,12.60,12.33,12.09,11.87,11.73,11.57,11.37,11.11,10.85,10.59,10.36,10.11,9.86,9.62,9.37,9.22,9.10,9,9,9,9.10,9.25,9.49,9.74,9.87,9.95,10,10,10,10,10.12,10.22,10.75,10.75,10.83,10.12,10.12,10,10,10,10,10,10,10,10,10,10,10,10,10,9.75,9.73,9.83,9.87,10,10.10,10.24,10.37,10.48,10.48,10.37,10.25,10.12,9.96,9.75,9.50,9.33,9.09,8.86,8.62,8.37,8.25,8.12,8.07,8,8,7.99,7.99,7.99,8,8,8,8,8.07,8.07,8,8,7.96,7.87,7.84,7.75,7.62,7.59,7.49,7.37,7.25,7.21,7.12,7,7,6.99,6.96,6.87,6.87,6.85,6.75,6.70,6.60,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.87,4.82,4.71,4.60,4.50,4.37,4.25,4.22,4.12,4.09,4,4,3.99,3.98,3.97,3.96,3.95,3.87,3.87,3.83,3.74,3.62,3.48,3.34,3.21,3.11,3,2.97,2.87,2.87,2.83,2.75,2.62,2.50,2.37,2.25,2.12,2,1.98,1.87,1.75,1.62,1.50,1.37,1.25,1.12,1.07,1,1,1,1.12,1.35,1.62,2,2.37,2.62,2.33,12,12.12,12.25,12.75,13.25,13.72,13.88,14.02,14.23,14.42,14.61,14.75,14.86,14.91,14.92,14.88,14.76,14.58,14.32,13.96,13.50,12.95,12.30,11.57,10.74,9.89,8.88,7.83,6.74,5.68,4.72,3.87,3,2.37,1.75,1.34,0.86,0.25,-0.25,-0.78,-1.38,-1.90,-2.50,-2.75,-2.91,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-1.75,-0.50,0.75,1.96,3,3.87,4.61,5.12,5.75,6.46,7.34,8.09,8.73,9.25,9.61,9.83,9.87,9.96,10,10.12,10.49,11,11.75,12.72,13.73,14.50,14.87,14.75,14.60,14.62,15,15.72,16.50,17.37,18.58,19.97,21.50,23,23.50,23.21,22.37,21.62,21.84,21.10,20.35,18.62,17.37,17.36,18.62,18.62,18.62,17.62,17.34,18.12,18.71,18.97,18.99,18.99,19.08,19.62,18.20,17.61,16.98,16.85,16.71,16.58,15.98,15.46,15.32,15.35,15.46,15.50,15.45,15.25,15.09,14.84,14.58,14.33,14.11,13.87,13.75,13.59,13.36,13.10,12.75,12.50,12.25,12,11.75,11.62,11.37,11.21,11,10.75,10.57,10.34,10.12,9.87,9.62,9.37,9.21,9.09,9,9,8.99,9,9,9.12,9.34,9.49,9.61,9.62,9.75,9.86,9.97,10,10,10.12,10.12,10.12,10.12,10.12,10,10,10,10,10,10,10,10,10,10,10,10,10,9,9.24,9.49,9.62,9.75,9.87,9.95,10,10.12,10.25,10.25,10.20,10.09,9.87,9.75,9.50,9.33,9.10,8.86,8.62,8.37,8.25,8.12,8.07,8,7.99,7.99,7.99,7.99,8,8,8,8.08,8.11,8.12,8.11,8.07,8,7.87,7.86,7.75,7.62,7.59,7.49,7.37,7.25,7.21,7.12,7,7,6.99,6.96,6.87,6.87,6.85,6.75,6.71,6.61,6.49,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.87,4.82,4.71,4.60,4.50,4.37,4.25,4.22,4.12,4.09,4,4,3.99,3.98,3.97,3.96,3.95,3.87,3.87,3.86,3.75,3.62,3.57,3.37,3.25,3.12,3.07,2.99,2.87,2.86,2.75,2.74,2.62,2.50,2.37,2.25,2.12,2.07,1.98,1.87,1.75,1.62,1.50,1.37,1.25,1.12,1.07,1,0.99,1,1.07,1.20,1.37,1.75,2.25,2.75,3.09,2.70,12.25,12.25,12.73,12.87,13.22,13.74,13.75,13.95,14.09,14.26,14.41,14.53,14.62,14.65,14.65,14.59,14.47,14.28,14.01,13.64,13.17,12.61,11.95,11.18,10.37,9.39,8.37,7.28,6.17,5.11,4.14,3.23,2.35,1.74,1.12,0.62,0.09,-0.50,-1.01,-1.53,-2.01,-2.43,-2.75,-2.91,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.80,-1.67,-0.40,1,3,3.87,4.95,5.84,6.71,7.50,8.37,9.24,10,10.62,11,11.37,11.62,11.82,11.84,11.75,11.83,11.99,12.37,13.07,13.87,14.75,15.37,15.75,15.87,15.86,15.87,16.25,16.98,17.95,19.12,20.37,21.62,22.87,23.48,23.62,23.50,23.21,22.98,22.75,22.87,22.12,20.45,18.57,18.12,18.59,18,17.36,17.25,17.35,18.12,18.75,18.98,18.97,18.87,18.85,18.62,17.87,17,16.34,15.37,15.86,15.82,15.50,14.87,14.59,14.50,14.62,14.62,14.62,14.50,14.34,14.12,13.87,13.62,13.49,13.35,13.21,13,12.86,12.62,12.37,12.12,11.87,11.71,11.50,11.25,11,10.85,10.62,10.47,10.25,10.08,9.87,9.62,9.37,9.21,9.09,9,9,8.99,8.99,8.99,9,9.07,9.12,9.24,9.25,9.35,9.21,9.75,9.86,9.97,9.99,9.99,10,10,10,10,10,10,10,10,10,10,10,11,10,10,10,10,9,9,9.07,9.24,9.45,9.59,9.62,9.72,9.83,9.96,10,10.08,10,9.87,9.74,9.50,9.32,9.09,8.86,8.62,8.37,8.25,8.12,8.07,8,7.99,7.99,7.99,7.99,8,8,8,8.10,8.12,8.12,8.12,8.12,8.07,7.99,7.87,7.75,7.70,7.60,7.50,7.37,7.25,7.21,7.12,7.07,7,6.99,6.96,6.87,6.87,6.86,6.75,6.71,6.61,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.87,4.82,4.71,4.60,4.50,4.37,4.25,4.23,4.12,4.10,4,4,3.99,3.98,3.97,3.96,3.95,3.87,3.87,3.87,3.83,3.74,3.62,3.50,3.36,3.23,3.11,3,2.95,2.87,2.75,2.71,2.62,2.50,2.37,2.25,2.12,2.07,1.97,1.87,1.75,1.62,1.50,1.37,1.25,1.12,1.07,1,0.99,0.99,1,1.09,1.25,1.50,1.96,2.50,3.20,3.75,3.22,12.75,12.75,12.85,12.98,13.12,13.24,13.57,13.75,13.95,14.07,14.20,14.29,14.36,14.39,14.37,14.30,14.17,13.98,13.70,13.32,12.84,12.27,11.60,10.87,9.93,8.93,7.86,6.76,5.62,4.54,3.55,2.62,1.71,1.09,0.48,-0.13,-0.67,-1.25,-1.77,-2.25,-2.75,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.75,-1.28,-0.75,1.20,3,4.82,5.74,7,8.25,9.37,10.25,11.12,11.99,12.45,12.70,12.98,13.37,13.72,13.62,13.62,13.50,13.50,13.62,14.25,15.07,15.85,16.47,16.86,17,17.11,17.12,17.37,18.10,19.12,20.47,21.99,23,23.50,23.62,23.75,23.62,23.50,23.33,23,22.75,21.12,19.74,18.62,17.98,17.62,17.25,16.87,16.37,17.37,18.62,19.09,18.99,18.75,18.62,18.25,17.86,17.20,16.37,15.59,15.12,15,15,14.74,14.25,13.87,13.87,13.87,13.87,13.87,13.83,13.70,13.50,13.25,13.11,12.87,12.75,12.62,12.50,12.37,12.23,12,11.75,11.59,11.37,11.12,10.95,10.72,10.50,10.34,10.12,10,9.83,9.62,9.37,9.20,9.08,9,9,8.99,8.99,8.98,8.96,8.87,8.87,8.87,8.97,9,9,9.12,9.12,9.83,9.83,9.84,9.85,9.86,9.87,9.98,9.99,10.08,10.07,10,9.98,10,10,10,11,10,10,10,9,9,9,9,9.12,9.24,9.32,9.36,9.46,9.62,9.75,9.87,9.95,9.87,9.72,9.50,9.25,9.07,8.85,8.62,8.37,8.25,8.12,8.07,8,7.99,7.99,7.99,7.99,7.99,8,8,8.10,8.12,8.20,8.22,8.20,8.12,8,7.95,7.84,7.72,7.61,7.50,7.37,7.25,7.22,7.12,7.07,7,6.98,6.96,6.87,6.87,6.86,6.75,6.72,6.62,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.87,4.82,4.71,4.60,4.50,4.37,4.25,4.23,4.12,4.10,4,4,4,3.98,3.97,3.96,3.96,3.87,3.87,3.87,3.84,3.75,3.62,3.50,3.37,3.25,3.12,3,2.97,2.87,2.75,2.71,2.61,2.50,2.37,2.25,2.12,2.07,1.97,1.87,1.75,1.62,1.50,1.37,1.25,1.12,1,1,0.99,0.99,1,1,1.12,1.33,1.62,2.12,2.86,3.74,4.62,3.87,12.96,12.96,12.97,12.99,13,13.12,13.35,13.55,13.73,13.87,13.98,14.05,14.11,14.12,14.10,14.02,13.89,13.68,13.40,13.01,12.52,11.96,11.28,10.48,9.52,8.49,7.38,6.25,5.09,4,2.99,2.03,1.12,0.45,-0.25,-0.88,-1.38,-1.88,-2.38,-2.65,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.66,-1.25,0.62,1.25,3.75,4.75,6.23,7.96,10.11,11.12,11.98,12.87,13.75,14.07,14.08,14.24,14.70,15.25,15.50,15.37,15.34,15.23,15,15.50,16.37,17.07,17.62,18,18.25,18.37,18.48,18.71,19.25,20.25,21.37,22.62,23.25,23.58,23.70,23.62,23.59,23.37,23.21,22.50,21.37,20.11,18.87,17.87,17.24,16.87,16.62,16.37,16.37,18,19.62,19.62,19.11,18.35,17.87,17.62,17.20,16.60,15.75,15,14.47,14.35,14.49,13.87,13.50,13.35,13.25,13.25,13.32,13.25,13.24,13.12,12.98,12.75,12.61,12.45,12.32,12.22,12.12,12,11.85,11.62,11.46,11.24,11,10.83,10.61,10.37,10.24,10.10,9.96,9.75,9.60,9.37,9.21,9.08,9,9,9,8.99,8.98,8.96,8.87,8.75,8.72,8.62,8.62,8.74,8.85,9,9.12,9.12,9.12,9.12,9.12,9.12,9.87,9.87,9.87,10,10.96,10,10,9,10,10,10,11,10,9,9,9,9,8.87,9,9.09,9.12,9.12,9.25,9.48,9.71,9.85,9.85,9.71,9.49,9.24,9,8.75,8.61,8.37,8.25,8.12,8.07,8,7.99,7.99,7.99,7.99,7.99,7.99,8,8.07,8.12,8.20,8.24,8.24,8.20,8.11,7.99,7.87,7.75,7.62,7.50,7.37,7.25,7.22,7.12,7.08,7,6.98,6.96,6.87,6.87,6.84,6.75,6.71,6.62,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.87,4.82,4.71,4.60,4.50,4.37,4.32,4.23,4.12,4.10,4,4,4,3.99,3.97,3.96,3.96,3.87,3.87,3.87,3.84,3.75,3.62,3.59,3.47,3.34,3.22,3.10,3,2.87,2.82,2.72,2.61,2.50,2.37,2.25,2.12,2.07,1.97,1.87,1.75,1.62,1.50,1.37,1.25,1.12,1,1,0.99,0.99,0.99,1,1.07,1.21,1.45,1.85,2.37,3.25,4.25,5.37,5.62,13,13,13,13,13,13,13.20,13.36,13.51,13.64,13.75,13.84,13.88,13.89,13.86,13.79,13.66,13.46,13.16,12.77,12.27,11.65,10.92,10.08,9.12,8.05,6.92,5.75,4.58,3.46,2.42,1.46,0.60,-0.17,-0.88,-1.50,-2,-2.38,-2.66,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.64,-1.02,0.62,1.99,3.25,4.72,6.25,8.34,11,12.25,13.33,14.08,14.62,15.12,14.73,14.97,15.58,16.45,17,17.12,17.22,17.12,17.12,17.37,17.87,18.45,18.87,19.25,19.50,19.70,19.82,20,20.50,21.21,22,22.75,23.25,23.50,23.50,23.45,23.25,23,22.57,21.62,20.45,19.12,17.87,16.73,16.25,16,16.12,16.35,16.37,18.60,20.59,19.87,19.62,18.12,16.37,16.75,16.61,15.87,15.12,14.45,13.87,13.70,13.50,13.24,12.97,12.83,12.75,12.75,12.75,12.75,12.71,12.62,12.49,12.33,12.12,12,11.87,11.75,11.71,11.61,11.49,11.32,11.12,10.87,10.71,10.50,10.33,10.20,10,9.87,9.75,9.59,9.37,9.22,9.09,9,9,9,8.99,8.99,8.97,8.87,8.75,8.61,8.46,8.37,8.37,8.45,8.59,8.86,8.87,9,9,9,9,9.10,9.09,9.07,9.95,9.97,9.98,10,9,9,9,10,10,10,9,9,9,8,8,8.75,9,9,9,9.08,9.12,9.37,9.60,9.72,9.62,9.46,9.12,8.87,8.70,8.50,8.37,8.25,8.12,8.07,8,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8.08,8.12,8.21,8.24,8.23,8.12,8,7.87,7.75,7.62,7.50,7.37,7.25,7.22,7.12,7.08,7,6.99,6.96,6.87,6.87,6.84,6.75,6.70,6.60,6.49,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.87,4.83,4.71,4.61,4.50,4.37,4.32,4.23,4.12,4.10,4,4,4,3.99,3.98,3.97,3.96,3.87,3.87,3.87,3.84,3.75,3.70,3.60,3.49,3.37,3.25,3.12,3,2.87,2.83,2.73,2.62,2.50,2.37,2.25,2.12,2,1.97,1.87,1.75,1.62,1.50,1.37,1.25,1.12,1.07,1,0.99,0.99,0.99,1,1,1.12,1.25,1.60,2.07,2.74,3.70,4.82,6.07,5.62,13,12.99,12.98,12.98,12.98,12.99,13.04,13.15,13.29,13.41,13.50,13.58,13.61,13.62,13.59,13.51,13.38,13.17,12.88,12.49,11.98,11.34,10.59,9.72,8.72,7.65,6.48,5.27,4.05,2.90,1.83,0.87,0,-0.75,-1.41,-1.93,-2.38,-2.63,-2.80,-2.98,-3.11,-3.17,-3.23,-3.24,-3.18,-3.12,-3.05,-3.02,-3,-3,-3,-3,-3,-3,-3,-2.64,-1.01,0.74,2.09,3.20,4.37,6,8.12,10.45,12.75,13.87,14.50,14.86,14.62,14.82,15.23,15.97,16.98,18,18.75,19.12,19.12,19.25,19.37,19.58,19.87,20.12,20.46,20.62,20.83,20.98,21.20,21.50,21.87,22.37,22.87,23.12,23.25,23.25,23.09,22.75,22.37,21.72,20.75,19.50,18.23,16.99,15.85,14.61,15.37,15.50,16.48,17.62,18.95,19.75,19.97,19.62,18,16.47,16.10,15.74,15.21,14.50,13.87,13.37,13.10,12.85,12.62,12.50,12.37,12.34,12.25,12.25,12.25,12.20,12.12,12,11.87,11.71,11.57,11.47,11.37,11.33,11.25,11.12,10.98,10.75,10.60,10.37,10.25,10.12,10,9.87,9.75,9.59,9.37,9.22,9.09,9,9,9,8.99,8.99,8.97,8.87,8.75,8.59,8.37,8.23,8.12,8.11,8.12,8.25,8.11,8.87,8.87,8.87,8.87,8.87,8.87,9,9,9,9,9,9,9,9,9,9,9,9,9,8,8,8,8,8.75,9.12,9.12,9.12,9.08,9.12,9.25,9.37,9.49,9.37,9.12,8.84,8.58,8.37,8.25,8.20,8.12,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8.08,8.12,8.12,8.20,8.12,8.07,7.95,7.75,7.62,7.50,7.37,7.25,7.22,7.12,7.08,7,6.99,6.96,6.87,6.87,6.85,6.75,6.70,6.60,6.49,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.87,4.83,4.71,4.61,4.50,4.37,4.25,4.23,4.12,4.11,4,4,4,3.99,3.98,3.97,3.96,3.87,3.87,3.87,3.84,3.75,3.70,3.60,3.50,3.37,3.25,3.12,3,2.87,2.84,2.74,2.62,2.50,2.37,2.25,2.12,2,1.96,1.87,1.75,1.62,1.50,1.37,1.25,1.12,1.07,1,0.99,0.99,0.99,0.99,1,1.07,1.12,1.37,1.75,2.25,3,4.08,5.25,6.37,5.62,12.98,12.98,12.87,12.87,12.87,12.86,12.79,12.93,13.07,13.17,13.26,13.32,13.35,13.35,13.32,13.24,13.11,12.91,12.62,12.23,11.72,11.07,10.29,9.38,8.37,7.25,6.07,4.82,3.54,2.25,1.25,0.25,-0.53,-1.25,-1.88,-2.29,-2.63,-2.78,-2.96,-3.12,-3.27,-3.40,-3.50,-3.50,-3.47,-3.34,-3.21,-3.11,-3.02,-3.01,-3.01,-3,-3,-3,-2.88,-2.25,-1,0.49,2.21,2.87,4.12,5.62,7.50,9.62,11.75,13.46,14.35,14,14.12,14.48,15.11,15.99,17.09,18.32,19.62,20.61,21.11,21.25,21.12,21.12,21.12,21.25,21.37,21.50,21.62,21.75,21.97,22.12,22.34,22.58,22.82,22.97,23,22.87,22.61,22.21,21.62,20.87,19.87,18.62,17.37,16.25,15.24,14.75,14.87,15.71,16.72,18.37,19.50,19.58,19.50,19.47,17.82,16.50,15.62,15,14.50,13.87,13.37,12.87,12.58,12.35,12.20,12.08,12,11.87,11.87,11.83,11.75,11.72,11.62,11.50,11.37,11.25,11.12,11.09,11,10.98,10.87,10.82,10.62,10.50,10.36,10.21,10.09,9.97,9.87,9.74,9.58,9.37,9.22,9.10,9,9,8.99,8.98,8.99,8.98,8.87,8.75,8.60,8.37,8.12,8.08,8,8,8,8,8.08,8.08,8.07,8.07,8,8,8.96,8.97,8.98,8.99,9,9,9,9,9,9,9,9,9,8,8,8,8,8,8.75,9.12,9.12,9.12,9,9,9.12,9.12,9.12,9,8.75,8.50,8.25,8.12,8.11,8.07,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8,8.10,8.12,8.11,8,7.96,7.83,7.62,7.50,7.37,7.25,7.22,7.12,7.08,7,6.99,6.96,6.87,6.87,6.86,6.75,6.71,6.60,6.49,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.87,4.83,4.71,4.61,4.50,4.37,4.25,4.23,4.12,4.10,4,4,4,3.99,3.98,3.97,3.96,3.87,3.87,3.87,3.85,3.75,3.70,3.61,3.50,3.37,3.25,3.12,3,2.95,2.85,2.74,2.62,2.50,2.37,2.25,2.12,2,1.96,1.87,1.75,1.62,1.50,1.37,1.25,1.12,1.08,1,1,0.99,0.99,0.99,1,1,1.11,1.25,1.50,1.87,2.47,3.25,4.37,5.62,6.62,5.62,12.87,12.87,12.87,12.09,12.09,12.14,12.55,12.71,12.84,12.93,13,13.05,13.08,13.08,13.04,12.98,12.86,12.67,12.39,12,11.49,10.84,10.03,9.10,8.04,6.89,5.64,4.40,3,1.71,0.70,-0.25,-1.13,-1.75,-2.25,-2.63,-2.88,-2.92,-3.08,-3.26,-3.50,-3.72,-3.86,-3.88,-3.78,-3.62,-3.39,-3.26,-3.13,-3.12,-3.02,-3.01,-3,-3,-2.88,-2.25,-1.15,0.12,1.37,2.50,3.62,5.09,6.74,8.62,10.50,12.24,12.87,13.12,13.35,13.87,14.75,15.75,16.87,18.25,19.62,21.12,22.12,22.62,22.50,22.25,22.12,22.12,22.12,22.12,22.12,22.12,22.22,22.25,22.35,22.37,22.50,22.59,22.50,22.34,21.99,21.49,20.83,19.98,18.98,17.84,16.70,15.62,14.87,14.22,14.87,15.75,16.87,18.12,18.62,18.75,18.62,18.25,17.25,16.12,15.25,14.50,13.87,13.35,12.84,12.37,12.10,11.87,11.75,11.71,11.62,11.57,11.50,11.37,11.35,11.25,11.21,11.11,11,10.87,10.75,10.74,10.70,10.62,10.61,10.50,10.37,10.25,10.12,10,9.95,9.86,9.73,9.57,9.37,9.24,9.10,9,8.99,8.98,8.97,8.96,8.96,8.87,8.75,8.61,8.37,8.12,8.07,8,7.99,7.99,7.99,8,7.99,7.99,7.99,7.99,7.99,8,8,8,8,8,9,9,9,9,9,9,9,9,8,8,8,8,8,8,8.82,8.96,9,9,8.87,8.87,8.87,8.87,8.83,8.62,8.45,8.25,8.12,8,8,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8,8,8,8,8,8,7.87,7.82,7.62,7.50,7.37,7.32,7.21,7.12,7.08,7,6.99,6.96,6.87,6.87,6.86,6.75,6.71,6.61,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.87,4.83,4.71,4.61,4.50,4.37,4.25,4.23,4.12,4.10,4,4,4,3.99,3.98,3.97,3.96,3.87,3.87,3.87,3.85,3.75,3.70,3.61,3.50,3.37,3.25,3.12,3,2.96,2.85,2.74,2.62,2.50,2.37,2.25,2.12,2.07,1.96,1.86,1.75,1.62,1.50,1.37,1.25,1.12,1.08,1,1,0.99,0.99,0.99,0.99,1,1.07,1.12,1.37,1.62,2,2.61,3.37,4.62,6,7.22,5.70,12.09,12.12,12.12,12.10,12.01,12.15,12.32,12.49,12.61,12.70,12.75,12.79,12.80,12.80,12.78,12.73,12.62,12.45,12.18,11.80,11.30,10.64,9.84,8.87,7.77,6.55,5.22,3.90,2.97,1.12,0.12,-0.75,-1.50,-2.13,-2.50,-2.76,-2.91,-3.02,-3.17,-3.43,-3.75,-4.08,-4.27,-4.30,-4.18,-3.98,-3.67,-3.47,-3.26,-3.21,-3.13,-3.03,-3,-3,-2.88,-2.38,-1.50,-0.38,0.83,1.87,3.10,4.46,5.99,7.62,9.33,10.83,11.62,12.10,12.60,13.36,14.25,15.36,16.59,17.95,19.37,20.82,22.12,22.86,23.07,22.87,22.75,22.62,22.50,22.37,22.25,22.12,22.07,22,21.99,21.99,22,21.98,21.86,21.60,21.12,20.62,19.87,19,18,16.98,15.96,15.12,14.50,14.25,14.83,15.70,16.75,17.75,17.83,17.75,17.60,17.12,16.45,15.61,14.75,14,13.37,12.85,12.37,11.98,11.71,11.50,11.45,11.37,11.33,11.25,11.12,11.07,10.98,10.87,10.83,10.74,10.62,10.57,10.50,10.46,10.37,10.37,10.36,10.25,10.23,10.12,10,9.87,9.83,9.73,9.57,9.37,9.24,9.12,9,8.99,8.97,8.95,8.87,8.87,8.87,8.75,8.62,8.37,8.21,8.09,8,8,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,9,8,8.12,8.62,8.62,8.62,8.62,8.62,8.62,8.60,8.50,8.37,8.22,8.10,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8,8,8,8,8,8,7.96,7.87,7.75,7.62,7.50,7.37,7.25,7.21,7.12,7.07,7,6.99,6.96,6.87,6.87,6.87,6.75,6.72,6.62,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.87,4.83,4.71,4.61,4.50,4.37,4.25,4.22,4.12,4.10,4,4,4,3.99,3.98,3.97,3.96,3.87,3.87,3.87,3.85,3.75,3.71,3.61,3.50,3.37,3.25,3.12,3.07,2.96,2.86,2.75,2.62,2.50,2.37,2.25,2.12,2.07,1.96,1.86,1.75,1.62,1.50,1.37,1.25,1.12,1.09,1,1,0.99,0.99,0.99,0.99,0.99,1,1.10,1.25,1.48,1.75,2.12,2.72,3.50,4.84,6.37,8,7.75,11.86,11.75,11.75,11.87,11.95,12.04,12.16,12.28,12.38,12.45,12.49,12.52,12.53,12.53,12.51,12.46,12.37,12.22,11.98,11.63,11.17,10.52,9.70,8.70,7.55,6.29,4.90,3.10,1.50,0.62,-0.30,-1.14,-1.80,-2.30,-2.64,-2.88,-3,-3.08,-3.25,-3.59,-4.01,-4.42,-4.71,-4.75,-4.61,-4.37,-4,-3.72,-3.47,-3.33,-3.22,-3.12,-3,-3,-2.89,-2.63,-1.88,-0.88,0.12,1.12,2.45,3.75,5.24,6.72,8.12,9.49,10.37,11,11.75,12.75,13.82,14.95,16.12,17.50,18.99,20.37,21.62,22.61,23,23,22.97,22.82,22.60,22.34,22.08,21.83,21.62,21.48,21.37,21.32,21.25,21.12,20.98,20.62,20.12,19.58,18.84,17.98,17,16.09,15.22,14.50,14.12,14.12,14.70,15.45,16.24,16.75,16.99,16.87,16.60,16.12,15.59,14.87,14.25,13.58,12.96,12.37,11.98,11.62,11.37,11.25,11.20,11.12,11.07,10.98,10.87,10.75,10.62,10.60,10.50,10.45,10.37,10.32,10.25,10.24,10.22,10.20,10.12,10.12,10.10,10,9.87,9.83,9.71,9.58,9.37,9.24,9.12,9,8.99,8.95,8.87,8.87,8.84,8.75,8.71,8.59,8.37,8.25,8.12,8.10,8.11,8.11,8.11,8.08,8,8,7.99,7.99,7.99,7.99,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8.10,8.21,8.32,8.32,8.33,8.34,8.33,8.25,8.25,8.12,8.08,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8.08,8.11,8.12,8.12,8.11,8,7.98,7.87,7.75,7.62,7.50,7.37,7.25,7.20,7.12,7.07,7,6.99,6.96,6.87,6.87,6.87,6.82,6.73,6.62,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.95,4.83,4.72,4.61,4.50,4.37,4.25,4.22,4.12,4.10,4,4,4,3.99,3.98,3.97,3.96,3.87,3.87,3.87,3.85,3.75,3.71,3.61,3.50,3.37,3.25,3.12,3.07,2.96,2.86,2.75,2.62,2.50,2.37,2.25,2.12,2.07,1.97,1.86,1.75,1.62,1.50,1.37,1.25,1.12,1.09,1,1,0.99,0.99,0.99,0.99,0.99,1,1,1.12,1.33,1.59,1.87,2.25,2.84,3.62,4.96,6.70,8.50,9.84,11.62,11.37,11.37,11.62,11.80,11.90,12,12.08,12.16,12.22,12.26,12.27,12.27,12.27,12.25,12.22,12.14,12.01,11.80,11.48,11.02,10.39,9.58,8.59,7.42,6.13,4.71,3.10,1.33,0.12,-0.88,-1.50,-2.13,-2.50,-2.76,-2.91,-3,-3.10,-3.29,-3.67,-4.21,-4.72,-5.04,-5.13,-4.96,-4.72,-4.30,-4,-3.73,-3.55,-3.36,-3.16,-2.98,-3,-2.90,-2.64,-2.13,-1.38,-0.50,0.61,1.59,3.22,4.50,5.84,7,8.12,9.08,9.87,10.97,12.12,13.36,14.59,15.87,17.21,18.60,19.96,21.12,22.07,22.62,22.82,22.75,22.62,22.37,22,21.62,21.33,21,20.75,20.62,20.50,20.37,20.21,19.95,19.58,19.07,18.37,17.70,16.87,16,15.21,14.50,14,13.86,14,14.48,15.09,15.62,16,16.12,16,15.74,15.32,14.75,14.25,13.62,13.08,12.50,12,11.62,11.37,11.21,11.09,11,10.87,10.86,10.75,10.62,10.50,10.45,10.36,10.25,10.24,10.12,10.12,10.11,10.09,10.08,10.07,10,10,10,9.87,9.84,9.71,9.57,9.37,9.25,9.12,9,8.98,8.87,8.87,8.85,8.75,8.62,8.60,8.49,8.37,8.24,8.12,8.12,8.12,8.24,8.25,8.25,8.25,8.25,8.20,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7.99,8,8,8.09,8.11,8.11,8.11,8.10,8.08,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8.09,8.12,8.23,8.25,8.25,8.12,8.09,7.96,7.83,7.62,7.50,7.37,7.25,7.20,7.12,7,7,6.99,6.97,6.87,6.87,6.87,6.84,6.74,6.62,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.95,4.84,4.72,4.61,4.50,4.37,4.25,4.22,4.12,4.09,4,4,4,3.99,3.98,3.97,3.96,3.87,3.87,3.87,3.85,3.75,3.71,3.61,3.50,3.37,3.25,3.12,3.07,2.96,2.86,2.75,2.62,2.50,2.37,2.25,2.12,2.08,1.97,1.87,1.75,1.62,1.50,1.37,1.25,1.12,1.09,1,1,0.99,0.99,0.99,0.99,0.99,0.99,1,1.07,1.21,1.37,1.70,2,2.37,2.95,3.70,4.97,6.70,8.45,7.87,11.25,11.12,11.12,11.37,11.58,11.72,11.80,11.89,11.96,12.01,12.03,12.03,12.02,12.02,12.02,12.01,11.98,11.89,11.73,11.45,11.02,10.41,9.61,8.61,7.43,6.10,4.62,3.07,1.12,-0.04,-1.13,-1.88,-2.38,-2.75,-2.89,-3,-3,-3.10,-3.29,-3.71,-4.26,-4.84,-5.25,-5.37,-5.21,-4.97,-4.59,-4.27,-4.02,-3.83,-3.58,-3.26,-3.10,-3,-2.91,-2.75,-2.38,-1.67,-0.88,0.25,1.47,2.62,3.87,5,6,7,7.87,8.87,10.12,11.58,12.96,14.32,15.62,16.99,18.25,19.50,20.60,21.45,22,22.25,22.33,22.12,21.87,21.50,21.12,20.72,20.35,20,19.82,19.62,19.37,19.12,18.87,18.37,17.87,17.25,16.57,15.82,15.07,14.37,13.86,13.50,13.50,13.75,14.22,14.70,15.12,15.37,15.37,15.25,14.97,14.57,14.11,13.61,13.10,12.60,12.12,11.73,11.37,11.20,11,10.96,10.87,10.75,10.62,10.59,10.48,10.37,10.25,10.21,10.12,10.11,10.07,10,10,10,9.98,9.97,9.96,9.87,9.87,9.82,9.71,9.58,9.37,9.25,9.12,9,8.99,8.87,8.87,8.75,8.72,8.61,8.49,8.37,8.25,8.21,8.11,8.10,8.12,8.25,8.36,8.45,8.50,8.50,8.58,8.72,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7.99,7.99,7.99,8,8,8,8,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8.09,8.12,8.25,8.37,8.37,8.37,8.25,8.10,7.87,7.74,7.58,7.37,7.25,7.20,7.11,7,7,6.99,6.97,6.95,6.87,6.87,6.85,6.75,6.62,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.07,4.96,4.84,4.73,4.61,4.50,4.37,4.25,4.21,4.12,4.09,4,4,4,3.99,3.98,3.97,3.96,3.87,3.87,3.87,3.85,3.75,3.71,3.61,3.50,3.37,3.25,3.12,3.07,2.96,2.86,2.75,2.62,2.50,2.37,2.25,2.12,2.08,1.98,1.87,1.75,1.62,1.50,1.37,1.25,1.12,1.09,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.11,1.25,1.50,1.75,2.12,2.50,3,3.71,4.85,6.34,7.70,7,11,11,11,11.12,11.34,11.49,11.61,11.70,11.76,11.80,11.80,11.79,11.79,11.80,11.82,11.85,11.86,11.83,11.73,11.51,11.14,10.57,9.78,8.77,7.58,6.21,4.68,3.03,1.24,-0.25,-1.25,-2,-2.50,-2.76,-2.92,-3,-3,-3.02,-3.23,-3.60,-4.17,-4.79,-5.27,-5.42,-5.37,-5.13,-4.79,-4.55,-4.36,-4.12,-3.80,-3.48,-3.17,-3.02,-3,-2.88,-2.50,-1.88,-1,0.10,1.12,2.25,3.25,4.25,5.20,6.12,7.07,8.12,9.50,11.10,12.61,14.11,15.50,16.86,18,19.10,20,20.75,21.25,21.59,21.62,21.50,21.25,20.87,20.49,20,19.62,19.32,19,18.75,18.50,18.12,17.75,17.35,16.75,16.12,15.50,14.86,14.24,13.71,13.33,13.12,13.25,13.50,13.87,14.32,14.62,14.75,14.75,14.58,14.25,13.87,13.49,13,12.60,12.12,11.75,11.48,11.24,11.07,10.87,10.84,10.75,10.62,10.50,10.45,10.35,10.25,10.12,10.11,10.07,10,10,9.97,9.95,9.87,9.87,9.87,9.85,9.82,9.75,9.62,9.57,9.37,9.25,9.12,9,8.99,8.87,8.87,8.75,8.62,8.57,8.37,8.25,8.21,8.12,8.09,8,8,8.12,8.24,8.37,8.50,8.62,8.75,8.86,8.75,8.86,8.98,9,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7.99,7.99,7.99,7.99,7.99,7.99,7.99,8,8,8,8,8,8,8,8,8,8,7.99,8,8.08,8.20,8.35,8.48,8.50,8.50,8.37,8.25,8.07,7.84,7.62,7.46,7.32,7.21,7.12,7.07,7,6.99,6.97,6.95,6.87,6.87,6.83,6.75,6.62,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.08,4.97,4.85,4.73,4.62,4.50,4.37,4.25,4.21,4.12,4.09,4,4,3.99,3.98,3.97,3.97,3.96,3.87,3.87,3.87,3.86,3.75,3.71,3.61,3.50,3.37,3.25,3.12,3.07,2.97,2.86,2.75,2.62,2.50,2.37,2.25,2.12,2.08,1.98,1.87,1.75,1.62,1.50,1.37,1.25,1.12,1.09,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.12,1.35,1.60,1.87,2.25,2.62,3.10,3.71,4.62,5.87,6.87,6.12,11,11,11,11,11.17,11.30,11.41,11.50,11.57,11.59,11.59,11.57,11.58,11.60,11.64,11.71,11.77,11.82,11.80,11.66,11.37,10.86,10.10,9.09,7.86,6.46,4.92,3.26,1.57,-0.15,-1.38,-2.13,-2.55,-2.88,-3,-3,-3,-3,-3,-3.26,-3.89,-4.79,-5.33,-5.49,-5.38,-5.18,-4.99,-4.79,-4.71,-4.42,-4.09,-3.66,-3.30,-3.10,-2.98,-2.88,-2.54,-1.91,-1.03,-0.13,0.87,1.84,2.75,3.62,4.50,5.50,6.58,7.75,9.12,10.72,12.25,13.87,15.48,16.75,17.75,18.62,19.45,20.09,20.50,20.84,20.87,20.83,20.59,20.25,19.85,19.37,19,18.62,18.25,17.96,17.62,17.25,16.83,16.35,15.82,15.24,14.62,14.08,13.57,13.12,12.87,12.83,12.98,13.24,13.58,13.87,14.12,14.22,14.12,13.96,13.62,13.34,12.96,12.50,12.12,11.84,11.50,11.25,11.09,10.95,10.84,10.73,10.62,10.50,10.37,10.34,10.24,10.12,10.10,10,10,9.98,9.96,9.87,9.87,9.86,9.83,9.75,9.73,9.62,9.60,9.50,9.37,9.25,9.12,9,8.99,8.87,8.87,8.75,8.62,8.50,8.37,8.25,8.12,8.09,8,8,8,8,8.08,8.12,8.25,8.37,8.50,8.71,8.83,8.87,8.97,9,9.07,9.99,10,9,9,9,9,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7.99,7.99,7.99,7.99,8,8,8,8.10,8.12,8.12,8.10,8.08,8.08,8.08,8.07,8,8,8,8.12,8.35,8.50,8.62,8.62,8.59,8.37,8.21,7.96,7.72,7.50,7.35,7.22,7.12,7.08,7,7,6.98,6.96,6.87,6.87,6.84,6.75,6.62,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.08,4.98,4.87,4.74,4.62,4.50,4.37,4.25,4.21,4.12,4.08,4,4,3.99,3.98,3.97,3.96,3.96,3.87,3.87,3.87,3.86,3.75,3.72,3.62,3.50,3.37,3.25,3.12,3.07,2.97,2.86,2.75,2.62,2.50,2.37,2.25,2.12,2.08,1.98,1.87,1.75,1.62,1.50,1.37,1.25,1.12,1.09,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.10,1.25,1.45,1.70,1.99,2.32,2.70,3.12,3.75,4.60,5.50,6.37,5.25,10.99,10.99,10.99,11,11.05,11.14,11.22,11.29,11.34,11.36,11.35,11.35,11.37,11.41,11.49,11.60,11.72,11.85,11.92,11.90,11.71,11.28,10.57,9.55,8.29,6.85,5.26,3.53,1.79,0.20,-1.13,-1.93,-2.50,-2.77,-2.92,-3,-3,-3,-3,-3.34,-3.83,-4.47,-4.99,-5.25,-5.29,-5.24,-5.14,-5.08,-4.98,-4.75,-4.36,-3.88,-3.46,-3.17,-3.01,-2.88,-2.63,-2,-1.13,-0.25,0.62,1.48,2.32,3.12,4.11,5.12,6.25,7.50,8.87,10.37,11.99,13.59,15.12,16.37,17.37,18.22,18.87,19.46,19.87,20.12,20.22,20.12,19.95,19.62,19.25,18.85,18.37,18,17.61,17.21,16.82,16.37,15.95,15.47,14.96,14.37,13.87,13.37,13,12.73,12.57,12.50,12.62,12.87,13.21,13.46,13.62,13.62,13.59,13.37,13.12,12.84,12.50,12.12,11.84,11.50,11.32,11.12,10.96,10.84,10.73,10.62,10.50,10.37,10.33,10.24,10.12,10.10,10,10,9.98,9.95,9.87,9.87,9.84,9.75,9.73,9.62,9.59,9.50,9.37,9.34,9.24,9.12,9,8.99,8.87,8.87,8.75,8.62,8.50,8.37,8.25,8.12,8.07,8,8,7.99,7.99,8,8,8,8.12,8.23,8.36,8.50,8.62,8.75,8.96,8.97,9.08,9.09,9,9,10,10,10,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7.99,7.99,8,8,8.07,8.12,8.22,8.32,8.37,8.37,8.34,8.25,8.25,8.25,8.22,8.12,8.09,8.11,8.25,8.49,8.62,8.75,8.70,8.50,8.25,8,7.75,7.57,7.37,7.25,7.12,7.10,7,7,7,6.97,6.87,6.87,6.84,6.75,6.62,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.07,4.98,4.87,4.75,4.62,4.50,4.37,4.25,4.21,4.12,4.08,4,4,3.99,3.98,3.97,3.96,3.95,3.87,3.87,3.87,3.85,3.75,3.71,3.61,3.50,3.37,3.25,3.12,3.07,2.97,2.87,2.75,2.62,2.50,2.37,2.25,2.12,2.08,1.98,1.87,1.75,1.62,1.50,1.37,1.25,1.12,1.11,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.12,1.34,1.57,1.75,2.07,2.37,2.75,3.22,3.75,4.50,5.33,6.08,5.47,10.98,10.98,10.97,10.93,10.95,10.99,11.04,11.08,11.11,11.12,11.12,11.13,11.17,11.24,11.35,11.50,11.70,11.89,12.08,12.17,12.12,11.80,11.16,10.16,8.86,7.33,5.63,3.80,1.99,0.38,-0.87,-1.76,-2.38,-2.75,-2.89,-3,-3,-3,-3,-3.37,-3.83,-4.30,-4.76,-5.12,-5.29,-5.37,-5.36,-5.27,-5.18,-4.91,-4.60,-4.12,-3.61,-3.25,-3.03,-2.88,-2.63,-2,-1.25,-0.50,0.32,1.11,1.87,2.75,3.71,4.75,5.99,7.32,8.62,10.12,11.62,13.25,14.74,16,17,17.83,18.45,18.95,19.32,19.50,19.62,19.61,19.37,19.12,18.75,18.36,17.87,17.45,16.99,16.50,16.09,15.62,15.12,14.70,14.23,13.75,13.33,12.87,12.61,12.37,12.25,12.25,12.37,12.60,12.82,13,13.12,13.12,13.07,12.87,12.62,12.37,12.11,11.82,11.50,11.33,11.12,10.97,10.84,10.73,10.62,10.50,10.37,10.32,10.23,10.12,10.10,10,10,9.98,9.95,9.87,9.87,9.83,9.75,9.70,9.62,9.50,9.45,9.36,9.25,9.12,9.11,9,8.99,8.87,8.87,8.75,8.62,8.50,8.37,8.25,8.12,8.08,8,7.99,7.98,7.98,7.98,7.98,7.97,7.97,7.97,8,8.11,8.25,8.37,8.50,8.60,8.62,8.70,8.73,8.75,9,9.23,9.25,9.21,8.75,8.25,8,8.21,8.84,8.87,8.96,9,8,8,8,8,8,8,8,8,8,8,7.99,8,8.12,8.25,8.37,8.50,8.71,8.84,8.86,8.75,8.62,8.50,8.50,8.45,8.32,8.12,8.12,8.25,8.50,8.73,8.74,8.59,8.36,8.11,7.85,7.61,7.37,7.25,7.12,7.12,7.08,7,7,6.99,6.96,6.87,6.85,6.75,6.70,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.07,4.98,4.87,4.75,4.62,4.50,4.37,4.25,4.21,4.12,4.08,4,4,3.99,3.98,3.97,3.96,3.95,3.87,3.87,3.87,3.84,3.75,3.71,3.61,3.49,3.37,3.25,3.12,3,2.97,2.87,2.75,2.62,2.50,2.37,2.25,2.12,2.08,1.98,1.87,1.75,1.62,1.50,1.37,1.25,1.12,1.10,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.10,1.24,1.46,1.62,1.87,2.12,2.37,2.75,3.24,3.75,4.46,5.12,5.86,5.62,10.96,10.87,10.87,10.83,10.82,10.83,10.85,10.88,10.90,10.89,10.90,10.93,10.98,11.08,11.23,11.42,11.66,11.95,12.22,12.45,12.55,12.40,11.85,10.86,9.49,7.84,5.97,3.98,2.08,0.50,-0.68,-1.67,-2.30,-2.75,-2.90,-3,-3,-3,-3,-3.36,-3.80,-4.27,-4.72,-5.08,-5.30,-5.41,-5.43,-5.40,-5.30,-5.03,-4.67,-4.38,-3.80,-3.39,-3.09,-2.88,-2.63,-2.13,-1.43,-0.76,-0.05,0.62,1.47,2.33,3.25,4.35,5.59,6.97,8.37,9.86,11.37,12.99,14.49,15.75,16.82,17.59,18.12,18.61,18.95,19.12,19.25,19.22,19,18.75,18.37,17.96,17.47,16.95,16.37,15.87,15.37,14.96,14.49,14,13.62,13.21,12.84,12.50,12.25,12.09,12,12,12.11,12.25,12.45,12.59,12.62,12.62,12.60,12.46,12.25,12,11.75,11.50,11.33,11.12,10.98,10.85,10.73,10.62,10.50,10.37,10.32,10.23,10.12,10.09,10,10,9.98,9.95,9.87,9.87,9.82,9.75,9.62,9.60,9.50,9.37,9.32,9.23,9.12,9.08,9,8.97,8.87,8.87,8.75,8.62,8.50,8.37,8.25,8.12,8.08,8,7.99,7.98,7.98,7.97,7.96,7.96,7.87,7.87,7.83,7.83,7.87,8,8.12,8.25,8.32,8.36,8.37,8.37,8.50,8.70,8.86,8.96,8.96,8.62,8.33,8.12,8.37,8.86,9.71,9.10,8.87,8.87,9,9,9,9,9,8,8,8,8,7.99,8.11,8.25,8.71,8.87,8.87,9.12,9.36,9.37,9.25,9.12,8.97,8.84,8.62,8.48,8.25,8.12,8.25,8.49,8.60,8.50,8.36,8.11,7.86,7.62,7.37,7.25,7.20,7.12,7.10,7.07,7,7,6.97,6.87,6.85,6.75,6.70,6.50,6.37,6.25,6.12,6,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,4.97,4.87,4.75,4.62,4.50,4.37,4.25,4.21,4.12,4.08,4,4,3.99,3.98,3.97,3.96,3.87,3.87,3.87,3.87,3.82,3.75,3.62,3.59,3.48,3.36,3.24,3.12,3,2.95,2.85,2.75,2.62,2.50,2.37,2.25,2.12,2.08,1.98,1.87,1.75,1.62,1.50,1.37,1.25,1.12,1.10,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.12,1.34,1.57,1.75,1.98,2.12,2.37,2.74,3.20,3.74,4.35,4.97,5.47,4.73,10.87,10.86,10.75,10.68,10.65,10.65,10.66,10.67,10.68,10.68,10.70,10.74,10.80,10.92,11.10,11.34,11.63,11.97,12.33,12.66,12.89,12.91,12.49,11.53,10.09,8.33,6.36,4.14,2.20,0.62,-0.43,-1.42,-2.13,-2.63,-2.88,-3,-3,-3,-3,-3.30,-3.76,-4.22,-4.63,-5,-5.25,-5.39,-5.46,-5.46,-5.33,-5.10,-4.76,-4.30,-3.90,-3.59,-3.16,-2.89,-2.67,-2.28,-1.75,-1.14,-0.50,0.21,0.97,1.75,2.73,3.75,5,6.37,7.97,9.50,11.20,12.85,14.37,15.75,16.75,17.50,18.07,18.46,18.74,18.87,18.99,18.87,18.75,18.48,18.09,17.61,17,16.49,15.87,15.37,14.85,14.36,13.87,13.49,13.10,12.75,12.37,12.12,11.97,11.83,11.75,11.75,11.84,11.97,12.09,12.21,12.25,12.25,12.20,12.07,11.87,11.71,11.50,11.32,11.12,10.99,10.85,10.73,10.62,10.50,10.37,10.32,10.23,10.12,10.09,10,10,9.97,9.95,9.87,9.87,9.82,9.75,9.62,9.59,9.50,9.37,9.25,9.21,9.12,9,8.99,8.95,8.87,8.86,8.75,8.62,8.50,8.37,8.25,8.12,8.08,8,7.99,7.98,7.98,7.97,7.96,7.87,7.87,7.84,7.75,7.62,7.62,7.62,7.75,7.87,8,8.09,8.11,8.11,8.12,8.24,8.37,8.50,8.62,8.62,8.37,8.25,8.25,8.50,8.97,9.09,9.10,9,9,9.12,9.87,10,10,10,9,9,8,8,8,8,8.87,9.62,9.37,9.37,9.61,9.85,9.99,9.87,9.71,9.37,9.12,8.87,8.59,8.25,8.12,8.12,8.25,8.34,8.25,8,7.83,7.61,7.37,7.25,7.20,7.12,7.11,7.08,7,7,6.98,6.87,6.86,6.75,6.62,6.50,6.37,6.25,6.12,6,5.87,5.82,5.62,5.50,5.37,5.25,5.12,5,4.97,4.87,4.75,4.62,4.50,4.37,4.25,4.21,4.12,4.08,4,4,3.99,3.97,3.97,3.95,3.87,3.87,3.87,3.85,3.75,3.73,3.62,3.50,3.45,3.34,3.22,3.11,3,2.87,2.75,2.71,2.60,2.48,2.36,2.25,2.12,2.07,1.98,1.87,1.75,1.62,1.50,1.37,1.25,1.12,1.10,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.09,1.23,1.45,1.62,1.87,2,2.12,2.33,2.62,3,3.61,4.22,4.75,5.24,3.98,10.75,10.72,10.59,10.51,10.48,10.47,10.47,10.48,10.48,10.48,10.50,10.55,10.64,10.78,10.98,11.25,11.58,11.96,12.37,12.77,13.10,13.23,12.92,12.02,10.54,8.73,6.75,4.59,2.21,1.14,0.01,-1.13,-1.88,-2.39,-2.75,-2.92,-3,-3,-3,-3.24,-3.66,-4.13,-4.55,-4.90,-5.17,-5.36,-5.42,-5.41,-5.33,-5.15,-4.87,-4.47,-4.13,-3.83,-3.62,-3.16,-2.80,-2.50,-2.13,-1.63,-1,-0.38,0.37,1.20,2.10,3.12,4.33,5.75,7.45,9.22,11,12.75,14.46,15.87,16.95,17.61,18.11,18.45,18.62,18.75,18.75,18.72,18.50,18.21,17.75,17.25,16.62,16,15.37,14.84,14.25,13.83,13.37,13,12.62,12.36,12.10,11.87,11.71,11.59,11.50,11.50,11.59,11.62,11.75,11.86,11.87,11.87,11.85,11.74,11.60,11.45,11.25,11.12,10.99,10.85,10.73,10.62,10.50,10.37,10.32,10.23,10.12,10.09,10,9.99,9.97,9.87,9.87,9.86,9.75,9.75,9.62,9.59,9.49,9.37,9.25,9.20,9.11,9,8.98,8.87,8.87,8.84,8.75,8.62,8.50,8.37,8.25,8.12,8.08,8,7.99,7.98,7.98,7.97,7.95,7.87,7.87,7.83,7.72,7.61,7.50,7.47,7.49,7.57,7.62,7.75,7.85,7.87,7.87,7.87,7.96,8,8.12,8.21,8.25,8.12,8.07,8.12,8.50,8.84,8.96,8.97,8.99,9.12,9.34,9.75,10,10,10,11,10,10,9,8,9,9.07,9.75,9.75,9.62,9.86,10.23,10.37,10.37,10.12,9.75,9.34,8.96,8.59,8.25,8,7.99,8,8,7.87,7.74,7.57,7.37,7.25,7.20,7.12,7.12,7.09,7,7,6.97,6.87,6.85,6.75,6.62,6.57,6.37,6.24,6.12,6,5.87,5.83,5.70,5.50,5.37,5.25,5.12,5.07,4.98,4.87,4.75,4.62,4.50,4.37,4.25,4.12,4.12,4.07,4,4,3.98,3.97,3.96,3.95,3.87,3.87,3.87,3.83,3.75,3.62,3.60,3.50,3.37,3.25,3.20,3.08,2.96,2.84,2.73,2.61,2.50,2.37,2.25,2.12,2.11,2,1.97,1.87,1.75,1.62,1.50,1.37,1.25,1.12,1.10,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.12,1.33,1.50,1.75,1.87,2,2.11,2.23,2.47,2.87,3.45,4.10,4.70,5,4.87,10.62,10.50,10.41,10.35,10.32,10.29,10.28,10.27,10.27,10.28,10.32,10.38,10.49,10.65,10.87,11.16,11.50,11.90,12.34,12.77,13.12,13.29,13.07,12.23,10.80,9.02,7.14,5.20,3.48,1.93,0.64,-0.75,-1.63,-2.28,-2.67,-2.88,-3,-3,-3,-3.16,-3.52,-3.97,-4.37,-4.71,-4.99,-5.18,-5.30,-5.36,-5.34,-5.25,-5.01,-4.72,-4.35,-4,-3.80,-3.54,-3.13,-2.78,-2.50,-2.05,-1.50,-0.89,-0.25,0.50,1.37,2.37,3.50,5,6.75,8.82,10.83,12.70,14.37,15.86,17,17.75,18.12,18.49,18.62,18.62,18.62,18.49,18.25,17.87,17.37,16.85,16.22,15.57,14.87,14.35,13.83,13.36,12.96,12.60,12.25,12,11.82,11.62,11.49,11.37,11.34,11.33,11.36,11.37,11.50,11.57,11.60,11.60,11.50,11.47,11.36,11.24,11.10,10.97,10.85,10.73,10.62,10.50,10.37,10.32,10.23,10.12,10.09,10,9.99,9.96,9.87,9.87,9.86,9.75,9.74,9.62,9.58,9.49,9.37,9.25,9.20,9.11,9,8.97,8.87,8.86,8.82,8.75,8.62,8.50,8.37,8.25,8.12,8.08,8,7.99,7.98,7.97,7.97,7.95,7.87,7.86,7.75,7.71,7.58,7.46,7.36,7.32,7.34,7.37,7.50,7.59,7.62,7.62,7.62,7.62,7.62,7.72,7.75,7.75,7.75,7.75,7.75,7.87,8.12,8.36,8.50,8.62,8.75,8.99,9.25,9.46,9.62,9.82,10,10.08,10,10,9,9,9,10,10.87,9.99,9.25,9.99,10.37,10.37,10.37,10.12,9.75,9.33,8.86,8.45,8.08,7.84,7.72,7.62,7.62,7.58,7.46,7.35,7.25,7.12,7.12,7.12,7.10,7.07,7,6.97,6.87,6.84,6.75,6.62,6.50,6.37,6.24,6.12,6,5.87,5.84,5.71,5.50,5.37,5.25,5.12,5.07,4.98,4.87,4.75,4.62,4.50,4.37,4.25,4.12,4.10,4,4,3.99,3.97,3.96,3.95,3.95,3.87,3.87,3.86,3.75,3.73,3.62,3.50,3.45,3.35,3.25,3.12,3,2.87,2.75,2.62,2.50,2.36,2.23,2.12,2,2,1.96,1.87,1.86,1.75,1.62,1.50,1.37,1.25,1.12,1.09,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.08,1.22,1.37,1.62,1.84,1.96,2,2,2.12,2.25,2.62,3.25,4,4.74,5.12,4,10.37,10.32,10.25,10.20,10.16,10.13,10.11,10.09,10.08,10.10,10.14,10.23,10.36,10.53,10.77,11.07,11.41,11.80,12.24,12.66,13.01,13.16,12.97,12.20,10.87,9.18,7.43,5.82,4.27,2.79,1.32,-0.13,-1.13,-1.88,-2.38,-2.75,-2.93,-3,-3,-3.11,-3.37,-3.77,-4.15,-4.50,-4.78,-5.01,-5.18,-5.29,-5.35,-5.35,-5.17,-4.98,-4.62,-4.25,-4.02,-3.92,-3.49,-3.10,-2.77,-2.43,-2,-1.50,-0.88,-0.16,0.62,1.50,2.62,4.07,5.87,8,10.12,12.09,13.75,15.25,16.62,17.62,18.23,18.50,18.62,18.59,18.46,18.23,17.87,17.50,17,16.37,15.75,15.10,14.47,13.87,13.37,12.96,12.58,12.25,12,11.75,11.58,11.37,11.25,11.22,11.12,11.12,11.12,11.21,11.25,11.32,11.35,11.35,11.32,11.25,11.12,11.07,10.95,10.84,10.73,10.62,10.50,10.37,10.32,10.23,10.12,10.09,10,9.99,9.96,9.87,9.87,9.85,9.75,9.74,9.62,9.58,9.48,9.37,9.25,9.20,9.11,9,8.97,8.87,8.85,8.75,8.72,8.62,8.50,8.37,8.25,8.12,8.08,8,7.99,7.98,7.97,7.95,7.95,7.87,7.86,7.75,7.62,7.57,7.37,7.32,7.24,7.12,7.12,7.25,7.33,7.37,7.37,7.37,7.37,7.37,7.37,7.37,7.46,7.46,7.46,7.45,7.47,7.58,7.72,7.87,8.08,8.24,8.37,8.61,8.82,9,9.23,9.37,9.57,9.62,9.75,9.86,9.07,9,9,10,10,9.96,9.84,9.73,9.84,9.87,9.87,9.73,9.37,8.97,8.50,8.11,7.75,7.49,7.37,7.36,7.35,7.32,7.25,7.20,7.12,7.12,7.12,7.10,7.07,7,6.96,6.87,6.75,6.72,6.61,6.50,6.37,6.23,6.12,6,5.95,5.85,5.71,5.50,5.37,5.25,5.12,5,4.99,4.87,4.75,4.62,4.50,4.37,4.25,4.12,4.10,4,4,3.99,3.97,3.95,3.87,3.87,3.87,3.87,3.85,3.75,3.70,3.59,3.48,3.37,3.25,3.20,3.12,3,2.87,2.75,2.62,2.37,2.23,2,1.87,1.82,1.75,1.75,1.75,1.75,1.74,1.62,1.50,1.37,1.25,1.12,1.09,1,1,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.11,1.25,1.50,1.74,1.87,1.97,2,2,2,2.12,2.48,3.12,4,4.85,5.25,4.12,10.22,10.16,10.13,10.08,10.03,9.99,9.96,9.91,9.89,9.93,10,10.10,10.25,10.43,10.67,10.97,11.29,11.67,12.09,12.48,12.80,12.93,12.74,12.03,10.82,9.24,7.62,6.13,4.72,3.36,1.97,0.62,-0.43,-1.38,-2.03,-2.63,-2.88,-3,-3,-3.05,-3.25,-3.61,-3.96,-4.27,-4.59,-4.86,-5.08,-5.25,-5.37,-5.42,-5.35,-5.16,-4.88,-4.53,-4.28,-4.16,-3.83,-3.36,-2.92,-2.75,-2.50,-2.01,-1.50,-0.88,-0.13,0.72,1.71,2.87,4.62,6.75,9.10,11.10,12.87,14.61,16.12,17.46,18.22,18.50,18.59,18.48,18.25,17.87,17.50,17.09,16.50,15.87,15.25,14.62,14,13.49,13,12.61,12.25,11.98,11.75,11.50,11.37,11.25,11.12,11.07,11,10.99,10.99,11,11,11.10,11.12,11.12,11.11,11.07,11,10.87,10.82,10.72,10.61,10.50,10.37,10.32,10.23,10.12,10.09,10,9.99,9.96,9.87,9.87,9.85,9.75,9.74,9.62,9.58,9.48,9.37,9.25,9.21,9.11,9,8.96,8.87,8.83,8.75,8.62,8.61,8.50,8.37,8.25,8.12,8.09,8,7.99,7.98,7.96,7.95,7.87,7.87,7.85,7.75,7.62,7.50,7.37,7.25,7.21,7.12,7.09,7.09,7.12,7.12,7.22,7.24,7.23,7.22,7.21,7.21,7.21,7.22,7.22,7.21,7.21,7.23,7.25,7.35,7.45,7.57,7.72,7.87,8,8.20,8.37,8.61,8.75,8.87,8.97,8.99,8.87,8.75,8.85,8.87,9,9,9,9,9,8.99,8.99,8.98,8.87,8.73,8.37,7.99,7.60,7.25,7.07,7,7.10,7.12,7.12,7.12,7.12,7.11,7.11,7.10,7.07,7,6.96,6.87,6.75,6.62,6.57,6.45,6.32,6.21,6.11,6,5.95,5.85,5.72,5.50,5.37,5.24,5.12,5,4.99,4.87,4.82,4.62,4.50,4.37,4.25,4.12,4.09,4,4,3.99,3.98,3.95,3.87,3.87,3.83,3.75,3.75,3.74,3.62,3.50,3.37,3.32,3.23,3.12,3.08,3,2.87,2.75,2.62,2.37,2.12,1.87,1.70,1.50,1.46,1.46,1.50,1.59,1.62,1.59,1.48,1.35,1.23,1.12,1.07,1,1,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.12,1.32,1.50,1.75,1.87,1.97,1.99,2,2,2.07,2.37,3.07,4,4.97,5.62,5.25,10.09,10.07,10.03,9.99,9.93,9.87,9.82,9.76,9.73,9.79,9.88,10,10.16,10.37,10.60,10.87,11.18,11.52,11.89,12.26,12.54,12.66,12.49,11.84,10.71,9.24,7.71,6.26,4.96,3.73,2.53,1.33,0.25,-0.77,-1.67,-2.29,-2.75,-3,-3,-3.03,-3.14,-3.47,-3.77,-4.09,-4.39,-4.68,-4.97,-5.18,-5.38,-5.54,-5.51,-5.38,-5.16,-4.87,-4.59,-4.41,-4.11,-3.59,-3.10,-2.93,-2.80,-2.51,-2.05,-1.51,-0.88,-0.13,0.74,1.73,2.50,5.62,8,10.12,12.10,13.87,15.70,17.32,18.25,18.50,18.50,18.34,18,17.62,17.12,16.62,16.07,15.47,14.84,14.23,13.62,13.12,12.70,12.32,12,11.75,11.50,11.37,11.23,11.10,11,10.87,10.87,10.84,10.83,10.84,10.87,10.87,10.87,10.95,10.95,10.87,10.87,10.75,10.71,10.61,10.50,10.37,10.32,10.23,10.12,10.09,10,9.99,9.95,9.87,9.87,9.85,9.75,9.74,9.62,9.58,9.48,9.37,9.25,9.21,9.12,9,8.96,8.87,8.82,8.75,8.62,8.59,8.50,8.37,8.25,8.12,8.09,8,8,7.98,7.96,7.95,7.87,7.87,7.85,7.75,7.62,7.50,7.37,7.25,7.20,7.11,7,7,7,7,7.07,7.08,7.08,7,7,7,7,7,7,7,7,7,7,7,7,7.07,7.12,7.20,7.25,7.37,7.58,7.75,7.87,8,8.11,8.12,8.10,8,8,8,8,8,8,8,8,8,8,7.99,7.99,7.98,7.87,7.62,7.45,7.10,6.75,6.62,6.75,6.98,7,7,7,7.07,7.08,7.09,7.07,7,6.96,6.87,6.75,6.62,6.50,6.37,6.25,6.12,6.08,6,5.95,5.85,5.72,5.57,5.37,5.24,5.12,5,4.99,4.87,4.83,4.70,4.50,4.37,4.25,4.12,4.08,4,4,3.99,3.98,3.97,3.95,3.87,3.75,3.70,3.59,3.50,3.50,3.49,3.36,3.25,3.12,3.11,3,2.98,2.87,2.75,2.62,2.37,2.12,1.87,1.58,1.32,1.12,1.08,1.11,1.22,1.35,1.37,1.37,1.25,1.20,1.11,1,1,0.99,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.11,1.32,1.58,1.75,1.87,1.97,1.99,1.99,2,2,2.37,3,4,5.11,5.98,6.37,10,10,9.97,9.91,9.84,9.76,9.68,9.62,9.59,9.67,9.78,9.93,10.11,10.32,10.53,10.78,11.05,11.36,11.68,12.01,12.27,12.38,12.23,11.63,10.59,9.21,7.74,6.38,5.15,4.10,3.09,2.11,0.87,-0.63,-1.17,-2,-2.63,-2.88,-3,-3.01,-3.08,-3.36,-3.63,-3.92,-4.25,-4.55,-4.87,-5.13,-5.37,-5.63,-5.65,-5.55,-5.38,-5.18,-4.88,-4.67,-4.30,-3.75,-3.27,-3.02,-3,-2.88,-2.50,-2.13,-1.55,-0.92,-0.17,0.75,2.50,4.86,7.34,9.37,11.25,13.22,15.12,17.20,18.37,18.59,18.37,18.12,17.75,17.25,16.75,16.21,15.62,15,14.37,13.86,13.33,12.85,12.37,12.08,11.75,11.50,11.37,11.22,11.09,10.97,10.87,10.75,10.73,10.62,10.62,10.62,10.70,10.74,10.75,10.75,10.82,10.75,10.75,10.62,10.59,10.50,10.37,10.32,10.23,10.12,10.09,10,9.99,9.95,9.87,9.87,9.84,9.75,9.74,9.62,9.58,9.48,9.37,9.25,9.21,9.12,9,8.97,8.87,8.83,8.75,8.62,8.59,8.49,8.37,8.25,8.12,8.11,8,8,7.98,7.96,7.95,7.87,7.87,7.83,7.75,7.62,7.50,7.37,7.25,7.20,7.11,7,7,6.99,6.99,6.99,6.98,6.96,6.87,6.87,6.87,6.87,6.87,6.87,6.87,6.87,6.87,6.87,6.84,6.75,6.75,6.74,6.74,6.75,6.75,6.87,7.09,7.25,7.37,7.47,7.48,7.47,7.37,7.37,7.35,7.33,7.33,7.25,7.12,7,7,7,7,7,7.08,7.12,7.21,7,6.75,6.62,6.35,6.37,6.62,6.87,6.97,6.99,7,7,7,7,7,6.95,6.85,6.73,6.61,6.46,6.33,6.21,6.12,6,5.99,5.87,5.85,5.72,5.57,5.37,5.24,5.12,5,4.98,4.87,4.84,4.71,4.50,4.37,4.24,4.12,4.07,4,4,4,3.99,3.98,3.96,3.87,3.82,3.62,3.61,3.22,3.12,3.21,3.22,3.12,3.12,3.07,3,2.97,2.87,2.75,2.61,2.37,2.12,1.87,1.50,1.22,0.87,0.75,0.70,0.75,0.87,1,1.12,1.12,1.11,1,0.99,0.97,0.97,0.97,0.97,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.12,1.25,1.50,1.73,1.87,1.95,1.98,1.99,2,2,2.35,3.12,4.24,5.46,6.50,6.58,9.99,9.96,9.91,9.84,9.75,9.65,9.55,9.49,9.48,9.59,9.72,9.88,10.07,10.27,10.48,10.70,10.92,11.17,11.46,11.74,11.98,12.09,11.95,11.40,10.43,9.13,7.77,6.50,5.40,4.48,3.62,2.75,1.32,0.62,-0.63,-1.38,-2.15,-2.75,-3,-3,-3.01,-3.26,-3.51,-3.83,-4.13,-4.47,-4.77,-5.08,-5.34,-5.55,-5.72,-5.65,-5.51,-5.40,-5.24,-4.98,-4.46,-3.86,-3.37,-3.02,-3,-3,-2.88,-2.51,-2.13,-1.63,-1,0.24,2.25,4.62,7,8.98,10.70,12.37,14.37,16.83,18,18.47,18.25,17.97,17.50,17,16.37,15.75,15.22,14.62,14.08,13.50,13,12.59,12.20,11.87,11.61,11.37,11.23,11.08,10.96,10.85,10.75,10.62,10.60,10.50,10.50,10.50,10.50,10.58,10.62,10.62,10.62,10.70,10.62,10.57,10.49,10.37,10.32,10.23,10.12,10.09,10,9.99,9.95,9.87,9.87,9.83,9.75,9.73,9.62,9.58,9.48,9.37,9.25,9.21,9.12,9,8.97,8.87,8.83,8.75,8.62,8.58,8.48,8.37,8.25,8.20,8.12,8,8,7.98,7.97,7.95,7.87,7.87,7.83,7.74,7.62,7.50,7.37,7.25,7.20,7.11,7,7,6.99,6.98,6.96,6.87,6.87,6.84,6.75,6.74,6.71,6.71,6.72,6.73,6.74,6.74,6.73,6.71,6.62,6.59,6.50,6.46,6.37,6.37,6.49,6.50,6.73,6.87,7.07,7.12,7.12,7.12,7.10,7,7,7,7,7,7,7,7,6.99,6.98,6.96,6.96,6.97,6.87,6.11,6.12,6.20,6.22,6.24,6.74,6.75,6.87,6.87,6.98,7,7,6.97,6.87,6.82,6.72,6.57,6.37,6.25,6.12,6.08,6,5.97,5.87,5.84,5.72,5.57,5.37,5.24,5.12,5,4.97,4.87,4.83,4.71,4.50,4.37,4.24,4.12,4,4,4,4,3.99,3.98,3.96,3.87,3.84,3.72,3.50,3.25,3.12,3.07,3,3.07,3,3,3,2.96,2.87,2.75,2.59,2.37,2.12,1.84,1.50,1.12,0.83,0.50,0.37,0.32,0.37,0.50,0.70,0.82,0.87,0.87,0.85,0.86,0.87,0.87,0.95,0.97,0.98,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.12,1.22,1.25,1.37,1.50,1.71,1.85,1.95,2,2.11,2.25,2.70,3.59,4.71,5.95,7.11,8.70,9.98,9.92,9.86,9.76,9.64,9.53,9.43,9.39,9.40,9.52,9.67,9.85,10.03,10.23,10.40,10.59,10.78,10.99,11.23,11.47,11.68,11.78,11.65,11.15,10.25,9.04,7.79,6.67,5.74,4.99,4.23,3.12,2.24,1.32,0.62,-0.79,-1.76,-2.76,-2.88,-3,-3,-3.13,-3.41,-3.72,-4.04,-4.38,-4.73,-5.01,-5.27,-5.50,-5.68,-5.66,-5.55,-5.43,-5.22,-5.09,-4.58,-3.89,-3.37,-3.01,-3,-3,-3,-2.88,-2.55,-2.16,-1.53,-0.38,1.50,4.75,6.84,8.96,10.25,11.59,13.47,15.36,17.20,18,18,17.74,17.25,16.70,16.07,15.45,14.85,14.25,13.75,13.25,12.75,12.37,12,11.70,11.45,11.25,11.10,10.96,10.85,10.74,10.62,10.50,10.47,10.37,10.37,10.37,10.37,10.37,10.48,10.50,10.57,10.57,10.50,10.46,10.37,10.25,10.23,10.12,10.09,10,9.99,9.95,9.87,9.87,9.83,9.75,9.73,9.62,9.58,9.48,9.37,9.25,9.21,9.12,9,8.97,8.87,8.83,8.75,8.62,8.57,8.48,8.37,8.25,8.20,8.12,8,8,7.99,7.97,7.95,7.87,7.87,7.83,7.74,7.62,7.50,7.37,7.25,7.20,7.11,7,7,6.99,6.97,6.96,6.87,6.87,6.75,6.71,6.62,6.57,6.50,6.50,6.50,6.50,6.57,6.57,6.50,6.50,6.46,6.37,6.25,6.25,6.21,6.21,6.24,6.35,6.48,6.71,6.87,6.97,7,7,7,7,7,6.99,6.99,6.99,6.99,6.99,6.97,6.96,6.87,6.87,6.07,6.07,6.07,6,6,6,6,6.99,6,6.71,6.74,6.87,6.96,6.98,6.95,6.87,6.75,6.62,6.50,6.37,6.24,6.12,6,5.99,5.87,5.87,5.75,5.62,5.50,5.37,5.24,5.12,5,4.96,4.87,4.75,4.70,4.50,4.37,4.24,4.12,4,4,4,4,3.99,3.98,3.96,3.87,3.84,3.72,3.57,3.36,3.12,3.07,3,3,3,3,2.99,2.96,2.87,2.75,2.62,2.33,2,1.75,1.37,1.09,0.73,0.37,0.12,-0.03,-0.13,-0.01,0.12,0.25,0.45,0.50,0.58,0.62,0.71,0.75,0.87,0.87,0.97,0.98,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1.12,1.37,1.25,1.25,1.37,1.58,1.75,1.87,2.09,2.25,2.50,3.08,3.87,5,6.46,7.50,8.62,9.96,9.87,9.78,9.65,9.53,9.41,9.33,9.30,9.35,9.49,9.64,9.83,10,10.17,10.33,10.47,10.61,10.78,10.98,11.20,11.38,11.47,11.36,10.89,10.05,8.93,7.83,6.89,6.20,5.60,5.03,5,3.12,2.75,0.87,-0.76,-1.25,-2.13,-3,-3,-3,-3.05,-3.34,-3.63,-4,-4.36,-4.68,-4.99,-5.24,-5.42,-5.59,-5.63,-5.59,-5.38,-5.24,-4.92,-4.40,-3.91,-3.25,-3,-3,-3,-3,-3,-2.89,-2.51,-1.88,-0.88,0.75,2,7.84,9,9.95,10.87,12.12,14.09,15.87,17.37,17.75,17.50,17,16.37,15.75,15.11,14.50,13.98,13.48,13,12.58,12.12,11.83,11.50,11.25,11.12,10.98,10.85,10.74,10.62,10.50,10.37,10.35,10.25,10.25,10.24,10.25,10.25,10.35,10.37,10.45,10.45,10.37,10.36,10.25,10.22,10.12,10.09,10,9.99,9.95,9.87,9.87,9.83,9.75,9.72,9.62,9.58,9.48,9.37,9.25,9.21,9.12,9,8.98,8.87,8.84,8.75,8.62,8.58,8.48,8.37,8.25,8.20,8.12,8.07,8,7.99,7.96,7.95,7.87,7.87,7.82,7.74,7.62,7.50,7.37,7.25,7.12,7.10,7,7,6.99,6.97,6.96,6.87,6.87,6.75,6.62,6.57,6.47,6.37,6.36,6.35,6.35,6.37,6.37,6.37,6.36,6.33,6.25,6.22,6.12,6.11,6.09,6.09,6.11,6.12,6.32,6.50,6.73,6.87,6.87,6.96,6.97,6.98,6.98,6.98,6.98,6.98,6.98,6.96,6.87,6.75,6.85,6.11,6.11,6,6,6,6,6,6,6,6,6.25,6.47,6.75,6.87,6.95,6.87,6.75,6.60,6.46,6.32,6.21,6.11,6,5.96,5.87,5.82,5.73,5.62,5.50,5.36,5.23,5.12,5,4.95,4.86,4.75,4.62,4.50,4.37,4.23,4.12,4,4,4,3.99,3.99,3.98,3.96,3.87,3.84,3.72,3.57,3.37,3.21,3,3,3,2.99,2.99,2.97,2.95,2.87,2.75,2.72,2.25,1.99,1.62,1.33,0.97,0.60,0.24,-0.13,-0.38,-0.50,-0.50,-0.50,-0.38,-0.14,0,0.12,0.25,0.37,0.50,0.71,0.85,0.87,0.97,0.98,0.98,0.98,0.99,0.99,0.99,0.99,0.99,0.99,0.99,0.99,1,1,1.12,1.12,1.23,1.22,1.25,1.50,1.75,1.99,2.23,2.49,2.87,3.50,4.25,5.25,6.25,7.25,7.57,9.87,9.78,9.67,9.53,9.40,9.29,9.24,9.24,9.32,9.45,9.63,9.80,9.97,10.10,10.22,10.33,10.42,10.55,10.73,10.91,11.09,11.16,11.05,10.63,9.87,8.87,7.91,7.18,6.74,6.28,5.87,5,3.97,2.59,1.37,0.07,-1,-1.93,-2.64,-3,-3,-3.03,-3.35,-3.66,-4.04,-4.40,-4.72,-4.98,-5.18,-5.37,-5.52,-5.62,-5.61,-5.52,-5.37,-4.78,-4.22,-3.74,-3.04,-3,-3,-3,-3,-3,-2.93,-2.64,-2.05,-1.15,0,1.85,7,8.87,9.73,10.24,11.11,12.57,14.87,16.84,17.62,17.45,16.87,16.12,15.47,14.75,14.21,13.62,13.21,12.75,12.36,11.99,11.62,11.37,11.12,11,10.87,10.74,10.62,10.50,10.37,10.32,10.24,10.12,10.12,10.12,10.12,10.12,10.24,10.25,10.33,10.33,10.25,10.25,10.20,10.12,10.09,10,9.99,9.96,9.87,9.87,9.84,9.75,9.72,9.62,9.58,9.49,9.37,9.25,9.20,9.12,9,8.98,8.87,8.85,8.75,8.62,8.58,8.48,8.37,8.25,8.20,8.12,8.07,8,7.98,7.96,7.87,7.87,7.87,7.82,7.74,7.62,7.50,7.37,7.25,7.12,7.09,7,7,6.99,6.97,6.96,6.87,6.87,6.75,6.62,6.50,6.37,6.33,6.25,6.21,6.20,6.20,6.21,6.21,6.21,6.20,6.12,6.12,6.10,6,6,6,6,6,6.10,6.21,6.36,6.50,6.71,6.82,6.87,6.87,6.87,6.87,6.87,6.87,6.95,6.87,6.87,6.75,6.61,6.25,6.12,6,6,6,6,6,6,6,6,6,6.07,6.37,6.62,6.87,6.87,6.75,6.59,6.37,6.25,6.12,6.08,6,5.95,5.86,5.75,5.62,5.50,5.37,5.25,5.20,5.11,5,4.95,4.85,4.73,4.60,4.46,4.33,4.21,4.11,4,4,4,3.99,3.99,3.98,3.96,3.87,3.84,3.72,3.57,3.37,3.23,3.10,3,3,2.99,2.98,2.98,2.96,2.86,2.82,2.75,2.24,1.98,1.61,1.22,0.83,0.37,0,-0.30,-0.63,-0.88,-1,-1,-0.91,-0.79,-0.63,-0.50,-0.27,-0.13,0.12,0.35,0.61,0.75,0.87,0.95,0.97,0.98,0.99,0.99,0.99,1,1,1,0.99,0.99,0.99,0.99,1,1.08,1.12,1.24,1.33,1.37,1.62,1.87,2.12,2.47,2.87,3.37,4,4.74,5.58,6.49,7.33,7.37,9.75,9.65,9.52,9.39,9.27,9.18,9.15,9.20,9.29,9.45,9.63,9.78,9.91,10.01,10.10,10.16,10.23,10.33,10.47,10.64,10.80,10.88,10.79,10.42,9.77,8.91,8.11,7.54,7.26,7.37,6.23,5,4.25,2.84,1.37,0.12,-1,-1.91,-2.63,-3,-3,-3.02,-3.37,-3.75,-4.13,-4.50,-4.78,-5,-5.17,-5.34,-5.47,-5.62,-5.64,-5.51,-5.25,-4.67,-4.09,-3.59,-3.27,-3,-3,-3,-3,-3,-2.90,-2.68,-2.25,-1.38,-0.13,1.71,5.50,9.10,9.46,9.75,10.25,11.75,13.87,16.46,17.37,17.45,16.73,15.96,15.20,14.50,13.87,13.37,12.87,12.50,12.12,11.75,11.50,11.25,11.07,10.87,10.75,10.62,10.50,10.37,10.25,10.22,10.12,10.09,10.07,10,10.08,10.11,10.12,10.12,10.22,10.22,10.20,10.12,10.12,10.08,10,10,9.97,9.87,9.87,9.86,9.82,9.75,9.62,9.60,9.50,9.37,9.25,9.20,9.12,9,8.98,8.87,8.85,8.75,8.62,8.60,8.49,8.37,8.25,8.20,8.12,8.07,8,7.98,7.95,7.87,7.87,7.87,7.82,7.74,7.62,7.50,7.37,7.25,7.12,7.09,7,7,6.99,6.97,6.96,6.87,6.87,6.75,6.62,6.50,6.37,6.25,6.20,6.12,6.10,6.09,6.09,6.09,6.10,6.09,6.09,6.07,6,6,6,6,6,6,6,6,6.12,6.23,6.36,6.50,6.62,6.71,6.75,6.75,6.75,6.75,6.83,6.83,6.84,6.73,6.58,6.37,6.23,6.10,6,6,6,6,6,6,6,6,6,6.09,6.35,6.60,6.87,6.75,6.59,6.37,6.24,6.12,6,6,5.87,5.85,5.73,5.60,5.46,5.34,5.23,5.12,5.08,5,4.95,4.85,4.73,4.58,4.37,4.25,4.12,4.09,4,4,4,3.99,3.99,3.98,3.96,3.87,3.84,3.72,3.57,3.37,3.23,3.10,3,3,3,2.99,2.97,2.95,2.87,2.87,2.12,2.12,1.97,1.75,1.12,0.70,0.25,-0.15,-0.54,-0.89,-1.17,-1.38,-1.50,-1.50,-1.42,-1.38,-1.16,-1,-0.75,-0.50,-0.17,0.12,0.49,0.72,0.86,0.87,0.96,0.98,0.99,0.99,1,1,1,0.99,0.99,0.99,0.99,1,1,1.10,1.23,1.37,1.50,1.73,1.96,2.25,2.58,2.95,3.37,3.87,4.50,5.21,6,7.12,8.12,8.24,9.62,9.49,9.37,9.26,9.16,9.09,9.10,9.16,9.29,9.46,9.63,9.78,9.86,9.92,9.96,9.99,10.02,10.10,10.23,10.38,10.55,10.65,10.59,10.30,9.76,9.07,8.41,7.98,7.75,7.62,7.25,6.87,4.87,3,1.33,-0.13,-1.25,-2.04,-2.63,-2.93,-3,-3.01,-3.40,-3.83,-4.25,-4.62,-4.88,-5.05,-5.18,-5.30,-5.41,-5.63,-5.65,-5.50,-5.13,-4.62,-4.08,-3.61,-3.38,-3,-3,-3,-3,-3,-2.90,-2.75,-2.27,-1.50,-0.25,1.50,4.99,8.34,9.12,9.12,9.57,10.70,12.75,15.12,17.62,17.37,16.62,15.74,14.87,14.20,13.59,13.09,12.62,12.25,11.95,11.62,11.37,11.12,10.95,10.75,10.62,10.50,10.37,10.25,10.21,10.12,10.07,10,10,10,10,10,10.08,10.11,10.12,10.12,10.11,10.09,10,10,10,9.97,9.95,9.87,9.87,9.84,9.75,9.70,9.61,9.50,9.37,9.25,9.21,9.12,9,8.98,8.87,8.85,8.75,8.70,8.61,8.50,8.37,8.25,8.21,8.12,8.07,8,7.97,7.95,7.87,7.87,7.86,7.82,7.74,7.62,7.50,7.37,7.25,7.12,7.08,7,7,6.99,6.97,6.96,6.87,6.87,6.75,6.62,6.50,6.37,6.25,6.12,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,6,6,6.07,6.12,6.21,6.32,6.37,6.49,6.50,6.58,6.60,6.61,6.62,6.62,6.59,6.50,6.36,6.24,6.21,6.12,6.12,6,6,6,6,6,6,6,6,6.20,6.37,6.50,6.62,6.50,6.37,6.23,6.11,6,5.99,5.87,5.85,5.73,5.58,5.37,5.25,5.12,5.10,5,5,4.87,4.85,4.73,4.57,4.37,4.25,4.12,4.07,4,4,4,3.99,3.99,3.98,3.96,3.87,3.84,3.72,3.57,3.37,3.23,3.10,3,2.87,3,3,3,2.96,2.07,2.11,2.12,2,1.83,1.75,1.08,0.58,0.09,-0.38,-0.77,-1.14,-1.50,-1.75,-1.90,-2,-2,-2,-1.88,-1.75,-1.50,-1.25,-0.88,-0.50,-0.13,0.32,0.61,0.75,0.87,0.87,0.97,0.99,1,1,1,0.99,0.99,0.99,0.99,0.99,1,1.09,1.22,1.37,1.60,1.75,2,2.36,2.74,3.12,3.58,4,4.50,5,5.62,6.62,8.21,9.62,10.09,9.37,9.33,9.24,9.14,9.07,9.03,9.07,9.14,9.28,9.45,9.61,9.74,9.83,9.82,9.82,9.80,9.83,9.88,9.99,10.16,10.35,10.48,10.49,10.30,9.89,9.32,8.76,8.34,8.32,8.50,8.62,7.85,5.48,3.25,1.12,-0.43,-1.54,-2.25,-2.75,-2.93,-3,-3,-3.38,-3.88,-4.35,-4.73,-4.98,-5.13,-5.22,-5.28,-5.38,-5.53,-5.63,-5.50,-5.22,-4.74,-4.22,-3.76,-3.48,-3.25,-3,-3,-3,-3,-3,-2.80,-2.42,-1.67,-0.43,1.61,4.24,7.58,8.37,8.25,8.62,9.50,10.98,14,16.87,17.59,16.46,15.50,14.62,13.86,13.25,12.75,12.37,12,11.74,11.47,11.23,11,10.85,10.62,10.50,10.37,10.25,10.20,10.11,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9.98,9.96,9.87,9.87,9.86,9.75,9.74,9.62,9.50,9.45,9.33,9.22,9.12,9,8.98,8.87,8.85,8.75,8.70,8.61,8.50,8.37,8.25,8.22,8.12,8.07,8,7.97,7.87,7.87,7.87,7.85,7.75,7.73,7.62,7.50,7.37,7.25,7.12,7.08,7,6.99,6.99,6.97,6.96,6.87,6.87,6.75,6.62,6.50,6.37,6.25,6.12,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,6,6,6,6.09,6.12,6.21,6.25,6.32,6.34,6.35,6.36,6.36,6.35,6.33,6.25,6.12,6.12,6.12,6.50,6.12,6,6,6,6,6,6,6,6,6.12,6.59,6.45,6.37,6.25,6.12,6.10,6,5.98,5.87,5.84,5.72,5.57,5.37,5.25,5.12,5.07,5,4.98,4.87,4.85,4.73,4.57,4.37,4.25,4.12,4,4,4,4,3.99,3.99,3.98,3.96,3.87,3.84,3.72,3.57,3.37,3.23,3.10,2.99,2.85,2.87,2,2,2.07,2.12,2.10,1.97,1.87,1.75,1.37,0.87,0.37,-0.13,-0.63,-1.01,-1.39,-1.75,-2.03,-2.27,-2.43,-2.50,-2.50,-2.42,-2.40,-2.38,-2.13,-1.76,-1.38,-0.89,-0.40,0.08,0.45,0.62,0.75,0.87,0.96,1,1,1,0.99,0.99,0.99,0.99,0.99,1,1.09,1.21,1.37,1.60,1.75,2,2.36,2.75,3.25,3.84,4.25,4.73,5.12,5.62,6.24,7.70,9.37,11.10,12.95,9.24,9.20,9.12,9.04,9.02,9.01,9.04,9.14,9.27,9.43,9.59,9.71,9.75,9.74,9.67,9.63,9.62,9.66,9.78,9.97,10.18,10.38,10.48,10.37,10.04,9.58,9,8.73,8.72,9.12,10.62,8,6.07,3.33,1.12,-0.54,-1.75,-2.43,-2.80,-3,-3,-3,-3.38,-3.89,-4.46,-4.88,-5.11,-5.16,-5.21,-5.26,-5.36,-5.50,-5.60,-5.50,-5.33,-5,-4.49,-4.01,-3.71,-3.38,-3.05,-3,-3,-3,-3,-2.80,-2.42,-1.75,-0.54,0.96,3,5.87,6.71,7.09,7.50,8.25,9.72,13,16.12,16.85,16.25,15.21,14.25,13.50,12.87,12.50,12.12,11.84,11.57,11.32,11.11,10.87,10.75,10.60,10.45,10.25,10.12,10.09,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9.99,9.98,9.96,9.95,9.87,9.87,9.85,9.75,9.71,9.61,9.49,9.37,9.25,9.12,9.07,8.99,8.87,8.85,8.75,8.71,8.62,8.50,8.37,8.32,8.22,8.12,8.07,8,7.97,7.87,7.87,7.87,7.83,7.75,7.71,7.62,7.50,7.37,7.25,7.12,7.08,7,6.99,6.98,6.97,6.95,6.87,6.87,6.75,6.62,6.50,6.37,6.25,6.12,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.98,5.98,5.97,5.97,5.98,6,6,6,6.08,6.10,6.10,6.11,6.10,6.10,6.09,6.07,6,6,6.12,6.12,6.12,6,6,6,5.98,5.97,5.96,5.98,6,6.12,6.22,6.25,6.21,6.12,6.07,6,5.96,5.87,5.82,5.70,5.50,5.37,5.24,5.12,5,5,4.98,4.87,4.85,4.73,4.57,4.37,4.25,4.12,4,4,4,4,3.99,3.99,3.98,3.96,3.87,3.84,3.72,3.57,3.37,3.23,3.10,2.97,2.83,2.75,2,2,1.99,1.99,1.97,1.87,1.74,1.71,1.21,0.74,0.20,-0.38,-0.88,-1.38,-1.68,-2,-2.27,-2.50,-2.66,-2.77,-2.76,-2.76,-2.78,-2.78,-2.77,-2.54,-2.28,-1.88,-1.38,-0.88,-0.38,0.12,0.37,0.60,0.75,0.96,1,1,0.99,0.99,0.99,0.99,0.99,1,1.09,1.21,1.37,1.60,1.75,2,2.25,2.70,3.24,3.86,4.49,5,5.49,5.87,6.37,7.49,9,10.70,12.12,12.82,9.10,9.08,9,9.01,9,9,9.04,9.13,9.25,9.39,9.53,9.63,9.65,9.61,9.53,9.46,9.40,9.40,9.54,9.78,10.08,10.37,10.58,10.58,10.25,9.75,9.20,8.85,8.75,9,9.50,8.75,5.50,3.12,0.87,-0.63,-1.77,-2.43,-2.78,-2.93,-3,-3,-3.35,-3.78,-4.29,-4.72,-4.93,-5.04,-5.12,-5.22,-5.34,-5.50,-5.61,-5.54,-5.38,-5.13,-4.88,-4.38,-4.01,-3.52,-3.12,-3,-3,-3,-3,-2.80,-2.43,-1.76,-0.77,0.37,1,3.99,5,5.87,6.24,7.35,8.37,11.97,16.37,17.12,15.75,14.87,14,13.23,12.62,12.25,11.87,11.62,11.37,11.12,10.99,10.84,10.62,10.50,10.34,10.12,10.09,10,10,9.99,9.99,9.99,9.99,10,10,10,10,10,10,10,10,9.99,9.98,9.97,9.96,9.87,9.87,9.87,9.84,9.75,9.62,9.57,9.45,9.33,9.21,9.10,9,8.87,8.86,8.75,8.71,8.62,8.50,8.37,8.32,8.23,8.12,8.08,8,7.97,7.87,7.87,7.86,7.82,7.75,7.70,7.61,7.50,7.37,7.25,7.12,7.09,7,6.99,6.98,6.97,6.95,6.87,6.86,6.75,6.62,6.50,6.37,6.25,6.12,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.98,5.97,5.96,5.87,5.87,5.87,5.85,5.85,5.85,5.85,5.86,5.86,5.86,5.86,5.87,5.87,5.87,5.87,5.97,5.99,6,6,6,5.99,5.98,5.96,5.85,5.84,5.85,5.98,6,6.08,6.09,6.07,6,5.98,5.95,5.87,5.75,5.62,5.50,5.36,5.23,5.12,5,5,4.97,4.87,4.85,4.73,4.57,4.37,4.25,4.12,4,4,4,4,3.99,3.99,3.98,3.96,3.87,3.84,3.72,3.57,3.37,3.23,3.10,2.97,2.75,2.62,2.12,2,2,1.98,1.87,1.74,1.70,1.33,1,0.60,-0.01,-0.63,-1.13,-1.75,-2.13,-2.38,-2.63,-2.75,-2.88,-2.89,-2.93,-3,-2.93,-3,-3,-2.90,-2.88,-2.75,-2.38,-1.89,-1.40,-0.91,-0.50,-0.13,0.25,0.62,0.87,0.97,0.99,0.98,0.98,0.98,0.99,1,1.09,1.22,1.37,1.61,1.82,2,2.25,2.62,3.12,3.75,4.50,5.21,5.83,6.36,6.84,7.50,8.61,10.12,11.75,12.87,11.71,9,9,9,9,8.99,8.99,9.03,9.11,9.21,9.33,9.43,9.50,9.51,9.46,9.38,9.30,9.25,9.29,9.45,9.73,10.07,10.37,10.50,10.50,10.21,9.62,9.12,8.72,8.50,8.45,8.25,7.12,5.50,1.87,0.50,-0.75,-1.68,-2.38,-2.75,-2.92,-3,-3,-3.25,-3.61,-4.02,-4.40,-4.66,-4.85,-4.98,-5.12,-5.28,-5.49,-5.63,-5.63,-5.50,-5.27,-4.87,-4.59,-4.42,-3.67,-3.17,-3,-3,-3,-3,-2.88,-2.50,-1.88,-1,0,1,3,4,4.99,5.95,6.10,8,10.12,13.75,15.62,15.37,14.50,13.62,12.87,12.37,12.08,11.75,11.50,11.25,11.12,10.98,10.82,10.62,10.45,10.25,10.12,10,10,9.99,9.99,9.99,9.99,10,10,10,10,10,10,10,10,10,10,9.99,9.98,9.96,9.95,9.87,9.87,9.83,9.75,9.62,9.50,9.37,9.25,9.12,9,8.96,8.87,8.75,8.72,8.62,8.50,8.37,8.33,8.23,8.12,8.08,8,7.97,7.87,7.87,7.85,7.75,7.75,7.62,7.60,7.50,7.37,7.25,7.20,7.10,7,7,6.98,6.97,6.95,6.87,6.86,6.75,6.62,6.50,6.37,6.25,6.12,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.98,5.97,5.95,5.87,5.87,5.75,5.75,5.62,5.62,5.62,5.62,5.61,5.61,5.61,5.61,5.62,5.62,5.70,5.75,5.82,5.85,5.87,5.87,5.87,5.95,5.95,5.84,5.75,5.22,5.75,5.84,5.97,6,6,5.99,5.96,5.87,5.85,5.74,5.58,5.37,5.25,5.12,5.11,5,5,4.97,4.87,4.85,4.73,4.57,4.37,4.25,4.12,4,4,4,4,3.99,3.99,3.98,3.97,3.87,3.84,3.72,3.57,3.37,3.23,3.10,2.97,2.75,2.60,2.25,2.08,2,2,1.87,1.75,1.12,0.75,0.62,0.62,-0.25,-0.79,-1.30,-1.88,-2.28,-2.63,-2.75,-2.88,-2.90,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.89,-2.75,-2.42,-2,-1.50,-1.05,-0.53,0,0.50,0.85,0.97,0.96,0.97,0.98,0.99,1,1.09,1.22,1.37,1.62,1.87,2.09,2.32,2.62,3.12,3.75,4.47,5.25,6,6.72,7.25,7.86,8.50,9.50,10.87,12.50,13.50,12.61,9,9,9,9,8.99,8.99,9.01,9.07,9.14,9.23,9.32,9.37,9.37,9.32,9.24,9.16,9.14,9.21,9.41,9.72,10.10,10.37,10.50,10.46,10.07,9.50,8.96,8.46,8.12,7.75,7.25,6.50,4.87,1.50,0.12,-0.92,-1.68,-2.29,-2.68,-2.89,-3,-3,-3.04,-3.38,-3.72,-4.04,-4.35,-4.58,-4.78,-5,-5.23,-5.47,-5.65,-5.71,-5.65,-5.50,-5.22,-5,-4.61,-3.88,-3.25,-3,-3,-3,-3,-2.89,-2.63,-2.01,-1.17,0.09,1,2,3,4,5,6,7,8.09,11.12,13.75,14.59,14.45,13.75,13,12.47,12.12,11.85,11.57,11.32,11.12,11,10.85,10.62,10.37,10.24,10.10,10,10,9.99,9.99,9.99,9.99,9.99,10,10,10,10,10,10,10,10,10,10,10,9.98,9.95,9.87,9.87,9.82,9.74,9.62,9.50,9.37,9.25,9.12,9,8.87,8.83,8.74,8.62,8.50,8.37,8.34,8.24,8.12,8.09,8,7.97,7.87,7.87,7.84,7.75,7.74,7.62,7.59,7.49,7.37,7.25,7.20,7.11,7,7,6.99,6.97,6.95,6.87,6.85,6.75,6.62,6.50,6.37,6.25,6.12,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.97,5.95,5.87,5.85,5.75,5.62,5.59,5.50,5.45,5.37,5.37,5.37,5.37,5.37,5.37,5.37,5.37,5.46,5.50,5.58,5.62,5.62,5.71,5.75,5.86,5.75,5.75,5.24,5.24,5.22,5.75,5.84,5.96,5.97,5.87,5.87,5.75,5.62,5.50,5.37,5.23,5.12,5.07,5,5,4.98,4.87,4.85,4.73,4.57,4.37,4.25,4.12,4,4,4,4,3.99,3.99,3.98,3.97,3.87,3.85,3.72,3.57,3.37,3.23,3.10,2.97,2.75,2.60,2.35,2.12,2,2,2,1.12,1,0.62,-0.63,-0.63,-0.75,-1.13,-1.63,-2,-2.40,-2.76,-2.88,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.41,-1.92,-1.40,-0.88,-0.18,0.35,0.72,0.87,0.87,0.96,0.98,1,1,1.12,1.37,1.62,1.87,2.12,2.37,2.73,3.12,3.75,4.49,5.32,6.12,6.98,7.62,8.25,8.87,9.62,10.45,11.50,12.96,14.25,15.50,9,9,8.99,8.99,8.99,8.99,9,9.02,9.07,9.13,9.17,9.21,9.20,9.16,9.09,9.02,9.02,9.14,9.37,9.73,10.12,10.46,10.59,10.37,9.97,9.37,8.75,8.20,7.75,7.32,6.75,5.84,4.82,1,-0.13,-0.88,-1.63,-2.25,-2.63,-2.88,-3,-3,-3,-3.04,-3.38,-3.68,-4,-4.29,-4.59,-4.88,-5.14,-5.40,-5.63,-5.73,-5.74,-5.86,-5.73,-5.51,-4.90,-4.37,-3.65,-3,-3,-3,-3,-3,-2.88,-2.25,-1.25,-0.02,1.08,1.98,3,4,5,6,6,7,9.99,12.10,14.70,14.62,13.97,13.25,12.70,12.36,12,11.74,11.47,11.25,11.12,10.96,10.74,10.50,10.25,10.12,10,10,9.99,9.99,9.99,9.99,9.99,10,10,10,10.07,10.10,10.11,10.11,10.10,10.09,10,10,10,9.97,9.87,9.87,9.82,9.73,9.62,9.50,9.37,9.24,9.11,8.99,8.87,8.75,8.62,8.57,8.46,8.35,8.25,8.12,8.09,8,7.98,7.87,7.87,7.84,7.75,7.74,7.62,7.58,7.49,7.37,7.25,7.21,7.12,7,7,6.99,6.97,6.95,6.87,6.85,6.75,6.62,6.50,6.37,6.25,6.12,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.97,5.87,5.87,5.84,5.74,5.62,5.50,5.45,5.36,5.25,5.25,5.23,5.22,5.22,5.22,5.22,5.21,5.22,5.23,5.25,5.33,5.36,5.37,5.47,5.50,5.61,5.73,5.25,5.12,5,5.12,5.23,5.75,5.84,5.87,5.87,5.75,5.60,5.46,5.32,5.12,5.10,5,5,5,4.98,4.87,4.86,4.73,4.57,4.37,4.24,4.12,4,4,4,4,3.99,3.99,3.99,3.97,3.87,3.85,3.72,3.50,3.37,3.23,3.10,2.98,2.82,2.61,2.37,2.12,2,2,2,1.34,0.95,0.49,-0.13,-0.76,-1.30,-1.63,-1.91,-2.25,-2.50,-2.76,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.64,-2.25,-1.68,-1,-0.29,0.25,0.70,0.83,0.87,0.97,0.99,1,1.12,1.34,1.61,1.87,2.25,2.50,2.87,3.25,3.75,4.50,5.36,6.25,7.20,8,8.62,9.25,10,10.99,11.97,12.87,13.62,15.50,16.37,9,8.99,8.99,8.99,8.99,8.99,8.99,9,9,9,9.08,9.08,9.07,9,8.95,8.87,8.87,9,9.32,9.72,10.12,10.50,10.61,10.37,9.87,9.25,8.62,8,7.50,7,6.37,5.46,3.75,1.12,0.37,-0.53,-1.38,-2,-2.50,-2.75,-2.90,-3,-3,-3,-3.13,-3.36,-3.68,-4.04,-4.40,-4.75,-5.04,-5.33,-5.53,-5.64,-5.71,-5.73,-5.60,-5.33,-4.97,-4.65,-4.26,-3.38,-3,-3,-3,-3,-2.79,-2.38,-1.50,-0.38,0.72,1.84,2.86,4,5,6,7,8,9,11,14.75,14.62,14.37,13.50,13.10,12.75,12.37,12.12,11.83,11.60,11.37,11.22,10.96,10.62,10.37,10.21,10.10,10,10,9.99,9.98,9.99,10,10,10,10.10,10.12,10.12,10.21,10.21,10.20,10.12,10.12,10.08,10,9.99,9.87,9.87,9.82,9.73,9.62,9.49,9.37,9.23,9.09,8.97,8.86,8.74,8.62,8.50,8.37,8.25,8.12,8.10,8,7.98,7.87,7.87,7.84,7.75,7.72,7.62,7.58,7.48,7.37,7.25,7.21,7.12,7.07,7,6.99,6.98,6.95,6.87,6.85,6.75,6.62,6.50,6.37,6.25,6.12,6.09,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.97,5.87,5.87,5.83,5.74,5.62,5.50,5.37,5.32,5.23,5.12,5.12,5.11,5.10,5.10,5.10,5.09,5.09,5.10,5.12,5.12,5.12,5.12,5.12,5.23,5.25,5.33,5.25,5.12,5,5,5,5.12,5.23,5.75,5.75,5.62,5.50,5.37,5.25,5.12,5.11,5,5,4.98,4.95,4.87,4.86,4.74,4.57,4.37,4.24,4.12,4,4,4,4,4,3.99,3.99,3.97,3.87,3.85,3.72,3.50,3.37,3.23,3.10,2.98,2.83,2.62,2.37,2.12,2,2,2,1.22,0.87,0.37,0,-0.64,-1.29,-1.88,-2.25,-2.50,-2.63,-2.78,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.76,-2.39,-1.79,-1.05,-0.29,0.33,0.62,0.82,0.87,0.99,1,1.12,1.25,1.58,1.87,2.25,2.62,3,3.47,3.97,4.59,5.37,6.34,7.37,8.33,9.09,9.62,10.25,11.12,12.86,14.62,15.98,16.98,17.50,16.34,8.99,8.99,8.99,8.99,8.98,8.98,8.98,8.98,8.98,8.97,8.95,8.87,8.87,8.82,8.75,8.70,8.73,8.87,9.22,9.62,10.08,10.37,10.50,10.37,9.87,9.25,8.61,8,7.50,7,6.36,5.33,3.75,2.25,1,-0.03,-1,-1.68,-2.25,-2.63,-2.80,-2.92,-3,-3,-3.11,-3.27,-3.54,-3.90,-4.27,-4.63,-4.91,-5.15,-5.37,-5.49,-5.53,-5.58,-5.43,-5.17,-4.89,-4.58,-4.15,-3.74,-3.37,-3,-3,-3,-3,-2.63,-1.93,-0.91,0.12,1.25,2.37,4,5,6,7,8,9,11,12.87,13.85,13.87,13.62,13.37,13.12,12.87,12.62,12.36,12.10,11.87,11.62,11.37,11,10.62,10.37,10.22,10.10,10,9.99,9.98,9.98,10,10,10.09,10.12,10.25,10.32,10.35,10.35,10.32,10.25,10.20,10.12,10.07,10,9.95,9.87,9.82,9.73,9.62,9.50,9.36,9.22,9.08,8.96,8.83,8.71,8.58,8.46,8.34,8.22,8.12,8,7.99,7.87,7.87,7.84,7.75,7.72,7.62,7.58,7.48,7.37,7.25,7.21,7.12,7.07,7,6.99,6.97,6.96,6.87,6.86,6.75,6.62,6.50,6.37,6.25,6.12,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.97,5.95,5.87,5.83,5.74,5.62,5.50,5.37,5.25,5.21,5.12,5.08,5,5,5,5,5,5,5,5,5,5,5,5,5,5.08,5.10,5.09,5.07,5,5,5,5,5,5.12,5.25,5.25,5.25,5.25,5.21,5.12,5.08,5,4.98,4.95,4.87,4.87,4.75,4.62,4.50,4.37,4.22,4.11,4,4,4,4,4,4,3.99,3.98,3.95,3.87,3.73,3.50,3.36,3.21,3.09,2.98,2.83,2.62,2.37,2.12,2,1.99,2,1.62,1,0.25,-0.18,-0.68,-1.25,-1.88,-2.28,-2.63,-2.77,-2.88,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.77,-2.38,-1.75,-1,-0.17,0.37,0.62,0.82,0.96,1.07,1.12,1.35,1.61,1.98,2.37,2.85,3.25,3.75,4.34,4.87,5.59,6.37,7.48,8.62,9.62,10.34,10.83,11.33,12.50,14.87,18.10,20.12,19.75,20.12,20.25,8.99,8.99,8.99,8.98,8.98,8.98,8.97,8.96,8.87,8.87,8.84,8.75,8.62,8.61,8.50,8.50,8.58,8.75,9.09,9.50,9.95,10.25,10.37,10.25,9.87,9.37,8.75,8.24,7.75,7.25,6.71,5.71,4.25,3.08,1.85,0.62,-0.39,-1.25,-1.89,-2.38,-2.66,-2.88,-3,-3,-3.03,-3.22,-3.43,-3.75,-4.13,-4.47,-4.75,-4.98,-5.14,-5.26,-5.38,-5.33,-5.22,-5.02,-4.78,-4.50,-4.18,-3.86,-3.53,-3.27,-3,-3,-3,-2.79,-2.38,-1.50,-0.51,0.59,1.84,3,5,6,7,8,9,11,12,13.84,13.25,13.50,13.62,13.62,13.50,13.21,12.87,12.73,12.59,12.37,12.11,11.62,11.21,10.75,10.48,10.23,10.08,10,9.98,9.98,9.99,10,10.12,10.25,10.37,10.48,10.50,10.50,10.46,10.37,10.25,10.20,10.11,10,9.97,9.87,9.82,9.72,9.61,9.50,9.36,9.22,9.07,8.87,8.75,8.62,8.50,8.37,8.25,8.12,8.09,8,7.95,7.87,7.85,7.75,7.72,7.62,7.57,7.48,7.37,7.25,7.21,7.12,7.07,7,6.99,6.97,6.95,6.87,6.86,6.75,6.62,6.50,6.37,6.25,6.12,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.97,5.87,5.87,5.83,5.74,5.62,5.50,5.37,5.25,5.20,5.12,5.07,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.97,4.96,4.96,4.98,4.98,4.99,4.99,5,4.98,4.97,4.99,5,5,5.08,5.08,5.08,5,5,4.96,4.87,4.87,4.86,4.75,4.72,4.62,4.49,4.36,4.23,4.12,4,4,4,4,4,4,4,3.99,3.97,3.87,3.75,3.50,3.34,3.12,3.07,2.97,2.82,2.62,2.37,2.12,2,1.97,1.87,1.75,1.33,0.61,-0.18,-0.88,-1.38,-1.88,-2.38,-2.66,-2.88,-2.92,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.76,-2.38,-1.63,-0.80,-0.13,0.36,0.60,0.84,1,1.23,1.37,1.71,2.08,2.50,3.08,3.62,4.25,4.95,5.62,6.33,6.87,7.75,8.84,10.22,11.37,12,12.35,12.62,13.84,16.50,20,21.36,22.12,22.74,23.21,8.99,8.99,8.98,8.98,8.98,8.97,8.96,8.87,8.87,8.75,8.71,8.60,8.50,8.37,8.35,8.35,8.37,8.62,8.97,9.37,9.75,10.12,10.32,10.25,10,9.62,9.12,8.74,8.37,8.08,7.50,6.70,5.37,4.25,2.98,1.50,0.20,-0.67,-1.50,-2.13,-2.50,-2.78,-2.93,-3,-3.01,-3.14,-3.34,-3.60,-3.97,-4.26,-4.53,-4.76,-4.93,-5.05,-5.12,-5.11,-5.01,-4.88,-4.71,-4.48,-4.22,-3.92,-3.65,-3.39,-3.17,-3,-3,-2.90,-2.63,-2.13,-1.18,-0.17,1.07,3,4,6,7,9,10,11,12,12.07,12.23,13.12,13.47,13.75,13.73,13.62,13.46,13.37,13.37,13.37,13,12.50,11.95,11.36,10.85,10.37,10.12,10,9.97,9.95,9.95,10,10.12,10.34,10.50,10.62,10.71,10.62,10.61,10.50,10.37,10.25,10.12,10.07,9.98,9.87,9.82,9.72,9.62,9.50,9.35,9.21,9.07,8.87,8.75,8.62,8.50,8.37,8.25,8.12,8,7.98,7.87,7.86,7.75,7.73,7.62,7.57,7.48,7.37,7.25,7.20,7.12,7.07,7,6.99,6.96,6.87,6.87,6.86,6.75,6.62,6.50,6.37,6.25,6.12,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.97,5.87,5.87,5.83,5.74,5.62,5.50,5.37,5.25,5.20,5.12,5.07,5,5,5,5,5,5,4.99,4.99,4.99,4.98,4.97,4.95,4.87,4.87,4.85,4.82,4.82,4.87,4.87,4.87,4.87,4.87,4.86,4.85,4.86,4.87,4.87,4.87,4.87,4.87,4.85,4.75,4.75,4.75,4.70,4.62,4.50,4.37,4.25,4.20,4.12,4,4,4,4,4,4,4,4,3.98,3.87,3.75,3.58,3.35,3.12,3,2.96,2.82,2.61,2.37,2.12,2,1.96,1.87,1.75,1.50,0.98,0.25,-0.63,-1.38,-2,-2.50,-2.76,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.77,-2.38,-1.67,-1,-0.29,0.12,0.50,0.87,1.12,1.47,1.75,2.12,2.62,3.24,3.87,4.62,5.50,6.50,7.45,8.25,8.96,9.74,11,12.62,13.74,14.12,14.20,14.20,15,17.87,20.25,22.09,23.25,25.10,23.12,8.99,8.98,8.98,8.98,8.97,8.96,8.87,8.87,8.75,8.70,8.58,8.45,8.34,8.25,8.20,8.22,8.33,8.50,8.85,9.24,9.62,9.99,10.22,10.25,10.12,9.96,9.70,9.50,9.36,9.32,9,8.32,7.25,6.23,4.82,2.20,1.23,-0.13,-1.13,-1.88,-2.30,-2.65,-2.88,-3,-3,-3.10,-3.22,-3.43,-3.75,-4.05,-4.33,-4.52,-4.71,-4.83,-4.88,-4.90,-4.87,-4.76,-4.63,-4.43,-4.22,-3.98,-3.73,-3.49,-3.24,-3,-3,-3,-2.88,-2.50,-1.88,-0.88,0.37,1.12,4,5,6,9,11,11,11,12,12.87,12.25,13.50,13.61,13.87,13.87,13.82,13.83,14,14.25,13.96,13.37,12.62,11.98,11.25,10.72,10.25,10.07,9.96,9.87,9.85,9.87,10.09,10.37,10.62,10.84,10.87,10.87,10.75,10.62,10.48,10.33,10.20,10.09,9.99,9.87,9.82,9.72,9.62,9.49,9.35,9.20,9,8.87,8.75,8.62,8.48,8.34,8.22,8.11,8,7.87,7.87,7.75,7.74,7.62,7.57,7.48,7.37,7.25,7.21,7.12,7.07,7,6.99,6.96,6.87,6.87,6.85,6.75,6.62,6.50,6.37,6.25,6.12,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.97,5.87,5.87,5.84,5.75,5.62,5.50,5.37,5.25,5.20,5.12,5.07,5,5,5,4.99,4.99,4.99,4.99,4.99,4.99,4.98,4.97,4.95,4.87,4.84,4.75,4.70,4.62,4.62,4.62,4.62,4.62,4.62,4.62,4.62,4.62,4.62,4.62,4.62,4.62,4.62,4.62,4.61,4.58,4.50,4.50,4.49,4.37,4.33,4.23,4.12,4.09,4,4,4,4,3.99,3.99,4,4,3.98,3.87,3.75,3.60,3.36,3.12,3,2.95,2.82,2.61,2.36,2.12,1.97,1.87,1.87,1.75,1.50,1.12,0.62,-0.13,-0.88,-1.67,-2.42,-2.75,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.77,-2.40,-1.88,-1.25,-0.55,-0.05,0.37,0.87,1.35,1.75,2.23,2.73,3.25,4,4.85,5.87,7,8.35,9.57,10.61,11.58,12.62,14.25,15.74,16.61,16.87,15.87,16,17.12,19.21,21.25,22.86,23.95,24.50,24.10,8.99,8.98,8.98,8.97,8.97,8.95,8.87,8.83,8.72,8.59,8.45,8.25,8.20,8.12,8.10,8.12,8.25,8.46,8.75,9.12,9.50,9.87,10.12,10.34,10.37,10.37,10.37,10.46,10.62,10.87,10.84,10.37,9.73,8.75,7.32,5.74,1.75,0.62,-0.68,-1.54,-2.13,-2.50,-2.75,-2.88,-3,-3.03,-3.13,-3.30,-3.59,-3.87,-4.11,-4.30,-4.49,-4.62,-4.71,-4.74,-4.74,-4.67,-4.58,-4.41,-4.24,-4.02,-3.79,-3.55,-3.30,-3.13,-3.02,-3,-2.88,-2.66,-2.15,-1.29,-0.18,1.20,3,4,6,8,9,12,12,11,11.99,11.12,12.32,13.50,14.36,14.11,13.87,13.98,14.12,14.37,14.25,13.87,13.32,12.59,11.75,11.07,10.50,10.12,9.87,9.75,9.62,9.75,9.99,10.37,10.75,11,11.10,11,10.87,10.73,10.50,10.37,10.24,10.11,10,9.87,9.82,9.72,9.62,9.49,9.34,9.12,9,8.87,8.74,8.60,8.45,8.32,8.12,8.08,7.98,7.87,7.83,7.75,7.62,7.58,7.49,7.37,7.25,7.21,7.12,7.07,7,6.98,6.96,6.87,6.87,6.83,6.75,6.62,6.50,6.37,6.25,6.12,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.97,5.87,5.87,5.84,5.75,5.62,5.50,5.37,5.25,5.20,5.12,5.07,5,5,5,4.99,4.99,4.99,4.99,4.99,4.99,4.98,4.97,4.95,4.87,4.82,4.72,4.61,4.50,4.37,4.37,4.37,4.37,4.37,4.37,4.37,4.36,4.37,4.36,4.36,4.36,4.36,4.36,4.35,4.34,4.33,4.32,4.25,4.25,4.22,4.12,4.10,4,4,4,4,4,3.99,3.99,3.98,3.97,3.98,3.87,3.75,3.61,3.37,3.12,3,2.95,2.83,2.61,2.36,2.12,1.87,1.85,1.75,1.58,1.33,1,0.61,0.12,-0.38,-1.13,-1.88,-2.63,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.63,-2.13,-1.53,-0.90,-0.27,0.36,0.98,1.58,2.12,2.72,3.25,3.97,4.75,5.83,7.12,8.62,10.25,11.82,13,14.24,15.62,17.60,19.62,19.75,17.50,17,17.50,18.87,20.62,22.50,23.87,24.08,24.21,24.08,8.99,8.98,8.98,8.97,8.96,8.87,8.86,8.75,8.62,8.47,8.33,8.20,8.11,8,8,8.09,8.21,8.37,8.62,9,9.37,9.82,10.12,10.37,10.62,10.85,11.10,11.48,12,12.61,12.75,12.72,12.33,11.87,10.62,8.24,4.84,1.23,-0.54,-1.01,-1.67,-2.13,-2.50,-2.75,-2.93,-3,-3.08,-3.22,-3.43,-3.67,-3.91,-4.12,-4.29,-4.46,-4.54,-4.62,-4.64,-4.63,-4.54,-4.43,-4.27,-4.10,-3.88,-3.63,-3.38,-3.17,-3.08,-3.01,-3,-2.88,-2.50,-1.80,-0.63,0.75,3,4,5,7,8,10,10,10,10,10,11.21,13.62,14.50,13.82,13.71,13.75,14,14.20,14.25,14.20,13.82,13.11,12.25,11.37,10.72,10.21,9.85,9.62,9.50,9.57,9.87,10.37,10.87,11.12,11.25,11.12,11,10.83,10.62,10.37,10.25,10.12,10,9.87,9.75,9.72,9.61,9.47,9.32,9.12,9,8.86,8.72,8.57,8.37,8.25,8.12,8,7.95,7.86,7.75,7.62,7.59,7.50,7.37,7.25,7.21,7.12,7.07,7,6.98,6.95,6.87,6.87,6.82,6.74,6.62,6.50,6.37,6.25,6.12,6.11,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.97,5.87,5.87,5.85,5.75,5.62,5.50,5.37,5.25,5.20,5.12,5.07,5,5,5,5,4.99,4.99,4.98,4.98,4.98,4.98,4.97,4.87,4.87,4.82,4.70,4.57,4.37,4.33,4.25,4.24,4.22,4.20,4.12,4.12,4.12,4.12,4.12,4.12,4.12,4.12,4.12,4.12,4.12,4.12,4.12,4.12,4.12,4.12,4.09,4,4,4,4,4,4,3.99,3.99,3.98,3.97,3.87,3.87,3.75,3.61,3.37,3.12,3,2.95,2.83,2.62,2.35,2.12,1.95,1.86,1.72,1.50,1.24,0.87,0.57,0.12,-0.27,-0.75,-1.30,-2,-2.63,-2.91,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.90,-2.75,-2.42,-1.89,-1.27,-0.50,0.32,1.09,1.84,2.50,3.22,3.87,4.62,5.57,6.75,8.25,10.07,12,13.87,15.35,16.50,17.98,20.37,21.47,18.87,17.57,17.20,18.60,20.25,22,23.12,23.59,23.87,23.62,22,8.99,8.98,8.98,8.97,8.95,8.87,8.75,8.62,8.50,8.37,8.23,8.12,8,8,8,8.07,8.12,8.36,8.62,8.97,9.36,9.75,10.12,10.50,10.87,11.25,11.75,12.37,13.25,14.08,14.62,14.71,14.82,14.59,15.32,12.62,7.12,1.12,0.87,-0.63,-1.05,-1.75,-2.25,-2.65,-2.88,-2.97,-3.04,-3.14,-3.27,-3.52,-3.76,-3.98,-4.16,-4.34,-4.47,-4.54,-4.61,-4.62,-4.58,-4.49,-4.36,-4.18,-3.98,-3.74,-3.46,-3.24,-3.10,-3.02,-3,-3,-2.88,-2.63,-1.13,0.75,1,3,4,6,8,11,10,9,9,9,10.07,11.86,12.85,13.12,13.25,13.50,13.75,14,14.12,14.12,13.99,13.37,12.57,11.72,10.87,10.25,9.75,9.48,9.37,9.50,9.96,10.50,11,11.33,11.37,11.25,11.12,10.87,10.62,10.48,10.25,10.12,10,9.87,9.75,9.70,9.58,9.37,9.25,9.12,8.98,8.84,8.62,8.50,8.37,8.25,8.12,8,7.87,7.75,7.71,7.61,7.50,7.37,7.25,7.20,7.12,7.07,7,6.98,6.95,6.87,6.86,6.75,6.73,6.62,6.50,6.37,6.25,6.12,6.10,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.98,5.97,5.87,5.87,5.85,5.75,5.62,5.50,5.37,5.25,5.20,5.12,5.07,5,5,5,5,5,4.99,4.99,4.98,4.98,4.98,4.97,4.87,4.87,4.75,4.70,4.50,4.37,4.25,4.12,4.12,4.12,4.10,4.08,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.97,3.87,3.86,3.75,3.58,3.37,3.12,3,2.96,2.84,2.62,2.25,2.12,1.96,1.87,1.75,1.50,1.24,0.87,0.59,0.22,-0.18,-0.64,-1.13,-1.67,-2.27,-2.78,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.89,-2.75,-2.50,-2,-1.38,-0.50,0.37,1.25,2.12,2.98,3.74,4.48,5.25,6.25,7.60,9.21,11.10,13.23,15.37,17.10,17.99,19,20,19.50,18.23,16.84,17.25,18.98,21.83,22,22.62,23.11,23.25,23,21,8.98,8.98,8.97,8.96,8.87,8.85,8.74,8.60,8.37,8.25,8.12,8,8,7.99,8,8,8.12,8.33,8.58,8.87,9.25,9.73,10.12,10.62,11.12,11.62,12.25,13.10,14,14.86,15.50,15.82,15.87,16.45,17.12,16.37,10.73,6,1,0.87,-0.42,-1.25,-1.93,-2.50,-2.77,-2.91,-3.01,-3.09,-3.13,-3.38,-3.63,-3.86,-4.05,-4.25,-4.39,-4.51,-4.61,-4.64,-4.63,-4.59,-4.49,-4.34,-4.13,-3.88,-3.59,-3.30,-3.12,-3.02,-3,-3,-2.90,-2.63,-1.30,-0.80,1,1,3,5,8,11,10,8,8,8,9,10.99,11.87,12.33,12.74,13.23,13.62,13.87,14.10,14.12,13.97,13.37,12.70,11.87,11.11,10.34,9.62,9.34,9.36,9.62,10.25,10.84,11.25,11.50,11.50,11.37,11.20,10.96,10.73,10.50,10.32,10.12,10,9.87,9.75,9.62,9.50,9.37,9.24,9.09,8.95,8.75,8.62,8.50,8.35,8.21,8.08,7.95,7.84,7.73,7.62,7.50,7.37,7.25,7.21,7.12,7.07,7,6.98,6.95,6.87,6.87,6.75,6.72,6.62,6.50,6.37,6.25,6.12,6.09,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.97,5.95,5.87,5.85,5.75,5.62,5.50,5.37,5.25,5.20,5.12,5.07,5,5,5,5,5,5,4.99,4.99,4.98,4.98,4.97,4.87,4.87,4.75,4.70,4.50,4.37,4.25,4.12,4.10,4.07,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.98,3.95,3.87,3.73,3.57,3.37,3.12,3,2.97,2.85,2.75,2.12,2.08,2,2,1.75,1.59,1.25,0.98,0.62,0.25,-0.05,-0.50,-1,-1.50,-2.13,-2.66,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.89,-2.75,-2.50,-2.14,-1.64,-1.01,-0.13,0.71,1.62,2.61,3.48,4.25,5.08,5.87,6.96,8.25,9.82,11.62,13.62,15.75,17.32,18.35,18.87,19.12,18.58,17.37,16.59,17.25,18.87,20.37,21.37,22,22.58,22.75,22.37,20,8.98,8.98,8.97,8.95,8.87,8.75,8.62,8.50,8.34,8.20,8.09,8,7.99,7.98,7.99,8,8.12,8.32,8.50,8.87,9.25,9.70,10.12,10.71,11.25,11.87,12.59,13.37,14.20,14.87,15.59,15.87,16.25,16.95,17.87,18.24,13.50,8.09,5,1,0.58,-0.67,-1.64,-2.38,-2.75,-2.88,-2.98,-3,-3.02,-3.26,-3.51,-3.76,-4,-4.21,-4.38,-4.53,-4.64,-4.73,-4.75,-4.74,-4.65,-4.53,-4.36,-4.11,-3.80,-3.50,-3.23,-3.02,-2.97,-3,-2.90,-2.51,-2,-1.13,-0.28,0.87,2.23,4,6,8,8,7,7,8,10,11,11,11.87,12.25,13.07,13.61,13.87,14,14,13.75,13.33,12.72,12,11.25,10.37,9.62,9.24,9.37,9.98,10.62,11.25,11.57,11.62,11.59,11.45,11.23,11,10.75,10.50,10.33,10.12,10,9.87,9.75,9.62,9.50,9.35,9.20,9,8.87,8.75,8.61,8.47,8.25,8.12,8,7.87,7.75,7.62,7.50,7.37,7.25,7.21,7.12,7,7,6.98,6.95,6.87,6.87,6.75,6.71,6.61,6.50,6.37,6.25,6.12,6.09,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.97,5.96,5.87,5.85,5.75,5.62,5.50,5.37,5.25,5.20,5.12,5.07,5,5,5,5,5,5,5,4.99,4.99,4.98,4.98,4.95,4.87,4.83,4.71,4.50,4.37,4.25,4.12,4.10,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.97,3.87,3.75,3.50,3.34,3.20,3.08,3,2.87,2.87,2,2,2,2,2,1.62,1.36,1.07,0.75,0.37,0,-0.30,-0.75,-1.26,-1.88,-2.50,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.77,-2.79,-2.79,-2.75,-2.50,-2.01,-1.50,-0.88,-0.25,0.57,1.37,2.32,3.22,4.09,4.87,5.73,6.59,7.58,8.75,10.20,11.84,13.62,15.37,16.97,18.09,18.73,18.75,18.25,17.37,16.85,17.45,18.62,19.87,20.87,21.75,22.36,22.50,22.08,20,8.97,8.97,8.95,8.87,8.85,8.73,8.59,8.37,8.25,8.12,8,7.99,7.97,7.97,7.99,8,8.12,8.25,8.50,8.85,9.23,9.62,10.12,10.70,11.25,11.87,12.61,13.32,14,14.62,15.23,15.62,16.12,16.75,17.37,17.87,15.33,10.87,6.97,4,1.50,-0.13,-1.26,-2.13,-2.63,-2.88,-2.93,-2.91,-2.93,-3.15,-3.41,-3.71,-3.97,-4.21,-4.40,-4.60,-4.74,-4.85,-4.90,-4.92,-4.88,-4.78,-4.63,-4.38,-4.10,-3.75,-3.38,-3.04,-2.89,-2.87,-2.90,-2.68,-2.28,-1.76,-0.88,0.12,1.36,2.62,4.97,5,6,6,7,8,10,11,11,11.99,12.12,13.09,13.62,13.95,13.99,13.87,13.70,13.25,12.71,12,11.25,10.45,9.60,9.12,9.49,10.21,11.11,11.62,11.75,11.73,11.62,11.45,11.24,11,10.75,10.50,10.34,10.12,10,9.87,9.75,9.61,9.46,9.25,9.12,9,8.85,8.72,8.57,8.37,8.25,8.11,7.97,7.84,7.71,7.58,7.45,7.33,7.22,7.12,7,7,6.98,6.95,6.87,6.86,6.75,6.73,6.61,6.50,6.37,6.25,6.12,6.09,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.98,5.96,5.87,5.85,5.75,5.62,5.50,5.37,5.25,5.12,5.11,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.97,4.87,4.87,4.75,4.60,4.37,4.25,4.12,4.08,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.98,3.95,3.82,3.82,3.12,3.12,3.07,3,2.96,3,2,2,2,2,2,2,1.37,1.12,0.86,0.50,0.12,-0.25,-0.63,-1.13,-1.63,-2.18,-2.78,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.63,-2.38,-2.38,-2.42,-2.50,-2.38,-2,-1.38,-0.67,0,0.71,1.50,2.33,3.12,4,4.83,5.62,6.46,7.25,8.21,9.25,10.50,12,13.62,15.25,16.82,18,18.74,18.87,18.58,18,17.60,17.75,18.71,19.87,21.12,22.12,22.70,22.74,22.11,20,8.97,8.96,8.87,8.87,8.75,8.62,8.49,8.33,8.12,8.08,8,7.97,7.96,7.97,7.99,8,8.12,8.32,8.50,8.83,9.12,9.61,10.10,10.62,11.21,11.75,12.37,13,13.62,14.22,14.75,15.24,15.75,16.25,16.75,16.62,15.99,12.50,8.23,5.95,2,0.22,-1.01,-1.88,-2.50,-2.88,-3,-2.84,-2.87,-3.08,-3.37,-3.66,-3.97,-4.24,-4.48,-4.68,-4.87,-5,-5.11,-5.15,-5.14,-5.09,-4.92,-4.71,-4.38,-4,-3.54,-3.13,-2.85,-2.79,-2.87,-2.89,-2.64,-2.15,-1.50,-0.63,0.37,1.46,1.50,3,4,5,7,9,11,11,10,11,13,13.07,13.84,13.97,13.98,13.87,13.71,13.24,12.62,12,11.37,10.47,9.62,9.12,9.49,10.25,11.25,11.71,11.75,11.74,11.60,11.37,11.21,10.99,10.75,10.50,10.35,10.12,10,9.87,9.74,9.59,9.37,9.25,9.11,8.96,8.75,8.62,8.50,8.35,8.20,8,7.87,7.75,7.62,7.49,7.36,7.23,7.12,7.07,7,6.99,6.95,6.87,6.87,6.82,6.73,6.62,6.50,6.37,6.25,6.12,6.10,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.98,5.98,5.96,5.87,5.85,5.75,5.62,5.50,5.37,5.25,5.12,5.11,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.97,4.87,4.83,4.62,4.50,4.33,4.12,4.08,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.98,3.97,3.95,3.95,3.95,3.87,3.83,3.75,3.21,3.12,3,2.98,2.87,2.87,2,2,2,2,2,2,1,1.12,0.87,0.61,0.23,-0.17,-0.63,-1.04,-1.50,-2.01,-2.75,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.63,-1.63,-1.63,-1.75,-1.91,-2,-1.88,-1.38,-0.64,0.12,0.87,1.72,2.50,3.32,4.11,4.87,5.62,6.50,7.32,8.12,8.96,9.87,11,12.37,13.87,15.50,17.08,18.34,19.12,19.45,19.25,18.75,18.37,18.25,19,20.50,21.87,23,23.37,23.12,22.50,20,8.96,8.87,8.87,8.83,8.71,8.57,8.37,8.24,8.11,8,7.97,7.95,7.95,7.96,8,8.07,8.12,8.33,8.50,8.82,9.12,9.57,10,10.50,11,11.60,12.12,12.71,13.23,13.75,14.25,14.74,15.24,15.72,16.08,16.12,15.62,14.23,9.96,5.86,1.62,0.21,-1,-1.80,-2.43,-2.79,-2.99,-2.80,-2.79,-3.03,-3.36,-3.68,-4,-4.30,-4.59,-4.83,-5.03,-5.21,-5.34,-5.40,-5.42,-5.38,-5.25,-5.01,-4.71,-4.33,-3.77,-3.26,-2.88,-2.78,-2.87,-3,-2.79,-2.50,-1.91,-1.25,-0.39,0.37,1.11,2,4,5,7,9,10,10,10,11,12,13,14,14,13.99,13.96,13.70,13.11,12.37,12,11.49,10.50,9.50,9.11,9.37,10.12,10.87,11.50,11.70,11.62,11.50,11.33,11.12,10.97,10.75,10.57,10.36,10.12,10,9.87,9.73,9.58,9.37,9.23,9.07,8.87,8.75,8.60,8.37,8.25,8.12,7.99,7.84,7.70,7.50,7.37,7.25,7.12,7.08,7,6.99,6.96,6.87,6.87,6.83,6.75,6.62,6.50,6.37,6.25,6.12,6.11,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.99,5.98,5.98,5.98,5.98,5.98,5.98,5.98,5.97,5.87,5.85,5.75,5.62,5.50,5.37,5.25,5.12,5.10,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.96,4.87,4.75,4.62,4.37,4.25,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.95,3.84,3.74,3.62,3.71,3.72,3.73,3.25,3.12,2.87,2.83,2.85,2.87,2.09,2,2,2,2,1,1,1,0.87,0.62,0.25,-0.25,-0.75,-1.18,-1.63,-2,-2.40,-2.80,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.68,-1.63,-1.25,-0.88,-1.18,-1.39,-1.50,-1.25,-0.68,0.07,0.87,1.74,2.62,3.50,4.34,5.08,5.83,6.61,7.47,8.35,9.12,9.95,10.74,11.86,13.25,14.87,16.46,17.87,19,19.87,20.25,20.12,19.75,19.37,19.25,20,21.46,22.75,23.62,23.82,23.48,22.87,21,8.95,8.87,8.86,8.75,8.62,8.48,8.25,8.12,8,7.97,7.87,7.87,7.87,7.96,8,8.08,8.12,8.35,8.50,8.83,9.12,9.50,9.95,10.37,10.87,11.35,11.84,12.32,12.75,13.25,13.75,14.24,14.73,15.20,15.50,15.71,15.25,14,11.22,6.37,1.37,-0.26,-1.13,-1.91,-2.50,-2.88,-2.97,-2.89,-2.83,-3.09,-3.41,-3.76,-4.11,-4.42,-4.73,-5,-5.25,-5.42,-5.58,-5.66,-5.71,-5.66,-5.54,-5.33,-5,-4.61,-4.05,-3.53,-3.15,-2.87,-2.89,-2.99,-2.85,-2.60,-2.24,-1.75,-1.04,-0.28,0.48,1,4,6,7,9,10,10,10,11,12,13,14,14,14,13.99,13.87,13,12.22,11.98,11.70,10.62,9.34,9.12,9.33,10,10.75,11.22,11.60,11.47,11.35,11.21,11.08,10.95,10.75,10.59,10.37,10.20,10,9.87,9.74,9.57,9.37,9.21,9,8.86,8.70,8.50,8.37,8.22,8.07,7.87,7.75,7.62,7.47,7.33,7.20,7.10,7,7,6.97,6.87,6.87,6.84,6.75,6.62,6.50,6.37,6.25,6.12,6.11,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.99,5.98,5.98,5.98,5.98,5.98,5.97,5.97,5.87,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.10,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.96,4.87,4.75,4.60,4.37,4.22,4.09,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.99,3.98,3.95,3.83,3.62,3.34,3.33,3.32,3.25,3.22,3.10,2.87,2.75,2.20,2.12,2.12,2.10,1.87,1.98,1,1,1,1,1,0.83,0.45,-0.17,-0.88,-1.41,-1.88,-2.25,-2.50,-2.75,-2.91,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.90,-2.26,-1.52,-0.63,-0.75,-0.88,-1,-0.90,-0.63,-0.03,0.73,1.58,2.48,3.50,4.45,5.25,5.98,6.62,7.50,8.50,9.50,10.46,11.33,12.12,13.36,14.87,16.37,17.75,18.96,19.97,20.73,21.21,21.12,20.75,20.37,20.37,21.24,22.37,23.50,23.84,23.75,23.50,23,21,8.87,8.87,8.83,8.71,8.50,8.37,8.22,8.08,7.98,7.87,7.87,7.87,7.87,7.96,8,8.11,8.23,8.37,8.59,8.86,9.12,9.50,9.87,10.25,10.62,11.10,11.50,11.96,12.37,12.84,13.25,13.75,14.25,14.75,15.12,15.37,15.25,14.74,11.98,6.87,1.61,-0.15,-1.38,-2.05,-2.63,-2.88,-2.97,-3.09,-2.84,-3.21,-3.54,-3.89,-4.25,-4.60,-4.90,-5.21,-5.47,-5.64,-5.79,-5.90,-5.96,-5.91,-5.79,-5.58,-5.25,-4.87,-4.36,-3.86,-3.39,-3.12,-2.99,-3.03,-2.91,-2.75,-2.48,-2.08,-1.63,-0.88,-0.04,1,4,6,8,9,9,9,9,11,13,14,15,15,14,14,14,13,12,12,12,10,10,9,9,10,11,11,11.11,11.22,11.11,11,11,10.87,10.75,10.60,10.37,10.21,10,9.87,9.75,9.58,9.37,9.12,9,8.82,8.62,8.48,8.25,8.12,8,7.85,7.70,7.50,7.37,7.25,7.12,7,7,6.97,6.87,6.87,6.85,6.75,6.70,6.50,6.37,6.25,6.12,6.11,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.98,5.98,5.98,5.98,5.97,5.97,5.97,5.96,5.87,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.96,4.87,4.75,4.59,4.37,4.20,4.08,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.99,3.97,3.87,3.82,3.62,3.36,3.12,3.07,3,3,2.95,2.85,2.75,2.23,2.09,1.87,1.85,1.87,1.87,1,1,1,1,1,1,1,0.25,-0.63,-1.38,-2.01,-2.42,-2.68,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.75,-2.16,-1.43,-0.90,-0.63,-0.63,-0.63,-0.42,-0.02,0.59,1.35,2.21,3.12,4.23,5.22,6,6.62,7.37,8.35,9.49,10.73,11.87,12.95,14,15.33,16.72,18,19.12,20,20.75,21.37,21.96,22,21.62,21.37,21.49,22.12,23.10,23.62,23.74,23.59,23.25,22.75,21.08,8.87,8.87,8.75,8.62,8.49,8.25,8.12,8,7.87,7.84,7.83,7.84,7.87,7.95,8,8.12,8.25,8.46,8.62,8.87,9.22,9.50,9.85,10.12,10.50,10.87,11.25,11.61,12,12.46,12.87,13.37,13.87,14.36,14.75,15.12,15.35,15.50,12.75,7.50,2.12,0,-1.38,-2.13,-2.63,-2.88,-2.98,-3.12,-3.12,-3.39,-3.74,-4.09,-4.43,-4.78,-5.12,-5.41,-5.67,-5.86,-6,-6.12,-6.15,-6.13,-6,-5.77,-5.47,-5.13,-4.63,-4.13,-3.73,-3.40,-3.23,-3.13,-3,-2.88,-2.66,-2.37,-1.93,-1.30,-0.51,1.12,3.07,6,7,8,9,8,9,11,13,15,15,15,14,14,13,13,12,12,11,10,10,10,9,10,10,10,10.75,11,11,11,10.99,10.87,10.75,10.61,10.37,10.21,10,9.87,9.75,9.58,9.37,9.12,8.97,8.75,8.59,8.37,8.23,8.07,7.87,7.75,7.61,7.46,7.25,7.12,7.09,7,6.98,6.95,6.87,6.86,6.75,6.72,6.58,6.37,6.25,6.12,6.10,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.98,5.98,5.98,5.98,5.97,5.96,5.95,5.87,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.98,4.95,4.87,4.75,4.57,4.36,4.12,4.09,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.98,3.97,3.87,3.82,3.62,3.36,3.12,3,3,2.96,2.87,2.75,2.61,2.35,2.09,1.84,1.70,1.50,1.12,1.25,1.11,0.87,0.87,0.72,0.50,0.62,0.99,0.09,-0.89,-1.89,-2.63,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.63,-2.02,-1.41,-0.89,-0.63,-0.40,-0.25,0,0.50,1.12,1.87,2.75,3.75,4.84,5.82,6.58,7.22,7.98,8.99,10.25,11.84,13.25,14.57,15.84,17.20,18.61,19.62,20.35,20.75,21.23,21.75,22.25,22.48,22.34,22.12,22.25,22.62,23.22,23.50,23.50,23.25,22.87,22.37,21.10,8.87,8.87,8.75,8.62,8.37,8.22,8,7.87,7.75,7.75,7.74,7.75,7.83,7.87,8,8.20,8.36,8.50,8.75,9,9.25,9.57,9.84,10.11,10.37,10.71,11,11.37,11.75,12.12,12.60,13.07,13.50,14,14.48,14.87,15.12,15.25,13.50,7.87,2.75,0.25,-1.29,-2.25,-2.63,-2.88,-2.98,-3.11,-3.38,-3.61,-3.93,-4.28,-4.63,-4.99,-5.29,-5.59,-5.86,-6.01,-6.16,-6.26,-6.29,-6.25,-6.13,-5.90,-5.62,-5.27,-4.86,-4.42,-4.04,-3.73,-3.51,-3.29,-3.11,-2.97,-2.83,-2.61,-2.25,-1.93,-0.68,1,3.12,5.07,7,8,9,8,9,11,14,16,15,15,14,13,13,12,12,11,11,10,10,10,9,9,10,10,10.72,11,11,11,10.99,10.97,10.84,10.62,10.37,10.20,10,9.87,9.75,9.57,9.36,9.12,8.87,8.72,8.50,8.34,8.12,7.99,7.84,7.62,7.50,7.37,7.24,7.12,7,6.99,6.96,6.87,6.87,6.83,6.74,6.61,6.47,6.32,6.12,6.10,6,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.98,5.98,5.97,5.97,5.96,5.95,5.87,5.86,5.75,5.62,5.50,5.37,5.25,5.12,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.98,4.97,4.87,4.85,4.71,4.50,4.33,4.12,4.08,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.98,3.97,3.87,3.75,3.62,3.36,3.12,3,3,2.97,2.87,2.75,2.57,2.33,2.07,1.75,1.58,1.37,1.12,1,0.96,0.87,0.85,0.70,0.36,-0.03,-0.29,-0.64,-0.75,-1.50,-2.25,-2.78,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.80,-2.38,-1.78,-1.25,-0.75,-0.38,-0.13,0.12,0.50,1,1.62,2.46,3.34,4.32,5.35,6.25,7,7.72,8.37,9.45,10.85,12.50,14.23,15.86,17.37,18.87,20,20.62,20.95,21.12,21.47,21.86,22.25,22.62,22.75,22.75,22.87,23.08,23.32,23.37,23.25,22.98,22.57,21.87,20.12,8.87,8.86,8.73,8.50,8.34,8.12,7.95,7.75,7.70,7.62,7.62,7.62,7.75,7.87,8,8.24,8.45,8.62,8.87,9.12,9.37,9.62,9.86,10.08,10.33,10.57,10.87,11.20,11.50,11.87,12.36,12.75,13.25,13.71,14.12,14.50,14.74,14.62,12.57,8.35,3.11,0.50,-1,-2,-2.63,-2.88,-2.93,-3.13,-3.42,-3.77,-4.13,-4.48,-4.80,-5.13,-5.43,-5.72,-5.97,-6.14,-6.27,-6.36,-6.38,-6.34,-6.22,-6,-5.75,-5.40,-5.02,-4.65,-4.33,-4.04,-3.83,-3.58,-3.27,-3.08,-2.92,-2.76,-2.51,-2.13,-0.88,0.99,2.96,4.87,7,8,7,8,9,11,15,16,16,15,14,13,13,12,12,11,11,10,11,10,9,9,9,10,10.71,10.87,11,11,11,11,10.87,10.62,10.37,10.20,10,9.87,9.75,9.57,9.34,9.11,8.87,8.62,8.46,8.25,8.10,7.87,7.75,7.60,7.37,7.25,7.12,7.08,7,6.97,6.87,6.87,6.85,6.75,6.62,6.50,6.35,6.22,6.12,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.99,5.98,5.98,5.97,5.96,5.95,5.87,5.86,5.75,5.62,5.50,5.37,5.25,5.12,5.11,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.98,4.97,4.87,4.87,4.75,4.62,4.45,4.25,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.98,3.96,3.87,3.75,3.61,3.36,3.12,3,3,2.98,2.87,2.75,2.58,2.32,2,1.73,1.46,1.21,1,0.85,0.75,0.73,0.72,0.61,0.37,-0.03,-0.38,-0.75,-1.01,-1.53,-2.13,-2.63,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.91,-2.75,-2.38,-1.92,-1.41,-0.89,-0.43,-0.13,0.24,0.50,0.87,1.46,2.12,2.87,3.85,4.87,5.87,6.86,7.62,8.25,8.87,9.83,11.12,12.73,14.50,16.48,18.25,19.74,20.62,21,21.25,21.50,21.71,21.99,22.35,22.74,23.08,23.25,23.37,23.47,23.47,23.37,23.12,22.75,22.24,21.37,19.21,8.87,8.82,8.62,8.48,8.25,8,7.84,7.62,7.57,7.50,7.49,7.50,7.62,7.84,8,8.25,8.50,8.75,9,9.25,9.50,9.71,9.87,10.08,10.25,10.50,10.75,11.08,11.37,11.75,12.12,12.57,12.97,13.37,13.75,14.12,14.25,14.24,13.20,9.45,3.35,1.60,-0.38,-1.63,-2.28,-2.66,-2.87,-3.12,-3.49,-3.88,-4.27,-4.63,-4.96,-5.26,-5.53,-5.79,-6.03,-6.24,-6.37,-6.42,-6.41,-6.40,-6.27,-6.09,-5.80,-5.49,-5.13,-4.80,-4.51,-4.29,-4.13,-3.99,-3.54,-3.22,-3.01,-2.85,-2.59,-2.50,-0.88,0.87,2.75,4.87,6,6,7,8,9,11,14,16,16,15,14,13,13,12,12,11,11,11,10,10,10,9,9,10,10.25,10.75,11,10.98,11,11,10.87,10.62,10.37,10.12,10,9.87,9.75,9.57,9.33,9.08,8.83,8.60,8.37,8.21,8,7.86,7.62,7.50,7.36,7.22,7.11,7,6.99,6.95,6.87,6.86,6.75,6.62,6.50,6.37,6.25,6.12,6,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.99,5.99,5.98,5.98,5.97,5.95,5.87,5.86,5.75,5.62,5.50,5.37,5.25,5.20,5.11,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.98,4.97,4.95,4.87,4.75,4.62,4.50,4.35,4.20,4.09,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.98,3.96,3.87,3.75,3.61,3.36,3.12,3,3,2.98,2.95,2.83,2.62,2.33,2,1.62,1.36,1,0.75,0.59,0.46,0.37,0.37,0.37,0.23,-0.13,-0.40,-0.63,-0.25,-1.16,-2,-2.55,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.68,-2.38,-1.90,-1.43,-1,-0.50,-0.13,0.25,0.61,0.95,1.35,1.87,2.57,3.37,4.37,5.46,6.59,7.61,8.35,8.87,9.45,10.12,11.21,12.74,14.50,16.47,18.37,19.82,20.62,21.21,21.61,21.87,22.12,22.33,22.57,22.87,23.36,23.73,23.87,23.87,23.75,23.49,23.12,22.62,22,21,18.25,8.87,8.75,8.62,8.37,8.12,7.87,7.71,7.50,7.37,7.34,7.33,7.37,7.50,7.75,8,8.25,8.57,8.87,9.12,9.37,9.60,9.75,9.87,10.08,10.24,10.46,10.72,11,11.33,11.62,12,12.35,12.70,13,13.36,13.62,13.87,14,13.25,11.25,6.47,2.62,0.33,-1.13,-1.88,-2.43,-2.73,-3.08,-3.51,-3.98,-4.38,-4.74,-5.04,-5.34,-5.59,-5.83,-6.02,-6.21,-6.33,-6.36,-6.35,-6.30,-6.21,-6.01,-5.76,-5.48,-5.16,-4.88,-4.63,-4.47,-4.38,-4.48,-3.96,-3.50,-3.14,-2.85,-2.51,-2.02,-0.88,0.73,2.50,4.22,5,6,6,9,10,12,14,16,16,15,14,14,13,12,12,11,11,11,10,10,10,10,9,9,9.87,10.50,10.87,10.98,10.98,11,10.87,10.62,10.36,10.12,10,9.95,9.75,9.58,9.32,9,8.75,8.50,8.34,8.12,7.98,7.75,7.62,7.46,7.25,7.12,7.07,7,6.97,6.87,6.87,6.75,6.62,6.50,6.37,6.25,6.12,6.09,6,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.98,5.98,5.98,5.98,5.98,5.97,5.95,5.87,5.87,5.75,5.62,5.50,5.37,5.25,5.20,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.98,4.97,4.95,4.87,4.82,4.70,4.50,4.37,4.24,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.98,3.96,3.87,3.75,3.61,3.36,3.12,3,3,2.98,2.95,2.83,2.62,2.33,2,1.62,1.25,0.95,0.62,0.35,0.12,0.08,0.07,0.07,-0.04,-0.28,-0.63,-0.93,-1.01,-1.18,-1.50,-2.38,-2.78,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.90,-2.80,-2.63,-2.38,-1.92,-1.38,-0.88,-0.40,0,0.37,0.74,1,1.37,1.75,2.35,3,3.87,4.95,6.12,7.36,8.50,9.32,9.62,10,10.48,11.24,12.50,14.37,16.37,18.22,19.62,20.62,21.46,22.10,22.58,22.83,22.87,22.87,23.12,23.62,24.09,24.36,24.37,24.12,23.70,23.12,22.57,21.82,20.75,18.34,8.87,8.75,8.50,8.25,8,7.75,7.50,7.37,7.24,7.12,7.12,7.23,7.37,7.62,7.87,8.25,8.61,8.87,9.24,9.48,9.71,9.85,9.96,10.08,10.23,10.37,10.62,10.96,11.25,11.50,11.85,12.12,12.37,12.62,12.87,13.21,13.48,13.71,13.37,12.12,7.59,3.37,0.87,-0.50,-1.50,-2.13,-2.52,-3,-3.51,-4.03,-4.43,-4.78,-5.09,-5.34,-5.54,-5.75,-5.93,-6.10,-6.18,-6.23,-6.22,-6.15,-6.08,-5.90,-5.67,-5.40,-5.13,-4.88,-4.66,-4.52,-4.50,-4.53,-4.25,-3.72,-3.26,-2.89,-2.49,-1.86,-1,0.37,2.20,4.25,6,5,8,11,13,14,15,16,16,15,15,14,13,12,12,11,11,11,10,10,10,9,9,9,9.25,10.22,10.62,10.86,10.96,10.98,10.87,10.62,10.33,10.12,10,9.95,9.84,9.60,9.32,9,8.73,8.48,8.25,8.09,7.87,7.75,7.60,7.37,7.24,7.11,7,6.99,6.96,6.87,6.82,6.71,6.58,6.45,6.32,6.21,6.11,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.99,5.98,5.98,5.98,5.98,5.97,5.97,5.96,5.87,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.12,5.07,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.98,4.97,4.95,4.87,4.82,4.70,4.50,4.37,4.25,4.12,4.07,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.98,3.96,3.87,3.75,3.60,3.36,3.12,3,3,2.98,2.95,2.83,2.62,2.34,2,1.62,1.25,0.87,0.50,0.20,-0.05,-0.25,-0.25,-0.25,-0.25,-0.38,-0.75,-1.17,-1.63,-1.88,-2,-2.25,-3,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.88,-2.75,-2.50,-2.25,-1.88,-1.38,-0.75,-0.25,0.24,0.62,1,1.33,1.62,1.98,2.37,2.95,3.62,4.50,5.62,6.85,8.21,9.46,10.32,10.49,10.70,10.87,11.45,12.59,14.37,16.50,18.35,19.83,20.99,21.99,22.82,23.37,23.58,23.37,23.33,23.48,23.87,24.37,24.75,24.82,24.46,23.85,23.12,22.37,21.61,20.59,18.37,8.87,8.75,8.49,8.20,7.87,7.62,7.37,7.20,7,6.95,6.87,7,7.20,7.48,7.83,8.21,8.60,8.97,9.33,9.58,9.75,9.87,9.97,10.08,10.23,10.37,10.62,10.87,11.12,11.37,11.62,11.87,12.07,12.25,12.48,12.74,13,13.34,13.25,12,8.25,3.07,1.62,0.07,-1.03,-1.79,-2.35,-2.89,-3.50,-4.08,-4.49,-4.80,-5.05,-5.26,-5.46,-5.63,-5.78,-5.91,-6.01,-6.04,-6.03,-6,-5.91,-5.75,-5.54,-5.29,-5.03,-4.80,-4.63,-4.50,-4.47,-4.52,-4.46,-3.87,-3.38,-2.98,-2.55,-2,-1.16,-0.01,1.57,3.97,4,6,8,11,14,15,16,16,17,16,15,14,13,12,12,11,11,11,10,10,10,10,9,9,9.75,9.87,10.33,10.62,10.84,10.95,10.87,10.59,10.25,10.09,10,9.96,9.85,9.61,9.32,9,8.70,8.37,8.22,8,7.87,7.74,7.57,7.37,7.22,7.10,7,6.97,6.87,6.85,6.75,6.62,6.50,6.36,6.24,6.12,6.07,6,6,6,6,6,6,6,5.99,5.99,5.98,5.99,5.98,5.98,5.98,5.98,5.97,5.96,5.95,5.87,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.97,4.95,4.87,4.82,4.70,4.50,4.37,4.25,4.12,4.07,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.98,3.96,3.87,3.75,3.60,3.36,3.12,3,3,2.98,2.87,2.82,2.62,2.33,2,1.70,1.32,0.87,0.45,0.08,-0.25,-0.38,-0.50,-0.41,-0.38,-0.38,-0.53,-1,-1.63,-2.16,-2.50,-2.63,-2.75,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.79,-2.63,-2.38,-2,-1.63,-1.14,-0.63,-0.01,0.50,1,1.37,1.75,2.12,2.50,2.87,3.32,3.83,4.50,5.36,6.37,7.62,8.97,10.21,11,11.25,11.37,11.50,12,13.22,15,17.12,18.87,20.37,21.62,22.75,23.75,24.24,24.07,23.83,23.62,23.75,24.12,24.59,25,25.08,24.62,23.85,23,22.20,21.37,20.37,18.50,8.85,8.71,8.37,8.09,7.75,7.45,7.21,7,6.84,6.73,6.71,6.75,6.99,7.25,7.70,8.12,8.60,9,9.36,9.61,9.75,9.87,9.97,10.07,10.21,10.37,10.62,10.85,11.08,11.25,11.45,11.59,11.71,11.84,12,12.24,12.58,12.87,13,11.96,8.75,5.25,2.37,0.62,-0.63,-1.51,-2.18,-2.84,-3.49,-4.11,-4.50,-4.77,-4.98,-5.13,-5.28,-5.46,-5.60,-5.73,-5.80,-5.85,-5.85,-5.80,-5.74,-5.60,-5.39,-5.16,-4.92,-4.71,-4.55,-4.43,-4.38,-4.37,-4.29,-3.91,-3.48,-3.08,-2.71,-2.23,-1.54,-0.63,0.62,1.87,3.25,4.62,6.75,9,13,15,16,17,17,16,15,14,13,12,12,11,11,11,10,10,10,10,10,9,9.21,9.75,10.11,10.35,10.50,10.62,10.59,10.37,10.22,10.07,10,10,9.87,9.62,9.32,8.99,8.62,8.37,8.20,8,7.87,7.71,7.50,7.35,7.20,7.09,7,6.96,6.87,6.82,6.71,6.58,6.37,6.25,6.12,6.09,6,6,6,6,6,6,6,5.99,5.99,5.99,5.98,5.98,5.98,5.98,5.97,5.97,5.96,5.87,5.87,5.86,5.75,5.62,5.50,5.37,5.25,5.12,5.08,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.96,4.87,4.82,4.70,4.50,4.37,4.25,4.12,4.08,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.99,3.98,3.98,3.98,3.98,3.96,3.87,3.75,3.60,3.36,3.12,3,3,2.97,2.87,2.75,2.59,2.25,2,1.71,1.37,0.97,0.49,0,-0.30,-0.52,-0.63,-0.63,-0.42,-0.30,-0.25,-0.50,-1.13,-1.78,-2.43,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.91,-2.75,-2.51,-2.18,-1.79,-1.38,-0.89,-0.38,0.21,0.86,1.37,1.95,2.37,2.85,3.25,3.75,4.12,4.58,5,5.57,6.34,7.25,8.45,9.71,10.84,11.62,12,12.21,12.35,13,14.47,16.25,18.20,19.85,21.25,22.50,23.62,24.61,24.62,24.36,24.08,23.87,24,24.25,24.62,24.97,24.96,24.48,23.62,22.74,21.87,21.10,20.25,18.61,8.82,8.62,8.33,7.96,7.60,7.25,7,6.82,6.62,6.50,6.50,6.62,6.83,7.12,7.60,8.09,8.58,9,9.37,9.61,9.75,9.86,9.87,10,10.12,10.37,10.58,10.75,10.97,11.12,11.22,11.25,11.33,11.37,11.50,11.72,12.12,12.50,12.75,11.87,9.12,5.87,3.12,1.12,-0.25,-1.26,-2.08,-2.79,-3.48,-4.08,-4.47,-4.67,-4.85,-4.98,-5.11,-5.24,-5.38,-5.49,-5.58,-5.63,-5.63,-5.61,-5.54,-5.41,-5.25,-5.03,-4.80,-4.62,-4.43,-4.33,-4.25,-4.24,-4.17,-3.89,-3.52,-3.14,-2.85,-2.49,-1.99,-1.40,-0.39,0.73,1.73,3.35,5.09,7.37,10,13,15,16,16,14,14,14,13,12,12,11,11,11,10,10,10,10,9,9,9.12,9.62,10,10.09,10.20,10.25,10.25,10.22,10.11,10,10,10,9.87,9.62,9.33,8.99,8.62,8.37,8.12,8,7.85,7.62,7.50,7.32,7.12,7.08,7,6.87,6.87,6.75,6.62,6.50,6.37,6.23,6.12,6,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.98,5.98,5.98,5.97,5.96,5.95,5.87,5.87,5.85,5.75,5.62,5.50,5.37,5.24,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.98,4.96,4.87,4.83,4.71,4.50,4.37,4.25,4.12,4.08,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.99,3.98,3.98,3.98,3.97,3.97,3.96,3.87,3.87,3.85,3.74,3.57,3.37,3.20,3.08,3,2.98,2.87,2.75,2.50,2.23,1.87,1.60,1.33,1,0.59,0.12,-0.28,-0.63,-0.76,-0.75,-0.63,-0.40,-0.13,-0.25,-0.55,-1.25,-2,-2.63,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.91,-2.75,-2.42,-2.05,-1.63,-1.16,-0.66,-0.13,0.50,1.12,1.84,2.47,3,3.58,4.12,4.71,5.25,5.75,6.11,6.37,6.75,7.37,8.25,9.35,10.50,11.60,12.46,12.99,13.23,13.62,14.62,16.12,17.86,19.50,21,22.25,23.35,24.25,24.73,24.72,24.46,24.23,24.12,24.12,24.34,24.50,24.61,24.37,23.87,23.12,22.33,21.50,20.75,19.98,18.71,8.75,8.58,8.24,7.84,7.45,7.12,6.85,6.62,6.48,6.37,6.37,6.49,6.72,7.08,7.50,8.07,8.58,9,9.36,9.59,9.72,9.75,9.87,9.99,10.12,10.33,10.50,10.71,10.85,10.95,10.97,10.97,10.95,10.97,11.07,11.25,11.75,12.24,12.50,11.83,9,6.08,3.47,1.48,-0.02,-1.13,-1.99,-2.75,-3.43,-4,-4.34,-4.52,-4.66,-4.76,-4.89,-5.01,-5.14,-5.25,-5.35,-5.40,-5.42,-5.41,-5.37,-5.26,-5.12,-4.91,-4.71,-4.51,-4.34,-4.18,-4.12,-4.09,-4,-3.84,-3.51,-3.16,-2.93,-2.71,-2.38,-2,-1.25,-0.38,0.62,1.84,3.12,4.50,7,11,13,14,13,12,13,13,13,12,12,11,11,11,10,10,10,9,9,9,9.11,9.71,9.62,9.75,9.87,10,10.07,10.07,10,10,10,10,9.87,9.62,9.33,8.99,8.62,8.37,8.12,7.99,7.84,7.62,7.46,7.25,7.12,7,6.98,6.87,6.85,6.74,6.61,6.47,6.32,6.12,6.09,6,6,6,6,6,6,5.99,5.99,5.99,5.99,5.98,5.98,5.98,5.97,5.96,5.95,5.87,5.87,5.85,5.75,5.62,5.50,5.37,5.25,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.97,4.87,4.85,4.71,4.50,4.37,4.25,4.12,4.09,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.98,3.97,3.97,3.97,3.96,3.87,3.87,3.82,3.71,3.50,3.37,3.24,3.12,3,2.96,2.87,2.75,2.50,2.12,1.75,1.46,1.12,0.87,0.57,0.23,-0.15,-0.50,-0.75,-1,-0.77,-0.63,-0.43,-0.27,-0.41,-0.88,-1.40,-2.14,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.75,-2.38,-1.93,-1.50,-1,-0.50,0.09,0.70,1.37,2.12,2.87,3.62,4.24,4.85,5.50,6.22,6.87,7.37,7.62,7.72,7.97,8.50,9.33,10.37,11.50,12.72,13.62,14.32,14.72,15.20,16.37,17.86,19.49,20.97,22.11,23,23.75,24.25,24.50,24.50,24.37,24.25,24.25,24.25,24.35,24.37,24.25,23.87,23.37,22.62,21.84,21,20.25,19.48,17.82,8.75,8.50,8.12,7.72,7.25,6.96,6.62,6.47,6.32,6.25,6.25,6.37,6.62,7,7.50,8.07,8.59,9,9.34,9.50,9.62,9.72,9.75,9.87,10.08,10.25,10.45,10.61,10.72,10.75,10.73,10.62,10.57,10.50,10.50,10.87,11.37,11.99,12.24,11.12,8.75,5.97,3.49,1.57,0,-1.02,-1.93,-2.72,-3.38,-3.87,-4.16,-4.35,-4.46,-4.54,-4.66,-4.79,-4.91,-5.03,-5.13,-5.21,-5.25,-5.25,-5.22,-5.13,-5,-4.84,-4.63,-4.42,-4.24,-4.08,-3.98,-3.90,-3.84,-3.66,-3.41,-3.17,-2.97,-2.78,-2.61,-2.50,-2,-1.38,-0.52,0.37,1.25,1.87,1,7,9,11,10,11,13,13,13,12,12,11,11,11,10,10,10,9,9,10,9,9,9.11,9.34,9.62,9.85,9.96,10,10,10,10,10,9.87,9.62,9.33,8.99,8.62,8.37,8.12,7.98,7.82,7.62,7.37,7.25,7.12,7,6.96,6.87,6.75,6.62,6.50,6.37,6.25,6.12,6.07,6,6,6,6,6,5.99,5.99,5.99,5.99,5.98,5.98,5.98,5.97,5.96,5.95,5.87,5.87,5.83,5.75,5.62,5.50,5.37,5.25,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.96,4.87,4.73,4.50,4.37,4.25,4.12,4.09,4,4,4,4,4,4,4,4,4,4,3.99,3.98,3.98,3.97,3.97,3.97,3.96,3.95,3.87,3.87,3.75,3.70,3.50,3.37,3.24,3.12,3,2.98,2.87,2.75,2.50,2.12,1.72,1.32,0.98,0.71,0.47,0.23,-0.01,-0.27,-0.51,-0.63,-0.64,-0.65,-0.64,-0.66,-0.75,-1.13,-1.38,-1.88,-2.38,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.76,-2.38,-1.88,-1.38,-0.88,-0.28,0.24,0.75,1.37,2.21,3.12,4,4.82,5.48,6.07,6.75,7.59,8.35,8.75,8.87,8.84,9,9.50,10.37,11.50,12.87,14.25,15.36,16,16.37,16.98,18,19.45,20.95,22.09,22.75,23.25,23.62,23.87,24.12,24.25,24.35,24.35,24.35,24.35,24.32,24.20,23.87,23.46,22.83,22.08,21.25,20.50,19.75,18.87,16.95,8.75,8.47,8,7.59,7.12,6.75,6.50,6.25,6.12,6.12,6.20,6.36,6.62,7.07,7.57,8.10,8.60,9,9.25,9.47,9.50,9.61,9.70,9.82,9.99,10.12,10.36,10.49,10.57,10.50,10.47,10.34,10.20,10.07,10.12,10.45,11,11.72,11.87,10.82,8.50,5.87,3.46,1.50,0,-1.13,-1.92,-2.67,-3.30,-3.84,-4,-4.13,-4.23,-4.34,-4.43,-4.58,-4.71,-4.84,-4.93,-5.02,-5.09,-5.11,-5.10,-5.02,-4.92,-4.77,-4.59,-4.38,-4.17,-3.99,-3.85,-3.75,-3.63,-3.47,-3.25,-3.03,-2.88,-2.80,-2.75,-2.71,-2.51,-2.16,-1.50,-0.88,-0.38,0,1.07,1.57,5,7,7,10,12,13,12,12,12,11,11,11,10,10,10,10,10,10,9,8.12,8.34,8.87,9.37,9.75,9.95,10,10,10,10,10,9.87,9.62,9.33,8.99,8.62,8.37,8.12,7.97,7.75,7.60,7.37,7.25,7.11,7,6.87,6.86,6.75,6.62,6.48,6.34,6.21,6.11,6,6,6,6,6,5.99,5.99,5.99,5.99,5.98,5.98,5.98,5.97,5.96,5.95,5.87,5.87,5.83,5.75,5.62,5.50,5.37,5.24,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.87,4.75,4.57,4.37,4.24,4.12,4.09,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.97,3.97,3.96,3.95,3.87,3.87,3.75,3.62,3.50,3.37,3.24,3.12,3,3,2.96,2.85,2.62,2.25,1.84,1.34,0.87,0.61,0.37,0.25,0.12,-0.01,-0.14,-0.25,-0.26,-0.25,-0.41,-0.64,-0.76,-1,-1.25,-1.63,-2.13,-2.52,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.89,-2.75,-2.38,-1.90,-1.38,-0.75,-0.13,0.37,0.87,1.46,2.09,2.87,4,5,5.97,6.50,7.11,7.75,8.62,9.33,9.70,9.70,9.62,9.75,10.37,11.47,12.87,14.45,16,17.10,17.62,17.87,18.45,19.37,20.75,22.12,22.86,22.99,23,23.23,23.50,23.83,24.11,24.25,24.37,24.37,24.35,24.23,23.99,23.57,22.99,22.25,21.50,20.75,20,19.25,18.37,17.09,8.62,8.37,7.87,7.37,6.98,6.61,6.33,6.12,6,6,6.12,6.36,6.62,7.12,7.62,8.12,8.61,8.98,9.22,9.36,9.37,9.48,9.58,9.71,9.87,10.07,10.23,10.35,10.37,10.34,10.22,10,9.82,9.62,9.62,9.97,10.50,11.12,11.49,10.37,8.33,5.83,3.47,1.50,-0.13,-1.18,-2,-2.64,-3.22,-3.67,-3.86,-3.91,-4,-4.11,-4.23,-4.36,-4.50,-4.63,-4.75,-4.87,-4.96,-5,-5,-4.98,-4.89,-4.76,-4.60,-4.39,-4.17,-3.97,-3.77,-3.62,-3.46,-3.25,-3.02,-2.78,-2.68,-2.72,-2.76,-2.78,-2.79,-2.63,-2.25,-1.88,-1.43,-0.89,-0.38,0.85,1.57,4,5,8,11,12,12,12,12,11,11,11,10,10,10,10,10,9,9,8.08,8.25,8.62,9.25,9.62,10,10.12,10.11,10,10,10,9.87,9.62,9.33,8.99,8.62,8.37,8.12,7.97,7.75,7.59,7.37,7.24,7.10,7,6.87,6.82,6.71,6.57,6.37,6.25,6.12,6.08,6,6,6,6,6,5.99,5.99,5.99,5.98,5.98,5.98,5.97,5.96,5.95,5.87,5.87,5.83,5.75,5.62,5.50,5.37,5.25,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.87,4.62,4.45,4.24,4.12,4.08,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.97,3.96,3.95,3.87,3.87,3.75,3.62,3.50,3.37,3.24,3.12,3,3,2.99,2.95,2.75,2.50,2.12,1.60,1.07,0.71,0.50,0.37,0.34,0.25,0.25,0.24,0.23,0.21,0.12,-0.13,-0.38,-0.54,-0.78,-1.13,-1.50,-2,-2.43,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.79,-2.43,-2,-1.39,-0.75,-0.04,0.60,1.12,1.61,2,2.62,3.50,4.62,5.75,6.70,7.36,7.87,8.50,9.23,9.82,10.11,10.11,10.09,10.37,11.25,12.62,14.35,16.09,17.62,18.62,19,19.10,19.50,20.25,21.45,22.60,22.98,22.75,22.73,22.75,23.09,23.61,24,24.25,24.37,24.36,24.25,24.07,23.70,23.12,22.48,21.74,20.97,20.23,19.50,18.75,17.97,16.24,8.37,8.12,7.70,7.23,6.75,6.37,6.12,6,5.87,5.97,6.12,6.37,6.74,7.20,7.62,8.12,8.59,8.87,9.11,9.22,9.25,9.34,9.45,9.59,9.75,9.87,10.09,10.12,10.21,10.12,9.95,9.71,9.37,9.24,9.23,9.37,9.86,10.36,10.58,9.75,8,5.70,3.47,1.50,-0.15,-1.28,-2.13,-2.63,-3.13,-3.51,-3.65,-3.71,-3.76,-3.88,-4,-4.14,-4.29,-4.48,-4.63,-4.75,-4.86,-4.92,-4.98,-4.98,-4.91,-4.79,-4.64,-4.48,-4.25,-4.01,-3.78,-3.58,-3.36,-3.12,-2.83,-2.54,-2.48,-2.52,-2.65,-2.79,-2.86,-2.88,-2.65,-2.50,-2.17,-1.75,-1.13,-0.13,1.25,3,4,6,9,11,12,13,13,12,11,11,10,10,10,10,9,9,9,8,8.12,8.62,9.20,9.60,10,10.25,10.25,10.12,10,10,9.87,9.62,9.33,8.99,8.62,8.37,8.12,7.97,7.75,7.58,7.37,7.23,7.10,6.99,6.87,6.75,6.62,6.50,6.35,6.21,6.11,6,6,6,6,6,6,5.99,5.99,5.98,5.98,5.98,5.97,5.96,5.95,5.87,5.87,5.83,5.74,5.62,5.50,5.37,5.25,5.12,5.08,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.99,4.87,4.83,4.62,4.37,4.12,4.07,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.97,3.95,3.87,3.87,3.75,3.62,3.50,3.37,3.24,3.12,3,3,3,2.98,2.87,2.75,2.50,2.08,1.57,0.85,0.75,0.72,0.70,0.62,0.62,0.70,0.72,0.73,0.62,0.50,0.36,0.12,-0.13,-0.38,-0.75,-1.16,-1.67,-2.25,-2.68,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.89,-2.63,-2.25,-1.63,-0.93,-0.17,0.60,1.32,1.87,2.25,2.61,3.12,4,5.24,6.35,7.23,7.86,8.35,8.87,9.50,10,10.25,10.25,10.45,11.07,12.32,14,15.95,17.70,19,19.62,19.85,19.87,20.12,20.72,21.50,22.25,22.50,22.32,22.32,22.47,22.87,23.50,24,24.25,24.35,24.25,24.07,23.75,23.25,22.62,21.87,21.12,20.37,19.62,18.87,18.25,17.50,16.37,8.11,7.86,7.45,7,6.61,6.25,6,5.87,5.84,5.87,6.12,6.37,6.83,7.25,7.75,8.12,8.50,8.75,8.96,9,9.10,9.12,9.25,9.45,9.62,9.75,9.87,10,10,9.87,9.62,9.37,9.09,8.86,8.75,8.87,9.12,9.37,9.50,8.87,7.48,5.48,3.37,1.57,-0.13,-1.25,-2.05,-2.76,-3.03,-3.35,-3.46,-3.50,-3.54,-3.66,-3.79,-3.97,-4.15,-4.34,-4.50,-4.65,-4.78,-4.89,-4.98,-5,-4.99,-4.90,-4.77,-4.60,-4.39,-4.14,-3.88,-3.62,-3.36,-3.09,-2.75,-2.46,-2.36,-2.38,-2.52,-2.74,-2.88,-3,-2.88,-2.79,-2.63,-2.39,-1.76,-0.63,0.62,2,3,5,8,10,13,13,13,12,11,11,11,10,10,9,9,9,9,8,8.07,8.75,9.09,9.46,9.95,10.37,10.48,10.32,10.12,10,9.87,9.62,9.33,8.99,8.62,8.33,8.12,7.96,7.75,7.58,7.37,7.23,7.09,6.98,6.87,6.75,6.61,6.45,6.25,6.12,6.08,6,6,6,6,6,5.99,5.99,5.99,5.98,5.98,5.97,5.97,5.95,5.87,5.87,5.83,5.74,5.62,5.50,5.37,5.25,5.12,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.98,4.87,4.86,4.73,4.50,4.25,4.12,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.96,3.87,3.87,3.83,3.72,3.57,3.37,3.25,3.12,3,3,3,2.99,2.98,2.87,2.75,2.50,2.11,1.62,1.32,1.11,1.07,1,1.07,1.12,1.12,1.12,1.12,1.12,1,0.83,0.61,0.37,0.12,-0.26,-0.75,-1.30,-1.88,-2.41,-2.75,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.50,-2,-1.38,-0.54,0.33,1.20,1.99,2.62,2.87,3.12,3.50,4.48,5.74,6.82,7.58,8.12,8.62,9.20,9.73,10.12,10.37,10.60,11,12,13.72,15.72,17.59,19,19.95,20.25,20.25,20.25,20.37,20.73,21.12,21.45,21.58,21.62,21.95,22.36,22.95,23.50,24.09,24.34,24.32,24.12,23.82,23.36,22.75,22.07,21.32,20.50,19.75,19,18.35,17.75,17.23,16.57,7.73,7.48,7.12,6.75,6.37,6.10,5.87,5.75,5.75,5.87,6.12,6.50,6.87,7.36,7.75,8.12,8.45,8.62,8.75,8.84,8.87,8.99,9.12,9.25,9.47,9.62,9.75,9.83,9.75,9.62,9.37,9.08,8.74,8.48,8.35,8.37,8.50,8.62,8.50,8,6.87,5.25,3.46,1.71,0,-1.04,-2,-2.67,-2.92,-3.14,-3.26,-3.29,-3.35,-3.48,-3.62,-3.83,-4.01,-4.22,-4.40,-4.60,-4.75,-4.89,-5,-5.08,-5.10,-5.05,-4.97,-4.80,-4.60,-4.35,-4.09,-3.78,-3.50,-3.22,-2.90,-2.65,-2.49,-2.38,-2.46,-2.65,-2.86,-3,-3,-3,-2.93,-2.75,-2.13,-1.16,-0.03,1,1,4,6,9,11,13,13,12,12,11,11,11,10,9,9,9,8,9,8,8.87,8.87,9.25,9.71,10.25,10.59,10.47,10.21,10,9.87,9.62,9.33,8.99,8.62,8.36,8.12,7.96,7.75,7.58,7.37,7.23,7.09,6.98,6.87,6.74,6.59,6.37,6.25,6.12,6.07,6,6,6,6,6,5.99,5.99,5.99,5.98,5.98,5.97,5.96,5.87,5.87,5.83,5.74,5.62,5.50,5.37,5.25,5.12,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.98,4.87,4.85,4.73,4.50,4.36,4.20,4.08,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.96,3.87,3.87,3.75,3.62,3.47,3.25,3.12,3.08,3,3,2.99,2.98,2.96,2.87,2.75,2.50,2.12,1.83,1.57,1.37,1.37,1.37,1.37,1.47,1.50,1.50,1.50,1.49,1.37,1.23,1,0.85,0.50,0.12,-0.39,-1,-1.63,-2.17,-2.63,-2.90,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.75,-2.38,-1.88,-1.13,-0.25,0.75,1.74,2.62,3.25,3.49,3.62,4.09,5,6.12,7.10,7.85,8.37,8.87,9.49,10,10.50,10.87,11.25,12.07,13.37,15.25,17.25,18.87,19.87,20.36,20.47,20.37,20.25,20.25,20.37,20.59,20.73,20.87,21.25,21.75,22.34,23,23.62,24.11,24.34,24.25,24,23.58,22.96,22.25,21.50,20.74,19.96,19.21,18.47,17.83,17.37,17.09,16.75,7.12,7.12,6.86,6.50,6.21,5.87,5.75,5.62,5.74,5.87,6.22,6.60,7,7.37,7.75,8.09,8.25,8.45,8.50,8.61,8.62,8.75,8.87,9.11,9.25,9.47,9.60,9.62,9.62,9.45,9.12,8.75,8.37,8.12,7.95,7.87,7.95,7.99,7.87,7.45,6.58,5.25,3.62,1.98,0.48,-0.75,-1.75,-2.63,-2.84,-3,-3.12,-3.14,-3.18,-3.33,-3.48,-3.68,-3.90,-4.12,-4.34,-4.53,-4.75,-4.91,-5.05,-5.17,-5.25,-5.25,-5.21,-5.10,-4.89,-4.65,-4.38,-4.05,-3.75,-3.47,-3.16,-2.89,-2.66,-2.58,-2.50,-2.64,-2.85,-3,-3,-3,-3,-2.88,-2.50,-1.75,-1,-1,1,3,5,6,9,13,14,13,12,12,11,11,10,9,9,8,8,8,8,8,8.83,9,9.47,9.97,10.37,10.36,10.23,10.08,9.87,9.62,9.33,8.99,8.62,8.36,8.12,7.97,7.75,7.59,7.37,7.23,7.09,6.98,6.86,6.73,6.57,6.37,6.25,6.12,6,6,6,6,6,6,5.99,5.99,5.98,5.98,5.97,5.96,5.87,5.87,5.84,5.75,5.62,5.50,5.37,5.25,5.12,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.97,4.87,4.84,4.72,4.50,4.37,4.24,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.95,3.87,3.83,3.71,3.50,3.37,3.22,3.10,3,3,2.99,2.98,2.96,2.87,2.84,2.62,2.45,2.12,1.87,1.74,1.62,1.62,1.62,1.62,1.71,1.75,1.75,1.75,1.73,1.62,1.50,1.25,0.99,0.62,0.24,-0.25,-0.88,-1.51,-2.13,-2.63,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.92,-2.68,-2.30,-1.75,-0.91,0.07,1.12,2.25,3.20,3.83,4,4.12,4.62,5.50,6.50,7.37,8.12,8.73,9.32,9.98,10.62,11.33,11.87,12.59,13.58,15,16.71,18.33,19.50,20.10,20.25,20.25,20.12,20,19.95,19.87,19.99,20.12,20.62,21.25,21.87,22.50,23.10,23.71,24.12,24.36,24.25,23.96,23.25,22.50,21.75,21,20.21,19.37,18.62,18,17.50,17.12,16.87,16.97,6.87,6.75,6.50,6.25,5.99,5.75,5.62,5.61,5.73,5.98,6.32,6.70,7.09,7.37,7.73,7.96,8.11,8.21,8.25,8.35,8.37,8.57,8.73,8.87,9.12,9.25,9.37,9.50,9.37,9.22,8.87,8.49,8.11,7.75,7.57,7.48,7.50,7.58,7.58,7.33,6.72,5.62,4.24,2.62,0.87,-0.50,-1.63,-2.50,-2.75,-2.90,-3,-3.03,-3.08,-3.18,-3.35,-3.59,-3.80,-4.03,-4.27,-4.51,-4.75,-4.97,-5.15,-5.30,-5.41,-5.49,-5.48,-5.41,-5.27,-5.05,-4.78,-4.49,-4.17,-3.88,-3.55,-3.25,-2.99,-2.80,-2.65,-2.73,-2.87,-3.02,-3,-3,-3,-2.90,-2.63,-2.25,-1.68,-0.63,0.62,2.32,3.97,6,8,13,15,14,13,12,12,11,10,9,8,8,8,8,8,8,8,8.75,9.23,9.75,10.12,10.25,10.25,10.12,9.95,9.62,9.33,8.99,8.62,8.37,8.12,7.98,7.75,7.59,7.37,7.23,7.09,6.98,6.86,6.72,6.57,6.37,6.24,6.12,6,6,6,5.99,5.99,5.99,5.99,5.99,5.98,5.98,5.97,5.95,5.87,5.86,5.75,5.62,5.50,5.37,5.25,5.12,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.97,4.87,4.83,4.71,4.50,4.37,4.25,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.96,3.87,3.87,3.75,3.62,3.47,3.25,3.12,3.07,3,2.99,2.97,2.96,2.87,2.85,2.71,2.50,2.25,2,1.87,1.75,1.73,1.73,1.74,1.75,1.75,1.75,1.75,1.75,1.75,1.82,1.48,1.12,0.84,0.50,0.12,-0.38,-1.01,-1.63,-2.18,-2.64,-2.90,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.90,-2.67,-2.27,-1.65,-0.79,0.25,1.50,2.75,3.75,4.25,4.49,4.62,5.12,5.87,6.83,7.73,8.45,9.12,9.87,10.74,11.62,12.62,13.47,14.25,15.25,16.46,17.73,18.75,19.50,19.75,19.87,19.82,19.70,19.50,19.37,19.37,19.50,19.87,20.61,21.37,22.12,22.75,23.32,23.82,24.25,24.50,24.37,23.84,22.99,22.09,21.37,20.60,19.74,18.83,18.24,17.62,17.32,16.87,17,16,6.97,6.23,6.20,5.98,5.73,5.58,5.50,5.57,5.75,6.07,6.37,6.75,7.12,7.37,7.62,7.75,7.87,7.95,8,8.09,8.20,8.35,8.50,8.74,8.95,9.12,9.25,9.25,9.20,8.97,8.62,8.21,7.75,7.46,7.22,7.12,7.21,7.37,7.62,7.62,7.37,6.62,5.25,3.45,1.48,-0.25,-1.41,-2.25,-2.65,-2.84,-2.93,-2.98,-2.93,-3.10,-3.25,-3.50,-3.74,-3.99,-4.25,-4.50,-4.77,-5.02,-5.26,-5.47,-5.63,-5.74,-5.77,-5.77,-5.71,-5.51,-5.27,-5,-4.68,-4.37,-4.02,-3.71,-3.40,-3.15,-2.92,-2.88,-2.96,-3.05,-3,-3,-3,-2.92,-2.80,-2.63,-2.04,-1.13,0.20,1.45,3,5,8,12,15,14,14,13,12,11,10,9,8,8,8,8,8,8,8,8.07,9.09,9.62,10.11,10.35,10.37,10.33,10.07,9.72,9.34,9,8.62,8.37,8.20,7.99,7.75,7.60,7.37,7.23,7.09,6.98,6.86,6.72,6.50,6.37,6.24,6.12,6,6,5.99,5.99,5.99,5.99,5.99,5.99,5.98,5.98,5.96,5.87,5.87,5.82,5.71,5.58,5.37,5.25,5.12,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.97,4.87,4.83,4.71,4.50,4.37,4.25,4.12,4.07,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.97,3.96,3.87,3.84,3.72,3.50,3.37,3.23,3.11,3,2.99,2.97,2.87,2.87,2.83,2.62,2.49,2.25,2,1.82,1.70,1.62,1.62,1.62,1.62,1.62,1.62,1.62,1.50,1.45,1.33,1.12,1,0.75,0.50,0.36,-0.02,-0.64,-1.38,-2,-2.50,-2.80,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.91,-2.66,-2.28,-1.65,-0.75,0.45,1.87,3.37,4.47,4.86,4.87,5.08,5.50,6.12,7,7.87,8.75,9.62,10.57,11.62,13,14.25,15.33,16,16.75,17.61,18.36,18.87,19.12,19.25,19.25,19.24,19.12,19,18.87,18.98,19.25,19.87,20.72,21.62,22.37,23,23.50,24,24.50,24.62,24.25,23.35,22.25,21.37,20.75,20.08,19.20,18.45,17.97,17.50,17.10,16.87,16,16,6,6.12,5.87,5.71,5.50,5.37,5.37,5.59,5.82,6.12,6.48,6.82,7.10,7.25,7.45,7.50,7.60,7.62,7.72,7.82,7.95,8.11,8.33,8.57,8.75,8.97,9.07,9.08,8.96,8.70,8.34,7.87,7.49,7.12,6.87,6.87,7,7.46,8,8.45,8.50,8,6.95,4.58,1.62,-0.13,-0.91,-1.88,-2.50,-2.79,-2.92,-2.97,-2.91,-2.96,-3.18,-3.42,-3.66,-3.92,-4.22,-4.50,-4.80,-5.11,-5.38,-5.63,-5.84,-5.99,-6.10,-6.14,-6.12,-6.01,-5.77,-5.51,-5.23,-4.89,-4.54,-4.21,-3.88,-3.58,-3.27,-3.11,-3.11,-3.11,-3.01,-3,-3,-3,-2.91,-2.88,-2.41,-1.63,-0.53,0.59,1.87,4,8,11,14,15,14,14,12,11,10,9,8,8,7,7,8,8,8,8,8.99,9.75,10.12,10.50,10.71,10.59,10.24,9.75,9.36,9,8.74,8.48,8.24,8,7.82,7.61,7.37,7.24,7.10,6.98,6.86,6.72,6.50,6.37,6.23,6.12,6,6,5.99,5.99,5.99,5.98,5.98,5.98,5.98,5.97,5.96,5.87,5.86,5.75,5.62,5.49,5.34,5.21,5.11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.99,4.99,4.97,4.87,4.83,4.71,4.50,4.37,4.25,4.12,4.07,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.97,3.95,3.87,3.75,3.62,3.49,3.32,3.12,3.07,3,2.97,2.87,2.87,2.75,2.62,2.37,2.12,1.87,1.62,1.37,1.34,1.25,1.25,1.33,1.34,1.35,1.33,1.23,1,0.87,0.70,0.50,0.37,0.25,0.12,0.07,-0.13,-1.13,-1.91,-2.75,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.92,-2.68,-2.30,-1.68,-0.75,0.50,2.25,4,5.62,5.25,5.24,5.33,5.74,6.33,7.11,8,9,10.07,11.24,12.62,14.23,16,16.70,17.33,17.84,18.25,18.60,18.73,18.75,18.75,18.71,18.62,18.50,18.50,18.50,18.75,19.24,19.99,20.87,21.75,22.59,23.12,23.62,24,24.50,24.59,24.10,22.96,21.62,20.70,20,19.33,18.49,17.84,17.50,17.21,16.83,16,16,16,6,5.87,5.75,5.37,5.25,5.32,5.37,5.61,5.87,6.20,6.50,6.84,7,7.12,7.25,7.25,7.32,7.36,7.37,7.50,7.62,7.87,8.12,8.37,8.61,8.75,8.86,8.84,8.62,8.37,8,7.60,7.20,6.86,6.62,6.62,6.99,7.62,8.50,9.45,9.84,9.58,8.62,7.25,1.50,1.36,-0.05,-1.30,-2.18,-2.75,-3,-2.98,-2.96,-2.96,-3.12,-3.38,-3.62,-3.88,-4.18,-4.50,-4.85,-5.16,-5.48,-5.76,-6.01,-6.23,-6.38,-6.48,-6.50,-6.42,-6.27,-6.04,-5.76,-5.42,-5.09,-4.72,-4.37,-4.02,-3.68,-3.38,-3.37,-3.14,-3.01,-3,-3,-3,-3,-2.88,-2.63,-2,-1.13,-0.13,1.50,4,6,10,14,15,15,15,13,11,10,9,8,7,7,7,7,8,8,8,9,9.87,10.20,10.62,10.95,10.82,10.48,9.87,9.37,9.09,8.75,8.50,8.25,8.07,7.85,7.62,7.37,7.25,7.12,7,6.87,6.73,6.50,6.37,6.23,6.11,6,6,5.99,5.99,5.99,5.98,5.98,5.98,5.98,5.97,5.95,5.87,5.83,5.71,5.57,5.37,5.25,5.12,5.07,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.99,4.98,4.87,4.86,4.71,4.50,4.37,4.25,4.12,4.07,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.97,3.95,3.87,3.75,3.61,3.37,3.25,3.12,3,2.98,2.87,2.86,2.75,2.60,2.37,2.08,1.73,1.37,1.12,0.87,0.83,0.75,0.75,0.84,0.85,0.84,0.84,0.61,0.37,0.12,-0.01,-0.18,-0.38,-0.42,-0.50,-0.66,-1.13,-1.63,-2.25,-2.79,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.75,-2.38,-1.66,-0.65,0.62,2.71,4.74,5.62,5.62,5.45,5.49,5.87,6.49,7.25,8.12,9.23,10.45,11.87,13.37,15.08,16.47,17.46,17.97,18.32,18.50,18.50,18.46,18.34,18.24,18.12,18.12,18.11,18.12,18.25,18.62,19.25,20.12,21.07,21.87,22.62,23.12,23.59,23.87,24.24,24.33,23.82,22.62,21.12,20.09,19.12,18.37,17.71,17.34,17.09,16.75,16.07,16,16,16,5,5,5.12,5.21,5.12,5.25,5.47,5.62,5.87,6.12,6.45,6.62,6.83,6.87,6.97,6.99,7,7.07,7.12,7.25,7.45,7.62,7.87,8.12,8.37,8.58,8.62,8.60,8.37,8.11,7.72,7.25,6.87,6.61,6.49,6.58,7,7.97,9.12,10.37,11.11,11,10.50,9.33,7.62,6.70,2,-0.25,-1.77,-2.42,-2.88,-3,-2.99,-2.99,-3.11,-3.33,-3.58,-3.85,-4.15,-4.50,-4.87,-5.23,-5.58,-5.89,-6.18,-6.43,-6.64,-6.79,-6.87,-6.85,-6.73,-6.53,-6.27,-5.96,-5.59,-5.21,-4.83,-4.46,-4.11,-3.80,-3.49,-3.21,-3.02,-3.01,-3,-3,-3,-2.88,-2.75,-2.25,-1.52,-0.38,1.12,3,5,8,12,14,15,15,13,11,10,9,8,7,7,7,7,8,8,8,9,10,10,10.84,10.72,10.61,10.50,9.95,9.50,9.12,8.87,8.59,8.34,8.10,7.87,7.62,7.49,7.25,7.12,7,6.87,6.74,6.57,6.37,6.22,6.11,6,6,5.99,5.98,5.98,5.98,5.98,5.97,5.97,5.96,5.87,5.87,5.75,5.62,5.50,5.34,5.12,5.09,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.95,4.87,4.72,4.50,4.37,4.25,4.12,4.08,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.97,3.87,3.86,3.74,3.57,3.37,3.21,3.09,3,2.87,2.86,2.74,2.58,2.34,2,1.62,1.24,0.86,0.50,0.33,0.21,0.12,0.12,0.21,0.21,0.12,0.07,-0.13,-0.38,-0.54,-0.75,-0.92,-1.04,-1.16,-1.30,-1.50,-1.78,-2.18,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.68,-2.29,-1.63,-0.38,1.25,3.12,5.12,6.07,5.75,5.50,5.59,6.10,6.75,7.62,8.62,9.72,10.87,12.50,14.12,15.62,16.84,17.62,18.12,18.37,18.37,18.25,18.12,17.95,17.83,17.75,17.75,17.75,17.87,18.20,18.62,19.37,20.24,21.12,21.97,22.62,23.07,23.37,23.70,23.87,23.87,23.37,22.37,20.87,19.50,18.37,17.59,17,16.71,16.70,16.12,16,16,16,16,5,5,4.87,4.87,5.12,5.32,5.50,5.72,5.87,6.09,6.25,6.37,6.50,6.62,6.62,6.62,6.72,6.75,6.87,7,7.23,7.46,7.72,7.98,8.20,8.36,8.37,8.36,8.12,7.83,7.37,6.99,6.62,6.37,6.35,6.50,7.12,8.25,9.75,11.12,12.23,12.50,12.25,11.75,11.57,10.75,5.12,0.37,-1.28,-2.14,-2.75,-2.90,-2.99,-3,-3.04,-3.27,-3.50,-3.78,-4.12,-4.48,-4.87,-5.25,-5.63,-6,-6.34,-6.63,-6.88,-7.09,-7.17,-7.18,-7.11,-6.93,-6.68,-6.38,-6,-5.60,-5.18,-4.86,-4.52,-4.10,-3.67,-3.25,-3.02,-3.01,-3,-3,-3,-2.91,-2.75,-2.38,-1.63,-0.63,0.74,2.33,4.22,7,10,13,14,14,13,11,9,9,8,7,7,7,7,8,8,8,9,10,10,10,10.10,10.21,10.12,9.95,9.60,9.25,8.87,8.62,8.37,8.12,7.87,7.75,7.50,7.36,7.20,7,6.87,6.75,6.58,6.37,6.22,6.10,6,6,5.99,5.98,5.98,5.98,5.98,5.97,5.96,5.95,5.87,5.85,5.74,5.60,5.37,5.25,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.87,4.75,4.57,4.37,4.25,4.12,4.08,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.97,3.87,3.85,3.70,3.50,3.33,3.12,3,2.97,2.87,2.75,2.59,2.34,2,1.62,1.12,0.73,0.25,-0.05,-0.30,-0.50,-0.51,-0.52,-0.50,-0.51,-0.63,-0.75,-0.88,-1.13,-1.26,-1.43,-1.63,-1.75,-1.89,-2.03,-2.25,-2.43,-2.75,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.63,-2.15,-1.29,0.12,2.12,4.22,5.75,6.22,5.87,5.62,5.75,6.45,7.25,8.25,9.37,10.59,11.87,13.35,14.87,16.21,17.22,17.87,18.21,18.25,18.23,18,17.85,17.62,17.50,17.49,17.50,17.62,17.82,18.12,18.70,19.37,20.25,21.11,21.86,22.37,22.86,23.20,23.46,23.61,23.59,23.08,22,20.50,19,17.85,17,16.50,16.36,16.12,16,16,16,16,17,5,5,4,4.87,5,5.25,5.50,5.62,5.75,5.87,6,6.12,6.25,6.33,6.37,6.37,6.46,6.50,6.62,6.82,7,7.25,7.50,7.75,7.98,8.12,8.20,8.12,7.87,7.50,7.12,6.71,6.37,6.23,6.24,6.50,7.35,8.62,10.24,11.75,13.09,14.12,13.73,13.50,13.62,12.85,6.49,2.20,-0.77,-1.88,-2.51,-2.88,-3,-3,-3.04,-3.17,-3.43,-3.72,-4.03,-4.41,-4.84,-5.25,-5.66,-6.08,-6.43,-6.78,-7.09,-7.28,-7.41,-7.46,-7.40,-7.27,-7.08,-6.76,-6.34,-5.88,-5.42,-4.99,-4.60,-4.18,-3.73,-3.29,-3.03,-3.01,-3,-3,-3,-2.92,-2.76,-2.42,-1.88,-0.93,0.20,1.45,3.11,5,9,11,12,14,12,10,9,8,8,7,7,7,7,8,8,8,9,10,10,10,10,10,10,9.96,9.72,9.33,8.96,8.62,8.37,8.21,8,7.82,7.62,7.37,7.25,7.09,6.87,6.75,6.58,6.37,6.20,6.09,6,6,5.99,5.98,5.98,5.97,5.97,5.96,5.95,5.87,5.87,5.75,5.62,5.50,5.37,5.22,5.10,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.87,4.82,4.58,4.37,4.24,4.12,4.08,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.97,3.87,3.75,3.62,3.46,3.25,3.12,3,2.87,2.75,2.62,2.37,2,1.62,1.21,0.72,0.24,-0.25,-0.63,-0.89,-1.13,-1.17,-1.25,-1.25,-1.25,-1.38,-1.50,-1.63,-1.76,-1.90,-2.13,-2.25,-2.38,-2.50,-2.54,-2.67,-2.80,-2.91,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.75,-2.38,-1.88,-0.88,0.98,3.21,5.25,6.21,6.12,6,5.87,6.23,6.95,7.87,9.07,10.25,11.57,12.87,14.37,15.85,16.87,17.72,18.12,18.25,18.22,18,17.85,17.62,17.48,17.37,17.36,17.37,17.50,17.75,18.12,18.72,19.37,20.12,20.95,21.62,22.12,22.60,22.97,23.25,23.46,23.35,22.74,21.50,20,18.50,17.36,16.61,16.25,16.07,16,16,16,16,17,17,5,4,4,4,4.75,5.08,5.36,5.48,5.58,5.62,5.75,5.87,5.97,6,6.10,6.12,6.23,6.32,6.45,6.61,6.82,7,7.25,7.50,7.75,7.87,7.98,7.87,7.62,7.25,6.87,6.47,6.12,6,6.12,6.59,7.50,8.87,10.62,12.37,13.75,14.37,14.37,14.50,14.74,11.95,7.37,2.12,-0.42,-1.67,-2.38,-2.75,-2.89,-3,-3.02,-3.13,-3.29,-3.61,-3.93,-4.34,-4.75,-5.21,-5.65,-6.10,-6.50,-6.88,-7.18,-7.41,-7.54,-7.59,-7.53,-7.46,-7.25,-6.88,-6.46,-5.98,-5.50,-5.01,-4.54,-4.09,-3.63,-3.30,-3.04,-3.01,-3,-3,-3,-3,-2.88,-2.55,-2.13,-1.38,-0.41,0.62,2.08,4,7,9,12,12,12,9,8,8,7,7,7,7,7,8,8,8,9,9,9,10,10,10,10,9.97,9.87,9.12,8.96,8.75,8.50,8.25,8.10,7.87,7.72,7.50,7.25,7.12,6.96,6.75,6.59,6.37,6.12,6.08,6,5.99,5.99,5.98,5.98,5.97,5.96,5.95,5.87,5.87,5.82,5.72,5.60,5.45,5.25,5.12,5.08,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.87,4.82,4.61,4.37,4.22,4.11,4.07,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.96,3.87,3.75,3.58,3.37,3.21,3.09,2.98,2.87,2.71,2.47,2.12,1.75,1.25,0.75,0.25,-0.25,-0.67,-1.13,-1.39,-1.63,-1.75,-1.80,-1.88,-1.88,-2,-2.13,-2.25,-2.38,-2.40,-2.53,-2.66,-2.75,-2.78,-2.88,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.88,-2.66,-2.40,-1.88,-1.25,-0.13,2,4.45,5.87,6.33,6.35,6.11,6.25,6.71,7.47,8.50,9.74,11,12.25,13.62,15.12,16.73,17.75,18.23,18.34,18.25,18.12,17.87,17.70,17.50,17.37,17.34,17.33,17.37,17.50,17.75,18.20,18.73,19.37,20.07,20.74,21.35,21.87,22.37,22.82,23.20,23.45,23.25,22.50,21.10,19.37,17.96,16.87,16.37,16.12,16,16,16,16,17,17,18,4,4,4,4,4,4.71,5,5.21,5.32,5.37,5.49,5.59,5.62,5.75,5.86,5.95,6,6.12,6.25,6.37,6.61,6.83,7.07,7.25,7.50,7.70,7.75,7.62,7.45,7.07,6.62,6.24,5.97,5.87,6,6.62,7.62,9.20,10.97,12.75,14.12,14.33,14.10,13.71,13.84,11,6,1.74,-0.38,-1.50,-2.13,-2.55,-2.78,-2.91,-3,-3.09,-3.18,-3.43,-3.77,-4.18,-4.64,-5.12,-5.60,-6.04,-6.49,-6.88,-7.21,-7.41,-7.53,-7.58,-7.52,-7.40,-7.23,-6.87,-6.42,-5.97,-5.47,-4.98,-4.48,-3.98,-3.48,-3,-3.11,-3.02,-3.01,-3,-3,-3,-3,-2.79,-2.42,-1.88,-1,-0.15,1.32,3.25,6,11,12,13,11,9,8,8,7,7,7,7,7,8,8,8,8,8,9,9,10,10,10,9.98,9.97,9,8.97,8.83,8.62,8.45,8.23,8,7.82,7.59,7.35,7.12,6.98,6.75,6.60,6.37,6.12,6.07,6,5.99,5.99,5.98,5.98,5.97,5.95,5.87,5.87,5.83,5.74,5.62,5.50,5.36,5.23,5.12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.87,4.75,4.61,4.37,4.21,4.09,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.95,3.86,3.70,3.49,3.25,3.12,3,2.95,2.82,2.61,2.25,1.87,1.37,0.95,0.37,-0.13,-0.63,-1.03,-1.50,-1.78,-2.02,-2.18,-2.27,-2.38,-2.38,-2.42,-2.52,-2.63,-2.68,-2.75,-2.78,-2.88,-2.92,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.75,-2.42,-2,-1.29,-0.50,1,3.12,5.12,6.37,6.74,6.75,6.62,6.62,7.12,7.87,8.98,10.22,11.37,12.60,13.85,15.25,16.71,17.75,18.36,18.25,18.12,17.87,17.73,17.59,17.49,17.37,17.37,17.37,17.37,17.57,17.83,18.23,18.74,19.35,19.98,20.60,21.12,21.72,22.25,22.75,23.24,23.50,23.25,22.23,20.61,18.85,17.45,16.57,16.12,16.07,16,16,16,16,17,18,19,3,3,3,3,4,4.12,4.62,4.95,5,5.12,5.22,5.32,5.37,5.50,5.62,5.75,5.85,5.96,6.08,6.23,6.37,6.61,6.84,7.08,7.25,7.47,7.50,7.47,7.22,6.84,6.37,6,5.75,5.62,5.87,6.61,7.75,9.34,11.12,13.12,13.58,13.62,13.59,12.20,10.95,9,5.10,1.24,-0.68,-1.16,-1.88,-2.38,-2.68,-2.88,-3,-3,-3.12,-3.25,-3.58,-4.02,-4.50,-4.99,-5.47,-5.92,-6.38,-6.75,-7.08,-7.28,-7.39,-7.42,-7.38,-7.25,-7.08,-6.73,-6.33,-5.87,-5.38,-4.89,-4.39,-3.88,-3.30,-2.75,-2.91,-3.10,-3.03,-3.01,-3,-3,-3,-2.88,-2.63,-2.17,-1.63,-0.75,0.58,2,4.87,8,12,12,10,9,8,8,8,8,8,8,8,8,8,8,8,8,8,9,10,10,10,10,9,9,9,8.96,8.84,8.62,8.37,8.12,7.87,7.62,7.37,7.12,7,6.82,6.60,6.37,6.12,6.07,6,5.99,5.99,5.98,5.97,5.96,5.87,5.87,5.83,5.74,5.62,5.50,5.37,5.25,5.12,5.08,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4.98,4.87,4.75,4.61,4.37,4.12,4.09,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.98,3.87,3.83,3.62,3.37,3.23,3.09,3,2.87,2.75,2.50,2.12,1.62,1.12,0.62,0.11,-0.38,-0.88,-1.30,-1.75,-2.03,-2.29,-2.50,-2.63,-2.64,-2.68,-2.75,-2.79,-2.88,-2.89,-2.91,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.90,-2.75,-2.50,-2.13,-1.50,-0.52,0.37,2.12,4.37,5.84,6.87,7.37,7.37,7.24,7.11,7.46,8.12,9.12,10.25,11.34,12.37,13.50,14.75,15.96,16.95,17.62,17.86,17.75,17.62,17.50,17.50,17.50,17.48,17.47,17.46,17.49,17.61,17.86,18.25,18.75,19.36,19.98,20.58,21.12,21.72,22.25,22.83,23.25,23.46,22.99,21.75,20.07,18.35,16.98,16.33,16.09,16,16,16,16.08,17,18,20,22,1,1,1.12,2.75,3.11,3.87,4.61,4.70,4.82,4.87,4.96,5,5.12,5.25,5.37,5.50,5.62,5.75,5.87,6,6.12,6.37,6.60,6.84,7,7.23,7.25,7.24,6.99,6.60,6.12,5.75,5.50,5.50,5.83,6.58,7.75,9.25,11.12,12.25,12.74,12.50,11.70,10.12,9,7,4.87,1.21,0.72,-0.63,-1.42,-2.03,-2.50,-2.75,-2.89,-2.96,-3,-3.15,-3.38,-3.85,-4.34,-4.80,-5.28,-5.75,-6.16,-6.53,-6.84,-7.04,-7.16,-7.21,-7.16,-7.03,-6.86,-6.53,-6.16,-5.75,-5.30,-4.85,-4.37,-3.86,-3.26,-2.76,-2.86,-3.17,-3.11,-3.03,-3.01,-3,-3,-2.92,-2.76,-2.50,-2.13,-1.27,-0.25,1,1.75,8,11,12,10,8,8,8,8,9,9,9,9,9,8,8,8,8,8,9,9,10,10,9,9,9,9.07,9.25,9.10,8.86,8.62,8.37,8.10,7.75,7.50,7.24,7,6.83,6.61,6.37,6.20,6.08,6,6,5.99,5.98,5.97,5.95,5.87,5.84,5.75,5.62,5.50,5.37,5.25,5.12,5.10,5,5,5,5,5,4.99,4.99,4.99,4.99,4.99,4.99,4.99,4.99,5,5,5,5,4.98,4.87,4.75,4.61,4.37,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.98,3.87,3.75,3.62,3.37,3.12,3.07,2.99,2.87,2.75,2.37,1.98,1.37,0.86,0.33,-0.16,-0.63,-1.13,-1.50,-1.88,-2.17,-2.50,-2.63,-2.76,-2.88,-2.88,-2.90,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.64,-2.25,-1.64,-0.88,0.37,1.71,2.34,5.12,6.62,7.46,8.12,8.37,7.75,7.50,7.71,8.25,9.12,10,10.87,11.84,12.87,14,15.11,16,16.72,17.12,17.25,17.32,17.37,17.48,17.50,17.59,17.59,17.50,17.50,17.62,17.87,18.25,18.75,19.37,20,20.62,21.25,21.86,22.46,22.98,23.34,23.24,22.50,21.12,19.46,17.87,16.70,16.12,16,16,16.08,16.12,16.12,17,19,22,24,-1,-0.88,0.75,1.25,2.62,3.32,4,4.50,4.46,4.59,4.62,4.75,4.85,4.98,5.12,5.25,5.37,5.50,5.62,5.75,5.87,6.11,6.33,6.50,6.75,6.96,7,6.98,6.71,6.33,5.87,5.50,5.35,5.37,5.73,6.46,7.50,8.99,10.37,11.49,11.75,11.25,10.12,9,8,7,5,3.85,1.23,0,-0.88,-1.63,-2.15,-2.50,-2.75,-2.88,-2.96,-3.05,-3.25,-3.68,-4.14,-4.62,-5.09,-5.51,-5.90,-6.25,-6.54,-6.76,-6.89,-6.96,-6.92,-6.83,-6.63,-6.35,-6.01,-5.65,-5.26,-4.86,-4.40,-3.91,-3.35,-2.77,-3,-3.26,-3.25,-3.12,-3.03,-3.01,-3,-3,-2.93,-2.75,-2.38,-1.75,-0.88,0.11,2.49,5.97,10,11,9,8,8,8,8,9,10,10,9,9,8,8,8,8,8,8,9,9,9,9,9,9,9.96,9.75,9.37,9.11,8.85,8.58,8.25,7.95,7.61,7.32,7.07,6.85,6.62,6.37,6.21,6.08,6,6,5.99,5.98,5.96,5.87,5.86,5.75,5.62,5.50,5.37,5.25,5.12,5.11,5,5,5,5,4.99,4.99,4.99,4.99,4.99,4.99,4.99,4.99,4.99,4.99,5,5,5,4.98,4.87,4.75,4.61,4.37,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.98,3.87,3.75,3.61,3.37,3.12,3,2.99,2.87,2.73,2.37,1.87,1.25,0.62,0.11,-0.38,-0.79,-1.18,-1.55,-1.90,-2.25,-2.50,-2.75,-2.88,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.54,-2,-1.25,-0.25,1.45,3.12,5.34,6.25,7.37,7.97,8.46,8.37,8.08,7.82,7.87,8.37,9,9.74,10.48,11.25,12.25,13.32,14.35,15.25,15.87,16.37,16.73,16.98,17.25,17.49,17.62,17.75,17.75,17.70,17.62,17.62,17.87,18.25,18.84,19.49,20.12,20.84,21.48,22.11,22.70,23.12,23.25,22.87,21.75,20.37,18.83,17.35,16.46,16.12,16.12,16.23,16.33,16.50,17.12,18.08,20,23,25,-2,-1.13,-0.75,0.62,1.37,2.25,3,3.62,3.98,4.09,4.23,4.36,4.48,4.62,4.75,4.87,5.08,5.21,5.34,5.47,5.62,5.75,6,6.24,6.46,6.62,6.75,6.62,6.37,6.07,5.62,5.36,5.20,5.24,5.57,6.12,7.12,8.25,9.46,10.50,10.62,10.75,9,9,8,7,6,4.95,1.12,0.87,-0.38,-1.14,-1.88,-2.28,-2.63,-2.75,-2.86,-3,-3.22,-3.50,-3.99,-4.42,-4.88,-5.28,-5.66,-6,-6.28,-6.50,-6.65,-6.74,-6.73,-6.63,-6.47,-6.23,-5.92,-5.63,-5.29,-4.96,-4.55,-4.13,-3.58,-3,-3.38,-3.53,-3.50,-3.25,-3.10,-3.02,-3,-3,-3,-2.90,-2.66,-2.17,-1.42,-0.25,1.62,4.45,7,9,9,8,8,8,9,11,11,10,9,9,8,8,7,7,8,8,8,9,9,9,9,9,9.96,9.82,9.62,9.36,9.08,8.75,8.46,8.09,7.73,7.37,7.12,6.87,6.62,6.37,6.21,6.09,6,6,5.99,5.98,5.96,5.87,5.83,5.72,5.59,5.45,5.32,5.20,5.12,5,5,5,5,4.99,4.99,4.99,4.99,4.99,4.98,4.98,4.98,4.98,4.98,4.98,4.99,4.99,4.97,4.87,4.82,4.62,4.37,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.98,3.87,3.75,3.61,3.37,3.12,3,2.99,2.87,2.73,2.37,1.82,1.12,0.50,-0.02,-0.50,-0.88,-1.25,-1.54,-1.88,-2.14,-2.50,-2.75,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.92,-2.75,-2.38,-1.76,-0.75,0.50,2.75,4.73,6.25,7.37,8,8.37,8.37,8.34,8.12,8,8.12,8.50,9,9.62,10.25,11,11.87,12.87,13.86,14.74,15.37,15.87,16.36,16.75,17.21,17.60,17.84,17.97,17.96,17.86,17.74,17.71,17.87,18.25,18.85,19.57,20.32,21,21.72,22.34,22.87,23.22,23.50,22.37,21,19.60,18.11,16.95,16.35,16.20,16.25,16.58,16.87,17.37,18.07,19.12,21,23,25,-2,-1.89,-1.25,-0.63,0.32,1.09,1.75,2.46,3.08,3.37,3.50,3.70,3.87,4.11,4.32,4.50,4.62,4.84,4.97,5.10,5.24,5.37,5.62,5.86,6.11,6.32,6.37,6.36,6.12,5.75,5.46,5.12,5,5.07,5.25,5.75,6.50,7.37,8.12,8.83,9.12,9,9,8,7,7,7,5,5,1.87,0.87,-0.50,-1.28,-1.88,-2.18,-2.50,-2.68,-2.89,-3.13,-3.43,-3.79,-4.27,-4.72,-5.12,-5.48,-5.80,-6.10,-6.34,-6.50,-6.60,-6.61,-6.53,-6.40,-6.22,-5.98,-5.68,-5.42,-5.14,-4.84,-4.48,-4.02,-3.50,-3.80,-4.02,-3.88,-3.49,-3.21,-3.05,-3,-3,-3,-2.93,-2.75,-2.38,-1.75,-0.63,0.96,1.87,6,9,9,9,9,9,9,11,11,10,9,8,8,7,7,7,7,8,8,9,9,9,9,9,9.96,9.87,9.75,9.57,9.25,8.96,8.59,8.21,7.83,7.48,7.12,6.87,6.62,6.37,6.21,6.09,6,6,5.99,5.98,5.95,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.08,5,5,4.99,4.99,4.98,4.98,4.98,4.98,4.98,4.98,4.97,4.97,4.98,4.97,4.97,4.98,4.96,4.87,4.75,4.62,4.37,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.98,3.87,3.75,3.61,3.37,3.12,3,2.99,2.87,2.73,2.37,1.82,1.12,0.50,-0.03,-0.50,-0.88,-1.17,-1.50,-1.75,-2,-2.27,-2.63,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.63,-2.14,-1.38,-0.28,1.37,3.86,7.37,6.96,7.73,8.57,8.36,8.35,8.25,8.20,8.12,8.35,8.71,9.12,9.72,10.25,10.99,11.75,12.70,13.62,14.46,15.10,15.62,16.12,16.62,17.24,17.75,18.12,18.25,18.24,18,17.84,17.75,17.85,18.22,18.84,19.61,20.37,21.23,21.87,22.50,22.87,23.08,22.74,21.73,20.23,18.74,17.46,16.61,16.25,16.25,16.60,17.12,17.74,18.35,19,20,21,24,27,-3,-2.76,-2.13,-1.39,-0.88,-0.25,0.46,1.12,1.75,2.20,2.50,2.84,3.07,3.36,3.62,3.87,4.12,4.37,4.50,4.62,4.82,4.99,5.21,5.46,5.72,5.87,6,6,5.83,5.50,5.25,5,4.84,4.75,4.87,5.25,5.75,6.36,6.87,7.22,7.95,8,8,7,7,6,6,6,7,5.37,2.72,0.87,-0.38,-1.13,-1.63,-2.13,-2.50,-2.74,-3.01,-3.33,-3.71,-4.13,-4.60,-5,-5.37,-5.72,-6,-6.25,-6.42,-6.54,-6.60,-6.54,-6.43,-6.29,-6.13,-5.89,-5.65,-5.46,-5.22,-4.96,-4.61,-4.22,-4.50,-4.73,-4.36,-3.80,-3.37,-3.10,-3,-3,-3,-3,-2.80,-2.50,-1.88,-0.92,0.37,2.23,4.97,8,9,8,8,8,9,11,11,11,9,8,7,7,7,7,7,7,8,8,9,9,9,9,9.97,9.87,9.87,9.72,9.45,9.09,8.62,8.25,7.87,7.50,7.22,6.87,6.62,6.37,6.21,6.09,6,6,5.99,5.98,5.95,5.87,5.75,5.61,5.46,5.33,5.21,5.11,5,5,4.99,4.98,4.98,4.98,4.98,4.97,4.97,4.97,4.96,4.96,4.96,4.95,4.87,4.87,4.87,4.87,4.75,4.62,4.37,4.22,4.07,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.98,3.87,3.75,3.61,3.37,3.12,3,2.99,2.87,2.74,2.37,1.87,1.24,0.61,0.07,-0.39,-0.75,-1.05,-1.30,-1.54,-1.79,-2.13,-2.38,-2.75,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.80,-2.50,-1.89,-1.03,0.21,2.12,5.12,6.25,7.12,7.70,8,8.22,8.24,8.24,8.25,8.37,8.62,8.98,9.37,9.95,10.50,11.12,11.85,12.62,13.50,14.25,14.85,15.37,15.95,16.60,17.25,17.86,18.25,18.50,18.48,18.24,17.87,17.71,17.73,18.07,18.74,19.62,20.57,21.46,22.20,22.71,22.87,22.60,21.75,20.62,19.24,17.97,16.97,16.37,16.24,16.37,16.87,17.62,18.62,19.25,19.73,20.34,21.87,24,27,-3,-2.88,-2.75,-2.63,-1.89,-1.38,-0.76,-0.25,0.36,0.83,1.25,1.62,2.07,2.45,2.75,3.12,3.48,3.75,3.97,4.12,4.32,4.50,4.74,5,5.25,5.48,5.61,5.62,5.50,5.25,5.08,4.83,4.62,4.50,4.50,4.73,5,5.25,5.87,6,7,7,7,7,6,6,6,7,8,7.87,5,2.71,0.95,-0.13,-0.89,-1.55,-2.13,-2.53,-2.87,-3.21,-3.61,-4.04,-4.51,-4.92,-5.36,-5.71,-6.01,-6.33,-6.54,-6.68,-6.75,-6.74,-6.66,-6.55,-6.40,-6.24,-6,-5.87,-5.72,-5.53,-5.34,-5.11,-5.38,-5.55,-4.91,-4.25,-3.61,-3.10,-3,-3,-3,-3,-2.88,-2.63,-2.05,-1.25,-0.02,1.50,3.61,6,8,8,6,7,9,10,10,10,9,8,7,7,6,6,6,7,8,8,8,8,9,9,9,9.87,9.87,9.86,9.50,9.12,8.74,8.33,7.87,7.59,7.25,6.95,6.62,6.37,6.21,6.09,6,6,5.99,5.98,5.95,5.85,5.74,5.59,5.37,5.25,5.12,5.08,5,5,4.99,4.98,4.98,4.97,4.97,4.97,4.96,4.96,4.96,4.95,4.87,4.87,4.87,4.87,4.75,4.74,4.59,4.37,4.24,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.99,3.99,3.99,3.98,3.87,3.75,3.60,3.37,3.12,3,2.99,2.87,2.75,2.37,1.95,1.37,0.75,0.25,-0.25,-0.63,-0.90,-1.17,-1.42,-1.75,-2.03,-2.38,-2.75,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.92,-2.75,-2.38,-1.67,-0.63,0.75,1.87,5.36,6.37,7,7.49,7.75,8,8.12,8.25,8.37,8.62,8.87,9.25,9.75,10.25,10.75,11.37,12,12.71,13.37,14,14.58,15.12,15.75,16.49,17.24,17.87,18.36,18.59,18.50,18.32,18,17.75,17.75,18.07,18.70,19.50,20.50,21.37,22.12,22.57,22.49,21.87,20.85,19.57,18.36,17.33,16.62,16.25,16.25,16.50,17.21,18.09,19.12,20.21,20,20.37,21.12,24,26,-3,-3,-3,-2.88,-2.55,-2.25,-1.88,-1.38,-1,-0.55,-0.13,0.37,0.83,1.25,1.73,2.23,2.70,3.09,3.36,3.60,3.75,4,4.25,4.50,4.75,5,5.20,5.25,5.22,5.08,4.86,4.61,4.37,4.22,4.20,4.25,4.25,4.87,5,6,6,6,6,6,6,6,7,8,10,9,7.87,4.22,2,0.75,-0.15,-1,-1.77,-2.29,-2.71,-3.05,-3.43,-3.99,-4.50,-4.98,-5.42,-5.84,-6.22,-6.53,-6.78,-6.96,-7.02,-7.02,-6.99,-6.89,-6.78,-6.65,-6.48,-6.37,-6.28,-6.18,-6.13,-6.08,-6.37,-6.21,-5.47,-4.68,-3.90,-3.13,-3,-3,-3,-3,-2.92,-2.75,-2.28,-1.55,-0.52,0.75,1.87,5,6,6,8,8,9,9,10,9,9,8,7,6,6,6,6,7,8,8,8,8,9,9,9,9.96,9.97,9.87,9.61,9.22,8.75,8.35,7.97,7.62,7.25,6.98,6.62,6.45,6.25,6.12,6,6,5.98,5.95,5.87,5.82,5.70,5.50,5.37,5.25,5.12,5.07,5,4.99,4.98,4.98,4.97,4.97,4.97,4.96,4.96,4.95,4.95,4.87,4.87,4.87,4.84,4.75,4.62,4.57,4.37,4.25,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.99,3.99,3.99,3.98,3.87,3.75,3.60,3.37,3.12,3,2.99,2.87,2.75,2.47,2,1.50,1,0.50,0.07,-0.38,-0.75,-1.13,-1.40,-1.75,-2.14,-2.64,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.89,-2.67,-2.18,-1.43,-0.38,1.33,3.62,6.20,6.62,7,7.37,7.62,7.87,8.12,8.33,8.58,8.87,9.23,9.62,10.08,10.57,11.09,11.62,12.24,12.82,13.35,13.85,14.35,14.87,15.58,16.35,17.12,17.83,18.32,18.50,18.50,18.25,18,17.84,17.83,18.09,18.62,19.45,20.25,21.12,21.75,22.10,21.99,21.08,19.87,18.62,17.62,16.97,16.50,16.37,16.45,16.75,17.37,18.25,19.25,19.85,20,20.25,20.87,22,22,-3,-3,-3,-3,-2.89,-2.77,-2.52,-2.25,-2,-1.75,-1.38,-0.88,-0.50,-0.02,0.50,1.11,1.62,2.12,2.60,2.96,3.25,3.48,3.74,3.97,4.25,4.48,4.72,4.85,4.87,4.75,4.61,4.36,4.12,4,4,4,4,4,5,5,5,5,5,6,6,6,7,9,10,10,8,5,2.99,1.62,0.62,-0.38,-1.40,-2.11,-2.58,-2.96,-3.35,-3.93,-4.52,-5.09,-5.61,-6.09,-6.50,-6.87,-7.13,-7.29,-7.38,-7.40,-7.38,-7.30,-7.23,-7.13,-7.04,-6.98,-6.91,-6.93,-6.99,-7.05,-7.33,-6.66,-5.89,-5.05,-4.22,-3.46,-3.03,-3,-3,-3,-3,-2.79,-2.50,-1.88,-1.01,0,1.33,3,6,8,10,9,9,9,9,9,9,9,7,6,6,6,6,7,7,8,8,8,9,9,9,9.97,9.97,9.87,9.62,9.25,8.75,8.37,7.99,7.62,7.25,7,6.71,6.47,6.25,6.12,6,6,5.97,5.87,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,5,4.99,4.98,4.97,4.97,4.96,4.96,4.96,4.95,4.87,4.87,4.87,4.86,4.82,4.74,4.62,4.50,4.37,4.25,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.98,3.98,3.97,3.87,3.75,3.60,3.37,3.12,3,2.99,2.87,2.75,2.50,2.12,1.72,1.25,0.82,0.35,-0.13,-0.63,-1.03,-1.50,-1.88,-2.38,-2.65,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.80,-2.51,-2,-1.25,-0.15,1.70,4.21,7.07,6.87,7.12,7.37,7.62,7.87,8.12,8.37,8.74,9.11,9.50,9.87,10.37,10.86,11.37,11.97,12.50,13,13.37,13.75,14.20,14.74,15.37,16.21,17,17.72,18.20,18.37,18.37,18.24,18,17.87,17.87,18.12,18.62,19.25,19.99,20.62,21.12,21.25,20.99,20.20,19.12,18.08,17.32,16.87,16.62,16.62,16.82,17.12,17.62,18.36,19,19.50,19.73,19.87,20,20,19,-3,-3,-3,-3,-3,-3,-2.90,-2.76,-2.64,-2.50,-2.25,-1.91,-1.75,-1.27,-0.75,0,0.62,1.12,1.62,2.12,2.50,2.82,3,3.23,3.46,3.70,4,4.45,4.50,4.60,4.25,4.12,3.87,3.85,3.95,4,4,4,4,5,5,5,5,5,6,7,8,9,9,8,7,5,3.75,2.23,0.96,-0.25,-1.25,-2,-2.50,-2.88,-3.26,-3.90,-4.59,-5.24,-5.85,-6.39,-6.88,-7.26,-7.55,-7.75,-7.86,-7.88,-7.85,-7.77,-7.72,-7.65,-7.62,-7.62,-7.63,-7.66,-7.73,-8,-7.58,-6.87,-6.09,-5.25,-4.43,-3.74,-3.27,-3.05,-3,-3,-3,-2.88,-2.64,-2.25,-1.52,-0.75,0.45,1.11,6,9,10,11,11,9,8,9,9,9,7,6,6,6,6,7,7,7,8,8,9,9,9,9.99,9.98,9.87,9.62,9.25,8.75,8.37,8,7.62,7.33,7,6.74,6.50,6.25,6.12,6.07,6,5.97,5.87,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.07,5,4.99,4.98,4.97,4.96,4.96,4.96,4.95,4.87,4.87,4.87,4.85,4.75,4.73,4.62,4.50,4.37,4.25,4.12,4.08,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.99,3.98,3.98,3.98,3.98,3.96,3.87,3.75,3.59,3.36,3.12,3,2.99,2.87,2.75,2.50,2.23,1.87,1.50,1.10,0.62,0.10,-0.50,-1.02,-1.54,-2.01,-2.40,-2.75,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.89,-2.75,-2.25,-1.75,-1,0,1.83,4.33,6.25,6.97,7.25,7.57,7.75,8,8.25,8.50,8.87,9.32,9.74,10.12,10.61,11.09,11.62,12.25,12.75,13.24,13.50,13.82,14.12,14.62,15.33,16.10,16.87,17.60,18.08,18.25,18.32,18.21,18.07,17.99,18,18.25,18.62,19.12,19.62,20,20.25,20.25,19.95,19.25,18.47,17.75,17.25,17.09,17,17.12,17.36,17.62,17.98,18.37,18.87,19.22,19.34,19.35,19.62,18,17,-3,-3,-3,-3,-3,-3,-3,-3,-2.91,-2.90,-2.79,-2.63,-2.42,-2.17,-1.75,-1.01,-0.40,0.12,0.62,1.11,1.50,1.86,2.08,2.23,2.37,2.57,2.85,3.12,3.45,3.62,3.85,3.87,3.97,3,3,3,3,4,4,4,4,4,4,5,5,7,8,10,9,8,6,5,3.84,2.73,1.11,-0.65,-1.25,-2.03,-2.50,-2.86,-3.24,-3.88,-4.65,-5.42,-6.13,-6.77,-7.29,-7.75,-8.08,-8.28,-8.39,-8.40,-8.36,-8.28,-8.23,-8.17,-8.16,-8.21,-8.28,-8.33,-8.29,-8.38,-7.68,-6.91,-6.12,-5.30,-4.54,-3.90,-3.42,-3.13,-3.01,-3,-3,-3,-2.89,-2.63,-2.05,-1.17,-0.13,1.20,5.87,8,10,11,10,9,8,8,9,9,7,6,6,5,6,7,7,7,8,8,9,9,9,10,9.98,9.87,9.62,9.25,8.82,8.37,8,7.62,7.36,7,6.75,6.50,6.34,6.12,6.09,6,5.98,5.87,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.07,5,4.99,4.98,4.97,4.96,4.96,4.95,4.87,4.87,4.87,4.85,4.75,4.72,4.62,4.50,4.37,4.25,4.12,4.09,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.98,3.98,3.98,3.97,3.97,3.87,3.87,3.75,3.58,3.37,3.12,3.07,2.99,2.87,2.75,2.50,2.25,2,1.70,1.34,0.87,0.25,-0.38,-1.02,-1.63,-2.13,-2.50,-2.75,-2.91,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.91,-2.75,-2.39,-1.93,-1.29,-0.52,0.35,1.97,4.87,6.25,7,7.50,7.87,8.12,8.25,8.47,8.75,9.10,9.50,9.87,10.32,10.74,11.23,11.75,12.37,13,13.37,13.62,13.87,14.12,14.62,15.25,16,16.83,17.50,18,18.25,18.25,18.24,18.12,18.12,18.24,18.37,18.62,18.99,19.25,19.45,19.49,19.36,19,18.50,18,17.62,17.48,17.50,17.62,17.86,18.07,18.23,18.37,18.57,18.75,18.87,18.87,18.75,18.37,17.86,16.87,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.91,-2.89,-2.77,-2.42,-1.88,-1.39,-1,-0.54,-0.02,0.50,0.75,0.97,1,1.08,1.12,1.36,1.62,2.09,2.37,3.25,3.75,2.75,2.75,2.11,3,3,3,3,3,3,3,4,4,5,6,7,9,9,8,7,5,3.87,2.62,0.95,-0.63,-1.63,-2.22,-2.58,-2.88,-3.23,-3.80,-4.75,-5.64,-6.48,-7.18,-7.76,-8.25,-8.63,-8.86,-8.96,-8.96,-8.88,-8.78,-8.71,-8.66,-8.66,-8.73,-8.85,-8.83,-8.63,-8.39,-7.63,-6.86,-6.04,-5.27,-4.55,-3.96,-3.49,-3.18,-3.04,-3,-3,-3,-2.92,-2.75,-2.25,-1.63,-0.50,1.20,3.12,5.48,7,9,9,7,7,8,9,9,7,6,5,5,6,6,7,7,8,8,9,9,9,9.96,9.97,9.87,9.62,9.25,8.75,8.37,8,7.70,7.37,7.10,6.84,6.59,6.37,6.23,6.12,6,5.98,5.87,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.07,5,4.99,4.97,4.97,4.96,4.95,4.87,4.87,4.87,4.85,4.75,4.71,4.61,4.50,4.37,4.25,4.12,4.09,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.98,3.98,3.97,3.96,3.87,3.86,3.73,3.57,3.37,3.20,3.08,2.98,2.87,2.75,2.50,2.32,2.08,1.83,1.50,1,0.45,-0.27,-1,-1.63,-2.15,-2.53,-2.78,-2.92,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.63,-2.14,-1.54,-0.79,0.07,1.12,2.07,4.95,6.50,7.25,7.96,8.50,8.74,8.75,8.83,9,9.32,9.62,10,10.37,10.75,11.25,11.82,12.45,13,13.46,13.62,13.87,14.12,14.62,15.25,16,16.75,17.48,17.98,18.25,18.37,18.37,18.35,18.37,18.46,18.59,18.74,18.87,18.96,18.96,18.86,18.62,18.25,18,17.75,17.71,17.75,18,18.37,18.70,18.87,18.87,18.84,18.73,18.62,18.50,18.37,18.12,17.84,17.62,16.75,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.79,-2.50,-2.16,-1.90,-1.63,-1.13,-0.63,-0.38,-0.38,-0.38,-0.38,-0.38,-0.25,0,0.57,0.95,1.22,1.25,1.12,1.12,1.47,1.84,2.25,2.50,2.58,2.62,2.75,2.87,2.87,3.07,3.37,3.98,4.62,5.12,5.37,5.74,5.25,5,3.83,2.25,0.70,-0.68,-1.75,-2.36,-2.73,-2.93,-3.21,-3.87,-4.83,-5.89,-6.83,-7.63,-8.24,-8.75,-9.14,-9.39,-9.50,-9.47,-9.37,-9.24,-9.13,-9.08,-9.08,-9.11,-9.25,-9.13,-9,-8.24,-7.46,-6.64,-5.87,-5.13,-4.49,-3.91,-3.48,-3.18,-3.04,-3.01,-3,-3,-3,-2.78,-2.42,-1.79,-0.92,0.25,1.62,1.97,4.82,7,6,6,6,8,9,9,7,5,5,5,5,6,7,7,8,8,9,9,9.08,9.75,9.95,9.87,9.62,9.25,8.75,8.37,8,7.72,7.37,7.12,6.87,6.62,6.45,6.25,6.12,6.07,5.99,5.87,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.07,5,4.98,4.97,4.96,4.96,4.87,4.87,4.87,4.85,4.75,4.71,4.61,4.50,4.37,4.25,4.12,4.10,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.98,3.97,3.97,3.95,3.87,3.83,3.71,3.50,3.37,3.22,3.09,2.98,2.87,2.73,2.50,2.33,2.12,1.87,1.62,1.12,0.57,-0.18,-1,-1.63,-2.17,-2.55,-2.79,-2.92,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.38,-1.88,-1.15,-0.29,0.75,2.12,3.87,5.72,6.83,7.62,8.37,9.25,9.60,9.34,9.25,9.36,9.58,9.84,10.12,10.37,10.75,11.12,11.72,12.25,12.83,13.23,13.50,13.75,14.09,14.57,15.21,15.97,16.75,17.47,18,18.34,18.49,18.50,18.58,18.62,18.62,18.75,18.82,18.82,18.75,18.61,18.37,18.08,17.87,17.74,17.73,17.86,18.12,18.62,19.12,19.59,19.75,19.62,19.33,18.87,18.50,18.22,17.95,17.62,17.32,16.87,15.59,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.80,-2.68,-2.55,-2.38,-1.93,-1.52,-1.38,-1.42,-1.50,-1.63,-1.63,-1.50,-1.14,-0.78,-0.63,-0.50,-0.63,-0.63,-0.13,0.25,0.87,1.37,1.62,1.86,1.98,2.10,2.09,1.83,1.75,1.75,1.87,2.12,2.25,2.25,2.34,2.25,2.50,3.37,1.50,0.12,-1,-1.96,-2.50,-2.83,-3.02,-3.35,-4.11,-5.04,-6.18,-7.23,-8.04,-8.66,-9.22,-9.62,-9.87,-9.93,-9.89,-9.75,-9.59,-9.42,-9.35,-9.34,-9.36,-9.39,-9.55,-8.73,-7.96,-7.14,-6.36,-5.62,-4.93,-4.35,-3.84,-3.41,-3.15,-3.04,-3.01,-3,-3,-3,-2.91,-2.68,-2.25,-1.50,-0.54,0.37,1.37,2.87,4,4.97,5,6,7,10,9,6,5,4,4,5,6,7,7,8,8,9,8.87,9.23,9.62,9.87,9.82,9.50,9.12,8.75,8.37,8,7.74,7.48,7.21,6.96,6.71,6.50,6.32,6.12,6.08,6,5.95,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5.07,5,4.98,4.96,4.95,4.87,4.87,4.87,4.85,4.75,4.71,4.61,4.50,4.37,4.25,4.12,4.10,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.97,3.96,3.87,3.87,3.82,3.70,3.50,3.37,3.22,3.09,2.97,2.85,2.71,2.50,2.34,2.12,1.95,1.62,1.25,0.62,-0.13,-0.88,-1.63,-2.15,-2.54,-2.79,-2.92,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.54,-2.13,-1.54,-0.78,0.12,1.37,2.97,4.75,6.37,7.11,7.95,8.86,9.75,10.12,9.87,9.71,9.75,9.87,10.07,10.25,10.47,10.75,11.12,11.57,12.07,12.50,12.87,13.24,13.50,13.87,14.37,15.11,15.87,16.72,17.47,18,18.37,18.62,18.74,18.75,18.86,18.87,18.95,18.87,18.75,18.62,18.37,18,17.83,17.62,17.62,17.75,18.08,18.50,19.12,19.86,20.47,20.74,20.45,19.75,19,18.37,17.87,17.50,17.12,16.83,16.36,15.37,-3.01,-3.02,-3.02,-3.02,-3.02,-3.02,-3.02,-3.01,-3.01,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.90,-2.77,-2.55,-2.38,-2.17,-2.25,-2.27,-2.38,-2.39,-2.29,-2.15,-1.88,-1.75,-1.75,-1.78,-1.65,-1.04,-0.63,-0.04,0.50,0.75,0.84,0.85,0.86,0.75,0.62,0.47,0.25,0.11,-0.13,-0.18,-0.25,0,0.12,0.71,0.75,0.36,-0.52,-1.40,-2.18,-2.64,-2.90,-3.34,-3.98,-4.73,-5.55,-6.62,-7.65,-8.43,-9.03,-9.55,-9.93,-10,-10,-10,-10,-9.78,-9.61,-9.49,-9.43,-9.39,-9.49,-9.08,-8.38,-7.62,-6.83,-6.04,-5.35,-4.72,-4.15,-3.67,-3.33,-3.13,-3.03,-3.01,-3,-3,-3,-3,-2.79,-2.50,-2,-1.25,-0.41,0.49,1.62,2.62,3.49,4,5,7,9,8,6,5,4,4,4,5,6,7,7,8,8,8.75,9.23,9.49,9.62,9.50,9.36,9,8.71,8.36,8,7.75,7.50,7.25,7,6.75,6.50,6.36,6.21,6.10,6,5.95,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,5,4.98,4.96,4.87,4.87,4.87,4.86,4.75,4.72,4.61,4.50,4.37,4.25,4.12,4.10,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.97,3.96,3.87,3.87,3.75,3.62,3.50,3.37,3.23,3.09,2.97,2.84,2.70,2.50,2.34,2.12,1.96,1.70,1.25,0.73,-0.01,-0.80,-1.52,-2.13,-2.51,-2.77,-2.91,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.68,-2.38,-1.88,-1.27,-0.50,0.50,1.86,3.37,5.12,6.50,7.32,8.12,9.20,10.12,10.37,10.12,10.08,10.12,10.25,10.35,10.47,10.60,10.82,11.11,11.47,11.86,12.24,12.60,12.87,13.25,13.70,14.25,14.98,15.82,16.62,17.48,18.11,18.50,18.75,18.87,18.99,19,19.11,19.11,19,18.85,18.59,18.25,17.96,17.73,17.62,17.62,17.87,18.32,18.87,19.62,20.37,21.12,21.37,20.96,20,19,18.21,17.50,17.09,16.75,16.45,16,15.25,-3.08,-3.08,-3.08,-3.05,-3.05,-3.04,-3.04,-3.03,-3.02,-3.01,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.79,-2.68,-2.75,-2.75,-2.78,-2.79,-2.75,-2.75,-2.50,-2.50,-2.50,-2.63,-2.63,-1.75,-1,-0.50,-0.13,-0.13,-0.25,-0.38,-0.50,-0.63,-0.63,-0.75,-1,-1.13,-1.30,-1.50,-1.50,-1.39,-1.13,-0.88,-0.75,-0.92,-1.38,-2,-2.43,-2.96,-3.38,-3.90,-4.55,-5.34,-6.18,-7.09,-7.97,-8.75,-9.30,-9.77,-10,-10,-10,-10,-10,-9.88,-9.66,-9.50,-9.41,-9.34,-9.14,-8.66,-8.05,-7.33,-6.53,-5.83,-5.13,-4.51,-4,-3.59,-3.29,-3.13,-3.04,-3.01,-3,-3,-3,-3,-2.88,-2.66,-2.38,-1.88,-1.16,-0.38,0.72,1.62,2.86,4,5,7,8,7,5,4,4,4,4,5,5,6,7,7,8.09,8.62,9.12,9.25,9.37,9.25,9.12,8.87,8.62,8.35,8,7.75,7.50,7.25,7,6.75,6.58,6.37,6.23,6.11,6,5.95,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,5,4.98,4.96,4.87,4.87,4.85,4.75,4.73,4.62,4.50,4.37,4.25,4.12,4.10,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.97,3.95,3.87,3.87,3.75,3.62,3.50,3.37,3.23,3.09,2.96,2.84,2.62,2.50,2.34,2.12,1.87,1.62,1.32,0.75,0.07,-0.75,-1.41,-2,-2.43,-2.75,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.77,-2.52,-2.16,-1.68,-1.13,-0.26,0.75,2.08,3.57,5.12,6.37,7.32,8.33,9.49,10.24,10.25,10.22,10.34,10.60,10.62,10.73,10.75,10.87,11,11.23,11.47,11.73,12,12.33,12.62,13,13.47,14.08,14.87,15.75,16.62,17.50,18.12,18.62,18.87,19,19.11,19.12,19.23,19.22,19.11,18.87,18.61,18.25,17.95,17.74,17.62,17.75,18.07,18.57,19.23,20,20.75,21.37,21.50,21,19.98,18.87,17.87,17.12,16.62,16.34,16.12,16,15.12,-3.17,-3.16,-3.16,-3.15,-3.13,-3.12,-3.10,-3.09,-3.05,-3.03,-3.02,-3.01,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.92,-3,-3,-3,-3,-2.88,-2.88,-2.88,-2.89,-2.78,-2.13,-1.13,-0.63,-0.50,-0.88,-1.17,-1.50,-1.75,-1.88,-1.65,-1.75,-1.88,-1.93,-2.13,-2.25,-2.28,-2.25,-2.04,-1.89,-1.88,-1.92,-2.30,-2.67,-3.10,-3.50,-3.99,-4.49,-5.10,-5.84,-6.68,-7.52,-8.30,-9.01,-9.50,-9.88,-10,-10,-10,-10,-10,-9.87,-9.65,-9.48,-9.30,-9.12,-8.98,-8.50,-7.80,-7.08,-6.33,-5.63,-4.97,-4.38,-3.91,-3.54,-3.29,-3.14,-3.08,-3.02,-3,-3,-3,-3,-2.93,-2.88,-2.63,-2.28,-1.88,-1,0,1.10,2.37,3.99,5,7,7,6,5,4,3,3,4,4,5,5,6,7.10,7.96,8.75,9.21,9.36,9.25,9.20,9,8.87,8.62,8.35,8,7.75,7.58,7.33,7.08,6.83,6.60,6.37,6.24,6.12,6,5.96,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,5,4.97,4.95,4.87,4.87,4.82,4.74,4.62,4.50,4.37,4.25,4.12,4.10,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.97,3.95,3.87,3.87,3.75,3.62,3.50,3.37,3.23,3.09,2.96,2.84,2.62,2.50,2.34,2.12,1.87,1.62,1.25,0.75,0.12,-0.55,-1.26,-1.88,-2.38,-2.63,-2.88,-2.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.90,-2.75,-2.40,-2.03,-1.55,-0.93,-0.13,0.87,2.12,3.50,4.87,6.09,7.12,8.20,9.25,9.86,9.95,10.09,10.48,10.97,11.12,11.12,11.21,11.32,11.37,11.46,11.50,11.62,11.87,12.12,12.45,12.82,13.25,13.95,14.75,15.75,16.74,17.58,18.25,18.70,18.87,19,19.12,19.22,19.25,19.25,19.12,18.87,18.62,18.25,17.98,17.75,17.75,17.87,18.25,18.75,19.50,20.25,20.87,21.37,21.37,20.75,19.71,18.58,17.50,16.62,16.12,15.87,15.87,16.08,16,-3.38,-3.38,-3.37,-3.35,-3.30,-3.26,-3.23,-3.16,-3.13,-3.08,-3.04,-3.01,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.25,-1,-0.43,-0.64,-1.38,-1.89,-2.25,-2.50,-2.55,-2.39,-2.39,-2.50,-2.50,-2.63,-2.67,-2.75,-2.75,-2.64,-2.63,-2.83,-3.03,-3.29,-3.46,-3.83,-4.27,-4.75,-5.23,-5.71,-6.34,-7.12,-7.91,-8.63,-9.23,-9.68,-9.97,-10,-10,-10,-10,-9.96,-9.77,-9.61,-9.40,-9.18,-8.85,-8.58,-8.33,-7.58,-6.87,-6.16,-5.48,-4.85,-4.29,-3.87,-3.52,-3.30,-3.16,-3.10,-3.04,-3.01,-3,-3,-3,-3,-3,-2.88,-2.63,-2.17,-1.50,-0.52,0.59,1.87,3.25,4.50,5.97,6,5,4,3,3,3,3,4,4,5,5.87,6.75,7.84,8.82,9.37,9.61,9.47,9.25,9,8.85,8.62,8.35,8.07,7.83,7.60,7.35,7.09,6.84,6.61,6.37,6.25,6.12,6,5.96,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,5,4.97,4.95,4.87,4.86,4.75,4.62,4.50,4.37,4.25,4.12,4.10,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.98,3.98,3.97,3.97,3.95,3.87,3.87,3.75,3.62,3.50,3.37,3.23,3.09,2.96,2.84,2.62,2.50,2.34,2.12,1.87,1.62,1.25,0.85,0.25,-0.40,-1.13,-1.67,-2.17,-2.52,-2.76,-2.90,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.64,-2.38,-1.93,-1.50,-0.88,-0.13,0.87,2,3.34,4.62,5.75,6.75,7.75,8.62,9.25,9.62,10,10.62,11.12,11.37,11.48,11.62,11.85,11.86,11.62,11.62,11.62,11.84,12,12.34,12.72,13.24,13.97,14.87,15.87,16.87,17.73,18.36,18.73,18.87,19,19.08,19.12,19.24,19.22,19.11,18.87,18.60,18.25,18,17.87,17.86,18,18.45,19,19.75,20.47,21,21.25,21.10,20.37,19.36,18.22,17.12,16.25,15.75,15.59,15.61,15.82,15.87,-3.76,-3.76,-3.75,-3.71,-3.64,-3.55,-3.48,-3.38,-3.26,-3.22,-3.12,-3.05,-3.01,-3.01,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.28,-1.25,-0.25,-0.93,-1.78,-2.38,-2.66,-2.88,-2.90,-2.79,-2.79,-2.88,-2.80,-2.88,-2.92,-3.15,-3.23,-3.24,-3.48,-3.55,-3.76,-3.92,-4.14,-4.50,-5,-5.50,-5.97,-6.38,-6.88,-7.53,-8.25,-8.93,-9.46,-9.84,-10,-10,-10,-9.93,-9.86,-9.75,-9.63,-9.55,-9.38,-8.98,-8.76,-8.38,-7.88,-7.36,-6.72,-6.04,-5.40,-4.83,-4.33,-3.91,-3.61,-3.38,-3.22,-3.12,-3.05,-3.02,-3,-3,-3,-3,-3,-2.92,-2.77,-2.42,-1.88,-1.03,0,1.21,2.37,3.37,4.33,5,4,3,3,3,3,3,3,4,4,5.12,6.36,7.75,8.87,9.58,9.85,9.62,9.34,9,8.85,8.62,8.35,8.08,7.84,7.62,7.36,7.10,6.84,6.61,6.37,6.24,6.12,6,5.96,5.87,5.75,5.62,5.50,5.37,5.25,5.12,5,5,4.97,4.95,4.87,4.84,4.75,4.62,4.49,4.34,4.21,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.98,3.98,3.97,3.97,3.95,3.87,3.87,3.75,3.62,3.50,3.37,3.22,3.09,2.96,2.84,2.62,2.50,2.34,2.12,1.87,1.62,1.33,0.87,0.37,-0.25,-0.88,-1.50,-2,-2.39,-2.68,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.88,-2.63,-2.25,-1.88,-1.39,-0.79,-0.05,0.86,1.95,3.12,4.37,5.46,6.37,7.34,8.12,8.87,9.47,10.12,10.82,11.33,11.50,11.62,11.87,12.12,12.24,11.82,11.62,11.62,11.75,12,12.34,12.75,13.37,14.12,15.12,16.22,17.12,17.87,18.46,18.73,18.84,18.87,18.87,19,19.07,19.08,18.99,18.82,18.57,18.25,18.07,17.95,17.99,18.21,18.62,19.25,19.98,20.62,21.12,21.25,20.87,20.10,19,17.87,16.84,16,15.57,15.37,15.35,15.25,13.82,-4.36,-4.36,-4.34,-4.27,-4.18,-4.08,-3.91,-3.74,-3.62,-3.40,-3.26,-3.15,-3.08,-3.03,-3.02,-3.01,-3.01,-3.01,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-1.52,-1.26,-1.50,-2.25,-2.75,-2.89,-3,-3,-3,-3.01,-3.22,-3.29,-3.62,-3.79,-3.78,-3.87,-4.14,-4.49,-4.58,-4.52,-4.41,-4.72,-5.13,-5.66,-6.24,-6.73,-7.12,-7.49,-7.97,-8.54,-9.14,-9.62,-9.90,-10,-10,-9.79,-9.63,-9.59,-9.42,-9.50,-9.50,-9.51,-9.09,-8.73,-8.29,-7.75,-7.17,-6.64,-6.03,-5.47,-4.93,-4.49,-4.10,-3.76,-3.50,-3.29,-3.16,-3.09,-3.03,-3,-3,-3,-3,-3,-3,-2.92,-2.75,-2.25,-1.50,-0.55,0.47,1.46,2.23,2.82,3.95,3,3,2,2,2,2,2,3,3.87,4.75,6.23,7.75,9,9.72,9.87,9.62,9.34,9,8.85,8.62,8.35,8.09,7.85,7.62,7.37,7.10,6.85,6.61,6.37,6.24,6.11,6,5.96,5.87,5.75,5.70,5.50,5.37,5.25,5.12,5,5,4.97,4.95,4.87,4.83,4.73,4.60,4.45,4.25,4.12,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.98,3.97,3.97,3.95,3.87,3.87,3.75,3.62,3.50,3.37,3.22,3.09,2.96,2.84,2.62,2.50,2.34,2.12,1.87,1.62,1.36,0.98,0.50,-0.05,-0.64,-1.25,-1.77,-2.25,-2.63,-2.88,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.91,-2.79,-2.52,-2.18,-1.80,-1.38,-0.77,-0.05,0.82,1.85,3,4.25,5.33,6.21,7,7.83,8.62,9.37,10.12,10.97,11.47,11.50,11.62,11.87,12.12,12,11.74,11.60,11.62,11.75,12,12.37,12.87,13.58,14.47,15.50,16.62,17.62,18.25,18.62,18.73,18.71,18.70,18.73,18.75,18.87,18.87,18.85,18.71,18.50,18.25,18.11,18,18.12,18.37,18.84,19.47,20.12,20.84,21.32,21.34,20.75,19.86,18.75,17.62,16.62,15.87,15.50,15.33,15.23,14.87,13.73,-5.13,-5.14,-5.13,-5.09,-4.98,-4.80,-4.60,-4.38,-4.09,-3.79,-3.53,-3.30,-3.15,-3.09,-3.04,-3.08,-3.05,-3.03,-3.02,-3.04,-3.04,-3.04,-3.03,-3.01,-3.01,-3.01,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2,-2,-3,-3,-3,-3,-3,-3.29,-3.58,-3.75,-4.25,-4.61,-4.77,-4.76,-4.60,-4.84,-5.14,-5.29,-5.24,-5.13,-5.23,-5.64,-6.25,-6.89,-7.43,-7.85,-8.15,-8.49,-8.88,-9.29,-9.67,-9.89,-10,-9.88,-9.52,-9.25,-9.22,-9.37,-9.43,-9.42,-9.42,-8.97,-8.54,-8.26,-7.78,-7.25,-6.66,-6.13,-5.62,-5.16,-4.75,-4.42,-4.09,-3.76,-3.50,-3.29,-3.16,-3.09,-3.02,-3,-3,-3,-3,-3,-3,-2.88,-2.51,-2,-1.17,-0.28,0.62,1.20,1.48,1.10,1,1,1,1,1,1,2,2,3.12,4.36,6.12,8,9.25,9.98,9.87,9.62,9.34,9,8.85,8.62,8.35,8.09,7.86,7.62,7.37,7.11,6.85,6.61,6.37,6.23,6.11,6,5.96,5.87,5.82,5.71,5.50,5.37,5.25,5.12,5,5,4.97,4.95,4.87,4.83,4.71,4.57,4.37,4.25,4.10,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.97,3.97,3.95,3.87,3.86,3.75,3.62,3.50,3.36,3.22,3.09,2.96,2.84,2.62,2.50,2.34,2.12,1.87,1.70,1.37,1.07,0.62,0.12,-0.40,-1,-1.53,-2.04,-2.51,-2.91,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.68,-2.43,-2.13,-1.75,-1.30,-0.75,-0.13,0.75,1.75,3,4.25,5.37,6.20,6.95,7.75,8.59,9.33,10,10.83,11.21,11.25,11.35,11.50,11.61,11.47,11.37,11.37,11.50,11.73,12.07,12.50,13.12,13.97,14.87,16,17.08,17.98,18.48,18.62,18.61,18.50,18.50,18.50,18.62,18.70,18.74,18.71,18.61,18.45,18.25,18.12,18.12,18.25,18.57,19,19.62,20.25,20.87,21.37,21.32,20.62,19.61,18.49,17.37,16.50,15.85,15.50,15.37,15.35,15.24,13.62,-6.09,-6.11,-6.13,-6.10,-5.99,-5.77,-5.50,-5.17,-4.79,-4.38,-3.96,-3.61,-3.36,-3.21,-3.22,-3.17,-3.14,-3.12,-3.11,-3.17,-3.21,-3.15,-3.11,-3.05,-3.04,-3.02,-3.01,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3.01,-3.38,-3.68,-4.02,-4.41,-4.87,-5.23,-5.39,-5.46,-5.51,-5.72,-5.63,-5.80,-5.76,-5.72,-5.74,-6.12,-6.75,-7.48,-8.11,-8.54,-8.84,-9.03,-9.26,-9.53,-9.76,-9.88,-9.83,-9.55,-9.08,-9.03,-9.23,-9.37,-9.42,-9.38,-9.09,-8.64,-8.46,-8.17,-7.75,-7.28,-6.76,-6.28,-5.88,-5.50,-5.16,-4.83,-4.48,-4.13,-3.79,-3.53,-3.34,-3.17,-3.09,-3.01,-3,-3,-3,-3,-3,-3,-2.89,-2.55,-1.89,-1,-0.16,0.25,0.23,0,-0.13,-0.13,-0.15,-0.16,-0.41,0.97,1,1.97,2.75,4.12,6.12,8.25,10.09,10.25,10,9.70,9.34,9,8.85,8.62,8.35,8.09,7.86,7.62,7.37,7.11,6.85,6.61,6.37,6.23,6.10,6,5.97,5.87,5.83,5.72,5.57,5.37,5.25,5.12,5,5,4.97,4.95,4.87,4.82,4.71,4.50,4.37,4.24,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.97,3.95,3.87,3.86,3.75,3.62,3.50,3.36,3.21,3.08,2.96,2.84,2.70,2.50,2.35,2.12,1.96,1.74,1.49,1.12,0.75,0.35,-0.16,-0.75,-1.25,-1.88,-2.38,-2.92,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.90,-2.75,-2.55,-2.38,-2.05,-1.75,-1.27,-0.75,-0.13,0.74,1.74,2.98,4.34,5.50,6.25,7.10,7.87,8.62,9.12,9.62,10.24,10.62,10.85,10.83,10.82,10.83,10.87,10.95,11.08,11.25,11.62,12.08,12.62,13.37,14.25,15.33,16.37,17.37,18.12,18.50,18.50,18.48,18.37,18.34,18.37,18.46,18.50,18.59,18.58,18.50,18.37,18.25,18.24,18.25,18.46,18.75,19.22,19.75,20.35,20.84,21.12,21,20.34,19.25,18.21,17.21,16.37,15.83,15.59,15.58,15.73,15.75,15.57,-7.12,-7.15,-7.23,-7.23,-7.13,-6.91,-6.60,-6.17,-5.71,-5.13,-4.55,-4.14,-3.80,-3.60,-3.51,-3.40,-3.35,-3.33,-3.36,-3.49,-3.51,-3.48,-3.37,-3.25,-3.21,-3.16,-3.11,-3.05,-3.03,-3.02,-3.02,-3.01,-3.01,-3.01,-3,-3,-3,-3,-3.01,-3.02,-3.34,-3.65,-4.03,-4.46,-4.91,-5.40,-5.76,-5.93,-6.04,-6.14,-6.23,-6.27,-6.18,-6.23,-6.18,-6.25,-6.59,-7.21,-7.96,-8.67,-9.18,-9.46,-9.59,-9.71,-9.84,-9.93,-9.93,-9.76,-9.49,-9.03,-9.12,-9.26,-9.40,-9.54,-9.38,-9.11,-9,-8.74,-8.46,-7.90,-7.30,-6.92,-6.53,-6.21,-5.92,-5.63,-5.28,-4.90,-4.52,-4.14,-3.83,-3.53,-3.33,-3.15,-3.08,-3,-3,-3,-3,-3,-3,-2.92,-2.77,-2.38,-1.66,-1,-0.68,-0.75,-0.89,-1.05,-1.13,-1.13,-1.13,-0.77,-0.50,1,0.87,1.32,3.87,6.32,8.60,10.11,10.50,10.12,9.73,9.34,9.07,8.86,8.62,8.35,8.09,7.86,7.62,7.37,7.11,6.85,6.61,6.37,6.22,6.10,6,5.97,5.87,5.84,5.73,5.58,5.37,5.25,5.12,5,5,4.98,4.95,4.87,4.82,4.70,4.50,4.37,4.23,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.95,3.87,3.86,3.75,3.62,3.50,3.35,3.21,3.08,2.96,2.84,2.70,2.50,2.36,2.12,1.99,1.75,1.57,1.25,0.96,0.50,0.10,-0.40,-1,-1.52,-2.13,-2.76,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.75,-2.63,-2.52,-2.42,-2.26,-2,-1.67,-1.27,-0.76,-0.13,0.62,1.62,2.87,4.25,5.46,6.32,7.12,8.12,8.87,8.87,9,9.74,10.25,10.47,10.25,10.10,10.12,10.24,10.37,10.62,11,11.47,12,12.71,13.50,14.50,15.61,16.62,17.61,18.20,18.37,18.37,18.33,18.24,18.21,18.24,18.33,18.37,18.46,18.47,18.37,18.37,18.34,18.36,18.47,18.62,19,19.37,19.87,20.33,20.62,20.74,20.48,19.75,18.85,17.87,16.98,16.25,15.85,15.74,15.83,16.10,16.37,14.50,-8.14,-8.25,-8.38,-8.43,-8.38,-8.18,-7.84,-7.36,-6.77,-6.13,-5.54,-5,-4.52,-4.22,-4,-3.88,-3.73,-3.72,-3.83,-3.98,-4.01,-3.99,-3.86,-3.67,-3.51,-3.37,-3.23,-3.13,-3.09,-3.04,-3.03,-3.02,-3.01,-3.01,-3.01,-3,-3,-3,-3.02,-3.05,-3.50,-3.90,-4.33,-4.78,-5.28,-5.83,-6.15,-6.35,-6.46,-6.58,-6.65,-6.63,-6.42,-6.52,-6.58,-6.71,-7,-7.58,-8.30,-9.09,-9.64,-9.91,-10,-10,-10,-10,-10,-9.96,-9.51,-9.14,-9.14,-9.26,-9.60,-9.59,-9.74,-9.97,-9.78,-9.47,-8.99,-8.41,-7.53,-7.22,-6.89,-6.63,-6.41,-6.13,-5.80,-5.42,-5.02,-4.61,-4.21,-3.85,-3.53,-3.29,-3.13,-3.03,-3,-3,-3,-3,-3,-3,-2.91,-2.67,-2.38,-1.93,-1.75,-1.63,-1.67,-1.88,-1.88,-1.88,-1.75,-1.50,-1.25,-0.91,-0.88,1.22,3.45,5.87,9.11,10.24,10.60,10.24,9.75,9.34,9.07,8.86,8.62,8.35,8.09,7.86,7.62,7.37,7.12,6.86,6.61,6.37,6.22,6.09,6,5.97,5.87,5.85,5.73,5.58,5.37,5.25,5.12,5,5,4.98,4.95,4.87,4.83,4.71,4.50,4.37,4.23,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.96,3.87,3.86,3.75,3.62,3.50,3.35,3.21,3.08,2.96,2.84,2.71,2.50,2.36,2.12,2,1.84,1.62,1.37,1.12,0.75,0.37,-0.13,-0.63,-1.14,-1.88,-2.38,-2.77,-2.92,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.67,-2.50,-2.27,-2.38,-2.38,-2.25,-2,-1.68,-1.29,-0.80,-0.18,0.60,1.57,2.75,4,5.21,6.20,7.12,8,8.62,8.62,8.62,9.35,10.12,10.25,9.87,9.50,9.57,9.62,9.87,10.25,10.62,11.22,11.86,12.62,13.60,14.62,15.74,16.75,17.62,18.09,18.25,18.25,18.12,18.12,18.11,18.12,18.23,18.25,18.36,18.37,18.37,18.37,18.37,18.50,18.72,19,19.35,19.73,20.08,20.34,20.37,20.25,19.87,19.21,18.37,17.50,16.75,16.21,15.96,15.87,16.12,16.49,16.12,13.46,-9.11,-9.29,-9.52,-9.67,-9.67,-9.50,-9.16,-8.64,-8,-7.29,-6.59,-5.90,-5.34,-4.91,-4.63,-4.43,-4.34,-4.30,-4.40,-4.50,-4.55,-4.60,-4.47,-4.16,-3.91,-3.67,-3.47,-3.27,-3.15,-3.11,-3.08,-3.04,-3.02,-3.02,-3.01,-3.01,-3.02,-3.02,-3.05,-3.25,-3.65,-4.10,-4.52,-5,-5.53,-6.08,-6.42,-6.63,-6.73,-6.84,-6.91,-6.89,-6.75,-6.75,-6.86,-7.01,-7.33,-7.85,-8.52,-9.25,-9.85,-10,-10,-10,-10,-10,-10,-10,-9.65,-9.30,-9.01,-9.16,-9.38,-9.75,-10,-10,-10,-9.89,-9.42,-8.60,-8.02,-7.61,-7.38,-7.15,-6.97,-6.71,-6.39,-6.02,-5.61,-5.15,-4.71,-4.25,-3.86,-3.51,-3.26,-3.11,-3,-3,-3,-3,-3,-3,-3,-3,-2.80,-2.63,-2.38,-2.26,-2.28,-2.38,-2.38,-2.38,-2.25,-2.04,-1.91,-1.63,-0.76,0.59,1.60,4.82,8.08,9.87,10.49,10.25,9.75,9.35,9.08,8.86,8.62,8.35,8.09,7.86,7.62,7.37,7.12,6.86,6.61,6.37,6.22,6.09,6,5.97,5.87,5.86,5.74,5.58,5.37,5.24,5.12,5,5,4.98,4.95,4.87,4.83,4.71,4.50,4.37,4.24,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.96,3.87,3.87,3.75,3.62,3.50,3.35,3.21,3.08,2.97,2.85,2.71,2.50,2.37,2.20,2,1.87,1.73,1.50,1.25,1,0.62,0.25,-0.17,-0.75,-1.38,-1.88,-2.39,-2.75,-2.88,-2.92,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.78,-2.63,-2.38,-2.16,-2.27,-2.27,-2.18,-2,-1.75,-1.38,-0.89,-0.29,0.46,1.37,2.50,3.75,4.87,5.97,6.87,7.83,8.37,8.37,8.48,9,9.75,9.96,9.62,9.24,9.20,9.25,9.50,9.87,10.25,10.87,11.62,12.50,13.50,14.62,15.74,16.74,17.48,17.87,18,18.08,18,18,18,18.10,18.12,18.23,18.25,18.33,18.37,18.37,18.50,18.75,19,19.37,19.75,20.11,20.36,20.45,20.32,19.97,19.37,18.71,17.95,17.21,16.62,16.25,16.12,16.24,16.50,16.57,15.85,13.37,-9.92,-10,-10,-10,-10,-10,-10,-10,-9.30,-8.52,-7.74,-6.98,-6.30,-5.78,-5.40,-5.13,-4.97,-4.88,-4.92,-4.98,-4.93,-4.92,-4.83,-4.58,-4.33,-4.09,-3.85,-3.61,-3.40,-3.27,-3.21,-3.14,-3.10,-3.04,-3.04,-3.04,-3.08,-3.09,-3.10,-3.38,-3.78,-4.22,-4.64,-5.14,-5.68,-6.23,-6.62,-6.86,-6.96,-7.01,-7.08,-7.05,-6.92,-6.88,-7.04,-7.25,-7.54,-8.01,-8.63,-9.27,-9.80,-10,-10,-10,-10,-10,-10,-9.85,-9.62,-9.24,-8.99,-8.74,-9.01,-9.64,-10,-10,-10,-9.98,-9.55,-9.03,-8.37,-8.14,-8,-7.76,-7.58,-7.34,-7.03,-6.67,-6.25,-5.78,-5.27,-4.76,-4.27,-3.84,-3.48,-3.22,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.91,-2.79,-2.68,-2.75,-2.75,-2.68,-2.65,-2.55,-2.43,-2.38,-2.02,-1.28,-0.55,0.75,1.75,6.62,9.45,10.37,10.32,9.84,9.37,9.08,8.86,8.62,8.35,8.09,7.86,7.62,7.37,7.12,6.86,6.61,6.37,6.22,6.09,6,5.97,5.87,5.86,5.74,5.58,5.37,5.24,5.12,5,5,4.98,4.96,4.87,4.83,4.71,4.50,4.37,4.24,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.96,3.87,3.87,3.75,3.62,3.50,3.35,3.21,3.09,2.97,2.86,2.72,2.50,2.37,2.21,2,1.87,1.75,1.62,1.49,1.25,0.95,0.59,0.22,-0.25,-0.67,-1.17,-1.78,-2.25,-2.52,-2.75,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.90,-2.76,-2.63,-2.39,-2.26,-2.28,-2.27,-2.25,-2.04,-1.79,-1.50,-1.03,-0.50,0.25,1.12,2.25,3.46,4.62,5.62,6.60,7.47,8.11,8.23,8.34,8.72,9.24,9.50,9.37,9,9,9,9.25,9.61,10,10.50,11.33,12.25,13.37,14.50,15.62,16.58,17.24,17.61,17.75,17.87,17.87,17.96,18,18.08,18.12,18.21,18.25,18.33,18.37,18.50,18.75,19,19.37,19.86,20.25,20.60,20.75,20.62,20.35,19.75,19.12,18.36,17.62,17,16.62,16.50,16.50,16.70,16.75,16.50,15.75,13.37,-10,-11,-11,-12,-12,-12,-12,-11,-10,-9.77,-8.93,-8.13,-7.39,-6.77,-6.29,-5.90,-5.64,-5.46,-5.40,-5.35,-5.24,-5.14,-5,-4.86,-4.65,-4.43,-4.17,-3.91,-3.65,-3.48,-3.36,-3.27,-3.22,-3.13,-3.12,-3.13,-3.16,-3.17,-3.17,-3.47,-3.88,-4.30,-4.74,-5.22,-5.76,-6.30,-6.76,-7.04,-7.14,-7.17,-7.16,-7.12,-7.01,-6.99,-7.17,-7.38,-7.66,-8.11,-8.68,-9.25,-9.73,-10,-10,-10,-10,-10,-10,-9.98,-9.49,-9.02,-8.58,-8.21,-8.50,-9.16,-9.72,-9.79,-9.90,-9.92,-9.71,-9.53,-9.30,-9.14,-8.68,-8.41,-8.21,-8,-7.74,-7.38,-6.97,-6.48,-5.92,-5.36,-4.76,-4.23,-3.76,-3.38,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.91,-2.90,-2.88,-2.88,-2.88,-2.77,-2.67,-2.63,-2.38,-1.88,-1.14,-0.38,1.83,6,9,10.37,10.37,9.87,9.37,9.08,8.86,8.62,8.35,8.09,7.86,7.62,7.37,7.12,6.85,6.61,6.37,6.21,6.09,6,5.97,5.87,5.85,5.72,5.57,5.37,5.23,5.11,5,5,4.98,4.96,4.87,4.83,4.71,4.50,4.37,4.23,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.97,3.87,3.87,3.75,3.62,3.50,3.35,3.21,3.08,2.98,2.87,2.75,2.58,2.37,2.21,2.07,1.97,1.87,1.75,1.62,1.45,1.20,0.87,0.58,0.25,-0.13,-0.43,-1.01,-1.52,-1.93,-2.26,-2.63,-2.89,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.89,-2.76,-2.63,-2.50,-2.38,-2.38,-2.38,-2.27,-2.13,-1.91,-1.63,-1.25,-0.75,-0.02,0.84,1.87,3,4.12,5.12,6.09,7,7.73,7.95,7.98,8.33,8.87,9.25,9.23,8.97,8.97,9,9.25,9.50,9.84,10.25,10.87,12,13.20,14.37,15.47,16.34,16.87,17.25,17.50,17.62,17.75,17.87,18,18.09,18.12,18.23,18.25,18.37,18.50,18.74,19,19.45,19.87,20.37,20.85,21.12,21.23,21,20.50,19.75,19,18.12,17.49,17.07,16.87,16.87,17.07,17.12,17,16.70,15.87,14.34,-11,-12,-12,-12,-13,-13,-13,-12,-11,-10,-10,-9.30,-8.53,-7.85,-7.26,-6.77,-6.39,-6.04,-5.86,-5.67,-5.48,-5.21,-5.05,-4.99,-4.90,-4.74,-4.50,-4.24,-3.96,-3.75,-3.59,-3.49,-3.39,-3.27,-3.27,-3.29,-3.35,-3.37,-3.37,-3.55,-4.01,-4.42,-4.83,-5.27,-5.83,-6.38,-6.88,-7.23,-7.37,-7.37,-7.26,-7.12,-6.99,-7.04,-7.25,-7.42,-7.59,-8.14,-8.68,-9.22,-9.67,-10,-10,-10,-10,-10,-10,-10,-9.48,-8.84,-8.24,-7.78,-7.93,-8.63,-9.22,-9.46,-9.76,-9.77,-9.90,-10,-10,-9.76,-9.36,-8.99,-8.83,-8.68,-8.48,-8.14,-7.72,-7.18,-6.62,-5.98,-5.33,-4.67,-4.11,-3.63,-3.23,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.89,-2.88,-2.77,-2.63,-2.15,-1.63,-0.55,1.50,5.08,8.86,10.37,10.49,10,9.46,9.10,8.87,8.62,8.35,8.09,7.86,7.62,7.37,7.11,6.84,6.59,6.37,6.20,6.08,6,5.96,5.87,5.83,5.70,5.50,5.36,5.21,5.10,5,5,4.98,4.96,4.87,4.83,4.71,4.50,4.37,4.23,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.98,3.97,3.87,3.87,3.82,3.62,3.50,3.36,3.20,3.08,2.99,2.87,2.75,2.58,2.37,2.21,2.08,1.99,1.87,1.86,1.75,1.61,1.37,1.12,0.87,0.62,0.37,0.22,-0.25,-0.75,-1.18,-1.63,-2.13,-2.53,-2.78,-2.93,-3,-3,-3,-3,-3,-3,-3,-2.90,-2.78,-2.63,-2.50,-2.38,-2.38,-2.38,-2.38,-2.25,-2.05,-1.80,-1.50,-1,-0.38,0.45,1.37,2.48,3.50,4.45,5.37,6.25,7,7.25,7.37,7.85,8.62,9.25,9.24,8.99,9,9.12,9.36,9.57,9.75,10.12,10.71,11.75,12.97,14.12,15.23,16,16.58,16.96,17.25,17.48,17.62,17.86,18,18.12,18.22,18.25,18.37,18.50,18.73,19,19.37,19.87,20.45,20.99,21.46,21.75,21.75,21.37,20.75,19.87,19,18.12,17.50,17.25,17.25,17.48,17.71,17.62,17.34,16.87,16.37,15.33,-11,-12,-13,-13,-13,-13,-14,-13,-12,-12,-11,-10,-9.67,-8.93,-8.28,-7.73,-7.25,-6.75,-6.41,-6.13,-5.83,-5.34,-5.03,-5.13,-5.11,-5,-4.79,-4.53,-4.29,-4.10,-3.91,-3.78,-3.67,-3.54,-3.54,-3.59,-3.63,-3.66,-3.68,-3.71,-4.23,-4.63,-5,-5.38,-5.89,-6.47,-6.99,-7.38,-7.54,-7.54,-7.38,-7.14,-6.79,-7.05,-7.27,-7.43,-7.72,-8.14,-8.64,-9.21,-9.65,-10,-10,-11,-11,-11,-10,-10,-9.71,-8.76,-7.92,-7.39,-7.28,-7.96,-8.52,-9.03,-9.34,-9.50,-10,-10,-10,-10,-9.59,-9.28,-9.39,-9.39,-9.24,-8.90,-8.46,-7.89,-7.27,-6.60,-5.87,-5.13,-4.47,-3.88,-3.37,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.92,-2.88,-2.75,-2.38,-1.88,-0.91,0.72,2,8.85,9.97,10.37,10.10,9.57,9.12,8.87,8.62,8.35,8.09,7.86,7.62,7.37,7.10,6.82,6.57,6.36,6.12,6.07,6,5.95,5.87,5.75,5.62,5.49,5.32,5.12,5.08,5,4.99,4.98,4.96,4.87,4.83,4.71,4.50,4.37,4.23,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.96,3.87,3.83,3.70,3.50,3.36,3.21,3.09,2.99,2.87,2.75,2.58,2.37,2.21,2.09,2,1.96,1.87,1.85,1.74,1.59,1.37,1.21,1,0.83,0.71,0.37,0,-0.42,-0.88,-1.38,-1.88,-2.38,-2.75,-3,-3,-3,-3,-3,-3,-3,-2.92,-2.88,-2.66,-2.50,-2.38,-2.38,-2.38,-2.42,-2.38,-2.25,-2.01,-1.75,-1.28,-0.75,0,0.86,1.75,2.72,3.62,4.58,5.49,6.21,6.50,6.74,7.24,8.12,9.75,9.12,8.96,9,9.25,9.49,9.62,9.82,10.09,10.62,11.50,12.72,13.87,14.87,15.62,16.12,16.57,16.87,17.25,17.50,17.82,18,18.12,18.25,18.37,18.50,18.74,19,19.37,19.87,20.37,21,21.60,22,22.35,22.25,21.83,21,20.08,19.12,18.25,17.74,17.50,17.74,18.12,18.37,18.10,17.62,17.23,16.87,16.25,-12,-12,-13,-13,-14,-14,-14,-14,-13,-13,-12,-11,-10,-10,-9.30,-8.72,-8.16,-7.62,-7.17,-6.77,-6.39,-5.90,-5.62,-5.43,-5.38,-5.27,-5.13,-4.88,-4.72,-4.52,-4.37,-4.22,-4.09,-3.93,-3.96,-4,-4.08,-4.12,-4.15,-4.15,-4.55,-4.90,-5.26,-5.63,-6.08,-6.60,-7.09,-7.50,-7.73,-7.72,-7.51,-7.26,-6.92,-6.93,-7.13,-7.28,-7.80,-8.17,-8.33,-9.05,-10,-10,-10,-11,-11,-11,-10,-10,-9.72,-8.83,-7.85,-7.13,-6.80,-7.38,-8.17,-8.75,-9.01,-9.39,-9.97,-10,-10,-9.93,-9.38,-9.62,-9.99,-10,-9.96,-9.61,-9.13,-8.53,-7.88,-7.14,-6.36,-5.55,-4.80,-4.13,-3.52,-3.08,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.92,-2.88,-2.52,-2.13,-1.38,-0.25,2.23,5.85,8.75,10.25,10.23,9.73,9.25,8.96,8.62,8.35,8.09,7.87,7.62,7.37,7.08,6.75,6.50,6.33,6.12,6,5.99,5.87,5.86,5.75,5.60,5.37,5.25,5.12,5.07,5,4.99,4.98,4.96,4.87,4.83,4.71,4.50,4.37,4.23,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.96,3.87,3.83,3.70,3.50,3.36,3.21,3.09,2.99,2.87,2.75,2.58,2.37,2.21,2.09,2,1.98,1.95,1.87,1.83,1.73,1.59,1.45,1.33,1.12,1.08,0.85,0.57,0.24,-0.13,-0.51,-1.01,-1.66,-2.30,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.88,-2.66,-2.50,-2.26,-2.28,-2.38,-2.50,-2.50,-2.39,-2.25,-2,-1.63,-1.13,-0.43,0.25,1.10,1.87,2.75,3.75,4.73,5.49,5.87,6.08,6.49,7.34,8.24,8.57,8.62,8.87,9.24,9.50,9.70,9.83,10,10.49,11.25,12.37,13.50,14.37,15.12,15.62,16.12,16.58,17,17.37,17.75,18,18.25,18.37,18.59,18.75,19,19.37,19.85,20.37,21,21.62,22.23,22.62,22.84,22.62,22.12,21.25,20.25,19.25,18.45,17.87,17.87,18.32,18.75,18.96,18.50,17.96,17.57,17.25,16.25,-12,-13,-13,-14,-14,-15,-15,-15,-14,-14,-13,-12,-11,-10,-10,-9.67,-9.14,-8.61,-8.11,-7.63,-7.17,-6.71,-6.30,-6.01,-5.80,-5.67,-5.52,-5.29,-5.17,-5.03,-4.88,-4.74,-4.61,-4.47,-4.50,-4.55,-4.65,-4.72,-4.76,-4.79,-5.01,-5.28,-5.63,-5.99,-6.38,-6.80,-7.25,-7.61,-7.83,-7.83,-7.67,-7.49,-7.34,-7.29,-7.28,-7.71,-8.14,-8.55,-8.96,-9.40,-10,-10,-10,-11,-11,-11,-11,-10,-9.65,-8.84,-7.98,-7.11,-6.59,-7.09,-7.93,-8.49,-8.83,-9.23,-9.71,-9.98,-9.96,-9.50,-9.46,-10,-10,-10,-10,-10,-9.66,-9.05,-8.37,-7.59,-6.75,-5.91,-5.12,-4.36,-3.71,-3.16,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.64,-2.29,-1.75,-0.75,0.72,2.12,7.72,9.61,10,9.75,9.35,9,8.62,8.35,8.08,7.86,7.62,7.37,7,6.75,6.49,6.25,6.12,6,5.97,5.87,5.83,5.70,5.50,5.37,5.22,5.11,5,5,4.99,4.98,4.96,4.87,4.83,4.71,4.50,4.37,4.23,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.96,3.87,3.83,3.70,3.50,3.36,3.21,3.09,2.99,2.87,2.75,2.58,2.37,2.21,2.09,2,1.99,1.97,1.87,1.87,1.83,1.74,1.62,1.58,1.47,1.37,1.20,1,0.82,0.62,0.25,-0.17,-0.93,-1.75,-2.55,-2.88,-3,-3,-3,-3,-3,-3,-2.88,-2.66,-2.41,-2.15,-2.16,-2.30,-2.50,-2.55,-2.54,-2.43,-2.25,-1.88,-1.38,-0.80,-0.16,0.50,1.25,2.11,3.08,4.07,4.86,5.25,5.47,5.62,6.24,7.08,7.71,8.12,8.58,9,9.37,9.62,9.75,9.95,10.25,10.87,11.87,12.87,13.87,14.50,15.09,15.62,16.20,16.75,17.25,17.73,18.11,18.37,18.62,18.83,19.07,19.37,19.83,20.37,21,21.70,22.34,22.86,23.22,23.25,23,22.34,21.37,20.37,19.46,18.57,18.24,18.37,18.83,19.25,19.33,18.75,18.25,17.97,17.62,16.25,-12,-13,-13,-14,-15,-16,-16,-15,-15,-15,-14,-13,-12,-11,-11,-10,-10,-9.62,-9.09,-8.58,-8.09,-7.59,-7.13,-6.75,-6.47,-6.24,-6.05,-5.85,-5.74,-5.62,-5.49,-5.35,-5.24,-5.11,-5.15,-5.26,-5.38,-5.46,-5.50,-5.54,-5.59,-5.84,-6.11,-6.43,-6.79,-7.18,-7.53,-7.84,-8,-8.04,-8,-7.77,-7.68,-7.83,-8.03,-8.36,-8.72,-9.04,-9.40,-9.84,-10,-10,-11,-10,-11,-10,-10,-9.85,-9.63,-8.86,-8.02,-7.25,-6.77,-6.73,-7.54,-8.11,-8.43,-8.73,-9.16,-9.41,-9.13,-9.10,-9.75,-10,-11,-11,-10,-10,-10,-9.46,-8.73,-7.89,-7.03,-6.17,-5.37,-4.58,-3.89,-3.24,-3.01,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.92,-2.75,-2.50,-2.03,-1.38,-0.54,0.71,4.75,7.87,9.37,9.62,9.37,9.10,8.73,8.36,8.09,7.87,7.62,7.35,7,6.71,6.45,6.24,6.10,6,5.96,5.87,5.75,5.62,5.48,5.25,5.12,5.08,5,5,4.98,4.98,4.96,4.87,4.83,4.71,4.50,4.37,4.23,4.11,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.96,3.87,3.83,3.70,3.50,3.36,3.21,3.09,2.99,2.87,2.75,2.58,2.37,2.21,2.09,2,1.99,1.98,1.96,1.87,1.87,1.85,1.75,1.75,1.70,1.70,1.49,1.37,1.25,1.12,1.07,0.50,-0.25,-1.03,-1.88,-2.38,-2.63,-2.88,-2.92,-3,-3,-2.93,-2.88,-2.75,-2.43,-2.14,-1.92,-2.28,-2.50,-2.67,-2.75,-2.63,-2.42,-2.13,-1.64,-1.13,-0.53,0.09,0.75,1.50,2.48,3.46,4.35,4.75,4.87,5,5.37,6.25,7,7.62,8.20,8.62,9.12,9.47,9.70,9.87,10.11,10.57,11.37,12.25,13.12,13.87,14.50,15.12,15.75,16.49,17.12,17.72,18.20,18.57,18.85,19.12,19.37,19.82,20.34,20.96,21.62,22.37,23,23.50,23.75,23.71,23.25,22.50,21.59,20.59,19.58,18.87,18.71,18.87,19.25,19.50,19.37,18.97,18.58,18.47,18.37,17.25,-12,-13,-14,-15,-16,-16,-16,-16,-16,-15,-14,-14,-13,-12,-11,-11,-11,-10,-10,-9.52,-9,-8.49,-8,-7.59,-7.24,-6.96,-6.66,-6.50,-6.37,-6.25,-6.13,-6.03,-5.88,-5.88,-5.97,-6.10,-6.22,-6.30,-6.36,-6.38,-6.42,-6.50,-6.78,-7.10,-7.43,-7.77,-8.08,-8.33,-8.50,-8.63,-8.55,-8.60,-8.59,-8.62,-8.72,-8.91,-9.16,-9.52,-9.68,-10,-10,-10,-11,-11,-11,-11,-10,-9.78,-9.75,-9,-8.29,-7.78,-7.25,-7,-7.33,-7.59,-8.03,-8.25,-8.71,-8.77,-8.78,-8.93,-9.84,-10,-10,-11,-11,-10,-10,-9.75,-8.97,-8.08,-7.22,-6.38,-5.58,-4.85,-4.12,-3.39,-3.02,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.63,-2.38,-1.88,-1.25,0.12,2.24,5.62,7.99,9.33,9.50,9.25,8.85,8.37,8.11,7.87,7.62,7.33,6.99,6.62,6.37,6.22,6.09,6,5.96,5.87,5.75,5.61,5.37,5.25,5.12,5,5,4.99,4.98,4.98,4.96,4.87,4.83,4.71,4.50,4.37,4.23,4.10,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.96,3.87,3.83,3.70,3.50,3.36,3.20,3.08,2.99,2.87,2.75,2.58,2.37,2.21,2.09,2,2,1.98,1.98,1.97,1.95,1.87,1.87,1.87,1.86,1.86,1.74,1.62,1.62,1.62,1.37,1,0.45,-0.25,-0.88,-1.42,-2.01,-2.40,-2.65,-2.79,-2.88,-2.88,-2.88,-2.76,-2.55,-2.30,-2.05,-2.38,-2.63,-2.77,-2.88,-2.78,-2.63,-2.28,-1.88,-1.38,-0.88,-0.25,0.37,1.10,1.87,2.84,3.62,4.10,4.33,4.50,5.12,5.97,6.72,7.25,7.75,8.35,8.87,9.35,9.70,9.95,10.12,10.47,11,11.83,12.57,13.24,13.87,14.50,15.37,16.24,17,17.75,18.34,18.75,19.12,19.48,19.84,20.25,20.87,21.58,22.34,23.10,23.75,24.25,24.37,24.12,23.50,22.62,21.73,20.71,19.86,19.33,19.21,19.37,19.62,19.71,19.45,19,18.75,19.10,19.37,19.33,-12,-13,-14,-15,-16,-16,-16,-16,-16,-16,-15,-14,-13,-12,-12,-12,-11,-11,-10,-10,-9.96,-9.38,-8.85,-8.40,-8.02,-7.71,-7.41,-7.16,-7.01,-6.90,-6.84,-6.77,-6.75,-6.80,-6.90,-7.01,-7.16,-7.25,-7.29,-7.30,-7.36,-7.46,-7.63,-7.88,-8.18,-8.52,-8.85,-9.13,-9.38,-9.61,-9.68,-9.63,-9.42,-9.26,-9.24,-9.37,-9.62,-9.64,-9.86,-10,-10,-10,-11,-11,-11,-11,-10,-9.77,-9.88,-9.38,-8.76,-8.22,-7.63,-7.35,-7.40,-7.77,-8.03,-8.10,-8.38,-8.71,-8.99,-9.15,-9.79,-10,-10,-10,-10,-10,-10,-9.75,-8.97,-8.12,-7.29,-6.55,-5.87,-5.16,-4.41,-3.52,-3.02,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.90,-2.76,-2.52,-2.16,-1.63,-0.89,0.21,2.32,6.72,8.87,9.50,9.37,9,8.50,8.12,7.87,7.62,7.32,6.97,6.62,6.37,6.20,6.07,6,5.95,5.87,5.75,5.59,5.37,5.23,5.11,5,5,4.99,4.98,4.98,4.96,4.87,4.83,4.71,4.50,4.37,4.22,4.10,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.96,3.87,3.83,3.70,3.50,3.35,3.20,3.08,2.98,2.87,2.75,2.58,2.37,2.21,2.09,2,2,1.99,1.99,1.99,1.99,2,2,1.99,1.97,2,1.97,1.87,1.87,1.87,1.75,1.50,1.11,0.61,0.12,-0.50,-1.13,-1.67,-2.13,-2.38,-2.55,-2.88,-2.76,-2.79,-2.75,-2.63,-2.50,-2.50,-2.76,-2.88,-3,-2.90,-2.75,-2.50,-2.13,-1.63,-1.13,-0.51,0.08,0.72,1.37,2.20,2.87,3.37,3.74,4.25,5,5.87,6.62,6.96,7.37,7.99,8.62,9.25,9.84,10.23,10.50,10.75,11.21,11.72,12.22,12.75,13.34,14,15,16,17,17.87,18.59,19.12,19.50,19.87,20.25,20.75,21.37,22.12,23,23.83,24.50,24.98,25,24.57,23.75,22.75,21.75,20.85,20.11,19.70,19.62,19.85,20,19.85,19.49,19.12,19.12,19.87,20.47,19.34,-12,-13,-14,-15,-15,-16,-16,-16,-16,-16,-15,-14,-13,-13,-13,-12,-12,-11,-11,-11,-10,-10,-9.63,-9.25,-8.90,-8.54,-8.24,-8,-7.90,-7.86,-7.79,-7.75,-7.74,-7.78,-7.93,-8.12,-8.25,-8.29,-8.28,-8.28,-8.34,-8.46,-8.67,-9,-9.35,-9.68,-10,-10,-10,-10,-10,-10,-10,-9.76,-9.48,-9.67,-9.92,-9.92,-9.96,-10,-10,-11,-10,-11,-11,-10,-10,-10,-10,-9.62,-9.10,-8.50,-7.97,-7.96,-7.91,-8.10,-8.12,-8.11,-7.97,-8.38,-8.78,-9.13,-9.49,-9.88,-10,-10,-10,-10,-9.75,-9.30,-8.71,-8,-7.37,-6.79,-6.23,-5.60,-4.83,-3.90,-3.11,-3.01,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.67,-2.39,-2,-1.43,-0.63,2.12,5.61,8.25,9.25,9.46,9.24,8.75,8.33,7.98,7.62,7.25,6.96,6.62,6.37,6.20,6.07,6,5.95,5.87,5.75,5.58,5.37,5.22,5.09,5,5,4.99,4.98,4.98,4.96,4.87,4.83,4.71,4.50,4.37,4.22,4.10,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.96,3.87,3.83,3.70,3.50,3.35,3.20,3.08,2.98,2.87,2.75,2.59,2.37,2.22,2.10,2,2,2,2,2,2,2.09,2.12,2.12,2.08,2,2,2,2,2,1.99,1.87,1.62,1.37,0.87,0.25,-0.38,-0.88,-1.26,-1.63,-1.91,-2.26,-2.63,-2.78,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.63,-2.27,-1.88,-1.38,-0.77,-0.25,0.37,0.98,1.60,2.12,2.62,3.12,3.84,4.82,6.12,6.25,6.47,6.87,7.58,8.46,9.34,10.12,10.73,11.12,11.47,11.70,11.87,12.12,12.46,12.96,13.62,14.74,15.87,17.08,18.12,19,19.61,20,20.25,20.62,21.12,21.86,22.73,23.70,24.60,25.25,25.62,25.37,24.72,23.75,22.75,21.82,20.96,20.25,19.95,19.87,20.10,20.20,19.87,19.59,19.37,20,20.84,21.50,20.37,-11,-12,-13,-14,-15,-15,-15,-15,-15,-15,-15,-14,-13,-13,-13,-12,-12,-12,-12,-12,-11,-10,-10,-10,-9.68,-9.38,-9.12,-8.97,-8.91,-8.91,-8.89,-8.86,-8.78,-8.89,-9.12,-9.33,-9.42,-9.40,-9.35,-9.27,-9.28,-9.42,-9.71,-10,-10,-10,-11,-11,-11,-11,-11,-11,-10,-10,-9.85,-9.73,-9.92,-9.99,-9.90,-9.35,-9.50,-9.92,-10,-10,-11,-11,-11,-10,-10,-9.84,-9.22,-8.62,-8.46,-8.42,-8.34,-8.24,-8.37,-8.24,-8,-8.05,-8.27,-8.78,-9.26,-9.34,-9.53,-9.59,-9.55,-9.40,-9.14,-8.77,-8.34,-7.87,-7.47,-7.03,-6.54,-5.97,-5.23,-4.39,-3.66,-3.22,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.91,-2.78,-2.55,-2.25,-1.66,-0.88,0.24,4.62,6.87,8.60,9.32,9.46,9,8.50,8.07,7.70,7.25,6.96,6.62,6.37,6.20,6,5.99,5.95,5.87,5.75,5.58,5.37,5.21,5.09,5,5,4.99,4.98,4.98,4.96,4.87,4.84,4.71,4.50,4.37,4.21,4.09,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,4,4,4,4,4,4,4,3.99,3.99,3.98,3.96,3.87,3.83,3.70,3.50,3.35,3.12,3.08,2.98,2.87,2.75,2.60,2.37,2.24,2.11,2,2,2,2,2.09,2.12,2.21,2.25,2.32,2.34,2,2,2,2,2,2,2,1.98,1.75,1.37,0.87,0.45,0,-0.38,-0.68,-1.02,-1.40,-1.92,-2.25,-2.66,-2.88,-3,-3,-3,-3,-3,-3,-2.92,-2.77,-2.50,-2.05,-1.63,-1.03,-0.50,0,0.58,1.09,1.50,2,2.50,3.25,4.23,5.12,5.70,5.87,6.23,7.22,8.25,9.37,10.50,11.37,11.96,12.24,12.25,12.20,12.12,12.32,12.72,13.37,14.50,15.87,17.24,18.50,19.50,20.12,20.50,20.75,21.07,21.50,22.25,23.12,24.12,25.10,25.72,25.87,25.50,24.74,23.75,22.75,21.83,21,20.37,20.07,20,20.08,20.10,19.87,19.72,19.87,20.75,22.25,21.87,20.37,-10,-11,-12,-13,-13,-14,-14,-14,-15,-15,-14,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-10,-10,-10,-10,-10,-9.86,-9.84,-9.97,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-11,-11,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-9.84,-9.72,-9.12,-9.35,-9.75,-10,-10,-10,-11,-10,-10,-9.87,-9.75,-9.13,-8.88,-8.78,-8.78,-8.71,-8.51,-8.36,-8.26,-8.03,-8.03,-8.23,-8.43,-8.92,-9,-9.18,-9.33,-9.13,-8.79,-8.50,-8.23,-7.98,-7.77,-7.60,-7.30,-6.88,-6.29,-5.55,-4.75,-4,-3.38,-3.05,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.66,-2.38,-1.88,-1.13,0.37,2.36,4.87,7,8.61,9.33,9.12,8.70,8.12,7.73,7.25,6.97,6.62,6.37,6.12,6,5.99,5.95,5.87,5.75,5.58,5.37,5.20,5.08,5,4.99,4.99,4.98,4.98,4.96,4.87,4.84,4.72,4.50,4.37,4.21,4.09,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,4,4,4,4,4,4,4,3.99,3.99,3.98,3.96,3.87,3.84,3.70,3.50,3.35,3.12,3.07,2.98,2.87,2.75,2.62,2.45,2.25,2.12,2.09,2.07,2.08,2.12,2.12,2.25,2.37,2.46,2.57,2.62,3,3,3,2,2,2,2,2.32,2.10,1.75,1.37,1.11,0.82,0.50,0.25,-0.03,-0.38,-0.88,-1.38,-2,-2.42,-2.76,-3,-3,-3,-3,-3,-3,-2.88,-2.63,-2.25,-1.79,-1.28,-0.77,-0.26,0.22,0.62,1,1.45,1.87,2.57,3.37,4.37,5.21,5.75,6.07,6.87,8.12,9.47,10.87,12.12,12.87,13.10,12.85,12.50,12.25,12.25,12.61,13.25,14.37,15.87,17.47,18.99,20.12,20.75,20.96,21.11,21.35,21.75,22.50,23.48,24.50,25.50,26.12,26.12,25.62,24.75,23.74,22.74,21.86,21.11,20.50,20.10,19.87,19.87,19.87,19.87,20,20.60,21.37,22.10,21.87,19.46,-8.75,-9.86,-10,-11,-12,-13,-13,-13,-14,-14,-13,-13,-13,-13,-13,-12,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-10,-10,-10,-9.63,-9.30,-8.72,-9,-9.47,-10,-10,-10,-9.87,-10,-10,-9.61,-9.62,-9.11,-9.11,-9.03,-8.99,-8.87,-8.74,-8.50,-8.21,-7.88,-7.75,-8.13,-8.28,-8.55,-8.67,-8.65,-8.77,-8.64,-8.21,-7.79,-7.66,-7.65,-7.75,-7.75,-7.60,-7.24,-6.66,-5.93,-5.12,-4.33,-3.54,-3.14,-3.01,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.89,-2.75,-2.50,-2,-1.29,-0.38,0.98,2.34,4.87,7.07,8.57,8.96,8.71,8.22,7.75,7.32,6.98,6.62,6.37,6.12,6,5.99,5.96,5.87,5.75,5.59,5.37,5.20,5.08,5,4.99,4.99,4.98,4.98,4.96,4.87,4.84,4.72,4.50,4.37,4.20,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.99,3.98,3.98,3.98,3.98,3.98,3.98,3.98,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.98,3.96,3.87,3.84,3.71,3.50,3.35,3.12,3.08,2.99,2.87,2.82,2.62,2.50,2.36,2.24,2.12,2.12,2.12,2.24,2.33,2.37,2.50,2.62,2.75,2.87,3,3,3,3,3,3,3,2.62,2.50,2.25,1.87,1.62,1.37,1.24,1.07,0.83,0.62,0.12,-0.40,-0.92,-1.66,-2.41,-2.88,-3,-3,-3,-3,-3,-3,-2.75,-2.40,-2,-1.52,-1.05,-0.63,-0.14,0.25,0.61,0.95,1.36,1.87,2.62,3.75,4.95,5.87,6.37,7,8,9.37,11,12.83,13.75,13.87,13.25,12.75,12.47,12.37,12.62,13.23,14.36,16,17.62,19.35,20.61,21.20,21.25,21.25,21.46,21.87,22.60,23.62,24.82,25.95,26.62,26.57,25.87,24.87,23.83,22.85,22,21.25,20.62,20.12,19.86,19.73,19.75,19.95,20.37,21.12,21.98,22.21,21.57,19.50,-7.40,-8.24,-9.12,-10,-10,-11,-12,-12,-12,-13,-13,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-11,-11,-11,-11,-10,-10,-11,-11,-12,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-12,-12,-12,-12,-11,-11,-11,-11,-10,-10,-9.85,-9.38,-8.88,-8.27,-8.55,-9.10,-8.88,-8.78,-8.93,-9.34,-9.14,-9.74,-9.14,-9.14,-9.18,-9.21,-9.21,-9.12,-8.91,-8.74,-8.50,-8.22,-7.73,-7.62,-7.68,-7.93,-7.88,-7.91,-7.84,-7.92,-7.85,-7.58,-7.12,-7.05,-7.41,-7.75,-7.92,-7.90,-7.63,-7.09,-6.33,-5.46,-4.60,-3.87,-3.22,-3.03,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.92,-2.79,-2.63,-2.18,-1.64,-0.90,-0.15,1,2.37,5.20,7.20,8.25,8.48,8.20,7.74,7.33,6.99,6.62,6.37,6.12,6,5.99,5.96,5.87,5.75,5.59,5.37,5.20,5.07,5,4.99,4.99,4.98,4.98,4.96,4.87,4.85,4.72,4.50,4.37,4.20,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3.99,3.98,3.98,3.98,3.98,3.98,3.98,3.98,3.98,3.98,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.98,3.98,3.97,3.87,3.84,3.71,3.50,3.35,3.20,3.08,3,2.87,2.86,2.75,2.61,2.47,2.36,2.25,2.25,2.33,2.37,2.49,2.59,2.70,2.84,2.87,2.98,3,3,3,3,3,3,3,3,2.87,2.62,2.35,2.08,1.87,1.75,1.62,1.58,1.37,1.07,0.50,-0.03,-0.88,-1.75,-2.30,-2.63,-2.80,-2.88,-3,-3,-2.88,-2.75,-2.50,-2.13,-1.75,-1.38,-0.90,-0.50,-0.13,0.20,0.50,0.87,1.35,2,3.12,4.62,6.59,6.74,7.12,7.75,9,10.75,12.84,15.71,14.34,13.61,13.07,12.71,12.62,12.75,13.34,14.37,16,17.71,19.37,20.62,21.23,21.25,21.25,21.37,21.75,22.48,23.57,24.87,26.33,27.12,27.11,26.20,25.12,24,23.11,22.33,21.62,20.98,20.37,19.95,19.74,19.75,20.07,20.75,21.70,22.50,22.22,21,19.57,-6.33,-7.02,-7.60,-8.41,-9.10,-9.78,-10,-10,-11,-11,-12,-12,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-12,-12,-13,-13,-14,-13,-13,-12,-12,-11,-11,-11,-10,-10,-10,-10,-9.90,-9.39,-9.13,-8.50,-7.73,-8.04,-7.71,-8.58,-8.50,-8.64,-8.09,-8.63,-8.17,-8.66,-8.86,-9,-9.05,-9.10,-8.98,-8.87,-8.61,-8.35,-8.11,-7.86,-7.66,-7.68,-7.58,-7.52,-7.21,-6.91,-7.05,-7.05,-6.79,-6.25,-6.58,-7.12,-7.72,-8.08,-8.15,-7.93,-7.41,-6.65,-5.75,-4.84,-4.03,-3.48,-3.05,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.67,-2.38,-2,-1.42,-0.78,0,1.37,3.32,5.37,7,7.82,7.97,7.62,7.33,6.99,6.62,6.36,6.12,6,5.98,5.96,5.87,5.75,5.59,5.37,5.12,5.07,5,4.99,4.99,4.98,4.98,4.96,4.87,4.85,4.73,4.50,4.37,4.12,4,4,4,4,4,4,4,3.99,3.99,3.99,3.99,3.99,3.99,4,4,4,4,4,4,4,4,4,4,3.99,3.98,3.97,3.97,3.97,3.97,3.97,3.97,3.97,3.97,3.97,3.97,3.97,3.97,3.97,3.97,3.98,3.97,3.97,3.97,3.96,3.87,3.85,3.72,3.50,3.36,3.20,3.08,3,2.96,2.87,2.82,2.71,2.60,2.50,2.46,2.47,2.50,2.58,2.62,2.74,2.83,2.87,2.97,2.99,3,3,3,3,3,3,3,3,3,3,2.70,2.37,2.25,2.10,2,1.96,1.84,1.62,1.23,0.74,-0.04,-0.88,-1.43,-2.04,-2.38,-2.50,-2.75,-2.75,-2.63,-2.63,-2.50,-2.18,-1.90,-1.55,-1.25,-0.88,-0.50,-0.18,0.12,0.47,0.87,1.59,2.62,4,5.60,7.72,6.82,7.37,8.49,10.12,12.20,13.98,14.22,13.62,13.25,13,12.87,13.11,13.58,14.48,15.95,17.70,19.22,20.37,20.99,21.11,21.09,21.12,21.46,22.12,23.25,24.71,26.24,27.50,27.25,26.46,25.45,24.37,23.50,22.86,22.25,21.59,20.87,20.21,19.96,20.11,20.47,21.09,21.75,22.37,21.50,19.97,16.62,-5.93,-6.49,-6.90,-7.38,-7.90,-8.35,-9.17,-9.77,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-11,-11,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-12,-13,-13,-13,-13,-13,-12,-12,-11,-11,-10,-9.51,-9.63,-9.50,-9.48,-9.43,-9.38,-9.13,-8.75,-8.04,-7.04,-6.53,-7.36,-7.23,-7.17,-7.28,-7.75,-7.35,-7.88,-8.24,-8.33,-8.55,-8.64,-8.67,-8.58,-8.47,-8.35,-8.24,-8.10,-7.88,-7.64,-7.63,-7.50,-7.17,-6.84,-6.52,-6.41,-6.37,-6.17,-5.85,-6.18,-6.80,-7.60,-8.10,-8.28,-8.13,-7.63,-6.87,-5.91,-4.98,-4.14,-3.54,-3.14,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.90,-2.77,-2.55,-2.25,-1.88,-1.38,-0.63,0.46,1.87,3.62,5.60,7,7.71,7.62,7.36,7,6.62,6.35,6.12,6,5.98,5.97,5.87,5.75,5.59,5.37,5.12,5,5,4.99,4.99,4.98,4.98,4.96,4.87,4.86,4.73,4.57,4.37,4.12,4,4,4,4,4,4,3.99,3.99,3.99,3.99,3.98,3.98,3.99,3.99,4,4,4,4,4,4,4,4,4,3.98,3.97,3.96,3.95,3.87,3.87,3.87,3.87,3.87,3.87,3.87,3.87,3.87,3.87,3.87,3.87,3.87,3.87,3.87,3.87,3.87,3.87,3.83,3.71,3.50,3.35,3.12,3.07,3,2.96,2.87,2.86,2.75,2.72,2.62,2.62,2.62,2.62,2.73,2.75,2.86,2.87,2.98,2.99,3,3,3,3,3,3,3,3,3,3,3,3,2.75,2.59,2.48,2.37,2.37,2.25,2.11,1.86,1.36,0.75,0.21,-0.50,-1.13,-1.63,-1.76,-1.89,-1.92,-1.92,-2.13,-2.25,-2.25,-2,-1.77,-1.50,-1.14,-0.88,-0.50,-0.25,0.12,0.60,1.23,2.10,3.12,4.37,5.33,6.11,6.85,7.87,9.37,11.25,12.75,13.48,13.50,13.37,13.34,13.37,13.50,14,14.87,16.12,17.85,19.24,20.24,20.75,20.87,20.75,20.75,21,21.70,22.87,24.34,25.82,26.96,27.23,26.62,25.75,24.85,24.10,23.58,23.10,22.46,21.62,20.87,20.71,21.12,21.25,21.25,21.45,21.49,20.37,18.37,15.73,-5.87,-6.14,-6.50,-6.84,-7.28,-7.66,-8.02,-8.59,-9.01,-9.21,-9.40,-9.47,-9.50,-9.59,-9.59,-9.78,-9.88,-10,-10,-10,-9.92,-10,-10,-10,-10,-10,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-13,-13,-13,-13,-13,-13,-13,-13,-12,-12,-10,-10,-9.89,-9.11,-8.26,-8.30,-8.38,-8.76,-8.93,-8.79,-8.43,-7.89,-7.13,-6.53,-6.26,-6.13,-6.01,-6,-6.08,-6.63,-7.26,-7.71,-7.68,-7.83,-8,-8.14,-8.18,-8.17,-8.18,-8.17,-8.16,-7.99,-7.79,-7.61,-7.42,-7.28,-6.96,-6.47,-6.10,-5.91,-5.88,-5.71,-5.37,-5.86,-6.54,-7.38,-7.92,-8.16,-8.04,-7.59,-6.84,-5.90,-4.97,-4.14,-3.55,-3.17,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.88,-2.66,-2.43,-2.15,-1.78,-1.18,-0.43,0.70,2.25,4.48,6.49,7.62,7.82,7.48,7.08,6.70,6.34,6.11,6,5.98,5.97,5.87,5.75,5.59,5.36,5.12,5,4.99,4.98,4.98,4.97,4.97,4.96,4.87,4.86,4.74,4.57,4.36,4.12,4,3.99,3.99,3.99,3.99,3.99,3.98,3.98,3.97,3.96,3.96,3.97,3.97,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.99,3.96,3.87,3.87,3.86,3.84,3.83,3.82,3.82,3.82,3.82,3.82,3.82,3.82,3.82,3.83,3.84,3.84,3.85,3.85,3.85,3.83,3.75,3.62,3.48,3.25,3.12,3,2.95,2.87,2.87,2.86,2.82,2.75,2.74,2.72,2.73,2.75,2.75,2.87,2.87,3,3,3,3,3,3,3,4,4,4,4,4,4,4,3,3,3,3,3,3,3,2.57,2.35,2.12,1.87,1.36,0.60,-0.13,-0.38,-0.41,-0.66,-0.66,-0.88,-1.30,-1.75,-2,-2.13,-1.89,-1.68,-1.38,-1.04,-0.75,-0.41,-0.13,0.34,0.87,1.50,2.33,3.10,3.87,5,6.12,7.57,9.08,10.60,11.84,12.62,13.07,13.37,13.74,14,14.25,14.73,15.59,16.87,18.35,19.58,20.37,20.75,20.71,20.48,20.34,20.50,21.21,22.45,23.98,25.50,26.62,27.12,26.87,26.12,25.25,24.62,24.25,24,23.50,22.74,22.08,22.45,22.62,22.37,21,20.34,20.57,18.62,15.87,13.82,-5.72,-6.02,-6.24,-6.38,-6.54,-6.92,-7.14,-7.52,-7.77,-7.88,-7.88,-8.04,-8.23,-8.40,-8.38,-8.36,-8.61,-8.96,-9.10,-8.99,-9.17,-9.38,-9.50,-9.50,-9.97,-10,-10,-11,-11,-11,-11,-11,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-11,-11,-10,-9.63,-9.08,-8.28,-7.61,-7.10,-7.42,-7.79,-8.11,-8.16,-7.87,-7.35,-6.63,-5.72,-5.52,-5.65,-5.79,-5.88,-6,-5.92,-6.25,-6.66,-6.91,-7.02,-7.18,-7.38,-7.51,-7.59,-7.72,-7.79,-7.89,-7.90,-7.83,-7.63,-7.42,-7.11,-6.92,-6.60,-6.14,-5.85,-5.64,-5.52,-5.30,-4.99,-5.54,-6.23,-6.97,-7.49,-7.68,-7.58,-7.13,-6.43,-5.58,-4.67,-3.91,-3.38,-3.13,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.93,-2.88,-2.68,-2.53,-2.38,-2.13,-1.75,-1.13,-0.04,1.62,4,6.37,7.75,8.10,7.62,7.12,6.73,6.34,6.09,5.99,5.97,5.96,5.87,5.75,5.50,5.25,5.09,4.96,4.87,4.87,4.87,4.87,4.87,4.87,4.87,4.85,4.73,4.58,4.25,4.08,3.95,3.87,3.87,3.87,3.87,3.87,3.95,3.87,3.87,3.87,3.86,3.86,3.87,3.87,3.87,3.87,3.87,3.87,3.87,3.87,3.87,3.95,3.97,3.98,3.97,3.85,3.75,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.61,3.61,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.59,3.49,3.33,3.12,2.99,2.87,2.83,2.75,2.75,2.75,2.75,2.73,2.71,2.70,2.71,2.74,2.75,2.86,2.87,3,3.12,3.12,3,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3.33,3.23,3.24,3.35,3.24,2.24,2.24,2,1.62,1.33,1.34,0.37,-0.43,-1.05,-1.50,-1.88,-2.01,-1.88,-1.52,-1.17,-0.88,-0.53,-0.25,0.12,0.59,1.12,1.72,2.25,2.96,3.75,5.46,7.25,9.11,10.20,11.12,11.85,12.50,13.33,14.12,15.07,15.60,16,16.58,17.75,19.21,20.36,20.87,20.87,20.57,20,19.75,19.97,20.75,22.12,23.75,25.37,26.82,27.58,27.37,26.47,25.50,24.87,24.71,24.73,24.37,23.96,23.87,24.25,26.45,22.50,19.82,18.12,17.62,14.97,12.50,8.87,-5.50,-5.79,-6.02,-6.17,-6.25,-6.28,-6.48,-6.61,-6.90,-7.04,-7.01,-6.79,-6.89,-7.21,-7.28,-7.17,-7.24,-7.64,-7.78,-7.97,-8.16,-8.39,-8.39,-8.87,-9.39,-9.85,-10,-10,-10,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-10,-9.58,-8.60,-7.99,-7.52,-6.92,-6.33,-5.99,-6.40,-6.93,-7.25,-7.01,-6.37,-5.71,-4.91,-4.55,-4.62,-4.79,-4.90,-5.03,-5.13,-5.13,-5.36,-5.84,-6.13,-6.33,-6.38,-6.62,-6.65,-6.71,-6.78,-7.09,-7.29,-7.43,-7.38,-7.27,-7.16,-6.84,-6.38,-6.05,-5.76,-5.43,-5.38,-5.25,-5.01,-4.68,-5.13,-5.62,-6.13,-6.53,-6.73,-6.63,-6.24,-5.63,-4.85,-4.02,-3.30,-2.87,-2.87,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.88,-2.75,-2.63,-2.50,-2.38,-2.30,-2.13,-1.63,-0.42,1.47,3.97,6.48,8,8.36,7.75,7.20,6.62,6.25,5.97,5.87,5.87,5.87,5.84,5.72,5.37,5.10,4.82,4.72,4.62,4.62,4.62,4.62,4.62,4.62,4.62,4.62,4.73,4.47,4.11,3.84,3.73,3.70,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.59,3.60,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.62,3.72,3.75,3.75,3.82,3.85,3.82,3.46,3.37,3.35,3.35,3.35,3.35,3.35,3.34,3.34,3.33,3.33,3.33,3.34,3.34,3.35,3.36,3.36,3.36,3.35,3.25,3.21,3.08,2.87,2.75,2.62,2.62,2.60,2.59,2.59,2.58,2.57,2.50,2.50,2.50,2.57,2.61,2.62,2.82,3,3.34,4,4,4,4,4,4,4,4,5,5,5,6,5,4,4,4,4,4,4,4,4.62,4.34,4.87,6.09,5.87,7.22,8.45,8.74,8.71,3.75,1.50,0.22,-0.43,-0.88,-1.25,-1.79,-1.88,-1.63,-1.13,-0.88,-0.53,-0.26,0.07,0.45,0.87,1.35,1.84,2.37,3.25,4.50,7.48,9.46,9.87,10.37,10.96,11.75,13,14.59,16.09,17.86,16.87,17.12,18.36,20.12,21.50,21.37,20.96,20.12,19.25,18.72,18.87,20.08,21.72,23.50,25.37,27.12,28.35,28,26.62,25.12,24.50,24.73,24.87,24.75,24.83,25.37,26.50,24.57,21.11,17.36,15,13.08,11.12,9,6,-3.21,-5.51,-5.75,-5.89,-5.99,-5.99,-5.92,-5.97,-6,-6.13,-6.12,-5.88,-5.85,-5.98,-6,-5.83,-5.99,-6.22,-6.58,-6.75,-6.98,-7.35,-7.73,-8,-8.52,-9.05,-9.49,-9.91,-10,-10,-10,-10,-10,-11,-10,-10,-10,-10,-10,-10,-10,-10,-10,-9.21,-7.97,-6.97,-6.50,-6.22,-5.64,-4.68,-4.63,-5.10,-5.52,-5.60,-5.41,-4.16,-3.77,-3.55,-3.71,-3.77,-4.04,-4.25,-4.38,-4.50,-4.50,-4.51,-5.10,-5.40,-5.52,-5.53,-5.64,-5.67,-5.62,-5.49,-5.64,-6.12,-6.51,-6.63,-6.71,-6.77,-6.43,-5.97,-5.40,-5.26,-5,-5,-4.87,-4.64,-4.30,-3.99,-4.04,-4.75,-5.25,-5.47,-5.39,-5.09,-4.55,-3.86,-3.08,-2.36,-1.85,-1.93,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-3,-2.80,-2.52,-2.29,-2.13,-1.92,-1.88,-1.88,-1.90,-0.13,1.25,3,5.95,7.87,7.85,6.75,5.75,5.74,4.72,4.72,4.72,4.72,4.74,4.75,4.62,4.61,3.75,3.59,3.50,3.50,3.58,3.61,3.62,3.75,3.87,3.96,3.98,3.87,3.84,3.12,2.97,2.87,2.87,2.87,2.87,2.87,2.87,2.87,2.87,2.87,2.99,2.87,2.87,2.87,2.87,2.87,2.87,2.87,2.87,2.87,2.87,2.87,2.87,2.95,2.97,2.98,2.97,2.87,2.87,2.98,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2.97,2.87,2.75,2.62,2.50,2.37,2.37,2.37,2.37,2.37,2.36,2.36,2.35,2.33,2.32,2.25,2.25,2.25,2.25,2.50,3.87,4,5,4,4,4,4,4,5,5,5,6,6,5,5,5,4,5,4,4,5,5,5,6,8,9,9.87,10.85,10.75,9.75,5.74,1.57,0.11,0.12,-0.13,-0.52,-0.88,-1.25,-1.13,-0.92,-0.75,-0.50,-0.25,0.07,0.37,0.75,1.12,1.45,1.84,2.62,3.62,5.70,8.72,9.70,9.59,9.47,10.37,12.34,14.21,16.10,17.99,16.87,15.84,17.75,19.72,21.62,20.60,19.37,19.25,18.09,15.97,16.87,18.75,20.70,22.62,24.61,26.59,28.61,28.62,25.62,22.74,21.83,23.95,24.07,23.21,24.37,27.50,25.62,21.62,17.73,13.75,10.82,8.87,6.97,6,5.12,];
}

function getTileMap()
{
	return [0,0,1,1,1,1,1,1,1,1,2,0,1,2,0,0,0,1,0,1,0,1,2,0,1,0,0,0,0,1,0,2,0,0,0,0,0,0,0,0,2,0,1,0,1,0,2,1,0,2,0,2,2,1,0,2,0,2,2,2,0,0,1,2,0,2,0,0,2,2,2,1,0,2,0,1,0,2,0,2,1,0,2,1,2,2,0,2,0,0,0,1,1,2,0,0,0,1,0,1,0,0,2,0,0,1,0,0,0,1,1,1,1,2,0,1,0,1,0,0,0,1,0,2,0,0,0,0,2,0,1,1,0,1,0,1,0,0,0,0,2,1,0,1,2,2,0,0,0,0,2,0,2,0,2,0,0,0,0,0,1,0,1,0,0,1,2,0,2,1,2,1,0,0,0,0,0,1,1,0,0,0,1,1,0,2,1,0,2,1,0,0,1,2,2,1,0,2,2,0,0,0,2,0,0,2,1,2,0,2,0,0,1,0,0,2,0,1,0,0,0,0,2,1,1,1,0,0,2,0,0,0,2,0,0,0,2,1,0,0,1,1,0,0,0,0,1,0,0,1,0,2,0,1,2,2,2,0,0,0,0,0,0,2,1,0,1,0,1,1,0,1,1,0,0,1,1,2,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,0,0,0,1,0,0,0,0,2,0,0,0,1,2,0,0,0,2,1,0,2,2,1,2,2,1,0,0,2,0,1,2,2,0,2,2,0,2,2,2,1,0,0,0,1,0,0,2,1,0,1,2,2,2,1,0,1,2,0,0,2,1,1,0,2,0,2,0,0,2,0,0,1,0,0,0,0,1,0,0,0,0,2,1,2,0,0,1,0,2,0,0,0,0,0,0,0,0,0,2,0,1,1,0,0,0,2,0,0,2,0,2,2,0,0,1,1,0,2,2,0,2,0,0,0,0,2,2,0,2,1,2,0,0,0,0,1,0,0,0,2,2,0,0,2,2,0,2,1,1,1,0,0,1,0,0,0,0,0,1,1,0,0,0,2,0,0,1,0,0,2,0,0,0,0,0,0,2,0,1,1,2,0,0,2,0,0,0,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0,2,0,0,0,0,0,2,1,0,0,2,1,0,0,2,2,1,0,0,1,0,2,0,0,2,0,0,1,1,1,0,2,0,0,2,0,0,0,0,1,2,1,0,1,2,1,0,1,0,1,1,2,0,0,0,0,2,2,1,2,2,0,0,2,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,0,2,0,0,2,2,1,2,0,0,0,0,0,2,2,0,1,2,1,0,2,0,1,0,0,2,1,0,1,0,1,0,2,0,1,1,0,2,2,0,0,0,1,2,0,0,0,2,0,0,1,2,2,2,1,0,0,0,0,0,2,0,2,1,0,2,0,0,0,1,1,2,0,0,1,0,0,0,0,1,0,2,0,2,1,0,0,1,0,2,1,0,2,2,1,0,2,2,0,0,2,1,0,2,2,1,2,0,0,1,0,0,1,1,0,1,1,0,2,0,0,0,0,0,1,1,2,0,1,0,1,0,1,0,0,0,1,0,0,0,1,1,1,1,0,1,0,0,0,1,0,0,0,2,0,2,0,2,0,0,0,0,2,1,2,0,1,0,1,2,0,2,1,2,1,2,1,2,1,0,0,0,0,0,0,0,1,2,0,0,2,0,2,2,1,0,0,0,2,0,0,0,0,1,0,1,1,0,2,0,0,0,2,0,0,1,2,0,1,0,0,0,2,0,0,2,1,0,2,0,0,0,1,0,1,0,1,0,0,0,0,0,0,2,0,2,0,0,2,2,1,0,0,0,0,2,1,1,2,2,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,2,2,1,0,0,1,1,1,1,0,0,2,1,1,0,1,1,0,2,0,2,2,2,0,2,0,1,0,0,0,2,2,0,2,0,0,1,1,1,1,2,0,1,2,1,0,0,1,0,0,2,2,1,2,2,1,2,2,1,0,1,1,0,1,2,0,1,1,0,0,2,1,1,2,0,0,0,2,0,0,1,2,1,1,0,0,1,2,1,0,0,1,0,1,0,0,0,0,2,0,1,0,2,0,1,0,1,2,0,2,1,2,1,2,0,0,0,0,2,0,0,0,0,1,1,0,2,0,0,0,2,0,0,2,1,0,2,2,2,0,0,0,2,1,2,1,1,2,0,2,0,1,1,0,1,1,1,0,2,0,1,0,0,2,1,1,0,0,0,1,2,1,0,1,2,0,2,0,1,0,1,2,2,1,2,2,0,0,0,0,2,0,2,1,2,0,2,0,0,0,0,2,0,2,1,0,2,2,0,0,2,2,0,0,0,1,0,0,2,0,1,1,0,0,0,0,1,0,0,2,1,1,2,2,0,0,2,0,0,1,0,0,2,2,1,0,0,2,1,0,0,0,1,1,0,0,2,1,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,1,0,1,1,0,0,1,1,0,0,0,1,1,0,2,1,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,2,1,0,2,0,0,0,1,0,1,0,2,2,1,1,0,1,0,2,1,0,0,2,0,1,0,1,0,0,0,0,0,1,0,1,2,2,0,0,0,0,1,2,0,1,0,1,2,2,2,0,1,1,1,0,2,0,0,1,0,2,0,2,1,0,2,0,2,2,2,0,0,2,2,1,1,0,1,0,2,2,1,0,0,1,0,0,1,2,0,1,0,0,0,1,1,2,0,0,2,0,0,0,2,0,0,2,1,0,1,0,0,1,1,0,1,1,0,1,0,2,2,1,0,1,2,2,1,1,1,0,1,0,1,0,0,0,0,2,2,0,2,2,0,2,0,0,1,2,0,2,0,0,2,1,0,1,0,2,1,0,0,1,0,0,2,0,1,0,2,0,2,1,2,0,0,0,1,0,1,2,0,0,2,2,0,1,2,0,0,0,2,0,1,0,1,2,0,1,1,2,1,0,2,0,0,0,1,1,0,0,1,2,0,0,1,1,2,0,0,0,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,0,0,0,1,0,1,2,0,0,1,2,1,0,1,2,0,0,0,0,0,2,2,1,0,0,0,0,0,2,1,1,1,0,0,0,0,0,0,1,2,2,1,0,1,0,0,0,2,0,1,0,2,0,1,1,0,1,1,2,0,0,0,1,2,2,1,2,0,0,0,2,0,2,2,0,0,0,0,0,0,0,1,0,2,2,2,0,0,2,2,0,2,1,2,1,1,0,1,1,0,2,1,2,0,2,1,0,0,0,1,2,1,0,2,2,0,2,0,0,0,0,0,1,0,0,0,0,1,0,1,1,2,1,0,0,0,2,0,0,0,2,0,1,2,2,2,1,2,1,2,1,0,1,2,0,1,1,2,0,1,2,0,0,0,2,0,1,1,0,2,1,0,0,1,1,2,2,0,0,1,2,0,0,0,1,0,0,1,0,2,2,0,2,0,2,0,1,2,1,1,1,0,0,0,2,1,2,1,0,1,0,0,2,1,2,2,0,1,0,0,0,2,2,0,2,2,1,0,1,0,2,0,0,2,1,1,0,0,2,2,0,0,2,2,2,2,0,0,0,2,2,1,2,0,2,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,1,0,0,1,2,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,2,0,2,0,0,0,2,0,0,0,2,0,2,1,0,0,0,0,2,1,1,1,2,2,0,0,2,1,0,0,0,0,2,0,0,2,0,1,0,2,2,0,0,2,0,0,2,1,1,1,2,0,0,2,0,0,1,1,2,0,0,1,0,0,2,2,0,0,2,2,2,1,2,2,0,0,0,1,0,2,0,1,1,0,0,1,0,0,0,2,2,0,0,2,1,1,2,0,2,0,0,0,0,1,1,2,2,1,0,1,1,0,0,0,2,0,2,0,0,1,2,0,0,0,1,2,0,1,1,1,0,0,2,0,2,2,1,0,0,0,0,2,0,0,0,2,0,0,2,2,1,0,2,2,1,2,1,2,0,1,0,0,0,0,0,0,2,1,2,1,0,0,0,0,0,0,1,1,1,0,0,2,2,1,2,1,1,0,0,0,0,1,0,2,2,2,0,1,0,0,2,0,1,0,2,2,0,2,1,1,0,1,0,0,0,0,0,1,2,0,0,1,0,2,1,1,0,2,2,0,2,0,1,0,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,1,0,1,0,0,1,2,0,2,1,0,2,2,1,0,1,2,0,0,0,2,0,1,0,1,0,0,0,2,2,1,0,0,1,2,1,1,0,0,2,2,2,1,1,2,0,2,2,2,0,1,1,0,0,1,2,1,1,1,1,1,1,0,0,1,1,0,0,0,0,2,0,0,0,2,0,0,2,0,0,1,0,2,0,0,1,1,1,1,0,0,2,1,1,1,0,0,0,0,1,0,2,2,1,0,2,1,0,1,0,0,0,2,2,0,0,2,2,2,0,1,0,2,0,2,0,0,1,1,2,0,0,1,0,1,1,2,0,2,1,2,0,0,0,1,2,2,1,0,0,0,0,1,1,0,0,0,1,1,0,2,0,0,2,2,2,0,0,0,0,0,0,0,0,0,1,1,0,2,2,1,1,0,0,0,0,0,1,0,0,1,0,0,1,1,1,0,0,1,0,1,2,0,1,1,0,2,1,0,2,1,0,2,2,0,1,0,2,0,1,2,1,0,2,2,0,2,0,0,1,0,0,0,1,0,2,0,1,0,2,1,0,1,1,1,0,2,0,1,0,2,0,2,1,1,0,0,1,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,2,0,1,2,1,1,2,0,0,1,2,1,0,2,1,2,1,2,1,0,1,2,1,2,0,1,1,1,0,1,1,1,0,2,1,0,1,1,1,1,2,0,2,0,2,0,2,0,0,2,0,0,0,2,1,2,0,0,1,0,2,1,0,2,0,2,1,0,1,0,0,2,0,1,1,0,1,2,2,1,2,2,0,2,0,2,2,2,2,1,1,1,0,0,2,0,0,2,1,0,0,0,2,1,1,0,0,0,2,0,0,0,0,2,2,2,1,0,0,0,1,1,2,2,0,1,0,0,0,1,1,0,2,0,0,1,0,0,0,2,1,0,1,0,1,2,2,0,0,2,0,1,2,0,2,1,1,0,0,1,1,2,0,2,1,2,0,1,0,0,1,0,1,0,1,0,0,2,1,2,2,0,4,4,1,1,2,0,2,0,0,1,2,0,0,0,0,1,1,2,1,2,0,1,1,0,1,2,2,0,0,0,2,2,0,0,0,0,0,0,2,1,0,0,0,0,0,0,2,1,1,0,0,1,0,1,0,0,0,1,0,1,1,0,0,0,1,0,1,0,0,1,0,1,0,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,2,0,2,2,0,1,0,2,0,2,2,0,2,2,0,2,2,0,0,0,1,2,0,0,0,0,0,0,2,0,1,1,2,1,0,0,0,2,0,2,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,1,0,2,2,0,0,2,0,2,1,1,1,2,1,0,0,0,2,0,0,1,2,0,2,1,0,1,0,2,2,2,0,0,2,0,2,1,0,0,2,2,0,0,0,1,0,1,0,0,0,0,2,0,1,0,0,0,0,2,2,2,2,2,0,0,1,2,0,1,1,0,0,0,0,0,0,2,2,1,0,1,0,0,2,0,0,1,0,1,0,1,2,0,0,1,1,2,0,0,1,0,1,0,0,2,1,0,2,1,2,1,1,0,0,1,0,2,2,2,0,0,2,0,0,2,4,4,4,4,0,0,1,2,0,1,0,0,1,1,0,0,0,2,2,2,0,0,1,0,2,0,0,0,2,0,1,1,0,0,0,1,1,2,0,2,0,2,1,1,0,0,2,2,0,2,0,0,0,1,0,2,0,2,2,2,1,0,0,0,0,0,1,0,0,1,2,0,0,0,1,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,0,0,0,2,2,0,1,0,1,0,0,2,0,1,0,0,1,0,2,0,2,1,1,2,2,1,0,2,2,1,0,0,2,0,0,0,2,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,1,0,2,2,2,0,0,2,1,0,2,0,0,2,0,2,1,1,1,0,2,0,1,0,0,0,0,1,1,0,0,2,2,0,0,0,0,0,0,2,1,0,0,0,2,2,0,0,2,0,1,2,0,1,0,1,0,0,1,0,1,1,0,0,0,2,0,0,0,1,1,2,0,0,1,0,1,0,0,2,1,2,2,1,1,0,0,2,0,0,2,1,0,0,0,1,2,1,2,0,2,0,0,0,2,1,0,0,0,1,0,1,0,0,2,0,2,0,2,0,0,1,0,0,0,1,2,2,0,0,0,4,4,4,4,4,4,0,1,0,0,0,0,0,1,0,0,2,0,1,0,1,0,2,0,0,1,2,0,1,0,0,2,0,2,0,0,2,0,2,2,2,1,0,2,0,1,0,2,1,0,2,2,0,1,0,2,0,0,2,2,0,0,2,0,1,0,1,0,2,0,0,0,2,2,1,0,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,1,1,1,1,1,1,2,1,2,0,0,0,1,0,0,2,0,0,0,1,1,0,2,1,0,0,0,0,0,0,2,0,1,2,1,0,0,2,2,1,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,1,0,1,0,2,2,0,0,2,1,0,1,2,1,0,2,1,0,1,2,0,1,2,0,0,0,0,0,0,1,1,0,0,1,1,0,2,0,0,0,0,1,2,1,1,2,0,0,1,0,1,0,0,0,0,0,0,0,2,0,0,0,1,0,0,1,2,0,2,1,0,0,1,0,1,0,0,0,0,0,1,0,1,2,0,2,0,0,2,2,1,1,0,2,1,1,0,0,1,2,1,1,0,0,0,1,2,1,0,2,0,2,1,0,1,2,0,1,0,0,2,0,1,0,0,2,1,0,0,0,2,4,4,4,4,4,4,2,2,0,2,1,0,1,0,2,2,2,2,2,0,0,0,0,1,0,2,2,0,1,0,1,0,2,2,0,0,2,0,2,2,0,0,1,1,0,2,0,0,0,2,2,0,0,1,2,1,0,2,2,0,1,0,2,1,2,0,0,0,0,2,2,2,0,2,2,1,1,0,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,1,1,1,1,1,1,2,0,1,0,1,1,1,0,0,0,0,0,0,1,2,1,2,1,2,0,1,0,2,1,1,0,0,0,2,0,0,1,0,1,2,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,0,1,2,0,0,0,1,0,0,1,0,0,2,0,1,2,0,2,1,0,1,0,0,0,0,2,0,0,1,0,2,0,0,2,0,0,2,1,0,2,0,0,0,1,2,1,0,0,0,2,0,1,1,1,0,0,0,0,2,0,2,1,0,0,1,2,2,0,0,2,1,0,2,2,0,0,2,2,2,2,0,2,1,2,1,2,0,2,1,2,2,0,0,2,2,0,0,0,2,0,2,0,0,0,0,0,0,2,0,0,0,2,1,0,0,2,1,0,2,0,2,0,1,2,1,0,0,2,0,2,0,2,0,5,4,4,4,2,6,6,0,2,1,0,0,0,0,2,2,2,2,0,0,2,2,0,2,0,2,0,2,2,1,0,0,0,0,1,0,0,0,2,2,1,1,1,0,2,0,0,1,0,0,1,0,1,1,1,2,1,2,0,1,0,1,0,1,0,2,2,0,0,1,2,0,1,0,1,0,0,2,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,1,1,1,0,0,1,1,1,0,1,0,0,0,1,2,2,0,0,0,0,1,1,0,0,0,1,1,1,0,2,1,2,0,0,0,2,1,1,2,0,2,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,1,1,0,0,0,2,2,0,0,0,0,0,0,2,0,0,0,1,2,0,0,2,0,0,0,0,0,0,0,2,0,0,1,0,0,0,2,0,0,0,2,1,1,2,2,0,0,0,0,1,1,1,1,1,0,0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,1,1,0,0,2,1,0,1,2,0,0,1,2,1,0,0,0,0,0,0,2,0,0,2,2,1,0,0,0,1,0,0,0,2,0,0,2,1,0,0,0,0,0,2,0,1,5,5,5,5,5,6,0,1,0,0,0,0,0,2,0,2,2,2,2,2,0,0,0,1,2,0,1,0,2,1,0,2,1,2,1,1,0,0,0,2,2,0,0,0,1,0,0,0,0,1,2,2,0,1,1,2,1,0,1,0,2,0,0,0,0,0,0,0,0,0,1,0,1,1,0,2,0,2,1,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,0,0,0,2,0,2,1,1,0,2,0,0,0,0,0,2,2,0,0,0,1,1,2,0,2,0,2,0,2,0,2,1,1,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,0,0,1,2,0,1,0,1,0,0,0,0,0,1,1,0,2,1,0,1,0,0,2,0,0,2,2,1,0,0,0,0,2,0,2,0,0,0,1,1,0,2,2,2,2,0,0,1,1,1,1,1,1,1,2,2,0,2,0,0,0,2,0,0,0,0,0,1,0,2,2,2,0,0,2,2,2,0,0,1,0,2,1,0,0,1,2,1,0,1,0,2,1,0,0,0,2,2,2,0,2,1,1,0,0,0,0,2,0,0,0,1,0,2,1,0,2,2,0,0,2,2,0,1,2,0,1,0,2,1,6,5,5,5,5,5,0,2,2,0,0,0,0,2,1,2,2,2,2,2,2,2,0,2,0,0,0,0,2,1,2,1,0,1,2,2,0,2,1,0,0,2,0,0,0,2,0,0,1,2,0,2,0,2,0,0,2,2,1,0,0,2,0,0,0,0,2,0,0,2,1,1,0,0,2,0,1,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,2,0,0,2,1,0,2,0,0,0,0,2,2,0,0,0,0,0,1,2,0,2,2,0,2,0,2,2,0,0,0,1,2,0,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,1,2,2,0,0,0,2,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,1,1,2,0,1,1,1,0,1,2,2,2,0,2,0,1,1,2,1,0,0,1,2,1,0,2,2,1,1,1,1,1,1,1,1,1,2,1,0,2,0,0,2,0,1,2,0,1,1,0,0,0,1,1,1,1,1,2,0,2,0,2,1,2,0,0,2,0,2,0,0,2,0,0,0,2,0,0,0,0,1,1,0,2,0,0,0,0,1,0,0,0,0,2,2,0,2,0,2,2,1,1,0,0,0,2,2,0,0,1,2,6,5,5,5,5,1,0,1,0,0,2,2,0,0,0,2,2,2,2,2,2,2,1,2,2,0,1,0,0,1,1,2,0,0,2,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,2,2,2,2,1,0,2,0,2,1,1,2,2,0,2,0,2,0,0,0,1,1,0,0,2,0,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,0,2,0,0,2,1,1,1,0,2,0,2,0,2,0,2,1,0,1,0,0,2,2,0,2,0,2,0,1,1,2,0,0,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,2,1,0,0,0,1,0,2,0,1,2,0,0,1,0,2,1,2,0,0,0,0,2,1,1,1,1,0,0,1,1,1,1,1,1,2,0,0,2,0,0,0,0,2,1,0,0,0,0,1,0,2,1,1,1,1,1,1,1,1,1,1,1,2,0,2,0,0,2,0,0,2,2,2,0,0,2,0,0,0,0,0,2,2,2,2,0,2,1,2,0,0,1,1,0,1,0,2,0,0,0,0,1,2,0,1,2,1,0,0,0,1,1,0,2,0,0,1,0,2,1,0,2,1,2,7,7,2,0,0,1,1,1,0,1,0,0,0,6,6,1,0,0,1,0,0,0,1,0,0,2,0,0,2,2,2,2,2,2,2,0,0,0,1,2,0,0,2,2,0,2,1,2,0,1,1,0,2,0,2,1,0,2,0,0,2,1,2,1,1,0,1,1,2,2,1,2,0,1,0,0,0,0,2,2,0,1,1,2,0,0,1,2,0,0,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,0,2,0,1,0,0,1,0,0,2,1,0,0,1,0,2,2,0,2,2,0,2,1,1,2,1,2,0,0,0,2,2,0,0,0,0,1,1,1,0,1,1,1,1,1,0,1,0,0,0,0,0,0,0,1,2,0,0,2,1,0,1,2,1,0,0,1,0,0,2,0,2,0,1,1,1,1,1,0,1,1,1,1,1,1,1,2,0,0,2,0,0,1,1,0,1,2,0,0,1,1,1,1,1,1,1,1,1,7,7,1,1,1,0,1,2,2,1,1,2,0,2,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,2,0,0,2,0,2,0,1,0,1,0,0,1,0,0,1,0,0,0,0,0,1,2,2,0,0,0,0,0,0,2,1,1,7,7,7,0,0,0,0,0,2,2,1,0,2,0,0,0,1,2,2,2,0,2,0,0,1,2,2,2,2,2,2,2,2,2,2,2,0,0,2,0,1,0,2,0,2,0,2,2,0,0,0,2,1,1,0,0,1,0,2,0,0,2,1,0,0,0,2,0,0,1,0,0,2,1,0,0,0,2,1,2,0,2,2,1,2,2,2,0,0,1,1,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,0,0,1,2,1,0,1,2,0,0,1,0,0,0,2,0,0,1,0,2,0,0,0,0,0,0,0,1,2,0,2,0,0,0,2,1,1,1,0,1,0,1,1,1,1,2,2,0,0,0,0,2,1,0,2,0,1,0,2,0,1,1,2,0,0,0,2,2,1,0,1,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,0,0,2,1,2,0,1,1,1,1,1,1,1,1,1,1,1,7,7,7,1,1,2,2,0,2,0,0,1,0,0,1,0,2,0,2,0,0,1,0,2,0,1,0,2,0,0,2,0,0,0,0,2,1,0,1,1,0,1,2,2,2,1,0,0,0,2,0,0,0,2,1,0,1,2,1,2,0,0,2,0,0,7,7,7,7,7,7,1,1,1,2,0,0,0,1,0,1,2,0,1,0,1,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,1,1,0,0,0,0,2,0,2,0,0,1,0,2,1,2,0,0,0,0,2,0,0,0,2,2,1,0,0,0,1,2,0,1,0,2,1,2,0,2,0,0,0,2,0,0,2,0,0,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,0,0,2,2,2,1,0,2,0,2,0,2,0,1,1,1,2,1,0,0,0,0,0,2,0,1,1,0,0,1,0,0,0,2,0,0,0,0,2,0,2,0,1,2,2,0,1,2,0,0,0,0,1,1,0,1,0,0,0,0,1,1,2,2,0,0,2,0,0,0,2,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,0,1,1,2,0,0,2,0,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,0,0,0,1,2,0,2,0,1,0,2,0,1,0,0,0,2,0,0,0,0,2,0,1,6,6,6,6,6,6,5,2,6,2,2,2,0,0,2,0,0,1,1,0,2,2,1,0,0,1,1,1,0,0,0,1,0,7,7,7,7,7,0,7,7,7,1,0,2,0,1,0,0,0,2,0,0,1,0,1,0,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,1,1,1,2,0,2,1,1,2,1,0,0,0,1,0,0,1,0,1,2,2,0,1,0,0,2,0,0,0,0,0,0,1,2,1,2,2,2,0,0,2,2,0,0,0,1,2,0,2,0,0,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,2,1,2,0,0,2,1,0,1,1,0,0,0,2,0,1,0,2,2,0,2,1,1,0,0,2,1,1,2,0,0,0,2,0,0,0,0,1,1,0,0,2,2,1,2,1,0,0,0,1,0,2,0,0,1,0,0,0,2,0,0,0,0,0,0,0,2,2,0,1,2,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,1,1,1,7,7,1,1,1,1,1,7,7,7,7,1,1,2,0,0,2,0,1,1,1,2,0,0,0,1,1,1,1,1,0,2,0,0,1,0,0,2,6,0,5,5,2,5,2,0,6,6,0,0,1,1,0,1,0,2,0,1,2,0,1,2,1,1,1,1,1,1,1,0,0,7,7,7,1,0,0,2,7,7,0,0,2,2,0,2,1,1,2,2,0,2,1,2,0,2,0,1,2,2,2,2,2,2,2,2,2,2,0,0,0,0,1,0,1,0,0,0,0,0,0,2,2,2,1,0,0,2,0,2,2,0,0,0,0,1,0,0,1,2,0,1,2,1,0,0,1,2,0,1,0,2,0,1,0,1,0,0,0,0,2,2,1,0,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,1,0,1,1,2,1,0,2,2,1,0,2,0,0,0,1,1,0,0,2,0,0,0,0,0,0,2,1,0,2,0,0,0,1,2,1,1,2,2,0,2,0,0,1,1,1,0,2,1,2,1,0,2,1,0,1,1,2,1,2,2,0,0,0,0,0,2,2,2,0,0,1,0,0,2,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,0,1,0,1,2,2,1,1,7,7,7,7,1,1,1,1,1,7,7,1,1,1,2,0,0,2,2,0,2,1,0,2,2,0,1,0,2,2,0,1,1,2,0,2,1,0,0,2,1,5,5,2,5,5,0,4,4,6,6,0,2,2,2,1,2,0,7,7,7,2,0,1,1,1,1,1,1,1,1,1,2,7,7,7,1,0,0,2,7,7,0,1,2,1,0,0,1,2,0,0,2,0,1,1,0,0,1,1,2,2,2,2,2,2,0,2,0,0,2,0,2,2,0,2,0,1,2,1,0,1,1,0,2,2,0,2,0,0,0,0,1,0,0,0,0,1,2,0,0,0,0,0,1,2,1,0,0,0,0,2,2,0,1,0,1,2,2,0,0,0,0,0,0,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,1,0,2,0,2,1,1,2,0,1,0,1,1,1,1,2,2,1,2,0,0,2,0,2,1,0,1,2,1,1,1,0,2,1,0,0,2,0,0,0,1,0,1,1,0,2,0,0,0,0,0,1,1,0,2,2,0,2,1,0,0,2,1,0,0,2,2,1,0,0,0,0,0,1,0,1,2,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,2,2,0,1,0,0,0,2,7,7,7,7,7,7,1,1,1,1,1,1,7,7,1,1,1,0,1,2,0,1,0,2,0,2,0,2,1,1,0,0,1,2,2,0,2,0,2,2,2,1,2,2,5,6,6,5,5,5,4,4,2,6,0,0,2,1,2,7,7,7,7,7,0,1,1,1,1,1,1,1,1,1,1,1,0,0,2,2,0,2,1,1,0,1,1,1,0,0,0,2,2,1,2,2,2,0,0,0,2,0,2,2,2,2,2,2,2,2,0,0,2,0,1,2,1,1,1,1,1,0,1,0,0,0,2,1,1,2,2,0,1,0,2,1,1,0,1,0,1,2,1,0,0,2,1,2,2,2,2,0,0,0,2,1,0,0,1,0,0,2,0,2,0,0,1,1,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,2,0,0,1,1,2,2,2,2,2,0,0,0,0,0,2,0,0,2,2,0,0,2,1,1,2,2,2,2,2,0,2,2,0,0,0,1,0,1,1,1,0,0,0,0,2,1,1,0,0,1,0,0,0,0,0,0,0,1,2,2,0,0,1,0,0,0,0,1,2,2,2,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,2,1,0,1,0,0,0,2,0,0,0,7,7,7,7,1,1,1,1,1,1,1,1,7,7,1,1,1,0,2,1,0,0,0,0,1,1,2,2,2,1,0,0,0,2,2,0,1,2,0,2,1,0,2,1,6,0,0,5,5,4,4,0,4,4,2,2,2,0,0,7,7,7,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,0,0,0,0,0,0,1,2,0,0,2,2,0,0,1,0,2,2,1,2,0,0,1,2,2,2,2,2,2,2,2,2,0,1,0,0,1,1,1,1,1,1,2,1,1,1,0,1,0,2,0,2,0,1,1,1,0,2,1,2,0,2,2,0,0,0,0,2,0,0,2,2,2,0,0,0,2,0,1,0,1,0,1,2,2,2,1,0,1,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,1,0,1,0,0,0,0,0,1,0,2,2,0,2,2,0,0,1,0,0,0,1,0,1,0,0,0,2,2,1,0,2,0,0,0,0,2,0,2,2,0,2,2,0,2,0,1,0,0,1,2,1,0,2,2,1,0,0,2,2,0,2,2,0,2,2,2,0,0,0,2,1,0,0,2,0,0,2,0,2,1,1,1,1,1,1,1,0,0,0,1,2,0,1,0,1,0,2,0,0,0,7,7,7,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,2,0,0,0,0,1,0,0,0,2,1,0,2,0,0,1,1,1,1,0,1,0,2,1,6,2,0,2,1,0,0,1,6,4,0,2,2,2,7,7,7,0,0,0,1,8,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,1,1,0,1,0,1,2,0,1,1,1,1,0,1,1,1,1,1,1,2,2,2,2,2,2,2,2,0,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,1,0,0,0,1,0,0,2,1,0,1,1,0,0,0,1,2,0,2,2,1,2,1,0,2,0,1,2,1,1,0,2,1,0,0,0,2,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,0,0,0,0,2,0,0,2,1,1,0,0,1,2,2,1,0,0,0,0,0,0,0,2,2,0,1,0,0,1,2,1,0,1,0,0,1,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0,0,2,0,0,0,1,2,0,2,2,1,0,0,2,2,0,2,2,0,0,0,1,0,0,2,2,0,0,0,1,2,2,2,0,1,0,0,1,2,1,2,0,0,1,0,0,2,2,1,7,7,0,2,0,1,1,2,1,1,1,1,1,2,0,2,0,0,0,2,1,1,2,1,1,1,2,1,0,0,2,1,0,0,0,0,0,0,1,2,0,2,0,1,0,1,1,1,2,6,6,2,2,0,0,0,7,7,1,8,8,8,8,8,1,2,2,2,2,2,1,1,1,1,1,1,2,1,1,0,1,0,0,0,0,1,2,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,1,0,0,2,1,1,1,1,1,1,1,1,1,1,1,4,4,0,1,0,1,2,0,0,0,0,0,2,2,1,0,0,0,0,0,0,0,0,1,0,2,1,1,0,0,1,1,0,1,1,0,1,2,0,1,2,1,0,0,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,0,0,2,2,2,0,2,2,0,2,0,0,0,0,2,2,1,2,0,2,0,2,1,0,1,2,2,1,0,0,0,0,0,0,2,2,1,1,1,0,0,0,0,0,1,2,1,2,0,0,0,0,2,0,0,2,0,0,1,1,0,1,0,0,2,2,0,1,0,0,1,2,0,2,1,0,0,1,0,2,0,0,0,1,0,0,2,0,2,0,1,1,0,0,1,0,0,1,0,2,2,1,0,0,1,0,0,1,2,0,1,0,1,0,2,0,0,0,0,2,2,0,1,0,0,0,2,0,1,0,0,2,0,2,0,1,2,2,1,2,0,0,1,2,2,0,1,0,0,2,0,0,0,1,0,1,2,0,1,1,8,0,8,1,8,8,8,8,2,2,2,1,1,1,1,0,1,1,1,2,1,0,0,0,2,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,0,0,1,0,1,1,1,1,1,1,1,6,6,6,4,4,4,4,1,1,0,0,0,1,2,1,2,0,1,2,2,0,0,0,1,0,0,0,0,0,0,2,0,1,1,2,2,0,0,0,2,2,1,1,1,1,0,2,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,0,1,0,0,2,0,2,0,1,0,0,0,1,0,1,2,0,0,0,1,2,0,0,0,2,1,0,0,0,0,0,1,0,0,1,1,1,1,1,1,2,2,0,0,0,1,0,2,2,1,2,0,2,0,0,2,0,0,2,1,0,0,1,0,0,0,2,1,0,1,1,0,2,0,1,0,0,1,0,1,2,2,2,0,2,1,0,1,0,1,0,0,0,2,0,2,0,0,2,1,0,0,0,0,2,0,0,1,0,1,0,0,1,0,0,0,2,0,1,1,0,0,0,0,2,1,2,1,1,0,2,2,1,0,0,1,1,0,0,0,2,2,2,1,0,2,2,2,0,2,1,1,0,1,1,1,1,2,2,2,8,8,8,8,8,1,8,2,2,2,2,1,1,1,2,0,2,0,0,1,2,0,2,0,0,0,0,0,1,1,1,1,1,1,1,1,6,6,6,2,2,2,2,2,2,2,2,2,2,1,0,1,0,0,0,1,1,1,6,6,6,1,4,4,4,4,4,0,0,2,0,0,2,1,0,0,0,0,2,2,2,2,0,0,0,1,0,1,0,0,0,0,1,1,0,1,2,0,2,0,0,0,0,0,2,2,0,0,2,0,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,0,0,0,1,0,0,0,0,0,1,1,2,0,0,0,2,2,1,1,1,0,1,0,0,2,0,1,2,0,1,1,0,2,0,0,1,1,1,1,1,1,1,0,0,0,1,2,1,1,0,0,2,2,2,0,0,0,0,0,0,2,2,2,1,0,1,0,0,1,1,1,1,1,2,0,1,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,1,2,0,0,0,0,1,2,2,2,2,0,0,1,2,1,2,0,2,0,0,0,0,0,1,2,0,0,0,1,1,0,1,0,0,2,2,2,0,0,0,0,0,0,0,0,2,1,1,2,0,0,0,1,2,2,0,1,2,0,0,9,9,9,1,1,1,8,2,2,2,2,2,2,0,2,0,0,1,1,1,0,1,0,1,1,2,2,1,0,2,0,0,1,1,1,1,1,1,5,5,6,6,2,2,2,2,2,2,2,2,2,0,0,0,2,1,0,0,1,1,4,4,4,4,4,4,4,5,1,2,0,2,1,0,0,1,1,2,1,0,2,0,0,1,0,0,0,1,1,2,2,0,1,0,1,2,0,2,0,0,1,0,0,0,0,0,0,1,2,0,0,1,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,1,0,2,2,1,0,2,1,2,2,1,0,0,0,2,0,0,2,2,2,0,0,0,0,2,1,0,0,0,0,1,2,2,0,1,1,1,1,1,1,1,1,0,1,1,0,0,0,0,0,1,0,1,1,1,2,1,2,2,1,2,2,2,2,2,2,0,0,2,1,0,0,0,0,0,0,2,1,2,1,1,1,0,1,2,2,1,0,1,2,0,0,1,2,2,0,1,0,1,0,0,1,2,2,0,1,0,0,2,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,2,2,0,0,1,0,1,0,0,2,2,2,0,2,2,0,1,2,1,2,1,0,1,2,0,0,1,0,0,0,0,2,2,0,0,9,9,9,1,1,2,2,2,2,2,2,2,1,0,1,1,2,0,2,0,1,2,2,0,1,1,0,1,0,1,1,2,1,1,4,1,1,5,5,5,2,2,2,2,2,2,2,1,0,2,1,1,1,1,2,0,0,2,0,1,1,4,4,4,4,1,5,5,5,2,1,2,1,1,0,1,0,2,0,0,0,1,1,0,0,1,2,0,2,1,0,2,2,0,1,1,2,0,0,0,2,1,2,0,2,2,2,0,0,1,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,2,2,0,2,2,2,1,2,1,0,0,1,1,2,0,2,0,0,0,2,0,0,0,0,2,2,0,0,1,2,2,0,0,2,1,1,1,1,1,1,1,1,0,0,1,2,0,1,0,0,2,0,0,1,1,7,7,7,7,0,1,0,2,1,0,0,0,0,2,1,0,2,0,0,0,0,2,1,0,1,0,0,0,1,1,1,0,2,0,0,0,0,2,2,1,1,1,1,0,0,1,2,0,1,2,0,0,0,2,2,2,1,2,1,0,1,0,0,2,0,0,1,1,0,2,0,2,2,1,1,0,1,0,0,2,0,0,2,0,2,0,2,1,2,0,2,1,2,0,0,0,1,0,1,0,0,2,2,9,9,9,9,9,1,2,2,2,2,2,2,1,2,1,0,2,2,0,0,0,0,2,0,1,1,1,1,1,2,0,0,2,2,4,4,4,5,5,5,5,5,2,2,2,2,2,0,0,2,0,1,0,0,2,2,0,0,0,1,0,1,1,1,4,5,5,5,5,5,0,0,0,1,0,1,0,1,1,1,0,0,2,1,0,1,0,2,0,0,2,1,2,0,2,0,0,1,0,0,1,0,2,0,0,1,2,0,1,0,1,0,0,2,2,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,0,2,2,0,1,0,0,2,0,0,2,0,0,2,0,0,1,2,0,0,1,0,2,2,0,1,2,0,1,2,0,0,0,1,1,1,1,1,1,1,0,2,1,0,2,2,1,1,2,2,0,1,7,7,7,7,7,7,7,7,0,2,1,1,1,1,1,0,0,0,1,0,2,0,1,2,1,1,1,0,1,1,2,0,1,1,2,2,1,1,2,1,1,1,1,1,1,2,0,0,1,0,2,1,1,2,0,0,0,0,0,2,0,1,2,1,0,0,1,0,0,1,1,2,2,0,1,0,0,2,2,0,0,2,0,0,0,0,2,0,1,0,1,0,0,2,0,0,1,0,1,2,1,1,2,2,2,2,0,2,1,1,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,1,0,0,2,0,1,1,0,2,0,2,1,0,1,4,4,4,4,5,5,5,2,2,2,2,2,0,2,2,2,0,0,1,1,2,0,2,1,2,2,1,1,1,1,5,5,5,5,5,5,1,0,2,0,0,0,0,2,0,0,0,0,0,2,2,2,0,1,0,2,0,0,0,0,1,1,0,0,0,2,0,2,1,0,1,2,0,0,2,0,1,0,2,1,0,0,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,0,0,0,0,1,2,2,1,2,1,2,0,2,0,0,1,0,2,1,1,0,2,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,0,2,0,2,0,0,2,0,2,0,0,7,7,7,7,0,7,7,7,1,1,1,1,1,1,1,1,0,1,1,0,1,0,2,2,1,1,0,0,0,0,0,0,0,2,1,1,2,2,0,1,1,1,1,1,1,1,1,0,0,1,1,2,1,0,1,0,0,1,2,2,2,0,2,0,2,0,0,2,0,1,0,2,0,0,0,2,0,1,2,0,0,0,2,2,2,2,1,0,0,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,2,2,1,2,0,0,0,2,0,0,0,0,1,1,1,0,0,1,2,0,1,4,4,4,4,1,1,1,1,0,0,2,2,2,0,0,2,0,2,0,2,2,1,1,1,0,0,0,1,1,1,5,5,5,5,2,0,2,6,0,1,2,2,1,0,0,0,2,1,0,2,1,2,0,2,0,1,0,1,1,0,0,1,0,2,0,2,2,1,0,2,1,2,0,0,2,0,0,1,0,0,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,1,2,0,0,0,0,0,0,0,2,1,2,0,2,0,0,1,1,2,0,0,1,2,0,0,2,0,0,0,1,0,1,2,0,1,1,1,1,1,1,1,1,0,0,0,0,2,0,1,2,0,1,0,2,2,0,2,1,1,7,7,1,1,1,1,1,1,1,1,1,0,0,2,0,0,2,0,2,0,1,0,1,0,0,0,0,1,0,2,2,0,1,1,1,1,1,1,1,1,1,1,2,1,2,2,0,0,0,2,0,2,0,1,0,2,2,0,0,2,0,1,0,0,0,2,1,2,1,0,1,0,2,2,1,0,2,1,2,0,0,0,1,1,1,2,2,2,2,2,2,2,2,2,2,0,0,0,1,1,2,2,2,2,2,2,2,2,2,0,0,1,2,0,0,1,1,0,2,0,0,1,2,2,2,0,0,1,1,1,2,0,0,2,6,6,4,6,6,1,1,2,2,0,1,1,0,1,2,1,1,1,2,1,0,0,1,1,0,1,0,2,0,1,1,6,6,6,6,6,6,6,1,2,0,1,0,1,0,2,0,2,2,0,2,1,0,0,1,0,1,0,0,2,0,0,0,1,0,2,0,0,1,0,1,0,1,0,2,2,0,0,2,0,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,2,0,0,0,0,2,0,1,2,2,0,0,2,0,0,2,0,0,0,1,1,0,2,0,0,0,1,2,0,2,0,0,1,0,0,1,1,1,1,1,0,1,2,0,2,0,0,1,0,0,1,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,0,1,0,2,1,1,2,2,1,2,0,0,2,2,2,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,0,1,0,0,2,2,0,0,0,1,2,2,0,2,0,0,1,2,0,1,2,0,2,0,1,1,0,2,1,2,0,1,2,1,2,2,2,2,2,2,2,2,2,2,1,0,2,0,2,2,2,2,2,2,2,2,2,2,2,0,2,0,1,0,2,2,2,2,0,0,1,0,0,2,2,0,1,2,2,2,0,0,0,1,2,6,6,6,0,2,2,0,1,1,2,1,0,0,0,2,0,2,2,1,0,0,1,2,1,0,0,1,0,1,0,2,0,0,1,0,2,0,1,0,0,1,2,2,1,1,0,0,0,2,1,2,0,0,2,0,0,0,2,0,0,0,1,0,1,0,1,0,0,2,0,0,0,0,0,1,2,0,1,1,2,1,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,0,1,2,0,0,1,2,0,0,2,1,0,1,2,2,0,0,0,0,1,0,2,0,0,1,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,1,2,2,1,0,2,1,0,2,1,2,1,2,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,0,0,2,0,1,0,1,0,0,0,2,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,0,1,0,2,0,0,2,2,0,0,0,1,0,1,1,1,0,1,1,1,2,0,0,1,1,0,0,0,2,2,0,1,0,1,2,1,2,1,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,1,1,0,1,1,0,0,0,0,2,2,0,0,2,2,0,2,1,1,0,1,0,0,0,1,6,6,0,0,0,0,2,0,0,2,2,1,0,0,0,1,0,1,2,1,2,2,2,0,0,1,1,1,0,0,0,0,2,2,2,1,0,0,2,1,2,0,0,0,2,0,0,0,0,0,0,0,0,0,2,1,2,0,1,1,2,2,0,1,0,0,0,1,0,0,0,2,0,0,2,0,1,2,0,2,1,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,1,1,2,0,0,0,0,2,1,0,0,2,0,0,0,1,2,0,2,2,0,2,2,1,2,0,0,2,0,1,0,1,0,1,0,1,2,0,0,2,1,0,1,0,0,0,0,0,1,0,2,0,1,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,0,0,2,2,0,0,0,2,1,1,0,0,0,1,0,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,2,1,0,0,1,0,0,0,1,0,2,2,0,0,0,1,0,1,0,2,2,1,0,0,0,2,0,0,0,1,0,0,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,2,0,1,0,0,2,0,0,2,2,1,1,0,2,2,0,1,1,0,0,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,2,0,1,0,0,2,0,0,0,0,0,0,1,1,2,0,2,2,0,2,0,1,0,1,0,0,0,1,1,1,1,0,2,1,2,10,10,10,10,2,0,0,1,2,2,2,1,0,2,1,1,1,0,1,1,0,2,0,0,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,1,0,1,2,1,2,1,1,0,0,0,2,1,1,0,1,0,0,0,2,1,1,0,1,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,2,0,1,1,1,0,0,1,0,1,2,0,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,0,2,1,1,1,0,0,2,0,0,0,1,2,2,0,1,2,0,1,0,2,2,0,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,1,0,0,0,1,2,0,1,0,2,1,1,0,0,0,11,11,11,0,0,1,0,0,0,0,2,10,10,1,0,2,0,0,2,0,2,2,2,2,2,11,1,0,2,0,0,0,0,0,2,0,0,0,1,1,0,0,1,0,0,1,1,2,2,1,0,2,2,0,1,2,0,2,0,2,1,2,1,1,2,0,0,1,0,0,2,0,0,0,1,2,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,2,0,0,0,1,2,0,1,0,0,1,1,0,2,1,2,2,1,2,1,1,0,0,0,0,0,0,2,2,0,0,0,2,1,0,2,1,1,1,10,10,10,1,0,0,0,0,0,2,0,2,0,2,0,0,0,1,1,2,1,1,0,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,0,0,2,0,2,0,2,1,1,2,0,0,0,2,0,0,0,0,2,1,1,0,2,2,2,0,0,2,0,0,2,0,0,0,2,0,0,0,0,1,0,1,1,2,0,0,0,2,2,0,2,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,1,1,1,0,0,0,0,2,2,1,1,1,2,0,1,1,0,2,1,0,0,0,0,1,1,1,1,1,1,1,1,0,2,2,2,0,1,0,1,1,0,0,0,0,2,1,10,0,1,1,0,2,11,11,11,11,2,2,0,10,10,2,10,10,3,1,2,1,2,2,0,0,0,0,0,0,0,11,11,2,1,2,1,0,0,0,0,1,2,2,0,0,1,2,2,1,1,0,2,2,2,2,1,1,0,0,0,0,1,0,1,0,2,0,0,1,0,2,2,0,0,0,0,1,1,2,2,2,0,0,1,0,1,0,0,0,0,2,2,0,1,0,2,2,2,0,2,2,0,0,2,0,1,2,0,0,2,2,1,1,1,0,1,0,0,0,0,2,1,2,0,0,0,1,1,0,0,2,2,0,1,0,10,1,10,2,0,1,1,1,1,0,0,0,0,2,1,0,0,2,2,0,0,0,2,1,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,2,0,2,0,1,0,0,0,0,2,0,0,0,0,1,1,1,0,2,0,1,0,1,0,0,0,0,0,0,1,1,2,2,1,0,0,0,0,0,0,2,2,1,1,2,0,0,0,2,1,2,0,2,0,1,1,1,1,1,1,0,0,1,0,0,0,0,0,1,0,2,1,1,0,0,2,0,2,0,0,0,0,0,1,2,2,2,0,2,0,1,2,0,0,0,0,1,1,1,1,2,0,0,0,0,2,0,0,1,1,1,0,2,0,0,10,10,1,1,10,1,2,1,11,0,11,11,2,0,10,10,10,10,10,10,0,0,0,0,0,1,0,0,1,1,0,2,1,0,2,0,0,0,0,2,0,1,0,1,0,0,0,2,1,0,0,1,0,0,1,0,1,0,1,2,0,2,0,10,10,10,0,0,2,0,2,0,0,1,0,0,1,0,2,1,0,0,0,0,1,2,0,1,1,0,1,2,1,0,0,1,1,0,1,0,0,1,0,0,0,0,0,0,0,0,1,2,0,0,0,0,0,0,2,0,2,1,0,0,0,1,0,0,2,0,1,1,2,0,1,1,0,0,1,10,10,2,0,2,0,2,2,0,0,0,0,0,2,0,0,0,0,0,0,1,2,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,0,0,0,1,2,1,1,1,0,0,2,0,2,2,0,2,0,1,0,0,0,0,0,0,1,1,0,2,0,0,0,2,0,2,0,2,0,0,1,1,1,2,2,2,0,0,1,0,1,0,0,0,0,7,7,1,1,1,0,2,1,2,0,1,0,0,0,0,0,0,1,1,0,0,2,0,0,1,0,1,1,1,0,0,2,2,2,0,0,2,0,0,0,2,1,1,0,1,0,0,0,1,1,1,1,1,0,0,0,2,0,0,2,10,10,10,1,10,10,10,1,11,11,4,11,11,0,0,10,10,10,10,2,1,0,0,2,0,2,2,1,1,0,0,1,1,2,0,2,0,0,2,1,0,0,2,1,0,2,2,2,2,0,0,1,0,2,1,0,2,1,2,1,1,0,0,10,10,10,10,0,2,0,0,0,0,1,1,0,0,1,0,0,2,0,0,0,1,0,1,2,0,1,0,2,0,2,0,0,2,2,1,0,2,4,6,6,6,6,1,0,2,1,0,0,2,1,2,1,0,2,0,2,0,1,2,0,0,2,0,2,0,2,0,0,0,0,0,1,0,0,0,2,0,10,0,0,2,1,0,2,0,1,0,1,1,1,1,0,2,2,1,0,1,0,1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,0,1,1,0,0,0,0,1,0,2,2,0,2,2,0,2,0,0,1,0,2,0,0,0,0,0,2,0,1,0,0,2,2,0,2,1,2,1,1,2,1,1,1,1,0,2,1,0,1,0,1,1,2,1,1,7,7,7,0,0,2,0,2,0,1,2,0,0,2,1,1,1,1,2,2,0,1,1,1,0,1,1,0,0,0,1,1,0,2,0,0,2,1,0,1,1,2,2,0,0,2,0,1,2,2,0,1,0,0,0,2,2,0,0,0,2,0,10,10,10,10,10,1,11,11,0,2,11,11,11,0,0,2,10,0,1,0,0,0,1,2,1,0,2,2,2,0,1,0,0,1,0,0,0,0,0,0,0,2,2,2,2,0,1,2,2,2,1,0,0,1,1,0,0,1,2,0,10,10,10,10,10,0,0,0,0,0,1,2,0,0,0,0,0,1,0,0,0,0,2,2,0,0,0,2,2,2,0,0,1,0,5,5,5,4,4,6,4,4,4,4,4,4,4,0,1,1,2,0,0,1,0,2,1,0,2,2,2,0,2,0,0,1,1,0,1,1,0,0,0,0,0,0,2,0,1,0,2,2,0,0,1,0,0,1,1,0,0,1,0,0,0,0,1,1,0,2,2,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,2,0,1,2,0,0,0,0,0,2,0,0,0,0,2,0,0,0,0,0,0,0,0,1,0,0,0,0,2,2,0,2,2,2,1,1,1,1,1,1,2,0,1,1,2,2,2,0,2,2,7,7,7,1,0,1,0,0,1,2,0,1,0,2,0,0,2,1,0,2,0,0,1,2,0,0,1,2,0,1,2,1,0,12,12,2,0,2,0,2,0,2,1,1,2,0,0,0,1,2,1,1,2,0,0,0,0,1,1,1,1,0,10,10,3,10,0,2,11,0,2,1,0,2,1,0,2,1,10,0,0,0,0,2,1,0,2,2,1,0,1,2,0,0,0,2,0,0,0,0,0,1,0,2,2,2,2,1,1,2,0,0,1,1,2,0,1,1,0,1,0,0,10,3,0,10,10,0,0,0,1,0,0,1,0,1,2,0,0,0,2,0,2,1,0,2,1,0,1,2,0,0,0,1,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,2,0,0,0,1,2,1,0,2,1,0,0,0,0,1,0,0,0,1,1,0,0,2,1,2,2,0,2,1,1,2,0,0,0,0,2,0,0,2,2,0,0,0,2,0,0,1,1,1,0,2,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,1,0,2,2,2,1,0,2,0,0,2,1,0,0,0,0,0,0,2,2,1,1,0,2,0,0,0,1,0,1,1,1,0,1,0,0,1,0,0,1,1,1,1,1,1,1,2,2,1,2,0,1,0,0,7,7,7,0,1,2,2,2,2,2,0,1,0,0,1,0,2,0,2,0,1,0,1,0,1,1,2,0,2,0,0,11,11,12,12,2,0,1,0,2,0,0,2,2,0,1,0,2,2,0,1,1,0,0,2,0,2,2,2,1,0,0,10,10,10,10,10,0,0,2,0,1,1,0,2,0,1,1,1,0,10,0,2,0,2,0,0,0,0,0,0,1,1,0,2,2,0,0,0,0,0,11,2,2,2,2,2,2,0,1,0,2,0,0,2,2,1,0,1,2,2,0,0,10,10,2,0,0,2,2,2,0,1,1,1,2,0,0,2,0,1,0,2,2,2,0,2,0,2,1,1,1,1,1,6,5,5,5,5,5,4,4,2,0,0,4,4,4,4,4,2,0,1,1,1,0,2,0,2,2,2,1,1,1,1,0,2,2,0,2,1,1,0,0,1,2,1,1,0,2,1,0,1,2,0,0,2,1,1,0,2,0,1,0,0,0,2,0,0,0,0,1,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,1,0,0,2,10,10,1,0,0,2,2,0,1,0,0,0,0,0,0,0,0,2,1,2,0,2,0,1,2,0,0,0,2,1,0,0,1,0,1,1,1,1,1,1,1,1,0,0,2,1,2,2,2,7,7,7,0,0,1,1,1,2,0,0,0,0,0,0,0,0,0,0,2,0,0,2,2,0,0,2,2,1,1,11,11,0,11,11,11,0,0,1,2,0,0,0,2,1,0,0,1,1,2,1,0,2,0,2,1,1,2,0,0,0,2,1,2,1,2,10,0,10,1,2,0,1,1,1,0,1,2,1,0,0,0,1,0,0,0,2,2,1,0,0,0,0,1,0,0,2,0,1,1,0,11,11,2,2,2,2,2,2,0,1,1,1,0,0,1,0,0,2,2,12,0,0,2,10,10,0,0,2,0,0,2,2,2,2,2,2,2,0,1,2,0,1,0,0,0,0,0,0,1,0,2,0,0,6,6,6,5,1,2,0,4,1,6,6,2,2,0,0,0,0,0,2,0,1,0,1,2,2,2,1,1,0,2,0,0,0,1,2,2,2,2,0,0,1,2,0,1,0,0,2,0,1,2,1,0,0,1,1,0,1,0,0,0,1,0,1,0,0,2,2,2,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,1,0,0,0,10,10,10,10,10,10,0,2,1,2,1,1,0,2,0,1,1,0,1,0,0,2,0,0,0,0,0,1,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,7,7,7,0,0,2,0,2,0,0,0,0,0,0,0,0,0,2,0,2,2,0,2,1,2,0,0,0,2,0,2,11,2,0,11,2,2,0,0,2,1,0,1,0,2,0,0,2,0,2,1,0,0,0,0,0,0,1,2,2,0,2,1,1,2,2,10,10,10,10,0,0,2,2,2,0,2,2,2,1,0,0,0,0,0,1,2,0,0,1,0,0,1,0,1,0,0,0,0,1,1,2,2,2,2,2,2,2,2,2,1,1,1,0,0,0,1,0,0,12,12,12,12,2,2,10,1,1,2,0,2,0,2,2,2,2,2,2,2,2,0,1,1,1,2,0,0,0,1,0,2,2,0,0,6,6,5,5,6,6,6,6,6,6,0,0,2,2,0,2,0,1,0,0,2,2,2,2,0,0,0,0,1,0,1,0,2,0,2,0,0,0,0,1,2,0,0,0,0,2,0,1,2,2,1,2,2,1,2,0,1,0,1,0,0,1,1,0,2,0,0,2,0,2,2,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,1,2,0,10,10,10,1,10,10,10,10,2,1,0,0,1,0,0,0,1,1,0,2,0,0,2,1,0,0,1,2,0,2,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,2,1,1,7,7,7,0,1,2,0,2,1,0,1,0,0,1,1,2,0,0,0,0,1,2,1,0,0,2,2,0,0,0,1,0,1,2,0,0,2,1,2,0,0,2,2,0,1,12,12,12,2,0,0,0,0,0,1,1,0,0,0,1,0,1,2,1,2,2,0,0,10,10,1,0,0,0,0,2,0,0,2,0,2,1,0,1,1,0,0,2,2,0,0,0,1,1,2,1,2,1,1,1,0,1,0,2,2,2,2,2,2,2,2,1,0,0,0,0,0,2,2,0,2,12,12,12,12,12,10,10,0,0,2,2,2,2,2,2,2,2,2,2,0,1,1,1,1,1,0,0,0,0,2,1,0,0,0,6,1,0,2,0,0,0,0,0,0,2,2,0,0,1,1,0,0,2,1,0,0,1,0,0,0,0,0,0,0,1,1,0,0,1,0,0,1,0,0,1,1,0,0,0,0,0,0,1,0,0,2,2,2,1,1,0,0,0,2,1,0,0,0,2,1,0,0,0,1,2,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,2,1,0,10,2,2,2,0,1,10,2,0,2,0,0,2,0,0,1,0,0,0,0,1,0,0,2,2,0,0,1,0,1,1,0,1,1,1,1,1,1,1,1,1,1,0,2,1,0,0,0,7,7,0,0,2,1,0,1,1,0,2,1,0,0,2,0,0,0,0,1,0,1,1,0,2,0,0,0,2,1,0,1,0,0,0,1,1,1,0,1,0,1,1,0,1,12,12,0,2,0,0,0,0,2,2,2,1,2,0,0,2,0,0,2,2,1,0,1,0,0,0,0,0,1,2,1,0,0,2,1,2,0,1,0,2,1,0,1,0,0,2,2,0,0,0,1,0,0,0,1,2,2,0,2,2,2,2,2,2,2,10,10,10,0,0,2,0,0,1,2,2,0,12,12,1,10,10,10,0,0,0,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,0,1,2,1,0,2,1,0,0,1,0,1,1,0,1,0,2,0,0,0,0,0,1,0,2,1,2,0,0,1,0,0,0,0,0,1,0,0,2,2,0,0,1,0,2,2,0,2,0,1,2,0,1,0,0,0,0,1,1,0,0,1,1,2,1,0,1,0,2,0,0,0,0,0,2,2,0,0,2,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,0,1,11,11,0,1,2,10,10,10,0,0,0,0,1,1,0,0,0,0,1,1,1,0,2,2,1,0,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,7,7,7,1,0,2,0,1,1,0,0,0,2,0,0,1,0,1,0,2,0,2,2,0,0,1,0,1,2,2,0,0,1,0,2,0,0,1,0,0,2,0,2,2,2,1,12,12,1,1,0,0,0,2,2,1,0,1,1,0,0,1,0,0,0,1,2,2,1,2,2,0,2,0,2,1,0,0,2,0,0,0,0,1,2,1,0,2,0,1,0,0,2,0,1,0,0,0,0,0,0,0,0,1,2,2,2,2,2,0,1,10,10,10,10,0,10,10,2,0,0,7,7,12,12,2,10,10,10,2,2,2,2,2,2,2,2,9,9,9,9,1,1,1,1,1,1,1,1,1,0,2,2,0,0,1,0,0,0,2,2,1,0,1,0,0,2,2,0,0,1,0,0,0,0,0,2,1,1,1,2,1,2,0,2,0,2,1,0,2,0,0,0,2,1,2,1,1,0,2,0,0,1,1,1,1,2,0,2,2,2,0,2,1,1,1,1,0,1,0,0,0,2,0,0,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,0,2,10,10,0,1,2,10,0,0,1,1,2,0,2,0,2,0,0,2,0,0,2,0,2,2,1,2,0,0,2,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,2,7,7,7,1,1,2,0,0,2,0,1,1,0,0,0,1,0,2,2,2,2,0,0,0,0,2,2,0,0,2,1,2,0,1,1,1,0,0,1,1,0,0,0,0,2,1,1,0,2,0,1,1,0,0,1,1,1,0,1,1,0,0,2,1,1,0,2,1,2,2,0,2,0,1,0,2,1,0,2,1,1,2,0,0,0,0,0,2,2,2,2,2,2,0,0,1,2,2,1,0,2,0,2,0,1,2,1,0,0,0,0,2,12,12,10,2,2,2,2,2,0,1,7,7,0,10,10,2,1,2,2,2,2,2,2,2,2,9,9,1,8,8,8,1,1,1,1,1,1,2,2,0,0,2,1,0,1,0,2,2,1,1,0,0,2,0,0,1,0,0,0,0,2,2,0,2,1,0,0,0,0,0,1,2,1,0,0,0,2,2,1,2,1,1,1,2,0,0,0,1,2,1,2,2,1,0,0,0,2,1,1,0,0,1,2,2,1,0,1,2,0,1,0,0,1,2,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,0,2,2,10,10,11,11,0,12,2,0,2,0,0,0,0,0,0,1,1,2,2,2,1,1,2,0,0,2,2,2,1,1,0,1,1,1,1,1,1,1,1,1,1,1,2,1,1,2,1,7,7,1,0,0,2,0,1,0,0,0,0,0,0,2,2,0,1,1,2,0,2,2,0,0,0,0,2,0,0,0,0,0,1,0,0,0,2,1,2,1,2,0,0,1,0,1,1,0,0,0,0,0,0,0,2,0,1,1,0,0,1,0,0,2,1,1,1,0,0,1,0,0,1,2,2,1,1,2,2,1,2,0,1,2,0,1,2,2,2,2,2,2,1,1,0,1,2,0,2,2,1,0,0,2,2,1,2,1,0,1,0,0,12,2,2,2,2,2,0,9,0,0,0,10,10,1,2,2,2,2,2,2,2,2,2,2,9,9,2,8,8,8,8,8,1,1,1,0,1,2,0,1,0,0,0,2,0,1,0,1,0,1,0,0,0,0,1,2,0,2,2,0,1,1,0,1,1,0,1,1,0,1,2,1,2,0,0,2,2,2,0,0,0,1,0,2,1,1,0,1,0,1,1,1,0,1,1,1,0,2,0,2,0,0,0,0,2,2,2,1,0,2,1,0,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,2,10,2,11,11,0,12,1,0,1,0,0,2,0,1,2,0,1,2,0,2,2,1,2,0,2,2,2,2,1,2,0,2,1,1,1,1,1,1,1,1,0,0,0,0,0,1,0,0,0,2,2,0,0,1,0,0,0,1,0,2,2,0,2,2,0,0,2,0,1,2,0,0,1,0,0,1,1,0,1,0,0,0,1,0,0,2,0,1,2,0,2,0,0,0,1,1,1,0,0,2,1,0,0,0,0,2,2,2,0,0,0,2,1,1,0,0,0,2,0,1,0,1,0,1,1,2,1,2,0,2,0,0,2,2,2,2,2,2,2,2,0,1,2,0,0,0,0,1,2,2,0,2,1,0,2,2,2,0,2,0,12,2,2,2,2,2,9,2,10,10,10,10,1,0,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,1,1,1,1,1,0,0,0,2,1,2,2,1,1,0,2,2,0,0,1,0,0,1,2,0,2,1,2,1,0,2,0,0,0,0,2,0,2,0,1,1,2,0,0,2,1,1,1,0,2,0,1,1,0,0,0,0,0,2,1,0,0,0,0,0,1,1,0,1,0,2,0,0,0,0,1,2,2,2,0,1,1,1,1,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,2,1,0,10,10,11,1,12,12,0,0,1,0,0,2,0,0,2,1,2,1,0,0,1,0,1,2,0,0,1,0,0,0,2,0,0,1,1,1,1,0,1,1,1,0,1,0,0,1,1,0,0,0,0,0,0,0,2,0,2,0,0,2,0,1,1,1,1,1,0,1,0,1,0,0,2,0,0,0,2,0,0,2,2,0,0,0,0,0,0,0,1,2,1,0,0,1,1,0,0,2,0,1,2,0,0,2,2,0,1,2,1,0,1,2,0,12,12,12,12,1,1,0,0,2,0,0,0,2,1,0,1,0,0,2,2,2,2,2,2,2,2,2,0,0,1,0,1,2,1,1,1,0,1,1,0,1,1,0,0,2,1,0,2,2,2,2,2,9,10,10,12,12,12,0,2,0,2,2,2,2,2,2,2,1,1,1,2,2,2,2,2,1,1,1,1,2,0,2,2,0,0,2,0,0,0,0,0,1,2,1,0,0,1,2,0,1,0,0,1,0,1,0,2,1,0,0,0,2,1,1,0,2,1,1,0,2,2,2,0,0,0,1,1,1,0,0,0,0,1,0,0,0,0,2,2,0,1,0,2,0,0,0,1,1,0,0,1,0,0,1,1,2,0,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,1,2,10,10,10,12,12,2,0,0,2,0,2,1,0,0,0,0,0,2,0,1,2,0,0,0,1,0,2,0,2,0,2,1,1,2,0,1,0,0,1,1,0,0,0,1,0,2,1,1,0,1,2,2,0,2,2,0,2,1,0,2,2,2,0,0,1,1,1,0,1,0,1,2,1,2,0,0,1,0,1,1,0,2,0,0,0,0,0,0,0,1,2,0,0,0,0,1,1,1,0,0,1,1,0,2,0,0,2,0,2,2,0,1,2,12,12,12,12,12,0,1,0,0,0,0,0,0,1,0,2,0,0,2,2,2,2,2,2,2,2,1,0,1,2,1,2,1,2,0,2,1,2,2,1,2,1,0,1,2,1,2,2,2,2,2,2,9,10,10,3,11,0,1,1,2,2,2,2,2,2,1,1,1,1,1,2,2,2,2,2,0,0,0,2,2,0,0,1,2,1,1,0,0,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,2,0,2,0,1,1,0,2,2,0,0,0,0,2,2,1,0,0,0,0,1,0,1,1,0,0,2,2,0,2,0,2,0,0,2,0,2,1,1,2,2,0,0,1,0,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,1,0,10,2,10,2,0,2,0,0,0,1,2,0,2,2,2,0,0,0,1,0,0,0,1,0,2,1,2,0,0,2,0,0,2,2,0,0,1,0,0,0,0,2,0,2,0,1,2,0,0,1,0,1,2,1,0,2,0,2,0,0,0,1,0,0,0,0,0,0,0,0,2,2,0,1,0,0,1,2,2,0,0,0,0,0,0,0,0,1,1,2,1,1,0,1,0,2,0,0,1,1,2,0,1,0,1,1,0,1,0,0,0,1,2,0,0,0,12,12,4,1,1,0,0,1,0,0,0,0,1,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,2,1,0,2,2,0,1,1,0,0,0,0,2,2,2,2,2,2,2,6,9,11,11,3,11,11,12,2,2,0,2,0,1,1,2,2,1,1,1,1,1,1,1,1,0,0,1,0,0,0,0,2,0,2,1,0,1,0,0,0,0,2,2,1,1,0,0,0,0,2,0,2,0,1,2,0,2,0,0,1,1,0,1,1,0,1,2,0,0,0,2,1,2,0,1,0,0,1,1,2,1,1,0,0,0,0,2,1,2,2,0,2,0,0,0,2,0,0,0,1,1,0,2,0,0,0,0,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,2,2,1,1,1,0,0,0,1,1,0,2,0,1,0,2,0,1,2,0,1,0,2,0,0,0,1,2,2,0,2,0,0,0,1,2,0,0,2,2,0,0,2,0,2,1,2,0,0,0,2,1,1,0,0,0,0,1,0,0,2,2,0,1,2,0,1,0,0,0,1,2,0,0,0,0,0,0,0,1,0,0,2,1,2,1,0,1,1,1,0,0,2,1,0,1,2,0,0,1,0,2,0,0,0,1,1,0,0,0,2,2,0,0,0,1,2,2,0,2,12,12,12,0,2,0,2,0,2,0,0,0,2,2,2,2,2,2,2,2,0,2,0,2,0,0,2,2,0,1,0,1,0,2,1,2,0,0,0,1,2,2,2,2,2,2,6,9,0,11,11,11,11,12,0,1,2,1,0,1,0,1,0,1,1,1,1,2,1,0,0,0,0,2,2,1,1,0,0,2,0,1,1,2,0,1,1,0,2,0,0,1,1,0,0,0,1,2,0,1,2,2,0,1,0,0,0,2,0,1,0,0,1,0,0,0,0,2,0,0,0,0,2,0,2,2,0,0,0,1,1,2,0,0,0,0,13,13,0,0,2,0,1,1,0,1,1,0,2,0,1,1,1,2,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,2,2,0,0,2,0,2,2,0,0,1,0,0,0,1,1,0,1,1,1,1,2,0,2,0,0,1,0,2,0,1,2,2,2,0,2,1,0,1,2,2,0,2,0,2,0,0,0,1,2,2,1,2,2,1,1,1,1,2,2,1,2,0,0,1,0,0,2,0,1,1,0,1,2,0,1,0,1,0,1,1,0,1,0,0,0,1,2,1,0,2,1,1,2,0,0,1,2,0,1,0,0,0,0,0,2,0,0,1,0,0,1,0,1,0,0,2,1,0,1,1,1,1,0,0,0,2,0,2,0,2,0,2,2,2,2,2,2,7,7,7,7,2,0,2,1,1,1,0,0,0,0,2,2,1,2,2,0,2,2,2,2,2,2,2,6,2,9,0,0,0,0,11,11,1,1,2,1,1,0,1,1,0,0,2,0,0,1,1,0,1,0,1,0,0,0,0,0,2,2,2,1,0,0,0,1,2,0,2,2,1,0,0,0,0,1,0,0,1,0,1,2,1,2,0,2,0,0,1,1,1,0,1,0,1,0,1,1,0,1,2,0,0,1,2,2,0,0,1,1,1,1,0,0,13,13,13,13,2,2,0,0,0,0,0,0,2,0,2,2,0,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,1,1,2,0,0,2,0,0,0,0,1,0,0,2,0,2,2,2,1,1,1,2,2,2,2,2,0,1,2,0,0,2,0,0,0,0,0,2,2,2,0,0,0,0,2,1,0,1,2,0,1,0,2,0,1,1,2,0,0,0,1,1,0,0,2,1,0,0,0,0,1,1,0,0,2,0,2,0,1,1,0,2,0,2,0,2,0,1,0,2,0,1,1,0,1,0,1,2,0,0,2,0,0,2,1,1,2,2,1,0,0,1,2,2,0,0,0,1,2,0,0,2,2,0,0,0,0,1,2,1,0,0,2,2,2,2,2,1,7,7,7,7,0,0,0,0,2,0,0,0,0,0,1,1,1,0,0,0,1,2,2,2,2,2,2,6,6,1,0,2,12,2,0,11,2,2,0,0,0,0,1,2,1,1,2,1,1,2,1,1,0,1,1,2,0,0,0,0,0,0,0,0,2,1,2,0,0,0,1,1,0,1,1,0,2,2,0,1,1,0,0,1,1,0,2,1,0,0,0,2,0,2,0,2,0,0,2,1,0,1,0,1,2,0,2,1,0,2,0,13,13,0,1,13,13,13,1,3,3,3,1,2,0,0,2,0,1,1,1,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,2,2,2,0,2,0,1,2,0,1,2,0,0,0,2,0,2,2,1,2,1,0,0,0,0,2,0,2,0,2,0,0,0,1,0,0,0,0,1,1,0,1,0,1,0,0,0,2,2,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,2,2,2,0,2,0,0,2,2,0,0,1,1,2,0,0,1,1,0,1,2,2,1,0,0,0,2,0,0,1,2,1,2,2,0,1,1,2,0,0,1,1,0,0,0,2,2,1,2,2,0,0,2,0,1,1,1,1,0,1,0,0,1,2,0,0,1,0,0,0,1,1,1,7,7,7,7,7,0,1,2,0,1,0,1,2,2,0,0,2,1,2,1,2,2,2,2,2,2,2,2,1,6,0,2,12,2,11,11,11,0,0,2,2,0,0,0,2,2,0,0,1,0,0,0,1,2,1,1,0,0,0,0,0,0,0,1,1,1,0,1,0,1,0,0,0,1,0,1,0,2,0,0,1,1,2,0,2,1,0,0,0,0,0,2,0,0,0,0,1,0,0,1,2,0,1,1,0,0,0,1,1,13,13,13,13,13,2,0,13,13,1,3,3,3,3,3,3,3,0,0,0,2,0,2,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,0,0,0,0,2,1,1,0,0,1,0,0,1,2,2,1,0,0,2,2,1,1,0,1,0,0,0,0,2,0,0,0,1,0,1,2,0,2,0,1,0,0,2,0,2,0,1,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,1,1,0,1,0,2,1,1,10,10,10,1,0,2,1,0,2,0,2,2,0,1,1,1,2,2,0,1,0,2,0,0,2,0,2,0,1,0,1,2,2,0,1,0,1,1,0,2,1,0,0,1,1,1,2,2,1,0,1,0,2,1,0,0,0,1,0,1,0,0,1,1,1,1,7,7,1,7,7,2,2,2,1,0,0,0,1,1,2,2,1,1,2,0,0,2,2,2,2,2,2,0,2,6,0,0,2,12,12,11,0,0,0,1,0,0,0,2,2,2,0,2,2,1,1,1,1,1,2,1,0,0,0,0,1,2,1,0,0,2,0,0,0,0,0,0,2,0,1,2,2,0,1,1,1,0,2,1,1,1,0,1,2,1,1,0,0,0,2,0,0,2,2,0,0,1,2,2,2,2,1,1,0,13,13,13,0,0,3,3,3,3,3,3,3,3,3,2,0,0,2,2,0,1,0,0,0,2,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,2,2,0,0,1,0,1,1,0,1,0,0,0,2,1,0,0,0,1,2,0,0,2,2,0,0,0,2,1,0,0,0,1,1,1,0,1,2,0,0,1,0,0,0,0,2,1,1,2,0,0,2,0,0,0,2,1,2,0,0,0,10,10,2,0,0,1,0,0,10,10,10,10,10,10,0,1,0,0,0,0,0,2,2,2,1,0,2,0,0,1,0,0,0,0,2,0,0,2,1,1,1,1,0,2,0,0,0,0,2,0,1,2,2,0,0,2,2,0,1,1,1,2,0,1,2,1,2,2,2,2,2,2,0,1,1,1,1,1,1,1,1,2,0,2,0,0,0,1,0,2,1,1,1,1,1,0,2,2,2,2,2,2,2,1,0,2,2,0,0,0,0,11,2,2,0,2,0,2,0,1,0,0,0,1,2,0,1,2,0,0,0,2,1,0,1,0,0,1,2,0,0,2,0,0,1,1,1,0,0,0,2,2,2,2,0,1,1,0,0,2,1,0,1,0,0,0,2,2,2,0,0,0,0,2,2,2,1,1,0,2,1,0,1,0,1,0,1,0,3,3,3,3,3,3,3,3,1,0,1,2,1,2,2,0,2,1,0,2,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,2,1,2,1,0,0,2,1,0,2,0,1,1,0,0,0,0,0,0,0,0,0,2,2,2,2,2,1,1,2,2,2,0,2,0,0,0,0,0,2,0,2,0,1,0,0,1,2,0,1,1,0,1,0,0,1,0,0,0,1,10,10,10,2,1,2,1,2,10,10,10,0,10,10,10,10,2,1,0,1,1,0,1,2,1,1,1,1,0,0,0,1,0,0,0,1,0,0,1,2,0,0,1,0,1,1,1,1,1,0,0,0,2,2,2,0,0,0,1,1,1,2,0,2,2,2,2,0,0,0,2,2,0,0,1,1,1,1,1,1,1,2,0,2,0,0,1,2,1,2,1,2,2,2,1,1,1,0,2,2,2,2,2,2,2,0,0,2,0,1,1,0,11,11,11,2,0,0,0,1,0,0,11,11,11,11,11,2,0,0,0,0,2,2,2,2,2,0,2,1,2,2,0,0,0,0,2,0,1,1,0,0,0,1,2,1,0,2,0,1,0,2,0,2,2,2,1,0,1,1,0,1,0,0,2,0,0,0,0,0,0,0,2,1,2,0,0,3,3,3,3,3,3,3,3,3,0,1,0,1,0,1,2,0,0,0,0,0,2,1,1,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,0,1,1,0,0,1,0,2,0,0,1,0,0,2,2,1,0,0,0,1,0,1,2,0,2,2,0,0,1,0,1,2,2,2,1,0,2,0,2,0,1,7,7,2,0,2,1,0,1,2,0,2,0,2,0,2,0,0,0,1,10,10,10,10,10,10,10,10,10,0,11,0,1,10,10,10,10,10,0,1,0,0,12,1,0,0,2,2,1,0,0,0,1,0,2,1,2,0,2,0,1,0,0,1,1,1,1,1,0,2,0,0,1,2,0,0,2,1,1,2,0,0,2,1,1,1,2,1,7,7,0,1,1,1,1,1,1,1,1,1,2,0,0,0,2,0,0,0,0,0,1,0,0,1,0,2,2,2,2,2,2,1,2,0,1,0,2,1,2,0,0,1,0,11,11,0,1,12,1,2,11,12,0,11,11,11,11,2,0,12,1,2,2,2,2,2,0,0,0,12,12,0,0,0,0,0,1,2,0,0,1,2,0,1,0,0,1,1,1,0,0,0,0,2,0,0,0,1,0,1,2,2,1,1,1,0,1,0,0,0,0,0,1,0,3,3,3,3,3,3,3,3,3,2,0,1,1,1,2,0,0,1,0,2,0,2,2,2,1,0,2,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,0,1,1,0,2,0,1,2,2,0,0,1,0,2,2,0,0,0,2,0,0,0,1,2,0,1,2,1,0,0,0,0,1,1,2,1,0,0,1,1,0,1,7,7,1,0,0,2,1,0,0,2,2,1,0,2,0,0,0,1,2,1,0,10,10,10,10,10,1,0,0,11,11,11,0,10,10,10,10,10,1,1,2,12,12,0,0,0,1,2,2,1,0,0,1,0,2,0,2,2,0,0,2,1,1,1,1,1,1,1,1,0,0,0,1,2,0,0,0,2,2,0,0,1,2,0,2,1,7,7,7,7,0,2,0,1,1,1,1,1,2,0,2,0,0,1,1,2,0,0,2,1,0,1,0,2,0,2,0,0,0,0,0,0,0,0,1,2,2,0,0,2,0,1,2,11,11,11,11,12,12,12,12,11,11,11,1,2,11,12,12,11,2,2,2,2,2,2,1,12,11,11,11,12,0,0,2,0,1,1,0,0,0,1,0,0,0,2,1,1,0,0,0,2,0,2,0,2,0,2,1,0,0,0,2,0,1,0,2,0,1,0,2,1,3,3,3,3,3,3,3,3,3,0,0,0,13,13,1,0,1,1,0,0,0,0,0,0,2,0,0,0,0,2,3,3,3,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,1,2,2,1,0,0,0,1,2,1,2,1,2,1,0,2,2,0,0,0,1,2,0,0,0,2,0,1,2,0,1,2,0,2,0,0,0,2,0,0,0,7,7,7,0,1,0,2,0,2,2,2,2,2,0,0,2,2,0,0,0,0,10,10,10,2,10,10,0,0,2,0,1,11,0,10,10,10,10,10,0,2,2,12,12,12,2,2,1,0,0,0,1,1,2,0,2,0,2,1,0,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,0,1,2,0,0,0,0,7,7,7,7,7,7,1,0,0,1,1,1,1,0,2,0,2,2,0,0,0,0,2,0,1,0,0,0,0,1,1,0,2,0,2,2,2,2,0,0,0,1,1,0,0,0,0,0,1,0,11,11,11,11,11,1,11,11,1,11,1,2,2,11,11,11,2,2,2,2,2,1,11,11,11,11,11,1,0,0,0,0,0,1,0,1,0,0,0,0,0,2,2,0,0,0,0,0,1,2,2,2,1,2,1,0,2,0,0,0,0,0,2,0,2,1,3,3,3,3,3,3,3,3,3,3,1,0,13,13,13,13,2,1,0,0,0,0,0,2,1,0,1,0,2,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,0,0,0,1,2,2,2,2,0,0,0,0,1,1,0,0,1,1,2,1,1,2,0,1,0,1,2,0,0,2,2,0,2,1,0,2,2,0,0,7,7,7,7,0,1,2,2,2,0,1,0,0,0,0,0,1,2,1,0,10,10,10,10,10,10,10,2,0,1,0,0,1,1,1,1,10,10,10,2,0,2,1,2,12,0,0,0,2,0,1,0,0,0,0,0,0,0,0,2,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,0,0,2,0,7,7,7,7,7,7,1,0,0,2,0,1,2,0,0,2,2,1,0,0,1,2,0,0,0,0,0,2,0,1,2,2,0,1,0,0,1,2,2,0,0,0,2,2,2,12,12,1,0,2,3,11,11,11,11,11,11,11,11,11,11,11,11,1,2,2,2,2,2,2,2,11,11,11,2,2,12,1,2,0,1,2,0,0,0,1,0,1,2,2,0,0,0,1,0,0,2,0,1,0,1,1,0,0,0,0,1,1,1,0,1,0,0,1,0,3,3,3,3,3,3,3,3,3,3,1,0,13,13,13,13,0,2,1,0,1,1,2,0,2,0,1,1,0,0,2,2,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,1,0,0,1,0,0,0,0,0,1,2,0,0,2,2,0,0,0,0,0,0,0,0,0,1,0,0,2,2,1,0,1,0,0,0,1,1,0,1,7,7,7,7,1,0,0,0,2,0,0,0,0,1,0,1,10,10,10,10,10,0,2,10,1,10,10,1,2,0,0,1,1,1,1,1,1,0,0,0,0,2,0,2,0,1,0,1,2,0,0,2,1,2,0,2,1,2,0,0,0,0,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,0,7,7,7,2,0,2,0,0,0,0,0,2,0,1,2,0,2,2,1,0,2,1,0,1,2,2,2,0,2,0,0,0,2,0,2,0,2,0,0,1,0,0,0,2,0,2,2,12,0,0,0,11,11,11,11,11,11,11,11,11,11,11,11,2,0,2,2,2,2,2,2,2,12,12,12,2,0,12,2,2,2,0,1,2,0,2,2,0,2,2,2,0,0,0,2,1,0,0,1,1,1,0,2,0,0,1,0,1,1,1,2,2,1,0,2,3,3,3,3,3,3,1,1,1,0,1,0,0,13,13,13,0,1,0,0,0,0,0,2,0,2,0,1,2,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,1,0,0,0,0,0,0,2,0,1,0,1,0,2,1,0,0,0,0,0,2,0,0,2,1,2,0,1,0,2,0,0,2,1,2,0,0,0,2,7,7,7,7,0,2,0,0,0,0,2,2,0,2,0,10,10,0,0,0,1,0,10,10,10,10,1,1,1,0,1,1,1,1,1,1,1,1,1,2,0,1,1,1,0,2,1,2,1,0,0,0,0,0,2,10,10,7,7,1,2,1,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,0,7,7,0,1,0,1,2,0,2,1,0,1,0,2,0,0,1,0,2,2,1,1,0,0,0,0,0,2,0,2,2,1,1,1,0,1,1,1,2,2,2,2,1,1,1,12,12,1,12,0,11,11,11,11,0,3,11,11,11,2,1,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,1,0,1,2,0,2,0,0,2,2,0,2,0,0,2,1,1,2,0,1,0,0,2,0,0,0,0,0,0,1,0,0,0,0,0,0,3,3,3,3,3,3,0,0,0,1,1,2,1,13,13,2,0,2,1,0,2,1,0,1,2,0,0,2,0,2,2,2,0,0,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,1,2,0,0,0,2,0,0,2,2,0,2,0,0,0,0,1,2,0,0,0,0,0,2,1,1,0,1,2,0,1,2,1,1,0,0,0,0,1,0,2,0,2,0,2,2,2,0,0,1,1,0,0,2,0,0,1,0,1,1,0,1,0,0,2,0,2,1,1,1,1,1,1,1,1,1,1,2,2,12,12,0,1,2,0,0,0,1,0,1,0,1,10,10,1,7,7,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,2,0,1,2,0,0,2,1,0,0,0,0,0,1,1,0,0,2,1,1,2,0,0,2,7,7,7,7,7,7,1,1,1,1,0,0,0,0,0,0,2,1,1,0,0,0,0,12,12,11,11,1,0,0,0,2,1,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,0,0,0,0,0,0,1,2,0,1,0,1,0,1,0,1,2,2,0,2,2,0,2,1,0,0,0,2,0,2,2,2,0,1,1,0,3,3,3,3,3,3,3,1,0,0,1,1,0,1,0,13,13,0,2,0,0,2,0,2,1,0,2,1,1,0,1,1,0,2,0,1,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,0,0,0,0,0,2,0,0,2,0,0,2,1,2,0,2,0,1,0,0,0,0,0,2,1,1,1,1,1,1,2,1,0,1,0,0,2,0,0,1,0,1,2,0,2,1,1,1,1,0,2,0,0,0,1,1,0,1,2,0,2,1,1,1,0,2,0,1,1,1,1,1,1,1,1,1,1,1,2,0,12,12,12,0,2,0,0,2,1,0,2,0,0,10,10,10,10,2,0,0,0,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,0,0,0,0,1,11,11,11,0,1,0,0,1,0,1,0,0,2,1,1,0,2,2,7,7,7,7,7,7,1,1,1,1,1,0,1,0,1,0,0,2,2,0,0,2,2,0,12,11,12,12,0,0,0,0,1,0,1,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,2,1,2,0,0,2,0,0,2,2,0,2,0,2,1,2,1,0,0,0,0,0,0,0,0,2,0,2,2,1,1,0,2,1,0,3,3,3,3,3,3,3,3,2,2,1,2,0,1,2,2,2,0,0,0,0,2,2,2,0,2,0,1,0,2,2,1,0,1,0,0,0,0,2,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,0,2,0,0,1,0,0,2,0,0,0,0,1,0,1,2,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,0,0,1,0,0,0,0,2,0,0,1,1,1,1,0,0,2,0,1,2,1,0,0,0,0,1,1,1,0,1,2,2,7,7,7,7,7,7,7,1,1,1,1,1,2,0,0,2,1,2,0,0,0,2,0,1,2,1,1,1,0,0,10,10,0,0,1,1,2,2,0,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,2,1,1,0,1,1,2,11,11,11,11,11,0,0,1,0,2,0,0,0,2,0,0,1,2,7,7,7,7,7,7,1,1,1,1,1,1,1,0,0,0,2,0,0,1,0,0,1,2,0,0,12,12,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,0,1,0,0,0,0,0,2,1,1,0,2,0,0,0,1,0,0,0,2,1,0,1,0,0,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,2,1,13,1,0,2,0,1,1,1,0,2,2,1,2,0,2,0,0,0,0,0,0,2,0,0,0,2,1,0,1,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,2,0,2,0,0,0,1,1,0,2,0,1,1,1,1,2,0,2,0,2,0,2,1,1,1,1,1,1,1,1,1,1,1,2,0,2,2,2,1,0,2,2,0,0,1,0,0,0,1,1,0,1,0,0,0,0,0,2,0,2,1,0,0,0,2,7,7,7,7,7,7,7,1,1,1,1,2,2,0,1,0,1,0,0,2,0,0,0,0,2,2,2,0,0,10,10,0,0,0,0,2,1,0,0,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,0,0,0,0,2,2,1,11,11,11,11,11,1,1,1,0,1,2,1,1,0,1,0,1,0,0,7,7,7,1,0,1,1,1,1,1,1,1,1,1,1,1,1,2,0,2,1,0,0,1,0,2,0,2,0,0,2,0,0,1,2,1,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,1,1,2,2,2,2,2,1,0,1,0,0,2,0,0,1,0,0,2,2,0,1,0,2,2,0,2,0,0,2,3,3,3,3,3,3,3,3,3,3,1,13,13,13,13,13,0,0,1,0,1,1,1,0,1,0,1,2,1,1,0,0,0,0,0,2,2,0,1,0,0,2,2,1,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,2,1,1,0,1,0,2,0,0,0,0,0,2,0,0,0,1,2,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,0,0,1,0,1,1,1,2,0,0,0,0,1,2,0,0,0,0,1,1,1,1,2,0,2,0,0,0,1,1,1,1,1,1,1,1,1,0,0,2,0,2,0,0,0,0,0,0,1,1,1,0,1,2,2,1,2,0,0,1,0,0,2,0,1,0,2,0,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,0,1,0,2,0,0,0,2,0,12,11,11,11,11,11,0,2,0,0,2,2,2,0,0,0,2,1,0,7,7,7,2,1,0,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,1,1,2,0,0,1,0,0,2,2,0,0,1,1,0,2,2,1,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,0,1,0,0,2,0,1,0,2,0,0,2,2,1,0,2,2,0,3,3,3,3,3,3,3,3,3,3,1,13,13,13,13,13,13,0,1,0,0,0,2,0,1,0,2,1,0,0,0,2,0,0,0,1,2,0,1,1,0,0,2,1,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,2,0,1,0,1,0,0,2,2,2,0,2,2,0,2,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,1,1,1,0,1,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,0,0,0,2,1,0,0,1,0,0,0,2,2,2,1,0,2,0,2,2,1,2,0,0,0,2,0,1,2,0,10,0,1,2,0,0,0,1,2,0,0,2,0,1,1,1,1,1,0,2,2,0,1,1,0,2,12,12,1,2,0,0,0,2,1,1,0,2,2,1,0,2,1,0,0,7,7,1,0,0,1,0,1,1,1,1,1,1,1,1,0,2,2,1,0,0,0,1,2,0,1,2,1,1,0,1,0,2,1,2,0,0,0,0,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,2,2,0,0,2,0,1,2,2,1,0,0,0,0,0,1,0,3,3,3,3,3,3,3,3,3,3,3,2,0,13,13,13,13,14,2,0,0,0,2,0,2,0,2,0,0,1,2,1,0,0,1,2,0,0,0,0,0,2,2,0,0,0,0,1,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,2,1,1,0,0,0,2,0,2,2,1,0,0,0,2,1,2,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,2,1,0,1,0,1,2,1,2,0,0,2,2,2,0,0,0,2,0,0,0,0,1,0,0,0,1,1,1,1,1,1,1,1,1,2,2,0,1,1,0,1,0,0,0,0,0,1,2,0,0,0,2,1,0,2,0,0,1,1,1,0,2,0,10,10,0,2,2,1,2,2,2,2,0,0,0,2,2,2,2,0,0,0,1,2,2,1,1,1,2,11,2,2,2,2,0,2,0,0,2,1,0,1,1,1,0,0,2,0,0,0,2,0,2,1,1,0,1,1,1,1,1,1,1,0,0,2,2,1,0,0,0,1,0,0,2,0,2,0,0,1,0,1,2,2,0,0,1,1,2,2,2,2,1,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,2,2,0,0,2,2,1,0,2,0,0,2,1,0,1,2,0,3,3,3,3,3,3,3,3,3,3,3,0,0,13,13,13,13,14,1,1,2,0,0,1,1,0,1,0,2,1,0,2,0,1,0,0,1,0,0,0,1,0,0,1,0,0,2,0,2,1,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,2,0,2,0,0,1,0,0,2,0,0,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,2,0,1,0,1,0,2,2,0,1,0,0,0,2,1,2,0,2,0,0,0,1,1,0,1,1,1,1,1,1,1,1,0,0,0,1,1,0,0,7,7,0,1,0,0,0,2,0,2,1,0,0,2,1,0,2,2,0,0,2,1,1,10,10,10,0,2,0,0,2,2,1,2,1,2,2,0,0,0,2,2,2,0,1,0,0,1,0,11,11,0,0,0,2,1,1,0,1,2,2,2,0,0,0,0,2,0,0,2,1,0,2,1,2,0,2,0,1,1,1,1,1,1,1,0,2,0,0,1,2,0,2,1,0,0,0,1,0,1,2,1,0,1,1,0,0,0,1,1,1,1,0,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,2,1,1,0,1,1,1,0,0,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,13,13,13,13,0,2,0,0,0,0,0,2,1,0,0,0,0,0,2,1,2,1,0,0,0,0,0,0,1,0,0,0,1,0,1,0,1,0,1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,0,0,1,0,1,0,2,1,0,2,0,2,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,0,2,2,0,2,0,0,2,0,2,0,0,2,0,0,1,1,0,2,0,0,0,2,2,1,1,1,1,1,1,1,1,1,7,7,0,0,1,2,7,7,7,7,1,0,0,0,0,0,1,1,1,1,0,2,1,0,2,0,0,1,1,10,10,10,10,10,10,0,2,2,2,1,1,1,1,0,2,2,2,1,0,1,2,1,0,0,11,11,11,11,0,1,0,0,2,2,0,0,0,1,2,0,0,0,2,1,1,2,1,2,0,0,1,0,0,0,0,1,1,1,1,1,1,2,2,0,2,1,0,1,0,0,0,1,0,0,0,0,2,0,2,2,0,1,0,0,0,0,1,0,0,0,0,0,0,1,0,2,2,2,2,2,2,2,2,2,2,2,2,0,2,0,0,0,0,1,2,0,2,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,13,13,13,13,2,0,2,2,0,0,2,2,0,0,1,2,1,1,2,0,1,2,0,1,0,2,0,0,1,1,0,1,0,2,0,1,1,2,1,0,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,0,0,2,2,0,0,0,0,0,2,1,0,0,0,0,0,0,1,0,0,1,1,1,1,0,0,0,2,0,0,0,2,2,0,1,1,2,1,0,1,0,2,2,1,0,1,1,0,1,2,1,1,0,1,1,1,1,1,1,1,1,2,7,7,7,7,7,7,7,7,7,7,2,1,0,0,0,0,2,0,0,0,2,1,0,2,1,0,0,1,10,10,10,10,10,10,10,10,10,2,0,2,1,1,0,1,1,1,0,2,0,11,1,0,1,2,11,2,2,0,2,2,0,1,0,0,2,0,0,2,2,0,0,0,0,2,1,0,2,1,2,2,2,2,0,0,0,1,2,1,1,1,0,1,2,1,0,0,1,1,0,1,0,0,0,2,0,1,0,0,0,0,0,1,1,1,0,2,0,0,2,0,0,0,1,0,0,0,2,2,2,2,2,2,2,2,2,2,2,1,2,0,0,0,2,0,1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,13,13,13,13,13,13,13,2,0,2,2,2,0,0,0,2,0,1,0,0,1,0,2,0,1,0,1,2,2,2,0,0,0,1,0,0,0,0,0,1,0,0,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,1,0,2,1,1,1,0,1,0,1,0,0,0,0,1,0,0,1,1,2,0,0,0,0,0,0,1,2,0,1,0,0,0,0,0,1,0,1,0,1,1,0,0,0,1,0,0,0,2,1,1,1,1,1,1,1,2,0,2,7,7,7,7,7,7,2,7,7,1,0,1,0,0,1,0,2,2,1,0,0,2,0,0,1,2,1,1,10,10,10,10,10,10,3,10,0,1,1,0,2,0,0,0,2,1,11,11,11,0,0,1,2,2,0,0,2,0,2,1,0,0,2,1,0,0,0,2,2,2,0,1,1,2,2,2,2,2,2,2,2,2,0,2,0,1,0,0,0,2,0,1,2,0,0,1,0,0,0,0,0,2,1,0,0,1,2,1,2,1,2,0,1,0,0,0,1,0,0,0,0,0,1,2,0,1,0,1,0,0,0,0,0,0,1,0,0,2,2,0,1,2,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,13,13,13,13,13,13,13,13,13,13,13,13,2,1,2,1,2,2,0,1,0,2,0,1,0,0,0,0,0,2,1,0,1,2,2,2,2,0,0,0,1,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,2,0,0,1,0,0,0,2,2,2,0,0,0,2,2,2,1,1,2,2,2,1,1,0,2,2,0,2,0,2,0,2,0,0,0,0,1,0,2,2,1,2,0,1,1,0,0,2,2,0,1,1,1,2,1,1,1,1,1,1,1,2,0,1,0,0,0,0,0,0,0,0,0,1,0,2,1,1,1,1,0,0,0,0,1,1,0,1,0,2,0,0,0,2,0,2,10,10,2,0,1,2,0,0,1,0,0,0,1,11,4,2,2,0,1,0,1,0,0,2,0,2,1,2,0,1,0,2,1,0,0,2,0,2,2,0,0,2,2,2,2,2,2,2,2,2,0,0,1,0,2,0,2,0,0,0,0,1,0,2,0,1,2,0,0,2,1,1,0,0,0,1,1,0,0,2,0,2,1,2,2,0,2,1,2,1,0,1,0,0,0,1,2,1,1,0,0,0,0,0,0,0,1,2,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,2,3,2,0,13,13,13,13,13,13,13,13,13,13,2,0,0,1,0,0,0,1,0,1,2,0,0,0,0,2,1,1,2,2,0,2,1,0,2,2,0,0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,1,1,1,1,1,1,1,1,10,0,2,0,0,2,1,1,0,0,0,0,2,2,0,0,1,2,1,0,2,0,1,0,2,1,0,0,1,2,1,0,2,0,2,2,0,0,1,1,2,0,1,2,0,0,0,0,0,2,2,2,1,2,0,1,1,1,0,1,0,0,1,1,1,1,1,1,2,2,2,1,0,2,0,0,0,0,0,0,0,0,2,0,1,0,1,1,2,1,0,0,0,1,0,1,0,1,2,0,1,2,1,0,2,0,0,0,11,0,2,0,0,1,0,0,0,2,0,0,2,0,0,2,0,0,0,0,0,2,1,0,0,1,0,0,0,2,2,2,2,2,2,2,2,2,0,0,0,0,1,0,1,0,0,2,0,0,2,0,2,0,0,0,0,2,2,0,0,0,0,0,0,0,0,2,1,0,1,0,0,0,2,2,0,0,0,2,1,0,1,0,0,1,0,1,2,1,0,2,0,1,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,2,0,0,2,13,13,13,13,13,13,13,13,0,0,1,0,2,0,1,0,1,2,1,0,0,0,1,2,0,0,1,1,0,2,0,0,2,0,10,10,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,1,1,1,1,1,1,1,1,10,10,0,1,0,1,1,2,1,1,0,0,1,0,0,0,2,2,1,0,1,0,1,0,1,0,1,0,0,0,2,1,0,0,2,0,0,0,2,0,2,1,0,0,2,2,0,0,0,1,0,1,2,1,0,2,2,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,2,1,2,2,2,0,0,0,1,0,2,2,1,0,0,2,1,0,0,1,1,0,0,2,0,0,1,0,0,1,1,0,1,0,0,0,0,2,1,0,2,1,0,1,2,1,0,2,0,2,0,2,0,0,0,0,2,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,1,2,0,1,0,1,2,1,2,2,0,0,2,0,1,0,1,1,2,0,0,0,0,0,1,0,0,2,2,2,0,2,0,0,2,0,1,0,1,2,1,1,1,2,2,0,0,1,1,2,0,0,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,2,13,13,13,13,13,0,2,1,0,1,1,2,1,1,2,1,1,1,2,2,0,0,1,1,0,0,1,2,1,0,10,10,10,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,1,2,1,1,1,1,10,10,0,0,0,0,2,2,2,2,1,2,0,0,0,2,0,0,1,1,0,2,0,0,0,2,0,1,2,1,0,2,1,0,1,0,0,0,0,2,0,1,0,1,0,0,2,0,1,1,0,0,1,2,1,2,0,1,0,2,0,1,1,1,1,1,1,1,1,1,1,1,2,0,2,1,0,0,1,1,1,0,0,2,1,1,2,0,2,0,0,0,0,0,0,1,2,1,2,2,2,2,0,0,0,2,2,0,2,0,0,1,0,0,1,1,0,0,1,0,0,2,0,2,1,1,0,2,2,0,0,0,1,1,0,1,2,2,2,0,2,2,2,2,2,2,2,2,2,2,1,2,2,0,0,1,0,0,1,0,0,2,0,2,2,0,0,1,1,2,2,1,0,1,0,0,0,0,0,0,2,0,0,2,1,2,1,1,2,1,0,0,0,1,0,2,0,0,0,1,2,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,13,13,13,13,0,0,1,2,0,0,0,2,0,1,2,0,1,0,0,1,0,1,2,2,0,0,0,10,10,0,10,0,2,0,0,1,0,0,10,2,15,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,1,1,0,2,0,0,10,2,11,11,2,1,2,1,1,0,1,2,0,0,2,1,2,0,0,0,0,0,0,1,0,0,0,0,1,2,2,1,0,0,2,2,1,0,0,1,1,0,0,2,0,1,1,0,2,0,2,1,0,2,2,0,2,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,0,2,2,2,1,0,1,1,0,0,0,0,0,1,0,2,1,0,1,0,0,2,0,0,0,0,1,2,0,2,0,2,0,0,0,0,0,0,1,2,1,2,2,0,0,2,2,0,0,0,0,0,0,1,0,0,0,0,0,2,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,0,1,2,1,2,1,0,0,0,2,2,0,1,1,0,0,0,0,1,0,2,1,1,1,2,0,2,1,0,1,1,0,1,0,2,2,2,2,0,0,0,0,1,0,0,0,2,0,2,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,3,0,1,0,2,3,3,3,3,3,3,3,3,3,0,0,13,13,2,1,0,2,0,1,0,0,2,1,0,1,0,2,0,1,0,0,0,0,2,1,1,10,10,0,0,0,2,2,0,1,2,10,10,10,10,2,10,10,15,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,0,0,10,1,0,0,10,0,0,10,10,1,0,1,2,0,2,2,0,1,0,0,1,2,1,1,1,0,2,1,1,2,0,1,1,0,1,0,0,0,0,2,0,1,0,0,0,0,1,0,1,1,1,2,0,0,0,1,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,1,0,1,1,0,0,0,0,0,0,1,0,1,2,0,0,2,2,0,2,0,1,0,1,1,1,0,1,1,1,1,0,0,0,1,0,2,0,2,0,2,1,0,0,0,0,0,0,0,1,2,0,0,0,0,1,2,2,0,1,1,0,2,1,0,2,2,2,2,2,2,2,2,2,2,0,0,1,0,2,0,0,0,2,2,0,0,0,0,0,1,0,2,0,2,0,2,1,0,2,1,0,0,2,1,0,2,0,1,1,0,0,2,2,2,2,0,1,1,0,0,0,1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,13,13,13,13,13,13,0,1,3,1,0,3,3,3,0,13,13,0,1,2,0,1,0,1,1,0,0,1,0,2,0,0,0,1,0,2,0,0,0,0,2,10,0,0,0,0,2,0,1,2,10,10,0,2,10,10,10,10,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,1,0,1,0,0,10,10,10,10,10,15,0,10,10,2,1,1,0,0,0,0,2,0,2,0,0,0,0,1,0,0,0,0,0,0,0,1,2,1,0,0,0,1,0,1,2,1,0,0,0,2,1,1,0,0,1,2,0,1,2,0,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,1,0,0,1,0,2,1,2,0,0,0,2,1,0,2,1,0,0,0,2,1,0,2,2,0,0,0,0,0,0,0,0,1,2,2,1,1,1,0,2,1,0,0,0,1,2,2,2,0,0,1,2,2,0,0,0,1,0,2,0,0,0,0,2,2,2,2,2,2,2,2,2,0,2,2,0,0,0,0,0,2,1,2,1,1,2,0,1,1,0,0,1,0,1,1,2,1,0,0,2,0,0,0,0,0,0,2,1,0,0,1,1,0,2,1,0,1,0,0,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,1,13,13,13,13,13,13,13,13,13,13,13,13,2,2,13,13,13,0,0,1,2,0,1,0,2,0,2,0,0,0,0,0,1,2,0,0,2,0,2,2,0,2,10,0,2,2,0,1,0,0,0,10,10,2,10,10,10,10,2,1,10,10,10,0,2,2,1,3,3,3,3,3,3,0,1,0,1,10,10,10,10,10,10,10,10,10,10,10,0,0,2,2,1,0,1,0,0,1,1,2,1,0,0,0,2,0,0,0,0,0,0,2,0,0,0,1,2,1,0,0,0,0,2,2,1,0,2,0,0,0,0,0,1,1,0,1,1,1,1,7,7,7,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,2,0,0,2,0,0,2,2,0,0,1,0,1,2,2,1,1,1,1,2,0,1,0,2,1,2,2,1,2,2,0,1,1,2,0,2,2,1,0,1,0,2,0,0,1,1,0,0,2,1,0,0,0,0,1,2,2,0,0,0,2,2,0,0,0,1,2,2,2,2,2,0,0,0,2,0,2,0,1,0,1,0,2,0,1,1,0,2,2,2,7,2,0,0,2,1,1,2,1,0,1,0,2,1,1,2,2,7,2,1,1,0,2,1,0,0,0,2,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,0,2,0,13,13,13,13,13,13,13,13,13,13,13,13,13,13,2,2,1,2,0,1,0,2,0,2,1,2,2,2,2,1,0,0,0,2,0,0,1,0,0,0,0,1,1,1,2,2,0,10,10,2,10,10,10,10,10,1,1,10,10,13,13,13,13,13,0,3,3,3,3,1,15,0,0,2,11,10,1,1,10,10,10,15,10,10,10,10,10,0,1,1,2,1,1,2,2,0,0,0,1,0,2,2,0,0,0,0,0,1,1,1,0,0,0,0,0,0,1,2,0,0,0,2,1,0,0,1,0,2,2,1,0,0,1,1,1,1,7,7,7,1,1,1,1,1,1,0,0,2,2,0,0,1,1,2,1,1,0,2,0,2,1,2,0,0,0,1,0,1,1,2,0,2,1,0,0,0,1,0,1,0,1,2,0,2,2,0,1,1,1,1,0,1,2,2,0,1,2,2,0,0,0,0,0,1,0,0,1,1,0,0,0,0,1,2,0,0,0,1,2,0,2,2,2,0,0,2,1,1,2,0,1,0,1,2,0,2,2,0,2,2,0,2,2,7,7,2,0,0,0,2,0,0,0,2,0,1,2,2,1,0,7,7,0,2,1,2,2,2,2,2,2,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,1,0,0,2,0,0,2,0,1,2,2,0,13,13,13,13,0,0,0,1,0,2,1,2,2,0,0,0,1,0,1,2,2,3,2,3,2,1,3,3,2,2,0,1,1,0,0,1,0,2,0,0,10,10,10,1,0,1,0,0,10,10,1,13,13,13,13,13,13,13,1,1,2,1,0,0,1,1,10,10,1,0,2,10,11,10,10,15,10,10,2,0,0,1,10,10,0,2,0,0,10,10,0,0,1,1,0,0,0,0,1,1,0,1,0,2,0,0,0,2,0,1,0,0,1,0,2,2,2,0,2,1,0,1,0,0,7,7,7,1,7,7,1,1,1,1,1,1,2,1,1,2,1,2,1,1,1,0,0,2,0,1,2,2,0,0,0,0,2,0,2,0,0,0,1,2,1,0,0,0,2,1,0,0,1,1,2,2,1,1,2,0,0,2,2,0,2,1,0,2,2,0,0,2,2,2,0,2,2,0,2,0,1,0,0,2,0,2,1,1,0,0,0,2,2,2,2,2,1,2,0,1,2,0,0,0,2,1,0,2,2,0,1,1,1,2,0,7,0,0,0,1,0,1,0,1,1,0,0,1,0,0,2,1,7,0,0,0,0,1,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,7,7,2,2,2,2,0,1,1,0,0,2,0,1,0,1,0,1,1,2,1,2,2,0,0,2,13,13,0,2,13,13,1,0,0,3,3,0,0,3,3,3,3,3,1,0,2,2,2,2,0,0,1,0,0,10,10,0,1,0,0,0,15,10,0,13,13,0,1,13,13,16,17,17,18,15,0,1,0,10,10,0,1,12,11,11,11,2,0,2,0,0,2,2,10,10,10,0,15,10,10,10,2,0,1,1,1,1,0,0,1,2,0,0,1,0,1,1,0,2,0,0,2,2,2,0,0,1,0,1,1,2,0,0,2,0,7,7,7,7,7,7,7,1,1,1,1,0,2,1,0,0,1,0,0,0,2,2,0,0,0,0,0,1,0,0,0,1,1,1,1,2,1,2,2,0,0,2,1,2,0,0,0,2,0,0,0,0,2,0,1,0,0,0,1,0,2,2,2,0,2,0,0,2,1,1,2,0,0,1,0,2,1,1,2,1,2,0,1,0,2,2,1,0,0,2,0,0,1,1,0,1,2,0,0,0,2,1,2,1,1,1,0,2,1,0,0,0,7,0,1,0,0,2,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,1,2,0,0,0,0,0,0,1,1,0,1,2,0,1,1,0,0,2,0,2,0,0,0,0,0,1,13,13,13,13,13,13,13,13,2,1,0,0,1,0,1,0,0,1,0,0,7,0,0,1,2,1,2,0,1,2,1,0,1,0,2,1,10,10,0,0,0,2,1,1,0,16,14,18,14,2,0,0,1,10,1,0,2,12,12,10,1,0,1,0,0,0,0,2,0,0,10,10,10,10,0,2,0,0,1,2,0,1,0,0,2,0,0,0,1,0,1,0,1,0,0,0,2,1,1,0,1,2,1,0,2,0,1,7,7,7,7,7,7,7,7,7,1,1,1,1,1,0,1,0,0,0,0,0,2,0,0,0,0,0,2,0,2,2,1,0,0,1,2,1,2,0,0,0,2,1,0,2,0,2,0,0,1,1,2,1,0,0,2,0,2,0,2,0,2,0,0,2,0,2,0,0,1,0,2,0,2,0,0,2,0,1,0,2,0,1,0,0,0,0,1,2,1,2,0,1,0,2,1,0,1,2,2,0,1,0,2,2,0,2,0,0,2,2,0,2,0,0,7,2,2,0,1,2,2,2,0,0,1,1,0,1,2,0,0,0,0,2,0,1,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,0,1,0,0,0,2,0,0,0,2,2,1,0,0,1,0,1,0,1,2,0,2,0,0,1,1,0,0,1,1,1,13,13,2,13,13,13,13,13,13,13,13,0,0,2,0,0,1,1,2,2,0,1,1,1,2,0,0,2,0,1,0,0,0,0,0,0,2,1,2,0,0,0,2,0,0,2,1,2,2,10,2,0,2,0,0,2,10,0,0,0,1,10,10,0,1,2,1,0,0,0,0,0,0,2,0,0,2,2,1,2,0,2,2,0,0,0,1,1,0,1,2,1,1,0,0,2,0,0,1,2,1,2,0,1,0,7,7,7,7,7,0,1,1,1,1,1,1,1,0,0,0,0,2,0,2,0,0,0,0,0,0,1,1,2,0,2,0,2,1,2,2,0,0,1,0,1,1,1,0,0,0,1,0,1,0,1,0,1,2,2,0,0,2,2,1,0,0,0,1,1,0,1,1,0,0,0,0,0,0,1,2,0,2,1,1,2,2,2,0,0,0,2,0,1,1,2,1,0,0,0,0,2,0,2,0,1,0,0,2,0,2,0,0,0,0,1,0,1,0,2,1,2,0,2,0,2,0,2,0,1,1,2,0,2,1,1,13,1,0,2,0,0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,0,0,1,1,2,2,0,2,0,0,2,0,0,0,0,0,0,1,0,0,0,2,0,0,0,2,0,2,2,1,2,2,2,0,1,0,0,0,0,13,13,13,13,13,1,0,0,2,0,2,1,1,1,2,2,0,0,1,10,10,2,0,0,1,1,1,0,2,0,1,2,0,2,0,1,0,10,1,1,2,0,10,10,0,2,0,1,1,0,0,0,2,0,1,10,10,2,1,10,10,0,2,0,2,1,0,2,1,2,0,0,0,1,1,1,0,2,0,2,0,1,2,0,0,0,2,1,0,1,1,2,0,0,1,2,0,2,2,2,0,2,0,2,1,2,1,1,1,1,1,2,1,2,0,1,0,1,0,2,2,0,0,0,0,2,0,0,2,0,1,2,1,0,0,1,0,2,0,0,0,1,0,1,0,0,2,1,0,1,0,0,1,0,1,0,0,0,0,1,0,0,2,0,0,0,2,0,0,0,0,0,1,2,1,0,0,2,1,1,0,0,1,0,1,0,0,1,2,0,0,1,0,0,0,0,0,0,0,2,1,0,0,1,0,0,0,0,0,0,2,2,0,0,1,0,0,0,1,0,0,1,0,0,1,0,1,2,13,13,13,13,2,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,2,1,1,1,0,1,0,1,0,0,2,0,1,0,0,2,0,0,1,0,0,1,2,1,2,0,2,0,0,0,0,0,0,1,2,0,0,0,0,1,1,0,2,13,13,0,1,0,2,0,2,0,0,0,1,0,0,0,0,1,0,0,2,0,0,2,1,2,1,0,1,0,0,0,0,0,2,2,10,0,2,0,0,10,0,1,0,0,1,1,0,2,0,1,10,10,10,10,0,0,10,10,10,10,0,2,0,0,0,0,1,2,0,1,0,2,0,2,2,0,1,0,2,0,0,0,0,1,1,0,0,2,0,0,0,0,1,2,2,1,2,1,1,1,0,1,0,2,2,2,2,2,2,1,0,0,2,0,1,0,0,2,2,2,1,2,1,0,0,0,1,0,2,2,1,1,0,0,0,0,1,1,1,1,1,0,2,0,0,0,2,1,1,0,2,0,2,2,2,0,2,0,0,0,2,0,0,2,0,1,0,0,1,2,1,1,0,2,2,0,1,0,1,0,0,1,2,2,2,1,0,0,0,1,2,2,0,2,1,0,0,0,2,0,0,2,0,1,2,0,0,0,2,1,2,0,0,0,1,0,0,0,1,2,1,0,1,0,13,13,13,13,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,1,0,1,2,0,2,0,0,1,0,0,2,2,1,0,0,0,2,2,0,0,0,1,0,2,0,0,1,2,2,0,0,1,0,2,2,2,0,1,2,0,1,0,1,0,2,0,1,1,0,2,0,0,0,2,0,0,1,2,0,2,1,1,0,0,2,0,0,0,0,0,0,2,1,0,2,1,2,2,2,0,0,1,2,10,1,11,0,0,1,0,2,0,0,10,10,10,10,2,0,10,10,0,1,2,2,1,0,0,1,2,0,0,1,0,2,1,1,0,0,0,0,0,0,0,0,1,1,1,2,2,1,0,0,2,1,0,2,2,1,0,0,1,1,0,0,0,0,0,2,1,2,1,1,1,0,0,0,0,1,0,0,2,0,1,0,2,0,0,1,1,0,2,0,0,2,0,1,0,1,1,1,1,1,1,1,1,1,0,0,2,0,1,2,0,0,1,0,0,0,1,0,1,1,1,2,0,0,0,2,0,0,0,0,0,0,0,0,2,2,0,2,0,1,0,2,1,0,0,0,1,0,0,0,0,1,2,2,1,1,1,0,0,2,0,2,2,0,19,0,0,0,0,0,0,0,0,1,1,0,1,2,2,1,1,2,0,0,0,3,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,0,0,1,0,0,0,1,0,0,1,1,1,0,0,0,0,0,0,0,0,2,1,2,2,0,0,0,2,0,1,1,2,1,0,1,1,0,2,2,1,1,0,0,2,1,0,1,2,1,2,0,0,0,1,0,0,0,2,0,0,0,0,0,0,2,1,2,0,2,1,1,2,0,0,0,7,7,2,0,0,1,1,2,0,15,10,1,11,11,2,1,0,2,2,10,10,0,0,0,1,0,1,0,1,0,0,0,2,1,0,10,10,1,2,0,1,0,0,0,1,1,0,2,0,2,0,1,1,1,0,0,2,2,1,0,0,0,0,2,0,1,2,2,2,1,0,0,0,0,0,2,0,0,1,0,2,2,2,1,1,1,1,1,0,1,1,1,2,0,1,1,0,0,0,2,2,0,0,1,1,1,1,1,1,1,1,1,1,1,2,1,0,1,2,0,0,0,2,0,0,0,0,0,0,0,2,1,0,2,0,0,0,1,1,0,0,1,2,0,0,0,0,1,1,0,0,1,1,1,0,0,0,2,2,2,2,1,0,2,1,2,2,2,0,0,2,0,1,0,19,2,0,0,0,1,2,0,1,0,1,0,2,0,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,0,0,1,0,1,0,0,1,0,1,0,0,2,0,1,2,2,1,0,1,2,0,0,0,0,0,0,0,1,1,2,1,2,2,0,2,0,0,2,1,0,1,2,0,0,2,1,0,2,0,2,0,0,1,1,1,0,0,0,2,1,0,0,0,1,2,1,0,0,2,0,1,2,0,0,2,0,2,1,7,7,1,0,1,0,0,1,15,10,10,11,11,11,1,0,0,1,10,10,1,2,2,2,0,0,0,0,1,0,11,11,11,0,10,10,10,2,0,1,2,0,0,1,0,0,2,0,1,0,0,0,1,0,2,2,0,1,1,0,0,0,0,0,0,2,1,0,2,0,0,2,0,1,0,0,1,0,1,1,0,0,1,0,2,0,0,1,1,1,1,2,1,0,2,2,1,2,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,2,1,0,1,0,0,2,1,2,0,1,2,0,0,2,0,1,2,2,2,2,0,0,0,0,0,1,1,0,1,1,2,1,0,0,0,1,0,1,2,0,2,0,2,2,0,0,1,0,0,1,1,2,0,2,2,19,1,2,0,0,2,0,0,0,0,1,2,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,2,1,2,0,1,2,0,0,1,0,2,2,0,1,1,2,1,2,1,0,1,0,0,2,1,1,1,0,2,0,1,0,1,0,0,0,0,2,1,0,2,2,1,1,0,0,1,2,0,0,0,1,1,2,0,2,2,0,0,2,0,2,1,0,0,0,2,0,0,1,2,1,0,0,1,0,2,2,1,2,0,7,1,2,0,0,2,0,15,10,10,10,0,2,2,0,0,2,10,2,0,0,0,2,2,2,0,2,0,1,0,11,11,11,0,1,1,2,0,2,2,0,2,0,0,2,2,0,1,2,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,1,0,2,0,2,0,0,1,2,0,2,0,1,2,1,1,0,2,0,0,0,1,2,0,0,2,1,2,2,2,2,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,0,2,2,0,1,0,2,1,0,1,0,0,0,2,1,0,2,0,0,0,2,2,1,0,0,0,0,1,0,0,1,0,0,2,0,0,0,0,2,0,2,0,0,2,0,2,0,0,2,0,2,0,0,0,0,0,2,0,1,0,2,1,0,1,2,2,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,1,0,1,2,0,0,1,2,1,2,1,1,2,2,2,0,0,1,2,2,0,0,0,0,0,0,1,0,2,0,0,0,0,1,1,2,1,0,2,2,0,2,2,0,1,2,1,0,0,2,0,2,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,10,1,2,1,2,1,0,2,0,0,1,1,0,1,0,1,0,0,15,10,15,10,0,0,0,2,2,2,10,0,0,0,0,1,0,0,2,0,2,10,10,0,1,0,0,0,10,10,2,2,2,2,0,2,2,0,0,0,0,0,1,0,0,1,1,0,1,2,2,0,1,0,1,1,0,0,0,2,0,2,2,1,2,1,0,1,0,1,1,2,0,1,1,1,0,2,2,0,1,0,1,0,1,2,1,2,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,1,0,0,0,0,0,0,2,2,0,2,0,2,0,0,2,0,2,0,0,1,1,2,1,0,0,0,0,2,0,0,0,2,2,0,0,1,1,2,0,1,0,0,1,0,2,0,0,0,0,1,0,2,0,0,2,2,2,1,2,0,2,1,0,0,2,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,2,1,0,0,0,2,0,0,0,1,2,0,0,1,2,1,2,0,1,0,1,2,0,2,0,1,1,0,2,0,0,0,0,0,0,0,1,0,1,0,1,0,2,1,1,2,2,2,0,0,0,2,0,0,1,0,0,0,0,0,2,1,0,1,2,2,2,1,10,10,10,10,0,1,0,0,0,0,1,0,0,0,1,0,0,1,2,0,1,0,10,0,0,0,1,2,0,1,2,0,1,0,0,0,0,1,0,2,1,10,10,10,1,2,10,0,10,10,10,1,2,1,0,0,2,0,0,0,0,1,2,1,1,2,2,0,0,2,1,0,0,0,0,0,2,2,0,2,0,0,0,2,0,0,1,0,1,0,2,1,1,0,0,2,0,0,0,0,1,0,1,2,0,0,2,2,2,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,0,0,0,1,2,0,1,1,2,0,0,1,0,2,1,2,0,2,1,0,0,0,1,2,0,1,0,0,1,0,0,1,0,1,0,2,0,0,2,0,0,1,1,0,1,2,2,0,0,0,0,0,1,1,0,0,0,1,0,0,0,2,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,1,0,0,2,0,2,0,0,7,2,0,2,0,1,1,0,2,2,1,0,1,0,1,0,2,1,0,0,0,2,0,2,0,1,0,0,0,1,0,0,0,0,0,2,1,0,1,2,0,1,0,0,0,1,2,0,2,1,0,0,2,0,0,0,1,1,0,2,0,1,10,10,10,2,1,0,0,0,0,2,1,1,2,1,2,0,0,0,0,0,0,2,10,0,0,0,0,0,1,0,1,1,1,2,2,2,0,0,1,2,10,10,0,1,10,10,10,10,10,0,10,10,10,1,0,0,0,1,2,0,0,0,0,0,1,2,0,0,1,0,0,1,0,0,1,2,2,0,0,0,2,2,1,0,0,2,1,0,0,1,0,2,0,1,0,2,0,1,1,0,1,1,2,1,2,2,2,2,0,0,1,0,0,2,0,1,1,1,1,1,1,1,1,1,1,0,2,2,0,0,0,0,1,0,2,0,2,2,0,1,1,1,0,0,0,0,1,0,2,0,0,2,0,1,0,1,0,0,0,0,2,0,1,0,1,0,1,0,0,0,0,2,0,0,0,0,1,1,1,2,0,1,0,2,0,0,2,0,2,2,0,0,2,0,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,0,1,0,0,0,0,0,2,7,0,0,0,1,2,0,0,0,0,1,0,1,0,2,0,2,1,0,1,0,1,0,2,1,1,0,1,2,2,1,0,0,2,0,2,0,2,2,1,0,0,2,0,0,0,0,1,1,1,2,0,1,2,2,0,0,0,2,1,0,0,0,0,0,0,1,0,0,0,0,0,2,1,2,0,1,0,0,0,0,0,2,2,0,0,1,0,0,1,2,0,1,0,0,0,0,1,2,10,10,10,10,2,1,0,0,10,0,0,0,0,1,1,10,0,0,1,0,0,0,1,0,0,0,1,0,2,0,1,0,0,2,2,1,2,0,0,0,0,0,1,0,2,0,2,1,0,1,0,0,1,0,1,1,2,0,1,0,1,0,0,1,0,2,1,2,2,0,2,0,1,0,1,0,1,2,1,1,1,1,0,1,0,0,0,1,0,0,0,1,0,1,1,0,2,2,1,1,0,0,0,0,2,0,0,1,1,1,1,2,2,0,0,2,2,0,1,1,0,0,2,0,2,1,0,2,0,1,0,2,2,0,0,0,0,0,0,0,2,0,2,2,2,2,0,0,0,2,2,1,0,2,1,1,2,0,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,0,0,2,0,0,2,0,0,0,0,7,0,2,0,2,0,1,0,1,1,0,0,2,2,0,1,1,0,1,2,0,0,0,1,0,2,1,1,0,0,2,2,2,2,0,0,0,1,2,0,0,0,1,2,1,0,2,0,0,1,1,0,2,1,2,1,2,0,0,2,0,1,0,2,1,0,0,0,0,2,1,1,1,1,2,2,0,2,2,0,0,2,2,2,10,0,1,0,0,2,2,2,0,2,1,0,0,1,2,2,10,2,0,10,1,1,10,1,0,0,0,2,0,1,2,1,0,2,0,1,2,2,0,2,0,1,0,2,0,0,2,2,0,0,0,0,1,0,1,2,0,2,1,0,0,2,1,2,1,0,2,0,1,2,0,0,0,1,2,2,0,2,0,0,2,2,0,0,1,1,1,2,2,2,2,2,2,0,0,0,0,1,1,0,0,0,0,0,1,0,0,2,0,0,1,1,1,0,0,0,2,0,0,0,1,0,0,0,0,2,0,1,0,2,0,2,0,0,1,2,0,0,2,0,1,0,0,2,0,0,0,0,2,2,0,0,0,0,0,0,2,1,0,1,1,0,1,0,1,0,0,1,0,0,1,1,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,0,1,0,1,2,0,0,1,1,0,2,1,2,1,2,0,0,1,1,0,2,1,0,0,1,0,2,0,0,1,1,2,0,2,0,0,0,0,2,1,0,2,0,1,2,0,0,0,0,2,2,2,0,2,0,2,0,0,1,0,0,1,1,1,0,1,0,2,0,1,0,0,2,0,2,2,2,0,1,2,1,1,2,0,1,1,1,0,0,2,1,1,0,0,2,10,0,0,1,1,1,2,1,1,0,0,2,0,0,0,1,10,10,2,10,10,10,10,0,0,10,1,0,0,0,0,2,2,0,1,2,1,2,2,2,2,2,1,0,1,2,2,1,1,2,0,2,0,1,0,0,1,2,1,0,0,1,0,0,0,1,2,0,1,2,2,2,0,1,2,0,0,0,2,2,0,0,1,2,0,0,0,0,2,0,1,0,0,2,1,1,0,1,0,2,0,2,2,0,0,0,0,2,0,0,1,2,2,0,0,2,0,0,0,0,0,2,2,1,0,2,0,0,2,2,2,0,1,1,0,0,2,0,0,0,0,1,1,0,0,0,0,0,0,0,2,0,2,2,2,2,1,2,1,0,2,1,0,0,1,0,0,2,0,0,2,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,2,1,2,0,0,2,2,2,0,0,1,2,2,0,0,1,0,1,2,2,0,0,1,0,2,2,0,1,0,0,2,2,2,2,2,2,0,0,1,2,0,2,0,0,0,1,2,1,0,0,0,0,2,0,2,2,0,2,2,0,1,1,2,1,0,2,1,1,0,2,1,2,1,2,2,0,0,0,1,1,0,1,1,1,2,0,0,0,1,0,2,0,0,1,0,1,2,2,1,0,0,2,1,1,2,0,2,2,0,2,1,2,10,10,10,10,10,10,10,1,2,0,0,10,10,1,1,0,0,2,0,0,1,2,0,10,10,2,2,1,2,0,0,1,0,0,1,0,1,2,0,0,0,0,1,2,0,2,0,1,1,1,0,2,0,1,0,0,1,0,0,0,1,0,10,10,10,10,10,0,1,0,0,0,1,0,0,2,0,1,0,2,0,0,2,2,0,1,2,0,2,0,1,0,2,0,0,1,1,0,1,1,0,1,0,0,0,1,0,2,0,0,2,1,0,0,1,1,0,1,0,0,0,0,0,1,0,0,1,2,2,0,2,0,2,0,0,0,1,1,1,0,0,2,0,0,0,1,1,2,0,2,0,2,0,0,0,2,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,2,0,1,1,0,0,0,1,1,7,7,0,2,0,1,0,0,2,0,0,0,2,0,1,2,0,2,1,1,1,2,0,1,2,2,0,0,0,0,0,2,2,0,1,1,1,0,0,1,2,0,2,1,1,1,0,2,0,0,0,0,1,1,2,0,1,0,0,1,0,1,0,2,2,0,2,2,1,0,2,0,2,1,0,2,0,0,0,2,1,2,2,0,1,1,2,0,2,0,0,2,2,0,1,2,2,0,2,2,0,0,2,1,0,10,10,10,10,15,10,10,0,2,2,2,0,10,10,0,1,2,0,1,0,2,1,1,0,10,10,1,1,2,2,1,0,1,2,0,0,0,0,0,0,0,0,1,0,1,0,2,1,2,2,0,1,1,1,0,0,1,0,2,1,2,1,10,10,0,2,0,2,2,1,0,0,1,0,0,0,0,2,2,1,2,0,1,0,0,1,1,1,2,2,0,0,0,2,0,1,0,2,0,0,1,2,2,0,0,1,0,0,1,0,0,2,2,0,0,0,0,0,1,0,0,0,0,0,0,2,0,0,0,1,1,1,0,0,2,2,0,2,2,2,0,1,1,1,1,0,1,0,0,0,0,1,2,1,2,2,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,0,1,1,0,2,0,2,0,7,1,1,0,0,1,0,0,2,0,2,0,1,2,0,0,0,2,0,1,0,0,0,0,2,0,2,0,1,2,0,0,0,0,0,2,2,2,1,1,2,0,1,1,2,0,2,2,2,2,0,2,2,0,0,2,1,0,0,1,1,1,1,0,0,0,1,0,2,0,1,2,0,1,0,1,0,0,0,0,0,1,2,2,0,1,2,1,0,1,1,2,1,0,0,2,1,2,0,2,1,2,0,1,2,2,10,10,10,10,10,10,1,0,0,0,0,1,10,2,1,0,0,0,0,0,2,2,1,10,10,0,0,2,0,1,1,0,0,0,1,0,0,0,0,0,0,2,2,0,0,0,0,0,0,1,0,0,0,0,0,2,0,0,0,0,1,0,10,10,2,1,2,1,0,0,2,2,0,1,2,1,1,1,0,2,2,0,0,1,2,2,0,0,2,2,0,1,1,2,2,2,2,2,2,2,1,1,2,0,0,0,0,0,0,0,1,1,0,0,2,2,0,0,2,0,0,0,1,1,1,2,0,1,2,0,0,1,0,1,0,0,2,0,2,0,1,2,2,0,0,0,1,0,0,1,2,2,2,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,0,0,0,0,0,1,2,0,2,1,2,0,2,2,2,2,2,2,2,2,2,0,2,2,0,0,2,0,1,1,1,1,2,1,0,1,0,1,0,2,0,1,0,0,0,0,2,2,0,2,2,0,0,0,2,2,0,2,0,2,1,1,1,2,0,0,1,1,2,1,1,0,0,0,1,0,0,1,2,1,2,0,0,2,0,0,0,2,0,0,0,1,1,0,0,0,0,2,1,2,0,0,2,0,1,1,2,2,2,0,0,1,2,1,10,10,10,15,10,10,2,10,10,10,0,1,0,1,0,0,1,0,1,0,0,0,1,0,0,10,10,0,10,10,0,2,1,0,0,1,0,0,0,1,0,2,0,0,2,0,0,1,0,0,0,1,0,2,0,0,1,1,0,2,2,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,2,0,2,1,2,0,0,1,0,0,0,2,0,1,2,0,0,1,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,2,0,0,0,2,1,0,2,0,2,0,0,0,2,1,0,0,0,1,1,2,2,1,1,0,0,0,0,0,0,1,2,2,0,0,0,2,1,1,2,2,0,13,13,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,1,0,2,0,2,0,1,1,1,2,0,1,0,0,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,1,0,0,0,0,0,1,0,1,2,0,2,0,0,2,1,1,1,2,0,2,1,0,2,0,0,0,0,1,0,1,1,0,2,0,2,1,0,1,0,0,0,1,0,0,0,1,2,0,1,0,2,2,0,0,2,0,0,0,2,1,2,2,2,0,1,1,0,1,0,2,0,2,0,1,0,2,0,1,1,0,2,1,2,1,0,10,10,10,10,10,10,10,10,10,10,0,0,1,0,1,2,2,2,0,2,0,0,0,0,1,10,10,15,10,10,10,2,0,2,2,1,0,0,1,0,2,0,1,0,1,1,0,2,2,2,0,1,2,0,2,0,0,0,1,2,0,2,0,0,0,0,2,2,2,2,0,1,0,2,0,2,1,0,0,2,0,0,0,2,0,0,0,0,0,1,0,1,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,1,2,2,0,1,0,0,1,1,2,2,0,0,1,0,0,1,1,0,0,1,0,2,1,0,2,1,2,0,2,1,2,2,0,2,1,2,0,0,2,2,1,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,1,0,1,2,0,0,2,1,0,0,2,2,1,1,0,2,2,2,2,2,2,2,2,2,2,0,2,2,1,2,2,0,0,0,0,0,0,0,0,0,1,1,1,2,1,2,0,0,2,0,0,0,1,2,0,0,1,0,0,2,0,2,2,2,0,0,0,0,1,2,1,2,1,2,0,0,0,2,2,0,1,1,0,1,1,0,2,2,2,0,2,2,1,0,0,0,1,1,2,0,1,0,0,0,2,1,2,0,0,1,0,0,2,1,0,0,10,10,10,10,10,0,1,1,10,10,0,0,2,1,0,0,1,0,0,2,0,0,1,1,10,10,10,10,10,10,0,0,0,1,0,0,0,1,1,0,2,0,2,1,2,0,0,0,2,0,2,0,0,0,1,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,2,0,0,0,0,2,0,0,0,0,2,0,2,2,0,1,1,0,2,0,0,0,2,1,2,2,2,2,2,2,7,7,2,2,2,2,2,2,2,1,1,0,2,0,1,1,0,2,1,2,0,1,2,0,2,0,0,0,2,0,2,0,0,1,0,0,1,0,0,0,0,0,0,0,1,1,0,0,2,0,0,0,2,0,13,13,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,1,2,0,2,7,7,2,2,0,1,0,2,2,0,2,2,2,2,2,2,2,2,2,2,2,0,2,1,2,2,2,0,0,0,0,0,1,0,2,2,0,2,0,0,0,1,1,0,2,2,0,0,2,1,0,1,0,2,0,2,2,2,2,0,1,1,0,1,2,0,0,0,1,0,1,1,2,1,2,0,2,0,1,0,0,2,2,1,0,1,0,1,1,0,0,2,1,0,0,1,1,0,2,2,1,2,1,1,0,1,10,10,10,10,2,0,10,10,10,1,1,0,2,2,0,10,1,1,2,0,0,1,0,0,2,1,1,0,0,0,2,0,2,10,10,10,2,2,2,0,2,2,2,0,1,0,0,2,1,1,0,0,2,1,0,0,0,2,1,1,0,2,0,0,1,0,0,0,1,0,2,0,2,0,2,1,1,2,0,1,1,2,0,2,1,1,1,0,1,2,0,2,0,0,1,0,1,0,1,1,2,2,2,2,2,2,2,7,7,2,2,2,2,2,2,2,2,0,2,0,1,0,2,0,1,2,0,0,2,2,0,0,0,0,0,1,1,2,0,2,2,0,1,0,2,1,0,2,1,2,0,0,1,2,2,0,2,1,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,0,1,0,0,7,7,0,7,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,0,0,0,1,1,0,2,2,2,0,0,2,0,1,1,0,2,2,0,0,2,2,0,2,1,1,2,0,0,0,0,1,0,0,1,0,1,0,1,2,1,0,0,1,0,0,2,2,1,0,1,1,0,1,0,0,2,2,0,1,2,0,2,0,0,0,0,1,0,1,2,2,1,0,0,0,0,0,2,0,0,0,10,0,2,10,10,10,10,15,10,10,1,1,1,1,0,0,1,0,2,1,1,10,10,2,1,1,2,0,0,0,0,0,10,10,10,10,2,0,1,2,0,0,0,2,0,0,2,0,1,0,2,1,0,0,0,0,2,0,2,1,1,0,2,0,0,0,1,0,0,0,0,0,1,2,0,0,0,1,0,1,0,1,2,0,1,2,0,0,0,0,2,0,1,2,0,0,2,2,2,2,2,0,1,2,2,2,2,7,7,2,2,2,2,2,2,2,2,1,0,0,2,1,0,1,2,0,0,2,1,0,0,0,0,1,0,0,1,1,1,1,0,0,2,1,2,0,0,2,2,13,0,2,2,0,1,0,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,0,2,2,0,2,7,7,1,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,0,0,0,0,0,2,2,0,1,2,2,0,0,2,2,0,1,0,0,0,1,0,1,2,1,0,0,0,1,0,1,2,1,0,0,0,1,0,0,0,1,2,2,2,1,0,2,0,1,1,2,0,0,0,2,1,2,2,0,2,2,0,0,0,0,0,0,1,0,1,1,1,2,0,0,1,0,1,0,0,0,0,0,0,10,10,10,10,10,1,1,1,1,1,0,1,0,0,0,0,10,10,0,0,0,1,1,0,0,2,0,2,10,10,10,10,2,0,0,0,0,1,2,1,0,0,2,0,1,1,0,0,2,0,2,2,0,0,1,0,2,0,0,1,0,1,0,1,0,0,1,0,1,0,0,0,2,2,0,0,2,0,1,1,2,2,1,2,2,2,0,1,2,2,2,2,2,2,2,2,2,1,1,0,2,2,7,7,7,2,2,2,2,2,2,2,2,2,2,1,2,0,1,0,0,1,0,1,2,1,0,0,1,1,0,2,1,2,2,1,2,1,2,0,0,0,2,0,13,13,13,0,2,0,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,0,0,0,0,0,0,7,0,0,2,1,0,1,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,1,0,2,0,0,0,1,0,1,0,0,0,0,1,2,0,0,0,0,0,0,1,1,0,0,2,1,0,0,0,0,2,0,1,1,0,0,2,0,2,0,2,0,1,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,1,0,0,0,0,0,1,1,2,1,0,2,0,0,2,2,0,1,0,0,10,10,1,0,1,1,1,1,1,1,1,0,0,0,0,1,10,2,0,0,0,2,2,2,1,0,0,2,2,0,1,1,0,1,2,1,0,0,0,1,2,0,0,2,0,1,0,0,1,2,2,0,0,2,1,0,2,1,2,0,2,2,2,0,0,0,1,0,1,1,2,2,2,0,0,0,2,0,0,2,0,0,1,0,0,1,2,0,2,2,2,2,2,2,2,2,2,2,0,0,7,7,7,7,2,2,2,2,2,2,2,2,2,0,0,2,2,0,1,2,0,0,0,2,0,1,0,1,0,0,2,0,2,1,0,0,2,2,0,2,0,2,2,13,13,13,13,2,0,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,0,0,1,1,1,2,0,0,0,2,0,2,0,2,0,1,1,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,1,2,0,1,1,1,0,0,0,1,1,0,2,0,2,0,2,0,0,2,1,0,0,2,1,1,0,2,1,2,2,2,2,0,1,0,0,1,2,2,0,2,2,2,0,0,0,0,1,0,0,1,2,1,2,0,0,2,0,0,0,0,1,0,0,0,0,1,1,0,2,0,1,2,2,2,0,0,2,2,2,2,2,2,2,1,1,1,10,0,0,1,1,1,1,1,1,1,1,1,0,2,0,10,1,1,0,1,0,0,0,1,0,2,0,1,0,0,2,0,2,1,2,1,0,2,2,1,0,0,2,1,0,2,0,0,2,0,0,0,1,0,0,2,1,2,0,2,0,2,1,2,2,0,1,1,0,1,0,0,1,1,1,1,2,1,2,0,1,2,0,1,0,2,0,2,2,2,2,2,2,2,2,2,2,2,7,7,7,7,7,2,2,2,2,2,2,2,2,0,1,0,0,0,0,0,0,0,1,1,1,2,1,0,0,1,1,2,0,0,1,0,1,1,1,2,1,2,2,0,0,13,13,1,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,0,0,0,1,2,0,1,0,1,2,0,0,1,0,0,0,0,0,1,0,2,2,2,2,2,2,2,2,2,0,1,0,0,0,0,0,0,2,0,0,0,0,0,0,2,1,1,1,1,0,0,0,0,2,1,2,0,0,1,2,0,1,1,0,0,2,1,0,0,0,1,2,0,1,0,2,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,2,0,0,0,1,0,2,0,0,1,0,1,2,1,1,0,2,2,1,1,2,0,0,0,2,0,0,2,0,0,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,0,10,10,10,2,11,0,2,0,1,1,0,2,0,1,2,0,0,0,2,1,0,0,2,1,1,0,1,1,1,2,1,1,0,1,1,0,0,1,1,0,1,0,2,0,0,1,1,2,2,0,2,0,0,0,1,1,0,1,0,0,0,1,0,0,0,2,2,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,7,7,7,7,7,2,2,2,2,2,2,2,0,2,1,1,2,0,0,0,2,0,0,2,0,1,0,1,1,0,2,0,2,0,0,1,3,0,0,0,3,1,2,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,2,0,0,2,2,0,1,1,0,0,1,1,2,2,0,0,2,0,1,1,1,2,0,1,1,2,2,2,2,2,2,0,1,1,2,2,0,0,2,1,0,2,1,1,0,0,1,0,0,1,1,0,1,1,2,2,1,0,0,0,2,2,1,0,1,1,0,0,1,0,2,0,2,0,2,1,2,0,1,0,1,1,0,2,0,1,2,0,0,1,1,0,2,2,1,2,2,0,1,0,2,0,0,0,1,0,2,2,0,1,1,0,0,2,2,0,2,1,0,2,0,2,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,0,1,1,0,10,10,10,0,11,1,1,0,1,1,0,0,0,1,0,0,0,0,0,2,2,1,0,12,0,0,2,2,2,0,1,2,0,2,0,1,0,2,0,0,2,0,2,0,1,0,2,0,1,2,0,0,2,2,2,0,1,2,0,0,2,0,0,0,1,2,1,1,0,0,0,2,0,2,2,2,2,2,2,2,2,2,2,2,2,7,7,2,2,2,2,2,2,2,2,2,2,0,2,1,0,2,0,0,0,0,0,1,2,2,1,0,1,0,2,3,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,0,1,0,0,2,2,0,2,0,1,2,1,0,0,2,2,2,2,0,0,1,2,0,0,1,2,1,0,1,0,0,1,0,2,1,2,0,1,1,0,1,0,2,0,0,2,1,1,1,2,1,1,2,2,0,1,0,0,0,0,2,1,2,0,0,0,0,1,1,0,2,2,0,1,2,2,0,0,1,0,0,2,1,1,1,1,0,0,0,0,0,0,0,1,1,0,0,2,1,1,2,2,2,1,0,1,0,2,0,0,1,0,0,0,2,1,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,0,1,1,1,0,1,0,0,0,2,2,0,11,11,1,0,0,2,0,1,0,0,0,1,0,0,1,2,0,11,12,12,12,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,2,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,2,0,2,0,2,2,0,1,1,0,0,0,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,1,0,1,2,1,0,0,1,1,0,0,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,1,2,0,1,0,2,2,1,0,1,1,2,0,2,2,2,2,2,2,1,0,1,0,0,2,2,0,1,0,1,0,1,0,0,1,0,0,0,1,2,1,0,0,0,2,2,0,0,2,1,0,2,0,0,0,0,1,0,2,2,0,0,2,0,2,2,1,2,0,0,0,1,0,0,0,0,0,0,1,2,0,1,0,2,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,10,1,0,1,0,0,0,2,2,0,2,1,0,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,0,0,2,1,2,0,2,11,0,2,2,0,2,0,1,0,2,0,0,1,0,1,0,0,11,11,0,0,12,12,0,0,2,1,1,1,1,2,1,0,0,1,1,1,2,0,2,0,0,0,0,0,0,2,0,1,0,2,0,1,1,0,2,2,1,2,0,2,0,0,2,0,0,1,1,1,0,0,1,2,1,2,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,2,0,0,0,1,0,2,0,0,0,0,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,0,1,0,1,0,1,0,0,1,0,2,2,2,2,2,2,2,2,2,2,0,1,1,1,0,2,1,1,1,0,2,2,0,0,1,0,0,0,2,2,0,0,0,0,1,0,0,0,0,1,1,0,2,2,2,0,1,0,2,0,2,0,0,0,0,1,0,0,2,2,0,0,2,0,0,1,0,1,2,2,0,0,2,0,0,1,0,2,0,1,2,2,0,0,2,1,0,1,2,2,2,10,10,0,0,1,2,1,2,0,2,1,1,1,1,2,1,0,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,10,10,0,1,0,0,0,2,1,2,0,1,0,0,0,2,0,2,0,11,11,11,11,11,0,1,0,2,1,1,0,0,2,2,0,1,0,2,0,1,0,1,0,1,2,2,2,1,0,0,0,1,1,1,0,0,2,0,0,1,1,0,2,0,1,1,1,0,1,0,2,2,2,0,2,0,2,2,1,0,2,0,2,1,0,0,2,2,2,2,2,2,2,2,2,2,0,1,1,1,0,0,1,2,0,2,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,1,0,0,0,1,2,0,1,2,2,0,2,2,2,2,2,2,2,2,2,0,2,1,1,0,0,2,2,0,1,1,2,1,1,1,1,2,1,0,0,0,0,0,2,0,0,0,0,2,0,0,0,2,0,0,0,0,1,1,2,0,1,2,0,0,0,0,0,2,2,0,0,0,0,0,0,2,2,1,0,0,0,1,0,2,0,0,0,0,1,0,0,0,0,2,2,2,2,1,0,1,0,0,0,0,0,0,2,1,0,0,0,0,2,0,0,1,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2,2,1,1,1,1,1,0,0,1,1,0,1,0,2,0,0,0,2,0,0,1,0,0,0,1,2,0,2,0,2,11,11,11,3,11,11,2,1,0,0,0,2,1,0,2,2,1,0,0,0,0,2,0,2,0,1,0,2,0,1,1,0,0,0,0,1,0,1,1,0,2,1,2,0,1,1,2,0,0,0,1,0,0,2,0,0,0,0,0,2,1,0,2,2,0,1,2,2,0,0,0,1,1,0,0,1,2,0,1,1,0,1,2,0,0,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,1,0,0,0,2,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,0,2,1,1,0,1,1,2,0,0,0,0,0,0,0,2,2,2,0,0,2,0,0,1,2,2,2,2,0,1,0,0,2,2,1,0,2,1,1,1,2,0,1,2,0,0,2,0,1,1,0,2,0,0,2,2,0,0,2,0,0,2,2,0,0,1,2,0,0,2,0,2,0,2,0,0,1,1,1,1,0,0,2,2,0,2,1,0,2,1,0,0,1,0,0,1,0,0,1,0,0,1,1,1,1,1,1,1,2,2,2,2,2,2,2,1,1,1,0,0,0,0,0,2,2,0,0,2,0,0,0,1,1,0,0,0,0,2,2,2,0,12,12,11,11,11,11,11,0,1,2,2,0,2,2,0,1,0,0,0,0,13,0,0,0,1,0,0,0,0,0,1,2,1,0,0,2,2,2,1,1,0,0,1,2,0,0,1,2,0,1,1,0,1,0,1,1,2,0,1,1,1,0,1,1,1,2,2,2,0,0,0,1,0,0,1,0,1,0,0,1,0,2,2,0,2,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,1,7,7,2,2,0,0,1,2,0,0,0,2,2,2,2,2,2,2,2,1,0,0,1,1,0,1,2,0,2,1,0,1,0,0,1,0,1,2,0,0,1,2,2,1,2,0,1,0,0,0,1,0,0,1,0,2,2,0,0,2,2,0,0,1,0,0,2,2,0,1,0,2,1,0,0,1,0,0,1,1,0,2,1,0,1,1,1,1,2,2,0,0,2,0,1,0,0,2,2,2,0,0,0,2,0,0,1,0,1,0,0,0,0,1,0,2,0,1,1,0,2,2,1,1,1,1,1,1,2,2,1,2,2,2,2,2,1,0,0,2,1,1,0,2,2,0,1,0,0,2,0,0,0,0,0,0,0,0,1,0,12,12,11,11,11,11,11,11,11,2,0,0,0,2,1,2,0,2,0,1,13,13,13,0,1,1,0,0,1,1,1,0,0,0,1,0,0,0,1,1,0,0,0,1,1,2,2,2,1,1,0,0,0,0,0,2,2,2,2,0,0,1,0,0,2,2,0,0,0,1,0,0,0,1,1,0,0,0,0,1,2,0,0,1,2,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,2,2,0,2,1,1,0,2,0,2,1,0,0,2,2,2,2,2,2,2,0,0,2,0,1,0,2,1,0,0,0,0,2,0,0,1,2,0,0,0,0,0,0,0,1,2,1,0,0,2,0,1,1,2,2,2,0,1,1,2,0,1,0,1,2,1,1,1,1,0,1,0,1,0,0,0,0,2,0,2,1,2,2,1,0,2,1,2,2,0,2,2,0,2,0,0,2,2,0,1,0,0,2,1,1,0,2,2,0,0,1,1,0,0,2,0,1,0,2,0,1,2,0,1,0,1,1,1,1,0,2,2,1,1,2,2,2,2,2,0,2,2,1,2,2,2,2,2,0,1,1,0,2,2,2,1,1,1,1,1,2,0,11,11,3,11,11,11,11,11,11,0,0,0,0,0,0,1,2,2,0,0,13,13,13,1,2,0,1,0,0,0,2,2,0,2,2,2,1,0,1,2,0,0,0,1,0,2,2,2,0,0,0,0,2,1,2,0,1,1,2,1,2,0,0,0,1,1,2,0,0,2,2,1,0,2,1,0,1,1,0,2,1,1,2,1,2,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,2,0,0,7,0,2,2,0,0,2,2,2,2,0,1,2,2,2,2,2,2,1,0,2,0,0,1,0,2,0,0,1,2,0,2,1,0,1,0,1,1,2,1,2,0,1,1,0,2,0,0,2,1,2,1,0,2,0,1,2,0,0,1,0,1,1,1,1,1,1,1,1,1,2,1,2,0,0,2,1,0,0,0,0,1,0,2,0,2,2,1,0,0,0,1,0,2,2,1,0,1,2,2,0,2,0,0,0,0,0,2,0,1,0,0,0,2,1,2,0,0,2,1,1,0,0,1,1,2,2,2,2,2,2,2,2,2,2,0,0,2,0,2,1,0,1,2,2,2,1,0,2,1,0,0,2,1,1,1,1,1,1,1,2,11,11,11,11,11,11,11,11,0,0,0,0,0,1,1,0,0,2,0,1,13,1,1,0,0,1,0,1,0,0,2,0,2,0,1,0,0,2,2,2,0,1,0,1,1,0,0,0,0,1,1,1,1,0,0,1,1,2,0,0,2,2,0,0,2,2,2,0,2,0,1,1,1,0,0,0,2,1,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,0,1,2,1,2,1,2,0,1,0,0,0,0,0,0,2,0,1,2,0,0,0,1,0,0,1,2,0,1,2,2,0,0,2,0,2,0,0,1,1,2,0,2,0,0,2,0,2,0,2,0,2,0,0,1,0,2,1,0,2,2,0,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,1,2,0,0,2,2,1,2,1,1,2,1,1,0,2,1,0,0,0,0,0,1,0,0,1,2,0,1,2,0,2,2,0,1,0,0,0,2,0,2,1,1,1,2,0,0,1,0,1,2,2,2,2,2,2,2,2,2,2,2,0,0,0,2,2,1,0,0,0,0,1,0,2,0,2,2,1,1,1,1,1,1,1,1,1,2,2,1,11,11,11,12,11,11,2,1,0,0,1,10,10,0,1,1,1,0,1,2,0,2,2,2,1,0,2,1,1,0,0,2,2,2,2,2,2,2,0,2,2,0,0,0,0,0,2,0,2,0,1,2,0,2,2,0,0,0,2,0,0,0,0,2,1,2,2,1,13,1,13,1,2,1,2,1,1,0,2,0,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,7,7,1,2,2,0,0,1,1,1,0,2,1,0,0,0,0,1,2,0,2,0,0,0,1,2,1,0,2,2,0,2,0,2,0,1,1,1,2,0,0,0,2,0,2,1,1,2,1,2,0,0,0,1,1,0,0,0,0,0,0,2,0,1,0,1,1,1,1,1,1,1,1,1,1,0,1,0,2,1,2,1,1,0,0,2,2,2,0,0,0,0,2,1,2,1,2,2,0,0,2,0,1,1,0,0,2,1,2,2,1,2,0,0,0,0,2,2,0,2,0,2,0,0,0,0,0,2,0,2,2,0,2,2,2,2,2,0,2,1,2,0,0,0,0,0,0,0,2,0,2,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,12,12,12,11,11,1,2,0,0,0,1,10,10,0,2,0,0,2,2,0,0,2,1,2,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,1,1,0,1,1,0,1,2,1,1,1,0,2,0,2,2,0,2,1,0,0,1,0,2,1,13,13,13,13,13,0,0,0,0,1,0,2,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,7,7,7,7,7,0,1,0,1,1,1,1,2,2,1,0,1,1,1,0,0,0,0,0,0,0,0,2,0,0,2,0,1,1,2,1,2,0,0,1,0,0,2,1,1,1,0,2,1,0,0,2,0,0,1,1,0,1,1,0,0,0,2,2,0,1,1,1,1,1,1,1,1,1,1,1,0,2,0,0,0,0,0,2,0,1,0,0,1,0,0,0,2,1,1,2,2,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,1,1,2,0,0,2,0,0,1,0,2,2,2,1,0,2,2,0,0,1,0,2,2,2,2,2,0,2,0,1,0,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,12,0,12,0,2,0,1,1,0,2,0,0,10,10,10,1,2,0,0,1,0,0,2,0,0,1,0,1,2,2,2,0,2,2,2,2,2,2,2,2,1,1,0,0,0,2,1,0,2,1,2,2,1,1,1,1,0,1,2,0,1,0,0,0,2,0,0,13,0,13,13,13,2,2,2,2,0,0,1,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,7,2,0,1,0,2,0,0,2,2,2,0,0,1,0,0,1,2,0,0,0,1,1,2,1,0,0,1,0,0,1,1,0,0,0,1,1,0,0,2,2,0,2,1,0,0,1,0,1,0,1,0,2,1,1,2,0,2,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,0,1,1,0,2,2,0,0,2,0,2,2,2,2,0,2,0,0,0,1,0,0,2,2,2,0,0,2,2,2,0,1,1,1,2,1,2,2,1,0,2,1,0,0,0,0,0,0,0,2,0,2,0,0,0,1,0,2,2,2,2,0,1,1,1,0,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,0,1,2,1,1,0,11,1,1,0,1,2,1,0,0,1,2,0,1,1,2,0,0,1,0,1,0,0,0,0,1,2,2,2,2,0,2,2,2,2,2,2,2,0,0,2,1,0,1,1,0,0,0,0,0,0,0,0,1,2,0,0,1,0,2,0,1,0,1,2,2,0,2,0,13,2,0,13,0,0,0,1,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,0,2,0,0,2,0,2,1,1,0,1,1,1,0,0,1,0,1,0,0,0,2,2,0,0,1,0,1,0,0,2,2,0,0,0,1,0,1,2,0,0,0,2,1,1,1,2,0,0,1,0,0,0,1,0,0,1,2,2,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,0,0,2,0,0,1,2,0,0,1,0,2,2,2,0,0,2,1,0,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,2,1,1,0,0,2,0,0,0,0,0,2,2,1,0,0,2,2,2,0,2,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,0,0,2,2,2,0,0,0,1,0,1,2,1,2,2,0,0,0,1,0,0,13,0,0,2,0,2,0,0,0,0,0,2,2,2,2,2,0,0,1,2,2,2,2,0,0,0,1,0,0,0,0,2,0,0,0,0,0,2,1,0,0,0,0,0,0,2,0,0,0,1,1,2,1,0,2,0,13,13,13,0,1,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,0,0,2,0,2,1,2,2,2,0,2,0,2,2,0,2,1,1,1,1,1,0,0,0,1,1,2,0,0,2,0,2,1,1,0,1,0,0,1,0,2,2,0,1,0,0,0,2,0,2,1,0,2,0,2,0,1,1,0,1,2,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,2,2,0,0,1,0,1,0,2,0,2,0,1,0,0,1,0,1,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,2,0,2,0,0,0,0,1,0,2,0,0,0,0,1,1,1,1,0,0,0,1,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,0,2,1,1,1,0,0,0,1,0,2,2,2,0,0,2,0,0,2,0,13,13,13,1,1,0,2,2,0,0,0,1,2,2,2,2,2,2,2,0,2,2,2,0,1,1,0,0,2,1,1,0,0,0,2,0,1,1,0,2,2,0,0,0,1,0,2,0,0,2,0,2,1,0,13,13,13,13,13,13,2,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,1,0,2,0,2,0,2,0,0,0,0,1,0,1,0,0,0,0,0,1,0,1,0,2,0,1,0,2,1,2,2,0,0,1,1,1,2,0,1,1,0,2,2,0,1,0,0,0,1,2,0,0,0,0,0,0,2,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,0,0,2,2,0,0,2,1,2,0,0,0,0,2,2,2,0,0,1,0,1,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,0,2,0,2,2,0,0,2,0,0,2,1,0,1,0,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,0,2,0,0,0,1,1,1,1,0,0,0,0,0,2,0,2,2,2,0,2,1,0,0,13,13,13,13,0,1,1,2,1,1,2,0,0,2,2,2,2,2,2,2,1,0,0,0,2,2,1,1,1,2,0,0,0,0,0,2,0,2,2,0,2,2,1,0,1,2,1,1,0,0,0,2,0,13,13,13,13,13,13,1,0,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,2,2,0,1,1,1,1,1,1,2,0,2,0,2,0,2,1,0,2,1,0,2,1,1,0,1,2,1,0,0,0,2,2,0,2,1,1,2,0,1,1,2,1,1,0,0,0,0,0,2,0,1,1,0,2,2,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,1,0,2,0,2,0,2,0,0,2,0,1,2,2,0,0,0,0,0,1,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,1,2,0,0,2,2,2,0,2,0,1,2,1,0,0,1,2,0,2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,0,0,1,2,2,1,0,0,2,0,0,0,0,0,0,0,0,0,0,2,0,1,2,13,13,13,13,13,13,1,2,1,0,0,0,1,2,2,2,2,2,2,2,2,2,2,0,0,0,1,0,2,1,2,0,0,2,0,0,1,2,0,0,2,1,1,1,0,0,1,0,0,2,1,13,13,0,0,13,13,13,13,0,1,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,0,0,0,1,2,2,0,0,1,2,1,0,0,0,0,0,1,2,0,0,1,0,2,0,0,0,2,2,0,0,2,0,2,1,0,0,2,0,0,2,2,2,1,0,2,0,0,2,0,0,0,0,0,1,2,1,0,1,0,0,2,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,0,2,1,2,0,1,0,0,0,2,0,1,0,0,2,2,0,0,0,2,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,1,0,0,1,2,0,2,0,1,2,0,0,0,0,0,2,0,2,0,2,2,2,2,2,1,0,0,0,2,2,2,2,2,2,2,2,2,1,0,1,2,2,0,1,2,1,0,2,0,2,1,0,2,0,0,1,1,0,2,2,0,2,0,1,0,2,13,13,13,13,13,13,13,0,1,0,1,2,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,1,0,0,1,0,2,0,2,0,0,1,0,1,2,0,1,2,0,2,0,2,2,1,13,13,13,13,0,0,13,13,13,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,2,0,1,0,0,1,0,0,0,2,1,0,1,2,2,0,0,2,1,1,1,2,1,1,0,1,1,0,0,0,1,0,0,0,2,0,2,0,2,0,0,0,0,0,1,0,0,1,0,2,2,0,0,0,2,0,2,0,0,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,2,1,1,0,1,2,0,1,0,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,1,2,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,2,0,2,2,1,1,1,1,0,0,1,0,0,0,0,0,0,2,2,1,1,1,2,2,2,2,1,2,2,2,2,2,2,2,2,2,1,1,1,1,0,1,0,0,2,1,2,2,1,1,0,0,0,1,0,2,0,0,2,1,0,2,2,1,0,0,0,13,13,13,13,13,13,13,13,1,1,2,1,1,1,2,2,2,2,0,2,2,2,2,2,2,0,0,0,1,2,2,1,0,1,0,0,0,2,0,1,0,0,2,0,0,13,13,13,0,13,13,13,13,13,13,13,0,1,13,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,0,2,0,2,1,1,0,2,0,0,1,1,0,1,0,0,2,0,0,0,0,1,0,0,0,2,0,2,0,0,0,0,0,0,0,1,2,0,0,0,2,1,0,0,1,2,0,1,0,1,0,0,1,1,0,0,0,0,1,0,2,0,2,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,2,0,0,0,0,2,2,1,1,0,0,0,2,1,1,0,1,2,1,2,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,1,2,2,0,2,1,0,1,1,1,1,1,2,1,2,2,0,2,0,2,2,0,2,0,0,2,2,2,2,0,2,2,2,2,2,2,2,2,1,1,1,1,2,0,0,10,10,0,0,0,1,2,2,2,1,2,2,1,1,0,0,0,2,0,0,1,0,2,1,2,13,13,13,13,13,13,13,13,2,0,2,0,0,2,2,2,2,2,2,2,2,2,2,0,0,0,0,2,0,0,0,0,1,0,0,1,0,2,2,0,0,1,0,0,13,13,13,13,13,13,13,13,13,13,13,2,0,2,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,2,0,2,1,0,1,1,1,0,1,1,2,0,0,0,0,1,0,1,0,1,0,0,1,0,1,0,1,0,1,0,0,0,2,1,0,0,0,0,0,0,2,0,1,0,0,0,0,1,0,0,1,1,0,2,0,0,0,0,1,2,1,0,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,1,2,2,0,2,0,1,0,0,1,0,1,0,1,1,2,2,0,0,2,2,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,1,2,0,2,2,0,2,0,1,1,1,1,1,1,1,1,1,1,1,0,2,0,1,0,1,0,0,0,0,0,1,0,0,0,0,2,2,1,2,2,7,7,7,1,1,1,1,0,0,0,10,10,0,1,0,0,1,2,1,0,2,0,1,1,0,0,0,2,1,0,2,0,2,2,0,1,13,13,13,13,13,13,13,0,2,2,0,2,2,2,2,2,2,2,2,2,2,2,0,0,1,1,1,0,1,2,0,0,0,0,0,1,2,0,0,2,0,0,0,13,13,13,13,0,13,13,0,2,0,1,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,2,0,1,0,2,2,0,0,0,0,0,0,0,1,1,1,1,0,2,1,0,2,0,0,2,0,0,2,0,1,2,0,2,0,2,0,0,1,0,0,2,0,0,2,1,0,1,0,0,0,2,1,0,2,2,2,1,1,0,0,0,1,2,1,0,2,2,1,2,0,2,0,1,1,1,1,1,1,1,1,1,0,2,0,1,0,1,0,0,0,0,0,0,2,2,2,1,0,0,1,0,1,2,2,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,2,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,1,0,1,0,1,0,1,0,0,2,2,2,2,1,2,2,1,2,2,7,7,7,1,1,1,0,2,2,0,0,2,0,2,0,2,2,1,0,0,0,1,0,0,2,2,0,0,1,0,0,0,0,0,2,1,2,13,13,13,13,13,0,1,0,0,0,0,2,2,2,2,2,2,2,2,2,2,1,1,1,2,0,2,2,0,1,0,0,0,2,1,1,1,0,1,0,0,2,0,13,13,13,13,13,13,13,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,0,1,1,1,0,2,0,2,0,0,0,0,0,2,0,0,0,1,0,0,1,1,0,0,2,0,1,0,0,2,0,0,1,0,0,0,1,0,0,2,2,1,0,0,0,0,0,1,2,2,0,2,2,0,0,2,2,0,1,1,2,1,0,2,1,0,1,1,0,2,0,2,0,0,1,0,0,2,1,1,1,1,1,1,1,1,0,0,0,0,0,2,1,0,2,0,0,0,2,0,0,0,2,1,2,2,2,0,1,2,2,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,2,0,1,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,0,2,1,1,0,0,0,0,2,2,2,2,2,2,2,2,2,7,7,7,7,1,1,1,2,2,1,1,2,1,0,1,0,0,0,2,2,0,0,2,1,2,2,0,0,0,0,2,1,2,0,0,0,2,0,0,2,13,13,13,1,0,1,1,2,2,2,2,2,2,2,2,2,0,0,0,0,2,2,1,0,0,0,0,0,0,0,1,1,13,13,13,13,13,1,0,0,2,1,0,2,13,2,0,13,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,0,2,0,0,0,1,0,1,1,0,1,1,1,0,0,0,1,0,0,0,2,2,2,2,0,2,0,0,1,0,0,2,0,2,0,2,0,0,0,2,0,0,0,2,0,1,0,1,0,2,1,2,0,2,1,0,2,2,1,0,0,0,2,0,0,2,0,0,2,0,0,0,2,0,0,1,2,0,0,0,2,0,1,1,1,1,1,1,2,0,0,0,0,1,1,0,0,2,0,1,2,0,0,1,0,0,0,0,0,0,0,0,2,1,2,0,1,1,1,1,1,1,1,1,1,1,1,2,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,0,1,0,2,2,2,2,2,2,2,2,2,0,2,2,2,2,2,7,7,7,1,1,0,0,0,0,0,2,0,0,1,1,0,1,0,1,1,0,0,1,0,0,0,1,0,1,1,0,0,0,1,0,0,2,2,0,2,2,1,0,0,0,2,1,2,2,2,2,2,2,2,2,2,1,0,0,0,0,2,0,1,0,2,1,0,0,13,13,13,13,13,13,13,13,13,0,1,0,0,2,1,2,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,2,0,2,2,0,0,0,1,2,2,0,0,1,0,0,2,0,0,1,2,1,0,0,1,2,1,1,1,1,1,2,0,0,0,0,2,0,1,1,2,2,0,0,0,0,0,2,2,1,1,2,0,1,0,1,2,0,2,0,0,0,2,0,2,2,2,0,0,0,0,1,0,0,0,0,1,2,0,0,0,2,0,1,1,2,1,1,1,2,1,1,1,1,2,2,0,0,1,2,0,2,1,0,2,0,0,1,0,2,0,0,0,0,2,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,0,2,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,2,0,0,2,0,0,0,0,1,0,1,2,0,0,1,0,1,1,0,1,2,1,0,2,2,1,0,0,0,2,0,0,2,0,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,0,1,1,1,2,0,0,0,2,1,0,0,0,0,13,13,13,13,13,13,13,13,13,0,2,0,0,2,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,2,0,2,2,0,0,0,0,1,0,2,0,1,0,0,0,1,1,1,0,1,0,1,1,0,0,0,2,0,0,1,2,0,1,1,1,1,0,2,1,0,0,1,0,0,1,0,0,0,1,2,0,0,0,1,2,0,2,1,0,2,0,0,2,0,0,0,0,1,0,2,2,2,2,0,1,1,2,0,0,1,0,0,1,0,0,0,1,1,2,2,0,0,1,1,0,2,0,0,1,2,1,1,2,1,2,0,0,2,1,1,0,2,0,2,2,2,1,2,2,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,15,0,1,1,2,2,2,2,2,0,2,2,2,2,2,2,1,2,2,2,2,2,1,2,2,2,0,0,2,2,0,1,1,0,2,1,2,1,1,2,0,0,1,0,0,0,2,0,0,1,1,1,1,0,0,1,0,0,2,0,0,2,0,1,2,2,2,2,2,2,2,2,0,0,1,2,0,0,2,0,2,0,0,0,2,0,1,13,13,13,13,13,13,13,13,13,1,1,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,15,2,0,2,1,0,2,0,0,1,1,1,1,0,0,0,1,2,0,0,0,0,2,0,1,0,0,1,0,0,0,2,0,0,0,1,0,1,0,2,1,0,0,0,0,2,1,2,0,0,1,0,2,1,0,0,1,0,1,0,0,0,2,1,0,0,2,1,1,2,2,0,2,1,2,1,2,0,0,0,0,2,1,0,0,1,0,2,1,0,1,0,2,2,2,0,0,0,0,0,2,1,0,0,0,1,0,0,0,1,0,2,1,2,0,0,2,1,1,0,0,2,2,1,0,1,1,1,1,1,1,1,1,1,1,2,2,1,0,2,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,2,2,2,1,0,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,0,0,2,1,0,1,0,2,0,0,1,0,1,1,0,0,2,2,2,1,0,1,0,1,0,1,2,2,0,1,2,0,1,0,2,2,2,2,2,2,2,0,0,0,0,0,0,2,2,2,2,2,0,2,1,0,1,0,13,13,13,13,13,13,13,13,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,1,0,0,1,1,0,2,1,0,0,0,0,1,0,1,1,0,1,2,0,0,2,1,0,0,2,0,2,0,1,0,0,0,1,2,2,2,0,0,2,0,1,0,0,1,0,0,2,0,2,0,2,1,0,1,2,0,2,0,0,2,2,0,0,2,0,0,0,0,0,0,0,1,1,2,2,1,2,0,0,1,0,0,0,0,0,2,1,2,0,0,0,0,0,0,1,0,1,0,0,0,2,1,0,0,2,0,1,0,0,0,1,1,2,1,1,1,0,2,0,1,2,1,1,1,1,1,1,1,1,2,2,1,2,0,2,0,2,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,2,0,0,0,1,0,1,2,2,0,0,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,1,0,0,10,10,10,0,2,2,2,0,2,0,2,0,0,1,0,0,0,2,2,0,0,0,0,1,0,0,0,0,1,2,0,0,0,2,2,2,2,1,1,0,0,0,0,0,1,0,0,1,1,0,0,2,0,0,0,0,2,13,13,13,13,13,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,0,1,1,2,0,0,2,0,1,2,0,2,0,1,1,1,0,0,0,1,1,2,1,0,0,2,0,0,0,0,2,2,0,2,0,0,0,0,2,0,0,0,1,2,0,2,2,0,2,1,0,2,2,2,0,0,0,1,1,1,0,1,2,0,0,2,1,0,2,0,0,0,1,1,1,1,0,2,0,2,0,1,1,0,1,0,1,2,2,0,1,0,1,2,2,1,0,0,2,1,2,2,2,1,0,0,1,1,1,2,0,0,0,0,1,2,1,0,0,2,0,1,2,0,2,0,1,1,1,1,1,1,0,0,2,1,0,0,0,0,0,1,0,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,0,1,1,2,2,0,1,0,0,1,2,2,0,1,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,1,0,0,10,2,1,0,0,2,1,0,0,0,2,0,2,1,2,0,2,2,0,2,0,0,2,2,2,2,2,0,0,0,1,1,2,2,1,0,0,0,0,0,2,2,1,0,0,1,1,1,0,2,2,0,0,1,1,1,13,13,13,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,0,2,0,1,0,0,2,0,2,2,2,0,1,2,2,0,2,0,0,0,0,1,1,2,0,1,0,0,0,2,0,0,0,2,2,2,0,2,2,0,2,1,0,2,1,2,1,0,2,1,2,2,0,0,0,0,0,2,0,2,2,2,0,2,0,1,2,0,0,1,0,0,0,1,2,0,2,2,0,0,0,0,0,0,2,0,1,2,1,1,0,1,2,0,0,0,2,2,1,1,0,0,1,2,0,2,2,2,2,1,0,0,2,0,0,1,0,0,1,1,0,0,0,0,2,0,2,2,1,1,1,1,2,0,1,1,2,0,0,2,0,2,2,0,1,1,2,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,0,3,0,0,1,0,2,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,1,1,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,2,1,0,2,0,0,1,0,2,0,2,1,1,2,1,1,0,0,2,0,1,2,0,0,2,2,1,1,0,2,1,1,0,1,0,1,0,0,1,13,13,13,13,13,13,0,1,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,1,1,2,1,0,0,1,1,1,0,1,1,0,2,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,2,1,0,2,1,1,0,2,0,0,0,0,1,0,0,0,0,2,1,2,2,0,1,2,2,0,0,1,1,1,1,0,0,0,2,2,0,0,0,0,1,0,1,0,0,0,2,0,1,0,1,1,0,1,1,2,0,0,0,0,0,2,2,0,2,2,2,2,1,0,2,2,1,2,2,1,0,1,0,1,0,0,1,2,0,0,2,0,2,0,0,1,2,1,1,1,0,0,0,1,1,1,0,1,2,0,1,0,0,1,1,0,2,0,0,1,1,1,1,1,1,1,1,1,1,1,1,2,1,0,1,1,0,0,0,0,3,0,0,1,2,2,0,1,1,2,2,0,1,1,2,2,2,2,2,2,2,1,0,1,2,0,1,2,2,0,0,0,0,2,1,0,0,1,0,2,2,0,0,0,0,0,0,2,0,0,0,1,0,2,0,1,0,0,0,0,2,2,1,1,0,2,0,0,0,2,2,1,2,1,1,2,2,2,2,1,13,13,13,13,13,13,13,13,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,2,0,0,2,0,2,2,0,0,1,1,0,2,0,0,1,2,0,1,0,1,2,2,0,2,2,2,2,2,2,2,2,0,1,1,0,0,0,0,0,1,2,0,0,0,0,1,0,0,0,1,0,0,2,1,0,1,2,0,0,1,2,1,1,1,1,2,0,0,1,2,0,1,0,2,0,2,1,1,2,2,2,0,0,0,1,2,1,1,1,0,0,1,2,1,0,2,0,1,1,1,1,0,0,1,0,1,0,0,0,0,2,2,1,2,0,0,0,2,1,2,2,1,0,0,0,0,2,0,1,2,2,2,2,0,0,0,1,0,2,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,2,1,0,2,2,2,0,2,1,1,0,2,2,0,0,0,2,1,0,2,0,2,2,1,0,0,2,2,1,0,0,0,0,2,0,1,0,1,0,0,0,1,1,0,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,0,2,0,0,1,0,0,0,0,0,0,0,0,1,0,2,2,0,1,0,1,2,1,2,2,0,13,13,13,13,13,13,13,13,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,1,1,0,0,0,1,0,13,13,1,0,1,1,0,2,2,0,0,2,1,1,0,0,2,0,2,2,2,2,2,2,2,2,2,2,2,2,1,0,2,1,0,1,2,0,0,0,0,0,0,1,1,0,1,1,2,2,1,0,1,0,1,1,1,1,1,1,1,0,2,2,1,1,0,0,0,2,0,1,1,2,1,1,0,2,2,2,2,1,2,1,1,2,1,0,2,0,2,2,0,1,2,0,1,0,1,2,0,2,0,0,2,1,1,1,0,0,0,0,1,1,2,0,2,1,0,2,1,1,1,0,0,2,0,0,0,0,0,1,1,2,1,1,2,0,0,2,0,0,1,1,1,1,1,1,1,1,1,0,2,0,0,0,0,0,1,1,0,0,0,2,0,0,1,2,0,0,0,0,2,0,2,0,1,0,0,1,2,1,0,0,0,0,1,1,0,1,0,0,0,2,0,0,0,1,0,0,1,2,0,0,0,0,0,0,0,0,0,2,0,0,1,0,1,0,0,0,0,0,2,1,2,1,0,0,2,1,1,0,1,1,1,1,0,2,1,0,13,13,13,13,13,13,13,13,13,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,2,1,1,2,0,0,13,13,13,13,2,0,1,1,0,0,0,0,2,1,2,1,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,1,1,2,1,0,0,0,2,0,0,0,0,1,2,0,0,1,2,0,1,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,2,0,1,0,0,2,0,1,1,1,0,0,0,1,0,2,1,0,2,1,1,0,2,2,2,2,1,2,1,2,0,1,1,0,2,0,1,0,0,2,0,2,0,1,1,0,0,1,0,2,0,0,2,0,1,0,2,0,0,2,0,0,2,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,2,2,1,0,2,2,0,2,1,2,0,0,2,2,0,1,2,0,0,2,0,0,0,0,2,0,0,1,0,0,2,0,0,2,2,0,0,1,0,2,1,2,1,2,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,2,0,1,0,13,13,13,1,0,0,1,0,0,2,1,0,2,1,0,1,2,2,0,13,13,13,13,13,13,13,14,13,13,13,13,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,0,0,0,0,2,0,13,13,13,13,13,2,0,0,2,0,1,2,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,0,0,2,0,1,2,0,2,2,0,1,1,0,2,0,1,2,0,2,1,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,2,1,0,0,2,0,2,2,1,1,0,2,0,1,0,0,1,2,0,1,0,0,0,0,2,2,2,0,0,0,0,2,0,1,0,1,1,2,0,2,0,0,0,1,0,2,0,2,0,0,2,0,0,2,1,1,1,1,1,0,0,0,2,0,1,0,0,2,0,0,2,2,0,1,1,1,1,1,0,0,0,1,0,1,2,0,2,0,0,0,1,0,0,0,0,0,1,2,0,1,0,13,13,13,0,0,2,2,1,0,1,0,2,2,1,0,1,1,1,0,2,1,0,0,1,0,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,13,13,13,13,13,0,0,2,0,1,1,0,0,0,0,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,10,10,10,0,0,0,0,1,13,13,13,13,13,0,0,0,1,2,0,2,0,2,0,0,2,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,1,0,1,0,2,0,0,1,2,2,0,2,1,0,0,1,0,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,1,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,2,1,0,2,1,2,0,0,1,0,0,0,1,0,0,2,0,0,0,1,0,1,0,0,2,1,2,2,0,2,0,1,0,0,1,0,2,2,0,2,2,1,1,0,1,0,0,0,0,0,0,2,2,0,1,1,0,0,2,0,2,1,0,0,0,2,1,2,0,1,0,1,0,2,0,2,0,2,0,13,13,13,13,13,2,2,0,2,0,0,0,1,2,2,0,0,1,2,2,2,2,1,0,0,1,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,0,13,13,13,2,0,0,0,0,0,2,0,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,10,10,10,10,2,2,1,0,1,13,13,13,13,0,0,2,1,2,0,2,1,2,0,0,0,2,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,1,0,0,0,2,0,0,1,0,1,0,2,2,0,2,1,2,1,1,2,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,2,0,1,1,2,0,1,0,0,0,0,0,2,1,0,1,0,0,2,0,2,1,1,0,0,2,1,0,0,0,0,0,1,2,0,2,1,0,0,0,2,1,1,0,2,0,0,0,2,0,1,0,2,1,2,1,2,0,0,2,2,0,0,2,2,1,1,0,1,1,1,2,0,0,1,2,1,0,0,0,2,0,1,2,0,2,0,0,0,0,1,0,0,2,0,0,2,1,1,0,0,1,1,13,13,13,13,13,13,13,14,0,13,1,0,13,13,13,0,1,2,0,13,13,0,0,2,0,0,0,2,0,2,2,2,1,0,0,0,0,0,0,1,0,0,0,0,2,0,0,1,0,0,1,2,2,0,2,2,0,13,13,13,13,13,13,13,13,13,13,0,13,13,13,0,13,13,13,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,10,10,0,10,0,0,0,13,13,13,13,13,0,1,0,2,0,0,2,2,0,1,1,0,0,2,2,0,2,0,2,2,2,2,2,2,2,2,2,2,2,0,1,0,1,0,2,0,1,2,2,2,0,2,0,1,2,0,0,2,2,0,0,2,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,1,0,0,0,0,2,0,0,2,2,0,0,2,1,1,0,2,0,1,0,0,1,0,0,2,0,1,1,1,0,0,1,1,0,0,1,0,0,2,2,1,2,2,0,0,2,2,0,1,0,0,2,0,1,2,1,0,0,0,1,2,0,2,0,0,1,1,0,2,1,0,1,0,0,0,0,0,0,0,1,0,0,0,1,2,0,2,0,0,0,0,1,0,2,2,2,1,1,13,2,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,0,1,1,0,2,0,2,0,0,1,1,1,0,0,0,1,1,0,0,2,2,2,0,0,2,1,1,0,0,1,0,1,2,0,0,0,13,13,13,13,13,0,13,1,1,2,0,2,1,1,1,1,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,10,10,0,0,1,0,0,0,13,13,13,13,13,13,0,2,0,0,0,0,0,1,0,0,2,2,2,1,1,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,1,0,0,0,0,1,2,1,0,1,0,2,0,0,1,2,0,1,0,0,0,1,2,1,1,1,1,1,1,1,1,1,1,0,0,2,0,2,0,2,0,1,0,2,0,2,2,1,2,2,1,2,2,0,0,0,2,2,0,0,0,1,0,1,1,0,0,1,2,2,0,1,2,0,0,0,0,0,2,1,0,0,0,1,2,0,0,0,2,0,0,2,2,0,0,2,1,1,1,1,1,2,1,0,2,1,2,1,2,2,0,0,0,0,2,1,1,0,2,0,0,0,1,0,1,0,1,0,1,2,1,2,2,0,1,1,2,0,0,2,1,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,0,2,0,0,1,1,0,1,0,0,1,2,2,2,0,0,1,0,2,0,0,1,1,0,2,0,0,1,0,2,2,2,1,1,0,0,1,2,0,1,1,0,0,0,2,0,2,2,1,2,0,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,10,10,10,10,0,2,1,0,13,13,13,13,13,13,13,0,1,0,0,0,0,0,0,1,0,1,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,1,0,1,0,0,2,1,0,2,1,0,2,0,1,0,0,0,1,0,0,2,0,0,1,1,1,1,1,1,1,1,1,0,2,2,0,0,1,0,2,0,0,2,2,0,1,1,2,0,2,1,0,1,0,0,0,0,0,0,2,0,1,1,0,0,0,2,0,0,1,2,1,0,2,1,0,0,0,1,2,1,1,1,0,1,0,2,0,2,0,1,0,1,0,1,0,2,0,0,0,0,2,0,2,1,0,1,2,1,0,1,0,0,0,2,0,0,1,0,1,0,1,0,1,1,0,2,0,0,0,1,0,0,10,2,2,0,1,0,0,1,13,13,13,13,0,13,13,1,13,13,13,13,13,1,0,0,0,2,0,1,1,0,0,0,0,2,0,2,0,0,10,10,10,0,0,0,0,2,0,1,1,1,1,0,0,1,1,0,1,2,1,0,1,0,0,2,0,0,1,2,2,2,0,0,0,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,10,10,10,10,1,2,0,0,13,13,13,13,13,13,13,1,0,1,1,1,1,1,1,1,0,0,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,1,1,0,1,0,0,1,2,0,2,1,0,0,1,2,0,0,0,0,1,0,0,0,2,2,1,2,1,1,1,1,0,0,1,2,2,0,0,1,0,0,0,2,0,0,0,0,0,1,2,0,2,1,2,1,2,2,0,0,0,1,0,0,0,1,2,0,1,0,0,2,1,2,1,2,2,0,2,2,1,1,0,0,0,2,0,2,0,0,0,0,0,2,0,0,1,0,2,1,0,1,1,2,2,2,1,1,0,0,0,2,2,0,0,0,1,0,0,0,2,0,1,1,0,0,0,2,2,0,1,0,13,2,0,0,10,10,1,0,0,1,0,1,0,0,1,0,1,0,1,0,0,2,1,0,2,0,1,1,0,2,0,1,0,2,2,2,0,1,0,0,0,10,10,1,2,1,2,1,0,0,0,1,2,0,0,0,0,2,0,0,0,0,2,0,1,0,0,2,2,0,0,2,2,1,2,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,10,10,10,10,0,10,0,0,0,13,13,13,13,13,13,13,13,13,13,1,0,0,1,0,0,1,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,2,0,2,1,0,0,0,2,1,1,2,1,1,2,0,0,0,0,2,0,0,1,0,0,1,2,2,1,1,2,2,0,1,2,1,1,0,2,0,0,0,0,0,2,2,0,0,1,0,1,1,2,1,2,0,0,2,0,1,0,2,1,1,0,2,0,2,0,0,0,1,1,1,0,1,0,0,2,0,2,0,2,2,2,1,1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,2,0,0,1,0,0,1,2,1,0,1,0,2,1,2,0,0,1,1,0,1,0,1,0,2,1,1,2,1,2,13,13,13,1,1,0,2,0,0,2,0,0,2,1,2,2,1,0,0,2,1,2,2,1,0,0,0,1,1,0,0,2,0,1,0,2,0,1,0,2,1,0,0,2,1,1,1,1,1,1,0,1,0,1,0,1,1,0,2,1,0,0,0,0,0,1,1,2,1,0,0,2,2,0,1,0,0,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,10,10,10,10,10,1,0,0,0,13,13,13,13,13,13,13,13,13,13,13,0,1,1,0,1,1,1,0,0,1,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,2,1,0,0,1,0,0,2,0,1,2,2,0,0,2,2,0,2,0,0,0,0,1,0,0,0,0,1,0,2,0,0,2,0,0,1,0,0,1,1,2,0,1,1,2,0,0,0,1,1,0,1,1,0,0,2,2,1,1,1,2,0,0,0,2,0,2,2,0,1,2,0,1,0,0,0,0,1,1,0,0,0,2,1,1,1,0,0,1,0,0,1,1,2,1,1,2,0,0,0,2,0,1,0,1,1,2,1,0,1,0,13,13,13,13,2,0,0,1,1,2,1,2,2,1,0,1,2,0,0,0,0,1,1,2,0,1,0,2,2,1,2,1,1,2,0,1,0,1,1,0,1,0,0,2,1,0,0,0,0,1,0,0,0,2,2,0,2,2,0,1,0,1,0,0,2,0,2,2,2,1,0,2,0,0,2,0,1,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,10,10,10,10,10,1,0,2,0,13,13,13,13,13,13,13,1,13,13,0,0,2,2,0,1,1,0,2,0,0,1,0,1,2,2,2,2,2,0,1,1,2,2,2,2,2,2,2,2,2,2,2,0,1,1,0,2,2,0,2,2,0,0,2,0,1,1,1,0,2,2,0,0,0,1,2,0,0,1,2,0,2,2,0,0,0,0,2,0,1,1,0,0,0,1,0,0,0,2,0,0,1,0,0,2,0,2,0,0,0,2,1,0,0,0,1,2,0,0,1,1,0,0,2,2,2,0,0,1,0,0,0,0,2,1,1,0,0,0,0,0,0,0,0,2,1,2,0,2,0,0,0,1,0,2,2,1,2,0,0,0,0,1,2,1,0,1,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,13,13,13,13,13,2,0,0,2,0,0,1,1,0,2,0,0,0,1,1,0,2,0,0,0,0,0,0,0,1,2,1,0,1,0,0,1,1,2,2,1,0,0,0,0,2,0,0,0,0,0,0,2,1,0,0,0,0,0,0,0,2,0,0,1,0,1,2,0,2,1,0,0,1,0,1,2,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,10,10,10,10,1,0,2,2,0,0,13,13,13,13,13,13,13,0,0,2,2,0,2,0,1,0,0,1,0,2,1,2,0,2,2,2,2,2,0,0,0,0,1,2,0,1,1,1,2,0,2,0,0,0,0,0,1,1,0,1,2,2,0,0,0,1,0,0,2,2,1,1,1,1,1,0,0,2,2,0,2,0,2,0,2,1,2,2,0,1,1,1,0,0,2,0,0,1,0,1,0,0,1,1,1,1,0,0,1,1,0,0,0,1,0,1,0,0,1,0,2,0,0,2,0,0,1,0,1,0,0,1,1,0,1,1,2,2,2,1,0,0,2,0,0,0,0,0,1,0,1,0,2,1,0,0,0,0,2,0,1,2,1,2,0,0,1,0,1,2,2,0,0,0,0,0,1,0,2,0,0,0,0,0,13,13,13,13,13,0,2,0,0,0,0,0,1,2,0,1,0,2,0,1,0,0,1,0,1,1,2,0,0,0,2,0,0,1,0,1,2,0,2,0,2,1,2,1,0,0,2,0,0,0,2,1,2,1,0,0,1,2,1,1,2,0,2,0,2,0,0,0,0,0,0,1,1,0,2,2,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,3,10,10,10,10,10,2,0,0,2,13,13,13,13,13,13,13,13,13,13,1,1,2,1,1,2,0,0,0,0,1,2,2,1,0,2,2,2,2,2,2,2,0,0,2,1,1,1,1,1,1,1,0,2,1,0,0,0,0,0,0,2,0,2,2,2,1,0,1,0,0,1,0,2,2,1,2,0,0,2,1,0,1,1,0,0,1,1,0,0,0,0,0,0,2,0,2,0,0,0,0,1,0,0,0,2,2,0,2,0,1,0,2,0,0,2,2,2,2,1,0,0,1,0,0,0,0,1,0,1,1,2,1,2,0,0,0,0,0,2,0,1,2,0,1,1,1,1,2,2,2,0,1,0,0,1,0,0,0,0,0,0,2,2,0,0,0,1,1,2,0,1,1,1,2,0,0,0,0,1,0,2,2,0,0,0,0,0,0,13,13,13,0,2,2,0,2,0,0,1,0,0,2,0,0,0,0,1,0,0,2,1,1,1,2,0,0,1,0,0,1,1,0,2,1,0,0,2,0,0,2,2,0,0,0,0,0,1,1,0,2,2,0,0,1,1,0,0,1,0,0,0,1,0,1,1,2,0,0,1,0,1,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,10,10,10,10,10,0,0,0,0,13,13,13,13,13,13,13,13,13,1,0,0,0,1,0,0,1,1,2,2,0,1,2,0,0,0,2,2,2,2,2,2,0,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,0,1,1,0,1,0,0,0,1,0,2,1,0,2,1,2,0,0,0,0,1,0,0,0,2,1,2,1,1,0,1,0,0,2,0,0,0,1,1,1,0,0,0,2,0,2,2,2,2,0,1,0,2,2,1,2,0,2,1,2,0,1,0,0,0,1,0,1,0,1,0,2,1,0,0,1,0,1,0,1,0,1,0,2,1,2,1,1,1,1,2,1,0,0,0,2,0,0,0,0,0,0,1,0,1,0,1,0,0,1,2,0,0,0,0,1,2,0,0,0,1,0,1,1,0,0,0,0,0,1,13,13,13,13,1,0,2,0,2,2,2,2,2,0,0,1,0,10,10,1,1,0,2,1,0,1,0,2,0,1,0,1,2,0,0,0,0,1,0,0,0,2,1,1,0,0,0,1,0,2,0,0,0,0,0,1,1,0,0,0,1,0,0,1,0,2,1,1,2,0,0,0,1,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,10,10,10,10,0,0,2,2,13,13,13,13,13,13,13,13,13,2,0,0,0,0,0,0,0,2,2,0,0,0,2,1,2,2,0,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,0,0,1,0,1,0,1,0,0,1,0,2,0,0,0,0,2,1,1,0,2,2,0,0,0,1,2,1,0,0,1,0,2,0,2,0,2,1,0,2,0,0,0,2,0,0,0,0,0,1,2,2,0,1,0,0,0,0,0,0,2,0,0,1,1,0,2,0,0,0,2,1,0,2,0,2,0,0,0,2,2,0,0,1,0,2,0,1,2,1,1,2,2,2,1,0,1,0,0,1,2,2,1,1,0,2,0,1,1,0,0,2,0,0,1,0,2,0,1,2,0,0,0,1,2,0,2,2,1,0,0,0,13,13,0,2,2,0,0,0,1,1,0,1,2,0,2,0,1,10,10,0,0,0,0,2,2,1,1,2,2,1,1,1,0,0,1,0,0,0,2,0,1,1,1,2,0,1,1,0,1,1,0,1,2,1,2,0,0,0,0,0,2,0,2,2,1,1,2,2,1,0,1,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,10,0,2,10,0,10,1,2,2,13,13,13,13,13,13,13,13,0,1,0,2,1,2,0,0,1,0,1,2,0,1,1,0,1,0,0,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,2,0,0,0,0,1,0,0,0,0,1,0,1,2,0,0,1,2,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,2,0,2,2,2,0,0,0,2,1,2,0,0,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,2,1,0,1,0,1,0,0,0,0,2,1,0,0,0,0,0,0,0,2,1,2,1,0,2,0,0,2,1,0,1,2,2,2,0,1,2,2,0,1,0,0,0,0,0,0,2,0,0,1,2,2,2,0,1,0,1,0,0,0,1,0,1,1,0,0,1,2,0,0,1,1,1,0,1,1,2,2,0,2,0,1,2,1,0,1,0,0,1,1,0,0,2,2,0,0,0,0,0,2,0,0,2,1,2,1,0,0,0,0,2,0,0,2,0,2,0,1,2,2,0,2,2,2,0,0,0,2,0,2,1,0,0,1,0,2,2,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,2,2,10,2,0,0,0,0,1,1,13,13,13,13,13,13,13,2,0,0,0,1,0,0,0,0,0,1,2,1,1,2,2,1,2,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,2,1,1,2,0,1,1,0,0,0,1,0,0,2,0,0,1,1,0,2,2,2,2,2,1,0,0,2,1,0,1,0,0,0,0,0,0,0,0,0,1,0,0,2,2,1,0,1,1,0,2,2,1,0,0,0,0,2,2,2,0,1,0,0,0,2,0,0,2,2,0,0,0,0,2,1,0,1,0,2,0,2,2,1,1,1,0,1,2,0,1,2,1,0,2,0,1,0,0,0,1,0,1,2,0,0,1,0,2,1,0,2,0,0,1,0,0,0,0,0,0,0,2,2,0,2,0,0,0,0,2,0,0,2,0,0,0,2,0,0,1,2,1,1,0,0,0,0,1,2,0,1,0,2,1,1,1,0,0,1,0,0,1,0,0,0,0,2,0,1,0,0,0,0,1,0,2,0,0,0,0,2,1,0,0,1,0,1,0,1,1,2,1,0,1,2,1,1,2,1,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,0,2,2,0,2,2,2,0,0,0,13,13,13,13,13,13,13,2,2,0,2,0,2,1,0,0,0,0,1,1,2,1,1,2,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,0,0,1,0,1,1,1,1,0,1,2,2,0,0,1,0,2,2,2,1,2,0,1,0,1,0,0,1,0,0,0,0,0,1,1,0,0,1,0,1,2,0,0,0,2,0,0,0,1,1,1,0,0,0,0,1,1,1,2,2,0,1,2,1,0,0,0,2,0,0,0,0,0,0,0,2,0,0,0,0,2,2,0,2,1,2,1,0,0,0,2,2,1,0,0,2,0,0,0,0,2,0,1,1,2,0,0,0,2,2,0,2,2,2,0,0,2,0,0,2,1,0,1,0,0,2,0,0,0,0,0,0,0,0,2,0,2,2,2,1,0,2,1,0,1,1,2,1,2,0,0,2,2,0,0,0,0,2,1,2,1,0,0,2,0,2,0,2,0,1,2,0,1,0,2,0,0,0,0,2,2,0,0,2,0,1,0,2,0,1,2,1,1,1,2,1,2,0,0,0,1,0,0,0,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,10,2,0,1,1,0,0,2,0,2,0,2,2,13,13,13,13,13,13,13,2,0,0,1,1,0,0,0,2,2,0,2,0,1,1,0,2,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,0,2,0,0,1,2,0,1,0,0,1,0,0,1,0,2,0,2,0,0,1,2,0,0,0,0,2,0,0,0,2,1,0,1,1,1,0,2,0,0,2,1,0,0,0,0,0,0,0,0,2,0,1,2,1,0,0,2,0,1,0,1,0,0,0,0,2,1,2,2,0,1,0,0,0,1,0,1,2,0,0,0,2,2,1,0,2,1,0,0,1,1,0,0,0,0,0,0,2,2,1,0,0,0,1,0,0,0,1,0,0,2,0,0,1,2,0,0,0,10,10,10,0,0,2,2,2,1,1,1,0,2,2,2,1,1,1,2,1,1,1,1,0,0,0,2,1,2,0,2,2,0,2,0,0,1,0,1,1,1,0,1,0,1,0,0,1,0,1,0,2,2,2,0,1,0,1,0,1,0,0,1,1,1,0,0,1,0,2,0,1,2,0,0,1,0,0,1,0,0,0,0,2,0,0,0,0,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,10,0,1,0,1,0,2,0,2,0,0,0,0,13,13,13,13,13,13,13,1,1,2,0,1,1,1,2,0,0,0,0,0,0,2,2,0,0,1,2,2,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,1,0,2,0,1,0,2,1,1,2,1,1,2,0,1,1,0,0,1,0,0,1,0,0,1,2,0,2,1,2,0,1,0,1,0,2,0,0,1,0,2,0,2,0,2,0,1,0,2,1,0,2,0,1,1,1,0,1,0,0,0,2,0,2,1,1,0,2,2,1,0,0,1,2,0,0,0,1,2,1,2,2,1,0,2,2,2,0,1,1,1,2,2,2,1,2,2,2,0,0,2,2,0,1,0,0,0,1,0,2,0,0,0,0,0,1,0,2,1,0,1,0,2,10,10,2,0,0,1,0,10,10,10,0,2,0,2,0,2,1,0,0,0,2,0,2,0,2,1,2,2,0,1,1,1,0,1,1,1,0,0,0,2,0,1,0,2,1,2,1,0,1,0,0,2,2,0,0,0,2,1,2,0,1,2,0,2,0,2,0,0,1,0,0,0,2,0,0,2,0,1,0,1,2,0,0,2,2,2,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,2,10,2,0,0,2,0,0,1,0,2,1,13,13,13,13,13,13,13,13,0,0,2,1,0,0,1,1,0,0,2,1,0,0,2,0,2,0,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,2,0,2,2,0,0,1,2,0,0,0,0,0,1,2,2,2,2,1,2,0,0,1,1,1,0,2,2,1,1,0,0,1,0,1,0,2,2,0,2,0,2,2,0,1,2,0,0,0,1,1,1,0,0,1,1,2,1,0,1,2,2,1,0,2,2,2,0,1,0,2,0,1,0,1,0,2,0,2,0,1,2,1,1,0,0,0,0,2,2,2,1,2,0,1,0,0,1,1,0,1,1,0,0,0,2,2,2,2,0,0,2,1,0,2,0,1,0,1,1,2,2,0,2,1,2,0,10,10,10,10,10,10,10,10,10,0,0,1,1,2,0,1,2,0,0,0,1,1,1,0,1,0,1,2,1,2,0,2,0,2,0,2,0,0,2,2,0,2,2,0,2,0,0,0,1,0,0,0,2,0,0,1,1,2,0,1,0,0,0,0,2,1,2,1,2,0,2,0,0,1,2,0,0,1,0,2,1,0,2,0,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,2,2,2,0,0,2,2,2,1,1,13,13,0,0,13,13,13,0,13,13,13,0,1,1,2,1,0,2,0,0,1,1,0,2,0,2,1,1,0,2,0,1,0,0,0,2,1,1,1,1,1,1,1,0,0,0,1,1,1,0,2,0,0,2,0,0,1,2,0,1,1,0,2,1,0,1,2,1,1,1,1,0,2,0,1,0,1,1,0,2,0,2,0,1,1,0,0,0,0,0,1,1,0,1,0,0,1,0,0,0,0,1,2,0,1,2,2,0,1,1,2,0,1,0,0,1,1,0,2,0,1,0,0,2,0,0,0,1,1,1,2,2,0,1,0,0,2,0,0,0,1,0,0,0,2,0,1,0,1,0,1,1,2,1,0,0,0,0,0,0,0,1,2,0,1,0,0,0,0,10,10,1,0,10,10,10,10,10,10,2,10,10,2,0,0,2,2,2,0,1,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,2,0,0,2,0,1,1,2,2,0,1,1,1,2,0,1,2,0,1,2,1,2,2,0,2,2,2,0,0,0,0,0,0,2,0,1,1,2,0,2,0,1,2,1,0,2,2,0,0,0,2,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,0,0,1,1,0,0,0,1,0,2,13,13,13,13,0,1,0,1,13,13,13,0,0,1,0,0,2,2,0,0,0,1,1,0,1,0,1,0,0,0,1,0,0,0,0,2,0,1,1,1,1,1,1,2,0,0,1,0,0,0,0,0,0,1,0,2,1,0,2,2,2,0,1,0,0,0,0,0,0,1,0,0,0,2,2,0,0,0,0,2,0,1,0,0,0,0,0,0,2,0,0,1,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,2,1,0,0,0,0,0,0,0,0,2,0,0,0,1,2,0,0,0,0,2,0,2,0,0,0,2,0,0,1,0,2,1,0,2,2,1,1,1,0,1,0,0,1,1,0,0,2,0,0,1,1,1,1,0,1,0,2,0,1,0,0,0,10,10,10,10,10,10,10,2,0,0,0,0,2,0,0,0,2,2,2,2,0,0,1,1,1,0,0,0,0,0,0,1,0,1,2,1,0,0,1,1,1,1,0,0,0,2,2,2,2,1,0,0,0,0,2,0,2,1,1,0,2,0,1,1,1,0,10,0,0,2,2,1,1,0,2,0,0,2,2,0,0,1,0,0,0,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,10,10,2,0,2,0,2,0,0,2,1,13,13,13,13,13,0,0,13,13,13,13,13,13,1,0,2,0,2,2,0,2,1,2,2,2,0,1,0,0,1,1,0,2,2,0,0,0,2,0,0,0,1,2,1,0,0,1,0,0,2,2,0,2,1,0,1,1,2,0,2,2,0,1,2,1,1,2,2,2,1,2,0,2,0,0,0,1,0,2,0,0,1,0,2,2,1,0,0,0,0,0,0,1,1,0,1,2,2,2,1,0,2,1,2,0,2,0,0,1,0,2,0,1,2,1,0,2,0,2,0,0,2,2,2,0,1,2,0,0,2,1,1,0,0,2,1,0,2,1,0,2,0,1,2,1,2,1,0,0,2,0,0,0,0,0,2,1,1,0,0,0,2,0,2,1,1,2,2,2,0,2,0,2,0,10,10,10,10,10,1,1,2,0,0,2,0,1,0,2,2,2,0,2,2,1,2,2,0,2,0,0,1,0,2,2,1,0,1,2,1,1,7,7,7,1,1,0,0,0,0,0,2,0,2,0,0,2,1,2,1,2,0,2,0,0,1,1,0,10,10,0,0,2,0,2,1,0,0,2,1,1,2,1,0,0,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,10,10,0,0,2,2,13,13,13,1,13,13,13,13,13,13,0,13,13,13,13,13,13,13,0,1,0,0,1,2,0,0,1,0,2,2,1,1,1,2,0,2,0,0,1,2,1,0,1,1,0,0,0,1,0,0,1,0,0,1,0,1,0,1,0,0,0,2,1,2,0,1,0,2,2,2,2,1,1,1,0,1,0,0,2,1,2,1,2,1,2,2,2,2,2,2,0,1,0,0,0,2,0,2,0,1,0,0,0,1,1,0,2,0,0,1,1,2,0,1,1,1,2,2,1,2,2,0,0,1,0,0,2,0,1,0,2,1,0,0,2,1,0,2,0,2,2,2,2,1,0,0,2,2,1,0,1,0,1,2,0,1,1,1,1,0,0,0,0,0,2,1,0,0,0,0,0,1,0,1,2,0,1,1,1,1,0,10,10,10,10,0,2,1,0,0,0,0,0,2,2,2,2,2,2,2,0,2,1,2,0,1,2,0,2,0,1,2,1,0,1,1,1,7,7,7,7,0,2,1,1,2,0,0,1,0,1,0,1,0,0,0,0,0,2,0,2,0,0,0,0,10,0,0,2,0,1,2,1,0,2,0,1,0,2,1,1,2,1,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,10,10,2,1,1,13,13,13,13,13,13,13,13,13,13,0,13,13,13,13,13,13,2,2,1,0,1,0,2,1,0,0,1,0,1,0,1,2,2,1,0,1,1,0,2,2,0,0,7,7,7,7,7,7,2,0,2,0,2,2,2,0,1,1,2,0,2,0,0,2,0,1,2,7,7,7,1,0,1,2,0,0,0,2,2,1,0,0,0,1,0,0,1,0,0,0,2,0,1,2,0,2,2,0,0,1,2,2,0,1,2,1,1,1,0,2,0,0,0,0,1,0,0,0,2,2,0,0,0,2,1,0,0,2,0,0,0,0,0,0,2,2,1,1,1,0,1,2,0,0,2,1,1,0,2,2,2,1,2,0,1,2,2,1,1,1,2,0,0,1,2,2,0,0,2,2,0,0,0,0,0,1,0,0,0,0,2,10,10,0,1,0,2,1,0,1,0,1,1,0,0,2,2,2,2,2,1,2,0,1,0,0,0,1,0,2,0,1,0,0,1,1,1,1,1,7,7,7,0,0,0,2,0,0,0,2,2,2,0,0,0,1,0,2,1,0,0,0,1,1,0,2,0,1,0,1,0,0,1,0,1,1,13,1,2,2,0,2,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,1,0,13,13,13,13,13,13,0,13,13,13,13,13,13,13,13,13,2,1,0,2,0,0,2,1,0,1,0,1,1,2,0,1,0,2,7,7,0,0,0,0,0,0,0,0,7,7,7,7,7,7,1,1,0,0,0,2,2,2,2,2,2,0,0,2,1,0,7,7,1,7,7,7,0,2,2,2,0,2,0,1,2,1,0,2,0,1,0,1,2,0,2,1,1,0,0,2,0,0,0,2,0,0,0,0,1,0,1,0,2,2,1,0,0,1,0,0,2,0,0,2,0,2,1,1,2,0,0,2,0,0,0,0,2,0,0,1,0,0,2,0,1,1,2,1,0,0,2,1,0,0,0,0,0,1,2,0,0,0,2,0,2,0,0,0,0,1,1,0,0,0,0,1,2,0,0,0,0,2,2,0,0,0,2,0,10,0,1,1,2,1,0,1,1,2,0,0,2,2,2,2,2,2,0,0,1,0,1,1,2,1,0,1,0,2,0,0,1,1,1,1,1,1,1,1,0,0,2,0,0,0,2,0,2,10,10,10,10,10,10,0,0,2,0,10,0,2,2,2,1,0,0,2,0,2,0,2,1,13,13,13,1,0,2,0,0,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,0,1,13,13,13,1,0,13,13,13,13,13,13,13,13,13,0,0,0,2,2,2,2,2,0,0,2,1,1,0,1,2,2,1,0,2,7,7,1,1,0,1,0,1,0,2,0,0,1,1,0,1,1,1,2,0,2,1,0,1,1,2,1,1,1,0,2,0,7,7,2,0,1,2,0,1,0,1,2,2,1,0,1,1,0,0,0,0,0,1,0,1,0,0,0,2,0,0,0,0,0,0,2,2,1,1,0,2,2,1,1,1,2,2,2,0,0,2,0,0,0,0,0,0,0,1,0,0,2,0,0,0,1,0,1,0,0,1,0,0,2,0,0,0,1,1,2,0,2,0,0,0,1,1,1,0,2,1,0,0,1,2,1,0,2,2,0,0,2,0,0,1,0,0,0,2,1,0,0,0,0,1,1,0,0,10,10,2,1,0,0,2,1,1,1,0,2,0,0,2,2,2,2,2,2,2,0,0,0,0,0,0,0,1,1,0,2,1,1,1,1,1,1,1,1,2,2,0,2,1,2,1,0,1,10,10,10,10,1,2,10,10,10,10,10,2,0,0,0,2,1,1,2,1,0,2,2,2,0,0,13,13,13,1,0,0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,2,0,1,13,13,13,13,13,13,13,13,13,13,13,13,13,0,0,2,0,1,0,1,0,2,0,1,0,0,2,0,1,2,2,0,0,2,7,7,7,0,0,0,0,2,2,2,0,2,0,0,0,2,2,1,2,2,2,0,2,1,1,0,0,1,1,2,0,0,7,7,7,0,0,1,0,2,0,1,0,0,0,0,0,0,0,1,2,2,0,0,1,1,1,2,0,0,0,1,1,0,2,2,0,2,2,1,1,2,0,1,0,1,2,1,2,0,0,1,0,0,2,0,0,0,1,0,0,0,0,2,0,0,2,0,0,0,1,0,0,2,1,0,1,1,0,0,2,0,1,2,0,1,0,0,0,2,0,0,1,1,1,0,2,1,2,0,0,2,1,1,0,0,0,0,1,1,0,1,2,1,0,1,2,2,0,2,1,0,1,1,1,0,2,0,1,0,0,0,0,0,2,2,2,2,2,2,1,0,0,2,1,2,1,2,0,1,0,0,1,1,1,1,1,1,1,1,2,0,0,2,2,0,0,1,1,10,10,10,2,0,1,1,1,2,1,0,0,0,1,2,2,1,0,0,0,2,1,1,0,1,1,2,13,2,0,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,1,2,1,13,13,13,13,13,13,13,13,13,13,13,1,2,0,2,0,2,2,1,0,2,0,2,1,1,2,0,2,0,0,0,2,2,0,7,7,7,2,1,1,0,0,0,0,0,0,1,2,1,1,1,0,0,0,0,2,0,2,0,1,0,0,0,2,2,0,0,7,7,7,0,0,2,2,2,0,0,1,2,1,2,0,0,0,0,2,1,0,2,1,0,0,0,0,0,1,1,0,0,0,1,1,2,2,0,1,2,0,0,0,0,0,2,0,2,2,0,0,0,0,2,0,2,0,0,2,2,1,2,0,0,1,2,0,1,2,0,2,2,2,2,1,0,0,0,0,1,2,1,0,2,2,0,2,1,0,1,0,0,2,1,0,1,2,0,0,2,0,2,0,0,2,0,0,0,2,1,0,2,1,2,2,0,0,1,0,0,1,0,2,2,0,1,2,0,0,1,0,1,0,2,2,2,2,2,1,1,2,1,2,0,0,1,0,0,0,1,1,1,1,1,1,1,1,0,0,0,2,1,2,2,0,2,2,1,2,0,0,2,2,2,0,0,2,0,2,2,0,2,0,0,2,2,0,0,0,0,1,0,0,0,1,0,1,1,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,13,13,13,13,13,13,13,13,1,0,0,1,1,1,1,1,2,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,7,7,7,7,7,0,0,2,0,0,2,0,2,2,2,1,2,0,1,0,2,1,1,0,1,0,1,1,1,2,0,0,0,0,0,7,7,1,1,0,2,2,2,2,2,0,0,2,1,2,2,2,2,0,0,2,1,0,0,0,1,1,1,1,2,0,1,0,0,1,1,0,0,1,0,1,0,0,0,0,0,0,0,0,2,2,2,0,0,1,7,7,7,0,0,2,2,0,0,1,2,0,1,0,2,1,2,1,0,0,0,0,0,0,0,0,1,1,1,2,1,1,1,0,0,2,0,0,1,0,0,1,0,2,0,1,2,1,0,1,2,0,0,1,0,0,1,2,2,0,2,0,0,0,0,1,1,1,2,2,0,0,2,1,0,2,0,1,2,2,2,2,2,0,0,0,0,2,0,2,1,1,0,2,1,1,1,1,1,1,1,1,0,0,0,0,1,0,2,0,1,0,2,1,0,0,0,1,2,2,0,0,1,0,0,2,2,0,2,1,2,2,0,1,0,1,0,1,0,2,2,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,0,0,1,0,0,1,13,13,13,20,13,13,13,13,0,1,0,2,2,0,1,2,0,2,0,0,2,0,2,0,1,1,0,2,1,1,2,0,7,7,7,7,0,2,2,1,1,0,2,0,2,1,2,0,1,0,0,0,1,0,0,0,1,0,1,0,2,0,2,2,2,0,0,2,0,0,0,1,0,1,0,1,1,0,0,0,0,2,1,1,1,0,2,0,0,1,2,0,0,0,1,1,0,1,0,0,2,2,1,2,0,1,0,2,2,0,0,1,0,2,1,1,1,0,0,0,0,2,7,7,7,2,7,7,7,7,0,1,0,0,0,2,2,1,0,2,0,0,2,2,0,2,0,2,2,0,2,0,2,0,1,1,2,0,0,1,2,2,0,2,2,0,1,2,1,0,1,0,2,0,0,0,2,2,0,0,0,0,1,2,2,0,0,2,0,0,1,2,0,2,0,0,0,1,0,0,2,2,2,2,2,2,2,2,0,0,2,0,0,0,0,1,0,2,1,1,1,1,1,2,0,0,0,0,1,0,0,0,0,1,0,0,0,1,2,0,0,2,0,1,0,0,2,0,0,0,1,1,0,0,0,0,0,1,2,0,1,0,0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,2,0,0,1,0,1,0,13,13,13,2,0,13,13,1,2,1,1,1,0,2,0,1,0,1,1,0,0,2,1,0,2,2,1,0,1,0,0,0,7,7,1,2,0,1,0,0,0,0,0,1,0,0,2,2,0,10,0,0,2,2,1,2,0,2,2,0,1,0,2,0,1,0,0,2,2,0,2,0,1,0,2,0,1,0,0,1,1,0,1,1,0,0,2,1,0,1,0,0,1,2,1,0,0,0,2,0,2,1,1,0,1,0,2,1,1,0,0,2,1,1,0,1,2,2,0,0,1,1,7,7,7,0,7,7,7,7,2,0,0,2,0,2,1,0,2,0,0,1,0,1,1,2,1,1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,2,0,0,2,0,0,0,0,0,1,0,2,0,1,0,1,1,1,2,0,0,0,2,1,0,1,0,1,2,2,1,0,0,2,0,0,1,1,2,2,2,2,2,2,2,2,2,2,2,0,1,0,0,0,1,1,1,1,1,1,1,2,0,0,0,1,0,1,0,0,0,1,0,0,0,1,1,0,1,2,2,0,2,2,1,2,2,0,0,2,2,1,0,0,0,1,0,2,2,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,1,1,2,0,0,0,0,0,0,13,13,13,13,13,13,13,2,0,0,2,0,0,1,1,1,0,0,0,1,2,0,2,0,2,1,1,0,0,2,1,1,2,2,1,0,2,2,1,0,0,0,1,0,1,0,0,0,0,10,10,0,0,2,0,0,1,2,0,1,1,1,0,1,0,2,1,0,0,1,2,0,0,1,0,2,1,2,0,0,2,0,2,0,0,1,2,2,0,0,0,1,0,1,1,0,1,1,1,1,1,0,0,0,2,2,0,0,0,2,0,0,0,2,2,0,1,1,0,1,1,2,7,7,0,2,7,7,7,7,1,0,1,2,2,0,2,0,0,1,0,0,2,2,2,0,0,0,0,0,2,0,0,0,1,2,2,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,2,0,0,2,0,0,1,0,2,0,2,0,0,1,0,0,2,2,2,2,0,2,1,2,0,0,2,1,2,2,2,2,2,2,2,2,2,1,0,0,1,1,0,1,0,0,0,2,1,2,0,0,2,0,1,0,1,0,0,0,0,0,0,0,1,0,2,1,0,2,0,2,2,2,0,1,2,1,2,0,0,1,0,1,0,0,1,0,0,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,2,2,1,1,1,2,13,0,1,2,13,13,13,13,13,13,13,0,1,2,1,1,0,0,2,2,2,1,2,0,2,0,2,0,1,2,1,0,1,0,1,2,0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,10,10,2,2,1,1,0,0,0,1,1,0,2,0,1,1,2,1,0,0,1,0,0,1,2,0,2,0,1,0,1,0,0,0,2,0,0,0,0,0,2,2,2,2,1,1,1,0,0,0,0,1,2,1,10,10,2,2,1,1,2,1,2,1,2,0,2,2,1,0,0,0,0,2,0,0,2,1,0,0,2,0,1,1,0,1,1,1,1,1,0,0,1,2,0,0,2,0,2,0,0,2,0,0,1,1,0,0,0,0,0,1,1,0,0,0,1,2,1,2,2,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,2,1,2,2,2,2,2,2,2,2,2,2,2,2,0,0,1,2,0,2,2,0,1,1,1,0,0,2,1,0,2,2,0,0,2,0,1,2,1,1,0,1,1,1,0,1,2,13,2,0,0,2,0,0,1,2,1,1,0,0,0,1,0,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,2,2,0,0,0,0,13,13,13,2,2,13,13,13,13,13,0,1,0,1,2,2,0,2,0,1,0,0,1,2,2,1,0,1,1,0,0,0,1,1,0,0,0,0,0,0,0,1,0,1,0,1,2,0,1,0,1,2,1,0,0,0,2,1,1,0,2,1,2,2,0,0,1,0,1,1,0,1,1,0,0,1,0,1,0,1,0,1,2,0,1,1,0,2,0,2,0,0,2,1,2,1,2,0,0,0,0,2,1,0,2,2,0,0,0,1,10,0,0,0,0,1,0,0,0,2,0,0,0,2,0,2,0,0,0,2,1,0,0,1,0,0,2,0,0,0,0,2,1,2,2,2,0,0,0,1,0,2,0,0,0,1,2,0,0,0,0,0,0,0,0,2,0,2,2,0,0,1,2,0,0,1,0,0,1,2,2,0,0,0,0,1,0,0,0,2,2,2,0,2,0,1,2,0,0,0,1,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,1,0,1,0,1,0,0,2,2,0,1,1,0,0,1,2,1,0,2,0,1,0,2,2,2,2,0,2,0,2,1,13,13,13,2,1,2,0,2,2,1,1,0,1,2,2,2,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,2,1,2,0,0,0,0,0,13,13,13,0,0,13,13,13,13,13,2,2,0,0,0,0,1,1,2,0,0,2,0,1,2,0,0,2,2,1,0,0,0,0,1,0,0,2,2,2,2,2,2,0,0,0,0,0,2,2,2,2,1,2,2,2,0,0,1,2,0,0,0,1,0,0,1,1,2,0,1,0,1,2,1,1,0,0,0,2,2,1,1,2,2,2,1,2,2,1,1,1,0,2,2,0,0,0,1,0,0,2,0,0,0,2,2,0,0,10,10,0,0,0,2,1,2,0,0,1,0,1,2,0,2,0,0,0,2,2,0,0,0,0,0,0,1,0,0,0,2,0,1,1,0,2,0,0,2,2,0,0,1,0,1,2,0,0,0,0,1,0,1,0,0,2,1,0,1,0,2,0,1,2,0,0,2,1,0,1,0,2,0,2,2,1,1,0,1,2,2,0,0,2,1,0,0,1,0,0,0,2,2,1,2,1,2,2,2,2,2,2,2,2,2,0,1,0,0,0,1,0,2,0,0,0,2,1,2,0,1,2,1,1,1,2,0,2,2,1,0,1,2,0,0,0,0,0,13,13,13,0,0,0,1,1,0,2,2,0,2,2,2,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,2,3,3,3,3,3,3,3,1,0,1,0,0,1,2,1,1,0,0,2,0,1,0,13,0,0,0,13,13,13,13,13,0,0,0,0,2,0,0,0,0,0,2,0,1,2,1,2,0,2,2,0,1,0,2,2,2,2,2,2,0,1,2,0,0,0,0,0,0,2,2,0,2,0,0,0,0,0,1,0,0,0,0,2,2,0,2,0,2,0,0,1,2,0,0,1,2,0,0,1,1,0,0,2,0,0,0,2,1,0,0,2,0,0,0,1,0,0,0,0,2,0,0,2,0,0,0,0,0,2,0,0,0,1,1,0,0,1,0,2,0,1,0,0,1,2,0,0,0,0,2,0,2,2,2,0,1,2,1,2,0,0,1,0,2,0,0,2,0,0,0,0,0,0,0,0,1,0,0,0,1,2,0,2,1,1,0,1,0,0,1,2,1,0,2,2,0,0,2,0,0,1,2,0,0,0,0,0,0,1,0,0,0,1,1,0,0,0,0,1,0,0,0,2,0,0,1,2,2,2,2,2,2,2,2,2,0,0,0,0,2,1,0,2,2,2,0,2,2,0,0,2,0,1,2,1,0,1,1,0,1,1,1,1,0,0,0,1,3,13,13,13,2,2,1,2,0,0,0,2,0,0,2,1,1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,0,0,1,2,0,0,2,1,0,0,0,0,0,0,1,0,2,0,0,1,0,13,13,13,13,0,0,2,0,1,13,13,13,13,1,0,2,0,1,0,0,0,2,0,0,2,1,2,0,2,0,0,0,1,0,0,2,2,2,0,0,1,2,1,0,0,1,0,2,2,0,0,2,2,0,2,1,1,0,1,1,0,0,0,2,2,0,2,2,1,1,0,0,2,1,0,1,0,1,1,2,0,1,1,0,0,1,0,0,2,0,0,0,0,0,1,1,2,1,1,2,1,2,0,0,0,0,0,0,2,0,0,0,0,0,0,1,0,1,0,2,0,0,0,0,0,1,1,0,0,0,0,0,0,2,0,1,1,2,2,0,0,1,1,0,1,0,1,1,2,2,0,2,0,0,0,2,1,1,1,0,1,1,1,0,0,2,2,1,2,1,0,0,0,1,2,0,1,1,1,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,1,1,0,0,0,0,2,2,0,0,0,0,0,2,1,0,0,1,0,1,0,0,2,1,0,0,0,0,2,2,1,1,1,13,3,13,13,13,13,0,0,1,1,0,1,2,0,2,0,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,3,3,3,3,0,2,1,0,0,0,2,0,2,0,0,2,1,1,0,1,2,1,2,2,1,2,2,13,13,13,13,13,13,13,13,0,0,0,0,13,13,13,13,2,0,2,0,1,2,1,1,1,0,0,0,0,0,1,0,2,0,2,2,0,0,2,0,0,2,2,0,1,0,2,1,0,0,0,2,1,1,1,1,0,0,0,0,0,2,1,1,1,1,0,0,0,1,1,1,0,1,0,1,2,0,0,0,0,0,0,0,1,1,0,0,1,2,0,0,1,1,0,0,1,2,0,2,0,0,2,1,1,0,1,0,0,2,1,0,0,0,0,0,2,1,1,0,2,2,1,0,1,0,0,1,2,0,0,2,0,2,0,1,0,2,0,0,0,1,0,1,0,2,0,1,1,1,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,1,2,1,0,0,0,0,0,0,1,0,0,0,1,1,2,0,2,2,0,1,2,0,0,0,0,2,1,0,0,2,0,0,2,1,2,1,0,2,2,2,2,0,2,2,2,2,2,2,1,1,1,1,0,0,0,0,0,0,0,2,0,0,2,1,0,1,0,1,2,1,2,2,1,0,0,1,0,0,1,0,13,13,13,3,13,13,13,13,0,2,1,1,0,1,1,2,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,2,1,0,2,1,0,0,0,0,1,0,1,0,1,1,2,0,0,2,1,2,13,13,13,13,13,13,13,13,13,13,13,0,13,13,13,13,13,0,0,0,0,1,1,0,0,0,0,1,2,0,1,0,2,1,0,2,0,0,0,0,1,1,2,0,1,2,1,0,0,0,0,1,0,1,0,0,0,1,0,0,2,2,2,2,0,0,0,1,0,1,0,2,1,2,0,0,1,0,0,0,0,2,0,0,0,2,2,1,0,0,0,1,2,2,1,1,0,1,1,1,2,0,0,0,0,1,2,0,1,2,0,0,0,0,2,2,2,0,0,2,0,1,0,1,1,0,2,0,1,0,0,2,2,0,0,1,2,0,0,1,0,1,2,0,2,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,2,1,2,0,1,1,0,2,1,1,1,2,0,2,2,0,0,2,0,0,0,1,1,0,0,1,2,0,0,0,1,0,2,0,0,1,2,0,0,0,1,2,2,2,1,1,1,1,1,1,1,1,0,0,0,2,0,0,0,0,0,0,0,0,0,2,0,0,0,1,0,1,2,0,2,0,1,2,2,13,13,13,3,3,13,13,13,0,1,2,0,0,1,0,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,3,1,2,2,0,0,2,2,2,2,0,2,0,1,0,2,13,0,2,0,2,0,0,0,13,13,13,13,13,13,13,2,13,13,13,13,0,13,13,13,0,2,0,2,0,2,1,0,2,2,0,1,0,2,1,0,0,2,0,0,0,0,2,1,1,1,2,0,1,0,0,1,1,0,2,0,0,0,2,2,0,1,1,2,1,1,2,0,2,1,0,0,0,0,0,1,2,0,1,0,2,2,0,1,2,1,1,0,0,0,2,0,1,0,2,2,1,0,2,2,2,2,2,0,1,0,1,1,0,0,1,0,0,0,0,2,0,0,0,0,0,2,0,0,1,0,1,2,2,1,1,0,0,1,0,1,1,1,2,1,2,0,0,0,0,2,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,0,0,1,0,1,1,2,0,1,0,0,0,1,1,2,0,0,0,0,0,1,2,0,0,0,0,0,1,1,1,2,0,0,0,2,0,1,2,2,2,1,0,2,2,2,1,1,1,1,1,1,1,1,1,0,1,0,2,1,2,0,1,0,2,0,0,0,2,2,2,0,0,0,0,0,0,2,0,0,0,13,13,13,3,3,13,13,13,13,1,0,0,0,2,1,1,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,1,0,0,0,2,1,2,1,2,10,1,0,0,0,0,0,13,13,13,0,1,2,0,0,1,13,13,13,13,13,13,13,0,0,13,13,13,0,2,0,1,0,0,0,0,0,0,2,2,0,2,0,0,0,0,0,2,0,2,1,0,0,2,1,2,0,2,0,0,1,0,2,0,0,1,0,2,1,0,0,2,0,0,0,2,0,1,0,0,2,2,2,2,1,2,0,0,2,0,1,0,2,0,2,0,1,0,0,1,0,2,0,0,2,1,2,1,1,2,0,1,2,0,0,1,2,2,0,0,0,2,0,0,0,2,2,2,1,0,1,0,1,0,2,1,2,0,1,1,0,0,0,1,2,0,1,0,2,2,0,2,1,1,2,1,1,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,0,0,0,0,2,2,0,2,1,1,0,0,0,2,0,1,1,0,0,0,2,0,2,0,0,2,1,0,1,0,0,0,1,0,0,2,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,1,0,0,0,0,2,2,1,0,2,1,0,1,0,0,2,2,0,0,2,0,2,0,1,1,13,3,3,3,3,13,13,13,13,0,0,1,0,1,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,2,0,0,0,1,2,10,10,10,10,0,0,2,0,1,13,13,13,13,2,1,0,2,0,13,13,13,13,13,13,2,0,0,0,0,0,2,0,1,2,0,2,1,1,0,2,1,0,0,2,1,0,2,0,1,0,0,2,0,1,0,0,1,2,0,0,1,1,1,0,1,1,0,0,1,2,0,1,0,1,0,0,0,0,0,1,2,0,1,0,1,0,1,0,1,1,2,0,0,0,0,0,1,2,1,1,2,2,0,0,0,2,0,0,0,0,2,1,1,1,1,2,0,0,1,1,0,1,1,2,2,0,2,2,0,2,1,2,0,0,0,1,2,1,1,2,2,1,0,0,0,0,1,2,0,1,1,0,0,0,2,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,0,1,0,1,1,2,0,0,0,0,1,1,0,2,2,1,1,0,0,1,0,1,0,2,2,0,2,10,10,1,0,0,2,0,0,2,1,2,2,2,0,0,2,2,0,1,1,1,1,1,1,1,1,2,0,0,2,1,1,1,2,0,0,2,1,2,0,0,13,2,13,0,1,2,0,2,2,0,1,2,2,1,3,3,3,3,3,13,13,1,0,1,1,1,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,2,2,1,0,2,0,2,0,0,0,0,0,0,1,10,10,10,15,13,13,13,13,13,13,13,13,13,1,0,0,0,1,13,13,13,13,13,0,2,0,2,1,1,2,0,1,0,1,0,2,2,2,2,0,2,1,0,2,1,2,1,0,0,1,0,2,1,0,0,0,0,1,0,0,1,0,1,1,2,2,1,1,2,0,2,0,2,2,2,1,1,2,0,0,1,0,1,2,0,0,0,2,1,0,2,0,1,0,0,2,0,0,1,0,2,0,0,2,1,1,2,1,1,0,0,1,0,0,1,1,0,2,0,0,0,2,0,0,2,1,2,1,0,0,2,0,0,0,2,0,2,1,2,0,0,2,2,0,2,1,2,0,0,0,0,1,2,1,2,2,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,0,1,1,0,1,0,2,0,1,0,0,1,0,0,2,2,1,0,0,2,2,2,0,1,1,0,1,10,10,0,1,0,1,1,2,1,1,0,0,0,2,0,0,0,2,1,1,1,1,1,1,1,1,1,2,1,0,1,0,2,0,2,0,0,2,1,1,1,13,13,13,13,13,0,1,2,1,0,0,0,1,0,3,3,3,3,3,3,3,1,2,1,1,0,3,3,3,3,3,3,3,3,3,3,3,0,0,0,2,0,1,2,2,1,0,0,0,0,2,1,0,2,13,2,0,2,1,1,2,0,10,2,13,13,13,13,13,13,13,13,13,0,1,0,0,0,0,0,13,1,0,2,0,0,0,0,2,0,0,2,2,1,1,0,1,0,0,1,0,0,2,2,1,2,0,1,0,0,2,0,1,0,2,1,0,0,0,0,2,0,0,0,1,2,0,0,0,1,0,0,2,1,2,2,0,0,0,1,0,0,2,0,2,0,2,2,0,1,0,2,1,2,0,0,2,1,0,0,1,0,1,2,0,2,2,0,2,2,0,2,0,0,1,0,1,0,1,1,0,0,1,0,2,0,0,0,0,0,2,2,0,2,2,0,2,0,2,1,0,2,0,1,1,2,1,0,2,0,0,2,0,1,0,2,0,2,2,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,1,1,0,1,2,0,1,0,0,0,1,0,0,1,1,1,1,0,2,2,0,0,2,0,0,0,0,2,0,0,1,1,0,0,2,2,2,0,2,2,0,1,1,1,1,0,0,0,1,2,1,2,2,1,1,1,1,1,1,1,0,0,1,2,1,2,0,0,0,2,0,1,1,0,13,13,13,13,13,2,0,2,2,0,1,0,0,0,1,3,3,3,3,3,3,3,0,0,0,3,3,3,3,3,3,3,3,3,3,3,2,0,2,0,1,0,0,0,0,0,1,0,2,0,0,0,0,0,13,13,13,0,1,0,0,0,2,1,2,2,13,13,13,13,13,1,13,2,2,2,10,1,1,0,0,0,1,1,0,0,0,1,1,1,0,0,1,0,0,0,2,2,0,0,1,0,2,0,1,0,0,1,2,0,0,1,1,1,0,0,0,0,1,0,0,1,0,2,0,1,0,0,1,0,0,0,7,7,2,0,2,2,2,2,2,2,2,0,0,1,1,1,2,2,2,2,1,0,0,2,1,2,2,0,0,0,0,0,2,2,0,1,0,2,0,0,2,0,0,2,1,2,0,0,1,2,0,0,2,2,2,0,1,0,2,0,0,0,0,0,0,1,2,2,0,0,2,1,0,1,0,1,1,1,0,2,0,0,0,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,1,1,0,2,1,1,2,0,2,0,0,0,2,0,0,0,2,1,0,1,0,0,0,0,1,2,1,0,0,1,0,0,1,2,2,0,2,1,0,0,2,0,0,0,0,0,0,2,2,1,2,0,0,0,2,0,2,0,2,1,1,1,1,1,1,1,1,1,0,2,1,0,0,1,0,0,0,0,2,1,1,1,2,2,13,13,0,1,1,0,0,2,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,1,1,3,10,2,2,2,0,0,0,10,10,10,1,10,15,10,13,13,13,13,2,0,2,0,13,0,0,0,13,13,13,13,13,13,13,0,0,10,10,10,0,0,0,0,0,0,2,0,0,2,1,0,2,2,0,2,0,0,0,1,1,1,0,0,2,0,0,0,0,2,1,1,0,1,1,1,0,0,1,0,2,0,0,1,2,0,0,0,2,0,0,0,1,1,7,7,2,0,0,2,1,0,0,0,0,1,2,0,1,0,0,1,0,0,2,0,0,1,0,2,2,1,0,0,0,0,2,0,0,2,0,2,0,2,0,1,0,0,0,1,1,2,0,1,0,2,1,0,0,0,0,2,0,0,0,0,0,0,2,1,0,0,0,2,0,0,1,1,0,0,0,1,2,0,2,0,1,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,0,0,0,1,1,0,1,0,1,2,0,2,0,1,0,2,1,1,0,2,1,2,2,0,1,2,2,2,1,0,0,0,0,0,0,1,1,0,0,1,2,1,0,0,2,0,2,2,2,1,2,0,0,1,1,0,2,2,2,0,0,2,2,2,1,1,1,1,1,1,1,1,1,1,2,0,0,1,1,0,1,0,0,0,1,1,0,2,2,2,0,1,2,1,2,1,1,1,0,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,2,1,2,10,10,10,2,2,0,1,1,0,10,10,10,10,10,10,10,13,13,0,0,2,0,13,13,13,0,13,13,13,13,13,13,13,13,13,13,0,10,10,10,10,0,0,0,2,2,0,1,0,1,1,0,0,0,1,0,2,2,1,0,0,1,1,2,1,0,0,1,0,0,0,1,1,1,1,1,0,0,2,0,2,2,0,1,0,1,0,2,0,0,0,0,1,7,7,2,0,0,0,0,0,0,0,0,2,2,0,0,1,0,0,2,0,0,2,2,0,0,0,0,0,1,0,1,2,0,0,0,1,2,0,2,2,2,0,0,2,0,1,2,0,1,2,1,0,0,1,0,0,0,1,2,0,1,1,2,1,0,1,0,2,2,0,0,0,1,0,2,0,1,2,2,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,2,0,0,1,0,0,2,1,2,2,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,2,2,1,0,2,0,1,1,1,2,1,2,1,1,2,1,1,0,1,2,0,0,2,0,1,2,2,2,0,0,0,2,0,2,2,0,0,1,1,1,1,1,1,1,1,1,1,2,0,0,1,2,0,0,2,0,0,1,0,1,0,0,0,1,2,1,2,1,2,0,1,0,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,2,2,0,0,10,10,10,0,0,0,1,2,10,10,10,10,10,10,10,1,15,10,2,1,2,13,13,13,2,1,1,13,13,0,2,13,13,13,13,13,13,0,10,2,1,2,0,1,2,2,1,0,2,0,0,2,0,1,0,2,1,0,1,0,0,0,1,2,2,0,1,1,0,2,1,1,1,1,1,1,1,2,0,1,2,0,0,1,1,0,2,0,0,0,1,1,7,7,7,1,0,0,0,2,0,0,0,0,2,2,0,0,0,0,2,0,1,2,2,2,2,2,0,2,2,2,2,2,1,1,1,2,0,0,2,2,0,2,1,2,0,0,0,1,1,2,0,0,1,1,2,0,0,0,0,2,0,2,1,0,2,2,0,0,0,0,2,0,0,1,1,0,1,0,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,1,0,0,0,0,1,1,2,0,0,1,0,0,0,0,0,0,0,1,0,0,0,2,1,1,2,1,0,2,2,1,0,2,0,1,2,1,1,2,0,1,2,0,0,2,0,0,0,0,2,0,2,1,1,0,1,0,0,2,0,0,2,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,1,2,2,0,2,0,2,0,0,1,2,0,0,0,0,1,0,0,2,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,0,0,0,1,10,10,10,0,0,1,1,10,10,10,10,10,0,10,10,10,10,10,10,1,0,0,13,0,1,1,13,13,13,0,2,0,13,0,2,13,0,0,0,2,2,0,0,1,2,0,0,1,0,0,2,0,0,2,1,2,2,0,0,0,2,1,0,0,1,0,1,0,0,1,1,1,1,1,1,1,1,0,1,2,0,1,0,0,2,1,0,1,0,0,0,7,7,7,1,2,0,0,1,1,1,1,0,0,0,2,2,2,0,0,1,0,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,2,2,0,2,0,1,0,1,0,0,0,0,0,0,0,0,1,0,1,1,0,2,2,0,0,2,0,1,2,0,1,2,2,2,2,2,0,0,1,0,2,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,2,0,2,0,0,1,1,0,0,0,0,0,2,0,1,1,0,0,1,2,0,2,0,2,0,0,1,0,0,2,0,0,0,0,0,1,1,0,1,0,0,1,2,0,0,1,0,0,0,0,1,0,0,2,2,1,2,1,2,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,0,2,0,0,1,0,0,1,1,0,1,1,1,0,1,0,1,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,2,1,1,10,10,15,10,10,0,0,0,10,10,10,10,10,2,0,10,10,10,0,10,0,0,0,1,0,0,2,13,13,13,13,1,0,2,0,1,2,0,2,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,1,0,0,2,0,0,1,2,2,0,0,0,2,1,1,1,1,1,1,1,1,2,0,1,0,1,0,1,1,0,0,0,0,1,7,7,7,7,0,2,0,2,1,0,2,1,0,0,2,0,1,2,2,2,1,0,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,7,7,0,2,0,0,1,2,0,0,0,0,0,0,2,2,0,0,1,2,0,2,2,0,2,2,0,0,1,0,1,0,1,1,0,2,0,2,0,1,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,0,0,0,0,0,0,2,0,1,0,1,0,0,0,2,0,0,0,0,1,1,2,2,1,2,1,1,2,2,1,2,0,0,1,2,0,0,0,0,2,1,0,2,0,1,2,2,2,0,1,0,1,0,2,2,2,2,0,2,1,1,0,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,2,0,1,1,1,0,0,13,13,0,0,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,2,0,10,10,10,10,10,10,10,0,10,10,10,10,10,10,0,0,10,10,10,2,2,0,2,0,2,0,1,2,2,13,13,2,2,0,1,1,1,0,0,0,0,1,0,0,2,0,2,2,0,2,1,0,0,1,1,2,2,0,0,0,0,1,0,0,1,2,0,2,0,1,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,0,1,1,2,7,7,7,7,1,2,1,0,1,0,1,0,0,2,0,1,2,0,2,0,0,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,7,7,7,2,1,2,0,2,2,0,0,0,1,2,0,0,0,1,0,0,0,1,0,0,2,1,0,0,2,0,2,0,0,0,1,0,0,1,2,2,1,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,2,1,0,0,0,0,0,1,1,0,0,0,2,2,1,2,2,0,1,0,2,1,1,0,1,1,1,1,2,2,0,0,1,2,0,0,1,0,0,2,1,2,0,1,1,1,0,0,1,0,2,0,0,0,2,0,2,0,1,2,0,1,2,0,0,0,1,0,2,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,0,0,0,0,0,0,2,1,13,13,13,13,1,2,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,2,1,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,2,1,10,1,1,0,2,0,0,0,0,0,0,2,0,1,1,0,0,2,0,1,0,0,1,2,1,1,1,0,0,2,2,0,0,1,2,2,2,1,2,1,0,0,2,0,1,2,2,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,1,2,1,1,2,1,1,0,0,2,0,0,0,7,7,0,0,2,0,2,1,2,2,0,0,0,0,0,0,2,0,0,1,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,7,7,7,7,0,0,2,1,0,0,0,2,2,1,1,2,0,1,0,2,0,0,1,1,2,2,0,0,1,1,1,2,0,0,2,0,1,0,0,0,1,2,2,1,2,0,0,0,0,2,1,1,1,1,1,1,1,0,1,0,0,0,1,0,0,0,0,2,0,1,2,0,1,0,0,2,0,0,2,0,1,0,0,2,1,0,2,1,1,0,0,1,0,2,0,0,2,0,1,0,0,0,0,0,1,1,2,0,1,0,2,0,0,0,0,0,0,2,2,1,0,0,0,2,2,0,2,0,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,0,0,2,2,2,1,13,13,13,2,2,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,2,0,0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,2,1,0,2,0,1,2,0,2,2,0,0,10,10,15,0,10,0,2,1,2,1,0,1,0,2,1,2,0,2,2,2,0,2,2,2,0,1,0,2,1,1,1,0,1,2,2,1,2,0,2,0,0,0,0,1,1,1,1,1,1,1,1,1,0,1,1,2,1,0,0,2,1,0,0,0,0,2,7,7,7,1,1,0,1,1,2,2,1,0,0,0,0,0,0,1,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,7,7,7,7,0,2,1,1,0,1,0,1,1,0,1,0,0,2,2,0,2,1,0,2,2,0,0,2,0,0,0,2,2,0,0,0,0,2,0,2,2,2,2,0,0,2,1,0,0,1,0,2,0,2,1,1,1,1,1,2,2,2,0,0,1,0,1,0,1,0,1,2,0,1,0,0,0,0,1,0,2,2,1,0,0,0,0,0,2,0,0,0,1,2,0,1,0,0,1,0,2,2,0,0,2,2,0,0,0,0,1,0,0,0,2,0,0,1,0,2,1,1,1,2,0,0,1,0,0,0,1,2,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,0,0,2,0,0,2,0,2,1,0,13,2,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,2,1,0,10,10,10,10,10,10,10,10,10,10,10,10,1,0,0,2,2,0,1,1,0,2,0,0,2,2,10,10,10,10,10,10,2,0,1,2,0,0,2,2,0,1,0,1,2,1,0,0,1,0,0,0,0,0,2,2,1,2,0,1,1,2,0,0,2,1,2,1,1,1,1,1,1,1,1,1,1,2,0,0,1,0,1,1,0,0,2,0,0,0,0,0,7,7,7,2,2,0,0,0,0,2,0,0,2,0,2,0,0,1,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,7,7,0,2,2,0,0,1,0,0,0,0,2,1,0,2,0,0,0,1,2,0,0,2,0,0,0,0,0,1,1,2,0,2,0,0,0,0,0,2,0,0,1,1,1,1,0,2,0,2,0,2,0,1,0,0,0,0,2,2,0,0,0,2,2,0,0,1,1,1,1,2,2,2,0,0,0,0,1,0,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,0,0,2,1,2,0,2,2,0,0,2,0,0,2,2,1,2,0,2,1,0,0,0,0,0,2,1,1,2,0,1,1,1,1,0,2,2,0,0,1,1,1,1,1,1,1,1,2,0,0,0,2,0,0,2,0,2,0,2,1,0,0,0,0,0,2,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,2,0,0,0,10,10,10,10,10,2,2,1,2,1,2,10,2,0,2,2,0,1,0,0,0,0,0,0,2,0,10,0,0,10,0,2,0,0,2,0,0,1,2,0,0,0,2,2,1,0,1,1,2,0,0,0,0,2,0,0,1,1,2,0,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,0,2,0,0,1,2,0,0,0,1,1,0,7,7,0,2,0,0,1,1,0,2,0,0,0,1,0,0,1,0,0,2,2,2,2,2,2,2,2,2,2,0,7,7,1,1,0,0,2,0,0,1,1,1,2,0,0,0,1,2,0,2,2,2,0,0,2,0,1,2,2,2,0,1,0,0,1,1,0,1,0,0,2,2,0,1,1,2,1,1,1,1,0,0,0,0,1,0,1,0,1,2,1,0,1,0,0,0,0,1,1,0,1,0,0,1,1,0,1,0,0,0,1,1,2,2,2,1,0,1,0,1,1,1,0,0,0,2,2,0,2,0,0,1,2,0,0,0,1,1,0,0,2,0,0,2,2,1,1,0,1,0,0,1,1,0,1,0,1,2,2,1,0,1,0,1,0,1,2,1,1,0,1,1,1,1,2,1,0,2,2,1,0,1,1,0,0,1,2,0,2,1,0,1,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,0,2,0,10,10,10,0,0,0,0,2,2,0,0,10,1,2,2,2,0,1,0,0,0,0,0,0,1,2,10,1,0,1,1,0,2,1,0,1,0,1,2,2,2,0,1,0,0,0,2,0,0,1,2,0,2,0,0,0,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,2,0,1,0,0,0,2,2,2,0,0,1,0,0,0,0,2,0,0,2,1,1,2,0,1,0,2,0,2,0,0,2,0,0,0,2,2,2,2,2,2,2,2,2,0,7,7,7,0,1,1,2,2,0,0,1,2,2,0,2,0,0,0,0,1,0,0,2,0,0,1,0,1,1,1,2,0,0,0,0,2,0,1,0,1,2,0,0,1,1,0,2,0,0,1,2,0,0,1,2,2,1,0,0,0,2,2,2,2,2,0,0,0,1,2,0,0,2,0,1,1,2,1,0,0,2,0,0,1,2,0,1,0,1,0,0,0,2,0,0,2,0,0,0,1,2,1,0,1,2,0,0,0,1,0,2,0,1,0,0,0,0,0,2,2,2,0,0,2,0,0,1,0,1,2,0,1,2,1,1,1,0,1,0,2,2,0,1,2,2,0,1,2,0,0,0,1,2,1,2,0,0,0,0,0,0,0,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,0,0,0,2,1,2,1,2,10,0,1,1,0,10,10,0,0,2,0,1,0,0,0,0,0,2,1,2,0,2,1,0,0,2,0,2,1,0,0,0,0,0,0,0,0,2,1,1,2,2,0,2,0,1,0,2,0,0,2,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,0,2,0,1,2,0,0,0,0,0,2,0,1,0,1,0,0,0,0,0,2,1,2,1,1,0,1,1,0,0,0,0,2,2,2,2,2,2,2,2,7,7,7,7,7,1,2,0,0,1,1,1,0,2,2,2,0,1,0,1,1,2,2,2,1,0,2,0,0,2,1,1,1,0,0,0,2,0,0,0,2,0,1,2,1,2,0,1,1,1,1,2,0,0,1,1,0,1,0,0,1,2,1,2,0,0,1,1,0,0,0,0,0,2,0,1,2,0,1,0,0,0,0,0,2,2,1,0,0,0,2,0,0,0,0,0,1,2,0,0,1,1,1,1,2,2,1,1,1,1,2,2,0,0,2,2,0,0,0,2,1,1,0,0,0,0,0,1,2,1,0,0,2,0,1,0,0,0,0,1,1,0,1,2,1,2,0,0,0,2,0,0,2,1,1,1,0,2,0,0,1,0,2,1,0,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,1,0,0,2,0,1,10,10,10,0,1,2,0,2,0,2,0,0,1,0,0,2,0,0,1,0,0,2,1,2,0,2,0,2,2,0,0,1,0,2,0,0,2,0,0,2,1,2,2,2,0,0,2,2,1,0,0,2,0,0,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,0,2,0,2,2,0,1,1,1,2,1,0,1,1,2,0,0,1,2,0,2,2,0,0,1,2,0,1,1,1,2,1,0,1,2,2,2,2,2,2,2,7,7,7,2,2,2,2,0,0,2,0,2,0,1,1,0,0,2,1,2,0,0,0,0,0,1,0,0,2,1,1,1,1,1,1,2,0,1,0,1,2,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,2,1,0,2,1,0,0,0,0,1,1,0,0,0,1,2,2,0,1,0,2,2,2,0,0,1,1,1,0,2,0,2,1,0,2,0,0,0,0,0,1,0,1,2,1,0,0,0,0,0,0,1,0,0,1,0,1,1,0,1,0,0,0,1,0,1,0,0,2,0,0,1,0,0,2,1,1,1,1,1,2,2,0,1,2,2,1,2,0,0,0,1,0,0,2,0,1,1,1,0,1,1,0,2,1,0,0,0,1,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,0,0,2,0,2,0,0,10,2,0,0,2,0,0,0,10,1,0,0,0,2,2,0,1,1,2,0,0,0,2,1,0,0,2,1,1,0,2,0,0,0,2,0,0,0,1,2,2,1,1,0,2,0,1,2,2,0,0,0,1,2,0,1,1,1,1,1,1,1,1,1,1,1,1,2,0,1,2,0,0,2,0,1,0,0,1,2,1,0,1,0,0,0,1,2,0,0,1,0,0,0,0,1,1,0,0,0,0,0,2,2,1,1,2,2,2,2,2,2,2,2,2,0,1,1,0,0,0,0,1,1,2,0,0,0,1,0,1,0,2,1,0,2,0,1,0,0,0,1,1,1,1,1,1,1,2,0,0,2,0,0,0,1,2,2,1,1,1,0,0,2,2,0,0,0,0,2,0,1,0,1,0,2,0,2,0,1,0,2,1,2,0,0,1,2,0,0,0,1,2,0,2,0,0,2,1,0,0,0,0,2,0,0,1,1,2,2,0,2,2,1,0,0,2,0,0,0,2,0,1,1,0,1,0,1,0,1,0,0,0,2,0,1,0,1,0,0,1,2,1,0,0,2,0,0,0,2,0,0,2,0,0,2,0,0,0,2,0,0,1,0,0,1,1,0,2,1,0,0,0,0,2,2,0,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,1,7,7,0,10,10,10,1,0,10,0,0,1,1,10,0,0,2,0,2,2,2,1,0,1,0,1,2,1,2,1,2,0,0,2,1,1,2,0,1,1,0,0,1,0,2,0,2,1,0,0,2,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,2,0,0,2,1,0,0,2,0,0,0,1,0,1,2,2,0,1,0,1,2,1,0,0,0,1,0,0,2,2,2,1,1,0,1,1,1,0,2,2,0,2,2,2,2,2,2,2,2,0,1,1,0,2,1,0,1,1,0,2,0,2,0,1,1,1,0,0,2,0,2,0,1,0,1,2,1,1,1,1,1,1,1,1,2,2,0,1,0,2,1,2,1,1,1,1,1,0,2,0,1,0,0,0,0,2,0,0,0,0,1,0,2,0,2,2,0,0,2,0,0,0,0,0,2,0,2,0,1,1,0,0,2,1,0,0,1,1,0,0,1,2,2,1,0,1,2,1,2,0,0,2,2,0,1,0,0,0,1,2,1,2,1,1,0,0,0,0,0,0,0,0,0,1,2,0,0,0,0,0,0,0,1,1,2,2,0,2,2,0,1,0,0,0,2,0,1,0,0,1,2,2,2,2,2,2,0,1,0,0,0,1,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,1,7,7,7,0,0,10,2,0,2,10,0,2,0,10,10,0,2,1,0,0,1,0,2,2,0,0,0,2,0,0,0,0,0,0,2,1,2,0,1,1,1,0,1,1,0,0,1,1,1,1,1,0,2,0,2,0,0,0,0,2,0,0,1,1,1,1,1,2,1,0,2,0,0,0,0,0,1,2,0,0,2,1,0,0,2,0,0,0,0,1,2,1,1,0,0,1,1,0,1,0,2,0,1,1,1,1,2,1,2,0,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,1,0,0,2,2,0,2,0,0,0,0,2,1,1,0,2,2,0,0,2,1,1,1,1,1,1,1,1,1,0,1,0,0,1,0,0,2,0,2,1,2,0,2,0,0,1,0,0,0,0,0,2,0,2,2,0,0,0,0,2,2,0,1,0,1,0,0,1,2,0,0,1,0,0,1,0,0,0,1,1,1,1,0,0,1,0,2,2,1,0,0,2,2,1,1,0,1,0,0,1,2,2,2,2,2,1,2,0,0,0,2,1,0,2,0,2,0,2,0,1,0,0,0,1,1,0,0,2,0,0,1,0,1,1,0,0,0,1,0,0,1,2,0,0,2,0,2,0,2,1,1,2,0,1,0,0,0,1,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,7,7,7,0,1,10,1,0,1,0,10,0,10,10,2,2,0,2,0,0,0,2,0,2,0,2,2,1,1,0,2,2,1,0,2,0,1,2,0,0,2,0,1,0,1,2,2,1,2,0,2,0,2,2,0,0,0,0,1,0,0,2,0,1,1,1,0,0,1,0,0,1,0,0,0,0,1,2,1,1,2,1,2,0,2,0,0,0,0,0,0,0,2,1,0,0,1,1,0,2,0,0,0,1,1,2,1,0,0,2,1,2,2,2,2,2,2,0,0,1,1,0,1,1,1,1,2,1,0,0,1,0,0,1,0,1,2,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,0,0,0,2,2,0,2,2,0,1,1,0,1,1,1,0,0,2,2,0,0,0,1,1,0,1,2,0,0,0,1,0,0,0,0,2,2,0,0,1,0,0,1,2,0,2,2,1,1,1,0,0,0,1,2,0,1,2,2,2,2,1,2,1,0,1,2,2,0,0,2,0,1,2,2,0,1,2,2,0,1,0,2,0,1,0,0,0,1,0,0,2,1,0,1,0,0,0,2,0,0,1,0,0,2,2,1,2,1,1,0,0,0,2,1,2,0,0,0,1,2,1,0,0,0,2,2,0,0,2,2,0,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,7,7,0,1,1,0,0,1,10,10,10,10,10,0,2,0,1,2,2,0,1,1,2,0,0,0,0,0,0,1,0,0,2,0,2,1,0,0,2,2,1,0,0,0,2,2,1,0,2,0,1,0,0,1,2,1,1,2,0,2,0,0,0,0,2,0,2,1,0,1,1,0,1,0,1,2,0,0,1,1,0,1,0,2,0,1,2,2,0,0,2,0,0,0,1,2,0,0,1,0,0,1,2,1,1,0,0,1,0,0,2,2,2,2,2,2,1,0,0,0,1,1,1,1,1,1,2,1,2,2,2,0,0,1,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,0,1,0,0,0,0,0,0,1,2,0,0,1,0,1,0,2,1,2,1,1,0,2,1,0,0,0,1,1,0,0,2,0,0,2,1,0,1,0,0,2,0,1,2,0,0,0,0,1,2,2,0,1,1,0,2,1,1,0,2,0,0,2,0,0,0,0,0,2,2,0,0,0,2,0,1,2,0,0,2,0,0,0,0,1,10,2,0,2,1,0,0,0,2,0,1,2,0,2,2,1,1,0,1,0,1,0,1,1,0,0,7,7,7,2,0,2,0,1,0,0,0,0,0,2,0,0,0,1,2,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,7,7,7,7,2,0,0,2,10,2,10,10,0,0,0,1,2,1,1,1,1,2,1,0,0,2,0,0,0,1,2,1,2,0,0,0,0,0,0,2,0,0,0,0,2,2,1,0,2,0,0,2,0,2,1,2,0,0,2,0,0,0,0,2,2,2,2,2,2,1,0,1,1,1,0,2,0,0,0,2,0,0,2,0,1,0,2,2,0,0,0,1,0,1,1,0,0,0,2,2,0,1,1,0,1,0,0,1,1,2,2,2,2,0,1,1,1,1,1,1,1,1,1,1,1,1,0,2,1,2,1,1,2,1,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,0,0,2,2,0,0,0,0,2,1,2,1,0,0,0,0,0,0,0,1,1,0,0,2,0,0,0,0,2,2,0,0,0,0,1,2,0,1,0,2,2,0,0,0,2,2,0,0,0,0,1,2,0,0,2,2,1,0,0,0,0,0,1,0,2,0,0,2,0,2,1,1,0,1,0,0,1,1,1,0,2,1,1,1,1,0,2,10,10,10,2,1,1,1,2,0,0,2,2,1,0,2,1,0,2,0,0,2,0,2,1,0,2,7,7,7,2,0,0,1,2,0,0,2,1,1,1,1,2,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,7,7,7,7,7,2,0,10,10,10,10,10,10,0,1,1,1,0,2,0,2,0,0,0,2,2,1,1,0,0,1,2,0,0,1,0,1,1,0,0,0,2,1,1,0,1,1,2,0,1,1,0,2,2,2,2,2,2,0,1,2,1,1,2,0,1,2,2,0,0,0,2,2,0,0,0,1,2,2,2,2,2,1,0,2,2,1,0,0,2,0,0,2,0,0,1,1,0,1,2,0,2,0,0,0,2,2,1,0,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,2,0,2,0,0,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,2,2,2,0,2,1,1,0,0,0,1,2,0,1,0,2,2,0,2,2,1,2,2,1,2,0,0,0,0,1,1,2,1,2,0,0,0,2,2,0,1,0,2,1,2,1,1,0,2,1,0,0,0,2,0,2,0,2,0,1,0,2,0,0,1,0,1,2,0,0,2,2,1,1,1,1,2,2,0,1,0,0,2,1,1,1,1,0,2,10,10,10,10,1,0,0,0,0,0,0,2,0,0,2,2,0,2,2,2,0,2,2,1,2,7,7,7,0,0,0,0,2,0,2,2,1,1,0,1,0,1,0,1,1,13,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,0,7,7,7,7,0,0,0,10,2,0,10,2,1,1,2,0,1,0,0,0,0,0,1,1,2,2,2,2,2,2,2,0,1,0,0,2,0,0,2,0,2,2,0,0,2,2,0,1,2,2,0,0,1,2,2,0,0,0,0,0,2,1,0,1,2,0,0,0,0,0,2,2,0,0,0,2,0,0,1,2,1,1,0,0,0,2,0,2,0,0,0,2,0,0,2,2,0,1,0,0,0,1,0,0,2,0,0,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,2,1,2,2,0,0,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,0,1,2,0,0,2,0,0,1,2,0,0,2,0,2,2,0,0,0,2,0,2,0,1,1,2,0,2,2,2,1,0,2,2,0,2,1,1,0,1,0,0,2,2,2,1,0,1,0,0,1,2,0,1,2,0,1,0,0,1,2,1,2,2,2,1,1,1,1,1,0,0,0,1,0,1,1,1,1,1,0,10,10,10,10,10,0,2,0,0,0,2,1,0,0,2,0,0,0,1,1,0,0,2,0,7,7,7,7,1,2,0,1,2,2,0,2,1,1,0,0,0,0,2,2,0,13,13,13,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,2,2,2,0,0,2,2,1,2,2,0,1,2,1,0,2,0,0,0,0,0,2,0,0,0,0,2,1,0,0,2,0,0,2,0,0,0,2,0,0,1,1,0,0,0,0,1,1,0,0,2,0,1,0,1,2,2,0,2,2,0,0,0,1,1,2,0,0,0,0,0,1,0,1,1,1,0,0,0,1,1,0,2,2,2,1,1,0,1,0,0,0,0,0,2,1,0,0,0,0,0,1,2,2,1,1,0,0,0,2,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,2,2,2,0,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,2,1,1,1,0,0,0,0,2,2,2,2,0,0,2,0,0,2,2,0,0,0,2,2,0,2,2,2,0,0,1,1,2,0,1,0,0,1,2,0,0,2,0,0,0,0,0,2,0,1,2,0,1,1,0,2,0,0,0,2,2,2,0,0,2,0,0,0,0,0,0,0,2,1,1,1,1,0,0,0,1,0,0,1,1,1,1,1,0,1,10,2,10,1,1,2,0,2,0,0,1,0,1,1,1,0,0,0,0,0,2,1,7,7,7,7,7,1,2,1,0,1,2,0,0,2,1,2,1,0,1,2,0,0,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,1,1,0,2,0,1,0,2,2,2,0,2,0,0,0,0,1,1,0,0,0,1,0,0,2,2,1,0,0,0,2,0,2,0,1,0,0,1,2,0,0,0,0,2,1,0,0,1,1,0,2,1,2,1,1,0,1,0,2,2,2,1,0,0,2,0,0,0,0,0,1,0,1,0,0,2,1,1,0,0,0,0,1,0,0,2,0,1,1,1,1,1,0,0,0,0,0,0,1,2,2,0,0,0,0,2,1,0,0,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,2,0,0,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,2,2,0,1,0,1,1,0,0,1,0,0,2,2,1,2,2,1,0,0,0,2,1,0,0,2,2,0,0,2,1,0,0,2,2,1,2,0,2,1,0,2,1,0,1,0,2,2,0,1,0,0,0,2,1,0,0,0,2,1,0,2,2,1,0,1,1,1,0,2,0,0,0,2,0,0,1,1,1,1,1,0,0,0,0,0,2,0,0,2,0,0,0,2,1,1,1,0,0,0,1,1,0,2,0,2,0,0,2,2,1,1,2,7,7,7,7,7,0,2,2,0,1,1,0,1,0,0,1,0,2,2,1,2,2,0,13,13,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,2,0,2,0,0,2,0,1,0,0,2,0,2,1,0,1,0,0,0,1,0,1,2,0,0,0,0,1,2,0,0,0,1,0,2,2,0,0,2,0,0,1,2,0,1,0,0,0,2,1,2,2,0,2,1,2,0,2,1,0,1,1,0,2,2,7,7,0,0,2,1,0,2,2,2,1,0,0,0,2,2,0,0,1,1,0,1,1,1,1,1,1,0,2,0,0,0,2,2,0,0,1,0,2,2,1,0,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,0,1,0,0,0,1,2,1,0,1,0,1,0,0,0,0,2,0,1,0,0,0,0,1,0,2,0,2,0,2,1,1,2,0,0,0,1,0,0,0,0,0,0,2,1,0,0,0,2,0,0,1,0,2,0,0,0,2,1,0,1,1,1,1,0,0,0,1,0,2,1,0,0,1,1,1,0,2,0,0,2,0,0,0,0,0,2,0,1,0,1,1,1,1,0,2,0,1,2,1,2,0,0,2,1,2,0,2,2,2,2,0,1,0,0,1,0,2,0,1,1,0,1,0,0,1,2,0,0,2,2,1,1,1,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,1,13,13,0,2,0,1,1,1,1,1,2,1,2,0,0,0,0,1,1,0,0,0,2,0,2,0,0,0,1,0,1,0,1,2,1,0,2,0,0,0,0,1,0,0,0,2,0,0,0,0,1,0,0,1,1,0,0,7,7,7,7,7,7,7,7,1,0,0,2,1,0,1,1,0,0,2,1,2,1,1,0,0,2,1,1,1,1,1,1,1,1,1,0,2,1,0,0,2,0,0,1,2,1,0,0,0,1,0,2,1,1,1,1,1,1,1,1,0,1,2,0,0,0,0,1,0,1,7,7,7,7,2,2,2,2,2,2,2,2,2,2,1,1,0,1,0,2,0,1,2,2,2,0,0,2,0,0,2,0,2,0,0,0,1,1,0,2,0,0,1,1,1,1,1,0,1,0,0,0,0,1,0,1,0,0,2,0,0,1,1,2,2,0,1,0,0,0,0,1,0,2,2,0,0,0,1,2,1,1,1,1,2,0,2,1,0,0,0,0,2,0,1,1,0,1,1,1,2,1,0,0,1,1,0,1,2,2,0,1,1,1,0,1,0,0,2,0,0,2,1,1,2,0,0,2,0,1,2,1,0,2,2,0,2,1,2,1,2,2,0,0,0,0,0,2,0,1,1,0,0,1,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,13,13,13,13,0,0,2,0,1,1,0,2,2,0,0,2,2,1,1,0,1,0,1,0,0,1,0,1,2,2,0,0,1,2,1,0,0,0,0,1,2,0,1,0,2,1,0,0,2,0,0,1,0,1,0,0,2,1,7,7,7,7,7,7,7,7,1,0,2,2,0,2,0,0,1,0,0,2,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,0,0,0,2,1,0,0,2,1,1,1,0,2,0,2,0,0,1,1,1,1,1,1,0,1,0,0,2,0,0,2,2,1,0,7,7,7,7,7,2,2,2,2,2,2,2,2,2,2,0,1,0,1,2,1,0,0,0,0,1,0,1,2,0,0,1,0,0,0,0,1,2,0,0,0,0,1,1,1,1,1,1,1,0,0,0,1,0,0,0,0,1,0,0,1,1,0,2,2,1,1,1,1,0,2,1,0,2,1,0,0,2,2,2,0,1,1,1,0,2,2,2,0,1,0,2,0,0,2,2,10,10,1,2,0,0,2,0,0,2,1,0,0,0,0,1,1,1,1,0,0,0,1,2,0,1,0,2,1,0,0,0,1,0,0,0,1,0,1,1,1,1,0,0,1,0,1,0,0,0,1,2,1,2,1,1,1,2,0,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,1,2,0,2,1,13,2,0,1,0,1,1,0,2,1,1,0,0,2,1,2,0,1,2,0,2,0,1,2,2,0,1,1,0,0,2,2,0,0,1,0,2,2,0,2,0,2,0,1,2,0,1,1,0,0,0,0,1,7,7,7,7,1,2,0,1,0,1,1,0,0,0,2,2,2,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,0,0,0,0,0,1,0,0,1,1,0,2,2,1,0,0,0,0,2,0,0,1,2,2,2,1,1,7,7,7,7,0,2,1,2,2,2,2,2,2,2,2,2,2,0,1,0,1,2,0,1,2,2,0,0,2,2,2,1,1,0,2,0,0,0,1,0,0,0,2,1,1,1,1,1,1,1,1,0,1,1,0,0,2,0,1,2,0,0,0,0,0,1,1,0,0,2,0,1,0,0,0,2,0,0,0,1,2,1,0,1,3,3,3,0,0,2,0,0,0,0,0,1,0,2,10,10,10,10,0,0,2,0,0,2,0,0,1,0,2,0,1,0,1,1,1,2,2,0,1,1,0,1,0,2,2,0,0,1,0,1,0,1,1,1,1,1,1,2,2,0,2,0,2,1,0,0,2,0,0,0,2,2,0,0,0,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,13,1,1,2,0,13,13,13,0,0,2,0,0,0,0,0,0,0,0,1,2,0,2,0,2,2,0,2,2,2,0,2,1,0,0,2,0,0,0,1,0,2,2,2,0,1,0,0,2,0,2,2,1,0,0,0,0,1,0,1,0,2,0,0,0,1,2,0,1,0,0,0,0,0,1,1,1,2,2,0,1,1,1,1,1,1,1,1,1,1,0,2,0,0,2,0,2,2,0,0,1,0,0,1,0,0,0,1,0,1,2,0,1,0,0,2,0,2,0,1,0,7,7,7,7,7,2,0,2,1,2,0,2,2,2,2,2,2,2,2,2,0,2,1,2,0,2,1,0,1,1,2,2,2,1,0,0,2,1,1,1,1,2,2,1,0,1,1,1,1,1,1,1,1,0,2,0,1,0,2,0,2,0,1,0,0,1,2,1,1,0,0,2,0,2,1,0,2,2,0,0,2,0,0,0,2,3,3,3,3,2,2,0,0,1,1,2,0,0,1,0,1,10,0,0,2,0,2,0,1,0,2,0,0,0,2,2,1,0,1,2,1,2,1,0,1,2,2,2,0,2,2,0,0,0,0,0,1,1,1,1,1,1,1,1,2,0,2,1,0,0,2,0,1,1,0,0,0,2,2,0,0,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,2,0,1,13,13,13,1,1,1,0,0,0,2,2,2,0,0,2,1,0,2,2,1,2,0,0,1,0,1,2,0,1,1,0,1,0,0,0,1,2,1,0,0,0,0,2,2,0,0,0,0,2,2,2,2,1,0,2,2,0,0,0,2,1,0,0,1,2,2,0,0,2,2,0,2,2,0,1,1,1,1,1,1,1,1,1,2,2,0,1,1,2,0,2,0,1,2,0,1,0,0,1,0,1,2,1,2,1,0,0,0,0,0,0,0,1,1,0,1,7,7,7,0,0,1,0,0,0,1,0,1,0,2,0,0,1,0,2,2,2,1,2,0,1,2,2,0,0,0,0,1,1,0,0,0,0,0,0,2,0,1,2,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,2,0,1,1,0,1,2,0,0,2,1,0,1,1,0,0,0,1,0,1,0,0,1,2,2,0,3,3,3,3,3,3,3,1,2,1,0,0,0,2,0,1,0,0,1,2,1,0,0,0,0,0,0,1,2,0,1,2,0,0,1,0,0,1,0,0,2,1,0,0,0,1,1,0,1,1,0,2,1,1,1,1,1,1,1,1,0,0,1,1,2,0,0,1,0,2,0,1,0,0,2,2,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,13,2,0,13,13,13,2,0,0,0,1,0,2,0,0,0,1,0,1,1,0,0,2,1,0,0,1,1,2,0,0,0,2,1,1,2,2,0,0,1,0,2,0,2,0,2,1,1,1,1,1,1,2,0,1,2,0,0,2,2,0,2,0,1,0,2,0,0,0,2,2,2,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,2,0,2,0,0,0,0,1,1,0,2,1,2,0,1,0,2,0,0,2,1,0,1,0,2,0,2,1,2,2,0,0,1,2,0,1,0,0,0,2,0,0,2,1,0,0,0,0,1,0,2,1,0,2,0,2,1,1,0,0,1,0,1,0,0,2,0,2,0,0,0,0,1,1,1,1,1,1,1,2,1,0,0,0,0,2,1,0,0,0,2,1,0,2,0,2,1,0,1,0,0,1,1,2,0,0,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,2,2,2,1,1,2,0,0,1,0,1,2,0,1,0,2,2,0,0,1,2,2,0,1,1,2,0,0,1,2,1,0,0,2,0,1,1,1,1,1,1,1,1,1,1,2,2,2,0,0,1,0,2,1,0,2,0,2,0,0,1,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,0,0,0,13,0,2,2,2,0,0,1,2,0,2,1,0,0,1,0,0,0,0,0,0,0,1,0,2,0,1,2,7,7,7,7,2,0,0,0,2,1,0,0,0,2,0,2,0,2,2,2,0,0,2,2,2,1,0,0,0,0,0,0,1,0,2,1,0,0,0,1,1,2,0,0,0,1,1,1,1,1,1,1,1,0,2,1,2,0,0,0,1,0,0,0,0,0,0,0,0,2,2,0,1,0,2,2,2,1,1,1,0,1,2,0,0,2,0,2,0,1,1,0,1,0,1,2,2,0,2,0,1,2,1,0,0,0,0,1,1,1,0,0,0,0,0,2,2,0,0,1,0,2,2,2,0,0,0,2,0,1,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,2,0,0,1,0,1,2,0,2,0,0,2,0,0,0,0,1,1,0,2,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,0,1,2,1,1,2,0,2,2,0,0,2,2,0,0,2,0,0,0,2,2,0,2,2,1,2,2,2,0,0,1,0,0,0,1,1,2,0,0,1,1,1,1,1,1,1,1,2,1,1,1,1,0,2,0,0,0,2,0,2,0,0,1,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,13,0,0,0,2,13,13,0,2,0,0,2,2,0,1,2,0,0,2,0,2,0,0,1,0,1,2,2,0,1,2,7,7,7,7,7,7,7,1,0,1,1,2,0,0,0,0,1,1,1,1,0,2,1,1,1,1,1,1,2,0,0,0,2,2,2,1,1,2,1,2,1,0,2,0,0,0,1,1,1,1,1,1,1,1,2,0,0,1,2,0,0,0,1,0,0,2,2,2,2,2,0,1,1,2,1,0,1,0,0,0,0,2,0,0,1,0,0,2,0,0,0,0,0,2,0,0,0,0,2,2,2,2,1,0,1,1,0,1,2,0,2,0,0,1,0,0,2,1,2,2,0,1,2,0,2,1,0,0,2,1,0,1,0,1,0,1,1,1,2,1,1,0,1,0,0,0,1,1,2,0,0,0,1,1,0,2,2,2,1,2,0,0,0,1,0,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,2,0,0,0,0,0,0,2,0,1,1,2,0,2,1,0,1,0,0,0,2,0,2,1,2,2,2,0,0,2,0,0,2,0,0,2,2,2,0,0,1,1,1,1,1,1,1,1,1,0,2,0,1,1,2,2,0,0,0,0,0,0,2,1,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,0,0,1,13,13,13,13,2,2,0,1,0,0,2,1,0,2,2,1,1,1,1,1,2,2,0,1,0,0,1,7,7,0,7,7,7,7,0,0,1,0,1,1,2,2,0,0,0,0,0,0,2,0,2,0,0,0,2,1,2,2,2,0,2,0,0,1,0,2,2,0,1,0,0,2,0,1,1,1,1,1,1,0,1,0,0,0,2,1,1,2,2,0,2,0,2,0,0,0,0,2,1,1,0,2,1,2,2,0,2,0,0,2,0,0,0,0,0,1,0,0,0,0,0,1,1,2,2,2,1,2,2,1,0,1,2,0,0,0,0,0,0,1,0,0,0,0,1,1,0,1,0,0,0,2,0,2,0,0,0,1,0,1,0,0,0,0,0,2,0,0,2,0,0,0,0,0,2,0,1,2,2,2,2,2,1,0,0,0,1,0,2,0,1,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,0,0,0,1,2,0,1,1,1,0,2,1,0,0,0,1,1,0,2,0,0,0,1,2,2,1,0,2,0,2,1,0,2,2,2,0,2,0,1,1,1,1,1,1,1,1,0,1,0,0,0,0,1,1,0,2,0,0,0,0,2,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,2,13,13,13,13,13,2,0,1,0,2,0,2,0,2,0,2,1,0,2,0,2,0,1,0,1,1,2,0,2,2,1,2,0,1,1,1,2,2,1,1,0,2,1,1,2,1,0,2,1,1,0,0,2,0,1,0,1,0,2,2,0,1,0,2,0,0,2,0,2,0,1,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,0,0,2,1,0,1,1,2,0,1,0,2,0,1,0,2,0,0,2,0,2,0,0,0,0,0,2,2,0,0,0,0,1,0,0,1,0,0,2,1,1,0,2,2,1,2,2,1,0,1,1,2,2,0,0,0,0,1,2,1,1,0,0,2,0,2,2,0,0,2,0,0,0,1,2,0,1,0,0,2,0,2,2,0,2,1,0,2,0,0,2,0,1,2,0,2,0,0,2,0,0,0,0,0,1,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,0,0,0,0,0,0,0,1,1,2,0,0,0,2,2,0,0,1,1,1,1,0,2,0,0,0,0,2,0,15,0,2,0,0,0,1,1,0,0,1,1,1,1,1,1,1,2,0,1,0,0,0,0,0,2,1,2,2,0,0,2,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,13,13,13,13,13,13,13,0,2,1,0,1,0,0,0,0,1,2,0,0,2,1,0,0,2,0,0,0,0,0,0,1,0,2,0,2,0,2,0,0,0,0,0,0,0,2,1,0,2,0,0,1,2,0,0,2,0,0,0,0,0,1,0,1,1,0,0,0,0,2,2,0,1,0,1,1,2,1,0,2,1,0,2,0,0,0,0,0,2,2,0,0,0,0,1,0,2,0,1,1,0,0,0,2,0,0,0,0,2,1,2,0,0,0,1,2,0,2,2,1,1,1,0,2,1,0,1,1,1,0,0,2,2,0,2,0,0,2,1,0,0,0,0,2,2,0,2,0,0,0,1,0,0,0,0,2,1,1,0,2,0,1,2,2,0,0,2,1,1,1,1,1,0,0,1,0,0,0,2,2,0,0,1,0,0,0,1,1,2,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,0,2,1,2,0,1,0,0,0,1,1,1,2,2,2,2,0,0,0,0,0,0,2,0,0,1,2,2,0,2,0,0,1,0,2,0,0,1,1,1,1,1,1,1,0,2,0,0,0,0,0,2,2,0,1,2,0,0,2,1,13,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,13,13,1,13,13,13,13,13,13,2,2,2,1,0,2,0,0,0,0,2,0,0,0,1,1,2,2,0,0,0,0,1,0,0,2,0,2,2,2,2,2,2,0,0,0,2,2,2,0,0,2,0,0,0,1,2,1,1,1,1,0,1,2,2,0,2,1,1,0,2,2,1,0,1,2,2,0,0,0,1,0,0,0,0,2,0,1,0,2,1,2,2,0,1,1,0,2,2,1,0,0,0,2,2,0,2,1,0,0,0,0,1,2,0,2,0,0,0,2,1,1,0,0,1,1,0,0,1,0,0,0,2,0,1,2,2,1,0,0,2,1,1,0,0,0,2,0,0,0,0,0,0,2,0,2,0,2,2,2,0,0,1,0,0,0,1,0,2,2,1,1,0,1,0,0,0,0,2,1,0,1,1,0,2,0,1,0,0,0,0,1,2,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,0,1,1,0,0,1,2,0,1,2,0,0,0,0,0,0,2,1,2,0,0,0,1,0,0,15,2,1,0,0,2,0,2,0,2,2,1,1,1,1,1,2,1,2,1,0,2,0,2,0,0,1,2,0,0,2,2,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,0,13,13,13,13,13,0,0,1,0,0,2,2,0,2,1,0,1,1,0,0,0,2,0,0,0,0,0,0,1,0,0,0,2,2,2,2,2,2,1,1,0,0,2,0,0,0,0,1,2,2,2,0,2,1,0,2,0,1,2,0,0,0,1,0,0,1,1,0,0,0,1,0,1,0,0,0,0,1,0,0,2,2,1,0,1,0,1,1,0,2,1,2,1,0,2,0,0,2,2,2,1,0,0,2,2,0,0,1,1,1,2,0,0,1,1,2,0,0,0,2,0,1,2,0,0,0,0,1,2,0,2,1,0,0,1,0,0,1,2,2,2,2,0,2,0,0,0,0,0,0,0,0,1,2,2,0,1,2,0,1,2,2,1,0,0,2,0,1,1,0,0,0,1,1,2,1,1,1,0,2,0,0,1,2,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,1,2,0,0,0,2,1,1,1,1,0,0,0,0,1,2,0,0,2,0,1,0,0,1,13,13,2,2,0,0,1,0,1,0,1,0,2,1,1,1,0,0,2,2,0,0,0,0,0,0,2,0,0,2,0,0,1,0,13,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,2,13,13,13,13,0,0,0,0,0,2,0,1,1,2,0,0,0,0,1,1,0,2,1,0,0,0,1,0,1,0,2,2,2,0,2,2,2,2,1,0,2,0,2,2,1,2,0,0,0,2,0,2,0,1,1,0,2,0,2,0,0,1,0,0,0,1,2,1,0,0,2,0,0,2,0,0,1,0,2,0,0,0,2,0,2,2,0,1,1,0,0,0,1,1,0,2,0,0,0,2,0,2,0,0,0,1,2,1,1,1,0,0,2,0,0,2,0,1,0,0,0,0,0,0,0,2,2,2,0,0,0,2,0,0,0,0,2,1,0,1,1,2,1,1,0,0,0,1,1,1,1,1,0,1,2,2,0,0,2,1,2,0,1,1,0,0,0,1,1,0,2,0,0,2,1,0,1,1,2,0,0,1,2,1,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,0,2,0,0,0,2,1,0,0,1,2,0,2,0,2,0,0,1,0,1,0,2,13,13,2,2,2,2,0,0,2,0,0,1,2,0,0,1,0,1,0,1,0,0,1,2,2,0,2,0,0,2,1,0,0,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,13,0,0,0,0,1,0,0,0,0,2,1,1,1,0,0,0,1,0,2,0,0,0,0,0,2,2,2,2,0,0,0,2,2,2,2,2,0,2,0,0,2,2,1,1,0,0,2,0,0,1,0,2,2,0,1,1,0,2,2,2,0,0,0,1,0,1,1,2,2,2,0,1,0,0,0,0,2,0,1,0,0,0,0,1,0,0,1,2,1,1,0,1,0,0,0,2,1,0,2,0,0,0,2,0,1,1,1,1,1,0,0,0,1,1,0,0,2,0,1,0,0,0,1,1,0,0,2,1,0,0,0,0,2,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,1,1,0,1,0,0,0,1,0,0,0,1,2,2,0,2,2,0,0,1,0,2,0,2,0,2,2,1,1,2,0,1,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,2,0,2,1,2,0,0,1,0,0,0,2,0,0,0,2,0,0,0,0,1,13,13,13,13,0,1,0,0,0,0,0,0,1,1,2,2,0,1,0,2,0,0,0,0,1,2,0,1,0,0,0,0,0,0,2,1,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,0,2,1,0,2,0,0,0,1,0,2,0,1,0,0,1,2,0,1,1,2,0,1,1,0,0,2,1,2,2,2,2,2,0,2,2,2,2,2,0,0,2,1,0,0,0,0,0,0,0,1,0,0,2,2,1,2,1,0,0,1,0,0,0,0,2,2,2,1,1,1,0,0,2,0,1,2,1,0,0,2,2,2,1,0,0,0,0,0,0,0,1,0,0,2,2,0,2,0,0,0,2,2,2,0,0,1,1,1,1,1,1,1,1,2,1,0,0,2,0,0,1,2,0,0,2,0,1,0,2,0,0,2,1,1,2,0,2,1,0,0,0,1,0,0,2,0,1,0,0,2,0,0,0,2,0,0,1,0,2,0,1,1,2,1,0,2,2,1,0,0,1,1,0,2,1,0,1,0,0,2,0,1,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,1,0,1,0,2,2,0,1,1,1,1,0,1,0,0,0,2,1,2,13,13,13,13,13,1,1,2,0,1,1,1,2,1,0,1,0,2,1,0,2,0,2,2,0,2,1,0,1,0,1,2,2,1,2,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,1,2,1,0,0,0,0,1,1,0,2,1,2,0,0,0,2,1,1,0,0,1,2,1,2,2,0,1,2,2,2,2,2,2,2,2,2,2,1,1,2,2,0,0,2,0,0,1,0,0,2,1,0,2,0,0,2,1,0,2,1,2,0,0,1,2,1,2,1,1,2,2,2,2,2,0,1,0,0,2,2,0,1,2,0,1,0,1,1,0,0,0,1,0,0,1,0,2,0,0,2,0,2,1,2,1,1,1,1,1,1,1,0,1,0,2,2,1,2,0,0,0,0,1,0,2,0,0,2,0,2,1,0,0,0,2,1,1,1,0,0,0,1,2,1,0,0,0,0,0,1,0,0,1,2,0,0,0,0,1,2,0,0,1,1,0,0,2,0,0,0,1,0,2,2,2,0,2,1,1,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,2,0,2,0,0,0,0,0,1,0,2,0,2,2,0,0,0,1,0,13,13,13,13,1,1,2,0,0,0,0,1,0,0,0,0,2,1,0,0,0,0,1,0,0,2,1,0,0,1,1,0,1,0,0,0,1,0,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,1,0,0,2,1,0,0,0,1,2,0,1,2,0,2,0,1,2,0,2,0,2,1,0,0,0,2,1,2,2,2,2,2,2,2,2,2,2,2,2,1,0,2,1,0,1,1,0,0,0,0,0,0,1,2,0,0,0,2,1,0,0,1,0,0,0,2,1,1,1,0,0,0,2,2,2,1,0,0,0,1,2,0,2,2,0,1,2,1,0,0,2,0,1,1,1,1,1,0,1,0,0,0,0,2,1,1,1,1,1,1,1,0,1,0,0,2,0,2,2,0,0,1,2,2,0,0,2,1,2,0,1,2,1,1,0,1,0,0,2,2,0,0,1,2,0,0,0,2,0,2,0,2,0,0,1,0,0,1,0,2,0,2,1,1,0,0,0,1,1,0,0,2,0,0,2,2,1,1,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,2,2,0,0,0,2,1,0,7,1,0,1,0,0,0,0,2,13,13,13,13,13,13,0,0,0,0,1,0,0,1,0,0,2,2,1,0,0,1,0,2,0,0,0,0,1,1,2,2,1,2,2,2,0,2,2,0,1,0,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,2,2,0,1,1,2,0,2,0,0,2,1,0,0,0,2,1,0,2,0,2,0,0,2,0,0,0,2,2,2,2,2,2,2,2,2,2,0,1,0,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,2,2,1,1,2,0,0,2,2,0,1,1,0,0,2,0,2,0,2,0,0,0,0,0,2,2,0,1,1,2,0,0,0,2,0,1,1,1,1,1,1,2,0,0,0,0,2,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,1,1,0,1,0,0,1,1,0,2,1,0,0,0,0,1,0,2,0,2,0,0,0,0,2,2,0,0,0,2,2,2,1,0,0,0,0,0,2,1,0,1,0,0,0,0,0,0,2,2,0,2,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,0,1,0,0,2,1,1,7,7,2,1,0,13,13,13,13,13,13,13,13,13,13,13,18,2,0,0,0,1,2,0,1,0,0,2,2,0,7,7,1,0,1,0,0,0,1,0,0,0,2,1,2,1,1,0,0,2,0,2,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,2,0,0,0,2,2,0,1,2,1,2,2,1,2,0,0,0,0,2,0,1,2,0,0,2,0,2,2,2,2,2,2,2,2,2,2,1,0,0,2,0,0,2,1,0,0,0,0,2,0,2,2,1,2,0,0,1,0,2,0,2,0,1,1,1,1,0,2,0,0,2,1,2,2,0,1,0,0,2,2,0,2,2,2,0,2,0,0,1,0,1,1,1,1,1,1,1,1,0,1,1,1,1,2,1,1,1,1,1,1,1,0,0,1,0,1,0,1,2,0,2,0,2,0,1,1,1,0,1,2,0,2,2,0,2,2,0,0,0,0,2,0,0,0,1,2,1,2,0,2,2,0,1,0,1,2,1,0,0,1,0,0,2,0,1,2,0,0,0,2,0,0,0,0,0,0,2,2,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,1,0,1,1,0,0,0,2,1,2,0,2,0,13,13,13,13,13,13,2,13,13,13,1,1,0,1,0,0,1,1,1,0,2,0,2,0,7,7,7,0,0,0,0,2,1,2,2,0,2,0,0,0,2,1,0,0,0,0,0,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,0,1,13,13,2,0,0,2,2,0,1,1,2,0,0,2,2,0,0,2,2,2,1,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,0,1,0,0,0,1,2,2,0,0,1,1,0,1,0,0,0,2,1,0,2,1,1,1,1,1,1,2,2,0,2,1,2,1,2,0,1,0,0,2,0,1,2,2,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,1,0,0,1,1,1,1,1,1,1,1,1,0,2,1,1,0,2,2,0,1,1,0,2,1,1,1,0,0,0,1,0,1,2,0,0,2,2,2,1,1,0,1,2,0,0,1,1,2,0,0,0,0,1,1,2,2,1,2,2,2,0,2,1,0,0,0,1,1,0,0,0,1,2,2,1,0,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,0,0,2,2,0,2,1,0,1,0,13,13,13,13,13,13,13,0,0,0,1,1,13,13,2,0,1,0,1,1,1,1,1,1,1,0,1,7,7,7,7,7,7,0,0,0,2,2,0,0,0,0,2,2,2,1,1,2,1,13,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,13,13,13,13,1,1,1,0,0,0,0,1,1,0,0,2,0,0,0,1,0,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,2,1,2,1,0,0,1,0,2,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,0,2,0,2,2,0,0,0,1,0,1,2,2,0,1,2,0,2,0,1,1,1,1,1,1,1,1,1,1,1,2,1,0,0,1,1,1,1,1,2,0,0,2,0,0,2,0,0,0,0,0,2,0,0,0,1,1,0,0,2,2,1,0,0,0,1,1,2,1,2,0,0,0,0,2,0,2,0,2,0,0,0,1,2,2,0,0,0,2,1,2,1,0,0,1,2,1,1,1,0,2,0,0,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,0,2,0,0,1,2,1,13,13,13,13,13,13,13,13,13,2,13,13,13,2,13,13,0,1,0,1,1,1,1,1,1,1,1,0,1,0,0,7,7,7,7,0,0,1,0,0,0,0,0,1,0,0,0,2,0,2,1,0,13,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,1,13,13,13,2,0,2,0,0,2,2,2,0,2,2,0,2,0,2,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,2,0,1,2,0,2,0,1,2,1,0,0,1,0,1,1,0,0,1,1,1,1,1,1,1,1,1,0,0,0,7,7,7,7,7,0,2,0,2,2,1,1,1,0,0,2,0,0,1,0,1,1,1,1,1,1,1,1,1,0,1,2,2,0,0,1,1,1,0,0,0,1,0,0,2,1,1,1,1,2,2,0,2,0,1,2,0,2,0,0,2,0,1,1,0,2,0,1,1,0,0,0,2,1,1,0,0,0,0,1,0,1,1,0,1,0,1,2,2,0,2,1,2,2,1,0,1,0,2,2,0,1,0,2,1,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,2,2,0,2,0,1,0,1,13,13,0,1,1,1,20,2,0,2,13,13,13,0,0,0,0,2,0,1,1,1,1,1,1,1,0,2,0,0,0,7,7,7,7,2,0,0,0,0,0,1,2,1,2,1,1,0,2,1,0,2,0,13,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,13,13,13,2,2,0,0,2,0,0,1,2,0,1,1,1,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,1,0,1,1,1,0,1,1,2,2,0,1,0,1,1,1,1,1,1,1,1,1,1,0,0,0,7,7,7,7,7,0,0,2,0,2,2,2,2,2,0,2,2,0,0,2,1,1,1,1,1,1,1,1,1,2,2,2,0,0,0,0,0,0,0,1,0,1,2,2,0,0,0,2,0,2,0,2,0,0,1,2,1,1,2,2,1,1,1,2,0,0,2,0,2,2,0,0,0,0,2,1,0,2,0,0,0,2,0,0,0,2,0,0,0,0,1,1,1,2,0,2,0,2,1,0,0,2,2,1,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,2,0,2,2,1,2,0,0,0,0,2,0,0,1,1,1,1,1,0,1,1,0,1,0,2,1,1,1,1,1,1,1,2,0,2,0,2,2,0,0,1,2,0,0,0,0,2,1,0,2,2,0,1,0,0,0,0,1,1,13,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,13,0,0,1,2,2,0,1,2,2,0,2,0,0,2,0,2,1,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,2,2,0,0,0,0,2,0,0,1,2,0,2,0,1,1,1,1,1,1,1,1,1,1,1,1,2,1,2,7,7,0,2,1,1,0,0,0,2,1,2,0,0,1,2,0,2,2,1,1,0,1,1,1,1,1,1,1,0,0,2,0,1,0,0,1,2,0,2,0,2,2,0,2,0,0,0,2,1,1,1,0,0,0,0,1,0,2,0,2,2,2,1,1,1,2,1,0,2,0,0,1,1,0,0,0,1,0,2,1,0,1,0,0,1,0,1,0,2,1,2,2,2,0,1,2,0,0,1,0,0,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,0,0,1,2,1,0,0,0,0,2,1,0,2,1,2,0,1,1,0,0,0,2,0,0,2,1,2,0,1,1,1,1,1,1,1,1,2,0,0,0,1,2,2,2,1,2,2,0,2,0,2,2,1,0,2,0,1,0,0,1,2,0,0,13,13,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,0,0,1,2,1,0,2,1,0,0,0,0,0,0,0,1,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,7,7,7,0,0,0,2,0,1,2,0,2,1,2,1,1,1,1,1,1,1,1,1,1,1,2,1,0,0,2,0,1,1,0,0,1,2,0,0,2,1,0,2,0,0,2,2,0,0,1,1,1,1,1,1,0,0,0,1,2,0,2,0,0,0,2,1,1,0,0,2,0,1,0,1,1,0,2,2,2,0,0,0,2,1,2,2,2,1,0,2,1,1,2,0,0,1,0,0,0,2,2,0,2,1,0,0,0,0,1,2,2,1,0,0,0,1,0,0,2,1,1,2,1,0,2,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,1,0,2,0,0,0,0,0,0,1,1,0,2,2,0,7,2,0,1,2,0,1,0,0,13,13,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,2,1,2,0,0,0,2,1,2,2,2,0,0,0,2,1,1,2,0,0,0,2,0,0,13,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,2,2,0,2,0,2,1,2,0,1,1,0,0,0,0,0,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,1,0,7,7,7,7,0,0,0,0,2,2,1,1,2,0,1,2,1,1,1,1,1,1,1,1,1,1,0,0,2,2,1,2,0,2,0,2,2,1,0,2,2,2,0,1,0,0,0,0,0,0,1,1,1,1,1,0,0,2,2,1,1,1,2,2,0,0,2,1,2,0,0,0,1,0,0,0,1,1,0,0,0,1,1,0,0,2,1,0,0,0,1,1,0,2,2,0,0,0,1,0,0,0,0,1,0,0,1,2,0,2,0,0,0,0,0,0,0,0,0,2,0,0,2,2,0,0,1,0,0,1,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,1,0,0,2,1,0,2,1,0,0,1,0,1,0,1,1,1,0,0,0,1,0,0,13,13,13,1,2,2,0,2,0,1,1,1,1,1,1,1,1,0,2,2,0,0,2,2,2,0,0,1,0,1,0,1,1,0,1,1,2,1,0,1,1,0,0,0,14,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,0,0,1,0,0,1,0,0,2,0,0,0,0,1,1,0,1,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,2,2,0,1,0,7,7,7,0,0,0,0,0,0,0,1,0,1,1,1,0,0,1,1,1,1,1,0,0,0,1,1,0,0,0,2,1,2,1,0,2,0,1,1,0,1,0,0,0,1,1,0,0,2,1,2,0,1,2,0,1,0,1,0,0,0,1,0,2,2,1,0,1,1,0,0,1,2,2,2,1,1,0,1,1,1,2,1,0,0,1,0,0,0,2,2,2,0,2,0,0,2,0,2,2,0,1,2,0,1,0,1,1,1,0,0,0,2,0,0,2,0,0,2,0,1,1,0,2,0,1,0,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,0,0,0,1,0,2,1,0,2,2,1,2,2,0,1,13,13,1,0,0,0,0,1,13,13,13,13,1,0,0,0,2,1,1,1,1,1,1,1,1,0,0,1,0,2,1,0,2,2,2,0,0,1,0,0,1,0,1,0,1,0,0,0,2,1,1,1,1,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,2,1,0,2,0,0,0,2,0,0,0,1,0,1,0,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,1,0,2,1,0,0,2,2,0,2,1,0,2,0,1,0,0,0,2,0,0,2,0,2,0,2,0,2,2,2,0,1,1,0,2,1,2,2,1,0,0,2,2,0,0,1,2,0,2,0,0,0,0,1,0,0,1,0,0,0,0,2,2,1,2,0,0,2,0,0,0,1,0,0,0,0,0,2,1,2,1,2,1,1,2,0,0,2,1,0,2,1,1,0,1,0,0,0,2,2,2,0,1,0,2,0,2,2,0,1,0,0,0,2,1,2,0,2,0,0,1,0,1,1,2,2,1,1,2,1,2,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,1,2,2,2,0,0,2,1,2,0,2,0,2,0,13,13,13,13,0,0,2,2,1,0,13,13,13,1,0,1,1,0,1,0,0,1,1,1,1,1,1,1,2,0,1,1,0,0,2,1,0,1,0,0,0,0,2,0,0,0,0,2,0,0,2,2,1,0,0,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,0,0,1,2,1,0,0,1,0,1,2,1,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,2,2,0,1,1,0,0,1,0,2,2,2,2,0,1,1,0,0,1,0,1,0,0,0,2,0,2,1,1,0,1,0,1,0,0,1,2,2,0,0,0,1,0,0,0,0,0,0,0,1,0,0,2,0,1,1,0,2,2,0,0,0,2,2,2,0,1,2,0,2,1,1,1,0,0,1,1,1,2,0,2,0,0,1,0,0,1,0,1,0,2,1,2,2,0,2,0,2,1,0,1,0,0,1,0,1,0,2,0,1,2,2,0,1,2,0,1,0,0,0,1,0,0,0,0,1,1,1,2,0,0,2,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,1,2,0,0,0,2,2,0,1,13,13,13,13,13,13,13,13,13,1,0,0,0,0,13,13,13,2,0,2,0,0,2,0,1,0,1,1,1,1,1,1,1,2,2,2,0,1,2,0,0,2,0,0,1,2,0,2,7,7,7,0,2,1,0,0,0,0,1,1,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,1,0,0,0,2,0,2,0,0,2,1,0,0,0,2,1,2,2,2,2,2,2,2,2,2,2,0,2,0,0,0,1,0,0,0,0,0,1,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,2,0,2,1,1,2,0,1,0,0,0,0,2,0,1,0,2,0,0,1,0,0,0,1,0,0,0,0,2,0,1,0,2,0,0,0,1,0,1,0,0,0,0,0,0,1,0,1,0,1,0,2,0,0,0,0,1,0,0,0,2,0,0,2,2,1,2,1,0,0,2,1,1,0,0,2,1,1,0,1,1,2,0,0,0,0,1,0,0,2,0,0,1,1,1,0,2,0,0,0,0,1,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,1,0,1,0,0,0,0,0,2,0,2,13,13,13,13,13,13,13,0,0,0,1,1,1,0,13,13,0,0,0,1,0,1,2,0,0,1,1,1,1,1,1,1,1,1,2,0,0,0,0,2,2,0,0,1,0,0,0,7,7,7,7,7,7,2,0,1,0,2,0,1,2,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,2,0,0,0,1,13,1,2,1,2,2,1,0,1,0,2,2,2,2,2,2,2,2,0,0,0,0,0,2,1,0,2,1,0,2,1,0,0,1,0,0,0,0,0,1,1,0,0,2,1,0,0,0,0,2,0,0,1,0,0,0,0,0,2,1,1,1,1,0,0,0,2,2,1,0,1,2,2,2,1,0,0,1,1,0,0,0,1,0,0,0,0,2,1,1,1,0,0,1,0,0,1,1,0,0,0,0,1,0,2,0,0,0,2,0,1,2,2,0,1,0,1,0,1,0,0,1,2,0,0,1,2,0,1,1,0,0,2,0,0,0,1,0,1,2,0,2,0,2,0,2,0,1,1,0,0,2,0,2,1,0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,0,0,1,1,0,2,1,1,1,1,1,13,13,13,13,13,13,1,0,1,0,0,2,0,0,0,0,0,0,0,1,0,1,1,2,0,1,1,1,1,1,1,1,1,1,2,0,1,0,2,2,1,0,0,2,0,0,0,7,7,7,7,7,7,0,0,0,0,0,0,0,0,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,0,2,13,13,13,13,0,1,1,1,1,0,0,2,2,2,2,2,2,0,0,0,1,2,0,0,1,2,2,1,1,0,0,2,0,0,2,1,1,0,0,1,0,2,2,2,2,2,2,2,1,0,1,0,1,2,1,0,0,0,0,0,1,1,0,0,0,2,0,0,0,1,1,0,0,0,2,2,0,1,1,2,1,0,0,2,0,1,1,1,2,1,1,1,2,2,0,2,1,0,1,0,0,0,0,0,2,2,0,0,1,1,2,0,1,0,2,1,0,0,0,2,0,0,2,0,1,2,0,0,0,2,0,1,1,2,2,0,0,0,0,0,2,0,0,0,0,0,2,2,1,0,1,0,2,2,3,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,1,0,0,1,2,2,2,2,0,0,1,0,2,13,13,13,13,13,13,0,0,0,0,2,0,1,0,2,2,0,0,1,2,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,2,1,0,0,0,0,0,2,1,0,2,0,2,0,2,0,0,0,0,0,1,0,2,0,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,0,0,13,13,13,13,0,1,0,1,0,2,2,0,2,0,2,2,2,2,0,2,1,2,2,2,0,0,0,0,0,2,1,0,1,0,0,1,0,1,0,2,0,1,0,1,0,1,0,1,1,2,2,2,0,1,2,0,1,0,0,2,0,1,0,0,0,1,0,0,1,1,0,1,0,1,2,2,2,0,0,2,0,0,0,0,1,0,2,0,2,0,0,1,0,0,2,1,2,1,0,2,1,0,1,0,0,0,1,0,2,2,2,2,0,0,0,0,0,0,1,1,1,0,0,1,2,2,2,2,0,0,0,2,2,1,2,0,0,2,0,0,0,0,1,0,0,0,1,1,1,1,0,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,1,0,1,2,1,0,0,0,2,7,2,2,13,13,13,13,13,13,0,0,0,2,2,2,0,2,2,0,0,2,2,1,1,0,2,1,1,1,1,1,1,1,1,1,1,1,1,2,0,1,0,1,0,0,0,1,0,1,1,1,1,0,0,0,0,0,2,0,1,1,0,0,1,0,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,1,13,13,13,13,1,1,0,2,1,1,2,1,0,0,0,0,0,2,2,2,1,2,1,0,0,0,1,0,2,0,1,1,0,1,0,0,2,1,0,0,0,2,2,1,0,2,0,0,0,1,1,0,0,1,0,2,0,0,2,0,0,1,0,2,0,0,2,0,0,0,1,0,0,2,2,0,2,0,1,2,2,0,1,1,0,1,0,0,0,1,2,2,2,1,0,0,0,1,0,0,0,2,2,2,2,0,2,0,0,2,2,1,1,1,0,0,1,2,1,0,0,0,0,1,1,0,0,1,1,1,1,2,0,0,1,0,1,0,1,2,2,2,2,1,2,0,0,0,2,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,2,0,0,1,0,0,2,0,0,0,1,7,1,0,2,13,13,13,13,13,13,13,13,13,2,1,2,1,0,0,1,0,0,2,2,2,0,0,1,1,1,1,1,1,1,1,1,1,1,2,0,1,0,0,2,2,0,2,1,1,1,1,1,1,0,0,0,0,1,0,0,1,0,2,0,13,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,0,13,13,13,13,2,2,2,2,0,0,0,1,2,0,0,0,2,0,1,0,0,1,0,2,2,0,2,2,0,0,2,0,2,0,0,0,0,1,0,0,0,2,1,2,0,0,1,0,0,0,0,0,0,0,2,2,2,0,0,1,1,0,1,0,0,2,0,0,0,0,0,0,0,1,2,0,0,0,0,0,0,0,0,1,2,0,1,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,2,1,0,2,1,0,2,1,0,0,0,2,0,1,2,0,2,0,0,0,1,2,2,0,2,1,0,1,2,0,0,2,2,0,0,0,0,0,0,1,2,0,1,0,0,2,2,0,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,1,0,2,0,1,0,1,0,2,2,2,0,0,7,7,0,1,13,13,13,13,13,13,13,13,13,0,0,1,0,0,0,1,0,1,0,0,2,0,0,1,1,1,1,1,1,1,1,1,1,1,2,1,2,0,0,2,0,0,1,1,1,1,1,1,1,1,1,2,0,1,1,0,0,0,0,2,13,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,13,13,13,13,13,1,2,0,0,1,0,0,0,2,0,0,1,2,1,0,1,0,0,2,0,0,2,2,0,1,0,0,0,0,0,2,0,2,0,0,2,2,0,2,0,0,0,0,1,2,2,0,2,0,0,0,0,2,2,2,0,0,0,1,1,0,1,1,2,0,0,1,2,1,1,0,0,0,2,1,0,2,1,0,1,2,1,1,1,1,2,1,0,1,1,0,2,0,1,1,1,0,2,1,0,2,0,0,2,0,0,0,0,2,7,7,7,0,0,0,0,0,1,2,0,0,0,0,1,2,0,0,2,2,2,1,1,1,0,1,1,0,1,0,0,1,2,1,2,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,0,0,0,0,2,0,0,2,0,0,1,0,0,0,2,2,0,13,13,13,13,13,13,13,13,0,0,1,0,0,2,1,0,1,0,0,2,1,2,2,2,1,2,1,1,1,1,1,1,1,1,1,1,0,0,2,0,0,1,2,1,1,1,1,1,1,1,1,1,2,0,0,1,1,2,2,2,1,2,13,13,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,2,13,13,13,13,13,0,0,0,2,2,0,1,2,0,0,2,2,1,0,0,0,0,0,1,1,0,0,0,2,0,0,2,2,0,0,1,2,2,2,1,0,1,2,2,0,0,0,2,0,2,1,1,0,2,0,0,1,1,2,1,1,1,1,2,1,0,1,1,1,0,1,1,1,0,1,1,2,1,1,2,1,1,0,0,1,1,1,0,0,2,2,1,0,1,0,0,2,2,2,0,0,0,2,2,0,0,0,1,0,0,0,0,1,7,7,7,2,1,1,1,2,0,0,2,1,0,1,2,2,0,1,1,0,0,1,0,0,1,2,0,0,1,0,1,1,0,1,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,0,2,1,1,1,0,2,1,2,2,2,0,0,2,2,0,2,0,13,13,13,13,13,13,13,13,0,1,0,1,0,2,0,2,1,0,0,2,0,1,2,0,0,1,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,2,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,0,13,13,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,13,13,13,13,13,13,0,13,2,1,0,1,0,0,1,2,0,2,1,1,0,1,1,1,0,1,2,0,0,1,0,1,0,0,1,0,0,0,0,0,0,2,0,1,2,0,2,2,1,1,0,0,0,0,0,1,0,0,2,0,2,2,1,0,0,0,0,1,0,1,0,0,0,0,0,2,0,0,2,0,2,0,1,2,0,0,0,2,2,0,0,0,2,0,1,0,0,2,0,0,2,1,2,0,0,0,1,0,2,0,2,0,7,7,7,0,2,1,0,2,1,0,0,0,0,1,1,2,0,0,2,1,1,2,1,0,0,0,0,0,1,0,2,0,0,0,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,1,1,0,1,0,0,2,1,0,1,1,1,0,0,1,0,0,2,0,2,0,13,13,13,13,13,13,17,1,0,2,1,0,1,1,0,0,0,2,1,0,0,0,0,0,2,1,1,0,2,1,1,1,1,1,1,1,1,0,0,0,2,0,0,2,0,1,1,1,1,1,1,1,1,1,0,2,1,1,0,0,1,1,0,13,13,13,13,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,13,13,13,13,14,13,13,13,0,1,1,0,0,0,0,1,0,0,1,1,0,0,1,0,0,2,2,0,2,0,0,2,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,2,0,1,0,0,2,0,1,0,1,2,0,2,2,2,0,0,0,1,1,0,1,1,1,1,1,1,0,0,0,0,2,2,0,2,2,1,0,2,2,2,2,0,0,0,0,2,2,1,1,0,0,1,0,0,2,0,0,2,2,0,0,1,7,7,7,7,2,0,0,2,0,2,1,2,1,1,0,1,0,1,0,2,0,2,0,1,0,0,2,2,0,0,2,1,0,2,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,0,1,2,0,0,0,0,1,1,2,0,2,1,1,0,2,0,2,0,1,0,1,13,13,13,0,0,0,0,1,2,1,1,2,1,0,0,1,2,0,1,0,2,1,0,0,2,1,0,0,0,0,2,1,1,1,1,1,1,1,0,2,0,2,0,2,2,1,0,1,1,1,1,1,1,1,1,0,1,0,1,0,2,2,0,0,1,13,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,13,13,13,13,0,1,0,0,1,1,0,0,0,0,0,2,0,0,0,0,0,1,1,0,2,0,0,2,0,0,0,0,2,1,0,2,0,1,0,2,2,0,2,0,2,0,0,0,2,2,0,1,1,0,0,2,0,2,1,2,0,0,0,0,2,0,2,2,0,0,0,0,2,0,1,2,1,0,0,1,1,0,0,0,0,0,0,0,2,1,0,0,1,0,0,0,1,2,2,0,0,1,0,0,2,7,7,7,7,2,1,1,0,0,0,1,0,0,2,0,2,0,0,0,0,0,0,0,0,1,2,2,0,0,2,2,0,1,0,0,0,15,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,1,2,0,1,0,2,0,0,1,1,1,0,2,0,0,1,0,2,2,0,1,13,13,13,13,13,0,0,1,0,0,1,0,2,0,1,0,0,0,1,2,0,1,0,0,0,2,0,2,0,1,2,0,1,1,1,1,1,1,1,1,1,0,0,0,2,0,0,2,0,0,1,1,1,1,1,1,1,1,0,2,0,1,1,1,1,0,0,1,2,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,13,13,13,13,0,2,2,0,0,2,2,2,1,0,1,0,0,2,0,2,0,2,1,0,0,1,0,0,0,0,2,2,0,1,0,0,1,0,0,1,1,0,2,2,0,0,0,0,0,0,0,0,2,2,1,0,0,1,1,1,0,0,2,0,1,2,1,2,1,1,2,1,0,0,0,1,0,0,2,0,0,0,0,0,0,0,0,0,1,0,0,1,1,2,2,0,0,0,1,0,2,0,1,2,7,7,2,2,2,0,0,0,1,0,2,1,0,0,0,1,0,0,2,1,1,0,0,2,0,0,2,0,1,0,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,2,2,2,0,0,1,2,1,0,2,1,0,1,2,1,2,1,1,1,7,13,13,13,13,13,13,13,13,1,1,0,0,2,1,2,0,1,2,0,0,0,2,0,0,1,0,0,2,0,0,0,0,1,2,0,0,1,1,1,1,1,1,1,2,2,0,0,1,0,0,0,0,2,1,1,1,1,1,1,1,1,1,0,2,1,1,1,2,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,13,13,13,2,2,2,2,0,2,0,1,0,0,2,2,0,0,0,0,2,0,0,2,1,1,1,1,1,1,1,2,0,0,0,1,0,1,1,0,1,1,0,0,0,1,0,1,0,0,0,0,1,0,1,0,1,0,0,2,2,0,0,2,1,0,0,1,0,0,0,0,0,1,0,2,2,1,2,1,0,0,2,0,1,2,0,0,1,0,1,0,0,0,2,2,2,1,0,0,0,2,2,0,0,2,0,1,2,0,0,2,2,2,0,1,0,0,1,0,1,0,1,2,1,0,0,0,1,1,1,0,0,0,0,0,1,3,3,3,3,3,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,1,2,0,0,0,0,0,0,0,0,0,1,0,1,2,1,0,0,0,13,13,13,13,1,13,13,2,2,2,0,2,0,1,1,0,2,0,0,0,0,0,2,2,0,0,2,2,1,0,2,0,0,2,2,1,0,1,1,1,1,1,1,1,0,2,0,1,2,1,0,1,0,0,0,1,1,1,1,1,1,1,1,1,0,2,1,0,1,2,1,15,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,13,13,13,1,0,2,0,0,0,0,2,0,0,0,1,0,0,2,0,1,2,0,0,0,0,0,1,0,0,2,2,0,0,0,2,0,0,0,0,0,1,2,0,1,0,0,0,2,2,1,0,0,0,0,1,0,2,2,0,0,2,1,0,2,0,0,0,1,0,1,2,0,0,2,1,0,0,0,2,0,1,2,0,1,0,2,2,1,2,1,1,2,1,0,0,0,0,0,2,1,0,1,0,2,0,1,0,2,1,1,0,2,1,1,0,0,1,1,2,2,0,2,0,2,0,0,0,0,2,0,1,0,0,0,1,0,3,3,0,1,0,2,2,2,2,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,0,2,0,1,1,1,2,1,1,0,1,2,0,0,1,2,0,0,1,13,13,13,13,1,2,1,1,1,0,0,1,0,0,1,0,1,0,1,2,0,1,0,1,1,2,2,1,0,1,1,1,0,0,0,2,2,2,0,1,1,1,1,1,0,0,2,0,2,0,2,7,7,0,1,0,0,1,1,1,1,1,1,1,1,0,2,0,2,2,0,2,2,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,13,13,13,13,13,0,0,2,1,0,2,0,0,1,1,0,0,1,1,2,1,0,2,0,1,1,0,1,2,0,0,0,0,0,1,0,0,2,0,0,0,1,0,0,2,1,1,1,2,0,1,0,0,0,1,0,2,2,0,0,2,1,0,0,1,0,0,1,2,0,2,2,0,0,0,0,0,0,0,0,1,0,1,0,2,2,0,1,1,0,0,2,2,0,0,0,1,0,0,2,0,2,0,0,2,0,0,2,0,0,1,0,1,2,1,2,0,0,0,2,2,0,1,0,1,2,2,0,0,0,0,0,0,0,2,2,0,1,0,1,0,1,1,0,2,1,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,1,0,0,1,1,1,1,0,0,0,0,0,0,0,1,0,0,0,13,13,13,13,0,0,0,0,2,2,1,1,0,0,0,1,2,0,2,2,2,1,1,2,2,2,2,1,1,0,0,0,0,0,2,1,0,1,1,0,0,0,1,1,1,1,0,0,0,2,0,0,0,7,7,2,2,2,0,0,1,1,1,1,1,1,1,2,0,0,1,0,0,2,1,0,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,13,13,13,13,13,0,2,0,1,0,0,2,0,0,0,1,2,0,2,0,0,2,1,1,0,0,0,0,1,0,0,2,1,1,1,0,0,2,0,2,0,2,2,1,1,1,1,1,2,1,0,0,0,0,2,0,0,0,2,0,1,1,2,2,2,0,1,2,7,7,0,0,0,0,1,0,1,0,2,0,0,1,0,2,2,0,0,1,2,0,0,0,1,2,1,2,0,2,0,2,0,1,1,1,0,1,1,2,2,0,2,0,0,0,1,0,0,1,2,0,2,2,0,0,1,0,0,0,0,2,1,1,2,1,0,1,1,0,0,0,0,0,0,2,1,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,0,1,0,0,2,2,0,1,0,0,2,1,1,0,0,1,0,0,1,13,13,13,2,0,2,2,2,2,0,0,0,0,0,2,1,2,0,2,2,0,0,0,2,0,1,0,2,0,1,2,2,0,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,1,2,0,2,2,7,7,1,0,2,1,0,2,1,1,1,1,1,0,2,0,1,0,0,1,2,2,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,13,13,13,13,13,1,1,0,0,0,1,0,0,2,1,1,1,1,1,0,1,0,1,0,2,0,2,0,2,0,1,0,0,2,2,0,2,0,1,0,2,1,1,1,1,1,1,1,0,0,1,2,0,1,1,2,0,2,0,2,2,1,1,1,0,0,0,7,7,0,2,1,0,0,0,2,1,2,0,0,2,0,2,0,1,0,1,2,0,1,1,0,2,1,0,0,0,1,1,0,0,0,1,0,1,1,0,2,0,2,0,0,1,0,1,1,2,1,0,1,0,0,2,2,0,0,0,2,0,1,0,1,1,1,0,0,1,1,0,0,0,1,0,0,0,0,1,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,2,0,2,0,2,2,0,0,1,1,1,0,0,2,0,1,1,0,13,13,0,0,0,1,0,1,2,0,1,1,0,0,0,1,2,0,2,0,2,2,1,1,0,2,2,0,0,0,2,1,1,0,1,2,2,2,0,0,0,2,0,0,0,0,0,1,2,0,0,0,0,1,7,7,1,0,1,0,0,2,2,1,1,1,2,2,1,0,0,0,0,0,0,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,13,13,13,1,0,2,0,0,0,2,0,0,1,2,1,1,0,0,1,1,0,2,2,2,0,2,0,0,0,2,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,2,0,0,2,1,1,1,1,0,2,0,7,7,0,0,1,2,0,0,2,2,2,1,2,0,1,1,2,1,2,2,2,1,0,1,1,1,0,0,0,1,0,0,2,0,0,0,2,0,1,2,0,0,0,1,0,2,0,1,0,0,1,0,0,0,1,1,1,1,0,2,1,0,1,2,1,0,1,0,1,0,0,2,0,0,1,0,1,0,1,1,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,0,2,2,1,1,1,0,0,0,2,1,0,2,1,13,13,2,13,13,2,0,1,1,0,1,0,1,0,1,0,0,1,0,1,2,1,0,2,0,0,2,0,2,0,0,1,0,1,2,0,0,2,2,0,0,2,0,0,0,0,1,0,0,2,1,0,0,0,1,0,0,0,2,0,1,0,2,0,0,2,2,0,2,0,2,0,1,2,0,2,1,0,1,1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,13,13,13,13,0,0,0,2,0,0,0,0,2,2,0,2,1,0,1,0,0,2,2,2,0,1,2,2,0,0,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,2,1,0,2,0,2,0,0,0,0,0,0,7,7,7,7,7,0,0,0,0,0,0,1,1,0,2,0,0,2,0,2,0,0,2,0,2,1,0,0,2,2,0,1,1,2,2,1,0,0,1,1,0,0,2,0,1,0,0,0,0,1,0,0,0,1,1,1,2,2,2,1,1,0,0,2,10,0,0,1,0,1,2,2,1,1,0,0,0,0,0,2,0,2,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,1,0,0,2,0,0,0,0,2,0,0,13,13,13,13,2,2,2,2,0,2,0,1,0,0,1,0,0,0,0,1,0,2,0,1,0,0,2,0,0,2,1,0,2,0,2,0,2,0,2,2,1,2,2,0,0,2,1,0,0,0,0,0,1,0,0,1,0,2,2,0,0,0,0,0,0,0,2,0,0,1,0,2,0,2,1,2,0,1,2,0,1,1,0,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,13,13,13,13,13,0,0,1,2,0,0,0,0,0,0,2,1,0,1,0,0,0,1,0,0,1,1,2,2,0,0,2,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,2,0,2,1,2,1,2,1,1,7,7,7,7,7,0,0,2,0,0,0,0,0,1,1,1,2,1,1,2,0,2,0,2,1,0,0,1,0,0,0,0,0,1,1,0,1,1,0,2,2,0,0,2,0,1,0,0,0,2,2,0,0,0,2,2,0,0,0,2,1,0,0,10,10,1,1,1,1,0,1,0,1,0,0,0,0,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,13,13,2,0,2,0,0,1,2,0,1,0,13,13,13,13,2,0,0,2,0,0,2,1,2,2,2,1,2,2,0,1,0,1,1,1,1,1,1,1,2,0,0,0,2,0,0,1,1,0,0,2,0,1,2,0,0,2,0,0,0,0,0,0,0,1,0,0,1,1,0,0,1,1,2,0,0,0,2,0,1,0,0,1,2,2,0,1,0,0,1,0,0,1,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,13,13,1,0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,2,0,0,0,0,0,2,1,1,1,1,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,1,1,0,0,1,0,1,2,1,0,1,1,0,1,1,0,0,2,2,0,1,0,2,0,2,0,2,0,1,1,1,0,2,0,2,0,1,2,1,0,0,1,1,0,1,2,2,0,1,0,0,2,0,0,0,2,2,1,1,0,2,2,0,1,1,1,0,2,0,0,0,0,0,1,0,1,0,10,10,10,1,1,0,2,1,0,2,0,0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,13,13,2,2,0,1,0,0,0,1,2,0,0,1,2,0,1,0,0,2,0,2,0,0,0,0,2,0,2,0,2,1,1,1,1,1,1,1,1,0,0,0,2,1,1,1,1,1,1,2,0,1,1,0,0,0,2,0,2,0,2,1,2,0,2,0,0,2,1,2,1,0,1,2,1,2,0,0,1,2,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,13,13,13,13,13,2,2,2,1,0,0,0,1,1,0,2,1,1,2,1,0,1,0,1,0,0,2,1,2,1,1,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,2,0,0,0,1,1,2,2,2,0,0,0,1,1,0,1,2,1,0,0,0,0,0,1,0,2,0,0,0,0,2,0,0,2,1,0,0,0,0,0,2,1,2,0,0,0,0,0,0,0,0,0,2,0,0,0,1,1,2,2,0,1,1,0,2,2,2,2,0,2,1,0,0,1,0,10,10,10,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,13,13,0,0,0,2,0,0,0,2,0,1,0,0,2,0,0,2,1,2,2,2,0,1,0,1,0,1,0,0,2,2,2,1,1,1,1,1,1,1,1,1,2,0,1,1,1,1,1,2,0,2,1,1,0,0,1,1,2,2,0,2,2,1,2,2,0,1,2,0,7,7,0,1,0,2,1,0,0,0,0,0,1,2,2,0,0,1,2,0,0,0,2,2,0,0,0,0,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,13,13,13,13,0,0,0,0,0,1,1,0,1,2,1,0,0,2,1,2,1,0,1,1,2,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,0,0,0,0,1,0,0,1,0,2,0,0,0,0,0,1,2,0,0,0,1,1,0,0,1,1,0,1,1,1,2,0,1,0,2,0,1,0,1,0,1,0,1,1,1,2,2,0,2,0,0,0,0,2,2,0,1,0,1,0,0,0,0,1,0,1,2,0,2,1,1,0,0,0,1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,13,13,2,0,1,0,2,0,1,0,1,2,0,0,2,0,0,0,2,0,0,0,0,2,2,0,1,1,0,1,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,0,2,0,1,1,0,0,0,2,2,1,1,0,0,1,0,7,7,7,7,7,7,0,2,0,2,0,0,0,1,1,0,1,0,2,2,1,1,2,2,0,0,0,1,0,0,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,13,13,13,13,0,0,0,0,0,0,1,0,1,2,0,0,0,1,0,0,2,2,2,2,2,2,2,0,0,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,0,2,2,2,2,1,0,2,0,0,0,0,1,0,0,2,2,2,0,2,0,0,0,2,0,2,1,0,0,1,1,1,0,0,0,1,0,0,2,1,0,0,0,1,0,1,1,1,1,2,1,0,0,0,1,1,1,1,1,1,2,0,0,2,1,0,0,0,0,0,0,0,1,2,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,0,0,0,2,2,0,2,0,0,0,2,7,0,0,0,1,0,2,0,2,1,10,1,1,0,0,0,0,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,1,0,1,0,1,0,0,1,1,2,0,0,0,0,0,1,7,7,7,7,7,7,2,2,0,2,0,0,0,0,1,2,1,0,2,0,0,0,2,0,1,1,0,1,0,0,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,13,13,13,2,1,0,1,0,1,0,2,2,1,1,2,0,2,2,1,0,2,2,2,2,2,1,1,0,0,2,2,0,1,0,0,0,0,0,0,1,1,0,2,0,2,1,0,2,1,1,0,0,0,1,2,0,0,0,2,2,0,1,0,0,0,0,2,2,2,0,2,0,0,0,2,0,1,1,1,1,1,0,0,2,1,2,0,1,1,2,1,0,0,0,0,1,1,1,0,0,0,0,1,0,0,2,0,1,1,1,0,0,1,0,2,0,0,1,0,1,0,0,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,1,2,0,0,0,2,0,1,0,0,7,0,2,0,2,0,0,1,1,10,10,10,0,1,0,1,0,1,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,2,2,0,0,0,0,0,2,2,2,1,2,2,7,7,1,1,0,0,0,7,7,7,0,0,0,2,2,2,2,0,1,0,1,1,0,2,0,1,0,1,2,0,2,0,0,2,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,13,0,1,2,0,0,2,2,0,2,0,1,0,1,1,0,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,0,1,0,2,1,0,1,0,2,0,0,0,1,0,1,0,0,0,0,2,1,0,1,0,2,0,1,0,2,2,1,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,1,0,2,0,1,1,0,0,0,1,1,0,2,2,0,2,0,2,0,2,1,0,1,0,0,0,0,0,0,0,0,2,1,2,0,2,0,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,13,13,1,0,0,1,0,0,0,2,2,0,0,7,7,1,1,1,1,0,1,2,2,0,0,1,2,1,0,0,0,2,2,2,2,2,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,2,0,2,2,2,0,0,0,1,1,0,0,7,7,7,0,0,2,0,0,7,7,0,0,0,0,2,2,2,0,1,2,2,2,1,0,2,0,0,0,0,0,2,2,2,1,13,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,13,13,13,13,0,0,0,0,2,2,2,1,2,2,1,0,2,0,0,2,2,2,2,2,2,2,2,2,2,2,1,0,0,2,1,0,0,2,2,2,1,0,2,0,2,1,1,0,1,0,2,2,1,1,2,1,2,2,2,0,2,0,1,2,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,0,2,0,1,2,0,0,2,1,2,2,0,2,0,0,0,0,1,2,1,0,2,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,13,13,13,2,2,0,1,2,1,0,0,0,0,0,0,7,1,0,2,1,2,2,1,0,1,1,0,2,0,0,1,2,2,0,2,0,2,0,2,2,1,1,1,1,2,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,2,0,1,0,7,7,7,2,0,2,1,0,0,0,0,0,0,0,1,0,1,0,0,0,1,0,2,0,0,0,2,1,0,0,0,1,0,1,1,13,13,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,13,13,13,1,1,2,0,1,2,1,0,1,0,0,2,1,2,1,2,2,2,2,2,2,2,2,2,2,2,2,0,0,2,0,0,1,0,2,2,0,1,0,0,0,2,0,1,0,2,1,0,1,0,0,0,2,2,2,1,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,1,1,0,2,2,1,0,0,0,0,1,2,0,0,0,0,2,0,2,0,0,0,0,0,0,0,1,0,0,1,1,0,1,1,2,0,0,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,0,13,13,2,0,0,0,1,1,1,0,0,2,1,1,0,0,1,0,0,0,0,0,1,0,0,0,0,1,2,2,0,0,2,1,1,0,2,0,0,0,1,1,0,2,2,0,1,1,1,1,1,0,0,1,0,0,3,3,2,0,2,0,0,2,0,1,7,7,0,1,0,0,1,1,1,0,0,0,0,2,0,2,0,0,1,0,2,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,1,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,13,13,0,2,0,2,1,1,2,2,1,1,0,2,1,0,0,1,2,2,2,2,2,2,2,2,2,2,0,0,2,0,1,1,2,0,2,0,0,2,0,1,1,1,1,0,0,1,1,0,1,2,2,1,0,0,1,0,1,0,0,2,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,2,0,1,2,0,0,1,0,0,1,2,1,1,1,0,0,0,2,2,0,1,2,2,1,0,0,1,2,2,0,1,1,0,2,0,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,13,13,2,0,0,2,0,0,0,1,0,0,0,2,2,1,0,0,0,0,0,0,2,1,1,2,0,0,0,0,1,0,0,2,0,7,7,7,1,0,2,0,1,2,2,0,1,2,1,1,1,2,0,1,2,2,2,3,3,3,0,2,0,2,1,2,0,0,1,0,1,0,0,2,2,1,2,1,2,0,2,0,1,1,0,0,0,0,0,0,1,2,2,1,2,0,0,2,1,1,0,1,1,0,2,13,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,0,1,1,0,0,0,0,0,0,0,0,0,1,0,0,0,2,2,2,2,2,2,2,2,2,2,2,1,2,1,2,2,0,1,2,2,0,0,0,0,0,2,0,1,2,2,2,0,0,0,0,1,0,2,0,0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,0,2,0,1,0,1,0,0,2,1,0,2,0,1,2,2,2,2,2,1,0,1,0,0,2,1,0,0,0,0,0,0,1,0,1,0,0,2,0,0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,13,13,0,1,1,0,0,1,0,2,2,0,0,0,0,1,0,1,1,0,1,2,0,0,2,0,2,0,0,10,10,10,2,1,0,7,7,1,2,2,2,2,2,1,0,1,0,1,0,0,2,2,0,1,0,0,0,3,3,3,3,3,0,1,1,0,1,1,1,1,0,0,0,2,1,1,2,0,0,0,1,1,0,1,0,0,0,0,2,0,0,0,2,0,0,2,0,0,0,0,0,2,0,0,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,13,0,2,0,0,1,0,0,0,2,10,0,0,1,0,1,2,0,2,2,2,2,2,2,2,2,2,1,0,0,0,0,2,0,0,1,0,1,1,2,1,2,1,0,0,2,0,2,0,2,2,2,2,0,0,2,1,2,0,0,0,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,1,0,1,0,2,2,2,2,0,2,2,2,2,1,0,0,0,1,0,2,2,0,1,2,0,1,2,0,2,0,0,0,2,1,0,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,13,13,13,13,0,0,0,2,2,0,0,0,2,2,1,0,1,0,0,2,0,1,0,1,0,0,0,1,2,0,0,10,0,10,10,1,7,7,7,0,0,0,2,2,0,0,0,0,1,0,21,21,2,0,0,2,1,0,0,3,3,3,3,3,3,3,3,0,2,1,0,0,0,0,2,2,0,0,0,2,1,0,0,1,0,1,2,0,0,0,1,1,1,1,0,1,2,2,2,2,1,0,0,0,0,0,0,13,13,13,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,1,1,0,1,0,1,1,2,2,10,10,10,1,1,0,0,2,0,1,2,2,2,2,2,2,2,2,0,2,2,2,2,0,1,1,0,0,2,0,1,0,0,2,0,2,0,2,2,0,0,1,0,2,0,1,0,2,0,1,0,1,0,1,2,1,1,1,1,1,1,1,1,1,0,0,0,1,0,1,2,2,0,0,0,2,0,2,0,1,0,0,1,1,0,0,2,0,0,0,2,0,2,0,0,2,0,2,0,0,1,2,0,1,0,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,13,13,0,2,0,0,1,1,0,2,2,2,2,2,1,1,1,1,0,1,0,0,0,0,0,0,1,1,2,2,1,1,0,1,10,1,1,1,1,2,1,0,0,2,0,0,0,2,2,21,21,21,0,0,0,0,2,2,0,3,3,3,3,3,3,3,3,3,3,3,0,2,0,0,0,1,1,0,1,2,0,0,0,2,0,0,1,0,0,0,0,2,0,0,1,0,1,0,0,0,0,0,0,2,2,0,1,1,13,13,13,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,13,13,13,0,0,2,1,2,1,1,2,10,10,1,2,1,1,0,1,0,0,0,0,2,2,2,2,2,2,2,0,2,1,1,1,0,1,0,2,0,2,1,0,2,2,0,0,0,0,1,0,2,1,0,0,0,2,0,0,1,2,0,0,2,0,2,0,1,1,1,1,1,1,1,1,2,0,2,1,2,0,2,0,1,2,0,2,0,0,0,0,2,0,0,2,0,2,0,2,0,2,0,0,1,0,0,2,0,1,1,1,1,1,0,1,2,0,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,13,13,0,2,1,0,2,0,0,2,2,2,2,2,0,0,2,0,0,0,0,1,0,2,0,0,2,0,2,1,0,2,2,0,10,2,0,0,0,2,0,1,0,0,0,2,1,0,1,21,21,21,21,2,2,1,2,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,1,0,0,1,0,2,2,0,2,0,0,2,1,0,0,2,2,0,0,2,1,1,0,0,0,0,0,0,0,0,1,0,0,0,13,13,13,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,13,0,13,13,0,2,1,0,10,10,10,10,10,0,1,0,0,1,0,2,0,0,1,1,2,2,2,2,0,2,2,1,0,0,0,1,2,1,2,0,1,0,0,1,0,2,1,0,2,1,1,0,0,2,0,1,0,1,2,0,0,2,0,0,0,0,1,2,1,1,1,1,1,0,0,2,2,1,0,0,1,0,0,0,1,0,0,2,2,0,0,1,2,2,0,1,0,0,2,0,2,0,2,0,0,0,2,1,0,1,1,0,1,1,0,2,2,2,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,13,13,2,2,1,2,1,2,2,2,2,2,2,2,2,2,1,1,2,2,0,2,0,2,1,1,2,0,2,0,1,1,0,10,10,1,0,1,0,1,1,1,0,1,1,0,0,2,2,0,21,21,21,1,1,0,0,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,1,0,0,2,2,2,0,1,0,1,0,0,0,0,0,2,1,0,1,1,2,0,0,2,2,0,0,1,1,0,1,0,13,13,2,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,13,13,13,13,2,0,0,0,2,10,10,0,0,1,0,2,0,0,0,0,0,1,2,0,2,1,0,2,1,1,0,2,1,0,1,2,2,2,2,2,0,1,2,0,1,0,0,1,2,1,0,0,2,2,0,0,0,1,0,2,0,2,0,2,0,2,2,2,1,1,1,1,0,0,0,0,0,1,0,1,0,0,2,0,0,1,2,1,0,1,0,1,2,0,1,0,0,1,1,1,0,1,0,0,2,1,0,0,1,0,0,2,2,1,2,2,1,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,2,2,0,0,0,2,0,2,2,2,2,2,2,2,2,2,2,1,1,0,2,0,0,1,0,1,0,1,0,1,1,10,10,2,0,1,0,1,2,2,1,2,1,0,1,1,0,0,0,2,0,0,0,2,0,0,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,1,2,0,1,0,0,0,0,1,0,0,2,0,0,1,1,0,1,1,0,2,0,2,2,0,0,0,2,1,13,13,13,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,13,13,13,2,1,1,0,0,1,2,2,0,2,1,2,2,0,1,0,1,2,2,2,0,2,0,0,1,0,2,2,0,1,2,1,1,0,1,2,0,0,2,2,1,1,0,0,2,1,0,0,0,0,1,0,1,0,0,2,0,0,2,1,0,0,2,0,0,2,1,1,1,0,1,2,1,0,0,0,1,0,1,0,2,1,2,2,0,1,1,2,0,0,0,0,1,0,2,0,1,2,0,2,1,2,0,0,1,2,0,2,0,2,1,0,0,1,2,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,0,1,0,0,2,0,2,2,2,2,2,2,2,2,2,2,2,2,1,0,2,0,0,2,0,0,0,0,0,2,0,1,0,0,0,0,0,1,2,0,0,0,0,10,2,2,0,0,1,1,0,2,0,2,1,0,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,1,0,0,2,2,0,0,0,0,0,0,0,2,0,1,0,1,0,0,0,0,0,2,1,2,1,0,0,13,0,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,13,1,0,0,0,2,0,0,1,1,2,0,1,2,2,2,0,0,1,0,2,1,0,1,2,1,0,0,2,0,0,0,0,1,0,1,1,1,0,0,2,1,0,1,0,2,0,2,0,0,2,0,1,0,0,1,0,0,0,0,0,1,0,1,1,1,0,0,0,2,0,0,1,0,0,0,0,0,0,1,0,2,2,0,2,0,1,2,2,0,2,0,2,0,0,0,1,0,2,0,2,0,2,1,0,0,1,0,1,2,1,2,1,0,1,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,1,1,2,1,2,2,2,2,2,2,2,2,2,2,2,2,1,0,1,2,0,0,0,2,2,0,1,1,2,1,0,1,2,0,0,1,0,0,2,0,1,10,10,0,2,0,1,0,0,0,1,2,0,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,2,1,1,1,0,0,2,1,0,0,0,1,1,1,0,0,0,0,0,0,1,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,13,13,13,13,1,2,1,1,0,0,2,2,1,1,1,1,1,1,2,0,0,0,1,0,1,0,0,2,0,0,0,0,1,2,0,2,0,0,2,2,2,1,7,7,7,1,0,2,1,1,0,0,0,0,0,0,1,2,0,0,1,0,2,2,0,0,2,0,0,0,2,0,0,0,2,0,0,2,0,2,0,2,0,0,0,0,2,1,0,0,0,0,1,2,0,0,0,0,0,2,0,0,1,0,0,2,0,0,1,0,0,2,2,0,0,2,0,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,1,2,0,0,0,2,0,0,0,2,2,2,2,2,2,2,2,2,2,2,0,2,0,1,0,2,1,0,0,1,1,2,2,2,0,0,0,0,0,0,2,2,0,1,0,1,2,1,0,2,1,1,1,0,0,2,0,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,0,2,0,1,0,1,0,0,1,0,2,0,0,2,2,0,1,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,13,13,13,2,0,2,1,0,0,1,2,1,1,0,2,0,2,0,2,1,0,2,0,0,1,0,2,1,0,2,2,0,1,1,0,1,0,0,1,1,1,7,7,7,7,0,2,0,1,0,2,0,1,0,0,0,2,0,2,1,1,0,0,0,2,2,1,1,0,2,0,2,0,2,1,1,2,0,0,1,1,0,0,2,19,7,7,0,19,0,0,0,0,0,2,0,1,2,0,2,2,0,1,0,2,1,0,0,0,2,0,0,1,2,2,0,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,0,0,0,0,0,2,0,0,2,0,2,2,2,2,2,2,2,2,2,2,2,1,0,2,2,2,2,0,0,0,0,0,1,0,2,0,2,1,0,1,0,1,1,2,2,0,2,1,2,0,2,1,0,1,0,2,0,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,1,1,1,0,0,2,1,0,0,2,1,0,0,0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,13,0,0,0,0,0,1,2,2,0,0,0,1,0,2,1,2,2,0,0,2,2,0,2,1,2,0,0,1,1,1,0,1,0,0,0,1,0,0,7,7,7,7,7,0,2,1,2,0,2,0,0,0,1,1,0,1,1,2,0,0,1,0,1,0,2,1,0,0,0,0,2,0,0,0,2,0,2,0,1,1,19,19,7,19,1,19,19,0,0,1,0,0,2,2,0,1,1,1,0,2,1,0,2,0,1,0,2,0,0,0,0,2,0,0,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,1,2,1,2,2,1,1,2,1,0,1,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0,2,0,0,1,2,0,0,0,1,1,0,0,1,1,2,0,0,0,2,21,21,2,2,0,2,2,2,2,2,0,0,0,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,0,2,2,2,0,0,0,0,0,0,2,0,1,0,2,0,1,2,1,0,0,2,1,1,2,0,2,1,0,0,1,0,1,7,7,7,2,1,0,0,2,0,0,0,0,0,1,1,2,1,1,0,0,0,0,0,0,2,1,0,0,0,0,1,1,0,0,0,1,0,1,0,0,1,19,19,19,2,1,2,19,0,0,0,0,2,0,0,0,0,1,1,0,1,0,0,1,0,1,1,0,1,2,1,1,0,0,0,0,0,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,2,2,0,2,0,2,0,1,0,0,1,2,2,2,2,2,2,2,0,2,0,2,1,2,2,1,0,0,0,2,0,0,0,1,0,0,0,1,0,2,2,0,0,0,0,2,21,21,1,2,2,0,1,1,1,0,1,0,0,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,10,10,2,0,1,0,1,1,2,0,0,2,1,0,2,0,1,1,2,0,1,2,1,0,0,2,2,0,2,0,0,1,0,1,1,0,0,0,0,1,1,1,0,0,0,0,0,1,1,1,1,0,0,0,1,0,0,0,2,0,0,1,2,0,0,2,1,2,0,0,0,1,1,2,2,2,0,2,19,2,19,19,19,19,19,1,0,2,1,0,0,2,0,2,0,2,2,2,1,0,1,1,0,2,0,2,2,0,2,0,2,1,2,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,0,0,1,0,1,1,0,1,1,0,2,2,2,2,2,2,2,2,1,2,0,0,2,1,1,2,0,1,1,2,1,1,1,1,0,0,1,2,1,0,2,0,2,2,0,21,21,0,2,1,0,0,2,1,0,0,0,2,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,10,0,0,0,1,2,0,10,10,2,2,2,0,2,0,2,0,2,0,0,0,1,1,2,0,1,1,0,2,1,2,2,0,1,2,1,1,2,1,0,0,1,2,2,0,0,2,0,2,2,2,0,1,1,1,0,0,2,1,1,1,2,2,0,0,0,1,1,0,2,0,0,0,0,1,0,2,7,19,0,7,7,0,2,2,0,0,0,0,0,0,0,2,2,1,2,1,0,0,1,1,1,1,1,1,0,0,0,2,0,2,1,1,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,1,1,2,0,0,0,2,0,2,1,0,2,0,0,2,2,2,2,2,2,0,0,0,2,1,1,1,2,1,2,0,0,0,1,1,0,2,2,2,0,10,10,10,1,1,0,0,1,0,0,1,2,0,2,2,0,1,1,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,10,10,10,0,0,10,2,10,10,10,0,0,0,2,2,0,0,1,1,2,1,0,1,1,0,0,0,0,0,1,0,2,0,0,0,0,0,0,2,2,0,2,0,0,2,2,2,0,2,2,0,2,2,2,0,2,1,0,2,0,1,0,1,0,0,0,0,1,0,1,1,0,0,2,0,2,1,0,7,7,0,1,0,2,0,0,0,0,0,0,0,0,1,2,0,0,1,2,1,2,2,1,1,0,0,0,1,0,2,0,0,1,2,0,2,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,0,0,1,0,0,0,2,0,1,1,1,1,1,2,2,2,2,2,2,0,2,2,0,0,0,2,2,1,1,1,0,2,1,2,0,2,0,0,2,2,10,2,1,2,7,0,0,0,2,2,2,0,0,0,1,0,0,0,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,10,10,10,10,10,10,10,10,0,1,1,1,0,0,0,2,0,0,1,0,0,2,1,0,2,0,1,1,1,0,2,1,1,1,1,0,0,0,0,1,0,2,1,0,0,0,1,0,2,0,0,0,2,2,1,1,1,0,0,1,0,2,0,0,2,0,1,2,1,0,0,0,1,1,0,2,0,0,0,1,1,0,0,1,0,2,1,0,1,0,1,0,1,1,2,1,0,2,0,1,0,2,0,0,0,2,0,2,0,0,1,1,1,2,0,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,1,2,0,1,2,0,0,0,2,1,1,2,0,2,2,2,2,2,1,0,0,0,2,0,0,10,10,2,0,0,0,1,2,0,2,0,0,0,0,1,0,0,0,7,7,2,0,1,2,1,0,1,1,0,2,0,2,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,10,0,0,10,10,10,10,0,0,0,0,0,0,2,2,0,2,0,1,0,0,0,2,0,2,0,1,0,2,1,1,1,1,1,1,0,0,2,0,2,0,1,0,0,1,0,0,0,2,0,2,1,0,2,1,2,1,1,0,0,2,0,2,0,1,0,0,1,1,1,0,0,1,1,1,0,1,0,0,1,0,2,0,0,2,2,1,2,0,2,0,0,2,1,1,1,0,2,0,0,2,0,0,1,1,1,2,0,0,2,2,0,0,0,1,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,2,1,2,0,0,0,2,0,0,2,0,0,0,2,2,2,2,2,1,2,0,0,2,1,2,10,0,0,0,1,0,0,0,2,1,0,1,0,2,0,1,2,7,1,0,2,0,2,0,0,1,1,1,0,1,1,1,1,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,0,0,10,1,0,0,0,10,1,0,0,2,1,0,1,2,2,2,0,0,2,0,2,0,2,1,1,1,1,1,1,1,1,1,0,1,0,2,1,0,0,2,0,0,2,0,1,1,0,2,0,2,0,2,0,0,2,0,2,0,0,1,0,1,0,1,0,2,0,1,0,1,0,1,0,1,2,0,0,1,1,2,0,0,0,0,0,0,0,1,1,0,0,2,1,2,1,0,0,0,2,2,1,1,0,0,0,0,0,0,0,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,1,2,2,0,1,0,1,2,2,0,2,2,2,2,2,2,1,2,0,0,1,2,10,0,1,2,0,2,1,0,0,1,1,2,0,0,1,2,1,2,0,1,0,0,0,1,0,0,2,2,0,2,2,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,10,1,0,0,0,0,1,1,1,2,2,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,2,0,2,0,0,0,0,0,0,0,2,1,2,0,0,0,2,2,0,1,2,1,0,2,0,1,0,1,1,0,0,2,0,1,2,1,0,0,1,2,2,1,0,2,0,0,2,0,0,1,2,2,1,1,0,0,0,2,0,1,1,2,2,1,2,1,0,1,2,0,2,2,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,0,0,0,0,2,2,2,1,1,0,1,0,1,0,2,2,2,2,2,2,0,2,0,0,0,2,1,1,1,0,2,1,0,1,1,2,0,0,1,0,2,1,0,0,0,0,0,2,0,0,0,2,0,2,1,0,0,2,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,0,1,2,0,2,0,1,2,0,2,1,2,0,0,0,2,2,1,1,1,1,1,1,1,1,0,0,0,0,2,2,0,0,1,0,0,1,1,2,0,2,2,0,2,2,1,0,1,1,2,0,2,2,1,2,0,0,1,0,0,0,0,1,1,1,0,1,2,0,1,1,2,2,0,0,0,0,0,2,2,2,2,0,2,0,0,1,0,0,2,0,1,2,0,2,0,0,2,0,2,0,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,0,0,0,2,0,2,2,0,0,0,1,1,2,2,2,2,2,2,2,1,0,2,2,2,1,2,2,2,0,2,2,0,0,2,2,0,1,0,1,0,0,0,0,2,0,0,1,10,10,0,1,1,1,2,1,1,0,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,13,2,0,2,0,2,0,1,0,1,0,2,2,0,1,1,1,1,1,1,1,0,0,2,1,2,2,2,2,1,2,1,2,2,2,1,1,0,2,1,0,1,2,0,0,0,0,0,2,1,1,2,1,2,2,0,0,1,0,0,2,2,0,1,0,0,7,7,7,0,1,1,1,2,0,2,0,2,2,0,0,2,1,0,2,1,0,0,0,0,1,1,0,2,2,1,0,0,0,0,0,0,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,1,1,0,0,0,1,0,0,0,0,0,1,0,0,2,2,2,2,2,2,2,2,2,0,0,1,1,1,2,0,1,1,0,1,2,10,2,0,0,1,2,0,0,2,1,0,2,0,0,2,0,1,1,1,0,0,1,0,0,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,13,13,13,2,0,2,0,2,0,0,0,0,2,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,1,2,2,0,0,1,2,2,0,0,1,2,0,0,0,1,1,0,2,0,2,0,0,0,1,2,1,0,1,1,0,0,2,2,0,0,2,0,7,7,7,7,1,2,0,0,2,0,1,0,2,2,0,2,2,2,2,0,1,2,0,0,0,0,0,2,1,0,0,1,1,0,0,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,0,1,0,0,2,1,2,0,1,0,2,0,1,2,0,0,2,2,2,2,2,2,2,1,1,1,1,1,1,0,0,0,2,1,10,10,10,0,0,2,1,1,0,2,2,0,0,0,0,0,1,1,0,2,2,0,0,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,13,13,13,1,1,0,0,2,1,0,2,0,2,1,1,1,1,1,1,1,1,1,0,0,0,1,0,2,0,0,0,1,1,0,0,1,2,1,2,2,0,2,0,0,0,1,0,2,0,2,0,1,0,0,0,0,1,0,0,1,0,7,7,0,0,7,7,0,2,0,0,1,2,0,0,1,1,2,0,1,0,0,1,1,2,2,2,2,1,0,0,0,0,0,1,0,1,1,0,2,0,2,0,0,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,0,0,2,0,2,2,1,0,1,0,0,1,0,0,1,1,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,2,0,10,10,10,0,21,21,1,1,2,0,2,0,0,0,0,2,2,0,1,0,1,2,2,2,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,0,0,1,0,1,2,0,2,0,0,2,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,2,0,0,1,0,2,2,1,0,1,0,1,1,0,0,0,0,0,2,1,2,0,2,0,2,0,2,0,2,2,2,7,7,0,7,7,1,1,0,1,0,2,2,1,0,1,1,1,1,2,0,2,1,0,0,2,2,0,0,0,1,2,0,1,2,2,1,1,0,0,1,0,0,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,0,0,1,1,1,0,2,1,0,2,2,2,0,1,0,0,2,2,2,2,2,1,1,1,1,1,1,1,1,2,0,0,1,2,1,21,21,21,21,2,2,2,2,1,1,0,0,1,0,0,0,0,2,0,0,2,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,2,2,2,1,0,0,2,1,0,2,0,1,1,1,1,1,1,1,1,0,0,0,0,2,0,1,0,0,0,0,0,1,0,2,2,2,0,0,1,2,1,0,1,0,1,2,2,0,2,1,0,0,1,1,1,0,0,1,7,7,2,7,7,0,0,0,2,2,2,1,2,1,1,1,1,1,1,0,2,1,2,0,0,0,0,0,0,0,2,0,2,0,2,0,1,1,2,0,0,1,2,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,2,0,0,0,0,1,0,0,2,0,0,2,0,0,0,2,0,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,0,2,21,21,21,21,1,1,1,1,0,0,2,1,1,1,0,0,0,2,0,0,0,1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,13,0,0,0,0,0,2,0,2,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,0,0,1,0,0,0,0,0,0,0,0,0,1,2,0,2,1,0,0,2,0,0,0,0,0,2,0,0,1,0,0,0,0,7,7,7,1,0,2,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,0,1,2,1,0,1,1,1,2,1,0,1,1,0,1,0,2,0,0,0,0,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,2,0,0,1,2,0,1,1,0,2,1,1,1,0,2,2,0,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,0,2,1,21,21,21,1,1,1,1,1,1,1,2,0,1,2,0,2,2,2,0,1,1,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,13,2,1,2,2,2,0,2,0,1,1,1,1,1,1,1,1,0,0,0,2,0,1,2,1,0,1,2,2,2,0,0,2,1,1,1,0,2,2,0,0,0,1,0,1,1,2,1,0,2,0,2,0,0,0,1,0,0,7,7,7,2,0,0,0,1,1,2,1,1,1,1,1,1,1,1,1,1,1,0,0,2,2,2,1,1,2,0,1,1,0,2,0,0,0,0,2,1,1,2,2,0,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,1,0,0,0,1,1,1,1,0,2,2,0,2,0,1,1,2,0,1,0,2,1,1,1,1,1,1,1,1,1,1,1,1,0,2,21,21,21,21,1,1,1,1,1,1,1,1,1,1,0,1,2,0,0,1,0,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,1,0,1,2,2,1,1,0,2,1,1,1,1,1,1,1,0,2,0,0,0,0,2,0,0,0,0,0,1,0,0,1,1,1,1,1,1,0,2,0,2,0,1,0,2,2,1,0,0,0,2,0,2,1,1,2,0,7,7,7,2,0,2,2,0,1,0,2,1,1,1,1,1,1,1,1,1,1,1,0,0,1,0,1,0,0,0,1,1,0,0,1,2,2,0,2,1,0,0,0,2,2,1,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,2,0,2,2,0,1,0,0,2,0,0,2,0,0,0,1,2,0,2,1,0,1,1,1,1,1,1,1,1,1,1,1,1,2,21,21,21,21,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,13,1,1,1,0,0,1,1,2,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,0,1,0,1,0,1,1,1,1,1,1,1,0,2,1,2,1,0,0,0,0,0,0,0,2,0,0,2,1,0,0,0,7,7,2,1,2,1,0,1,0,0,1,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,0,2,0,1,2,1,0,1,2,0,0,1,0,1,2,0,2,1,0,2,1,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,2,1,0,2,2,0,0,1,0,0,0,1,1,2,2,2,1,1,1,0,1,0,1,1,1,1,1,1,1,1,1,1,1,2,21,21,21,21,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,13,2,1,0,2,0,0,0,0,1,1,1,1,1,1,0,0,2,1,0,1,0,0,1,0,0,0,1,2,1,1,1,1,1,1,1,1,0,2,0,0,0,1,0,0,1,0,1,0,1,1,1,0,2,0,2,0,0,2,0,1,2,1,0,1,0,1,1,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,0,0,0,0,0,2,1,2,0,0,2,1,1,0,1,0,0,0,2,2,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,2,2,0,2,1,0,0,1,0,0,1,1,0,2,0,1,2,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,21,21,21,21,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,2,1,1,1,1,1,0,1,0,1,1,1,0,2,2,0,2,1,1,0,2,0,0,1,0,1,2,0,1,1,1,1,1,1,1,0,2,0,0,2,1,2,2,2,2,0,0,2,0,0,1,2,2,2,0,1,2,1,0,2,1,1,2,0,1,0,2,1,2,2,1,1,1,1,1,1,1,1,0,0,0,1,1,2,1,0,2,0,0,1,2,2,1,1,0,2,1,0,0,1,1,1,2,0,2,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,2,0,0,0,0,0,2,0,2,0,2,0,1,0,2,1,0,0,2,0,2,2,0,0,1,1,1,1,1,1,1,2,2,2,21,21,21,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,13,1,0,0,0,1,2,0,0,0,0,0,2,1,1,0,0,1,0,2,1,0,0,2,0,1,0,2,1,1,1,1,1,1,2,1,0,2,1,0,0,1,1,2,0,0,0,0,1,0,1,2,2,0,0,1,0,0,1,0,0,0,2,0,1,0,2,1,2,0,1,1,1,1,1,1,1,0,2,0,2,2,1,0,1,1,0,1,0,1,0,2,2,0,2,0,0,0,2,2,2,1,0,2,2,0,1,2,1,1,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,0,0,1,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,21,21,7,7,2,1,1,1,1,2,21,21,21,21,21,21,2,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,13,13,13,13,0,1,1,0,0,1,2,0,2,0,2,2,0,0,2,0,0,0,0,2,0,0,0,2,0,2,0,1,1,1,1,2,2,2,1,2,2,0,0,2,1,1,1,2,1,1,1,0,0,0,0,0,0,1,0,0,2,2,2,0,0,1,1,0,0,0,1,1,0,1,1,1,1,1,0,0,19,19,19,1,0,1,1,0,0,1,2,0,0,0,0,0,0,2,0,0,0,1,1,2,2,0,0,0,0,1,0,1,2,0,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,0,0,0,0,0,2,0,0,1,0,1,0,1,0,1,0,21,21,21,21,7,2,2,2,2,2,2,21,21,21,21,21,21,2,0,1,1,2,1,1,1,1,1,1,1,0,0,2,21,21,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,13,13,13,2,2,2,0,2,0,0,0,0,1,0,1,0,1,2,0,2,0,2,2,0,0,2,0,2,2,1,1,0,2,0,0,0,2,0,1,1,2,0,2,2,1,2,1,0,0,2,0,1,0,2,2,2,0,1,2,2,0,1,0,0,0,1,2,0,2,1,1,0,1,1,1,1,1,19,19,19,0,19,0,0,1,0,2,0,0,2,1,0,0,1,2,0,0,0,0,2,0,0,2,0,1,2,1,0,0,1,1,0,1,0,0,2,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,0,2,2,0,1,1,0,0,0,2,1,1,2,0,0,2,21,21,21,21,21,2,2,2,2,2,2,19,21,21,21,21,21,21,2,0,0,0,0,0,1,1,1,2,2,0,0,21,21,21,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,13,13,13,0,2,2,0,0,0,0,1,0,2,1,1,2,2,2,2,0,1,2,2,2,1,0,0,1,1,0,0,2,1,1,0,0,1,0,1,0,0,0,2,0,1,2,0,0,0,0,0,0,1,0,1,1,1,2,0,1,0,2,0,0,0,0,1,0,1,0,1,1,1,1,1,1,1,19,1,1,0,0,0,2,0,2,2,1,0,0,0,2,0,2,0,0,0,2,0,1,0,0,0,0,1,1,1,0,1,2,2,0,0,2,2,0,1,2,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,0,1,2,0,0,0,2,0,1,2,0,0,0,0,0,1,2,0,21,21,2,2,2,2,2,2,2,19,19,21,21,21,21,21,2,2,0,0,1,1,0,0,0,1,1,0,21,21,21,21,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,13,1,0,1,0,1,1,2,2,0,1,2,1,2,1,0,2,2,0,2,0,0,2,2,1,0,0,2,2,2,0,2,0,0,0,0,2,2,2,0,0,0,1,0,2,1,0,1,0,1,0,0,0,0,0,0,1,1,2,1,0,2,0,2,2,0,1,2,0,1,1,1,1,1,1,1,7,7,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,2,2,0,0,0,0,2,0,0,1,2,0,1,0,0,1,2,2,1,1,0,0,0,2,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,2,0,1,0,1,10,10,2,0,0,1,0,0,2,21,21,21,21,2,2,2,2,2,2,2,21,21,21,21,21,2,2,2,2,2,1,2,2,0,0,0,0,21,21,21,0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,1,10,2,2,0,0,1,0,0,0,0,1,0,1,1,0,2,0,2,0,2,0,0,0,1,0,0,0,1,2,0,1,2,0,2,0,1,2,0,0,2,0,0,0,0,1,0,1,0,0,2,0,2,1,2,1,1,1,0,0,2,0,0,0,0,2,2,1,1,1,1,1,1,1,1,1,7,7,7,7,1,1,1,1,1,1,1,1,1,2,1,1,2,2,2,0,2,1,2,0,0,0,2,0,0,1,0,0,0,0,0,0,0,0,2,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,0,1,1,1,0,10,10,10,2,0,1,0,2,1,2,7,7,21,21,2,2,2,2,2,2,2,21,21,21,21,2,2,2,2,0,2,2,2,0,0,1,0,0,21,21,1,1,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,10,10,10,10,2,0,0,1,1,1,0,0,0,0,0,2,0,1,0,1,0,2,0,0,0,1,0,2,2,2,0,1,2,0,0,0,0,0,0,0,2,0,1,0,0,0,0,0,1,0,2,0,0,1,1,0,0,0,1,0,0,0,0,1,2,0,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,1,1,0,0,1,2,0,1,2,1,2,2,1,0,1,0,1,2,1,0,2,0,0,0,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,1,2,1,0,2,10,2,2,1,2,0,0,2,2,7,21,21,2,2,2,2,2,2,2,2,21,21,21,2,2,2,2,1,0,0,0,1,2,0,21,21,21,21,1,0,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,15,10,10,10,10,0,0,0,0,1,1,0,0,0,0,0,0,2,0,2,2,2,0,1,2,0,1,0,2,0,0,1,0,0,0,0,0,0,0,0,1,0,2,1,1,1,2,0,2,0,2,0,2,2,0,0,1,2,2,2,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,2,0,0,0,0,0,1,1,1,0,0,1,0,2,1,2,0,0,0,2,1,0,0,0,2,1,0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,2,1,1,1,0,1,1,0,0,0,1,1,1,0,2,2,21,21,21,2,2,2,2,2,2,2,2,2,21,21,2,2,2,2,1,0,0,0,0,0,21,21,21,21,21,18,14,14,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,2,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,10,10,10,0,0,0,0,0,0,0,1,0,0,0,1,2,0,2,0,1,1,2,0,2,0,2,0,0,0,0,2,0,0,0,2,0,0,2,0,0,2,0,0,1,2,0,0,0,2,0,2,1,2,1,2,0,0,0,1,2,0,1,2,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,0,0,0,0,0,2,2,2,2,0,1,0,1,1,2,0,0,1,0,0,0,2,1,0,2,0,2,0,1,2,1,2,13,13,13,13,15,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,2,0,0,0,2,1,2,0,2,0,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,21,21,2,2,2,2,1,1,1,1,2,21,21,21,21,14,1,18,16,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,10,0,1,0,0,0,0,0,1,0,0,0,0,0,1,2,0,2,1,2,0,2,0,1,2,1,0,0,0,0,2,2,1,2,0,0,2,2,0,1,0,2,0,0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,2,1,1,1,2,2,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,0,0,1,0,0,0,1,2,1,1,0,0,2,0,1,2,1,0,1,2,0,0,1,0,0,0,2,0,1,13,13,13,13,13,13,13,13,2,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,2,0,0,0,1,0,2,1,0,0,0,1,0,2,1,0,0,0,0,2,1,2,2,2,2,2,2,21,21,1,1,1,0,1,0,0,1,21,21,21,21,20,0,0,2,1,2,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,1,1,1,0,0,0,0,0,2,0,0,0,0,2,1,0,0,2,1,1,1,0,0,0,0,0,2,0,0,2,0,0,2,0,0,0,0,1,0,2,2,0,1,0,0,0,2,1,0,0,0,2,0,1,0,1,2,1,1,0,1,0,0,0,2,0,0,2,2,1,0,1,2,0,0,1,1,1,1,1,1,1,1,1,1,2,0,0,0,0,0,1,2,1,0,0,2,0,0,1,0,1,2,0,0,0,1,0,0,1,1,0,0,0,0,0,2,0,13,13,13,0,0,13,13,13,3,3,1,3,3,3,3,3,3,3,3,3,3,3,1,0,0,1,1,0,1,0,0,2,2,1,2,0,0,0,1,0,1,2,0,2,0,1,1,0,1,1,0,0,2,1,1,2,0,0,2,1,1,21,21,21,1,0,1,2,2,1,1,1,];
}

function getTilePallet()
{
	return ["desert_dirt_rough_2","desert_dirt_rough","desert_sand_dunes_50","desert_sand_wet","desert_dirt_persia_1","desert_dirt_persia_rocks","desert_dirt_rocks_1","desert_sand_stones","desert_dirt_rocks_2","desert_dirt_rocks_3","desert_sand_scrub","desert_plants_b","desert_dirt_rocks_3_scrub","desert_cliff_3_dirty","desert_cliff_4","forestfloor_dirty","desert_cliff_2","desert_cliff_1","desert_cliff_5","desert_sand_dunes_rocks","desert_cliff_3","desert_cliff_egypt_2"];
}
