/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.color;

public class TagEntry {
    public static final int entrySize = 12;
    private int signature;
    private int size;
    private int offset;
    private byte[] data;

    public TagEntry(int sig, int offset, int size, byte[] data) {
        this.signature = sig;
        this.offset = offset;
        this.size = size;
        this.data = new byte[size];
        System.arraycopy(data, offset, this.data, 0, size);
    }

    public TagEntry(int sig, byte[] data) {
        this.signature = sig;
        this.size = data.length;
        this.data = new byte[this.size];
        System.arraycopy(data, this.offset, this.data, 0, this.size);
    }

    public byte[] getData() {
        byte[] d = new byte[this.size];
        System.arraycopy(this.data, 0, d, 0, this.size);
        return d;
    }

    public String hashKey() {
        return TagEntry.tagHashKey(this.signature);
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + (char)(this.signature >> 24 & 0xFF);
        s = String.valueOf(s) + (char)(this.signature >> 16 & 0xFF);
        s = String.valueOf(s) + (char)(this.signature >> 8 & 0xFF);
        s = String.valueOf(s) + (char)(this.signature & 0xFF);
        return s;
    }

    public int getSignature() {
        return this.signature;
    }

    public int getSize() {
        return this.size;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public static String tagHashKey(int sig) {
        return "" + sig;
    }
}

