/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.peer.gtk.GtkClipboard;
import gnu.java.awt.peer.gtk.GtkImage;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StringBufferInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GtkSelection
implements Transferable {
    private static Object requestLock = new Object();
    private final boolean clipboard;
    private boolean requestInProgress;
    private boolean mimeTypesDelivered;
    private DataFlavor[] dataFlavors;
    private boolean textDelivered;
    private String text;
    private boolean imageDelivered;
    private Pointer imagePointer;
    private Image image;
    private boolean urisDelivered;
    private List<File> uris;
    private boolean bytesDelivered;
    private byte[] bytes;

    GtkSelection(GtkClipboard clipboard) {
        this.clipboard = clipboard == GtkClipboard.clipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public DataFlavor[] getTransferDataFlavors() {
        block11: {
            var2_1 = GtkSelection.requestLock;
            synchronized (var2_1) {
                if (!this.mimeTypesDelivered) ** GOTO lbl11
                result = (DataFlavor[])this.dataFlavors.clone();
                break block11;
lbl-1000:
                // 1 sources

                {
                    try {
                        GtkSelection.requestLock.wait();
                        continue;
                    }
                    catch (InterruptedException v0) {}
lbl11:
                    // 3 sources

                    ** while (this.requestInProgress)
                }
lbl12:
                // 1 sources

                if (!this.mimeTypesDelivered) {
                    this.requestInProgress = true;
                    this.requestMimeTypes(this.clipboard);
                    while (!this.mimeTypesDelivered) {
                        try {
                            GtkSelection.requestLock.wait();
                        }
                        catch (InterruptedException v1) {}
                    }
                    this.requestInProgress = false;
                }
                result = this.dataFlavors;
                if (!GtkClipboard.canCache) {
                    this.dataFlavors = null;
                    this.mimeTypesDelivered = false;
                }
                GtkSelection.requestLock.notifyAll();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mimeTypesAvailable(String[] mimeTypes) {
        Object object = requestLock;
        synchronized (object) {
            if (mimeTypes == null) {
                this.dataFlavors = new DataFlavor[0];
            } else {
                ArrayList<DataFlavor> flavorsList = new ArrayList<DataFlavor>(mimeTypes.length + 1);
                int i = 0;
                while (i < mimeTypes.length) {
                    try {
                        if (mimeTypes[i] == GtkClipboard.stringMimeType) {
                            flavorsList.add(DataFlavor.stringFlavor);
                            flavorsList.add(DataFlavor.plainTextFlavor);
                        } else if (mimeTypes[i] == GtkClipboard.imageMimeType) {
                            flavorsList.add(DataFlavor.imageFlavor);
                        } else if (mimeTypes[i] == GtkClipboard.filesMimeType) {
                            flavorsList.add(DataFlavor.javaFileListFlavor);
                        } else {
                            DataFlavor target = new DataFlavor(mimeTypes[i]);
                            if (!flavorsList.contains(target)) {
                                flavorsList.add(target);
                            }
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        cnfe.printStackTrace();
                    }
                    catch (NullPointerException npe) {
                        npe.printStackTrace();
                    }
                    ++i;
                }
                this.dataFlavors = new DataFlavor[flavorsList.size()];
                flavorsList.toArray(this.dataFlavors);
            }
            this.mimeTypesDelivered = true;
            requestLock.notifyAll();
        }
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] dfs = this.getTransferDataFlavors();
        int i = 0;
        while (i < dfs.length) {
            if (flavor.equals(dfs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String getText() {
        block11: {
            var2_1 = GtkSelection.requestLock;
            synchronized (var2_1) {
                if (!this.textDelivered) ** GOTO lbl11
                result = this.text;
                break block11;
lbl-1000:
                // 1 sources

                {
                    try {
                        GtkSelection.requestLock.wait();
                        continue;
                    }
                    catch (InterruptedException v0) {}
lbl11:
                    // 3 sources

                    ** while (this.requestInProgress)
                }
lbl12:
                // 1 sources

                if (!this.textDelivered) {
                    this.requestInProgress = true;
                    this.requestText(this.clipboard);
                    while (!this.textDelivered) {
                        try {
                            GtkSelection.requestLock.wait();
                        }
                        catch (InterruptedException v1) {}
                    }
                    this.requestInProgress = false;
                }
                result = this.text;
                if (!GtkClipboard.canCache) {
                    this.text = null;
                    this.textDelivered = false;
                }
                GtkSelection.requestLock.notifyAll();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void textAvailable(String text) {
        Object object = requestLock;
        synchronized (object) {
            this.text = text;
            this.textDelivered = true;
            requestLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Image getImage() {
        block12: {
            var2_1 = GtkSelection.requestLock;
            synchronized (var2_1) {
                if (!this.imageDelivered) ** GOTO lbl11
                result = this.image;
                break block12;
lbl-1000:
                // 1 sources

                {
                    try {
                        GtkSelection.requestLock.wait();
                        continue;
                    }
                    catch (InterruptedException v0) {}
lbl11:
                    // 3 sources

                    ** while (this.requestInProgress)
                }
lbl12:
                // 1 sources

                if (!this.imageDelivered) {
                    this.requestInProgress = true;
                    this.requestImage(this.clipboard);
                    while (!this.imageDelivered) {
                        try {
                            GtkSelection.requestLock.wait();
                        }
                        catch (InterruptedException v1) {}
                    }
                    this.requestInProgress = false;
                }
                if (this.imagePointer != null) {
                    this.image = new GtkImage(this.imagePointer);
                }
                this.imagePointer = null;
                result = this.image;
                if (!GtkClipboard.canCache) {
                    this.image = null;
                    this.imageDelivered = false;
                }
                GtkSelection.requestLock.notifyAll();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imageAvailable(Pointer pointer) {
        Object object = requestLock;
        synchronized (object) {
            this.imagePointer = pointer;
            this.imageDelivered = true;
            requestLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private List<File> getURIs() {
        block11: {
            var2_1 = GtkSelection.requestLock;
            synchronized (var2_1) {
                if (!this.urisDelivered) ** GOTO lbl11
                result = this.uris;
                break block11;
lbl-1000:
                // 1 sources

                {
                    try {
                        GtkSelection.requestLock.wait();
                        continue;
                    }
                    catch (InterruptedException v0) {}
lbl11:
                    // 3 sources

                    ** while (this.requestInProgress)
                }
lbl12:
                // 1 sources

                if (!this.urisDelivered) {
                    this.requestInProgress = true;
                    this.requestURIs(this.clipboard);
                    while (!this.urisDelivered) {
                        try {
                            GtkSelection.requestLock.wait();
                        }
                        catch (InterruptedException v1) {}
                    }
                    this.requestInProgress = false;
                }
                result = this.uris;
                if (!GtkClipboard.canCache) {
                    this.uris = null;
                    this.urisDelivered = false;
                }
                GtkSelection.requestLock.notifyAll();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void urisAvailable(String[] uris) {
        Object object = requestLock;
        synchronized (object) {
            if (uris != null && uris.length != 0) {
                ArrayList<File> list2 = new ArrayList<File>(uris.length);
                int i = 0;
                while (i < uris.length) {
                    try {
                        URI uri = new URI(uris[i]);
                        if (uri.getScheme().equals("file")) {
                            list2.add(new File(uri));
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                    ++i;
                }
                this.uris = list2;
            }
            this.urisDelivered = true;
            requestLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getBytes(String target) {
        var3_2 = GtkSelection.requestLock;
        synchronized (var3_2) {
            while (true) {
                block9: {
                    if (this.requestInProgress) break block9;
                    this.requestInProgress = true;
                    this.requestBytes(this.clipboard, target);
                    if (true) ** GOTO lbl22
                }
                try {
                    GtkSelection.requestLock.wait();
                }
                catch (InterruptedException v0) {}
            }
            do {
                try {
                    GtkSelection.requestLock.wait();
                }
                catch (InterruptedException v2) {}
lbl22:
                // 3 sources

            } while (!this.bytesDelivered);
            result = this.bytes;
            this.bytes = null;
            this.bytesDelivered = false;
            this.requestInProgress = false;
            GtkSelection.requestLock.notifyAll();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bytesAvailable(byte[] bytes) {
        Object object = requestLock;
        synchronized (object) {
            this.bytes = bytes;
            this.bytesDelivered = true;
            requestLock.notifyAll();
        }
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        List<File> uris;
        Image image;
        String text;
        if (flavor.equals(DataFlavor.stringFlavor) && (text = this.getText()) != null) {
            return text;
        }
        if (flavor.equals(DataFlavor.plainTextFlavor) && (text = this.getText()) != null) {
            return new StringBufferInputStream(text);
        }
        if (flavor.equals(DataFlavor.imageFlavor) && (image = this.getImage()) != null) {
            return image;
        }
        if (flavor.equals(DataFlavor.javaFileListFlavor) && (uris = this.getURIs()) != null) {
            return uris;
        }
        byte[] bytes = this.getBytes(flavor.getMimeType());
        if (bytes == null) {
            throw new UnsupportedFlavorException(flavor);
        }
        if (flavor.isMimeTypeSerializedObject()) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bais);
                return ois.readObject();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
        }
        if (flavor.isRepresentationClassInputStream()) {
            return new ByteArrayInputStream(bytes);
        }
        throw new UnsupportedFlavorException(flavor);
    }

    private native void requestText(boolean var1);

    private native void requestImage(boolean var1);

    private native void requestURIs(boolean var1);

    private native void requestBytes(boolean var1, String var2);

    private native void requestMimeTypes(boolean var1);
}

