/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.qt;

import gnu.java.awt.peer.qt.QtImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public class QtImageConsumer
implements ImageConsumer {
    private QtImage target;
    private int width;
    private int height;
    private Hashtable properties;
    private int[] pixelCache = null;
    private ImageProducer source;

    public QtImageConsumer(QtImage target, ImageProducer source) {
        this.target = target;
        this.source = source;
    }

    public synchronized void imageComplete(int status) {
        this.source.removeConsumer(this);
        this.target.setImage(this.width, this.height, this.pixelCache, this.properties);
    }

    public synchronized void setColorModel(ColorModel model) {
    }

    public synchronized void setDimensions(int width, int height) {
        this.pixelCache = new int[width * height];
        this.width = width;
        this.height = height;
    }

    public synchronized void setHints(int flags) {
    }

    public synchronized void setPixels(int x, int y, int width, int height, ColorModel cm, byte[] pixels, int offset, int scansize) {
        this.setPixels(x, y, width, height, cm, this.convertPixels(pixels), offset, scansize);
    }

    public synchronized void setPixels(int x, int y, int width, int height, ColorModel cm, int[] pixels, int offset, int scansize) {
        if (this.pixelCache == null) {
            return;
        }
        if (cm.equals(QtImage.nativeModel)) {
            int i = 0;
            while (i < height) {
                System.arraycopy(pixels, offset + i * scansize, this.pixelCache, (y + i) * this.width + x, width);
                ++i;
            }
        } else {
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    int pix = cm.getRGB(pixels[offset + i * scansize + x + j]);
                    byte b = (byte)(pix & 0xFF);
                    byte r = (byte)((pix & 0xFF0000) >> 16 & 0xFF);
                    pix &= 0xFF00FF00;
                    pix |= (b & 0xFF) << 16;
                    this.pixelCache[(y + i) * this.width + x + j] = pix |= r & 0xFF;
                    ++j;
                }
                ++i;
            }
        }
    }

    private int[] convertPixels(byte[] pixels) {
        int[] ret = new int[pixels.length];
        int i = 0;
        while (i < pixels.length) {
            ret[i] = pixels[i] & 0xFF;
            ++i;
        }
        return ret;
    }

    public synchronized void setProperties(Hashtable props) {
        this.properties = props;
    }
}

