/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.util;

import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.prng.MDGenerator;
import java.util.HashMap;

public class PRNG {
    private IRandom delegate;

    private PRNG(IRandom delegate) {
        this.delegate = delegate;
    }

    public static final PRNG getInstance() {
        MDGenerator delegate = new MDGenerator();
        try {
            HashMap<String, byte[]> map = new HashMap<String, byte[]>();
            long t = System.currentTimeMillis();
            byte[] seed = new byte[]{(byte)(t >>> 56), (byte)(t >>> 48), (byte)(t >>> 40), (byte)(t >>> 32), (byte)(t >>> 24), (byte)(t >>> 16), (byte)(t >>> 8), (byte)t};
            map.put("gnu.crypto.prng.md.seed", seed);
            delegate.init(map);
        }
        catch (Exception x) {
            throw new ExceptionInInitializerError(x);
        }
        return new PRNG(delegate);
    }

    public void nextBytes(byte[] buffer) {
        this.nextBytes(buffer, 0, buffer.length);
    }

    public void nextBytes(byte[] buffer, int offset, int length) {
        try {
            this.delegate.nextBytes(buffer, offset, length);
        }
        catch (LimitReachedException limitReachedException) {
            try {
                HashMap<String, byte[]> map = new HashMap<String, byte[]>();
                long t = System.currentTimeMillis();
                byte[] seed = new byte[]{(byte)(t >>> 56), (byte)(t >>> 48), (byte)(t >>> 40), (byte)(t >>> 32), (byte)(t >>> 24), (byte)(t >>> 16), (byte)(t >>> 8), (byte)t};
                map.put("gnu.crypto.prng.md.seed", seed);
                this.delegate.init(map);
                this.delegate.nextBytes(buffer, offset, length);
            }
            catch (Exception y) {
                throw new ExceptionInInitializerError(y);
            }
        }
    }
}

