/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.ServerKeyExchangeParams;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ServerDHParams
implements Builder,
ServerKeyExchangeParams {
    private final ByteBuffer buffer;

    public ServerDHParams(ByteBuffer buffer) {
        this.buffer = buffer.duplicate().order(ByteOrder.BIG_ENDIAN);
    }

    public ServerDHParams(BigInteger p, BigInteger g, BigInteger y) {
        byte[] p_bytes = p.toByteArray();
        byte[] g_bytes = g.toByteArray();
        byte[] y_bytes = y.toByteArray();
        int len = p_bytes.length + g_bytes.length + y_bytes.length + 6;
        int p_off = 0;
        if (p_bytes[0] == 0) {
            p_off = 1;
            --len;
        }
        int g_off = 0;
        if (g_bytes[0] == 0) {
            g_off = 1;
            --len;
        }
        int y_off = 0;
        if (y_bytes[0] == 0) {
            y_off = 1;
            --len;
        }
        int p_len = p_bytes.length - p_off;
        int g_len = g_bytes.length - g_off;
        int y_len = y_bytes.length - y_off;
        this.buffer = ByteBuffer.allocate(len);
        this.buffer.putShort((short)p_len);
        this.buffer.put(p_bytes, p_off, p_len);
        this.buffer.putShort((short)g_len);
        this.buffer.put(g_bytes, g_off, g_len);
        this.buffer.putShort((short)y_len);
        this.buffer.put(y_bytes, y_off, y_len);
    }

    @Deprecated
    public KeyExchangeAlgorithm algorithm() {
        return null;
    }

    public int length() {
        int offset1 = this.buffer.getShort(0) & 0xFFFF;
        int offset2 = this.buffer.getShort(offset1 + 2) & 0xFFFF;
        return (this.buffer.getShort(offset1 + offset2 + 4) & 0xFFFF) + offset1 + offset2 + 6;
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().position(0).limit(this.length());
    }

    public BigInteger p() {
        int len = this.buffer.getShort(0) & 0xFFFF;
        byte[] buf = new byte[len];
        this.buffer.position(2);
        this.buffer.get(buf);
        return new BigInteger(1, buf);
    }

    public BigInteger g() {
        int off = (this.buffer.getShort(0) & 0xFFFF) + 2;
        int len = this.buffer.getShort(off) & 0xFFFF;
        byte[] buf = new byte[len];
        this.buffer.position(off + 2);
        this.buffer.get(buf);
        return new BigInteger(1, buf);
    }

    public BigInteger y() {
        int offset1 = (this.buffer.getShort(0) & 0xFFFF) + 2;
        int offset2 = (this.buffer.getShort(offset1) & 0xFFFF) + offset1 + 2;
        int len = this.buffer.getShort(offset2) & 0xFFFF;
        byte[] buf = new byte[len];
        this.buffer.position(offset2 + 2);
        this.buffer.get(buf);
        return new BigInteger(1, buf);
    }

    public void setP(BigInteger p) {
        byte[] buf = p.toByteArray();
        int length = buf[0] == 0 ? buf.length - 1 : buf.length;
        int offset = buf[0] == 0 ? 1 : 0;
        this.buffer.putShort(0, (short)length);
        this.buffer.position(2);
        this.buffer.put(buf, offset, length);
    }

    public void setG(BigInteger g) {
        byte[] buf = g.toByteArray();
        int length = buf[0] == 0 ? buf.length - 1 : buf.length;
        int offset = buf[0] == 0 ? 1 : 0;
        int where = (this.buffer.getShort(0) & 0xFFFF) + 2;
        this.buffer.putShort(where, (short)length);
        this.buffer.position(where + 2);
        this.buffer.put(buf, offset, length);
    }

    public void setY(BigInteger y) {
        int offset1 = (this.buffer.getShort(0) & 0xFFFF) + 2;
        int offset2 = (this.buffer.getShort(offset1) & 0xFFFF) + offset1 + 2;
        byte[] buf = y.toByteArray();
        int length = buf[0] == 0 ? buf.length - 1 : buf.length;
        int offset = buf[0] == 0 ? 1 : 0;
        this.buffer.putShort(offset2, (short)length);
        this.buffer.position(offset2 + 2);
        this.buffer.put(buf, offset, length);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  dh_p:  ");
        out.println(this.p().toString(16));
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  dh_g:  ");
        out.println(this.g().toString(16));
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  dh_Ys: ");
        out.println(this.y().toString(16));
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} ServerDHParams;");
        return str.toString();
    }
}

