/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;

public class CheckedInputStream
extends FilterInputStream {
    private Checksum sum;

    public CheckedInputStream(InputStream in, Checksum sum) {
        super(in);
        this.sum = sum;
    }

    public Checksum getChecksum() {
        return this.sum;
    }

    public int read() throws IOException {
        int x = this.in.read();
        if (x != -1) {
            this.sum.update(x);
        }
        return x;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int r = this.in.read(buf, off, len);
        if (r != -1) {
            this.sum.update(buf, off, r);
        }
        return r;
    }

    public long skip(long n) throws IOException {
        if (n == 0L) {
            return 0L;
        }
        int min = (int)Math.min(n, 1024L);
        byte[] buf = new byte[min];
        long s = 0L;
        while (n > 0L) {
            int r = this.in.read(buf, 0, min);
            if (r == -1) break;
            s += (long)r;
            min = (int)Math.min(n -= (long)r, 1024L);
            this.sum.update(buf, 0, r);
        }
        return s;
    }
}

