#!/bin/sh
export PATH='/usr/obj/ports/hs-scientific-0.3.4.6/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: scientific
version: 0.3.4.6
id: scientific-0.3.4.6-JWnrWS98ixeAp8KdIqhPYx
key: scientific-0.3.4.6-JWnrWS98ixeAp8KdIqhPYx
license: BSD3
maintainer: Bas van Dijk <v.dijk.bas@gmail.com>
homepage: https://github.com/basvandijk/scientific
synopsis: Numbers represented using scientific notation
description:
    @Data.Scientific@ provides the number type '\''Scientific'\''. Scientific numbers are
    arbitrary precision and space efficient. They are represented using
    <http://en.wikipedia.org/wiki/Scientific_notation scientific notation>.
    The implementation uses a coefficient @c :: '\''Integer'\''@ and a base-10 exponent
    @e :: '\''Int'\''@. A scientific number corresponds to the
    '\''Fractional'\'' number: @'\''fromInteger'\'' c * 10 '\''^^'\'' e@.
    .
    Note that since we'\''re using an '\''Int'\'' to represent the exponent these numbers
    aren'\''t truly arbitrary precision. I intend to change the type of the exponent
    to '\''Integer'\'' in a future release.
    .
    The main application of '\''Scientific'\'' is to be used as the target of parsing
    arbitrary precision numbers coming from an untrusted source. The advantages
    over using '\''Rational'\'' for this are that:
    .
    * A '\''Scientific'\'' is more efficient to construct. Rational numbers need to be
    constructed using '\''%'\'' which has to compute the '\''gcd'\'' of the '\''numerator'\'' and
    '\''denominator'\''.
    .
    * '\''Scientific'\'' is safe against numbers with huge exponents. For example:
    @1e1000000000 :: '\''Rational'\''@ will fill up all space and crash your
    program. Scientific works as expected:
    .
    > > read "1e1000000000" :: Scientific
    > 1.0e1000000000
    .
    * Also, the space usage of converting scientific numbers with huge exponents to
    @'\''Integral'\''s@ (like: '\''Int'\'') or @'\''RealFloat'\''s@ (like: '\''Double'\'' or '\''Float'\'')
    will always be bounded by the target type.
category: Data
author: Bas van Dijk
exposed: True
indefinite: False
exposed-modules:
    Data.ByteString.Builder.Scientific Data.Scientific
    Data.Text.Lazy.Builder.Scientific
hidden-modules: Math.NumberTheory.Logarithms
                GHC.Integer.Logarithms.Compat GHC.Integer.Compat Utils
abi: c3bc8910ee93da066ec4523f5fa3bfd0
trusted: False
import-dirs: /usr/local/lib/ghc/scientific-0.3.4.6
library-dirs: /usr/local/lib/ghc/scientific-0.3.4.6
              /usr/local/lib/i386-openbsd-ghc-8.2.2
data-dir: /usr/local/share/hs-scientific-0.3.4.6
hs-libraries: HSscientific-0.3.4.6-JWnrWS98ixeAp8KdIqhPYx
depends:
    base-4.10.1.0 ghc-prim-0.5.1.1 deepseq-1.4.3.0
    text-1.2.1.3-5I6D6Lq0QEU97eY5wqs6DJ
    hashable-1.2.6.1-43aRZ47jOxKDNgwLEE5ins
    vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4 containers-0.5.10.2
    binary-0.8.5.1 integer-gmp-1.0.1.0 bytestring-0.10.8.2
abi-depends: base-4.10.1.0=3c10740f6cf9df7b9dca6d01ba411ea7
             ghc-prim-0.5.1.1=84323a6edd008b04bf217464a4ccaf16
             deepseq-1.4.3.0=a3192b565ae21910ed279f609cad2bc5
             text-1.2.1.3-5I6D6Lq0QEU97eY5wqs6DJ=77e10b579708f506156fd8ed84f18afc
             hashable-1.2.6.1-43aRZ47jOxKDNgwLEE5ins=66bea76bebf9ad48bf13bb6c3bd232ce
             vector-0.12.0.1-IUGn3M9mkBh8CyXcBnfTR4=e7e504497bf3603a09d1b2efc5f2260c
             containers-0.5.10.2=2ff387bb382d9f510ffcf8f3ed2013c5
             binary-0.8.5.1=142c3e2dbe8d996b6fd2914d8ad787d1
             integer-gmp-1.0.1.0=7d948c9c98bb9ecc021f32964406f9ad
             bytestring-0.10.8.2=2a4bbfd60b4f148922e8caf44d9009f9
haddock-interfaces: /usr/local/share/doc/hs-scientific-0.3.4.6/html/scientific.haddock
haddock-html: /usr/local/share/doc/hs-scientific-0.3.4.6/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"

