/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.deobf;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;

public class PackageNode {
    private static final char SEPARATOR_CHAR = '.';
    private PackageNode parentPackage;
    private List<PackageNode> innerPackages = Collections.emptyList();
    private final String packageName;
    private String packageAlias;
    private String cachedPackageFullName;
    private String cachedPackageFullAlias;

    public PackageNode(String packageName) {
        this.packageName = packageName;
        this.parentPackage = this;
    }

    public String getName() {
        return this.packageName;
    }

    public String getFullName() {
        if (this.cachedPackageFullName == null) {
            Deque<PackageNode> pp = this.getParentPackages();
            StringBuilder result = new StringBuilder();
            result.append(pp.pop().getName());
            while (!pp.isEmpty()) {
                result.append('.');
                result.append(pp.pop().getName());
            }
            this.cachedPackageFullName = result.toString();
        }
        return this.cachedPackageFullName;
    }

    public String getAlias() {
        if (this.packageAlias != null) {
            return this.packageAlias;
        }
        return this.packageName;
    }

    public void setAlias(String alias) {
        this.packageAlias = alias;
    }

    public boolean hasAlias() {
        return this.packageAlias != null;
    }

    public String getFullAlias() {
        if (this.cachedPackageFullAlias == null) {
            Deque<PackageNode> pp = this.getParentPackages();
            StringBuilder result = new StringBuilder();
            if (!pp.isEmpty()) {
                result.append(pp.pop().getAlias());
                while (!pp.isEmpty()) {
                    result.append('.');
                    result.append(pp.pop().getAlias());
                }
            } else {
                result.append(this.getAlias());
            }
            this.cachedPackageFullAlias = result.toString();
        }
        return this.cachedPackageFullAlias;
    }

    public PackageNode getParentPackage() {
        return this.parentPackage;
    }

    public List<PackageNode> getInnerPackages() {
        return this.innerPackages;
    }

    public void addInnerPackage(PackageNode pkg) {
        if (this.innerPackages.isEmpty()) {
            this.innerPackages = new ArrayList<PackageNode>();
        }
        this.innerPackages.add(pkg);
        pkg.parentPackage = this;
    }

    public PackageNode getInnerPackageByName(String name) {
        PackageNode result = null;
        for (PackageNode p : this.innerPackages) {
            if (!p.getName().equals(name)) continue;
            result = p;
            break;
        }
        return result;
    }

    private Deque<PackageNode> getParentPackages() {
        ArrayDeque<PackageNode> pp = new ArrayDeque<PackageNode>();
        PackageNode currentPkg = this;
        PackageNode parentPkg = currentPkg.getParentPackage();
        while (currentPkg != parentPkg) {
            pp.push(currentPkg);
            currentPkg = parentPkg;
            parentPkg = currentPkg.getParentPackage();
        }
        return pp;
    }
}

