/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.utils.OverlayIcon;
import java.awt.Font;
import java.io.InputStream;
import java.net.URL;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    private static final ImageIcon ICON_STATIC = Utils.openIcon("static_co");
    private static final ImageIcon ICON_FINAL = Utils.openIcon("final_co");
    private static final ImageIcon ICON_ABSTRACT = Utils.openIcon("abstract_co");
    private static final ImageIcon ICON_NATIVE = Utils.openIcon("native_co");
    public static final Font FONT_HACK = Utils.openFontTTF("Hack-Regular");

    private Utils() {
    }

    public static ImageIcon openIcon(String name) {
        String iconPath = "/icons-16/" + name + ".png";
        URL resource = Utils.class.getResource(iconPath);
        if (resource == null) {
            throw new JadxRuntimeException("Icon not found: " + iconPath);
        }
        return new ImageIcon(resource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Font openFontTTF(String name) {
        String fontPath = "/fonts/" + name + ".ttf";
        try (InputStream is = Utils.class.getResourceAsStream(fontPath);){
            Font font2 = Font.createFont(0, is);
            Font font = font2.deriveFont(12.0f);
            return font;
        }
        catch (Exception e) {
            LOG.error("Failed load font by path: {}", (Object)fontPath, (Object)e);
            return null;
        }
    }

    public static void addKeyBinding(JComponent comp, KeyStroke key, String id, Action action) {
        comp.getInputMap().put(key, id);
        comp.getActionMap().put(id, action);
    }

    public static String typeFormat(String name, ArgType type) {
        return "<html><body><nobr>" + name + "<span style='color:#888888;'> : " + Utils.typeStr(type) + "</span></nobr></body></html>";
    }

    public static String typeStr(ArgType type) {
        if (type == null) {
            return "null";
        }
        if (type.isObject()) {
            String cls = type.getObject();
            int dot = cls.lastIndexOf(46);
            if (dot != -1) {
                return cls.substring(dot + 1);
            }
            return cls;
        }
        if (type.isArray()) {
            return Utils.typeStr(type.getArrayElement()) + "[]";
        }
        return type.toString();
    }

    public static OverlayIcon makeIcon(AccessInfo af, Icon pub, Icon pri, Icon pro, Icon def) {
        Icon icon = af.isPublic() ? pub : (af.isPrivate() ? pri : (af.isProtected() ? pro : def));
        OverlayIcon overIcon = new OverlayIcon(icon);
        if (af.isFinal()) {
            overIcon.add(ICON_FINAL);
        }
        if (af.isStatic()) {
            overIcon.add(ICON_STATIC);
        }
        if (af.isAbstract()) {
            overIcon.add(ICON_ABSTRACT);
        }
        if (af.isNative()) {
            overIcon.add(ICON_NATIVE);
        }
        return overIcon;
    }

    public static boolean isFreeMemoryAvailable() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long totalFree = runtime.freeMemory() + maxMemory - runtime.totalMemory();
        return (double)totalFree > (double)maxMemory * 0.2;
    }

    public static String memoryInfo() {
        Runtime runtime = Runtime.getRuntime();
        StringBuilder sb = new StringBuilder();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        sb.append("heap: ").append(Utils.format(allocatedMemory - freeMemory));
        sb.append(", allocated: ").append(Utils.format(allocatedMemory));
        sb.append(", free: ").append(Utils.format(freeMemory));
        sb.append(", total free: ").append(Utils.format(freeMemory + maxMemory - allocatedMemory));
        sb.append(", max: ").append(Utils.format(maxMemory));
        return sb.toString();
    }

    private static String format(long mem) {
        return Long.toString((long)((double)mem / 1024.0 / 1024.0)) + "MB";
    }

    public static char caseChar(char ch, boolean toLower) {
        return toLower ? Character.toLowerCase(ch) : ch;
    }
}

