/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.classfile.attribute.Annotation;
import jd.core.model.classfile.attribute.Attribute;
import jd.core.model.classfile.attribute.AttributeRuntimeAnnotations;
import jd.core.model.classfile.attribute.AttributeRuntimeParameterAnnotations;
import jd.core.model.classfile.attribute.AttributeSignature;
import jd.core.model.classfile.attribute.CodeException;
import jd.core.model.classfile.attribute.ElementValue;
import jd.core.model.classfile.attribute.ElementValueAnnotationValue;
import jd.core.model.classfile.attribute.ElementValueArrayValue;
import jd.core.model.classfile.attribute.ElementValueClassInfo;
import jd.core.model.classfile.attribute.ElementValueEnumConstValue;
import jd.core.model.classfile.attribute.ElementValuePair;
import jd.core.model.classfile.attribute.ParameterAnnotations;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.reference.Reference;
import jd.core.model.reference.ReferenceMap;
import jd.core.process.analyzer.classfile.SignatureAnalyzer;
import jd.core.process.analyzer.classfile.visitor.ReferenceVisitor;

public class ReferenceAnalyzer {
    public static void Analyze(ReferenceMap referenceMap, ClassFile classFile) {
        ReferenceAnalyzer.CountReferences(referenceMap, classFile);
        ReferenceAnalyzer.ReduceReferences(referenceMap, classFile);
    }

    private static void CountReferences(ReferenceMap referenceMap, ClassFile classFile) {
        int i;
        referenceMap.add(classFile.getThisClassName());
        AttributeSignature as = classFile.getAttributeSignature();
        if (as == null) {
            int[] interfaces;
            if (classFile.getSuperClassIndex() != 0) {
                referenceMap.add(classFile.getSuperClassName());
            }
            if ((interfaces = classFile.getInterfaces()) != null) {
                i = interfaces.length - 1;
                while (i >= 0) {
                    String internalInterfaceName = classFile.getConstantPool().getConstantClassName(interfaces[i]);
                    referenceMap.add(internalInterfaceName);
                    --i;
                }
            }
        } else {
            String signature = classFile.getConstantPool().getConstantUtf8(as.signature_index);
            SignatureAnalyzer.AnalyzeClassSignature(referenceMap, signature);
        }
        ReferenceAnalyzer.CountReferencesInAttributes(referenceMap, classFile.getConstantPool(), classFile.getAttributes());
        ArrayList<ClassFile> innerClassFiles = classFile.getInnerClassFiles();
        if (innerClassFiles != null) {
            i = innerClassFiles.size() - 1;
            while (i >= 0) {
                ReferenceAnalyzer.CountReferences(referenceMap, innerClassFiles.get(i));
                --i;
            }
        }
        ReferenceVisitor visitor = new ReferenceVisitor(classFile.getConstantPool(), referenceMap);
        ReferenceAnalyzer.CountReferencesInFields(referenceMap, visitor, classFile);
        ReferenceAnalyzer.CountReferencesInMethods(referenceMap, visitor, classFile);
    }

    private static void CountReferencesInAttributes(ReferenceMap referenceMap, ConstantPool constants, Attribute[] attributes) {
        if (attributes != null) {
            int i = attributes.length - 1;
            while (i >= 0) {
                switch (attributes[i].tag) {
                    case 16: 
                    case 17: {
                        Annotation[] annotations = ((AttributeRuntimeAnnotations)attributes[i]).annotations;
                        int j = annotations.length - 1;
                        while (j >= 0) {
                            ReferenceAnalyzer.CountAnnotationReference(referenceMap, constants, annotations[j]);
                            --j;
                        }
                        break;
                    }
                    case 18: 
                    case 19: {
                        ParameterAnnotations[] parameterAnnotations = ((AttributeRuntimeParameterAnnotations)attributes[i]).parameter_annotations;
                        ReferenceAnalyzer.CountParameterAnnotationsReference(referenceMap, constants, parameterAnnotations);
                    }
                }
                --i;
            }
        }
    }

    private static void CountAnnotationReference(ReferenceMap referenceMap, ConstantPool constants, Annotation annotation) {
        String typeName = constants.getConstantUtf8(annotation.type_index);
        SignatureAnalyzer.AnalyzeSimpleSignature(referenceMap, typeName);
        ElementValuePair[] elementValuePairs = annotation.elementValuePairs;
        if (elementValuePairs != null) {
            int j = elementValuePairs.length - 1;
            while (j >= 0) {
                ReferenceAnalyzer.CountElementValue(referenceMap, constants, elementValuePairs[j].element_value);
                --j;
            }
        }
    }

    private static void CountParameterAnnotationsReference(ReferenceMap referenceMap, ConstantPool constants, ParameterAnnotations[] parameterAnnotations) {
        if (parameterAnnotations != null) {
            int i = parameterAnnotations.length - 1;
            while (i >= 0) {
                Annotation[] annotations = parameterAnnotations[i].annotations;
                if (annotations != null) {
                    int j = annotations.length - 1;
                    while (j >= 0) {
                        ReferenceAnalyzer.CountAnnotationReference(referenceMap, constants, annotations[j]);
                        --j;
                    }
                }
                --i;
            }
        }
    }

    private static void CountElementValue(ReferenceMap referenceMap, ConstantPool constants, ElementValue ev) {
        switch (ev.tag) {
            case 3: {
                ElementValueClassInfo evci = (ElementValueClassInfo)ev;
                String signature = constants.getConstantUtf8(evci.class_info_index);
                SignatureAnalyzer.AnalyzeSimpleSignature(referenceMap, signature);
                break;
            }
            case 4: {
                ElementValueAnnotationValue evanv = (ElementValueAnnotationValue)ev;
                ReferenceAnalyzer.CountAnnotationReference(referenceMap, constants, evanv.annotation_value);
                break;
            }
            case 5: {
                ElementValueArrayValue evarv = (ElementValueArrayValue)ev;
                ElementValue[] values = evarv.values;
                if (values == null) break;
                int i = values.length - 1;
                while (i >= 0) {
                    if (values[i].tag == 3) {
                        ElementValueClassInfo evci = (ElementValueClassInfo)values[i];
                        String signature = constants.getConstantUtf8(evci.class_info_index);
                        SignatureAnalyzer.AnalyzeSimpleSignature(referenceMap, signature);
                    }
                    --i;
                }
                break;
            }
            case 2: {
                ElementValueEnumConstValue evecv = (ElementValueEnumConstValue)ev;
                String signature = constants.getConstantUtf8(evecv.type_name_index);
                SignatureAnalyzer.AnalyzeSimpleSignature(referenceMap, signature);
            }
        }
    }

    private static void CountReferencesInFields(ReferenceMap referenceMap, ReferenceVisitor visitor, ClassFile classFile) {
        Field[] fields = classFile.getFields();
        if (fields == null) {
            return;
        }
        int i = fields.length - 1;
        while (i >= 0) {
            Field field = fields[i];
            if ((field.access_flags & 0x1000) == 0) {
                ReferenceAnalyzer.CountReferencesInAttributes(referenceMap, classFile.getConstantPool(), field.getAttributes());
                AttributeSignature as = field.getAttributeSignature();
                String signature = classFile.getConstantPool().getConstantUtf8(as == null ? field.descriptor_index : as.signature_index);
                SignatureAnalyzer.AnalyzeSimpleSignature(referenceMap, signature);
                if (field.getValueAndMethod() != null) {
                    visitor.visit(field.getValueAndMethod().getValue());
                }
            }
            --i;
        }
    }

    private static void CountReferencesInMethods(ReferenceMap referenceMap, ReferenceVisitor visitor, ClassFile classFile) {
        Method[] methods = classFile.getMethods();
        if (methods == null) {
            return;
        }
        ConstantPool constants = classFile.getConstantPool();
        int i = methods.length - 1;
        while (i >= 0) {
            Method method = methods[i];
            if ((method.access_flags & 0x1040) == 0 && !method.containsError()) {
                CodeException[] codeExceptions;
                LocalVariables localVariables;
                ElementValue defaultAnnotationValue;
                ReferenceAnalyzer.CountReferencesInAttributes(referenceMap, classFile.getConstantPool(), method.getAttributes());
                AttributeSignature as = method.getAttributeSignature();
                String signature = constants.getConstantUtf8(as == null ? method.descriptor_index : as.signature_index);
                SignatureAnalyzer.AnalyzeMethodSignature(referenceMap, signature);
                int[] exceptionIndexes = method.getExceptionIndexes();
                if (exceptionIndexes != null) {
                    int j = exceptionIndexes.length - 1;
                    while (j >= 0) {
                        referenceMap.add(constants.getConstantClassName(exceptionIndexes[j]));
                        --j;
                    }
                }
                if ((defaultAnnotationValue = method.getDefaultAnnotationValue()) != null) {
                    ReferenceAnalyzer.CountElementValue(referenceMap, constants, defaultAnnotationValue);
                }
                if ((localVariables = method.getLocalVariables()) != null) {
                    ReferenceAnalyzer.CountReferencesInLocalVariables(referenceMap, constants, localVariables);
                }
                if ((codeExceptions = method.getCodeExceptions()) != null) {
                    ReferenceAnalyzer.CountReferencesInCodeExceptions(referenceMap, constants, codeExceptions);
                }
                ReferenceAnalyzer.CountReferencesInCode(visitor, method);
            }
            --i;
        }
    }

    private static void CountReferencesInLocalVariables(ReferenceMap referenceMap, ConstantPool constants, LocalVariables localVariables) {
        int i = localVariables.size() - 1;
        while (i >= 0) {
            LocalVariable lv = localVariables.getLocalVariableAt(i);
            if (lv != null && lv.signature_index > 0) {
                String signature = constants.getConstantUtf8(lv.signature_index);
                SignatureAnalyzer.AnalyzeSimpleSignature(referenceMap, signature);
            }
            --i;
        }
    }

    private static void CountReferencesInCodeExceptions(ReferenceMap referenceMap, ConstantPool constants, CodeException[] codeExceptions) {
        int i = codeExceptions.length - 1;
        while (i >= 0) {
            CodeException ce = codeExceptions[i];
            if (ce.catch_type != 0) {
                String internalClassName = constants.getConstantClassName(ce.catch_type);
                referenceMap.add(internalClassName);
            }
            --i;
        }
    }

    private static void CountReferencesInCode(ReferenceVisitor visitor, Method method) {
        List<Instruction> instructions = method.getFastNodes();
        if (instructions != null) {
            int i = instructions.size() - 1;
            while (i >= 0) {
                visitor.visit(instructions.get(i));
                --i;
            }
        }
    }

    private static void ReduceReferences(ReferenceMap referenceMap, ClassFile classFile) {
        int index;
        String internalName;
        HashMap<String, Boolean> multipleInternalClassName = new HashMap<String, Boolean>();
        for (Reference reference : referenceMap.values()) {
            String internalClassName;
            internalName = reference.getInternalName();
            index = internalName.lastIndexOf(47);
            String string = internalClassName = index != -1 ? internalName.substring(index + 1) : internalName;
            if (multipleInternalClassName.containsKey(internalClassName)) {
                multipleInternalClassName.put(internalClassName, Boolean.TRUE);
                continue;
            }
            multipleInternalClassName.put(internalClassName, Boolean.FALSE);
        }
        Iterator<Reference> iterator = referenceMap.values().iterator();
        while (iterator.hasNext()) {
            String internalClassName;
            String internalPackageName;
            Reference reference;
            reference = iterator.next();
            internalName = reference.getInternalName();
            index = internalName.lastIndexOf(47);
            if (index != -1) {
                internalPackageName = internalName.substring(0, index);
                internalClassName = internalName.substring(index + 1);
            } else {
                internalPackageName = "";
                internalClassName = internalName;
            }
            String internalPackageName_className = String.valueOf(classFile.getInternalPackageName()) + '/' + internalClassName;
            if (!classFile.getInternalPackageName().equals(internalPackageName) && ((Boolean)multipleInternalClassName.get(internalClassName)).booleanValue()) {
                iterator.remove();
                continue;
            }
            if (!referenceMap.contains(internalPackageName_className)) continue;
            iterator.remove();
        }
    }
}

