/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceOuterReferenceVisitor {
    private int opcode;
    private int index;
    private int outerThisInstructionIndex;

    public ReplaceOuterReferenceVisitor(int opcode, int index, int outerThisInstructionIndex) {
        this.opcode = opcode;
        this.index = index;
        this.outerThisInstructionIndex = outerThisInstructionIndex;
    }

    public void init(int opcode, int index) {
        this.opcode = opcode;
        this.index = index;
    }

    public void visit(Instruction instruction) {
        switch (instruction.opcode) {
            case 190: {
                ArrayLength al = (ArrayLength)instruction;
                if (this.match(al.arrayref)) {
                    al.arrayref = this.newInstruction(al.arrayref);
                    break;
                }
                this.visit(al.arrayref);
                break;
            }
            case 83: 
            case 272: {
                ArrayStoreInstruction asi = (ArrayStoreInstruction)instruction;
                if (this.match(asi.arrayref)) {
                    asi.arrayref = this.newInstruction(asi.arrayref);
                } else {
                    this.visit(asi.arrayref);
                }
                if (this.match(asi.indexref)) {
                    asi.indexref = this.newInstruction(asi.indexref);
                } else {
                    this.visit(asi.indexref);
                }
                if (this.match(asi.valueref)) {
                    asi.valueref = this.newInstruction(asi.valueref);
                    break;
                }
                this.visit(asi.valueref);
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                if (this.match(ai.test)) {
                    ai.test = this.newInstruction(ai.test);
                } else {
                    this.visit(ai.test);
                }
                if (ai.msg == null) break;
                if (this.match(ai.msg)) {
                    ai.msg = this.newInstruction(ai.msg);
                    break;
                }
                this.visit(ai.msg);
                break;
            }
            case 191: {
                AThrow aThrow = (AThrow)instruction;
                if (this.match(aThrow.value)) {
                    aThrow.value = this.newInstruction(aThrow.value);
                    break;
                }
                this.visit(aThrow.value);
                break;
            }
            case 266: {
                UnaryOperatorInstruction uoi = (UnaryOperatorInstruction)instruction;
                if (this.match(uoi.value)) {
                    uoi.value = this.newInstruction(uoi.value);
                    break;
                }
                this.visit(uoi.value);
                break;
            }
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                if (this.match(boi.value1)) {
                    boi.value1 = this.newInstruction(boi.value1);
                } else {
                    this.visit(boi.value1);
                }
                if (this.match(boi.value2)) {
                    boi.value2 = this.newInstruction(boi.value2);
                    break;
                }
                this.visit(boi.value2);
                break;
            }
            case 192: {
                CheckCast checkCast = (CheckCast)instruction;
                if (this.match(checkCast.objectref)) {
                    checkCast.objectref = this.newInstruction(checkCast.objectref);
                    break;
                }
                this.visit(checkCast.objectref);
                break;
            }
            case 54: 
            case 58: 
            case 269: {
                StoreInstruction storeInstruction = (StoreInstruction)instruction;
                if (this.match(storeInstruction.valueref)) {
                    storeInstruction.valueref = this.newInstruction(storeInstruction.valueref);
                    break;
                }
                this.visit(storeInstruction.valueref);
                break;
            }
            case 264: {
                DupStore dupStore = (DupStore)instruction;
                if (this.match(dupStore.objectref)) {
                    dupStore.objectref = this.newInstruction(dupStore.objectref);
                    break;
                }
                this.visit(dupStore.objectref);
                break;
            }
            case 275: 
            case 276: {
                ConvertInstruction ci = (ConvertInstruction)instruction;
                if (this.match(ci.value)) {
                    ci.value = this.newInstruction(ci.value);
                    break;
                }
                this.visit(ci.value);
                break;
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                if (this.match(ifCmp.value1)) {
                    ifCmp.value1 = this.newInstruction(ifCmp.value1);
                } else {
                    this.visit(ifCmp.value1);
                }
                if (this.match(ifCmp.value2)) {
                    ifCmp.value2 = this.newInstruction(ifCmp.value2);
                    break;
                }
                this.visit(ifCmp.value2);
                break;
            }
            case 260: 
            case 262: {
                IfInstruction iff = (IfInstruction)instruction;
                if (this.match(iff.value)) {
                    iff.value = this.newInstruction(iff.value);
                    break;
                }
                this.visit(iff.value);
                break;
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).instructions;
                int i = branchList.size() - 1;
                while (i >= 0) {
                    this.visit(branchList.get(i));
                    --i;
                }
                break;
            }
            case 193: {
                InstanceOf instanceOf = (InstanceOf)instruction;
                if (this.match(instanceOf.objectref)) {
                    instanceOf.objectref = this.newInstruction(instanceOf.objectref);
                    break;
                }
                this.visit(instanceOf.objectref);
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                InvokeNoStaticInstruction insi = (InvokeNoStaticInstruction)instruction;
                if (this.match(insi.objectref)) {
                    insi.objectref = this.newInstruction(insi.objectref);
                } else {
                    this.visit(insi.objectref);
                }
            }
            case 184: 
            case 274: {
                List<Instruction> list = ((InvokeInstruction)instruction).args;
                int i = list.size() - 1;
                while (i >= 0) {
                    if (this.match(list.get(i))) {
                        list.set(i, this.newInstruction(list.get(i)));
                    } else {
                        this.visit(list.get(i));
                    }
                    --i;
                }
                break;
            }
            case 171: {
                LookupSwitch ls = (LookupSwitch)instruction;
                if (this.match(ls.key)) {
                    ls.key = this.newInstruction(ls.key);
                    break;
                }
                this.visit(ls.key);
                break;
            }
            case 194: {
                MonitorEnter monitorEnter = (MonitorEnter)instruction;
                if (this.match(monitorEnter.objectref)) {
                    monitorEnter.objectref = this.newInstruction(monitorEnter.objectref);
                    break;
                }
                this.visit(monitorEnter.objectref);
                break;
            }
            case 195: {
                MonitorExit monitorExit = (MonitorExit)instruction;
                if (this.match(monitorExit.objectref)) {
                    monitorExit.objectref = this.newInstruction(monitorExit.objectref);
                    break;
                }
                this.visit(monitorExit.objectref);
                break;
            }
            case 197: {
                Instruction[] dimensions = ((MultiANewArray)instruction).dimensions;
                int i = dimensions.length - 1;
                while (i >= 0) {
                    if (this.match(dimensions[i])) {
                        dimensions[i] = this.newInstruction(dimensions[i]);
                    } else {
                        this.visit(dimensions[i]);
                    }
                    --i;
                }
                break;
            }
            case 188: {
                NewArray newArray = (NewArray)instruction;
                if (this.match(newArray.dimension)) {
                    newArray.dimension = this.newInstruction(newArray.dimension);
                    break;
                }
                this.visit(newArray.dimension);
                break;
            }
            case 189: {
                ANewArray aNewArray = (ANewArray)instruction;
                if (this.match(aNewArray.dimension)) {
                    aNewArray.dimension = this.newInstruction(aNewArray.dimension);
                    break;
                }
                this.visit(aNewArray.dimension);
                break;
            }
            case 87: {
                Pop pop = (Pop)instruction;
                if (this.match(pop.objectref)) {
                    pop.objectref = this.newInstruction(pop.objectref);
                    break;
                }
                this.visit(pop.objectref);
                break;
            }
            case 181: {
                PutField putField = (PutField)instruction;
                if (this.match(putField.objectref)) {
                    putField.objectref = this.newInstruction(putField.objectref);
                } else {
                    this.visit(putField.objectref);
                }
                if (this.match(putField.valueref)) {
                    putField.valueref = this.newInstruction(putField.valueref);
                    break;
                }
                this.visit(putField.valueref);
                break;
            }
            case 179: {
                PutStatic putStatic = (PutStatic)instruction;
                if (this.match(putStatic.valueref)) {
                    putStatic.valueref = this.newInstruction(putStatic.valueref);
                    break;
                }
                this.visit(putStatic.valueref);
                break;
            }
            case 273: {
                ReturnInstruction ri = (ReturnInstruction)instruction;
                if (this.match(ri.valueref)) {
                    ri.valueref = this.newInstruction(ri.valueref);
                    break;
                }
                this.visit(ri.valueref);
                break;
            }
            case 170: {
                TableSwitch ts = (TableSwitch)instruction;
                if (this.match(ts.key)) {
                    ts.key = this.newInstruction(ts.key);
                    break;
                }
                this.visit(ts.key);
                break;
            }
            case 280: {
                TernaryOpStore tos = (TernaryOpStore)instruction;
                if (this.match(tos.objectref)) {
                    tos.objectref = this.newInstruction(tos.objectref);
                    break;
                }
                this.visit(tos.objectref);
                break;
            }
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                if (this.match(to.test)) {
                    to.test = this.newInstruction(to.test);
                } else {
                    this.visit(to.test);
                }
                if (this.match(to.value1)) {
                    to.value1 = this.newInstruction(to.value1);
                } else {
                    this.visit(to.value1);
                }
                if (this.match(to.value2)) {
                    to.value2 = this.newInstruction(to.value2);
                    break;
                }
                this.visit(to.value2);
                break;
            }
            case 265: {
                AssignmentInstruction ai = (AssignmentInstruction)instruction;
                if (this.match(ai.value1)) {
                    ai.value1 = this.newInstruction(ai.value1);
                } else {
                    this.visit(ai.value1);
                }
                if (this.match(ai.value2)) {
                    ai.value2 = this.newInstruction(ai.value2);
                    break;
                }
                this.visit(ai.value2);
                break;
            }
            case 271: {
                ArrayLoadInstruction ali = (ArrayLoadInstruction)instruction;
                if (this.match(ali.arrayref)) {
                    ali.arrayref = this.newInstruction(ali.arrayref);
                } else {
                    this.visit(ali.arrayref);
                }
                if (this.match(ali.indexref)) {
                    ali.indexref = this.newInstruction(ali.indexref);
                    break;
                }
                this.visit(ali.indexref);
                break;
            }
            case 277: 
            case 278: {
                IncInstruction ii = (IncInstruction)instruction;
                if (this.match(ii.value)) {
                    ii.value = this.newInstruction(ii.value);
                    break;
                }
                this.visit(ii.value);
                break;
            }
            case 180: {
                GetField gf = (GetField)instruction;
                if (this.match(gf.objectref)) {
                    gf.objectref = this.newInstruction(gf.objectref);
                    break;
                }
                this.visit(gf.objectref);
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                if (this.match(iai.newArray)) {
                    iai.newArray = this.newInstruction(iai.newArray);
                } else {
                    this.visit(iai.newArray);
                }
                if (iai.values == null) break;
                this.visit(iai.values);
                break;
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 268: 
            case 270: 
            case 279: 
            case 285: {
                break;
            }
            default: {
                System.err.println("Can not replace DupLoad in " + instruction.getClass().getName() + ", opcode=" + instruction.opcode);
            }
        }
    }

    public void visit(List<Instruction> instructions) {
        int index = instructions.size() - 1;
        while (index >= 0) {
            Instruction i = instructions.get(index);
            if (this.match(i)) {
                instructions.set(index, this.newInstruction(i));
            } else {
                this.visit(i);
            }
            --index;
        }
    }

    private boolean match(Instruction i) {
        return i.opcode == this.opcode && ((IndexInstruction)i).index == this.index;
    }

    private Instruction newInstruction(Instruction i) {
        return new GetStatic(285, i.offset, i.lineNumber, this.outerThisInstructionIndex);
    }
}

