/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.type;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Type;
import org.jd.gui.service.type.AbstractTypeFactoryProvider;
import org.jd.gui.util.parser.antlr.ANTLRJavaParser;
import org.jd.gui.util.parser.antlr.AbstractJavaListener;
import org.jd.gui.util.parser.antlr.JavaParser;

public class JavaFileTypeFactoryProvider
extends AbstractTypeFactoryProvider {
    protected AbstractTypeFactoryProvider.Cache<URI, Listener> cache = new AbstractTypeFactoryProvider.Cache();

    @Override
    public String[] getSelectors() {
        List<String> externalSelectors = this.getExternalSelectors();
        if (externalSelectors == null) {
            return new String[]{"*:file:*.java"};
        }
        int size = externalSelectors.size();
        String[] selectors = new String[size + 1];
        externalSelectors.toArray(selectors);
        selectors[size] = "*:file:*.java";
        return selectors;
    }

    @Override
    public Collection<Type> make(API api, Container.Entry entry) {
        Listener listener = this.getListener(entry);
        if (listener == null) {
            return Collections.emptyList();
        }
        return listener.getRootTypes();
    }

    @Override
    public Type make(API api, Container.Entry entry, String fragment) {
        Listener listener = this.getListener(entry);
        if (listener == null) {
            return null;
        }
        if (fragment != null && fragment.length() > 0) {
            int index = fragment.indexOf(45);
            if (index != -1) {
                fragment = fragment.substring(0, index);
            }
            return listener.getType(fragment);
        }
        return listener.getMainType();
    }

    protected Listener getListener(Container.Entry entry) {
        Listener listener;
        URI key = entry.getUri();
        if (this.cache.containsKey(key)) {
            return (Listener)this.cache.get(key);
        }
        try (InputStream inputStream = entry.getInputStream();){
            listener = new Listener(entry);
            ANTLRJavaParser.parse(new ANTLRInputStream(inputStream), listener);
        }
        catch (IOException ignore) {
            listener = null;
        }
        this.cache.put(key, listener);
        return listener;
    }

    static {
        ANTLRJavaParser.parse(new ANTLRInputStream("class EarlyLoading{}"), new Listener(null));
    }

    protected static class Listener
    extends AbstractJavaListener {
        protected String displayPackageName = "";
        protected JavaType mainType = null;
        protected JavaType currentType = null;
        protected ArrayList<Type> rootTypes = new ArrayList();
        protected HashMap<String, Type> types = new HashMap();

        public Listener(Container.Entry entry) {
            super(entry);
        }

        public Type getMainType() {
            return this.mainType;
        }

        public Type getType(String typeName) {
            return this.types.get(typeName);
        }

        public ArrayList<Type> getRootTypes() {
            return this.rootTypes;
        }

        @Override
        public void enterPackageDeclaration(JavaParser.PackageDeclarationContext ctx) {
            super.enterPackageDeclaration(ctx);
            this.displayPackageName = this.packageName.replace('/', '.');
        }

        @Override
        public void enterClassDeclaration(JavaParser.ClassDeclarationContext ctx) {
            this.enterTypeDeclaration(ctx, 0);
        }

        @Override
        public void exitClassDeclaration(JavaParser.ClassDeclarationContext ctx) {
            this.exitTypeDeclaration();
        }

        @Override
        public void enterEnumDeclaration(JavaParser.EnumDeclarationContext ctx) {
            this.enterTypeDeclaration(ctx, 16384);
        }

        @Override
        public void exitEnumDeclaration(JavaParser.EnumDeclarationContext ctx) {
            this.exitTypeDeclaration();
        }

        @Override
        public void enterInterfaceDeclaration(JavaParser.InterfaceDeclarationContext ctx) {
            this.enterTypeDeclaration(ctx, 512);
        }

        @Override
        public void exitInterfaceDeclaration(JavaParser.InterfaceDeclarationContext ctx) {
            this.exitTypeDeclaration();
        }

        @Override
        public void enterAnnotationTypeDeclaration(JavaParser.AnnotationTypeDeclarationContext ctx) {
            this.enterTypeDeclaration(ctx, 8192);
        }

        @Override
        public void exitAnnotationTypeDeclaration(JavaParser.AnnotationTypeDeclarationContext ctx) {
            this.exitTypeDeclaration();
        }

        protected void enterTypeDeclaration(ParserRuleContext ctx, int access) {
            String name = ctx.getToken(100, 0).getText();
            JavaParser.TypeContext superType = ctx.getRuleContext(JavaParser.TypeContext.class, 0);
            String superQualifiedTypeName = superType == null ? ((access & 0x200) == 0 ? "java/lang/Object" : "") : this.resolveInternalTypeName(superType.classOrInterfaceType().Identifier());
            ParserRuleContext parent = ctx.getParent();
            if (parent instanceof JavaParser.TypeDeclarationContext) {
                access += this.getTypeDeclarationContextAccessFlag(parent);
            } else if (parent instanceof JavaParser.MemberDeclarationContext) {
                access += this.getMemberDeclarationContextAccessFlag(parent.getParent());
            }
            if (this.currentType == null) {
                String internalTypeName = this.packageName.isEmpty() ? name : this.packageName + "/" + name;
                String outerName = null;
                String displayTypeName = name;
                String displayInnerTypeName = null;
                this.currentType = new JavaType(access, internalTypeName, superQualifiedTypeName, outerName, displayTypeName, displayInnerTypeName, this.displayPackageName, null);
                this.types.put(internalTypeName, this.currentType);
                this.rootTypes.add(this.currentType);
                this.nameToInternalTypeName.put(name, internalTypeName);
                if (this.mainType == null) {
                    this.mainType = this.currentType;
                } else {
                    int index;
                    String path = this.entry.getPath();
                    if (path.substring(index = path.lastIndexOf(47) + 1).startsWith(name + '.')) {
                        this.mainType = this.currentType;
                    }
                }
            } else {
                String internalTypeName = this.currentType.getName() + '$' + name;
                String outerName = this.currentType.getName();
                String displayTypeName = this.currentType.getDisplayTypeName() + '.' + name;
                String displayInnerTypeName = name;
                JavaType subType = new JavaType(access, internalTypeName, superQualifiedTypeName, outerName, displayTypeName, displayInnerTypeName, this.displayPackageName, this.currentType);
                this.currentType.getInnerTypes().add(subType);
                this.currentType = subType;
                this.types.put(internalTypeName, this.currentType);
                this.nameToInternalTypeName.put(name, internalTypeName);
            }
        }

        protected void exitTypeDeclaration() {
            this.currentType = this.currentType.getOuterType();
        }

        @Override
        public void enterClassBodyDeclaration(JavaParser.ClassBodyDeclarationContext ctx) {
            ParseTree first;
            if (ctx.getChildCount() == 2 && (first = ctx.getChild(0)) instanceof TerminalNode && ((TerminalNode)first).getSymbol().getType() == 38) {
                this.currentType.getMethods().add(new JavaMethod(this.currentType, 8, "<clinit>", "()V"));
            }
        }

        @Override
        public void enterConstDeclaration(JavaParser.ConstDeclarationContext ctx) {
            JavaParser.TypeContext typeContext = ctx.type();
            int access = this.getClassBodyDeclarationAccessFlag(ctx.getParent().getParent());
            for (JavaParser.ConstantDeclaratorContext constantDeclaratorContext : ctx.constantDeclarator()) {
                TerminalNode identifier = constantDeclaratorContext.Identifier();
                String name = identifier.getText();
                int dimensionOnVariable = this.countDimension(constantDeclaratorContext.children);
                String descriptor = this.createDescriptor(typeContext, dimensionOnVariable);
                this.currentType.getFields().add(new JavaField(access, name, descriptor));
            }
        }

        @Override
        public void enterFieldDeclaration(JavaParser.FieldDeclarationContext ctx) {
            JavaParser.TypeContext typeContext = ctx.type();
            int access = this.getClassBodyDeclarationAccessFlag(ctx.getParent().getParent());
            for (JavaParser.VariableDeclaratorContext declaration : ctx.variableDeclarators().variableDeclarator()) {
                JavaParser.VariableDeclaratorIdContext variableDeclaratorId = declaration.variableDeclaratorId();
                TerminalNode identifier = variableDeclaratorId.Identifier();
                String name = identifier.getText();
                int dimensionOnVariable = this.countDimension(variableDeclaratorId.children);
                String descriptor = this.createDescriptor(typeContext, dimensionOnVariable);
                this.currentType.getFields().add(new JavaField(access, name, descriptor));
            }
        }

        @Override
        public void enterMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
            this.enterMethodDeclaration(ctx, ctx.Identifier(), ctx.formalParameters(), ctx.type());
        }

        @Override
        public void enterInterfaceMethodDeclaration(JavaParser.InterfaceMethodDeclarationContext ctx) {
            this.enterMethodDeclaration(ctx, ctx.Identifier(), ctx.formalParameters(), ctx.type());
        }

        public void enterMethodDeclaration(ParserRuleContext ctx, TerminalNode identifier, JavaParser.FormalParametersContext formalParameters, JavaParser.TypeContext returnType) {
            int access = this.getClassBodyDeclarationAccessFlag(ctx.getParent().getParent());
            String name = identifier.getText();
            String paramDescriptors = this.createParamDescriptors(formalParameters.formalParameterList());
            String returnDescriptor = this.createDescriptor(returnType, 0);
            String descriptor = paramDescriptors + returnDescriptor;
            this.currentType.getMethods().add(new JavaMethod(this.currentType, access, name, descriptor));
        }

        @Override
        public void enterConstructorDeclaration(JavaParser.ConstructorDeclarationContext ctx) {
            int access = this.getClassBodyDeclarationAccessFlag(ctx.getParent().getParent());
            String paramDescriptors = this.createParamDescriptors(ctx.formalParameters().formalParameterList());
            String descriptor = paramDescriptors + "V";
            this.currentType.getMethods().add(new JavaMethod(this.currentType, access, "<init>", descriptor));
        }

        protected String createParamDescriptors(JavaParser.FormalParameterListContext formalParameterList) {
            StringBuffer paramDescriptors = null;
            if (formalParameterList != null) {
                List<JavaParser.FormalParameterContext> formalParameters = formalParameterList.formalParameter();
                paramDescriptors = new StringBuffer("(");
                for (JavaParser.FormalParameterContext formalParameter : formalParameters) {
                    int dimensionOnParameter = this.countDimension(formalParameter.variableDeclaratorId().children);
                    paramDescriptors.append(this.createDescriptor(formalParameter.type(), dimensionOnParameter));
                }
            }
            return paramDescriptors == null ? "()" : paramDescriptors.append(')').toString();
        }

        protected int getTypeDeclarationContextAccessFlag(ParserRuleContext ctx) {
            int access = 0;
            for (JavaParser.ClassOrInterfaceModifierContext coiModifierContext : ctx.getRuleContexts(JavaParser.ClassOrInterfaceModifierContext.class)) {
                access += this.getAccessFlag(coiModifierContext);
            }
            return access;
        }

        protected int getMemberDeclarationContextAccessFlag(ParserRuleContext ctx) {
            int access = 0;
            for (JavaParser.ModifierContext modifierContext : ctx.getRuleContexts(JavaParser.ModifierContext.class)) {
                JavaParser.ClassOrInterfaceModifierContext coiModifierContext = modifierContext.classOrInterfaceModifier();
                if (coiModifierContext == null) continue;
                access += this.getAccessFlag(coiModifierContext);
            }
            return access;
        }

        protected int getClassBodyDeclarationAccessFlag(ParserRuleContext ctx) {
            if ((this.currentType.access & 0x200) == 0) {
                int access = 0;
                for (JavaParser.ModifierContext modifierContext : ctx.getRuleContexts(JavaParser.ModifierContext.class)) {
                    JavaParser.ClassOrInterfaceModifierContext coimc = modifierContext.classOrInterfaceModifier();
                    if (coimc == null) continue;
                    access += this.getAccessFlag(coimc);
                }
                return access;
            }
            return 1;
        }

        protected int getAccessFlag(JavaParser.ClassOrInterfaceModifierContext ctx) {
            ParseTree first;
            if (ctx.getChildCount() == 1 && (first = ctx.getChild(0)) instanceof TerminalNode) {
                switch (((TerminalNode)first).getSymbol().getType()) {
                    case 38: {
                        return 8;
                    }
                    case 18: {
                        return 16;
                    }
                    case 1: {
                        return 1024;
                    }
                    case 35: {
                        return 1;
                    }
                    case 34: {
                        return 4;
                    }
                    case 33: {
                        return 2;
                    }
                }
            }
            return 0;
        }
    }

    protected static class JavaMethod
    implements Type.Method {
        protected JavaType type;
        protected int access;
        protected String name;
        protected String descriptor;

        public JavaMethod(JavaType type, int access, String name, String descriptor) {
            this.type = type;
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
        }

        @Override
        public int getFlags() {
            return this.access;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescriptor() {
            return this.descriptor;
        }

        @Override
        public Icon getIcon() {
            return AbstractTypeFactoryProvider.getMethodIcon(this.access);
        }

        @Override
        public String getDisplayName() {
            boolean isInnerClass;
            String constructorName = this.type.getDisplayInnerTypeName();
            boolean bl = isInnerClass = constructorName != null;
            if (constructorName == null) {
                constructorName = this.type.getDisplayTypeName();
            }
            StringBuffer sb = new StringBuffer();
            AbstractTypeFactoryProvider.writeMethodSignature(sb, this.access, this.access, isInnerClass, constructorName, this.name, this.descriptor);
            return sb.toString();
        }
    }

    protected static class JavaField
    implements Type.Field {
        protected int access;
        protected String name;
        protected String descriptor;

        public JavaField(int access, String name, String descriptor) {
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
        }

        @Override
        public int getFlags() {
            return this.access;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescriptor() {
            return this.descriptor;
        }

        @Override
        public Icon getIcon() {
            return AbstractTypeFactoryProvider.getFieldIcon(this.access);
        }

        @Override
        public String getDisplayName() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.name).append(" : ");
            AbstractTypeFactoryProvider.writeSignature(sb, this.descriptor, this.descriptor.length(), 0, false);
            return sb.toString();
        }
    }

    protected static class JavaType
    implements Type {
        protected int access;
        protected String name;
        protected String superName;
        protected String outerName;
        protected String displayTypeName;
        protected String displayInnerTypeName;
        protected String displayPackageName;
        protected List<Type> innerTypes = new ArrayList<Type>();
        protected List<Type.Field> fields = new ArrayList<Type.Field>();
        protected List<Type.Method> methods = new ArrayList<Type.Method>();
        protected JavaType outerType;

        public JavaType(int access, String name, String superName, String outerName, String displayTypeName, String displayInnerTypeName, String displayPackageName, JavaType outerType) {
            this.access = access;
            this.name = name;
            this.superName = superName;
            this.outerName = outerName;
            this.displayTypeName = displayTypeName;
            this.displayInnerTypeName = displayInnerTypeName;
            this.displayPackageName = displayPackageName;
            this.outerType = outerType;
        }

        @Override
        public int getFlags() {
            return this.access;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getSuperName() {
            return this.superName;
        }

        @Override
        public String getOuterName() {
            return this.outerName;
        }

        @Override
        public String getDisplayTypeName() {
            return this.displayTypeName;
        }

        @Override
        public String getDisplayInnerTypeName() {
            return this.displayInnerTypeName;
        }

        @Override
        public String getDisplayPackageName() {
            return this.displayPackageName;
        }

        @Override
        public Icon getIcon() {
            return AbstractTypeFactoryProvider.getTypeIcon(this.access);
        }

        public JavaType getOuterType() {
            return this.outerType;
        }

        @Override
        public Collection<Type> getInnerTypes() {
            return this.innerTypes;
        }

        @Override
        public Collection<Type.Field> getFields() {
            return this.fields;
        }

        @Override
        public Collection<Type.Method> getMethods() {
            return this.methods;
        }
    }
}

