"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function isLogicalOr(op) {
    return !!op.or;
}
exports.isLogicalOr = isLogicalOr;
function isLogicalAnd(op) {
    return !!op.and;
}
exports.isLogicalAnd = isLogicalAnd;
function isLogicalNot(op) {
    return !!op.not;
}
exports.isLogicalNot = isLogicalNot;
function forEachLeave(op, fn) {
    if (isLogicalNot(op)) {
        forEachLeave(op.not, fn);
    }
    else if (isLogicalAnd(op)) {
        for (var _i = 0, _a = op.and; _i < _a.length; _i++) {
            var subop = _a[_i];
            forEachLeave(subop, fn);
        }
    }
    else if (isLogicalOr(op)) {
        for (var _b = 0, _c = op.or; _b < _c.length; _b++) {
            var subop = _c[_b];
            forEachLeave(subop, fn);
        }
    }
    else {
        fn(op);
    }
}
exports.forEachLeave = forEachLeave;
function normalizeLogicalOperand(op, normalizer) {
    if (isLogicalNot(op)) {
        return { not: normalizeLogicalOperand(op.not, normalizer) };
    }
    else if (isLogicalAnd(op)) {
        return { and: op.and.map(function (o) { return normalizeLogicalOperand(o, normalizer); }) };
    }
    else if (isLogicalOr(op)) {
        return { or: op.or.map(function (o) { return normalizeLogicalOperand(o, normalizer); }) };
    }
    else {
        return normalizer(op);
    }
}
exports.normalizeLogicalOperand = normalizeLogicalOperand;
//# sourceMappingURL=data:application/json;base64,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