/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineDecoration;
import org.jhotdraw.geom.Geom;

public abstract class AbstractLineDecoration
implements LineDecoration {
    private boolean isFilled;
    private boolean isStroked;
    private boolean isSolid;

    public AbstractLineDecoration(boolean bl, boolean bl2, boolean bl3) {
        this.isFilled = bl;
        this.isStroked = bl2;
        this.isSolid = bl3;
    }

    protected boolean isFilled() {
        return this.isFilled;
    }

    protected boolean isStroked() {
        return this.isStroked;
    }

    protected boolean isSolid() {
        return this.isSolid;
    }

    @Override
    public void draw(Graphics2D graphics2D, Figure figure, Point2D.Double double_, Point2D.Double double_2) {
        Color color;
        GeneralPath generalPath = this.getTransformedDecoratorPath(figure, double_, double_2);
        if (this.isFilled && (color = this.isSolid ? figure.get(AttributeKeys.STROKE_COLOR) : figure.get(AttributeKeys.FILL_COLOR)) != null) {
            graphics2D.setColor(color);
            graphics2D.fill(generalPath);
        }
        if (this.isStroked && (color = figure.get(AttributeKeys.STROKE_COLOR)) != null) {
            graphics2D.setColor(color);
            graphics2D.setStroke(AttributeKeys.getStroke(figure));
            graphics2D.draw(generalPath);
        }
    }

    @Override
    public Rectangle2D.Double getDrawingArea(Figure figure, Point2D.Double double_, Point2D.Double double_2) {
        GeneralPath generalPath = this.getTransformedDecoratorPath(figure, double_, double_2);
        Rectangle2D rectangle2D = generalPath.getBounds2D();
        Rectangle2D.Double double_3 = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        if (this.isStroked) {
            double d = figure.get(AttributeKeys.STROKE_WIDTH);
            int n = figure.get(AttributeKeys.STROKE_JOIN);
            double d2 = figure.get(AttributeKeys.STROKE_MITER_LIMIT) * d;
            double d3 = n == 0 ? (double)((int)(1.0 + d / 2.0 * d2)) : (double)((int)(1.0 + d / 2.0));
            Geom.grow(double_3, d3, d3);
        } else {
            Geom.grow(double_3, 1.0, 1.0);
        }
        return double_3;
    }

    @Override
    public double getDecorationRadius(Figure figure) {
        double d = figure.get(AttributeKeys.STROKE_WIDTH);
        double d2 = d > 1.0 ? 1.0 + (d - 1.0) / 2.0 : 1.0;
        return this.getDecoratorPathRadius(figure) * d2;
    }

    private GeneralPath getTransformedDecoratorPath(Figure figure, Point2D.Double double_, Point2D.Double double_2) {
        GeneralPath generalPath = this.getDecoratorPath(figure);
        double d = figure.get(AttributeKeys.STROKE_WIDTH);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(double_.x, double_.y);
        affineTransform.rotate(Math.atan2(double_.x - double_2.x, double_2.y - double_.y));
        if (d > 1.0) {
            affineTransform.scale(1.0 + (d - 1.0) / 2.0, 1.0 + (d - 1.0) / 2.0);
        }
        generalPath.transform(affineTransform);
        return generalPath;
    }

    protected void setFilled(boolean bl) {
        this.isFilled = bl;
    }

    protected void setStroked(boolean bl) {
        this.isStroked = bl;
    }

    protected void setSolid(boolean bl) {
        this.isSolid = bl;
    }

    protected abstract GeneralPath getDecoratorPath(Figure var1);

    protected abstract double getDecoratorPathRadius(Figure var1);
}

