/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * matrixCompMult(dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf), dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf)) => dmat2x3(0.2116lf, 0.2025lf, 1.0609lf, 3.7636lf, 0.5625lf, 0.25lf)
 * matrixCompMult(dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf), dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf)) => dmat2x3(-0.6348lf, 0.5715lf, 1.03lf, -2.0952lf, -1.3725lf, 0.37lf)
 * matrixCompMult(dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf), dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf)) => dmat2x3(-0.6348lf, 0.5715lf, 1.03lf, -2.0952lf, -1.3725lf, 0.37lf)
 * matrixCompMult(dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf), dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf)) => dmat2x3(1.9043999999999996lf, 1.6129lf, 1.0lf, 1.1664lf, 3.3489000000000004lf, 0.5476lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[(distance(matrixCompMult(dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf), dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf))[0], dvec3(0.2116lf, 0.2025lf, 1.0609lf)) * distance(matrixCompMult(dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf), dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf))[0], dvec3(0.2116lf, 0.2025lf, 1.0609lf))) + (distance(matrixCompMult(dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf), dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf))[1], dvec3(3.7636lf, 0.5625lf, 0.25lf)) * distance(matrixCompMult(dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf), dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf))[1], dvec3(3.7636lf, 0.5625lf, 0.25lf))) <= 1.5754880830000005e-09lf ? 1 : -1] array0;
  double[(distance(matrixCompMult(dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf), dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf))[0], dvec3(-0.6348lf, 0.5715lf, 1.03lf)) * distance(matrixCompMult(dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf), dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf))[0], dvec3(-0.6348lf, 0.5715lf, 1.03lf))) + (distance(matrixCompMult(dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf), dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf))[1], dvec3(-2.0952lf, -1.3725lf, 0.37lf)) * distance(matrixCompMult(dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf), dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf))[1], dvec3(-2.0952lf, -1.3725lf, 0.37lf))) <= 8.201002580000001e-10lf ? 1 : -1] array1;
  double[(distance(matrixCompMult(dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf), dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf))[0], dvec3(-0.6348lf, 0.5715lf, 1.03lf)) * distance(matrixCompMult(dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf), dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf))[0], dvec3(-0.6348lf, 0.5715lf, 1.03lf))) + (distance(matrixCompMult(dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf), dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf))[1], dvec3(-2.0952lf, -1.3725lf, 0.37lf)) * distance(matrixCompMult(dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf), dmat2x3(-0.46lf, -0.45lf, 1.03lf, 1.94lf, -0.75lf, -0.5lf))[1], dvec3(-2.0952lf, -1.3725lf, 0.37lf))) <= 8.201002580000001e-10lf ? 1 : -1] array2;
  double[(distance(matrixCompMult(dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf), dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf))[0], dvec3(1.9043999999999996lf, 1.6129lf, 1.0lf)) * distance(matrixCompMult(dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf), dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf))[0], dvec3(1.9043999999999996lf, 1.6129lf, 1.0lf))) + (distance(matrixCompMult(dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf), dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf))[1], dvec3(1.1664lf, 3.3489000000000004lf, 0.5476lf)) * distance(matrixCompMult(dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf), dmat2x3(1.38lf, -1.27lf, 1.0lf, -1.08lf, 1.83lf, -0.74lf))[1], dvec3(1.1664lf, 3.3489000000000004lf, 0.5476lf))) <= 2.0103671700000008e-09lf ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
