/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * step(dvec2(-2.0lf, -2.0lf), dvec2(-2.0lf, -0.6666666666666667lf)) => dvec2(1.0lf, 1.0lf)
 * step(dvec2(-2.0lf, -2.0lf), dvec2(0.6666666666666665lf, 2.0lf)) => dvec2(1.0lf, 1.0lf)
 * step(dvec2(-0.6666666666666667lf, -0.6666666666666667lf), dvec2(-2.0lf, -0.6666666666666667lf)) => dvec2(0.0lf, 1.0lf)
 * step(dvec2(-0.6666666666666667lf, -0.6666666666666667lf), dvec2(0.6666666666666665lf, 2.0lf)) => dvec2(1.0lf, 1.0lf)
 * step(dvec2(0.6666666666666665lf, 0.6666666666666665lf), dvec2(-2.0lf, -0.6666666666666667lf)) => dvec2(0.0lf, 0.0lf)
 * step(dvec2(0.6666666666666665lf, 0.6666666666666665lf), dvec2(0.6666666666666665lf, 2.0lf)) => dvec2(1.0lf, 1.0lf)
 * step(dvec2(2.0lf, 2.0lf), dvec2(-2.0lf, -0.6666666666666667lf)) => dvec2(0.0lf, 0.0lf)
 * step(dvec2(2.0lf, 2.0lf), dvec2(0.6666666666666665lf, 2.0lf)) => dvec2(0.0lf, 1.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(step(dvec2(-2.0lf, -2.0lf), dvec2(-2.0lf, -0.6666666666666667lf)), dvec2(1.0lf, 1.0lf)) <= 1.4142135623730951e-05lf ? 1 : -1] array0;
  double[distance(step(dvec2(-2.0lf, -2.0lf), dvec2(0.6666666666666665lf, 2.0lf)), dvec2(1.0lf, 1.0lf)) <= 1.4142135623730951e-05lf ? 1 : -1] array1;
  double[distance(step(dvec2(-0.6666666666666667lf, -0.6666666666666667lf), dvec2(-2.0lf, -0.6666666666666667lf)), dvec2(0.0lf, 1.0lf)) <= 1e-05lf ? 1 : -1] array2;
  double[distance(step(dvec2(-0.6666666666666667lf, -0.6666666666666667lf), dvec2(0.6666666666666665lf, 2.0lf)), dvec2(1.0lf, 1.0lf)) <= 1.4142135623730951e-05lf ? 1 : -1] array3;
  double[distance(step(dvec2(0.6666666666666665lf, 0.6666666666666665lf), dvec2(-2.0lf, -0.6666666666666667lf)), dvec2(0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array4;
  double[distance(step(dvec2(0.6666666666666665lf, 0.6666666666666665lf), dvec2(0.6666666666666665lf, 2.0lf)), dvec2(1.0lf, 1.0lf)) <= 1.4142135623730951e-05lf ? 1 : -1] array5;
  double[distance(step(dvec2(2.0lf, 2.0lf), dvec2(-2.0lf, -0.6666666666666667lf)), dvec2(0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array6;
  double[distance(step(dvec2(2.0lf, 2.0lf), dvec2(0.6666666666666665lf, 2.0lf)), dvec2(0.0lf, 1.0lf)) <= 1e-05lf ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
