/*
 * Decompiled with CFR 0.152.
 */
package com.projity.association;

import com.projity.association.Association;
import com.projity.association.AssociationComparator;
import com.projity.association.AssociationFormat;
import com.projity.association.AssociationListFormat;
import com.projity.association.InvalidAssociationException;
import com.projity.field.FieldParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class AssociationList
implements List {
    protected LinkedList list = new LinkedList();

    public AssociationList() {
    }

    public AssociationList(AssociationList associationList) {
        this();
        this.list.addAll(associationList.list);
    }

    @Override
    public boolean add(Association association) {
        Association association2 = AssociationList.findAssociation(this.list, association.getLeft(), association.getRight(), null);
        if (association2 != null) {
            return false;
        }
        return this.list.add(association);
    }

    private static Object getObject(Association association, boolean bl) {
        return bl ? association.getLeft() : association.getRight();
    }

    public Association find(boolean bl, Object object) {
        for (Association association : this.list) {
            if (AssociationList.getObject(association, bl) != object) continue;
            return association;
        }
        return null;
    }

    public Association findLeft(Object object) {
        return this.find(true, object);
    }

    public Association findRight(Object object) {
        return this.find(false, object);
    }

    public static Association findAssociation(LinkedList linkedList, Object object, Object object2, Association association) {
        for (Association association2 : linkedList) {
            if (association2 == association || association2.getLeft() != object || association2.getRight() != object2) continue;
            return association2;
        }
        return null;
    }

    public static List extractDistinct(List list, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Association association : list) {
            Object object = AssociationList.getObject(association, bl);
            if (arrayList.contains(object)) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    protected void testValid(boolean bl) throws InvalidAssociationException {
        for (Association association : this.list) {
            association.testValid(bl);
        }
    }

    public void replaceAll(Object object, boolean bl) {
        for (Association association : this.list) {
            association.replace(object, bl);
        }
    }

    public AssociationList setAssociations(String string, AssociationFormat associationFormat) throws FieldParseException {
        AssociationListFormat associationListFormat = AssociationListFormat.getInstance(associationFormat);
        AssociationList associationList = (AssociationList)associationListFormat.parseObject(string, new ParsePosition(0));
        if (associationList == null) {
            System.out.println(associationFormat.getParameters().getError());
            throw new FieldParseException(associationFormat.getParameters().getError());
        }
        LinkedList linkedList = this.list;
        LinkedList linkedList2 = associationList.list;
        try {
            associationList.testValid(true);
        }
        catch (InvalidAssociationException invalidAssociationException) {
            System.out.println(invalidAssociationException.getMessage());
            throw new FieldParseException(invalidAssociationException.getMessage());
        }
        for (Association association : linkedList2) {
            if (AssociationList.findAssociation(linkedList2, association.getLeft(), association.getRight(), association) == null) continue;
            throw new FieldParseException("Duplicate association");
        }
        LinkedList<Association> linkedList3 = new LinkedList<Association>();
        LinkedList<Association> linkedList4 = new LinkedList<Association>();
        for (Association association : linkedList) {
            if (association.isDefault()) continue;
            Association association2 = AssociationList.findAssociation(linkedList2, association.getLeft(), association.getRight(), null);
            if (association2 == null) {
                linkedList3.add(association);
                continue;
            }
            if (associationFormat.getParameters().isAllowDetailsEntry()) {
                linkedList4.add(association);
            }
            association.copyPrincipalFieldsFrom(association2);
        }
        Iterator iterator = linkedList3.iterator();
        while (iterator.hasNext()) {
            ((Association)iterator.next()).doRemoveService(this);
        }
        LinkedList<Association> linkedList5 = new LinkedList<Association>();
        for (Association association : linkedList2) {
            if (association.isDefault() || AssociationList.findAssociation(linkedList4, association.getLeft(), association.getRight(), null) != null) continue;
            linkedList5.add(association);
        }
        iterator = linkedList5.iterator();
        while (iterator.hasNext()) {
            ((Association)iterator.next()).doAddService(this);
        }
        iterator = linkedList4.iterator();
        while (iterator.hasNext()) {
            ((Association)iterator.next()).doUpdateService(this);
        }
        Collections.sort(this.list, new AssociationComparator(associationFormat.getParameters().getIdField()));
        return associationList;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean remove(Object object) {
        return this.list.remove(object);
    }

    @Override
    public void addFirst(Object object) {
        this.list.addFirst(object);
    }

    @Override
    public Iterator iterator() {
        return this.list.iterator();
    }

    public LinkedList getList() {
        return this.list;
    }

    public void add(int n, Object object) {
        this.list.add(n, object);
    }

    @Override
    public boolean add(Object object) {
        return this.list.add(object);
    }

    public boolean addAll(int n, Collection collection) {
        return this.list.addAll(n, collection);
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.list.addAll(collection);
    }

    @Override
    public void addLast(Object object) {
        this.list.addLast(object);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.list.contains(object);
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        return this.list.equals(object);
    }

    public Object get(int n) {
        return this.list.get(n);
    }

    @Override
    public Object getFirst() {
        return this.list.getFirst();
    }

    @Override
    public Object getLast() {
        return this.list.getLast();
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public int indexOf(Object object) {
        return this.list.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.list.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.list.listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.list.listIterator(n);
    }

    public Object remove(int n) {
        return this.list.remove(n);
    }

    @Override
    public boolean removeAll(Collection collection) {
        return this.list.removeAll(collection);
    }

    @Override
    public Object removeFirst() {
        return this.list.removeFirst();
    }

    @Override
    public Object removeLast() {
        return this.list.removeLast();
    }

    @Override
    public boolean retainAll(Collection collection) {
        return this.list.retainAll(collection);
    }

    public Object set(int n, Object object) {
        return this.list.set(n, object);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public List subList(int n, int n2) {
        return this.list.subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        return this.list.toArray(objectArray);
    }

    public String toString() {
        return this.list.toString();
    }

    public void dump(boolean bl) {
        for (Association association : this.list) {
            System.out.println(AssociationList.getObject(association, bl));
        }
    }
}

