/*
 * Decompiled with CFR 0.152.
 */
package com.projity.datatype;

import com.projity.datatype.Duration;
import com.projity.datatype.Work;
import com.projity.options.EditOption;
import com.projity.options.ScheduleOption;
import com.projity.strings.Messages;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DurationFormat
extends Format {
    private boolean showPlusSign = false;
    private boolean isWork = false;
    private boolean canBeNonTemporal = false;
    private static Format instance = null;
    private static Format signedInstance = null;
    private static Format workInstance = null;
    private static Format nonTemporalWorkInstance = null;
    private static String[] types = new String[]{"minute", "hour", "day", "week", "month", "year", "percent", "eminute", "ehour", "eday", "eweek", "emonth", "eyear", "epercent"};
    private static final int SINGULAR = 0;
    private static final int PLURAL = 1;
    private static final String[] multiple = new String[]{".singular", ".plural"};
    private static int TYPE_COUNT = types.length;
    private static int NAME_COUNT = 4;
    private static String[][][] typesArray = new String[NAME_COUNT][multiple.length][TYPE_COUNT];
    private static Pattern[] pattern = new Pattern[TYPE_COUNT];
    private static String estimatedSymbol = Messages.getString("Units.estimatedSymbol");
    private static NumberFormat DECIMAL_FORMAT = NumberFormat.getNumberInstance();

    public static Format getInstance() {
        if (instance == null) {
            instance = new DurationFormat(false);
        }
        return instance;
    }

    public static Format getSignedInstance() {
        if (signedInstance == null) {
            signedInstance = new DurationFormat(true);
        }
        return signedInstance;
    }

    public static Format getWorkInstance() {
        if (workInstance == null) {
            workInstance = new DurationFormat(false);
            ((DurationFormat)DurationFormat.workInstance).isWork = true;
        }
        return workInstance;
    }

    public static Format getNonTemporalWorkInstance() {
        if (nonTemporalWorkInstance == null) {
            nonTemporalWorkInstance = new DurationFormat(false);
            ((DurationFormat)DurationFormat.nonTemporalWorkInstance).isWork = true;
            ((DurationFormat)DurationFormat.nonTemporalWorkInstance).canBeNonTemporal = true;
        }
        return nonTemporalWorkInstance;
    }

    private DurationFormat(boolean bl) {
        this.showPlusSign = bl;
        String string = Messages.getString("Units.estimatedSymbolRegex");
        for (int i = 0; i < TYPE_COUNT; ++i) {
            String string2 = null;
            String string3 = null;
            for (int j = 0; j < multiple.length; ++j) {
                String string4 = new String(Messages.getString("Units." + types[i] + multiple[j]));
                if (j == 0) {
                    string2 = string4;
                }
                if (j == 1) {
                    string3 = string4;
                }
                String[] stringArray = string4.split("\\|");
                for (int k = 0; k < NAME_COUNT; ++k) {
                    DurationFormat.typesArray[k][j][i] = stringArray[k];
                }
            }
            DurationFormat.pattern[i] = Pattern.compile("((?:" + string2 + ")|(?:" + string3 + "))?(\\s*" + string + "?)");
        }
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        Number number;
        Duration duration = null;
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(parsePosition.getIndex()) == '+') {
            parsePosition.setIndex(parsePosition.getIndex() + 1);
        }
        if ((number = DECIMAL_FORMAT.parse(string, parsePosition)) == null) {
            return null;
        }
        String string2 = string.substring(parsePosition.getIndex());
        string2 = string2.trim();
        for (int i = 0; i < TYPE_COUNT; ++i) {
            long l;
            Matcher matcher = pattern[i].matcher(string2);
            if (!matcher.matches()) continue;
            int n = matcher.group(1) != null ? i : -1;
            double d = number.doubleValue();
            if (n == 6 || n == 13) {
                d /= 100.0;
            }
            if (n == -1 && this.isWork) {
                n = this.canBeNonTemporal ? -2 : ScheduleOption.getInstance().getWorkUnit();
            }
            if (Duration.millis(l = Duration.getInstance(d, n)) > 105120000000L) {
                return null;
            }
            if (matcher.group(2).length() != 0) {
                l = Duration.setAsEstimated(l, true);
            }
            duration = new Duration(l);
            return duration;
        }
        return null;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl;
        long l = ((Duration)object).getEncodedMillis();
        if (((Duration)object).isWork() && Duration.getType(l) != -2) {
            l = Duration.setAsTimeUnit(l, ScheduleOption.getInstance().getWorkUnit());
        }
        double d = Duration.getValue(l);
        int n = Duration.getEffectiveType(l);
        if (d > 0.0 && this.showPlusSign) {
            stringBuffer.append("+");
        }
        if (bl = Duration.isPercent(l)) {
            d *= 100.0;
        }
        DECIMAL_FORMAT.format(d, stringBuffer, fieldPosition);
        String string = DurationFormat.formatTypeUnit(n, Math.abs(d) == 1.0, EditOption.getInstance().isAddSpaceBeforeLabel(), Duration.isPercent(l), Duration.isEstimated(l), EditOption.getInstance().getViewAs(n));
        stringBuffer.append(string);
        return stringBuffer;
    }

    public String formatCompact(Object object) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        long l = ((Duration)object).getEncodedMillis();
        if (((Duration)object).isWork() && Duration.getType(l) != -2) {
            l = Duration.setAsTimeUnit(l, ScheduleOption.getInstance().getWorkUnit());
        }
        double d = Duration.getValue(l);
        int n = Duration.getEffectiveType(l);
        if (d > 0.0 && this.showPlusSign) {
            stringBuffer.append("+");
        }
        if (bl = Duration.isPercent(l)) {
            d *= 100.0;
        }
        stringBuffer.append(DECIMAL_FORMAT.format(d));
        String string = DurationFormat.formatTypeUnit(n, Math.abs(d) == 1.0, false, Duration.isPercent(l), Duration.isEstimated(l), 3);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String formatTypeUnit(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n == -2) {
            return "";
        }
        if (bl2 && !bl3) {
            stringBuffer.append(" ");
        }
        String string = typesArray[n2][bl ? 0 : 1][n];
        stringBuffer.append(string);
        if (bl4) {
            stringBuffer.append(estimatedSymbol);
        }
        return stringBuffer.toString();
    }

    public static String formatTypeUnit(int n) {
        DurationFormat.getInstance();
        return DurationFormat.formatTypeUnit(n, true, false, false, false, EditOption.getInstance().getViewAs(n));
    }

    public static String format(long l) {
        return DurationFormat.getInstance().format(new Duration(l)).toString();
    }

    public static String formatCompact(long l) {
        return ((DurationFormat)DurationFormat.getInstance()).formatCompact(new Duration(l)).toString();
    }

    public static String formatWork(long l) {
        return DurationFormat.getWorkInstance().format(new Work(l)).toString();
    }

    public static String formatWork(Object object) {
        if (object != null && object instanceof Long) {
            return DurationFormat.formatWork((Long)object);
        }
        return DurationFormat.getWorkInstance().format(object);
    }
}

