/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.dialog.AbstractDialog;
import com.projity.dialog.ActionJList;
import com.projity.dialog.ButtonPanel;
import com.projity.field.Field;
import com.projity.pm.graphic.frames.MainFrameFactory;
import com.projity.session.Session;
import com.projity.session.SessionFactory;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import com.projity.util.Environment;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicListUI;

public final class LookupDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    Field field;
    JComboBox types;
    JList results;
    JScrollPane resultsPane;
    JTextField match;
    JButton find;
    JButton removeButton;
    LinkedHashMap resultMap;
    String key;
    String value;

    public static String[] getKeyAndValue(Field field) {
        LookupDialog lookupDialog = new LookupDialog(field);
        lookupDialog.initControls();
        if (lookupDialog.doModal()) {
            return new String[]{lookupDialog.key, lookupDialog.value};
        }
        return null;
    }

    @Override
    public ButtonPanel createButtonPanel() {
        AbstractAction abstractAction = new AbstractAction(Messages.getString("Text.Remove")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LookupDialog.this.remove();
            }
        };
        this.removeButton = new JButton(abstractAction);
        this.createOkCancelButtons();
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.addButton(this.removeButton);
        buttonPanel.addButton(this.ok);
        buttonPanel.addButton(this.cancel);
        return buttonPanel;
    }

    private void remove() {
        this.value = null;
        this.key = null;
        super.onOk();
    }

    @Override
    public void onOk() {
        int n = this.results.getSelectedIndex();
        if (n != -1) {
            this.value = (String)this.results.getSelectedValue();
            this.key = this.keyForValue(this.value);
        }
        super.onOk();
    }

    private String keyForValue(String string) {
        for (Map.Entry entry : this.resultMap.entrySet()) {
            if (string != entry.getValue()) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    private LookupDialog(Field field) {
        super(MainFrameFactory.getMainFrame(), Messages.getString("LookupDialog.LookupAnObject"), true);
        this.field = field;
    }

    @Override
    protected boolean initialOkEnabledState() {
        return false;
    }

    protected void initControls() {
        this.types = new JComboBox<String>(this.field.getLookupTypes().split(";"));
        this.results = new JList();
        this.results.setSelectionMode(0);
        this.resultsPane = new JScrollPane(this.results);
        if (Environment.isNewLook()) {
            this.results.setUI(new BasicListUI());
        }
        this.match = new JTextField();
        this.match.setToolTipText(Messages.getString("LookupDialog.EnterPartOfTheName"));
        this.find = new JButton(Messages.getString("LookupDialog.Find"));
        this.find.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Session session = SessionFactory.getInstance().getSession(false);
                if (session != null) {
                    try {
                        LookupDialog.this.resultMap = (LinkedHashMap)SessionFactory.call(session, "queryLike", new Class[]{String.class, String.class}, new Object[]{LookupDialog.this.types.getSelectedItem(), LookupDialog.this.match.getText()});
                        LookupDialog.this.results = new ActionJList(LookupDialog.this.resultMap.values().toArray());
                        ((ActionJList)LookupDialog.this.results).addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                LookupDialog.this.onOk();
                            }
                        });
                        if (LookupDialog.this.resultMap.isEmpty()) {
                            LookupDialog.this.resultsPane.getViewport().add(new JLabel(Messages.getString("LookupDialog.NoMatchesFound")));
                            LookupDialog.this.resultsPane.setEnabled(false);
                            LookupDialog.this.ok.setEnabled(false);
                        } else {
                            LookupDialog.this.resultsPane.setEnabled(true);
                            LookupDialog.this.resultsPane.getViewport().add(LookupDialog.this.results);
                            LookupDialog.this.ok.setEnabled(true);
                        }
                    }
                    catch (Exception exception) {
                        Alert.error(Messages.getString("LookupDialog.UnableToContactServer"));
                        exception.printStackTrace();
                    }
                }
            }
        });
    }

    @Override
    public JComponent createContentPanel() {
        this.initControls();
        FormLayout formLayout = new FormLayout("p, 3dlu, p,20dlu,p,3dlu,160dlu:grow,3dlu,p", "p, 3dlu, p,3dlu,fill:default:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.append(Messages.getString("LookupDialog.Type"), (Component)this.types);
        defaultFormBuilder.append(Messages.getString("LookupDialog.Find") + ":", (Component)this.match);
        defaultFormBuilder.append(this.find);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("LookupDialog.Results"));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.add((Component)this.resultsPane, cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 9));
        return defaultFormBuilder.getPanel();
    }
}

