/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog.options;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.dialog.AbstractDialog;
import com.projity.options.CalendarOption;
import com.projity.strings.Messages;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class CalendarDialogBox
extends AbstractDialog {
    private static final long serialVersionUID = -6887419605301434923L;
    private Form form;
    JSpinner hoursPerDay;
    JSpinner hoursPerWeek;
    JSpinner daysPerMonth;
    JTextField startTime;
    JTextField endTime;
    JComboBox weekStart;
    JComboBox fiscalYearStart;
    JCheckBox useStartingYear;
    JButton setAsDefault;

    public static CalendarDialogBox getInstance(Frame frame, CalendarOption calendarOption) {
        return new CalendarDialogBox(frame, calendarOption);
    }

    private CalendarDialogBox(Frame frame, CalendarOption calendarOption) {
        super(frame, Messages.getString("CalendarDialogBox.DurationSettings"), true);
        this.form = new Form(calendarOption);
        this.addDocHelp("Calendar_Options");
    }

    protected void initControls() {
        String[] stringArray = new String[]{Messages.getString("CalendarDialogBox.Monday"), Messages.getString("CalendarDialogBox.Tuesday"), Messages.getString("CalendarDialogBox.Wednesday"), Messages.getString("CalendarDialogBox.Thursday"), Messages.getString("CalendarDialogBox.Friday"), Messages.getString("CalendarDialogBox.Saturday"), Messages.getString("CalendarDialogBox.Sunday")};
        String[] stringArray2 = new String[]{Messages.getString("CalendarDialogBox.January"), Messages.getString("CalendarDialogBox.February"), Messages.getString("CalendarDialogBox.March"), Messages.getString("CalendarDialogBox.April"), Messages.getString("CalendarDialogBox.May"), Messages.getString("CalendarDialogBox.June"), Messages.getString("CalendarDialogBox.July"), Messages.getString("CalendarDialogBox.August"), Messages.getString("CalendarDialogBox.September"), Messages.getString("CalendarDialogBox.October"), Messages.getString("CalendarDialogBox.November"), Messages.getString("CalendarDialogBox.December")};
        this.weekStart = new JComboBox<String>(stringArray);
        this.fiscalYearStart = new JComboBox<String>(stringArray2);
        this.useStartingYear = new JCheckBox(Messages.getString("CalendarDialogBox.UserStartingYearForFVNumbering"));
        this.useStartingYear.setEnabled(false);
        this.startTime = new JTextField(Messages.getString("CalendarDialogBox.EightAM"));
        this.endTime = new JTextField(Messages.getString("CalendarDialogBox.SixPM"));
        this.hoursPerDay = new JSpinner(new SpinnerNumberModel(this.form.getHoursPerDay(), 0.0, 24.0, 0.5));
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this.hoursPerDay, "##.##");
        this.hoursPerDay.setEditor(numberEditor);
        this.hoursPerWeek = new JSpinner(new SpinnerNumberModel(this.form.getHoursPerWeek(), 0.0, 168.0, 0.5));
        JSpinner.NumberEditor numberEditor2 = new JSpinner.NumberEditor(this.hoursPerWeek, "##.##");
        this.hoursPerWeek.setEditor(numberEditor2);
        this.daysPerMonth = new JSpinner(new SpinnerNumberModel(this.form.getDaysPerMonth(), 0.0, 31.0, 1.0));
        JSpinner.NumberEditor numberEditor3 = new JSpinner.NumberEditor(this.daysPerMonth, "##.##");
        this.daysPerMonth.setEditor(numberEditor3);
        this.setAsDefault = new JButton(Messages.getString("CalendarDialogBox.SetAsDefault"));
        this.fiscalYearStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CalendarDialogBox.this.fiscalYearStart.getSelectedItem().equals(Messages.getString("CalendarDialogBox.January"))) {
                    CalendarDialogBox.this.useStartingYear.setEnabled(false);
                } else {
                    CalendarDialogBox.this.useStartingYear.setEnabled(true);
                }
            }
        });
    }

    @Override
    protected boolean bind(boolean bl) {
        if (this.form == null) {
            return false;
        }
        if (bl) {
            this.weekStart.setSelectedItem(this.form.getWeekStart());
            this.fiscalYearStart.setSelectedItem(this.form.getFiscalYearStart());
            this.useStartingYear.setSelected(this.form.getUseStartingYear());
            this.startTime.setText(Messages.getString("CalendarDialogBox.Eight"));
            this.endTime.setText(Messages.getString("CalendarDialogBox.Seventeen"));
            this.hoursPerDay.setValue(this.form.getHoursPerDay());
            this.hoursPerWeek.setValue(this.form.getHoursPerWeek());
            this.daysPerMonth.setValue(this.form.getDaysPerMonth());
            this.setAsDefault.setSelected(this.form.getSetAsDefault());
        } else {
            this.form.setWeekStart((String)this.weekStart.getSelectedItem());
            this.form.setFiscalYearStart((String)this.fiscalYearStart.getSelectedItem());
            Boolean bl2 = new Boolean(this.useStartingYear.isSelected());
            this.form.setUseStartingYear(bl2);
            this.form.setStartTime(this.startTime.getText());
            this.form.setEndTime(this.endTime.getText());
            this.form.setHoursPerDay((Double)this.hoursPerDay.getValue());
            this.form.setHoursPerWeek((Double)this.hoursPerWeek.getValue());
            this.form.setDaysPerMonth((Double)this.daysPerMonth.getValue());
            Boolean bl3 = new Boolean(this.setAsDefault.isSelected());
            this.form.setSetAsDefault(bl3);
        }
        return true;
    }

    @Override
    public JComponent createContentPanel() {
        this.initControls();
        FormLayout formLayout = new FormLayout("p,3dlu,p,p:grow", "p,3dlu,p,3dlu,p,3dlu,p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)new JLabel(Messages.getString("CalendarDialogBox.TheseSettingsOnlyApplyToDuration")), cellConstraints.xyw(defaultFormBuilder.getColumn(), defaultFormBuilder.getRow(), 4));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("CalendarDialogBox.HoursPerday"), (Component)this.hoursPerDay);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("CalendarDialogBox.HoursPerWeek"), (Component)this.hoursPerWeek);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.append(Messages.getString("CalendarDialogBox.DaysPerMonth"), (Component)this.daysPerMonth);
        return defaultFormBuilder.getPanel();
    }

    @Override
    public Object getBean() {
        return this.form;
    }

    public Form getForm() {
        return this.form;
    }

    public static class Form {
        Double hoursPerDay;
        Double hoursPerWeek;
        Double daysPerMonth;
        String startTime;
        String endTime;
        String weekStart;
        String fiscalYearStart;
        Boolean useStartingYear;
        Boolean setAsDefault;

        Form(CalendarOption calendarOption) {
            this.hoursPerDay = new Double(calendarOption.getHoursPerDay());
            this.hoursPerWeek = new Double(calendarOption.getHoursPerWeek());
            this.daysPerMonth = new Double(calendarOption.getDaysPerMonth());
            this.startTime = calendarOption.getDefaultStartHour() + "";
            this.endTime = calendarOption.getDefaultEndHour() + "";
        }

        public void copyToOption(CalendarOption calendarOption) {
            calendarOption.setHoursPerDay(this.hoursPerDay);
            calendarOption.setHoursPerWeek(this.hoursPerWeek);
            calendarOption.setDaysPerMonth(this.daysPerMonth);
        }

        public Double getDaysPerMonth() {
            return this.daysPerMonth;
        }

        public void setDaysPerMonth(Double d) {
            this.daysPerMonth = d;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String string) {
            this.endTime = string;
        }

        public String getFiscalYearStart() {
            return this.fiscalYearStart;
        }

        public void setFiscalYearStart(String string) {
            this.fiscalYearStart = string;
        }

        public Double getHoursPerDay() {
            return this.hoursPerDay;
        }

        public void setHoursPerDay(Double d) {
            this.hoursPerDay = d;
        }

        public Double getHoursPerWeek() {
            return this.hoursPerWeek;
        }

        public void setHoursPerWeek(Double d) {
            this.hoursPerWeek = d;
        }

        public Boolean getSetAsDefault() {
            return this.setAsDefault;
        }

        public void setSetAsDefault(Boolean bl) {
            this.setAsDefault = bl;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String string) {
            this.startTime = string;
        }

        public Boolean getUseStartingYear() {
            return this.useStartingYear;
        }

        public void setUseStartingYear(Boolean bl) {
            this.useStartingYear = bl;
        }

        public String getWeekStart() {
            return this.weekStart;
        }

        public void setWeekStart(String string) {
            this.weekStart = string;
        }
    }
}

