/*
 * Decompiled with CFR 0.152.
 */
package com.projity.graphic.configuration;

import com.projity.configuration.NamedItem;
import com.projity.graphic.configuration.BarStyle;
import com.projity.strings.Messages;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.collections.Closure;
import org.apache.commons.digester.Digester;

public class BarStyles
implements NamedItem {
    public static final String category = "BarStylesCategory";
    String name = null;
    String id = null;
    ArrayList rows = new ArrayList();
    String zoomX = null;
    String zoomY = null;
    double[] zoomRatioX = null;
    int defaultZoomIndexX;
    double[] zoomRatioY = null;
    int defaultZoomIndexY;

    @Override
    public String getCategory() {
        return category;
    }

    public void apply(Object object, Closure closure) {
        this.apply(object, closure, false, false, false, false);
    }

    public void apply(Object object, Closure closure, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        for (BarStyle barStyle : this.rows) {
            if (barStyle.isLink() != bl || barStyle.isHorizontalGrid() != bl4 || barStyle.isAnnotation() != bl2 || barStyle.isCalendar() != bl3 || !barStyle.evaluate(object)) continue;
            closure.execute(barStyle.getBarFormat());
        }
    }

    public void addStyle(BarStyle barStyle) {
        barStyle.setBelongsTo(this);
        barStyle.build();
        this.rows.add(barStyle);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setId(String string) {
        this.id = string;
        this.setName(Messages.getString(string));
    }

    public String getId() {
        return this.id;
    }

    public ArrayList getRows() {
        return this.rows;
    }

    public String getZoomX() {
        return this.zoomX;
    }

    public void setZoomX(String string) {
        this.zoomX = string;
    }

    public String getZoomY() {
        return this.zoomY;
    }

    public void setZoomY(String string) {
        this.zoomY = string;
    }

    public double getRatioX(int n, boolean bl) {
        this.initZoomX();
        if (this.zoomX == null) {
            return 1.0;
        }
        int n2 = this.defaultZoomIndexX + n - (bl ? 0 : 1);
        if (n2 < 0 || n2 >= this.zoomRatioX.length) {
            return 1.0;
        }
        return bl ? this.zoomRatioX[n2] : 1.0 / this.zoomRatioX[n2];
    }

    protected void initZoomX() {
        if (this.zoomRatioX == null) {
            if (this.zoomX == null) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.zoomX, ",;:|");
            this.zoomRatioX = new double[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if ("*".equals(string)) {
                    this.defaultZoomIndexX = n;
                    continue;
                }
                this.zoomRatioX[n++] = Double.parseDouble(string);
            }
        }
    }

    public double getRatioY(int n, boolean bl) {
        this.initZoomY();
        if (this.zoomY == null) {
            return 1.0;
        }
        int n2 = this.defaultZoomIndexY + n - (bl ? 0 : 1);
        if (n2 < 0 || n2 >= this.zoomRatioY.length) {
            return 1.0;
        }
        return bl ? this.zoomRatioY[n2] : 1.0 / this.zoomRatioY[n2];
    }

    protected void initZoomY() {
        if (this.zoomRatioY == null) {
            if (this.zoomY == null) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.zoomY, ",;:|");
            this.zoomRatioY = new double[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if ("*".equals(string)) {
                    this.defaultZoomIndexY = n;
                    continue;
                }
                this.zoomRatioY[n++] = Double.parseDouble(string);
            }
        }
    }

    public int getMinZoom() {
        this.initZoomX();
        this.initZoomY();
        if (this.zoomRatioX == null || this.zoomRatioY == null) {
            return 0;
        }
        return Math.min(-this.defaultZoomIndexX, -this.defaultZoomIndexY);
    }

    public int getMaxZoom() {
        this.initZoomX();
        this.initZoomY();
        if (this.zoomRatioX == null || this.zoomRatioY == null) {
            return 0;
        }
        return Math.min(this.zoomRatioX.length - this.defaultZoomIndexX - 1, this.zoomRatioY.length - this.defaultZoomIndexY - 1);
    }

    public static void addDigesterEvents(Digester digester) {
        digester.addFactoryCreate("*/bar/styles", "com.projity.graphic.configuration.BarStylesFactory");
        digester.addSetProperties("*/bar/styles");
        digester.addSetNext("*/bar/styles", "add", "com.projity.configuration.NamedItem");
        digester.addObjectCreate("*/bar/styles/style", "com.projity.graphic.configuration.BarStyle");
        digester.addSetProperties("*/bar/styles/style");
        digester.addSetNext("*/bar/styles/style", "addStyle", "com.projity.graphic.configuration.BarStyle");
    }
}

