/*
 * Decompiled with CFR 0.152.
 */
package com.projity.graphic.configuration;

import com.projity.configuration.Dictionary;
import com.projity.configuration.NamedItem;
import com.projity.contrib.util.Log;
import com.projity.contrib.util.LogFactory;
import com.projity.field.InvalidFormulaException;
import com.projity.graphic.configuration.CellStyle;
import com.projity.graphic.configuration.CellStyleFactory;
import com.projity.strings.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.digester.Digester;

public class CellStyles
implements NamedItem {
    static Log log = LogFactory.getLog(CellStyles.class);
    public static final String category = "CellStylesCategory";
    String name = null;
    String id = null;
    Map styleMap = new HashMap();
    Map factoryMap = new HashMap();
    List factories = new ArrayList();
    protected static CellStyles instance = null;

    @Override
    public String getCategory() {
        return category;
    }

    public void addStyle(CellStyleFactory cellStyleFactory) {
        this.factories.add(cellStyleFactory);
        this.factoryMap.put(cellStyleFactory.getId(), cellStyleFactory);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setId(String string) {
        this.id = string;
        this.setName(Messages.getString(string));
    }

    public String getId() {
        return this.id;
    }

    public CellStyle getStyle(String string) {
        CellStyle cellStyle = (CellStyle)this.styleMap.get(string);
        if (cellStyle == null) {
            CellStyleFactory cellStyleFactory = this.getFactory(string);
            try {
                cellStyle = cellStyleFactory.getCellStyle();
                this.styleMap.put(string, cellStyle);
            }
            catch (InvalidFormulaException invalidFormulaException) {
                log.error("Formula not set: invalid formula text: " + cellStyleFactory.getFormulaText());
            }
        }
        return cellStyle;
    }

    public CellStyle getDefaultStyle() {
        return this.getStyle("CellStyle.default");
    }

    public CellStyleFactory getFactory(String string) {
        return (CellStyleFactory)this.factoryMap.get(string);
    }

    public List getFactories() {
        return this.factories;
    }

    public static void addDigesterEvents(Digester digester) {
        digester.addObjectCreate("*/cellstyles", "com.projity.graphic.configuration.CellStyles");
        digester.addSetProperties("*/cellstyles");
        digester.addSetNext("*/cellstyles", "add", "com.projity.configuration.NamedItem");
        digester.addObjectCreate("*/cellstyles/style", "com.projity.graphic.configuration.CellStyleFactory");
        digester.addSetProperties("*/cellstyles/style");
        digester.addCallMethod("*/cellstyles/style/formulaText", "setFormulaText", 0);
        digester.addSetNext("*/cellstyles/style", "addStyle", "com.projity.graphic.configuration.CellStyleFactory");
    }

    public static CellStyles getInstance() {
        if (instance == null) {
            instance = (CellStyles)Dictionary.get(category, "default");
        }
        return instance;
    }
}

