/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.gantt;

import com.projity.graphic.configuration.BarStyle;
import com.projity.grouping.core.transform.TransformList;
import com.projity.grouping.core.transform.filtering.BaseFilter;
import com.projity.pm.graphic.gantt.GanttInteractor;
import com.projity.pm.graphic.graph.GraphInteractor;
import com.projity.pm.graphic.graph.GraphPopupMenu;
import com.projity.strings.Messages;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;

public class GanttPopupMenu
extends GraphPopupMenu {
    private static final long serialVersionUID = -5006500626139949187L;

    public GanttPopupMenu(GraphInteractor graphInteractor) {
        super(graphInteractor);
    }

    @Override
    protected void init() {
        this.removeAll();
        this.add(new SplitModeMenuAction());
        this.add(new AssignmentsMenuAction());
        final JMenu jMenu = new JMenu(Messages.getString("Gantt.Popup.barStylesMenu"));
        final JMenu jMenu2 = new JMenu(Messages.getString("Gantt.Popup.annotationStylesMenu"));
        CollectionUtils.forAllDo(this.interactor.getGraph().getBarStyles().getRows(), new Closure(){

            @Override
            public void execute(Object object) {
                BarStyle barStyle = (BarStyle)object;
                BarMenuAction barMenuAction = new BarMenuAction(barStyle);
                if (barStyle.isLink()) {
                    GanttPopupMenu.this.add(barMenuAction);
                } else if (barStyle.isCalendar()) {
                    GanttPopupMenu.this.add(barMenuAction);
                } else if (barStyle.isHorizontalGrid()) {
                    GanttPopupMenu.this.add(barMenuAction);
                } else if (barStyle.isAnnotation()) {
                    jMenu2.add(barMenuAction);
                } else {
                    jMenu.add(barMenuAction);
                }
            }
        });
        this.add(jMenu);
        this.add(jMenu2);
    }

    private class SplitModeMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -8615889754474230400L;

        SplitModeMenuAction() {
            super(Messages.getString("Gantt.Popup.splitMode"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ((GanttInteractor)GanttPopupMenu.this.interactor).setSplitMode();
        }
    }

    private class AssignmentsMenuAction
    extends JRadioButtonMenuItem
    implements ActionListener {
        private static final long serialVersionUID = 3480838269288912755L;
        BaseFilter filter;
        BaseFilter filterOffline;

        AssignmentsMenuAction() {
            super(Messages.getString("Gantt.Popup.showAssignments"));
            this.filter = (BaseFilter)TransformList.getInstance("hidden_filters").getTransform("Filter.Gantt");
            this.filterOffline = (BaseFilter)TransformList.getInstance("hidden_filters").getTransform("Filter.OfflineGantt");
            this.setSelected(this.filter.isShowAssignments());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.filter.setShowAssignments(this.isSelected());
            this.filterOffline.setShowAssignments(this.isSelected());
            GanttPopupMenu.this.interactor.getGraph().getModel().getCache().update();
        }
    }

    private class BarMenuAction
    extends JRadioButtonMenuItem
    implements ActionListener {
        private static final long serialVersionUID = 8168153384233811506L;
        BarStyle style;

        BarMenuAction(BarStyle barStyle) {
            super(barStyle.getName());
            this.style = barStyle;
            this.setSelected(barStyle.isActive());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.style.setActive(this.isSelected());
            GanttPopupMenu.this.interactor.getGraph().getModel().updateAll(true);
        }
    }
}

