/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.editor;

import com.projity.configuration.Settings;
import com.projity.datatype.PercentFormat;
import com.projity.datatype.Rate;
import com.projity.field.Field;
import com.projity.field.Range;
import com.projity.pm.graphic.spreadsheet.editor.KeyboardFocusSpinner;
import com.projity.pm.graphic.spreadsheet.editor.SimpleEditor;
import com.projity.util.MathUtils;
import java.awt.Component;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;

public class SpinEditor
extends SimpleEditor {
    private Double defaultValue = new Double(1.0);
    private static double MAX_VALUE = 6.0E7;
    private static final String NUMBER_TEMPLATE = "#######################";
    Field field;
    KeyboardFocusSpinner spin;

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.cachedTable = jTable;
        if (object == null || this.field.isPercent() && object instanceof Double && PercentFormat.isSpecialValue((Double)object)) {
            this.spin.setValue(this.defaultValue);
        } else {
            if (object instanceof Rate) {
                object = new Double(((Rate)object).getValue());
            }
            this.spin.setValue(object);
        }
        return this.spin;
    }

    public static JSpinner getJSpinnerInstance(Field field, double d, boolean bl) {
        double d2 = 0.0;
        double d3 = MAX_VALUE;
        double d4 = 0.5;
        double d5 = d;
        Range range = field.getRange();
        if (range != null) {
            d3 = range.getMaximum();
            d2 = range.getMinimum();
            d4 = range.getStep();
            d5 = Math.max(d2, Math.min(d, d3));
        }
        JSpinner jSpinner = bl ? new KeyboardFocusSpinner(new SpinnerNumberModel(d5, d2, d3, d4)) : new JSpinner(new SpinnerNumberModel(d5, d2, d3, d4));
        String string = NUMBER_TEMPLATE.substring(Double.toString(d3).length());
        JSpinner.NumberEditor numberEditor = field.isPercent() ? new JSpinner.NumberEditor(jSpinner, string + Settings.PERCENT) : new JSpinner.NumberEditor(jSpinner, string);
        jSpinner.setEditor(numberEditor);
        numberEditor.getTextField().setHorizontalAlignment(4);
        return jSpinner;
    }

    public static Object getValue(JSpinner jSpinner, Field field) {
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)jSpinner.getEditor();
        Object object = null;
        try {
            if (field.isPercent()) {
                object = PercentFormat.getInstance().parseObject(numberEditor.getTextField().getText());
                object = new Double(MathUtils.roundToDecentPrecision(((Number)object).doubleValue()));
            } else {
                object = NumberFormat.getInstance().parseObject(numberEditor.getTextField().getText());
            }
        }
        catch (ParseException parseException) {
            return null;
        }
        if (field.isRate()) {
            object = new Rate(((Number)object).doubleValue());
        }
        return object;
    }

    public SpinEditor(Field field) {
        this.field = field;
        this.spin = (KeyboardFocusSpinner)SpinEditor.getJSpinnerInstance(field, 0.0, true);
    }

    @Override
    public Object getCellEditorValue() {
        return SpinEditor.getValue(this.spin, this.field);
    }

    @Override
    public void cancelCellEditing() {
        super.cancelCellEditing();
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        if (this.handledPostErrorFocus()) {
            this.spin.getTextField().setValue(this.spin.getValue());
            return false;
        }
        return true;
    }
}

