/*
 * Decompiled with CFR 0.152.
 */
package com.projity.print;

import com.projity.job.JobRunnable;
import com.projity.offline_graphics.SVGRenderer;
import com.projity.pm.graphic.graph.GraphParams;
import com.projity.print.ViewPrintableParams;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class DocumentPrintable
implements Printable,
Pageable {
    protected ViewPrintableParams printableParams;
    protected JobRunnable jr;
    protected PrinterJob printerJob;
    protected PageFormat pageFormat;
    protected Stroke cellStroke = new BasicStroke(0.25f);
    protected Stroke spreadSheetStroke = new BasicStroke(0.5f);
    protected Color cellColor = Color.GRAY;
    protected Color spreadSheetColor = Color.BLACK;

    public DocumentPrintable() {
    }

    public DocumentPrintable(ViewPrintableParams viewPrintableParams) {
        this.printableParams = viewPrintableParams;
    }

    @Override
    public int getNumberOfPages() {
        return this.printableParams.getDocumentRowCount() * this.printableParams.getDocumentColCount();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        return this.print(graphics, n);
    }

    public JobRunnable getJr() {
        return this.jr;
    }

    public void setJr(JobRunnable jobRunnable) {
        this.jr = jobRunnable;
    }

    public PrinterJob getPrinterJob() {
        return this.printerJob;
    }

    public void setPrinterJob(PrinterJob printerJob) {
        this.printerJob = printerJob;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    @Override
    public PageFormat getPageFormat(int n) {
        return this.pageFormat;
    }

    @Override
    public Printable getPrintable(int n) {
        return this;
    }

    public void update() {
        SVGRenderer sVGRenderer = this.printableParams.getRenderer();
        GraphParams graphParams = sVGRenderer.getParams();
        int n = (int)Math.ceil((this.pageFormat.getImageableWidth() - 1.0) / this.printableParams.getTotalZoomX());
        int n2 = (int)Math.ceil((this.pageFormat.getImageableHeight() - 1.0) / this.printableParams.getTotalZoomY());
        graphParams.setPrintBounds(new Rectangle(0, 0, n, n2));
        this.printableParams.setDocumentColCount(graphParams.getPrintCols());
        this.printableParams.setDocumentRowCount(graphParams.getPrintRows());
    }

    public int print(Graphics graphics, int n) throws PrinterException {
        int n2 = this.getNumberOfPages();
        if (n < n2) {
            if (this.jr != null && this.jr.getJob().isCanceled()) {
                this.printerJob.cancel();
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            Color color = graphics2D.getColor();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.transform(this.printableParams.getTransform());
            graphics2D.setStroke(this.spreadSheetStroke);
            graphics2D.setColor(this.spreadSheetColor);
            this.printMain(graphics2D, n);
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
            graphics2D.setTransform(affineTransform);
            if (this.jr != null) {
                if (this.jr.getJob().isCanceled()) {
                    this.printerJob.cancel();
                    return 1;
                }
                int n3 = this.getNumberOfPages();
                if (n3 == 0) {
                    n3 = 1;
                }
                this.jr.setProgress((float)(n + 1) / (float)n3);
            }
            return 0;
        }
        return 1;
    }

    protected void printMain(Graphics2D graphics2D, int n) throws PrinterException {
    }
}

