/*
 * Decompiled with CFR 0.152.
 */
package com.projity.print;

import com.projity.contrib.ClassLoaderUtils;
import com.projity.help.HelpUtil;
import com.projity.menu.MenuActionConstants;
import com.projity.menu.MenuActionsMap;
import com.projity.menu.MenuManager;
import com.projity.pm.graphic.IconManager;
import com.projity.print.ExtendedPageFormat;
import com.projity.print.GraphPageable;
import com.projity.print.PDFPrintService;
import com.projity.print.PageSetup;
import com.projity.print.PageSize;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.MissingListenerException;

public class PrintPreviewFrame
extends JFrame
implements ActionMap,
MenuActionConstants {
    private PagePanel pagePanel;
    private JScrollPane pageScrollPane;
    protected GraphPageable document;
    private int pageIndex = 0;
    private double zoom;
    protected MenuManager menuManager;
    protected MenuActionsMap actionsMap;
    protected PageSetup pageSetup;
    protected JComponent pageSetupComponent;

    public PrintPreviewFrame(GraphPageable graphPageable) {
        this.document = graphPageable;
        this.zoom = 1.0;
        this.init();
        HelpUtil.addDocHelp(this, "Print_Preview");
    }

    public double getZoomX() {
        return this.zoom;
    }

    public double getZoomY() {
        return this.zoom;
    }

    public void correctPageIndex() {
        int n = this.document.getNumberOfPages();
        if (this.pageIndex == 0) {
            return;
        }
        if (this.pageIndex >= n) {
            this.pageIndex = n - 1;
        }
    }

    public void init() {
        this.setExtendedState(this.getExtendedState() | 6);
        this.setTitle(Messages.getString("PrintPreviewFrame.PrintPreview"));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (PrintPreviewFrame.this.pageSetup != null) {
                    PrintPreviewFrame.this.pageSetup.saveSettings(true, false);
                }
            }
        });
        this.menuManager = MenuManager.getInstance(this);
        JToolBar jToolBar = this.menuManager.getToolBar("PrintPreviewToolBar");
        this.getContentPane().add((Component)jToolBar, "First");
        this.actionsMap.setEnabledDocumentMenuActions(true);
        this.pagePanel = new PagePanel();
        this.updateSize();
        this.pageScrollPane = new JScrollPane(this.pagePanel, 22, 32);
        this.getContentPane().add((Component)this.pageScrollPane, "Center");
        this.addFormatPanel();
    }

    public void addHandlers() {
        this.actionsMap = new MenuActionsMap(this, this.menuManager);
        this.actionsMap.addHandler("PrintPreviewPrint", new PrintAction());
        this.actionsMap.addHandler("PrintPreviewPDF", new PDFAction());
        this.actionsMap.addHandler("PrintPreviewFormat", new FormatAction());
        this.actionsMap.addHandler("PrintPreviewBack", new BackAction());
        this.actionsMap.addHandler("PrintPreviewForward", new ForwardAction());
        this.actionsMap.addHandler("PrintPreviewUp", new UpAction());
        this.actionsMap.addHandler("PrintPreviewDown", new DownAction());
        this.actionsMap.addHandler("PrintPreviewFirst", new FirstAction());
        this.actionsMap.addHandler("PrintPreviewLast", new LastAction());
        this.actionsMap.addHandler("PrintPreviewZoomIn", new ZoomInAction());
        this.actionsMap.addHandler("PrintPreviewZoomOut", new ZoomOutAction());
        this.actionsMap.addHandler("PrintPreviewZoomReset", new ZoomResetAction());
        this.actionsMap.addHandler("PrintPreviewLeftView", new LeftViewAction());
        this.actionsMap.addHandler("PrintPreviewRightView", new RightViewAction());
    }

    @Override
    public Action getAction(String string) throws MissingListenerException {
        Action action;
        if (this.actionsMap == null) {
            this.addHandlers();
        }
        if ((action = this.actionsMap.getConcreteAction(string)) == null) {
            throw new MissingListenerException("no listener for PrintPreviewFrame", this.getClass().getName(), string);
        }
        return action;
    }

    @Override
    public String getStringFromAction(Action action) throws MissingListenerException {
        if (this.actionsMap == null) {
            this.addHandlers();
        }
        return this.actionsMap.getStringFromAction(action);
    }

    public void toggleFormatPanel() {
        if (this.pageSetupComponent == null) {
            return;
        }
        boolean bl = !this.pageSetupComponent.isVisible();
        this.pageSetupComponent.setVisible(bl);
    }

    public void addFormatPanel() {
        if (this.pageSetup == null) {
            this.pageSetup = PageSetup.getInstance(this.document);
            this.pageSetupComponent = new JScrollPane(this.pageSetup.createContentPanel(true));
            this.pageSetupComponent.setFont(this.pageSetupComponent.getFont().deriveFont(8));
            this.getContentPane().add((Component)this.pageSetupComponent, "East");
        }
    }

    public double getZoom() {
        return this.zoom;
    }

    public void nextPage() {
        this.correctPageIndex();
        if (this.pageIndex < this.document.getNumberOfPages() - 1) {
            ++this.pageIndex;
            this.updatePanel();
        }
    }

    public void previousPage() {
        this.correctPageIndex();
        if (this.pageIndex > 0) {
            --this.pageIndex;
            this.updatePanel();
        }
    }

    public void lowerPage() {
        this.correctPageIndex();
        if (this.pageIndex < this.document.getNumberOfPages() - this.document.getColumnCount()) {
            this.pageIndex += this.document.getColumnCount();
            this.updatePanel();
        }
    }

    public void upperPage() {
        this.correctPageIndex();
        if (this.pageIndex >= this.document.getColumnCount()) {
            this.pageIndex -= this.document.getColumnCount();
            this.updatePanel();
        }
    }

    public void firstPage() {
        this.correctPageIndex();
        if (this.pageIndex != 0) {
            this.pageIndex = 0;
            this.updatePanel();
        }
    }

    public void lastPage() {
        this.correctPageIndex();
        if (this.pageIndex != this.document.getNumberOfPages() - 1) {
            this.pageIndex = this.document.getNumberOfPages() - 1;
            this.updatePanel();
        }
    }

    public void print() {
        this.document.print();
    }

    protected void update() {
        this.document.update();
        this.updatePanel();
    }

    protected void updatePanel() {
        this.updateSize();
        this.pagePanel.repaint();
    }

    protected void updateSize() {
        ExtendedPageFormat extendedPageFormat = this.document.getPageFormat();
        Dimension dimension = new Dimension();
        PageSize pageSize = extendedPageFormat.getSize();
        if (extendedPageFormat.getOrientation() == 1) {
            dimension.setSize((double)Math.round(pageSize.getX(25400) * 72.0f) * this.zoom, (double)Math.round(pageSize.getY(25400) * 72.0f) * this.zoom);
        } else {
            dimension.setSize((double)Math.round(pageSize.getY(25400) * 72.0f) * this.zoom, (double)Math.round(pageSize.getX(25400) * 72.0f) * this.zoom);
        }
        this.pagePanel.setPreferredSize(dimension);
        this.pagePanel.revalidate();
    }

    protected void zoomIn() {
        this.zoom *= 1.25;
        this.updatePanel();
    }

    protected void zoomOut() {
        this.zoom /= 1.25;
        this.updatePanel();
    }

    protected void zoomReset() {
        this.zoom = 1.0;
        this.updatePanel();
    }

    protected void toggleLeftView() {
        if (this.document instanceof GraphPageable) {
            GraphPageable graphPageable = this.document;
            boolean bl = graphPageable.getRenderer().getParams().isLeftPartVisible();
            graphPageable.getRenderer().getParams().setLeftPartVisible(!bl);
            if (bl) {
                graphPageable.getRenderer().getParams().setRightPartVisible(true);
            }
            this.pageIndex = 0;
            this.updateButtons();
            this.update();
        }
    }

    protected void toggleRightView() {
        if (this.document instanceof GraphPageable) {
            GraphPageable graphPageable = this.document;
            boolean bl = graphPageable.getRenderer().getParams().isRightPartVisible();
            graphPageable.getRenderer().getParams().setRightPartVisible(!bl);
            if (bl) {
                graphPageable.getRenderer().getParams().setLeftPartVisible(true);
            }
            this.pageIndex = 0;
            this.updateButtons();
            this.update();
        }
    }

    protected void updateButtons() {
        if (this.document instanceof GraphPageable) {
            JButton jButton;
            GraphPageable graphPageable = this.document;
            boolean bl = graphPageable.getRenderer().getParams().isLeftPartVisible();
            ArrayList arrayList = this.menuManager.getToolBarFactory().getButtonsFromId("PrintPreviewLeftView");
            if (arrayList != null && arrayList.size() == 1) {
                jButton = (JButton)arrayList.get(0);
                jButton.setIcon(IconManager.getIcon(bl ? "print.leftView" : "print.leftViewHidden"));
            }
            this.menuManager.setActionSelected("PrintPreviewLeftView", bl);
            bl = graphPageable.getRenderer().getParams().isRightPartVisible();
            arrayList = this.menuManager.getToolBarFactory().getButtonsFromId("PrintPreviewRightView");
            if (arrayList != null && arrayList.size() == 1) {
                jButton = (JButton)arrayList.get(0);
                jButton.setIcon(IconManager.getIcon(bl ? "print.rightView" : "print.rightViewHidden"));
            }
            this.menuManager.setActionSelected("PrintPreviewRightView", bl);
        }
    }

    public PagePanel getPagePanel() {
        return this.pagePanel;
    }

    public class PagePanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        protected AffineTransform transform = null;
        protected double w;
        protected double h;
        private double fx;
        private double fy;
        private Point point = new Point();
        private Cursor defaultCursor = null;

        public PagePanel() {
            PrintPreviewFrame.this.document.update();
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public AffineTransform updateTransform() {
            Dimension dimension = this.getSize();
            double d = dimension.getWidth();
            double d2 = dimension.getHeight();
            double d3 = PrintPreviewFrame.this.getZoomX();
            double d4 = PrintPreviewFrame.this.getZoomY();
            ExtendedPageFormat extendedPageFormat = PrintPreviewFrame.this.document.getPageFormat();
            this.w = extendedPageFormat.getWidth();
            this.h = extendedPageFormat.getHeight();
            double d5 = this.w * d3;
            double d6 = this.h * d4;
            double d7 = d > d5 ? (d - d5) / 2.0 : 0.0;
            double d8 = d2 > d6 ? (d2 - d6) / 2.0 : 0.0;
            this.transform = new AffineTransform(d3, 0.0, 0.0, d4, d7, d8);
            return this.transform;
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            this.setBackground(Color.GRAY);
            Dimension dimension = this.getSize();
            double d = dimension.getWidth();
            double d2 = dimension.getHeight();
            BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            AffineTransform affineTransform = graphics2D.getTransform();
            Color color = graphics2D.getColor();
            graphics2D.setColor(Color.GRAY);
            graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, d, d2));
            graphics2D.transform(this.updateTransform());
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, this.w, this.h));
            graphics2D.setColor(color);
            try {
                PrintPreviewFrame.this.correctPageIndex();
                PrintPreviewFrame.this.document.printWithDefault(graphics2D, PrintPreviewFrame.this.pageIndex);
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
            }
            graphics2D.setTransform(affineTransform);
            if (bufferedImage != null) {
                graphics.drawImage(bufferedImage, 0, 0, this);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Rectangle rectangle = this.getVisibleRect();
            this.fx = (double)mouseEvent.getX() - rectangle.getX();
            this.fy = (double)mouseEvent.getY() - rectangle.getY();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Rectangle rectangle = this.getVisibleRect();
            double d = (double)mouseEvent.getX() - rectangle.getX();
            double d2 = (double)mouseEvent.getY() - rectangle.getY();
            double d3 = rectangle.getX() - d + this.fx;
            double d4 = rectangle.getY() - d2 + this.fy;
            this.fx = d;
            this.fy = d2;
            Dimension dimension = this.getSize();
            if (d3 < 0.0) {
                d3 = 0.0;
            } else if (d3 + rectangle.getWidth() > dimension.getWidth()) {
                d3 = dimension.getWidth() - rectangle.getWidth();
            }
            if (d4 < 0.0) {
                d4 = 0.0;
            } else if (d4 + rectangle.getHeight() > dimension.getHeight()) {
                d4 = dimension.getHeight() - rectangle.getHeight();
            }
            rectangle.setFrame(d3, d4, rectangle.getWidth(), rectangle.getHeight());
            this.scrollRectToVisible(rectangle);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.transform == null) {
                return;
            }
            try {
                this.transform.inverseTransform(mouseEvent.getPoint(), this.point);
                if (this.point.getX() >= 0.0 && this.point.getX() <= this.w && this.point.getY() >= 0.0 && this.point.getY() <= this.h) {
                    if (this.defaultCursor == null) {
                        this.defaultCursor = this.getCursor();
                        this.setCursor(Cursor.getPredefinedCursor(13));
                    }
                } else if (this.defaultCursor != null) {
                    this.setCursor(this.defaultCursor);
                    this.defaultCursor = null;
                }
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
    }

    public class RightViewAction
    extends MenuActionsMap.GlobalMenuAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreviewFrame.this.toggleRightView();
        }

        @Override
        protected boolean needsDocument() {
            return true;
        }

        @Override
        protected boolean allowed(boolean bl) {
            if (!(PrintPreviewFrame.this.document instanceof GraphPageable)) {
                return false;
            }
            GraphPageable graphPageable = PrintPreviewFrame.this.document;
            return graphPageable.getRenderer().getParams().isSupportLeftAndRightParts();
        }
    }

    public class LeftViewAction
    extends MenuActionsMap.GlobalMenuAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreviewFrame.this.toggleLeftView();
        }

        @Override
        protected boolean needsDocument() {
            return true;
        }

        @Override
        protected boolean allowed(boolean bl) {
            if (!(PrintPreviewFrame.this.document instanceof GraphPageable)) {
                return false;
            }
            GraphPageable graphPageable = PrintPreviewFrame.this.document;
            return graphPageable.getRenderer().getParams().isSupportLeftAndRightParts();
        }
    }

    public class ZoomOutAction
    extends MenuActionsMap.GlobalMenuAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreviewFrame.this.zoomOut();
        }
    }

    public class ZoomResetAction
    extends MenuActionsMap.GlobalMenuAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreviewFrame.this.zoomReset();
        }
    }

    public class ZoomInAction
    extends MenuActionsMap.GlobalMenuAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreviewFrame.this.zoomIn();
        }
    }

    public class LastAction
    extends MenuActionsMap.GlobalMenuAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreviewFrame.this.lastPage();
        }
    }

    public class FirstAction
    extends MenuActionsMap.GlobalMenuAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreviewFrame.this.firstPage();
        }
    }

    public class DownAction
    extends MenuActionsMap.GlobalMenuAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreviewFrame.this.lowerPage();
        }
    }

    public class UpAction
    extends MenuActionsMap.GlobalMenuAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreviewFrame.this.upperPage();
        }
    }

    public class ForwardAction
    extends MenuActionsMap.GlobalMenuAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreviewFrame.this.nextPage();
        }
    }

    public class BackAction
    extends MenuActionsMap.GlobalMenuAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreviewFrame.this.previousPage();
        }
    }

    public class FormatAction
    extends MenuActionsMap.GlobalMenuAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreviewFrame.this.toggleFormatPanel();
        }
    }

    public class PDFAction
    extends MenuActionsMap.GlobalMenuAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Class clazz = ClassLoaderUtils.forName("org.projectlibre.export.ImageExport");
                clazz.getMethod("export", GraphPageable.class, Component.class).invoke(null, PrintPreviewFrame.this.document, PrintPreviewFrame.this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public class PrintAction
    extends MenuActionsMap.GlobalMenuAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PrintPreviewFrame.this.document.getPrintService() instanceof PDFPrintService) {
                Alert.error(Messages.getString("PageSetupDialog.NotValidPrinter"), PrintPreviewFrame.this);
                return;
            }
            PrintPreviewFrame.this.document.print();
        }
    }
}

