/*
 * Decompiled with CFR 0.152.
 */
package com.projity.util;

import com.projity.strings.Messages;
import com.projity.util.DateTime;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;

public class SpecialDateFormat
extends SimpleDateFormat {
    private static final String NO_END = Messages.getString("Date.NoEnd");
    private static final String NO_START = Messages.getString("Date.NoStart");
    public static String DATE_FORMAT = "EEE MM/dd/yy H:mm";
    private static DateFormat instance = null;
    private static DateFormat defaultInstance = DateFormat.getDateTimeInstance(2, 3);

    public static DateFormat getSpecialInstance() {
        if (instance == null) {
            instance = new SpecialDateFormat();
            instance.setTimeZone(DateUtils.UTC_TIME_ZONE);
            defaultInstance.setTimeZone(DateUtils.UTC_TIME_ZONE);
        }
        return instance;
    }

    protected SpecialDateFormat() {
        super(DATE_FORMAT);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (date.equals(DateTime.getMaxDate())) {
            stringBuffer.append(NO_END);
            return stringBuffer;
        }
        if (date.equals(DateTime.NA_TIME)) {
            stringBuffer.append(NO_START);
            return stringBuffer;
        }
        return defaultInstance.format(date, stringBuffer, fieldPosition);
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        if (string.equals(NO_END)) {
            return DateTime.getMaxDate();
        }
        if (string.equals(NO_START)) {
            return DateTime.NA_TIME;
        }
        return defaultInstance.parse(string, parsePosition);
    }
}

