/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserDialog;

public class BrowseRepositoryAction
extends AnAction
implements DumbAware {
    public static final String REPOSITORY_BROWSER_TOOLWINDOW = "SVN Repositories";

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            RepositoryBrowserDialog dialog = new RepositoryBrowserDialog(ProjectManager.getInstance().getDefaultProject());
            dialog.show();
        } else {
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
            ToolWindow w = manager.getToolWindow(REPOSITORY_BROWSER_TOOLWINDOW);
            if (w == null) {
                RepositoryToolWindowPanel component = new RepositoryToolWindowPanel(project);
                w = manager.registerToolWindow(REPOSITORY_BROWSER_TOOLWINDOW, true, ToolWindowAnchor.BOTTOM, (Disposable)project, true);
                w.setHelpId("reference.svn.repository");
                Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)component, "", false);
                Disposer.register((Disposable)content, (Disposable)component);
                w.getContentManager().addContent(content);
            }
            w.show(null);
            w.activate(null);
        }
    }

    private static class RepositoryToolWindowPanel
    extends JPanel
    implements Disposable {
        private final RepositoryBrowserDialog myDialog;
        private final Project myProject;

        private RepositoryToolWindowPanel(Project project) {
            super(new BorderLayout());
            this.myProject = project;
            this.myDialog = new RepositoryBrowserDialog(project);
            JComponent component = this.myDialog.createBrowserComponent(true);
            this.add((Component)component, "Center");
            this.add((Component)this.myDialog.createToolbar(false, new AnAction[0]), "West");
        }

        public void dispose() {
            this.myDialog.disposeRepositoryBrowser();
            ToolWindowManager.getInstance((Project)this.myProject).unregisterToolWindow(BrowseRepositoryAction.REPOSITORY_BROWSER_TOOLWINDOW);
        }
    }
}

