/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.utils.UniqueSequence;

public final class FactoryNoteOnEntityCommand
implements SingleMultiFactoryCommand<AbstractEntityDiagram> {
    private final IRegex partialPattern;

    public FactoryNoteOnEntityCommand(IRegex partialPattern) {
        this.partialPattern = partialPattern;
    }

    private RegexConcat getRegexConcatSingleLine(IRegex partialPattern) {
        return new RegexConcat(new RegexLeaf("^[%s]*note[%s]+"), new RegexLeaf("POSITION", "(right|left|top|bottom)"), new RegexOr(new RegexConcat(new RegexLeaf("[%s]+of[%s]+"), partialPattern), new RegexLeaf("")), new RegexLeaf("[%s]*"), FactoryNoteOnEntityCommand.color().getRegex(), new RegexLeaf("URL", "[%s]*(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*:[%s]*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    private RegexConcat getRegexConcatMultiLine(IRegex partialPattern, boolean withBracket) {
        return new RegexConcat(new RegexLeaf("^[%s]*note[%s]+"), new RegexLeaf("POSITION", "(right|left|top|bottom)"), new RegexOr(new RegexConcat(new RegexLeaf("[%s]+of[%s]+"), partialPattern), new RegexLeaf("")), new RegexLeaf("[%s]*"), FactoryNoteOnEntityCommand.color().getRegex(), new RegexLeaf("URL", "[%s]*(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf(withBracket ? "[%s]*\\{" : "[%s]*"), new RegexLeaf("$"));
    }

    @Override
    public Command<AbstractEntityDiagram> createSingleLine() {
        return new SingleLineCommand2<AbstractEntityDiagram>(this.getRegexConcatSingleLine(this.partialPattern)){

            @Override
            protected CommandExecutionResult executeArg(AbstractEntityDiagram system, RegexResult arg) {
                String s = arg.get("NOTE", 0);
                return FactoryNoteOnEntityCommand.this.executeInternal(arg, system, null, BlocLines.getWithNewlines(s));
            }
        };
    }

    @Override
    public Command<AbstractEntityDiagram> createMultiLine(final boolean withBracket) {
        return new CommandMultilines2<AbstractEntityDiagram>(this.getRegexConcatMultiLine(this.partialPattern, withBracket), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                if (withBracket) {
                    return "(?i)^(\\})$";
                }
                return "(?i)^[%s]*(end[%s]?note)$";
            }

            @Override
            public CommandExecutionResult executeNow(AbstractEntityDiagram system, BlocLines lines) {
                RegexResult line0 = this.getStartingPattern().matcher(StringUtils.trin(lines.getFirst499()));
                lines = lines.subExtract(1, 1);
                lines = lines.removeEmptyColumns();
                Url url = null;
                if (line0.get("URL", 0) != null) {
                    UrlBuilder urlBuilder = new UrlBuilder(system.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
                    url = urlBuilder.getUrl(line0.get("URL", 0));
                }
                return FactoryNoteOnEntityCommand.this.executeInternal(line0, system, url, lines);
            }
        };
    }

    private CommandExecutionResult executeInternal(RegexResult line0, AbstractEntityDiagram diagram, Url url, BlocLines strings) {
        Link link;
        IEntity cl1;
        String pos = line0.get("POSITION", 0);
        Code code = Code.of(line0.get("ENTITY", 0));
        if (code == null) {
            cl1 = diagram.getLastEntity();
            if (cl1 == null) {
                return CommandExecutionResult.error("Nothing to note to");
            }
        } else {
            cl1 = diagram.isGroup(code) ? diagram.getGroup(code) : diagram.getOrCreateLeaf(code, null, null);
        }
        ILeaf note = diagram.createLeaf(UniqueSequence.getCode("GMN"), strings.toDisplay(), LeafType.NOTE, null);
        Colors colors = FactoryNoteOnEntityCommand.color().getColor(line0, diagram.getSkinParam().getIHtmlColorSet());
        note.setColors(colors);
        if (url != null) {
            note.addUrl(url);
        }
        Position position = Position.valueOf(StringUtils.goUpperCase(pos)).withRankdir(diagram.getSkinParam().getRankdir());
        LinkType type = new LinkType(LinkDecor.NONE, LinkDecor.NONE).goDashed();
        if (position == Position.RIGHT) {
            link = new Link(cl1, note, type, Display.NULL, 1);
            link.setHorizontalSolitary(true);
        } else if (position == Position.LEFT) {
            link = new Link(note, cl1, type, Display.NULL, 1);
            link.setHorizontalSolitary(true);
        } else if (position == Position.BOTTOM) {
            link = new Link(cl1, note, type, Display.NULL, 2);
        } else if (position == Position.TOP) {
            link = new Link(note, cl1, type, Display.NULL, 2);
        } else {
            throw new IllegalArgumentException();
        }
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }
}

