/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolComponent1
extends USymbol {
    USymbolComponent1() {
    }

    @Override
    public SkinParameter getSkinParameter() {
        return SkinParameter.COMPONENT1;
    }

    private void drawNode(UGraphic ug, double widthTotal, double heightTotal, boolean shadowing) {
        URectangle form = new URectangle(widthTotal, heightTotal);
        if (shadowing) {
            form.setDeltaShadow(4.0);
        }
        ug.draw(form);
        URectangle small = new URectangle(10.0, 5.0);
        ug.apply(new UTranslate(-5.0, 5.0)).draw(small);
        ug.apply(new UTranslate(-5.0, heightTotal - 10.0)).draw(small);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 10.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                StringBounder stringBounder = ug.getStringBounder();
                Dimension2D dimTotal = this.calculateDimension(stringBounder);
                ug = UGraphicStencil.create(ug, USymbolComponent1.this.getRectangleStencil(dimTotal), new UStroke());
                ug = symbolContext.apply(ug);
                USymbolComponent1.this.drawNode(ug, dimTotal.getWidth(), dimTotal.getHeight(), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolComponent1.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolComponent1.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimStereo, dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(TextBlock title, TextBlock stereotype, double width, double height, SymbolContext symbolContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean manageHorizontalLine() {
        return true;
    }
}

