/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import net.sourceforge.plantuml.BackSlash;
import net.sourceforge.plantuml.preproc.DefineSignature;
import net.sourceforge.plantuml.preproc.Variables;

public class Define {
    private final DefineSignature signature;
    private final String definition;
    private final String definitionQuoted;
    private final boolean emptyParentheses;

    public Define(String key, List<String> lines, boolean emptyParentheses) {
        this.signature = new DefineSignature(key);
        this.emptyParentheses = emptyParentheses;
        if (lines == null) {
            this.definition = null;
            this.definitionQuoted = null;
        } else {
            StringBuilder sb = new StringBuilder();
            Iterator<String> it = lines.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append('\n');
            }
            this.definition = sb.toString();
            this.definitionQuoted = Matcher.quoteReplacement(this.definition);
        }
    }

    public String toString() {
        return this.signature.toString();
    }

    public String apply(String line) {
        if (this.definition == null) {
            return line;
        }
        if (this.signature.isMethod()) {
            for (Variables vars : this.signature.getVariationVariables()) {
                line = vars.applyOn(line, this.signature.getFonctionName(), this.definitionQuoted);
            }
        } else {
            String regex = "\\b" + this.signature.getKey() + "\\b" + (this.emptyParentheses ? "(\\(\\))?" : "");
            line = BackSlash.translateBackSlashes(line);
            line = line.replaceAll(regex, this.definitionQuoted);
            line = BackSlash.untranslateBackSlashes(line);
        }
        return line;
    }
}

