/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project2;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.png.PngIO;
import net.sourceforge.plantuml.project2.GanttDiagram2;
import net.sourceforge.plantuml.project2.Project2;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;

public class PSystemProject2
extends AbstractPSystem {
    private final Project2 project = new Project2();
    private final Color background = Color.WHITE;
    private final ColorMapper colorMapper = new ColorMapperIdentity();

    @Override
    public int getNbImages() {
        return 1;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Project)");
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormatOption, long seed) throws IOException {
        GanttDiagram2 diagram = new GanttDiagram2(this.project);
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.PNG) {
            BufferedImage im = this.createImage(diagram);
            PngIO.write((RenderedImage)im, os, fileFormatOption.isWithMetadata() ? this.getMetadata() : null, 96);
        } else if (fileFormat == FileFormat.SVG) {
            UGraphicSvg svg = new UGraphicSvg((Dimension2D)new Dimension2DDouble(0.0, 0.0), this.colorMapper, StringUtils.getAsHtml(this.background), false, 1.0, fileFormatOption.getSvgLinkTarget(), fileFormatOption.getHoverColor(), this.seed());
            diagram.draw(svg, 0.0, 0.0);
            svg.createXml(os, fileFormatOption.isWithMetadata() ? this.getMetadata() : null);
        } else if (fileFormat == FileFormat.EPS) {
            UGraphicEps eps = new UGraphicEps(this.colorMapper, EpsStrategy.getDefault2());
            diagram.draw(eps, 0.0, 0.0);
            os.write(eps.getEPSCode().getBytes());
        } else if (fileFormat == FileFormat.EPS_TEXT) {
            UGraphicEps eps = new UGraphicEps(this.colorMapper, EpsStrategy.WITH_MACRO_AND_TEXT);
            diagram.draw(eps, 0.0, 0.0);
            os.write(eps.getEPSCode().getBytes());
        } else {
            throw new UnsupportedOperationException();
        }
        return new ImageDataSimple();
    }

    private BufferedImage createImage(GanttDiagram2 diagram) {
        EmptyImageBuilder builder = new EmptyImageBuilder(10, 10, this.background);
        Graphics2D g2d = builder.getGraphics2D();
        UGraphicG2d ug = new UGraphicG2d(this.colorMapper, g2d, 1.0);
        double height = diagram.getHeight(ug.getStringBounder());
        double width = diagram.getWidth(ug.getStringBounder());
        g2d.dispose();
        builder = new EmptyImageBuilder(width, height, this.background);
        BufferedImage im = builder.getBufferedImage();
        g2d = builder.getGraphics2D();
        ug = new UGraphicG2d(this.colorMapper, g2d, 1.0);
        ug.setBufferedImage(im);
        diagram.draw(ug, 0.0, 0.0);
        g2d.dispose();
        return im;
    }

    public final Project2 getProject() {
        return this.project;
    }
}

