/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class Opale
extends AbstractTextBlock
implements TextBlock {
    private final int cornersize = 10;
    private final HtmlColor noteBackgroundColor;
    private final HtmlColor borderColor;
    private final int marginX1 = 6;
    private final int marginX2 = 15;
    private final int marginY = 5;
    private final boolean withShadow;
    private Direction strategy;
    private Point2D pp1;
    private Point2D pp2;
    private final boolean withLink;
    private final TextBlock textBlock;
    private final double delta = 4.0;

    public Opale(HtmlColor borderColor, HtmlColor noteBackgroundColor, TextBlock textBlock, boolean withShadow, boolean withLink) {
        this.noteBackgroundColor = noteBackgroundColor;
        this.withLink = withLink;
        this.withShadow = withShadow;
        this.borderColor = borderColor;
        this.textBlock = textBlock;
    }

    public void setOpale(Direction strategy, Point2D pp1, Point2D pp2) {
        this.strategy = strategy;
        this.pp1 = pp1;
        this.pp2 = pp2;
    }

    private final double getWidth(StringBounder stringBounder) {
        return this.textBlock.calculateDimension(stringBounder).getWidth() + 6.0 + 15.0;
    }

    private final double getHeight(StringBounder stringBounder) {
        Dimension2D size = this.textBlock.calculateDimension(stringBounder);
        return size.getHeight() + 10.0;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double height = this.getHeight(stringBounder);
        double width = this.getWidth(stringBounder);
        return new Dimension2DDouble(width, height);
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        UPolygon polygon = this.getPolygonNormal(stringBounder);
        if (this.withShadow) {
            polygon.setDeltaShadow(4.0);
        }
        ug = ug.apply(new UChangeBackColor(this.noteBackgroundColor)).apply(new UChangeColor(this.borderColor));
        ug.draw(polygon);
        if (this.withLink) {
            UPolygon polygonOpale;
            if (this.strategy == Direction.LEFT) {
                polygonOpale = this.getPolygonLeft(stringBounder, this.pp1, this.pp2);
            } else if (this.strategy == Direction.RIGHT) {
                polygonOpale = this.getPolygonRight(stringBounder, this.pp1, this.pp2);
            } else if (this.strategy == Direction.UP) {
                polygonOpale = this.getPolygonUp(stringBounder, this.pp1, this.pp2);
            } else if (this.strategy == Direction.DOWN) {
                polygonOpale = this.getPolygonDown(stringBounder, this.pp1, this.pp2);
            } else {
                throw new IllegalArgumentException();
            }
            ug.draw(polygonOpale);
        }
        ug.apply(new UTranslate(this.getWidth(stringBounder) - 10.0, 0.0)).draw(new ULine(0.0, 10.0));
        ug.apply(new UTranslate(this.getWidth(stringBounder), 10.0)).draw(new ULine(-10.0, 0.0));
        this.textBlock.drawU(ug.apply(new UTranslate(6.0, 5.0)));
    }

    private UPolygon getPolygonNormal(StringBounder stringBounder) {
        UPolygon polygon = new UPolygon();
        polygon.addPoint(0.0, 0.0);
        polygon.addPoint(0.0, this.getHeight(stringBounder));
        polygon.addPoint(this.getWidth(stringBounder), this.getHeight(stringBounder));
        polygon.addPoint(this.getWidth(stringBounder), 10.0);
        polygon.addPoint(this.getWidth(stringBounder) - 10.0, 0.0);
        polygon.addPoint(0.0, 0.0);
        return polygon;
    }

    private UPolygon getPolygonLeft(StringBounder stringBounder, Point2D pp1, Point2D pp2) {
        UPolygon polygon = new UPolygon();
        polygon.addPoint(0.0, 0.0);
        double y1 = pp1.getY() - 4.0;
        y1 = MathUtils.limitation(y1, 0.0, this.getHeight(stringBounder) - 8.0);
        polygon.addPoint(0.0, y1);
        polygon.addPoint(pp2.getX(), pp2.getY());
        polygon.addPoint(0.0, y1 + 8.0);
        polygon.addPoint(0.0, this.getHeight(stringBounder));
        polygon.addPoint(this.getWidth(stringBounder), this.getHeight(stringBounder));
        polygon.addPoint(this.getWidth(stringBounder), 10.0);
        polygon.addPoint(this.getWidth(stringBounder) - 10.0, 0.0);
        polygon.addPoint(0.0, 0.0);
        return polygon;
    }

    private UPolygon getPolygonRight(StringBounder stringBounder, Point2D pp1, Point2D pp2) {
        UPolygon polygon = new UPolygon();
        polygon.addPoint(0.0, 0.0);
        polygon.addPoint(0.0, this.getHeight(stringBounder));
        polygon.addPoint(this.getWidth(stringBounder), this.getHeight(stringBounder));
        double y1 = pp1.getY() - 4.0;
        y1 = MathUtils.limitation(y1, 10.0, this.getHeight(stringBounder) - 8.0);
        polygon.addPoint(this.getWidth(stringBounder), y1 + 8.0);
        polygon.addPoint(pp2.getX(), pp2.getY());
        polygon.addPoint(this.getWidth(stringBounder), y1);
        polygon.addPoint(this.getWidth(stringBounder), 10.0);
        polygon.addPoint(this.getWidth(stringBounder) - 10.0, 0.0);
        polygon.addPoint(0.0, 0.0);
        return polygon;
    }

    private UPolygon getPolygonUp(StringBounder stringBounder, Point2D pp1, Point2D pp2) {
        UPolygon polygon = new UPolygon();
        polygon.addPoint(0.0, 0.0);
        polygon.addPoint(0.0, this.getHeight(stringBounder));
        polygon.addPoint(this.getWidth(stringBounder), this.getHeight(stringBounder));
        polygon.addPoint(this.getWidth(stringBounder), 10.0);
        polygon.addPoint(this.getWidth(stringBounder) - 10.0, 0.0);
        double x1 = pp1.getX() - 4.0;
        x1 = MathUtils.limitation(x1, 0.0, this.getWidth(stringBounder) - 10.0);
        polygon.addPoint(x1 + 8.0, 0.0);
        polygon.addPoint(pp2.getX(), pp2.getY());
        polygon.addPoint(x1, 0.0);
        polygon.addPoint(0.0, 0.0);
        return polygon;
    }

    private UPolygon getPolygonDown(StringBounder stringBounder, Point2D pp1, Point2D pp2) {
        UPolygon polygon = new UPolygon();
        polygon.addPoint(0.0, 0.0);
        polygon.addPoint(0.0, this.getHeight(stringBounder));
        double x1 = pp1.getX() - 4.0;
        x1 = MathUtils.limitation(x1, 0.0, this.getWidth(stringBounder));
        polygon.addPoint(x1, this.getHeight(stringBounder));
        polygon.addPoint(pp2.getX(), pp2.getY());
        polygon.addPoint(x1 + 8.0, this.getHeight(stringBounder));
        polygon.addPoint(this.getWidth(stringBounder), this.getHeight(stringBounder));
        polygon.addPoint(this.getWidth(stringBounder), 10.0);
        polygon.addPoint(this.getWidth(stringBounder) - 10.0, 0.0);
        polygon.addPoint(0.0, 0.0);
        return polygon;
    }

    public final int getMarginX1() {
        return 6;
    }
}

