/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.sprite;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sourceforge.plantuml.version.Version;

public class RessourcesUtils {
    public static Set<String> getJarFile(String path2, boolean folder) throws IOException {
        if (path2.startsWith("/") || path2.endsWith("/")) {
            throw new IllegalArgumentException();
        }
        String protocol = RessourcesUtils.getProtocol();
        if ("file".equals(protocol)) {
            URL local = Version.class.getClassLoader().getResource(path2);
            try {
                return RessourcesUtils.listEntry(new File(local.toURI()));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return null;
            }
        }
        if ("jar".equals(protocol)) {
            String classFile = Version.class.getName().replace(".", "/") + ".class";
            URL versionURL = Version.class.getClassLoader().getResource(classFile);
            String jarPath = versionURL.getPath().substring(5, versionURL.getPath().indexOf("!"));
            if (folder) {
                return RessourcesUtils.listFolders(new JarFile(URLDecoder.decode(jarPath, "UTF-8")), path2 + "/");
            }
            return RessourcesUtils.listFiles(new JarFile(URLDecoder.decode(jarPath, "UTF-8")), path2 + "/");
        }
        return Collections.emptySet();
    }

    private static String getProtocol() {
        URL resource = Version.class.getClassLoader().getResource("net/sourceforge/plantuml/version/logo.png");
        return resource.getProtocol();
    }

    private static Set<String> listFiles(JarFile jarFile, String path2) {
        Enumeration<JarEntry> entries = jarFile.entries();
        TreeSet<String> result = new TreeSet<String>();
        while (entries.hasMoreElements()) {
            String name = entries.nextElement().getName();
            if (!name.startsWith(path2)) continue;
            result.add(name.substring(path2.length()));
        }
        return result;
    }

    private static Set<String> listFolders(JarFile jarFile, String path2) {
        Enumeration<JarEntry> entries = jarFile.entries();
        TreeSet<String> result = new TreeSet<String>();
        while (entries.hasMoreElements()) {
            String folder;
            int x;
            String name = entries.nextElement().getName();
            if (!name.startsWith(path2) || (x = (folder = name.substring(path2.length())).indexOf(47)) == -1) continue;
            result.add(folder.substring(0, x));
        }
        return result;
    }

    private static Set<String> listEntry(File dir) {
        TreeSet<String> result = new TreeSet<String>();
        for (String n : dir.list()) {
            result.add(n);
        }
        return result;
    }
}

