/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.visio;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.TikzFontDistortion;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.AtomText;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UImageSvg;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.visio.DriverDotPathVdx;
import net.sourceforge.plantuml.ugraphic.visio.DriverLineVdx;
import net.sourceforge.plantuml.ugraphic.visio.DriverNoneVdx;
import net.sourceforge.plantuml.ugraphic.visio.DriverPolygonVdx;
import net.sourceforge.plantuml.ugraphic.visio.DriverRectangleVdx;
import net.sourceforge.plantuml.ugraphic.visio.DriverTextVdx;
import net.sourceforge.plantuml.ugraphic.visio.DriverUPathVdx;
import net.sourceforge.plantuml.ugraphic.visio.VisioGraphics;

public class UGraphicVdx
extends AbstractUGraphic<VisioGraphics>
implements ClipContainer,
UGraphic2 {
    private final StringBounder stringBounder;

    private UGraphicVdx(ColorMapper colorMapper, VisioGraphics visio) {
        super(colorMapper, visio);
        this.stringBounder = FileFormat.PNG.getDefaultStringBounder(TikzFontDistortion.getDefault());
        this.register();
    }

    public UGraphicVdx(ColorMapper colorMapper) {
        this(colorMapper, new VisioGraphics());
    }

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicVdx(this);
    }

    private UGraphicVdx(UGraphicVdx other) {
        super(other);
        this.stringBounder = other.stringBounder;
        this.register();
    }

    private void register() {
        this.registerDriver(URectangle.class, new DriverRectangleVdx());
        this.registerDriver(UText.class, new DriverTextVdx(this.stringBounder));
        this.registerDriver(AtomText.class, new DriverNoneVdx());
        this.registerDriver(ULine.class, new DriverLineVdx());
        this.registerDriver(UPolygon.class, new DriverPolygonVdx());
        this.registerDriver(UEllipse.class, new DriverNoneVdx());
        this.registerDriver(UImage.class, new DriverNoneVdx());
        this.registerDriver(UImageSvg.class, new DriverNoneVdx());
        this.registerDriver(UPath.class, new DriverUPathVdx());
        this.registerDriver(DotPath.class, new DriverDotPathVdx());
        this.registerDriver(UCenteredCharacter.class, new DriverNoneVdx());
    }

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    @Override
    public void startUrl(Url url) {
    }

    @Override
    public void closeAction() {
    }

    @Override
    public void writeImageTOBEMOVED(OutputStream os, String metadata, int dpi) throws IOException {
        this.createVsd(os);
    }

    public void createVsd(OutputStream os) throws IOException {
        ((VisioGraphics)this.getGraphicObject()).createVsd(os);
    }

    @Override
    public boolean matchesProperty(String propertyName) {
        return "SPECIALTXT".equalsIgnoreCase(propertyName);
    }
}

