/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.dtd;

import com.thaiopensource.relaxng.edit.AbstractVisitor;
import com.thaiopensource.relaxng.edit.AnyNameNameClass;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoiceNameClass;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.ComponentVisitor;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.Container;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.ExternalRefPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.NameClassVisitor;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.NotAllowedPattern;
import com.thaiopensource.relaxng.edit.NsNameNameClass;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.ParentRefPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.PatternVisitor;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.edit.SchemaDocument;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.output.common.Name;
import com.thaiopensource.relaxng.output.common.NameClassSplitter;
import com.thaiopensource.relaxng.output.dtd.AttlistMapper;
import com.thaiopensource.relaxng.output.dtd.AttributeType;
import com.thaiopensource.relaxng.output.dtd.ContentType;
import com.thaiopensource.relaxng.output.dtd.Datatypes;
import com.thaiopensource.relaxng.output.dtd.GrammarPart;
import com.thaiopensource.relaxng.output.dtd.NamespaceManager;
import com.thaiopensource.xml.util.Naming;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Analysis {
    private final NamespaceManager nsm = new NamespaceManager();
    private final AttlistMapper am = new AttlistMapper();
    private final ErrorReporter er;
    private final Map contentTypes = new HashMap();
    private final Map attributeTypes = new HashMap();
    private final Map attributeAlphabets = new HashMap();
    private final Map attributeNamespaces = new HashMap();
    private Map defines = null;
    private final Set attlists = new HashSet();
    private final Map parts = new HashMap();
    private final Map seenTable = new HashMap();
    private final Map elementDecls = new HashMap();
    private ContentType startType = ContentType.ERROR;
    private GrammarPart mainPart;
    private final SchemaCollection schemas;
    private GrammarPattern grammarPattern;
    private final AttributeTyper attributeTyper = new AttributeTyper();
    private final AttributeAlphabetComputer attributeAlphabetComputer = new AttributeAlphabetComputer();
    private final AttributeNamespacesComputer attributeNamespacesComputer = new AttributeNamespacesComputer();
    private final IncludeContentChecker includeContentChecker = new IncludeContentChecker();

    private boolean seen(Pattern pattern) {
        if (this.seenTable.get(pattern) != null) {
            return true;
        }
        this.seenTable.put(pattern, pattern);
        return false;
    }

    Analysis(SchemaCollection schemaCollection, ErrorReporter errorReporter) {
        this.schemas = schemaCollection;
        this.er = errorReporter;
        new Analyzer().analyzeContentType(this.getPattern());
        this.checkAttlists();
        if (!errorReporter.getHadError()) {
            this.nsm.assignPrefixes();
        }
    }

    private void checkAttlists() {
        Iterator iterator = this.attlists.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.getParamEntityElementName(string) != null) continue;
            this.er.error("not_attlist", string, this.getBody(string).getSourceLocation());
        }
    }

    Pattern getPattern() {
        return ((SchemaDocument)this.schemas.getSchemaDocumentMap().get(this.schemas.getMainUri())).getPattern();
    }

    String getPrefixForNamespaceUri(String string) {
        return this.nsm.getPrefixForNamespaceUri(string);
    }

    String getDefaultNamespaceUri() {
        return this.nsm.getDefaultNamespaceUri();
    }

    String getParamEntityElementName(String string) {
        return this.am.getParamEntityElementName(string);
    }

    ContentType getContentType(Pattern pattern) {
        return (ContentType)this.contentTypes.get(pattern);
    }

    AttributeType getAttributeType(Pattern pattern) {
        AttributeType attributeType = (AttributeType)this.attributeTypes.get(pattern);
        if (attributeType == null) {
            attributeType = (AttributeType)pattern.accept(this.attributeTyper);
            this.attributeTypes.put(pattern, attributeType);
        }
        return attributeType;
    }

    Set getAttributeAlphabet(Pattern pattern) {
        Set set = (Set)this.attributeAlphabets.get(pattern);
        if (set == null) {
            set = Collections.unmodifiableSet((Set)pattern.accept(this.attributeAlphabetComputer));
            this.attributeAlphabets.put(pattern, set);
        }
        return set;
    }

    Set getAttributeNamespaces(Pattern pattern) {
        Set set = (Set)this.attributeNamespaces.get(pattern);
        if (set == null) {
            set = (Set)pattern.accept(this.attributeNamespacesComputer);
            this.attributeNamespaces.put(pattern, set);
        }
        return set;
    }

    Pattern getBody(String string) {
        return (Pattern)this.defines.get(string);
    }

    GrammarPattern getGrammarPattern() {
        return this.grammarPattern;
    }

    String getMainUri() {
        return this.schemas.getMainUri();
    }

    GrammarPart getGrammarPart(String string) {
        if (string.equals(this.schemas.getMainUri())) {
            return this.mainPart;
        }
        return (GrammarPart)this.parts.get(string);
    }

    Pattern getSchema(String string) {
        return ((SchemaDocument)this.schemas.getSchemaDocumentMap().get(string)).getPattern();
    }

    String getEncoding(String string) {
        return ((SchemaDocument)this.schemas.getSchemaDocumentMap().get(string)).getEncoding();
    }

    class AttributeNamespacesComputer
    extends AbstractVisitor {
        AttributeNamespacesComputer() {
        }

        public Object visitPattern(Pattern pattern) {
            return Collections.EMPTY_SET;
        }

        public Object visitMixed(MixedPattern mixedPattern) {
            return Analysis.this.getAttributeNamespaces(mixedPattern.getChild());
        }

        public Object visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return Analysis.this.getAttributeNamespaces(oneOrMorePattern.getChild());
        }

        public Object visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            return Analysis.this.getAttributeNamespaces(zeroOrMorePattern.getChild());
        }

        public Object visitOptional(OptionalPattern optionalPattern) {
            return Analysis.this.getAttributeNamespaces(optionalPattern.getChild());
        }

        public Object visitComposite(CompositePattern compositePattern) {
            List list = compositePattern.getChildren();
            HashSet hashSet = Collections.EMPTY_SET;
            boolean bl = false;
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                HashSet hashSet2 = Analysis.this.getAttributeNamespaces((Pattern)list.get(n));
                if (hashSet2 != Collections.EMPTY_SET && !hashSet.containsAll(hashSet2)) {
                    if (hashSet == Collections.EMPTY_SET) {
                        hashSet = hashSet2;
                    } else {
                        if (!bl) {
                            hashSet = new HashSet(hashSet);
                            bl = true;
                        }
                        hashSet.addAll(hashSet2);
                    }
                }
                ++n;
            }
            if (bl) {
                hashSet = Collections.unmodifiableSet(hashSet);
            }
            return hashSet;
        }

        public Object visitAttribute(AttributePattern attributePattern) {
            HashSet<String> hashSet = null;
            List list = NameClassSplitter.split(attributePattern.getNameClass());
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                String string = ((NameNameClass)list.get(n)).getNamespaceUri();
                if (string.length() != 0 && string != NameClass.INHERIT_NS && !string.equals("http://www.w3.org/XML/1998/namespace")) {
                    if (hashSet == null) {
                        hashSet = new HashSet<String>();
                    }
                    hashSet.add(string);
                }
                ++n;
            }
            if (hashSet == null) {
                return Collections.EMPTY_SET;
            }
            return Collections.unmodifiableSet(hashSet);
        }

        public Object visitRef(RefPattern refPattern) {
            return Analysis.this.getAttributeNamespaces(Analysis.this.getBody(refPattern.getName()));
        }
    }

    class AttributeAlphabetComputer
    extends AbstractVisitor {
        AttributeAlphabetComputer() {
        }

        public Object visitPattern(Pattern pattern) {
            return Collections.EMPTY_SET;
        }

        public Object visitMixed(MixedPattern mixedPattern) {
            return Analysis.this.getAttributeAlphabet(mixedPattern.getChild());
        }

        public Object visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return Analysis.this.getAttributeAlphabet(oneOrMorePattern.getChild());
        }

        public Object visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            return Analysis.this.getAttributeAlphabet(zeroOrMorePattern.getChild());
        }

        public Object visitOptional(OptionalPattern optionalPattern) {
            return Analysis.this.getAttributeAlphabet(optionalPattern.getChild());
        }

        public Object visitComposite(CompositePattern compositePattern) {
            List list = compositePattern.getChildren();
            HashSet hashSet = new HashSet();
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                hashSet.addAll(Analysis.this.getAttributeAlphabet((Pattern)list.get(n)));
                ++n;
            }
            return hashSet;
        }

        public Object visitAttribute(AttributePattern attributePattern) {
            HashSet<Name> hashSet = new HashSet<Name>();
            List list = NameClassSplitter.split(attributePattern.getNameClass());
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                NameNameClass nameNameClass = (NameNameClass)list.get(n);
                String string = nameNameClass.getNamespaceUri();
                if (string == NameClass.INHERIT_NS) {
                    string = "";
                }
                hashSet.add(new Name(string, nameNameClass.getLocalName()));
                ++n;
            }
            return hashSet;
        }

        public Object visitRef(RefPattern refPattern) {
            return Analysis.this.getAttributeAlphabet(Analysis.this.getBody(refPattern.getName()));
        }
    }

    class AttributeTyper
    extends AbstractVisitor {
        AttributeTyper() {
        }

        public Object visitPattern(Pattern pattern) {
            return AttributeType.EMPTY;
        }

        public Object visitMixed(MixedPattern mixedPattern) {
            return Analysis.this.getAttributeType(mixedPattern.getChild());
        }

        public Object visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return Analysis.this.getAttributeType(oneOrMorePattern.getChild());
        }

        public Object visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            return Analysis.this.getAttributeType(zeroOrMorePattern.getChild());
        }

        public Object visitOptional(OptionalPattern optionalPattern) {
            return Analysis.this.getAttributeType(optionalPattern.getChild());
        }

        public Object visitComposite(CompositePattern compositePattern) {
            List list = compositePattern.getChildren();
            AttributeType attributeType = Analysis.this.getAttributeType((Pattern)list.get(0));
            int n = 1;
            int n2 = list.size();
            while (n < n2) {
                attributeType = AttributeType.group(attributeType, Analysis.this.getAttributeType((Pattern)list.get(n)));
                ++n;
            }
            return attributeType;
        }

        public Object visitAttribute(AttributePattern attributePattern) {
            return AttributeType.SINGLE;
        }

        public Object visitEmpty(EmptyPattern emptyPattern) {
            return AttributeType.MULTI;
        }

        public Object visitRef(RefPattern refPattern) {
            return Analysis.this.getAttributeType(Analysis.this.getBody(refPattern.getName()));
        }
    }

    class IncludeContentChecker
    extends AbstractVisitor {
        IncludeContentChecker() {
        }

        public Object visitContainer(Container container) {
            List list = container.getComponents();
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                ((Component)list.get(n)).accept(this);
                ++n;
            }
            return null;
        }

        public Object visitDefine(DefineComponent defineComponent) {
            Analysis.this.er.error("sorry_include_override", defineComponent.getSourceLocation());
            return null;
        }

        public Object visitDiv(DivComponent divComponent) {
            return this.visitContainer(divComponent);
        }
    }

    private class Analyzer
    implements PatternVisitor,
    ComponentVisitor,
    NameClassVisitor {
        private ElementPattern ancestorPattern;
        private final Set pendingRefs;

        public Analyzer() {
            this.pendingRefs = new HashSet();
        }

        private Analyzer(ElementPattern elementPattern) {
            this.ancestorPattern = elementPattern;
            this.pendingRefs = new HashSet();
        }

        private Analyzer(Set set) {
            this.pendingRefs = set;
        }

        public Object visitEmpty(EmptyPattern emptyPattern) {
            return ContentType.EMPTY;
        }

        public Object visitData(DataPattern dataPattern) {
            return ContentType.SIMPLE_TYPE;
        }

        public Object visitValue(ValuePattern valuePattern) {
            Datatypes.Info info = Datatypes.getInfo(valuePattern.getDatatypeLibrary(), valuePattern.getType());
            if (info.usesTokenEquality() && Naming.isNmtoken((String)valuePattern.getValue())) {
                return ContentType.ENUM;
            }
            if (info.usesCdataEquality()) {
                return ContentType.VALUE;
            }
            return ContentType.SIMPLE_TYPE;
        }

        public Object visitElement(ElementPattern elementPattern) {
            int n;
            if (Analysis.this.seen(elementPattern)) {
                n = NameClassSplitter.split(elementPattern.getNameClass()).size();
            } else {
                new Analyzer(elementPattern).analyzeContentType(elementPattern.getChild());
                List list = this.noteNames(elementPattern.getNameClass(), true);
                n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    NameNameClass nameNameClass = (NameNameClass)list.get(n2);
                    String string = nameNameClass.getNamespaceUri();
                    if (string == NameClass.INHERIT_NS) {
                        string = "";
                    }
                    Name name = new Name(string, nameNameClass.getLocalName());
                    ElementPattern elementPattern2 = (ElementPattern)Analysis.this.elementDecls.get(name);
                    if (elementPattern2 != null) {
                        Analysis.this.er.error("sorry_multiple_element", string, name.getLocalName(), elementPattern.getSourceLocation());
                        Analysis.this.er.error("other_element", elementPattern2.getSourceLocation());
                    } else {
                        Analysis.this.elementDecls.put(name, elementPattern);
                    }
                    ++n2;
                }
            }
            return n == 1 ? ContentType.DIRECT_SINGLE_ELEMENT : ContentType.ELEMENT_CLASS;
        }

        public Object visitAttribute(AttributePattern attributePattern) {
            this.noteNames(attributePattern.getNameClass(), false);
            ContentType contentType = this.analyzeContentType(attributePattern.getChild());
            if (contentType.isA(ContentType.MODEL_GROUP) || contentType == ContentType.MIXED_ELEMENT_CLASS || contentType == ContentType.MIXED_MODEL) {
                Analysis.this.er.error("bad_attribute_type", attributePattern.getSourceLocation());
            }
            if (this.ancestorPattern != null) {
                Analysis.this.am.noteAttribute(this.ancestorPattern);
            }
            return ContentType.EMPTY;
        }

        private List noteNames(NameClass nameClass, boolean bl) {
            nameClass.accept(this);
            List list = NameClassSplitter.split(nameClass);
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Analysis.this.nsm.noteName((NameNameClass)list.get(n2), bl);
                ++n2;
            }
            return list;
        }

        public Object visitNotAllowed(NotAllowedPattern notAllowedPattern) {
            return ContentType.NOT_ALLOWED;
        }

        public Object visitText(TextPattern textPattern) {
            return ContentType.TEXT;
        }

        public Object visitList(ListPattern listPattern) {
            return ContentType.SIMPLE_TYPE;
        }

        public Object visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return this.checkContentType("sorry_one_or_more", ContentType.oneOrMore(this.analyzeContentTypeNullAncestorPattern(oneOrMorePattern.getChild())), oneOrMorePattern);
        }

        public Object visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            return this.checkContentType("sorry_zero_or_more", ContentType.zeroOrMore(this.analyzeContentTypeNullAncestorPattern(zeroOrMorePattern.getChild())), zeroOrMorePattern);
        }

        public Object visitChoice(ChoicePattern choicePattern) {
            List list = choicePattern.getChildren();
            ContentType contentType = this.analyzeContentType((Pattern)list.get(0));
            int n = 1;
            int n2 = list.size();
            while (n < n2) {
                contentType = this.checkContentType("sorry_choice", ContentType.choice(contentType, this.analyzeContentType((Pattern)list.get(n))), choicePattern);
                ++n;
            }
            if (Analysis.this.getAttributeType(choicePattern) == AttributeType.MULTI) {
                HashSet hashSet = new HashSet();
                int n3 = 0;
                int n4 = list.size();
                while (n3 < n4) {
                    Set set = Analysis.this.getAttributeAlphabet((Pattern)list.get(n3));
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (hashSet.contains(e)) {
                            Analysis.this.er.error("sorry_choice_attribute_name", ((Name)e).getNamespaceUri(), ((Name)e).getLocalName(), choicePattern.getSourceLocation());
                            continue;
                        }
                        hashSet.add(e);
                    }
                    ++n3;
                }
            }
            return contentType;
        }

        public Object visitInterleave(InterleavePattern interleavePattern) {
            List list = interleavePattern.getChildren();
            ContentType contentType = this.analyzeContentType((Pattern)list.get(0));
            int n = 1;
            int n2 = list.size();
            while (n < n2) {
                contentType = this.checkContentType("sorry_interleave", ContentType.interleave(contentType, this.analyzeContentType((Pattern)list.get(n))), interleavePattern);
                ++n;
            }
            return contentType;
        }

        public Object visitGroup(GroupPattern groupPattern) {
            List list = groupPattern.getChildren();
            ContentType contentType = this.analyzeContentType((Pattern)list.get(0));
            int n = 1;
            int n2 = list.size();
            while (n < n2) {
                contentType = this.checkContentType("sorry_group", ContentType.group(contentType, this.analyzeContentType((Pattern)list.get(n))), groupPattern);
                ++n;
            }
            return contentType;
        }

        public Object visitRef(RefPattern refPattern) {
            String string = refPattern.getName();
            Pattern pattern = Analysis.this.getBody(string);
            if (pattern == null) {
                Analysis.this.er.error("undefined_ref", refPattern.getSourceLocation());
                return ContentType.ERROR;
            }
            if (this.pendingRefs.contains(string)) {
                Analysis.this.er.error("ref_loop", refPattern.getSourceLocation());
                return ContentType.ERROR;
            }
            this.pendingRefs.add(string);
            ContentType contentType = ContentType.ref(new Analyzer(this.pendingRefs).analyzeContentType(pattern));
            this.pendingRefs.remove(string);
            if (contentType.isA(ContentType.EMPTY)) {
                Analysis.this.am.noteAttributeGroupRef(this.ancestorPattern, refPattern.getName());
            }
            return ContentType.ref(contentType);
        }

        public Object visitParentRef(ParentRefPattern parentRefPattern) {
            Analysis.this.er.error("sorry_parent_ref", parentRefPattern.getSourceLocation());
            return null;
        }

        public Object visitGrammar(GrammarPattern grammarPattern) {
            if (Analysis.this.defines != null) {
                Analysis.this.er.error("sorry_nested_grammar", grammarPattern.getSourceLocation());
                return ContentType.ERROR;
            }
            Analysis.this.defines = new HashMap();
            try {
                Analysis.this.mainPart = new GrammarPart(Analysis.this.er, Analysis.this.defines, Analysis.this.attlists, Analysis.this.schemas, Analysis.this.parts, grammarPattern);
            }
            catch (GrammarPart.IncludeLoopException includeLoopException) {
                Analysis.this.er.error("include_loop", includeLoopException.getInclude().getSourceLocation());
                return ContentType.ERROR;
            }
            Analysis.this.grammarPattern = grammarPattern;
            this.visitContainer(grammarPattern);
            return Analysis.this.startType;
        }

        public Object visitExternalRef(ExternalRefPattern externalRefPattern) {
            Analysis.this.er.error("sorry_external_ref", externalRefPattern.getSourceLocation());
            return null;
        }

        public Object visitMixed(MixedPattern mixedPattern) {
            return this.checkContentType("sorry_mixed", ContentType.mixed(this.analyzeContentType(mixedPattern.getChild())), mixedPattern);
        }

        public Object visitOptional(OptionalPattern optionalPattern) {
            return this.checkContentType("sorry_optional", ContentType.optional(this.analyzeContentTypeNullAncestorPattern(optionalPattern.getChild())), optionalPattern);
        }

        public Object visitContainer(Container container) {
            List list = container.getComponents();
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                ((Component)list.get(n)).accept(this);
                ++n;
            }
            return null;
        }

        public Object visitDiv(DivComponent divComponent) {
            return this.visitContainer(divComponent);
        }

        public Object visitDefine(DefineComponent defineComponent) {
            if (defineComponent.getName() == DefineComponent.START) {
                Analysis.this.startType = this.analyzeContentType(defineComponent.getBody());
            } else {
                new Analyzer().analyzeContentType(defineComponent.getBody());
            }
            if (Analysis.this.attlists.contains(defineComponent.getName()) && Analysis.this.getContentType(defineComponent.getBody()) != ContentType.EMPTY) {
                Analysis.this.er.error("not_attlist", defineComponent.getName(), defineComponent.getSourceLocation());
                Analysis.this.attlists.remove(defineComponent.getName());
            }
            return null;
        }

        public Object visitInclude(IncludeComponent includeComponent) {
            Analysis.this.includeContentChecker.visitContainer(includeComponent);
            this.visitContainer((GrammarPattern)((SchemaDocument)Analysis.this.schemas.getSchemaDocumentMap().get(includeComponent.getHref())).getPattern());
            return null;
        }

        public Object visitChoice(ChoiceNameClass choiceNameClass) {
            List list = choiceNameClass.getChildren();
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                ((NameClass)list.get(n)).accept(this);
                ++n;
            }
            return ContentType.ELEMENT_CLASS;
        }

        public Object visitAnyName(AnyNameNameClass anyNameNameClass) {
            Analysis.this.er.error("sorry_wildcard", anyNameNameClass.getSourceLocation());
            return null;
        }

        public Object visitNsName(NsNameNameClass nsNameNameClass) {
            Analysis.this.er.error("sorry_wildcard", nsNameNameClass.getSourceLocation());
            return null;
        }

        public Object visitName(NameNameClass nameNameClass) {
            Analysis.this.nsm.noteName(nameNameClass, true);
            return ContentType.DIRECT_SINGLE_ELEMENT;
        }

        ContentType checkContentType(String string, ContentType contentType, Pattern pattern) {
            if (contentType != null) {
                return contentType;
            }
            Analysis.this.er.error(string, pattern.getSourceLocation());
            return ContentType.ERROR;
        }

        ContentType analyzeContentType(Pattern pattern) {
            ContentType contentType = (ContentType)Analysis.this.contentTypes.get(pattern);
            if (contentType == null) {
                contentType = (ContentType)pattern.accept(this);
                Analysis.this.contentTypes.put(pattern, contentType);
            }
            return contentType;
        }

        ContentType analyzeContentTypeNullAncestorPattern(Pattern pattern) {
            return (this.ancestorPattern == null ? this : new Analyzer(this.pendingRefs)).analyzeContentType(pattern);
        }
    }
}

