/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.javafx;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

enum JavaFXInstallator {
    INSTANCE;

    private static final NotNullLazyValue<String> URL;

    @NotNull
    private static String getJavaFXSdkURL() {
        String string;
        InputStream resource = JavaFXInstallator.class.getResourceAsStream("/org/intellij/plugins/markdown/javafx/location.properties");
        try {
            Properties properties = new Properties();
            properties.load(resource);
            string = properties.getProperty("javafx_sdk_overlay_location");
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not find location.properties. Check your installation.");
        }
        if (string == null) {
            JavaFXInstallator.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean installOpenJFXAndReport(@NotNull JComponent parentComponent) {
        DownloadableFileDescription fileDescription;
        DownloadableFileService fileService;
        FileDownloader downloader;
        List progress;
        if (parentComponent == null) {
            JavaFXInstallator.$$$reportNull$$$0(1);
        }
        if ((progress = (downloader = (fileService = DownloadableFileService.getInstance()).createDownloader(Collections.singletonList(fileDescription = fileService.createFileDescription((String)URL.getValue(), "javafx-sdk-overlay.zip")), "OpenJFX")).downloadWithProgress(this.getInstallationPath(), null, parentComponent)) == null) {
            return false;
        }
        boolean success = false;
        for (Pair pair : progress) {
            if (!((DownloadableFileDescription)pair.getSecond()).equals(fileDescription)) {
                Logger.getInstance(JavaFXInstallator.class).warn("Another file downloaded: " + pair);
                continue;
            }
            VirtualFile file = (VirtualFile)pair.getFirst();
            if (file == null) continue;
            File archiveFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            try {
                ZipUtil.extract((File)archiveFile, (File)new File(this.getInstallationPath()), null, (boolean)true);
                Logger.getInstance(JavaFXInstallator.class).info("Downloaded and installed OpenJFX in " + archiveFile.getParent());
                success = true;
            }
            catch (IOException iOException) {}
        }
        return success;
    }

    public String getInstallationPath() {
        return PathManager.getConfigPath() + "/openjfx";
    }

    static {
        URL = new NotNullLazyValue<String>(){

            @NotNull
            protected String compute() {
                String string = JavaFXInstallator.getJavaFXSdkURL();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/javafx/JavaFXInstallator$1", "compute"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/javafx/JavaFXInstallator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaFXSdkURL";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/javafx/JavaFXInstallator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installOpenJFXAndReport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

