/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionInitializationContextImpl;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.patterns.ElementPattern;
import java.awt.Color;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionProcessBase
implements CompletionProcessEx,
Disposable {
    protected final int myInvocationCount;
    protected final Object myLock = new String("CompletionProgressIndicator");
    protected OffsetsInFile myHostOffsets;
    private CompletionParameters myParameters;
    @NotNull
    private final Caret myCaret;
    @NotNull
    private final OffsetMap myOffsetMap;

    public CompletionProcessBase(CompletionInitializationContext context) {
        this.myInvocationCount = context.getInvocationCount();
        this.myHostOffsets = ((CompletionInitializationContextImpl)context).getHostOffsets();
        this.myCaret = context.getCaret();
        this.myOffsetMap = context.getOffsetMap();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myParameters.getOriginalFile().getProject();
        if (project == null) {
            CompletionProcessBase.$$$reportNull$$$0(0);
        }
        return project;
    }

    @Override
    @NotNull
    public Editor getEditor() {
        Editor editor = this.myParameters.getEditor();
        if (editor == null) {
            CompletionProcessBase.$$$reportNull$$$0(1);
        }
        return editor;
    }

    @Override
    @NotNull
    public Caret getCaret() {
        Caret caret = this.myCaret;
        if (caret == null) {
            CompletionProcessBase.$$$reportNull$$$0(2);
        }
        return caret;
    }

    @Override
    @NotNull
    public OffsetMap getOffsetMap() {
        OffsetMap offsetMap = this.myOffsetMap;
        if (offsetMap == null) {
            CompletionProcessBase.$$$reportNull$$$0(3);
        }
        return offsetMap;
    }

    @Override
    @Nullable
    public Lookup getLookup() {
        return null;
    }

    public boolean isAutopopupCompletion() {
        return this.myInvocationCount == 0;
    }

    @Override
    @NotNull
    public OffsetsInFile getHostOffsets() {
        OffsetsInFile offsetsInFile = this.myHostOffsets;
        if (offsetsInFile == null) {
            CompletionProcessBase.$$$reportNull$$$0(4);
        }
        return offsetsInFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerChildDisposable(@NotNull Supplier<Disposable> child) {
        if (child == null) {
            CompletionProcessBase.$$$reportNull$$$0(5);
        }
        Object object = this.myLock;
        synchronized (object) {
            Disposer.register((Disposable)this, (Disposable)child.get());
        }
    }

    public void dispose() {
    }

    @Override
    public void itemSelected(LookupElement item, char aChar) {
    }

    @Override
    public void addWatchedPrefix(int startOffset, ElementPattern<String> restartCondition) {
    }

    @Override
    public void addAdvertisement(String message, @Nullable Color bgColor) {
    }

    @Override
    public CompletionParameters getParameters() {
        return this.myParameters;
    }

    @Override
    public void setParameters(CompletionParameters parameters2) {
        this.myParameters = parameters2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionProcessBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaret";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOffsetMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostOffsets";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionProcessBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerChildDisposable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

