/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class DefaultCompletionContributor
extends CompletionContributor {
    static void addDefaultAdvertisements(LookupImpl lookup, boolean includePsiFeatures) {
        String shortcut;
        Project project = lookup.getProject();
        if (CompletionUtil.shouldShowFeature(project, "editing.completion.finishByDotEtc")) {
            lookup.addAdvertisement(LangBundle.message("completion.dot.etc.ad", new Object[0]), null);
        }
        if (!includePsiFeatures) {
            return;
        }
        if (CompletionUtil.shouldShowFeature(project, "editing.completion.finishBySmartEnter") && StringUtil.isNotEmpty((String)(shortcut = DefaultCompletionContributor.getActionShortcut((String)"EditorChooseLookupItemCompleteStatement")))) {
            lookup.addAdvertisement(LangBundle.message("completion.smart.enter.ad", shortcut), null);
        }
        if ((CompletionUtil.shouldShowFeature(project, "codeassists.quickjavadoc") || CompletionUtil.shouldShowFeature(project, "codeassists.quickjavadoc.lookup")) && StringUtil.isNotEmpty((String)(shortcut = DefaultCompletionContributor.getActionShortcut((String)"QuickJavaDoc")))) {
            lookup.addAdvertisement(LangBundle.message("completion.quick.javadoc.ad", shortcut), null);
        }
        if ((CompletionUtil.shouldShowFeature(project, "codeassists.quickdefinition") || CompletionUtil.shouldShowFeature(project, "codeassists.quickdefinition.lookup")) && StringUtil.isNotEmpty((String)(shortcut = DefaultCompletionContributor.getActionShortcut((String)"QuickImplementations")))) {
            lookup.addAdvertisement(LangBundle.message("completion.quick.implementations.ad", shortcut), null);
        }
    }

    public String handleEmptyLookup(@NotNull CompletionParameters parameters2, Editor editor) {
        if (parameters2 == null) {
            DefaultCompletionContributor.$$$reportNull$$$0(0);
        }
        return LangBundle.message("completion.no.suggestions", new Object[0]);
    }

    public AutoCompletionDecision handleAutoCompletionPossibility(@NotNull AutoCompletionContext context) {
        LookupElement[] items;
        if (context == null) {
            DefaultCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((items = context.getItems()).length == 1) {
            LookupElement item = items[0];
            if (!StringUtil.isEmpty((String)context.getLookup().itemPattern(item)) || context.getParameters().getCompletionType() == CompletionType.SMART) {
                return AutoCompletionDecision.insertItem((LookupElement)item);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/DefaultCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleEmptyLookup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleAutoCompletionPossibility";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

