/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonTooltipAction;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.AbstractEmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0003\u00a8\u0006\u000f"}, d2={"extractMostPriorityFixFromHighlightInfo", "Lcom/intellij/codeInsight/intention/IntentionAction;", "highlightInfo", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getFirstAvailableAction", "intentionsInfo", "Lcom/intellij/codeInsight/daemon/impl/ShowIntentionsPass$IntentionsInfo;", "wrapIntentionToTooltipAction", "Lcom/intellij/codeInsight/daemon/impl/DaemonTooltipAction;", "intention", "info", "intellij.platform.lang.impl"})
public final class DaemonTooltipActionProviderKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final IntentionAction extractMostPriorityFixFromHighlightInfo(@NotNull HighlightInfo highlightInfo, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Collection<HighlightInfo.IntentionActionDescriptor> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)highlightInfo, (String)"highlightInfo");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        List fixes = new ArrayList();
        List<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> quickFixActionMarkers = highlightInfo.quickFixActionRanges;
        if (quickFixActionMarkers == null || quickFixActionMarkers.isEmpty()) {
            return null;
        }
        Iterable iterable = quickFixActionMarkers;
        List list2 = fixes;
        void var6_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            HighlightInfo.IntentionActionDescriptor intentionActionDescriptor = (HighlightInfo.IntentionActionDescriptor)it.first;
            collection.add(intentionActionDescriptor);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(CollectionsKt.toList((Iterable)collection));
        ShowIntentionsPass.IntentionsInfo intentionsInfo = new ShowIntentionsPass.IntentionsInfo();
        ShowIntentionsPass.fillIntentionsInfoForHighlightInfo(highlightInfo, intentionsInfo, fixes);
        intentionsInfo.filterActions(psiFile);
        return DaemonTooltipActionProviderKt.getFirstAvailableAction(psiFile, editor, intentionsInfo);
    }

    @Nullable
    public static final IntentionAction getFirstAvailableAction(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull ShowIntentionsPass.IntentionsInfo intentionsInfo) {
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)intentionsInfo, (String)"intentionsInfo");
        Project project = psiFile.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"psiFile.project");
        Project project2 = project;
        CachedIntentions cachedIntentions = CachedIntentions.createAndUpdateActions(project2, psiFile, editor, intentionsInfo);
        Intrinsics.checkExpressionValueIsNotNull((Object)cachedIntentions, (String)"CachedIntentions.createA\u2026, editor, intentionsInfo)");
        CachedIntentions cachedIntentions2 = cachedIntentions;
        List<IntentionActionWithTextCaching> list2 = cachedIntentions2.getAllActions();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"cachedIntentions.allActions");
        List<IntentionActionWithTextCaching> allActions = list2;
        if (allActions.isEmpty()) {
            return null;
        }
        Iterable $receiver$iv = allActions;
        for (Object element$iv : $receiver$iv) {
            String text2;
            IntentionAction action;
            IntentionActionWithTextCaching it;
            IntentionActionWithTextCaching intentionActionWithTextCaching = it = (IntentionActionWithTextCaching)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)intentionActionWithTextCaching, (String)"it");
            Intrinsics.checkExpressionValueIsNotNull((Object)intentionActionWithTextCaching.getAction(), (String)"it.action");
            if (action instanceof IntentionActionDelegate) {
                IntentionAction intentionAction = ((IntentionActionDelegate)action).getDelegate();
                Intrinsics.checkExpressionValueIsNotNull((Object)intentionAction, (String)"action.delegate");
                action = intentionAction;
            }
            if (action instanceof AbstractEmptyIntentionAction || !action.isAvailable(project2, editor, psiFile)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)it.getText(), (String)"it.text");
            if (XmlStringUtil.isWrappedInHtml((String)text2)) continue;
            return action;
        }
        return null;
    }

    @NotNull
    public static final DaemonTooltipAction wrapIntentionToTooltipAction(@NotNull IntentionAction intention, @NotNull HighlightInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)intention, (String)"intention");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        String string = intention.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"intention.text");
        return new DaemonTooltipAction(string, info.getActualStartOffset());
    }
}

