/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretStateTransferableData;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlCopyPastePreProcessor
implements CopyPastePreProcessor {
    private static final Logger LOG = Logger.getInstance(HtmlCopyPastePreProcessor.class);
    private static final DataFlavor ourHtmlDataFlavor = HtmlCopyPastePreProcessor.buildDataFlavor("text/html;class=java.lang.String");
    private static final DataFlavor ourRtfDataFlavor = HtmlCopyPastePreProcessor.buildDataFlavor("text/rtf;class=java.io.InputStream");

    private static DataFlavor buildDataFlavor(String flavor) {
        try {
            return new DataFlavor(flavor);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text2) {
        return null;
    }

    @Override
    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file2, Editor editor, String text2, RawText rawText) {
        block7: {
            Transferable content;
            if (file2.getLanguage() != HTMLLanguage.INSTANCE) {
                String string = text2;
                if (string == null) {
                    HtmlCopyPastePreProcessor.$$$reportNull$$$0(0);
                }
                return string;
            }
            CopyPasteManager manager = CopyPasteManager.getInstance();
            if (manager.areDataFlavorsAvailable(new DataFlavor[]{ourHtmlDataFlavor, ourRtfDataFlavor}) && (content = manager.getContents()) != null && !content.isDataFlavorSupported(CaretStateTransferableData.FLAVOR)) {
                String string;
                try {
                    String data;
                    String string2 = data = content.isDataFlavorSupported(ourHtmlDataFlavor) ? (String)content.getTransferData(ourHtmlDataFlavor) : HtmlCopyPastePreProcessor.convertFromRtfStream((InputStream)content.getTransferData(ourRtfDataFlavor));
                    if (StringUtil.isEmpty((String)data)) break block7;
                    string = data;
                }
                catch (UnsupportedFlavorException | IOException e) {
                    LOG.error((Throwable)e);
                }
                if (string == null) {
                    HtmlCopyPastePreProcessor.$$$reportNull$$$0(1);
                }
                return string;
            }
        }
        String string = text2;
        if (string == null) {
            HtmlCopyPastePreProcessor.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static String convertFromRtfStream(InputStream stream) {
        DefaultStyledDocument document = new DefaultStyledDocument();
        try {
            new RTFEditorKit().read(stream, (Document)document, 0);
            StringWriter writer = new StringWriter();
            new HTMLEditorKit().write(writer, (Document)document, 0, document.getLength());
            return writer.toString();
        }
        catch (IOException | BadLocationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/HtmlCopyPastePreProcessor", "preprocessOnPaste"));
    }
}

